# - Find Feel
# This module looks for Feel (Library for the Finite Element Method) support
# it will define the following values
#  FEELPP_INCLUDE_DIR = where feel/feelcore/feel.hpp can be found
#  FEELPP_LIBRARY    = the library to link in

set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++0x " )
set( CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} -std=c++0x " )
set( CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -std=c++0x " )

LIST(REMOVE_DUPLICATES CMAKE_CXX_FLAGS)
LIST(REMOVE_DUPLICATES CMAKE_CXX_FLAGS_DEBUG)
LIST(REMOVE_DUPLICATES CMAKE_CXX_FLAGS_RELEASE)

INCLUDE(CheckIncludeFile)
INCLUDE(CheckIncludeFiles)
INCLUDE(CheckIncludeFileCXX)
INCLUDE(CheckFunctionExists)
INCLUDE(CheckSymbolExists)
INCLUDE(CheckCXXSourceCompiles)
INCLUDE(CheckLibraryExists)


OPTION(FEELPP_ENABLE_TBB "enable feel++ TBB support" OFF)
if ( FEELPP_ENABLE_TBB )
  FIND_PACKAGE(TBB)
  IF ( TBB_FOUND )
    INCLUDE_DIRECTORIES( ${TBB_INCLUDE_DIR} )
    SET(FEELPP_LIBRARIES ${TBB_LIBRARIES})
    SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} Tbb" )
  ENDIF (TBB_FOUND )
endif()

FIND_PACKAGE(OpenMP)

# on APPLE enfore the use of macports openmpi version
if ( APPLE )
  if ( EXISTS /opt/local/lib/openmpi/bin/mpic++ )
    set(MPI_COMPILER /opt/local/lib/openmpi/bin/mpic++)
  endif()

#  set(MPI_LIBRARY "MPI_LIBRARY-NOTFOUND" )
  MESSAGE(STATUS "Use mpi compiler ${MPI_COMPILER}")

endif( APPLE )
FIND_PACKAGE(MPI)
IF ( MPI_FOUND )
  SET(CMAKE_REQUIRED_INCLUDES "${MPI_INCLUDE_PATH};${CMAKE_REQUIRED_INCLUDES}")
  SET( FEELPP_HAS_MPI 1 )
  SET( FEELPP_HAS_MPI_H 1 )
  ADD_DEFINITIONS( -DFEELPP_HAS_MPI=1 -DFEELPP_HAS_MPI_H=1 )
  SET(FEELPP_BOOST_MPI mpi)
  SET(FEELPP_LIBRARIES ${MPI_LIBRARIES} ${FEELPP_LIBRARIES})
  INCLUDE_DIRECTORIES(${MPI_INCLUDE_PATH})
  SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} Mpi" )
ENDIF()



Check_Include_File_CXX(dlfcn.h FEELPP_HAS_DLFCN_H)
if ( FEELPP_HAS_DLFCN_H )
  add_definitions(-DFEELPP_HAS_DLFCN_H)
endif()
CHECK_LIBRARY_EXISTS (dl dlopen "" FEELPP_HAS_LIBDL)
IF (FEELPP_HAS_LIBDL)
  set(DL_LIBRARY dl)
  SET (FEELPP_HAS_DLOPEN 1)
  add_definitions(-DFEELPP_HAS_DLOPEN)
  SET(FEELPP_LIBRARIES ${DL_LIBRARY} ${FEELPP_LIBRARIES})
ELSE ()
  CHECK_FUNCTION_EXISTS (dlopen FEELPP_HAS_DLOPEN)
ENDIF (FEELPP_HAS_LIBDL)

#
# Xml2
#
FIND_PACKAGE(LibXml2 REQUIRED)
SET(FEELPP_LIBRARIES  ${LIBXML2_LIBRARIES} ${FEELPP_LIBRARIES})
INCLUDE_DIRECTORIES(${LIBXML2_INCLUDE_DIR})
#
# Blas and Lapack
#
if (APPLE)
        FIND_PACKAGE(LAPACK )
else (APPLE)
        FIND_PACKAGE(LAPACK REQUIRED)
endif (APPLE)
SET(FEELPP_LIBRARIES  ${LAPACK_LIBRARIES} ${FEELPP_LIBRARIES})

FIND_PACKAGE(Boost COMPONENTS date_time filesystem system program_options unit_test_framework signals  ${FEELPP_BOOST_MPI} regex  serialization)
OPTION(BOOST_ENABLE_TEST_DYN_LINK "enable boost test with dynamic lib" ON)
MARK_AS_ADVANCED(BOOST_ENABLE_TEST_DYN_LINK)

set(Boost_ADDITIONAL_VERSIONS "1.39" "1.40" "1.41" "1.42" "1.43" "1.44" "1.45" "1.46" "1.47" "1.48" "1.49" )
set( BOOST_PARAMETER_MAX_ARITY 20 )
#set( BOOST_FILESYSTEM_VERSION 2)
set( BOOST_FILESYSTEM_VERSION 3)
if (BOOST_ENABLE_TEST_DYN_LINK)
    add_definitions( -DBOOST_PARAMETER_MAX_ARITY=${BOOST_PARAMETER_MAX_ARITY} -DBOOST_TEST_DYN_LINK -DBOOST_FILESYSTEM_VERSION=${BOOST_FILESYSTEM_VERSION})
else (BOOST_ENABLE_TEST_DYN_LINK)
    add_definitions( -DBOOST_PARAMETER_MAX_ARITY=${BOOST_PARAMETER_MAX_ARITY} -DBOOST_FILESYSTEM_VERSION=${BOOST_FILESYSTEM_VERSION})
endif (BOOST_ENABLE_TEST_DYN_LINK)

if(CMAKE_COMPILER_IS_GNUCXX)
# this fix an issue with boost filesystem: boost is usually no compiled with
# std=c++0x and we compile with it, this causes problems with the macro
# BOOST_SCOPED_ENUM macros whose behavior differs in both case and would
# generate different c++ codes and undefined references at link time.
# in a short future, this should not be necessary anymore
ADD_DEFINITIONS(-DBOOST_NO_SCOPED_ENUMS)
endif()

INCLUDE_DIRECTORIES(${Boost_INCLUDE_DIR}   ${BOOST_INCLUDE_PATH})

SET(FEELPP_LIBRARIES ${Boost_LIBRARIES} ${FEELPP_LIBRARIES})

INCLUDE_DIRECTORIES(BEFORE contrib/)

#
# Eigen
#
if ( EXISTS ${CMAKE_CURRENT_SOURCE_DIR}/feel AND EXISTS ${CMAKE_CURRENT_SOURCE_DIR}/contrib )
  option(EIGEN_BUILD_PKGCONFIG "Build pkg-config .pc file for Eigen" OFF)
  set(EIGEN_INCLUDE_INSTALL_DIR ${CMAKE_INSTALL_PREFIX})
  add_subdirectory(contrib/eigen)
  INCLUDE_DIRECTORIES( ${FEELPP_SOURCE_DIR}/contrib/eigen )
endif()

#FIND_PACKAGE(Eigen2 REQUIRED)
#INCLUDE_DIRECTORIES( ${Eigen2_INCLUDE_DIR} )
#add_subdirectory(contrib/eigen)
#INCLUDE_DIRECTORIES( ${FEELPP_SOURCE_DIR}/contrib/eigen )
#add_definitions( -DEIGEN_NO_STATIC_ASSERT )

#
# Scotch
#
#CheckIncludeFileCXX( ptscotch.h FEELPP_HAS_PTSCOTCH_H )
#CheckIncludeFileCXX( scotch.h FEELPP_HAS_SCOTCH_H )
#
# Metis
#
FIND_PACKAGE(Metis)
if ( METIS_FOUND )
  INCLUDE_DIRECTORIES(${METIS_INCLUDE_DIR})
#  LINK_DIRECTORIES(${METIS_LIBRARIES})
  SET(FEELPP_LIBRARIES ${METIS_LIBRARY} ${FEELPP_LIBRARIES})
  SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} Metis" )
endif( METIS_FOUND )

#
# Ann
#
FIND_PACKAGE(ANN REQUIRED)
if ( ANN_FOUND )
  INCLUDE_DIRECTORIES( ${ANN_INCLUDE_DIR} )
  SET(FEELPP_LIBRARIES ${ANN_LIBRARIES} ${FEELPP_LIBRARIES})
  SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} ANN" )
endif()

#
# GLPK
#
FIND_PACKAGE(GLPK REQUIRED)
if ( GLPK_FOUND )
  INCLUDE_DIRECTORIES( ${GLPK_INCLUDE_DIR} )
  SET(FEELPP_LIBRARIES ${GLPK_LIBRARIES} ${FEELPP_LIBRARIES})
  SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} GLPK" )
endif()

# xml
find_package(LibXml2 2.6.27)

# Python
FIND_PACKAGE(PythonLibs)
if ( PYTHONLIBS_FOUND )
   message(STATUS "PythonLibs: ${PYTHON_INCLUDE_DIRS} ${PYTHON_LIBRARIES}")
   include_directories(${PYTHON_INCLUDE_DIRS})
#   SET(FEELPP_LIBRARIES ${PYTHON_LIBRARIES} ${FEELPP_LIBRARIES})
   SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} Python" )
endif()

FIND_LIBRARY(METIS_LIBRARY
    NAMES
    metis
    PATHS
    $ENV{PETSC_DIR}/lib
#    "/opt/local/lib"
)
message(STATUS "Metis: ${METIS_LIBRARY}" )
IF( METIS_LIBRARY )
 SET(FEELPP_LIBRARIES ${METIS_LIBRARY} ${FEELPP_LIBRARIES})
ENDIF()

FIND_LIBRARY(PARMETIS_LIBRARY
    NAMES
    parmetis
    PATHS
    $ENV{PETSC_DIR}/lib
)


IF( PARMETIS_LIBRARY )
message(STATUS "Parmetis: ${PARMETIS_LIBRARY}" )
SET(FEELPP_LIBRARIES ${PARMETIS_LIBRARY} ${FEELPP_LIBRARIES})
ENDIF()

FIND_LIBRARY(ML_LIBRARY
    NAMES
    ml
    PATHS
    $ENV{PETSC_DIR}/lib
)
message(STATUS "ML: ${ML_LIBRARY}" )
IF ( ML_LIBRARY )
SET(FEELPP_LIBRARIES ${ML_LIBRARY} ${FEELPP_LIBRARIES})
ENDIF()
FIND_LIBRARY(GFORTRAN_LIBRARY
    NAMES
    gfortran
    PATHS
    "/opt/local/lib"
    "/usr/lib/gcc/x86_64-linux-gnu/"
    PATH_SUFFIXES
    gcc46 gcc45 gcc44 4.6 4.5 4.4
)

FIND_LIBRARY(MUMPS_COMMON_LIBRARY
    NAMES
    mumps_common
    PATHS
    $ENV{PETSC_DIR}/lib
)


FIND_LIBRARY(DMUMPS_LIBRARY
    NAMES
    dmumps
    PATHS
    $ENV{PETSC_DIR}/lib
)

message(STATUS "Mumps: ${DMUMPS_LIBRARY} ${MUMPS_COMMON_LIBRARY}" )
if ( GFORTRAN_LIBRARY AND MUMPS_COMMON_LIBRARY AND DMUMPS_LIBRARY )
SET(FEELPP_LIBRARIES ${DMUMPS_LIBRARY} ${MUMPS_COMMON_LIBRARY} ${GFORTRAN_LIBRARY} ${FEELPP_LIBRARIES})
endif()

FIND_LIBRARY(AMD_LIBRARY
    NAMES
    amd
    PATHS
    $ENV{PETSC_DIR}/lib
)

FIND_LIBRARY(UMFPACK_LIBRARY
    NAMES
    umfpack
    PATHS
    $ENV{PETSC_DIR}/lib
)
message(STATUS "Amd: ${AMD_LIBRARY}" )
message(STATUS "Umfpack: ${UMFPACK_LIBRARY}" )
SET(FEELPP_LIBRARIES ${UMFPACK_LIBRARY} ${AMD_LIBRARY} ${FEELPP_LIBRARIES})

#
# Petsc
#
FIND_PACKAGE( PETSc REQUIRED)
if ( PETSC_FOUND )
  SET(CMAKE_REQUIRED_INCLUDES "${PETSC_INCLUDES};${CMAKE_REQUIRED_INCLUDES}")
  SET(FEELPP_LIBRARIES ${PETSC_LIBRARIES} ${FEELPP_LIBRARIES})
  SET(BACKEND_PETSC petsc)
  INCLUDE_DIRECTORIES(
    ${PETSC_INCLUDE_DIR}
    ${PETSC_INCLUDE_CONF}
    )
  SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} PETSc" )

endif( PETSC_FOUND )

#
# parpack
#
FIND_LIBRARY(PARPACK_LIBRARY NAMES parpack)
if (PARPACK_LIBRARY)
    SET(PARPACK_LIBRARIES ${PARPACK_LIBRARY})
    SET(FEELPP_LIBRARIES ${PARPACK_LIBRARIES} ${FEELPP_LIBRARIES})
endif()
MARK_AS_ADVANCED( PARPACK_LIBRARY )


#
# SLEPc
#
OPTION(FEELPP_ENABLE_SLEPC "enable feel++ SLEPc support" ON)
if (FEELPP_ENABLE_SLEPC)
  FIND_PACKAGE( SLEPc )
  if ( SLEPC_FOUND )
    SET(CMAKE_REQUIRED_INCLUDES "${SLEPC_INCLUDES};${CMAKE_REQUIRED_INCLUDES}")
    INCLUDE_DIRECTORIES( ${SLEPC_INCLUDE_DIR} )
    SET(FEELPP_LIBRARIES ${SLEPC_LIBRARIES} ${FEELPP_LIBRARIES})
    SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} SLEPc" )
  endif(SLEPC_FOUND)
endif(FEELPP_ENABLE_SLEPC)


#
# Trilinos
#
OPTION(FEELPP_ENABLE_TRILINOS "enable feel++ Trilinos support" ON)
if (FEELPP_ENABLE_TRILINOS)
FIND_PACKAGE(Trilinos)
  if ( TRILINOS_FOUND )
    INCLUDE_DIRECTORIES(${TRILINOS_INCLUDE_DIR})
    SET(FEELPP_LIBRARIES ${TRILINOS_LIBRARIES} ${FEELPP_LIBRARIES})
    SET(BACKEND_TRILINOS trilinos)
    SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} Trilinos" )
  endif( TRILINOS_FOUND )
endif (FEELPP_ENABLE_TRILINOS)

#
# OpenTURNS
#
OPTION(FEELPP_ENABLE_OPENTURNS "enable feel++ OpenTURNS support" ON)
IF ( FEELPP_ENABLE_OPENTURNS )
  FIND_PACKAGE( OpenTURNS )
  if ( OPENTURNS_FOUND )
    MESSAGE(STATUS "OpenTURNS Libraries: ${OpenTURNS_LIBRARIES}")
    MESSAGE(STATUS "OpenTURNS Headers: ${OpenTURNS_INCLUDE_DIRS}")
    INCLUDE_DIRECTORIES(${OpenTURNS_INCLUDE_DIRS})
    SET(FEELPP_LIBRARIES ${OpenTURNS_LIBRARIES} ${FEELPP_LIBRARIES})
    SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} OpenTURNS" )
  endif( OPENTURNS_FOUND )
endif()

#
# VTK
#
FIND_PACKAGE(VTK)
if ( VTK_FOUND )
  set(FEELPP_HAS_VTK 1)
  SET(VTK_LIBRARIES "-lvtkRendering -lvtkGraphics -lvtkImaging  -lvtkFiltering -lvtkCommon" )
  INCLUDE_DIRECTORIES(${VTK_INCLUDE_DIRS})
  MARK_AS_ADVANCED( VTK_DIR )
  SET(FEELPP_LIBRARIES ${VTK_LIBRARIES} ${FEELPP_LIBRARIES})
  SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} VTK" )
endif()

#
# Octave
#
OPTION(FEELPP_ENABLE_OCTAVE "Enable Feel++/Octave interface" OFF)
if ( FEELPP_ENABLE_OCTAVE )
  FIND_PACKAGE(Octave)
  if ( OCTAVE_FOUND )

    # find octave-config and get variables from it
    FIND_PROGRAM(OCTAVE_CONFIG octave-config)
    IF(NOT OCTAVE_CONFIG)
      MESSAGE(FATAL_ERROR "Octave is required, but octave-config was not found.  Please install Octave and rerun cmake.")
    ENDIF(NOT OCTAVE_CONFIG)

    EXECUTE_PROCESS(COMMAND ${OCTAVE_CONFIG} --oct-site-dir
      OUTPUT_VARIABLE OCT_SITE_DIR OUTPUT_STRIP_TRAILING_WHITESPACE)
    EXECUTE_PROCESS(COMMAND ${OCTAVE_CONFIG} --m-site-dir
      OUTPUT_VARIABLE M_SITE_DIR OUTPUT_STRIP_TRAILING_WHITESPACE)
    EXECUTE_PROCESS(COMMAND ${OCTAVE_CONFIG} -p OCTINCLUDEDIR
      OUTPUT_VARIABLE OCTINCLUDEDIR OUTPUT_STRIP_TRAILING_WHITESPACE)
    EXECUTE_PROCESS(COMMAND ${OCTAVE_CONFIG} -p OCTLIBDIR
      OUTPUT_VARIABLE OCTLIBDIR OUTPUT_STRIP_TRAILING_WHITESPACE)

    # Make the values accessible from other CMakeLists.txt files
    # Also, this allows packagers to override the default values
    SET(FEELPP_OCT_DIR ${OCT_SITE_DIR}/feel++ CACHE PATH ".oct files from Feel++")
    SET(FEELPP_M_DIR ${M_SITE_DIR}/feel++ CACHE PATH ".m files from Feel++")

    message(STATUS "oct dir: ${FEELPP_OCT_DIR}" )
    message(STATUS "m dir: ${FEELPP_M_DIR}" )
    message(STATUS "include dir: ${OCTINCLUDEDIR}" )


    INCLUDE_DIRECTORIES( ${OCTINCLUDEDIR} )

    SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} Octave" )
  endif( OCTAVE_FOUND )
endif( FEELPP_ENABLE_OCTAVE)

#
# Gmsh
#
FIND_PACKAGE(Gmsh REQUIRED)
if ( GMSH_FOUND )
  ADD_DEFINITIONS( -DFEELPP_HAS_GMSH=1 -D_FEELPP_HAS_GMSH_ -DGMSH_EXECUTABLE=${GMSH_EXECUTABLE} )
  SET(FEELPP_LIBRARIES ${GMSH_LIBRARY} ${FEELPP_LIBRARIES})
  include_directories(${GMSH_INCLUDE_DIR})
  SET(FEELPP_ENABLED_OPTIONS "${FEELPP_ENABLED_OPTIONS} Gmsh" )
endif()


#
# if Feel++ has been installed on the system
#
if ( NOT EXISTS ${CMAKE_SOURCE_DIR}/feel OR NOT EXISTS ${CMAKE_SOURCE_DIR}/contrib )
  FIND_PATH(FEELPP_INCLUDE_DIR feelconfig.h  PATHS /usr/include/feel /usr/lib/feel/include /opt/feel/include /usr/ljk/include/feel /usr/local  )

  FIND_LIBRARY(FEELPP_LIBRARY feel++ PATHS /usr/lib /usr/lib/feel/lib /opt/feel/lib /usr/ljk/lib )

  INCLUDE_DIRECTORIES ( ${FEELPP_INCLUDE_DIR} )
  FIND_PACKAGE_HANDLE_STANDARD_ARGS (Feel DEFAULT_MSG
    FEELPP_INCLUDE_DIR  FEELPP_LIBRARY
    )



 if ( FEELPP_FOUND )
    message(STATUS "Feel++ includes: ${FEELPP_INCLUDE_DIR}")
    message(STATUS "Feel++ library: ${FEELPP_LIBRARY}")
  endif()

  MARK_AS_ADVANCED(
  FEELPP_INCLUDE_DIR
  FEELPP_LIBRARY
  )
else()
  message(STATUS "we work within Feel++ sources")
  INCLUDE_DIRECTORIES (
    ${FEELPP_BUILD_DIR}/
    ${FEELPP_SOURCE_DIR}/
    ${FEELPP_SOURCE_DIR}/contrib/gmm/include
    )
endif()

SET(FEELPP_LIBRARIES feel++  ${FEELPP_LIBRARIES})

LINK_DIRECTORIES(
  ${VTK_LIBRARY_DIRS}
  ${BOOST_LIBRARY_PATH}
  ${MPI_LIBRARY_PATH}
  )


MARK_AS_ADVANCED(FEELPP_LIBRARIES)

