/*
 * $Id: ide_gen_cdrom_gui_gtk.c,v 1.26 2009-07-13 09:08:55 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "system.h"
#include "glue-gui.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-change.h"
#include "glue-gui-gtk-fi.h"

#include "ide_gen_cdrom_gui_gtk.h"

#define COMP "ide_gen_cdrom"

struct cpssp {
	struct sig_string *port_change;

	GtkWidget *gui_change;
	GtkWidget *gui_fi;

	int comp_id;

	int fault_sig_id;
	struct sig_boolean *fault_sig_ptr;
};

/*
 * Simulator Callbacks
 */

static void
ide_gen_cdrom_gui_change(void *_cpssp, const char *path)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_change_set(GUI_GTK_CHANGE(cpssp->gui_change), path);
}

/*
 * GUI Callbacks
 */
static void
ide_gen_cdrom_insert_event(GtkWidget *w, const char *string, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_change, cpssp, string);
}

static void
ide_gen_cdrom_remove_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_string_set(cpssp->port_change, cpssp, "");
}

static void
ide_gen_cdrom_gui_drive_fault_event(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	fprintf(stderr, "%s %p %u\n", __FUNCTION__, cpssp, fault->state);

	free(fault);
}

void *
ide_gen_cdrom_gui_gtk_create(
	unsigned int page,
	const char *name,
	const char *unit_str,
	struct sig_manage *port_manage,
	struct sig_power_device *port_power,
	struct sig_ide_bus *port_ide,
	struct sig_magneto_optical *port_media,
	struct sig_string *port_change
)
{
	static const struct sig_string_funcs change_funcs = {
		.set = ide_gen_cdrom_gui_change,
	};
	struct cpssp *cpssp;
	char path[1024];
	GtkWidget *vbox;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);

	cpssp->comp_id = system_comp_lookup(name);

	vbox = gtk_vbox_new(FALSE, 1);

	cpssp->gui_change = gui_gtk_change_new("CD");
	GTK_WIDGET_UNSET_FLAGS(cpssp->gui_change, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(cpssp->gui_change), "change-inserted",
			G_CALLBACK(ide_gen_cdrom_insert_event), cpssp);
	g_signal_connect(G_OBJECT(cpssp->gui_change), "change-removed",
			G_CALLBACK(ide_gen_cdrom_remove_event), cpssp);
	gtk_widget_show(cpssp->gui_change);
	gtk_box_pack_end(GTK_BOX(vbox), cpssp->gui_change, FALSE, FALSE, 1);

	cpssp->gui_fi = gui_gtk_fi_new("Drive Fault", "Boolean");
	g_signal_connect(G_OBJECT(cpssp->gui_fi), "fi-change",
			G_CALLBACK(ide_gen_cdrom_gui_drive_fault_event),
			cpssp);

	gui_gtk_comp_add(page, COMP, name, vbox,
			FALSE, FALSE, cpssp->gui_fi);

	/* Fault Signal */
	snprintf(path, sizeof(path)-1, "%s:fault", system_path());
	path[sizeof(path)-1] = '\0';
	cpssp->fault_sig_id = system_sig_create("boolean", path);
	assert(0 <= cpssp->fault_sig_id);
	cpssp->fault_sig_ptr = system_sig_get(cpssp->fault_sig_id);
	assert(cpssp->fault_sig_ptr);

	system_comp_connect(cpssp->comp_id, "fault", cpssp->fault_sig_id);

	/* Out */
	cpssp->port_change = port_change;

	/* In */
	sig_string_connect(port_change, cpssp, &change_funcs);

	system_name_pop();

	return cpssp;
}

void
ide_gen_cdrom_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	system_comp_disconnect(cpssp->comp_id, "fault");
	system_sig_unget(cpssp->fault_sig_ptr);
	system_sig_destroy(cpssp->fault_sig_id);

	free(cpssp);
}
