/* $Id: list.h 4799 2009-10-02 13:22:19Z potyra $
 *
 * Generic list structures.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LIST_H_INCLUDED
#define __LIST_H_INCLUDED

#include <stdlib.h>

/** entry in a single linked list */
struct slist_entry {
	/** pointer to next element */
	struct slist_entry *next;
	/** pointer to data object */
	void *data;
};

/** single linked list */
struct slist {
	/** pointer to first element */
	struct slist_entry *first;
	/** pointer to last element. */
	struct slist_entry *tail;
};

extern struct slist *
slist_create(void *(*allocator)(size_t));

extern void
slist_destroy(struct slist *l, void (*deallocator)(void *));

extern void
slist_add(struct slist *l, void *data, void *(*allocator)(size_t));

#endif /* __LIST_H_INCLUDED */
