#ifndef __RARRAY_H__
#define __RARRAY_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include <stdlib.h>

/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/

struct rarray {
  void     **array;
  int        size;
  int        count;
  unsigned   flags;
};

typedef struct rarray rarray_t;

/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern rarray_t *rarray_create_size (size_t size);
extern rarray_t *rarray_create (void);
extern void      rarray_destroy (rarray_t *ptr);
extern void      rarray_add (rarray_t *ptr, void *p);
extern void      rarray_remove (rarray_t *ptr, unsigned index);
extern void      rarray_shrink (rarray_t *ptr);
extern rarray_t *rarray_join (rarray_t *x, rarray_t *y);
extern void      rarray_add_array (rarray_t *x, rarray_t *y,
                                   int (*pred)(void *));

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER rarray.h
 *
 ****************************************************************************/
#endif
