/*
 * Copyright (C) 2004-2007 by CERN/IT/GD/CT
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)$RCSfile: dpm_util.c,v $ $Revision: 1.11 $ $Date: 2009/11/13 10:03:12 $ CERN IT-GD/CT Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Castor_limits.h"
#include "dpm_constants.h"
#include "dpm_util.h"
#include "serrno.h"

#ifndef _WIN32
#if defined(_REENTRANT) || defined(_THREAD_SAFE)
#define strtok(X,Y) strtok_r(X,Y,&last)
#endif /* _REENTRANT || _THREAD_SAFE */
#endif /* _WIN32 */

extern char *getconfent();
extern char localdomain[CA_MAXHOSTNAMELEN+1];
extern char localhost[CA_MAXHOSTNAMELEN+1];
static char *default_protocols[] = {"rfio", "gsiftp", NULL};

build_proxy_filename(char *proxy_filename, char *r_token)
{
	strcpy (proxy_filename, P_tmpdir);
	if (*(P_tmpdir+sizeof(P_tmpdir)-2) != '/')
		strcat (proxy_filename, "/");
	strcat (proxy_filename, "dpm");
	strcat (proxy_filename, r_token);
	return (0);
}

get_req_retention_time(tp)
time_t *tp;
{
	int errflag;
	char *p;
	char *p2;
	time_t req_retention;

	p = getconfent ("DPM", "REQCLEAN", 0);
	req_retention = 0x7FFFFFFF;
	if (p && strcmp (p, "Inf") != 0) {
		errflag = 0;
		if ((req_retention = strtol (p, &p2, 10)) < 0 ||
		    (*p2 != '\0' && *(p2+1) != '\0')) {
			errflag++;
		} else {
			switch (*p2) {
				case 'y':
					req_retention *= 365 * 86400;
					break;

				case 'm':
					req_retention *= 30 * 86400;
					break;

				case 'd':
					req_retention *= 86400;
					break;
                                                
				case 'h':
					req_retention *= 3600;
					break;

				case '\0':
					break;

				default:
					errflag++;
					break;
			}
		}
		if (errflag)
			return (-1);
	}
	*tp = req_retention;
	return (0);
}

get_supported_protocols(char ***sup_proto)
{
#ifndef _WIN32
#if defined(_REENTRANT) || defined(_THREAD_SAFE)
	char *last = NULL;
#endif
#endif
	int nb_supported_protocols = 0;
	char *p;
	char *protocols;
	char *sav_protocols;
	char **supported_protocols;

	if ((protocols = getconfent ("DPM", "PROTOCOLS", 1))) {
		if ((sav_protocols = strdup (protocols)) == NULL)
			return (-1);
		p = strtok (protocols, " \t");
		while (p) {
			nb_supported_protocols++;
			p = strtok (NULL, " \t");
		}
		if ((supported_protocols =
		    malloc ((nb_supported_protocols + 1) * sizeof(char *))) == NULL) {
			free (sav_protocols);
			return (-1);
		}
		nb_supported_protocols = 0;
		p = strtok (sav_protocols, " \t");
		while (p) {
			supported_protocols[nb_supported_protocols++] = p;
			p = strtok (NULL, " \t");
		}
		supported_protocols[nb_supported_protocols] = NULL;
	} else {
		supported_protocols = default_protocols;
		while (supported_protocols[nb_supported_protocols])
			nb_supported_protocols++;
	}
	*sup_proto = supported_protocols;
	return (nb_supported_protocols);
}

is_surl_local (char *surl)
{
	int len;
	char *p;
	char *q;
	char server[CA_MAXHOSTNAMELEN+1];

	if (strncmp (surl, "srm://", 6)) {
		errno = EINVAL;
		return (-1);
	}
	if ((p = strchr (surl + 6, '/')) == NULL) {
		errno = EINVAL;
		return (-1);
	}
	if (memchr (surl + 6, '[', p - surl - 6) != NULL) {
		/* the surl host is an IP address: it is not supported */
		errno = EINVAL;
		return (-1);
	}
	if ((q = memchr (surl + 6, ':', p - surl - 6)) != NULL)
		p = q;
	if ((len = p - surl - 6) >= sizeof(server)) {
		errno = EINVAL;
		return (-1);
	}
	memcpy (server, surl + 6, len);
	server[len] = '\0';
	if (strcmp (server, localhost) == 0)
		return (1);
	if (strchr (server, '.'))
		return (0);
	if (len + strlen (localdomain) >= sizeof(server)) {
		errno = EINVAL;
		return (-1);
	}
	strcat (server, localdomain);
	if (strcmp (server, localhost) == 0)
		return (1);
	return (0);
}

char *
sfnfromsurl (char *surl)
{
	char *p;

	if (strncmp (surl, "srm://", 6)) {
		errno = EINVAL;
		return (NULL);
	}
	if ((p = strstr (surl + 6, "?SFN=")))
		return (p + 5);
	if ((p = strchr (surl + 6, '/')) == NULL) {
		errno = EINVAL;
		return (NULL);
	}
	return (p);
}

char *
status2str (int status, char *buf)
{
	static char *s_status[] = {
		"DPM_SUCCESS", "DPM_QUEUED", "DPM_ACTIVE", "DPM_READY",
		"DPM_RUNNING", "DPM_DONE", "DPM_FAILED", "DPM_ABORTED",
		"DPM_EXPIRED", "DPM_RELEASED"};
	if ((status & 0xF000) == DPM_FAILED)
		sprintf (buf, "DPM_FAILED (%s)", sstrerror (status - DPM_FAILED));
	else if (status >= DPM_SUCCESS && status <= DPM_RELEASED)
		strcpy (buf, s_status[status >> 12]);
	else
		sprintf (buf, "%d", status);
	return (buf);
}

const char *
csumtype2srmname (const char *csumtype)
{
	const char *name = csumtype;
	if (!strcmp (csumtype, "AD"))
		name = "ADLER32";
	else if (!strcmp (csumtype, "CS"))
		name = "CRC32";
	else if (!strcmp (csumtype, "MD"))
		name = "MD5";
	return name;
}
