/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File:  oct6100_defines.h

    Copyright (c) 2001-2007 Octasic Inc.
    
Description: 

	Header file containing all defines used throughout the API.

This file is part of the Octasic OCT6100 GPL API . The OCT6100 GPL API  is 
free software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation; 
either version 2 of the License, or (at your option) any later version.

The OCT6100 GPL API is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
for more details. 

You should have received a copy of the GNU General Public License 
along with the OCT6100 GPL API; if not, write to the Free Software 
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.7

$Octasic_Release: OCT612xAPI-01.00-PR49 $

$Octasic_Revision: 171 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef __OCT6100_DEFINES_H__
#define __OCT6100_DEFINES_H__

/*****************************  INCLUDE FILES  *******************************/

#include "octdef.h"

/*****************************  DEFINES  *************************************/

/* 32-bits values. */
#define cOCT6100_FFFFFFFF	0xFFFFFFFF
#define cOCT6100_FFFFFFFE	0xFFFFFFFE
#define cOCT6100_7FFFFFFF	0x7FFFFFFF

/* 16-bits values. */
#define cOCT6100_FFFD		0xFFFD
#define cOCT6100_FFFE		0xFFFE
#define cOCT6100_FFFF		0xFFFF
#define cOCT6100_7FFF		0x7FFF

/* 8-bits values. */
#define cOCT6100_FF			0xFF

#define cOCT6100_CURRENT_VALUE				cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_CHIP_ID			cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_HANDLE				cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_TIMESLOT			cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_STREAM				cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_VALUE				cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_STAT				cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_STAT_W				cOCT6100_FFFF
#define cOCT6100_INVALID_PCM_LAW			cOCT6100_FF
#define cOCT6100_INVALID_EVENT				cOCT6100_FFFF
#define cOCT6100_INVALID_INDEX				cOCT6100_FFFF
#define cOCT6100_INVALID_TONE				cOCT6100_FFFFFFFF
#define cOCT6100_INVALID_PORT				cOCT6100_FF

#define cOCT6100_AUTO_SELECT				cOCT6100_FFFFFFFE
#define cOCT6100_AUTO_SELECT_TAIL			cOCT6100_FFFE

#define cOCT6100_INVALID_BOOL				2

#define cOCT6100_KEEP_PREVIOUS_SETTING		0x70100000

#define cOCT6100_INVALID_SIGNED_STAT		cOCT6100_7FFFFFFF
#define cOCT6100_INVALID_SIGNED_STAT_W		cOCT6100_7FFF
#define cOCT6100_INVALID_ECHO_DELAY			0x400



#define cOCT6100_SIZE_128	128
#define cOCT6100_SIZE_256	256
#define cOCT6100_SIZE_512	512
#define cOCT6100_SIZE_1K	1024
#define cOCT6100_SIZE_2K	2048
#define cOCT6100_SIZE_4K	4096
#define cOCT6100_SIZE_8K	8192
#define cOCT6100_SIZE_16K	16384
#define cOCT6100_SIZE_32K	32768
#define cOCT6100_SIZE_64K	65536
#define cOCT6100_SIZE_128K	131072
#define cOCT6100_SIZE_256K	262144
#define cOCT6100_SIZE_512K	524288
#define cOCT6100_SIZE_1M	1048576
#define cOCT6100_SIZE_2M	2097152
#define cOCT6100_SIZE_4M	4194304
#define cOCT6100_SIZE_8M	8388608
#define cOCT6100_SIZE_16M	16777216
#define cOCT6100_SIZE_32M	33554432
#define cOCT6100_SIZE_64M	67108864
#define cOCT6100_SIZE_128M	134217728
#define cOCT6100_SIZE_256M	268435456
#define cOCT6100_SIZE_512M	536870912
#define cOCT6100_SIZE_1G	1073741824 
#define cOCT6100_SIZE_2G	2147483648

#define cOCT6100_HNDL_TAG_MASK					0xFF000000
#define cOCT6100_HNDL_INDEX_MASK				0x0000FFFF
#define cOCT6100_ENTRY_OPEN_CNT_MASK			0x000000FF
#define cOCT6100_ENTRY_OPEN_CNT_SHIFT			16

#define cOCT6100_HNDL_TAG_INVALID				0xFF000000

#define cOCT6100_HNDL_TAG_CHANNEL				0x01000000
#define cOCT6100_HNDL_TAG_TSI_CNCT				0x02000000
#define cOCT6100_HNDL_TAG_CONF_BRIDGE			0x03000000
#define cOCT6100_HNDL_TAG_PHASING_TSST			0x04000000
#define cOCT6100_HNDL_TAG_BIDIR_CHANNEL			0x05000000
#define cOCT6100_HNDL_TAG_COPY_EVENT			0x06000000
#define cOCT6100_HNDL_TAG_ADPCM_CHANNEL			0x07000000

#define cOCT6100_INVALID_HANDLE_TYPE	cOCT6100_INVALID_VALUE

#define cOCT6100_MEMORY_ROUND_SIZE 16

#define mOCT6100_ROUND_MEMORY_SIZE( ulMemorySize, ulTempVar )			\
	if ((ulTempVar = ulMemorySize % cOCT6100_MEMORY_ROUND_SIZE) != 0)	\
		ulMemorySize += cOCT6100_MEMORY_ROUND_SIZE - ulTempVar;

#define mOCT6100_ROUND_ADDRESS( ulAddress, ulBoundary, ulTempVar )		\
	if ((ulTempVar = ulAddress % ulBoundary) != 0)						\
		ulAddress += ulBoundary - ulTempVar;

#define cOCT6100_INTERNAL_CLOCK_SOURCE	0
#define cOCT6100_EXTERNAL_CLOCK_SOURCE	1

#define cOCT6100_ACTIVE_HIGH_POLARITY	0
#define cOCT6100_ACTIVE_LOW_POLARITY	1

#define cOCT6100_TDM_SAMPLE_AT_3_QUARTERS		0
#define cOCT6100_TDM_SAMPLE_AT_RISING_EDGE		1
#define cOCT6100_TDM_SAMPLE_AT_FALLING_EDGE		2

#define cOCT6100_TDM_STREAM_FREQ_2MHZ	0
#define cOCT6100_TDM_STREAM_FREQ_4MHZ	1
#define cOCT6100_TDM_STREAM_FREQ_8MHZ	2
#define cOCT6100_TDM_STREAM_FREQ_16MHZ	3

#define cOCT6100_TDM_STREAM_MAX_GROUPS	8

#define cOCT6100_PCM_U_LAW		0
#define cOCT6100_PCM_A_LAW		1
#define cOCT6100_PCM_UNCHANGED	2
#define cOCT6100_ADPCM_ENCODED	3

#define cOCT6100_INTERRUPT_DISABLE		0
#define cOCT6100_INTERRUPT_NO_TIMEOUT	1
#define cOCT6100_INTERRUPT_TIMEOUT		2

#define cOCT6100_NUMBER_TSSTS_1		1
#define cOCT6100_NUMBER_TSSTS_2		2

#define cOCT6100_G711_64KBPS				1
#define cOCT6100_G726_40KBPS				2
#define cOCT6100_G726_32KBPS				3
#define cOCT6100_G726_24KBPS				4
#define cOCT6100_G726_16KBPS				5
#define cOCT6100_G727_40KBPS_4_1			6
#define cOCT6100_G727_40KBPS_3_2			7
#define cOCT6100_G727_40KBPS_2_3			8
#define cOCT6100_G727_32KBPS_4_0			9
#define cOCT6100_G727_32KBPS_3_1			10
#define cOCT6100_G727_32KBPS_2_2			11
#define cOCT6100_G727_24KBPS_3_0			12
#define cOCT6100_G727_24KBPS_2_1			13
#define cOCT6100_G727_16KBPS_2_0			14
#define cOCT6100_G726_ENCODED				15
#define cOCT6100_G711_G726_ENCODED			16
#define cOCT6100_G711_G727_2C_ENCODED		17
#define cOCT6100_G711_G727_3C_ENCODED		18
#define cOCT6100_G711_G727_4C_ENCODED		19
#define cOCT6100_G727_2C_ENCODED			20
#define cOCT6100_G727_3C_ENCODED			21
#define cOCT6100_G727_4C_ENCODED			22

#define cOCT6100_ADPCM_IN_HIGH_BITS			0
#define cOCT6100_ADPCM_IN_LOW_BITS			1

/* The values of these defines must not change. */
#define cOCT6100_H100_TRACKA			0
#define cOCT6100_H100_TRACKB			1
#define cOCT6100_H100_TRACKA_FALLBACKB	2
#define cOCT6100_H100_TRACKB_FALLBACKA	3
#define cOCT6100_H100_DISABLED			4
#define cOCT6100_H100_MASTERA			5
#define cOCT6100_H100_BACKUPA			6
#define cOCT6100_H100_MASTERB			7
#define cOCT6100_H100_BACKUPB			8

#define cOCT6100_FREE_TSST	0
#define cOCT6100_RX_TSST	16
#define cOCT6100_TX_TSST	32

#define cOCT6100_INTRPT_ACTIVE			0
#define cOCT6100_INTRPT_WILL_TIMEOUT	1
#define cOCT6100_INTRPT_IN_TIMEOUT		2
#define cOCT6100_INTRPT_DISABLED		3

#define cOCT6100_EXTERNAL_MEM_BIST_TIMEOUT	1000000

/* Clocks defines */
#define cOCT6100_UPCLK_FREQ_33_33_MHZ		33333333

#define cOCT6100_MCLK_FREQ_133_MHZ			133000000
#define cOCT6100_MCLK_FREQ_125_MHZ			125000000
#define cOCT6100_MCLK_FREQ_117_MHZ			117000000
#define cOCT6100_MCLK_FREQ_108_MHZ			108000000
#define cOCT6100_MCLK_FREQ_100_MHZ			100000000
#define cOCT6100_MCLK_FREQ_92_MHZ			 92000000
#define cOCT6100_MCLK_FREQ_83_MHZ			 83000000
#define cOCT6100_MCLK_FREQ_75_MHZ			 75000000

/* Tone buffer defines.*/
#define cOCT6100_MAX_NUM_TONE_BUFFERS	1344
#define cOCT6100_MAX_TONES_PER_CALL		32

/* Memory defines.*/
#define	cOCT6100_MEM_TYPE_SDR				0
#define	cOCT6100_MEM_TYPE_DDR				1
#define cOCT6100_MEM_TYPE_SDR_PLL_BYPASS	2

#define cOCT6100_MEMORY_CHIP_SIZE_8MB		cOCT6100_SIZE_8M
#define cOCT6100_MEMORY_CHIP_SIZE_16MB		cOCT6100_SIZE_16M
#define cOCT6100_MEMORY_CHIP_SIZE_32MB		cOCT6100_SIZE_32M
#define cOCT6100_MEMORY_CHIP_SIZE_64MB		cOCT6100_SIZE_64M
#define cOCT6100_MEMORY_CHIP_SIZE_128MB		cOCT6100_SIZE_128M

#define cOCT6100_MAX_NUM_MEMORY_CHIP		2

#define cOCT6100_16MB_MEMORY_BANKS			0
#define cOCT6100_32MB_MEMORY_BANKS			1
#define cOCT6100_64MB_MEMORY_BANKS			2
#define cOCT6100_128MB_MEMORY_BANKS			3

#define cOCT6100_1_MEMORY_BANKS				0
#define cOCT6100_2_MEMORY_BANKS				1
#define cOCT6100_3_MEMORY_BANKS				2
#define cOCT6100_4_MEMORY_BANKS				3

/* Chip open defines.*/
#define cOCT6100_INTERNAL_TONE_ARRAY_SIZE	256		/* in words.*/
#define cOCT6100_INTERNAL_SUPER_ARRAY_SIZE	1024	/* in words.*/

/* Internal memory mapping.*/

/*=======================================================================*/
#define cOCT6100_TSST_CONTROL_MEM_BASE			0x26000

#define cOCT6100_TSST_CONTROL_MEM_ENTRY_SIZE			2	/* Each entries are 2 bytes.*/
#define cOCT6100_TSST_CONTROL_MEM_INPUT_TSST			0x0800
#define cOCT6100_TSST_CONTROL_MEM_OUTPUT_TSST			0x2000

#define cOCT6100_TSST_CONTROL_MEM_PCM_LAW_OFFSET		12
#define cOCT6100_TSST_CONTROL_MEM_NIBBLE_POS_OFFSET		11
#define cOCT6100_TSST_CONTROL_MEM_TSST_NUM_OFFSET		12

#define cOCT6100_TSST_CONTROL_MEM_TSI_MEM_MASK			0x7FF

#define cOCT6100_TSST_CONTROL_PHASING_TSST_BASE_ENTRY	1344
#define cOCT6100_TSST_CONTROL_TIMESTAMP_BASE_ENTRY		1516

/*=======================================================================*/
#define cOCT6100_CONVERSION_CONTROL_MEM_BASE				0x28000

/* Each entries are 8 bytes but an 8 bytes mixer entry is located inbetween each entry.*/
#define cOCT6100_CONVERSION_CONTROL_MEM_ENTRY_SIZE			16	
#define cOCT6100_CONVERSION_CONTROL_MEM_ENCODER				0x0000
#define cOCT6100_CONVERSION_CONTROL_MEM_DECODER				0x8000
#define cOCT6100_CONVERSION_CONTROL_MEM_ACTIVATE_ENTRY		0x8000
#define cOCT6100_CONVERSION_CONTROL_MEM_RST_ON_NEXT_FR		0x8000

#define cOCT6100_CONVERSION_CONTROL_MEM_PHASE_OFFSET		12
#define cOCT6100_CONVERSION_CONTROL_MEM_NIBBLE_POS_OFFSET	9
#define cOCT6100_CONVERSION_CONTROL_MEM_COMP_OFFSET			11
#define cOCT6100_CONVERSION_CONTROL_MEM_LAW_OFFSET			8
#define cOCT6100_CONVERSION_CONTROL_MEM_SIL_SUP_OFFSET		8

#define cOCT6100_CONVERSION_CONTROL_PHASE_SIZE_BASE_ADD		0x5400

/*=======================================================================*/
#define cOCT6100_MIXER_CONTROL_MEM_BASE			0x28008

/* Each entries are 8 bytes but an 8 bytes mixer entry is located inbetween each entry.*/
#define cOCT6100_MIXER_CONTROL_MEM_ENTRY_SIZE			16	
#define cOCT6100_MIXER_CONTROL_MEM_SUB_STORE			0xA000
#define cOCT6100_MIXER_CONTROL_MEM_STORE				0x8000
#define cOCT6100_MIXER_CONTROL_MEM_LOAD					0x4000
#define cOCT6100_MIXER_CONTROL_MEM_ACCUMULATE			0x6000
#define cOCT6100_MIXER_CONTROL_MEM_COPY					0x2000
#define cOCT6100_MIXER_CONTROL_MEM_NO_OP				0x0000

#define cOCT6100_MIXER_CONTROL_MEM_LAW_OFFSET			11

#define cOCT6100_MIXER_HEAD_NODE						0
#define cOCT6100_MIXER_TAIL_NODE						1
#define cOCT6100_MIXER_RECORD_COPY_NODE					2

/*=======================================================================*/
#define cOCT6100_ECHO_CONTROL_MEM_BASE			0x14000

#define cOCT6100_ECHO_CONTROL_MEM_ENTRY_SIZE			4	/* Each entries are 8 bytes.*/
#define cOCT6100_ECHO_CONTROL_MEM_ACTIVATE_ENTRY		0x8000
#define cOCT6100_ECHO_CONTROL_MEM_EXTERNAL_AF_CTRL		0x2000

#define cOCT6100_ECHO_CONTROL_MEM_DEBUG_OFFSET			14
#define cOCT6100_ECHO_CONTROL_MEM_AF_CONTROL			14
#define cOCT6100_ECHO_CONTROL_MEM_INPUT_LAW_OFFSET		12
#define cOCT6100_ECHO_CONTROL_MEM_OUTPUT_LAW_OFFSET		11

#define cOCT6100_ECHO_CONTROL_MEM_TSI_MEM_MASK			0x7FF

/*=======================================================================*/
#define cOCT6100_ST_CONTROL_MEM_BASE			0x2000000

#define cOCT6100_ST_CONTROL_MEM_ENTRY_SIZE				16	/* Each entries are 8 bytes.*/

/*=======================================================================*/
#define cOCT6100_PART1_BASE						0x00080000
#define cOCT6100_PART1_CPU_LSU_CB_BASE 			cOCT6100_PART1_BASE+0x0000E3C0	/* 8 * 8    = 64 bytes */
#define cOCT6100_PART1_HW_LSU_CB_BASE 			cOCT6100_PART1_BASE+0x0000E400	/* 8 * 128  = 1K byte */
#define cOCT6100_PART1_END_STATICS_BASE 		cOCT6100_PART1_BASE+0x0000E9F0	/* 912 bytes available for your viewing pleasure. */
#define cOCT6100_PART1_API_SCRATCH_PAD 			cOCT6100_PART1_END_STATICS_BASE+4+(12*8)
#define cOCT6100_PART1_EGO_REG                  cOCT6100_PART1_BASE+0x0007FF00

/* External Memory mapping. */
#define cOCT6100_EXTERNAL_MEM_BLOCK_SIZE		1024
#define cOCT6100_EXTERNAL_MEM_BASE_ADDRESS		0x08000000


#define cOCT6100_TLV_BASE						( 0x00016000 + cOCT6100_EXTERNAL_MEM_BASE_ADDRESS )
#define cOCT6100_CHANNEL_ROOT_BASE				( 0x00020000 + cOCT6100_EXTERNAL_MEM_BASE_ADDRESS )
#define cOCT6100_PGSP_EVENT_OUT_BASE			( 0x002C0000 + cOCT6100_EXTERNAL_MEM_BASE_ADDRESS )
#define cOCT6100_POUCH_BASE						( 0x002E0000 + cOCT6100_EXTERNAL_MEM_BASE_ADDRESS )
#define cOCT6100_IMAGE_FILE_BASE				( 0x00300000 + cOCT6100_EXTERNAL_MEM_BASE_ADDRESS )

#define cOCT6100_CHANNEL_ROOT_SIZE				4096
#define cOCT6100_CHANNEL_ROOT_TOTAL_SIZE		( 672 * cOCT6100_CHANNEL_ROOT_SIZE )
#define cOCT6100_PGSP_EVENT_OUT_SIZE			131072
#define cOCT6100_PGSP_TONE_EVENT_SIZE			0x40
#define cOCT6100_IMAGE_FILE_SIZE				0x100000

#define cOCT6100_MATRIX_TIMESTAMP_DWORD_ADD		cOCT6100_POUCH_BASE + 0x8
#define cOCT6100_MATRIX_CHAN_SELECT_DWORD_ADD	cOCT6100_POUCH_BASE + 0x14
#define cOCT6100_MATRIX_WRITE_PTR_DWORD_ADD		cOCT6100_POUCH_BASE + 0x4
#define cOCT6100_MATRIX_PLL_JITTER_COUNT_ADD	cOCT6100_POUCH_BASE + 0x1C
#define cOCT6100_MATRIX_DWORD_BASE				cOCT6100_POUCH_BASE + 0xE0000

#define cOCT6100_CHANNEL_ROOT_GLOBAL_CONF_OFFSET	0x0000

#define cOCT6100_NUM_WORDS_PER_TONE_EVENT			32
#define cOCT6100_NUM_PGSP_EVENT_OUT					2048
#define cOCT6100_VALID_TONE_EVENT					0x8000
#define cOCT6100_LOCAL_TIMESTAMP_INCREMENT			32	/* 4 ms increment. */
#define cOCT6100_ABSOLUTE_MAX_NUM_PGSP_EVENT_OUT	65535
#define cOCT6100_MIN_TIMESLOT_FOR_TIMESTAMP			5


/*=======================================================================*/
#define cOCT6100_GSC_PGSP_CONTEXT_BASE_ADD_OFFSET			0x0C
#define cOCT6100_GSC_PGSP_INIT_CONTEXT_BASE_ADD_OFFSET		0x10
#define cOCT6100_GSC_RIN_CIRC_BUFFER_BASE_ADD_OFFSET		0x14
#define cOCT6100_GSC_SIN_CIRC_BUFFER_BASE_ADD_OFFSET		0x18
#define cOCT6100_GSC_SOUT_CIRC_BUFFER_BASE_ADD_OFFSET		0x1C

#define cOCT6100_GSC_BUFFER_LAW_OFFSET						27

/*=======================================================================*/
#define cOCT6100_CH_MAIN_PGSP_CONTEXT_OFFSET			0x00000
#define cOCT6100_CH_MAIN_TONE_EVENT_OFFSET				0x00488

/*=======================================================================*/
#define cOCT6100_PLAYOUT_EVENT_REPEAT_OFFSET			31
#define cOCT6100_PLAYOUT_EVENT_LAW_OFFSET				30
#define cOCT6100_PLAYOUT_EVENT_MIX_OFFSET				28
#define cOCT6100_PLAYOUT_EVENT_LOOP_TIMES_OFFSET		27
#define cOCT6100_PLAYOUT_EVENT_GAIN_OFFSET				24

#define cOCT6100_PLAYOUT_EVENT_MEM_SIZE					16

/* Image related defines.*/
#define cOCT6100_MIN_IMAGE_SIZE					0x001000
#define cOCT6100_MAX_IMAGE_SIZE					0x100000
#define cOCT6100_MAX_IMAGE_REGION				60
#define cOCT6100_IMAGE_AF_CST_OFFSET			0x1000;

/* Max defines.*/
#define cOCT6100_MAX_ECHO_CHANNELS				672
#define cOCT6100_MAX_TSI_CNCTS					1530
#define cOCT6100_MAX_CALLER_ID_PLAYOUT_BUFFERS	( 3328 + 6 )
#define cOCT6100_MAX_PLAYOUT_BUFFERS			( 1344 + cOCT6100_MAX_CALLER_ID_PLAYOUT_BUFFERS )
#define cOCT6100_MAX_CONF_BRIDGE				672
#define cOCT6100_MAX_FLEX_CONF_PARTICIPANTS		cOCT6100_MAX_ECHO_CHANNELS
#define cOCT6100_MAX_PHASING_TSST				16
#define cOCT6100_MAX_ADPCM_CHANNELS				672

#define cOCT6100_NUM_TSI_B4_PHASING				1344
#define cOCT6100_TOTAL_TSI_CONTROL_MEM_ENTRY	1534
#define cOCT6100_MAX_TSI_CONTROL_MEM_ENTRY		1344
#define cOCT6100_MAX_ECHO_CONTROL_MEM_ENTRY		672
#define cOCT6100_MAX_TSI_B4_TIMESTAMP			172
#define cOCT6100_TSI_MEM_FOR_TIMESTAMP			4
#define cOCT6100_API_EXT_TONE_EXTRA_TSI			1533

/* Echo channel ports */
#define cOCT6100_CHANNEL_PORT_RIN				0
#define cOCT6100_CHANNEL_PORT_ROUT				1
#define cOCT6100_CHANNEL_PORT_SIN				2
#define cOCT6100_CHANNEL_PORT_SOUT				3
#define cOCT6100_CHANNEL_PORT_ROUT_SOUT			4

#define cOCT6100_NO_ENCODING					10
#define cOCT6100_NO_DECODING					11

/* Buffer playout defines */
#define cOCT6100_NO_SKIP							0
#define cOCT6100_BUFFER_PLAYOUT_MIN_SIZE			1024
#define cOCT6100_DEFAULT_TIMESTAMP					0
#define cOCT6100_MIXING_0_DB						0
#define cOCT6100_MIXING_MINUS_6_DB					1
#define cOCT6100_MIXING_MINUS_12_DB					2
#define cOCT6100_MIXING_MUTE						3
#define cOCT6100_PLAYOUT_GAIN						0x41000000
#define cOCT6100_PLAYOUT_EVENT						1
#define cOCT6100_MINIMUM_BUFFER_SIZE				64
#define cOCT6100_BUFFER_SIZE_GRANULARITY			16
#define cOCT6100_REPEAT_INFINITELY					cOCT6100_INVALID_VALUE
#define cOCT6100_REPEAT_MAX							32767
#define cOCT6100_SAMPLES_PER_MS						8

/* For the playout events. */
#define cOCT6100_MAX_BUFFER_PLAYOUT_EVENT_PER_CALL	32
#define cOCT6100_MIN_BUFFER_PLAYOUT_EVENT			128
#define cOCT6100_MAX_BUFFER_PLAYOUT_EVENT			65535
/* Event types */
#define  cOCT6100_BUFFER_PLAYOUT_EVENT_INVALID				cOCT6100_INVALID_VALUE
#define  cOCT6100_BUFFER_PLAYOUT_EVENT_STOP					1


/* Phasing defines.*/
#define cOCT6100_SINGLE_PHASING					0
#define cOCT6100_DUAL_PHASING					1
#define cOCT6100_NO_PHASING						2

/* Echo canceller mode.*/
#define cOCT6100_ELECTRIC_EC					0
#define cOCT6100_ELECTRIC_EC_DISPLACEMENT		1
#define cOCT6100_ACCOUSTIC_ES					2

/* Echo control modes.*/
#define cOCT6100_ECHO_OP_MODE_NORMAL				0
#define cOCT6100_ECHO_OP_MODE_HT_FREEZE				1
#define cOCT6100_ECHO_OP_MODE_HT_RESET				2
#define cOCT6100_ECHO_OP_MODE_POWER_DOWN			3
#define cOCT6100_ECHO_OP_MODE_EXTERNAL				4
#define cOCT6100_ECHO_OP_MODE_NO_ECHO				5
#define cOCT6100_ECHO_OP_MODE_SPEECH_RECOGNITION	6
#define cOCT6100_ECHO_OP_MODE_G169_ALC				cOCT6100_ECHO_OP_MODE_NO_ECHO

/* 2100 Hz disabling configuration. */
#define cOCT6100_NEVER_DISABLED					0
#define cOCT6100_G164_2100_HZ					1
#define cOCT6100_G165_2100_HZ_WITH_PHASE_REV	2

/* TSST defines.*/
#define cOCT6100_UNASSIGNED						cOCT6100_FFFD

#define cOCT6100_MAX_TSSTS						4096
#define cOCT6100_TWO_TSSTS_INDEX_MASK			0x8000
#define cOCT6100_TSST_INDEX_MASK				0x7FFF
#define cOCT6100_INPUT_TSST						0
#define cOCT6100_OUTPUT_TSST					1

/* Conference bridges defines.*/
#define cOCT6100_MAX_MIXER_EVENTS						1344
#define cOCT6100_MAX_FLEX_CONF_PARTICIPANTS_PER_BRIDGE	32
#define cOCT6100_CONF_DOMINANT_SPEAKER_UNASSIGNED		672
#define cOCT6100_CONF_NO_DOMINANT_SPEAKER_HNDL			cOCT6100_FFFFFFFE

/* Conversion memory defines.*/
#define cOCT6100_MAX_CONVERSION_MEMORY_BLOCKS	1344

/* Tone detection defines.*/
#define cOCT6100_MAX_TONE_NUMBER				55

/* Register definition and address. */
#define cOCT6100_TONE_EVENT_WRITE_PTR_REG		0x722
#define cOCT6100_TONE_EVENT_READ_PTR_REG		0x720

/* Special Signaling tone IDs. */
#define cOCT6100_TONE_SIN_SYSTEM7_2000				0x20000023
#define cOCT6100_TONE_SIN_SYSTEM7_1780				0x20000024
#define	cOCT6100_TONE_ROUT_G168_2100GB_ON			0x10000000
#define cOCT6100_TONE_ROUT_G168_2100GB_WSPR			0x10000002
#define cOCT6100_TONE_ROUT_G168_1100GB_ON			0x10000004
#define cOCT6100_TONE_ROUT_G168_2100GB_ON_WIDE_A	0x10000005
#define cOCT6100_TONE_ROUT_G168_2100GB_ON_WIDE_B	0x10000006
#define cOCT6100_TONE_ROUT_G168_2100GB_WSPR_WIDE	0x10000008
#define cOCT6100_TONE_SOUT_G168_2100GB_ON			0x40000000
#define cOCT6100_TONE_SOUT_G168_2100GB_WSPR			0x40000002
#define cOCT6100_TONE_SOUT_G168_1100GB_ON			0x40000004
#define cOCT6100_TONE_SOUT_G168_2100GB_ON_WIDE_A	0x40000005
#define cOCT6100_TONE_SOUT_G168_2100GB_ON_WIDE_B	0x40000006
#define cOCT6100_TONE_SOUT_G168_2100GB_WSPR_WIDE	0x40000008
#define cOCT6100_TONE_SIN_SYSTEM5_2400				0x20000020
#define cOCT6100_TONE_SIN_SYSTEM5_2600				0x20000021
#define cOCT6100_TONE_SIN_SYSTEM5_2400_2600			0x20000022

#define cOCT6100_CHIP_ID_REVISION_REG			0x17E

/* BOOT type. */
#define cOCT6100_AF_BOOT_TYPE					0x5
#define cOCT6100_PRODUCTION_BOOT_TYPE			0x7
#define cOCT6100_PRODUCTION_SHORT_BOOT_TYPE		0x8

/*Production Bist Modes*/
#define cOCT6100_PRODUCTION_BIST_STANDARD		0x0
#define cOCT6100_PRODUCTION_BIST_SHORT			0x1

/* Interrupt register masks.*/
#define cOCT6100_INTRPT_MASK_REG_102H			0x0001
#define cOCT6100_INTRPT_MASK_REG_202H			0x1C01
#define cOCT6100_INTRPT_MASK_REG_302H			0xF100
#define cOCT6100_INTRPT_MASK_REG_502H			0x0002
#define cOCT6100_INTRPT_MASK_REG_702H			0x0002

#define cOCT6100_DECODER_MEMORY_OFFSET			672

/* Debug defines.*/
#define cOCT6100_DEBUG_MAX_READ_LENGTH				10240
#define cOCT6100_DEBUG_SOUT_MAX_READ_LENGTH			2560
#define cOCT6100_DEBUG_CHAN_RECORD_INDEX			64
#define cOCT6100_DEBUG_RECORD_BUFFER_BYTE_SIZE		0x20000
#define cOCT6100_DEBUG_RECORD_MATRIX_SIZE			0x8000
#define cOCT6100_DEBUG_RECORD_READ_DATA_BYTE_SIZE	1024
#define cOCT6100_DEBUG_RECORD_BLOCK_BYTE_SIZE		0x1000

/* Tone event defines.*/
#define cOCT6100_MAX_TONE_EVENT					56
#define cOCT6100_TONE_PRESENT					0
#define cOCT6100_TONE_STOP						1
#define cOCT6100_TONE_REFRESH					2

/* TLV defines.*/
#define cOCT6100_TLV_MAX_ADDRESS						0x10000000
#define cOCT6100_TLV_MAX_TONE_NAME_SIZE					64

#define cOCT6100_VERSION_NUMBER_MAX_SIZE				1016

/* Echo Tail defines.*/
#define cOCT6100_TAIL_LENGTH_32MS				32
#define cOCT6100_TAIL_LENGTH_64MS				64
#define cOCT6100_TAIL_LENGTH_128MS				128
#define cOCT6100_MAX_ECHO_TAIL_DISPLACEMENT		5600	/* In milliseconds */





/* Generic loop counter.*/
#define cOCT6100_MAX_LOOP						0x2000
/* CPU boot timeout counter. */
#define cOCT6100_MAX_LOOP_CPU_TIMEOUT			0x20000

/* Automatic level control */
#define cOCT6100_PASS_THROUGH_LEVEL_CONTROL		0x90

/* Channel stats debug info */
#define cOCT6100_DEBUG_CHAN_STATS_EVENT_BYTE_SIZE		1024
#define cOCT6100_DEBUG_CHAN_STATS_LITE_EVENT_BYTE_SIZE	720

/* Image start string define */
#define cOCT6100_IMAGE_START_STRING				"EDS3_IMAGE_NAME"
 
/* Tone image info defines.*/
#define cOCT6100_TONE_INFO_START_STRING			"[ToneDetectorInfo]"
#define cOCT6100_TONE_INFO_STOP_STRING			"[~ToneDetectorInfo]"
#define cOCT6100_TONE_INFO_EVENT_STRING			"TONEEVENT=0x"

#define cOCT6100_MAX_NLP_CONF_DWORD				20

/* Tail displacement info.*/
#define cOCT6100_MAX_TAIL_DISPLACEMENT			896

/* Comfort noise define */
#define cOCT6100_COMFORT_NOISE_NORMAL			0x0
#define cOCT6100_COMFORT_NOISE_EXTENDED			0x3
#define cOCT6100_COMFORT_NOISE_OFF				0x2
#define cOCT6100_COMFORT_NOISE_FAST_LATCH		0x1

/* Mixer event type.*/
#define cOCT6100_EVENT_TYPE_SOUT_COPY			0x0
#define cOCT6100_EVENT_TYPE_SIN_COPY			0x1

/* Tone disabler status.*/
#define cOCT6100_TONE_DISABLER_EC_ENABLED		0
#define cOCT6100_TONE_DISABLER_EC_DISABLED		1

/* ADPCM Channel defines */
#define cOCT6100_ADPCM_ENCODING					0
#define cOCT6100_ADPCM_DECODING					1

/* Double talk behavior modes. */
#define cOCT6100_DOUBLE_TALK_BEH_NORMAL				0x0
#define cOCT6100_DOUBLE_TALK_BEH_LESS_AGGRESSIVE	0x1

/* Api Version string length.*/
#define cOCT6100_API_VERSION_STRING_LENGTH		32

/* Extended tone detection information. */
#define cOCT6100_API_EXT_TONE_DISABLED			0
#define cOCT6100_API_EXT_TONE_SIN_PORT_MODE		1
#define cOCT6100_API_EXT_TONE_RIN_PORT_MODE		2



/* Mute/UnMute defines. */
#define cOCT6100_CHANNEL_MUTE_PORT_NONE					0x00
#define cOCT6100_CHANNEL_MUTE_PORT_RIN					0x01
#define cOCT6100_CHANNEL_MUTE_PORT_ROUT					0x02
#define cOCT6100_CHANNEL_MUTE_PORT_SIN					0x04
#define cOCT6100_CHANNEL_MUTE_PORT_SOUT					0x08
#define cOCT6100_CHANNEL_MUTE_PORT_SIN_WITH_FEATURES	0x10

/* Debug get data dump modes. */
#define cOCT6100_DEBUG_GET_DATA_MODE_16S_LITE			0x0
#define cOCT6100_DEBUG_GET_DATA_MODE_120S_LITE			0x1
#define cOCT6100_DEBUG_GET_DATA_MODE_16S				0x2
#define cOCT6100_DEBUG_GET_DATA_MODE_120S				0x3

/* Debug get data dump content. */
#define cOCT6100_DEBUG_GET_DATA_CONTENT_COMPLETE		0x0		/* Full binary dump to be sent for support. */
#define cOCT6100_DEBUG_GET_DATA_CONTENT_RIN_PCM			0x1		/* Only Rin PCM stream data. */
#define cOCT6100_DEBUG_GET_DATA_CONTENT_SIN_PCM			0x2		/* Only Sin PCM stream data. */
#define cOCT6100_DEBUG_GET_DATA_CONTENT_SOUT_PCM		0x3		/* Only Sout PCM stream data. */



#define cOCT6100_BIST_IN_PROGRESS				0x0
#define cOCT6100_BIST_CONFIGURATION_FAILED		0x1
#define cOCT6100_BIST_STATUS_CRC_FAILED			0x2
#define cOCT6100_BIST_MEMORY_FAILED				0x3
#define cOCT6100_BIST_SUCCESS					0x4

/* Image types. */
#define cOCT6100_IMAGE_TYPE_WIRELINE		0x0
#define cOCT6100_IMAGE_TYPE_COMBINED		0x1

/* Fatal general error types. */
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_1		0x0001
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_2		0x0002
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_3		0x0004
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_4		0x0008
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_5		0x0010
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_6		0x0020
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_7		0x0040
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_8		0x0080
#define cOCT6100_FATAL_GENERAL_ERROR_TYPE_9		0x0100

#endif /* __OCT6100_DEFINES_H__ */

