/* dconf-update.c generated by valac 0.12.0, the Vala compiler
 * generated from dconf-update.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <gvdb-builder.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GvdbItem* get_parent (GHashTable* table, const gchar* name);
GHashTable* read_locks_directory (const gchar* dirname, GError** error);
GHashTable* read_directory (const gchar* dirname, GError** error);
void maybe_update_from_directory (const gchar* dirname, GError** error);
void update_all (const gchar* dirname, GError** error);
void dconf_update (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


GvdbItem* get_parent (GHashTable* table, const gchar* name) {
	GvdbItem* result = NULL;
	GvdbItem* parent = NULL;
	gint end;
	gchar* _tmp3_ = NULL;
	gchar* parent_name;
	gconstpointer _tmp4_ = NULL;
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	end = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar _tmp1_;
				gchar _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = string_get (name, (glong) i);
				if (!(_tmp1_ != '\0')) {
					break;
				}
				_tmp2_ = string_get (name, (glong) (i - 1));
				if (_tmp2_ == '/') {
					end = i;
				}
			}
		}
	}
	_tmp3_ = string_substring (name, (glong) 0, (glong) end);
	parent_name = _tmp3_;
	_tmp4_ = g_hash_table_lookup (table, parent_name);
	parent = (GvdbItem*) _tmp4_;
	if (parent == NULL) {
		GvdbItem* _tmp5_ = NULL;
		GvdbItem* _tmp6_ = NULL;
		_tmp5_ = gvdb_hash_table_insert (table, parent_name);
		parent = _tmp5_;
		_tmp6_ = get_parent (table, parent_name);
		gvdb_item_set_parent (parent, _tmp6_);
	}
	result = parent;
	_g_free0 (parent_name);
	return result;
}


GHashTable* read_locks_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GDir* _tmp0_ = NULL;
	GDir* dir;
	GHashTable* _tmp1_ = NULL;
	GHashTable* table;
	const gchar* name = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = g_dir_open (dirname, (guint) 0, &_inner_error_);
	dir = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (dir == NULL) {
		result = NULL;
		_g_dir_close0 (dir);
		return result;
	}
	_tmp1_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp1_;
	while (TRUE) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* filename;
		struct stat buf = {0};
		gboolean _tmp4_ = FALSE;
		struct stat _tmp5_ = {0};
		gint _tmp6_;
		gchar* contents = NULL;
		gchar* _tmp8_ = NULL;
		gchar** _tmp9_;
		gchar** _tmp10_ = NULL;
		_tmp2_ = g_dir_read_name (dir);
		name = _tmp2_;
		if (!(name != NULL)) {
			break;
		}
		_tmp3_ = g_build_filename (dirname, name, NULL);
		filename = _tmp3_;
		_tmp6_ = stat (filename, &_tmp5_);
		buf = _tmp5_;
		if (_tmp6_ < 0) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp7_;
			_tmp7_ = S_ISREG (buf.st_mode);
			_tmp4_ = !_tmp7_;
		}
		if (_tmp4_) {
			_g_free0 (filename);
			continue;
		}
		g_file_get_contents (filename, &_tmp8_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp8_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			_g_free0 (filename);
			_g_hash_table_unref0 (table);
			_g_dir_close0 (dir);
			return NULL;
		}
		_tmp10_ = _tmp9_ = g_strsplit (contents, "\n", 0);
		{
			gchar** line_collection;
			int line_collection_length1;
			int line_it;
			line_collection = _tmp10_;
			line_collection_length1 = _vala_array_length (_tmp9_);
			for (line_it = 0; line_it < _vala_array_length (_tmp9_); line_it = line_it + 1) {
				gchar* _tmp11_;
				gchar* line;
				_tmp11_ = g_strdup (line_collection[line_it]);
				line = _tmp11_;
				{
					gboolean _tmp12_;
					_tmp12_ = g_str_has_prefix (line, "/");
					if (_tmp12_) {
						gvdb_hash_table_insert_string (table, line, "");
					}
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (contents);
		_g_free0 (filename);
	}
	result = table;
	_g_dir_close0 (dir);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


GHashTable* read_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* table;
	const gchar* name = NULL;
	GDir* _tmp1_ = NULL;
	GDir* dir;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GHashTable* _tmp35_ = NULL;
	GHashTable* _tmp36_;
	GHashTable* locks;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp0_;
	gvdb_hash_table_insert (table, "/");
	_tmp1_ = g_dir_open (dirname, (guint) 0, &_inner_error_);
	dir = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	while (TRUE) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* filename;
		struct stat buf = {0};
		gboolean _tmp4_ = FALSE;
		struct stat _tmp5_ = {0};
		gint _tmp6_;
		GKeyFile* _tmp8_ = NULL;
		GKeyFile* kf;
		gsize _tmp9_;
		gchar** _tmp10_ = NULL;
		_tmp2_ = g_dir_read_name (dir);
		name = _tmp2_;
		if (!(name != NULL)) {
			break;
		}
		_tmp3_ = g_build_filename (dirname, name, NULL);
		filename = _tmp3_;
		_tmp6_ = stat (filename, &_tmp5_);
		buf = _tmp5_;
		if (_tmp6_ < 0) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp7_;
			_tmp7_ = S_ISREG (buf.st_mode);
			_tmp4_ = !_tmp7_;
		}
		if (_tmp4_) {
			_g_free0 (filename);
			continue;
		}
		_tmp8_ = g_key_file_new ();
		kf = _tmp8_;
		g_key_file_load_from_file (kf, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "%s: %s\n", filename, e->message);
			_g_error_free0 (e);
			_g_key_file_free0 (kf);
			_g_free0 (filename);
			continue;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_key_file_free0 (kf);
			_g_free0 (filename);
			_g_dir_close0 (dir);
			_g_hash_table_unref0 (table);
			return NULL;
		}
		_tmp10_ = g_key_file_get_groups (kf, &_tmp9_);
		{
			gchar** group_collection;
			int group_collection_length1;
			int group_it;
			group_collection = _tmp10_;
			group_collection_length1 = _tmp9_;
			for (group_it = 0; group_it < _tmp9_; group_it = group_it + 1) {
				gchar* _tmp11_;
				gchar* group;
				_tmp11_ = g_strdup (group_collection[group_it]);
				group = _tmp11_;
				{
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_;
					gsize _tmp17_;
					gchar** _tmp18_ = NULL;
					gchar** _tmp19_;
					gint _tmp19__length1;
					gint __tmp19__size_;
					_tmp14_ = g_str_has_prefix (group, "/");
					if (_tmp14_) {
						_tmp13_ = TRUE;
					} else {
						gboolean _tmp15_;
						_tmp15_ = g_str_has_suffix (group, "/");
						_tmp13_ = _tmp15_;
					}
					if (_tmp13_) {
						_tmp12_ = TRUE;
					} else {
						gboolean _tmp16_;
						_tmp16_ = string_contains (group, "//");
						_tmp12_ = _tmp16_;
					}
					if (_tmp12_) {
						fprintf (stderr, "%s: ignoring invalid group name: %s\n", filename, group);
						_g_free0 (group);
						continue;
					}
					_tmp18_ = g_key_file_get_keys (kf, group, &_tmp17_, &_inner_error_);
					_tmp19_ = _tmp18_;
					_tmp19__length1 = _tmp17_;
					__tmp19__size_ = _tmp17_;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_key_file_free0 (kf);
						_g_free0 (filename);
						_g_dir_close0 (dir);
						_g_hash_table_unref0 (table);
						return NULL;
					}
					{
						gchar** key_collection;
						int key_collection_length1;
						int key_it;
						key_collection = _tmp19_;
						key_collection_length1 = _tmp19__length1;
						for (key_it = 0; key_it < _tmp19__length1; key_it = key_it + 1) {
							gchar* _tmp20_;
							gchar* key;
							_tmp20_ = g_strdup (key_collection[key_it]);
							key = _tmp20_;
							{
								gboolean _tmp21_;
								gchar* _tmp22_;
								gchar* _tmp23_;
								gchar* _tmp24_;
								gchar* _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* path;
								gconstpointer _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								gchar* text;
								GVariant* _tmp30_ = NULL;
								GVariant* value;
								GvdbItem* _tmp31_ = NULL;
								GvdbItem* item;
								GvdbItem* _tmp32_ = NULL;
								_tmp21_ = string_contains (key, "/");
								if (_tmp21_) {
									fprintf (stderr, "%s: [%s]: ignoring invalid key name: %s\n", filename, group, key);
									_g_free0 (key);
									continue;
								}
								_tmp22_ = g_strconcat ("/", group, NULL);
								_tmp23_ = _tmp22_;
								_tmp24_ = g_strconcat (_tmp23_, "/", NULL);
								_tmp25_ = _tmp24_;
								_tmp26_ = g_strconcat (_tmp25_, key, NULL);
								_tmp27_ = _tmp26_;
								_g_free0 (_tmp25_);
								_g_free0 (_tmp23_);
								path = _tmp27_;
								_tmp28_ = g_hash_table_lookup (table, path);
								if (((GvdbItem*) _tmp28_) != NULL) {
									fprintf (stderr, "%s: [%s]: %s: ignoring duplicate definition of key %s\n", filename, group, key, path);
									_g_free0 (path);
									_g_free0 (key);
									continue;
								}
								_tmp29_ = g_key_file_get_value (kf, group, key, &_inner_error_);
								text = _tmp29_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								_tmp30_ = g_variant_parse (NULL, text, NULL, NULL, &_inner_error_);
								value = _tmp30_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
										goto __catch2_g_variant_parse_error;
									}
									_g_free0 (text);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp31_ = gvdb_hash_table_insert (table, path);
								item = _tmp31_;
								_tmp32_ = get_parent (table, path);
								gvdb_item_set_parent (item, _tmp32_);
								gvdb_item_set_value (item, value);
								_g_variant_unref0 (value);
								goto __finally2;
								__catch2_g_variant_parse_error:
								{
									GError * e;
									e = _inner_error_;
									_inner_error_ = NULL;
									fprintf (stderr, "%s: [%s]: %s: skipping invalid value: %s (%s)\n", filename, group, key, text, e->message);
									_g_error_free0 (e);
								}
								__finally2:
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (text);
									_g_free0 (path);
									_g_free0 (key);
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									_g_dir_close0 (dir);
									_g_hash_table_unref0 (table);
									return NULL;
								}
								_g_free0 (text);
								_g_free0 (path);
								_g_free0 (key);
							}
						}
						key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (group);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_key_file_free0 (kf);
		_g_free0 (filename);
	}
	_tmp33_ = g_strconcat (dirname, "/locks", NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = read_locks_directory (_tmp34_, &_inner_error_);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	locks = _tmp36_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (dir);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	if (locks != NULL) {
		GvdbItem* _tmp37_ = NULL;
		GvdbItem* item;
		_tmp37_ = gvdb_hash_table_insert (table, ".locks");
		item = _tmp37_;
		gvdb_item_set_hash_table (item, locks);
	}
	result = table;
	_g_hash_table_unref0 (locks);
	_g_dir_close0 (dir);
	return result;
}


void maybe_update_from_directory (const gchar* dirname, GError** error) {
	struct stat dir_buf = {0};
	gboolean _tmp0_ = FALSE;
	struct stat _tmp1_ = {0};
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp2_ = stat (dirname, &_tmp1_);
	dir_buf = _tmp1_;
	if (_tmp2_ == 0) {
		gboolean _tmp3_;
		_tmp3_ = S_ISDIR (dir_buf.st_mode);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		struct stat lockdir_buf = {0};
		struct stat file_buf = {0};
		gint _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* filename;
		gboolean _tmp6_ = FALSE;
		gchar* _tmp7_;
		gchar* _tmp8_;
		struct stat _tmp9_ = {0};
		gint _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_ = FALSE;
		struct stat _tmp13_ = {0};
		gint _tmp14_;
		GHashTable* _tmp15_ = NULL;
		GHashTable* table;
		gint _tmp16_;
		gint fd;
		gboolean _tmp17_ = FALSE;
		GDBusConnection* _tmp20_ = NULL;
		GDBusConnection* system_bus;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GVariant* _tmp25_ = NULL;
		GVariant* _tmp26_;
		_tmp4_ = strlen (dirname);
		_tmp5_ = string_substring (dirname, (glong) 0, (glong) (_tmp4_ - 2));
		filename = _tmp5_;
		_tmp7_ = g_strconcat (dirname, "/locks", NULL);
		_tmp8_ = _tmp7_;
		_tmp10_ = stat (_tmp8_, &_tmp9_);
		lockdir_buf = _tmp9_;
		_tmp11_ = _tmp10_ == 0;
		_g_free0 (_tmp8_);
		if (_tmp11_) {
			_tmp6_ = lockdir_buf.st_mtime > dir_buf.st_mtime;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			dir_buf.st_mtime = lockdir_buf.st_mtime;
		}
		_tmp14_ = stat (filename, &_tmp13_);
		file_buf = _tmp13_;
		if (_tmp14_ == 0) {
			_tmp12_ = file_buf.st_mtime > dir_buf.st_mtime;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_g_free0 (filename);
			return;
		}
		_tmp15_ = read_directory (dirname, &_inner_error_);
		table = _tmp15_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		}
		_tmp16_ = open (filename, O_WRONLY, (mode_t) 0);
		fd = _tmp16_;
		if (fd < 0) {
			_tmp17_ = errno != ENOENT;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gint saved_error;
			const gchar* _tmp18_ = NULL;
			GError* _tmp19_ = NULL;
			saved_error = errno;
			_tmp18_ = g_strerror (saved_error);
			_tmp19_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Can not open '%s' for replacement: %s", filename, _tmp18_);
			_inner_error_ = _tmp19_;
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		gvdb_table_write_contents (table, filename, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __finally3;
		}
		if (fd >= 0) {
			write (fd, "\0\0\0\0\0\0\0\0", (gsize) 8);
		}
		__finally3:
		if (fd >= 0) {
			close (fd);
		}
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_tmp20_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error_);
		system_bus = _tmp20_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp21_ = g_path_get_basename (filename);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("/ca/desrt/dconf/Writer/", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_variant_new ("(s)", "/", NULL);
		_tmp26_ = g_variant_ref_sink (_tmp25_);
		g_dbus_connection_emit_signal (system_bus, NULL, _tmp24_, "ca.desrt.dconf.Writer", "WritabilityNotify", _tmp26_, &_inner_error_);
		_g_variant_unref0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (system_bus);
			goto __catch4_g_error;
		}
		g_dbus_connection_flush_sync (system_bus, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (system_bus);
			goto __catch4_g_error;
		}
		_g_object_unref0 (system_bus);
		goto __finally4;
		__catch4_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_g_hash_table_unref0 (table);
		_g_free0 (filename);
	}
}


void update_all (const gchar* dirname, GError** error) {
	const gchar* name = NULL;
	GDir* _tmp0_ = NULL;
	GDir* dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp0_ = g_dir_open (dirname, (guint) 0, &_inner_error_);
	dir = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp1_ = g_dir_read_name (dir);
		name = _tmp1_;
		if (!(name != NULL)) {
			break;
		}
		_tmp2_ = g_str_has_suffix (name, ".d");
		if (_tmp2_) {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = g_build_filename (dirname, name, NULL);
			_tmp4_ = _tmp3_;
			maybe_update_from_directory (_tmp4_, &_inner_error_);
			_g_free0 (_tmp4_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				fprintf (stderr, "%s\n", e->message);
				_g_error_free0 (e);
			}
			__finally5:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_dir_close0 (dir);
				return;
			}
		}
	}
	_g_dir_close0 (dir);
}


void dconf_update (gchar** args, int args_length1) {
	GError * _inner_error_ = NULL;
	update_all ("/etc/dconf/db", &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "fatal: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



