/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _CONTACT_DLG_HH_
#define _CONTACT_DLG_HH_

#include "CryptonitDlg.hh"
//#include <wx/wx.h>
#include <wx/notebook.h>

#include "../Entry.hh"
#include "../User.hh"
#include "../Certificate.hh"

#define INFOS_COUNT 17

class ContactDlg : public CryptonitDlg{

public:  
  
    ContactDlg(wxWindow *parent, wxWindowID id,
	       const wxString &title=_T(""));
  

    ContactDlg(wxWindow *parent, wxWindowID id,
	       Cryptonit::Entry* contact,
	       Cryptonit::User *u,
	       bool readonly,
	       const wxString &title=_T(""));

    ContactDlg(wxWindow *parent, wxWindowID id,
	       const wxString &filename,
	       Cryptonit::User *u,
	       const wxString &title);
    
    wxPanel* createContactTab(bool readonly=false);
    wxPanel* createAddressTab(bool readonly=false);
    wxPanel* createCertifTab();

    /** add a contact to the user's addressbook
     * @param u : a User
     * @param filename : the contact's certificate filename.
     */
    int addContact(Cryptonit::User *u, const wxString filename);
    
    /** save a modified Contact
     * @param c : the contact to save.
     */
    int saveContact(Cryptonit::Entry* entry);


    void viewCertificate(wxCommandEvent &WXUNUSED(event));
    

private : 
    void createFieldTab();
   
  
    wxNotebook *tab;
  
    wxTextCtrl *ctrlTab[INFOS_COUNT];
    wxString   fieldsTab[INFOS_COUNT];
    
    /** First tab **/
    wxTextCtrl *firstName;
    wxTextCtrl *lastName;
    wxTextCtrl *displayName;
    wxTextCtrl *nickname;

    wxTextCtrl *email;
    wxTextCtrl *email2;
    wxTextCtrl *screenName;
  
    wxTextCtrl *workPhone;
    wxTextCtrl *homePhone;
    wxTextCtrl *fax;
    wxTextCtrl *pager;
    wxTextCtrl *mobile;
  
    /** Second tab **/
    wxTextCtrl *address;
    wxTextCtrl *address2;
    wxTextCtrl *city;
    wxTextCtrl *stateName;
    wxTextCtrl *zipCode;
    wxTextCtrl *countryName;
    wxTextCtrl *www;

    wxTextCtrl *title;
    wxTextCtrl *department;
    wxTextCtrl *organization;
    wxTextCtrl *workAddress;
    wxTextCtrl *workAddress2;
    wxTextCtrl *workCity;
    wxTextCtrl *workState;
    wxTextCtrl *workZip;
    wxTextCtrl *workCountry;
    wxTextCtrl *workwww;
  


    /** Values **/
    /** First tab **/
    wxString firstNameText;
    wxString lastNameText;
    wxString displayNameText;
    wxString nicknameText;

    wxString emailText;
    wxString email2Text;
    wxString screenNameText;
  
    wxString workPhoneText;
    wxString homePhoneText;
    wxString faxText;
    wxString pagerText;
    wxString mobileText;
  
    /** Second tab **/
    wxString addressText;
    wxString address2Text;
    wxString cityText;
    wxString stateNameText;
    wxString zipCodeText;
    wxString countryNameText;
    wxString wwwText;

    wxString titleText;
    wxString departmentText;
    wxString organizationText;
    wxString workAddressText;
    wxString workAddress2Text;
    wxString workCityText;
    wxString workStateText;
    wxString workZipText;
    wxString workCountryText;
    wxString workwwwText;

//    wxString contactCertif;
    Cryptonit::Certificate *cert;
    Cryptonit::User *user;
  

  DECLARE_EVENT_TABLE()
  
};


enum {
    CDLG_CERT_BTN_ID = 8000
    
};

#endif
