/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include <wx/filename.h>

#include "ContactDlg.hh"
#include "CertificateViewer.hh"

#include "../Certificate.hh"
#include "../Contact.hh"
#include "Common.hh"



using namespace Cryptonit;

BEGIN_EVENT_TABLE(ContactDlg, CryptonitDlg)
EVT_BUTTON( CDLG_CERT_BTN_ID, ContactDlg::viewCertificate)
END_EVENT_TABLE()

ContactDlg::ContactDlg(wxWindow *parent, wxWindowID id,
		       const wxString &title)
    : CryptonitDlg(parent, id, title)
{
  

    tab = new wxNotebook(this, -1);
  
    wxPanel *contactPanel = (wxPanel *) NULL;
    wxPanel *addressPanel = (wxPanel *) NULL;
 
    contactPanel = createContactTab(false);
    addressPanel = createAddressTab(false);
    tab->AddPage(contactPanel, _("Contact") );
    tab->AddPage(addressPanel, _("Address") );
    mainSizer->Add(tab,1,wxEXPAND | wxCENTER | wxALL, 1);
  
    SetAutoLayout( TRUE );
}




ContactDlg::ContactDlg(wxWindow *parent, wxWindowID id,
		       Cryptonit::Entry* contact,
		       Cryptonit::User *u,
		       bool readonly,
		       const wxString &title)
    : CryptonitDlg(parent, id, title)
{
  
    user = u;
    
  /* initialize values */
  /** Values **/
  /** First tab **/
   firstNameText = std2wx(contact->getAttributeFirstValue("cn"));
   lastNameText = std2wx(contact->getAttributeFirstValue("sn"));
   displayNameText = std2wx(contact->getAttributeFirstValue("name"));
   nicknameText = std2wx(contact->getAttributeFirstValue("givenName"));

   emailText = std2wx(contact->getAttributeFirstValue("mail"));
   email2Text = std2wx(contact->getAttributeFirstValue(""));
   screenNameText = std2wx(contact->getAttributeFirstValue("displayName"));
  
   workPhoneText = std2wx(contact->getAttributeFirstValue("telephoneNumber"));
   homePhoneText = std2wx(contact->getAttributeFirstValue("homeTelephoneNumber"));
   faxText = std2wx(contact->getAttributeFirstValue("facsimileTelephoneNumber"));
   pagerText = std2wx(contact->getAttributeFirstValue("pager"));
   mobileText = std2wx(contact->getAttributeFirstValue("mobile"));
  
  /** Second tab **/
   addressText = std2wx(contact->getAttributeFirstValue("street"));
   address2Text = std2wx(contact->getAttributeFirstValue(""));
   cityText = std2wx(contact->getAttributeFirstValue("l"));
   stateNameText = std2wx(contact->getAttributeFirstValue("st"));
   zipCodeText = std2wx(contact->getAttributeFirstValue("postalCode"));
   countryNameText = std2wx(contact->getAttributeFirstValue("co"));
   wwwText = std2wx(contact->getAttributeFirstValue(""));

   titleText = std2wx(contact->getAttributeFirstValue("title"));
   departmentText = std2wx(contact->getAttributeFirstValue("ou"));
   organizationText = std2wx(contact->getAttributeFirstValue("o"));
   workAddressText = std2wx(contact->getAttributeFirstValue("street"));
   workAddress2Text = std2wx(contact->getAttributeFirstValue(""));
   workCityText = std2wx(contact->getAttributeFirstValue("l"));
   workStateText = std2wx(contact->getAttributeFirstValue("st"));
   workZipText = std2wx(contact->getAttributeFirstValue("postalCode"));
   workCountryText = std2wx(contact->getAttributeFirstValue("co"));
   workwwwText = std2wx(contact->getAttributeFirstValue(""));

   wxFileName certFile( std2wx(contact->getAttributeFirstValue("userCertificate")));
   certFile=wxMyPrepend(certFile,std2wx(user->getCertificatesDir()));
   
  
   if(contact->getAttributeFirstValue("userCertificate") != ""){
       cert = new Certificate();
       if(cert->load(wx2std(certFile.GetFullPath()).c_str())!=SUCCESS){
					 delete cert;
					 cert = NULL;
       }
   } else {
       cert= new Certificate( );
       if(cert->load((void*)contact->getAttributeFirstValue("userCertificate;binary").c_str(),contact->getAttributeFirstValue("userCertificate;binary").size() ) !=SUCCESS){
	   delete cert;
	   cert = NULL;
       }
       
   }
   
   //contactCertif = certFile.GetFullPath();

   tab = new wxNotebook(this, -1);
  
   wxPanel *contactPanel = (wxPanel *) NULL;
   wxPanel *addressPanel = (wxPanel *) NULL;
   wxPanel *certificatePanel = (wxPanel *) NULL;
   
   contactPanel = createContactTab(readonly);
   addressPanel = createAddressTab(readonly);
   tab->AddPage(contactPanel, _("Contact") );
   tab->AddPage(addressPanel, _("Address") );
   if (cert != NULL) {
               certificatePanel = createCertifTab();
               tab->AddPage(certificatePanel, _("Certificates") );
   }

    mainSizer->Add(tab,1,wxEXPAND | wxCENTER | wxALL, 1);
    SetAutoLayout( TRUE );
}




ContactDlg::ContactDlg(wxWindow *parent, wxWindowID id,
		       const wxString &filename,
		       Cryptonit::User *u,
		       const wxString &title)
    : CryptonitDlg(parent, id, title)
{
    user = u;
    cert = new Certificate ();
    if(cert->load(wx2std(filename).c_str()) != SUCCESS){
	
	delete cert;

    }
    else{

				firstNameText = std2wx(cert->getSubjectName().getValue("CN"));;	
				departmentText = std2wx(cert->getSubjectName().getValue("OU"));
				organizationText = std2wx(cert->getSubjectName().getValue("O"));
				countryNameText = std2wx(cert->getSubjectName().getValue("C"));
				workCountryText = std2wx(cert->getSubjectName().getValue("C"));

				emailText = std2wx(cert->getEmailAddress());
	
	tab = new wxNotebook(this, -1);

	wxPanel *contactPanel = (wxPanel *) NULL;
	wxPanel *addressPanel = (wxPanel *) NULL;
	wxPanel *certificatePanel = (wxPanel *) NULL;
		
	contactPanel = createContactTab();
	addressPanel = createAddressTab();
	certificatePanel = createCertifTab();
	tab->AddPage(contactPanel, _("Contact") );
	tab->AddPage(addressPanel, _("Address") );
	tab->AddPage(certificatePanel, _("Certificates") );
	mainSizer->Add(tab,1,wxEXPAND | wxCENTER | wxALL, 1);	
	//contactCertif = filename;
    }

    //SetSize( GetBestSize() );
    SetAutoLayout( TRUE );	
    


}



void ContactDlg::createFieldTab(){
    int i = 0;
    fieldsTab[i++]= _T("cn");
    fieldsTab[i++]= _T("sn");
    fieldsTab[i++]= _T("name");
    fieldsTab[i++]= _T("givenName");
    fieldsTab[i++]= _T("mail");
    fieldsTab[i++]= _T("mail2");
    fieldsTab[i++]= _T("displayName");
    
    /*    fieldsTab[i++]= _T("telephoneNumber");
	  fieldsTab[i++]= _T("homeTelephoneNumber");
	  fieldsTab[i++]= _T("facsimileTelephoneNumber");
	  fieldsTab[i++]= _T("pager");
	  fieldsTab[i++]= _T("mobile");
	  fieldsTab[i++] = _T("street");
	  fieldsTab[i++] = _T("street2");
	  fieldsTab[i++] = _T("l");
	  fieldsTab[i++] = _T("st");
	  fieldsTab[i++] = _T("postalCode");
	  fieldsTab[i++] = _T("co");
	  fieldsTab[i++] = _T("www");*/
    
    fieldsTab[i++] = _T("title");
    fieldsTab[i++] = _T("ou");
    fieldsTab[i++] = _T("o");
    fieldsTab[i++] = _T("workStreet");
    fieldsTab[i++] = _T("workStreet2");
    fieldsTab[i++] = _T("workLocation");
    fieldsTab[i++] = _T("workState");
    fieldsTab[i++] = _T("workPostalCode");
    fieldsTab[i++] = _T("workCo");
    fieldsTab[i++] = _T("workWww");
	
}




wxPanel* ContactDlg::createContactTab(bool readonly){
    wxPanel *panel = new wxPanel( tab );
  
    wxBoxSizer *mSizer = new wxBoxSizer(wxVERTICAL);
  
    /** NAME **/
    wxStaticBox *nameFrame =  new wxStaticBox(panel,-1,_("Name"));
    wxStaticBoxSizer *nameSizer = new wxStaticBoxSizer(nameFrame,wxVERTICAL);
  
    wxBoxSizer *bs = new wxBoxSizer(wxHORIZONTAL);
  
    bs->Add(new wxStaticText(panel , -1 , _("First")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[0]/*firstName*/ = new wxTextCtrl(panel,-1 , firstNameText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[0] /*firstName*/, 1, wxALIGN_RIGHT | wxALL,2);
    nameSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);

    bs = new wxBoxSizer(wxHORIZONTAL);
    bs->Add(new wxStaticText(panel , -1 , _("Last")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[1] /*lastName*/ = new wxTextCtrl(panel,-1, lastNameText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[1] /*lastName*/, 1, wxALIGN_RIGHT | wxALL,2);
    nameSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);
  
    bs = new wxBoxSizer(wxHORIZONTAL);
    bs->Add(new wxStaticText(panel , -1 , _("Display")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[2] /*displayName*/ = new wxTextCtrl(panel,-1, displayNameText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[2] /*displayName*/, 1, wxALIGN_RIGHT | wxALL,2);
    nameSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);
    
    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Nickname")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[3] /*nickname*/ = new wxTextCtrl(panel,-1, nicknameText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[3] /*nickname*/, 1, wxALIGN_RIGHT | wxALL,2); 
    nameSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);

  
    mSizer->Add(nameSizer,0, wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);
  

  


    /** INTERNET **/
    wxStaticBox *netFrame =  new wxStaticBox(panel,-1,_("Internet"));
    wxStaticBoxSizer *netSizer = new wxStaticBoxSizer(netFrame,wxVERTICAL);


    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Email")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[4] /*email*/ = new wxTextCtrl(panel,-1, emailText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[4] /*email*/, 1, wxALIGN_RIGHT | wxALL,2);
    netSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);  

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Additional Email")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[5] /*email2*/ = new wxTextCtrl(panel,-1, email2Text , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[5] /*email2*/, 1, wxALIGN_RIGHT | wxALL,2);
    netSizer->Add(bs,1,wxALIGN_RIGHT | wxALL,2);

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Screen Name")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[6] /*screenName*/ = new wxTextCtrl(panel,-1, screenNameText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[6] /*screenName*/, 1, wxALIGN_RIGHT | wxALL,2);
    netSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);

    mSizer->Add(netSizer,0, wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);


    

    if(cert != NULL){
	wxButton *certifBtn = new wxButton(panel ,CDLG_CERT_BTN_ID,_("View certifiate")); 
	mSizer->Add(certifBtn, 0 ,  wxALIGN_CENTER_HORIZONTAL  | wxALL , 10);
    }

    

    /** PHONE **/
  
   //  wxStaticBox *phoneFrame =  new wxStaticBox(panel,-1,_("Phone"));
//     wxStaticBoxSizer *phoneSizer = new wxStaticBoxSizer(phoneFrame,wxVERTICAL);


//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("Work")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[7] /*workPhone*/ = new wxTextCtrl(panel,-1, workPhoneText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add(ctrlTab[7], 1, wxALIGN_RIGHT | wxALL,2);
//     phoneSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);  

//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("Home")), 0, wxALIGN_RIGHT |  wxALL, 3 );
//     ctrlTab[8]/*homePhone*/ = new wxTextCtrl(panel,-1, homePhoneText , wxDefaultPosition , wxSize(200,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add(ctrlTab[8]/* homePhone*/, 1, wxALIGN_RIGHT | wxALL,2);
//     phoneSizer->Add(bs,1,wxALIGN_RIGHT | wxALL,2);

//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("Fax")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[9] /*fax*/ = new wxTextCtrl(panel,-1, faxText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add(ctrlTab[9] /*fax*/, 1, wxALIGN_RIGHT | wxALL,2);
//     phoneSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);

//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("Pager")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[10] /*pager*/ = new wxTextCtrl(panel,-1, pagerText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add(ctrlTab[10] /*pager*/, 1, wxALIGN_RIGHT | wxALL,2);
//     phoneSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);

//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("Mobile")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[11] /*mobile*/ = new wxTextCtrl(panel,-1, mobileText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add(ctrlTab[11] /*mobile*/, 1, wxALIGN_RIGHT | wxALL,2);
//     phoneSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);
  

//     mSizer->Add(phoneSizer,0, wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);
  

    panel->SetAutoLayout( TRUE );
    panel->SetSizer(mSizer);
    mSizer->Fit(panel);
    return panel;
  
}
 
wxPanel* ContactDlg::createAddressTab(bool readonly){
    wxPanel *panel = new wxPanel( tab );

  
    wxBoxSizer *mSizer = new wxBoxSizer(wxVERTICAL);
  
     wxBoxSizer *bs = new wxBoxSizer(wxHORIZONTAL);
    /** HOME **/
//     wxStaticBox *homeFrame =  new wxStaticBox(panel,-1,_("Home"));
//     wxStaticBoxSizer *homeSizer = new wxStaticBoxSizer(homeFrame,wxVERTICAL);
  

  
//     bs->Add(new wxStaticText(panel , -1 , _("Address")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[12] /*address*/ = new wxTextCtrl(panel,-1 , addressText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add(ctrlTab[12] /*address*/, 1, wxALIGN_RIGHT | wxALL,2);
//     homeSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);

//     bs = new wxBoxSizer(wxHORIZONTAL);
//     bs->Add(new wxStaticText(panel , -1 , ""), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[13] /*address2*/ = new wxTextCtrl(panel,-1, address2Text , wxDefaultPosition , wxSize(200,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add( ctrlTab[13] /*address2*/, 1, wxALIGN_RIGHT | wxALL,2);
//     homeSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);
  
//     bs = new wxBoxSizer(wxHORIZONTAL);
//     bs->Add(new wxStaticText(panel , -1 , _("City")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[14] /*city*/ = new wxTextCtrl(panel,-1, cityText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add(ctrlTab[14] /*city*/, 1, wxALIGN_RIGHT | wxALL,2);
//     homeSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);
    
//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("State/Province")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    
//     ctrlTab[15] /*stateName*/ = new wxTextCtrl(panel,-1, stateNameText , wxDefaultPosition , wxSize(100,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add( ctrlTab[15]/*stateName*/, 1, wxALIGN_RIGHT | wxALL,0); 
//     bs->Add(new wxStaticText(panel , -1 , _("Zip/Postal Code"), wxDefaultPosition , wxSize(100,30) ), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[16] /*zipCode*/ = new wxTextCtrl(panel,-1, zipCodeText , wxDefaultPosition , wxSize(50,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add( ctrlTab[16]/*zipCode*/, 1, wxALIGN_RIGHT | wxALL,2); 


//     homeSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);



//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("Country")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[17] /*countryName*/ = new wxTextCtrl(panel,-1, countryNameText , wxDefaultPosition , wxSize(200,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add( ctrlTab[17] /*countryName*/, 1, wxALIGN_RIGHT | wxALL,2); 
//     homeSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);

//     bs = new wxBoxSizer(wxHORIZONTAL);  
//     bs->Add(new wxStaticText(panel , -1 , _("Web Page")), 0, wxALIGN_RIGHT |  wxALL, 2 );
//     ctrlTab[18] /*www*/ = new wxTextCtrl(panel,-1, wwwText , wxDefaultPosition , wxSize(200,20), (readonly ? wxTE_READONLY : 0) );
//     bs->Add( ctrlTab[18] /*www*/, 1, wxALIGN_RIGHT | wxALL,2); 
//     homeSizer->Add(bs,1,wxALIGN_RIGHT | wxALL , 2);


  
//     mSizer->Add(homeSizer,0, wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);
  


    /** WORK **/
    wxStaticBox *workFrame =  new wxStaticBox(panel,-1,_("Work"));
    wxStaticBoxSizer *workSizer = new wxStaticBoxSizer(workFrame,wxVERTICAL);


    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Title")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[7] /*title*/ = new wxTextCtrl(panel,-1, titleText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add( ctrlTab[7] /*title*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);  

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Department")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[8] /*department*/ = new wxTextCtrl(panel,-1, departmentText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add( ctrlTab[8] /*department*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1,wxALIGN_RIGHT | wxALL,2);

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Organization")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[9] /*organization*/ = new wxTextCtrl(panel,-1, organizationText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[9] /*organization*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Address")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[10] /*workAddress*/ = new wxTextCtrl(panel,-1, workAddressText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[10] /*workAddress*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);  

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _T("")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[11] /*workAddress2*/ = new wxTextCtrl(panel,-1, workAddress2Text , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[11] /*workAddress2*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1,wxALIGN_RIGHT | wxALL,2);

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("City")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[12]  /*workCity*/ = new wxTextCtrl(panel,-1, workCityText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[12]/*workCity*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("State/Province")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[13] /*workState*/ = new wxTextCtrl(panel,-1, workStateText , wxDefaultPosition , wxSize(100,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[13] /*workState*/, 1, wxALIGN_RIGHT | wxALL,2);
    //  workSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);  

    //bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Zip/Postal Code")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[14] /*workZip*/ = new wxTextCtrl(panel,-1, workZipText , wxDefaultPosition , wxSize(50,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[14] /*workZip*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1,wxALIGN_RIGHT | wxALL,2);

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Country")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[15] /*workCountry*/ = new wxTextCtrl(panel,-1, workCountryText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[15] /*workCountry*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);

    bs = new wxBoxSizer(wxHORIZONTAL);  
    bs->Add(new wxStaticText(panel , -1 , _("Web Page")), 0, wxALIGN_RIGHT |  wxALL, 2 );
    ctrlTab[16] /*workwww*/ = new wxTextCtrl(panel,-1, workwwwText , wxDefaultPosition , wxSize(300,20), (readonly ? wxTE_READONLY : 0) );
    bs->Add(ctrlTab[16] /*workwww*/, 1, wxALIGN_RIGHT | wxALL,2);
    workSizer->Add(bs,1, wxALIGN_RIGHT | wxALL,2);

    mSizer->Add(workSizer,0, wxEXPAND |  wxALIGN_RIGHT | wxALL, 2);

    panel->SetAutoLayout( TRUE );
    panel->SetSizer(mSizer);
    mSizer->Fit(panel);
  
    return panel;
}


wxPanel* ContactDlg::createCertifTab(){
    wxPanel *panel = new wxPanel( tab );
    wxStaticBox *certifFrame =  new wxStaticBox(panel,-1,_("Contact's Certificate"));
    wxStaticBoxSizer *certifSizer = new wxStaticBoxSizer(certifFrame,wxVERTICAL);
    
    wxButton *certifBtn = new wxButton(panel ,CDLG_CERT_BTN_ID,_("View contact's certifiate")); 
    certifSizer->Add(certifBtn, 0 ,  wxALIGN_CENTER | wxALL , 10);

    
 // panel->SetAutoLayout( TRUE );
    panel->SetSizer(certifSizer);
    certifSizer->Fit(panel);

    return panel;
}

int ContactDlg::addContact(Cryptonit::User *u,const wxString filename){
    
    createFieldTab();
	

    /** we save this contact's certificate */
    Certificate *certificate = new Certificate();;
#ifdef DEBUG
    std::cerr << "loading "<< filename << std::endl;
#endif
    
    if( certificate->load(wx2std(filename).c_str())!= SUCCESS){
#ifdef DEBUG
	std::cerr << "error while loading "<< filename << std::endl;
#endif
	return -1;
    }
    
    
    std::string certHash = certificate->getHash();
    wxFileName certFile(std2wx(certHash));
    certFile.SetExt(_T("der"));
    certFile=wxMyPrepend(certFile,std2wx(u->getCertificatesDir()));
    if(certificate->save(wx2std(certFile.GetFullPath()).c_str()) != SUCCESS){
	return -2;
    }
    
    Contact *contact = new Contact(certificate->getSubjectName().getValues(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE, '/'));
    contact->setInfo("userCertificate", wx2std(certFile.GetFullName()));
    delete certificate;    


    
    for(int i=0 ; i < INFOS_COUNT ; i++){
				if(ctrlTab[i]->GetValue() != _T("") && fieldsTab[i] != _T("")) {
#ifdef DEBUG										
						std::cout << fieldsTab[i] << "=" << ctrlTab[i]->GetValue() << std::endl;
#endif
						contact->setInfo(wx2std(fieldsTab[i]), wx2std(ctrlTab[i]->GetValue()));
				}
    }
    
    
    if( ! u->addressBook->addContact( contact ) ) {
	return -3;
    }

	
    return SUCCESS; 
}



int ContactDlg::saveContact(Cryptonit::Entry* entry) {
    createFieldTab();
	
    for(int i=0 ; i < INFOS_COUNT ; i++){
				std::string infoName = wx2std(fieldsTab[i]);
				std::string value = wx2std(ctrlTab[i]->GetValue());
				if(ctrlTab[i]->GetValue() != _T("") && fieldsTab[i] != _T("")) {
						if( entry->getAttributeFirstValue( infoName ) != "" )
								if( entry->erase( infoName ) ) 
										entry->append( infoName, new Attribute(value) );
						entry->append( infoName, new Attribute(value) );
				}
    }
    
    return SUCCESS; 
}


void ContactDlg::viewCertificate(wxCommandEvent &WXUNUSED(event)){
    if(cert) {
				CertificateViewer cv(*cert, user ,this, -1 , _("Certificate properties"));
				cv.showModal(wxSize(435,500) , _("Close"), false); 
    }
}
