/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _Contact_hh_
#define _Contact_hh_


#include <string>

#include "ContactInfo.hh"

namespace Cryptonit 
{
   /** Contain the contacts of a user.
    * 
    */
    class Contact
    {

    private:

	std::string contactName;


	/** Contact representation in form of a Entry.
	 *  For its inclusion in the DirectoryService adrees book.
	 *  All others object property will not be stored in the
	 *  address book, except the contactName.
	 */

	/** Contains the contact informations */
	Entry* contactInfo;

    public:

	/** Constructs an anonymous empty contact.
	 *
	 */
	Contact();

	
	/** Contructs a new empty contact named 'name'.
	 *
	 *  @param name : contact name
	 */
	Contact( const std::string name );


	/** Constructs a contact with his data.
	 * 
	 * @param name : contact name
	 * @param info : the data of the contact.
	 */
	Contact( const std::string name, const Entry& info );
	Contact( const std::string name, Entry* info );
	

	/** Destructs the contact.
	 *  The contact isn't removed from the corresponding 
	 *  address book, if any.
	 */
	~Contact();
	

	/** Retrieves the contact name.
	 *
	 *  @return contact name.
	 */
	std::string getName();


	/** Get the data of the contact.
	 *
	 *  @return all the attributes of the contact
	 */
	Entry* getInfo();
	

	/** Retrieves a particular info.
	 *
	 * @param infoName : information name, eg. "givenName"
	 */
	std::string getInfo( const std::string infoName );


	/** Set the data of the contact.
	 *  @return true if the operation succeed.
	 *  @param info : contact information
	 */
	bool setInfo( const Entry& info );
	bool setInfo( const Entry* info );


	/** Set a particular information to 'value'. If the info
	 *  already exist, it is deleted.
	 *
	 *  @return true if the opration succeed.
	 *  @param infoName : information name, eg. "givenName"
	 *  @param value : inforamtion value.
	 */
	bool setInfo( const std::string infoName, const std::string value );


	/** Remove a particular info.
	 *
	 * @param infoName : information name, eg. "givenName"
	 */
	bool removeInfo( const std::string infoName );
	
    };
}
#endif
