# terminalsize_tests.py - unit tests for terminalsize.py
# Copyright (C) 2008  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os
import unittest

import terminalsize


class GetTerminalSizeTests(unittest.TestCase):

    def testReturnsUnknownWhenQueryingDevNull(self):
        fd = os.open("/dev/null", os.O_RDONLY)
        rows, cols = terminalsize.get_terminal_size(fd)
        os.close(fd)
        self.assertEqual(rows, None)
        self.assertEqual(cols, None)

    def testReturnsTwoIntegersWhenStdoutIsATerminal(self):
        # We only run this check if stdout is a terminal.
        # Unfortunately, there is no sensible way of checking the values.
        # But that's OK, they're lumberjacks.
        if os.isatty(1):
            rows, cols = terminalsize.get_terminal_size(1)
            self.assertEqual(type(rows), int)
            self.assertEqual(type(cols), int)
