use Test::More;

use CipUX::RBAC;
use File::Spec;

if ( not $ENV{TEST_CGI} ) {
    my $msg = 'CGI test.  Set $ENV{TEST_CGI} to a true value to run.';
    plan( skip_all => $msg );
} else {
    plan( tests => 5 );
}

my $rbac_cat_xml = File::Spec->catfile( 't', 'cipux-cat-rbac.xml' );
my $rbac_conf    = File::Spec->catfile( 't', 'cipux-rbac.conf' );

my $rbac = CipUX::RBAC->new( { debug => 0, cfg => $rbac_conf } );
is( ref $rbac, 'CipUX::RBAC' );

my $graph = $rbac->read_xml_file( { file => $rbac_cat_xml } );
ok( $graph->directed() );

my @u1 =
  $rbac->users_by_cat_module( { graph => $graph, module => 'access.cgi' } );
is( "@u1", "gandalf cipadmin" );

my @u2 =
  $rbac->users_by_cat_module( { graph => $graph, module => 'teacher.cgi' } );
is( "@u2", "gandalf cipadmin bilbo" );

my @u3 =
  $rbac->users_by_cat_module( { graph => $graph, module => 'student.cgi' } );
is( "@u3", "bilbo cipadmin teacher frodo gandalf" );

