use strict;
use warnings;
use Module::Build::CipUX;

my $builder = Module::Build::CipUX->new(
    module_name       => 'CipUX::RBAC',
    license           => 'gpl',
    dist_author       => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version_from => 'lib/CipUX/RBAC.pm',

    #create_makefile_pl => 'traditional',
    #create_readme      => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'Test::Perl::Critic' => 0,
        'Readonly::XS'       => 0,
        'CipUX::Task'        => 0,
    },

    build_requires => {
        'Test::More'           => 0,
        'Test::Pod'            => '1.14',
        'Test::Pod::Coverage'  => '1.04',
        'Module::Build'        => 0,
        'Module::Build::CipUX' => 0,
    },

    requires => {
        'Carp'               => 0,
        'CipUX'              => 0,
        'Class::Std'         => '0.0.9',
        'Data::Dumper'       => 0,
        'English'            => 0,
        'Frontier::Client'   => 0,
        'Getopt::Long'       => 0,
        'Graph'              => 0,
        'Graph::Directed'    => 0,
        'Graph::Reader::XML' => 0,
        'Graph::Writer::XML' => 0,
        'Graph::Writer::Dot' => 0,
        'List::MoreUtils'    => 0,
        'Log::Log4perl'      => 0,
        'Pod::Usage'         => 0,
        'Readonly'           => 0,
        'Scalar::Util'       => 0,
        'version'            => 0,
    },

    # BUILD target
    # Normally you can delete this comments. This lines are
    # intended as a hint what is possible. If you uncomment or
    # use this lines you should know what you do!
    # Only add if it is not already added by Module::Build::CipuX
    # This is useful for CipUX CAT packages
    #
    # This is useful for CipUX core modules
    # schema_files => {
    #     'etc/ldap/schema/cipux.schema' => 'schema/cipux.schema',
    # },

    # INSTALL target: This key=value will be used
    # REALEASE target: The key will be used
    # Only add if it is not already added by Module::Build::CipuX
    # install_path => {
    #    conf755    => 'etc/cipux/',
    # },
    #
    # For some strange locations of POD
    # #bindoc_dirs => [ 'blib/bin755', 'blib/sbin755'],
    add_to_cleanup => ['CipUX-RBAC-*'],
);

# Only to uncomment, if you changed the BUILD target
# $builder->add_build_element('dat');
#$builder->do_create_readme();
#$builder->do_create_makefile_pl();
$builder->create_build_script();

