// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/chromeos/login/network_dropdown_handler.h"

#include "chrome/browser/chromeos/login/webui_login_display.h"
#include "chrome/browser/ui/webui/chromeos/login/network_dropdown.h"
#include "content/browser/webui/web_ui.h"
#include "grit/generated_resources.h"
#include "ui/base/l10n/l10n_util.h"

namespace {

// JS API callbacks names.
const char kJsApiNetworkItemChosen[] = "networkItemChosen";
const char kJsApiNetworkDropdownShow[] = "networkDropdownShow";
const char kJsApiNetworkDropdownHide[] = "networkDropdownHide";
const char kJsApiNetworkDropdownRefresh[] = "networkDropdownRefresh";

}  // namespace

namespace chromeos {

NetworkDropdownHandler::NetworkDropdownHandler() {
}

NetworkDropdownHandler::~NetworkDropdownHandler() {
}

void NetworkDropdownHandler::GetLocalizedStrings(
    base::DictionaryValue* localized_strings) {
  localized_strings->SetString("selectNetwork",
      l10n_util::GetStringUTF16(IDS_NETWORK_SELECTION_SELECT));
}

void NetworkDropdownHandler::Initialize() {
}

void NetworkDropdownHandler::RegisterMessages() {
  web_ui_->RegisterMessageCallback(kJsApiNetworkItemChosen,
      NewCallback(this, &NetworkDropdownHandler::HandleNetworkItemChosen));
  web_ui_->RegisterMessageCallback(kJsApiNetworkDropdownShow,
      NewCallback(this, &NetworkDropdownHandler::HandleNetworkDropdownShow));
  web_ui_->RegisterMessageCallback(kJsApiNetworkDropdownHide,
      NewCallback(this, &NetworkDropdownHandler::HandleNetworkDropdownHide));
  web_ui_->RegisterMessageCallback(kJsApiNetworkDropdownRefresh,
      NewCallback(this, &NetworkDropdownHandler::HandleNetworkDropdownRefresh));
}

void NetworkDropdownHandler::HandleNetworkItemChosen(
    const base::ListValue* args) {
  DCHECK(args->GetSize() == 1);
  double id;
  if (!args->GetDouble(0, &id))
    NOTREACHED();
  DCHECK(dropdown_.get());
  dropdown_->OnItemChosen(static_cast<int>(id));
}

void NetworkDropdownHandler::HandleNetworkDropdownShow(
    const base::ListValue* args) {
  DCHECK(args->GetSize() == 1);
  std::string element_id;
  if (!args->GetString(0, &element_id))
    NOTREACHED();

  dropdown_.reset(new NetworkDropdown(
      web_ui_, WebUILoginDisplay::GetLoginWindow()->GetNativeWindow()));
}

void NetworkDropdownHandler::HandleNetworkDropdownHide(
    const base::ListValue* args) {
  DCHECK(args->GetSize() == 0);
  dropdown_.reset();
}

void NetworkDropdownHandler::HandleNetworkDropdownRefresh(
    const base::ListValue* args) {
  DCHECK(args->GetSize() == 0);
  // Since language change is async,
  // we may in theory be on another screen during this call.
  if (dropdown_.get())
    dropdown_->Refresh();
}

}  // namespace chromeos
