# Copyright (c) 2011 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'skia',
      'type': '<(component)',
      'sources': [
        '../third_party/skia/gpu/src/GrAAHairLinePathRenderer.cpp',
        '../third_party/skia/gpu/src/GrAAHairLinePathRenderer.h',
        '../third_party/skia/gpu/src/GrAddPathRenderers_aahairline.cpp',
        '../third_party/skia/gpu/src/GrAllocPool.cpp',
        '../third_party/skia/gpu/src/GrAtlas.cpp',
        '../third_party/skia/gpu/src/GrBufferAllocPool.cpp',
        '../third_party/skia/gpu/src/GrBufferAllocPool.h',
        '../third_party/skia/gpu/src/GrClip.cpp',
        '../third_party/skia/gpu/src/GrContext.cpp',
        '../third_party/skia/gpu/src/GrDefaultPathRenderer.cpp',
        '../third_party/skia/gpu/src/GrDefaultPathRenderer.h',
        '../third_party/skia/gpu/src/GrDrawTarget.cpp',
        '../third_party/skia/gpu/src/GrDrawTarget.h',
        '../third_party/skia/gpu/src/GrGeometryBuffer.h',
        '../third_party/skia/gpu/src/GrGLDefaultInterface_none.cpp',
        '../third_party/skia/gpu/src/GrGLIndexBuffer.cpp',
        '../third_party/skia/gpu/src/GrGLIndexBuffer.h',
        '../third_party/skia/gpu/src/GrGLInterface.cpp',
        '../third_party/skia/gpu/src/GrGLIRect.h',
        '../third_party/skia/gpu/src/GrGLProgram.cpp',
        '../third_party/skia/gpu/src/GrGLProgram.h',
        '../third_party/skia/gpu/src/GrGLRenderTarget.cpp',
        '../third_party/skia/gpu/src/GrGLRenderTarget.h',
        '../third_party/skia/gpu/src/GrGLStencilBuffer.cpp',
        '../third_party/skia/gpu/src/GrGLStencilBuffer.h',
        '../third_party/skia/gpu/src/GrGLTexture.cpp',
        '../third_party/skia/gpu/src/GrGLTexture.h',
        '../third_party/skia/gpu/src/GrGLUtil.cpp',
        '../third_party/skia/gpu/src/GrGLVertexBuffer.cpp',
        '../third_party/skia/gpu/src/GrGLVertexBuffer.h',
        '../third_party/skia/gpu/src/GrGpu.cpp',
        '../third_party/skia/gpu/src/GrGpu.h',
        '../third_party/skia/gpu/src/GrGpuFactory.cpp',
        '../third_party/skia/gpu/src/GrGpuGL.cpp',
        '../third_party/skia/gpu/src/GrGpuGL.h',
        '../third_party/skia/gpu/src/GrGpuGLFixed.cpp',
        '../third_party/skia/gpu/src/GrGpuGLFixed.h',
        '../third_party/skia/gpu/src/GrGpuGLShaders.cpp',
        '../third_party/skia/gpu/src/GrGpuGLShaders.h',
        '../third_party/skia/gpu/src/GrIndexBuffer.h',
        '../third_party/skia/gpu/src/GrInOrderDrawBuffer.cpp',
        '../third_party/skia/gpu/src/GrInOrderDrawBuffer.h',
        '../third_party/skia/gpu/src/GrMatrix.cpp',
        '../third_party/skia/gpu/src/GrMemory.cpp',
        '../third_party/skia/gpu/src/GrPathRenderer.cpp',
        '../third_party/skia/gpu/src/GrPathRenderer.h',
        '../third_party/skia/gpu/src/GrPathRendererChain.cpp',
        '../third_party/skia/gpu/src/GrPathRendererChain.h',
        '../third_party/skia/gpu/src/GrPathUtils.cpp',
        '../third_party/skia/gpu/src/GrRectanizer_fifo.cpp',
        '../third_party/skia/gpu/src/GrRenderTarget.cpp',
        '../third_party/skia/gpu/src/GrResource.cpp',
        '../third_party/skia/gpu/src/GrResourceCache.cpp',
        '../third_party/skia/gpu/src/GrResourceCache.h',
        '../third_party/skia/gpu/src/GrStencil.cpp',
        '../third_party/skia/gpu/src/GrStencilBuffer.cpp',
        '../third_party/skia/gpu/src/GrStencilBuffer.h',
        '../third_party/skia/gpu/src/GrTesselatedPathRenderer.cpp',
        '../third_party/skia/gpu/src/GrTesselatedPathRenderer.h',
        '../third_party/skia/gpu/src/GrTexture.cpp',
        '../third_party/skia/gpu/src/GrTextContext.cpp',
        '../third_party/skia/gpu/src/GrTextStrike.cpp',
        '../third_party/skia/gpu/src/GrTextStrike_impl.h',
        '../third_party/skia/gpu/src/GrVertexBuffer.h',

        '../third_party/skia/gpu/include/GrAllocPool.h',
        '../third_party/skia/gpu/include/GrAllocator.h',
        '../third_party/skia/gpu/include/GrAtlas.h',
        '../third_party/skia/gpu/include/GrClip.h',
        '../third_party/skia/gpu/include/GrClipIterator.h',
        '../third_party/skia/gpu/include/GrColor.h',
        '../third_party/skia/gpu/include/GrConfig.h',
        '../third_party/skia/gpu/include/GrContext.h',
        '../third_party/skia/gpu/include/GrFontScaler.h',
        '../third_party/skia/gpu/include/GrGLConfig.h',
        '../third_party/skia/gpu/include/GrGLConfig_chrome.h',
        '../third_party/skia/gpu/include/GrGLInterface.h',
        '../third_party/skia/gpu/include/GrGlyph.h',
        '../third_party/skia/gpu/include/GrGpuVertex.h',
        '../third_party/skia/gpu/include/GrIPoint.h',
        '../third_party/skia/gpu/include/GrInstanceCounter.h',
        '../third_party/skia/gpu/include/GrKey.h',
        '../third_party/skia/gpu/include/GrMatrix.h',
        '../third_party/skia/gpu/include/GrMesh.h',
        '../third_party/skia/gpu/include/GrNoncopyable.h',
        '../third_party/skia/gpu/include/GrPaint.h',
        '../third_party/skia/gpu/include/GrPath.h',
        '../third_party/skia/gpu/include/GrPathSink.h',
        '../third_party/skia/gpu/include/GrPoint.h',
        '../third_party/skia/gpu/include/GrRandom.h',
        '../third_party/skia/gpu/include/GrRect.h',
        '../third_party/skia/gpu/include/GrRectanizer.h',
        '../third_party/skia/gpu/include/GrRefCnt.h',
        '../third_party/skia/gpu/include/GrRenderTarget.h',
        '../third_party/skia/gpu/include/GrSamplerState.h',
        '../third_party/skia/gpu/include/GrScalar.h',
        '../third_party/skia/gpu/include/GrStencil.h',
        '../third_party/skia/gpu/include/GrStopwatch.h',
        '../third_party/skia/gpu/include/GrStringBuilder.h',
        '../third_party/skia/gpu/include/GrTArray.h',
        '../third_party/skia/gpu/include/GrTBSearch.h',
        '../third_party/skia/gpu/include/GrTDArray.h',
        '../third_party/skia/gpu/include/GrTHashCache.h',
        '../third_party/skia/gpu/include/GrTLList.h',
        '../third_party/skia/gpu/include/GrTextContext.h',
        '../third_party/skia/gpu/include/GrTextStrike.h',
        '../third_party/skia/gpu/include/GrTexture.h',
        '../third_party/skia/gpu/include/GrTypes.h',
        '../third_party/skia/gpu/include/GrUserConfig.h',

        #'../third_party/skia/src/animator/SkAnimate.h',
        #'../third_party/skia/src/animator/SkAnimateActive.cpp',
        #'../third_party/skia/src/animator/SkAnimateActive.h',
        #'../third_party/skia/src/animator/SkAnimateBase.cpp',
        #'../third_party/skia/src/animator/SkAnimateBase.h',
        #'../third_party/skia/src/animator/SkAnimateField.cpp',
        #'../third_party/skia/src/animator/SkAnimateMaker.cpp',
        #'../third_party/skia/src/animator/SkAnimateMaker.h',
        #'../third_party/skia/src/animator/SkAnimateProperties.h',
        #'../third_party/skia/src/animator/SkAnimateSchema.xsd',
        #'../third_party/skia/src/animator/SkAnimateSchema.xsx',
        #'../third_party/skia/src/animator/SkAnimateSet.cpp',
        #'../third_party/skia/src/animator/SkAnimateSet.h',
        #'../third_party/skia/src/animator/SkAnimator.cpp',
        #'../third_party/skia/src/animator/SkAnimatorScript.cpp',
        #'../third_party/skia/src/animator/SkAnimatorScript.h',
        #'../third_party/skia/src/animator/SkAnimatorScript2.cpp',
        #'../third_party/skia/src/animator/SkAnimatorScript2.h',
        #'../third_party/skia/src/animator/SkBase64.cpp',
        #'../third_party/skia/src/animator/SkBase64.h',
        #'../third_party/skia/src/animator/SkBoundable.cpp',
        #'../third_party/skia/src/animator/SkBoundable.h',
        #'../third_party/skia/src/animator/SkBuildCondensedInfo.cpp',
        #'../third_party/skia/src/animator/SkCondensedDebug.cpp',
        #'../third_party/skia/src/animator/SkCondensedRelease.cpp',
        #'../third_party/skia/src/animator/SkDisplayAdd.cpp',
        #'../third_party/skia/src/animator/SkDisplayAdd.h',
        #'../third_party/skia/src/animator/SkDisplayApply.cpp',
        #'../third_party/skia/src/animator/SkDisplayApply.h',
        #'../third_party/skia/src/animator/SkDisplayBounds.cpp',
        #'../third_party/skia/src/animator/SkDisplayBounds.h',
        #'../third_party/skia/src/animator/SkDisplayEvent.cpp',
        #'../third_party/skia/src/animator/SkDisplayEvent.h',
        #'../third_party/skia/src/animator/SkDisplayEvents.cpp',
        #'../third_party/skia/src/animator/SkDisplayEvents.h',
        #'../third_party/skia/src/animator/SkDisplayInclude.cpp',
        #'../third_party/skia/src/animator/SkDisplayInclude.h',
        #'../third_party/skia/src/animator/SkDisplayInput.cpp',
        #'../third_party/skia/src/animator/SkDisplayInput.h',
        #'../third_party/skia/src/animator/SkDisplayList.cpp',
        #'../third_party/skia/src/animator/SkDisplayList.h',
        #'../third_party/skia/src/animator/SkDisplayMath.cpp',
        #'../third_party/skia/src/animator/SkDisplayMath.h',
        #'../third_party/skia/src/animator/SkDisplayMovie.cpp',
        #'../third_party/skia/src/animator/SkDisplayMovie.h',
        #'../third_party/skia/src/animator/SkDisplayNumber.cpp',
        #'../third_party/skia/src/animator/SkDisplayNumber.h',
        #'../third_party/skia/src/animator/SkDisplayPost.cpp',
        #'../third_party/skia/src/animator/SkDisplayPost.h',
        #'../third_party/skia/src/animator/SkDisplayRandom.cpp',
        #'../third_party/skia/src/animator/SkDisplayRandom.h',
        #'../third_party/skia/src/animator/SkDisplayScreenplay.cpp',
        #'../third_party/skia/src/animator/SkDisplayScreenplay.h',
        #'../third_party/skia/src/animator/SkDisplayType.cpp',
        #'../third_party/skia/src/animator/SkDisplayType.h',
        #'../third_party/skia/src/animator/SkDisplayTypes.cpp',
        #'../third_party/skia/src/animator/SkDisplayTypes.h',
        #'../third_party/skia/src/animator/SkDisplayXMLParser.cpp',
        #'../third_party/skia/src/animator/SkDisplayXMLParser.h',
        #'../third_party/skia/src/animator/SkDisplayable.cpp',
        #'../third_party/skia/src/animator/SkDisplayable.h',
        #'../third_party/skia/src/animator/SkDraw3D.cpp',
        #'../third_party/skia/src/animator/SkDraw3D.h',
        #'../third_party/skia/src/animator/SkDrawBitmap.cpp',
        #'../third_party/skia/src/animator/SkDrawBitmap.h',
        #'../third_party/skia/src/animator/SkDrawBlur.cpp',
        #'../third_party/skia/src/animator/SkDrawBlur.h',
        #'../third_party/skia/src/animator/SkDrawClip.cpp',
        #'../third_party/skia/src/animator/SkDrawClip.h',
        #'../third_party/skia/src/animator/SkDrawColor.cpp',
        #'../third_party/skia/src/animator/SkDrawColor.h',
        #'../third_party/skia/src/animator/SkDrawDash.cpp',
        #'../third_party/skia/src/animator/SkDrawDash.h',
        #'../third_party/skia/src/animator/SkDrawDiscrete.cpp',
        #'../third_party/skia/src/animator/SkDrawDiscrete.h',
        #'../third_party/skia/src/animator/SkDrawEmboss.cpp',
        #'../third_party/skia/src/animator/SkDrawEmboss.h',
        #'../third_party/skia/src/animator/SkDrawExtraPathEffect.cpp',
        #'../third_party/skia/src/animator/SkDrawFull.cpp',
        #'../third_party/skia/src/animator/SkDrawFull.h',
        #'../third_party/skia/src/animator/SkDrawGradient.cpp',
        #'../third_party/skia/src/animator/SkDrawGradient.h',
        #'../third_party/skia/src/animator/SkDrawGroup.cpp',
        #'../third_party/skia/src/animator/SkDrawGroup.h',
        #'../third_party/skia/src/animator/SkDrawLine.cpp',
        #'../third_party/skia/src/animator/SkDrawLine.h',
        #'../third_party/skia/src/animator/SkDrawMatrix.cpp',
        #'../third_party/skia/src/animator/SkDrawMatrix.h',
        #'../third_party/skia/src/animator/SkDrawOval.cpp',
        #'../third_party/skia/src/animator/SkDrawOval.h',
        #'../third_party/skia/src/animator/SkDrawPaint.cpp',
        #'../third_party/skia/src/animator/SkDrawPaint.h',
        #'../third_party/skia/src/animator/SkDrawPath.cpp',
        #'../third_party/skia/src/animator/SkDrawPath.h',
        #'../third_party/skia/src/animator/SkDrawPoint.cpp',
        #'../third_party/skia/src/animator/SkDrawPoint.h',
        #'../third_party/skia/src/animator/SkDrawRectangle.cpp',
        #'../third_party/skia/src/animator/SkDrawRectangle.h',
        #'../third_party/skia/src/animator/SkDrawSaveLayer.cpp',
        #'../third_party/skia/src/animator/SkDrawSaveLayer.h',
        #'../third_party/skia/src/animator/SkDrawShader.cpp',
        #'../third_party/skia/src/animator/SkDrawShader.h',
        #'../third_party/skia/src/animator/SkDrawText.cpp',
        #'../third_party/skia/src/animator/SkDrawText.h',
        #'../third_party/skia/src/animator/SkDrawTextBox.cpp',
        #'../third_party/skia/src/animator/SkDrawTextBox.h',
        #'../third_party/skia/src/animator/SkDrawTo.cpp',
        #'../third_party/skia/src/animator/SkDrawTo.h',
        #'../third_party/skia/src/animator/SkDrawTransparentShader.cpp',
        #'../third_party/skia/src/animator/SkDrawTransparentShader.h',
        #'../third_party/skia/src/animator/SkDrawable.cpp',
        #'../third_party/skia/src/animator/SkDrawable.h',
        #'../third_party/skia/src/animator/SkDump.cpp',
        #'../third_party/skia/src/animator/SkDump.h',
        #'../third_party/skia/src/animator/SkExtraPathEffects.xsd',
        #'../third_party/skia/src/animator/SkExtras.h',
        #'../third_party/skia/src/animator/SkGetCondensedInfo.cpp',
        #'../third_party/skia/src/animator/SkHitClear.cpp',
        #'../third_party/skia/src/animator/SkHitClear.h',
        #'../third_party/skia/src/animator/SkHitTest.cpp',
        #'../third_party/skia/src/animator/SkHitTest.h',
        #'../third_party/skia/src/animator/SkIntArray.h',
        #'../third_party/skia/src/animator/SkMatrixParts.cpp',
        #'../third_party/skia/src/animator/SkMatrixParts.h',
        #'../third_party/skia/src/animator/SkMemberInfo.cpp',
        #'../third_party/skia/src/animator/SkMemberInfo.h',
        #'../third_party/skia/src/animator/SkOpArray.cpp',
        #'../third_party/skia/src/animator/SkOpArray.h',
        #'../third_party/skia/src/animator/SkOperand.h',
        #'../third_party/skia/src/animator/SkOperand2.h',
        #'../third_party/skia/src/animator/SkOperandInterpolator.h',
        #'../third_party/skia/src/animator/SkOperandIterpolator.cpp',
        #'../third_party/skia/src/animator/SkPaintParts.cpp',
        #'../third_party/skia/src/animator/SkPaintParts.h',
        #'../third_party/skia/src/animator/SkParseSVGPath.cpp',
        #'../third_party/skia/src/animator/SkPathParts.cpp',
        #'../third_party/skia/src/animator/SkPathParts.h',
        #'../third_party/skia/src/animator/SkPostParts.cpp',
        #'../third_party/skia/src/animator/SkPostParts.h',
        #'../third_party/skia/src/animator/SkScript.cpp',
        #'../third_party/skia/src/animator/SkScript.h',
        #'../third_party/skia/src/animator/SkScript2.h',
        #'../third_party/skia/src/animator/SkScriptCallBack.h',
        #'../third_party/skia/src/animator/SkScriptDecompile.cpp',
        #'../third_party/skia/src/animator/SkScriptRuntime.cpp',
        #'../third_party/skia/src/animator/SkScriptRuntime.h',
        #'../third_party/skia/src/animator/SkScriptTokenizer.cpp',
        #'../third_party/skia/src/animator/SkSnapshot.cpp',
        #'../third_party/skia/src/animator/SkSnapshot.h',
        #'../third_party/skia/src/animator/SkTDArray_Experimental.h',
        #'../third_party/skia/src/animator/SkTextOnPath.cpp',
        #'../third_party/skia/src/animator/SkTextOnPath.h',
        #'../third_party/skia/src/animator/SkTextToPath.cpp',
        #'../third_party/skia/src/animator/SkTextToPath.h',
        #'../third_party/skia/src/animator/SkTypedArray.cpp',
        #'../third_party/skia/src/animator/SkTypedArray.h',
        #'../third_party/skia/src/animator/SkXMLAnimatorWriter.cpp',
        #'../third_party/skia/src/animator/SkXMLAnimatorWriter.h',

        '../third_party/skia/src/animator/SkTime.cpp',

        '../third_party/skia/src/core/ARGB32_Clamp_Bilinear_BitmapShader.h',
        '../third_party/skia/src/core/Sk64.cpp',
        '../third_party/skia/src/core/SkAdvancedTypefaceMetrics.cpp',
        '../third_party/skia/src/core/SkAlphaRuns.cpp',
        '../third_party/skia/src/core/SkAntiRun.h',
        '../third_party/skia/src/core/SkBitmap.cpp',
        '../third_party/skia/src/core/SkBitmapProcShader.cpp',
        '../third_party/skia/src/core/SkBitmapProcShader.h',
        '../third_party/skia/src/core/SkBitmapProcState.cpp',
        '../third_party/skia/src/core/SkBitmapProcState.h',
        '../third_party/skia/src/core/SkBitmapProcState_matrix.h',
        '../third_party/skia/src/core/SkBitmapProcState_matrixProcs.cpp',
        '../third_party/skia/src/core/SkBitmapProcState_sample.h',
        '../third_party/skia/src/core/SkBitmapSampler.cpp',
        '../third_party/skia/src/core/SkBitmapSampler.h',
        '../third_party/skia/src/core/SkBitmapSamplerTemplate.h',
        '../third_party/skia/src/core/SkBitmapShader16BilerpTemplate.h',
        '../third_party/skia/src/core/SkBitmapShaderTemplate.h',
        '../third_party/skia/src/core/SkBitmap_scroll.cpp',
        '../third_party/skia/src/core/SkBlitBWMaskTemplate.h',
        '../third_party/skia/src/core/SkBlitRow_D16.cpp',
        '../third_party/skia/src/core/SkBlitRow_D32.cpp',
        '../third_party/skia/src/core/SkBlitRow_D4444.cpp',
        '../third_party/skia/src/core/SkBlitter.cpp',
        '../third_party/skia/src/core/SkBlitter_4444.cpp',
        '../third_party/skia/src/core/SkBlitter_A1.cpp',
        '../third_party/skia/src/core/SkBlitter_A8.cpp',
        '../third_party/skia/src/core/SkBlitter_ARGB32.cpp',
        '../third_party/skia/src/core/SkBlitter_RGB16.cpp',
        '../third_party/skia/src/core/SkBlitter_Sprite.cpp',
        '../third_party/skia/src/core/SkBuffer.cpp',
        '../third_party/skia/src/core/SkCanvas.cpp',
        '../third_party/skia/src/core/SkChunkAlloc.cpp',
        '../third_party/skia/src/core/SkClampRange.cpp',
        '../third_party/skia/src/core/SkClipStack.cpp',
        '../third_party/skia/src/core/SkColor.cpp',
        '../third_party/skia/src/core/SkColorFilter.cpp',
        '../third_party/skia/src/core/SkColorTable.cpp',
        '../third_party/skia/src/core/SkComposeShader.cpp',
        '../third_party/skia/src/core/SkConcaveToTriangles.cpp',
        '../third_party/skia/src/core/SkConcaveToTriangles.h',
        '../third_party/skia/src/core/SkCordic.cpp',
        '../third_party/skia/src/core/SkCordic.h',
        '../third_party/skia/src/core/SkCoreBlitters.h',
        '../third_party/skia/src/core/SkCubicClipper.cpp',
        '../third_party/skia/src/core/SkCubicClipper.h',
        '../third_party/skia/src/core/SkData.cpp',
        '../third_party/skia/src/core/SkDebug.cpp',
        #'../third_party/skia/src/core/SkDebug_stdio.cpp',
        '../third_party/skia/src/core/SkDeque.cpp',
        '../third_party/skia/src/core/SkDevice.cpp',
        '../third_party/skia/src/core/SkDither.cpp',
        '../third_party/skia/src/core/SkDraw.cpp',
        '../third_party/skia/src/core/SkDrawProcs.h',
        #'../third_party/skia/src/core/SkDrawing.cpp',
        '../third_party/skia/src/core/SkEdgeBuilder.cpp',
        '../third_party/skia/src/core/SkEdgeClipper.cpp',
        '../third_party/skia/src/core/SkEdge.cpp',
        '../third_party/skia/src/core/SkEdge.h',
        '../third_party/skia/src/core/SkFP.h',
        '../third_party/skia/src/core/SkFilterProc.cpp',
        '../third_party/skia/src/core/SkFilterProc.h',
        '../third_party/skia/src/core/SkFlate.cpp',
        '../third_party/skia/src/core/SkFlattenable.cpp',
        '../third_party/skia/src/core/SkFloat.cpp',
        '../third_party/skia/src/core/SkFloat.h',
        '../third_party/skia/src/core/SkFloatBits.cpp',
        '../third_party/skia/src/core/SkFontHost.cpp',
        '../third_party/skia/src/core/SkGeometry.cpp',
        '../third_party/skia/src/core/SkGlobals.cpp',
        '../third_party/skia/src/core/SkGlyphCache.cpp',
        '../third_party/skia/src/core/SkGlyphCache.h',
        '../third_party/skia/src/core/SkGraphics.cpp',
        '../third_party/skia/src/core/SkLineClipper.cpp',
        '../third_party/skia/src/core/SkMMapStream.cpp',
        '../third_party/skia/src/core/SkMallocPixelRef.cpp',
        '../third_party/skia/src/core/SkMask.cpp',
        '../third_party/skia/src/core/SkMaskFilter.cpp',
        '../third_party/skia/src/core/SkMath.cpp',
        '../third_party/skia/src/core/SkMatrix.cpp',
        '../third_party/skia/src/core/SkMetaData.cpp',
        '../third_party/skia/src/core/SkPackBits.cpp',
        '../third_party/skia/src/core/SkPaint.cpp',
        '../third_party/skia/src/core/SkPath.cpp',
        '../third_party/skia/src/core/SkPathEffect.cpp',
        '../third_party/skia/src/core/SkPathHeap.cpp',
        '../third_party/skia/src/core/SkPathHeap.h',
        '../third_party/skia/src/core/SkPathMeasure.cpp',
        '../third_party/skia/src/core/SkPicture.cpp',
        '../third_party/skia/src/core/SkPictureFlat.cpp',
        '../third_party/skia/src/core/SkPictureFlat.h',
        '../third_party/skia/src/core/SkPicturePlayback.cpp',
        '../third_party/skia/src/core/SkPicturePlayback.h',
        '../third_party/skia/src/core/SkPictureRecord.cpp',
        '../third_party/skia/src/core/SkPictureRecord.h',
        '../third_party/skia/src/core/SkPixelRef.cpp',
        '../third_party/skia/src/core/SkPoint.cpp',
        '../third_party/skia/src/core/SkProcSpriteBlitter.cpp',
        '../third_party/skia/src/core/SkPtrRecorder.cpp',
        '../third_party/skia/src/core/SkQuadClipper.cpp',
        '../third_party/skia/src/core/SkQuadClipper.h',
        '../third_party/skia/src/core/SkRasterizer.cpp',
        '../third_party/skia/src/core/SkRect.cpp',
        '../third_party/skia/src/core/SkRefDict.cpp',
        '../third_party/skia/src/core/SkRegion.cpp',
        '../third_party/skia/src/core/SkRegionPriv.h',
        '../third_party/skia/src/core/SkRegion_path.cpp',
        '../third_party/skia/src/core/SkScalar.cpp',
        '../third_party/skia/src/core/SkScalerContext.cpp',
        '../third_party/skia/src/core/SkScan.cpp',
        '../third_party/skia/src/core/SkScanPriv.h',
        '../third_party/skia/src/core/SkScan_AntiPath.cpp',
        '../third_party/skia/src/core/SkScan_Antihair.cpp',
        '../third_party/skia/src/core/SkScan_Hairline.cpp',
        '../third_party/skia/src/core/SkScan_Path.cpp',
        '../third_party/skia/src/core/SkShader.cpp',
        '../third_party/skia/src/core/SkShape.cpp',
        '../third_party/skia/src/core/SkSpriteBlitter_ARGB32.cpp',
        '../third_party/skia/src/core/SkSpriteBlitter_RGB16.cpp',
        '../third_party/skia/src/core/SkSinTable.h',
        '../third_party/skia/src/core/SkSpriteBlitter.h',
        '../third_party/skia/src/core/SkSpriteBlitterTemplate.h',
        '../third_party/skia/src/core/SkStream.cpp',
        '../third_party/skia/src/core/SkString.cpp',
        '../third_party/skia/src/core/SkStroke.cpp',
        '../third_party/skia/src/core/SkStrokerPriv.cpp',
        '../third_party/skia/src/core/SkStrokerPriv.h',
        '../third_party/skia/src/core/SkTextFormatParams.h',
        '../third_party/skia/src/core/SkTSearch.cpp',
        '../third_party/skia/src/core/SkTSort.h',
        '../third_party/skia/src/core/SkTemplatesPriv.h',
        '../third_party/skia/src/core/SkTypeface.cpp',
        '../third_party/skia/src/core/SkTypefaceCache.cpp',
        '../third_party/skia/src/core/SkUnPreMultiply.cpp',
        '../third_party/skia/src/core/SkUtils.cpp',
        '../third_party/skia/src/core/SkWriter32.cpp',
        '../third_party/skia/src/core/SkXfermode.cpp',

        '../third_party/skia/src/effects/Sk1DPathEffect.cpp',
        '../third_party/skia/src/effects/Sk2DPathEffect.cpp',
        '../third_party/skia/src/effects/SkAvoidXfermode.cpp',
        '../third_party/skia/src/effects/SkBitmapCache.cpp',
        '../third_party/skia/src/effects/SkBitmapCache.h',
        '../third_party/skia/src/effects/SkBlurDrawLooper.cpp',
        '../third_party/skia/src/effects/SkBlurMask.cpp',
        '../third_party/skia/src/effects/SkBlurMask.h',
        '../third_party/skia/src/effects/SkBlurMaskFilter.cpp',
        '../third_party/skia/src/effects/SkColorFilters.cpp',
        '../third_party/skia/src/effects/SkColorMatrixFilter.cpp',
        '../third_party/skia/src/effects/SkCornerPathEffect.cpp',
        '../third_party/skia/src/effects/SkDashPathEffect.cpp',
        '../third_party/skia/src/effects/SkDiscretePathEffect.cpp',
        '../third_party/skia/src/effects/SkEmbossMask.cpp',
        '../third_party/skia/src/effects/SkEmbossMask.h',
        '../third_party/skia/src/effects/SkEmbossMask_Table.h',
        '../third_party/skia/src/effects/SkEmbossMaskFilter.cpp',
        '../third_party/skia/src/effects/SkGradientShader.cpp',
        '../third_party/skia/src/effects/SkKernel33MaskFilter.cpp',
        '../third_party/skia/src/effects/SkLayerDrawLooper.cpp',
        '../third_party/skia/src/effects/SkLayerRasterizer.cpp',
        '../third_party/skia/src/effects/SkPaintFlagsDrawFilter.cpp',
        '../third_party/skia/src/effects/SkPorterDuff.cpp',
        '../third_party/skia/src/effects/SkPixelXorXfermode.cpp',
        '../third_party/skia/src/effects/SkRadialGradient_Table.h',
        '../third_party/skia/src/effects/SkTransparentShader.cpp',

        '../third_party/skia/src/gpu/SkGpuCanvas.cpp',
        '../third_party/skia/src/gpu/SkGpuDevice.cpp',
        '../third_party/skia/src/gpu/GrPrintf_skia.cpp',
        '../third_party/skia/src/gpu/SkGrFontScaler.cpp',
        '../third_party/skia/src/gpu/SkGr.cpp',
        '../third_party/skia/src/gpu/SkGrTexturePixelRef.cpp',

        '../third_party/skia/src/images/bmpdecoderhelper.cpp',
        '../third_party/skia/src/images/bmpdecoderhelper.h',
        '../third_party/skia/src/images/SkBitmap_RLEPixels.h',
        '../third_party/skia/src/images/SkCreateRLEPixelRef.cpp',
        #'../third_party/skia/src/images/SkFDStream.cpp',
        #'../third_party/skia/src/images/SkFlipPixelRef.cpp',
        '../third_party/skia/src/images/SkImageDecoder.cpp',
        '../third_party/skia/src/images/SkImageDecoder_Factory.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_fpdfemb.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_libbmp.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_libgif.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_libico.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_libjpeg.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_libpng.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_libpvjpeg.cpp',
        #'../third_party/skia/src/images/SkImageDecoder_wbmp.cpp',
        #'../third_party/skia/src/images/SkImageEncoder.cpp',
        #'../third_party/skia/src/images/SkImageEncoder_Factory.cpp',
        #'../third_party/skia/src/images/SkImageRef.cpp',
        #'../third_party/skia/src/images/SkImageRefPool.cpp',
        #'../third_party/skia/src/images/SkImageRefPool.h',
        #'../third_party/skia/src/images/SkImageRef_GlobalPool.cpp',
        #'../third_party/skia/src/images/SkMovie.cpp',
        #'../third_party/skia/src/images/SkMovie_gif.cpp',
        '../third_party/skia/src/images/SkScaledBitmapSampler.cpp',
        '../third_party/skia/src/images/SkScaledBitmapSampler.h',

        '../third_party/skia/src/opts/opts_check_SSE2.cpp',

        '../third_party/skia/src/pdf/SkBitSet.cpp',
        '../third_party/skia/src/pdf/SkPDFCatalog.cpp',
        '../third_party/skia/src/pdf/SkPDFDevice.cpp',
        '../third_party/skia/src/pdf/SkPDFDocument.cpp',
        '../third_party/skia/src/pdf/SkPDFFont.cpp',
        '../third_party/skia/src/pdf/SkPDFFormXObject.cpp',
        '../third_party/skia/src/pdf/SkPDFGraphicState.cpp',
        '../third_party/skia/src/pdf/SkPDFImage.cpp',
        '../third_party/skia/src/pdf/SkPDFPage.cpp',
        '../third_party/skia/src/pdf/SkPDFShader.cpp',
        '../third_party/skia/src/pdf/SkPDFStream.cpp',
        '../third_party/skia/src/pdf/SkPDFTypes.cpp',
        '../third_party/skia/src/pdf/SkPDFUtils.cpp',

        #'../third_party/skia/src/ports/SkFontHost_FONTPATH.cpp',
        '../third_party/skia/src/ports/SkFontHost_FreeType.cpp',
        #'../third_party/skia/src/ports/SkFontHost_android.cpp',
        #'../third_party/skia/src/ports/SkFontHost_ascender.cpp',
        '../third_party/skia/src/ports/SkFontHost_tables.cpp',
        #'../third_party/skia/src/ports/SkFontHost_gamma.cpp',
        '../third_party/skia/src/ports/SkFontHost_gamma_none.cpp',
        #'../third_party/skia/src/ports/SkFontHost_linux.cpp',
        '../third_party/skia/src/ports/SkFontHost_mac.cpp',
        #'../third_party/skia/src/ports/SkFontHost_none.cpp',
        '../third_party/skia/src/ports/SkFontHost_win.cpp',
        '../third_party/skia/src/ports/SkGlobals_global.cpp',
        #'../third_party/skia/src/ports/SkImageDecoder_CG.cpp',
        #'../third_party/skia/src/ports/SkImageDecoder_empty.cpp',
        #'../third_party/skia/src/ports/SkImageRef_ashmem.cpp',
        #'../third_party/skia/src/ports/SkImageRef_ashmem.h',
        #'../third_party/skia/src/ports/SkOSEvent_android.cpp',
        #'../third_party/skia/src/ports/SkOSEvent_dummy.cpp',
        '../third_party/skia/src/ports/SkOSFile_stdio.cpp',
        #'../third_party/skia/src/ports/SkThread_none.cpp',
        #'../third_party/skia/src/ports/SkThread_pthread.cpp',
        '../third_party/skia/src/ports/SkThread_win.cpp',
        '../third_party/skia/src/ports/SkTime_Unix.cpp',
        #'../third_party/skia/src/ports/SkXMLParser_empty.cpp',
        #'../third_party/skia/src/ports/SkXMLParser_expat.cpp',
        #'../third_party/skia/src/ports/SkXMLParser_tinyxml.cpp',
        #'../third_party/skia/src/ports/SkXMLPullParser_expat.cpp',
        '../third_party/skia/src/ports/sk_predefined_gamma.h',

        '../third_party/skia/include/utils/mac/SkCGUtils.h',
        '../third_party/skia/src/utils/mac/SkCreateCGImageRef.cpp',

        '../third_party/skia/include/core/Sk64.h',
        '../third_party/skia/include/core/SkAdvancedTypefaceMetrics.h',
        '../third_party/skia/include/core/SkAutoKern.h',
        '../third_party/skia/include/core/SkBitmap.h',
        '../third_party/skia/include/core/SkBlitRow.h',
        '../third_party/skia/include/core/SkBlitter.h',
        '../third_party/skia/include/core/SkBounder.h',
        '../third_party/skia/include/core/SkBuffer.h',
        '../third_party/skia/include/core/SkCanvas.h',
        '../third_party/skia/include/core/SkChunkAlloc.h',
        '../third_party/skia/include/core/SkClipStack.h',
        '../third_party/skia/include/core/SkColor.h',
        '../third_party/skia/include/core/SkColorFilter.h',
        '../third_party/skia/include/core/SkColorPriv.h',
        '../third_party/skia/include/core/SkColorShader.h',
        '../third_party/skia/include/core/SkComposeShader.h',
        '../third_party/skia/include/core/SkData.h',
        '../third_party/skia/include/core/SkDeque.h',
        '../third_party/skia/include/core/SkDescriptor.h',
        '../third_party/skia/include/core/SkDevice.h',
        '../third_party/skia/include/core/SkDither.h',
        '../third_party/skia/include/core/SkDraw.h',
        '../third_party/skia/include/core/SkDrawFilter.h',
        '../third_party/skia/include/core/SkDrawLooper.h',
        #'../third_party/skia/include/core/SkDrawing.h',
        '../third_party/skia/include/core/SkEndian.h',
        '../third_party/skia/include/core/SkFDot6.h',
        '../third_party/skia/include/core/SkFixed.h',
        '../third_party/skia/include/core/SkFlate.h',
        '../third_party/skia/include/core/SkFlattenable.h',
        '../third_party/skia/include/core/SkFloatBits.h',
        '../third_party/skia/include/core/SkFloatingPoint.h',
        '../third_party/skia/include/core/SkFontHost.h',
        '../third_party/skia/include/core/SkGeometry.h',
        '../third_party/skia/include/core/SkGlobals.h',
        '../third_party/skia/include/core/SkGraphics.h',
        '../third_party/skia/include/core/SkMMapStream.h',
        '../third_party/skia/include/core/SkMallocPixelRef.h',
        '../third_party/skia/include/core/SkMask.h',
        '../third_party/skia/include/core/SkMaskFilter.h',
        '../third_party/skia/include/core/SkMath.h',
        '../third_party/skia/include/core/SkMatrix.h',
        '../third_party/skia/include/core/SkOSFile.h',
        '../third_party/skia/include/core/SkPackBits.h',
        '../third_party/skia/include/core/SkPaint.h',
        '../third_party/skia/include/core/SkPath.h',
        '../third_party/skia/include/core/SkPathEffect.h',
        '../third_party/skia/include/core/SkPathMeasure.h',
        '../third_party/skia/include/core/SkPerspIter.h',
        '../third_party/skia/include/core/SkPicture.h',
        '../third_party/skia/include/core/SkPixelRef.h',
        '../third_party/skia/include/core/SkPoint.h',
        '../third_party/skia/include/core/SkPtrRecorder.h',
        '../third_party/skia/include/core/SkRandom.h',
        '../third_party/skia/include/core/SkRasterizer.h',
        '../third_party/skia/include/core/SkReader32.h',
        '../third_party/skia/include/core/SkRect.h',
        '../third_party/skia/include/core/SkRefCnt.h',
        '../third_party/skia/include/core/SkRefDict.h',
        '../third_party/skia/include/core/SkRegion.h',
        '../third_party/skia/include/core/SkScalar.h',
        '../third_party/skia/include/core/SkScalarCompare.h',
        '../third_party/skia/include/core/SkScalerContext.h',
        '../third_party/skia/include/core/SkScan.h',
        '../third_party/skia/include/core/SkShader.h',
        '../third_party/skia/include/core/SkStream.h',
        '../third_party/skia/include/core/SkString.h',
        '../third_party/skia/include/core/SkStroke.h',
        '../third_party/skia/include/core/SkTDArray.h',
        '../third_party/skia/include/core/SkTDStack.h',
        '../third_party/skia/include/core/SkTDict.h',
        '../third_party/skia/include/core/SkTRegistry.h',
        '../third_party/skia/include/core/SkTScopedPtr.h',
        '../third_party/skia/include/core/SkTSearch.h',
        '../third_party/skia/include/core/SkTemplates.h',
        '../third_party/skia/include/core/SkThread.h',
        '../third_party/skia/include/core/SkThread_platform.h',
        '../third_party/skia/include/core/SkTime.h',
        '../third_party/skia/include/core/SkTypeface.h',
        '../third_party/skia/include/core/SkTypes.h',
        '../third_party/skia/include/core/SkUnPreMultiply.h',
        '../third_party/skia/include/core/SkUnitMapper.h',
        '../third_party/skia/include/core/SkUtils.h',
        '../third_party/skia/include/core/SkWriter32.h',
        '../third_party/skia/include/core/SkXfermode.h',

        '../third_party/skia/include/effects/Sk1DPathEffect.h',
        '../third_party/skia/include/effects/Sk2DPathEffect.h',
        '../third_party/skia/include/effects/SkAvoidXfermode.h',
        '../third_party/skia/include/effects/SkBlurDrawLooper.h',
        '../third_party/skia/include/effects/SkBlurMaskFilter.h',
        '../third_party/skia/include/effects/SkColorMatrix.h',
        '../third_party/skia/include/effects/SkColorMatrixFilter.h',
        '../third_party/skia/include/effects/SkCornerPathEffect.h',
        '../third_party/skia/include/effects/SkDashPathEffect.h',
        '../third_party/skia/include/effects/SkDiscretePathEffect.h',
        '../third_party/skia/include/effects/SkDrawExtraPathEffect.h',
        '../third_party/skia/include/effects/SkEmbossMaskFilter.h',
        '../third_party/skia/include/effects/SkGradientShader.h',
        '../third_party/skia/include/effects/SkKernel33MaskFilter.h',
        '../third_party/skia/include/effects/SkLayerDrawLooper.h',
        '../third_party/skia/include/effects/SkLayerRasterizer.h',
        '../third_party/skia/include/effects/SkPaintFlagsDrawFilter.h',
        '../third_party/skia/include/effects/SkPixelXorXfermode.h',
        '../third_party/skia/include/effects/SkPorterDuff.h',
        '../third_party/skia/include/effects/SkTransparentShader.h',

        '../third_party/skia/include/gpu/SkGpuCanvas.h',
        '../third_party/skia/include/gpu/SkGpuDevice.h',
        '../third_party/skia/include/gpu/SkGr.h',
        '../third_party/skia/include/gpu/SkGrTexturePixelRef.h',

        '../third_party/skia/include/pdf/SkBitSet.h',
        '../third_party/skia/include/pdf/SkPDFCatalog.h',
        '../third_party/skia/include/pdf/SkPDFDevice.h',
        '../third_party/skia/include/pdf/SkPDFDocument.h',
        '../third_party/skia/include/pdf/SkPDFFont.h',
        '../third_party/skia/include/pdf/SkPDFFormXObject.h',
        '../third_party/skia/include/pdf/SkPDFGraphicState.h',
        '../third_party/skia/include/pdf/SkPDFImage.h',
        '../third_party/skia/include/pdf/SkPDFPage.h',
        '../third_party/skia/include/pdf/SkPDFShader.h',
        '../third_party/skia/include/pdf/SkPDFStream.h',
        '../third_party/skia/include/pdf/SkPDFTypes.h',
        '../third_party/skia/include/pdf/SkPDFUtils.h',

        '../third_party/skia/include/ports/SkStream_Win.h',
        '../third_party/skia/include/ports/SkTypeface_win.h',

        '../third_party/skia/include/images/SkFlipPixelRef.h',
        '../third_party/skia/include/images/SkImageDecoder.h',
        '../third_party/skia/include/images/SkImageEncoder.h',
        '../third_party/skia/include/images/SkImageRef.h',
        '../third_party/skia/include/images/SkImageRef_GlobalPool.h',
        '../third_party/skia/include/images/SkMovie.h',
        '../third_party/skia/include/images/SkPageFlipper.h',

        'ext/bitmap_platform_device.cc',
        'ext/bitmap_platform_device.h',
        'ext/bitmap_platform_device_data.h',
        'ext/bitmap_platform_device_linux.cc',
        'ext/bitmap_platform_device_linux.h',
        'ext/bitmap_platform_device_mac.cc',
        'ext/bitmap_platform_device_mac.h',
        'ext/bitmap_platform_device_win.cc',
        'ext/bitmap_platform_device_win.h',
        'ext/convolver.cc',
        'ext/convolver.h',
        'ext/google_logging.cc',
        'ext/image_operations.cc',
        'ext/image_operations.h',
        'ext/SkThread_chrome.cc',
        'ext/platform_canvas.cc',
        'ext/platform_canvas.h',
        'ext/platform_canvas_linux.cc',
        'ext/platform_canvas_mac.cc',
        'ext/platform_canvas_win.cc',
        'ext/platform_device.cc',
        'ext/platform_device.h',
        'ext/platform_device_linux.cc',
        'ext/platform_device_mac.cc',
        'ext/platform_device_win.cc',
        'ext/SkMemory_new_handler.cpp',
        'ext/skia_utils_mac.mm',
        'ext/skia_utils_mac.h',
        'ext/skia_utils_win.cc',
        'ext/skia_utils_win.h',
        'ext/vector_canvas.cc',
        'ext/vector_canvas.h',
        'ext/vector_platform_device_cairo_linux.cc',
        'ext/vector_platform_device_cairo_linux.h',
        'ext/vector_platform_device_emf_win.cc',
        'ext/vector_platform_device_emf_win.h',
        'ext/vector_platform_device_skia.cc',
        'ext/vector_platform_device_skia.h',
      ],
      'include_dirs': [
        '..',
        'config',
        '../third_party/skia/include/config',
        '../third_party/skia/include/core',
        '../third_party/skia/include/effects',
        '../third_party/skia/include/gpu',
        '../third_party/skia/include/images',
        '../third_party/skia/include/pdf',
        '../third_party/skia/include/ports',
        '../third_party/skia/include/utils',
        '../third_party/skia/gpu/include',
        '../third_party/skia/gpu/src',
        '../third_party/skia/src/core',
      ],
      'msvs_disabled_warnings': [4244, 4267,4345, 4390, 4554, 4800],
      'mac_framework_dirs': [
        '$(SDKROOT)/System/Library/Frameworks/ApplicationServices.framework/Frameworks',
      ],
      'defines': [
        'SK_BUILD_NO_IMAGE_ENCODE',
        'GR_GL_CUSTOM_SETUP_HEADER="GrGLConfig_chrome.h"',
        'GR_STATIC_RECT_VB=1',
        'GR_AGGRESSIVE_SHADER_OPTS=1',
        'SK_DISABLE_FAST_AA_STROKE_RECT',
        'SK_IGNORE_CF_OPTIMIZATION',
        'SK_BLUR_MASK_FILTER_IGNORE_MARGIN_FIX',
      ],
      'sources!': [
        '../third_party/skia/include/core/SkTypes.h',
      ],
      'conditions': [
        [ 'OS != "mac"', {
          'sources/': [
            ['exclude', '_mac\\.(cc|cpp|mm?)$'],
            ['exclude', '/mac/']
          ],
          'sources': [
            '../third_party/skia/include/utils/SkMatrix44.h',
            '../third_party/skia/src/utils/SkMatrix44.cpp',
          ],
        }],
        [ 'toolkit_uses_gtk == 0', {
          'sources/': [ ['exclude', '_(linux|gtk)\\.(cc|cpp)$'] ],
          'sources!': [
            '../third_party/skia/src/ports/SkFontHost_FreeType.cpp',
            '../third_party/skia/src/ports/SkFontHost_TryeType_Tables.cpp',
            '../third_party/skia/src/ports/SkFontHost_gamma_none.cpp',
            '../third_party/skia/src/ports/SkFontHost_gamma_none.cpp',
            '../third_party/skia/src/ports/SkFontHost_tables.cpp',
          ],
        }],
        [ 'OS != "win"', {
          'sources/': [ ['exclude', '_win\\.(cc|cpp)$'] ],
        }],
        [ 'armv7 == 1', {
          'defines': [
            '__ARM_ARCH__=7',
          ],
        }],
        [ 'armv7 == 1 and arm_neon == 1', {
          'defines': [
            '__ARM_HAVE_NEON',
          ],
        }],
        [ 'target_arch == "arm"', {
          'sources!': [
            '../third_party/skia/src/opts/opts_check_SSE2.cpp'
          ],
        }],
        [ 'toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:gdk',
            '../build/linux/system.gyp:fontconfig',
            '../build/linux/system.gyp:freetype2',
            '../third_party/harfbuzz/harfbuzz.gyp:harfbuzz',
            '../third_party/icu/icu.gyp:icuuc',
          ],
          'cflags': [
            '-Wno-unused',
            '-Wno-unused-function',
          ],
          'sources': [
            'ext/SkFontHost_fontconfig.cpp',
            'ext/SkFontHost_fontconfig_direct.cpp',
          ],
        }],
        [ 'OS == "mac"', {
          'defines': [
            'SK_BUILD_FOR_MAC',
          ],
          'include_dirs': [
            '../third_party/skia/include/utils/mac',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/AppKit.framework',
            ],
          },
          'conditions': [
             [ 'use_skia == 0', {
               'sources/': [
                 ['exclude', '/pdf/'],
                 ['exclude', 'ext/vector_platform_device_skia\\.(cc|h)'],
               ],
            },
            { # use_skia
              'defines': [
                'SK_SUPPORT_888_TEXT',
                'SK_USE_MAC_CORE_TEXT',
              ],
            }],
          ],
        }],
        [ 'OS == "win"', {
          'sources!': [
            '../third_party/skia/src/core/SkMMapStream.cpp',
            '../third_party/skia/src/ports/SkTime_Unix.cpp',
            'ext/SkThread_chrome.cc',
          ],
          'include_dirs': [
            'config/win',
          ],
          'direct_dependent_settings': {
            'include_dirs': [
              'config/win',
            ],
          },
        },],
        ['component=="shared_library"', {
          'defines': [
            'GR_DLL=1',
            'GR_IMPLEMENTATION=1',
            'SKIA_DLL',
            'SKIA_IMPLEMENTATION=1',
          ],
          'dependencies': [
            '../base/base.gyp:base',
          ],
          'direct_dependent_settings': {
            'defines': [
              'GR_DLL',
              'SKIA_DLL',
            ],
          },
        },],
      ],
      'dependencies': [
        'skia_opts',
        'skia_libtess',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../third_party/sfntly/sfntly.gyp:sfntly',
        '../third_party/zlib/zlib.gyp:zlib',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          'config',
          '../third_party/skia/include/config',
          '../third_party/skia/include/core',
          '../third_party/skia/include/effects',
          '../third_party/skia/include/pdf',
          '../third_party/skia/include/gpu',
          '../third_party/skia/include/ports',
          '../third_party/skia/gpu/include',
          'ext',
        ],
        'mac_framework_dirs': [
          '$(SDKROOT)/System/Library/Frameworks/ApplicationServices.framework/Frameworks',
        ],
        'defines': [
          'SK_BUILD_NO_IMAGE_ENCODE',
          'GR_GL_CUSTOM_SETUP_HEADER="GrGLConfig_chrome.h"',
          'GR_AGGRESSIVE_SHADER_OPTS=1',
        ],
      },
    },

    # Due to an unfortunate intersection of lameness between gcc and gyp,
    # we have to build the *_SSE2.cpp files in a separate target.  The
    # gcc lameness is that, in order to compile SSE2 intrinsics code, it
    # must be passed the -msse2 flag.  However, with this flag, it may
    # emit SSE2 instructions even for scalar code, such as the CPUID
    # test used to test for the presence of SSE2.  So that, and all other
    # code must be compiled *without* -msse2.  The gyp lameness is that it
    # does not allow file-specific CFLAGS, so we must create this extra
    # target for those files to be compiled with -msse2.
    #
    # This is actually only a problem on 32-bit Linux (all Intel Macs have
    # SSE2, Linux x86_64 has SSE2 by definition, and MSC will happily emit
    # SSE2 from instrinsics, which generating plain ol' 386 for everything
    # else).  However, to keep the .gyp file simple and avoid platform-specific
    # build breakage, we do this on all platforms.

    # For about the same reason, we need to compile the ARM opts files
    # separately as well.
    {
      'target_name': 'skia_opts',
      'type': 'static_library',
      'include_dirs': [
        '..',
        'config',
        '../third_party/skia/include/config',
        '../third_party/skia/include/core',
        '../third_party/skia/include/effects',
        '../third_party/skia/include/images',
        '../third_party/skia/include/utils',
        '../third_party/skia/src/core',
      ],
      'conditions': [
        [ 'os_posix == 1 and OS != "mac" and target_arch != "arm"', {
          'cflags': [
            '-msse2',
          ],
        }],
        [ 'target_arch != "arm"', {
          'sources': [
            '../third_party/skia/src/opts/SkBitmapProcState_opts_SSE2.cpp',
            '../third_party/skia/src/opts/SkBlitRow_opts_SSE2.cpp',
            '../third_party/skia/src/opts/SkUtils_opts_SSE2.cpp',
          ],
        },
        {  # arm
          'conditions': [
            [ 'armv7 == 1', {
              'defines': [
                '__ARM_ARCH__=7',
              ],
            }],
            [ 'armv7 == 1 and arm_neon == 1', {
              'defines': [
                '__ARM_HAVE_NEON',
              ],
              'cflags': [
                # The neon assembly contains conditional instructions which
                # aren't enclosed in an IT block. The assembler complains
                # without this option.
                # See #86592.
                '-Wa,-mimplicit-it=always',
              ],
           }],
          ],
          # The assembly uses the frame pointer register (r7 in Thumb/r11 in
          # ARM), the compiler doesn't like that.
          'cflags': [
            '-fomit-frame-pointer',
          ],
          'sources': [
            '../third_party/skia/src/opts/SkBitmapProcState_opts_arm.cpp',
            '../third_party/skia/src/opts/SkBlitRow_opts_arm.cpp',
            '../third_party/skia/src/opts/SkUtils_opts_none.cpp',
          ],
        }],
      ],
    },
    {
      'target_name': 'skia_libtess',
      'type': 'static_library',
      'include_dirs': [
        '../third_party/skia/third_party/glu',
      ],
      'sources': [
        '../third_party/skia/third_party/glu/sk_glu.h',
        '../third_party/skia/third_party/glu/gluos.h',
        '../third_party/skia/third_party/glu/libtess/dict-list.h',
        '../third_party/skia/third_party/glu/libtess/dict.c',
        '../third_party/skia/third_party/glu/libtess/dict.h',
        '../third_party/skia/third_party/glu/libtess/geom.c',
        '../third_party/skia/third_party/glu/libtess/geom.h',
        '../third_party/skia/third_party/glu/libtess/memalloc.c',
        '../third_party/skia/third_party/glu/libtess/memalloc.h',
        '../third_party/skia/third_party/glu/libtess/mesh.c',
        '../third_party/skia/third_party/glu/libtess/mesh.h',
        '../third_party/skia/third_party/glu/libtess/normal.c',
        '../third_party/skia/third_party/glu/libtess/normal.h',
        '../third_party/skia/third_party/glu/libtess/priorityq-heap.h',
        '../third_party/skia/third_party/glu/libtess/priorityq-sort.h',
        '../third_party/skia/third_party/glu/libtess/priorityq.c',
        '../third_party/skia/third_party/glu/libtess/priorityq.h',
        '../third_party/skia/third_party/glu/libtess/render.c',
        '../third_party/skia/third_party/glu/libtess/render.h',
        '../third_party/skia/third_party/glu/libtess/sweep.c',
        '../third_party/skia/third_party/glu/libtess/sweep.h',
        '../third_party/skia/third_party/glu/libtess/tess.c',
        '../third_party/skia/third_party/glu/libtess/tess.h',
        '../third_party/skia/third_party/glu/libtess/tessmono.c',
        '../third_party/skia/third_party/glu/libtess/tessmono.h',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '../third_party/skia/third_party/glu',
        ],
      },
    },
    {
      'target_name': 'image_operations_bench',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        'skia',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'ext/image_operations_bench.cc',
      ],
    },
  ],
}
