{
  'variables': {
    'chromium_code': 1,
    'chrome_grit_out_dir': '<(SHARED_INTERMEDIATE_DIR)/chrome',
    'webkit_grit_out_dir': '<(SHARED_INTERMEDIATE_DIR)/webkit',

    'ui_grit_out_dir': '<(SHARED_INTERMEDIATE_DIR)/ui',
    'ui_strings_out_dir': '<(ui_grit_out_dir)/ui_strings',
    'app_locale_out_dir': '<(ui_grit_out_dir)/app_locale_settings',

    # TODO(sgk): eliminate this; see comment in build/common.gypi
    'msvs_debug_link_incremental': '1',

    # Decide which .rc file to use for strings based on branding
    'conditions': [
      ['branding=="Chrome"', {
        'strings_rc_name': 'strings_google_chrome',
      }, {
        'strings_rc_name': 'strings',
      }],
    ],
  },
  'target_defaults': {
    'type': 'loadable_module',
    'dependencies': [
      '../../chrome.gyp:chrome_strings',
      '../../chrome.gyp:platform_locale_settings',
      '../../../ui/base/strings/ui_strings.gyp:ui_strings',
      '../../../webkit/support/webkit_support.gyp:webkit_strings',
    ],
    'msvs_settings': {
      'VCLinkerTool': {
        'BaseAddress': '0x3CF00000',
        'OutputFile': '$(OutDir)\\locales\\$(ProjectName).dll',
        'LinkIncremental': '1',  # 1 == No
        'LinkTimeCodeGeneration': '0',
        'ResourceOnlyDLL': 'true',
      },
    },
    'defines': [
      '_USRDLL',
      'GENERATED_RESOURCES_DLL_EXPORTS',
    ],
    'include_dirs': [
      '<(chrome_grit_out_dir)',
    ],
  },
  'conditions': [
    ['OS=="win"', {
      'targets': [
        {
          'target_name': 'am',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_am.rc',
            '<(chrome_grit_out_dir)/generated_resources_am.rc',
            '<(chrome_grit_out_dir)/locale_settings_am.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_am.rc',
            '<(webkit_grit_out_dir)/webkit_strings_am.rc',
            '<(ui_strings_out_dir)/ui_strings_am.rc',
            '<(app_locale_out_dir)/app_locale_settings_am.rc',
          ],
        },
        {
          'target_name': 'ar',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ar.rc',
            '<(chrome_grit_out_dir)/generated_resources_ar.rc',
            '<(chrome_grit_out_dir)/locale_settings_ar.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ar.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ar.rc',
            '<(ui_strings_out_dir)/ui_strings_ar.rc',
            '<(app_locale_out_dir)/app_locale_settings_ar.rc',
          ],
        },
        {
          'target_name': 'bg',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_bg.rc',
            '<(chrome_grit_out_dir)/generated_resources_bg.rc',
            '<(chrome_grit_out_dir)/locale_settings_bg.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_bg.rc',
            '<(webkit_grit_out_dir)/webkit_strings_bg.rc',
            '<(ui_strings_out_dir)/ui_strings_bg.rc',
            '<(app_locale_out_dir)/app_locale_settings_bg.rc',
          ],
        },
        {
          'target_name': 'bn',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_bn.rc',
            '<(chrome_grit_out_dir)/generated_resources_bn.rc',
            '<(chrome_grit_out_dir)/locale_settings_bn.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_bn.rc',
            '<(webkit_grit_out_dir)/webkit_strings_bn.rc',
            '<(ui_strings_out_dir)/ui_strings_bn.rc',
            '<(app_locale_out_dir)/app_locale_settings_bn.rc',
          ],
        },
        {
          'target_name': 'ca',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ca.rc',
            '<(chrome_grit_out_dir)/generated_resources_ca.rc',
            '<(chrome_grit_out_dir)/locale_settings_ca.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ca.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ca.rc',
            '<(ui_strings_out_dir)/ui_strings_ca.rc',
            '<(app_locale_out_dir)/app_locale_settings_ca.rc',
          ],
        },
        {
          'target_name': 'cs',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_cs.rc',
            '<(chrome_grit_out_dir)/generated_resources_cs.rc',
            '<(chrome_grit_out_dir)/locale_settings_cs.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_cs.rc',
            '<(webkit_grit_out_dir)/webkit_strings_cs.rc',
            '<(ui_strings_out_dir)/ui_strings_cs.rc',
            '<(app_locale_out_dir)/app_locale_settings_cs.rc',
          ],
        },
        {
          'target_name': 'da',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_da.rc',
            '<(chrome_grit_out_dir)/generated_resources_da.rc',
            '<(chrome_grit_out_dir)/locale_settings_da.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_da.rc',
            '<(webkit_grit_out_dir)/webkit_strings_da.rc',
            '<(ui_strings_out_dir)/ui_strings_da.rc',
            '<(app_locale_out_dir)/app_locale_settings_da.rc',
          ],
        },
        {
          'target_name': 'de',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_de.rc',
            '<(chrome_grit_out_dir)/generated_resources_de.rc',
            '<(chrome_grit_out_dir)/locale_settings_de.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_de.rc',
            '<(webkit_grit_out_dir)/webkit_strings_de.rc',
            '<(ui_strings_out_dir)/ui_strings_de.rc',
            '<(app_locale_out_dir)/app_locale_settings_de.rc',
          ],
        },
        {
          'target_name': 'el',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_el.rc',
            '<(chrome_grit_out_dir)/generated_resources_el.rc',
            '<(chrome_grit_out_dir)/locale_settings_el.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_el.rc',
            '<(webkit_grit_out_dir)/webkit_strings_el.rc',
            '<(ui_strings_out_dir)/ui_strings_el.rc',
            '<(app_locale_out_dir)/app_locale_settings_el.rc',
          ],
        },
        {
          'target_name': 'en-GB',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_en-GB.rc',
            '<(chrome_grit_out_dir)/generated_resources_en-GB.rc',
            '<(chrome_grit_out_dir)/locale_settings_en-GB.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_en-GB.rc',
            '<(webkit_grit_out_dir)/webkit_strings_en-GB.rc',
            '<(ui_strings_out_dir)/ui_strings_en-GB.rc',
            '<(app_locale_out_dir)/app_locale_settings_en-GB.rc',
          ],
        },
        {
          'target_name': 'en-US',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_en-US.rc',
            '<(chrome_grit_out_dir)/generated_resources_en-US.rc',
            '<(chrome_grit_out_dir)/locale_settings_en-US.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_en-US.rc',
            '<(webkit_grit_out_dir)/webkit_strings_en-US.rc',
            '<(ui_strings_out_dir)/ui_strings_en-US.rc',
            '<(app_locale_out_dir)/app_locale_settings_en-US.rc',
          ],
        },
        {
          'target_name': 'es-419',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_es-419.rc',
            '<(chrome_grit_out_dir)/generated_resources_es-419.rc',
            '<(chrome_grit_out_dir)/locale_settings_es-419.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_es-419.rc',
            '<(webkit_grit_out_dir)/webkit_strings_es-419.rc',
            '<(ui_strings_out_dir)/ui_strings_es-419.rc',
            '<(app_locale_out_dir)/app_locale_settings_es-419.rc',
          ],
        },
        {
          'target_name': 'es',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_es.rc',
            '<(chrome_grit_out_dir)/generated_resources_es.rc',
            '<(chrome_grit_out_dir)/locale_settings_es.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_es.rc',
            '<(webkit_grit_out_dir)/webkit_strings_es.rc',
            '<(ui_strings_out_dir)/ui_strings_es.rc',
            '<(app_locale_out_dir)/app_locale_settings_es.rc',
          ],
        },
        {
          'target_name': 'et',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_et.rc',
            '<(chrome_grit_out_dir)/generated_resources_et.rc',
            '<(chrome_grit_out_dir)/locale_settings_et.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_et.rc',
            '<(webkit_grit_out_dir)/webkit_strings_et.rc',
            '<(ui_strings_out_dir)/ui_strings_et.rc',
            '<(app_locale_out_dir)/app_locale_settings_et.rc',
          ],
        },
        {
          'target_name': 'fa',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_fa.rc',
            '<(chrome_grit_out_dir)/generated_resources_fa.rc',
            '<(chrome_grit_out_dir)/locale_settings_fa.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_fa.rc',
            '<(webkit_grit_out_dir)/webkit_strings_fa.rc',
            '<(ui_strings_out_dir)/ui_strings_fa.rc',
            '<(app_locale_out_dir)/app_locale_settings_fa.rc',
          ],
        },
        {
          'target_name': 'fi',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_fi.rc',
            '<(chrome_grit_out_dir)/generated_resources_fi.rc',
            '<(chrome_grit_out_dir)/locale_settings_fi.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_fi.rc',
            '<(webkit_grit_out_dir)/webkit_strings_fi.rc',
            '<(ui_strings_out_dir)/ui_strings_fi.rc',
            '<(app_locale_out_dir)/app_locale_settings_fi.rc',
          ],
        },
        {
          'target_name': 'fil',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_fil.rc',
            '<(chrome_grit_out_dir)/generated_resources_fil.rc',
            '<(chrome_grit_out_dir)/locale_settings_fil.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_fil.rc',
            '<(webkit_grit_out_dir)/webkit_strings_fil.rc',
            '<(ui_strings_out_dir)/ui_strings_fil.rc',
            '<(app_locale_out_dir)/app_locale_settings_fil.rc',
          ],
        },
        {
          'target_name': 'fr',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_fr.rc',
            '<(chrome_grit_out_dir)/generated_resources_fr.rc',
            '<(chrome_grit_out_dir)/locale_settings_fr.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_fr.rc',
            '<(webkit_grit_out_dir)/webkit_strings_fr.rc',
            '<(ui_strings_out_dir)/ui_strings_fr.rc',
            '<(app_locale_out_dir)/app_locale_settings_fr.rc',
          ],
        },
        {
          'target_name': 'gu',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_gu.rc',
            '<(chrome_grit_out_dir)/generated_resources_gu.rc',
            '<(chrome_grit_out_dir)/locale_settings_gu.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_gu.rc',
            '<(webkit_grit_out_dir)/webkit_strings_gu.rc',
            '<(ui_strings_out_dir)/ui_strings_gu.rc',
            '<(app_locale_out_dir)/app_locale_settings_gu.rc',
          ],
        },
        {
          'target_name': 'he',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_he.rc',
            '<(chrome_grit_out_dir)/generated_resources_he.rc',
            '<(chrome_grit_out_dir)/locale_settings_he.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_he.rc',
            '<(webkit_grit_out_dir)/webkit_strings_he.rc',
            '<(ui_strings_out_dir)/ui_strings_he.rc',
            '<(app_locale_out_dir)/app_locale_settings_he.rc',
          ],
        },
        {
          'target_name': 'hi',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_hi.rc',
            '<(chrome_grit_out_dir)/generated_resources_hi.rc',
            '<(chrome_grit_out_dir)/locale_settings_hi.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_hi.rc',
            '<(webkit_grit_out_dir)/webkit_strings_hi.rc',
            '<(ui_strings_out_dir)/ui_strings_hi.rc',
            '<(app_locale_out_dir)/app_locale_settings_hi.rc',
          ],
        },
        {
          'target_name': 'hr',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_hr.rc',
            '<(chrome_grit_out_dir)/generated_resources_hr.rc',
            '<(chrome_grit_out_dir)/locale_settings_hr.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_hr.rc',
            '<(webkit_grit_out_dir)/webkit_strings_hr.rc',
            '<(ui_strings_out_dir)/ui_strings_hr.rc',
            '<(app_locale_out_dir)/app_locale_settings_hr.rc',
          ],
        },
        {
          'target_name': 'hu',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_hu.rc',
            '<(chrome_grit_out_dir)/generated_resources_hu.rc',
            '<(chrome_grit_out_dir)/locale_settings_hu.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_hu.rc',
            '<(webkit_grit_out_dir)/webkit_strings_hu.rc',
            '<(ui_strings_out_dir)/ui_strings_hu.rc',
            '<(app_locale_out_dir)/app_locale_settings_hu.rc',
          ],
        },
        {
          'target_name': 'id',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_id.rc',
            '<(chrome_grit_out_dir)/generated_resources_id.rc',
            '<(chrome_grit_out_dir)/locale_settings_id.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_id.rc',
            '<(webkit_grit_out_dir)/webkit_strings_id.rc',
            '<(ui_strings_out_dir)/ui_strings_id.rc',
            '<(app_locale_out_dir)/app_locale_settings_id.rc',
          ],
        },
        {
          'target_name': 'it',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_it.rc',
            '<(chrome_grit_out_dir)/generated_resources_it.rc',
            '<(chrome_grit_out_dir)/locale_settings_it.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_it.rc',
            '<(webkit_grit_out_dir)/webkit_strings_it.rc',
            '<(ui_strings_out_dir)/ui_strings_it.rc',
            '<(app_locale_out_dir)/app_locale_settings_it.rc',
          ],
        },
        {
          'target_name': 'ja',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ja.rc',
            '<(chrome_grit_out_dir)/generated_resources_ja.rc',
            '<(chrome_grit_out_dir)/locale_settings_ja.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ja.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ja.rc',
            '<(ui_strings_out_dir)/ui_strings_ja.rc',
            '<(app_locale_out_dir)/app_locale_settings_ja.rc',
          ],
        },
        {
          'target_name': 'kn',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_kn.rc',
            '<(chrome_grit_out_dir)/generated_resources_kn.rc',
            '<(chrome_grit_out_dir)/locale_settings_kn.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_kn.rc',
            '<(webkit_grit_out_dir)/webkit_strings_kn.rc',
            '<(ui_strings_out_dir)/ui_strings_kn.rc',
            '<(app_locale_out_dir)/app_locale_settings_kn.rc',
          ],
        },
        {
          'target_name': 'ko',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ko.rc',
            '<(chrome_grit_out_dir)/generated_resources_ko.rc',
            '<(chrome_grit_out_dir)/locale_settings_ko.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ko.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ko.rc',
            '<(ui_strings_out_dir)/ui_strings_ko.rc',
            '<(app_locale_out_dir)/app_locale_settings_ko.rc',
          ],
        },
        {
          'target_name': 'lt',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_lt.rc',
            '<(chrome_grit_out_dir)/generated_resources_lt.rc',
            '<(chrome_grit_out_dir)/locale_settings_lt.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_lt.rc',
            '<(webkit_grit_out_dir)/webkit_strings_lt.rc',
            '<(ui_strings_out_dir)/ui_strings_lt.rc',
            '<(app_locale_out_dir)/app_locale_settings_lt.rc',
          ],
        },
        {
          'target_name': 'lv',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_lv.rc',
            '<(chrome_grit_out_dir)/generated_resources_lv.rc',
            '<(chrome_grit_out_dir)/locale_settings_lv.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_lv.rc',
            '<(webkit_grit_out_dir)/webkit_strings_lv.rc',
            '<(ui_strings_out_dir)/ui_strings_lv.rc',
            '<(app_locale_out_dir)/app_locale_settings_lv.rc',
          ],
        },
        {
          'target_name': 'ml',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ml.rc',
            '<(chrome_grit_out_dir)/generated_resources_ml.rc',
            '<(chrome_grit_out_dir)/locale_settings_ml.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ml.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ml.rc',
            '<(ui_strings_out_dir)/ui_strings_ml.rc',
            '<(app_locale_out_dir)/app_locale_settings_ml.rc',
          ],
        },
        {
          'target_name': 'mr',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_mr.rc',
            '<(chrome_grit_out_dir)/generated_resources_mr.rc',
            '<(chrome_grit_out_dir)/locale_settings_mr.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_mr.rc',
            '<(webkit_grit_out_dir)/webkit_strings_mr.rc',
            '<(ui_strings_out_dir)/ui_strings_mr.rc',
            '<(app_locale_out_dir)/app_locale_settings_mr.rc',
          ],
        },
        {
          'target_name': 'nb',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_nb.rc',
            '<(chrome_grit_out_dir)/generated_resources_nb.rc',
            '<(chrome_grit_out_dir)/locale_settings_nb.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_nb.rc',
            '<(webkit_grit_out_dir)/webkit_strings_nb.rc',
            '<(ui_strings_out_dir)/ui_strings_nb.rc',
            '<(app_locale_out_dir)/app_locale_settings_nb.rc',
          ],
        },
        {
          'target_name': 'nl',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_nl.rc',
            '<(chrome_grit_out_dir)/generated_resources_nl.rc',
            '<(chrome_grit_out_dir)/locale_settings_nl.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_nl.rc',
            '<(webkit_grit_out_dir)/webkit_strings_nl.rc',
            '<(ui_strings_out_dir)/ui_strings_nl.rc',
            '<(app_locale_out_dir)/app_locale_settings_nl.rc',
          ],
        },
        {
          'target_name': 'pl',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_pl.rc',
            '<(chrome_grit_out_dir)/generated_resources_pl.rc',
            '<(chrome_grit_out_dir)/locale_settings_pl.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_pl.rc',
            '<(webkit_grit_out_dir)/webkit_strings_pl.rc',
            '<(ui_strings_out_dir)/ui_strings_pl.rc',
            '<(app_locale_out_dir)/app_locale_settings_pl.rc',
          ],
        },
        {
          'target_name': 'pt-BR',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_pt-BR.rc',
            '<(chrome_grit_out_dir)/generated_resources_pt-BR.rc',
            '<(chrome_grit_out_dir)/locale_settings_pt-BR.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_pt-BR.rc',
            '<(webkit_grit_out_dir)/webkit_strings_pt-BR.rc',
            '<(ui_strings_out_dir)/ui_strings_pt-BR.rc',
            '<(app_locale_out_dir)/app_locale_settings_pt-BR.rc',
          ],
        },
        {
          'target_name': 'pt-PT',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_pt-PT.rc',
            '<(chrome_grit_out_dir)/generated_resources_pt-PT.rc',
            '<(chrome_grit_out_dir)/locale_settings_pt-PT.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_pt-PT.rc',
            '<(webkit_grit_out_dir)/webkit_strings_pt-PT.rc',
            '<(ui_strings_out_dir)/ui_strings_pt-PT.rc',
            '<(app_locale_out_dir)/app_locale_settings_pt-PT.rc',
          ],
        },
        {
          'target_name': 'ro',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ro.rc',
            '<(chrome_grit_out_dir)/generated_resources_ro.rc',
            '<(chrome_grit_out_dir)/locale_settings_ro.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ro.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ro.rc',
            '<(ui_strings_out_dir)/ui_strings_ro.rc',
            '<(app_locale_out_dir)/app_locale_settings_ro.rc',
          ],
        },
        {
          'target_name': 'ru',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ru.rc',
            '<(chrome_grit_out_dir)/generated_resources_ru.rc',
            '<(chrome_grit_out_dir)/locale_settings_ru.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ru.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ru.rc',
            '<(ui_strings_out_dir)/ui_strings_ru.rc',
            '<(app_locale_out_dir)/app_locale_settings_ru.rc',
          ],
        },
        {
          'target_name': 'sk',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_sk.rc',
            '<(chrome_grit_out_dir)/generated_resources_sk.rc',
            '<(chrome_grit_out_dir)/locale_settings_sk.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_sk.rc',
            '<(webkit_grit_out_dir)/webkit_strings_sk.rc',
            '<(ui_strings_out_dir)/ui_strings_sk.rc',
            '<(app_locale_out_dir)/app_locale_settings_sk.rc',
          ],
        },
        {
          'target_name': 'sl',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_sl.rc',
            '<(chrome_grit_out_dir)/generated_resources_sl.rc',
            '<(chrome_grit_out_dir)/locale_settings_sl.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_sl.rc',
            '<(webkit_grit_out_dir)/webkit_strings_sl.rc',
            '<(ui_strings_out_dir)/ui_strings_sl.rc',
            '<(app_locale_out_dir)/app_locale_settings_sl.rc',
          ],
        },
        {
          'target_name': 'sr',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_sr.rc',
            '<(chrome_grit_out_dir)/generated_resources_sr.rc',
            '<(chrome_grit_out_dir)/locale_settings_sr.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_sr.rc',
            '<(webkit_grit_out_dir)/webkit_strings_sr.rc',
            '<(ui_strings_out_dir)/ui_strings_sr.rc',
            '<(app_locale_out_dir)/app_locale_settings_sr.rc',
          ],
        },
        {
          'target_name': 'sv',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_sv.rc',
            '<(chrome_grit_out_dir)/generated_resources_sv.rc',
            '<(chrome_grit_out_dir)/locale_settings_sv.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_sv.rc',
            '<(webkit_grit_out_dir)/webkit_strings_sv.rc',
            '<(ui_strings_out_dir)/ui_strings_sv.rc',
            '<(app_locale_out_dir)/app_locale_settings_sv.rc',
          ],
        },
        {
          'target_name': 'sw',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_sw.rc',
            '<(chrome_grit_out_dir)/generated_resources_sw.rc',
            '<(chrome_grit_out_dir)/locale_settings_sw.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_sw.rc',
            '<(webkit_grit_out_dir)/webkit_strings_sw.rc',
            '<(ui_strings_out_dir)/ui_strings_sw.rc',
            '<(app_locale_out_dir)/app_locale_settings_sw.rc',
          ],
        },
        {
          'target_name': 'ta',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_ta.rc',
            '<(chrome_grit_out_dir)/generated_resources_ta.rc',
            '<(chrome_grit_out_dir)/locale_settings_ta.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_ta.rc',
            '<(webkit_grit_out_dir)/webkit_strings_ta.rc',
            '<(ui_strings_out_dir)/ui_strings_ta.rc',
            '<(app_locale_out_dir)/app_locale_settings_ta.rc',
          ],
        },
        {
          'target_name': 'te',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_te.rc',
            '<(chrome_grit_out_dir)/generated_resources_te.rc',
            '<(chrome_grit_out_dir)/locale_settings_te.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_te.rc',
            '<(webkit_grit_out_dir)/webkit_strings_te.rc',
            '<(ui_strings_out_dir)/ui_strings_te.rc',
            '<(app_locale_out_dir)/app_locale_settings_te.rc',
          ],
        },
        {
          'target_name': 'th',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_th.rc',
            '<(chrome_grit_out_dir)/generated_resources_th.rc',
            '<(chrome_grit_out_dir)/locale_settings_th.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_th.rc',
            '<(webkit_grit_out_dir)/webkit_strings_th.rc',
            '<(ui_strings_out_dir)/ui_strings_th.rc',
            '<(app_locale_out_dir)/app_locale_settings_th.rc',
          ],
        },
        {
          'target_name': 'tr',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_tr.rc',
            '<(chrome_grit_out_dir)/generated_resources_tr.rc',
            '<(chrome_grit_out_dir)/locale_settings_tr.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_tr.rc',
            '<(webkit_grit_out_dir)/webkit_strings_tr.rc',
            '<(ui_strings_out_dir)/ui_strings_tr.rc',
            '<(app_locale_out_dir)/app_locale_settings_tr.rc',
          ],
        },
        {
          'target_name': 'uk',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_uk.rc',
            '<(chrome_grit_out_dir)/generated_resources_uk.rc',
            '<(chrome_grit_out_dir)/locale_settings_uk.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_uk.rc',
            '<(webkit_grit_out_dir)/webkit_strings_uk.rc',
            '<(ui_strings_out_dir)/ui_strings_uk.rc',
            '<(app_locale_out_dir)/app_locale_settings_uk.rc',
          ],
        },
        {
          'target_name': 'vi',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_vi.rc',
            '<(chrome_grit_out_dir)/generated_resources_vi.rc',
            '<(chrome_grit_out_dir)/locale_settings_vi.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_vi.rc',
            '<(webkit_grit_out_dir)/webkit_strings_vi.rc',
            '<(ui_strings_out_dir)/ui_strings_vi.rc',
            '<(app_locale_out_dir)/app_locale_settings_vi.rc',
          ],
        },
        {
          'target_name': 'zh-CN',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_zh-CN.rc',
            '<(chrome_grit_out_dir)/generated_resources_zh-CN.rc',
            '<(chrome_grit_out_dir)/locale_settings_zh-CN.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_zh-CN.rc',
            '<(webkit_grit_out_dir)/webkit_strings_zh-CN.rc',
            '<(ui_strings_out_dir)/ui_strings_zh-CN.rc',
            '<(app_locale_out_dir)/app_locale_settings_zh-CN.rc',
          ],
        },
        {
          'target_name': 'zh-TW',
          'sources': [
            '<(chrome_grit_out_dir)/platform_locale_settings_zh-TW.rc',
            '<(chrome_grit_out_dir)/generated_resources_zh-TW.rc',
            '<(chrome_grit_out_dir)/locale_settings_zh-TW.rc',
            '<(chrome_grit_out_dir)/<(strings_rc_name)_zh-TW.rc',
            '<(webkit_grit_out_dir)/webkit_strings_zh-TW.rc',
            '<(ui_strings_out_dir)/ui_strings_zh-TW.rc',
            '<(app_locale_out_dir)/app_locale_settings_zh-TW.rc',
          ],
        },
      ],
    }],
  ],
}
