/*
 * Copyright (c) 2011 The Native Client Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/*
 * NaCl error codes.
 */

#ifndef SERVICE_RUNTIME_NACL_ERROR_CODE_H__
#define SERVICE_RUNTIME_NACL_ERROR_CODE_H__   1

#ifdef __cplusplus
extern "C" {
#endif

typedef enum NaClErrorCode {
  LOAD_OK,
  LOAD_STATUS_UNKNOWN,  /* load status not available yet */
  LOAD_UNSUPPORTED_OS_PLATFORM,
  LOAD_DEP_UNSUPPORTED,
  LOAD_INTERNAL,
  LOAD_DUP_LOAD_MODULE,
  LOAD_DUP_START_MODULE,
  LOAD_OPEN_ERROR,
  LOAD_READ_ERROR,
  LOAD_TOO_MANY_PROG_HDRS,
  LOAD_PROG_HDR_SIZE_TOO_SMALL,
  LOAD_BAD_ELF_MAGIC,
  LOAD_NOT_32_BIT,
  LOAD_NOT_64_BIT,
  LOAD_BAD_ABI,
  LOAD_NOT_EXEC,
  LOAD_BAD_MACHINE,
  LOAD_BAD_ELF_VERS,
  LOAD_TOO_MANY_SECT,
  LOAD_BAD_SECT,
  LOAD_NO_MEMORY,
  LOAD_SECT_HDR,
  LOAD_ADDR_SPACE_TOO_SMALL,
  LOAD_ADDR_SPACE_TOO_BIG,
  LOAD_DATA_OVERLAPS_STACK_SECTION,
  LOAD_RODATA_OVERLAPS_DATA,
  LOAD_DATA_NOT_LAST_SEGMENT,
  LOAD_NO_DATA_BUT_RODATA_NOT_LAST_SEGMENT,
  LOAD_TEXT_OVERLAPS_RODATA,
  LOAD_TEXT_OVERLAPS_DATA,
  LOAD_BAD_RODATA_ALIGNMENT,
  LOAD_BAD_DATA_ALIGNMENT,
  LOAD_UNLOADABLE,
  LOAD_BAD_ELF_TEXT,
  LOAD_TEXT_SEG_TOO_BIG,
  LOAD_DATA_SEG_TOO_BIG,
  LOAD_MPROTECT_FAIL,
  LOAD_MADVISE_FAIL,
  LOAD_TOO_MANY_SYMBOL_STR,
  LOAD_SYMTAB_ENTRY_TOO_SMALL,
  LOAD_NO_SYMTAB,
  LOAD_NO_SYMTAB_STRINGS,
  LOAD_SYMTAB_ENTRY,
  LOAD_UNKNOWN_SYMBOL_TYPE,
  LOAD_SYMTAB_DUP,
  LOAD_REL_ERROR,
  LOAD_REL_UNIMPL,
  LOAD_UNDEF_SYMBOL,
  LOAD_BAD_SYMBOL_DATA,
  LOAD_BAD_FILE,
  LOAD_BAD_ENTRY,
  LOAD_SEGMENT_OUTSIDE_ADDRSPACE,
  LOAD_DUP_SEGMENT,
  LOAD_SEGMENT_BAD_LOC,
  LOAD_BAD_SEGMENT,
  LOAD_REQUIRED_SEG_MISSING,
  LOAD_SEGMENT_BAD_PARAM,
  LOAD_VALIDATION_FAILED,
  LOAD_UNIMPLEMENTED,
  /*
   * service runtime errors (post load, during startup phase)
   */
  SRT_NO_SEG_SEL
} NaClErrorCode;
#define NACL_ERROR_CODE_MAX (SRT_NO_SEG_SEL+1)

char const  *NaClErrorString(NaClErrorCode  errcode);

#ifdef __cplusplus
}  /* end of extern "C" */
#endif

#endif
