// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is auto-generated. DO NOT EDIT!

#include "native_client/src/shared/ppapi_proxy/plugin_context_3d.h"

#include "gpu/command_buffer/client/gles2_implementation.h"
#include "ppapi/c/dev/ppb_opengles_dev.h"

using ppapi_proxy::PluginContext3D;
using ppapi_proxy::PluginResource;

namespace {

void ActiveTexture(PP_Resource context, GLenum texture) {
  PluginContext3D::implFromResource(context)->ActiveTexture(texture);
}
void AttachShader(PP_Resource context, GLuint program, GLuint shader) {
  PluginContext3D::implFromResource(context)->AttachShader(program, shader);
}
void BindAttribLocation(
    PP_Resource context, GLuint program, GLuint index, const char* name) {
  PluginContext3D::implFromResource(
      context)->BindAttribLocation(program, index, name);
}
void BindBuffer(PP_Resource context, GLenum target, GLuint buffer) {
  PluginContext3D::implFromResource(context)->BindBuffer(target, buffer);
}
void BindFramebuffer(PP_Resource context, GLenum target, GLuint framebuffer) {
  PluginContext3D::implFromResource(
      context)->BindFramebuffer(target, framebuffer);
}
void BindRenderbuffer(
    PP_Resource context, GLenum target, GLuint renderbuffer) {
  PluginContext3D::implFromResource(
      context)->BindRenderbuffer(target, renderbuffer);
}
void BindTexture(PP_Resource context, GLenum target, GLuint texture) {
  PluginContext3D::implFromResource(context)->BindTexture(target, texture);
}
void BlendColor(
    PP_Resource context, GLclampf red, GLclampf green, GLclampf blue,
    GLclampf alpha) {
  PluginContext3D::implFromResource(
      context)->BlendColor(red, green, blue, alpha);
}
void BlendEquation(PP_Resource context, GLenum mode) {
  PluginContext3D::implFromResource(context)->BlendEquation(mode);
}
void BlendEquationSeparate(
    PP_Resource context, GLenum modeRGB, GLenum modeAlpha) {
  PluginContext3D::implFromResource(
      context)->BlendEquationSeparate(modeRGB, modeAlpha);
}
void BlendFunc(PP_Resource context, GLenum sfactor, GLenum dfactor) {
  PluginContext3D::implFromResource(context)->BlendFunc(sfactor, dfactor);
}
void BlendFuncSeparate(
    PP_Resource context, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha,
    GLenum dstAlpha) {
  PluginContext3D::implFromResource(
      context)->BlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
}
void BufferData(
    PP_Resource context, GLenum target, GLsizeiptr size, const void* data,
    GLenum usage) {
  PluginContext3D::implFromResource(
      context)->BufferData(target, size, data, usage);
}
void BufferSubData(
    PP_Resource context, GLenum target, GLintptr offset, GLsizeiptr size,
    const void* data) {
  PluginContext3D::implFromResource(
      context)->BufferSubData(target, offset, size, data);
}
GLenum CheckFramebufferStatus(PP_Resource context, GLenum target) {
  return PluginContext3D::implFromResource(
      context)->CheckFramebufferStatus(target);
}
void Clear(PP_Resource context, GLbitfield mask) {
  PluginContext3D::implFromResource(context)->Clear(mask);
}
void ClearColor(
    PP_Resource context, GLclampf red, GLclampf green, GLclampf blue,
    GLclampf alpha) {
  PluginContext3D::implFromResource(
      context)->ClearColor(red, green, blue, alpha);
}
void ClearDepthf(PP_Resource context, GLclampf depth) {
  PluginContext3D::implFromResource(context)->ClearDepthf(depth);
}
void ClearStencil(PP_Resource context, GLint s) {
  PluginContext3D::implFromResource(context)->ClearStencil(s);
}
void ColorMask(
    PP_Resource context, GLboolean red, GLboolean green, GLboolean blue,
    GLboolean alpha) {
  PluginContext3D::implFromResource(
      context)->ColorMask(red, green, blue, alpha);
}
void CompileShader(PP_Resource context, GLuint shader) {
  PluginContext3D::implFromResource(context)->CompileShader(shader);
}
void CompressedTexImage2D(
    PP_Resource context, GLenum target, GLint level, GLenum internalformat,
    GLsizei width, GLsizei height, GLint border, GLsizei imageSize,
    const void* data) {
  PluginContext3D::implFromResource(
      context)->CompressedTexImage2D(
          target, level, internalformat, width, height, border, imageSize,
          data);
}
void CompressedTexSubImage2D(
    PP_Resource context, GLenum target, GLint level, GLint xoffset,
    GLint yoffset, GLsizei width, GLsizei height, GLenum format,
    GLsizei imageSize, const void* data) {
  PluginContext3D::implFromResource(
      context)->CompressedTexSubImage2D(
          target, level, xoffset, yoffset, width, height, format, imageSize,
          data);
}
void CopyTexImage2D(
    PP_Resource context, GLenum target, GLint level, GLenum internalformat,
    GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
  PluginContext3D::implFromResource(
      context)->CopyTexImage2D(
          target, level, internalformat, x, y, width, height, border);
}
void CopyTexSubImage2D(
    PP_Resource context, GLenum target, GLint level, GLint xoffset,
    GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
  PluginContext3D::implFromResource(
      context)->CopyTexSubImage2D(
          target, level, xoffset, yoffset, x, y, width, height);
}
GLuint CreateProgram(PP_Resource context) {
  return PluginContext3D::implFromResource(context)->CreateProgram();
}
GLuint CreateShader(PP_Resource context, GLenum type) {
  return PluginContext3D::implFromResource(context)->CreateShader(type);
}
void CullFace(PP_Resource context, GLenum mode) {
  PluginContext3D::implFromResource(context)->CullFace(mode);
}
void DeleteBuffers(PP_Resource context, GLsizei n, const GLuint* buffers) {
  PluginContext3D::implFromResource(context)->DeleteBuffers(n, buffers);
}
void DeleteFramebuffers(
    PP_Resource context, GLsizei n, const GLuint* framebuffers) {
  PluginContext3D::implFromResource(
      context)->DeleteFramebuffers(n, framebuffers);
}
void DeleteProgram(PP_Resource context, GLuint program) {
  PluginContext3D::implFromResource(context)->DeleteProgram(program);
}
void DeleteRenderbuffers(
    PP_Resource context, GLsizei n, const GLuint* renderbuffers) {
  PluginContext3D::implFromResource(
      context)->DeleteRenderbuffers(n, renderbuffers);
}
void DeleteShader(PP_Resource context, GLuint shader) {
  PluginContext3D::implFromResource(context)->DeleteShader(shader);
}
void DeleteTextures(PP_Resource context, GLsizei n, const GLuint* textures) {
  PluginContext3D::implFromResource(context)->DeleteTextures(n, textures);
}
void DepthFunc(PP_Resource context, GLenum func) {
  PluginContext3D::implFromResource(context)->DepthFunc(func);
}
void DepthMask(PP_Resource context, GLboolean flag) {
  PluginContext3D::implFromResource(context)->DepthMask(flag);
}
void DepthRangef(PP_Resource context, GLclampf zNear, GLclampf zFar) {
  PluginContext3D::implFromResource(context)->DepthRangef(zNear, zFar);
}
void DetachShader(PP_Resource context, GLuint program, GLuint shader) {
  PluginContext3D::implFromResource(context)->DetachShader(program, shader);
}
void Disable(PP_Resource context, GLenum cap) {
  PluginContext3D::implFromResource(context)->Disable(cap);
}
void DisableVertexAttribArray(PP_Resource context, GLuint index) {
  PluginContext3D::implFromResource(context)->DisableVertexAttribArray(index);
}
void DrawArrays(PP_Resource context, GLenum mode, GLint first, GLsizei count) {
  PluginContext3D::implFromResource(context)->DrawArrays(mode, first, count);
}
void DrawElements(
    PP_Resource context, GLenum mode, GLsizei count, GLenum type,
    const void* indices) {
  PluginContext3D::implFromResource(
      context)->DrawElements(mode, count, type, indices);
}
void Enable(PP_Resource context, GLenum cap) {
  PluginContext3D::implFromResource(context)->Enable(cap);
}
void EnableVertexAttribArray(PP_Resource context, GLuint index) {
  PluginContext3D::implFromResource(context)->EnableVertexAttribArray(index);
}
void Finish(PP_Resource context) {
  PluginContext3D::implFromResource(context)->Finish();
}
void Flush(PP_Resource context) {
  PluginContext3D::implFromResource(context)->Flush();
}
void FramebufferRenderbuffer(
    PP_Resource context, GLenum target, GLenum attachment,
    GLenum renderbuffertarget, GLuint renderbuffer) {
  PluginContext3D::implFromResource(
      context)->FramebufferRenderbuffer(
          target, attachment, renderbuffertarget, renderbuffer);
}
void FramebufferTexture2D(
    PP_Resource context, GLenum target, GLenum attachment, GLenum textarget,
    GLuint texture, GLint level) {
  PluginContext3D::implFromResource(
      context)->FramebufferTexture2D(
          target, attachment, textarget, texture, level);
}
void FrontFace(PP_Resource context, GLenum mode) {
  PluginContext3D::implFromResource(context)->FrontFace(mode);
}
void GenBuffers(PP_Resource context, GLsizei n, GLuint* buffers) {
  PluginContext3D::implFromResource(context)->GenBuffers(n, buffers);
}
void GenerateMipmap(PP_Resource context, GLenum target) {
  PluginContext3D::implFromResource(context)->GenerateMipmap(target);
}
void GenFramebuffers(PP_Resource context, GLsizei n, GLuint* framebuffers) {
  PluginContext3D::implFromResource(context)->GenFramebuffers(n, framebuffers);
}
void GenRenderbuffers(PP_Resource context, GLsizei n, GLuint* renderbuffers) {
  PluginContext3D::implFromResource(
      context)->GenRenderbuffers(n, renderbuffers);
}
void GenTextures(PP_Resource context, GLsizei n, GLuint* textures) {
  PluginContext3D::implFromResource(context)->GenTextures(n, textures);
}
void GetActiveAttrib(
    PP_Resource context, GLuint program, GLuint index, GLsizei bufsize,
    GLsizei* length, GLint* size, GLenum* type, char* name) {
  PluginContext3D::implFromResource(
      context)->GetActiveAttrib(
          program, index, bufsize, length, size, type, name);
}
void GetActiveUniform(
    PP_Resource context, GLuint program, GLuint index, GLsizei bufsize,
    GLsizei* length, GLint* size, GLenum* type, char* name) {
  PluginContext3D::implFromResource(
      context)->GetActiveUniform(
          program, index, bufsize, length, size, type, name);
}
void GetAttachedShaders(
    PP_Resource context, GLuint program, GLsizei maxcount, GLsizei* count,
    GLuint* shaders) {
  PluginContext3D::implFromResource(
      context)->GetAttachedShaders(program, maxcount, count, shaders);
}
GLint GetAttribLocation(
    PP_Resource context, GLuint program, const char* name) {
  return PluginContext3D::implFromResource(
      context)->GetAttribLocation(program, name);
}
void GetBooleanv(PP_Resource context, GLenum pname, GLboolean* params) {
  PluginContext3D::implFromResource(context)->GetBooleanv(pname, params);
}
void GetBufferParameteriv(
    PP_Resource context, GLenum target, GLenum pname, GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetBufferParameteriv(target, pname, params);
}
GLenum GetError(PP_Resource context) {
  return PluginContext3D::implFromResource(context)->GetError();
}
void GetFloatv(PP_Resource context, GLenum pname, GLfloat* params) {
  PluginContext3D::implFromResource(context)->GetFloatv(pname, params);
}
void GetFramebufferAttachmentParameteriv(
    PP_Resource context, GLenum target, GLenum attachment, GLenum pname,
    GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetFramebufferAttachmentParameteriv(
          target, attachment, pname, params);
}
void GetIntegerv(PP_Resource context, GLenum pname, GLint* params) {
  PluginContext3D::implFromResource(context)->GetIntegerv(pname, params);
}
void GetProgramiv(
    PP_Resource context, GLuint program, GLenum pname, GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetProgramiv(program, pname, params);
}
void GetProgramInfoLog(
    PP_Resource context, GLuint program, GLsizei bufsize, GLsizei* length,
    char* infolog) {
  PluginContext3D::implFromResource(
      context)->GetProgramInfoLog(program, bufsize, length, infolog);
}
void GetRenderbufferParameteriv(
    PP_Resource context, GLenum target, GLenum pname, GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetRenderbufferParameteriv(target, pname, params);
}
void GetShaderiv(
    PP_Resource context, GLuint shader, GLenum pname, GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetShaderiv(shader, pname, params);
}
void GetShaderInfoLog(
    PP_Resource context, GLuint shader, GLsizei bufsize, GLsizei* length,
    char* infolog) {
  PluginContext3D::implFromResource(
      context)->GetShaderInfoLog(shader, bufsize, length, infolog);
}
void GetShaderPrecisionFormat(
    PP_Resource context, GLenum shadertype, GLenum precisiontype, GLint* range,
    GLint* precision) {
  PluginContext3D::implFromResource(
      context)->GetShaderPrecisionFormat(
          shadertype, precisiontype, range, precision);
}
void GetShaderSource(
    PP_Resource context, GLuint shader, GLsizei bufsize, GLsizei* length,
    char* source) {
  PluginContext3D::implFromResource(
      context)->GetShaderSource(shader, bufsize, length, source);
}
const GLubyte* GetString(PP_Resource context, GLenum name) {
  return PluginContext3D::implFromResource(context)->GetString(name);
}
void GetTexParameterfv(
    PP_Resource context, GLenum target, GLenum pname, GLfloat* params) {
  PluginContext3D::implFromResource(
      context)->GetTexParameterfv(target, pname, params);
}
void GetTexParameteriv(
    PP_Resource context, GLenum target, GLenum pname, GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetTexParameteriv(target, pname, params);
}
void GetUniformfv(
    PP_Resource context, GLuint program, GLint location, GLfloat* params) {
  PluginContext3D::implFromResource(
      context)->GetUniformfv(program, location, params);
}
void GetUniformiv(
    PP_Resource context, GLuint program, GLint location, GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetUniformiv(program, location, params);
}
GLint GetUniformLocation(
    PP_Resource context, GLuint program, const char* name) {
  return PluginContext3D::implFromResource(
      context)->GetUniformLocation(program, name);
}
void GetVertexAttribfv(
    PP_Resource context, GLuint index, GLenum pname, GLfloat* params) {
  PluginContext3D::implFromResource(
      context)->GetVertexAttribfv(index, pname, params);
}
void GetVertexAttribiv(
    PP_Resource context, GLuint index, GLenum pname, GLint* params) {
  PluginContext3D::implFromResource(
      context)->GetVertexAttribiv(index, pname, params);
}
void GetVertexAttribPointerv(
    PP_Resource context, GLuint index, GLenum pname, void** pointer) {
  PluginContext3D::implFromResource(
      context)->GetVertexAttribPointerv(index, pname, pointer);
}
void Hint(PP_Resource context, GLenum target, GLenum mode) {
  PluginContext3D::implFromResource(context)->Hint(target, mode);
}
GLboolean IsBuffer(PP_Resource context, GLuint buffer) {
  return PluginContext3D::implFromResource(context)->IsBuffer(buffer);
}
GLboolean IsEnabled(PP_Resource context, GLenum cap) {
  return PluginContext3D::implFromResource(context)->IsEnabled(cap);
}
GLboolean IsFramebuffer(PP_Resource context, GLuint framebuffer) {
  return PluginContext3D::implFromResource(
      context)->IsFramebuffer(framebuffer);
}
GLboolean IsProgram(PP_Resource context, GLuint program) {
  return PluginContext3D::implFromResource(context)->IsProgram(program);
}
GLboolean IsRenderbuffer(PP_Resource context, GLuint renderbuffer) {
  return PluginContext3D::implFromResource(
      context)->IsRenderbuffer(renderbuffer);
}
GLboolean IsShader(PP_Resource context, GLuint shader) {
  return PluginContext3D::implFromResource(context)->IsShader(shader);
}
GLboolean IsTexture(PP_Resource context, GLuint texture) {
  return PluginContext3D::implFromResource(context)->IsTexture(texture);
}
void LineWidth(PP_Resource context, GLfloat width) {
  PluginContext3D::implFromResource(context)->LineWidth(width);
}
void LinkProgram(PP_Resource context, GLuint program) {
  PluginContext3D::implFromResource(context)->LinkProgram(program);
}
void PixelStorei(PP_Resource context, GLenum pname, GLint param) {
  PluginContext3D::implFromResource(context)->PixelStorei(pname, param);
}
void PolygonOffset(PP_Resource context, GLfloat factor, GLfloat units) {
  PluginContext3D::implFromResource(context)->PolygonOffset(factor, units);
}
void ReadPixels(
    PP_Resource context, GLint x, GLint y, GLsizei width, GLsizei height,
    GLenum format, GLenum type, void* pixels) {
  PluginContext3D::implFromResource(
      context)->ReadPixels(x, y, width, height, format, type, pixels);
}
void ReleaseShaderCompiler(PP_Resource context) {
  PluginContext3D::implFromResource(context)->ReleaseShaderCompiler();
}
void RenderbufferStorage(
    PP_Resource context, GLenum target, GLenum internalformat, GLsizei width,
    GLsizei height) {
  PluginContext3D::implFromResource(
      context)->RenderbufferStorage(target, internalformat, width, height);
}
void SampleCoverage(PP_Resource context, GLclampf value, GLboolean invert) {
  PluginContext3D::implFromResource(context)->SampleCoverage(value, invert);
}
void Scissor(
    PP_Resource context, GLint x, GLint y, GLsizei width, GLsizei height) {
  PluginContext3D::implFromResource(context)->Scissor(x, y, width, height);
}
void ShaderBinary(
    PP_Resource context, GLsizei n, const GLuint* shaders, GLenum binaryformat,
    const void* binary, GLsizei length) {
  PluginContext3D::implFromResource(
      context)->ShaderBinary(n, shaders, binaryformat, binary, length);
}
void ShaderSource(
    PP_Resource context, GLuint shader, GLsizei count, const char** str,
    const GLint* length) {
  PluginContext3D::implFromResource(
      context)->ShaderSource(shader, count, str, length);
}
void StencilFunc(PP_Resource context, GLenum func, GLint ref, GLuint mask) {
  PluginContext3D::implFromResource(context)->StencilFunc(func, ref, mask);
}
void StencilFuncSeparate(
    PP_Resource context, GLenum face, GLenum func, GLint ref, GLuint mask) {
  PluginContext3D::implFromResource(
      context)->StencilFuncSeparate(face, func, ref, mask);
}
void StencilMask(PP_Resource context, GLuint mask) {
  PluginContext3D::implFromResource(context)->StencilMask(mask);
}
void StencilMaskSeparate(PP_Resource context, GLenum face, GLuint mask) {
  PluginContext3D::implFromResource(context)->StencilMaskSeparate(face, mask);
}
void StencilOp(PP_Resource context, GLenum fail, GLenum zfail, GLenum zpass) {
  PluginContext3D::implFromResource(context)->StencilOp(fail, zfail, zpass);
}
void StencilOpSeparate(
    PP_Resource context, GLenum face, GLenum fail, GLenum zfail,
    GLenum zpass) {
  PluginContext3D::implFromResource(
      context)->StencilOpSeparate(face, fail, zfail, zpass);
}
void TexImage2D(
    PP_Resource context, GLenum target, GLint level, GLint internalformat,
    GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type,
    const void* pixels) {
  PluginContext3D::implFromResource(
      context)->TexImage2D(
          target, level, internalformat, width, height, border, format, type,
          pixels);
}
void TexParameterf(
    PP_Resource context, GLenum target, GLenum pname, GLfloat param) {
  PluginContext3D::implFromResource(
      context)->TexParameterf(target, pname, param);
}
void TexParameterfv(
    PP_Resource context, GLenum target, GLenum pname, const GLfloat* params) {
  PluginContext3D::implFromResource(
      context)->TexParameterfv(target, pname, params);
}
void TexParameteri(
    PP_Resource context, GLenum target, GLenum pname, GLint param) {
  PluginContext3D::implFromResource(
      context)->TexParameteri(target, pname, param);
}
void TexParameteriv(
    PP_Resource context, GLenum target, GLenum pname, const GLint* params) {
  PluginContext3D::implFromResource(
      context)->TexParameteriv(target, pname, params);
}
void TexSubImage2D(
    PP_Resource context, GLenum target, GLint level, GLint xoffset,
    GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type,
    const void* pixels) {
  PluginContext3D::implFromResource(
      context)->TexSubImage2D(
          target, level, xoffset, yoffset, width, height, format, type,
          pixels);
}
void Uniform1f(PP_Resource context, GLint location, GLfloat x) {
  PluginContext3D::implFromResource(context)->Uniform1f(location, x);
}
void Uniform1fv(
    PP_Resource context, GLint location, GLsizei count, const GLfloat* v) {
  PluginContext3D::implFromResource(context)->Uniform1fv(location, count, v);
}
void Uniform1i(PP_Resource context, GLint location, GLint x) {
  PluginContext3D::implFromResource(context)->Uniform1i(location, x);
}
void Uniform1iv(
    PP_Resource context, GLint location, GLsizei count, const GLint* v) {
  PluginContext3D::implFromResource(context)->Uniform1iv(location, count, v);
}
void Uniform2f(PP_Resource context, GLint location, GLfloat x, GLfloat y) {
  PluginContext3D::implFromResource(context)->Uniform2f(location, x, y);
}
void Uniform2fv(
    PP_Resource context, GLint location, GLsizei count, const GLfloat* v) {
  PluginContext3D::implFromResource(context)->Uniform2fv(location, count, v);
}
void Uniform2i(PP_Resource context, GLint location, GLint x, GLint y) {
  PluginContext3D::implFromResource(context)->Uniform2i(location, x, y);
}
void Uniform2iv(
    PP_Resource context, GLint location, GLsizei count, const GLint* v) {
  PluginContext3D::implFromResource(context)->Uniform2iv(location, count, v);
}
void Uniform3f(
    PP_Resource context, GLint location, GLfloat x, GLfloat y, GLfloat z) {
  PluginContext3D::implFromResource(context)->Uniform3f(location, x, y, z);
}
void Uniform3fv(
    PP_Resource context, GLint location, GLsizei count, const GLfloat* v) {
  PluginContext3D::implFromResource(context)->Uniform3fv(location, count, v);
}
void Uniform3i(
    PP_Resource context, GLint location, GLint x, GLint y, GLint z) {
  PluginContext3D::implFromResource(context)->Uniform3i(location, x, y, z);
}
void Uniform3iv(
    PP_Resource context, GLint location, GLsizei count, const GLint* v) {
  PluginContext3D::implFromResource(context)->Uniform3iv(location, count, v);
}
void Uniform4f(
    PP_Resource context, GLint location, GLfloat x, GLfloat y, GLfloat z,
    GLfloat w) {
  PluginContext3D::implFromResource(context)->Uniform4f(location, x, y, z, w);
}
void Uniform4fv(
    PP_Resource context, GLint location, GLsizei count, const GLfloat* v) {
  PluginContext3D::implFromResource(context)->Uniform4fv(location, count, v);
}
void Uniform4i(
    PP_Resource context, GLint location, GLint x, GLint y, GLint z, GLint w) {
  PluginContext3D::implFromResource(context)->Uniform4i(location, x, y, z, w);
}
void Uniform4iv(
    PP_Resource context, GLint location, GLsizei count, const GLint* v) {
  PluginContext3D::implFromResource(context)->Uniform4iv(location, count, v);
}
void UniformMatrix2fv(
    PP_Resource context, GLint location, GLsizei count, GLboolean transpose,
    const GLfloat* value) {
  PluginContext3D::implFromResource(
      context)->UniformMatrix2fv(location, count, transpose, value);
}
void UniformMatrix3fv(
    PP_Resource context, GLint location, GLsizei count, GLboolean transpose,
    const GLfloat* value) {
  PluginContext3D::implFromResource(
      context)->UniformMatrix3fv(location, count, transpose, value);
}
void UniformMatrix4fv(
    PP_Resource context, GLint location, GLsizei count, GLboolean transpose,
    const GLfloat* value) {
  PluginContext3D::implFromResource(
      context)->UniformMatrix4fv(location, count, transpose, value);
}
void UseProgram(PP_Resource context, GLuint program) {
  PluginContext3D::implFromResource(context)->UseProgram(program);
}
void ValidateProgram(PP_Resource context, GLuint program) {
  PluginContext3D::implFromResource(context)->ValidateProgram(program);
}
void VertexAttrib1f(PP_Resource context, GLuint indx, GLfloat x) {
  PluginContext3D::implFromResource(context)->VertexAttrib1f(indx, x);
}
void VertexAttrib1fv(PP_Resource context, GLuint indx, const GLfloat* values) {
  PluginContext3D::implFromResource(context)->VertexAttrib1fv(indx, values);
}
void VertexAttrib2f(PP_Resource context, GLuint indx, GLfloat x, GLfloat y) {
  PluginContext3D::implFromResource(context)->VertexAttrib2f(indx, x, y);
}
void VertexAttrib2fv(PP_Resource context, GLuint indx, const GLfloat* values) {
  PluginContext3D::implFromResource(context)->VertexAttrib2fv(indx, values);
}
void VertexAttrib3f(
    PP_Resource context, GLuint indx, GLfloat x, GLfloat y, GLfloat z) {
  PluginContext3D::implFromResource(context)->VertexAttrib3f(indx, x, y, z);
}
void VertexAttrib3fv(PP_Resource context, GLuint indx, const GLfloat* values) {
  PluginContext3D::implFromResource(context)->VertexAttrib3fv(indx, values);
}
void VertexAttrib4f(
    PP_Resource context, GLuint indx, GLfloat x, GLfloat y, GLfloat z,
    GLfloat w) {
  PluginContext3D::implFromResource(context)->VertexAttrib4f(indx, x, y, z, w);
}
void VertexAttrib4fv(PP_Resource context, GLuint indx, const GLfloat* values) {
  PluginContext3D::implFromResource(context)->VertexAttrib4fv(indx, values);
}
void VertexAttribPointer(
    PP_Resource context, GLuint indx, GLint size, GLenum type,
    GLboolean normalized, GLsizei stride, const void* ptr) {
  PluginContext3D::implFromResource(
      context)->VertexAttribPointer(indx, size, type, normalized, stride, ptr);
}
void Viewport(
    PP_Resource context, GLint x, GLint y, GLsizei width, GLsizei height) {
  PluginContext3D::implFromResource(context)->Viewport(x, y, width, height);
}

} // namespace

const PPB_OpenGLES2_Dev* PluginContext3D::GetOpenGLESInterface() {
  const static struct PPB_OpenGLES2_Dev ppb_opengles = {
    &ActiveTexture,
    &AttachShader,
    &BindAttribLocation,
    &BindBuffer,
    &BindFramebuffer,
    &BindRenderbuffer,
    &BindTexture,
    &BlendColor,
    &BlendEquation,
    &BlendEquationSeparate,
    &BlendFunc,
    &BlendFuncSeparate,
    &BufferData,
    &BufferSubData,
    &CheckFramebufferStatus,
    &Clear,
    &ClearColor,
    &ClearDepthf,
    &ClearStencil,
    &ColorMask,
    &CompileShader,
    &CompressedTexImage2D,
    &CompressedTexSubImage2D,
    &CopyTexImage2D,
    &CopyTexSubImage2D,
    &CreateProgram,
    &CreateShader,
    &CullFace,
    &DeleteBuffers,
    &DeleteFramebuffers,
    &DeleteProgram,
    &DeleteRenderbuffers,
    &DeleteShader,
    &DeleteTextures,
    &DepthFunc,
    &DepthMask,
    &DepthRangef,
    &DetachShader,
    &Disable,
    &DisableVertexAttribArray,
    &DrawArrays,
    &DrawElements,
    &Enable,
    &EnableVertexAttribArray,
    &Finish,
    &Flush,
    &FramebufferRenderbuffer,
    &FramebufferTexture2D,
    &FrontFace,
    &GenBuffers,
    &GenerateMipmap,
    &GenFramebuffers,
    &GenRenderbuffers,
    &GenTextures,
    &GetActiveAttrib,
    &GetActiveUniform,
    &GetAttachedShaders,
    &GetAttribLocation,
    &GetBooleanv,
    &GetBufferParameteriv,
    &GetError,
    &GetFloatv,
    &GetFramebufferAttachmentParameteriv,
    &GetIntegerv,
    &GetProgramiv,
    &GetProgramInfoLog,
    &GetRenderbufferParameteriv,
    &GetShaderiv,
    &GetShaderInfoLog,
    &GetShaderPrecisionFormat,
    &GetShaderSource,
    &GetString,
    &GetTexParameterfv,
    &GetTexParameteriv,
    &GetUniformfv,
    &GetUniformiv,
    &GetUniformLocation,
    &GetVertexAttribfv,
    &GetVertexAttribiv,
    &GetVertexAttribPointerv,
    &Hint,
    &IsBuffer,
    &IsEnabled,
    &IsFramebuffer,
    &IsProgram,
    &IsRenderbuffer,
    &IsShader,
    &IsTexture,
    &LineWidth,
    &LinkProgram,
    &PixelStorei,
    &PolygonOffset,
    &ReadPixels,
    &ReleaseShaderCompiler,
    &RenderbufferStorage,
    &SampleCoverage,
    &Scissor,
    &ShaderBinary,
    &ShaderSource,
    &StencilFunc,
    &StencilFuncSeparate,
    &StencilMask,
    &StencilMaskSeparate,
    &StencilOp,
    &StencilOpSeparate,
    &TexImage2D,
    &TexParameterf,
    &TexParameterfv,
    &TexParameteri,
    &TexParameteriv,
    &TexSubImage2D,
    &Uniform1f,
    &Uniform1fv,
    &Uniform1i,
    &Uniform1iv,
    &Uniform2f,
    &Uniform2fv,
    &Uniform2i,
    &Uniform2iv,
    &Uniform3f,
    &Uniform3fv,
    &Uniform3i,
    &Uniform3iv,
    &Uniform4f,
    &Uniform4fv,
    &Uniform4i,
    &Uniform4iv,
    &UniformMatrix2fv,
    &UniformMatrix3fv,
    &UniformMatrix4fv,
    &UseProgram,
    &ValidateProgram,
    &VertexAttrib1f,
    &VertexAttrib1fv,
    &VertexAttrib2f,
    &VertexAttrib2fv,
    &VertexAttrib3f,
    &VertexAttrib3fv,
    &VertexAttrib4f,
    &VertexAttrib4fv,
    &VertexAttribPointer,
    &Viewport
  };
  return &ppb_opengles;
}
