#ifndef SIMPLECODE_HPP
#define SIMPLECODE_HPP

#include <qobject.h>

#include "AdaptiveHuffman.h"
#include "BasicPanel.h"
#include "CamPanel.h"
#include "CamTile.h"
#include "CodecFrame.h"
#include "DiffPanel.h"
#include "DCTPanel.h"
#include "VideoDevice.h"


class CCamWidget;

class CSimpleCodec: public CCodecFrame
{
   Q_OBJECT
private:
   CVideoDevice *pVideo;

   int zigzag[64][2];
   int image_w, image_h;
   int half_w, half_h;
   int tiles_y, tiles_uv;
   CCamTile *pTilesY, *pTilesUV;
   CCamTile **pSorted, *pUsed;
   CCamTile **pSendAbs, **pSendDiff;
   int *UsedForDiff, *UsedForAbs;
   int GraphPos;

   CCamPanel *pRGB, *pYUV;
   CDCTPanel *pFDCTImage, *pIDCTImage;
   CDCTPanel *pFDCTDiff, *pIDCTDiff;
   CBasicPanel *pRecImage, *pRecDiff;
   CDiffPanel *pRec_YUV;
   CBasicPanel *pReconstruction;
   CBasicPanel *pSelection;
   int Count, Refresh;
   
//   CAdaptiveHuffman Compressor(256), Decompressor(256);

   /* Various compression parameters */
   int ParamSmear;
   int ParamThreshold;
   int ParamMaxPFrames;
   bool ParamClearDiff;
   int ParamBytesPerPacket;

   void CreateTiles();
   void Send(CCamPanel *p, bool update);
   void MoveTileToEnd(CCamTile *tile);

private slots:
   void Resize(const QSize &ns);

public:
   CSimpleCodec(CVideoDevice *video);
   ~CSimpleCodec();

public slots:
   void UpdatePanel();
};


#endif
