from bzrlib.transport import get_transport


def create_mirror(source_branch, target_location, possible_transports):
    possible_transports.append(source_branch.bzrdir.root_transport)
    t = get_transport(target_location, possible_transports)
    mirror = source_branch.bzrdir.clone_on_transport(t).open_branch()
    mirror.set_public_branch(source_branch.base)
    mirror.set_parent(source_branch.base)
    if source_branch.get_config().has_explicit_nickname():
        mirror.nick = source_branch.nick
    mirror.set_submit_branch(source_branch.get_submit_branch())
    source_config = source_branch.get_config()
    child_submit_to = source_config.get_user_option('child_submit_to')
    if child_submit_to is not None:
        mirror.get_config().set_user_option('child_submit_to', child_submit_to)
    return mirror
