--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


SET search_path = public, pg_catalog;

--
-- Name: dblink_pkey_results; Type: TYPE; Schema: public; Owner: root
--

CREATE TYPE dblink_pkey_results AS (
	"position" integer,
	colname text
);


ALTER TYPE public.dblink_pkey_results OWNER TO root;

--
-- Name: actualizatotalbaran(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotalbaran() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalalbaran(NEW.idalbaran);
	bimp := calcbimpalbaran(NEW.idalbaran);
	imp := calcimpuestosalbaran(NEW.idalbaran);
	UPDATE albaran SET totalalbaran = tot, bimpalbaran = bimp, impalbaran = imp WHERE idalbaran = NEW.idalbaran;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotalbaran() OWNER TO postgres;

--
-- Name: actualizatotalbaranb(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotalbaranb() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalalbaran(OLD.idalbaran);
	bimp := calcbimpalbaran(OLD.idalbaran);
	imp := calcimpuestosalbaran(OLD.idalbaran);
	UPDATE albaran SET totalalbaran = tot, bimpalbaran = bimp, impalbaran = imp WHERE idalbaran = OLD.idalbaran;
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotalbaranb() OWNER TO postgres;

--
-- Name: actualizatotalbaranp(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotalbaranp() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalalbpro(NEW.idalbaranp);
	bimp := calcbimpalbpro(NEW.idalbaranp);
	imp := calcimpuestosalbpro(NEW.idalbaranp);
	UPDATE albaranp SET totalalbaranp = tot, bimpalbaranp = bimp, impalbaranp = imp WHERE idalbaranp = NEW.idalbaranp;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotalbaranp() OWNER TO postgres;

--
-- Name: actualizatotalbaranpb(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotalbaranpb() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalalbpro(OLD.idalbaranp);
	bimp := calcbimpalbpro(OLD.idalbaranp);
	imp := calcimpuestosalbpro(OLD.idalbaranp);
	UPDATE albaranp SET totalalbaranp = tot, bimpalbaranp = bimp, impalbaranp = imp WHERE idalbaranp = OLD.idalbaranp;
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotalbaranpb() OWNER TO postgres;

--
-- Name: actualizatotfactura(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotfactura() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalfactura(NEW.idfactura);
	bimp := calcbimpfactura(NEW.idfactura);
	imp := calcimpuestosfactura(NEW.idfactura);
	UPDATE factura SET totalfactura = tot, bimpfactura = bimp, impfactura = imp WHERE idfactura = NEW.idfactura;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotfactura() OWNER TO postgres;

--
-- Name: actualizatotfacturab(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotfacturab() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalfactura(OLD.idfactura);
	bimp := calcbimpfactura(OLD.idfactura);
	imp := calcimpuestosfactura(OLD.idfactura);
	UPDATE factura SET totalfactura = tot, bimpfactura = bimp, impfactura = imp WHERE idfactura = OLD.idfactura;
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotfacturab() OWNER TO postgres;

--
-- Name: actualizatotfacturap(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotfacturap() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalfacpro(NEW.idfacturap);
	bimp := calcbimpfacpro(NEW.idfacturap);
	imp := calcimpuestosfacpro(NEW.idfacturap);
	UPDATE facturap SET totalfacturap = tot, bimpfacturap = bimp, impfacturap = imp WHERE idfacturap = NEW.idfacturap;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotfacturap() OWNER TO postgres;

--
-- Name: actualizatotfacturapb(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotfacturapb() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalfacpro(OLD.idfacturap);
	bimp := calcbimpfacpro(OLD.idfacturap);
	imp := calcimpuestosfacpro(OLD.idfacturap);
	UPDATE facturap SET totalfacturap = tot, bimpfacturap = bimp, impfacturap = imp WHERE idfacturap = OLD.idfacturap;
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotfacturapb() OWNER TO postgres;

--
-- Name: actualizatotpedcli(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotpedcli() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalpedcli(NEW.idpedidocliente);
	bimp := calcbimppedcli(NEW.idpedidocliente);
	imp := calcimpuestospedcli(NEW.idpedidocliente);
	UPDATE pedidocliente SET totalpedidocliente = tot, bimppedidocliente = bimp, imppedidocliente = imp WHERE idpedidocliente = NEW.idpedidocliente;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotpedcli() OWNER TO postgres;

--
-- Name: actualizatotpedclib(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotpedclib() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalpedcli(OLD.idpedidocliente);
	bimp := calcbimppedcli(OLD.idpedidocliente);
	imp := calcimpuestospedcli(OLD.idpedidocliente);
	UPDATE pedidocliente SET totalpedidocliente = tot, bimppedidocliente = bimp, imppedidocliente = imp WHERE idpedidocliente = OLD.idpedidocliente;
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotpedclib() OWNER TO postgres;

--
-- Name: actualizatotpedidoproveedor(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotpedidoproveedor() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalpedpro(NEW.idpedidoproveedor);
	bimp := calcbimppedpro(NEW.idpedidoproveedor);
	imp := calcimpuestospedpro(NEW.idpedidoproveedor);
	UPDATE pedidoproveedor SET totalpedidoproveedor = tot, bimppedidoproveedor = bimp, imppedidoproveedor = imp WHERE idpedidoproveedor = NEW.idpedidoproveedor;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotpedidoproveedor() OWNER TO postgres;

--
-- Name: actualizatotpedidoproveedorb(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotpedidoproveedorb() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalpedpro(OLD.idpedidoproveedor);
	bimp := calcbimppedpro(OLD.idpedidoproveedor);
	imp := calcimpuestospedpro(OLD.idpedidoproveedor);
	UPDATE pedidoproveedor SET totalpedidoproveedor = tot, bimppedidoproveedor = bimp, imppedidoproveedor = imp WHERE idpedidoproveedor = OLD.idpedidoproveedor;
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotpedidoproveedorb() OWNER TO postgres;

--
-- Name: actualizatotpres(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotpres() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalpres(NEW.idpresupuesto);
	bimp := calcbimppres(NEW.idpresupuesto);
	imp := calcimpuestospres(NEW.idpresupuesto);
	UPDATE presupuesto SET totalpresupuesto = tot, bimppresupuesto = bimp, imppresupuesto = imp WHERE idpresupuesto = NEW.idpresupuesto;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotpres() OWNER TO postgres;

--
-- Name: actualizatotpresb(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION actualizatotpresb() RETURNS "trigger"
    AS $$
DECLARE
	tot NUMERIC(12,2);
	bimp NUMERIC(12,2);
	imp NUMERIC(12,2);
BEGIN
	tot := calctotalpres(OLD.idpresupuesto);
	bimp := calcbimppres(OLD.idpresupuesto);
	imp := calcimpuestospres(OLD.idpresupuesto);
	UPDATE presupuesto SET totalpresupuesto = tot, bimppresupuesto = bimp, imppresupuesto = imp WHERE idpresupuesto = OLD.idpresupuesto;
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.actualizatotpresb() OWNER TO postgres;

--
-- Name: aumentastock(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION aumentastock() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    -- Hacemos el update del stock del articulo
    UPDATE articulo SET stockarticulo = stockarticulo - NEW.cantlalbaran WHERE idarticulo = NEW.idarticulo;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.aumentastock() OWNER TO postgres;

--
-- Name: aumentastockp(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION aumentastockp() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    UPDATE articulo SET stockarticulo = stockarticulo + NEW.cantlalbaranp WHERE idarticulo = NEW.idarticulo;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.aumentastockp() OWNER TO postgres;

--
-- Name: calcbimpalbaran(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcbimpalbaran(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    total numeric(12, 2);
    res RECORD;

BEGIN
    total := 0;
    FOR res IN SELECT cantlalbaran * pvplalbaran * (1 - descuentolalbaran / 100) AS subtotal1 FROM lalbaran WHERE idalbaran = idp LOOP
	total := total + res.subtotal1;
    END LOOP;
    FOR res IN SELECT proporciondalbaran FROM dalbaran WHERE idalbaran = idp LOOP
	total := total * (1 - res.proporciondalbaran / 100);
    END LOOP;
    RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcbimpalbaran(integer) OWNER TO postgres;

--
-- Name: calcbimpalbpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcbimpalbpro(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    total numeric(12, 2);
    res RECORD;

BEGIN
    total := 0;
    FOR res IN SELECT cantlalbaranp * pvplalbaranp * (1 - descuentolalbaranp / 100) AS subtotal1 FROM lalbaranp WHERE idalbaranp = idp LOOP
	total := total + res.subtotal1;
    END LOOP;
    FOR res IN SELECT proporciondalbaranp FROM dalbaranp WHERE idalbaranp = idp LOOP
	total := total * (1 - res.proporciondalbaranp / 100);
    END LOOP;
    RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcbimpalbpro(integer) OWNER TO postgres;

--
-- Name: calcbimpfacpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcbimpfacpro(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlfacturap * pvplfacturap * (1 - descuentolfacturap/100) AS subtotal1 FROM lfacturap WHERE idfacturap = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondfacturap FROM dfacturap WHERE idfacturap = idp LOOP
		total := total * (1 - res.proporciondfacturap/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcbimpfacpro(integer) OWNER TO postgres;

--
-- Name: calcbimpfactura(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcbimpfactura(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlfactura * pvplfactura * (1 - descuentolfactura/100) AS subtotal1 FROM lfactura WHERE idfactura = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondfactura FROM dfactura WHERE idfactura = idp LOOP
		total := total * (1 - res.proporciondfactura/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcbimpfactura(integer) OWNER TO postgres;

--
-- Name: calcbimppedcli(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcbimppedcli(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlpedidocliente * pvplpedidocliente * (1 - descuentolpedidocliente/100) AS subtotal1 FROM lpedidocliente WHERE idpedidocliente = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondpedidocliente FROM dpedidocliente WHERE idpedidocliente = idp LOOP
		total := total * (1 - res.proporciondpedidocliente/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcbimppedcli(integer) OWNER TO postgres;

--
-- Name: calcbimppedpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcbimppedpro(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlpedidoproveedor * pvplpedidoproveedor * (1 - descuentolpedidoproveedor/100) AS subtotal1 FROM lpedidoproveedor WHERE idpedidoproveedor = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondpedidoproveedor FROM dpedidoproveedor WHERE idpedidoproveedor = idp LOOP
		total := total * (1 - res.proporciondpedidoproveedor/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcbimppedpro(integer) OWNER TO postgres;

--
-- Name: calcbimppres(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcbimppres(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlpresupuesto * pvplpresupuesto * (1 - descuentolpresupuesto/100) AS subtotal1 FROM lpresupuesto WHERE idpresupuesto = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondpresupuesto FROM dpresupuesto WHERE idpresupuesto = idp LOOP
		total := total * (1 - res.proporciondpresupuesto/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcbimppres(integer) OWNER TO postgres;

--
-- Name: calcimpuestosalbaran(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcimpuestosalbaran(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    total numeric(12, 2);
    res RECORD;

BEGIN
    total := 0;
    FOR res IN SELECT cantlalbaran * pvplalbaran * (1 - descuentolalbaran / 100) * (ivalalbaran / 100) AS subtotal1 FROM lalbaran WHERE idalbaran = idp LOOP
    	total := total + res.subtotal1;
    END LOOP;
    FOR res IN SELECT proporciondalbaran FROM dalbaran WHERE idalbaran = idp LOOP
    	total := total * (1 - res.proporciondalbaran / 100);
    END LOOP;
    RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcimpuestosalbaran(integer) OWNER TO postgres;

--
-- Name: calcimpuestosalbpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcimpuestosalbpro(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    total numeric(12, 2);
    res RECORD;

BEGIN
    total := 0;
    FOR res IN SELECT cantlalbaranp * pvplalbaranp * (1 - descuentolalbaranp / 100) * (ivalalbaranp / 100) AS subtotal1 FROM lalbaranp WHERE idalbaranp = idp LOOP
	total := total + res.subtotal1;
    END LOOP;
    FOR res IN SELECT proporciondalbaranp FROM dalbaranp WHERE idalbaranp = idp LOOP
	total := total * (1 - res.proporciondalbaranp / 100);
    END LOOP;
    RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcimpuestosalbpro(integer) OWNER TO postgres;

--
-- Name: calcimpuestosfacpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcimpuestosfacpro(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlfacturap * pvplfacturap * (1 - descuentolfacturap/100) *( ivalfacturap/100) AS subtotal1 FROM lfacturap WHERE idfacturap = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondfacturap FROM dfacturap WHERE idfacturap = idp LOOP
		total := total * (1 - res.proporciondfacturap/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcimpuestosfacpro(integer) OWNER TO postgres;

--
-- Name: calcimpuestosfactura(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcimpuestosfactura(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlfactura * pvplfactura * (1 - descuentolfactura/100) *(ivalfactura/100) AS subtotal1 FROM lfactura WHERE idfactura = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondfactura FROM dfactura WHERE idfactura = idp LOOP
		total := total * (1 - res.proporciondfactura/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcimpuestosfactura(integer) OWNER TO postgres;

--
-- Name: calcimpuestospedcli(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcimpuestospedcli(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlpedidocliente * pvplpedidocliente * (1 - descuentolpedidocliente/100) *( ivalpedidocliente/100) AS subtotal1 FROM lpedidocliente WHERE idpedidocliente = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondpedidocliente FROM dpedidocliente WHERE idpedidocliente = idp LOOP
		total := total * (1 - res.proporciondpedidocliente/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcimpuestospedcli(integer) OWNER TO postgres;

--
-- Name: calcimpuestospedpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcimpuestospedpro(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlpedidoproveedor * pvplpedidoproveedor * (1 - descuentolpedidoproveedor/100) *( ivalpedidoproveedor/100) AS subtotal1 FROM lpedidoproveedor WHERE idpedidoproveedor = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondpedidoproveedor FROM dpedidoproveedor WHERE idpedidoproveedor = idp LOOP
		total := total * (1 - res.proporciondpedidoproveedor/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcimpuestospedpro(integer) OWNER TO postgres;

--
-- Name: calcimpuestospres(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calcimpuestospres(integer) RETURNS numeric
    AS $_$
DECLARE
idp ALIAS FOR $1;
total numeric(12,2);
res RECORD;
BEGIN
	total := 0;
	FOR  res IN SELECT cantlpresupuesto * pvplpresupuesto * (1 - descuentolpresupuesto/100) * (ivalpresupuesto/100) AS subtotal1 FROM lpresupuesto WHERE idpresupuesto = idp LOOP
		total := total + res.subtotal1;
	END LOOP;
	FOR res IN SELECT proporciondpresupuesto FROM dpresupuesto WHERE idpresupuesto = idp LOOP
		total := total * (1 - res.proporciondpresupuesto/100);
	END LOOP;
	RETURN total;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calcimpuestospres(integer) OWNER TO postgres;

--
-- Name: calctotalalbaran(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calctotalalbaran(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    totalBImponibleLineas numeric(12, 4);
    totalIRPF numeric(12, 4);
    totalIVA numeric(12, 4);
    totalRE numeric(12, 4);
    totalTotal numeric(12, 2);
    res RECORD;
    res2 RECORD;

BEGIN
    totalBImponibleLineas := 0;
    totalIRPF := 0;
    totalIVA := 0;
    totalRE := 0;
    totalTotal := 0;

    FOR res IN SELECT cantlalbaran * pvplalbaran * (1 - descuentolalbaran / 100) AS subtotal1 FROM lalbaran WHERE idalbaran = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas + res.subtotal1;
    END LOOP;

    SELECT INTO res valor::numeric FROM configuracion WHERE LOWER(nombre) = 'irpf';
    IF FOUND THEN
        totalIRPF := totalBImponibleLineas * (res.valor / 100);
    END IF;

    FOR res IN SELECT cantlalbaran * pvplalbaran * (1 - descuentolalbaran / 100) * (ivalalbaran / 100) AS subtotal1 FROM lalbaran WHERE idalbaran = idp LOOP
	totalIVA := totalIVA + res.subtotal1;
    END LOOP;

    FOR res IN SELECT cantlalbaran * pvplalbaran * (1 - descuentolalbaran / 100) * (reqeqlalbaran / 100) AS subtotal1 FROM lalbaran WHERE idalbaran = idp LOOP
	totalRE := totalRE + res.subtotal1;
    END LOOP;

    FOR res IN SELECT proporciondalbaran FROM dalbaran WHERE idalbaran = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas * (1 - res.proporciondalbaran / 100);
	totalIRPF := totalIRPF * (1 - res.proporciondalbaran / 100);
	totalIVA := totalIVA * (1 - res.proporciondalbaran / 100);
	totalRE := totalRE * (1 - res.proporciondalbaran / 100);
    END LOOP;

    totalTotal = totalBImponibleLineas - totalIRPF + totalIVA + totalRE;

    RETURN totalTotal;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calctotalalbaran(integer) OWNER TO postgres;

--
-- Name: calctotalalbpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calctotalalbpro(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    totalBImponibleLineas numeric(12, 4);
    totalIRPF numeric(12, 4);
    totalIVA numeric(12, 4);
    totalRE numeric(12, 4);
    totalTotal numeric(12, 2);
    res RECORD;
    res2 RECORD;

BEGIN
    totalBImponibleLineas := 0;
    totalIRPF := 0;
    totalIVA := 0;
    totalRE := 0;
    totalTotal := 0;

    FOR res IN SELECT cantlalbaranp * pvplalbaranp * (1 - descuentolalbaranp / 100) AS subtotal1 FROM lalbaranp WHERE idalbaranp = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas + res.subtotal1;
    END LOOP;

    SELECT INTO res2 idproveedor FROM albaranp WHERE idalbaranp = idp;

    SELECT INTO res irpfproveedor FROM proveedor WHERE idproveedor = res2.idproveedor;
    IF FOUND THEN
        totalIRPF := totalBImponibleLineas * (res.irpfproveedor / 100);
    END IF;

    FOR res IN SELECT cantlalbaranp * pvplalbaranp * (1 - descuentolalbaranp / 100) * (ivalalbaranp / 100) AS subtotal1 FROM lalbaranp WHERE idalbaranp = idp LOOP
	totalIVA := totalIVA + res.subtotal1;
    END LOOP;

    FOR res IN SELECT cantlalbaranp * pvplalbaranp * (1 - descuentolalbaranp / 100) * (reqeqlalbaranp / 100) AS subtotal1 FROM lalbaranp WHERE idalbaranp = idp LOOP
	totalRE := totalRE + res.subtotal1;
    END LOOP;

    FOR res IN SELECT proporciondalbaranp FROM dalbaranp WHERE idalbaranp = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas * (1 - res.proporciondalbaranp / 100);
	totalIRPF := totalIRPF * (1 - res.proporciondalbaranp / 100);
	totalIVA := totalIVA * (1 - res.proporciondalbaranp / 100);
	totalRE := totalRE * (1 - res.proporciondalbaranp / 100);
    END LOOP;

    totalTotal = totalBImponibleLineas - totalIRPF + totalIVA + totalRE;

    RETURN totalTotal;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calctotalalbpro(integer) OWNER TO postgres;

--
-- Name: calctotalfacpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calctotalfacpro(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    totalBImponibleLineas numeric(12, 4);
    totalIRPF numeric(12, 4);
    totalIVA numeric(12, 4);
    totalRE numeric(12, 4);
    totalTotal numeric(12, 2);
    res RECORD;
    res2 RECORD;

BEGIN
    totalBImponibleLineas := 0;
    totalIRPF := 0;
    totalIVA := 0;
    totalRE := 0;
    totalTotal := 0;

    FOR res IN SELECT cantlfacturap * pvplfacturap * (1 - descuentolfacturap / 100) AS subtotal1 FROM lfacturap WHERE idfacturap = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas + res.subtotal1;
    END LOOP;

    SELECT INTO res2 idproveedor FROM facturap WHERE idfacturap = idp;

    SELECT INTO res irpfproveedor FROM proveedor WHERE idproveedor = res2.idproveedor;
    IF FOUND THEN
        totalIRPF := totalBImponibleLineas * (res.irpfproveedor / 100);
    END IF;

    FOR res IN SELECT cantlfacturap * pvplfacturap * (1 - descuentolfacturap / 100) * (ivalfacturap / 100) AS subtotal1 FROM lfacturap WHERE idfacturap = idp LOOP
	totalIVA := totalIVA + res.subtotal1;
    END LOOP;

    FOR res IN SELECT cantlfacturap * pvplfacturap * (1 - descuentolfacturap / 100) * (reqeqlfacturap / 100) AS subtotal1 FROM lfacturap WHERE idfacturap = idp LOOP
	totalRE := totalRE + res.subtotal1;
    END LOOP;

    FOR res IN SELECT proporciondfacturap FROM dfacturap WHERE idfacturap = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas * (1 - res.proporciondfacturap / 100);
	totalIRPF := totalIRPF * (1 - res.proporciondfacturap / 100);
	totalIVA := totalIVA * (1 - res.proporciondfacturap / 100);
	totalRE := totalRE * (1 - res.proporciondfacturap / 100);
    END LOOP;

    totalTotal = totalBImponibleLineas - totalIRPF + totalIVA + totalRE;

    RETURN totalTotal;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calctotalfacpro(integer) OWNER TO postgres;

--
-- Name: calctotalfactura(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calctotalfactura(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    totalBImponibleLineas numeric(12, 4);
    totalIRPF numeric(12, 4);
    totalIVA numeric(12, 4);
    totalRE numeric(12, 4);
    totalTotal numeric(12, 2);
    res RECORD;

BEGIN
    totalBImponibleLineas := 0;
    totalIRPF := 0;
    totalIVA := 0;
    totalRE := 0;
    totalTotal := 0;

    FOR res IN SELECT cantlfactura * pvplfactura * (1 - descuentolfactura / 100) AS subtotal1 FROM lfactura WHERE idfactura = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas + res.subtotal1;
    END LOOP;

    SELECT INTO res valor::numeric FROM configuracion WHERE LOWER(nombre) = 'irpf';
    IF FOUND THEN
        totalIRPF := totalBImponibleLineas * (res.valor / 100);
    END IF;

    FOR res IN SELECT cantlfactura * pvplfactura * (1 - descuentolfactura / 100) * (ivalfactura / 100) AS subtotal1 FROM lfactura WHERE idfactura = idp LOOP
	totalIVA := totalIVA + res.subtotal1;
    END LOOP;

    FOR res IN SELECT cantlfactura * pvplfactura * (1 - descuentolfactura / 100) * (reqeqlfactura / 100) AS subtotal1 FROM lfactura WHERE idfactura = idp LOOP
	totalRE := totalRE + res.subtotal1;
    END LOOP;

    FOR res IN SELECT proporciondfactura FROM dfactura WHERE idfactura = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas * (1 - res.proporciondfactura / 100);
	totalIRPF := totalIRPF * (1 - res.proporciondfactura / 100);
	totalIVA := totalIVA * (1 - res.proporciondfactura / 100);
	totalRE := totalRE * (1 - res.proporciondfactura / 100);
    END LOOP;

    totalTotal = totalBImponibleLineas - totalIRPF + totalIVA + totalRE;

    RETURN totalTotal;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calctotalfactura(integer) OWNER TO postgres;

--
-- Name: calctotalpedcli(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calctotalpedcli(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    totalBImponibleLineas numeric(12, 4);
    totalIRPF numeric(12, 4);
    totalIVA numeric(12, 4);
    totalRE numeric(12, 4);
    totalTotal numeric(12, 2);
    res RECORD;
    res2 RECORD;

BEGIN
    totalBImponibleLineas := 0;
    totalIRPF := 0;
    totalIVA := 0;
    totalRE := 0;
    totalTotal := 0;

    FOR res IN SELECT cantlpedidocliente * pvplpedidocliente * (1 - descuentolpedidocliente / 100) AS subtotal1 FROM lpedidocliente WHERE idpedidocliente = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas + res.subtotal1;
    END LOOP;

    SELECT INTO res valor::numeric FROM configuracion WHERE LOWER(nombre) = 'irpf';
    IF FOUND THEN
        totalIRPF := totalBImponibleLineas * (res.valor / 100);
    END IF;

    FOR res IN SELECT cantlpedidocliente * pvplpedidocliente * (1 - descuentolpedidocliente / 100) * (ivalpedidocliente / 100) AS subtotal1 FROM lpedidocliente WHERE idpedidocliente = idp LOOP
	totalIVA := totalIVA + res.subtotal1;
    END LOOP;

    FOR res IN SELECT cantlpedidocliente * pvplpedidocliente * (1 - descuentolpedidocliente / 100) * (reqeqlpedidocliente / 100) AS subtotal1 FROM lpedidocliente WHERE idpedidocliente = idp LOOP
	totalRE := totalRE + res.subtotal1;
    END LOOP;

    FOR res IN SELECT proporciondpedidocliente FROM dpedidocliente WHERE idpedidocliente = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas * (1 - res.proporciondpedidocliente / 100);
	totalIRPF := totalIRPF * (1 - res.proporciondpedidocliente / 100);
	totalIVA := totalIVA * (1 - res.proporciondpedidocliente / 100);
	totalRE := totalRE * (1 - res.proporciondpedidocliente / 100);
    END LOOP;

    totalTotal = totalBImponibleLineas - totalIRPF + totalIVA + totalRE;

    RETURN totalTotal;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calctotalpedcli(integer) OWNER TO postgres;

--
-- Name: calctotalpedpro(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calctotalpedpro(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    totalBImponibleLineas numeric(12, 4);
    totalIRPF numeric(12, 4);
    totalIVA numeric(12, 4);
    totalRE numeric(12, 4);
    totalTotal numeric(12, 2);
    res RECORD;
    res2 RECORD;

BEGIN
    totalBImponibleLineas := 0;
    totalIRPF := 0;
    totalIVA := 0;
    totalRE := 0;
    totalTotal := 0;

    FOR res IN SELECT cantlpedidoproveedor * pvplpedidoproveedor * (1 - descuentolpedidoproveedor / 100) AS subtotal1 FROM lpedidoproveedor WHERE idpedidoproveedor = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas + res.subtotal1;
    END LOOP;

    SELECT INTO res2 idproveedor FROM pedidoproveedor WHERE idpedidoproveedor = idp;

    SELECT INTO res irpfproveedor FROM proveedor WHERE idproveedor = res2.idproveedor;
    IF FOUND THEN
        totalIRPF := totalBImponibleLineas * (res.irpfproveedor / 100);
    END IF;

    FOR res IN SELECT cantlpedidoproveedor * pvplpedidoproveedor * (1 - descuentolpedidoproveedor / 100) * (ivalpedidoproveedor / 100) AS subtotal1 FROM lpedidoproveedor WHERE idpedidoproveedor = idp LOOP
	totalIVA := totalIVA + res.subtotal1;
    END LOOP;

    FOR res IN SELECT cantlpedidoproveedor * pvplpedidoproveedor * (1 - descuentolpedidoproveedor / 100) * (reqeqlpedidoproveedor / 100) AS subtotal1 FROM lpedidoproveedor WHERE idpedidoproveedor = idp LOOP
	totalRE := totalRE + res.subtotal1;
    END LOOP;

    FOR res IN SELECT proporciondpedidoproveedor FROM dpedidoproveedor WHERE idpedidoproveedor = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas * (1 - res.proporciondpedidoproveedor / 100);
	totalIRPF := totalIRPF * (1 - res.proporciondpedidoproveedor / 100);
	totalIVA := totalIVA * (1 - res.proporciondpedidoproveedor / 100);
	totalRE := totalRE * (1 - res.proporciondpedidoproveedor / 100);
    END LOOP;

    totalTotal = totalBImponibleLineas - totalIRPF + totalIVA + totalRE;

    RETURN totalTotal;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calctotalpedpro(integer) OWNER TO postgres;

--
-- Name: calctotalpres(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calctotalpres(integer) RETURNS numeric
    AS $_$
DECLARE
    idp ALIAS FOR $1;
    totalBImponibleLineas numeric(12, 4);
    totalIRPF numeric(12, 4);
    totalIVA numeric(12, 4);
    totalRE numeric(12, 4);
    totalTotal numeric(12, 2);
    res RECORD;
    res2 RECORD;

BEGIN
    totalBImponibleLineas := 0;
    totalIRPF := 0;
    totalIVA := 0;
    totalRE := 0;
    totalTotal := 0;

    FOR res IN SELECT cantlpresupuesto * pvplpresupuesto * (1 - descuentolpresupuesto / 100) AS subtotal1 FROM lpresupuesto WHERE idpresupuesto = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas + res.subtotal1;
    END LOOP;

    SELECT INTO res valor::numeric FROM configuracion WHERE LOWER(nombre) = 'irpf';
    IF FOUND THEN
        totalIRPF := totalBImponibleLineas * (res.valor / 100);
    END IF;

    FOR res IN SELECT cantlpresupuesto * pvplpresupuesto * (1 - descuentolpresupuesto / 100) * (ivalpresupuesto / 100) AS subtotal1 FROM lpresupuesto WHERE idpresupuesto = idp LOOP
	totalIVA := totalIVA + res.subtotal1;
    END LOOP;

    FOR res IN SELECT cantlpresupuesto * pvplpresupuesto * (1 - descuentolpresupuesto / 100) * (reqeqlpresupuesto / 100) AS subtotal1 FROM lpresupuesto WHERE idpresupuesto = idp LOOP
	totalRE := totalRE + res.subtotal1;
    END LOOP;

    FOR res IN SELECT proporciondpresupuesto FROM dpresupuesto WHERE idpresupuesto = idp LOOP
	totalBImponibleLineas := totalBImponibleLineas * (1 - res.proporciondpresupuesto / 100);
	totalIRPF := totalIRPF * (1 - res.proporciondpresupuesto / 100);
	totalIVA := totalIVA * (1 - res.proporciondpresupuesto / 100);
	totalRE := totalRE * (1 - res.proporciondpresupuesto / 100);
    END LOOP;

    totalTotal = totalBImponibleLineas - totalIRPF + totalIVA + totalRE;

    RETURN totalTotal;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calctotalpres(integer) OWNER TO postgres;

--
-- Name: calculacodigocompletoarticulo(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calculacodigocompletoarticulo() RETURNS "trigger"
    AS $$
DECLARE
	as RECORD;
	codigocompleto character varying(100);
	codnumeric integer;
BEGIN
	-- Lo primero comprobamos el el código del articulo no esté vacio y de ser así lo llenamos.
	IF NEW.codarticulo = '' THEN
		SELECT INTO as max(codarticulo) AS m FROM articulo WHERE idfamilia = NEW.idfamilia;
		IF FOUND THEN
			IF is_number(as.m) THEN
				codnumeric := to_number(as.m);
				codnumeric := codnumeric +1;
				NEW.codarticulo := CAST (codnumeric AS varchar);
				WHILE length(NEW.codarticulo) < 4 LOOP
					NEW.codarticulo := '0' || NEW.codarticulo;
				END LOOP;
			ELSE
				NEW.codarticulo := '0000';
			END IF;
		ELSE
			NEW.codarticulo = '0000';
		END IF;
	END IF;

	codigocompleto := NEW.codarticulo;
	SELECT INTO as codigocompletofamilia FROM familia WHERE idfamilia = NEW.idfamilia;
	IF FOUND THEN
		codigocompleto := as.codigocompletofamilia || codigocompleto;
	END IF;
        NEW.codigocompletoarticulo := codigocompleto;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calculacodigocompletoarticulo() OWNER TO postgres;

--
-- Name: calculacodigocompletofamilia(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION calculacodigocompletofamilia() RETURNS "trigger"
    AS $$
DECLARE
	as RECORD;
	codigocompleto character varying(50);
BEGIN
	codigocompleto := NEW.codigofamilia;
	SELECT INTO as codigocompletofamilia FROM familia WHERE idfamilia = NEW.padrefamilia;
	IF FOUND THEN
		codigocompleto := as.codigocompletofamilia || codigocompleto;
	END IF;
        NEW.codigocompletofamilia := codigocompleto;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.calculacodigocompletofamilia() OWNER TO postgres;

--
-- Name: conectabulmacont(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION conectabulmacont() RETURNS integer
    AS $$
DECLARE
	bs RECORD;
	quer TEXT;
BEGIN
	SELECT INTO bs * FROM configuracion WHERE nombre='DataBaseContabilidad';
	quer := 'dbname=' || bs.valor;
	PERFORM dblink_connect(quer);
	PERFORM dblink_exec( 'SET DATESTYLE TO SQL,European');
	RETURN 0;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.conectabulmacont() OWNER TO root;

--
-- Name: crearef(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION crearef() RETURNS character varying
    AS $$
DECLARE
    asd RECORD;
    result character varying(15);
    efound boolean;

BEGIN
    efound := FALSE;
    WHILE efound = FALSE LOOP
	result := random_string(6);
	efound := TRUE;
	SELECT INTO asd idpresupuesto FROM presupuesto WHERE refpresupuesto = result;
	IF FOUND THEN
	    efound := FALSE;
	END IF;
	SELECT INTO asd idpedidocliente FROM pedidocliente WHERE refpedidocliente = result;
	IF FOUND THEN
	    efound := FALSE;
	END IF;
	SELECT INTO asd idalbaran FROM albaran WHERE refalbaran = result;
	IF FOUND THEN
	    efound := FALSE;
	END IF;	
	SELECT INTO asd idfactura FROM factura WHERE reffactura = result;
	IF FOUND THEN
		efound := FALSE;
	END IF;
	SELECT INTO asd idcobro FROM cobro WHERE refcobro = result;
	IF FOUND THEN
		efound := FALSE;
	END IF;
	SELECT INTO asd idpedidoproveedor FROM pedidoproveedor WHERE refpedidoproveedor = result;
	IF FOUND THEN
		efound := FALSE;
	END IF;
	SELECT INTO asd idalbaranp FROM albaranp WHERE refalbaranp = result;
	IF FOUND THEN
		efound := FALSE;
	END IF;
	SELECT INTO asd idfacturap FROM facturap WHERE reffacturap = result;
	IF FOUND THEN
		efound := FALSE;
	END IF;
	SELECT INTO asd idpago FROM pago WHERE refpago = result;
	IF FOUND THEN
		efound := FALSE;
	END IF;
    END LOOP;
    RETURN result;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.crearef() OWNER TO postgres;

--
-- Name: crearutacomercial(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION crearutacomercial(date) RETURNS integer
    AS $_$
DECLARE
	fecha ALIAS FOR $1;
	client RECORD;
	nfechabase DATE;

BEGIN
	FOR client IN SELECT * FROM cliente LOOP
		nfechabase := client.fechabasecomercialcliente;
		RAISE NOTICE 'Nuevo Cliente';
		WHILE nfechabase <= fecha LOOP
			RAISE NOTICE ' Nuevo ciclo % %', nfechabase, fecha;
			IF fecha = nfechabase THEN
				-- Aqui toca crear la hoja de ruta.
				-- Al final actualizamos la fecha base para que los calculos sean siempre lo menos
				-- complejos y largos posible.
				RAISE NOTICE 'Hemos llegado al quiz';
				-- UPDATE cliente set fechabasecomercialcliente = nfechabase WHERE idcliente = client.idcliente;
			END IF;
			nfechabase := nfechabase + client.periodocomercialcliente;
--			RAISE NOTICE ' Calculo % %', nfechabase, fecha;
		END LOOP;
	END LOOP;
	RETURN 0;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.crearutacomercial(date) OWNER TO postgres;

--
-- Name: dblink(text); Type: FUNCTION; Schema: public; Owner: ubuntu
--

CREATE FUNCTION dblink(text) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text) OWNER TO ubuntu;

--
-- Name: dblink(text, text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink(text, text) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text, text) OWNER TO root;

--
-- Name: dblink(text, text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink(text, text, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text, text, boolean) OWNER TO root;

--
-- Name: dblink(text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink(text, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text, boolean) OWNER TO root;

--
-- Name: dblink_build_sql_delete(text, int2vector, integer, text[]); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_build_sql_delete(text, int2vector, integer, text[]) RETURNS text
    AS '$libdir/dblink', 'dblink_build_sql_delete'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_build_sql_delete(text, int2vector, integer, text[]) OWNER TO root;

--
-- Name: dblink_build_sql_insert(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_build_sql_insert(text, int2vector, integer, text[], text[]) RETURNS text
    AS '$libdir/dblink', 'dblink_build_sql_insert'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_build_sql_insert(text, int2vector, integer, text[], text[]) OWNER TO root;

--
-- Name: dblink_build_sql_update(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_build_sql_update(text, int2vector, integer, text[], text[]) RETURNS text
    AS '$libdir/dblink', 'dblink_build_sql_update'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_build_sql_update(text, int2vector, integer, text[], text[]) OWNER TO root;

--
-- Name: dblink_cancel_query(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_cancel_query(text) RETURNS text
    AS '$libdir/dblink', 'dblink_cancel_query'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_cancel_query(text) OWNER TO root;

--
-- Name: dblink_close(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_close(text) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text) OWNER TO root;

--
-- Name: dblink_close(text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_close(text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text, boolean) OWNER TO root;

--
-- Name: dblink_close(text, text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_close(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text, text) OWNER TO root;

--
-- Name: dblink_close(text, text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_close(text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text, text, boolean) OWNER TO root;

--
-- Name: dblink_connect(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_connect(text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_connect(text) OWNER TO root;

--
-- Name: dblink_connect(text, text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_connect(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_connect(text, text) OWNER TO root;

--
-- Name: dblink_connect_u(text); Type: FUNCTION; Schema: public; Owner: ubuntu
--

CREATE FUNCTION dblink_connect_u(text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT SECURITY DEFINER;


ALTER FUNCTION public.dblink_connect_u(text) OWNER TO ubuntu;

--
-- Name: dblink_connect_u(text, text); Type: FUNCTION; Schema: public; Owner: ubuntu
--

CREATE FUNCTION dblink_connect_u(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT SECURITY DEFINER;


ALTER FUNCTION public.dblink_connect_u(text, text) OWNER TO ubuntu;

--
-- Name: dblink_current_query(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_current_query() RETURNS text
    AS '$libdir/dblink', 'dblink_current_query'
    LANGUAGE c;


ALTER FUNCTION public.dblink_current_query() OWNER TO root;

--
-- Name: dblink_disconnect(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_disconnect() RETURNS text
    AS '$libdir/dblink', 'dblink_disconnect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_disconnect() OWNER TO root;

--
-- Name: dblink_disconnect(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_disconnect(text) RETURNS text
    AS '$libdir/dblink', 'dblink_disconnect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_disconnect(text) OWNER TO root;

--
-- Name: dblink_error_message(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_error_message(text) RETURNS text
    AS '$libdir/dblink', 'dblink_error_message'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_error_message(text) OWNER TO root;

--
-- Name: dblink_exec(text, text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_exec(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text, text) OWNER TO root;

--
-- Name: dblink_exec(text, text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_exec(text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text, text, boolean) OWNER TO root;

--
-- Name: dblink_exec(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_exec(text) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text) OWNER TO root;

--
-- Name: dblink_exec(text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_exec(text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text, boolean) OWNER TO root;

--
-- Name: dblink_fetch(text, integer); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_fetch(text, integer) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, integer) OWNER TO root;

--
-- Name: dblink_fetch(text, integer, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_fetch(text, integer, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, integer, boolean) OWNER TO root;

--
-- Name: dblink_fetch(text, text, integer); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_fetch(text, text, integer) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, text, integer) OWNER TO root;

--
-- Name: dblink_fetch(text, text, integer, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_fetch(text, text, integer, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, text, integer, boolean) OWNER TO root;

--
-- Name: dblink_get_connections(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_get_connections() RETURNS text[]
    AS '$libdir/dblink', 'dblink_get_connections'
    LANGUAGE c;


ALTER FUNCTION public.dblink_get_connections() OWNER TO root;

--
-- Name: dblink_get_pkey(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_get_pkey(text) RETURNS SETOF dblink_pkey_results
    AS '$libdir/dblink', 'dblink_get_pkey'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_get_pkey(text) OWNER TO root;

--
-- Name: dblink_get_result(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_get_result(text) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_get_result'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_get_result(text) OWNER TO root;

--
-- Name: dblink_get_result(text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_get_result(text, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_get_result'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_get_result(text, boolean) OWNER TO root;

--
-- Name: dblink_is_busy(text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_is_busy(text) RETURNS integer
    AS '$libdir/dblink', 'dblink_is_busy'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_is_busy(text) OWNER TO root;

--
-- Name: dblink_open(text, text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_open(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text) OWNER TO root;

--
-- Name: dblink_open(text, text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_open(text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text, boolean) OWNER TO root;

--
-- Name: dblink_open(text, text, text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_open(text, text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text, text) OWNER TO root;

--
-- Name: dblink_open(text, text, text, boolean); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_open(text, text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text, text, boolean) OWNER TO root;

--
-- Name: dblink_send_query(text, text); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION dblink_send_query(text, text) RETURNS integer
    AS '$libdir/dblink', 'dblink_send_query'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_send_query(text, text) OWNER TO root;

--
-- Name: disminuyestock(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION disminuyestock() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    -- Hacemos el update del stock del articulo
    UPDATE articulo SET stockarticulo = stockarticulo + OLD.cantlalbaran WHERE idarticulo= OLD.idarticulo;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.disminuyestock() OWNER TO postgres;

--
-- Name: disminuyestockp(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION disminuyestockp() RETURNS "trigger"
    AS $$
DECLARE

BEGIN
    -- Hacemos el update del stock del articulo
    UPDATE articulo SET stockarticulo = stockarticulo - OLD.cantlalbaranp WHERE idarticulo= OLD.idarticulo;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.disminuyestockp() OWNER TO postgres;

--
-- Name: is_number(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION is_number(character varying) RETURNS boolean
    AS $_$select $1 ~ '^[-+]?[0-9]+$'$_$
    LANGUAGE sql IMMUTABLE STRICT;


ALTER FUNCTION public.is_number(character varying) OWNER TO postgres;

--
-- Name: ivaarticulo(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION ivaarticulo(integer) RETURNS numeric
    AS $_$
DECLARE
	idarticulo ALIAS FOR $1;
	as RECORD;
BEGIN
	SELECT INTO AS * FROM tipo_iva, tasa_iva, articulo WHERE tasa_iva.idtipo_iva = tipo_iva.idtipo_iva AND tipo_iva.idtipo_iva = articulo.idtipo_iva AND articulo.idarticulo = idarticulo ORDER BY fechatasa_iva;
	IF FOUND THEN
		RETURN as.porcentasa_iva;
	END IF;
	RETURN 0.0;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.ivaarticulo(integer) OWNER TO postgres;

--
-- Name: modificadostock(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION modificadostock() RETURNS "trigger"
    AS $$
DECLARE 
	cant numeric;
	as RECORD;
BEGIN
	IF NEW.stockarticulo <> OLD.stockarticulo THEN
		cant := NEW.stockarticulo - OLD.stockarticulo;
		FOR as IN SELECT * FROM comparticulo WHERE idarticulo = NEW.idarticulo LOOP
			UPDATE articulo SET stockarticulo = stockarticulo + cant * as.cantcomparticulo WHERE idarticulo = as.idcomponente;
		END LOOP;
	END IF;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.modificadostock() OWNER TO postgres;

--
-- Name: ncuadrante(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION ncuadrante() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;
BEGIN
    IF NEW.aperturacuadrante IS NULL THEN
	SELECT INTO as * FROM almacen WHERE idalmacen = NEW.idalmacen;
	NEW.aperturacuadrante = as.aperturaalmacen;
	NEW.cierrecuadrante = as.cierrealmacen;
	NEW.apertura1cuadrante = as.apertura1almacen;
	NEW.cierre1cuadrante = as.cierre1almacen;
    END IF;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.ncuadrante() OWNER TO postgres;

--
-- Name: plpgsql_call_handler(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
    AS '$libdir/plpgsql', 'plpgsql_call_handler'
    LANGUAGE c;


ALTER FUNCTION public.plpgsql_call_handler() OWNER TO postgres;

--
-- Name: propagacodigocompletofamilia(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION propagacodigocompletofamilia() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
	UPDATE familia SET codigocompletofamilia=codigocompletofamilia WHERE padrefamilia = NEW.idfamilia;
	UPDATE articulo SET codigocompletoarticulo = codigocompletoarticulo WHERE articulo.idfamilia = NEW.idfamilia;
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.propagacodigocompletofamilia() OWNER TO postgres;

--
-- Name: pvparticulo(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION pvparticulo(integer) RETURNS numeric
    AS $_$
DECLARE
	idarticulo ALIAS FOR $1;
	as RECORD;
BEGIN
	SELECT INTO AS pvparticulo FROM  articulo WHERE articulo.idarticulo = idarticulo;
	IF FOUND THEN
		RETURN as.pvparticulo;
	END IF;
	RETURN 0.0;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.pvparticulo(integer) OWNER TO postgres;

--
-- Name: pvparticuloclial(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION pvparticuloclial(integer, integer, integer) RETURNS numeric
    AS $_$
DECLARE
	idarticulo ALIAS FOR $1;
	idclient ALIAS FOR $2;
	idalmacen ALIAS FOR $3;
	as RECORD;
BEGIN
	SELECT INTO AS pvpltarifa FROM ltarifa WHERE ltarifa.idarticulo = idarticulo AND ltarifa.idalmacen = idalmacen AND idtarifa IN (SELECT idtarifa FROM cliente WHERE idcliente=idclient);
	IF FOUND THEN
		RETURN as.pvpltarifa;
	END IF;


	SELECT INTO AS pvparticulo FROM  articulo WHERE articulo.idarticulo = idarticulo;
	IF FOUND THEN
		RETURN as.pvparticulo;
	END IF;
	RETURN 0.0;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.pvparticuloclial(integer, integer, integer) OWNER TO postgres;

--
-- Name: random_string(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION random_string(integer) RETURNS character varying
    AS $_$
DECLARE
    iLoop int4;
    result varchar;

BEGIN
    result = '';
    IF ($1 > 0) AND ($1 < 255) THEN
	FOR iLoop in 1 .. $1 LOOP
	    result = result || chr(int4(random()*25)+65);
	END LOOP;
	RETURN result;
    ELSE
	RETURN 'f';
    END IF;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.random_string(integer) OWNER TO postgres;

--
-- Name: restriccionesalbaran(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionesalbaran() RETURNS "trigger"
    AS $$
DECLARE
asd RECORD;
BEGIN
	IF NEW.fechaalbaran IS NULL THEN
		NEW.fechaalbaran := now();
	END IF;
        IF NEW.numalbaran IS NULL THEN
                SELECT INTO asd max(numalbaran) AS m FROM albaran;
		IF asd.m IS NOT NULL THEN
			NEW.numalbaran := asd.m + 1;
		ELSE
			NEW.numalbaran := 1;
		END IF;
        END IF;
	IF NEW.refalbaran IS NULL OR NEW.refalbaran = '' THEN
		SELECT INTO asd crearef() AS m;
		IF FOUND THEN
			NEW.refalbaran := asd.m;
		END IF;
	END IF;
        RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionesalbaran() OWNER TO postgres;

--
-- Name: restriccionesalbaranp(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionesalbaranp() RETURNS "trigger"
    AS $$
DECLARE
asd RECORD;
BEGIN
	IF NEW.fechaalbaranp IS NULL THEN
		NEW.fechaalbaranp := now();
	END IF;
        IF NEW.numalbaranp IS NULL THEN
                SELECT INTO asd max(numalbaranp) AS m FROM albaranp;
		IF asd.m IS NOT NULL THEN
			NEW.numalbaranp := asd.m + 1;
		ELSE
			NEW.numalbaranp := 1;
		END IF;
        END IF;
	IF NEW.refalbaranp IS NULL OR NEW.refalbaranp = '' THEN
		SELECT INTO asd crearef() AS m;
		IF FOUND THEN
			NEW.refalbaranp := asd.m;
		END IF;
	END IF;
        RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionesalbaranp() OWNER TO postgres;

--
-- Name: restriccionescobro(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionescobro() RETURNS "trigger"
    AS $$
DECLARE
    asd RECORD;

BEGIN
    IF NEW.fechacobro IS NULL THEN
	NEW.fechacobro := now();
    END IF;
    IF NEW.refcobro IS NULL OR NEW.refcobro = '' THEN
	SELECT INTO asd crearef() AS m;
	IF FOUND THEN
	    NEW.refcobro := asd.m;
	END IF;
    END IF;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionescobro() OWNER TO postgres;

--
-- Name: restriccionesfactura(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionesfactura() RETURNS "trigger"
    AS $$
DECLARE
    asd RECORD;

BEGIN
    IF NEW.ffactura IS NULL THEN
	NEW.ffactura := now();
    END IF;
    IF NEW.numfactura IS NULL THEN
	SELECT INTO asd max(numfactura) AS m FROM factura WHERE codigoserie_factura = NEW.codigoserie_factura AND idalmacen = NEW.idalmacen;
	IF asd.m IS NOT NULL THEN
	    NEW.numfactura := asd.m + 1;
	ELSE
	    NEW.numfactura := 1;
	END IF;
    END IF;
    IF NEW.reffactura IS NULL OR NEW.reffactura = '' THEN
	SELECT INTO asd crearef() AS m;
	IF FOUND THEN
	    NEW.reffactura := asd.m;
	END IF;
    END IF;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionesfactura() OWNER TO postgres;

--
-- Name: restriccionesfacturap(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionesfacturap() RETURNS "trigger"
    AS $$
DECLARE
asd RECORD;
BEGIN
	IF NEW.ffacturap IS NULL THEN
		NEW.ffacturap := now();
	END IF;
	IF NEW.reffacturap IS NULL OR NEW.reffacturap = '' THEN
		SELECT INTO asd crearef() AS m;
		IF FOUND THEN
			NEW.reffacturap := asd.m;
		END IF;
	END IF;
        RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionesfacturap() OWNER TO postgres;

--
-- Name: restriccioneslfactura(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccioneslfactura() RETURNS "trigger"
    AS $$
DECLARE
asd RECORD;
reg RECORD;
BEGIN
	IF NEW.idarticulo IS NULL THEN
	RAISE EXCEPTION 'ARTICULO INVALIDO';
	return OLD;
	END IF;

	FOR asd IN SELECT * FROM articulo WHERE idarticulo=NEW.idarticulo LOOP
        	IF NEW.desclfactura IS NULL THEN
			NEW.desclfactura := asd.nomarticulo;
		END IF;
		IF NEW.cantlfactura IS NULL THEN
			NEW.cantlfactura := 1;
		END IF;
		IF NEW.descuentolfactura IS NULL THEN
			NEW.descuentolfactura := 0;
		END IF;
		IF NEW.pvplfactura IS NULL THEN
			SELECT INTO reg pvparticulo(NEW.idarticulo) AS precio;
			NEW.pvplfactura := reg.precio;
		END IF;
		IF NEW.ivalfactura IS NULL then
			SELECT INTO reg ivaarticulo(NEW.idarticulo) AS iva;
			NEW.ivalfactura := reg.iva;
		END IF;
	END LOOP;	
        RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccioneslfactura() OWNER TO postgres;

--
-- Name: restriccionespago(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionespago() RETURNS "trigger"
    AS $$
DECLARE
    asd RECORD;

BEGIN
    IF NEW.fechapago IS NULL THEN
	NEW.fechapago := now();
    END IF;
    IF NEW.refpago IS NULL OR NEW.refpago = '' THEN
	SELECT INTO asd crearef() AS m;
	IF FOUND THEN
	    NEW.refpago := asd.m;
	END IF;
    END IF;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionespago() OWNER TO postgres;

--
-- Name: restriccionespedidocliente(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionespedidocliente() RETURNS "trigger"
    AS $$
DECLARE
asd RECORD;
BEGIN
	IF NEW.fechapedidocliente IS NULL THEN
		NEW.fechapedidocliente := now();
	END IF;
        IF NEW.numpedidocliente IS NULL THEN
                SELECT INTO asd max(numpedidocliente) AS m FROM pedidocliente;
		IF asd.m IS NOT NULL THEN
			NEW.numpedidocliente := asd.m + 1;
		ELSE
			NEW.numpedidocliente := 1;
		END IF;
        END IF;
	IF NEW.refpedidocliente IS NULL OR NEW.refpedidocliente = '' THEN
		SELECT INTO asd crearef() AS m;
		IF FOUND THEN
			NEW.refpedidocliente := asd.m;
		END IF;
	END IF;
        RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionespedidocliente() OWNER TO postgres;

--
-- Name: restriccionespedidoproveedor(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionespedidoproveedor() RETURNS "trigger"
    AS $$
DECLARE
asd RECORD;
BEGIN
	IF NEW.fechapedidoproveedor IS NULL THEN
		NEW.fechapedidoproveedor := now();
	END IF;
        IF NEW.numpedidoproveedor IS NULL THEN
                SELECT INTO asd max(numpedidoproveedor) AS m FROM pedidoproveedor;
		IF asd.m IS NOT NULL THEN
			NEW.numpedidoproveedor := asd.m + 1;
		ELSE
			NEW.numpedidoproveedor := 1;
		END IF;
        END IF;
	IF NEW.refpedidoproveedor IS NULL OR NEW.refpedidoproveedor = '' THEN
		SELECT INTO asd crearef() AS m;
		IF FOUND THEN
			NEW.refpedidoproveedor := asd.m;
		END IF;
	END IF;
        RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionespedidoproveedor() OWNER TO postgres;

--
-- Name: restriccionespresupuesto(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION restriccionespresupuesto() RETURNS "trigger"
    AS $$
DECLARE
asd RECORD;
BEGIN
	IF NEW.fpresupuesto IS NULL THEN
		NEW.fpresupuesto := now();
	END IF;
        IF NEW.numpresupuesto IS NULL THEN
                SELECT INTO asd max(numpresupuesto) AS m FROM presupuesto;
		IF asd.m IS NOT NULL THEN	
			NEW.numpresupuesto := asd.m + 1;
		ELSE

			NEW.numpresupuesto := 1;
		END IF;			
        END IF;
	IF NEW.refpresupuesto IS NULL OR NEW.refpresupuesto = '' THEN
		SELECT INTO asd crearef() AS m;
		IF FOUND THEN
			NEW.refpresupuesto := asd.m;
		END IF;
	END IF;
        RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.restriccionespresupuesto() OWNER TO postgres;

--
-- Name: s_aumentacontrolstock(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_aumentacontrolstock() RETURNS "trigger"
    AS $$
DECLARE

BEGIN
    UPDATE articulo SET stockarticulo = stockarticulo + NEW.stocknewcontrolstock - NEW.stockantcontrolstock WHERE idarticulo = NEW.idarticulo;
    -- Hacemos el update del stock por almacenes
    UPDATE stock_almacen SET stock = NEW.stocknewcontrolstock WHERE idarticulo = NEW.idarticulo AND idalmacen = NEW.idalmacen;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_aumentacontrolstock() OWNER TO postgres;

--
-- Name: s_aumentastock(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_aumentastock() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    -- Hacemos el update del stock por almacenes
    UPDATE stock_almacen SET stock = stock - NEW.cantlalbaran WHERE idarticulo = NEW.idarticulo AND idalmacen IN (SELECT idalmacen FROM albaran WHERE idalbaran=NEW.idalbaran);
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_aumentastock() OWNER TO postgres;

--
-- Name: s_aumentastockp(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_aumentastockp() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    -- Hacemos el update del stock por almacenes
    UPDATE stock_almacen SET stock = stock + NEW.cantlalbaranp WHERE idarticulo = NEW.idarticulo AND idalmacen IN (SELECT idalmacen FROM albaranp WHERE idalbaranp=NEW.idalbaranp);
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_aumentastockp() OWNER TO postgres;

--
-- Name: s_cambiaalbaran(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_cambiaalbaran() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;

BEGIN
    IF NEW.idalmacen <> OLD.idalmacen THEN
	FOR as IN SELECT * FROM lalbaran WHERE idalbaran = NEW.idalbaran LOOP
    	    UPDATE stock_almacen SET stock = stock + as.cantlalbaran WHERE idarticulo = as.idarticulo AND idalmacen = OLD.idalmacen;
	    UPDATE stock_almacen SET stock = stock - as.cantlalbaran WHERE idarticulo = as.idarticulo AND idalmacen = NEW.idalmacen;
	END LOOP;
    END IF;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_cambiaalbaran() OWNER TO postgres;

--
-- Name: s_cambiaalbaranp(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_cambiaalbaranp() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;

BEGIN
    IF NEW.idalmacen <> OLD.idalmacen THEN
	FOR as IN SELECT * FROM lalbaranp WHERE idalbaranp = NEW.idalbaranp LOOP
	    UPDATE stock_almacen SET stock = stock - as.cantlalbaranp WHERE idarticulo = as.idarticulo AND idalmacen = OLD.idalmacen;
	    UPDATE stock_almacen SET stock = stock + as.cantlalbaranp WHERE idarticulo = as.idarticulo AND idalmacen = NEW.idalmacen;
	END LOOP;
    END IF;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_cambiaalbaranp() OWNER TO postgres;

--
-- Name: s_dalmacen(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_dalmacen() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    DELETE FROM stock_almacen WHERE idalmacen = OLD.idalmacen;
    RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_dalmacen() OWNER TO postgres;

--
-- Name: s_darticulo(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_darticulo() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    DELETE FROM stock_almacen WHERE idarticulo = OLD.idarticulo;
    RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_darticulo() OWNER TO postgres;

--
-- Name: s_disminuyecontrolstock(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_disminuyecontrolstock() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    -- Hacemos el update del stock del articulo
    UPDATE articulo SET stockarticulo = stockarticulo - OLD.stocknewcontrolstock + OLD.stockantcontrolstock WHERE idarticulo= OLD.idarticulo;
    -- Hacemos el update del stock por almacenes
    UPDATE stock_almacen SET stock = stock - OLD.stocknewcontrolstock + OLD.stockantcontrolstock WHERE idarticulo = OLD.idarticulo AND idalmacen = OLD.idalmacen;
    RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_disminuyecontrolstock() OWNER TO postgres;

--
-- Name: s_disminuyecontrolstock1(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_disminuyecontrolstock1() RETURNS "trigger"
    AS $$
DECLARE
    rant RECORD;

BEGIN
    -- Cogemos el stock anterior.
    FOR rant IN SELECT * FROM stock_almacen WHERE idarticulo = NEW.idarticulo AND idalmacen = NEW.idalmacen LOOP
	NEW.stockantcontrolstock := rant.stock;
    END LOOP;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_disminuyecontrolstock1() OWNER TO postgres;

--
-- Name: s_disminuyecontrolstock2(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_disminuyecontrolstock2() RETURNS "trigger"
    AS $$
DECLARE
    rant RECORD;

BEGIN
    -- Hacemos el update del stock del articulo
    UPDATE articulo SET stockarticulo = stockarticulo - OLD.stocknewcontrolstock + OLD.stockantcontrolstock WHERE idarticulo= OLD.idarticulo;
    -- Hacemos el update del stock por almacenes
    UPDATE stock_almacen SET stock = stock - OLD.stocknewcontrolstock + OLD.stockantcontrolstock WHERE idarticulo = OLD.idarticulo AND idalmacen = OLD.idalmacen;
    -- Cogemos el stock anterior.
    FOR rant IN SELECT * FROM stock_almacen WHERE idarticulo = NEW.idarticulo AND idalmacen = NEW.idalmacen LOOP
	NEW.stockantcontrolstock := rant.stock;
    END LOOP;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_disminuyecontrolstock2() OWNER TO postgres;

--
-- Name: s_disminuyestock(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_disminuyestock() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    -- Hacemos el update del stock por almacenes
    UPDATE stock_almacen SET stock = stock + OLD.cantlalbaran WHERE idarticulo = OLD.idarticulo AND idalmacen IN (SELECT idalmacen FROM albaran WHERE idalbaran = OLD.idalbaran);
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_disminuyestock() OWNER TO postgres;

--
-- Name: s_disminuyestockp(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_disminuyestockp() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    -- Hacemos el update del stock por almacenes
    UPDATE stock_almacen SET stock = stock - OLD.cantlalbaranp WHERE idarticulo = OLD.idarticulo AND idalmacen IN (SELECT idalmacen FROM albaranp WHERE idalbaranp=OLD.idalbaranp);
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_disminuyestockp() OWNER TO postgres;

--
-- Name: s_modificadostockalmacen(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_modificadostockalmacen() RETURNS "trigger"
    AS $$
DECLARE 
    cant numeric;
    as RECORD;
BEGIN
    IF NEW.stock <> OLD.stock THEN
	cant := NEW.stock - OLD.stock;
	FOR as IN SELECT * FROM comparticulo WHERE idarticulo = NEW.idarticulo LOOP
	    UPDATE stock_almacen SET stock = stock + cant * as.cantcomparticulo WHERE idarticulo = as.idcomponente AND idalmacen = NEW.idalmacen;
	END LOOP;
    END IF;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_modificadostockalmacen() OWNER TO postgres;

--
-- Name: s_nalmacen(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_nalmacen() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;
BEGIN
    FOR as IN SELECT * FROM articulo LOOP
	INSERT INTO stock_almacen (idarticulo, idalmacen, stock) VALUES (as.idarticulo, NEW.idalmacen, 0);
    END LOOP;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_nalmacen() OWNER TO postgres;

--
-- Name: s_narticulo(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION s_narticulo() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;
BEGIN
    FOR as IN SELECT * FROM almacen LOOP
	INSERT INTO stock_almacen (idarticulo, idalmacen, stock) VALUES (NEW.idarticulo, as.idalmacen, 0);
    END LOOP;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.s_narticulo() OWNER TO postgres;

--
-- Name: syncbulmacontalmacend(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontalmacend() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idcuentaalmacen IS NOT NULL THEN
		query := 'DELETE FROM cuenta WHERE idcuenta = ' || OLD.idcuentaalmacen;
		PERFORM dblink_exec(query);
	END IF;
	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontalmacend() OWNER TO root;

--
-- Name: syncbulmacontalmacenu(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontalmacenu() RETURNS "trigger"
    AS $$
DECLARE
	cs RECORD;
	bs RECORD;
	codcta INTEGER;
	quer TEXT;
	idpadre INTEGER;
	descripcion TEXT;
	tipocuenta1 INTEGER;
BEGIN
	-- conectamos con contabilidad, etc
	PERFORM conectabulmacont();

	-- Cogemos el nombre de la cuenta.
	descripcion := quote_literal(NEW.nomalmacen);

	-- Hacemos el update del stock del articulo
	IF NEW.idcuentaalmacen IS NULL THEN
		-- Buscamos el codigo de cuenta que vaya a corresponderle
		SELECT INTO cs  max(codigo)::INTEGER as cod FROM bc_cuenta WHERE codigo LIKE '5700%' ;
		IF cs.cod IS NOT NULL THEN
			codcta := cs.cod;
			codcta := codcta +1;
		ELSE
			codcta := '5700001';
		END IF;
	
		-- Buscamos la cuenta padre (la 4300)
		SELECT INTO bs idcuenta, tipocuenta FROM bc_cuenta WHERE codigo ='570';
		idpadre := bs.idcuenta;
		tipocuenta1 := bs.tipocuenta;
	

	
		-- Creamos el Query de insercion
		quer := 'INSERT INTO cuenta (descripcion, padre, codigo, tipocuenta) VALUES ( ' || descripcion ||', ' || idpadre || ', ''' || codcta || ''' , '|| tipocuenta1 || ')';
		PERFORM dblink_exec(quer);
	
		SELECT INTO bs  max(idcuenta) AS id FROM bc_cuenta;
		NEW.idcuentaalmacen := bs.id;
	ELSE
		quer := 'UPDATE cuenta SET descripcion =' || descripcion || ' WHERE idcuenta =' || NEW.idcuentaalmacen;
		PERFORM dblink_exec(quer);
	END IF;


	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontalmacenu() OWNER TO root;

--
-- Name: syncbulmacontbancod(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontbancod() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idasientobanco IS NOT NULL THEN
		query := 'DELETE FROM cuenta WHERE idcuenta = ' || OLD.idcuentabanco;
		PERFORM dblink_exec(query);

	END IF;

	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontbancod() OWNER TO root;

--
-- Name: syncbulmacontbancou(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontbancou() RETURNS "trigger"
    AS $$
DECLARE
	bs RECORD;
	codcta INTEGER;
	quer TEXT;
	idpadre INTEGER;
	descripcion TEXT;
	tipocuenta1 INTEGER;
BEGIN
	-- conectamos con contabilidad, etc
	PERFORM conectabulmacont();

	-- Cogemos el nombre de la cuenta.
	descripcion := quote_literal(NEW.nombanco);

	-- Hacemos el update del stock del articulo
	IF NEW.idcuentabanco IS NULL THEN
		-- Buscamos el codigo de cuenta que vaya a corresponderle
		SELECT INTO bs  max(codigo)::INTEGER as cod FROM bc_cuenta WHERE codigo LIKE '5730%' ;
		IF FOUND THEN
			codcta := bs.cod;
			codcta := codcta +1;
		ELSE
			codcta := '5730001';
		END IF;
	
		-- Buscamos la cuenta padre (la 4300)
		SELECT INTO bs idcuenta, tipocuenta FROM bc_cuenta WHERE codigo ='573';
		idpadre := bs.idcuenta;
		tipocuenta1 := bs.tipocuenta;
	
		-- Creamos el Query de insercion
		quer := 'INSERT INTO cuenta (descripcion, padre, codigo, tipocuenta) VALUES ( ' || descripcion ||', ' || idpadre || ', ''' || codcta || ''' , '|| tipocuenta1 || ')';
		PERFORM dblink_exec(quer);
	
		SELECT INTO bs  max(idcuenta) AS id FROM bc_cuenta;
		NEW.idcuentabanco := bs.id;
	ELSE
		quer := 'UPDATE cuenta SET descripcion =' || descripcion || ' WHERE idcuenta =' || NEW.idcuentabanco;
		PERFORM dblink_exec(quer);
	END IF;


	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontbancou() OWNER TO root;

--
-- Name: syncbulmacontcliented(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontcliented() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idcuentacliente IS NOT NULL THEN
		query := 'DELETE FROM  cuenta WHERE idcuenta = ' || OLD.idcuentacliente ;
		PERFORM dblink_exec(query);
	END IF;

	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontcliented() OWNER TO root;

--
-- Name: syncbulmacontclienteu(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontclienteu() RETURNS "trigger"
    AS $$
DECLARE
	bs RECORD;
	quer TEXT;
	subquery TEXT;
	codcta INTEGER;
	idpadre INTEGER;
	descripcion TEXT;
	cp TEXT;
	cif TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo

	-- Cogemos el nombre de la cuenta.
	descripcion := quote_literal(NEW.nomcliente);
	cp := substring(NEW.cpcliente, length(NEW.cpcliente)-4, 5);
	cif := substring(NEW.cifcliente, length(NEW.cifcliente)-11, 12);

	IF NEW.idcuentacliente IS NULL THEN
		-- Buscamos el codigo de cuenta que vaya a corresponderle
		SELECT INTO bs  max(codigo)::INTEGER as cod FROM bc_cuenta WHERE codigo LIKE '4300%' ;
		IF FOUND THEN
			codcta := bs.cod;
			codcta := codcta +1;
		ELSE
			codcta := '4300001';
		END IF;
	
		-- Buscamos la cuenta padre (la 4300)
		SELECT INTO bs idcuenta FROM bc_cuenta WHERE codigo ='4300';
		idpadre := bs.idcuenta;

		-- Creamos el Query de insercion
		quer := 'INSERT INTO cuenta (descripcion, padre, codigo) VALUES ( ' || descripcion ||', ' || idpadre || ', ''' || codcta || ''' )';

		PERFORM dblink_exec(quer);
	
	
		SELECT INTO bs  max(idcuenta) AS id FROM bc_cuenta;
	
		NEW.idcuentacliente = bs.id;
	ELSE
		quer := 'UPDATE cuenta SET descripcion = ' || descripcion || ', cifent_cuenta = ''' || cif || ''', nombreent_cuenta = ''' || NEW.nomaltcliente || ''', dirent_cuenta = ''' || NEW.dircliente || ''', cpent_cuenta = ''' || cp || ''', telent_cuenta = ''' || NEW.telcliente || ''', bancoent_cuenta = ''' || NEW.bancocliente || ''', emailent_cuenta = ''' || NEW.mailcliente || ''', webent_cuenta = ''' || NEW.urlcliente || ''' WHERE idcuenta= ' || NEW.idcuentacliente;
		PERFORM dblink_exec(quer);
	END IF;

	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontclienteu() OWNER TO root;

--
-- Name: syncbulmacontcobrod(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontcobrod() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idasientocobro IS NOT NULL THEN
		query := 'DELETE FROM apunte WHERE idasiento= ' || OLD.idasientocobro;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  borrador WHERE idasiento= ' || OLD.idasientocobro ;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  asiento WHERE idasiento = ' || OLD.idasientocobro;
		PERFORM dblink_exec(query);
	END IF;

	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontcobrod() OWNER TO root;

--
-- Name: syncbulmacontcobrou(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontcobrou() RETURNS "trigger"
    AS $$
DECLARE
	cs RECORD;
	client RECORD;
	qbanco RECORD;
	idctacliente TEXT;
	query TEXT;
	subquery TEXT;
	idctacobro INTEGER;
	flecha DATE;
	concepto TEXT;
	concepto1 TEXT;
	asientonuevo BOOLEAN;
BEGIN
	-- conectamos con contabilidad, etc
	PERFORM conectabulmacont();

	concepto := '[A. Automatico] Cobro ' || NEW.refcobro;
	concepto1 := 'Cobro ' || NEW.refcobro;

	
	-- Puede darse el caso de que el contable haya borrado el asiento. Y por eso comprobamos que realmente exista en la contabilidad.
	asientonuevo := TRUE;
	IF NEW.idasientocobro IS NOT NULL THEN
		query := 'SELECT idasiento FROM asiento WHERE idasiento =' || NEW.idasientocobro;
		SELECT INTO cs * FROM dblink(query) AS t1 (idasiento integer);
		IF FOUND THEN
			asientonuevo := FALSE;
		END IF;
	END IF;



	-- Hacemos el update del stock del articulo
	IF asientonuevo IS FALSE THEN
		query := 'DELETE FROM apunte WHERE idasiento= ' || NEW.idasientocobro;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM borrador WHERE idasiento= ' || NEW.idasientocobro;
		PERFORM dblink_exec(query);
		query := 'UPDATE asiento SET descripcion = ''' || concepto || ''', comentariosasiento = ''' || concepto || ''' WHERE idasiento = ' || NEW.idasientocobro;
		PERFORM dblink_exec(query);
	ELSE
		-- Hacemos el update del stock del articulo
		query := 'INSERT INTO asiento (fecha, descripcion, comentariosasiento) VALUES ( ' || quote_literal(NEW.fechacobro) || ', ''' || concepto || ''', ''' || concepto || ''')';
		PERFORM dblink_exec(query);

		SELECT INTO cs * FROM dblink('SELECT max(idasiento) AS id FROM asiento') AS t1 (id integer);
		NEW.idasientocobro = cs.id;
	END IF;


	-- Buscamos el cliente y su cuenta.
	SELECT INTO client idcuentacliente FROM cliente WHERE idcliente = NEW.idcliente;
	IF NOT FOUND THEN
		RAISE EXCEPTION 'El cliente no tiene cuenta asociada en la contabilidad';
	END IF;
	idctacliente := client.idcuentacliente;


	-- Buscamos el banco
	IF NEW.idbanco IS NOT NULL THEN
		SELECT INTO qbanco idcuentabanco FROM banco WHERE idbanco = NEW.idbanco;
		IF NOT FOUND THEN
			RAISE EXCEPTION 'El banco no tiene cuenta asociada en la contabilidad';
		END IF;
		idctacobro := qbanco.idcuentabanco;
	ELSE
		-- Buscamos la cuenta de servicio o de venta
		SELECT INTO cs MAX(idcuenta) AS id FROM bc_cuenta WHERE codigo LIKE '5700%';
		IF NOT FOUND THEN
			RAISE EXCEPTION 'No existe ls cuenta de Caja 5700...';
		END IF;
		idctacobro := cs.id;
	END IF;



	-- Apunte opr el proveedor
	query := 'INSERT INTO borrador (fecha, idcuenta, haber, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.fechacobro || ''', ' || idctacliente || ', ' || NEW.cantcobro || ', '|| NEW.idasientocobro ||', ''' || concepto1 || ''', ''Cobro'')';
	PERFORM dblink_exec(query);


	-- Apunte por caja o banco.
	query := 'INSERT INTO borrador (fecha, idcuenta, debe, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.fechacobro || ''', ' || idctacobro || ', ' || NEW.cantcobro || ', '|| NEW.idasientocobro ||', ''' || concepto1 || ''', ''Cobro'')';
	PERFORM dblink_exec(query);


	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontcobrou() OWNER TO root;

--
-- Name: syncbulmacontfacturad(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontfacturad() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idasientofactura IS NOT NULL THEN
		query := 'DELETE FROM registroiva WHERE idborrador IN (SELECT idborrador FROM borrador WHERE idasiento = ' || OLD.idasientofactura || ')';
		PERFORM dblink_exec(query);
		query := 'DELETE FROM apunte WHERE idasiento= ' || OLD.idasientofactura;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  borrador WHERE idasiento= ' || OLD.idasientofactura ;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  asiento WHERE idasiento = ' || OLD.idasientofactura ;
		PERFORM dblink_exec(query);
	END IF;

	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontfacturad() OWNER TO root;

--
-- Name: syncbulmacontfacturapd(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontfacturapd() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idasientofacturap IS NOT NULL THEN
		query := 'DELETE FROM registroiva WHERE idborrador IN (SELECT idborrador FROM borrador WHERE idasiento = ' || OLD.idasientofacturap || ')';
		PERFORM dblink_exec(query);
		query := 'DELETE FROM apunte WHERE idasiento= ' || OLD.idasientofacturap;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  borrador WHERE idasiento= ' || OLD.idasientofacturap ;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  asiento WHERE idasiento = ' || OLD.idasientofacturap ;
		PERFORM dblink_exec(query);
	END IF;

	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontfacturapd() OWNER TO root;

--
-- Name: syncbulmacontfacturapu(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontfacturapu() RETURNS "trigger"
    AS $$
DECLARE
	bs RECORD;
	cs RECORD;
	provider RECORD;
	ctaiva RECORD;
	cta TEXT;
	idcta TEXT;
	idctaproveedor TEXT;
	query TEXT;
	varaux TEXT;
	idctaserv TEXT;
	idctairpf TEXT;
	porirpf NUMERIC := 0;
	totaldesc NUMERIC := 1;
	totaliva NUMERIC := 0;
	total NUMERIC := 0;
	concepto TEXT;
	concepto1 TEXT;
	asientonuevo BOOLEAN;
BEGIN
	-- conectamos con contabilidad, etc
	PERFORM conectabulmacont();
	concepto := '[A.Automatico] Factura Proveedor Num:' || NEW.numfacturap;
	concepto1 := 'Factura Proveedor Num. ' || NEW.numfacturap;



	-- Puede darse el caso de que el contable haya borrado el asiento. Y por eso comprobamos que realmente exista en la contabilidad.
	asientonuevo := TRUE;
	IF NEW.idasientofacturap IS NOT NULL THEN
		query := 'SELECT idasiento FROM asiento WHERE idasiento =' || NEW.idasientofacturap;
		SELECT INTO cs * FROM dblink(query) AS t1 (idasiento integer);
		IF FOUND THEN
			asientonuevo := FALSE;
		END IF;
	END IF;

	-- Hacemos el update del stock del articulo
	IF asientonuevo IS FALSE THEN
		query := 'DELETE FROM registroiva WHERE idborrador IN (SELECT idborrador FROM borrador WHERE idasiento = ' || NEW.idasientofacturap || ')';
		PERFORM dblink_exec(query);
		query := 'DELETE FROM apunte WHERE idasiento= ' || NEW.idasientofacturap;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM borrador WHERE idasiento= ' || NEW.idasientofacturap;
		PERFORM dblink_exec(query);
		query := 'UPDATE asiento SET descripcion =''' || concepto || ''', comentariosasiento = ''' || concepto || ''' WHERE idasiento = ' || NEW.idasientofacturap;
		PERFORM dblink_exec(query);
	ELSE
		-- Hacemos el update del stock del articulo
		query := 'INSERT INTO asiento (fecha, descripcion, comentariosasiento) VALUES ( ' || quote_literal(NEW.ffacturap) || ', ''' || concepto ||  ''', ''' || concepto || ''')';
		PERFORM dblink_exec(query);
		SELECT INTO bs * FROM dblink('SELECT max(idasiento) AS id FROM asiento') AS t1 (id integer);
		NEW.idasientofacturap = bs.id;
	END IF;


	-- Buscamos el proveedor y su cuenta.
	SELECT INTO provider idcuentaproveedor FROM proveedor WHERE idproveedor=NEW.idproveedor;
	IF NOT FOUND THEN
		RAISE EXCEPTION 'El proveedor no tiene cuenta asociada en la contabilidad';
	END IF;
	idctaproveedor := provider.idcuentaproveedor;

	-- Buscamos la cuenta de servicio o de venta
	SELECT INTO cs MAX(idcuenta) AS id FROM bc_cuenta WHERE codigo LIKE '6000%';
	IF NOT FOUND THEN
		RAISE EXCEPTION 'No existe ls cuenta de Compras 6000...';
	END IF;
	idctaserv := cs.id;

	-- Buscamos la cuenta de IRPF
	SELECT INTO cs MAX(idcuenta) AS id FROM bc_cuenta WHERE codigo LIKE '4730%';
	IF NOT FOUND THEN
		RAISE EXCEPTION 'No existe ls cuenta de IRPF 4730...';
	END IF;
	idctairpf := cs.id;


	-- Buscamos el IRP que aplicamos
	SELECT INTO bs (irpfproveedor / 100) as val FROM proveedor WHERE idproveedor = NEW.idproveedor;
	IF bs.val IS NOT NULL THEN
		porirpf := bs.val;
	END IF;


	-- Buscamos los decuentos generales a aplicar.
	SELECT INTO bs 1 - SUM(proporciondfacturap) / 100 AS tdesc, count(iddfacturap) AS numdesc FROM dfacturap WHERE idfacturap = NEW.idfacturap;
	IF bs.numdesc <> 0 THEN
		totaldesc := bs.tdesc;
	END IF;

	-- Creamos los apuntes de IVA.
	FOR  bs IN SELECT SUM (cantlfacturap*pvplfacturap*(100-descuentolfacturap)/100) AS base, round(ivalfacturap) AS iva, ivalfacturap, reqeqlfacturap FROM lfacturap  WHERE idfacturap = NEW.idfacturap GROUP BY ivalfacturap, reqeqlfacturap LOOP
		IF bs.iva <> 0 THEN
			varaux := '4720%' || bs.iva;
			-- Hacemos la busqueda de la cuenta de IVA correspondiente.
			SELECT INTO ctaiva * FROM bc_cuenta WHERE codigo LIKE varaux;
			IF NOT FOUND THEN
				RAISE EXCEPTION 'No existe una cuenta de IVA para el tipo de IVA %', bs.iva;
			END IF;
			cta := ctaiva.codigo;
			idcta := ctaiva.idcuenta;

			-- Hacemos la insercion del borrador del apunte.
			query := 'INSERT INTO borrador (fecha, idcuenta, debe, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffacturap || ''', ' || idcta || ', ' || bs.base * totaldesc * bs.iva / 100 || ', '|| NEW.idasientofacturap ||', ''' || concepto1 || ''' ,  ''Factura Proveedor'')';
			PERFORM dblink_exec(query);

			-- Vamos calculando el total de IVA
			totaliva := totaliva + bs.base * totaldesc * bs.iva / 100;
		END IF;
		IF bs.reqeqlfacturap <> 0 THEN
			varaux := '47201%' || bs.iva;
			-- Hacemos la busqueda de la cuenta de Recargo correspondiente.
			SELECT INTO ctaiva * FROM bc_cuenta WHERE codigo LIKE varaux;
			IF NOT FOUND THEN
				RAISE EXCEPTION 'No existe una cuenta de Recargo para el tipo de Recargo %', bs.reqeqlfacturap;
			END IF;
			cta := ctaiva.codigo;
			idcta := ctaiva.idcuenta;

			-- Hacemos la insercion del borrador del apunte.
			query := 'INSERT INTO borrador (fecha, idcuenta, debe, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffacturap || ''', ' || idcta || ', ' || bs.base * totaldesc * bs.reqeqlfacturap / 100 || ', '|| NEW.idasientofacturap ||', ''' || concepto1 || ''', ''Factura Proveedor'')';
			PERFORM dblink_exec(query);

			-- Vamos calculando el total de IVA
			totaliva := totaliva + bs.base * totaldesc * bs.reqeqlfacturap / 100;
		END IF;
	END LOOP;



	-- Calculamos el total de la factura.
	SELECT INTO bs SUM (cantlfacturap*pvplfacturap*(100-descuentolfacturap)/100) AS base FROM lfacturap WHERE idfacturap = NEW.idfacturap;


	-- Hacemos la insercion del borrador del apunte al proveedor.
	total := bs.base * totaldesc * (1 - porirpf) + totaliva;
	query := 'INSERT INTO borrador (fecha, idcuenta, haber, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffacturap || ''', ' || idctaproveedor || ', ' || total || ', '|| NEW.idasientofacturap ||', ''' || concepto1 || ''' , ''Factura Proveedor'')';
	PERFORM dblink_exec(query);


	-- Creamos el apunte de IRPF
	IF porirpf <> 0 THEN
		-- Hacemos la insercion del borrador del apunte.
		query := 'INSERT INTO borrador (fecha, idcuenta, haber, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffacturap || ''', ' || idctairpf || ', ' || bs.base * totaldesc * porirpf || ', '|| NEW.idasientofacturap ||', ''' || concepto1 || ''' , ''Factura Proveedor'')';
		PERFORM dblink_exec(query);
	END IF;


	-- Creamos el apunte de servicio.
	-- Hacemos la insercion del borrador del apunte.
	query := 'INSERT INTO borrador (fecha, idcuenta, debe, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffacturap || ''', ' || idctaserv || ', ' || bs.base * totaldesc || ', '|| NEW.idasientofacturap ||', ''' || concepto1 || ''' , ''Factura Proveedor'')';
	PERFORM dblink_exec(query);


	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontfacturapu() OWNER TO root;

--
-- Name: syncbulmacontfacturau(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontfacturau() RETURNS "trigger"
    AS $$
DECLARE
	bs RECORD;
	cs RECORD;
	client RECORD;
	ctaiva RECORD;
	cta TEXT;
	idcta TEXT;
	idctacliente TEXT;
	flecha DATE;
	query TEXT;
	subquery TEXT;
	varaux TEXT;
	idctaserv TEXT;
	porirpf NUMERIC;
	totaldesc NUMERIC;
	idctairpf TEXT;
	totaliva NUMERIC;
	concepto TEXT;
	concepto1 TEXT;
	asientonuevo BOOLEAN;
BEGIN
	-- conectamos con contabilidad, etc
	PERFORM conectabulmacont();
	totaliva := 0;

	concepto := '[A. Automatico] Factura Cliente Num.' || NEW.numfactura;
	concepto1 := 'Factura Cliente Num. ' || NEW.numfactura;

	-- Hacemos el update del stock del articulo
	asientonuevo := TRUE;

	-- Puede darse el caso de que el contable haya borrado el asiento. Y por eso comprobamos que realmente exista en la contabilidad.
	IF NEW.idasientofactura IS NOT NULL THEN
		query := 'SELECT idasiento FROM asiento WHERE idasiento =' || NEW.idasientofactura;
		SELECT INTO bs * FROM dblink(query) AS t1 (idasiento integer);
		IF FOUND THEN
			asientonuevo := FALSE;
		END IF;
	END IF;

	IF asientonuevo IS FALSE THEN
		query := 'DELETE FROM registroiva WHERE idborrador IN (SELECT idborrador FROM borrador WHERE idasiento = ' || NEW.idasientofactura || ')';
		PERFORM dblink_exec(query);
		query := 'DELETE FROM apunte WHERE idasiento= ' || NEW.idasientofactura;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM borrador WHERE idasiento= ' || NEW.idasientofactura;
		PERFORM dblink_exec(query);
		query := 'UPDATE asiento SET descripcion =''' || concepto || ''', comentariosasiento = ''' || concepto || ''' WHERE idasiento = ' || NEW.idasientofactura;
		PERFORM dblink_exec(query);
	ELSE
		-- Hacemos el update del stock del articulo
		query := 'INSERT INTO asiento (fecha, descripcion, comentariosasiento) VALUES ( ' || quote_literal(NEW.ffactura) || ', ''' || concepto || ''' , ''' || concepto || ''')';
		PERFORM dblink_exec(query);
		SELECT INTO bs * FROM dblink('SELECT max(idasiento) AS id FROM asiento') AS t1 (id integer);
		NEW.idasientofactura = bs.id;
	END IF;


	-- Buscamos el cliente y su cuenta.
	SELECT INTO client idcuentacliente FROM cliente WHERE idcliente=NEW.idcliente;
	IF NOT FOUND THEN
		RAISE EXCEPTION 'El cliente no tiene cuenta asociada en la contabilidad';
	END IF;
	idctacliente := client.idcuentacliente;

	-- Buscamos la cuenta de servicio o de venta
	SELECT INTO cs MAX(idcuenta) AS id FROM bc_cuenta WHERE codigo LIKE '7000%';
	IF NOT FOUND THEN
		RAISE EXCEPTION 'No existe ls cuenta de Ventas 7000...';
	END IF;
	idctaserv := cs.id;

	-- Buscamos la cuenta de IRPF
	SELECT INTO cs MAX(idcuenta) AS id FROM bc_cuenta WHERE codigo LIKE '4730%';
	IF NOT FOUND THEN
		RAISE EXCEPTION 'No existe ls cuenta de IRPF 4730...';
	END IF;
	idctairpf := cs.id;


	-- Buscamos el IRP que aplicamos
	SELECT INTO bs valor::NUMERIC / 100 as val FROM configuracion WHERE nombre ='IRPF';
	IF FOUND THEN
		porirpf := bs.val;
	ELSE
		porirpf := 0;
	END IF;

	-- Buscamos los decuentos generales a aplicar.
	SELECT INTO bs 1 - SUM(proporciondfactura) / 100 AS tdesc FROM dfactura WHERE idfactura = NEW.idfactura;
	IF FOUND THEN
		totaldesc := bs.tdesc;
	END IF;
	totaldesc := 1;

	-- Creamos los apuntes de IVA.
	FOR  bs IN SELECT SUM (cantlfactura*pvplfactura*(100-descuentolfactura)/100) AS base, round(ivalfactura) AS iva, ivalfactura, reqeqlfactura FROM lfactura  WHERE idfactura = NEW.idfactura GROUP BY ivalfactura, reqeqlfactura LOOP
		IF bs.iva <> 0 THEN
			varaux := '4770%' || bs.iva;
			-- Hacemos la busqueda de la cuenta de IVA correspondiente.
			SELECT INTO ctaiva * FROM bc_cuenta WHERE codigo LIKE varaux;
			IF NOT FOUND THEN
				RAISE EXCEPTION 'No existe una cuenta de IVA para el tipo de IVA %', bs.iva;
			END IF;
			cta := ctaiva.codigo;
			idcta := ctaiva.idcuenta;

			-- Hacemos la insercion del borrador del apunte.
			query := 'INSERT INTO borrador (fecha, idcuenta, haber, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffactura || ''', ' || idcta || ', ' || bs.base * totaldesc * bs.iva / 100 || ', '|| NEW.idasientofactura ||', ''' || concepto1 || ''' ,  ''Factura Cliente'')';
			PERFORM dblink_exec(query);

			-- Vamos calculando el total de IVA
			totaliva := totaliva + bs.base * totaldesc * bs.iva / 100;
		END IF;
		IF bs.reqeqlfactura <> 0 THEN
			varaux := '47701%' || bs.iva;
			-- Hacemos la busqueda de la cuenta de Recargo correspondiente.
			SELECT INTO ctaiva * FROM bc_cuenta WHERE codigo LIKE varaux;
			IF NOT FOUND THEN
				RAISE EXCEPTION 'No existe una cuenta de Recargo para el tipo de Recargo %', bs.reqeqlfactura;
			END IF;
			cta := ctaiva.codigo;
			idcta := ctaiva.idcuenta;

			-- Hacemos la insercion del borrador del apunte.
			query := 'INSERT INTO borrador (fecha, idcuenta, haber, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffactura || ''', ' || idcta || ', ' || bs.base * totaldesc * bs.reqeqlfactura / 100 || ', '|| NEW.idasientofactura ||', ''' || concepto1 || ''' ,  ''Factura Cliente'')';
			PERFORM dblink_exec(query);

			-- Vamos calculando el total de IVA
			totaliva := totaliva + bs.base * totaldesc * bs.reqeqlfactura / 100;
		END IF;
	END LOOP;



	-- Creamos el apunte de cliente.
	SELECT INTO bs SUM (cantlfactura*pvplfactura*(100-descuentolfactura)/100) AS base FROM lfactura WHERE idfactura = NEW.idfactura;
	-- Hacemos la insercion del borrador del apunte.
	query := 'INSERT INTO borrador (fecha, idcuenta, debe, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffactura || ''', ' || idctacliente || ', ' || bs.base * totaldesc * (1-porirpf) + totaliva || ', '|| NEW.idasientofactura ||', ''' || concepto1 || ''' ,  ''Factura Cliente'')';
	PERFORM dblink_exec(query);


	-- Creamos el apunte de IRPF
	IF porirpf <> 0 THEN
		-- Hacemos la insercion del borrador del apunte.
		query := 'INSERT INTO borrador (fecha, idcuenta, debe, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffactura || ''', ' || idctairpf || ', ' || bs.base * totaldesc * porirpf || ', '|| NEW.idasientofactura ||', ''' || concepto1 || ''' ,  ''Factura Cliente'')';
		PERFORM dblink_exec(query);
	END IF;


	-- Creamos el apunte de servicio.
	-- Hacemos la insercion del borrador del apunte.
	query := 'INSERT INTO borrador (fecha, idcuenta, haber, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.ffactura || ''', ' || idctaserv || ', ' || bs.base * totaldesc || ', '|| NEW.idasientofactura ||', ''' || concepto1 || ''' ,  ''Factura Cliente'')';
	PERFORM dblink_exec(query);


	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontfacturau() OWNER TO root;

--
-- Name: syncbulmacontpagod(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontpagod() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idasientopago IS NOT NULL THEN
		query := 'DELETE FROM apunte WHERE idasiento= ' || OLD.idasientopago;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  borrador WHERE idasiento= ' || OLD.idasientopago ;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM  asiento WHERE idasiento = ' || OLD.idasientopago ;
		PERFORM dblink_exec(query);
	END IF;

	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontpagod() OWNER TO root;

--
-- Name: syncbulmacontpagou(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontpagou() RETURNS "trigger"
    AS $$
DECLARE
	cs RECORD;
	client RECORD;
	qbanco RECORD;
	idctacliente TEXT;
	query TEXT;
	subquery TEXT;
	idctapago INTEGER;
	flecha DATE;
	concepto TEXT;
	concepto1 TEXT;
	asientonuevo BOOLEAN;
BEGIN
	-- conectamos con contabilidad, etc
	PERFORM conectabulmacont();

	concepto := '[A. Automatico] Pago ' || NEW.refpago;
	concepto1 := 'Pago ' || NEW.refpago;


	-- Puede darse el caso de que el contable haya borrado el asiento. Y por eso comprobamos que realmente exista en la contabilidad.
	asientonuevo := TRUE;
	IF NEW.idasientopago IS NOT NULL THEN
		query := 'SELECT idasiento FROM asiento WHERE idasiento =' || NEW.idasientopago;
		SELECT INTO cs * FROM dblink(query) AS t1 (idasiento integer);
		IF FOUND THEN
			asientonuevo := FALSE;
		END IF;
	END IF;


	-- Hacemos el update del stock del articulo
	IF asientonuevo IS FALSE THEN
		query := 'DELETE FROM apunte WHERE idasiento= ' || NEW.idasientopago;
		PERFORM dblink_exec(query);
		query := 'DELETE FROM borrador WHERE idasiento= ' || NEW.idasientopago;
		PERFORM dblink_exec(query);
		query := 'UPDATE asiento SET descripcion = ''' || concepto || ''', comentariosasiento = ''' || concepto || ''' WHERE idasiento = ' || NEW.idasientopago;
		PERFORM dblink_exec(query);
	ELSE
		-- Hacemos el update del stock del articulo
		query := 'INSERT INTO asiento (fecha, descripcion, comentariosasiento) VALUES ( ' || quote_literal(NEW.fechapago) || ', ''' || concepto || ''', ''' || concepto || ''')';
		PERFORM dblink_exec(query);

		SELECT INTO cs * FROM dblink('SELECT max(idasiento) AS id FROM asiento') AS t1 (id integer);
		NEW.idasientopago = cs.id;
	END IF;


	-- Buscamos el cliente y su cuenta.
	SELECT INTO client idcuentaproveedor FROM proveedor WHERE idproveedor = NEW.idproveedor;
	IF NOT FOUND THEN
		RAISE EXCEPTION 'El cliente no tiene cuenta asociada en la contabilidad';
	END IF;
	idctacliente := client.idcuentaproveedor;


	-- Buscamos el banco
	IF NEW.idbanco IS NOT NULL THEN
		SELECT INTO qbanco idcuentabanco FROM banco WHERE idbanco = NEW.idbanco;
		IF NOT FOUND THEN
			RAISE EXCEPTION 'El banco no tiene cuenta asociada en la contabilidad';
		END IF;
		idctapago := qbanco.idcuentabanco;
	ELSE
		-- Buscamos la cuenta de servicio o de venta
		SELECT INTO cs MAX(idcuenta) AS id FROM bc_cuenta WHERE codigo LIKE '5700%';
		IF NOT FOUND THEN
			RAISE EXCEPTION 'No existe la cuenta de Caja 5700...';
		END IF;
		idctapago := cs.id;
	END IF;



	-- Apunte opr el proveedor
	query := 'INSERT INTO borrador (fecha, idcuenta, debe, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.fechapago || ''', ' || idctacliente || ', ' || NEW.cantpago || ', '|| NEW.idasientopago ||', ''' || concepto1 || ''', ''Pago'')';
	PERFORM dblink_exec(query);


	-- Apunte por caja o banco.
	query := 'INSERT INTO borrador (fecha, idcuenta, haber, idasiento, descripcion, conceptocontable) VALUES (''' || NEW.fechapago || ''', ' || idctapago || ', ' || NEW.cantpago || ', '|| NEW.idasientopago ||', ''' || concepto1 || ''', ''Pago'')';
	PERFORM dblink_exec(query);


	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontpagou() OWNER TO root;

--
-- Name: syncbulmacontproveedord(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontproveedord() RETURNS "trigger"
    AS $$
DECLARE
	query TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo
	IF OLD.idcuentacliente IS NOT NULL THEN
		query := 'DELETE FROM  cuenta WHERE idcuenta = ' || OLD.idcuentaproveedor ;
		PERFORM dblink_exec(query);
	END IF;

	PERFORM dblink_disconnect();
	RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontproveedord() OWNER TO root;

--
-- Name: syncbulmacontproveedoru(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION syncbulmacontproveedoru() RETURNS "trigger"
    AS $$
DECLARE
	bs RECORD;
	quer TEXT;
	subquery TEXT;
	flecha DATE;
	codcta INTEGER;
	idpadre INTEGER;
	grupo INTEGER;
	descripcion TEXT;
BEGIN
	PERFORM conectabulmacont();
	-- Hacemos el update del stock del articulo

	-- Cogemos el nombre de la cuenta.
	descripcion := quote_literal(NEW.nomproveedor);

	IF NEW.idcuentaproveedor IS NULL THEN
		-- Buscamos el codigo de cuenta que vaya a corresponderle
		SELECT INTO bs  max(codigo) as cod FROM bc_cuenta WHERE codigo LIKE '4000%' ;
		codcta := bs.cod;
		codcta := codcta +1;
	
		-- Buscamos la cuenta padre (la 4300)
		SELECT INTO bs idcuenta FROM bc_cuenta WHERE codigo ='4000';
		idpadre := bs.idcuenta;
	
		-- Creamos el Query de insercion
		quer := 'INSERT INTO cuenta (descripcion, padre, codigo) VALUES ( ' || descripcion ||', ' || idpadre || ', ''' || codcta || ''' )';
		PERFORM dblink_exec(quer);
	
	
		SELECT INTO bs  max(idcuenta) AS id FROM bc_cuenta;
	
		NEW.idcuentaproveedor = bs.id;
	ELSE
		-- NOTA: Si no estan todos los campos completos el update no funciona bien
		-- Hay que introducir una validacion de campos.
		quer := 'UPDATE cuenta SET descripcion = ' || descripcion || ', cifent_cuenta = ''' || NEW.cifproveedor || ''', nombreent_cuenta = ''' || NEW.nomaltproveedor || ''', dirent_cuenta = ''' || NEW.dirproveedor || ''', cpent_cuenta = ''' || NEW.cpproveedor || ''', telent_cuenta = ''' || NEW.telproveedor || ''', emailent_cuenta = ''' || NEW.emailproveedor || ''', webent_cuenta = ''' || NEW.urlproveedor || ''' WHERE idcuenta= ' || NEW.idcuentaproveedor;
--		RAISE EXCEPTION ' % ', quer;
		PERFORM dblink_exec(quer);
	END IF;

	PERFORM dblink_disconnect();
	RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.syncbulmacontproveedoru() OWNER TO root;

--
-- Name: to_number(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION to_number(character varying) RETURNS bigint
    AS $_$
DECLARE
BEGIN
	RAISE NOTICE 'to_number %', $1;
        RETURN CAST(text($1) AS INT8);
END
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.to_number(character varying) OWNER TO postgres;

--
-- Name: trazabilidadalbarand(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION trazabilidadalbarand() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    DELETE FROM movimiento WHERE idlalbaran = OLD.numlalbaran;
    RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.trazabilidadalbarand() OWNER TO postgres;

--
-- Name: trazabilidadalbarani(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION trazabilidadalbarani() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;
BEGIN
    SELECT INTO as idalmacen FROM albaran WHERE idalbaran = NEW.idalbaran;
    INSERT INTO movimiento (idarticulo, cantidadmovimiento, idlalbaran, fechamovimiento, lotemovimiento, idalmacen) VALUES (NEW.idarticulo, -NEW.cantlalbaran, NEW.numlalbaran, NOW(), NEW.lotelalbaran, as.idalmacen);
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.trazabilidadalbarani() OWNER TO postgres;

--
-- Name: trazabilidadalbaranpd(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION trazabilidadalbaranpd() RETURNS "trigger"
    AS $$
DECLARE
BEGIN
    DELETE FROM movimiento WHERE idlalbaranp = OLD.numlalbaranp;
    RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.trazabilidadalbaranpd() OWNER TO postgres;

--
-- Name: trazabilidadalbaranpi(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION trazabilidadalbaranpi() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;
BEGIN
    SELECT INTO as idalmacen FROM albaranp WHERE idalbaranp = NEW.idalbaranp;
    INSERT INTO movimiento (idarticulo, cantidadmovimiento, idlalbaranp, fechamovimiento, lotemovimiento, idalmacen) VALUES (NEW.idarticulo, NEW.cantlalbaranp, NEW.numlalbaranp, NOW(), NEW.lotelalbaranp, as.idalmacen);
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.trazabilidadalbaranpi() OWNER TO postgres;

--
-- Name: trazabilidadalbaranpu(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION trazabilidadalbaranpu() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;
BEGIN
    SELECT INTO as idalmacen FROM albaranp WHERE idalbaranp = NEW.idalbaranp;
    UPDATE movimiento SET cantidadmovimiento = NEW.cantlalbaranp, idalmacen = as.idalmacen WHERE idlalbaranp = NEW.numlalbaranp;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.trazabilidadalbaranpu() OWNER TO postgres;

--
-- Name: trazabilidadalbaranu(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION trazabilidadalbaranu() RETURNS "trigger"
    AS $$
DECLARE
    as RECORD;
BEGIN
    SELECT INTO as idalmacen FROM albaran WHERE idalbaran = NEW.idalbaran;
    UPDATE movimiento SET cantidadmovimiento = -NEW.cantlalbaran, idalmacen = as.idalmacen WHERE idlalbaran = NEW.numlalbaran;
    RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.trazabilidadalbaranu() OWNER TO postgres;

--
-- Name: validacionasterisk(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION validacionasterisk(character varying, character varying) RETURNS boolean
    AS $_$
DECLARE
    passtraba ALIAS FOR $1;
    extealm   ALIAS FOR $2;
    trab      RECORD;
    alm       RECORD;
BEGIN
   SELECT INTO trab * FROM trabajador WHERE passasterisktrabajador = passtraba;
   IF FOUND THEN 
	SELECT INTO alm * FROM almacen WHERE extasteriskalmacen = extealm;
	IF FOUND THEN
		INSERT INTO valasterisk (idtrabajador, idalmacen) VALUES (trab.idtrabajador, alm.idalmacen);
		RETURN TRUE;
	END IF;
   END IF;

   RETURN FALSE;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.validacionasterisk(character varying, character varying) OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: alb_pro; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE alb_pro (
    idalb_pro integer NOT NULL,
    ncompraalb_pro integer,
    nalbalb_pro character varying(60),
    fcrealb_pro date,
    frecepalb_pro date,
    comentalb_pro character varying(2000),
    idfra_pro integer,
    idalmacen integer NOT NULL
);


ALTER TABLE public.alb_pro OWNER TO postgres;

--
-- Name: alb_pro_idalb_pro_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE alb_pro_idalb_pro_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.alb_pro_idalb_pro_seq OWNER TO postgres;

--
-- Name: alb_pro_idalb_pro_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE alb_pro_idalb_pro_seq OWNED BY alb_pro.idalb_pro;


--
-- Name: alb_pro_idalb_pro_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('alb_pro_idalb_pro_seq', 1, false);


--
-- Name: albaran; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE albaran (
    idalbaran integer NOT NULL,
    numalbaran integer NOT NULL,
    descalbaran character varying(150),
    refalbaran character varying(12) NOT NULL,
    fechaalbaran date DEFAULT now(),
    comentalbaran character varying(3000),
    procesadoalbaran boolean DEFAULT false,
    contactalbaran character varying,
    telalbaran character varying,
    idcliente integer,
    idforma_pago integer,
    idfactura integer,
    idnofactura integer,
    idalmacen integer NOT NULL,
    idtrabajador integer,
    comentprivalbaran character varying(3000),
    totalalbaran numeric(12,2) DEFAULT 0,
    bimpalbaran numeric(12,2) DEFAULT 0,
    impalbaran numeric(12,2) DEFAULT 0,
    horaalbaran time without time zone DEFAULT now(),
    anuladoalbaran boolean,
    ticketalbaran boolean,
    recogidoalbaran boolean,
    idz integer
);


ALTER TABLE public.albaran OWNER TO postgres;

--
-- Name: albaran_idalbaran_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE albaran_idalbaran_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.albaran_idalbaran_seq OWNER TO postgres;

--
-- Name: albaran_idalbaran_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE albaran_idalbaran_seq OWNED BY albaran.idalbaran;


--
-- Name: albaran_idalbaran_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('albaran_idalbaran_seq', 834, true);


--
-- Name: albaranp; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE albaranp (
    idalbaranp integer NOT NULL,
    numalbaranp integer NOT NULL,
    descalbaranp character varying(150),
    refalbaranp character varying(12) NOT NULL,
    fechaalbaranp date DEFAULT now(),
    comentalbaranp character varying(3000),
    procesadoalbaranp boolean DEFAULT false,
    idproveedor integer,
    idforma_pago integer,
    idalmacen integer NOT NULL,
    idtrabajador integer,
    totalalbaranp numeric(12,2) DEFAULT 0,
    bimpalbaranp numeric(12,2) DEFAULT 0,
    impalbaranp numeric(12,2) DEFAULT 0
);


ALTER TABLE public.albaranp OWNER TO postgres;

--
-- Name: albaranp_idalbaranp_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE albaranp_idalbaranp_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.albaranp_idalbaranp_seq OWNER TO postgres;

--
-- Name: albaranp_idalbaranp_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE albaranp_idalbaranp_seq OWNED BY albaranp.idalbaranp;


--
-- Name: albaranp_idalbaranp_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('albaranp_idalbaranp_seq', 72, true);


--
-- Name: almacen; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE almacen (
    idalmacen integer NOT NULL,
    codigoalmacen numeric(5,0) NOT NULL,
    nomalmacen character varying(50),
    diralmacen character varying(150),
    poblalmacen character varying(50),
    cpalmacen character varying(20),
    telalmacen character varying(20),
    faxalmacen character varying(20),
    emailalmacen character varying(100),
    inactivoalmacen character(1),
    aperturaalmacen time without time zone,
    cierrealmacen time without time zone,
    apertura1almacen time without time zone,
    cierre1almacen time without time zone,
    extasteriskalmacen character varying,
    tipoalmacen character varying,
    idcuentaalmacen integer
);


ALTER TABLE public.almacen OWNER TO postgres;

--
-- Name: almacen_idalmacen_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE almacen_idalmacen_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.almacen_idalmacen_seq OWNER TO postgres;

--
-- Name: almacen_idalmacen_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE almacen_idalmacen_seq OWNED BY almacen.idalmacen;


--
-- Name: almacen_idalmacen_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('almacen_idalmacen_seq', 8, true);


SET default_with_oids = false;

--
-- Name: almacentipotrabajo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE almacentipotrabajo (
    idtipotrabajo integer NOT NULL,
    idalmacen integer NOT NULL,
    numpers integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.almacentipotrabajo OWNER TO postgres;

SET default_with_oids = true;

--
-- Name: articulo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE articulo (
    idarticulo integer NOT NULL,
    codarticulo character varying(12),
    nomarticulo character varying(50),
    abrevarticulo character varying(30),
    obserarticulo character varying(2000),
    presentablearticulo boolean DEFAULT true NOT NULL,
    controlstockarticulo boolean DEFAULT true NOT NULL,
    idtipo_articulo numeric(2,0),
    idtipo_iva integer,
    codigocompletoarticulo character varying(100),
    idfamilia integer NOT NULL,
    stockarticulo numeric(12,2) DEFAULT 0,
    inactivoarticulo character(1),
    pvparticulo numeric(12,2) DEFAULT 0 NOT NULL,
    pesoundarticulo numeric(12,2) DEFAULT 0,
    volumenundarticulo numeric(12,2) DEFAULT 0,
    ivaincarticulo boolean DEFAULT false
);


ALTER TABLE public.articulo OWNER TO postgres;

--
-- Name: articulo_idarticulo_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE articulo_idarticulo_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.articulo_idarticulo_seq OWNER TO postgres;

--
-- Name: articulo_idarticulo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE articulo_idarticulo_seq OWNED BY articulo.idarticulo;


--
-- Name: articulo_idarticulo_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('articulo_idarticulo_seq', 5387, true);


SET default_with_oids = false;

--
-- Name: ausencia; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE ausencia (
    idausencia integer NOT NULL,
    idtrabajador integer NOT NULL,
    fechainausencia date NOT NULL,
    fechafinausencia date NOT NULL,
    motivoausencia character varying,
    CONSTRAINT ausencia_check CHECK ((fechainausencia <= fechafinausencia))
);


ALTER TABLE public.ausencia OWNER TO postgres;

--
-- Name: ausencia_idausencia_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE ausencia_idausencia_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ausencia_idausencia_seq OWNER TO postgres;

--
-- Name: ausencia_idausencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE ausencia_idausencia_seq OWNED BY ausencia.idausencia;


--
-- Name: ausencia_idausencia_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('ausencia_idausencia_seq', 5, true);


--
-- Name: banco; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE banco (
    idbanco integer NOT NULL,
    nombanco character varying(50),
    dirbanco character varying(150),
    poblbanco character varying(50),
    cpbanco character varying(20),
    telbanco character varying(20),
    faxbanco character varying(20),
    emailbanco character varying(100),
    contactobanco character varying,
    codentidadbanco character varying(14),
    codagenciabanco character varying(17),
    numcuentabanco character varying(17),
    dcbanco character varying(2),
    comentbanco character varying,
    webbanco character varying(100),
    idcuentabanco integer
);


ALTER TABLE public.banco OWNER TO postgres;

--
-- Name: banco_idbanco_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE banco_idbanco_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.banco_idbanco_seq OWNER TO postgres;

--
-- Name: banco_idbanco_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE banco_idbanco_seq OWNED BY banco.idbanco;


--
-- Name: banco_idbanco_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('banco_idbanco_seq', 11, true);


--
-- Name: bc_apunte; Type: VIEW; Schema: public; Owner: ubuntu
--

CREATE VIEW bc_apunte AS
    SELECT t1.idapunte FROM dblink('SELECT idapunte FROM apunte'::text) t1(idapunte integer);


ALTER TABLE public.bc_apunte OWNER TO ubuntu;

--
-- Name: bc_asiento; Type: VIEW; Schema: public; Owner: ubuntu
--

CREATE VIEW bc_asiento AS
    SELECT t1.idasiento FROM dblink('SELECT idasiento FROM asiento'::text) t1(idasiento integer);


ALTER TABLE public.bc_asiento OWNER TO ubuntu;

--
-- Name: bc_borrador; Type: VIEW; Schema: public; Owner: ubuntu
--

CREATE VIEW bc_borrador AS
    SELECT t1.idborrador FROM dblink('SELECT idborrador FROM borrador'::text) t1(idborrador integer);


ALTER TABLE public.bc_borrador OWNER TO ubuntu;

--
-- Name: bc_cuenta; Type: VIEW; Schema: public; Owner: root
--

CREATE VIEW bc_cuenta AS
    SELECT t1.idcuenta, t1.codigo, t1.descripcion, t1.tipocuenta FROM dblink('SELECT idcuenta, codigo, descripcion, tipocuenta FROM cuenta'::text) t1(idcuenta integer, codigo character varying, descripcion character varying, tipocuenta integer);


ALTER TABLE public.bc_cuenta OWNER TO root;

SET default_with_oids = true;

--
-- Name: cliente; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cliente (
    idcliente integer NOT NULL,
    nomcliente character varying(100),
    nomaltcliente character varying(300),
    cifcliente character varying(200),
    dircliente character varying(100),
    poblcliente character varying(40),
    cpcliente character varying(10),
    telcliente character varying(20),
    faxcliente character varying(20),
    mailcliente character varying(100),
    urlcliente character varying(150),
    faltacliente date DEFAULT now(),
    fbajacliente date,
    comentcliente character varying(2000),
    inactivocliente character(1),
    idtarifa integer,
    codcliente character varying(12),
    corpcliente character varying(200),
    teltrabcliente character varying(25),
    movilcliente character varying(25),
    recargoeqcliente boolean DEFAULT false,
    idforma_pago integer,
    regimenfiscalcliente character varying(50) NOT NULL,
    bancocliente character(120),
    idprovincia integer,
    comentcomercialcliente character varying,
    idzonacomercial integer,
    periodocomercialcliente interval DEFAULT '7 days'::interval NOT NULL,
    fechabasecomercialcliente date DEFAULT now() NOT NULL,
    horarutacomercialcliente time without time zone DEFAULT '08:00:00'::time without time zone NOT NULL,
    idcuentacliente integer
);


ALTER TABLE public.cliente OWNER TO postgres;

--
-- Name: cliente_idcliente_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE cliente_idcliente_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cliente_idcliente_seq OWNER TO postgres;

--
-- Name: cliente_idcliente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE cliente_idcliente_seq OWNED BY cliente.idcliente;


--
-- Name: cliente_idcliente_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('cliente_idcliente_seq', 148, true);


--
-- Name: cobro; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cobro (
    idcobro integer NOT NULL,
    idcliente integer NOT NULL,
    fechacobro date DEFAULT now(),
    cantcobro numeric(12,2) DEFAULT 0,
    refcobro character varying(12) NOT NULL,
    previsioncobro boolean DEFAULT false,
    comentcobro character varying(500),
    idtrabajador integer,
    idbanco integer,
    fechavenccobro date DEFAULT now(),
    idq19 integer,
    idasientocobro integer
);


ALTER TABLE public.cobro OWNER TO postgres;

--
-- Name: cobro_idcobro_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE cobro_idcobro_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cobro_idcobro_seq OWNER TO postgres;

--
-- Name: cobro_idcobro_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE cobro_idcobro_seq OWNED BY cobro.idcobro;


--
-- Name: cobro_idcobro_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('cobro_idcobro_seq', 180, true);


--
-- Name: codigobarras; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE codigobarras (
    idcodigobarras integer NOT NULL,
    idarticulo integer NOT NULL,
    ean14codigobarras numeric(14,0) NOT NULL,
    unixcajacodigobarras numeric(4,0),
    cajxpaletcodigobarras numeric(4,0),
    unidadcodigobarras character(1)
);


ALTER TABLE public.codigobarras OWNER TO postgres;

--
-- Name: codigobarras_idcodigobarras_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE codigobarras_idcodigobarras_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.codigobarras_idcodigobarras_seq OWNER TO postgres;

--
-- Name: codigobarras_idcodigobarras_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE codigobarras_idcodigobarras_seq OWNED BY codigobarras.idcodigobarras;


--
-- Name: codigobarras_idcodigobarras_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('codigobarras_idcodigobarras_seq', 1, false);


SET default_with_oids = false;

--
-- Name: comentario_evento; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE comentario_evento (
    idcomentario_evento integer NOT NULL,
    idevento integer NOT NULL,
    idtrabajador integer NOT NULL,
    fechacomentario_evento timestamp without time zone DEFAULT now(),
    textcomentario_evento character varying
);


ALTER TABLE public.comentario_evento OWNER TO postgres;

--
-- Name: comentario_evento_idcomentario_evento_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE comentario_evento_idcomentario_evento_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.comentario_evento_idcomentario_evento_seq OWNER TO postgres;

--
-- Name: comentario_evento_idcomentario_evento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE comentario_evento_idcomentario_evento_seq OWNED BY comentario_evento.idcomentario_evento;


--
-- Name: comentario_evento_idcomentario_evento_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('comentario_evento_idcomentario_evento_seq', 5, true);


SET default_with_oids = true;

--
-- Name: comparticulo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE comparticulo (
    idarticulo integer NOT NULL,
    cantcomparticulo integer DEFAULT 1 NOT NULL,
    idcomponente integer NOT NULL
);


ALTER TABLE public.comparticulo OWNER TO postgres;

--
-- Name: configuracion; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE configuracion (
    nombre character varying(25) NOT NULL,
    valor character varying(350)
);


ALTER TABLE public.configuracion OWNER TO postgres;

SET default_with_oids = false;

--
-- Name: contrato; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE contrato (
    idcontrato integer NOT NULL,
    idcliente integer NOT NULL,
    refcontrato character varying,
    nomcontrato character varying NOT NULL,
    fincontrato date,
    ffincontrato date,
    periodicidadcontrato interval,
    descontrato character varying,
    loccontrato character varying
);


ALTER TABLE public.contrato OWNER TO postgres;

--
-- Name: contrato_idcontrato_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE contrato_idcontrato_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.contrato_idcontrato_seq OWNER TO postgres;

--
-- Name: contrato_idcontrato_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE contrato_idcontrato_seq OWNED BY contrato.idcontrato;


--
-- Name: contrato_idcontrato_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('contrato_idcontrato_seq', 1, true);


SET default_with_oids = true;

--
-- Name: controlstock; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE controlstock (
    idinventario integer NOT NULL,
    idalmacen integer NOT NULL,
    idarticulo integer NOT NULL,
    stockantcontrolstock numeric(12,2) DEFAULT 0,
    stocknewcontrolstock numeric(12,2) NOT NULL,
    punteocontrolstock boolean DEFAULT false NOT NULL
);


ALTER TABLE public.controlstock OWNER TO postgres;

SET default_with_oids = false;

--
-- Name: cuadrante; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cuadrante (
    idcuadrante integer NOT NULL,
    fechacuadrante date NOT NULL,
    idalmacen integer NOT NULL,
    comentcuadrante character varying,
    aperturacuadrante time without time zone,
    cierrecuadrante time without time zone,
    apertura1cuadrante time without time zone,
    cierre1cuadrante time without time zone,
    fiestacuadrante boolean DEFAULT false
);


ALTER TABLE public.cuadrante OWNER TO postgres;

--
-- Name: cuadrante_idcuadrante_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE cuadrante_idcuadrante_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cuadrante_idcuadrante_seq OWNER TO postgres;

--
-- Name: cuadrante_idcuadrante_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE cuadrante_idcuadrante_seq OWNED BY cuadrante.idcuadrante;


--
-- Name: cuadrante_idcuadrante_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('cuadrante_idcuadrante_seq', 1244, true);


SET default_with_oids = true;

--
-- Name: dalbaran; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dalbaran (
    iddalbaran integer NOT NULL,
    conceptdalbaran character varying(500),
    proporciondalbaran numeric(12,2),
    idalbaran integer NOT NULL
);


ALTER TABLE public.dalbaran OWNER TO postgres;

--
-- Name: dalbaran_iddalbaran_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dalbaran_iddalbaran_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dalbaran_iddalbaran_seq OWNER TO postgres;

--
-- Name: dalbaran_iddalbaran_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dalbaran_iddalbaran_seq OWNED BY dalbaran.iddalbaran;


--
-- Name: dalbaran_iddalbaran_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dalbaran_iddalbaran_seq', 1, false);


--
-- Name: dalbaranp; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dalbaranp (
    iddalbaranp integer NOT NULL,
    conceptdalbaranp character varying(500),
    proporciondalbaranp numeric(12,2),
    idalbaranp integer NOT NULL
);


ALTER TABLE public.dalbaranp OWNER TO postgres;

--
-- Name: dalbaranp_iddalbaranp_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dalbaranp_iddalbaranp_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dalbaranp_iddalbaranp_seq OWNER TO postgres;

--
-- Name: dalbaranp_iddalbaranp_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dalbaranp_iddalbaranp_seq OWNED BY dalbaranp.iddalbaranp;


--
-- Name: dalbaranp_iddalbaranp_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dalbaranp_iddalbaranp_seq', 1, true);


--
-- Name: dfactura; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dfactura (
    iddfactura integer NOT NULL,
    conceptdfactura character varying(2000),
    proporciondfactura numeric(12,2),
    idfactura integer NOT NULL
);


ALTER TABLE public.dfactura OWNER TO postgres;

--
-- Name: dfactura_iddfactura_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dfactura_iddfactura_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dfactura_iddfactura_seq OWNER TO postgres;

--
-- Name: dfactura_iddfactura_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dfactura_iddfactura_seq OWNED BY dfactura.iddfactura;


--
-- Name: dfactura_iddfactura_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dfactura_iddfactura_seq', 1, false);


--
-- Name: dfacturap; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dfacturap (
    iddfacturap integer NOT NULL,
    conceptdfacturap character varying(2000),
    proporciondfacturap numeric(12,2),
    idfacturap integer NOT NULL
);


ALTER TABLE public.dfacturap OWNER TO postgres;

--
-- Name: dfacturap_iddfacturap_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dfacturap_iddfacturap_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dfacturap_iddfacturap_seq OWNER TO postgres;

--
-- Name: dfacturap_iddfacturap_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dfacturap_iddfacturap_seq OWNED BY dfacturap.iddfacturap;


--
-- Name: dfacturap_iddfacturap_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dfacturap_iddfacturap_seq', 1, false);


--
-- Name: division; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE division (
    iddivision integer NOT NULL,
    descdivision character varying(1000),
    contactosdivisioon character varying(500),
    comentdivision character varying(2000),
    teldivision character varying(20),
    faxdivision character varying(20),
    maildivision character varying(100),
    idproveedor integer NOT NULL,
    inactivodivision character(1)
);


ALTER TABLE public.division OWNER TO postgres;

--
-- Name: division_iddivision_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE division_iddivision_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.division_iddivision_seq OWNER TO postgres;

--
-- Name: division_iddivision_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE division_iddivision_seq OWNED BY division.iddivision;


--
-- Name: division_iddivision_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('division_iddivision_seq', 1, false);


--
-- Name: dpedidocliente; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dpedidocliente (
    iddpedidocliente integer NOT NULL,
    conceptdpedidocliente character varying(2000),
    proporciondpedidocliente numeric(12,2),
    idpedidocliente integer NOT NULL
);


ALTER TABLE public.dpedidocliente OWNER TO postgres;

--
-- Name: dpedidocliente_iddpedidocliente_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dpedidocliente_iddpedidocliente_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dpedidocliente_iddpedidocliente_seq OWNER TO postgres;

--
-- Name: dpedidocliente_iddpedidocliente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dpedidocliente_iddpedidocliente_seq OWNED BY dpedidocliente.iddpedidocliente;


--
-- Name: dpedidocliente_iddpedidocliente_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dpedidocliente_iddpedidocliente_seq', 1, true);


--
-- Name: dpedidoproveedor; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dpedidoproveedor (
    iddpedidoproveedor integer NOT NULL,
    conceptdpedidoproveedor character varying(2000),
    proporciondpedidoproveedor numeric(12,2),
    idpedidoproveedor integer NOT NULL
);


ALTER TABLE public.dpedidoproveedor OWNER TO postgres;

--
-- Name: dpedidoproveedor_iddpedidoproveedor_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dpedidoproveedor_iddpedidoproveedor_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dpedidoproveedor_iddpedidoproveedor_seq OWNER TO postgres;

--
-- Name: dpedidoproveedor_iddpedidoproveedor_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dpedidoproveedor_iddpedidoproveedor_seq OWNED BY dpedidoproveedor.iddpedidoproveedor;


--
-- Name: dpedidoproveedor_iddpedidoproveedor_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dpedidoproveedor_iddpedidoproveedor_seq', 2, true);


--
-- Name: dpresupuesto; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dpresupuesto (
    iddpresupuesto integer NOT NULL,
    conceptdpresupuesto character varying(2000),
    proporciondpresupuesto numeric(12,2),
    idpresupuesto integer
);


ALTER TABLE public.dpresupuesto OWNER TO postgres;

--
-- Name: dpresupuesto_iddpresupuesto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dpresupuesto_iddpresupuesto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dpresupuesto_iddpresupuesto_seq OWNER TO postgres;

--
-- Name: dpresupuesto_iddpresupuesto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dpresupuesto_iddpresupuesto_seq OWNED BY dpresupuesto.iddpresupuesto;


--
-- Name: dpresupuesto_iddpresupuesto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dpresupuesto_iddpresupuesto_seq', 1, false);


SET default_with_oids = false;

--
-- Name: estado_evento; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE estado_evento (
    idestado_evento integer NOT NULL,
    nomestado_evento character varying
);


ALTER TABLE public.estado_evento OWNER TO postgres;

--
-- Name: estado_evento_idestado_evento_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE estado_evento_idestado_evento_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.estado_evento_idestado_evento_seq OWNER TO postgres;

--
-- Name: estado_evento_idestado_evento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE estado_evento_idestado_evento_seq OWNED BY estado_evento.idestado_evento;


--
-- Name: estado_evento_idestado_evento_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('estado_evento_idestado_evento_seq', 1, true);


--
-- Name: evento; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE evento (
    idevento integer NOT NULL,
    idcliente integer,
    idtipo_evento integer NOT NULL,
    idestado_evento integer NOT NULL,
    fechaevento timestamp without time zone DEFAULT now(),
    subjectevento character varying
);


ALTER TABLE public.evento OWNER TO postgres;

--
-- Name: evento_idevento_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE evento_idevento_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.evento_idevento_seq OWNER TO postgres;

--
-- Name: evento_idevento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE evento_idevento_seq OWNED BY evento.idevento;


--
-- Name: evento_idevento_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('evento_idevento_seq', 5, true);


SET default_with_oids = true;

--
-- Name: factura; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE factura (
    idfactura integer NOT NULL,
    codigoserie_factura character varying(6) NOT NULL,
    numfactura integer NOT NULL,
    reffactura character varying(15) NOT NULL,
    ffactura date DEFAULT now(),
    descfactura character varying(500),
    idalmacen integer NOT NULL,
    contactfactura character varying(90),
    telfactura character varying(20),
    comentfactura character varying(3000),
    procesadafactura boolean DEFAULT false,
    idusuari integer,
    idcliente integer,
    idforma_pago integer,
    idtrabajador integer,
    totalfactura numeric(12,2) DEFAULT 0,
    bimpfactura numeric(12,2) DEFAULT 0,
    impfactura numeric(12,2) DEFAULT 0,
    idasientofactura integer
);


ALTER TABLE public.factura OWNER TO postgres;

--
-- Name: factura_idfactura_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE factura_idfactura_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.factura_idfactura_seq OWNER TO postgres;

--
-- Name: factura_idfactura_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE factura_idfactura_seq OWNED BY factura.idfactura;


--
-- Name: factura_idfactura_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('factura_idfactura_seq', 596, true);


--
-- Name: facturap; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE facturap (
    idfacturap integer NOT NULL,
    numfacturap character varying(20) NOT NULL,
    reffacturap character varying(15) NOT NULL,
    ffacturap date,
    descfacturap character varying(500),
    contactfacturap character varying(90),
    telfacturap character varying(20),
    comentfacturap character varying(3000),
    procesadafacturap boolean DEFAULT false,
    idusuari integer,
    idproveedor integer,
    idforma_pago integer,
    idtrabajador integer,
    totalfacturap numeric(12,2) DEFAULT 0,
    bimpfacturap numeric(12,2) DEFAULT 0,
    impfacturap numeric(12,2) DEFAULT 0,
    idasientofacturap integer
);


ALTER TABLE public.facturap OWNER TO postgres;

--
-- Name: facturap_idfacturap_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE facturap_idfacturap_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.facturap_idfacturap_seq OWNER TO postgres;

--
-- Name: facturap_idfacturap_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE facturap_idfacturap_seq OWNED BY facturap.idfacturap;


--
-- Name: facturap_idfacturap_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('facturap_idfacturap_seq', 264, true);


--
-- Name: familia; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE familia (
    idfamilia integer NOT NULL,
    codigofamilia character varying(12) NOT NULL,
    nombrefamilia character varying(50) NOT NULL,
    descfamilia character varying(300),
    padrefamilia integer,
    codigocompletofamilia character varying(50),
    productofisicofamilia boolean DEFAULT true NOT NULL
);


ALTER TABLE public.familia OWNER TO postgres;

--
-- Name: familia_idfamilia_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE familia_idfamilia_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.familia_idfamilia_seq OWNER TO postgres;

--
-- Name: familia_idfamilia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE familia_idfamilia_seq OWNED BY familia.idfamilia;


--
-- Name: familia_idfamilia_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('familia_idfamilia_seq', 226, true);


--
-- Name: forma_pago; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE forma_pago (
    idforma_pago integer NOT NULL,
    descforma_pago character varying(500),
    dias1tforma_pago integer,
    descuentoforma_pago numeric(12,2)
);


ALTER TABLE public.forma_pago OWNER TO postgres;

--
-- Name: forma_pago_idforma_pago_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE forma_pago_idforma_pago_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.forma_pago_idforma_pago_seq OWNER TO postgres;

--
-- Name: forma_pago_idforma_pago_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE forma_pago_idforma_pago_seq OWNED BY forma_pago.idforma_pago;


--
-- Name: forma_pago_idforma_pago_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('forma_pago_idforma_pago_seq', 13, true);


--
-- Name: fra_pro; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE fra_pro (
    idfra_pro integer NOT NULL,
    numfra_pro character varying(60),
    fcrefra_pro date,
    comentfra_pro character varying(2000)
);


ALTER TABLE public.fra_pro OWNER TO postgres;

--
-- Name: fra_pro_idfra_pro_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE fra_pro_idfra_pro_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.fra_pro_idfra_pro_seq OWNER TO postgres;

--
-- Name: fra_pro_idfra_pro_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE fra_pro_idfra_pro_seq OWNED BY fra_pro.idfra_pro;


--
-- Name: fra_pro_idfra_pro_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('fra_pro_idfra_pro_seq', 1, false);


SET default_with_oids = false;

--
-- Name: horario; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE horario (
    idhorario integer NOT NULL,
    idtrabajador integer NOT NULL,
    idcuadrante integer NOT NULL,
    horainhorario time without time zone,
    horafinhorario time without time zone
);


ALTER TABLE public.horario OWNER TO postgres;

--
-- Name: horario_idhorario_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE horario_idhorario_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.horario_idhorario_seq OWNER TO postgres;

--
-- Name: horario_idhorario_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE horario_idhorario_seq OWNED BY horario.idhorario;


--
-- Name: horario_idhorario_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('horario_idhorario_seq', 926, true);


--
-- Name: incidenciacomercial; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE incidenciacomercial (
    idincidenciacomercial integer NOT NULL,
    fechaincidenciacomercial date,
    idcliente integer,
    comentincidenciacomercial character varying,
    refincidenciacomercial character varying,
    estadoincidenciacomercial integer,
    horaincidenciacomercial time without time zone,
    idrutacomercial integer,
    idpedidocliente integer,
    idcobro integer,
    idtrabajador integer
);


ALTER TABLE public.incidenciacomercial OWNER TO postgres;

--
-- Name: incidenciacomercial_idincidenciacomercial_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE incidenciacomercial_idincidenciacomercial_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.incidenciacomercial_idincidenciacomercial_seq OWNER TO postgres;

--
-- Name: incidenciacomercial_idincidenciacomercial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE incidenciacomercial_idincidenciacomercial_seq OWNED BY incidenciacomercial.idincidenciacomercial;


--
-- Name: incidenciacomercial_idincidenciacomercial_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('incidenciacomercial_idincidenciacomercial_seq', 1, false);


SET default_with_oids = true;

--
-- Name: inventario; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE inventario (
    idinventario integer NOT NULL,
    nominventario character varying NOT NULL,
    fechainventario date DEFAULT now()
);


ALTER TABLE public.inventario OWNER TO postgres;

--
-- Name: inventario_idinventario_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE inventario_idinventario_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.inventario_idinventario_seq OWNER TO postgres;

--
-- Name: inventario_idinventario_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE inventario_idinventario_seq OWNED BY inventario.idinventario;


--
-- Name: inventario_idinventario_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('inventario_idinventario_seq', 8, true);


--
-- Name: lalbaran; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lalbaran (
    numlalbaran integer NOT NULL,
    desclalbaran character varying,
    cantlalbaran numeric(12,2),
    pvplalbaran numeric(12,2),
    descuentolalbaran numeric(12,2),
    ivalalbaran numeric(12,2),
    idalbaran integer NOT NULL,
    idarticulo integer NOT NULL,
    ordenlalbaran integer,
    reqeqlalbaran numeric(12,2) DEFAULT 0,
    lotelalbaran character varying
);


ALTER TABLE public.lalbaran OWNER TO postgres;

--
-- Name: lalbaran_numlalbaran_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lalbaran_numlalbaran_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lalbaran_numlalbaran_seq OWNER TO postgres;

--
-- Name: lalbaran_numlalbaran_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lalbaran_numlalbaran_seq OWNED BY lalbaran.numlalbaran;


--
-- Name: lalbaran_numlalbaran_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lalbaran_numlalbaran_seq', 1579, true);


--
-- Name: lalbaranp; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lalbaranp (
    numlalbaranp integer NOT NULL,
    desclalbaranp character varying,
    cantlalbaranp numeric(12,2),
    ivalalbaranp numeric(12,2),
    pvplalbaranp numeric(12,2),
    descuentolalbaranp numeric(12,2),
    idalbaranp integer NOT NULL,
    idarticulo integer NOT NULL,
    ordenlalbaranp integer,
    reqeqlalbaranp numeric(12,2) DEFAULT 0,
    lotelalbaranp character varying
);


ALTER TABLE public.lalbaranp OWNER TO postgres;

--
-- Name: lalbaranp_numlalbaranp_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lalbaranp_numlalbaranp_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lalbaranp_numlalbaranp_seq OWNER TO postgres;

--
-- Name: lalbaranp_numlalbaranp_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lalbaranp_numlalbaranp_seq OWNED BY lalbaranp.numlalbaranp;


--
-- Name: lalbaranp_numlalbaranp_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lalbaranp_numlalbaranp_seq', 218, true);


SET default_with_oids = false;

--
-- Name: lcontrato; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lcontrato (
    idlcontrato integer NOT NULL,
    idcontrato integer NOT NULL,
    idarticulo integer NOT NULL,
    cantlcontrato numeric(12,2) DEFAULT 1,
    pvplcontrato numeric(12,2) DEFAULT 0,
    desclcontrato character varying,
    ordenlcontrato integer
);


ALTER TABLE public.lcontrato OWNER TO postgres;

--
-- Name: lcontrato_idlcontrato_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lcontrato_idlcontrato_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lcontrato_idlcontrato_seq OWNER TO postgres;

--
-- Name: lcontrato_idlcontrato_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lcontrato_idlcontrato_seq OWNED BY lcontrato.idlcontrato;


--
-- Name: lcontrato_idlcontrato_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lcontrato_idlcontrato_seq', 1, true);


SET default_with_oids = true;

--
-- Name: lfactura; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lfactura (
    idlfactura integer NOT NULL,
    cantlfactura numeric(12,2),
    pvplfactura numeric(12,2),
    ivalfactura numeric(12,2),
    descuentolfactura numeric(12,2),
    idfactura integer NOT NULL,
    idarticulo integer,
    desclfactura character varying,
    ordenlfactura integer,
    reqeqlfactura numeric(12,2) DEFAULT 0,
    lotelfactura character varying
);


ALTER TABLE public.lfactura OWNER TO postgres;

--
-- Name: lfactura_idlfactura_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lfactura_idlfactura_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lfactura_idlfactura_seq OWNER TO postgres;

--
-- Name: lfactura_idlfactura_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lfactura_idlfactura_seq OWNED BY lfactura.idlfactura;


--
-- Name: lfactura_idlfactura_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lfactura_idlfactura_seq', 1291, true);


--
-- Name: lfacturap; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lfacturap (
    idlfacturap integer NOT NULL,
    desclfacturap character varying,
    cantlfacturap numeric(12,2),
    pvplfacturap numeric(12,2),
    ivalfacturap numeric(12,2),
    descuentolfacturap numeric(12,2),
    idfacturap integer NOT NULL,
    idarticulo integer,
    ordenlfacturap integer,
    reqeqlfacturap numeric(12,2) DEFAULT 0,
    lotelfacturap character varying
);


ALTER TABLE public.lfacturap OWNER TO postgres;

--
-- Name: lfacturap_idlfacturap_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lfacturap_idlfacturap_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lfacturap_idlfacturap_seq OWNER TO postgres;

--
-- Name: lfacturap_idlfacturap_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lfacturap_idlfacturap_seq OWNED BY lfacturap.idlfacturap;


--
-- Name: lfacturap_idlfacturap_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lfacturap_idlfacturap_seq', 870, true);


SET default_with_oids = false;

--
-- Name: log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE log (
    idlog integer NOT NULL,
    iplog integer NOT NULL,
    urllog character varying,
    fechalog character varying(20),
    useragentlog character varying,
    getlog character varying,
    postlog character varying,
    sessionlog character varying
);


ALTER TABLE public.log OWNER TO postgres;

--
-- Name: log_idlog_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE log_idlog_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.log_idlog_seq OWNER TO postgres;

--
-- Name: log_idlog_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE log_idlog_seq OWNED BY log.idlog;


--
-- Name: log_idlog_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('log_idlog_seq', 1036, true);


SET default_with_oids = true;

--
-- Name: lpedido; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lpedido (
    numlpedido integer NOT NULL,
    desclpedido character varying(150),
    cantlpedido numeric(12,2),
    pvdlpedido numeric(12,2),
    prevlpedido date,
    ivalpedido numeric(12,2),
    descuentolpedido numeric(12,2),
    idpedido integer NOT NULL,
    idalb_pro integer,
    idarticulo integer,
    reqeqlpedido numeric(12,2) DEFAULT 0
);


ALTER TABLE public.lpedido OWNER TO postgres;

--
-- Name: lpedido_numlpedido_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lpedido_numlpedido_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lpedido_numlpedido_seq OWNER TO postgres;

--
-- Name: lpedido_numlpedido_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lpedido_numlpedido_seq OWNED BY lpedido.numlpedido;


--
-- Name: lpedido_numlpedido_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lpedido_numlpedido_seq', 1, false);


--
-- Name: lpedidocliente; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lpedidocliente (
    numlpedidocliente integer NOT NULL,
    cantlpedidocliente numeric(12,2),
    pvplpedidocliente numeric(12,2),
    prevlpedidocliente date,
    ivalpedidocliente numeric(12,2),
    descuentolpedidocliente numeric(12,2),
    idpedidocliente integer NOT NULL,
    idarticulo integer,
    puntlpedidocliente boolean DEFAULT false,
    desclpedidocliente character varying,
    ordenlpedidocliente integer,
    reqeqlpedidocliente numeric(12,2) DEFAULT 0
);


ALTER TABLE public.lpedidocliente OWNER TO postgres;

--
-- Name: lpedidocliente_numlpedidocliente_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lpedidocliente_numlpedidocliente_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lpedidocliente_numlpedidocliente_seq OWNER TO postgres;

--
-- Name: lpedidocliente_numlpedidocliente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lpedidocliente_numlpedidocliente_seq OWNED BY lpedidocliente.numlpedidocliente;


--
-- Name: lpedidocliente_numlpedidocliente_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lpedidocliente_numlpedidocliente_seq', 1052, true);


--
-- Name: lpedidoproveedor; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lpedidoproveedor (
    idlpedidoproveedor integer NOT NULL,
    desclpedidoproveedor character varying,
    cantlpedidoproveedor numeric(12,2),
    pvplpedidoproveedor numeric(12,2),
    prevlpedidoproveedor date,
    ivalpedidoproveedor numeric(12,2),
    descuentolpedidoproveedor numeric(12,2),
    idpedidoproveedor integer NOT NULL,
    idarticulo integer,
    puntlpedidoproveedor boolean DEFAULT false,
    ordenlpedidoproveedor integer,
    reqeqlpedidoproveedor numeric(12,2) DEFAULT 0
);


ALTER TABLE public.lpedidoproveedor OWNER TO postgres;

--
-- Name: lpedidoproveedor_numlpedidoproveedor_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lpedidoproveedor_numlpedidoproveedor_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lpedidoproveedor_numlpedidoproveedor_seq OWNER TO postgres;

--
-- Name: lpedidoproveedor_numlpedidoproveedor_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lpedidoproveedor_numlpedidoproveedor_seq OWNED BY lpedidoproveedor.idlpedidoproveedor;


--
-- Name: lpedidoproveedor_numlpedidoproveedor_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lpedidoproveedor_numlpedidoproveedor_seq', 93, true);


--
-- Name: lpresupuesto; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE lpresupuesto (
    idlpresupuesto integer NOT NULL,
    cantlpresupuesto numeric(12,2),
    pvplpresupuesto numeric(12,2),
    ivalpresupuesto numeric(12,2),
    descuentolpresupuesto numeric(12,2),
    idpresupuesto integer NOT NULL,
    idarticulo integer,
    desclpresupuesto character varying,
    ordenlpresupuesto integer,
    reqeqlpresupuesto numeric(12,2) DEFAULT 0
);


ALTER TABLE public.lpresupuesto OWNER TO postgres;

--
-- Name: lpresupuesto_idlpresupuesto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE lpresupuesto_idlpresupuesto_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lpresupuesto_idlpresupuesto_seq OWNER TO postgres;

--
-- Name: lpresupuesto_idlpresupuesto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE lpresupuesto_idlpresupuesto_seq OWNED BY lpresupuesto.idlpresupuesto;


--
-- Name: lpresupuesto_idlpresupuesto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('lpresupuesto_idlpresupuesto_seq', 841, true);


--
-- Name: ltarifa; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE ltarifa (
    idltarifa integer NOT NULL,
    idalmacen integer NOT NULL,
    idarticulo integer NOT NULL,
    idtarifa integer NOT NULL,
    pvpltarifa numeric(13,4)
);


ALTER TABLE public.ltarifa OWNER TO postgres;

--
-- Name: ltarifa_idltarifa_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE ltarifa_idltarifa_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ltarifa_idltarifa_seq OWNER TO postgres;

--
-- Name: ltarifa_idltarifa_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE ltarifa_idltarifa_seq OWNED BY ltarifa.idltarifa;


--
-- Name: ltarifa_idltarifa_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('ltarifa_idltarifa_seq', 1, false);


SET default_with_oids = false;

--
-- Name: minimsalmacen; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE minimsalmacen (
    idminimsalmacen integer NOT NULL,
    idalmacen integer NOT NULL,
    idarticulo integer NOT NULL,
    valminimsalmacen numeric(12,2) NOT NULL
);


ALTER TABLE public.minimsalmacen OWNER TO postgres;

--
-- Name: minimsalmacen_idminimsalmacen_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE minimsalmacen_idminimsalmacen_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.minimsalmacen_idminimsalmacen_seq OWNER TO postgres;

--
-- Name: minimsalmacen_idminimsalmacen_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE minimsalmacen_idminimsalmacen_seq OWNED BY minimsalmacen.idminimsalmacen;


--
-- Name: minimsalmacen_idminimsalmacen_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('minimsalmacen_idminimsalmacen_seq', 1, true);


SET default_with_oids = true;

--
-- Name: moneda; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE moneda (
    idmoneda integer NOT NULL,
    cod2moneda character varying(2),
    cod3moneda character varying(3),
    descmoneda character varying(50)
);


ALTER TABLE public.moneda OWNER TO postgres;

--
-- Name: moneda_idmoneda_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE moneda_idmoneda_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.moneda_idmoneda_seq OWNER TO postgres;

--
-- Name: moneda_idmoneda_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE moneda_idmoneda_seq OWNED BY moneda.idmoneda;


--
-- Name: moneda_idmoneda_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('moneda_idmoneda_seq', 1, false);


SET default_with_oids = false;

--
-- Name: movimiento; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE movimiento (
    idmovimiento integer NOT NULL,
    fechamovimiento date NOT NULL,
    idarticulo integer NOT NULL,
    cantidadmovimiento numeric(12,2) NOT NULL,
    lotemovimiento character varying,
    idalmacen integer NOT NULL,
    idlalbaran integer,
    idlalbaranp integer
);


ALTER TABLE public.movimiento OWNER TO postgres;

--
-- Name: movimiento_idmovimiento_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE movimiento_idmovimiento_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.movimiento_idmovimiento_seq OWNER TO postgres;

--
-- Name: movimiento_idmovimiento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE movimiento_idmovimiento_seq OWNED BY movimiento.idmovimiento;


--
-- Name: movimiento_idmovimiento_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('movimiento_idmovimiento_seq', 337, true);


SET default_with_oids = true;

--
-- Name: nofactura; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE nofactura (
    idnofactura integer NOT NULL,
    numnofactura integer NOT NULL,
    fechanofactura date,
    conceptnofactura character varying(150),
    observnofactura character varying(150),
    idalmacen integer NOT NULL
);


ALTER TABLE public.nofactura OWNER TO postgres;

--
-- Name: nofactura_idnofactura_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE nofactura_idnofactura_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.nofactura_idnofactura_seq OWNER TO postgres;

--
-- Name: nofactura_idnofactura_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE nofactura_idnofactura_seq OWNED BY nofactura.idnofactura;


--
-- Name: nofactura_idnofactura_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('nofactura_idnofactura_seq', 1, false);


--
-- Name: pago; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pago (
    idpago integer NOT NULL,
    idproveedor integer NOT NULL,
    fechapago date DEFAULT now(),
    cantpago numeric(12,2) DEFAULT 0,
    refpago character varying(12) NOT NULL,
    previsionpago boolean DEFAULT false,
    comentpago character varying(500),
    idtrabajador integer,
    idbanco integer,
    idasientopago integer
);


ALTER TABLE public.pago OWNER TO postgres;

--
-- Name: pago_idpago_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pago_idpago_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pago_idpago_seq OWNER TO postgres;

--
-- Name: pago_idpago_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pago_idpago_seq OWNED BY pago.idpago;


--
-- Name: pago_idpago_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pago_idpago_seq', 137, true);


SET default_with_oids = false;

--
-- Name: pais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pais (
    idpais integer NOT NULL,
    cod2pais character varying(2),
    cod3pais character varying(3),
    descpais character varying(50)
);


ALTER TABLE public.pais OWNER TO postgres;

--
-- Name: pais_idpais_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pais_idpais_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pais_idpais_seq OWNER TO postgres;

--
-- Name: pais_idpais_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pais_idpais_seq OWNED BY pais.idpais;


--
-- Name: pais_idpais_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pais_idpais_seq', 11, true);


SET default_with_oids = true;

--
-- Name: pedido; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pedido (
    idpedido integer NOT NULL,
    numpedido character varying(60),
    fechapedido date,
    descpedido character varying(500),
    iddivision integer NOT NULL,
    idalmacen integer NOT NULL,
    idtrabajador integer
);


ALTER TABLE public.pedido OWNER TO postgres;

--
-- Name: pedido_idpedido_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pedido_idpedido_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pedido_idpedido_seq OWNER TO postgres;

--
-- Name: pedido_idpedido_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pedido_idpedido_seq OWNED BY pedido.idpedido;


--
-- Name: pedido_idpedido_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pedido_idpedido_seq', 1, false);


--
-- Name: pedidocliente; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pedidocliente (
    idpedidocliente integer NOT NULL,
    numpedidocliente integer NOT NULL,
    fechapedidocliente date DEFAULT now(),
    refpedidocliente character varying(12) NOT NULL,
    descpedidocliente character varying(500),
    comentpedidocliente character varying(3000),
    contactpedidocliente character varying(90),
    telpedidocliente character varying(20),
    idpresupuesto integer,
    procesadopedidocliente boolean DEFAULT false,
    idcliente integer NOT NULL,
    idforma_pago integer,
    idalmacen integer NOT NULL,
    idtrabajador integer,
    totalpedidocliente numeric(12,2) DEFAULT 0,
    bimppedidocliente numeric(12,2) DEFAULT 0,
    imppedidocliente numeric(12,2) DEFAULT 0
);


ALTER TABLE public.pedidocliente OWNER TO postgres;

--
-- Name: pedidocliente_idpedidocliente_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pedidocliente_idpedidocliente_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pedidocliente_idpedidocliente_seq OWNER TO postgres;

--
-- Name: pedidocliente_idpedidocliente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pedidocliente_idpedidocliente_seq OWNED BY pedidocliente.idpedidocliente;


--
-- Name: pedidocliente_idpedidocliente_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pedidocliente_idpedidocliente_seq', 488, true);


--
-- Name: pedidoproveedor; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pedidoproveedor (
    idpedidoproveedor integer NOT NULL,
    numpedidoproveedor integer NOT NULL,
    fechapedidoproveedor date,
    refpedidoproveedor character varying(12) NOT NULL,
    descpedidoproveedor character varying(500),
    comentpedidoproveedor character varying(3000),
    contactpedidoproveedor character varying(90),
    telpedidoproveedor character varying(20),
    procesadopedidoproveedor boolean DEFAULT false,
    idproveedor integer NOT NULL,
    idforma_pago integer,
    idalmacen integer NOT NULL,
    idtrabajador integer,
    totalpedidoproveedor numeric(12,2) DEFAULT 0,
    bimppedidoproveedor numeric(12,2) DEFAULT 0,
    imppedidoproveedor numeric(12,2) DEFAULT 0
);


ALTER TABLE public.pedidoproveedor OWNER TO postgres;

--
-- Name: pedidoproveedor_idpedidoproveedor_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pedidoproveedor_idpedidoproveedor_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pedidoproveedor_idpedidoproveedor_seq OWNER TO postgres;

--
-- Name: pedidoproveedor_idpedidoproveedor_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pedidoproveedor_idpedidoproveedor_seq OWNED BY pedidoproveedor.idpedidoproveedor;


--
-- Name: pedidoproveedor_idpedidoproveedor_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pedidoproveedor_idpedidoproveedor_seq', 35, true);


--
-- Name: precio_compra; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE precio_compra (
    idprecio_compra integer NOT NULL,
    idarticulo integer NOT NULL,
    iddivision integer,
    idalmacen integer,
    fechapreciocompra date,
    valorpreciocompra numeric(13,4) NOT NULL
);


ALTER TABLE public.precio_compra OWNER TO postgres;

--
-- Name: precio_compra_idprecio_compra_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE precio_compra_idprecio_compra_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.precio_compra_idprecio_compra_seq OWNER TO postgres;

--
-- Name: precio_compra_idprecio_compra_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE precio_compra_idprecio_compra_seq OWNED BY precio_compra.idprecio_compra;


--
-- Name: precio_compra_idprecio_compra_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('precio_compra_idprecio_compra_seq', 1, true);


--
-- Name: presupuesto; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE presupuesto (
    idpresupuesto integer NOT NULL,
    numpresupuesto integer NOT NULL,
    refpresupuesto character varying(12) NOT NULL,
    fpresupuesto date DEFAULT now(),
    descpresupuesto character varying(150),
    contactpresupuesto character varying(90),
    telpresupuesto character varying(20),
    vencpresupuesto date,
    comentpresupuesto character varying(3000),
    idusuari integer,
    procesadopresupuesto boolean DEFAULT false,
    idcliente integer,
    idalmacen integer NOT NULL,
    idforma_pago integer NOT NULL,
    idtrabajador integer,
    totalpresupuesto numeric(12,2) DEFAULT 0,
    bimppresupuesto numeric(12,2) DEFAULT 0,
    imppresupuesto numeric(12,2) DEFAULT 0
);


ALTER TABLE public.presupuesto OWNER TO postgres;

--
-- Name: presupuesto_idpresupuesto_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE presupuesto_idpresupuesto_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.presupuesto_idpresupuesto_seq OWNER TO postgres;

--
-- Name: presupuesto_idpresupuesto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE presupuesto_idpresupuesto_seq OWNED BY presupuesto.idpresupuesto;


--
-- Name: presupuesto_idpresupuesto_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('presupuesto_idpresupuesto_seq', 290, true);


--
-- Name: proveedor; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE proveedor (
    idproveedor integer NOT NULL,
    nomproveedor character varying(200),
    nomaltproveedor character varying(200),
    cifproveedor character varying(12),
    codicliproveedor character varying(30),
    comentproveedor character varying(2000),
    poblproveedor character varying(50),
    cpproveedor character varying(9) NOT NULL,
    emailproveedor character varying(100),
    urlproveedor character varying(100),
    clavewebproveedor character varying(100),
    inactivoproveedor character(1),
    telproveedor character varying(48),
    faxproveedor character varying(48),
    dirproveedor character varying(250),
    codproveedor character varying(12),
    recargoeqproveedor boolean DEFAULT false,
    idforma_pago integer,
    regimenfiscalproveedor character varying(50) NOT NULL,
    irpfproveedor numeric(12,2) DEFAULT 0,
    cbancproveedor character(120),
    idprovincia integer,
    idcuentaproveedor integer
);


ALTER TABLE public.proveedor OWNER TO postgres;

--
-- Name: proveedor_idproveedor_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE proveedor_idproveedor_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.proveedor_idproveedor_seq OWNER TO postgres;

--
-- Name: proveedor_idproveedor_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE proveedor_idproveedor_seq OWNED BY proveedor.idproveedor;


--
-- Name: proveedor_idproveedor_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('proveedor_idproveedor_seq', 40, true);


SET default_with_oids = false;

--
-- Name: provincia; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE provincia (
    idprovincia integer NOT NULL,
    idpais integer,
    provincia character varying(500)
);


ALTER TABLE public.provincia OWNER TO postgres;

--
-- Name: provincia_idprovincia_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE provincia_idprovincia_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.provincia_idprovincia_seq OWNER TO postgres;

--
-- Name: provincia_idprovincia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE provincia_idprovincia_seq OWNED BY provincia.idprovincia;


--
-- Name: provincia_idprovincia_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('provincia_idprovincia_seq', 10, true);


--
-- Name: q19; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE q19 (
    idq19 integer NOT NULL,
    fechaq19 date,
    nomq19 character varying
);


ALTER TABLE public.q19 OWNER TO postgres;

--
-- Name: q19_idq19_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE q19_idq19_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.q19_idq19_seq OWNER TO postgres;

--
-- Name: q19_idq19_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE q19_idq19_seq OWNED BY q19.idq19;


--
-- Name: q19_idq19_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('q19_idq19_seq', 2, true);


--
-- Name: rutacomercial; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE rutacomercial (
    idrutacomercial integer NOT NULL,
    fecharutacomercial date,
    idcliente integer,
    comentariosrutacomercial character varying,
    horarutacomercial time without time zone,
    refrutacomercial character varying
);


ALTER TABLE public.rutacomercial OWNER TO postgres;

--
-- Name: rutacomercial_idrutacomercial_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE rutacomercial_idrutacomercial_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.rutacomercial_idrutacomercial_seq OWNER TO postgres;

--
-- Name: rutacomercial_idrutacomercial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE rutacomercial_idrutacomercial_seq OWNED BY rutacomercial.idrutacomercial;


--
-- Name: rutacomercial_idrutacomercial_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('rutacomercial_idrutacomercial_seq', 1, false);


SET default_with_oids = true;

--
-- Name: serie_factura; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE serie_factura (
    codigoserie_factura character varying(6) NOT NULL,
    descserie_factura character varying(50) NOT NULL
);


ALTER TABLE public.serie_factura OWNER TO postgres;

--
-- Name: stock_almacen; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE stock_almacen (
    idarticulo integer NOT NULL,
    idalmacen integer NOT NULL,
    stock numeric(12,2) DEFAULT 0
);


ALTER TABLE public.stock_almacen OWNER TO postgres;

--
-- Name: suministra; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE suministra (
    idsuministra integer NOT NULL,
    refpro character varying(100),
    principalsuministra numeric(12,2),
    idproveedor integer,
    idarticulo integer
);


ALTER TABLE public.suministra OWNER TO postgres;

--
-- Name: suministra_idsuministra_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE suministra_idsuministra_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.suministra_idsuministra_seq OWNER TO postgres;

--
-- Name: suministra_idsuministra_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE suministra_idsuministra_seq OWNED BY suministra.idsuministra;


--
-- Name: suministra_idsuministra_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('suministra_idsuministra_seq', 1, false);


--
-- Name: tarifa; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tarifa (
    idtarifa integer NOT NULL,
    nomtarifa character varying(60),
    finiciotarifa date,
    ffintarifa date
);


ALTER TABLE public.tarifa OWNER TO postgres;

--
-- Name: tarifa_idtarifa_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tarifa_idtarifa_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tarifa_idtarifa_seq OWNER TO postgres;

--
-- Name: tarifa_idtarifa_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tarifa_idtarifa_seq OWNED BY tarifa.idtarifa;


--
-- Name: tarifa_idtarifa_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tarifa_idtarifa_seq', 1, false);


--
-- Name: tasa_iva; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tasa_iva (
    idtasa_iva integer NOT NULL,
    idtipo_iva integer NOT NULL,
    porcentasa_iva numeric(5,2) NOT NULL,
    fechatasa_iva date NOT NULL,
    porcentretasa_iva numeric(5,2) DEFAULT 0
);


ALTER TABLE public.tasa_iva OWNER TO postgres;

--
-- Name: tasa_iva_idtasa_iva_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tasa_iva_idtasa_iva_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tasa_iva_idtasa_iva_seq OWNER TO postgres;

--
-- Name: tasa_iva_idtasa_iva_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tasa_iva_idtasa_iva_seq OWNED BY tasa_iva.idtasa_iva;


--
-- Name: tasa_iva_idtasa_iva_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tasa_iva_idtasa_iva_seq', 1, false);


--
-- Name: ticket; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE ticket (
    numticket integer NOT NULL,
    fechaticket date
);


ALTER TABLE public.ticket OWNER TO postgres;

--
-- Name: tipo_articulo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tipo_articulo (
    idtipo_articulo integer NOT NULL,
    codtipo_articulo character varying(10),
    desctipo_articulo character varying(50)
);


ALTER TABLE public.tipo_articulo OWNER TO postgres;

--
-- Name: tipo_articulo_idtipo_articulo_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tipo_articulo_idtipo_articulo_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tipo_articulo_idtipo_articulo_seq OWNER TO postgres;

--
-- Name: tipo_articulo_idtipo_articulo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tipo_articulo_idtipo_articulo_seq OWNED BY tipo_articulo.idtipo_articulo;


--
-- Name: tipo_articulo_idtipo_articulo_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tipo_articulo_idtipo_articulo_seq', 38, true);


SET default_with_oids = false;

--
-- Name: tipo_evento; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tipo_evento (
    idtipo_evento integer NOT NULL,
    nomtipo_evento character varying
);


ALTER TABLE public.tipo_evento OWNER TO postgres;

--
-- Name: tipo_evento_idtipo_evento_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tipo_evento_idtipo_evento_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tipo_evento_idtipo_evento_seq OWNER TO postgres;

--
-- Name: tipo_evento_idtipo_evento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tipo_evento_idtipo_evento_seq OWNED BY tipo_evento.idtipo_evento;


--
-- Name: tipo_evento_idtipo_evento_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tipo_evento_idtipo_evento_seq', 1, true);


SET default_with_oids = true;

--
-- Name: tipo_iva; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tipo_iva (
    idtipo_iva integer NOT NULL,
    desctipo_iva character varying(2000)
);


ALTER TABLE public.tipo_iva OWNER TO postgres;

--
-- Name: tipo_iva_idtipo_iva_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tipo_iva_idtipo_iva_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tipo_iva_idtipo_iva_seq OWNER TO postgres;

--
-- Name: tipo_iva_idtipo_iva_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tipo_iva_idtipo_iva_seq OWNED BY tipo_iva.idtipo_iva;


--
-- Name: tipo_iva_idtipo_iva_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tipo_iva_idtipo_iva_seq', 1, false);


SET default_with_oids = false;

--
-- Name: tipotrabajo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tipotrabajo (
    idtipotrabajo integer NOT NULL,
    nomtipotrabajo character varying NOT NULL,
    colortipotrabajo character varying
);


ALTER TABLE public.tipotrabajo OWNER TO postgres;

--
-- Name: tipotrabajo_idtipotrabajo_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tipotrabajo_idtipotrabajo_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tipotrabajo_idtipotrabajo_seq OWNER TO postgres;

--
-- Name: tipotrabajo_idtipotrabajo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tipotrabajo_idtipotrabajo_seq OWNED BY tipotrabajo.idtipotrabajo;


--
-- Name: tipotrabajo_idtipotrabajo_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tipotrabajo_idtipotrabajo_seq', 4, true);


SET default_with_oids = true;

--
-- Name: trabajador; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE trabajador (
    idtrabajador integer NOT NULL,
    nomtrabajador character varying NOT NULL,
    apellidostrabajador character varying,
    dirtrabajador character varying,
    nsstrabajador character varying,
    teltrabajador character varying,
    moviltrabajador character varying,
    emailtrabajador character varying,
    fototrabajador character varying,
    activotrabajador boolean DEFAULT true NOT NULL,
    idtipotrabajo integer,
    tipotrabajador character varying,
    idzonacomercial integer,
    passasterisktrabajador character varying
);


ALTER TABLE public.trabajador OWNER TO postgres;

--
-- Name: trabajador_idtrabajador_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE trabajador_idtrabajador_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.trabajador_idtrabajador_seq OWNER TO postgres;

--
-- Name: trabajador_idtrabajador_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE trabajador_idtrabajador_seq OWNED BY trabajador.idtrabajador;


--
-- Name: trabajador_idtrabajador_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('trabajador_idtrabajador_seq', 15, true);


--
-- Name: usuario; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE usuario (
    loginusuario character varying(15) NOT NULL,
    nombreusuario character varying(35),
    apellido1usuario character varying(35),
    apellido2usuario character varying(35),
    claveusuario character varying(35),
    permisosusuario text
);


ALTER TABLE public.usuario OWNER TO postgres;

SET default_with_oids = false;

--
-- Name: valasterisk; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE valasterisk (
    idvalasterisk integer NOT NULL,
    fechavalasterisk date DEFAULT now() NOT NULL,
    idalmacen integer NOT NULL,
    idtrabajador integer NOT NULL,
    horavalasterisk time without time zone DEFAULT now() NOT NULL,
    archvalasterisk character varying
);


ALTER TABLE public.valasterisk OWNER TO postgres;

--
-- Name: valasterisk_idvalasterisk_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE valasterisk_idvalasterisk_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.valasterisk_idvalasterisk_seq OWNER TO postgres;

--
-- Name: valasterisk_idvalasterisk_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE valasterisk_idvalasterisk_seq OWNED BY valasterisk.idvalasterisk;


--
-- Name: valasterisk_idvalasterisk_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('valasterisk_idvalasterisk_seq', 22, true);


--
-- Name: z; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE z (
    idz integer NOT NULL,
    fechaz date DEFAULT now(),
    horaz time without time zone DEFAULT now(),
    totalz numeric(12,2),
    idalmacen integer NOT NULL,
    numtickets integer
);


ALTER TABLE public.z OWNER TO postgres;

--
-- Name: z_idz_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE z_idz_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.z_idz_seq OWNER TO postgres;

--
-- Name: z_idz_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE z_idz_seq OWNED BY z.idz;


--
-- Name: z_idz_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('z_idz_seq', 7, true);


--
-- Name: zonacomercial; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE zonacomercial (
    idzonacomercial integer NOT NULL,
    nomzonacomercial character varying
);


ALTER TABLE public.zonacomercial OWNER TO postgres;

--
-- Name: zonacomercial_idzonacomercial_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE zonacomercial_idzonacomercial_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.zonacomercial_idzonacomercial_seq OWNER TO postgres;

--
-- Name: zonacomercial_idzonacomercial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE zonacomercial_idzonacomercial_seq OWNED BY zonacomercial.idzonacomercial;


--
-- Name: zonacomercial_idzonacomercial_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('zonacomercial_idzonacomercial_seq', 1, false);


--
-- Name: idalb_pro; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE alb_pro ALTER COLUMN idalb_pro SET DEFAULT nextval('alb_pro_idalb_pro_seq'::regclass);


--
-- Name: idalbaran; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE albaran ALTER COLUMN idalbaran SET DEFAULT nextval('albaran_idalbaran_seq'::regclass);


--
-- Name: idalbaranp; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE albaranp ALTER COLUMN idalbaranp SET DEFAULT nextval('albaranp_idalbaranp_seq'::regclass);


--
-- Name: idalmacen; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE almacen ALTER COLUMN idalmacen SET DEFAULT nextval('almacen_idalmacen_seq'::regclass);


--
-- Name: idarticulo; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE articulo ALTER COLUMN idarticulo SET DEFAULT nextval('articulo_idarticulo_seq'::regclass);


--
-- Name: idausencia; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ausencia ALTER COLUMN idausencia SET DEFAULT nextval('ausencia_idausencia_seq'::regclass);


--
-- Name: idbanco; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE banco ALTER COLUMN idbanco SET DEFAULT nextval('banco_idbanco_seq'::regclass);


--
-- Name: idcliente; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE cliente ALTER COLUMN idcliente SET DEFAULT nextval('cliente_idcliente_seq'::regclass);


--
-- Name: idcobro; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE cobro ALTER COLUMN idcobro SET DEFAULT nextval('cobro_idcobro_seq'::regclass);


--
-- Name: idcodigobarras; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE codigobarras ALTER COLUMN idcodigobarras SET DEFAULT nextval('codigobarras_idcodigobarras_seq'::regclass);


--
-- Name: idcomentario_evento; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE comentario_evento ALTER COLUMN idcomentario_evento SET DEFAULT nextval('comentario_evento_idcomentario_evento_seq'::regclass);


--
-- Name: idcontrato; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE contrato ALTER COLUMN idcontrato SET DEFAULT nextval('contrato_idcontrato_seq'::regclass);


--
-- Name: idcuadrante; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE cuadrante ALTER COLUMN idcuadrante SET DEFAULT nextval('cuadrante_idcuadrante_seq'::regclass);


--
-- Name: iddalbaran; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dalbaran ALTER COLUMN iddalbaran SET DEFAULT nextval('dalbaran_iddalbaran_seq'::regclass);


--
-- Name: iddalbaranp; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dalbaranp ALTER COLUMN iddalbaranp SET DEFAULT nextval('dalbaranp_iddalbaranp_seq'::regclass);


--
-- Name: iddfactura; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dfactura ALTER COLUMN iddfactura SET DEFAULT nextval('dfactura_iddfactura_seq'::regclass);


--
-- Name: iddfacturap; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dfacturap ALTER COLUMN iddfacturap SET DEFAULT nextval('dfacturap_iddfacturap_seq'::regclass);


--
-- Name: iddivision; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE division ALTER COLUMN iddivision SET DEFAULT nextval('division_iddivision_seq'::regclass);


--
-- Name: iddpedidocliente; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dpedidocliente ALTER COLUMN iddpedidocliente SET DEFAULT nextval('dpedidocliente_iddpedidocliente_seq'::regclass);


--
-- Name: iddpedidoproveedor; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dpedidoproveedor ALTER COLUMN iddpedidoproveedor SET DEFAULT nextval('dpedidoproveedor_iddpedidoproveedor_seq'::regclass);


--
-- Name: iddpresupuesto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dpresupuesto ALTER COLUMN iddpresupuesto SET DEFAULT nextval('dpresupuesto_iddpresupuesto_seq'::regclass);


--
-- Name: idestado_evento; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE estado_evento ALTER COLUMN idestado_evento SET DEFAULT nextval('estado_evento_idestado_evento_seq'::regclass);


--
-- Name: idevento; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE evento ALTER COLUMN idevento SET DEFAULT nextval('evento_idevento_seq'::regclass);


--
-- Name: idfactura; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE factura ALTER COLUMN idfactura SET DEFAULT nextval('factura_idfactura_seq'::regclass);


--
-- Name: idfacturap; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE facturap ALTER COLUMN idfacturap SET DEFAULT nextval('facturap_idfacturap_seq'::regclass);


--
-- Name: idfamilia; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE familia ALTER COLUMN idfamilia SET DEFAULT nextval('familia_idfamilia_seq'::regclass);


--
-- Name: idforma_pago; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE forma_pago ALTER COLUMN idforma_pago SET DEFAULT nextval('forma_pago_idforma_pago_seq'::regclass);


--
-- Name: idfra_pro; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE fra_pro ALTER COLUMN idfra_pro SET DEFAULT nextval('fra_pro_idfra_pro_seq'::regclass);


--
-- Name: idhorario; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE horario ALTER COLUMN idhorario SET DEFAULT nextval('horario_idhorario_seq'::regclass);


--
-- Name: idincidenciacomercial; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE incidenciacomercial ALTER COLUMN idincidenciacomercial SET DEFAULT nextval('incidenciacomercial_idincidenciacomercial_seq'::regclass);


--
-- Name: idinventario; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE inventario ALTER COLUMN idinventario SET DEFAULT nextval('inventario_idinventario_seq'::regclass);


--
-- Name: numlalbaran; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lalbaran ALTER COLUMN numlalbaran SET DEFAULT nextval('lalbaran_numlalbaran_seq'::regclass);


--
-- Name: numlalbaranp; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lalbaranp ALTER COLUMN numlalbaranp SET DEFAULT nextval('lalbaranp_numlalbaranp_seq'::regclass);


--
-- Name: idlcontrato; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lcontrato ALTER COLUMN idlcontrato SET DEFAULT nextval('lcontrato_idlcontrato_seq'::regclass);


--
-- Name: idlfactura; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lfactura ALTER COLUMN idlfactura SET DEFAULT nextval('lfactura_idlfactura_seq'::regclass);


--
-- Name: idlfacturap; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lfacturap ALTER COLUMN idlfacturap SET DEFAULT nextval('lfacturap_idlfacturap_seq'::regclass);


--
-- Name: idlog; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE log ALTER COLUMN idlog SET DEFAULT nextval('log_idlog_seq'::regclass);


--
-- Name: numlpedido; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lpedido ALTER COLUMN numlpedido SET DEFAULT nextval('lpedido_numlpedido_seq'::regclass);


--
-- Name: numlpedidocliente; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lpedidocliente ALTER COLUMN numlpedidocliente SET DEFAULT nextval('lpedidocliente_numlpedidocliente_seq'::regclass);


--
-- Name: idlpedidoproveedor; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lpedidoproveedor ALTER COLUMN idlpedidoproveedor SET DEFAULT nextval('lpedidoproveedor_numlpedidoproveedor_seq'::regclass);


--
-- Name: idlpresupuesto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE lpresupuesto ALTER COLUMN idlpresupuesto SET DEFAULT nextval('lpresupuesto_idlpresupuesto_seq'::regclass);


--
-- Name: idltarifa; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ltarifa ALTER COLUMN idltarifa SET DEFAULT nextval('ltarifa_idltarifa_seq'::regclass);


--
-- Name: idminimsalmacen; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE minimsalmacen ALTER COLUMN idminimsalmacen SET DEFAULT nextval('minimsalmacen_idminimsalmacen_seq'::regclass);


--
-- Name: idmoneda; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE moneda ALTER COLUMN idmoneda SET DEFAULT nextval('moneda_idmoneda_seq'::regclass);


--
-- Name: idmovimiento; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE movimiento ALTER COLUMN idmovimiento SET DEFAULT nextval('movimiento_idmovimiento_seq'::regclass);


--
-- Name: idnofactura; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE nofactura ALTER COLUMN idnofactura SET DEFAULT nextval('nofactura_idnofactura_seq'::regclass);


--
-- Name: idpago; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pago ALTER COLUMN idpago SET DEFAULT nextval('pago_idpago_seq'::regclass);


--
-- Name: idpais; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pais ALTER COLUMN idpais SET DEFAULT nextval('pais_idpais_seq'::regclass);


--
-- Name: idpedido; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pedido ALTER COLUMN idpedido SET DEFAULT nextval('pedido_idpedido_seq'::regclass);


--
-- Name: idpedidocliente; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pedidocliente ALTER COLUMN idpedidocliente SET DEFAULT nextval('pedidocliente_idpedidocliente_seq'::regclass);


--
-- Name: idpedidoproveedor; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pedidoproveedor ALTER COLUMN idpedidoproveedor SET DEFAULT nextval('pedidoproveedor_idpedidoproveedor_seq'::regclass);


--
-- Name: idprecio_compra; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE precio_compra ALTER COLUMN idprecio_compra SET DEFAULT nextval('precio_compra_idprecio_compra_seq'::regclass);


--
-- Name: idpresupuesto; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE presupuesto ALTER COLUMN idpresupuesto SET DEFAULT nextval('presupuesto_idpresupuesto_seq'::regclass);


--
-- Name: idproveedor; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE proveedor ALTER COLUMN idproveedor SET DEFAULT nextval('proveedor_idproveedor_seq'::regclass);


--
-- Name: idprovincia; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE provincia ALTER COLUMN idprovincia SET DEFAULT nextval('provincia_idprovincia_seq'::regclass);


--
-- Name: idq19; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE q19 ALTER COLUMN idq19 SET DEFAULT nextval('q19_idq19_seq'::regclass);


--
-- Name: idrutacomercial; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE rutacomercial ALTER COLUMN idrutacomercial SET DEFAULT nextval('rutacomercial_idrutacomercial_seq'::regclass);


--
-- Name: idsuministra; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE suministra ALTER COLUMN idsuministra SET DEFAULT nextval('suministra_idsuministra_seq'::regclass);


--
-- Name: idtarifa; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tarifa ALTER COLUMN idtarifa SET DEFAULT nextval('tarifa_idtarifa_seq'::regclass);


--
-- Name: idtasa_iva; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tasa_iva ALTER COLUMN idtasa_iva SET DEFAULT nextval('tasa_iva_idtasa_iva_seq'::regclass);


--
-- Name: idtipo_articulo; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tipo_articulo ALTER COLUMN idtipo_articulo SET DEFAULT nextval('tipo_articulo_idtipo_articulo_seq'::regclass);


--
-- Name: idtipo_evento; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tipo_evento ALTER COLUMN idtipo_evento SET DEFAULT nextval('tipo_evento_idtipo_evento_seq'::regclass);


--
-- Name: idtipo_iva; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tipo_iva ALTER COLUMN idtipo_iva SET DEFAULT nextval('tipo_iva_idtipo_iva_seq'::regclass);


--
-- Name: idtipotrabajo; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tipotrabajo ALTER COLUMN idtipotrabajo SET DEFAULT nextval('tipotrabajo_idtipotrabajo_seq'::regclass);


--
-- Name: idtrabajador; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE trabajador ALTER COLUMN idtrabajador SET DEFAULT nextval('trabajador_idtrabajador_seq'::regclass);


--
-- Name: idvalasterisk; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE valasterisk ALTER COLUMN idvalasterisk SET DEFAULT nextval('valasterisk_idvalasterisk_seq'::regclass);


--
-- Name: idz; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE z ALTER COLUMN idz SET DEFAULT nextval('z_idz_seq'::regclass);


--
-- Name: idzonacomercial; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE zonacomercial ALTER COLUMN idzonacomercial SET DEFAULT nextval('zonacomercial_idzonacomercial_seq'::regclass);


--
-- Data for Name: alb_pro; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY alb_pro (idalb_pro, ncompraalb_pro, nalbalb_pro, fcrealb_pro, frecepalb_pro, comentalb_pro, idfra_pro, idalmacen) FROM stdin;
\.


--
-- Data for Name: albaran; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY albaran (idalbaran, numalbaran, descalbaran, refalbaran, fechaalbaran, comentalbaran, procesadoalbaran, contactalbaran, telalbaran, idcliente, idforma_pago, idfactura, idnofactura, idalmacen, idtrabajador, comentprivalbaran, totalalbaran, bimpalbaran, impalbaran, horaalbaran, anuladoalbaran, ticketalbaran, recogidoalbaran, idz) FROM stdin;
725	144	TINTA	UDRXOU	2007-05-07	\N	t	Carmen	\N	126	1	\N	\N	1	2	\N	33.99	29.30	4.69	20:54:46.971476	\N	\N	\N	\N
726	145	HOST	KIOYPZ	2007-05-08	\N	t	\N	\N	44	1	\N	\N	1	1	\N	417.60	360.00	57.60	20:54:46.971476	\N	\N	\N	\N
728	147	SERVIDOR	CCOBCG	2007-05-08	\N	t	PEPMA	\N	133	1	\N	\N	1	6	\N	174.00	150.00	24.00	20:54:46.971476	\N	\N	\N	\N
729	148	RENOVACION .COM	DOOEWQ	2007-05-08	\N	t	\N	\N	41	6	\N	\N	1	1	\N	34.80	30.00	4.80	20:54:46.971476	\N	\N	\N	\N
730	149	MANTENIMIENTO	VLVVBH	2007-05-08	\N	t	Jaime Jaume	\N	19	2	\N	\N	1	1	\N	580.00	500.00	80.00	20:54:46.971476	\N	\N	\N	\N
684	105	T. RED	YUJKKK	2007-03-27	None\n	f	Pep Sabater	None	54	1	\N	\N	1	\N	[None]\n	173.70	149.74	23.96	20:54:46.971476	\N	\N	\N	\N
773	190	Tintas HP	OWZYDK	2007-05-15	\N	t	\N	\N	91	1	\N	\N	1	2	\N	52.21	45.01	7.20	20:54:46.971476	\N	\N	\N	\N
582	19	PROGRAMACION	SKEEQF	2006-11-14	\N	t	jUAN pEDRO FULLANA	\N	88	1	\N	\N	1	2	\N	40.60	35.00	5.60	20:54:46.971476	\N	\N	\N	\N
584	21	openvpn	DEANCB	2006-12-12	\N	f	\N	\N	59	1	\N	\N	1	6	\N	396.72	342.00	54.72	20:54:46.971476	\N	\N	\N	\N
694	115	MAT	YRPKXT	2007-04-23	\N	t	\N	\N	103	4	\N	\N	1	6	\N	371.70	320.43	51.28	20:54:46.971476	\N	\N	\N	\N
775	192	REVISION ONO	DYIIKQ	2007-05-16	Revision conexion internet ONO\nRevision Spybot\n\n	f	LUIS FRAILE	None	139	1	\N	\N	1	\N	[None]\n\n	20.30	17.50	2.80	20:54:46.971476	\N	\N	\N	\N
583	20	MAT	EWCHWX	2006-12-20	\N	t	LLORENÇ	\N	97	1	\N	\N	1	6	\N	165.65	142.80	22.85	20:54:46.971476	\N	\N	\N	\N
666	89	TOLO MAYOL	HTSMMW	2007-03-23	\N	f	\N	\N	40	1	\N	\N	1	6	\N	40.60	35.00	5.60	20:54:46.971476	\N	\N	\N	\N
696	117	VPN	WRERUC	2007-04-24	\N	t	\N	\N	103	4	\N	\N	1	6	\N	208.80	180.00	28.80	20:54:46.971476	\N	\N	\N	\N
579	16	MANT	HZIKYP	2006-12-20	\N	t	\N	\N	103	2	\N	\N	1	6	\N	668.16	576.00	92.16	20:54:46.971476	\N	\N	\N	\N
766	183	BulmaGés	NSTJHX	2007-05-09	\N	t	Juan Manuel Ginzo Santizo juanma@zugazabeitia.com	\N	135	1	\N	\N	1	2	\N	139.20	120.00	19.20	20:54:46.971476	\N	\N	\N	\N
767	184	TALLER	KQTYYO	2007-05-10	\N	t	Francisco Sanchez	630350857	40	1	\N	\N	1	6	\N	40.61	35.01	5.60	20:54:46.971476	\N	\N	\N	\N
607	42	MANT	TLUVJW	2007-02-16	Problemas con programa de facturacion	t	\N	\N	13	1	\N	\N	1	6	\N	99.08	85.41	13.67	20:54:46.971476	\N	\N	\N	\N
599	34	TONERS	XHXIXK	2007-02-07	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	573.34	494.26	79.08	20:54:46.971476	\N	\N	\N	\N
761	178	SWITCH	[SYCTD	2007-05-08	\N	t	\N	\N	103	4	\N	\N	1	6	\N	379.13	326.84	52.29	20:54:46.971476	\N	\N	\N	\N
586	23	REVISAR CORREO	BMAHIE	2006-11-03	\N	t	Tomeu Buades	\N	64	1	\N	\N	1	6	\N	47.56	41.00	6.56	20:54:46.971476	\N	\N	\N	\N
605	40	RECUPERAR DOCUMENTOS/VIRUS	KMSMQN	2007-01-17	\N	t	MINA	\N	64	1	\N	\N	1	6	\N	37.41	32.25	5.16	20:54:46.971476	\N	\N	\N	\N
606	41	OMAR	IDPVMK	2007-02-13	\N	t	OMAR	\N	64	1	\N	\N	1	6	\N	47.56	41.00	6.56	20:54:46.971476	\N	\N	\N	\N
608	43	ORDENADOR 2	BWRKUG	2007-02-23	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	526.20	453.62	72.58	20:54:46.971476	\N	\N	\N	\N
609	44	ORDENADOR 1	BHMMAZ	2007-02-16	\N	t	Joan Estrany	\N	10	1	\N	\N	1	6	\N	526.20	453.62	72.58	20:54:46.971476	\N	\N	\N	\N
720	139	WEB APA	BGTTPU	2007-05-03	\N	f	Marga Inaraja	\N	131	1	\N	\N	1	6	\N	580.00	500.00	80.00	20:54:46.971476	\N	\N	\N	\N
785	202	REVISAR EQUIPO-A.CAMBA	QXGFHF	2007-05-23	Revisar registro\nRevisar problemas con Outlook-Express\nRevisar posibles virus\nInstalar AVG-Profesional\n\n	f	ANTONIO CAMBA	971771543	40	1	\N	\N	1	6	[None]\n	92.10	79.40	12.70	20:54:46.971476	\N	\N	\N	\N
641	66	MAT	QXCIHW	2007-02-20	None\n	t	Isidoro	None	9	1	\N	\N	1	6	[None]\n	72.30	62.33	9.97	20:54:46.971476	\N	\N	\N	\N
721	140	HOST	INLXZA	2007-05-03	\N	t	\N	\N	132	1	\N	\N	1	1	\N	417.60	360.00	57.60	20:54:46.971476	\N	\N	\N	\N
786	203	TINTAS	IMNDGI	2007-05-23	\N	t	\N	\N	91	1	\N	\N	1	2	\N	39.23	33.82	5.41	20:54:46.971476	\N	\N	\N	\N
722	141	FESKATEVA	IBPKBI	2007-05-04	\N	f	Marga Inaraja	\N	40	1	\N	\N	1	6	\N	243.60	210.00	33.60	20:54:46.971476	\N	\N	\N	\N
723	142	INFOPOLLENSA.COM	DOCKNO	2007-05-04	\N	t	\N	\N	16	1	\N	\N	1	1	\N	34.80	30.00	4.80	20:54:46.971476	\N	\N	\N	\N
594	30	GIBPROMOCIONES.COM	YUEQDS	2007-02-15	\N	t	\N	\N	103	1	\N	\N	1	2	\N	34.80	30.00	4.80	20:54:46.971476	\N	\N	\N	\N
654	77	CABLE	SGPNZS	2007-03-20	\N	t	\N	\N	108	1	\N	\N	1	6	\N	20.68	17.83	2.85	20:54:46.971476	\N	\N	\N	\N
638	63	AVG Antivirus Professional Edition (3 licencias, 1 año)	UEEZVL	2007-03-15	\N	t	\N	\N	91	6	\N	\N	1	6	\N	123.42	106.40	17.02	20:54:46.971476	\N	\N	\N	\N
649	72	IMPRESORAS	QENLSH	2007-03-20	\N	t	Alberto Fidalgo	\N	59	1	\N	\N	1	6	\N	324.75	279.96	44.79	20:54:46.971476	\N	\N	\N	\N
648	71	IMPRESORAS	QENLSH1	2007-03-20	\N	t	Miguel Fidalgo	971 45 41 16	59	1	\N	\N	1	6	\N	581.11	500.96	80.15	20:54:46.971476	\N	\N	\N	\N
650	73	IMPRESORAS	VDRMHJ2	2007-03-20	\N	t	Alberto Fidalgo	\N	59	1	\N	\N	1	6	\N	324.75	279.96	44.79	20:54:46.971476	\N	\N	\N	\N
668	91	TINTA	OFZVZR	2007-03-26	\N	f	Sport Inca	\N	122	1	\N	\N	1	6	\N	59.40	51.21	8.19	20:54:46.971476	\N	\N	\N	\N
651	74	CUCHILLAS ETIQUETAS	KPNBCT	2007-03-20	\N	t	Joan	\N	10	6	\N	\N	1	6	\N	8.80	7.59	1.21	20:54:46.971476	\N	\N	\N	\N
616	51	TFT + SOFT 1	[MJXDT	2007-03-06	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	222.44	191.76	30.68	20:54:46.971476	\N	\N	\N	\N
621	53	TAMBOR	EUWLWN	2007-02-22	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	92.93	80.11	12.82	20:54:46.971476	\N	\N	\N	\N
667	90	GRABADORAS DVD	GBOFBF	2007-03-23	None\n\n	t	Joan Estrany	None	10	6	\N	\N	1	\N	Recuperar equipo Bel, desde imagen de disco.\nMontar grabadora - Joan\nRecuperar copias para Antonia\n\n\n	69.60	60.00	9.60	20:54:46.971476	\N	\N	\N	\N
653	76	SON COCO	XGOQWP	2007-03-20	\N	t	CATI MATEU	\N	10	1	\N	\N	1	6	\N	642.59	553.96	88.63	20:54:46.971476	\N	\N	\N	\N
673	94	RATON	OGMEGX	2007-03-28	\N	t	\N	\N	91	1	\N	\N	1	2	\N	7.32	6.31	1.01	20:54:46.971476	\N	\N	\N	\N
669	92	VISITA	BXIMM[	2007-03-27	None\n	f	pEPE sABATER	None	54	1	\N	\N	1	\N	[None]\n	40.60	35.00	5.60	20:54:46.971476	\N	\N	\N	\N
622	54	DOMINIO	BRMJZW	2007-02-21	\N	t	Juan Pedro Fullana	\N	88	6	\N	\N	1	1	\N	34.80	30.00	4.80	20:54:46.971476	\N	\N	\N	\N
724	143	LIMPIEZA EQUIPOS	UNIIYN	2007-04-10	\N	t	Mª José	\N	23	1	\N	\N	1	6	\N	63.14	54.43	8.71	20:54:46.971476	\N	\N	\N	\N
768	185	MANT BGES	KUHKXO	2007-05-08	\N	t	\N	\N	135	1	\N	\N	1	2	\N	139.20	120.00	19.20	20:54:46.971476	\N	\N	\N	\N
787	204	TONER	HGMRII	2007-05-24	\N	t	\N	\N	28	1	\N	\N	1	1	\N	101.24	87.28	13.96	20:54:46.971476	\N	\N	\N	\N
689	110	PORTATIL	RTLTJO	2007-04-23	\N	t	Pepe Sabater	\N	54	7	\N	\N	1	1	\N	974.40	840.00	134.40	20:54:46.971476	\N	\N	\N	\N
759	176	Material Dialma	JAFAGB	2007-05-08	\N	f	\N	\N	10	6	\N	\N	1	6	\N	9.71	8.37	1.34	20:54:46.971476	\N	\N	\N	\N
739	156	TONER	CEOTVX	2007-04-11	\N	f	Joan Estrany	\N	10	6	\N	\N	1	6	\N	76.32	65.79	10.53	20:54:46.971476	\N	\N	\N	\N
731	150	ACCESORIOS	LRMBBX	2007-05-09	\N	t	Mª José	\N	23	1	\N	\N	1	1	\N	110.20	95.00	15.20	20:54:46.971476	\N	\N	\N	\N
733	152	TINTA	WTYNHH	2007-04-23	\N	t	\N	\N	91	1	\N	\N	1	1	\N	39.95	34.44	5.52	20:54:46.971476	\N	\N	\N	\N
685	106	VISITA	EV[JIT	2007-04-02	None\n	f	Pepe Sabater	None	54	1	\N	\N	1	\N	[None]\n	128.76	111.00	17.76	20:54:46.971476	\N	\N	\N	\N
732	151	HOSTING	FBMTJF	2007-05-09	\N	t	Juan Antonio	\N	103	4	\N	\N	1	1	\N	417.60	360.00	57.60	20:54:46.971476	\N	\N	\N	\N
738	155	VISITA	PNNDII	2007-04-10	\N	f	\N	\N	59	1	\N	\N	1	6	\N	27.26	23.50	3.76	20:54:46.971476	\N	\N	\N	\N
688	109	TINTAS	IPBLYU	2007-04-20	\N	t	\N	\N	91	1	\N	\N	1	2	\N	79.90	68.88	11.04	20:54:46.971476	\N	\N	\N	\N
566	4	IMPRESORA	VBDXNN	2007-01-15	\N	t	\N	\N	23	1	\N	\N	1	2	\N	899.00	775.00	124.00	20:54:46.971476	\N	\N	\N	\N
568	6	BROTHER	GQGKTW	2007-01-15	\N	t	\N	\N	91	1	\N	\N	1	2	\N	414.97	357.73	57.23	20:54:46.971476	\N	\N	\N	\N
695	116	MAT	NUYUXO	2007-04-24	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	420.15	362.20	57.95	20:54:46.971476	\N	\N	\N	\N
750	167	MANT	BBEQLF	2007-04-20	\N	t	\N	\N	103	4	\N	\N	1	6	\N	130.00	112.07	17.93	20:54:46.971476	\N	\N	\N	\N
575	12	EQUIPO GRABACION CAMARAS	TZUAON	2007-01-02	\N	t	\N	\N	63	1	\N	\N	1	1	\N	839.89	724.04	115.85	20:54:46.971476	\N	\N	\N	\N
578	15	OPENVPN	GYC[VA	2006-12-12	\N	t	Isabel	\N	13	6	\N	\N	1	6	\N	179.80	155.00	24.80	20:54:46.971476	\N	\N	\N	\N
563	1	BROTHER	QTUHYJ	2007-01-10	\N	t	\N	\N	10	6	\N	\N	1	6	\N	\N	173.20	0.00	20:54:46.971476	\N	\N	\N	\N
574	11	TONER HL-2070N/REVISION EQUIPOS	BHZGVX	2007-01-29	\N	t	\N	\N	26	6	\N	\N	1	6	\N	70.17	60.49	9.68	20:54:46.971476	\N	\N	\N	\N
577	14	MAT	YIMGBA	2006-12-19	\N	t	Joan Estrany	\N	26	6	\N	\N	1	6	\N	230.77	198.94	31.84	20:54:46.971476	\N	\N	\N	\N
589	25	CABLES SEGURIDAD	MYVGGU	2007-01-31	\N	t	\N	\N	108	7	\N	\N	1	6	\N	3283.91	2830.96	452.95	20:54:46.971476	\N	\N	\N	\N
734	153	INSTALAR IMPRESORAS	ICTPNV	2007-04-24	\N	f	\N	\N	10	6	\N	\N	1	6	\N	4.95	4.27	0.68	20:54:46.971476	\N	\N	\N	\N
703	123	T.RED	PLRBUW	2007-02-15	None	f	None	None	40	1	\N	\N	1	\N	[None]	25.00	21.55	3.45	20:54:46.971476	\N	\N	\N	\N
569	7	MATERIAL	JQIQVX	2007-01-17	\N	f	Tomeu	\N	14	\N	\N	\N	1	2	\N	31.80	27.41	4.39	20:54:46.971476	\N	\N	\N	\N
693	114	REVISION COPIAS A CINTA	UHDPIS	2007-04-25	\N	f	Alberto Fidalgo	\N	59	1	\N	\N	1	6	\N	40.60	35.00	5.60	20:54:46.971476	\N	\N	\N	\N
587	24	MAT	QGGYJV	2006-05-15	\N	t	Miguel Soler	\N	95	1	\N	\N	1	6	\N	107.93	93.04	14.89	20:54:46.971476	\N	\N	\N	\N
570	8	MATERIAL	QTJHLI	2007-01-17	\N	t	Miguel Soler	\N	95	1	\N	\N	1	6	\N	51.59	44.47	7.12	20:54:46.971476	\N	\N	\N	\N
567	5	CONTAPLUS	TVUVLN	2007-01-15	\N	t	\N	\N	8	1	\N	\N	1	6	\N	525.48	453.00	72.48	20:54:46.971476	\N	\N	\N	\N
576	13	MONTAJE DE RED	WVQHWY	2006-10-24	\N	t	Carmen	\N	8	1	\N	\N	1	6	\N	232.00	200.00	32.00	20:54:46.971476	\N	\N	\N	\N
718	137	TINTAS	GWCFSO	2007-04-27	\N	t	Joan Estrany	\N	26	6	\N	\N	1	6	\N	506.85	436.94	69.91	20:54:46.971476	\N	\N	\N	\N
591	27	CABLES DE SEGURIDAD	VVSOHG	2007-02-08	\N	t	\N	\N	108	7	\N	\N	1	6	\N	80.39	69.30	11.09	20:54:46.971476	\N	\N	\N	\N
598	33	WEB	FJFSVG	2007-02-20	\N	f	\N	\N	106	1	\N	\N	1	8	\N	3178.40	2740.00	438.40	20:54:46.971476	\N	\N	\N	\N
777	194	CONF. OKI	IPCMVW	2007-05-16	No coge bien el tamano del papel	f	Alberto Fidalgo	\N	59	1	\N	\N	1	6	\N	40.60	35.00	5.60	20:54:46.971476	\N	\N	\N	\N
601	36	FUENTE ALIMENTACION	WKQREA	2007-01-31	\N	t	\N	\N	91	1	\N	\N	1	6	\N	37.53	32.35	5.18	20:54:46.971476	\N	\N	\N	\N
600	35	MAT	BFZBCB	2007-02-05	\N	t	\N	\N	91	1	\N	\N	1	6	\N	270.31	233.03	37.28	20:54:46.971476	\N	\N	\N	\N
602	37	IMPRESORA EPSON	NJFYJY	2007-02-22	\N	t	\N	\N	91	1	\N	\N	1	2	\N	69.88	60.24	9.64	20:54:46.971476	\N	\N	\N	\N
778	195	MANT/SA GERRERIA	VCDYLI	2007-05-17	None\n	t	JUAN ANTONIO	971771376	103	4	\N	\N	1	6	[None]\n	6.30	5.43	0.87	20:54:46.971476	\N	\N	\N	\N
758	175	MANT	OXNKCR	2007-05-09	\N	t	\N	\N	103	4	\N	\N	1	6	\N	3.20	2.76	0.44	20:54:46.971476	\N	\N	\N	\N
603	38	SOTF	AOGHMX	2007-02-08	\N	t	\N	\N	10	6	\N	\N	1	6	\N	144.79	124.82	19.97	20:54:46.971476	\N	\N	\N	\N
581	18	CLUB MAC	DF[TMW	2006-05-09	\N	t	\N	\N	16	1	\N	\N	1	1	\N	40.60	35.00	5.60	20:54:46.971476	\N	\N	\N	\N
590	26	lasgalletasdetusviajes	ELDBXH	2007-02-01	\N	t	Agata	\N	16	1	\N	\N	1	1	\N	46.40	40.00	6.40	20:54:46.971476	\N	\N	\N	\N
580	17	GECOALIMENT	VQLCKF	2006-03-08	\N	t	aGATA	\N	16	1	\N	\N	1	1	\N	81.20	70.00	11.20	20:54:46.971476	\N	\N	\N	\N
610	45	TFT + SOTF 2	WKNSLS	2007-02-23	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	382.35	329.61	52.74	20:54:46.971476	\N	\N	\N	\N
611	46	TFT + SOFT 1	[MJXDT	2007-02-23	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	457.20	394.14	63.06	20:54:46.971476	\N	\N	\N	\N
614	49	TINTAS	RFMSHL	2007-03-06	\N	t	\N	\N	91	1	\N	\N	1	2	\N	48.07	41.44	6.63	20:54:46.971476	\N	\N	\N	\N
615	50	ORDENADOR Y ESCANER DE ESCUELA DEL MAR	TUXCBT	2007-03-06	\N	f	Carlos Escuela del Mar	971.22.22.11	40	1	\N	\N	1	6	\N	46.40	40.00	6.40	20:54:46.971476	\N	\N	\N	\N
612	47	IMPRESORA	XSZHYS	2007-03-05	\N	t	Miguel Cañellas	\N	122	1	\N	\N	1	6	\N	190.19	163.96	26.23	20:54:46.971476	\N	\N	\N	\N
617	52	CABLES	NGIXEL	2007-03-06	\N	t	\N	\N	108	7	\N	\N	1	6	\N	241.16	207.90	33.26	20:54:46.971476	\N	\N	\N	\N
719	138	Puesto Lector de Tarjetas USB	DXSHGH	2007-05-02	\N	t	Conchi	\N	85	1	\N	\N	1	2	\N	14.53	12.53	2.00	20:54:46.971476	\N	\N	\N	\N
592	28	www.rosconstruccion.com	DNHVNN	2007-02-09	\N	f	Esteban (Boris) - Pedro Ros	971 85 81 13 - 607 71 46 49	119	1	\N	\N	1	2	\N	34.80	30.00	4.80	20:54:46.971476	\N	\N	\N	\N
564	2	Impresora Jaume	KPOJTD	2007-01-10	\N	t	\N	\N	10	6	\N	\N	1	6	\N	\N	87.00	13.92	20:54:46.971476	\N	\N	\N	\N
565	3	BRTOHER CATI	XXMWRQ	2007-01-10	\N	t	\N	\N	10	6	\N	\N	1	6	\N	\N	263.80	42.21	20:54:46.971476	\N	\N	\N	\N
604	39	INSTALAR IMPRESORA	DQLKIY	2007-01-01	\N	t	JOAN	\N	10	\N	\N	\N	1	6	\N	202.03	174.16	27.86	20:54:46.971476	\N	\N	\N	\N
625	57	CABLE	IVXVYD	2007-03-13	\N	t	\N	\N	108	7	\N	\N	1	6	\N	33.98	29.29	4.69	20:54:46.971476	\N	\N	\N	\N
623	55	JAUME ESTRANY	JGKYCJ	2007-03-13	\N	t	Joan Estrany	\N	10	6	\N	\N	1	6	\N	222.27	191.61	30.66	20:54:46.971476	\N	\N	\N	\N
624	56	MAT CATI	JRHZGM	2007-03-13	\N	t	\N	\N	10	\N	\N	\N	1	6	\N	57.64	49.69	7.95	20:54:46.971476	\N	\N	\N	\N
637	62	TFT SONY	DGPEBM	2007-03-15	\N	t	Tolo	\N	103	4	\N	\N	1	6	\N	363.50	313.36	50.14	20:54:46.971476	\N	\N	\N	\N
595	31	MANT MAT	IWQZDH	2007-02-19	\N	t	\N	\N	103	1	\N	\N	1	6	\N	220.45	190.04	30.40	20:54:46.971476	\N	\N	\N	\N
596	32	TFT	DZTCRV	2007-02-19	\N	t	\N	\N	103	1	\N	\N	1	6	\N	283.97	244.80	39.17	20:54:46.971476	\N	\N	\N	\N
660	83	GATEWAY	IPUTDF	2007-03-20	None\n	t	Esteban	None	57	1	\N	\N	1	6	[None]\n	97.46	84.02	13.44	20:54:46.971476	\N	\N	\N	\N
675	96	ORDENADOR	IXBPGP	2007-03-29	\N	t	\N	\N	10	6	\N	\N	1	6	\N	562.60	485.00	77.60	20:54:46.971476	\N	\N	\N	\N
674	95	TN2000	SDNJBT	2007-03-29	\N	t	\N	\N	10	1	\N	\N	1	6	\N	210.51	181.47	29.04	20:54:46.971476	\N	\N	\N	\N
665	88	DOMINIOS	NAPARM	2007-03-23	\N	t	Esteban	\N	57	6	\N	\N	1	1	\N	81.20	70.00	11.20	20:54:46.971476	\N	\N	\N	\N
678	99	AVG	RXACNC	2007-04-02	\N	f	Miguel Soler	\N	103	2	\N	\N	1	6	\N	77.60	66.90	10.70	20:54:46.971476	\N	\N	\N	\N
679	100	TPV	QYIBYU	2007-04-02	\N	t	\N	\N	93	1	\N	\N	1	2	\N	527.45	454.70	72.75	20:54:46.971476	\N	\N	\N	\N
681	102	CABLES	IVSGDN	2007-04-02	\N	t	Antonio Tudurí	\N	124	1	\N	\N	1	6	\N	274.11	236.30	37.81	20:54:46.971476	\N	\N	\N	\N
788	205	TINTAS	YEFLON	2007-05-25	\N	t	\N	\N	126	1	\N	\N	1	1	\N	34.23	29.51	4.73	20:54:46.971476	\N	\N	\N	\N
756	173	MANT	CIWUGP	2007-05-02	\N	t	\N	\N	26	6	\N	\N	1	6	\N	326.06	281.09	44.98	20:54:46.971476	\N	\N	\N	\N
593	29	g-ribasazcona	NLUSQF	2007-02-09	\N	f	\N	\N	116	1	\N	\N	1	1	\N	34.80	30.00	4.80	20:54:46.971476	\N	\N	\N	\N
690	111	HOST	HSTCBW	2007-04-23	\N	f	\N	\N	116	1	\N	\N	1	1	\N	78.88	68.00	10.88	20:54:46.971476	\N	\N	\N	\N
784	201	MANTEMINIENTO - ENTREGA TONER	JZEJVN	2007-05-22	None\n	t	JOAN	None	26	6	\N	\N	1	6	[None]\n	165.36	142.55	22.81	20:54:46.971476	\N	\N	\N	\N
760	177	TOLO MAYOL	IISDSD	2007-05-07	\N	f	\N	\N	40	1	\N	\N	1	6	\N	6.98	6.02	0.96	20:54:46.971476	\N	\N	\N	\N
796	212	asdfasdfasdf	EMLYHM	2007-08-20	\N	f	\N	\N	96	\N	\N	\N	1	6	\N	232.00	200.00	32.00	20:54:46.971476	\N	\N	\N	\N
573	10	CONECTAR EQUIPO057CONFIGURAR IMPRESORAS	ZTBFVE	2007-01-10	\N	t	\N	\N	8	6	\N	\N	1	6	\N	1.85	1.81	0.04	20:54:46.971476	\N	\N	\N	\N
572	9	TINTAS	YZOBMY	2007-01-25	\N	t	\N	\N	91	1	\N	\N	1	2	\N	34.92	32.53	2.40	20:54:46.971476	\N	\N	\N	\N
824	236	asdf	HCMETO	2007-12-04	\N	f	\N	\N	16	2	\N	\N	1	7	\N	232.00	200.00	32.00	14:52:34.366763	\N	\N	\N	\N
825	237	Ticket de venta	BJXHJY	2007-12-04	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	2506.17	2160.49	345.68	14:54:39.129884	\N	t	\N	5
826	238	Ticket de venta	THWNXU	2007-12-04	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	3310.07	2853.51	456.56	17:21:28.341413	\N	t	\N	6
827	239	Ticket de venta	OLWFCW	2007-12-04	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	3030.98	2612.91	418.07	17:21:32.748843	\N	t	\N	6
828	240	Ticket de venta	TDWBFG	2007-12-04	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	1828.80	1576.55	252.25	17:21:57.554476	\N	t	\N	6
829	241	Ticket de venta	XWXIWL	2007-12-04	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	2509.49	2163.35	346.14	17:51:18.398974	\N	t	\N	6
830	242	Ticket de venta	FLIAFB	2007-12-04	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	1541.44	1328.83	212.62	19:21:39.661242	\N	t	\N	7
831	243	Ticket de venta	WFQLAX	2007-12-05	\N	f	\N	\N	12	\N	\N	\N	1	8	\N	5634.07	4856.96	777.12	09:46:46.752448	\N	t	\N	7
832	244	Ticket de venta	OEDFBP	2007-12-10	\N	f	\N	\N	12	\N	\N	\N	1	8	\N	3605.67	3108.34	497.33	19:41:30.073182	\N	t	\N	7
833	245	Ticket de venta	XEYQBH	2007-12-12	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	883.66	761.78	121.89	16:13:13.064132	\N	t	\N	7
834	246	Ticket de venta	LELTFJ	2007-12-12	\N	f	\N	\N	12	\N	\N	\N	1	2	\N	1520.70	1310.95	209.76	16:13:17.04181	\N	t	\N	7
783	200	MATERIAL ETIQUETAS	[FCGSO	2007-05-21	Entregadas\n	t	None	None	26	6	\N	\N	1	6	[None]\n	1109.22	956.22	153.00	20:54:46.971476	\N	\N	\N	\N
\.


--
-- Data for Name: albaranp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY albaranp (idalbaranp, numalbaranp, descalbaranp, refalbaranp, fechaalbaranp, comentalbaranp, procesadoalbaranp, idproveedor, idforma_pago, idalmacen, idtrabajador, totalalbaranp, bimpalbaranp, impalbaranp) FROM stdin;
34	109796	FEDERACION DE TIRO	TKSLPF	2007-01-15	\N	f	7	1	1	\N	317.45	273.66	43.78
35	110112	TIENDA	POVHXI	2007-01-17	\N	f	5	6	1	\N	42.74	36.86	5.88
32	108916	TIENDA	VSHKXW	2007-01-11	\N	f	5	6	1	\N	\N	32.33	5.18
33	109795	INMOVILIZADO	UVHYFI	2007-01-11	\N	f	5	6	1	\N	\N	24.31	3.88
37	110114	TARJETAS CONETXIA	OZDCTQ	2007-01-22	\N	f	33	1	1	\N	\N	215.55	34.49
40	110117	TINTA DIALMA	XFHYRL	2007-02-07	\N	f	7	6	1	\N	412.88	355.93	56.97
41	110118	DIALMA	FBWSQS	2007-01-25	\N	f	7	6	1	\N	50.53	43.56	6.97
42	110119	TAMBOR OKI	TKGFJV	2007-02-27	\N	f	7	6	1	\N	66.91	57.68	9.23
43	110120	MAT	ZHMULP	2007-02-22	\N	f	5	6	1	\N	413.18	356.34	56.85
44	110121	DIALMA	DMJYLP	2007-03-09	\N	f	5	6	1	\N	1488.64	1283.84	204.80
46	110123	AZUL YATCHS	UVRHKP	2007-02-15	\N	f	7	\N	1	\N	79.26	68.33	10.93
47	110124	FED. BALEAR. TIRO	TBSQGT	2007-02-06	\N	f	5	6	1	\N	464.46	400.56	63.90
48	110125	MAT	XZINVQ	2007-02-07	\N	f	5	\N	1	\N	575.91	496.68	79.23
49	110126	MAT	MYCVWN	2007-01-31	\N	f	5	6	1	\N	2558.88	2206.84	352.04
50	110127	GIB	LGTMEC	2007-02-06	\N	f	5	6	1	\N	3.54	3.05	0.49
51	110128	GIB	GYXXFH	2007-02-02	\N	f	5	6	1	\N	198.34	171.05	27.28
52	110129	TIENDA	MYIEOO	2007-02-15	\N	f	5	\N	1	\N	20.80	17.94	2.86
53	110130	MAT	XLNFYI	2007-01-23	\N	f	5	6	1	\N	191.95	165.54	26.41
54	110131	ADMAS BALEARES	VLGXGD	2007-03-07	\N	f	8	6	1	\N	49.08	42.31	6.77
30	1	BROTHER DIALMA	BTURJT	2007-01-08	\N	f	7	1	1	\N	\N	173.20	0.00
31	2	BROTHER DIALMA	WSNBXT	2007-01-10	\N	f	7	6	1	\N	\N	351.40	56.23
55	110132	TIENDA	KRICCN	2007-01-22	\N	f	5	6	1	\N	80.92	69.79	11.14
56	110133	MIGUEL SOLER	ISOPVD	2007-02-16	\N	f	5	6	1	\N	407.05	351.05	56.00
57	110134	SPORT INCA	QSCZIJ	2007-03-05	\N	f	7	6	1	\N	154.74	133.40	21.34
58	110135	MAT	PUFJNS	2007-03-13	\N	f	5	6	1	\N	36.21	31.23	4.98
59	110136	TFT GIB	XRQMGX	2007-03-15	\N	f	5	6	1	\N	214.30	184.82	29.48
60	110137	Compras Varias	[WCFQE	2007-05-02	\N	f	5	4	1	\N	220.98	190.50	30.47
61	110138	DIALMA	TXBSBZ	2007-05-22	\N	f	7	6	1	\N	132.27	114.03	18.24
62	110139	DIALMA	BYFKIO	2007-04-27	\N	f	7	6	1	\N	363.08	313.00	50.08
63	110140	DIALMA	YX[YNK	2007-04-30	\N	f	7	6	1	\N	187.12	161.31	25.81
65	110142	DIALMA	UXVMXB	2007-05-25	\N	f	7	6	1	\N	616.17	531.18	84.99
69	110146	DIALMA	YXQVED	2007-05-02	\N	f	7	6	1	\N	66.91	57.68	9.23
71	71986	CONETXIA	JEOHZW	2007-05-15	\N	f	21	6	1	\N	92.94	80.12	12.82
68	110145	DIALMA	ORDNOQ	2007-04-21	\N	f	7	6	1	\N	296.31	272.55	23.77
67	110144	DIALMA	VJXZTF	2007-04-10	\N	f	7	6	1	\N	164.52	139.75	24.78
70	110147	DIALMA	OYAIKY	2007-05-02	\N	f	7	6	1	\N	70.95	57.68	13.27
66	110143	EUGENIO	UQYVIZ	2007-05-23	\N	f	7	6	1	\N	65.98	62.84	3.14
72	110148	asdf	MOOMSN	2007-08-13	\N	f	5	\N	1	\N	4210.80	3630.00	580.80
36	110113	ACOMAN PYLSA	YTGOLI	2007-01-17	\N	f	11	1	1	\N	1180.47	1017.65	162.82
\.


--
-- Data for Name: almacen; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY almacen (idalmacen, codigoalmacen, nomalmacen, diralmacen, poblalmacen, cpalmacen, telalmacen, faxalmacen, emailalmacen, inactivoalmacen, aperturaalmacen, cierrealmacen, apertura1almacen, cierre1almacen, extasteriskalmacen, tipoalmacen, idcuentaalmacen) FROM stdin;
2	200	Tijuana	Joaquin Turina, 1 local 4	Palma de Mallorca	07004	971 29 06 29		info@iglues.org	\N	\N	\N	\N	\N	104	Almacen	10939
4	400	India	Joaquin Turina, 1 local 4	Palma de Mallorca	07004	971 29 06 29		info@iglues.org	\N	\N	\N	\N	\N	1112	Tienda	10940
5	500	Magalli	Joaquin Turina, 1 local 4	Palma de Mallorca	07004	971 29 06 29		info@iglues.org	\N	\N	\N	\N	\N	1113	Almacen	10941
6	600	Mogambi	Joaquin Turina, 1 local 4	Palma de Mallorca	07004	971 29 06 29		info@iglues.org	\N	\N	\N	\N	\N	101	Tienda	10942
1	100	Conetxia	Joaquin Turina, 1 local 4	Palma de Mallorca	07004	971 29 06 29		info@iglues.org	\N	\N	\N	\N	\N	102	Tienda	10943
\.


--
-- Data for Name: almacentipotrabajo; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY almacentipotrabajo (idtipotrabajo, idalmacen, numpers) FROM stdin;
2	2	2
2	4	2
4	4	12
1	4	5
2	5	5
3	5	9
\.


--
-- Data for Name: articulo; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY articulo (idarticulo, codarticulo, nomarticulo, abrevarticulo, obserarticulo, presentablearticulo, controlstockarticulo, idtipo_articulo, idtipo_iva, codigocompletoarticulo, idfamilia, stockarticulo, inactivoarticulo, pvparticulo, pesoundarticulo, volumenundarticulo, ivaincarticulo) FROM stdin;
4562	01	Cinta de Papel 12x30,48 DK22214			f	f	\N	2	080701	133	\N	\N	10.22	0.00	0.00	f
4563	02	Cinta de Papel 62x30,48 DK22205			f	f	\N	2	080702	133	\N	\N	18.92	0.00	0.00	f
4239	02	PROGRAMACION VARIOS			f	f	\N	2	020702	208	\N	\N	35.00	0.00	0.00	f
2903	1293	ROSETA RJ45 CAT. 5E UTP 1 TOMA FS3110			f	t	\N	2	07051293	188	\N	t	2.94	0.00	0.00	f
4180	02	DESPLAZAMIENTO PALMA			f	f	\N	2	020202	56	\N	\N	6.00	0.00	0.00	f
4179	01	INSTALACION / HORA			t	f	\N	2	020201	56	\N	\N	35.00	0.00	0.00	f
4207	02	MANTENIMIENTO HARDWARE ECOLOGING			f	f	\N	2	020502	206	\N	\N	50.00	0.00	0.00	f
4193	01	PROGRAMACION WEB			f	f	\N	2	020701	208	\N	\N	35.00	0.00	0.00	f
4184	03	HORAS CONTRATO			t	t	\N	2	020203	56	\N	\N	0.00	0.00	0.00	f
4185	04	DESPLAZAMIENTO CONTRATO			f	f	\N	2	020204	56	\N	\N	0.00	0.00	0.00	f
4241	01	REPARACIONES			f	f	\N	2	020101	23	\N	\N	20.00	0.00	0.00	f
3439	4480	CART. HP COLOR Nº22 PSC1410 DJ3940 5ML			f	t	\N	2	08074480	133	\N	t	12.45	0.00	0.00	f
3159	3354	CONECTOR MACHO RJ45 UTP (BOLSA DE 10 U.) TD10			f	t	\N	2	07053354	188	\N	t	1.49	0.00	0.00	f
3438	4479	CART. HP NEGRO Nº21 PSC1410 NEGRO 5ML C9351AE			f	t	\N	2	08074479	133	\N	t	11.31	0.00	0.00	f
4542	01	Reparaciones a Particulares			f	f	\N	2	010101	25	\N	\N	20.00	0.00	0.00	f
4634	4977	FA. 120W FSP UNIV. PORTATIL NB120			f	t	\N	2	02044977	58	\N	t	41.89	0.00	0.00	f
3580	4977	FUENTE ALIMENTACION FSP UNIV. PORTATIL 120W N			f	t	\N	2	02994977	204	\N	t	43.28	0.00	0.00	f
3780	5541	PORTATIL ACER TM4652LMi PM740 512 DDR2 60GB 1			f	t	\N	2	02995541	204	\N	t	834.11	0.00	0.00	f
3783	5545	SOPORTE PARA PORTATIL KENSINGTON EASY RISER			f	t	\N	2	02995545	204	\N	t	15.07	0.00	0.00	f
3396	4276	PEN DRIVE 512 MB GENERICO USB 2.0			f	t	\N	2	04274276	195	\N	t	12.06	0.00	0.00	f
4098	6122	RATON NGS BLADE MOUSE LASER CABLE RETRACTIL U			f	t	\N	2	04086122	72	\N	t	16.53	0.00	0.00	f
3218	3637	BLISTER 1UD PILA CEGASA 8F05 SUPER ALKALINE			f	t	\N	2	09023637	107	\N	t	0.96	0.00	0.00	f
4627	4791	TELEFONO VOIP RIMAX IP PHONE USB			f	t	\N	2	13074791	203	\N	t	19.10	0.00	0.00	f
3217	3636	BLISTER 4UDS PILAS CEGASA LR6 EVOLUTION			f	t	\N	2	09023636	107	\N	t	3.13	0.00	0.00	f
3520	4738	KVM ENRACABLE ATEN ACS-1216A 16 PUERTOS			f	t	\N	2	09024738	107	\N	t	745.48	0.00	0.00	f
4089	6113	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD			f	t	\N	2	01076113	215	\N	t	567.05	0.00	0.00	f
4093	6117	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0			f	t	\N	2	01076117	215	\N	t	690.16	0.00	0.00	f
4919	6754	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG			f	t	\N	2	02046754	58	\N	t	26.87	0.00	0.00	f
4910	6743	SOPORTE PARA PORTATIL 17" NOTEPAL 2 VENT. NEG			f	t	\N	2	02046743	58	\N	t	44.75	0.00	0.00	f
4103	6128	ORD. INTEL CORE 2 DUO E6300 FOLLETO NAVIDAD 0			f	t	\N	2	01076128	215	\N	t	834.52	0.00	0.00	f
4203	01	CONTRATACION / RENOVACION DE DOMINIOS			t	t	\N	2	020601	207	\N	\N	30.00	0.00	0.00	f
4189	01	SIN DEFINIR (COMODIN)			f	f	\N	2	020401	58	\N	\N	0.00	0.00	0.00	f
4566	01	DCP130C IMP. BROTHER COLOR MULTIFUNCION			t	t	\N	2	041901	142	\N	\N	72.00	0.00	0.00	f
3134	3248	CAJA MICRO ATX 3GTLM-397			f	t	\N	2	03023248	31	\N	t	54.22	0.00	0.00	f
3981	5952	VENTILADOR AMD TR2 K8 754 939 AM2 R1 SILENCIO			f	t	\N	2	03135952	51	\N	t	7.04	0.00	0.00	f
4301	4466	PB ASROCK 939S56-M SiS 756 PCI-E SON SATA-R L			f	t	\N	2	03324466	196	\N	t	67.04	0.00	0.00	f
4665	5855	IMPRESORA HP PHOTOSMART C4180 MULTIFUNCION LC			f	t	\N	2	04265855	200	\N	t	122.49	0.00	0.00	f
3935	5892	SWITCH NETGEAR GS608FS 8 PUERTOS 10/100/1000			f	t	\N	2	07025892	95	\N	t	63.05	0.00	0.00	f
3936	5893	SWITCH NETGEAR JGS516GE 16 PUERTOS 10/100/100			f	t	\N	2	07025893	95	\N	t	183.54	0.00	0.00	f
4069	6084	FA. 480W TACENS VALEO SMART 13.5CM PLATA 0dB			f	t	\N	2	03106084	48	\N	t	73.69	0.00	0.00	f
4828	6609	PB ASUS P5W DH DEL 975X 2XPCIE DDR2 8CH 2XGLA			f	t	\N	2	03116609	86	\N	t	166.93	0.00	0.00	f
3762	5477	ALTAVOCES RIMAX MUSIC LED 2.0 LED AZUL			f	t	\N	2	04065477	70	\N	t	18.36	0.00	0.00	f
2837	0470	DISQUETERA ALPS 3.5" 1,44 Mb			f	t	\N	2	03150470	53	\N	t	5.33	0.00	0.00	f
4251	2119	SERV. IMPRESORA D-LINK 1 PUERTO DP-301P+			f	t	\N	2	07022119	95	\N	t	67.86	0.00	0.00	f
3114	3160	LATIGUILLO UTP CAT.5E DE 3 MTS CRUZADO NEGRO			f	t	\N	2	07053160	188	\N	t	1.36	0.00	0.00	f
4610	4177	TAMBOR OKI C5100 5300 SERIES MAGENTA			f	t	\N	2	08094177	136	\N	t	106.95	0.00	0.00	f
4188	04	CANON LPI BROTHER			f	f	\N	2	042904	217	\N	\N	15.00	0.00	0.00	f
4344	5555	ACCESS POINT D-LINK DWL-G700AP WIRELESS 54Mbp			f	t	\N	2	07015555	94	\N	t	42.05	0.00	0.00	f
3276	3908	CART. JT EPSON C70 C80 CYAN E84C			f	t	\N	2	08063908	132	\N	t	7.14	0.00	0.00	f
3905	5846	AURICULAR CON MICROFONO NGS VOX 230DJ MULTIME			f	t	\N	2	09075846	189	\N	t	11.05	0.00	0.00	f
4960	6838	CAJA EXT. CONCEPTRONIC 2.5" SATA USB 2.0 CHD2			f	t	\N	2	04236838	148	\N	t	18.28	0.00	0.00	f
3603	5036	CART. JT CANON S200 S300 NEGRO C14			f	t	\N	2	08065036	132	\N	t	2.92	0.00	0.00	f
4703	6407	NEON CAJA KIT 2 X 30 cm AZUL CCKP2-30B INVERS			f	t	\N	2	09046407	109	\N	t	6.75	0.00	0.00	f
5345	7391	TECLADO LOGITECH VALUE KEYBOARD PS/2 OEM NEGR			f	t	\N	2	04077391	71	\N	t	6.95	0.00	0.00	f
3761	5476	CABLE P.PARALELO DB25 M/H (EXTENSION)1.8Mt. A			f	t	\N	2	09015476	106	\N	t	3.37	0.00	0.00	f
4021	6013	DISCO ZIP 750 MB PACK DE 3 UNIDADES			f	t	\N	2	08046013	102	\N	t	41.80	0.00	0.00	f
4022	6014	CAJA EXT. CONCEPTRONIC 2.5" IDE USB 2.0 CHD2U			f	t	\N	2	04236014	148	\N	t	11.98	0.00	0.00	f
4348	5636	FAX SAMSUNG SF-360 COPIADORA Y TELEFONO TINTA			f	t	\N	2	04165636	115	\N	t	78.46	0.00	0.00	f
4651	5638	KIT DSL-924 ROUTER ADSL D-LINK WIFI+ADAP USB 			f	t	\N	2	07075638	220	\N	t	78.19	0.00	0.00	f
3815	5640	MICROFONO SOBREMESA NGS STARMIX Z1 CON AURICU			f	t	\N	2	09075640	189	\N	t	7.71	0.00	0.00	f
4125	6152	SOFT. PINNACLE STUDIO TITANIUM PACK 20 ANIVER			f	t	\N	2	06036152	91	\N	t	73.70	0.00	0.00	f
3914	5862	SOFT. ANTIVIRUS PANDA 2007 + ANTISPYWARE			f	t	\N	2	06035862	91	\N	t	25.62	0.00	0.00	f
3823	5648	LEADER KIT MALETIN ORGANICER + MS105 + BULLSE			f	t	\N	2	09105648	190	\N	t	40.71	0.00	0.00	f
3307	3987	CINTA HP ULTRIUM 200 GB C7971A			f	t	\N	2	08033987	101	\N	t	33.83	0.00	0.00	f
3230	3692	ADAPTADOR USB 2.0 DOCK STATION PS2 RJ45 HUB S			f	t	\N	2	04133692	80	\N	t	58.52	0.00	0.00	f
4502	6366	GATEWAY KONIG ( SWITCH 4P + FIREWALL)			f	t	\N	2	04046366	68	\N	t	39.23	0.00	0.00	f
3242	3771	GARANTIA PIXEL TFT 17"			f	t	\N	2	04023771	66	\N	t	30.12	0.00	0.00	f
4531	03	OKI TAMBOR EP-CART C32-BLACK			f	f	\N	2	081003	137	\N	\N	85.41	0.00	0.00	f
4020	6012	CRT 17" HYUNDAI Q770S 1280x1024 DYNAFLAT 2 TO			f	t	\N	2	04016012	65	\N	t	112.25	0.00	0.00	f
2994	2387	TECLADO NUMERICO NGS USB PARA NOTEBOOK PLUS K			f	t	\N	2	04072387	71	\N	t	15.51	0.00	0.00	f
4334	5336	TFT 17"  ACER AL1717AS 8MS PLATA MULTIMEDIA			f	t	\N	2	04025336	66	\N	t	182.06	0.00	0.00	f
5301	7347	HD PORTATIL 120 GB SATA TOSHIBA 5400RPM 8MB			f	t	\N	2	03277347	194	\N	t	70.96	0.00	0.00	f
4383	6221	IMPRESORA CANON PIXMA IP 5300			f	t	\N	2	04036221	67	\N	t	159.45	0.00	0.00	f
4465	6320	IMPRESORA CANON PIXMA IP 6700D LCD LECT TARJE			f	t	\N	2	04036320	67	\N	t	185.80	0.00	0.00	f
3940	5897	ROUTER ADSL NETGEAR DG834FS + 4 PUERTOS LAN 1			f	t	\N	2	04045897	68	\N	t	62.12	0.00	0.00	f
3941	5898	ROUTER ADSL2+ NETGEAR WIRELESS DG834GFS 4P 54			f	t	\N	2	04045898	68	\N	t	73.94	0.00	0.00	f
3943	5900	ROUTER ADSL NETGEAR WIRELESS DG834GTFS + SWIT			f	t	\N	2	04045900	68	\N	t	88.73	0.00	0.00	f
3955	5912	GATEWAY NETGEAR WNR854T WIRELESS 300MBPS + 4P			f	t	\N	2	04045912	68	\N	t	158.99	0.00	0.00	f
3990	5969	GATEWAY NETGEAR WGR614FS WIRELESS 54MBPS + 4x			f	t	\N	2	04045969	68	\N	t	45.11	0.00	0.00	f
3195	3498	CABLE D-LINK PROLONGACION ANTENA N-N WIRELESS			f	t	\N	2	07013498	94	\N	t	40.16	0.00	0.00	f
3828	5657	ANTENA D-LINK ANT24-1201 12dBi EXTERIOR DIREC			f	t	\N	2	07015657	94	\N	t	72.01	0.00	0.00	f
3137	3255	CART. JT HP NEGRO Nº45 DJ700 800 900 709JCSP 			f	t	\N	2	08063255	132	\N	t	11.69	0.00	0.00	f
3610	5043	CART. JT RECL LEXMARK Z13 Z2X Z3X NEGRO ML16			f	t	\N	2	08065043	132	\N	t	23.37	0.00	0.00	f
3445	4509	LECTOR C.B. METROLOGIC MS-9535BT VOYAGER BLUE			f	t	\N	2	05034509	120	\N	t	323.61	0.00	0.00	f
2818	0314	CAJON PORTAMONEDAS TPV 41 CM. AUTOMATICO			f	t	\N	2	05030314	120	\N	t	45.53	0.00	0.00	f
3103	3130	IMPRESORA TICKETS EPSON TM-T88 TERMICA SERIE			f	t	\N	2	05033130	120	\N	t	321.28	0.00	0.00	f
3281	3922	IMPRESORA TICKETS EPSON TMT88 TERM. PARALELO 			f	t	\N	2	05033922	120	\N	t	326.24	0.00	0.00	f
4411	6253	TECLADO REDUCIDO TPV ACK-700 USB			f	t	\N	2	05036253	120	\N	t	31.58	0.00	0.00	f
4438	6292	IMPRESORA TICKETS EPSON TMU-220PB CORTE AUT.			f	t	\N	2	05036292	120	\N	t	288.33	0.00	0.00	f
3085	3024	CAJA EXT. KEPLER 5.25" IDE USB 2.0 CD-ROM KE1			f	t	\N	2	04233024	148	\N	t	39.54	0.00	0.00	f
3253	3824	CAJA EXT. CONCEPTRONIC 3.5 IDE FIREWIRE USB 2			f	t	\N	2	04233824	148	\N	t	34.52	0.00	0.00	f
4133	6161	CAPTURADORA TV EXT. AVERMEDIA VOLAR TDT FM US			f	t	\N	2	04206161	143	\N	t	88.33	0.00	0.00	f
4015	6005	SINTONIZADORA TV EXT. AVERMEDIA DVB-T STB7			f	t	\N	2	04206005	143	\N	t	103.08	0.00	0.00	f
3671	5263	PROYECTOR EPSON TW-20 + VIDEOSENDER + PANTALL			f	t	\N	2	04215263	146	\N	t	838.78	0.00	0.00	f
4146	6174	PROYECTOR SONY VPL-EX3 2000 LUM MM 1024X768			f	t	\N	2	04216174	146	\N	t	879.93	0.00	0.00	f
3628	5105	PB EPOX 9NPA ULTRA S939 PCIE SATA2 SON 1G-LAN			f	t	\N	2	03325105	196	\N	t	99.65	0.00	0.00	f
4114	6139	RW DVD DUAL DL LITEON 18X8X18X LH-18A1H LS NE			f	t	\N	2	03226139	128	\N	t	35.05	0.00	0.00	f
4026	6023	RW DVD DUAL DL LG 18X8X18X GSA-H22N/ H12 NEGR			f	t	\N	2	03226023	128	\N	t	30.53	0.00	0.00	f
4053	6063	RW DVD DUAL DL AOPEN 16X8X16X DW1670 NEGRA BU			f	t	\N	2	03226063	128	\N	t	29.37	0.00	0.00	f
4056	6069	RW DVD DUAL DL LG 18X8X16X GSA-H22N / H12 OEM			f	t	\N	2	03226069	128	\N	t	30.93	0.00	0.00	f
4437	6291	RW DVD DUAL DL LG 18X8X16X GSA-H42N NEGRA OEM			f	t	\N	2	03226291	128	\N	t	29.71	0.00	0.00	f
4475	6333	RW DVD DUAL DL LITEON HP18X8X18X LIGHTSCRIBE 			f	t	\N	2	03226333	128	\N	t	47.10	0.00	0.00	f
4510	6374	CONTROLADORA SCSI ADAPTEC ASC29320ALP-R RAID 			f	t	\N	2	03236374	129	\N	t	336.25	0.00	0.00	f
4321	5070	CONTROLADORA SATA RAID 0-1 ID 2000			f	t	\N	2	03235070	129	\N	t	28.75	0.00	0.00	f
2816	0147	CONTROLADORA UW-SCSI 29160 ADAPTEC OEM 160 MB			f	t	\N	2	03230147	129	\N	t	213.58	0.00	0.00	f
3987	5964	MINIPC ASUS PUNDIT P1-AH1 S939 DDR SATA SON 1			f	t	\N	2	03025964	31	\N	t	158.82	0.00	0.00	f
3009	2513	CAJA SEMITORRE ATX G313 AZUL USB+AUDIO 8802			f	t	\N	2	03022513	31	\N	t	46.99	0.00	0.00	f
3305	3967	CAJA SERVIDOR INTEL SC5275 PILOT POINT 2 NEGR			f	t	\N	2	03033967	32	\N	t	368.53	0.00	0.00	f
4468	6323	BACKPLANE 6 HOT SWAP SC5400/5299-E DISCOS SAS			f	t	\N	2	03036323	32	\N	t	219.70	0.00	0.00	f
4483	6341	CAJA SERVIDOR ENLIGHT EN-7280			f	t	\N	2	03036341	32	\N	t	66.81	0.00	0.00	f
3876	5785	VENTILADOR THERMALTAKE MINI TYPHOON 90 INTEL 			f	t	\N	2	03135785	51	\N	t	39.04	0.00	0.00	f
4161	6191	MEMORIA DIMM DDR2 512MB 533Mhz KINGSTON ECC R			f	t	\N	2	03146191	52	\N	t	100.40	0.00	0.00	f
4470	6326	MEMORIA FBDIMM DDR2 2G 667MHz KINGSTON ECC			f	t	\N	2	03146326	52	\N	t	432.81	0.00	0.00	f
3564	4890	PB INTEL S775 BLKD945GNTLR DDR2 VGA SON LAN R			f	t	\N	2	03114890	86	\N	t	114.49	0.00	0.00	f
4104	6129	AURICULAR CON MICRO LOGITECH HEADSET 250 USB			f	t	\N	2	09076129	189	\N	t	34.72	0.00	0.00	f
3560	4870	PB INTEL D945PVS S775 PCIE DDR2 SATA2 GLAN RE			f	t	\N	2	03114870	86	\N	t	158.78	0.00	0.00	f
3211	3609	PB ASROCK 775i65GV VGA SATA SON LAN			f	t	\N	2	03113609	86	\N	t	49.10	0.00	0.00	f
3975	5944	PB INTEL S775 D102GGC2L ATI VGA SON DDR2 SATA			f	t	\N	2	03115944	86	\N	t	73.86	0.00	0.00	f
4051	6060	PB ASROCK 775XFIRE-VSTA 2XPCIE LAN SATA2 RAID			f	t	\N	2	03116060	86	\N	t	60.23	0.00	0.00	f
4363	5931	ADAPTADOR DE RED RIMAX RED ELECT. A RJ45 85Mb			f	t	\N	2	07025931	95	\N	t	48.49	0.00	0.00	f
3759	5472	CPU INTEL PIV D 940 LGA775 FSB800 2x(3.20GHZ 			f	t	\N	2	03125472	50	\N	t	190.41	0.00	0.00	f
3971	5937	CPU INTEL CORE2 DUO E6300 1.8 GHZ FSB1066 2MB			f	t	\N	2	03125937	50	\N	t	178.71	0.00	0.00	f
3972	5938	CPU INTEL CORE2 DUO E6400 2.13 GHZ FSB1066 2M			f	t	\N	2	03125938	50	\N	t	216.87	0.00	0.00	f
3331	4065	BACKUP INT. IOMEGA REV DRIVE 35GB ATAPI			f	t	\N	2	03154065	53	\N	t	323.92	0.00	0.00	f
2979	2290	BACKUP INT. DAT SUPERMAST 20/40 GB SCSI+SOFT			f	t	\N	2	03152290	53	\N	t	518.89	0.00	0.00	f
4452	6307	HD 320 GB ATA WESTERN DIGITAL 7200 RPM 8MB			f	t	\N	2	03166307	54	\N	t	92.13	0.00	0.00	f
4455	6310	HD  80 GB SATA2 WESTERN DIGITAL 7200 RPM 8 MB			f	t	\N	2	03166310	54	\N	t	43.24	0.00	0.00	f
3810	5625	SVGA G-FORCE IV FX6500 256MB PCIE TV DVI			f	t	\N	2	03175625	55	\N	t	58.53	0.00	0.00	f
4043	6048	SVGA G-FORCE 6200LE 64 MB 256HM PCI-E DVI			f	t	\N	2	03176048	55	\N	t	34.75	0.00	0.00	f
4448	6302	SVGA SAPPHIRE RADEON X1600 PRO 512MB DDR2 PCI			f	t	\N	2	03176302	55	\N	t	110.63	0.00	0.00	f
4419	6268	HD PORTATIL 80 GB SEAGATE 7200RPM 8MB			f	t	\N	2	03276268	194	\N	t	115.53	0.00	0.00	f
4934	6778	CART. MAXTEC BROTHER LC800 MFC 3420 CYAN B31C			f	t	\N	2	08066778	132	\N	t	3.90	0.00	0.00	f
3424	4434	PEN DRIVE 512 MB KINGSTON USB 2.0 DATA TRAVEL			f	t	\N	2	04274434	195	\N	t	9.28	0.00	0.00	f
3879	5796	HD PORTATIL 100 GB FUJITSU 5400RPM 8MB			f	t	\N	2	03275796	194	\N	t	70.96	0.00	0.00	f
3443	4499	PEN DRIVE 1 GB PNY USB 2.0 ATTACHE			f	t	\N	2	04274499	195	\N	t	16.86	0.00	0.00	f
3437	4476	PB ASROCK K8UPGRADE NF3 SON LAN SATA RAID			f	t	\N	2	03324476	196	\N	t	45.20	0.00	0.00	f
3436	4467	PB ASROCK 939A8X-M ULI M1689 SON SATA RAID LA			f	t	\N	2	03324467	196	\N	t	51.48	0.00	0.00	f
3882	5804	PB ASROCK AM2NF3-VSTA AM2 DDR2 LAN SATA RAID			f	t	\N	2	03325804	196	\N	t	56.99	0.00	0.00	f
3909	5850	PB ASROCK AM2NF6G-VSTA R2.0 AM2 DDR2 LAN SATA			f	t	\N	2	03325850	196	\N	t	60.39	0.00	0.00	f
4937	6781	KVM MANUAL KONIG 4X1 4PC/1MON/1TEC/1RAT KO 12			f	t	\N	2	09026781	107	\N	t	23.72	0.00	0.00	f
4042	6047	PB ASROCK ALIVENF6G-DVI AM2 PCIE VGA GLAN SAT			f	t	\N	2	03326047	196	\N	t	67.55	0.00	0.00	f
3771	5517	REPRODUCTOR MP3 RIMAX MYSTIC 1GB MP4 LCD 1.5"			f	t	\N	2	13045517	198	\N	t	65.72	0.00	0.00	f
4938	6782	COMPROBADOR DE CABLEADO LED PHASAK DX230			f	t	\N	2	09026782	107	\N	t	15.99	0.00	0.00	f
3772	5518	REPRODUCTOR MP3 RIMAX MYSTIC 2GB MP4 LCD 1.5"			f	t	\N	2	13045518	198	\N	t	85.82	0.00	0.00	f
3416	4398	REPRODUCTOR MP3 RIMAX LIPO 606 USB VOZ FM 1GB			f	t	\N	2	13044398	198	\N	t	85.82	0.00	0.00	f
3624	5091	REPRODUCTOR DIVX / DVD YAMADA CHILI STYLE 630			f	t	\N	2	13045091	198	\N	t	59.10	0.00	0.00	f
4077	6093	REPRODUCTOR HD RIMAX ALUM TVIX 250 GB USB2.0 			f	t	\N	2	13046093	198	\N	t	166.43	0.00	0.00	f
5318	7364	CAJA SERVIDOR INTEL SC5295UP PILOTPOINT3 NEGR			f	t	\N	2	03037364	32	\N	t	192.95	0.00	0.00	f
4735	6459	REPRODUCTOR DIVX / DVD YAMADA KAZUKI 7400X-CU			f	t	\N	2	13046459	198	\N	t	46.41	0.00	0.00	f
4343	5536	IMPRESORA CANON PIXMA MP 800R MULTIFUNCION IR			f	t	\N	2	04265536	200	\N	t	406.39	0.00	0.00	f
3493	4664	IMPRESORA HP OFFICEJET 5615 MULTIFUNCION CON 			f	t	\N	2	04264664	200	\N	t	170.57	0.00	0.00	f
3572	4940	IMPRESORA HP LASERJET 2820MFP MULTIFUNCION Q3			f	t	\N	2	04264940	200	\N	t	1069.46	0.00	0.00	f
3793	5585	IMPRESORA HP LASERJET 3052 MULTIF RJ45 USB2 Q			f	t	\N	2	04265585	200	\N	t	419.65	0.00	0.00	f
3873	5778	IMPRESORA EPSON DX4000 MULTIFUNCION			f	t	\N	2	04265778	200	\N	t	89.89	0.00	0.00	f
3912	5856	IMPRESORA HP PHOTOSMART C3180 MULTIFUNCION US			f	t	\N	2	04265856	200	\N	t	93.67	0.00	0.00	f
3976	5945	IMPRESORA CANON PIXMA MP 160 MULTIFUNCION			f	t	\N	2	04265945	200	\N	t	79.83	0.00	0.00	f
4476	6334	IMPRESORA HP LASERJET 3392 MULTIFUNCION Q6501			f	t	\N	2	04266334	200	\N	t	850.57	0.00	0.00	f
4110	6135	CAJA SEMITORRE ATX TSAA 861 NEGRA USB+AUDIO			f	t	\N	2	03026135	31	\N	t	59.28	0.00	0.00	f
3554	4856	POCKET PC HP iPAQ HW6515 FA385T 312MHZ TEL GP			f	t	\N	2	13024856	201	\N	t	627.84	0.00	0.00	f
4228	03	HOSTING ESCUELA DEL MAR			f	f	\N	2	020603	207	\N	\N	42.00	0.00	0.00	f
4231	06	HOSTING JMCREP.COM			f	f	\N	2	020606	207	\N	\N	90.00	0.00	0.00	f
4232	07	HOSTING MARMOLERIAFULLANA.COM 			f	f	\N	2	020607	207	\N	\N	90.00	0.00	0.00	f
4234	09	HOSTING CASASCONHISTORIA.NET			f	f	\N	2	020609	207	\N	\N	45.00	0.00	0.00	f
4236	11	HOSTING VIAMAR-IBIZA.COM			f	f	\N	2	020611	207	\N	\N	90.00	0.00	0.00	f
4235	10	HOSTING IBIZASEACHARTER.COM			f	f	\N	2	020610	207	\N	\N	30.00	0.00	0.00	f
4192	01	R FINANCIERO			f	f	\N	2	020301	57	\N	\N	0.10	0.00	0.00	f
2874	1093	ADAPTADOR USB A PTO. SERIE DB9 MACHO (SB2040)			f	t	\N	2	09011093	106	\N	t	22.98	0.00	0.00	f
2875	1095	CONTROLADORA PCI 3PTOS.FIREWIRE CONCEPTRONIC			f	t	\N	2	03261095	186	\N	t	14.53	0.00	0.00	f
2876	1097	PCMCIA CONCEPTRONIC 2PTOS. USB 2.0 S/CABLE CS			f	t	\N	2	04151097	82	\N	t	20.46	0.00	0.00	f
2878	1134	ADAPTADOR USB A P.PARALELO 1.8 M CN36 (KO 202			f	t	\N	2	09011134	106	\N	t	19.04	0.00	0.00	f
2918	1511	SAI NGS ALERT 500 OFF LINE			f	t	\N	2	04141511	81	\N	t	71.46	0.00	0.00	f
3063	2947	TONER IMP. HP LASERJET 1300 Q2613A			f	t	\N	2	08092947	136	\N	t	53.39	0.00	0.00	f
3108	3146	CABLE USB 2.0 1,8M A -MINI- B (4 pines) MM SB			f	t	\N	2	09013146	106	\N	t	4.49	0.00	0.00	f
3200	3532	PACK 5 DVD+RW VERBATIM 4.7GB DATALIFE+			f	t	\N	2	08023532	100	\N	t	8.73	0.00	0.00	f
3201	3547	PACK 5 DVD+R DL VERBATIM 8.5GB 2.4X JEWEL			f	t	\N	2	08023547	100	\N	t	21.59	0.00	0.00	f
3202	3555	DESKTOP NGS INALAMBRICO SLIM KIT OPTICAL			f	t	\N	2	04073555	71	\N	t	37.54	0.00	0.00	f
4599	3754	MEMORIA COMPACT FLASH KINGSTON 512MB STANDARD			f	t	\N	2	04273754	195	\N	t	12.99	0.00	0.00	f
3298	3952	CART. EPSON R800 MAGENTA C13T054340			f	t	\N	2	08073952	133	\N	t	14.43	0.00	0.00	f
3330	4054	TONER IMP. HP LASERJET 3500/50 3700 SERIES Q2			f	t	\N	2	08094054	136	\N	t	105.90	0.00	0.00	f
4607	4059	ALTAVOCES RIMAX WIRELESS SPEAKERS			f	t	\N	2	04064059	70	\N	t	39.16	0.00	0.00	f
3376	4240	TONER IMP. HP LASERJET 4100 C8061X			f	t	\N	2	08094240	136	\N	t	102.24	0.00	0.00	f
3379	4255	CART. HP NEGRO Nº10 2000C 2500C 2200 2250 C48			f	t	\N	2	08074255	133	\N	t	25.45	0.00	0.00	f
3380	4258	ALTAVOCES NGS TWINSTAR			f	t	\N	2	04064258	70	\N	t	16.53	0.00	0.00	f
3381	4259	ALTAVOCES NGS HI-SONIC 5.1 CON MANDO			f	t	\N	2	04064259	70	\N	t	45.70	0.00	0.00	f
3382	4260	RATON NGS VIPER SPORT OPTICO USB PS2 NEGRO			f	t	\N	2	04084260	72	\N	t	11.55	0.00	0.00	f
3383	4261	RATON NGS VIPER SPORT OPTICO USB PS2 ROJO			f	t	\N	2	04084261	72	\N	t	11.55	0.00	0.00	f
3398	4295	IMPRESORA HP LASERJET 2840EN MULTIFUNCION Q39			f	t	\N	2	04264295	200	\N	t	896.65	0.00	0.00	f
3399	4314	IMP. TICKETS SAMSUNG SRP-275 APG NEGRA PARALE			f	t	\N	2	05034314	120	\N	t	183.24	0.00	0.00	f
4297	4329	CAJA MICRO ATX DH-153-B PLATA NEGRO 200W			f	t	\N	2	03024329	31	\N	t	54.22	0.00	0.00	f
4357	5837	PB FOXCONN 915PL7AE-S 915PL S775 PCIE SON LAN			f	t	\N	2	03115837	86	\N	t	60.24	0.00	0.00	f
4736	6460	CAMARA VIDEO IP RIMAX IPCAM 7200 RJ45 IR PAN/			f	t	\N	2	13056460	202	\N	t	144.58	0.00	0.00	f
4298	4404	TONER IMP. BROTHER TN-2000 NEGRO			f	t	\N	2	08094404	136	\N	t	53.48	0.00	0.00	f
3475	4602	ALTAVOCES NGS SPHERE 2.1 BLIND. MAGNET.			f	t	\N	2	04064602	70	\N	t	24.84	0.00	0.00	f
3510	4703	HD PORTATIL 80 GB FUJITSU 2.5" 5400RPM 8M			f	t	\N	2	03274703	194	\N	t	57.30	0.00	0.00	f
3515	4713	VENTILADOR BLUE ORB II K8 LGA775 LED AZUL 17 			f	t	\N	2	03134713	51	\N	t	30.23	0.00	0.00	f
3516	4714	CAMARA VIDEO IP D-LINK DCS-900 RJ45			f	t	\N	2	13054714	202	\N	t	117.71	0.00	0.00	f
3529	4761	CAMARA VIDEO IP CONCEPTRONIC RJ45 CNETCAM			f	t	\N	2	13054761	202	\N	t	107.75	0.00	0.00	f
4313	4762	CAMARA VIDEO IP CONCEPTRONIC RJ45 Y WIFI C54N			f	t	\N	2	13054762	202	\N	t	135.61	0.00	0.00	f
3533	4773	TONER IMP. EPSON ACULASER C1100/X11 AMARILLO			f	t	\N	2	08094773	136	\N	t	66.58	0.00	0.00	f
3545	4820	LEC. TARJ. CHIP INTELIGENTE CARDMAN 3121 USB 			f	t	\N	2	04234820	148	\N	t	25.16	0.00	0.00	f
4630	4821	HD PORTATIL 100 GB FUJITSU 4200RPM 8MB			f	t	\N	2	03274821	194	\N	t	71.40	0.00	0.00	f
4633	4927	ROUTER ADSL RDSI CONCEPTRONIC + 4 PUERTOS LAN			f	t	\N	2	07074927	220	\N	t	56.14	0.00	0.00	f
3596	5029	CAJA ATX RACK 19" 4U RMC4S2 3X5.25" + 2X3.5" 			f	t	\N	2	03035029	32	\N	t	126.53	0.00	0.00	f
3693	5347	RATON NGS ODISSEY OPTICO MULTIMEDIA USB			f	t	\N	2	04085347	72	\N	t	10.72	0.00	0.00	f
3694	5350	SOPORTE CPU METALICO CON RUEDAS OA 2035			f	t	\N	2	09025350	107	\N	t	12.95	0.00	0.00	f
3695	5356	RATON LOGITECH RX 300 OPTICAL MOUSE 3D NEGRO 			f	t	\N	2	04085356	72	\N	t	10.18	0.00	0.00	f
3696	5357	CONECTOR MACHO FTP RJ49 CAT.5E			f	t	\N	2	07055357	188	\N	t	3.46	0.00	0.00	f
3697	5359	CART. FAX CANON BX3 B100 110 MP10 B150 B155 B			f	t	\N	2	08075359	133	\N	t	26.30	0.00	0.00	f
3699	5364	CABLE EXTENSION AUDIO MINI JACK 3.5mm M/H AK 			f	t	\N	2	09015364	106	\N	t	2.25	0.00	0.00	f
4750	6481	CART. BROTHER MFC210C 1835C AMARILLO LC900Y			f	t	\N	2	08076481	133	\N	t	9.55	0.00	0.00	f
4751	6482	CART. BROTHER MFC210C 1835C CYAN LC900C			f	t	\N	2	08076482	133	\N	t	9.12	0.00	0.00	f
4641	5396	LECTOR C.B. METROLOGIC MS-3580 QUANTUM T NEGR			f	t	\N	2	05035396	120	\N	t	291.23	0.00	0.00	f
3711	5399	CABLE USB 2.0 1,8M A-MINI-B (5 pines) M/M SB 			f	t	\N	2	09015399	106	\N	t	3.70	0.00	0.00	f
3750	5452	GRABADORA DIGITAL NGS DE VOZ ECHO			f	t	\N	2	13045452	198	\N	t	100.39	0.00	0.00	f
3766	5488	CART. CANON IP6120D IP6220D PHOTO COLOR CL52			f	t	\N	2	08075488	133	\N	t	20.04	0.00	0.00	f
3767	5491	DISQUETERA USB 1.44M 3.5" NEC UF0002 NEGRA BL			f	t	\N	2	04195491	142	\N	t	22.86	0.00	0.00	f
3774	5527	AURICULAR NGS RUNNER SPORT HEADSET			f	t	\N	2	09075527	189	\N	t	5.37	0.00	0.00	f
5328	7374	DESKTOP NGS INALAMBRICO SUNSET KIT OPTICAL			f	t	\N	2	04077374	71	\N	t	32.41	0.00	0.00	f
5329	7375	PEN DRIVE 2 GB TAKE MS COLOURLINE USB 2.0 AZU			f	t	\N	2	04277375	195	\N	t	14.36	0.00	0.00	f
5330	7376	HD EXT. 500GB WESTERN DIGITAL ELEMENTS DESKTO			f	t	\N	2	04197376	142	\N	t	110.94	0.00	0.00	f
5331	7377	HD EXT. 750GB WESTERN DIGITAL MY BOOK ESSENTI			f	t	\N	2	04197377	142	\N	t	207.72	0.00	0.00	f
4779	6526	ARMARIO RACK 19" 32U 600X900 SUELO			f	t	\N	2	07046526	150	\N	t	753.19	0.00	0.00	f
4783	6534	SVGA POWERCOLOR RADEON X1550 512MB DDR2 PCIE 			f	t	\N	2	03176534	55	\N	t	56.76	0.00	0.00	f
5332	7378	HD EXT. 250GB WESTERN DIGITAL ELEMENTS DESKTO			f	t	\N	2	04197378	142	\N	t	80.39	0.00	0.00	f
4658	5765	TONER IMP. OKI 8W/8P/6W (TYPE 6) NEGRO			f	t	\N	2	08095765	136	\N	t	25.23	0.00	0.00	f
3901	5841	ESCANER EPSON PERFECTION V10			f	t	\N	2	04055841	69	\N	t	83.05	0.00	0.00	f
3915	5863	SOFT. ANTIVIRUS PANDA INTERNET SECURITY 2007 			f	t	\N	2	06035863	91	\N	t	65.84	0.00	0.00	f
3916	5864	SOFT. ANTIVIRUS NORTON 2007 RETAIL			f	t	\N	2	06035864	91	\N	t	40.61	0.00	0.00	f
3919	5870	PB INTEL D946GZISSL S775 VGA PCIE DDR2 SATA2 			f	t	\N	2	03115870	86	\N	t	83.43	0.00	0.00	f
3920	5871	TELEFONO VOIP CONCEPTRONIC USB			f	t	\N	2	13075871	203	\N	t	22.37	0.00	0.00	f
4360	5875	SWITCH NETGEAR 16 PUERTOS 10/100 8XPOE FS116P			f	t	\N	2	07025875	95	\N	t	168.13	0.00	0.00	f
3922	5876	ROUTER ADSL2+ CONCEPTRONIC WIRELESS 4PTOS C54			f	t	\N	2	07015876	94	\N	t	60.49	0.00	0.00	f
4361	5882	ADAPTADOR NETGEAR RED ELECT. A RJ45 14Mbps XE			f	t	\N	2	07025882	95	\N	t	35.02	0.00	0.00	f
3929	5885	KIT ADAPTADOR DE RED NETGEAR RED ELECT. A R45			f	t	\N	2	07025885	95	\N	t	188.45	0.00	0.00	f
3930	5886	T.RED PCI NETGEAR GA311GE 10/100/1000			f	t	\N	2	03295886	183	\N	t	15.05	0.00	0.00	f
4286	3989	HD PORTATIL 60 GB TOSHIBA 4200RPM 8MB			f	t	\N	2	03273989	194	\N	t	64.01	0.00	0.00	f
3361	4157	HD PORTATIL 80 GB FUJITSU 2.5" 4200RPM 8M			f	t	\N	2	03274157	194	\N	t	63.59	0.00	0.00	f
3933	5889	SWITCH NETGEAR FS116GE 16 PUERTOS 10/100			f	t	\N	2	07025889	95	\N	t	45.53	0.00	0.00	f
4362	5891	SWITCH NETGEAR GS605FS 5 PUERTOS 10/100/1000			f	t	\N	2	07025891	95	\N	t	38.53	0.00	0.00	f
4668	5897	ROUTER ADSL NETGEAR DG834FS + 4 PUERTOS LAN 1			f	t	\N	2	07075897	220	\N	t	55.57	0.00	0.00	f
4669	5898	ROUTER ADSL2+ NETGEAR WIRELESS DG834GFS 4P 54			f	t	\N	2	07075898	220	\N	t	66.16	0.00	0.00	f
3949	5906	REPRODUCTOR MULTIMEDIA INALAMBRICO NETGEAR EV			f	t	\N	2	13045906	198	\N	t	184.94	0.00	0.00	f
3950	5907	TELEFONO VOIP NETGEAR SKYPE WIFI PHONE			f	t	\N	2	13075907	203	\N	t	163.07	0.00	0.00	f
3951	5908	ACCESS POINT NETGEAR WG602FS WIRELESS 54Mbps			f	t	\N	2	07015908	94	\N	t	36.06	0.00	0.00	f
3952	5909	T.RED PCMCIA NETGEAR WIRELESS LAN WG511FS 54M			f	t	\N	2	07015909	94	\N	t	24.52	0.00	0.00	f
3954	5911	T.RED PCMCIA NETGEAR WIRELESS LAN WN511T 300M			f	t	\N	2	07015911	94	\N	t	63.75	0.00	0.00	f
4672	5912	GATEWAY NETGEAR WNR854T WIRELESS 300MBPS + 4P			f	t	\N	2	07075912	220	\N	t	150.14	0.00	0.00	f
4007	5995	AURICULAR CON MICROFONO NGS MSX8PRO			f	t	\N	2	09075995	189	\N	t	7.71	0.00	0.00	f
4676	5998	IMPRESORA HP LASERJET P2015N CB449A USB RJ45			f	t	\N	2	04245998	173	\N	t	275.43	0.00	0.00	f
4010	6000	PILAS RECARGABLES AA 2100 mAh CEGASA BLISTER 			f	t	\N	2	09026000	107	\N	t	7.88	0.00	0.00	f
4038	6042	ALTAVOCES LOGITECH X-210 / 2.1			f	t	\N	2	04066042	70	\N	t	32.04	0.00	0.00	f
4679	6043	TFT 17"  PHILIPS 170S7FB NEGRO 1280X1024 NO M			f	t	\N	2	04026043	66	\N	t	192.87	0.00	0.00	f
4039	6044	IMPRESORA HP LASERJET M1005 MULTIFUNCION CB37			f	t	\N	2	04266044	200	\N	t	255.48	0.00	0.00	f
4045	6051	CAJA SEMITORRE ATX TUNIQ 2 NEGRA 12CM			f	t	\N	2	03026051	31	\N	t	72.47	0.00	0.00	f
4073	6089	CAJA SEMITORRE ATX TUNIQ 2 NEGRA/PLATA 12CM			f	t	\N	2	03026089	31	\N	t	69.27	0.00	0.00	f
4084	6108	ADAPTADOR FM MP3 CONCEPTR. TRANSMITTER CLLFMC			f	t	\N	2	13046108	198	\N	t	12.58	0.00	0.00	f
4135	6163	CART. EPSON D68 D88 DX3800 CYAN T061240B0			f	t	\N	2	08076163	133	\N	t	7.99	0.00	0.00	f
4390	6228	CAMARA WEB LOGITECH QUICKCAM COM. STX PLUS PL			f	t	\N	2	04116228	75	\N	t	39.58	0.00	0.00	f
4391	6229	SVGA SAPPHIRE RADEON X1600 PRO 512MB DDR2 AGP			f	t	\N	2	03176229	55	\N	t	123.25	0.00	0.00	f
4395	6233	CART. MAXTEC HP Nº45 DJ 710 750 NEGRO 51645A 			f	t	\N	2	08066233	132	\N	t	8.77	0.00	0.00	f
4396	6234	CART. MAXTEC EPSON D68 D88 DX3800 NEGRO T0611			f	t	\N	2	08066234	132	\N	t	3.83	0.00	0.00	f
4397	6235	CART. MAXTEC BROTHER LC41 47M 900M MAGENTA B-			f	t	\N	2	08066235	132	\N	t	3.90	0.00	0.00	f
4398	6236	CART. MAXTEC HP Nº56 DJ 5150 NEGRO C6656AE H6			f	t	\N	2	08066236	132	\N	t	13.14	0.00	0.00	f
4401	6241	CPU INTEL XEON D5050 3.0 DUAL 2x2MB 667FSB AC			f	t	\N	2	03126241	50	\N	t	210.86	0.00	0.00	f
4402	6242	PB INTEL S5000PSLROMB DXEON 667 DLAN PCIE SAT			f	t	\N	2	03116242	86	\N	t	633.75	0.00	0.00	f
4409	6251	HD  73.5 GB SAS3 FUJITSU 15000 RPM 16MB AL-9L			f	t	\N	2	03166251	54	\N	t	202.39	0.00	0.00	f
4416	6264	PB ASUS K8V-XE S754 PCI-E SATA2 SON LAN RAID			f	t	\N	2	03326264	196	\N	t	55.01	0.00	0.00	f
4417	6266	CAJA SERVIDOR ENLIGHT SR-5032			f	t	\N	2	03036266	32	\N	t	116.86	0.00	0.00	f
4423	6272	CART. MAXTEC EPSON C64 C86 CX3600 NEGRO T0441			f	t	\N	2	08066272	132	\N	t	3.83	0.00	0.00	f
4467	6322	IMPRESORA CANON PIXMA IP 3300 USB			f	t	\N	2	04036322	67	\N	t	64.55	0.00	0.00	f
4689	6327	KIT MONTAJE BACKPLANE SC5299/5295 SAS APP3HSD			f	t	\N	2	03046327	38	\N	t	27.06	0.00	0.00	f
4690	6329	MEMORIA FBDIMM DDR2 1G 667MHz KINGSTON ECC			f	t	\N	2	03146329	52	\N	t	60.24	0.00	0.00	f
4692	6355	CAJA EXT. CONCEPTRONIC 3.5 IDE FIREWIRE USB 2			f	t	\N	2	04236355	148	\N	t	32.89	0.00	0.00	f
4522	6388	TONER IMP. HP LASERJET 3600 3800 CYAN Q7581A			f	t	\N	2	08096388	136	\N	t	137.01	0.00	0.00	f
4715	6423	REPRODUCTOR HD CONCEPTRONIC MULTIMEDIA 300 GB			f	t	\N	2	13046423	198	\N	t	174.65	0.00	0.00	f
4730	6453	LINTERNA RIMAX MAGIC LIGHT RECARGABLE MOVIMIE			f	t	\N	2	09026453	107	\N	t	5.42	0.00	0.00	f
4731	6454	ALTAVOCES RIMAX MUSIC WHITE SPEAKERS PARA MP3			f	t	\N	2	04066454	70	\N	t	39.64	0.00	0.00	f
4767	6506	PB INTEL D946GZISSL S775 VGA PCIE DDR2 SATA2 			f	t	\N	2	03116506	86	\N	t	84.70	0.00	0.00	f
4768	6507	RATON LOGITECH S96 OPTCAL WHEEL MOUSE OEM PS/			f	t	\N	2	04086507	72	\N	t	7.64	0.00	0.00	f
3937	5894	SWITCH NETGEAR JGS524GE 24 PUERTOS 10/100/100			f	t	\N	2	07025894	95	\N	t	326.84	0.00	0.00	f
4784	6536	PORT. SAMSUNG Q40 U1400 1.2GB 60GB DVD-RW 12.			f	t	\N	2	02996536	204	\N	t	1544.28	0.00	0.00	f
4785	6537	PB ASUS A8R32-MVP DELUXE 2xPCIE DDR SATA2 2XG			f	t	\N	2	03326537	196	\N	t	130.22	0.00	0.00	f
4786	6539	PB ASUS P5PL2 i945PL PCIE DDR2 SATA2 GLAN SON			f	t	\N	2	03116539	86	\N	t	73.82	0.00	0.00	f
4816	6592	CART. MAXTEC EPSON L.MAGENTA  R360/265 RX560 			f	t	\N	2	08066592	132	\N	t	5.13	0.00	0.00	f
4818	6594	CART. MAXTEC EPSON 400/440/640/740/810 COLOR 			f	t	\N	2	08066594	132	\N	t	5.84	0.00	0.00	f
4819	6595	CART. MAXTEC EPSON 1160/740/760/810/860			f	t	\N	2	08066595	132	\N	t	3.25	0.00	0.00	f
4830	6611	MEMORIA MMC-MOBILE KINGSTON 1 GB RS-MMC			f	t	\N	2	04276611	195	\N	t	19.43	0.00	0.00	f
4833	6616	CAJA SEMITORRE ATX QUARTERBACK NEGRA VENTANA 			f	t	\N	2	03026616	31	\N	t	49.12	0.00	0.00	f
4837	6622	PB GIGABYTE GA-965P-DS3 S775 1006 PCIE DDR2 S			f	t	\N	2	03116622	86	\N	t	101.08	0.00	0.00	f
4841	6631	RW DVD DL SATA SAMSUNG 18X6X18X SH-S203A NEGR			f	t	\N	2	03226631	128	\N	t	29.54	0.00	0.00	f
4842	6633	PB GIGABYTE GA-945PL-S3 S775 1006 PCIE DDR2 S			f	t	\N	2	03116633	86	\N	t	72.29	0.00	0.00	f
2890	1220	LATIGUILLO UTP CAT.5E DE 10 MTS MARFIL PL1010			f	t	\N	2	07051220	188	\N	t	5.12	0.00	0.00	f
2961	2100	MEMORIA DIMM DDR 512 MB 400Mhz KINGSTON			f	t	\N	2	03142100	52	\N	t	25.58	0.00	0.00	f
3227	3668	ACCESS POINT CONCEPTRONIC 54 Mbps C54APM WIRE			f	t	\N	2	07013668	94	\N	t	40.37	0.00	0.00	f
4867	6678	ADAPTADOR FM MP3 CONCEPTR. TRANSMITTER CLLFMB			f	t	\N	2	13046678	198	\N	t	19.47	0.00	0.00	f
4868	6679	RATON CONCEPTRONIC OPTICAL COLOR MOUSE USB PS			f	t	\N	2	04086679	72	\N	t	9.30	0.00	0.00	f
4869	6680	RATON CONCEPTRONIC OPTICAL TRAVEL MOUSE USB P			f	t	\N	2	04086680	72	\N	t	5.05	0.00	0.00	f
4870	6681	RATON CONCEPTRONIC LASER MOUSE USB PS2			f	t	\N	2	04086681	72	\N	t	13.16	0.00	0.00	f
4004	5990	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144			f	t	\N	2	08075990	133	\N	t	7.96	0.00	0.00	f
4902	6735	CAJA EXT. ICY BOX 3.5" IDE USB 2.0 HDD IDE PL			f	t	\N	2	04236735	148	\N	t	27.07	0.00	0.00	f
4903	6736	CAJA EXT. ICY BOX 2.5" IDE USB 2.0 IB-250U			f	t	\N	2	04236736	148	\N	t	19.76	0.00	0.00	f
4920	6759	FA. 250W THERMALTAKE PARA NVIDIA SLI 5.25" AD			f	t	\N	2	03106759	48	\N	t	43.69	0.00	0.00	f
4921	6760	IMP. TICKETS SAMSUNG SRP-350+COPG TERM. NEGRO			f	t	\N	2	05036760	120	\N	t	289.93	0.00	0.00	f
4942	6797	ARMARIO RACK 19" PCCASE 6U F450 1 CUERPO			f	t	\N	2	07046797	150	\N	t	91.65	0.00	0.00	f
4943	6799	CART. MAXTEC LEXMARK 3200 5000 5700 COLOR 12A			f	t	\N	2	08066799	132	\N	t	22.40	0.00	0.00	f
4944	6804	CART. MAXTEC EPSON C70 C80 CX5200 5400 NEGRO 			f	t	\N	2	08066804	132	\N	t	4.88	0.00	0.00	f
4945	6805	IMP. TICKETS SAMSUNG SRP-275 CPG NEGRA PARALE			f	t	\N	2	05036805	120	\N	t	246.04	0.00	0.00	f
3878	5788	IMPRESORA EPSON STYLUS D78 USB DINA4 22PPM 57			f	t	\N	2	04035788	67	\N	t	60.24	0.00	0.00	f
3754	5462	PB ASROCK P4i65G i865G SATA VGA SON LAN DDR40			f	t	\N	2	03115462	86	\N	t	50.70	0.00	0.00	f
4949	6815	CAJA EXT. ICY BOX 3.5" IDE USB 2.0 HDD NEGRO 			f	t	\N	2	04236815	148	\N	t	43.72	0.00	0.00	f
4957	6829	IMP. TICKETS SAMSUNG SRP-350+COSG TERM NEGRO			f	t	\N	2	05036829	120	\N	t	286.46	0.00	0.00	f
4958	6833	CART. MAXTEC EPSON C60 COLOR T029			f	t	\N	2	08066833	132	\N	t	5.84	0.00	0.00	f
4959	6837	FA. 600W GC PFC PIV 12CM 20/24 PIN TC RETAIL			f	t	\N	2	03106837	48	\N	t	25.73	0.00	0.00	f
4961	6839	SVGA ASUS G-FORCE 8800GTS PCIE 320DDR3 DUAL D			f	t	\N	2	03176839	55	\N	t	317.13	0.00	0.00	f
4966	6850	PEN DRIVE 2 GB KINGSTON USB 2.0 DATA TRAV. MI			f	t	\N	2	04276850	195	\N	t	18.65	0.00	0.00	f
4549	01	ORDENADOR MONTADO SERIE FEEL			f	f	\N	2	130801	213	\N	\N	0.10	0.00	0.00	f
2841	0679	CABLE USB 3MT A/B MM   SB2403			f	t	\N	2	09010679	106	\N	t	1.45	0.00	0.00	f
4011	6001	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 			f	t	\N	2	04026001	66	\N	t	226.24	0.00	0.00	f
4559	07	OKI TONER AZUL C33/C34			f	f	\N	2	081007	137	\N	\N	38.38	0.00	0.00	f
4503	6367	CPU INTEL CORE2 DUO E4300 1.8 GHZ FSB800 2MB			f	t	\N	2	03126367	50	\N	t	162.28	0.00	0.00	f
4983	6895	SWITCH NETGEAR GS724T 24 PUERTOS 10/100/1000 			f	t	\N	2	07026895	95	\N	t	224.18	0.00	0.00	f
4984	6899	PB ASUS M2V-MX K8M890 VGA AM2 PCIE DDR2 GLAN 			f	t	\N	2	03326899	196	\N	t	51.49	0.00	0.00	f
4986	6901	PB ASROCK ALIVENF6G-VSTA AM2 PCIE VGA GLAN SA			f	t	\N	2	03326901	196	\N	t	47.01	0.00	0.00	f
4989	6909	SVGA XFX G-FORCE 8600GT PCIE 256DDR3 DUAL DVI			f	t	\N	2	03176909	55	\N	t	117.73	0.00	0.00	f
4990	6910	RW DVD DUAL DL LITEON 20X8X20X LIGHTSCRIBE NE			f	t	\N	2	03226910	128	\N	t	28.94	0.00	0.00	f
4993	6913	LATIGUILLO FIBRA OPTICA MTRJ-MTRJ DE 1 MTS RL			f	t	\N	2	07056913	188	\N	t	21.24	0.00	0.00	f
4995	6915	LATIGUILLO FIBRA OPTICA MTRJ-ST DE 2 MTS RL 4			f	t	\N	2	07056915	188	\N	t	20.94	0.00	0.00	f
5015	6950	TFT 22"  BENQ FP222WA 5MS DVI NEGRO PANORAMIC			f	t	\N	2	04026950	66	\N	t	272.18	0.00	0.00	f
5016	6951	SVGA XFX G-FORCE 8600GT XXX PCIE 256DDR3 2X D			f	t	\N	2	03176951	55	\N	t	125.39	0.00	0.00	f
5018	6955	SVGA SAPPHIRE ATI X550XTX PCIE 256MB 512HM TV			f	t	\N	2	03176955	55	\N	t	53.31	0.00	0.00	f
5022	6966	SVGA SAPPHIRE RADEON X1550 512MB DDR2 AGP RET			f	t	\N	2	03176966	55	\N	t	103.87	0.00	0.00	f
5030	6977	RW DVD DL SATA LITEON 20X4X20X LH-20A1S 3 FRO			f	t	\N	2	03226977	128	\N	t	32.61	0.00	0.00	f
5040	7005	IMPRESORA HP PHOTOSMART C4280 MULTIFUNCION US			f	t	\N	2	04267005	200	\N	t	95.18	0.00	0.00	f
5041	7006	CAJA MICRO ATX ENLIGHT EN-2406 NEGRA USB AUDI			f	t	\N	2	03027006	31	\N	t	38.25	0.00	0.00	f
5042	7010	SVGA G-FORCE 7600GS PCIE 512 DDR2 DUAL DVI TV			f	t	\N	2	03177010	55	\N	t	72.18	0.00	0.00	f
5043	7011	VENTILADOR THERMALTAKE SILENT 775D			f	t	\N	2	03137011	51	\N	t	25.82	0.00	0.00	f
5044	7012	MEMORIA MINI SECURE DIGITAL KINGSTON MINISD 2			f	t	\N	2	04277012	195	\N	t	21.41	0.00	0.00	f
5048	7019	RW DVD DL ASUS 18X8X18X DRW-1814BL LIGHTS NEG			f	t	\N	2	03227019	128	\N	t	27.41	0.00	0.00	f
5059	7032	CPU INTEL P DUALCORE E2160 1.8 GHZ FSB800 1MB			f	t	\N	2	03127032	50	\N	t	72.18	0.00	0.00	f
5080	7065	CPU INTEL CELERON 430 1.8 GHz 512K 800M S775 			f	t	\N	2	03127065	50	\N	t	44.41	0.00	0.00	f
5081	7066	TECLADO LOGITECH CLASSIC PS/2 NEGRO RETAIL			f	t	\N	2	04077066	71	\N	t	10.47	0.00	0.00	f
5082	7071	PB ASUS M2N-MX SE GF6100 AM2 VGA PCIE DDR2 6C			f	t	\N	2	03327071	196	\N	t	51.19	0.00	0.00	f
5083	7072	CABLE VGA 7 MTS. M-H (ALARGADOR) AK4227			f	t	\N	2	09017072	106	\N	t	14.30	0.00	0.00	f
3210	3605	MODEM 56K USB CONCEPTRONIC C56U RETAIL			f	t	\N	2	04043605	68	\N	t	23.89	0.00	0.00	f
5098	7093	REPRODUCTOR MP3 CREATIVE ZEN STONE 1GB NEGRO			f	t	\N	2	13047093	198	\N	t	38.61	0.00	0.00	f
5099	7094	REPRODUCTOR MP3 CREATIVE ZEN STONE 1GB DARK B			f	t	\N	2	13047094	198	\N	t	37.28	0.00	0.00	f
5101	7096	REPRODUCTOR MP3 CREATIVE ZEN STONE 1GB RED			f	t	\N	2	13047096	198	\N	t	37.28	0.00	0.00	f
4601	3902	CAMARA RIMAX 47T COLOR EXT. VISION NOCTURNA			f	t	\N	2	13053902	202	\N	t	63.73	0.00	0.00	f
5109	7110	GATEWAY 3G/UMTS LINKSYS WRT54G3G WIFI 54MBPS 			f	t	\N	2	07077110	220	\N	t	190.82	0.00	0.00	f
5121	7125	ADAPT DE RED NETGEAR RED ELECT. A WIFI 54Mbps			f	t	\N	2	07027125	95	\N	t	77.06	0.00	0.00	f
5132	7139	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON ECC			f	t	\N	2	03147139	52	\N	t	70.24	0.00	0.00	f
3358	4147	BOBINA 25 DVD-R VERBATIM 16X 4.7GB			f	t	\N	2	08024147	100	\N	t	29.23	0.00	0.00	f
3372	4208	CAMARA WEB LOGITECH QUICKCAM NOTEBOOK			f	t	\N	2	04114208	75	\N	t	32.75	0.00	0.00	f
3374	4223	CART. HP NEGRO PARA THINKJET Y QUIETJET (5160			f	t	\N	2	08074223	133	\N	t	10.73	0.00	0.00	f
5159	7178	CAJA SEMITORRE ATX FREEZING STORM NEGRA VENTA			f	t	\N	2	03027178	31	\N	t	49.33	0.00	0.00	f
5161	7180	HD PORTATIL 160 GB SATA2 SEAGATE 2.5" 7200RPM			f	t	\N	2	03277180	194	\N	t	142.49	0.00	0.00	f
5163	7182	TFT 17" PHILIPS 170X7FB NEGRO 1280X1024 DVI 5			f	t	\N	2	04027182	66	\N	t	202.81	0.00	0.00	f
5164	7183	PAPEL ROLLO A1 HP INSTANTDRY SATINADO 61cm x 			f	t	\N	2	08107183	137	\N	t	41.36	0.00	0.00	f
5165	7185	CAMARA FOTOS KODAK V803 8MP 32MB 3XOPT SD			f	t	\N	2	13037185	199	\N	t	169.16	0.00	0.00	f
5166	7186	PORT. SAMSUNG R60+ T2130 1GB 120GB DVD-RW 15.			f	t	\N	2	02997186	204	\N	t	660.66	0.00	0.00	f
5227	7271	DESKTOP LOGITECH CORDLESS WAVE LASER			f	t	\N	2	04077271	71	\N	t	74.59	0.00	0.00	f
5228	7272	TECLADO LOGITECH CLASSIC 200 RETAIL			f	t	\N	2	04077272	71	\N	t	10.69	0.00	0.00	f
5229	7273	TFT 22"  RYOKU / YURAKU M2BABW 5MS NEGRO MM P			f	t	\N	2	04027273	66	\N	t	221.90	0.00	0.00	f
5230	7274	TFT 20" ASUS VW202S 5MS NEGRO MM 0.258			f	t	\N	2	04027274	66	\N	t	207.90	0.00	0.00	f
5233	7277	RW DVD DUAL DL SLIM LITEON 8X8X4 DS-8A1P OEM			f	t	\N	2	03357277	211	\N	t	48.11	0.00	0.00	f
5234	7278	PORT. HP 530 M420 512MB 80GB DVD-RW 15.4" WXG			f	t	\N	2	02997278	204	\N	t	440.43	0.00	0.00	f
5238	7283	ESCANER CANON LIDE 90 2400DPI A4 USB			f	t	\N	2	04057283	69	\N	t	80.30	0.00	0.00	f
5239	7284	IMPRESORA HP OFFICEJET 6315 MULTIFUNCION CON 			f	t	\N	2	04267284	200	\N	t	197.67	0.00	0.00	f
5240	7286	HD 500 GB SATA2 WESTERN DIGITAL 7200 RPM 8 MB			f	t	\N	2	03167286	54	\N	t	111.95	0.00	0.00	f
3538	4800	ADAPT. CONCEP. USB 2.0 BLUETOOTH 100/200M CBT			f	t	\N	2	04234800	148	\N	t	13.67	0.00	0.00	f
5242	7288	RW DVD DUAL DL LG 20X8X20X GSA-H58N NEGRA OEM			f	t	\N	2	03227288	128	\N	t	25.29	0.00	0.00	f
5243	7289	CPU INTEL P DUALCORE E2180 2 GHZ FSB800 1MB			f	t	\N	2	03127289	50	\N	t	79.04	0.00	0.00	f
5295	7341	SOFT. ANTIVIRUS PANDA INTERNET SECURITY 2008 			f	t	\N	2	06037341	91	\N	t	67.30	0.00	0.00	f
5360	7406	IMPRESORA EPSON STYLUS PHOTO R285 USB 6 CART			f	t	\N	2	04037406	67	\N	t	101.11	0.00	0.00	f
5382	7429	PORT. HP 6720s T5470 2x512MB 160GB DVD-RW 15.			f	t	\N	2	02997429	204	\N	t	678.04	0.00	0.00	f
4977	6876	PANEL REPARTIDOR 24 UTP CAT.5E PU2515			f	t	\N	2	07066876	185	\N	t	63.78	0.00	0.00	f
4979	6883	CART. MAXTEC EPSON C62 CX3200 NEGRO T040			f	t	\N	2	08066883	132	\N	t	3.18	0.00	0.00	f
5235	7280	TONER IMP. LEXMARK X340/X342N NEGRO			f	t	\N	2	08097280	136	\N	t	71.58	0.00	0.00	f
3629	5113	ADAPTADOR D-LINK DBT-122 USB BLUETOOTH 10M			f	t	\N	2	04235113	148	\N	t	16.73	0.00	0.00	f
3656	5224	CART. CANON IP1600 2200 MP150 170 450 COLOR C			f	t	\N	2	08075224	133	\N	t	19.61	0.00	0.00	f
5141	7151	RATON NGS QUOLL WIRELESS OPTICAL USB BLANCO			f	t	\N	2	04087151	72	\N	t	14.88	0.00	0.00	f
2922	1580	ALTAVOCES NGS SOUNDBAND 200 PC BLANCO			f	t	\N	2	04061580	70	\N	t	7.65	0.00	0.00	f
3586	5014	HD 200 GB SATA2 SEAGATE 7200 RPM 8MB			f	t	\N	2	03165014	54	\N	t	57.49	0.00	0.00	f
4204	01	MANTENIMIENTO GIB			f	f	\N	2	020501	206	\N	\N	576.00	0.00	0.00	f
4240	03	PROGRAMACION BULMAGES			f	f	\N	2	020703	208	\N	\N	40.00	0.00	0.00	f
3198	3527	CINTA TRAVAN 40 CERTANCE  20/40GB			f	t	\N	2	08033527	101	\N	t	48.06	0.00	0.00	f
2831	0426	CABLE PS/2 M/M 1.8M			f	t	\N	2	09010426	106	\N	t	1.05	0.00	0.00	f
4121	6148	CAJA EXT. D-LINK DSM-G600 1X3.5" IDE LAN RJ45			f	t	\N	2	04196148	142	\N	t	275.94	0.00	0.00	f
3476	4608	ALTAVOCES NGS SPHERE 2.0 BLIND. MAGNET.			f	t	\N	2	04064608	70	\N	t	16.53	0.00	0.00	f
3377	4242	TFT 17"  HP L1740 PLATA NEGRO PL766AT			f	t	\N	2	04024242	66	\N	t	243.77	0.00	0.00	f
3679	5283	TFT 19"  BENQ FP91G+ 8MS DVI PLATA NEGRO			f	t	\N	2	04025283	66	\N	t	219.99	0.00	0.00	f
5335	7381	TFT 19"  BENQ FP92Wa 5MS PLATA NEGRO 1440 x 9			f	t	\N	2	04027381	66	\N	t	195.86	0.00	0.00	f
3809	5623	VENTILADOR K8 Y 775 SPIRE VERTICOOL II SP601B			f	t	\N	2	03135623	51	\N	t	26.37	0.00	0.00	f
3752	5455	ROUTER ADSL2-2+D-LINK 4 PUERTOS 10/100 DSL-52			f	t	\N	2	04045455	68	\N	t	56.23	0.00	0.00	f
5358	7404	MULTIP. VGA AMPLIF. 250 Mhz 2 MONITORES			f	t	\N	2	09027404	107	\N	t	34.72	0.00	0.00	f
4328	5208	GATEWAY D-LINK WIRELESS DI-624 4P 108Mbps 2.4			f	t	\N	2	04045208	68	\N	t	73.49	0.00	0.00	f
4772	6512	AURICULAR BOTON NGS MSX SUPREME			f	t	\N	2	09076512	189	\N	t	11.76	0.00	0.00	f
5336	7382	DESKTOP NGS INALAMBRICO TRAIL BLAZING OPTICAL			f	t	\N	2	04077382	71	\N	t	33.16	0.00	0.00	f
3589	5021	ALTAVOCES NGS CUBE 5.1 BLIND. MAGNET. MANDO			f	t	\N	2	04065021	70	\N	t	65.64	0.00	0.00	f
5025	6970	SVGA ASUS ATI RADEON 9250 AGP8X 128MB DVI TV			f	t	\N	2	03176970	55	\N	t	27.75	0.00	0.00	f
3110	3148	TECLADO USB NGS RED SKIN SPORT (ROJO)			f	t	\N	2	04073148	71	\N	t	12.42	0.00	0.00	f
3542	4814	TECLADO NUMERICO NGS USB KMAX NOTEBOOK CALC.			f	t	\N	2	04074814	71	\N	t	24.53	0.00	0.00	f
3246	3798	RATON NGS MINIJET BLUETOOTH P/ PORTATILES			f	t	\N	2	04083798	72	\N	t	53.18	0.00	0.00	f
3446	4515	ANTENA D-LINK ANT24-1800 18dBi EXTERIOR DIREC			f	t	\N	2	07014515	94	\N	t	168.95	0.00	0.00	f
3129	3236	T.RED PCI D-LINK WIRELESS LAN DWL-G520 108 MB			f	t	\N	2	07013236	94	\N	t	33.61	0.00	0.00	f
3309	3991	CART. HP NEGRO Nº20 DJ610C 640C C6614DE NEGRO			f	t	\N	2	08073991	133	\N	t	28.10	0.00	0.00	f
2968	2189	CART. FAX SAMSUNG SF-330 335 340 345 360 M40			f	t	\N	2	08072189	133	\N	t	30.25	0.00	0.00	f
4513	6377	RW DVD DUAL DL USB 2.0 HP LITEON 18X6X18X LIG			f	t	\N	2	04186377	121	\N	t	77.49	0.00	0.00	f
2901	1260	ARMARIO MURAL DE 16 PUERTOS MAXIOFFICE			f	t	\N	2	07041260	150	\N	t	86.10	0.00	0.00	f
2902	1263	KIT ARMARIO DE 16 PUERTOS			f	t	\N	2	07041263	150	\N	t	289.07	0.00	0.00	f
3194	3493	CAPTURADORA TV EXT. CONCEPTRONIC TV USB 2.0 B			f	t	\N	2	04203493	143	\N	t	72.04	0.00	0.00	f
3913	5860	PEN DRIVE 4 GB PNY USB 2.0 ATTACHE			f	t	\N	2	04275860	195	\N	t	68.30	0.00	0.00	f
3746	5444	PB INTEL SE7520BD2VD2 BRANDON 1 SCSI DDR2 DUA			f	t	\N	2	03115444	86	\N	t	465.49	0.00	0.00	f
2814	0056	MEMORIA DIMM SDRAM 256 MB 133MHZ MARCA			f	t	\N	2	03140056	52	\N	t	18.57	0.00	0.00	f
4463	6318	T.SONIDO CREATIVE SB X-FI ELITE PRO			f	t	\N	2	03206318	125	\N	t	341.58	0.00	0.00	f
3365	4181	RW DVD DUAL DL PHILIPS 16X4X16X 1640B NEGRA			f	t	\N	2	03224181	128	\N	t	34.23	0.00	0.00	f
3005	2467	CAPTURADORA PCI ANALOGICA AVERMEDIA EZ MAKER			f	t	\N	2	03242467	130	\N	t	49.96	0.00	0.00	f
3867	5755	CAJA SEMITORRE ATX 3326CA NEGRA USB+AUDIO			f	t	\N	2	03025755	31	\N	t	48.19	0.00	0.00	f
3715	5404	CAJA SERVIDOR SUPERMICRO SC733I-450B NEGRA			f	t	\N	2	03035404	32	\N	t	262.19	0.00	0.00	f
3716	5408	CAJA SERVIDOR INTEL SC5295BRP 500W 1+1 NEGRO			f	t	\N	2	03035408	32	\N	t	289.89	0.00	0.00	f
3847	5690	FUENTE DE ALI. TACENS 460W 13.5CM PLATA 0dB			f	t	\N	2	03105690	48	\N	t	70.00	0.00	0.00	f
5337	7383	MEMORIA COMPACT FLASH TAKE MS CF 1GB			f	t	\N	2	04277383	195	\N	t	10.96	0.00	0.00	f
5338	7384	IMPRESORA CANON PIXMA IP 1800 USB			f	t	\N	2	04037384	67	\N	t	43.61	0.00	0.00	f
3934	5890	SWITCH NETGEAR JFS524GE 24 PUERTOS 10/100			f	t	\N	2	07025890	95	\N	t	73.95	0.00	0.00	f
3812	5633	IMPRESORA HP F380 MULTIFUNCION USB Q8134A			f	t	\N	2	04265633	200	\N	t	66.54	0.00	0.00	f
4027	6024	PB GIGABYTE GA-945P-S3 S775 1006 PCIE DDR2 SA			f	t	\N	2	03116024	86	\N	t	88.99	0.00	0.00	f
4273	3292	DISQUETERA ALPS 3.5" 1,44 Mb NEGRA			f	t	\N	2	03153292	53	\N	t	5.43	0.00	0.00	f
3274	3897	DISQUETERA SONY 3.5" HD NEGRA			f	t	\N	2	03153897	53	\N	t	6.30	0.00	0.00	f
3240	3758	HD 200 GB ATA MAXTOR 7200 RPM 8MB			f	t	\N	2	03163758	54	\N	t	65.81	0.00	0.00	f
3979	5948	HD  80 GB SATA2 SEAGATE 7200 RPM 2MB			f	t	\N	2	03165948	54	\N	t	40.70	0.00	0.00	f
3204	3560	HD 160 GB ATA MAXTOR 7200 RPM 8MB			f	t	\N	2	03163560	54	\N	t	79.78	0.00	0.00	f
3132	3242	SWITCH D-LINK 24P 10/100/1000 DGS-1224T			f	t	\N	2	07023242	95	\N	t	385.42	0.00	0.00	f
2975	2249	SERV. IMPRESORA D-LINK 2 PUERTOS DP-300+			f	t	\N	2	07022249	95	\N	t	91.40	0.00	0.00	f
3859	5733	SVGA POWERCOLOR RADEON X1300 256MB PCI-E BULK			f	t	\N	2	03175733	55	\N	t	62.86	0.00	0.00	f
4406	6247	SWITCH NETGEAR FS726TGE 24P 10/100 +2P 1000 C			f	t	\N	2	07026247	95	\N	t	115.30	0.00	0.00	f
4154	6183	CONTROLADORA PCI 8 PTOS SERIE PCI 38			f	t	\N	2	03266183	186	\N	t	113.98	0.00	0.00	f
2893	1225	LATIGUILLO FTP CAT.5E DE 5 MTS IB7205			f	t	\N	2	07051225	188	\N	t	3.92	0.00	0.00	f
4541	14	HOSTING PLAN BASE BÁSICO			f	f	\N	2	020614	207	\N	\N	17.00	0.00	0.00	f
3203	3556	HD PORTATIL 40 GB SAMSUNG 2.5" 5400 RPM			f	t	\N	2	03273556	194	\N	t	47.92	0.00	0.00	f
3904	5845	MEMORIA SECURE DIGITAL GENERICA SD 1 GB			f	t	\N	2	04275845	195	\N	t	14.35	0.00	0.00	f
4054	6065	MEMORIA MEMORY STICK PRO DUO 2 GB TAKE MS BLK			f	t	\N	2	04276065	195	\N	t	50.23	0.00	0.00	f
5339	7385	TFT 19"  PHILIPS 190S8FB NEGRO 1280X1024 5MS 			f	t	\N	2	04027385	66	\N	t	204.23	0.00	0.00	f
5340	7386	TECLADO GENERICO NEGRO P/S2			f	t	\N	2	04077386	71	\N	t	2.57	0.00	0.00	f
4337	5363	REPRODUCTOR DIVX / DVD YAMADA CHILI STYLE 110			f	t	\N	2	13045363	198	\N	t	99.42	0.00	0.00	f
3386	4264	BOLSA CAMARA MONRAY ROCK 500			f	t	\N	2	13034264	199	\N	t	17.92	0.00	0.00	f
4347	5593	BATERIA CANON PARA CAMARAS IXUS 30 40 50 60 N			f	t	\N	2	13035593	199	\N	t	35.19	0.00	0.00	f
3861	5740	HD 160 GB SATA2 SEAGATE 7200RPM 2MB			f	t	\N	2	03165740	54	\N	t	46.02	0.00	0.00	f
4176	6209	CAMARA FOTOS BENQ C510 SLIM 5MP 2" 16MB SD OP			f	t	\N	2	13036209	199	\N	t	95.80	0.00	0.00	f
5341	7387	MEMORIA COMPACT FLASH HI SPEED TAKE MS CF 4GB			f	t	\N	2	04277387	195	\N	t	38.95	0.00	0.00	f
4704	6408	NEON CAJA KIT 2 X 30 cm ROJO CCKP2-30R INVERS			f	t	\N	2	09046408	109	\N	t	7.29	0.00	0.00	f
5342	7388	SOFT. WINDOWS 2003 SERVER ENTERPRISE R2SP2 25			f	t	\N	2	03307388	184	\N	t	2531.90	0.00	0.00	f
4705	6409	NEON CAJA KIT 2 X 30 cm UV CCKP2-30B INVERSOR			f	t	\N	2	09046409	109	\N	t	8.88	0.00	0.00	f
5343	7389	MEMORIA MMC-MOBILE TAKE MS 1 GB RS-MMC			f	t	\N	2	04277389	195	\N	t	10.01	0.00	0.00	f
4008	5996	TELEFONO VOIP NGS SKYPHONE			f	t	\N	2	13075996	203	\N	t	24.84	0.00	0.00	f
5344	7390	MEMORIA MULTIMEDIA CARD TAKE MS MMC PLUS 1GB			f	t	\N	2	04277390	195	\N	t	13.25	0.00	0.00	f
3619	5078	T.RED MINIPCI MSI WIRELESS MS6833A 54MBPS			f	t	\N	2	03345078	209	\N	t	15.36	0.00	0.00	f
2840	0636	ALFOMBRILLA NYLON AZUL (MPM BLAUW)			f	t	\N	2	09090636	192	\N	t	0.53	0.00	0.00	f
2882	1211	T.RED PCI CONCEPTRONIC 10/100 W.O.L. ( C100i 			f	t	\N	2	03291211	183	\N	t	5.19	0.00	0.00	f
2885	1215	LATIGUILLO UTP CAT.5E DE 0.5 MTS PL1000			f	t	\N	2	07051215	188	\N	t	0.78	0.00	0.00	f
2886	1216	LATIGUILLO UTP CAT.5E DE 1MT PL1001			f	t	\N	2	07051216	188	\N	t	1.06	0.00	0.00	f
2930	1603	ARCHIVADOR CD S NGS WALLETS SMART 28 U			f	t	\N	2	09101603	190	\N	t	6.54	0.00	0.00	f
4248	1888	MEMORIA DIMM SDRAM 512 MB KINGSTON 133 MHZ			f	t	\N	2	03141888	52	\N	t	51.18	0.00	0.00	f
2987	2377	AURICULAR CON MICROFONO NGS MS104			f	t	\N	2	09072377	189	\N	t	3.99	0.00	0.00	f
4582	2397	HUB USB NGS 6 PUERTOS			f	t	\N	2	04132397	80	\N	t	24.84	0.00	0.00	f
3318	4024	FUNDA PROT. CONECTOR RJ45 AZUL 10 Uds. TT 451			f	t	\N	2	07054024	188	\N	t	1.49	0.00	0.00	f
3320	4026	LATIGUILLO UTP CAT.5E DE 3 MTS NEGRO PL4003			f	t	\N	2	07054026	188	\N	t	1.73	0.00	0.00	f
4609	4159	BANDEJA KIT MAXIOFFICE 280X160 mm			f	t	\N	2	07064159	185	\N	t	8.72	0.00	0.00	f
3363	4167	CAJA EXT. HDD 3.5"  SATA/PATA USB 2.0 SATA SI			f	t	\N	2	04234167	148	\N	t	80.80	0.00	0.00	f
4614	4293	TONER IMP. SAMSUNG SCX 4216F			f	t	\N	2	08094293	136	\N	t	74.30	0.00	0.00	f
3400	4321	SIST. MANOS LIBRES TELF. NGS STYLESET			f	t	\N	2	09074321	189	\N	t	40.71	0.00	0.00	f
4616	4339	TONER IMP. HP LASERJET 4250/4350 Q5942X ALTA 			f	t	\N	2	08094339	136	\N	t	177.42	0.00	0.00	f
3403	4347	TONER IMP. HP LASERJET 1010 SERIES Q2612A			f	t	\N	2	08094347	136	\N	t	54.95	0.00	0.00	f
3412	4374	CART. HP COLOR Nº343 DESKJET 5740 C8766EE			f	t	\N	2	08074374	133	\N	t	17.73	0.00	0.00	f
4619	4376	HUB USB NGS 7 PUERTOS USB 2.0			f	t	\N	2	04134376	80	\N	t	24.01	0.00	0.00	f
3461	4572	CABLE ALIM. CPU-RED EN ANGULO 2 MTS AK 5018			f	t	\N	2	09014572	106	\N	t	2.89	0.00	0.00	f
4525	6391	PB INTEL S5000XVNSATA DXEON 667 DLAN PCIE SAT			f	t	\N	2	03116391	86	\N	t	528.24	0.00	0.00	f
4306	4629	ALTAVOCES CONCEPT. SOUND ON THE GO PORTAT CSO			f	t	\N	2	04064629	70	\N	t	8.58	0.00	0.00	f
3488	4655	BLISTER 1UD PILA CEGASA CR2032 LITIO 3V			f	t	\N	2	09024655	107	\N	t	0.55	0.00	0.00	f
4311	4736	CART. HP MAGENTA Nº82 DSJ500 DSJ800 C4912A			f	t	\N	2	08074736	133	\N	t	29.92	0.00	0.00	f
3007	2492	HD 160 GB ATA SEAGATE 7200 RPM 2MB			f	t	\N	2	03162492	54	\N	t	48.67	0.00	0.00	f
3532	4772	TONER IMP. EPSON ACULASER C1100/X11 CYAN			f	t	\N	2	08094772	136	\N	t	66.58	0.00	0.00	f
4371	6052	CAJA SEMITORRE ATX SMILODON NEGRA 12CM VENTAN			f	t	\N	2	03316052	197	\N	t	80.75	0.00	0.00	f
3599	5032	CART. JT CANON BJC6000 3000 6200 S400 AMARILL			f	t	\N	2	08065032	132	\N	t	4.22	0.00	0.00	f
3600	5033	CART. JT CANON BJC6000 3000 6200 FOT NEGRO C2			f	t	\N	2	08065033	132	\N	t	4.22	0.00	0.00	f
3601	5034	CART. JT CANON BJC6000 3000 6200 FOTO CYAN C2			f	t	\N	2	08065034	132	\N	t	4.22	0.00	0.00	f
3853	5707	SVGA SAPPHIRE RADEON X1300 512MB DDR2 PCI-E			f	t	\N	2	03175707	55	\N	t	101.66	0.00	0.00	f
3735	5430	CART. JT HP COLOR Nº23 DESKJET 710C M23			f	t	\N	2	08065430	132	\N	t	20.45	0.00	0.00	f
3737	5432	CART. JT HP COLOR Nº57 DESKJET 5550 M57			f	t	\N	2	08065432	132	\N	t	28.24	0.00	0.00	f
3739	5434	CART. JT HP COLOR Nº28 DESKJET 3420/3425 M28			f	t	\N	2	08065434	132	\N	t	19.47	0.00	0.00	f
3741	5436	PROMO RECARGA JT 1NEGRO + 1COLOR REGALO 1 NEG			f	t	\N	2	08065436	132	\N	t	18.84	0.00	0.00	f
3757	5469	VENTILACION TECHO ARMARIO 600X600 RV2660			f	t	\N	2	07065469	185	\N	t	120.48	0.00	0.00	f
3763	5480	HUB USB MINI CONCEPTRONIC 4 PTOS C4PUSB2			f	t	\N	2	04235480	148	\N	t	9.88	0.00	0.00	f
4345	5565	CABLE P.PARALELO 15 METROS AK1064			f	t	\N	2	09015565	106	\N	t	10.54	0.00	0.00	f
3788	5567	CART. EPSON C48 NEGRO C13T066140LB			f	t	\N	2	08075567	133	\N	t	6.70	0.00	0.00	f
3817	5642	ALTAVOCES NGS ICEFLOW PARA PORTATILES Y MP3			f	t	\N	2	04065642	70	\N	t	49.77	0.00	0.00	f
5346	7392	CAJA THERMALTAKE WING RS100 NEGRO VG1000BNS			f	t	\N	2	03027392	31	\N	t	40.83	0.00	0.00	f
3868	5757	CPU AMD ATHLON64 X2 4200+ AM2 2x(2.2Ghz 512KB			f	t	\N	2	03125757	50	\N	t	71.40	0.00	0.00	f
4355	5820	HD 320 GB SATA2 SEAGATE 7200 RPM 8MB			f	t	\N	2	03165820	54	\N	t	74.41	0.00	0.00	f
3893	5827	T.RED PCI D-LINK DFE-538TX 10/100 RJ45			f	t	\N	2	03295827	183	\N	t	7.16	0.00	0.00	f
4706	6410	MEMORIA MICRO SECURE DIGITAL 2GB KINGSTON SDC			f	t	\N	2	04276410	195	\N	t	22.05	0.00	0.00	f
4708	6412	MINI HUB USB NGS 4ONE 4 PTOS			f	t	\N	2	04136412	80	\N	t	8.23	0.00	0.00	f
4709	6413	BOLSA CAMARA MONRAY DUNE 400			f	t	\N	2	13036413	199	\N	t	27.96	0.00	0.00	f
4710	6414	BOLSA CAMARA MONRAY DUNE 200			f	t	\N	2	13036414	199	\N	t	12.39	0.00	0.00	f
3813	5634	PB INTEL D945PLRNL S775 PCIE DDR2 SATA2 LAN B			f	t	\N	2	03115634	86	\N	t	85.66	0.00	0.00	f
4173	6206	REPRODUCTOR MP3 RIMAX B-TWIN 2GB 1.8" MP4 WMA			f	t	\N	2	13046206	198	\N	t	60.12	0.00	0.00	f
4544	03	Instalacion del SO Linux			f	f	\N	2	010103	25	\N	\N	10.00	0.00	0.00	f
5347	7393	SVGA XFX G-FORCE 8400GS PCIE 512 DDR2 DVI TV			f	t	\N	2	03177393	55	\N	t	46.93	0.00	0.00	f
5348	7394	FA. 700W THERMALTAKE TOUGHPOWER 14CM 8 PIN PC			f	t	\N	2	03107394	48	\N	t	134.58	0.00	0.00	f
5027	6973	PANEL FRONTAL 19" GUIA CABLES 1U GLXJ1U			f	t	\N	2	07066973	185	\N	t	5.47	0.00	0.00	f
3925	5880	T.RED PCMCIA NETGEAR FA511 10/100			f	t	\N	2	04155880	82	\N	t	30.12	0.00	0.00	f
3999	5985	FUNDA MP3 NANO MONRAY PROTECH N2 NEGRA			f	t	\N	2	13045985	198	\N	t	7.71	0.00	0.00	f
4037	6041	TONER IMP. SAMSUNG ML-2010			f	t	\N	2	08096041	136	\N	t	69.81	0.00	0.00	f
5107	7108	GATEWAY FIREWALL VPN NETGEAR FVX538 8P 2PWAN			f	t	\N	2	07077108	220	\N	t	176.76	0.00	0.00	f
5108	7109	NAS NETGEAR READYNAS NV+ 1TB (2X500GB) GLAN T			f	t	\N	2	04197109	142	\N	t	1085.84	0.00	0.00	f
5349	7395	IMPRESORA HP LASERJET 1022N USB Q5913A			f	t	\N	2	04247395	173	\N	t	309.49	0.00	0.00	f
5359	7405	IMPRESORA CANON PIXMA MP 460 MULTIFUNCION			f	t	\N	2	04267405	200	\N	t	112.61	0.00	0.00	f
5353	7399	LECTOR C.B. METROLOGIC MK5502 OPTIMUS S USB P			f	t	\N	2	05037399	120	\N	t	693.95	0.00	0.00	f
4506	6370	IMPRESORA HP OFFICEJET 7210 MULTIFUNCION CON 			f	t	\N	2	04266370	200	\N	t	328.14	0.00	0.00	f
4394	6232	CART. MAXTEC EPSON C64 C86 CX3600 MAGENTA T04			f	t	\N	2	08066232	132	\N	t	3.83	0.00	0.00	f
4175	6208	SVGA G-FORCE FX7300GS 256 PCIE DDR2 HDTV DVI			f	t	\N	2	03176208	55	\N	t	38.93	0.00	0.00	f
5354	7400	IMPRESORA ETIQUETAS GODEX EZ-1200 PLUS			f	t	\N	2	05037400	120	\N	t	472.45	0.00	0.00	f
4561	16	HOSTING MENSUAL ANIMASEALOUNGE.COM			f	f	\N	2	020616	207	\N	\N	30.00	0.00	0.00	f
4564	01	LACIE ETHERNET DISK MINI 500 GB (Ref: 301138)			f	t	\N	2	041501	82	\N	\N	206.03	0.00	0.00	f
5355	7401	PUNTERO TABLETA DIGITALIZADORA NGS CAD			f	t	\N	2	04177401	116	\N	t	15.23	0.00	0.00	f
5356	7402	MANDO A DISTANCIA PARA ALTAVOCES HI SONIC NGS			f	t	\N	2	04067402	70	\N	t	14.14	0.00	0.00	f
4376	6199	ALTAVOCES LOGITECH X-540 5.1 70W RMS			f	t	\N	2	04066199	70	\N	t	79.01	0.00	0.00	f
4719	6437	PEN DRIVE 1 GB TAKE MS SLIMLINE USB 2.0			f	t	\N	2	04276437	195	\N	t	9.04	0.00	0.00	f
4172	6205	REPRODUCTOR MP3 RIMAX B-TWIN 1GB 1.8" MP4 WMA			f	t	\N	2	13046205	198	\N	t	49.28	0.00	0.00	f
4237	06	CONFIGURACION E INSTALACION OPENVPN			f	f	\N	2	020206	56	\N	\N	150.00	0.00	0.00	f
4773	6514	TONER IMP. CANON EP-87C LBP 2410 CYAN			f	t	\N	2	08096514	136	\N	t	87.54	0.00	0.00	f
4540	13	HOSTING PLAN BASE PROFESIONAL			f	f	\N	2	020613	207	\N	\N	30.00	0.00	0.00	f
5197	7232	CABLE DVI-D / HDMI 5Mts.M/M AK3795			f	t	\N	2	09017232	106	\N	t	36.95	0.00	0.00	f
5198	7233	RW DVD DUAL DL LG 20X8X18X GSA-H55N NEGRA OEM			f	t	\N	2	03227233	128	\N	t	24.53	0.00	0.00	f
3926	5881	KIT ADAPTADOR DE RED NETGEAR RED ELECT. A WIF			f	t	\N	2	07025881	95	\N	t	105.08	0.00	0.00	f
4711	6415	TABLETA DIGITALIZADORA NGS GRABADORA NOTAS D-			f	t	\N	2	04176415	116	\N	t	82.27	0.00	0.00	f
3256	3842	RATON LOGITECH PILOT  WHEEL OPT OEM S96 NEGRO			f	t	\N	2	04083842	72	\N	t	6.82	0.00	0.00	f
3664	5233	SOFT. OFFICE 2003 PYME OEM			f	t	\N	2	06025233	90	\N	t	238.45	0.00	0.00	f
3962	5921	MEMORIA MINI SECURE DIGITAL KINGSTON MINISD 1			f	t	\N	2	04275921	195	\N	t	13.69	0.00	0.00	f
4553	15	HOSTING ANUAL GIBPROMOCIONES.COM			f	f	\N	2	020615	207	\N	\N	360.00	0.00	0.00	f
4812	6588	CART. MAXTEC EPSON CYAN R360/265 RX560 T0802			f	t	\N	2	08066588	132	\N	t	5.13	0.00	0.00	f
4817	6593	CART. MAXTEC EPSON C60 NEGRO T028			f	t	\N	2	08066593	132	\N	t	5.19	0.00	0.00	f
4500	6363	RW DVD DUAL DL LG 18X8X16X GSA-H42N OEM			f	t	\N	2	03226363	128	\N	t	24.99	0.00	0.00	f
4560	12	MANTENIMIENTO ANUAL BULMAGES ZAIBATSU			f	f	\N	2	020512	206	\N	\N	120.00	0.00	0.00	f
4824	6605	PACK 8 ROLLOS PAPEL TICKET AUTOCOPIA 76.5 x 6			f	t	\N	2	05036605	120	\N	t	7.84	0.00	0.00	f
3456	4548	FUENTE DE ALI. 450W ( PIV ) ATX			f	t	\N	2	03104548	48	\N	t	17.35	0.00	0.00	f
2889	1219	LATIGUILLO UTP CAT.5E DE 5 MTS MARFIL PL1005			f	t	\N	2	07051219	188	\N	t	2.71	0.00	0.00	f
4881	6700	PEN DRIVE 4 GB GENERICO USB 2.0			f	t	\N	2	04276700	195	\N	t	30.12	0.00	0.00	f
4233	08	PAQUETE 6 DOMINIOS ESCUELA			f	f	\N	2	020608	207	\N	\N	70.00	0.00	0.00	f
4539	02	AVG Internet Security			f	f	\N	2	070702	220	\N	\N	46.90	0.00	0.00	f
2842	0680	CABLE USB 5MT A/B MM   SB2405			f	t	\N	2	09010680	106	\N	t	2.49	0.00	0.00	f
3144	3279	LATIGUILLO UTP CAT.5E AZUL 1.5M. PL2051			f	t	\N	2	07053279	188	\N	t	0.90	0.00	0.00	f
3067	2974	CART. HP NEGRO Nº56 DJ 5150 OJ 5510 C6656AE 1			f	t	\N	2	08072974	133	\N	t	14.99	0.00	0.00	f
3068	2975	CART. HP COLOR Nº57 PSC 2410 (C6657AE) 17 ml			f	t	\N	2	08072975	133	\N	t	25.17	0.00	0.00	f
4834	6617	CAJA SEMITORRE ATX SAGITTA PLATA ROJA VENTANA			f	t	\N	2	03026617	31	\N	t	55.12	0.00	0.00	f
2880	1173	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK			f	t	\N	2	09011173	106	\N	t	13.80	0.00	0.00	f
2852	0820	SOFT. WINDOWS XP PROFESIONAL OEM			f	t	\N	2	03300820	184	\N	t	138.35	0.00	0.00	f
4186	02	BROTHER TINTA COLOR MULTIFUNCION DCP-130			t	t	\N	2	042902	217	\N	\N	87.00	0.00	0.00	f
4183	01	BROTHER MULTIFUNCION LASER MONOCROMO DCP-7025			t	t	\N	2	042901	217	\N	\N	263.80	0.00	0.00	f
4721	6440	REPRODUCTOR HD CONCEPTRONIC MULTIMEDIA 400 GB			f	t	\N	2	13046440	198	\N	t	183.52	0.00	0.00	f
4722	6441	TELEFONO VOIP NGS BLUESKYPHONE INALAMBRICO			f	t	\N	2	13076441	203	\N	t	45.70	0.00	0.00	f
3457	4555	CINTA EPSON LQ SERIES NEGRO #7753 (C13S015021			f	t	\N	2	08054555	103	\N	t	5.88	0.00	0.00	f
4992	6912	CABLE HD IDE 80 HILOS 40 PIN 3 CONECTORES DMA			f	t	\N	2	03016912	28	\N	t	4.70	0.00	0.00	f
2917	1479	CABLE P.PARALELO 1.8 MTS AK1062			f	t	\N	2	09011479	106	\N	t	2.41	0.00	0.00	f
2939	1634	VENTILADOR ADICIONAL COOLBOX 8X8 8025M12SA PO			f	t	\N	2	03011634	28	\N	t	2.00	0.00	0.00	f
5225	7269	RATON NGS EVO WIRELESS V2 OPTICAL USB			f	t	\N	2	04087269	72	\N	t	12.37	0.00	0.00	f
5296	7342	LATIGUILLO FIBRA OPTICA VF-45 ST DE 5 MTS			f	t	\N	2	07057342	188	\N	t	84.82	0.00	0.00	f
4835	6618	CAJA EXT. ICY BOX 2.5" IDE USB 2.0 IB-220U-WH			f	t	\N	2	04236618	148	\N	t	15.98	0.00	0.00	f
2896	1248	ROSETA RJ45 CAT. 5E UTP 2 TOMAS FS 4210			f	t	\N	2	07051248	188	\N	t	3.77	0.00	0.00	f
3364	4176	TAMBOR OKI C5100 5300 SERIES CYAN			f	t	\N	2	08094176	136	\N	t	106.95	0.00	0.00	f
3963	5922	CAJA MICRO ATX ENLIGHT PM2411 NEGRA USB AUDIO			f	t	\N	2	03025922	31	\N	t	38.25	0.00	0.00	f
3989	5968	CAMARA WEB LOGITECH QUICKCAM FUSION GRIS			f	t	\N	2	04115968	75	\N	t	81.31	0.00	0.00	f
4018	6009	CART. EPSON RX420 RX420 RX520 PACK 4 COLORES			f	t	\N	2	08076009	133	\N	t	28.47	0.00	0.00	f
3825	5652	LATIGUILLO UTP CAT.5E DE 15 MTS MARFIL PL 101			f	t	\N	2	07055652	188	\N	t	8.13	0.00	0.00	f
5297	7343	SVGA XFX G-FORCE 7300GT 512 ULTRA SILENT PCIE			f	t	\N	2	03177343	55	\N	t	64.81	0.00	0.00	f
4836	6620	CABLE VGA M/M 10M APANTALLADO FERRITA AK4269			f	t	\N	2	09016620	106	\N	t	20.24	0.00	0.00	f
4848	6651	CART. EPSON MAGENTA RX700 T559340 13ML			f	t	\N	2	08076651	133	\N	t	11.34	0.00	0.00	f
5298	7344	UNIDAD DE CINTA SONY AIT I390ST 150/390GB SAT			f	t	\N	2	04197344	142	\N	t	1372.39	0.00	0.00	f
4928	6772	CART. MAXTEC PIXMA CYAN CLI-8C MP500 800 IP 4			f	t	\N	2	08066772	132	\N	t	3.57	0.00	0.00	f
3332	4070	CART. HP COLOR Nº58 (C6658AE) 17 ml			f	t	\N	2	08074070	133	\N	t	19.54	0.00	0.00	f
4929	6773	CART. MAXTEC PIXMA MAGENTA CLI-8M MP500 800 I			f	t	\N	2	08066773	132	\N	t	3.57	0.00	0.00	f
4930	6774	CART. MAXTEC PIXMA AMARILL CLI-8Y MP500 800 I			f	t	\N	2	08066774	132	\N	t	3.57	0.00	0.00	f
4931	6775	CART. MAXTEC PIXMA CYAN CLARO CLI-8PC MP500 I			f	t	\N	2	08066775	132	\N	t	3.57	0.00	0.00	f
5299	7345	SOFT. WINDOWS 2003 SERVER SBS INGLES SP2 R2 5			f	t	\N	2	03307345	184	\N	t	447.18	0.00	0.00	f
3453	4531	CART. EPSON D68 D88 DX3800 AMARILLO T061440LB			f	t	\N	2	08074531	133	\N	t	7.96	0.00	0.00	f
3261	3857	HUB USB UH-275 MINI 4 PTOS. USB 2.0 SB 2110			f	t	\N	2	04133857	80	\N	t	24.65	0.00	0.00	f
4023	6015	ALTAVOCES CONCEPTRONIC 2.1 SPEAKERSET CLLSPK2			f	t	\N	2	04066015	70	\N	t	32.89	0.00	0.00	f
4723	6444	ALTAVOCES NGS SOUNDBAND 200 PC PLATA + HEADSE			f	t	\N	2	04066444	70	\N	t	13.22	0.00	0.00	f
4725	6446	TECLADO NGS PLANET MULTIMEDIA			f	t	\N	2	04076446	71	\N	t	16.64	0.00	0.00	f
3431	4443	ARCHIVADOR CD S NGS WALLETS CAR 12 U			f	t	\N	2	09104443	190	\N	t	3.82	0.00	0.00	f
3328	4051	RATON LOGITECH PILOT  WHEEL OPT OEM S96 BLANC			f	t	\N	2	04084051	72	\N	t	7.60	0.00	0.00	f
4629	4797	LEC. TARJ. USB 2.0 INTERNO 3.5" NEGRO OEM			f	t	\N	2	03154797	53	\N	t	9.07	0.00	0.00	f
4049	6057	REPRODUCTOR MP3 RIMAX D-LUXE 2GB MP4 LCD 1.8"			f	t	\N	2	13046057	198	\N	t	57.71	0.00	0.00	f
3816	5641	AURICULAR CON MICRO NGS STARMIX MEDIA + HUB M			f	t	\N	2	09075641	189	\N	t	10.90	0.00	0.00	f
3818	5643	RATON NGS NEO PRO OPTICO USB			f	t	\N	2	04085643	72	\N	t	6.57	0.00	0.00	f
3819	5644	RATON NGS NEO WIRELESS OPTICAL USB			f	t	\N	2	04085644	72	\N	t	16.53	0.00	0.00	f
3820	5645	CAMARA WEB NGS BUBBLE 300K USB 1.1			f	t	\N	2	04115645	75	\N	t	24.88	0.00	0.00	f
3821	5646	CAMARA WEB NGS BULLS EYE CHAT 300K USB + HEAD			f	t	\N	2	04115646	75	\N	t	24.84	0.00	0.00	f
3822	5647	SPRAYER KIT MALETIN STELLA + RATON KITSCH GRA			f	t	\N	2	09105647	190	\N	t	40.71	0.00	0.00	f
4310	4701	SOFT. ANTIVIRUS McAFEE ACTIVE VIRUSSCAN SMB 5			f	t	\N	2	06034701	91	\N	t	278.84	0.00	0.00	f
4124	6151	SOFT. EDICION FOTOGRAFICA PAINT SHOP PRO PHOT			f	t	\N	2	06036151	91	\N	t	11.63	0.00	0.00	f
4096	6120	BOLSA CAMARA NGS SHEATH ROJA			f	t	\N	2	13036120	199	\N	t	7.71	0.00	0.00	f
3917	5865	SOFT. NORTON INTERNET SECURITY 2007			f	t	\N	2	06035865	91	\N	t	68.77	0.00	0.00	f
4116	6142	SOFT. ANTIVIRUS PANDA 2007 + FIREWALL + ACT. 			f	t	\N	2	06036142	91	\N	t	34.15	0.00	0.00	f
4165	6196	SOFT. ANTIVIRUS McAFEE ACTIVE VIRUSSCAN SMB C			f	t	\N	2	06036196	91	\N	t	35.94	0.00	0.00	f
4429	6280	SOFT. ANTIVIRUS NORTON 2007 RETAIL 3 USUARIOS			f	t	\N	2	06036280	91	\N	t	58.47	0.00	0.00	f
3906	5847	SOFT. ANTIVIRUS McAFEE VIRUSSCAN PLUS 2007			f	t	\N	2	06035847	91	\N	t	34.33	0.00	0.00	f
3241	3769	BOBINA 50 CD S VERBATIM 700 MB 52X CRYSTAL S-			f	t	\N	2	08013769	99	\N	t	27.07	0.00	0.00	f
3061	2931	PACK 10 DVD+RW VERBATIM 4.7 GB 4X DATALIFE			f	t	\N	2	08022931	100	\N	t	17.61	0.00	0.00	f
4256	2675	CINTA DAT HP 4mm 125M DDS-3 24GB			f	t	\N	2	08032675	101	\N	t	4.66	0.00	0.00	f
4421	6270	CARTUCHO LIMPIADOR HP AIT Q1996A			f	t	\N	2	08036270	101	\N	t	26.17	0.00	0.00	f
3064	2965	DISCO REMOVIBLE IOMEGA REV DE 35GB			f	t	\N	2	08042965	102	\N	t	43.46	0.00	0.00	f
3310	3994	REJILLA VENTILADOR 8CM CCFL ESPIRAL LED AZUL			f	t	\N	2	09043994	109	\N	t	4.41	0.00	0.00	f
2825	0414	CABLE VGA M/H 1.8M (EXTENSION) AK3220			f	t	\N	2	09010414	106	\N	t	2.98	0.00	0.00	f
3142	3277	ADAPTADOR USB A TECLADO Y RATON PS2 KO1030			f	t	\N	2	09013277	106	\N	t	6.27	0.00	0.00	f
3323	4029	CABLE VGA M/M 5M PROTECCIONES METALICAS AK923			f	t	\N	2	09014029	106	\N	t	12.37	0.00	0.00	f
2916	1448	CABLE SERIE EXT. 9 PINES ( DB-9 ) M/H 3 MTS			f	t	\N	2	09011448	106	\N	t	3.05	0.00	0.00	f
3583	4993	CABLE VGA M/M 5M PROTECC. METAL.Y FERR. AK953			f	t	\N	2	09014993	106	\N	t	12.86	0.00	0.00	f
3584	5011	CABLE VGA M/M 5M APANTALLADO FERRITA AK4265			f	t	\N	2	09015011	106	\N	t	8.35	0.00	0.00	f
2856	0963	CABLE P.PARALELO DB-25 M-M 3 MTS. AK 4016			f	t	\N	2	09010963	106	\N	t	4.73	0.00	0.00	f
2848	0774	DATA SWITCH manual 4X1 4PC/1mon/1tec/1rat			f	t	\N	2	09020774	107	\N	t	29.75	0.00	0.00	f
2960	2099	SOPORTE CPU CON RUEDAS CS3AL			f	t	\N	2	09022099	107	\N	t	8.84	0.00	0.00	f
2988	2378	REGLETA NGS SURGE TEL 200 2 TOMAS + FAX			f	t	\N	2	09022378	107	\N	t	8.23	0.00	0.00	f
2845	0764	DATA SWITCH MANUAL 4X1 DB25H DAV 14			f	t	\N	2	09020764	107	\N	t	8.89	0.00	0.00	f
3197	3526	TRANSFORMADOR DC/AC COCHE RIMAX CAR INVERTER			f	t	\N	2	09023526	107	\N	t	26.53	0.00	0.00	f
4282	3855	REGLETA 4 TOMAS CONECTOR PARA SAI BNS 1204			f	t	\N	2	09023855	107	\N	t	2.27	0.00	0.00	f
3265	3873	DATA SWITCH MANUAL 4X1 USB SD6030			f	t	\N	2	09023873	107	\N	t	10.54	0.00	0.00	f
3283	3925	KVM MINI USB AUTO CON CABLES 2 CPU S SB7020			f	t	\N	2	09023925	107	\N	t	51.92	0.00	0.00	f
4292	4122	CARGADOR DE PILAS AA/AAA RIMAX COOL CHARGER 2			f	t	\N	2	09024122	107	\N	t	19.04	0.00	0.00	f
3373	4214	REGLETA CYBERPOWER NOTEBOOK SURGE PROTECTOR			f	t	\N	2	09024214	107	\N	t	13.84	0.00	0.00	f
3481	4619	REGLETA MONRAY POWER STRIP 3 TOMAS SIN INTERR			f	t	\N	2	09024619	107	\N	t	3.05	0.00	0.00	f
3214	3633	BLISTER 4UDS PILAS CEGASA LR03 SUPER ALKALINE			f	t	\N	2	09023633	107	\N	t	3.07	0.00	0.00	f
4323	5124	CABLE KVM 3 EN 1 2XPS2 M/M 1XVGA M/H 2M AK 31			f	t	\N	2	09025124	107	\N	t	7.39	0.00	0.00	f
3632	5125	CABLE KVM 3 EN 1 2XPS2 M/H 1XVGA M/H 5M AK 31			f	t	\N	2	09025125	107	\N	t	13.42	0.00	0.00	f
4329	5215	CABLE KVM 3 EN 1 2XPS2 M/M 1XVGA M/M 2Mts. AK			f	t	\N	2	09025215	107	\N	t	6.78	0.00	0.00	f
2846	0766	DATA SWITCH AUTO 4X1 DB25H (AB 5414)			f	t	\N	2	09020766	107	\N	t	58.73	0.00	0.00	f
3747	5449	BACKPLANE 6 HOT SWAP SC5300/5275 DISCOS SATA			f	t	\N	2	09025449	107	\N	t	181.14	0.00	0.00	f
4150	6179	RAISER PCI HP PARA DC7700 DC7600 ULTRA SLIM			f	t	\N	2	09026179	107	\N	t	25.60	0.00	0.00	f
3149	3329	LUZ PARA PORTATIL NGS ALIMENTADA POR USB			f	t	\N	2	09023329	107	\N	t	12.39	0.00	0.00	f
3151	3331	CONTROL REMOTO NGS LASER RECEPTOR USB TARGET			f	t	\N	2	09023331	107	\N	t	41.46	0.00	0.00	f
2853	0843	GOTAS DE RESINA 25 x 25 (CUADRADAS)			f	t	\N	2	09030843	108	\N	t	0.33	0.00	0.00	f
3525	4753	DISIPADOR COBRE PARA MEMORIA THERMALTAKE A213			f	t	\N	2	09044753	109	\N	t	9.18	0.00	0.00	f
3773	5520	LIQUIDO REFRIGERANTE THERMALTAKE ULTRAVIOLETA			f	t	\N	2	09045520	109	\N	t	7.76	0.00	0.00	f
3019	2568	BATERIA DE PORTATIL M30N3-MCY23			f	t	\N	2	02042568	58	\N	t	108.96	0.00	0.00	f
2999	2395	HUB USB NGS SWITCH 2 A 4 PUERTOS			f	t	\N	2	04132395	80	\N	t	16.53	0.00	0.00	f
3000	2396	HUB USB NGS 4 PUERTOS 2.0 480 MBPS			f	t	\N	2	04132396	80	\N	t	36.61	0.00	0.00	f
3172	3410	HUB USB NGS 4 PUERTOS 2.0 TINY CON O SIN ALIM			f	t	\N	2	04133410	80	\N	t	16.53	0.00	0.00	f
3173	3411	HUB USB NGS TRAVEL HUB 4 PUERTOS PORTATIL			f	t	\N	2	04133411	80	\N	t	12.39	0.00	0.00	f
2996	2392	HUB USB NGS 4 PUERTOS			f	t	\N	2	04132392	80	\N	t	15.70	0.00	0.00	f
2998	2394	HUB USB NGS 4 PUERTOS VERTICAL			f	t	\N	2	04132394	80	\N	t	21.60	0.00	0.00	f
2861	0973	SAI NGS 350 CHRONUS OFF LINE			f	t	\N	2	04140973	81	\N	t	53.93	0.00	0.00	f
3410	4372	HUB USB NGS 3 PUERTOS + LEC. TARJ.			f	t	\N	2	04134372	80	\N	t	28.25	0.00	0.00	f
3910	5852	REPET. SEÑAL VIDEO/AUDIO RIMAX VIDEOSENDER CO			f	t	\N	2	09025852	107	\N	t	39.76	0.00	0.00	f
3471	4592	SAI NGS PROWAVE 2000 RACK			f	t	\N	2	04144592	81	\N	t	1008.77	0.00	0.00	f
3473	4600	SAI NGS RHINO 2000 RACK			f	t	\N	2	04144600	81	\N	t	1195.73	0.00	0.00	f
3561	4872	SAI NGS RHINO 3000 RACK			f	t	\N	2	04144872	81	\N	t	1694.28	0.00	0.00	f
3654	5221	SAI NGS RHINO 3000			f	t	\N	2	04145221	81	\N	t	1577.90	0.00	0.00	f
4374	6178	SAI NGS RHINO 1500 ONLINE			f	t	\N	2	04146178	81	\N	t	730.37	0.00	0.00	f
4333	5313	HD EXT. LAN+USB2.0 250 GB CONCEPTRONIC NETWOR			f	t	\N	2	04195313	142	\N	t	160.30	0.00	0.00	f
2871	1083	T.RED PCMCIA CONCEPTRONIC 10/100 CSP100TCL			f	t	\N	2	04151083	82	\N	t	23.43	0.00	0.00	f
3181	3433	ALTAVOCES NGS SOUNDBAND 200 NEGRO			f	t	\N	2	04063433	70	\N	t	7.65	0.00	0.00	f
3205	3568	HD EXT. USB 80 GB "HANDYDRIVE" SLIM USB2.0			f	t	\N	2	04193568	142	\N	t	84.43	0.00	0.00	f
3537	4796	ALTAVOCES RIMAX  MINI M-SPEAKERS			f	t	\N	2	04064796	70	\N	t	10.24	0.00	0.00	f
3472	4594	ALTAVOCES LOGITECH Z-5500 5.1 DIGITAL 500W RM			f	t	\N	2	04064594	70	\N	t	371.57	0.00	0.00	f
3463	4584	ALTAVOCES NGS BEAT 2.1 SUBWOOFER			f	t	\N	2	04064584	70	\N	t	18.20	0.00	0.00	f
4097	6121	BOLSA CAMARA NGS SHEATH AZUL			f	t	\N	2	13036121	199	\N	t	7.71	0.00	0.00	f
3213	3622	ALTAVOCES NGS SUPRA 2.1 POWERED SUBWOOFER			f	t	\N	2	04063622	70	\N	t	16.54	0.00	0.00	f
3228	3669	ALTAVOCES NGS SOUNDMASTER 5.1 CON MANDO			f	t	\N	2	04063669	70	\N	t	65.64	0.00	0.00	f
3689	5343	ALTAVOCES NGS MINIMAL 2.1 SUBWOOFER			f	t	\N	2	04065343	70	\N	t	27.34	0.00	0.00	f
4041	6046	ALTAVOCES LOGITECH Z-5450 5.1 WIRELESS DIGITA			f	t	\N	2	04066046	70	\N	t	328.17	0.00	0.00	f
3769	5502	TABLETA DIGITALIZADORA WACOM GRAPHIRE4 CLASSI			f	t	\N	2	04175502	116	\N	t	202.24	0.00	0.00	f
4327	5206	TFT 17"  COMPASS NV721CF PLATA MM 16MS			f	t	\N	2	04025206	66	\N	t	150.60	0.00	0.00	f
4498	6361	TFT 19" SONY SDM-G96D NEGRO 1280X1024 2ms DVI			f	t	\N	2	04026361	66	\N	t	303.54	0.00	0.00	f
4508	6372	TFT 42" TV LG 42PC1RV XD ENGINE 852X480 MM HD			f	t	\N	2	04026372	66	\N	t	1216.87	0.00	0.00	f
3460	4570	IMPRESORA HP DESKJET 5940 A4 USB C9017B			f	t	\N	2	04034570	67	\N	t	69.00	0.00	0.00	f
4272	3263	ROUTER VPN SERVER D-LINK 4P/ 1PWAN/ DI-804HV			f	t	\N	2	04043263	68	\N	t	76.17	0.00	0.00	f
4354	5793	GATEWAY CONCEPTRONIC C100BRS4H SWITCH 4P + FI			f	t	\N	2	04045793	68	\N	t	26.40	0.00	0.00	f
4486	6344	ROUTER ADSL2+ CONCEPTRONIC + 4 PTS LAN 100MB 			f	t	\N	2	04046344	68	\N	t	56.65	0.00	0.00	f
3146	3305	TFT 15"  LG L1510BF TACTIL PLATEADO			f	t	\N	2	04023305	66	\N	t	522.08	0.00	0.00	f
3830	5661	KVM D-LINK DKVM-2K 2 PUERTOS PS2 AUTO + CABLE			f	t	\N	2	09025661	107	\N	t	20.08	0.00	0.00	f
3832	5668	CAJA MICRO ATX DM318 NEGRO PLATA 220W			f	t	\N	2	03025668	31	\N	t	55.30	0.00	0.00	f
3924	5878	TFT 20" ACER AL2017 PLATA NEGRO 8ms MM			f	t	\N	2	04025878	66	\N	t	306.55	0.00	0.00	f
3829	5658	TFT 17" SONY SDM-E76D NEGRO 1280X1024 8ms DVI			f	t	\N	2	04025658	66	\N	t	217.20	0.00	0.00	f
4091	6115	TFT 17"  AOC LM765A 8MS PLATA NEGRO MM			f	t	\N	2	04026115	66	\N	t	166.40	0.00	0.00	f
4168	6200	TFT 20" BELINEA 2025 S1 PLATA NEGRO 8ms MM			f	t	\N	2	04026200	66	\N	t	312.31	0.00	0.00	f
4451	6305	TFT 19"  HANNS·G HX191DP 5MS PLATA NEGRO MM D			f	t	\N	2	04026305	66	\N	t	179.25	0.00	0.00	f
4102	6127	TFT 19"  RYOKU / YURAKU MW9KBA 8MS NEGRO MM P			f	t	\N	2	04026127	66	\N	t	188.93	0.00	0.00	f
5300	7346	SVGA ATI RADEON ASUS X1050 256/1GB HM DVI TV 			f	t	\N	2	03177346	55	\N	t	37.25	0.00	0.00	f
3570	4923	IMPRESORA HP OFFICEJET PRO K550 DTN USB2.0 RJ			f	t	\N	2	04034923	67	\N	t	288.88	0.00	0.00	f
4105	6130	IMPRESORA EPSON PICTUREMATE 100 PAPEL 10X15CM			f	t	\N	2	04036130	67	\N	t	99.31	0.00	0.00	f
3833	5669	IMPRESORA HP DESKJET D2360 A4 USB C9079A			f	t	\N	2	04035669	67	\N	t	51.61	0.00	0.00	f
3834	5670	IMPRESORA EPSON STYLUS PHOTO R240			f	t	\N	2	04035670	67	\N	t	80.64	0.00	0.00	f
3977	5946	IMPRESORA CANON PIXMA IP 1700			f	t	\N	2	04035946	67	\N	t	51.61	0.00	0.00	f
3837	5676	CAMARA WEB LOGITECH QUICKCAM CHAT UPGRADE			f	t	\N	2	04115676	75	\N	t	20.43	0.00	0.00	f
4466	6321	IMPRESORA CANON PIXMA IP 4300 USB			f	t	\N	2	04036321	67	\N	t	105.64	0.00	0.00	f
4253	2432	GATEWAY D-LINK DI-604 ( SWITCH 4P + FIREWALL)			f	t	\N	2	04042432	68	\N	t	40.16	0.00	0.00	f
4259	2770	ROUTER ADSL CONCEPTRONIC + 4 PUERTOS LAN 100M			f	t	\N	2	04042770	68	\N	t	47.93	0.00	0.00	f
3838	5677	CAMARA WEB LOGITECH QUICKCAM CONNECT (UPGRADE			f	t	\N	2	04115677	75	\N	t	32.53	0.00	0.00	f
3449	4522	LATIGUILLO UTP CAT.5E ROJO 1 Mt. PL3001			f	t	\N	2	07054522	188	\N	t	0.94	0.00	0.00	f
3244	3777	MODEM 56K SERIE U.S.ROBOTICS 205630 V.90 V.92			f	t	\N	2	04043777	68	\N	t	61.20	0.00	0.00	f
3854	5710	ROUTER ADSL2+ SMC WIRELESS 7904WBRA2 + SWITCH			f	t	\N	2	04045710	68	\N	t	86.25	0.00	0.00	f
3985	5961	MODEM 56K SERIE U.S.ROBOTICS 805631A V.90 V.9			f	t	\N	2	04045961	68	\N	t	45.05	0.00	0.00	f
3831	5665	GATEWAY D-LINK DI-524UP WIRELESS 54 + 4XRJ45 			f	t	\N	2	04045665	68	\N	t	59.04	0.00	0.00	f
3923	5877	ROUTER ADSL2+ CONCEPTRONIC + 4 PUERTOS LAN 10			f	t	\N	2	04045877	68	\N	t	47.98	0.00	0.00	f
4099	6123	DESKTOP NGS INALAMBRICO STYLISHPRO SLIM USB			f	t	\N	2	04076123	71	\N	t	46.53	0.00	0.00	f
3944	5901	ROUTER ADSL NETGEAR WIFI MIMO DG834PNFS + SWI			f	t	\N	2	04045901	68	\N	t	118.31	0.00	0.00	f
3450	4523	LATIGUILLO UTP CAT.5E VERDE 1 Mt. PL2501			f	t	\N	2	07054523	188	\N	t	0.76	0.00	0.00	f
3826	5653	LATIGUILLO UTP CAT.5E ROJO 1.5 Mt. PL3051			f	t	\N	2	07055653	188	\N	t	0.90	0.00	0.00	f
4303	4517	ESCANER HP SCANJET 4850 48bits USB2.0 4800x96			f	t	\N	2	04054517	69	\N	t	152.24	0.00	0.00	f
4427	6276	ESCANER DE MANO IRISLINK IRISPEN EXPRESS OCR			f	t	\N	2	04056276	69	\N	t	124.33	0.00	0.00	f
3846	5689	VENTILADOR TACENS GELUS INTEL Y AMD 9dB			f	t	\N	2	03135689	51	\N	t	27.71	0.00	0.00	f
5302	7348	IMPRESORA CANON PIXMA MP 210 MULTIFUNCION			f	t	\N	2	04267348	200	\N	t	81.60	0.00	0.00	f
4428	6278	ESCANER EPSON PERFECTION V700 PHOTO USB FIREW			f	t	\N	2	04056278	69	\N	t	611.58	0.00	0.00	f
3158	3339	DESKTOP NGS WIRELESS SET OPTICAL PS/2			f	t	\N	2	04073339	71	\N	t	27.86	0.00	0.00	f
3359	4148	DESKTOP LOGITECH CORDLESS ULTRAX MEDIA OEM			f	t	\N	2	04074148	71	\N	t	48.19	0.00	0.00	f
3109	3147	TECLADO NGS 108 MULTIMEDIA NEGRO PS2 (WEBMAST			f	t	\N	2	04073147	71	\N	t	8.23	0.00	0.00	f
3494	4667	DESKTOP LOGITECH DINOVO MEDIA DESKTOP LASER			f	t	\N	2	04074667	71	\N	t	187.45	0.00	0.00	f
3851	5698	KIT POWER OVER ETHERNET D-LINK DWL-P200			f	t	\N	2	07055698	188	\N	t	42.17	0.00	0.00	f
3495	4670	DESKTOP LOGITECH CORDLESS S510 REMOTE			f	t	\N	2	04074670	71	\N	t	67.39	0.00	0.00	f
4149	6177	DESKTOP LOGITECH CORDLESS MX3200 LASER			f	t	\N	2	04076177	71	\N	t	83.53	0.00	0.00	f
3245	3797	TECLADO NUMERICO NGS PLUS KEYPAD CALCULATOR			f	t	\N	2	04073797	71	\N	t	20.52	0.00	0.00	f
4460	6315	DESKTOP LOGITECH CORDLESS ULTRAX MEDIA REMOTE			f	t	\N	2	04076315	71	\N	t	46.63	0.00	0.00	f
3505	4689	TECLADO NGS SLIM MULTIMEDIA BLANCO USB			f	t	\N	2	04074689	71	\N	t	16.53	0.00	0.00	f
3712	5401	RATON NGS OPTICAL KITSCH GRAFFITTI P/ PORTATL			f	t	\N	2	04085401	72	\N	t	14.05	0.00	0.00	f
2978	2271	RATON LOGITECH PILOT  WHEEL OPTICAL OEM B58 N			f	t	\N	2	04082271	72	\N	t	9.13	0.00	0.00	f
2926	1588	RATON NGS PS/2 NOTEBOOK OPTICAL VIPMOUSE			f	t	\N	2	04081588	72	\N	t	6.93	0.00	0.00	f
3504	4688	TECLADO NGS ICEPLANET OFFICE 125 TECLAS MM US			f	t	\N	2	04074688	71	\N	t	16.53	0.00	0.00	f
3168	3405	RATON NGS LASER MOUSE OPTICO INALAMBRICO			f	t	\N	2	04083405	72	\N	t	18.60	0.00	0.00	f
3267	3875	RATON NGS SYMBIOSIS POWERED NEGRO			f	t	\N	2	04083875	72	\N	t	3.49	0.00	0.00	f
4293	4128	RATON GENERICO WHITE OPTICO PS2			f	t	\N	2	04084128	72	\N	t	4.02	0.00	0.00	f
3354	4134	RATON LOGITECH MX 518 OPTICAL MOUSE USB/PS2			f	t	\N	2	04084134	72	\N	t	48.08	0.00	0.00	f
3499	4675	RATON LOGITECH G5 LASER MOUSE			f	t	\N	2	04084675	72	\N	t	65.48	0.00	0.00	f
5304	7350	PORT. SAMSUNG P500 T7250 1GB 120GB DVD-RW 15.			f	t	\N	2	02997350	204	\N	t	900.01	0.00	0.00	f
3500	4678	RATON LOGITECH LX5 CORDLESS OPTICAL MOUSE GRI			f	t	\N	2	04084678	72	\N	t	24.53	0.00	0.00	f
3503	4687	RATON NGS BLACK PLUME MOUSE OPTICO INALAMBRIC			f	t	\N	2	04084687	72	\N	t	24.10	0.00	0.00	f
3183	3443	RATON NGS BEETLE OPTICO USB			f	t	\N	2	04083443	72	\N	t	11.55	0.00	0.00	f
3573	4941	RATON LOGITECH G7 CORDLESS LASER MOUSE			f	t	\N	2	04084941	72	\N	t	80.77	0.00	0.00	f
2877	1111	RATON LOGITECH MARBLE MOUSE OPTICAL			f	t	\N	2	04081111	72	\N	t	29.83	0.00	0.00	f
3189	3462	RATON LOGITECH MX 1000 LASER CORDLESS MOUSE			f	t	\N	2	04083462	72	\N	t	57.78	0.00	0.00	f
3498	4673	RATON LOGITECH MINI OPTICAL MOUSE PORTATILES 			f	t	\N	2	04084673	72	\N	t	24.73	0.00	0.00	f
4028	6026	RATON LOGITECH MINI OPTICAL MOUSE PORTATILES 			f	t	\N	2	04086026	72	\N	t	24.73	0.00	0.00	f
3170	3407	GAMEPAD NGS SPITFIRE VIBRACION 6 BOTONES Y 2 			f	t	\N	2	04093407	73	\N	t	15.81	0.00	0.00	f
3196	3501	GAMEPAD LOGITECH CORDLESS RUMBLEPAD 2			f	t	\N	2	04093501	73	\N	t	39.59	0.00	0.00	f
3169	3406	GAMEPAD NGS STARFIGHTER ERGONOMICO 8 BOTONES			f	t	\N	2	04093406	73	\N	t	6.98	0.00	0.00	f
3427	4438	GAMEPAD NGS V2 INALAMBRICO 12 BOTONES VIBRA U			f	t	\N	2	04094438	73	\N	t	35.65	0.00	0.00	f
5305	7351	CARTUCHO LIMPIADOR SDX 1-CL SONY AIT 3			f	t	\N	2	08037351	101	\N	t	31.34	0.00	0.00	f
3407	4364	CAMARA WEB LOGITECH QUICKCAM COMMUNICATE STX 			f	t	\N	2	04114364	75	\N	t	56.76	0.00	0.00	f
2869	1027	CAMARA WEB LABTEC WEBCAM -RETAIL-			f	t	\N	2	04111027	75	\N	t	11.29	0.00	0.00	f
4009	5999	OFERTA NGS WEBCAM SHOWCAM PLUS + GAMEPAD SPIT			f	t	\N	2	04115999	75	\N	t	24.84	0.00	0.00	f
3011	2533	ANTENA D-LINK ANT24-0800 8dBi EXTERIOR OMNIDI			f	t	\N	2	07012533	94	\N	t	110.78	0.00	0.00	f
3778	5537	SERVIDOR DE IMPRESORA CANON  BLUETOOTH USB			f	t	\N	2	07015537	94	\N	t	67.69	0.00	0.00	f
4507	6371	ACCESS POINT NETGEAR WG302GE WIRELESS 108M PR			f	t	\N	2	07016371	94	\N	t	258.81	0.00	0.00	f
4249	1950	FA. 24V EPSON PS-180 TM-T88 U295 L60 L90 SERI			f	t	\N	2	05031950	120	\N	t	43.88	0.00	0.00	f
4294	4165	CABLE D-LINK PROLONGACION ANTENA SMA MH WIFI 			f	t	\N	2	07014165	94	\N	t	16.61	0.00	0.00	f
3125	3228	ACCESS POINT D-LINK DWL-2100AP WIRELESS 108Mb			f	t	\N	2	07013228	94	\N	t	77.11	0.00	0.00	f
5306	7352	PB ECS GEFORCE6100SM-M AM2 VGA PCIE DDR2 6CH 			f	t	\N	2	03327352	196	\N	t	41.83	0.00	0.00	f
3849	5695	SERV. IMPRESORA D-LINK 4P USB 2.0 DPR-1260 WI			f	t	\N	2	07015695	94	\N	t	138.55	0.00	0.00	f
3957	5914	T.RED PCMCIA NETGEAR WIRELESS LAN WPN511FS 10			f	t	\N	2	07015914	94	\N	t	44.37	0.00	0.00	f
4472	6330	T.RED USB LINKSYS WIRELESS WUSBF54G 2.4 GHz 5			f	t	\N	2	07016330	94	\N	t	75.28	0.00	0.00	f
3526	4756	SWITCH 3COM 8P.10/100 DUALSPEED 3C16791A			f	t	\N	2	07024756	95	\N	t	48.02	0.00	0.00	f
4315	4805	ADAPTADOR DE RED CONNECTION RED ELECTRICA A R			f	t	\N	2	07024805	95	\N	t	67.86	0.00	0.00	f
3243	3776	SWITCH 3COM 24 PUERTOS 10/100/1000 SSTACK3 42			f	t	\N	2	07023776	95	\N	t	306.86	0.00	0.00	f
3931	5887	SWITCH NETGEAR FS605FS 5 PUERTOS 10/100			f	t	\N	2	07025887	95	\N	t	14.01	0.00	0.00	f
3947	5904	SERV. IMPRESORA NETGEAR 2P USB WIRELESS + 4P 			f	t	\N	2	07025904	95	\N	t	116.10	0.00	0.00	f
3704	5382	RECARGA JT CART. UNIV. COLOR 3X30ML  + 1XLIMP			f	t	\N	2	08065382	132	\N	t	11.04	0.00	0.00	f
3738	5433	CART. JT HP NEGRO Nº27 DESKJET 3420/3425 M27			f	t	\N	2	08065433	132	\N	t	13.54	0.00	0.00	f
2858	0969	CART. JT EPSON 880/880T COLOR (T020401) E31			f	t	\N	2	08060969	132	\N	t	5.84	0.00	0.00	f
2859	0970	CART. JT EPSON 880/880T NEGRO 5683JB E30			f	t	\N	2	08060970	132	\N	t	3.25	0.00	0.00	f
2865	1009	CART. JT EPSON C70/C80/C82/CX5200 NEGRO E45			f	t	\N	2	08061009	132	\N	t	11.04	0.00	0.00	f
2866	1010	CART. JT EPSON C70/C80 CYAN 6613CJB E46c			f	t	\N	2	08061010	132	\N	t	7.14	0.00	0.00	f
2867	1011	CART. JT EPSON C70/C80 MAGENTA 6613MJB E46m			f	t	\N	2	08061011	132	\N	t	7.14	0.00	0.00	f
2868	1012	CART. JT EPSON C70/C80 AMARILLO 6613YJB E46y			f	t	\N	2	08061012	132	\N	t	7.14	0.00	0.00	f
2881	1179	CART. JT EPSON 870 915 890 895 5813JB E35/75 			f	t	\N	2	08061179	132	\N	t	9.10	0.00	0.00	f
2909	1367	CART. JT EPSON 1270 1280 1290 COLOR (T009401)			f	t	\N	2	08061367	132	\N	t	11.37	0.00	0.00	f
2910	1369	CART. JT EPSON 480 580 C20 C40 NEGRO (T013401			f	t	\N	2	08061369	132	\N	t	3.25	0.00	0.00	f
2920	1570	CART. JT EPSON 400 440 640 700 NEGRO 3323JB E			f	t	\N	2	08061570	132	\N	t	3.25	0.00	0.00	f
2947	1759	CART. JT EPSON 200/500 COLOR 2903JB			f	t	\N	2	08061759	132	\N	t	8.86	0.00	0.00	f
3020	2602	CART. JT EPSON PHOTO 700/750 COLOR 3383JB E17			f	t	\N	2	08062602	132	\N	t	6.17	0.00	0.00	f
3021	2603	CART. JT EPSON PHOTO 810/820/830 COLOR 8933JB			f	t	\N	2	08062603	132	\N	t	9.10	0.00	0.00	f
3022	2604	CART. JT EPSON PHOTO 810/830 NEGRO 892JB E79			f	t	\N	2	08062604	132	\N	t	7.47	0.00	0.00	f
4342	5519	IMPRESORA HP DESKJET 6940 A4 USB RJ45 C8970B			f	t	\N	2	04035519	67	\N	t	118.69	0.00	0.00	f
3028	2656	CART. JT EPSON C82/CX5200/5400 AMARILLO E86Y-			f	t	\N	2	08062656	132	\N	t	7.14	0.00	0.00	f
3034	2698	CART. JT EPSON 400/440/640/740 COLOR 334JB E1			f	t	\N	2	08062698	132	\N	t	5.84	0.00	0.00	f
3035	2699	CART. JT EPSON C42/C44/C46 COLOR 886JC E73			f	t	\N	2	08062699	132	\N	t	9.10	0.00	0.00	f
3036	2700	CART. JT EPSON C42/C44/C46 NEGRO 885JB E72			f	t	\N	2	08062700	132	\N	t	7.47	0.00	0.00	f
3073	3009	CART. JT EPSON PHOTO 950 NEGRO (C13T033140) E			f	t	\N	2	08063009	132	\N	t	7.81	0.00	0.00	f
3074	3010	CART. JT EPSON PHOTO 950 CYAN (C13T033240) E4			f	t	\N	2	08063010	132	\N	t	7.81	0.00	0.00	f
3075	3011	CART. JT EPSON PHOTO 950 CYAN CLARO(T033540) 			f	t	\N	2	08063011	132	\N	t	7.81	0.00	0.00	f
3076	3012	CART. JT EPSON PHOTO 950 MAGENTA CLARO E47LM			f	t	\N	2	08063012	132	\N	t	7.81	0.00	0.00	f
3078	3014	CART. JT EPSON PHOTO 950 AMARILLO (C13T033440			f	t	\N	2	08063014	132	\N	t	7.81	0.00	0.00	f
3081	3017	CART. JT EPSON NEGRO R200/RX500 C13T048140 E9			f	t	\N	2	08063017	132	\N	t	6.82	0.00	0.00	f
3083	3019	CART. JT EPSON MAGENTA R200/RX500 C13T048340 			f	t	\N	2	08063019	132	\N	t	6.82	0.00	0.00	f
3141	3268	CART. JT EPSON CYAN CLARO 48540 E92LC  R200/3			f	t	\N	2	08063268	132	\N	t	6.82	0.00	0.00	f
3448	4521	R53 CHIP RESETEADOR NIVEL DE TINTA PARA CART 			f	t	\N	2	08064521	132	\N	t	11.69	0.00	0.00	f
3511	4704	CART. JT EPSON D68 D88 DX3800 DX4800 CYAN E10			f	t	\N	2	08064704	132	\N	t	4.55	0.00	0.00	f
3512	4705	CART. JT EPSON D68 D88 DX3800 DX4800 MAGENTA 			f	t	\N	2	08064705	132	\N	t	4.55	0.00	0.00	f
3605	5038	CART. JT RECL LEXMARK Z4X Z5X X63 X7X NEGRO M			f	t	\N	2	08065038	132	\N	t	22.40	0.00	0.00	f
3611	5044	CART. JT RECL LEXMARK Z13 Z2X Z3X COLOR ML26			f	t	\N	2	08065044	132	\N	t	23.37	0.00	0.00	f
3622	5081	OFERTA JET TEC C62 COLOR Y NEGRO +1 NEGRO GRA			f	t	\N	2	08065081	132	\N	t	16.88	0.00	0.00	f
3645	5178	CART. JT EPSON STYLUS R800 NEGRO MATE E93MB			f	t	\N	2	08065178	132	\N	t	8.12	0.00	0.00	f
3840	5680	PACK CART. JT EPSON C44/C46 2xNEGRO 1xCOLOR E			f	t	\N	2	08065680	132	\N	t	16.23	0.00	0.00	f
3026	2654	CART. JT EPSON 870/1270/1290 NEGRO 887JB E74			f	t	\N	2	08062654	132	\N	t	8.12	0.00	0.00	f
3044	2778	CART. JT EPSON C64 C66 C84 C86 CX6400 NEGRO E			f	t	\N	2	08062778	132	\N	t	6.82	0.00	0.00	f
3045	2779	CART. JT EPSON C64 C66 C84 C86 CX6400 CYAN E8			f	t	\N	2	08062779	132	\N	t	6.82	0.00	0.00	f
3046	2780	CART. JT EPSON C64/C66 C84/C86 6400 MAGENTA E			f	t	\N	2	08062780	132	\N	t	6.82	0.00	0.00	f
3047	2781	CART. JT EPSON C64/84 C66/C86 6400 AMARILLO E			f	t	\N	2	08062781	132	\N	t	6.82	0.00	0.00	f
3072	3000	CART. JT EPSON 400 800 800+ 1000 NEGRO 973JB 			f	t	\N	2	08063000	132	\N	t	4.94	0.00	0.00	f
3235	3722	CART. JT EPSON STYLUS RX420 RX 425 AMARILLO E			f	t	\N	2	08063722	132	\N	t	5.19	0.00	0.00	f
3514	4707	CART. JT EPSON D68 D88 DX3800 DX4800 NEGRO E1			f	t	\N	2	08064707	132	\N	t	4.55	0.00	0.00	f
3612	5045	CART. JT RECL LEXMARK JPR Z800 AIO X5200 NEGR			f	t	\N	2	08065045	132	\N	t	17.53	0.00	0.00	f
3620	5079	OFERTA JET TEC C64 3 COLORES +1 NEGRO GRATIS			f	t	\N	2	08065079	132	\N	t	20.45	0.00	0.00	f
3736	5431	CART. JT HP NEGRO Nº56 DESKJET 5550 M56			f	t	\N	2	08065431	132	\N	t	13.63	0.00	0.00	f
3839	5679	PACK CART. JT EPSON 400 800 2xNEGRO 1xCOLOR E			f	t	\N	2	08065679	132	\N	t	9.10	0.00	0.00	f
3013	2541	CART. JT EPSON C60 COLOR (T029401) E51			f	t	\N	2	08062541	132	\N	t	9.10	0.00	0.00	f
3135	3253	CART. JT HP COLOR Nº78 DJ PS OJ PSC M78			f	t	\N	2	08063253	132	\N	t	19.47	0.00	0.00	f
3136	3254	CART. JT HP NEGRO Nº15 3820C (C6615) M15			f	t	\N	2	08063254	132	\N	t	11.69	0.00	0.00	f
3138	3256	CART. JT HP COLOR Nº17 840 845C (C6625) M17			f	t	\N	2	08063256	132	\N	t	18.41	0.00	0.00	f
3140	3267	CART. JT EPSON MAGENTA CLARO 48640 E92LM R200			f	t	\N	2	08063267	132	\N	t	6.82	0.00	0.00	f
3642	5175	CART. JT EPSON STYLUS R800 CYAN E93C			f	t	\N	2	08065175	132	\N	t	8.12	0.00	0.00	f
3644	5177	CART. JT EPSON STYLUS R800 OPTIMIZADOR E93G			f	t	\N	2	08065177	132	\N	t	4.55	0.00	0.00	f
2857	0967	CART. JT EPSON 680/777 NEGRO (T017401) E32			f	t	\N	2	08060967	132	\N	t	10.06	0.00	0.00	f
2860	0972	CART. JT EPSON C60 NEGRO (T028401) E50			f	t	\N	2	08060972	132	\N	t	7.47	0.00	0.00	f
2914	1431	CART. JT EPSON C62 COLOR (C13T041040)			f	t	\N	2	08061431	132	\N	t	12.05	0.00	0.00	f
2955	1919	CART. JT EPSON 740 760 860 1520 NEGRO 333JC E			f	t	\N	2	08061919	132	\N	t	3.25	0.00	0.00	f
3722	5416	CART. JT BROTHER LC900 MFC 210C 620N NEGRO B2			f	t	\N	2	08065416	132	\N	t	4.48	0.00	0.00	f
3723	5417	CART. JT BROTHER LC900 MFC 210C 620N CYAN B2C			f	t	\N	2	08065417	132	\N	t	4.48	0.00	0.00	f
3724	5418	CART. JT BROTHER LC900 MFC 210C 620N MAGENTA 			f	t	\N	2	08065418	132	\N	t	4.49	0.00	0.00	f
3725	5419	CART. JT BROTHER LC900 MFC 210C 620N AMARILLO			f	t	\N	2	08065419	132	\N	t	4.49	0.00	0.00	f
3841	5681	PACK CART. JT EPSON C62 2xNEGRO 1xCOLOR E70E7			f	t	\N	2	08065681	132	\N	t	16.23	0.00	0.00	f
3842	5682	PACK CART. JT EPSON R200/RX500 RAINBOW E92BCM			f	t	\N	2	08065682	132	\N	t	30.52	0.00	0.00	f
5307	7353	ACC. SENSOR DE MOVIMIENTO RIMAX SECURITY PHON			f	t	\N	2	13057353	202	\N	t	38.27	0.00	0.00	f
4127	6154	CART. CANON IP6600 PHOTO MAGENTA CLI8PM			f	t	\N	2	08076154	133	\N	t	11.07	0.00	0.00	f
3290	3941	CART. HP CYAN Nº40 DJ1200 DSJ 230 250C 51640C			f	t	\N	2	08073941	133	\N	t	29.73	0.00	0.00	f
3292	3943	CART. HP AMARILLO Nº40 DJ1200 DSJ 230 250C 51			f	t	\N	2	08073943	133	\N	t	29.73	0.00	0.00	f
4285	3951	CART. EPSON R800 AMARILLO C13T054440			f	t	\N	2	08073951	133	\N	t	14.99	0.00	0.00	f
4295	4297	CART. EPSON PH 810 830 830U 925 935 NE (T0264			f	t	\N	2	08074297	133	\N	t	31.04	0.00	0.00	f
4296	4299	CART. EPSON PH 810 830 830U 925 935 COLOR (T0			f	t	\N	2	08074299	133	\N	t	27.28	0.00	0.00	f
3401	4326	CART. EPSON C42 C44 C46 NEGRO (T036140)			f	t	\N	2	08074326	133	\N	t	16.59	0.00	0.00	f
3556	4861	CART. EPSON RX420 PACK 4 COLORES			f	t	\N	2	08074861	133	\N	t	29.92	0.00	0.00	f
3648	5181	CART. JT EPSON STYLUS R800 AMARILLO E93Y			f	t	\N	2	08075181	133	\N	t	7.22	0.00	0.00	f
3302	3957	CART. EPSON R800 OPTIM. BRILLO C13T054040			f	t	\N	2	08073957	133	\N	t	8.00	0.00	0.00	f
3452	4530	CART. EPSON D68 D88 DX3800 CYAN T061240B0			f	t	\N	2	08074530	133	\N	t	8.18	0.00	0.00	f
3454	4532	CART. EPSON D68 D88 DX3800 NEGRO T061140LB			f	t	\N	2	08074532	133	\N	t	8.24	0.00	0.00	f
3779	5538	CABEZAL IMPRESION DESINGJET 130 90 30 Nº85 AM			f	t	\N	2	08075538	133	\N	t	29.77	0.00	0.00	f
3289	3940	CART. HP NEGRO Nº40 DJ1200 DSJ 230 250C 51640			f	t	\N	2	08073940	133	\N	t	25.43	0.00	0.00	f
4338	5372	CART. EPSON PACK 6 TINTAS R300/RX500 C13T0481			f	t	\N	2	08075372	133	\N	t	59.92	0.00	0.00	f
3299	3954	CART. EPSON R800 CYAN C13T054940			f	t	\N	2	08073954	133	\N	t	14.43	0.00	0.00	f
3300	3955	CART. EPSON R800 NEGRO FOTO C13T054140			f	t	\N	2	08073955	133	\N	t	14.55	0.00	0.00	f
3301	3956	CART. EPSON R800 NEGRO MATE C13T054840			f	t	\N	2	08073956	133	\N	t	14.41	0.00	0.00	f
2819	0316	LECTOR C.B. CCD-83 INFRARROJOS TECLADO PS2			f	t	\N	2	05030316	120	\N	t	44.52	0.00	0.00	f
4283	3859	VISOR VFD 450 2 LINEAS NEGRO			f	t	\N	2	05033859	120	\N	t	96.06	0.00	0.00	f
2820	0317	TECLADO REDUCIDO TPV ACK-700			f	t	\N	2	05030317	120	\N	t	22.24	0.00	0.00	f
4245	0319	VISOR VFD 450 2 LINEAS			f	t	\N	2	05030319	120	\N	t	97.01	0.00	0.00	f
4143	6171	SOFT. LICENCIA D-LINK NETWORK SECURITY VPN 1 			f	t	\N	2	04046171	68	\N	t	42.78	0.00	0.00	f
4052	6061	RW DVD DUAL DL USB 2.0 LITEON 16X4X16X SHM-16			f	t	\N	2	04186061	121	\N	t	62.84	0.00	0.00	f
3770	5516	TONER IMP. HP LASERJET 2500 1500 NEGRO C9700A			f	t	\N	2	08095516	136	\N	t	70.95	0.00	0.00	f
4268	2977	TONER IMP. HP LASERJET 2500 1500 AMARILLO C97			f	t	\N	2	08092977	136	\N	t	92.73	0.00	0.00	f
4271	3252	TONER IMP. HP LASERJET 4200 INTELIGENTE (Q133			f	t	\N	2	08093252	136	\N	t	129.66	0.00	0.00	f
2864	1007	TONER IMP. SAMSUNG ML-1210/1250			f	t	\N	2	08091007	136	\N	t	69.40	0.00	0.00	f
4288	4033	TONER IMP. HP LASERJET 2410/20/30 SERIES Q651			f	t	\N	2	08094033	136	\N	t	104.87	0.00	0.00	f
4346	5577	TONER IMP. HP LASERJET 4300 SERIES Q1339A			f	t	\N	2	08095577	136	\N	t	172.37	0.00	0.00	f
2835	0444	TONER IMP. SAMSUNG ML-6060			f	t	\N	2	08090444	136	\N	t	110.94	0.00	0.00	f
4287	4018	TONER IMP. EPSON EPL-5900 EPL-6100 ALTA CAPAC			f	t	\N	2	08094018	136	\N	t	112.22	0.00	0.00	f
3968	5934	TONER IMP. EPSON ACULASER C900 C1900 MAGENTA 			f	t	\N	2	08095934	136	\N	t	84.46	0.00	0.00	f
4512	6376	PAPEL A4 FOTO BRILLO 180GRS 20 UDS OCI4888			f	t	\N	2	08106376	137	\N	t	7.01	0.00	0.00	f
3090	3070	PAPEL A4 210 GRS. BRILLO-MATE 12 UDS OCI4722			f	t	\N	2	08103070	137	\N	t	6.45	0.00	0.00	f
3091	3073	ETIQUETAS CD PERMANENTES 200 UDS. DLW1796			f	t	\N	2	08103073	137	\N	t	9.22	0.00	0.00	f
3093	3075	ETIQUETAS CD BLANCO OPACO 50 UDS OLW4827			f	t	\N	2	08103075	137	\N	t	5.60	0.00	0.00	f
3094	3076	ETIQUETAS CD PLATA METAL. PMTES. 20UDS OLW479			f	t	\N	2	08103076	137	\N	t	10.28	0.00	0.00	f
3095	3077	CARATULAS CD SIN LOMO 12 UDS OCI3340			f	t	\N	2	08103077	137	\N	t	4.89	0.00	0.00	f
3096	3078	TARJS. VISITA BL. RECTO 85x54 200GRS 150U OCC			f	t	\N	2	08103078	137	\N	t	8.81	0.00	0.00	f
3097	3079	TARJS. VISITA BLANCO 85x45 200 GRS 180 UDS OC			f	t	\N	2	08103079	137	\N	t	7.02	0.00	0.00	f
3098	3080	TARJS. VISITA BL ESPESOR 85x45 160GRS 100U OC			f	t	\N	2	08103080	137	\N	t	7.02	0.00	0.00	f
3099	3081	TARJS. VISITA BRILLO-MATE 210GRS 48U OCI4723			f	t	\N	2	08103081	137	\N	t	5.63	0.00	0.00	f
3272	3892	PAPEL A4 120 GRS. MATE 200 UDS DCI1867			f	t	\N	2	08103892	137	\N	t	10.63	0.00	0.00	f
4082	6103	ETIQUETAS CD BLANCO ULTRABLANCO 60 UDS OLW479			f	t	\N	2	08106103	137	\N	t	4.96	0.00	0.00	f
2970	2224	ETIQUETAS BLANCAS PARA PRESS IT 50 U.			f	t	\N	2	08102224	137	\N	t	5.19	0.00	0.00	f
3089	3069	PAPEL A4 FOTO BRILLO 260GRS 10 UDS OCI4863			f	t	\N	2	08103069	137	\N	t	6.02	0.00	0.00	f
3092	3074	ETIQUETAS CD CALIDAD FOTO PMTES. 24 UDS OLW47			f	t	\N	2	08103074	137	\N	t	7.72	0.00	0.00	f
3120	3203	TONER IMP. EPSON ACULASER C900 C1900 NEGRO			f	t	\N	2	08093203	136	\N	t	49.39	0.00	0.00	f
3131	3241	CAJA EXT.CONCEPTRONIC 5.25"IDE USB 2.0 IDE			f	t	\N	2	04233241	148	\N	t	30.33	0.00	0.00	f
3284	3926	CAJA EXT. KEPLER 3.5" IDE FIREWIRE+ USB KE201			f	t	\N	2	04233926	148	\N	t	53.87	0.00	0.00	f
3546	4823	LEC. TARJ. USB 2.0 INTERNO 3.5" NEGRO BLA PLA			f	t	\N	2	04234823	148	\N	t	6.82	0.00	0.00	f
3765	5484	LEC. TARJ. 19 EN 1 PNY XD USB 2.0 EXT			f	t	\N	2	04235484	148	\N	t	13.17	0.00	0.00	f
3423	4430	RATON NGS CRUSADER 2 BOTONES PS2			f	t	\N	2	04084430	72	\N	t	2.71	0.00	0.00	f
3918	5867	LEC. TARJ. 21 EN 1 SPIRE USB 2.0 EXT SP150			f	t	\N	2	04235867	148	\N	t	10.86	0.00	0.00	f
3031	2669	ARMARIO RACK MKS 19" 42U 600X800			f	t	\N	2	07042669	150	\N	t	895.82	0.00	0.00	f
3100	3096	ARMARIO RACK 19" 6U 1 CUERPO SERIE EVO 600x36			f	t	\N	2	07043096	150	\N	t	119.83	0.00	0.00	f
3101	3097	ARMARIO RACK 19" 9U F400 RK2109			f	t	\N	2	07043097	150	\N	t	231.04	0.00	0.00	f
3182	3437	ARMARIO RACK 19" RK9100 42U PUERTA 600X1000			f	t	\N	2	07043437	150	\N	t	1261.66	0.00	0.00	f
3482	4624	ARMARIO RACK 19" 33U 600X800 RK 4133			f	t	\N	2	07044624	150	\N	t	765.41	0.00	0.00	f
3707	5385	ARMARIO RACK 19" 2 CUERPO 9U 500 mm RK 3109			f	t	\N	2	07045385	150	\N	t	282.07	0.00	0.00	f
4420	6269	ARMARIO RACK 19" 1 CUERPO 12U 400 mm RK 2112			f	t	\N	2	07046269	150	\N	t	248.76	0.00	0.00	f
2967	2185	GARANTIA ON SITE SERVIDOR 3 AÑOS			f	t	\N	2	10052185	187	\N	t	130.80	0.00	0.00	f
3378	4245	EXTENSION DE GARANTIA THINKCLIENT HP 3 AÑOS 1			f	t	\N	2	10054245	187	\N	t	69.46	0.00	0.00	f
3988	5966	GATEWAY D-LINK DI-524 WIRELESS 54 + 4XRJ45			f	t	\N	2	04045966	68	\N	t	52.20	0.00	0.00	f
4652	5705	CONTROLADORA PCMCIA CONNECTION 2 PUERTOS FIRE			f	t	\N	2	03265705	186	\N	t	21.27	0.00	0.00	f
4653	5706	MEMORIA DIMM DDR2 1024MB 800MHz KINGSTON CL5			f	t	\N	2	03145706	52	\N	t	34.30	0.00	0.00	f
3855	5711	ADAPTADOR DIVISOR DE AUDIO JACK 3.5 mm 1xM / 			f	t	\N	2	09015711	106	\N	t	0.48	0.00	0.00	f
4654	5715	MEMORIA SO DIMM DDR2 1GB 667MHz KINGSTON			f	t	\N	2	03285715	193	\N	t	24.51	0.00	0.00	f
3637	5154	IMPRESORA CANON LASER LBP3200 USB			f	t	\N	2	04245154	173	\N	t	176.27	0.00	0.00	f
4083	6106	IMPRESORA HP LASERJET COLOR 4700DN A4 RJ45			f	t	\N	2	04246106	173	\N	t	2111.82	0.00	0.00	f
4061	6074	IMPRESORA HP LASERJET P2015 CB366A USB 26ppm			f	t	\N	2	04246074	173	\N	t	249.42	0.00	0.00	f
4136	6164	CAJA MICRO ATX FOXCONN GTLM073 300 USB SIN FU			f	t	\N	2	03026164	31	\N	t	35.81	0.00	0.00	f
3871	5770	CAJA SERVIDOR INTEL SC2400 2U DRISKILL NEGRO 			f	t	\N	2	03035770	32	\N	t	862.49	0.00	0.00	f
4034	6036	CAJA SERVIDOR INTEL SC5295UP PILOT POINT 3 NE			f	t	\N	2	03036036	32	\N	t	247.30	0.00	0.00	f
3574	4954	CAJA SERVIDOR SUPERMICRO SC742S-420 NEGRA			f	t	\N	2	03034954	32	\N	t	366.51	0.00	0.00	f
3635	5137	CAJA SERVIDOR SUPERMICRO SC743I-R760B NEGRA			f	t	\N	2	03035137	32	\N	t	607.48	0.00	0.00	f
3974	5942	HD 250 GB ATA SEAGATE 7200 RPM 16MB			f	t	\N	2	03165942	54	\N	t	73.70	0.00	0.00	f
5308	7354	ACC. SENSOR MAG. VENTANA PUERTA RIMAX SECURIT			f	t	\N	2	13057354	202	\N	t	20.98	0.00	0.00	f
4320	5010	PB INTEL D945PVS S775 PCIE DDR2 SATA2 GLAN BL			f	t	\N	2	03115010	86	\N	t	128.75	0.00	0.00	f
2815	0057	MEMORIA DIMM SDRAM 512 MB 133MHZ MARCA			f	t	\N	2	03140057	52	\N	t	38.34	0.00	0.00	f
3315	4014	CPU AMD SEMPRON 2800+ S754 1.6Ghz 256KB BOX			f	t	\N	2	03124014	50	\N	t	40.40	0.00	0.00	f
4336	5358	HD  73 GB USCSI-320 FUJITSU 10000RPM 68PIN RO			f	t	\N	2	03165358	54	\N	t	166.65	0.00	0.00	f
4497	6360	HD 250 GB SATA2 WESTERN DIGITAL 7200 RPM 8MB			f	t	\N	2	03166360	54	\N	t	70.80	0.00	0.00	f
4258	2734	SVGA GFORCE 4 MX4000 128 DDR TV DVI AGP8X			f	t	\N	2	03172734	55	\N	t	28.60	0.00	0.00	f
4067	6081	SVGA G-FORCE 7950GT PCIE 512DDR3 DUAL DVI TV			f	t	\N	2	03176081	55	\N	t	291.70	0.00	0.00	f
4341	5501	MEMORIA SO DIMM DDR2 1GB 400MHz KINGSTON			f	t	\N	2	03285501	193	\N	t	78.98	0.00	0.00	f
4356	5821	HD PORTATIL 60 GB FUJITSU 2.5" 5400RPM 8M			f	t	\N	2	03275821	194	\N	t	55.69	0.00	0.00	f
4487	6346	HD PORTATIL 80 GB HITACHI 5400RPM 8MB			f	t	\N	2	03276346	194	\N	t	62.42	0.00	0.00	f
3627	5102	PB EPOX 8HDAI PRO S754 AGP SATA SON LAN DDR40			f	t	\N	2	03325102	196	\N	t	60.25	0.00	0.00	f
3814	5638	KIT DSL-924 ROUTER ADSL D-LINK WIFI+ADAP USB 			f	t	\N	2	04045638	68	\N	t	87.35	0.00	0.00	f
2838	0551	CONTROLADORA 2 PUERTOS PARALELO PCI 32 BITS			f	t	\N	2	03260551	186	\N	t	29.77	0.00	0.00	f
4280	3785	CAJA COOLBOX CASE PRO TR05 PLATA 350W			f	t	\N	2	03313785	197	\N	t	69.88	0.00	0.00	f
3226	3661	FRONTAL NEGRO CD-ROM LITEON			f	t	\N	2	03183661	123	\N	t	0.13	0.00	0.00	f
2940	1652	DVD ROM LITEON 16X 48X IDE OEM BULK			f	t	\N	2	03191652	124	\N	t	17.49	0.00	0.00	f
3413	4385	DVD ROM LG 16X52X 8164 NEGRO OEM			f	t	\N	2	03194385	124	\N	t	16.84	0.00	0.00	f
3886	5812	T.SONIDO CREATIVE SB X-FI XTREME MUSIC 24BITS			f	t	\N	2	03205812	125	\N	t	119.94	0.00	0.00	f
3623	5084	CPU INTEL PENTIUM M 740 1.73 GHZ FSB533 2MB			f	t	\N	2	03335084	212	\N	t	198.93	0.00	0.00	f
5309	7355	ACC. SENSOR DE HUMO RIMAX SECURITY PHONE			f	t	\N	2	13057355	202	\N	t	66.61	0.00	0.00	f
5310	7356	ACC. MANDO A DISTANCIA RIMAX SECURITY PHONE			f	t	\N	2	13057356	202	\N	t	20.98	0.00	0.00	f
4304	4520	RW DVD DUAL DL LG 16X8X16X 4167B OEM NEGRA SI			f	t	\N	2	03224520	128	\N	t	37.34	0.00	0.00	f
3518	4734	DVD ROM LG 16X52X 8164 OEM			f	t	\N	2	03194734	124	\N	t	14.98	0.00	0.00	f
3835	5671	CART. EPSON STYLUS 400 800 NEGRO C13S02003940			f	t	\N	2	08075671	133	\N	t	21.42	0.00	0.00	f
3836	5675	BOBINA 10 CD´S COLOR DISC VERBATIM 210MB 8CM 			f	t	\N	2	08015675	99	\N	t	13.17	0.00	0.00	f
3740	5435	RW DVD DUAL DL LITEON HP16X8X16X LIGHTSCRIBE 			f	t	\N	2	03225435	128	\N	t	48.06	0.00	0.00	f
4100	6124	CAMARA WEB NGS TX-SIGHT USB PINZA PORTATIL TF			f	t	\N	2	04116124	75	\N	t	28.25	0.00	0.00	f
4120	6147	RW DVD DUAL DL LITEON 18X8X18X LH-18A1H LS BU			f	t	\N	2	03226147	128	\N	t	45.18	0.00	0.00	f
4155	6184	TARJETA DE PROTECCION HD PCI PHASAK PC GUARDI			f	t	\N	2	03236184	129	\N	t	15.60	0.00	0.00	f
4495	6354	KIT ACTIVATION KEY INTEL RAID AXXRAK18E			f	t	\N	2	03236354	129	\N	t	355.42	0.00	0.00	f
3562	4882	CAPTURADORA TV PCI AVERMEDIA HYBRID TDT +ANAL			f	t	\N	2	03244882	130	\N	t	76.24	0.00	0.00	f
3543	4818	CAPTURADORA TV EXT. REDBELL TDT USB 2.0 RADIO			f	t	\N	2	03244818	130	\N	t	40.00	0.00	0.00	f
4493	6352	CAPTURADORA TV WINTV HVR-1100 TDT + ANALOG			f	t	\N	2	03246352	130	\N	t	60.28	0.00	0.00	f
4499	6362	CAPTURADORA DE VIDEO PINNACLE STUDIO MOVIEBOA			f	t	\N	2	03246362	130	\N	t	107.01	0.00	0.00	f
3444	4506	CAJA THERMALTAKE SWING VB6000SWS PLATA VENTAN			f	t	\N	2	03024506	31	\N	t	69.00	0.00	0.00	f
4324	5162	CAJA SEMITORRE ATX FOXCONN 3GTS082 USB+AUDIO			f	t	\N	2	03025162	31	\N	t	58.43	0.00	0.00	f
3639	5167	CAJA SEMITORRE ATX MG415 DISPLAY NEGRA USB+AU			f	t	\N	2	03025167	31	\N	t	60.84	0.00	0.00	f
4024	6016	MINIPC ASUS PUNDIT P3-PH4 775 DDR2 VGA SATA L			f	t	\N	2	03026016	31	\N	t	170.59	0.00	0.00	f
4058	6071	MINIPC ASUS PUNDIT P1-PH1 S775 DDR2 SATA SON 			f	t	\N	2	03026071	31	\N	t	172.51	0.00	0.00	f
4109	6134	CAJA SEMITORRE ATX 3319CA NEGRA PLATA			f	t	\N	2	03026134	31	\N	t	48.80	0.00	0.00	f
5311	7357	ALTAVOCES RIMAX I-SPEAK SPEAKERS PARA IPOD Y 			f	t	\N	2	04067357	70	\N	t	78.87	0.00	0.00	f
4111	6136	CAJA SEMITORRE ATX TS 088 NEGRA USB+AUDIO			f	t	\N	2	03026136	31	\N	t	72.29	0.00	0.00	f
4418	6267	CAJA SEMITORRE ATX 313152 NEGRA AZUL 2202			f	t	\N	2	03026267	31	\N	t	48.07	0.00	0.00	f
3316	4020	CAJA SERVIDOR INTEL SC5300BRP NEGRO			f	t	\N	2	03034020	32	\N	t	615.82	0.00	0.00	f
3702	5376	CAJA SERVIDOR SUPERMICRO SC743S1-R760B NEGRA			f	t	\N	2	03035376	32	\N	t	896.77	0.00	0.00	f
3717	5409	FUENTE DE ALI. INTEL SERVIDOR 500W APP350WPSU			f	t	\N	2	03035409	32	\N	t	202.48	0.00	0.00	f
3745	5443	CAJA SERVIDOR INTEL SC5295DP PILOT POINT 3 NE			f	t	\N	2	03035443	32	\N	t	282.88	0.00	0.00	f
3748	5450	KIT RACK CAJA SERVIDOR SC5295 APP3RACKIT			f	t	\N	2	03035450	32	\N	t	152.11	0.00	0.00	f
3749	5451	KIT BAHIA HOT SWAP SC5295 PILOT P.3 APP3HSDBK			f	t	\N	2	03035451	32	\N	t	38.65	0.00	0.00	f
4050	6058	FUENTE DE ALI. INTEL SERVIDOR 730W FXX730WPSU			f	t	\N	2	03036058	32	\N	t	181.37	0.00	0.00	f
4400	6240	CAJA SERVIDOR INTEL SC5299DP TORRE			f	t	\N	2	03036240	32	\N	t	255.13	0.00	0.00	f
4464	6319	FUENTE DE ALI. INTEL SERVIDOR 830W FXX830WPSU			f	t	\N	2	03036319	32	\N	t	191.06	0.00	0.00	f
4129	6156	FUENTE DE ALI. SEASONIC 600W S12600HT 12CM 2X			f	t	\N	2	03106156	48	\N	t	191.57	0.00	0.00	f
4139	6167	FUENTE DE ALI. TAGAN 2FORCE 480W 2X8CM NEGRA			f	t	\N	2	03106167	48	\N	t	119.05	0.00	0.00	f
4016	6006	FUENTE DE ALI. THERMALTAKE PUREPOWER 460 W006			f	t	\N	2	03106006	48	\N	t	97.59	0.00	0.00	f
4068	6083	FUENTE DE ALI. THERMALTAKE TOUGHPOWER 550 W00			f	t	\N	2	03106083	48	\N	t	119.04	0.00	0.00	f
5312	7358	TFT 19"  LG L194WS PLATA 5ms PANORAMICO			f	t	\N	2	04027358	66	\N	t	178.88	0.00	0.00	f
4425	6274	FUENTE DE ALI. SUNBEAM 550W NUUO 12CM 2XPCI-E			f	t	\N	2	03106274	48	\N	t	113.19	0.00	0.00	f
3980	5951	VENTILADOR AMD K8 K7 S478 AEROCOOL DP103			f	t	\N	2	03135951	51	\N	t	12.77	0.00	0.00	f
3869	5761	PB ASROCK 775i65PE I865PE SATA SON LAN			f	t	\N	2	03115761	86	\N	t	54.84	0.00	0.00	f
3803	5608	PB ASROCK 775i65G R2.0 VGA SATA SON LAN			f	t	\N	2	03115608	86	\N	t	46.69	0.00	0.00	f
4107	6132	SINTONIZADORA TV CONCEPTRONIC CLLDVBTS 1XSCAR			f	t	\N	2	04206132	143	\N	t	68.19	0.00	0.00	f
3874	5780	PB ASROCK 775DUAL-VSTA AGP8 PCI-E LAN SATA RA			f	t	\N	2	03115780	86	\N	t	56.82	0.00	0.00	f
4072	6087	PB ASUS P5B DELUXE/WIFI AP P965 PCIE DDR2 SAT			f	t	\N	2	03116087	86	\N	t	211.94	0.00	0.00	f
4108	6133	CAJA MICRO ATX 1019-CA NEGRA PLATA			f	t	\N	2	03026133	31	\N	t	48.07	0.00	0.00	f
4456	6311	PB ASROCK 4COREDUAL-VSTA AGP8 PCI-E LAN SATA 			f	t	\N	2	03116311	86	\N	t	62.29	0.00	0.00	f
3802	5607	CPU AMD ATHLON64 3500+ AM2 1000 2.2Ghz 512KB 			f	t	\N	2	03125607	50	\N	t	89.24	0.00	0.00	f
3264	3867	CPU AMD SEMPRON 3000+ S754 1.8Ghz 128KB BOX			f	t	\N	2	03123867	50	\N	t	42.00	0.00	0.00	f
3268	3877	CPU AMD ATHLON64 3000+ S939 1.8 GHZ 512KB BOX			f	t	\N	2	03123877	50	\N	t	58.88	0.00	0.00	f
3313	4011	CPU AMD ATHLON64 3200+ S939 2.0GHZ 512KB  BOX			f	t	\N	2	03124011	50	\N	t	63.87	0.00	0.00	f
4033	6035	CPU AMD SEMPRON 3600+ AM2 800 2.0Ghz 256KB BO			f	t	\N	2	03126035	50	\N	t	99.89	0.00	0.00	f
3559	4869	CPU INTEL CELERON D 346+ 3.06 256K 533M S775 			f	t	\N	2	03124869	50	\N	t	56.24	0.00	0.00	f
5313	7359	MEMORIA SO DIMM DDR2 2GB 667MHz KINGSTON			f	t	\N	2	03287359	193	\N	t	160.55	0.00	0.00	f
3563	4884	CPU INTEL CELERON D 331+ 2.66 256K 533M S775 			f	t	\N	2	03124884	50	\N	t	45.52	0.00	0.00	f
4322	5118	CPU INTEL PIV D 820+ LGA775 FSB800 2x(2.8GHZ 			f	t	\N	2	03125118	50	\N	t	93.58	0.00	0.00	f
3682	5297	CPU INTEL PIV D 930 LGA775 FSB800 2x(3.0GHZ 2			f	t	\N	2	03125297	50	\N	t	144.45	0.00	0.00	f
3800	5604	CPU AMD SEMPRON 3200+ AM2 800 1.8Ghz 128KB BO			f	t	\N	2	03125604	50	\N	t	65.41	0.00	0.00	f
4032	6033	CPU AMD SEMPRON 3400+ AM2 800 1.8Ghz 256KB BO			f	t	\N	2	03126033	50	\N	t	73.99	0.00	0.00	f
4364	5949	CASSETE PAPEL CANON PCL-CP100 TAMAÑO L			f	t	\N	2	04035949	67	\N	t	13.05	0.00	0.00	f
4365	5950	CASSETE PAPEL CANON PCC-CP100 TAMAÑO TAR. CRE			f	t	\N	2	04035950	67	\N	t	10.45	0.00	0.00	f
3870	5763	CPU INTEL PIV D 945 LGA775 FSB800 2x(3.40GHZ 			f	t	\N	2	03125763	50	\N	t	160.64	0.00	0.00	f
3239	3756	RATON NGS EVO PRO POWERED OPTICO USB			f	t	\N	2	04083756	72	\N	t	6.40	0.00	0.00	f
5314	7360	RATON LOGITECH RX250 OPTICAL MOUSE OEM NEGRO			f	t	\N	2	04087360	72	\N	t	8.53	0.00	0.00	f
4367	6017	CPU INTEL CELERON D 351+ 3.2 256K 533M S775 B			f	t	\N	2	03126017	50	\N	t	56.30	0.00	0.00	f
3857	5726	CPU AMD ATHLON64 X2 3800+ AM2 2x(2.0Ghz 512KB			f	t	\N	2	03125726	50	\N	t	68.99	0.00	0.00	f
4368	6022	CPU INTEL PIV D 915 LGA775 FSB800 2x(2.8GHZ 2			f	t	\N	2	03126022	50	\N	t	98.88	0.00	0.00	f
4151	6180	CPU INTEL CELERON D 352+ 3.2 512K 533M S775 B			f	t	\N	2	03126180	50	\N	t	59.57	0.00	0.00	f
4164	6195	CPU INTEL CELERON D 347+ 3.06 512K 533M S775 			f	t	\N	2	03126195	50	\N	t	60.02	0.00	0.00	f
4461	6316	CPU INTEL XEON D5050 3.0 DUAL 2x2MB 667FSB PA			f	t	\N	2	03126316	50	\N	t	209.59	0.00	0.00	f
3996	5982	BOLSA CAMARA MONRAY FALL 200			f	t	\N	2	13035982	199	\N	t	11.60	0.00	0.00	f
4279	3670	HD 250 GB ATA MAXTOR 7200 RPM 8MB			f	t	\N	2	03163670	54	\N	t	71.48	0.00	0.00	f
3973	5940	HD  80 GB SATA2 MAXTOR 7200 RPM 8MB			f	t	\N	2	03165940	54	\N	t	41.06	0.00	0.00	f
4123	6150	HD  80 GB ATA MAXTOR 7200 RPM 8MB			f	t	\N	2	03166150	54	\N	t	41.77	0.00	0.00	f
3618	5074	HD 160 GB SATA2 MAXTOR 7200 8MB			f	t	\N	2	03165074	54	\N	t	57.36	0.00	0.00	f
3687	5335	HD 200 GB SATA2 MAXTOR 7200 RPM 8M			f	t	\N	2	03165335	54	\N	t	63.63	0.00	0.00	f
3049	2800	HD 160 GB SATA SEAGATE 7200 RPM			f	t	\N	2	03162800	54	\N	t	91.04	0.00	0.00	f
3050	2809	HD 120 GB SATA MAXTOR 7200 RPM			f	t	\N	2	03162809	54	\N	t	76.30	0.00	0.00	f
4025	6021	CPU INTEL PIV 641 LGA775 3.2GHZ FSB800 2MB			f	t	\N	2	03126021	50	\N	t	156.54	0.00	0.00	f
3509	4699	HD 160 GB SATA2 SAMSUNG 7200 RPM HD160JJ 8MB			f	t	\N	2	03164699	54	\N	t	73.20	0.00	0.00	f
3060	2909	HD 160 GB SATA SAMSUNG 7200 RPM SP1614C 8MB			f	t	\N	2	03162909	54	\N	t	94.11	0.00	0.00	f
4040	6045	BOBINA 25 DVD+R VERBATIM 16X 4.7GB			f	t	\N	2	08026045	100	\N	t	29.64	0.00	0.00	f
4450	6304	HD 160 GB ATA WESTERN DIGITAL 7200 RPM 2MB			f	t	\N	2	03166304	54	\N	t	55.87	0.00	0.00	f
3865	5753	HD  80 GB ATA MAXTOR 7200 RPM 2MB			f	t	\N	2	03165753	54	\N	t	43.24	0.00	0.00	f
3785	5556	SVGA POWERCOLOR RADEON X1300 PRO 256MB 64 PCI			f	t	\N	2	03175556	55	\N	t	61.82	0.00	0.00	f
3163	3377	SVGA POWERCOLOR ATI RADEON 9250 128MB TV DVI			f	t	\N	2	03173377	55	\N	t	34.80	0.00	0.00	f
4932	6776	CART. MAXTEC PIXMA MAGEN CLAR CLI-8PM MP500 I			f	t	\N	2	08066776	132	\N	t	3.57	0.00	0.00	f
4289	4039	SVGA POWERCOLOR ATI X300SE PCIE 128MB HM 256M			f	t	\N	2	03174039	55	\N	t	40.46	0.00	0.00	f
3848	5693	SVGA POWERCOLOR RADEON X1300 512MB DDR2 PCI-E			f	t	\N	2	03175693	55	\N	t	91.81	0.00	0.00	f
3251	3811	SVGA ATI RADEON 9250 128MB 64bit TV DVI RETAI			f	t	\N	2	03173811	55	\N	t	27.89	0.00	0.00	f
3023	2616	SVGA G-FORCE IV FX5200 128MB/TV/DVI/8X RETAIL			f	t	\N	2	03172616	55	\N	t	35.05	0.00	0.00	f
3685	5327	SVGA SAPPHIRE ATI RADEON 9250 128MB DVI +TV			f	t	\N	2	03175327	55	\N	t	34.92	0.00	0.00	f
3806	5617	SVGA G-FORCE IV FX5500 128MB TV DVI 8X			f	t	\N	2	03175617	55	\N	t	37.59	0.00	0.00	f
3880	5797	SVGA ATI X550 PCIE 256MB DVI			f	t	\N	2	03175797	55	\N	t	53.35	0.00	0.00	f
4012	6002	SVGA POWERCOLOR ATI X550 PCIE 512HM TV DVI RE			f	t	\N	2	03176002	55	\N	t	54.40	0.00	0.00	f
4101	6125	SVGA SAPPHIRE RADEON X1600 PRO 512MB DDR2 AGP			f	t	\N	2	03176125	55	\N	t	141.98	0.00	0.00	f
3807	5618	SVGA SAPPHIRE RADEON X1300 512HM DDR2 PCI-E			f	t	\N	2	03175618	55	\N	t	55.59	0.00	0.00	f
4014	6004	SVGA POWERCOLOR ATI X300SE PCIE 128MB HM 512M			f	t	\N	2	03176004	55	\N	t	39.33	0.00	0.00	f
4166	6197	SVGA SAPPHIRE RADEON X1300 PRO 256MB DDR2 AGP			f	t	\N	2	03176197	55	\N	t	98.10	0.00	0.00	f
4382	6220	SVGA PVIEW GEFORCE 6200A 256 AGP8X DDR 64BIT 			f	t	\N	2	03176220	55	\N	t	52.73	0.00	0.00	f
4079	6095	T.RED PCI NETGEAR FA311-200ISS 10/100 RJ45			f	t	\N	2	03296095	183	\N	t	9.58	0.00	0.00	f
4392	6230	SVGA PVIEW GEFORCE 7100GS 256 PCIE DDR2 DVI T			f	t	\N	2	03176230	55	\N	t	50.93	0.00	0.00	f
3346	4106	SERV. IMPRESORA CONCEPTRONIC USB 2.0			f	t	\N	2	07024106	95	\N	t	41.57	0.00	0.00	f
4414	6260	SVGA SAPPHIRE RADEON X1600 PRO 256MB DDR2 PCI			f	t	\N	2	03176260	55	\N	t	96.88	0.00	0.00	f
2832	0427	CABLE DUPLICADOR ALIMENTACION X 2 INTERNO AK3			f	t	\N	2	03010427	28	\N	t	1.57	0.00	0.00	f
3343	4096	ADAPTADOR SCSI SCA80H HPDB68H LVD INTERNO			f	t	\N	2	03014096	28	\N	t	42.89	0.00	0.00	f
3827	5654	VENTILADOR ADICIONAL SPIRE 8X8 FD08025S1L			f	t	\N	2	03015654	28	\N	t	2.46	0.00	0.00	f
3852	5702	VENTILADOR BLOWER COOLBOX DOBLE SLOT SB-B			f	t	\N	2	03015702	28	\N	t	6.34	0.00	0.00	f
3517	4722	REPRODUCTOR MP3 NGS JAZZ 512MB RADIO VOZ			f	t	\N	2	13044722	198	\N	t	46.45	0.00	0.00	f
4171	6203	REPRODUCTOR HD RIMAX ALUM TVIX 300 GB USB2.0 			f	t	\N	2	13046203	198	\N	t	181.24	0.00	0.00	f
4378	6212	RATON NGS SYMBIOSIS POWERED PLATA			f	t	\N	2	04086212	72	\N	t	3.49	0.00	0.00	f
4403	6244	SAI NGS RHINO 2000			f	t	\N	2	04146244	81	\N	t	1062.73	0.00	0.00	f
4404	6245	IMPRESORA TICKETS EPSON TM-U950 MATRICIAL PAR			f	t	\N	2	05036245	120	\N	t	683.40	0.00	0.00	f
5315	7361	MEMORIA DIMM DDR 1024 MB 266Mhz KINGSTON 184 			f	t	\N	2	03147361	52	\N	t	85.57	0.00	0.00	f
4144	6172	TRIPODE SONY VCTR640 CON ELEVADOR Y NIVEL			f	t	\N	2	13036172	199	\N	t	62.01	0.00	0.00	f
4017	6008	PUNTERO RECAMBIO HP POQUET PC IPAQ FA237A			f	t	\N	2	13026008	201	\N	t	20.08	0.00	0.00	f
3582	4988	CAPTURADORA TV EXT. NGS ATMOS TV USB 2.0 STIC			f	t	\N	2	13064988	205	\N	t	41.73	0.00	0.00	f
4274	3441	IMPRESORA EPSON LQ-590 MATRICIAL 24 AGUJAS US			f	t	\N	2	04253441	182	\N	t	450.77	0.00	0.00	f
3341	4087	ADAPTADOR CABLE HD PORTATIL A IDE 40 HILOS + 			f	t	\N	2	03014087	28	\N	t	11.45	0.00	0.00	f
3054	2856	IMPRESORA EPSON FX-890 + MATRICIAL			f	t	\N	2	04252856	182	\N	t	493.02	0.00	0.00	f
4254	2433	SOFT. WINDOWS 2003 SERVER ESTANDAR + 5 CLIENT			f	t	\N	2	03302433	184	\N	t	763.52	0.00	0.00	f
3123	3220	SOFT. WINDOWS XP HOME EDITION OEM ALEMAN			f	t	\N	2	03303220	184	\N	t	81.46	0.00	0.00	f
3051	2827	SOFT. WINDOWS XP PROFESIONAL OEM INGLES			f	t	\N	2	03302827	184	\N	t	135.55	0.00	0.00	f
3684	5326	SOFT. WINDOWS XP HOME EDITION OEM PACK DE 3			f	t	\N	2	03305326	184	\N	t	243.20	0.00	0.00	f
3862	5743	SOFT. WINDOWS 2003 SERVER R2a ESP 5 CAL OEM 1			f	t	\N	2	03305743	184	\N	t	647.17	0.00	0.00	f
4514	6378	SOFT. WINDOWS VISTA ULTIMATE 64 BIT OEM			f	t	\N	2	03306378	184	\N	t	170.41	0.00	0.00	f
2855	0917	VENTILADOR PARA CABINA DE RACK 19			f	t	\N	2	07060917	185	\N	t	67.08	0.00	0.00	f
3015	2559	BANDEJA DESLIZANTE 600X600 y 800X600 PARA 19"			f	t	\N	2	07062559	185	\N	t	74.06	0.00	0.00	f
3016	2561	MODULO DE TERMOSTATO 2U			f	t	\N	2	07062561	185	\N	t	48.41	0.00	0.00	f
3070	2991	TAPA PARA CONJUNTO 2 VENTILADORES 600X800 RAC			f	t	\N	2	07062991	185	\N	t	120.70	0.00	0.00	f
4275	3482	ARMARIO RACK 19" 1 CUERPO 6U 400 mm RK2106			f	t	\N	2	07063482	185	\N	t	205.53	0.00	0.00	f
3355	4135	BANDEJA FIJA 19" 600x1000 420mm PROFUNDIDAD R			f	t	\N	2	07064135	185	\N	t	35.43	0.00	0.00	f
3017	2565	REGLETA RACK 19" C/INT 6 TOMAS			f	t	\N	2	07062565	185	\N	t	26.72	0.00	0.00	f
3162	3375	BANDEJA KNURR FIJA 600*800			f	t	\N	2	07063375	185	\N	t	37.57	0.00	0.00	f
3701	5370	BANDEJA FRONTAL 19" PARA DISP. DE 270mm 1U RS			f	t	\N	2	07065370	185	\N	t	26.36	0.00	0.00	f
5316	7362	TFT 17"  ACER AL1717FS 5MS PLATA MULTIMEDIA			f	t	\N	2	04027362	66	\N	t	193.86	0.00	0.00	f
2954	1884	CONTROLADORA PCI 2 PTOS SERIE +1 PAR. PCI42			f	t	\N	2	03261884	186	\N	t	34.02	0.00	0.00	f
3317	4023	CONTROLADORA 4(+1 INT) PTOS. USB 2.0 SB3015			f	t	\N	2	03264023	186	\N	t	15.45	0.00	0.00	f
3048	2786	CONTROLADORA USB 2.0 + FIREWIRE CONCEPTRONIC 			f	t	\N	2	03262786	186	\N	t	28.42	0.00	0.00	f
3065	2967	PCMCIA CONCEPTRONIC USB 2.0 + FIREWIRE (1+1)			f	t	\N	2	03262967	186	\N	t	42.01	0.00	0.00	f
3319	4025	COMPROBADOR DE CABLEADO LED PHASAK DX240			f	t	\N	2	07054025	188	\N	t	45.94	0.00	0.00	f
3336	4078	KIT POWER OVER ETHERNET D-LINK DWL-P100			f	t	\N	2	07054078	188	\N	t	42.17	0.00	0.00	f
3143	3278	LATIGUILLO UTP CAT.5E VERDE 1.5Mt. PL 2751			f	t	\N	2	07053278	188	\N	t	1.66	0.00	0.00	f
3357	4145	TRANSCEPTOR DE RED ETHERNET TX-FX RJ45 ST MUL			f	t	\N	2	07054145	188	\N	t	80.78	0.00	0.00	f
3811	5632	LATIGUILLO FTP CAT.5E DE 0.5 MT MARFIL PL4200			f	t	\N	2	07055632	188	\N	t	1.05	0.00	0.00	f
4070	6085	ROSETA EMBUTIDA RJ45 CAT. 5E UTP 1 TOMA FE 11			f	t	\N	2	07056085	188	\N	t	3.71	0.00	0.00	f
4071	6086	ROSETA EMBUTIDA RJ45 CAT. 5E UTP 2 TOMAS FE 2			f	t	\N	2	07056086	188	\N	t	6.02	0.00	0.00	f
4471	6327	KIT MONTAJE BACKPLANE SC5299/5295 SAS APP3HSD			f	t	\N	2	03036327	32	\N	t	29.93	0.00	0.00	f
4933	6777	CART. MAXTEC BROTHER LC800 MFC 3420 NEGRO B31			f	t	\N	2	08066777	132	\N	t	5.52	0.00	0.00	f
5357	7403	IMPRESORA CANON PIXMA IP 3500 USB			f	t	\N	2	04037403	67	\N	t	64.55	0.00	0.00	f
3038	2738	AURICULAR CON MICRO NGS VOX320 + HUB MULTIMED			f	t	\N	2	09072738	189	\N	t	26.41	0.00	0.00	f
3348	4108	KIT COCHE CONCEPTRONIC BLUETOOTH MANOS LIBRES			f	t	\N	2	09074108	189	\N	t	53.12	0.00	0.00	f
3180	3429	AURICULAR NGS WIRELESS BLUETOOTH LITEPHONE			f	t	\N	2	09073429	189	\N	t	36.46	0.00	0.00	f
4527	6395	TFT 17"  CAPTIVA 1703E PLATA NEGRO 8MS MM			f	t	\N	2	04026395	66	\N	t	150.60	0.00	0.00	f
4516	6381	MODEM ADSL2+ D-LINK DSL-320T ETHERNET 10/100			f	t	\N	2	04046381	68	\N	t	46.86	0.00	0.00	f
4518	6384	LECTOR C.B. METROLOGIC MS-9540CG VOYAGER (USB			f	t	\N	2	05036384	120	\N	t	209.20	0.00	0.00	f
4523	6389	TONER IMP. HP LASERJET 3600 3800 AMARILLO Q75			f	t	\N	2	08096389	136	\N	t	144.49	0.00	0.00	f
4526	6394	RW DVD DL SATA LITEON 16X4X16X SH-16A7S +F.NE			f	t	\N	2	03226394	128	\N	t	35.27	0.00	0.00	f
4520	6386	CONTROLADORA SCSI ADAPTEC ASC39320A-R RAID 68			f	t	\N	2	03236386	129	\N	t	278.48	0.00	0.00	f
2929	1602	ARCHIVADOR CD S NGS WALLETS DINAMIC 28 U			f	t	\N	2	09101602	190	\N	t	5.82	0.00	0.00	f
3411	4373	SOFT. OFFICE BASIC 2003 SERV. MICROSOFT OEM			f	t	\N	2	06024373	90	\N	t	196.06	0.00	0.00	f
3508	4694	CART. JT EPSON PHOTO 950 960 NEGRO E85B			f	t	\N	2	08064694	132	\N	t	7.81	0.00	0.00	f
3152	3332	MALETIN MONRAY EXECUTIVE CUERO			f	t	\N	2	09103332	190	\N	t	38.87	0.00	0.00	f
3153	3333	MALETIN MONRAY DIPLOMATIC			f	t	\N	2	09103333	190	\N	t	38.87	0.00	0.00	f
2972	2244	ARCHIVADOR CD S NGS WALLETS TRENDY LINE 240 U			f	t	\N	2	09102244	190	\N	t	21.73	0.00	0.00	f
3055	2857	CINTA IMPRESORA EPSON FX-890 NEGRO S015329			f	t	\N	2	08052857	103	\N	t	6.60	0.00	0.00	f
4047	6055	KIT DG834PN ROUTER ADSL NETGEAR WIFI+ADAP USB			f	t	\N	2	04046055	68	\N	t	135.57	0.00	0.00	f
4132	6159	DESKTOP LABTEC ULTRAFLAT WIRELESS DESKTOP PS/			f	t	\N	2	04076159	71	\N	t	14.46	0.00	0.00	f
4410	6252	KIT NETGEAR ROUTER WNR854T + WIFI CARDBUS WN5			f	t	\N	2	04046252	68	\N	t	153.55	0.00	0.00	f
3483	4625	ARCHIVADOR CD S NGS WALLETS SMART 96 U			f	t	\N	2	09104625	190	\N	t	14.47	0.00	0.00	f
3594	5027	MALETIN MONRAY CATWALK FEMENINO			f	t	\N	2	09105027	190	\N	t	31.08	0.00	0.00	f
2933	1606	ARCHIVADOR CD S NGS WALLETS SMART 48 U			f	t	\N	2	09101606	190	\N	t	9.37	0.00	0.00	f
3329	4053	MALETIN MONRAY SOPHIE FEMENINO			f	t	\N	2	09104053	190	\N	t	27.19	0.00	0.00	f
4509	6373	VENTILADOR AMD K8 K7 S478 AEROCOOL HT101			f	t	\N	2	03136373	51	\N	t	10.92	0.00	0.00	f
3393	4271	MALETIN MONRAY JOURNEY			f	t	\N	2	09104271	190	\N	t	38.87	0.00	0.00	f
3404	4348	MALETIN PARA PORTATIL 17" NGS PLUS ORGANIZER 			f	t	\N	2	09104348	190	\N	t	22.59	0.00	0.00	f
3432	4444	ARCHIVADOR CD S NGS WALLETS CAR 36 U			f	t	\N	2	09104444	190	\N	t	6.16	0.00	0.00	f
3592	5024	MALETIN MONRAY FIRST CLASS			f	t	\N	2	09105024	190	\N	t	38.87	0.00	0.00	f
3593	5026	MALETIN MONRAY SHEILA FEMENINO			f	t	\N	2	09105026	190	\N	t	22.59	0.00	0.00	f
5317	7363	CABLE DE MONITOR PnP VGA HQ HD15M/M 15 MTR. A			f	t	\N	2	09017363	106	\N	t	41.36	0.00	0.00	f
3889	5818	ESSENTIAL KIT MALETIN CATWALK + VIP MOUSE + 4			f	t	\N	2	09105818	190	\N	t	43.20	0.00	0.00	f
4458	6313	MEMORIA SO DIMM DDR 1 GB 400MHz KINGSTON			f	t	\N	2	03286313	193	\N	t	100.18	0.00	0.00	f
4484	6342	MEMORIA SO DIMM DDR 512 MB 333Mhz KINGSTON AC			f	t	\N	2	03286342	193	\N	t	74.41	0.00	0.00	f
4494	6353	MEMORIA SO DIMM DDR2 512 MB 533MHz KINGSTON			f	t	\N	2	03286353	193	\N	t	89.59	0.00	0.00	f
3369	4194	HD PORTATIL 60 GB SAMSUNG 2.5" 5400RPM 8M			f	t	\N	2	03274194	194	\N	t	60.72	0.00	0.00	f
3630	5120	HD PORTATIL 60 GB TOSHIBA 5400RPM 8MB			f	t	\N	2	03275120	194	\N	t	64.42	0.00	0.00	f
3665	5237	HD PORTATIL 100 GB TOSHIBA 5400RPM 16MB			f	t	\N	2	03275237	194	\N	t	83.47	0.00	0.00	f
4351	5732	HD PORTATIL 100 GB SAMSUNG 5400RPM 8MB HM100J			f	t	\N	2	03275732	194	\N	t	70.99	0.00	0.00	f
3568	4915	MEMORIA SECURE DIGITAL PNY SD 512 MB			f	t	\N	2	04274915	195	\N	t	11.07	0.00	0.00	f
3680	5291	MEMORIA SECURE DIGITAL PNY SD 2 GB			f	t	\N	2	04275291	195	\N	t	30.86	0.00	0.00	f
3727	5422	PEN DRIVE 512 MB TOSHIBA USB2.0 PX1261E-1M51			f	t	\N	2	04275422	195	\N	t	22.67	0.00	0.00	f
4349	5651	PEN DRIVE 2 GB KINGSTON USB 2.0 DATA TRAV II+			f	t	\N	2	04275651	195	\N	t	33.39	0.00	0.00	f
4543	02	Instalacion del SO Windows			f	f	\N	2	010102	25	\N	\N	20.00	0.00	0.00	f
4545	04	Limpieza de virus			f	f	\N	2	010104	25	\N	\N	35.00	0.00	0.00	f
3440	4482	PEN DRIVE 1 GB GENERICO USB 2.0			f	t	\N	2	04274482	195	\N	t	20.22	0.00	0.00	f
4359	5861	MEMORIA MINI SECURE DIGITAL TAKEMS MINISD 1GB			f	t	\N	2	04275861	195	\N	t	12.05	0.00	0.00	f
3891	5823	PEN DRIVE 2 GB DANE-ELEC USB 2.0 AZUL			f	t	\N	2	04275823	195	\N	t	39.58	0.00	0.00	f
4177	6210	PEN DRIVE 512 MB TAKEMS MINI USB 2.0			f	t	\N	2	04276210	195	\N	t	8.69	0.00	0.00	f
4169	6201	PB GIGABYTE GA-M61PM-S2 AM2 NFORCE PCIE VGA S			f	t	\N	2	03326201	196	\N	t	69.55	0.00	0.00	f
4316	4831	CAJA THERMALTAKE MAMBO VC2000BNS NEGRO			f	t	\N	2	03314831	197	\N	t	46.82	0.00	0.00	f
4399	6238	CAJA THERMALTAKE BACH NEGRO CON MEDIALAB VB80			f	t	\N	2	03316238	197	\N	t	188.95	0.00	0.00	f
4426	6275	CAJA SEMITORRE ATX RAIDMAX RX-9 NEGRA ALTAV. 			f	t	\N	2	03316275	197	\N	t	139.93	0.00	0.00	f
3805	5615	REPRODUCTOR HD CONCEPTRONIC MULTIMEDIA 300 GB			f	t	\N	2	13045615	198	\N	t	204.81	0.00	0.00	f
3148	3328	GRABADORA DIGITAL NGS DE VOZ Y CONV. TELF. X-			f	t	\N	2	13043328	198	\N	t	90.57	0.00	0.00	f
5319	7365	TONER IMP. OKI C3100 MAGENTA 42126642			f	t	\N	2	08097365	136	\N	t	113.61	0.00	0.00	f
4048	6056	REPRODUCTOR MP3 RIMAX D-LUXE 1GB MP4 LCD 1.8"			f	t	\N	2	13046056	198	\N	t	63.87	0.00	0.00	f
4339	5459	CAMARA FOTOS CANON IXUS 60 6MP SD 3XOPT LCD2.			f	t	\N	2	13035459	199	\N	t	271.43	0.00	0.00	f
3474	4601	CAMARA FOTOS NGS EAGLEVIEW S3-100 3.1MP			f	t	\N	2	13034601	199	\N	t	75.83	0.00	0.00	f
3636	5145	CONTROL REMOTO LOGITECH HARMONY 525 PROGRAMAB			f	t	\N	2	13035145	199	\N	t	69.63	0.00	0.00	f
3179	3428	CAMARA FOTOS NGS EAGLEVIEW D3 3.2MP ZOOM			f	t	\N	2	13033428	199	\N	t	69.75	0.00	0.00	f
3389	4267	BOLSA CAMARA MONRAY SHELL D400			f	t	\N	2	13034267	199	\N	t	10.83	0.00	0.00	f
3753	5458	CAMARA FOTOS CANON POWERSHOT A430 4MP SD 4XOP			f	t	\N	2	13035458	199	\N	t	127.60	0.00	0.00	f
3844	5685	CAMARA FOTOS KODAK C643 6MP 32MB 3XOPT			f	t	\N	2	13035685	199	\N	t	147.93	0.00	0.00	f
4092	6116	CAMARA FOTOS KODAK P880 8MP 5XOPT 32MB MEM SD			f	t	\N	2	13036116	199	\N	t	438.83	0.00	0.00	f
4145	6173	CAMARA DIGITAL VIDEO SONY DCR-SR30E HD 30 GB			f	t	\N	2	13036173	199	\N	t	599.27	0.00	0.00	f
4147	6175	CAMARA FOTOS SONY DSLR-A100K 10MP KIT 18-70 m			f	t	\N	2	13036175	199	\N	t	898.27	0.00	0.00	f
4408	6249	CAMARA FOTOS KODAK C743 7.1MP OPT3X 2.4" 32MB			f	t	\N	2	13036249	199	\N	t	143.73	0.00	0.00	f
4326	5192	MULTIFUNCION HP LASERJET 3050MFP CON FAX Q650			f	t	\N	2	04265192	200	\N	t	310.00	0.00	0.00	f
4332	5264	IMPRESORA EPSON CX11NF MULTIFUNCION LASER CON			f	t	\N	2	04265264	200	\N	t	1137.13	0.00	0.00	f
3677	5281	IMPRESORA CANON PIXMA MP 500 MULTIFUNCION IR			f	t	\N	2	04265281	200	\N	t	221.40	0.00	0.00	f
4174	6207	GPS AVMAP GEOSAT5 5" TACTIL SOFT SD P.IBERICA			f	t	\N	2	13026207	201	\N	t	435.07	0.00	0.00	f
4059	6072	PORTATIL SAMSUNG R40 M430 1GB 80GB DVD-RW 15.			f	t	\N	2	02996072	204	\N	t	734.81	0.00	0.00	f
3939	5896	PORTATIL SAMSUNG R40 T5500 1GB 120GB DVD-RW 1			f	t	\N	2	02995896	204	\N	t	939.78	0.00	0.00	f
3856	5724	HD 750 GB SATA2 SEAGATE 7200 RPM 16MB			f	t	\N	2	03165724	54	\N	t	217.27	0.00	0.00	f
5320	7366	PB ECS KN1 LITE NFORCE4 S939 SON SATA RAID GL			f	t	\N	2	03327366	196	\N	t	85.88	0.00	0.00	f
4433	6287	PORTATIL HP NX7300 CM430 1GB 80GB DVD-RW 15.4			f	t	\N	2	02996287	204	\N	t	654.18	0.00	0.00	f
3921	5872	ADAPTADOR VOIP CONCEPTRONIC			f	t	\N	2	13075872	203	\N	t	40.39	0.00	0.00	f
4057	6070	FUENTE ALIMENTACION TARGUS UNIV. PORTATIL 90W			f	t	\N	2	02996070	204	\N	t	107.89	0.00	0.00	f
4335	5337	RW DVD DUAL DL SLIM SAMSUNG 8X8X4 SN-S082D OE			f	t	\N	2	03355337	211	\N	t	55.82	0.00	0.00	f
4217	08	MANTENIMIENTO BFACT GORGBLAU			f	f	\N	2	020508	206	\N	\N	30.00	0.00	0.00	f
4218	09	MANTENIMIENTO RED ESCUELA DEL MAR			f	f	\N	2	020509	206	\N	\N	35.00	0.00	0.00	f
4219	10	MANTENIMIENTO INF. ESCUELA DEL MAR			f	f	\N	2	020510	206	\N	\N	105.00	0.00	0.00	f
4220	11	MANTENIMIENTO SPAZZOLA			f	f	\N	2	020511	206	\N	\N	180.30	0.00	0.00	f
4216	07	MANTENIMIENTO DIALMA			f	f	\N	2	020507	206	\N	\N	380.00	0.00	0.00	f
4208	03	MANTENIMIENTO BULMAGES ECOLOGING			f	f	\N	2	020503	206	\N	\N	30.00	0.00	0.00	f
4225	02	HOSTING BORISGRAFIC.COM			f	f	\N	2	020602	207	\N	\N	75.00	0.00	0.00	f
4366	6010	SOFT. ANTIVIRUS PANDA 2007 + FIREWALL			f	t	\N	2	06036010	91	\N	t	42.52	0.00	0.00	f
4106	6131	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA			f	t	\N	2	04236131	148	\N	t	27.71	0.00	0.00	f
3470	4591	TECLADO NGS ZENITH 17 TECLAS MULTIMEDIA USB			f	t	\N	2	04074591	71	\N	t	8.23	0.00	0.00	f
4191	05	PORTES			f	f	\N	2	020205	56	\N	\N	5.00	0.00	0.00	f
4030	6030	FA. 460W GC PFC PIV 12CM 20/24 PIN SA			f	t	\N	2	03106030	48	\N	t	18.31	0.00	0.00	f
4529	02	BROTHER TAMBOR C-DR200			f	f	\N	2	081002	137	\N	\N	80.11	0.00	0.00	f
4565	08	TN3060 BROTHER 8220/8045/8440/8840			t	t	\N	2	081008	137	\N	\N	87.28	0.00	0.00	f
4170	6202	HP EVODC5700 E6300 1.8GHZ 1.0GB 80GB COMBO XP			f	t	\N	2	01086202	216	\N	t	869.86	0.00	0.00	f
4572	0023	un articulo			f	f	\N	2	01020023	59	\N	\N	10.00	5.00	5.00	f
4573	456	AÑLSKJ			f	f	\N	2	0206456	207	\N	\N	12.00	1.00	111.00	f
2817	0311	DISCO ZIP 250 MB			f	t	\N	2	08040311	102	\N	t	11.35	0.00	0.00	f
3858	5727	CPU AMD ATHLON64 X2 4600+ AM2 2x(2.4Ghz 512KB			f	t	\N	2	03125727	50	\N	t	99.33	0.00	0.00	f
4375	6192	GAMEPAD LOGITECH CORDLESS PRECISION CONTROL P			f	t	\N	2	04096192	73	\N	t	22.17	0.00	0.00	f
5321	7367	TONER IMP. OKI C3100 CYAN 42126643			f	t	\N	2	08097367	136	\N	t	113.60	0.00	0.00	f
2821	0322	LECTOR C.B. METROLOGIC MS-9520 VOYAGER (TECLA			f	t	\N	2	05030322	120	\N	t	163.40	0.00	0.00	f
2822	0411	CABLE PS/2 M/M 3 MTS AK3236			f	t	\N	2	09010411	106	\N	t	1.84	0.00	0.00	f
2824	0413	CABLE SERIE (DB-9) 1.8 Mts. M/H (ALARGADOR) 9			f	t	\N	2	09010413	106	\N	t	2.01	0.00	0.00	f
2826	0415	CABLE ALIMENTACION CPU-RED 1.8MTS AK5012			f	t	\N	2	09010415	106	\N	t	1.60	0.00	0.00	f
2827	0418	CABLE P.PARALELO 10MTS AK 1054			f	t	\N	2	09010418	106	\N	t	8.83	0.00	0.00	f
2828	0419	CABLE P.PARALELO 5M AK1034			f	t	\N	2	09010419	106	\N	t	4.01	0.00	0.00	f
2829	0420	ADAPTADOR DE TECLADO PS2 A CONEXION AT AK5301			f	t	\N	2	09010420	106	\N	t	1.53	0.00	0.00	f
2830	0421	ADAPTADOR DE TECLADO AT A CONEXION PS2 AK5300			f	t	\N	2	09010421	106	\N	t	1.29	0.00	0.00	f
2833	0439	ADAPTADOR SLOT 1 - FCPGA			f	t	\N	2	03010439	28	\N	t	6.02	0.00	0.00	f
2834	0440	SOPORTE PARA UNIDADES DE 3.5" CON FRONTAL MF5			f	t	\N	2	03010440	28	\N	t	3.61	0.00	0.00	f
4574	0445	TONER IMP. SAMSUNG ML-4600			f	t	\N	2	08090445	136	\N	t	69.23	0.00	0.00	f
3052	2852	IMPRESORA EPSON LASER EPL6200L USB			f	t	\N	2	04242852	173	\N	t	185.73	0.00	0.00	f
4246	0480	IMP. TICKETS EPSON TM-T88IV-812 TERMICA PARAL			f	t	\N	2	05030480	120	\N	t	328.55	0.00	0.00	f
2839	0579	CABLE P.PARALELO 3 Mts AK1063			f	t	\N	2	09010579	106	\N	t	3.37	0.00	0.00	f
4575	0710	RATON LOGITECH TRACKMAN WHEEL MOUSE USB/PS2			f	t	\N	2	04080710	72	\N	t	36.35	0.00	0.00	f
2844	0755	CABLE HD IDE 80 HILOS 40 PIN 3 CONECTORES DMA			f	t	\N	2	03010755	28	\N	t	2.17	0.00	0.00	f
2847	0773	KVM MANUAL 2X1 2PC/1mon/1tec/1rat			f	t	\N	2	09020773	107	\N	t	18.67	0.00	0.00	f
2849	0789	TONER IMP. SAMSUNG LASER ML-6050			f	t	\N	2	08090789	136	\N	t	111.95	0.00	0.00	f
2851	0819	SOFT. WINDOWS XP HOME EDITION OEM			f	t	\N	2	03300819	184	\N	t	82.95	0.00	0.00	f
2854	0911	CABLE PS/2 M/M 10MTS			f	t	\N	2	09010911	106	\N	t	5.06	0.00	0.00	f
2863	0989	CABLE ALIMENT. CPU A MONITOR O SAI 1.8 AK5030			f	t	\N	2	09010989	106	\N	t	2.06	0.00	0.00	f
4576	1074	MEMORIA DIMM DDR 512 MB 266Mhz KINGSTON			f	t	\N	2	03141074	52	\N	t	26.29	0.00	0.00	f
2870	1076	CABLE SERIE DB9H - DB25M 1.8 M (IMPRESORA TIC			f	t	\N	2	09011076	106	\N	t	2.67	0.00	0.00	f
2872	1087	CABLE PS/2 1.8 Mts. M/H (Extension) AK 3230			f	t	\N	2	09011087	106	\N	t	1.45	0.00	0.00	f
2873	1088	CABLE PS/2 M / H 3 MTS (Extension) AK 3233			f	t	\N	2	09011088	106	\N	t	1.77	0.00	0.00	f
2887	1217	LATIGUILLO UTP CAT.5E DE 2 MTS PL1002			f	t	\N	2	07051217	188	\N	t	1.13	0.00	0.00	f
2888	1218	LATIGUILLO UTP CAT.5E DE 3 MTS PL1003			f	t	\N	2	07051218	188	\N	t	2.34	0.00	0.00	f
2891	1221	LATIGUILLO FTP CAT.5E DE 0.5 M PL 1200			f	t	\N	2	07051221	188	\N	t	1.13	0.00	0.00	f
2894	1237	FUNDA PROT. CONECTOR RJ45 ROJO 10 Uds.TT4511			f	t	\N	2	07051237	188	\N	t	1.49	0.00	0.00	f
2895	1246	CONECTOR HEMBRA UTP RJ45 CAT.5E (SD2016)			f	t	\N	2	07051246	188	\N	t	3.05	0.00	0.00	f
2897	1251	PANEL REPARTIDOR 24 UTP CAT.5E PU2410			f	t	\N	2	07061251	185	\N	t	32.46	0.00	0.00	f
2898	1254	HERRAMIENTA CRIMPADORA C/CABEZAL RJ45, RJ12, 			f	t	\N	2	07051254	188	\N	t	27.11	0.00	0.00	f
2899	1256	HERRAMIENTA INSERCION Y CORTE KRONE 6417			f	t	\N	2	07051256	188	\N	t	39.92	0.00	0.00	f
2900	1258	HERRAMIENTA DE CORTE (PELADOR DE CABLES)			f	t	\N	2	07051258	188	\N	t	3.77	0.00	0.00	f
2904	1297	TERMINADOR USCSI2 LVD SE/EXT.. HPDB68H			f	t	\N	2	03011297	28	\N	t	11.93	0.00	0.00	f
2906	1326	MARCO PARA CONECTOR HEMBRA GRIS*			f	t	\N	2	07051326	188	\N	t	0.35	0.00	0.00	f
2907	1328	ALARGADORES DE CONEXION UTP RJ45 (H-H) TD1018			f	t	\N	2	07051328	188	\N	t	1.36	0.00	0.00	f
2908	1334	PANEL FRONTAL CIEGO 1 U.			f	t	\N	2	07051334	188	\N	t	8.20	0.00	0.00	f
2911	1370	CART. JT EPSON 480 580 C20 C40 COLOR (T014401			f	t	\N	2	08061370	132	\N	t	5.84	0.00	0.00	f
4247	1377	MEMORIA DIMM SDRAM 256 MB KINGSTON 133 MHZ			f	t	\N	2	03141377	52	\N	t	25.54	0.00	0.00	f
2913	1389	CONTROLADORA IDE ATA 133 RAID 3710			f	t	\N	2	03231389	129	\N	t	31.89	0.00	0.00	f
2915	1433	SAI NGS 500 CHRONUS OFF LINE			f	t	\N	2	04141433	81	\N	t	49.02	0.00	0.00	f
4162	6193	AURICULAR CON MICRO CONCEPTRONIC CGAMESTARU U			f	t	\N	2	09076193	189	\N	t	24.46	0.00	0.00	f
3254	3826	TECLADO NGS CUTEWHITE 108 TECLAS BLANCO			f	t	\N	2	04073826	71	\N	t	4.94	0.00	0.00	f
5322	7368	TONER IMP. OKI C3100 AMARILLO 42804513			f	t	\N	2	08097368	136	\N	t	113.33	0.00	0.00	f
2919	1556	CAMARA PORTATIL USB FUNCAM CONCEPTRONIC			f	t	\N	2	04111556	75	\N	t	12.67	0.00	0.00	f
2921	1578	SAI NGS 650 CHRONUS OFF LINE			f	t	\N	2	04141578	81	\N	t	82.18	0.00	0.00	f
2923	1582	AURICULAR CON MICRO NGS Y CONTROL VOLUMEN MS1			f	t	\N	2	09071582	189	\N	t	4.66	0.00	0.00	f
2924	1584	AURICULAR CON MICRO Y REG. VOL NGS COMPACT			f	t	\N	2	09071584	189	\N	t	13.24	0.00	0.00	f
2925	1585	MICROFONO SOBREMESA NGS VOX110			f	t	\N	2	09071585	189	\N	t	8.57	0.00	0.00	f
2927	1589	RATON INALAMBRICO NGS SNAKE FLAKE			f	t	\N	2	04081589	72	\N	t	17.57	0.00	0.00	f
2928	1597	CAMARA WEB NGS SHOW CAM 100K USB			f	t	\N	2	04111597	75	\N	t	12.53	0.00	0.00	f
2931	1604	ARCHIVADOR CDS+REPROD. NGS WALLET CDP-12			f	t	\N	2	09021604	107	\N	t	7.19	0.00	0.00	f
2932	1605	ARCHIVADOR CD S NGS WALLET DINAMICS 96 U			f	t	\N	2	09101605	190	\N	t	12.36	0.00	0.00	f
2934	1608	MALETIN MONRAY ORGANIZER NYLON 15"			f	t	\N	2	09101608	190	\N	t	15.71	0.00	0.00	f
2935	1609	ARCHIVADOR CD S NGS WALLETS DINAMIC 208 U			f	t	\N	2	09101609	190	\N	t	21.08	0.00	0.00	f
2936	1610	TABLETA DIGITALIZADORA NGS CADBOY			f	t	\N	2	04171610	116	\N	t	40.71	0.00	0.00	f
2937	1611	TABLETA DIGITALIZADORA NGS CADBOY ULTRA			f	t	\N	2	04171611	116	\N	t	69.80	0.00	0.00	f
5323	7369	CAMARA DE RED AXIS 210 COLOR 10/100			f	t	\N	2	13057369	202	\N	t	472.30	0.00	0.00	f
2938	1612	TABLETA DIGITALIZADORA NGS DRAW MASTER			f	t	\N	2	04171612	116	\N	t	79.37	0.00	0.00	f
4577	1635	VENTILADOR ADICIONAL COOLBOX 8X8 8025M12CA			f	t	\N	2	03011635	28	\N	t	3.13	0.00	0.00	f
4578	1686	DISQUETERA NEC 3,5" NEGRA			f	t	\N	2	03151686	53	\N	t	5.02	0.00	0.00	f
2941	1696	BOBINA 25 CD´S VERBATIM 52X ( 700 MB ) SUPERA			f	t	\N	2	08011696	99	\N	t	12.52	0.00	0.00	f
2942	1701	PACK 10 CD-R VERBATIM 52X PRINTABLE ( 700 MB 			f	t	\N	2	08011701	99	\N	t	8.12	0.00	0.00	f
2943	1729	CART. HP NEGRO Nº27 3320C/3325/3420C (C8727AE			f	t	\N	2	08071729	133	\N	t	14.59	0.00	0.00	f
2944	1730	CART. HP TRICOLOR  Nº28 3320C/3420C (C8728AE)			f	t	\N	2	08071730	133	\N	t	16.89	0.00	0.00	f
2945	1731	CART. HP NEGRO Nº15 (C6615DE)25 ml			f	t	\N	2	08071731	133	\N	t	22.92	0.00	0.00	f
2946	1757	TONER FAX SAMSUNG SF-5100/530 LASER ( SF-5100			f	t	\N	2	08091757	136	\N	t	69.96	0.00	0.00	f
2949	1766	DISQUETES VERBATIM 3.5" (CAJA 10 u.)			f	t	\N	2	08111766	191	\N	t	2.27	0.00	0.00	f
2951	1779	MICROFONO SOBREMESA NGS MS102 DESKTOP MICROPH			f	t	\N	2	09071779	189	\N	t	1.78	0.00	0.00	f
4579	1837	PACK 4 ROTULADORES VERBATIM			f	t	\N	2	09021837	107	\N	t	2.84	0.00	0.00	f
2956	1933	TONER IMP. HP 1200/3330 MULTIFUNCION (C7115A)			f	t	\N	2	08091933	136	\N	t	50.72	0.00	0.00	f
2957	1935	CABLE USB 1,8 MTS A/A M/M SB1000			f	t	\N	2	09011935	106	\N	t	2.41	0.00	0.00	f
4580	1989	SWITCH D-LINK DES-1005D/E 5 PTOS 10/100, 1 PT			f	t	\N	2	07021989	95	\N	t	16.06	0.00	0.00	f
2958	2059	CART. HP NEGRO Nº45 DJ700 800 900 (51645AE)			f	t	\N	2	08072059	133	\N	t	24.41	0.00	0.00	f
2959	2060	CART. HP COLOR Nº23 DJ 700 SERIES OFFICEJET R			f	t	\N	2	08072060	133	\N	t	27.54	0.00	0.00	f
2962	2126	REPETIDOR SEÑAL VIDEO/AUDIO CONCEPTRONIC (CVI			f	t	\N	2	09022126	107	\N	t	43.95	0.00	0.00	f
2963	2141	MEMORIA SO DIMM SDRAM 256 MB 133 MHZ KINGSTON			f	t	\N	2	03282141	193	\N	t	31.87	0.00	0.00	f
2964	2147	BOBINA CABLE UTP FLEXIBLE CAT.5E 305 MTS			f	t	\N	2	07052147	188	\N	t	133.39	0.00	0.00	f
2965	2169	TONER IMP. SAMSUNG ML 1510/1710/1750			f	t	\N	2	08092169	136	\N	t	64.93	0.00	0.00	f
2966	2176	AURICULAR CON MICRO LOGITECH CHAT HEADSET			f	t	\N	2	09072176	189	\N	t	19.88	0.00	0.00	f
5324	7370	LATIGUILLO FIBRA OPTICA ST-ST DE 4 MTS			f	t	\N	2	07057370	188	\N	t	51.61	0.00	0.00	f
2969	2202	ESCANER HP SCANJET 2400 A4 USB			f	t	\N	2	04052202	69	\N	t	73.39	0.00	0.00	f
2971	2243	ARCHIVADOR CD S NGS WALLETS URBAN LINE 240 U			f	t	\N	2	09102243	190	\N	t	21.73	0.00	0.00	f
2973	2245	ARCHIVADOR CD S NGS WALLETS TRENDY LINE 104 U			f	t	\N	2	09102245	190	\N	t	14.47	0.00	0.00	f
2974	2246	RATON NGS OPTICAL VIP MOUSE P/ PORTATILES			f	t	\N	2	04082246	72	\N	t	11.55	0.00	0.00	f
4581	2248	MEMORIA SO DIMM DDR 512 MB 266Mhz			f	t	\N	2	03282248	193	\N	t	48.33	0.00	0.00	f
2976	2253	AURICULAR CONCEPTRONIC BLUETOOTH MANOS LIBRES			f	t	\N	2	09072253	189	\N	t	34.23	0.00	0.00	f
2977	2254	IMP.TICKETS EPSON TM-U220PD-002 PARALELO			f	t	\N	2	05032254	120	\N	t	215.11	0.00	0.00	f
4252	2295	CABLE VGA 5 MTS. M-H (ALARGADOR) AK4225			f	t	\N	2	09012295	106	\N	t	7.71	0.00	0.00	f
2980	2299	DISCO ZIP 750 MB			f	t	\N	2	08042299	102	\N	t	14.22	0.00	0.00	f
2981	2302	RATON NGS VISION OPTICAL PS2 INTERNET CON RUE			f	t	\N	2	04082302	72	\N	t	10.72	0.00	0.00	f
2982	2312	SWITCH D-LINK 16 PUERTOS DES-1016 D/E			f	t	\N	2	07022312	95	\N	t	46.86	0.00	0.00	f
2983	2317	SAI NGS 850 CHRONUS OFF LINE			f	t	\N	2	04142317	81	\N	t	118.82	0.00	0.00	f
2985	2375	ALTAVOCES NGS SYSTEM 850 2.1 SW850			f	t	\N	2	04062375	70	\N	t	25.00	0.00	0.00	f
2989	2379	REGLETA NGS SURGE TEL 600 6 TOMAS + FAX			f	t	\N	2	09022379	107	\N	t	12.39	0.00	0.00	f
2990	2380	REGLETA NGS SURGE TEL 700 7 TOMAS + FAX			f	t	\N	2	09022380	107	\N	t	16.53	0.00	0.00	f
2991	2381	AURICULAR CON MICROFONO NGS REG. VOLUMEN MS10			f	t	\N	2	09072381	189	\N	t	7.23	0.00	0.00	f
2992	2382	AURICULAR CON MICROFONO NGS VOX 220DJ MULTIME			f	t	\N	2	09072382	189	\N	t	9.46	0.00	0.00	f
2993	2383	AURICULAR CON MICROFONO NGS VOX 240 MULTIMEDI			f	t	\N	2	09072383	189	\N	t	11.12	0.00	0.00	f
2995	2389	CAMARA WEB NGS SHOW CAM PLUS 300K USB			f	t	\N	2	04112389	75	\N	t	20.69	0.00	0.00	f
3002	2412	USB 2.0 DATA BRIDGE CONCEPTRONIC TRANSF. DATO			f	t	\N	2	09012412	106	\N	t	15.16	0.00	0.00	f
4255	2463	CART. EPSON C64 C84 CX3650 400 NEGRO (C13T044			f	t	\N	2	08072463	133	\N	t	17.36	0.00	0.00	f
4583	2496	CARCASA RACK VIPOWER VP-10LSFU-133 UDMA133			f	t	\N	2	04232496	148	\N	t	6.17	0.00	0.00	f
3008	2501	ADAPTADOR CABLE CORRIENTE DISCO DURO A SERIAL			f	t	\N	2	03012501	28	\N	t	1.81	0.00	0.00	f
4372	6097	RW DVD DUAL DL ASUS 16X8X16X DRW-1608P3S NEGR			f	t	\N	2	03226097	128	\N	t	30.12	0.00	0.00	f
4353	5776	SOFT. WINDOWS 2003 SERVER SBS SP1 R2 OEM + 5 			f	t	\N	2	03305776	184	\N	t	415.83	0.00	0.00	f
3010	2524	SWITCH D-LINK 8 PUERTOS 10/100 DES-1008D			f	t	\N	2	07022524	95	\N	t	20.08	0.00	0.00	f
3014	2551	TAMBOR HP LASERJET 1500/2500 SERIES C9704A			f	t	\N	2	08092551	136	\N	t	136.28	0.00	0.00	f
3018	2567	REGLETA NGS SURGE TEL 500 5 TOMAS + FAX			f	t	\N	2	09022567	107	\N	t	10.72	0.00	0.00	f
3024	2639	TONER IMP. HP LASERJET 4000/4050 SERIES C4127			f	t	\N	2	08092639	136	\N	t	79.90	0.00	0.00	f
4585	2643	CART. EPSON PHOTO 950 NEGRO (C13T033140)			f	t	\N	2	08072643	133	\N	t	14.14	0.00	0.00	f
3027	2655	CART. JT EPSON C82/CX5200/5400 MAGENT 9183MJB			f	t	\N	2	08062655	132	\N	t	7.14	0.00	0.00	f
3029	2657	CART. JT EPSON 680/777 COLOR (T018401) E40			f	t	\N	2	08062657	132	\N	t	9.10	0.00	0.00	f
3030	2661	CABLE VGA M/M 1.8M PROTECCIONES METALICAS AK4			f	t	\N	2	09012661	106	\N	t	4.42	0.00	0.00	f
3032	2670	GUIAS DE GRAVEDAD F-800 (PAR DE GUIAS). RT302			f	t	\N	2	07062670	185	\N	t	23.81	0.00	0.00	f
3033	2696	PACK 5 DVD-RW VERBATIM 4.7GB DATA / VIDEO			f	t	\N	2	08022696	100	\N	t	9.96	0.00	0.00	f
3037	2701	CART. JT EPSON 680/777 NEGRO (T017401) E39			f	t	\N	2	08062701	132	\N	t	8.12	0.00	0.00	f
4257	2719	SOFT. PACK 5 LICENCIAS CAL WINDOWS 2003 SERVE			f	t	\N	2	03302719	184	\N	t	396.69	0.00	0.00	f
3039	2745	CART. EPSON C82 CX5200 CX5400 AMARILLO (T0424			f	t	\N	2	08072745	133	\N	t	15.31	0.00	0.00	f
4586	2746	CART. EPSON PHOTO 870 890 900 1270 1290 NE (T			f	t	\N	2	08072746	133	\N	t	24.20	0.00	0.00	f
3040	2749	CART. EPSON C82 CX5200 CX5400 CYAN (T042240)			f	t	\N	2	08072749	133	\N	t	15.28	0.00	0.00	f
3041	2751	CART. EPSON C82 CX5200 CX5400 MAGENTA (T04234			f	t	\N	2	08072751	133	\N	t	15.43	0.00	0.00	f
3042	2754	CABLE HD SCSI 50 PIN 3 CONECTORES 75 cm			f	t	\N	2	03012754	28	\N	t	1.08	0.00	0.00	f
4587	2770	ROUTER ADSL CONCEPTRONIC + 4 PUERTOS LAN 100M			f	t	\N	2	07072770	220	\N	t	46.17	0.00	0.00	f
4589	2777	CART. EPSON COLOR 400 600 800  (T052040)			f	t	\N	2	08072777	133	\N	t	29.24	0.00	0.00	f
4261	2816	CART. EPSON NEGRO R300/RX500 C13T048140			f	t	\N	2	08072816	133	\N	t	14.77	0.00	0.00	f
4262	2818	CART. EPSON MAGENTA R300/RX500 C13T048340			f	t	\N	2	08072818	133	\N	t	13.23	0.00	0.00	f
4263	2819	CART. EPSON AMARILLO R300/RX500 C13T048440			f	t	\N	2	08072819	133	\N	t	13.23	0.00	0.00	f
4590	2820	CART. EPSON CYAN CLARO R300/RX500 C13T048540			f	t	\N	2	08072820	133	\N	t	13.25	0.00	0.00	f
4264	2821	CART. EPSON MAGENTA CLARO R300 RX500 C13T0486			f	t	\N	2	08072821	133	\N	t	14.23	0.00	0.00	f
3053	2854	SWITCH D-LINK 24P 10/100 DES-1024D NO GEST			f	t	\N	2	07022854	95	\N	t	60.24	0.00	0.00	f
3056	2858	CUBIERTA PARA CABLES NTP 25mm 2 MTS. NEGRO			f	t	\N	2	09022858	107	\N	t	4.89	0.00	0.00	f
3057	2859	CUBIERTA PARA CABLES NTP 25mm 2 MTS. GRIS			f	t	\N	2	09022859	107	\N	t	4.89	0.00	0.00	f
4265	2861	GAMEPAD LOGITECH DUAL ACTION USB			f	t	\N	2	04092861	73	\N	t	24.29	0.00	0.00	f
4266	2888	TONER IMP. HP LASERJET 2500 1500 CIAN C9701A			f	t	\N	2	08092888	136	\N	t	79.90	0.00	0.00	f
4267	2968	CABLE HD SATA 75 CM			f	t	\N	2	03012968	28	\N	t	6.27	0.00	0.00	f
3066	2971	TONER IMP. HP LASERJET 1100 3200 C4092A			f	t	\N	2	08092971	136	\N	t	46.02	0.00	0.00	f
3069	2979	CAJA SEMITORRE ATX G313 NEGRA USB+AUDIO C2628			f	t	\N	2	03022979	31	\N	t	49.40	0.00	0.00	f
3071	2993	T.RED PCI D-LINK DGE-530T 10/100/1000			f	t	\N	2	03292993	183	\N	t	18.07	0.00	0.00	f
4591	3006	CART. EPSON PHOTO 950 MAGENTA CLARO (C13T0336			f	t	\N	2	08073006	133	\N	t	14.11	0.00	0.00	f
4269	3007	CART. EPSON PHOTO 950 CYAN CLARO (C13T033540)			f	t	\N	2	08073007	133	\N	t	14.36	0.00	0.00	f
3077	3013	CART. JT EPSON PHOTO 950 MAGENTA (C13T033340)			f	t	\N	2	08063013	132	\N	t	7.81	0.00	0.00	f
3079	3015	CART. JT EPSON STYLUS 900 COLOR E18 (C13T0050			f	t	\N	2	08063015	132	\N	t	6.17	0.00	0.00	f
3080	3016	CART. JT EPSON STYLUS 900 NEGRO E19 (C13T0030			f	t	\N	2	08063016	132	\N	t	3.25	0.00	0.00	f
3082	3018	CART. JT EPSON CYAN R200/RX500 C13T048240 E92			f	t	\N	2	08063018	132	\N	t	6.82	0.00	0.00	f
3084	3020	CART. JT EPSON AMARILLO R200/RX500 C13T048440			f	t	\N	2	08063020	132	\N	t	6.82	0.00	0.00	f
3086	3026	TORNILLOS PARA ARMARIOS 10 PIEZAS (BOLSA)			f	t	\N	2	07063026	185	\N	t	3.96	0.00	0.00	f
3640	5169	SWITCH CONCEPTRONIC 8 PTOS. 10/100/1000  CGIG			f	t	\N	2	07025169	95	\N	t	64.08	0.00	0.00	f
3087	3027	KVM MINI PS2 AUTO CON CABLES 2 CPU S AB7522			f	t	\N	2	09023027	107	\N	t	42.01	0.00	0.00	f
3102	3126	T.RED PCI CONCEPTRONIC WIRELESS 54Mbps C54RI			f	t	\N	2	07013126	94	\N	t	18.77	0.00	0.00	f
4270	3131	CINTA IMPR. TICKETS EP210 Y SM270 BICOLOR (ER			f	t	\N	2	08053131	103	\N	t	3.01	0.00	0.00	f
3104	3136	SVGA G-FORCE IV FX5500 256MB TV DVI 8X			f	t	\N	2	03173136	55	\N	t	34.41	0.00	0.00	f
3105	3143	CABLE FIREWIRE 1.8 mts  6 pines M / M FW1020			f	t	\N	2	09013143	106	\N	t	4.18	0.00	0.00	f
3106	3144	CABLE FIREWIRE 4.5 mts 6 p. M / H (Ext.) FW13			f	t	\N	2	09013144	106	\N	t	7.23	0.00	0.00	f
3107	3145	CABLE FIREWIRE 1.8 mts  6M / 4M FW1420			f	t	\N	2	09013145	106	\N	t	4.01	0.00	0.00	f
3111	3153	EXTRAIBLE HD SATA DE ALUMINIO PHASAK PH1180			f	t	\N	2	09023153	107	\N	t	25.60	0.00	0.00	f
3112	3156	LIMPIADOR SPRAY DE AIRE COMPRIMIDO (400 ml) D			f	t	\N	2	09023156	107	\N	t	4.14	0.00	0.00	f
3113	3159	LATIGUILLO UTP CAT.5E DE 2 MTS CRUZADO NEGRO			f	t	\N	2	07053159	188	\N	t	1.20	0.00	0.00	f
3115	3161	LATIGUILLO UTP CAT.5E DE 5 MTS CRUZADO NEGRO			f	t	\N	2	07053161	188	\N	t	1.66	0.00	0.00	f
3116	3180	ALFOMBRILLA SERIGRAFIADA CEREZAS MPI 097			f	t	\N	2	09093180	192	\N	t	0.53	0.00	0.00	f
3117	3182	ALFOMBRILLA SERIGRAFIADA RATON Y RATON MPI 12			f	t	\N	2	09093182	192	\N	t	0.53	0.00	0.00	f
3118	3189	RATON NGS EVO WIRELESS OPTICAL USB			f	t	\N	2	04083189	72	\N	t	12.37	0.00	0.00	f
3119	3192	SERV. IMPRESORA D-LINK 1 PUERTO USB DP-301U E			f	t	\N	2	07023192	95	\N	t	72.70	0.00	0.00	f
3121	3210	KIT LIMPIADOR LECTOR CD CD-R  - FD90			f	t	\N	2	09023210	107	\N	t	3.17	0.00	0.00	f
3124	3225	SERV. IMPRESORA D-LINK 2PTOS PARA +1USB DP-30			f	t	\N	2	07023225	95	\N	t	94.17	0.00	0.00	f
3126	3229	SERV. IMPRESORA D-LINK 1P USB 2.0 DP-G310 WIR			f	t	\N	2	07023229	95	\N	t	96.94	0.00	0.00	f
3127	3231	TRAVEL KIT NGS MALETIN ORGANIZER MINIHUB 4 VI			f	t	\N	2	09103231	190	\N	t	38.92	0.00	0.00	f
3128	3233	SWITCH D-LINK 8P 10/100/1000 DGS-1008D NO GES			f	t	\N	2	07023233	95	\N	t	64.94	0.00	0.00	f
3130	3239	CART. HP TRICOLOR Nº17 840/845C (C6625AE) 15 			f	t	\N	2	08073239	133	\N	t	23.10	0.00	0.00	f
3133	3247	CAJA SEMITORRE ATX LC323 NEGRO ( C2628 )			f	t	\N	2	03023247	31	\N	t	48.19	0.00	0.00	f
4592	3257	ADAPTADOR USB 2.0 10/100 CONCEPTRONIC CSP480L			f	t	\N	2	04233257	148	\N	t	27.54	0.00	0.00	f
4593	3263	ROUTER VPN SERVER D-LINK 4P/ 1PWAN/ DI-804HV			f	t	\N	2	07073263	220	\N	t	76.18	0.00	0.00	f
3145	3302	TONER IMP. HP LASERJET 1150 SERIES Q2624A			f	t	\N	2	08093302	136	\N	t	57.49	0.00	0.00	f
3147	3307	TONER IMP. HP LASERJET 2300 NEGRO Q2610A			f	t	\N	2	08093307	136	\N	t	92.87	0.00	0.00	f
3150	3330	CONTROL REMOTO NGS PRESENTACIONES RECEPTOR US			f	t	\N	2	09023330	107	\N	t	21.19	0.00	0.00	f
3154	3335	MALETIN MONRAY SHUTTLE MAX. PROTECCION C/RUED			f	t	\N	2	09103335	190	\N	t	40.71	0.00	0.00	f
3155	3336	MALETIN MONRAY BIG GUN			f	t	\N	2	09103336	190	\N	t	23.29	0.00	0.00	f
3156	3337	MALETIN MONRAY NOTEPACK			f	t	\N	2	09103337	190	\N	t	31.08	0.00	0.00	f
4594	3346	ANTENA D-LINK ANT24-0801 8.5dBi INT & EXT PAR			f	t	\N	2	07013346	94	\N	t	99.71	0.00	0.00	f
3160	3364	ALTAVOCES LOGITECH X-230 / 2.1			f	t	\N	2	04063364	70	\N	t	45.77	0.00	0.00	f
3161	3370	ADAPTADOR PCI CONCEPT. PARA TARJ. PCMCIA CIPC			f	t	\N	2	04233370	148	\N	t	40.75	0.00	0.00	f
3164	3382	BANDEJA FIJA 19" 600x600 420mm PROFUNDIDAD RS			f	t	\N	2	07063382	185	\N	t	27.78	0.00	0.00	f
3165	3385	PACK 10 CD-R VERBATIM 700MB 52X SUPERAZO			f	t	\N	2	08013385	99	\N	t	8.12	0.00	0.00	f
3166	3386	PACK 10CDR VERBATIM 700MB 52X SLIM COLOR			f	t	\N	2	08013386	99	\N	t	7.82	0.00	0.00	f
3167	3401	AURICULAR CON MICRO NGS MS107 VIBRACION			f	t	\N	2	09073401	189	\N	t	24.23	0.00	0.00	f
3171	3408	TECLADO NGS CUTEBLACK 108 TECLAS NEGRO			f	t	\N	2	04073408	71	\N	t	7.40	0.00	0.00	f
3174	3412	USB 2.0 DATA BRIDGE NGS TRANSFER 2 DISP SIN P			f	t	\N	2	09013412	106	\N	t	31.96	0.00	0.00	f
4595	3415	ARCHIVADOR CD S NGS WALLETS STRIP LINE 32 U			f	t	\N	2	09103415	190	\N	t	7.19	0.00	0.00	f
3175	3416	ARCHIVADOR CD S NGS WALLETS TAGGER LINE 32 U			f	t	\N	2	09103416	190	\N	t	7.19	0.00	0.00	f
3178	3426	GAMEPAD NGS SPACE DEFENDER INALAMBRICO USB			f	t	\N	2	04093426	73	\N	t	33.55	0.00	0.00	f
3185	3451	GATEWAY CONCEPTRONIC WIRELESS C54BRS4			f	t	\N	2	07013451	94	\N	t	38.27	0.00	0.00	f
3186	3453	TONER IMP. HP LASERJET 1160/1320 SERIES Q5949			f	t	\N	2	08093453	136	\N	t	54.13	0.00	0.00	f
3187	3454	ALFOMBRILLA DE PVC VERDE MP GROEN			f	t	\N	2	09093454	192	\N	t	0.60	0.00	0.00	f
3188	3460	MEMORIA DIMM DDR2 512 MB 533Mhz KINGSTON			f	t	\N	2	03143460	52	\N	t	13.13	0.00	0.00	f
3190	3468	ARCHIVADOR CD S NGS WALLETS DINAMIC 56 U			f	t	\N	2	09103468	190	\N	t	8.72	0.00	0.00	f
3191	3480	BANDEJA FRONTAL 19" 280mm PERFORADA RS2020			f	t	\N	2	07063480	185	\N	t	21.27	0.00	0.00	f
3192	3481	PANEL FRONTAL 19" GUIA CABLES 5ESTRIBOS (RF30			f	t	\N	2	07063481	185	\N	t	25.52	0.00	0.00	f
3193	3492	CABLE USB 3 Mts. M/H (EXTENSION) KO 1230  A/A			f	t	\N	2	09013492	106	\N	t	1.77	0.00	0.00	f
4596	3497	ANTENA D-LINK ANT24-1400 14dBi EXTERIOR DIREC			f	t	\N	2	07013497	94	\N	t	138.48	0.00	0.00	f
3199	3531	MEMORIA DIMM DDR2 1024MB 533MHz KINGSTON CL4			f	t	\N	2	03143531	52	\N	t	23.78	0.00	0.00	f
4276	3584	CART. EPSON S.C. 400 440 500 600 640 (T050140			f	t	\N	2	08073584	133	\N	t	25.14	0.00	0.00	f
4597	3585	CART. EPSON PHOTO 700/EX 750/M C13T053040LB			f	t	\N	2	08073585	133	\N	t	20.80	0.00	0.00	f
3206	3586	TONER IMP. HP LASERJET 2100 2200 8150N (C4096			f	t	\N	2	08093586	136	\N	t	78.87	0.00	0.00	f
3207	3587	TONER IMP. EPSON ACULASER C900 C1900 AMARILLO			f	t	\N	2	08093587	136	\N	t	136.92	0.00	0.00	f
4277	3588	TONER IMP. EPSON ACULASER C900 C1900 MAGENTA			f	t	\N	2	08093588	136	\N	t	136.92	0.00	0.00	f
4278	3589	TONER IMP. EPSON ACULASER C900 C1900 CYAN			f	t	\N	2	08093589	136	\N	t	138.88	0.00	0.00	f
3208	3603	MODEM 56K SERIE CONCEPTRONIC C56EW			f	t	\N	2	04043603	68	\N	t	26.75	0.00	0.00	f
3209	3604	MODEM 56K PCI CONCEPTRONIC CONEXANT RETAIL C5			f	t	\N	2	03213604	126	\N	t	9.73	0.00	0.00	f
3219	3638	BLISTER 1UD PILA CEGASA CR2025 LITIO 3V			f	t	\N	2	09023638	107	\N	t	0.55	0.00	0.00	f
3220	3641	CART. HP NEGRO Nº29 DJ 600 OJ 500 700 51629AE			f	t	\N	2	08073641	133	\N	t	27.55	0.00	0.00	f
3221	3642	CART. HP COLOR Nº49 DJ 600 OJ 500 700 51649AE			f	t	\N	2	08073642	133	\N	t	28.47	0.00	0.00	f
3222	3643	TONER IMP. HP LASERJET  SERIES Q5949X ALTA CA			f	t	\N	2	08093643	136	\N	t	104.69	0.00	0.00	f
4598	3647	HD PORTATIL 80 GB SAMSUNG 2.5" 5400RPM 8M			f	t	\N	2	03273647	194	\N	t	57.72	0.00	0.00	f
3223	3648	RATON NGS SATELLITE RF 5 BOTONES			f	t	\N	2	04083648	72	\N	t	29.00	0.00	0.00	f
3225	3654	MEMORIA SO DIMM DDR 512 MB 400MHz KINGSTON			f	t	\N	2	03283654	193	\N	t	33.01	0.00	0.00	f
3229	3688	CINTA TRAVAN HP 8GB TR-4 MINICARTUCHO C4425A			f	t	\N	2	08033688	101	\N	t	32.61	0.00	0.00	f
3231	3714	CART. HP NEGRO Nº26 DJ 500 400 51626AE			f	t	\N	2	08073714	133	\N	t	29.49	0.00	0.00	f
3232	3719	CART. JT EPSON STYLUS RX420 RX 425 NEGRO E95B			f	t	\N	2	08063719	132	\N	t	5.19	0.00	0.00	f
3233	3720	CART. JT EPSON STYLUS RX420 RX 425 CYAN E95C			f	t	\N	2	08063720	132	\N	t	4.69	0.00	0.00	f
3234	3721	CART. JT EPSON STYLUS RX420 RX 425 MAGENTA E9			f	t	\N	2	08063721	132	\N	t	5.19	0.00	0.00	f
3236	3725	CART. HP NEGRO Nº339 DESKJET 6840 C8767EE			f	t	\N	2	08073725	133	\N	t	22.08	0.00	0.00	f
3237	3726	CART. HP COLOR Nº 344 DESKJET 6840 C9363EE			f	t	\N	2	08073726	133	\N	t	24.77	0.00	0.00	f
3238	3738	SENSOR REDES WIFI CONCEPTRONIC CWIFIS			f	t	\N	2	07013738	94	\N	t	16.00	0.00	0.00	f
3248	3800	EXTRAIBLE HD IDE PLASTICO PHASAK SI1180 MARFI			f	t	\N	2	09023800	107	\N	t	9.04	0.00	0.00	f
3249	3801	EXTRAIBLE HD IDE PLASTICO PHASAK SI1184 NEGRO			f	t	\N	2	09023801	107	\N	t	10.40	0.00	0.00	f
4163	6194	CAMARA WEB CONCEPTRONIC DESKCAM PRO CDESKCAM			f	t	\N	2	04116194	75	\N	t	18.14	0.00	0.00	f
3250	3806	ESCANER HP SCANJET 5590 USB2 ALIM AUTO 2CARAS			f	t	\N	2	04053806	69	\N	t	470.39	0.00	0.00	f
4281	3840	TONER IMP. HP LASERJET 2550 SERIES NEGRO Q396			f	t	\N	2	08093840	136	\N	t	65.16	0.00	0.00	f
3255	3841	TONER IMP. HP LASERJET 2550 SERIES AMARILLO Q			f	t	\N	2	08093841	136	\N	t	79.90	0.00	0.00	f
3257	3844	RECARGADOR DISPOSITIVOS USB  COCHE Y CASA RIM			f	t	\N	2	09023844	107	\N	t	7.59	0.00	0.00	f
3259	3854	CABLE FIREWIRE 1.8 mts  4M / 4M FW1220			f	t	\N	2	09013854	106	\N	t	4.66	0.00	0.00	f
3260	3856	DATA SWITCH MANUAL 1X2 USB 1.1 SD6010			f	t	\N	2	09023856	107	\N	t	10.54	0.00	0.00	f
3262	3861	DESKTOP NGS PLANET KIT OPTICAL			f	t	\N	2	04073861	71	\N	t	43.27	0.00	0.00	f
3263	3864	LEC. TARJ. 14 EN 1 CONCEPTRONIC USB 2.0 INT. 			f	t	\N	2	04233864	148	\N	t	28.77	0.00	0.00	f
3266	3874	RATON NGS SYMBIOSIS POWERED BLANCO			f	t	\N	2	04083874	72	\N	t	3.49	0.00	0.00	f
4600	3885	TONER IMP. HP LASERJET 2550 SERIES CYAN Q3961			f	t	\N	2	08093885	136	\N	t	78.48	0.00	0.00	f
4284	3886	TONER IMP. HP LASERJET 2550 SERIES MAGENTA Q3			f	t	\N	2	08093886	136	\N	t	78.48	0.00	0.00	f
3269	3888	CAJON PORTAMONEDAS TPV 41 CM. AUTOMATICO NEGR			f	t	\N	2	05033888	120	\N	t	43.00	0.00	0.00	f
4167	6198	REPRODUCTOR HD CONCEPTRONIC MULTIMEDIA 320 GB			f	t	\N	2	13046198	198	\N	t	165.52	0.00	0.00	f
3270	3889	IMP. TICKETS EPSON TM-U220PD-052 NEGRA PARALE			f	t	\N	2	05033889	120	\N	t	212.76	0.00	0.00	f
3271	3891	LECTOR C.B. METROLOGIC MS-9520 VOYAGER (USB)			f	t	\N	2	05033891	120	\N	t	163.40	0.00	0.00	f
3273	3894	LECTOR C.B. METROLOGIC MS-9520 VOYAGER (TEC) 			f	t	\N	2	05033894	120	\N	t	163.54	0.00	0.00	f
4602	3906	AURICULAR CON MICRO LOGITECH PREMIUM STEREO H			f	t	\N	2	09073906	189	\N	t	21.36	0.00	0.00	f
3278	3910	CART. JT EPSON C70 C80 MAGENTA E84M			f	t	\N	2	08063910	132	\N	t	7.14	0.00	0.00	f
3285	3928	REGLETA 19" PROTECCION 6TOMAS+2TEL/FAX			f	t	\N	2	07063928	185	\N	t	26.93	0.00	0.00	f
3286	3930	CART. EPSON C64 C84 CX3650 250 AMARILLO C13T0			f	t	\N	2	08073930	133	\N	t	10.19	0.00	0.00	f
3287	3931	CART. EPSON C64 C84 CX3650 250 CYAN C13T04524			f	t	\N	2	08073931	133	\N	t	10.34	0.00	0.00	f
3288	3932	CART. EPSON C64 C84 CX3650 250 MAGENTA C13T04			f	t	\N	2	08073932	133	\N	t	10.07	0.00	0.00	f
4603	3936	GATEWAY LINKSYS WRT54GS WIRELESS 54MBPS SB + 			f	t	\N	2	07013936	94	\N	t	70.39	0.00	0.00	f
3293	3944	CART. EPSON 4 TINTAS C64 C84 CX3650 400 T0441			f	t	\N	2	08073944	133	\N	t	39.36	0.00	0.00	f
3295	3948	VENTILACION TECHO ARMARIO 600X600 800 1000 4V			f	t	\N	2	07063948	185	\N	t	141.04	0.00	0.00	f
3296	3949	LATIGUILLO UTP CAT.6 DE 5MTS GRIS PL1605			f	t	\N	2	07053949	188	\N	t	5.35	0.00	0.00	f
3303	3958	BANDEJA FRONTAL 19" PARA DISP. DE 170mm 1U RS			f	t	\N	2	07063958	185	\N	t	20.55	0.00	0.00	f
3304	3960	CAJA THERMALTAKE SOPRANO VB1000SWS PLATA VENT			f	t	\N	2	03023960	31	\N	t	82.12	0.00	0.00	f
3306	3985	HD 250 GB ATA SEAGATE 7200 RPM 8MB			f	t	\N	2	03163985	54	\N	t	57.23	0.00	0.00	f
3308	3990	IMPRESORA HP LASERJET 1020 USB Q5911A			f	t	\N	2	04243990	173	\N	t	134.17	0.00	0.00	f
3311	4002	MALETIN MONRAY STELLA FEMENINO VERDE			f	t	\N	2	09104002	190	\N	t	27.19	0.00	0.00	f
3312	4007	TAMBOR HP LASERJET 2550 SERIES (Q3964A)			f	t	\N	2	08094007	136	\N	t	136.28	0.00	0.00	f
4605	4009	TONER IMP. EPSON EPL-6200 EPL-6200L 3000 HOJA			f	t	\N	2	08094009	136	\N	t	78.84	0.00	0.00	f
3314	4012	CPU AMD ATHLON64 3500+ S939 2.2GHZ 512KB  BOX			f	t	\N	2	03124012	50	\N	t	64.42	0.00	0.00	f
3321	4027	LATIGUILLO UTP CAT.5E DE 5 MTS NEGRO PL 4005			f	t	\N	2	07054027	188	\N	t	1.96	0.00	0.00	f
3322	4028	CABLE PS/2 M/M 5 MTS			f	t	\N	2	09014028	106	\N	t	2.25	0.00	0.00	f
3324	4034	TONER IMP. HP LASERJET 2550 SERIES AMARILLO Q			f	t	\N	2	08094034	136	\N	t	59.33	0.00	0.00	f
3325	4035	TONER IMP. HP LASERJET 2550 SERIES CYAN Q3971			f	t	\N	2	08094035	136	\N	t	59.41	0.00	0.00	f
4606	4036	TONER IMP. HP LASERJET 2550 SERIES MAGENTA Q3			f	t	\N	2	08094036	136	\N	t	59.63	0.00	0.00	f
3326	4043	CINTA DAT DDS5 HP 170M DAT 72 72/36GB C8010A			f	t	\N	2	08034043	101	\N	t	13.75	0.00	0.00	f
3327	4046	IMPRESORA HP DESKJET 1280 A3 USB PARALELO C81			f	t	\N	2	04034046	67	\N	t	240.08	0.00	0.00	f
4655	5729	MINIPC ASUS T2-PH2 S775 PCI-E DDR2 GLAN SATA 			f	t	\N	2	03025729	31	\N	t	174.41	0.00	0.00	f
4608	4061	ADAPTADOR VOIP RIMAX DUAL VOIP			f	t	\N	2	13074061	203	\N	t	31.01	0.00	0.00	f
4290	4066	BACKUP EXT. IOMEGA REV DRIVE 35GB USB 2.0 + 5			f	t	\N	2	04194066	142	\N	t	499.46	0.00	0.00	f
3333	4074	T.RED PCMCIA D-LINK WIRELESS LAN DWL-G650 108			f	t	\N	2	07014074	94	\N	t	33.61	0.00	0.00	f
3337	4081	CABLE D-LINK PROLONGACION ANTENA N-N WIRELESS			f	t	\N	2	07014081	94	\N	t	26.31	0.00	0.00	f
3338	4082	CABLE D-LINK PROLONGACION ANTENA N-N WIRELESS			f	t	\N	2	07014082	94	\N	t	34.63	0.00	0.00	f
3340	4086	PAPEL FOTO BRILLO 13x18 210 GRS. 12 UDS OCI48			f	t	\N	2	08104086	137	\N	t	6.02	0.00	0.00	f
3342	4094	IMP. TICKETS SAMSUNG SRP-275 AP PARALELO			f	t	\N	2	05034094	120	\N	t	183.66	0.00	0.00	f
3344	4097	FUNDA PROT. CONECTOR RJ45 AMARILLO 10Uds. TT 			f	t	\N	2	07054097	188	\N	t	1.49	0.00	0.00	f
3345	4104	T.RED PCI CONCEPTRONIC 10/100/1000 W.O.L. C1G			f	t	\N	2	03294104	183	\N	t	10.92	0.00	0.00	f
4291	4105	T.RED PCMCIA CONCEPTRONIC 10/100/1000 C1GC			f	t	\N	2	04154105	82	\N	t	25.27	0.00	0.00	f
3350	4112	PACK 10 DVD+R VERBATIM 16X 4.7 GB PRINTABLE			f	t	\N	2	08024112	100	\N	t	13.93	0.00	0.00	f
3351	4115	CABLE D-LINK ADAPTADOR N-SMA ANTENA WIRELESS 			f	t	\N	2	07014115	94	\N	t	9.70	0.00	0.00	f
3352	4116	IMPRESORA HP LASERJET 1022 USB Q5912A			f	t	\N	2	04244116	173	\N	t	203.31	0.00	0.00	f
3353	4121	PACK 10 CD-R VERBATIM 700MB 52X S.AZO LIGHTSC			f	t	\N	2	08014121	99	\N	t	10.75	0.00	0.00	f
3362	4161	CONVERSOR VGA-TV USB 1280X1024 VT1010			f	t	\N	2	04204161	143	\N	t	55.40	0.00	0.00	f
4611	4178	TAMBOR OKI C5100 5300 SERIES AMARILLO			f	t	\N	2	08094178	136	\N	t	106.95	0.00	0.00	f
4612	4179	TAMBOR OKI C5100 5300 SERIES NEGRO			f	t	\N	2	08094179	136	\N	t	90.47	0.00	0.00	f
3366	4190	DESKTOP NGS CORDLESS SET OPTICAL			f	t	\N	2	04074190	71	\N	t	21.07	0.00	0.00	f
3371	4206	PACK 10 DVD-R VERBATIM 16X 4.7 GB PRINTABLE			f	t	\N	2	08024206	100	\N	t	14.70	0.00	0.00	f
4113	6138	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB			f	t	\N	2	03166138	54	\N	t	69.25	0.00	0.00	f
3375	4225	ANTENA D-LINK 24-0700 INTERIOR 7 dBi OMNIDIRE			f	t	\N	2	07014225	94	\N	t	78.94	0.00	0.00	f
3384	4262	RATON NGS VIPER SPORT OPTICO USB PS2 BLANCO			f	t	\N	2	04084262	72	\N	t	11.55	0.00	0.00	f
3385	4263	BOLSA CAMARA MONRAY OASIS 300			f	t	\N	2	13034263	199	\N	t	19.47	0.00	0.00	f
3390	4268	BOLSA CAMARA MONRAY SHELL D500			f	t	\N	2	13034268	199	\N	t	9.73	0.00	0.00	f
3391	4269	MALETIN MONRAY TROOPER VERDE C/RUEDAS			f	t	\N	2	09104269	190	\N	t	40.42	0.00	0.00	f
3392	4270	BOLSA CAMARA MONRAY DUNE 300			f	t	\N	2	13034270	199	\N	t	26.48	0.00	0.00	f
3394	4272	DESKTOP NGS INALAMBRICO SLIM KIT OPTICAL SNOW			f	t	\N	2	04074272	71	\N	t	37.31	0.00	0.00	f
3792	5579	PB ASROCK 775i945GZ DDR2 VGA AGIE SATA2 SON L			f	t	\N	2	03115579	86	\N	t	60.55	0.00	0.00	f
3395	4273	AURICULAR NGS ENVOLVE SURROUND 5.1			f	t	\N	2	09074273	189	\N	t	37.39	0.00	0.00	f
4956	6826	CART. BROTHER MFC240C 440CN MAGENTA LC1000M			f	t	\N	2	08076826	133	\N	t	10.08	0.00	0.00	f
5325	7371	RATON NGS METEOR RF WIRELESS OPTICAL USB			f	t	\N	2	04087371	72	\N	t	16.53	0.00	0.00	f
4615	4336	ALTAVOCES LOGITECH X-530 5.1 140W RMS			f	t	\N	2	04064336	70	\N	t	65.77	0.00	0.00	f
3402	4337	DESKTOP LOGITECH CORDLESS EX 110			f	t	\N	2	04074337	71	\N	t	32.89	0.00	0.00	f
4617	4346	IMPRESORA HP LASERJET 2600N COLOR Q6455A			f	t	\N	2	04244346	173	\N	t	411.01	0.00	0.00	f
3405	4350	MEMORIA SO DIMM SDRAM 512 MB 133 MHZ KINGSTON			f	t	\N	2	03284350	193	\N	t	78.25	0.00	0.00	f
4618	4361	ADAPTADOR CONCEPTRONIC PCMCIA BLUETOOTH 100M			f	t	\N	2	04154361	82	\N	t	46.77	0.00	0.00	f
3406	4362	CART. EPSON PHOTO 870 875 890 895 COLOR C13T0			f	t	\N	2	08074362	133	\N	t	19.40	0.00	0.00	f
3408	4370	ALTAVOCES NGS SPHERE 5.1 BLIND. MAGNET. MANDO			f	t	\N	2	04064370	70	\N	t	65.64	0.00	0.00	f
3414	4391	SVGA SAPPHIRE ATI RADEON 9550 256MB DVI +TV R			f	t	\N	2	03174391	55	\N	t	46.53	0.00	0.00	f
3415	4393	CONTROLADORA PCI 2 PTOS SERIE 4037A			f	t	\N	2	03264393	186	\N	t	29.41	0.00	0.00	f
3417	4400	RATON LOGITECH CORDLESS V200 NOTEBOOK MOUSE P			f	t	\N	2	04084400	72	\N	t	30.39	0.00	0.00	f
3418	4405	TONER IMP. OKI B6100 SERIES NEGRO			f	t	\N	2	08094405	136	\N	t	215.19	0.00	0.00	f
4299	4412	UNIDAD FOTOCONDUCTORA EPSON ACULASER C1100/X1			f	t	\N	2	08094412	136	\N	t	191.80	0.00	0.00	f
3421	4424	TONER IMP. BROTHER TN-8000 NEGRO			f	t	\N	2	08094424	136	\N	t	27.92	0.00	0.00	f
3422	4427	TONER IMP. HP LASERJET 4600 SERIES NEGRO C972			f	t	\N	2	08094427	136	\N	t	123.84	0.00	0.00	f
3425	4435	TONER IMP. HP LASERJET 2600 NEGRO Q6000A			f	t	\N	2	08094435	136	\N	t	56.42	0.00	0.00	f
3426	4437	ADAPTADOR VIDEO DVI-VGA  M-H AB 3750			f	t	\N	2	09024437	107	\N	t	5.88	0.00	0.00	f
3428	4439	GAMEPAD NGS PHANTOM 12 BOTONES VIBRACION USB			f	t	\N	2	04094439	73	\N	t	9.89	0.00	0.00	f
3433	4449	LECTOR DE TARJETAS MAGNETICAS PS/2 MR-345			f	t	\N	2	05034449	120	\N	t	65.92	0.00	0.00	f
3434	4453	CART. HP CYAN Nº11 OJ9100 DSJ110 BIJ1000 C483			f	t	\N	2	08074453	133	\N	t	26.58	0.00	0.00	f
4300	4454	CART. HP MAGENTA Nº11 OJ9100 DSJ110 BIJ1000 C			f	t	\N	2	08074454	133	\N	t	25.70	0.00	0.00	f
3435	4455	CART. HP AMARILLO Nº11 OJ9100 DSJ110 BIJ1000 			f	t	\N	2	08074455	133	\N	t	27.46	0.00	0.00	f
4302	4481	IMPRESORA EPSON ACULASER C1100 COLOR USB PARA			f	t	\N	2	04244481	173	\N	t	473.17	0.00	0.00	f
3441	4492	PASAHILOS CEPILLO 1 U. NEGRO RT4701			f	t	\N	2	07044492	150	\N	t	29.77	0.00	0.00	f
3442	4493	PACK 10 CD-RW VERBATIM 32X 700MB			f	t	\N	2	08014493	99	\N	t	16.30	0.00	0.00	f
3447	4516	PEN DRIVE 1 GB KINGSTON USB 2.0 DATA TRAVELLE			f	t	\N	2	04274516	195	\N	t	8.71	0.00	0.00	f
4620	4551	VENTILADOR AMD SPIRE WHISPERROCK V SPA04S4 S4			f	t	\N	2	03134551	51	\N	t	8.99	0.00	0.00	f
3458	4559	ANTENA D-LINK DWL-50AT INTERIOR 5 dBi OMNIDIR			f	t	\N	2	07014559	94	\N	t	9.70	0.00	0.00	f
3459	4560	CAJA THERMALTAKE SWING VB6000BWS NEGRO VENTAN			f	t	\N	2	03024560	31	\N	t	83.06	0.00	0.00	f
4305	4580	ADAPTADOR PARALELO DB25H A CN36H AB9560			f	t	\N	2	09014580	106	\N	t	3.41	0.00	0.00	f
3464	4585	VOLANTE NGS DIABLO VIBRACION DUAL SHOCK			f	t	\N	2	04094585	73	\N	t	37.31	0.00	0.00	f
3465	4586	AURICULAR BOTON NGS MSX1			f	t	\N	2	09074586	189	\N	t	6.57	0.00	0.00	f
3466	4587	GAMEPAD NGS HORNET 10 BOTONES USB			f	t	\N	2	04094587	73	\N	t	8.06	0.00	0.00	f
3467	4588	GAMEPAD NGS MAVERICK 12 BOTONES VIBRACION PS2			f	t	\N	2	04094588	73	\N	t	16.12	0.00	0.00	f
3468	4589	GAMEPAD NGS KIT 2XMAVERICK 12 BOTONES VIBRACI			f	t	\N	2	04094589	73	\N	t	28.35	0.00	0.00	f
3469	4590	RATON NGS BUGGY OPTICO USB			f	t	\N	2	04084590	72	\N	t	11.55	0.00	0.00	f
4621	4598	KIT CAMARA RIMAX 47T COLOR EXT. SMART RECORDE			f	t	\N	2	13054598	202	\N	t	137.23	0.00	0.00	f
4622	4607	FA. FSP UNIV. PORTATIL 90W 19V NB90			f	t	\N	2	02044607	58	\N	t	34.05	0.00	0.00	f
3486	4639	CART. HP NEGRO Nº338 DESKJET 5740 C8765EE			f	t	\N	2	08074639	133	\N	t	15.31	0.00	0.00	f
4625	4641	SVGA RADEON ATI X550XT PCIE 256MB TV DVI RETA			f	t	\N	2	03174641	55	\N	t	55.54	0.00	0.00	f
3489	4656	CARGADOR DE PILAS AA/AAA CEGASA STANDARD			f	t	\N	2	09024656	107	\N	t	14.11	0.00	0.00	f
4308	4657	PILAS RECARGABLES AA 2100 mAh CEGASA BLISTER 			f	t	\N	2	09024657	107	\N	t	14.47	0.00	0.00	f
3490	4658	PILAS RECARGABLES AAA 800 mAh CEGASA BLISTER 			f	t	\N	2	09024658	107	\N	t	6.47	0.00	0.00	f
3491	4659	PILAS RECARGABLES AA 2300 mAh CEGASA BLISTER 			f	t	\N	2	09024659	107	\N	t	8.95	0.00	0.00	f
4626	4668	DESKTOP LOGITECH CORDLESS MX5000 LASER			f	t	\N	2	04074668	71	\N	t	135.51	0.00	0.00	f
3496	4671	DESKTOP LOGITECH CORDLESS S510			f	t	\N	2	04074671	71	\N	t	41.29	0.00	0.00	f
4737	6461	CART. MAXTEC LEXMARK Z13 Z23 Z33 COLOR 10N002			f	t	\N	2	08066461	132	\N	t	22.40	0.00	0.00	f
3497	4672	RATON LOGITECH MINI OPTICAL MOUSE PORTATILES 			f	t	\N	2	04084672	72	\N	t	24.20	0.00	0.00	f
4309	4685	TECLADO REDUCIDO TPV ACK-700 NEGRO			f	t	\N	2	05034685	120	\N	t	22.24	0.00	0.00	f
3519	4737	MICROFONO SOBREMESA LOGITECH USB DESKTOP -47d			f	t	\N	2	09074737	189	\N	t	21.58	0.00	0.00	f
3521	4741	CAMARA WEB NGS BULLS EYE 300K USB 1.1			f	t	\N	2	04114741	75	\N	t	15.70	0.00	0.00	f
3522	4742	CAMARA WEB NGS PACK 2 B&W BULLS EYE 300K USB 			f	t	\N	2	04114742	75	\N	t	24.84	0.00	0.00	f
3523	4745	CABLE AUDIO MINI JACK A RCA M/M 2M AK2230			f	t	\N	2	09014745	106	\N	t	1.93	0.00	0.00	f
4312	4748	CABLE KVM ESPECIFICO 1.8 METROS AK 1840			f	t	\N	2	09024748	107	\N	t	23.25	0.00	0.00	f
3524	4750	TONER IMP. SAMSUNG ML-1610			f	t	\N	2	08094750	136	\N	t	57.63	0.00	0.00	f
4739	6463	CART. MAXTEC BROTHER LC41 47Y 900Y AMARILLO B			f	t	\N	2	08066463	132	\N	t	3.90	0.00	0.00	f
4199	03	BROTHER CART. TINTA MAGENTA LC1000M			t	t	\N	2	080103	99	\N	\N	10.63	0.00	0.00	f
4198	02	BROTHER CART. TINTA AZUL LC1000C			t	t	\N	2	080102	99	\N	\N	10.63	0.00	0.00	f
3527	4757	AURICULAR CONCEPTRONIC INALAMBR. USB CWLHEADP			f	t	\N	2	09074757	189	\N	t	49.27	0.00	0.00	f
3528	4758	CAPTURADORA VIDEO USB2 CONCEPTR.HOME VIDEO CR			f	t	\N	2	04204758	143	\N	t	47.48	0.00	0.00	f
3534	4775	ADAPTADOR CONCEPTRONIC USB 2.0 BLUETOOTH 40M 			f	t	\N	2	04234775	148	\N	t	12.16	0.00	0.00	f
3536	4783	PAPEL ROLLO A1 HP NORMAL 61cm x 45.7 m C6035A			f	t	\N	2	08104783	137	\N	t	17.13	0.00	0.00	f
4745	6475	REGLETA 5 TOMAS CONECTOR PARA SAI PROTEC BNS 			f	t	\N	2	09026475	107	\N	t	5.19	0.00	0.00	f
4628	4792	TELEFONO VOIP RIMAX DUALPHONE INALAMBRICO USB			f	t	\N	2	13074792	203	\N	t	79.08	0.00	0.00	f
4314	4793	SINTONIZADORA TV RIMAX TDT5300 2X SCART SPDIF			f	t	\N	2	04204793	143	\N	t	41.05	0.00	0.00	f
4631	4823	LEC. TARJ. USB 2.0 INTERNO 3.5" NEGRO BLA PLA			f	t	\N	2	03154823	53	\N	t	6.48	0.00	0.00	f
3547	4826	LATIGUILLO UTP CAT.6 15MTS PL 1115			f	t	\N	2	07054826	188	\N	t	15.82	0.00	0.00	f
3548	4827	LATIGUILLO UTP CAT.6 DE 10MTS GRIS PL1610			f	t	\N	2	07054827	188	\N	t	9.18	0.00	0.00	f
3549	4828	LATIGUILLO UTP CAT.6 DE 3MTS GRIS PL1603			f	t	\N	2	07054828	188	\N	t	4.07	0.00	0.00	f
3550	4830	BLISTER 8UDS PILAS CEGASA LR03 EVOLUTION +CAR			f	t	\N	2	09024830	107	\N	t	6.55	0.00	0.00	f
3860	5734	REPRODUCTOR HD CONCEPTRONIC MULTIMEDIA 250 GB			f	t	\N	2	13045734	198	\N	t	141.10	0.00	0.00	f
4746	6476	LATIGUILLO UTP CAT.5E DE 20 MTS MARFIL PL1020			f	t	\N	2	07056476	188	\N	t	9.87	0.00	0.00	f
4555	05	OKI TONER MAGENTA C33/C34			f	f	\N	2	081005	137	\N	\N	38.38	0.00	0.00	f
4554	04	OKI TONER NEGRO C33/C34			f	f	\N	2	081004	137	\N	\N	27.41	0.00	0.00	f
4632	4847	SAI RIELLO DIALOG DUAL DLD330 3300VA USB RS23			f	t	\N	2	04144847	81	\N	t	1544.11	0.00	0.00	f
3555	4859	CART. HP NEGRO Nº336 PSC1510 C9362EE			f	t	\N	2	08074859	133	\N	t	11.89	0.00	0.00	f
3557	4862	CART. EPSON RX420 NEGRO C13T055140LB			f	t	\N	2	08074862	133	\N	t	8.08	0.00	0.00	f
3558	4867	CPU INTEL CELERON D 336+ 2.8 256K 533M S775 B			f	t	\N	2	03124867	50	\N	t	38.07	0.00	0.00	f
3565	4896	HD 160 GB SATA2 SEAGATE 7200RPM 8MB			f	t	\N	2	03164896	54	\N	t	58.60	0.00	0.00	f
3566	4898	CART. HP NEGRO Nº20 DJ610C 640C C6614NE NEGRO			f	t	\N	2	08074898	133	\N	t	15.77	0.00	0.00	f
3569	4922	GUIAS EXTRAIBLES PARA RACK 2U 26" SR-26			f	t	\N	2	07064922	185	\N	t	47.30	0.00	0.00	f
3571	4938	CART. HP COLOR Nº41 DJ 820cxi 850c 870cxi 516			f	t	\N	2	08074938	133	\N	t	27.86	0.00	0.00	f
3575	4962	PAPEL FOTO BRILLO 10x15 260 GRS. 20 UDS OCI48			f	t	\N	2	08104962	137	\N	t	4.25	0.00	0.00	f
4318	4963	TONER IMP. HP LASERJET 3500/50 3700 CYAN Q267			f	t	\N	2	08094963	136	\N	t	105.57	0.00	0.00	f
4369	6031	CAJA SEMITORRE ATX Q29 DISPLAY USB AUDIO			f	t	\N	2	03026031	31	\N	t	52.41	0.00	0.00	f
4086	6110	HD 320 GB SATA2 MAXTOR 7200 RPM 8MB			f	t	\N	2	03166110	54	\N	t	90.64	0.00	0.00	f
4370	6049	PB INTEL S775 BLKD955XCSLKR DDR2 GLAN SATA2 R			f	t	\N	2	03116049	86	\N	t	89.45	0.00	0.00	f
4319	4964	TONER IMP. HP LASERJET 3500/50 3700 AMARILLO 			f	t	\N	2	08094964	136	\N	t	104.22	0.00	0.00	f
3576	4965	TONER IMP. HP LASERJET 3500/50 3700 MAGENTA Q			f	t	\N	2	08094965	136	\N	t	105.57	0.00	0.00	f
3577	4971	CART. EPSON C42 C44 C46 COLOR (T037040)			f	t	\N	2	08074971	133	\N	t	23.23	0.00	0.00	f
3578	4973	TONER IMP. SAMSUNG ML 1520			f	t	\N	2	08094973	136	\N	t	72.12	0.00	0.00	f
3579	4976	LECTOR C.B. CCD-SG303 INFRARROJOS USB			f	t	\N	2	05034976	120	\N	t	88.13	0.00	0.00	f
4530	05	CARTUCHO NEGRO C-LC1000BK			f	f	\N	2	080105	99	\N	\N	19.32	0.00	0.00	f
4548	05	Back Up y restauración de datos			f	f	\N	2	010105	25	\N	\N	30.00	0.00	0.00	f
3581	4978	IMP. TICKETS EPSON TM-T88IV-042 TERMICA USB N			f	t	\N	2	05034978	120	\N	t	333.28	0.00	0.00	f
4635	4986	MEMORIA SO DIMM DDR 1 GB 333Mhz KINGSTON			f	t	\N	2	03284986	193	\N	t	76.99	0.00	0.00	f
4636	5002	CAJA MICRO ATX DM317 PLATA NEGRO 220W			f	t	\N	2	03025002	31	\N	t	55.30	0.00	0.00	f
3585	5012	MEMORIA SO DIMM DDR2 512 MB 400MHz KINGSTON			f	t	\N	2	03285012	193	\N	t	15.13	0.00	0.00	f
3587	5019	CART. JT CANON BJC6000 3000 6200 S400 NEGRO C			f	t	\N	2	08065019	132	\N	t	4.22	0.00	0.00	f
3588	5020	CONTROLADORA 4(+1 INT) PTOS. USB 2.0 CONCEPTR			f	t	\N	2	03265020	186	\N	t	10.37	0.00	0.00	f
3590	5022	TECLADO NUMERICO NGS INALAMBRICO KPLUS CALCUL			f	t	\N	2	04075022	71	\N	t	33.16	0.00	0.00	f
3591	5023	JOYSTICK NGS BLACKHAWK 12 BOTONES 4 EJES			f	t	\N	2	04095023	73	\N	t	21.06	0.00	0.00	f
3598	5031	CART. JT CANON BJC6000 3000 6200 S400 MAGENTA			f	t	\N	2	08065031	132	\N	t	4.22	0.00	0.00	f
4449	6303	HD  80 GB ATA WESTERN DIGITAL 7200 RPM 2MB			f	t	\N	2	03166303	54	\N	t	42.67	0.00	0.00	f
3602	5035	CART. JT CANON BJC6000 3000 6200 FOT MAGENTA 			f	t	\N	2	08065035	132	\N	t	4.22	0.00	0.00	f
3604	5037	CART. JT CANON S200 S300 COLOR C15			f	t	\N	2	08065037	132	\N	t	4.55	0.00	0.00	f
3606	5039	CART. JT RECL LEXMARK JPRINTER 3200 COLOR ML8			f	t	\N	2	08065039	132	\N	t	22.40	0.00	0.00	f
3607	5040	CART. JT RECL LEXMARK Z4X Z5X X63 X7X COLOR M			f	t	\N	2	08065040	132	\N	t	23.37	0.00	0.00	f
3608	5041	CART. JT RECL LEXMARK Z12 Z22 Z32 Z700 NEGRO 			f	t	\N	2	08065041	132	\N	t	22.40	0.00	0.00	f
3609	5042	CART. JT RECL LEXMARK Z12 Z22 Z32 Z700 COLOR 			f	t	\N	2	08065042	132	\N	t	22.40	0.00	0.00	f
3613	5048	CART. HP COLOR Nº 342 PSC1510 C9361EE			f	t	\N	2	08075048	133	\N	t	13.95	0.00	0.00	f
4747	6477	SVGA XFX G-FORCE 7300GT 256 AGP DDR2 DVI TV			f	t	\N	2	03176477	55	\N	t	113.55	0.00	0.00	f
3614	5066	CONTROLADORA PCI 3 FIREWIRE CONNECTION CNL139			f	t	\N	2	03265066	186	\N	t	13.89	0.00	0.00	f
3615	5067	CABLE ALIMENTACION CORRIENTE A PORTATIL (MICK			f	t	\N	2	09015067	106	\N	t	3.37	0.00	0.00	f
3616	5068	SOPORTE VESA MONITOR TFT BRAZO ARTICULADO OA 			f	t	\N	2	09025068	107	\N	t	65.06	0.00	0.00	f
3617	5069	SOPORTE VESA MONITOR TFT PARED OA 1255			f	t	\N	2	09025069	107	\N	t	28.46	0.00	0.00	f
3621	5080	OFERTA JET TEC C42 COLOR Y NEGRO +1 NEGRO GRA			f	t	\N	2	08065080	132	\N	t	16.55	0.00	0.00	f
3625	5099	HD PORTATIL 80 GB TOSHIBA 5400RPM 8MB			f	t	\N	2	03275099	194	\N	t	57.31	0.00	0.00	f
3631	5121	AURICULAR CON MICROFONO CONCEPTRONIC CCHATSTA			f	t	\N	2	09075121	189	\N	t	3.87	0.00	0.00	f
3633	5126	LATIGUILLO UTP CAT.6E DE 0.5MT GRIS PL1600			f	t	\N	2	07055126	188	\N	t	1.96	0.00	0.00	f
3634	5134	ALTAVOCES NGS SHAKER 5.1 WIRELESS MANDO			f	t	\N	2	04065134	70	\N	t	157.05	0.00	0.00	f
4325	5171	IMP. TICKETS SAMSUNG SRP-275 AG SERIE NEGRO			f	t	\N	2	05035171	120	\N	t	194.02	0.00	0.00	f
3641	5174	CART. JT EPSON STYLUS R800 CYAN E93BL			f	t	\N	2	08065174	132	\N	t	8.12	0.00	0.00	f
3643	5176	CART. JT EPSON STYLUS R800 MAGENTA E93M			f	t	\N	2	08065176	132	\N	t	8.12	0.00	0.00	f
3646	5179	CART. JT EPSON STYLUS R800 NEGRO E93PB			f	t	\N	2	08065179	132	\N	t	8.12	0.00	0.00	f
3647	5180	CART. JT EPSON STYLUS R800 ROJO E93R			f	t	\N	2	08065180	132	\N	t	8.12	0.00	0.00	f
3649	5182	CART. JT EPSON STYLUS C48 NEGRO E107			f	t	\N	2	08065182	132	\N	t	3.90	0.00	0.00	f
3650	5183	CART. JT EPSON STYLUS C48 COLOR E108			f	t	\N	2	08065183	132	\N	t	6.49	0.00	0.00	f
4637	5184	SVGA G-FORCE 6600GT XFX DDR3 256MB AGP DUALDV			f	t	\N	2	03175184	55	\N	t	173.49	0.00	0.00	f
3651	5186	CINTA IMPRESORA EPSON LX-300 NEGRO #8750			f	t	\N	2	08075186	133	\N	t	4.53	0.00	0.00	f
3652	5188	PACK 5 DVD+R VERBATIM 16X 4.7 GB LIGHTSCRIBE			f	t	\N	2	08025188	100	\N	t	9.28	0.00	0.00	f
3653	5204	ACCESS POINT D-LINK DWL-3200AP WIRELESS 108Mb			f	t	\N	2	07015204	94	\N	t	180.04	0.00	0.00	f
3655	5223	ADAPTADOR CONCEPTRONIC USB 2.0 IDE CIDE23U			f	t	\N	2	04235223	148	\N	t	15.16	0.00	0.00	f
3658	5226	CART. CANON IP4200 5200 MP500 MP800 NEGRO CLI			f	t	\N	2	08075226	133	\N	t	10.18	0.00	0.00	f
3484	4627	SVGA POWERCOLOR ATI RADEON X700 256DDR TV DVI			f	t	\N	2	03174627	55	\N	t	66.30	0.00	0.00	f
3659	5227	CART. CANON IP4200 5200 MP500 MP800 CYAN CLI8			f	t	\N	2	08075227	133	\N	t	10.55	0.00	0.00	f
3660	5228	CART. CANON IP4200 5200 MP500 MP800 MAGENTA C			f	t	\N	2	08075228	133	\N	t	11.76	0.00	0.00	f
3661	5229	CART. CANON IP4200 5200 MP500 MP800 AMARILLO 			f	t	\N	2	08075229	133	\N	t	11.76	0.00	0.00	f
3662	5230	RATON NGS QUOKKA OPTICAL 2 EN 1 USB			f	t	\N	2	04085230	72	\N	t	8.23	0.00	0.00	f
3663	5231	RATON NGS WALLABY OPTICAL WIRELESS 2 EN 1 USB			f	t	\N	2	04085231	72	\N	t	33.17	0.00	0.00	f
3666	5238	SOPORTE PARA UNIDADES DE 3.5" SIN FRONTAL			f	t	\N	2	03015238	28	\N	t	2.17	0.00	0.00	f
4638	5249	SWITCH D-LINK 24P 10/100/1000 DGS-1024D NO GE			f	t	\N	2	07025249	95	\N	t	240.84	0.00	0.00	f
3667	5254	KVM D-LINK DKVM-4K 4 PUERTOS PS2 AUTO CON 2 C			f	t	\N	2	09025254	107	\N	t	55.40	0.00	0.00	f
4748	6479	CART. BROTHER MFC210C 1835C NEGRO LC900BK			f	t	\N	2	08076479	133	\N	t	18.72	0.00	0.00	f
4749	6480	CART. BROTHER MFC210C 1835C MAGENTA LC900M			f	t	\N	2	08076480	133	\N	t	9.57	0.00	0.00	f
3668	5255	ANTENA D-LINK ANT24-0600 6dBi INTERIOR DIRECC			f	t	\N	2	07015255	94	\N	t	33.24	0.00	0.00	f
3669	5256	SWITCH D-LINK 5P 10/100/1000 DGS-1005D NO GES			f	t	\N	2	07025256	95	\N	t	37.23	0.00	0.00	f
3670	5257	KVM D-LINK DKVM-4U 4 PUERTOS USB AUTO CON 2 C			f	t	\N	2	09025257	107	\N	t	60.93	0.00	0.00	f
3672	5269	LATIGUILLO FTP CAT.5E DE 0.5 M NEGRO PL4200			f	t	\N	2	07055269	188	\N	t	1.06	0.00	0.00	f
3673	5270	CART. CANON IP1600 2200 MP150 170 450 NEGRO P			f	t	\N	2	08075270	133	\N	t	14.55	0.00	0.00	f
3674	5271	TONER IMP. CANON EP-22 LBP 800 810 NEGRO			f	t	\N	2	08095271	136	\N	t	52.27	0.00	0.00	f
3675	5272	TONER IMP. CANON EP-27 LBP 3200 MF3110 5630 5			f	t	\N	2	08095272	136	\N	t	50.23	0.00	0.00	f
3676	5277	KIT IMPRESION SUBLIMACION CANON KP108IP 10X15			f	t	\N	2	08075277	133	\N	t	29.45	0.00	0.00	f
4640	5305	RATON LOGITECH MX400 LASER MOUSE			f	t	\N	2	04085305	72	\N	t	32.39	0.00	0.00	f
3686	5331	CAMARA WEB LOGITECH QUICKCAM EXPRESS V.2006			f	t	\N	2	04115331	75	\N	t	14.57	0.00	0.00	f
3691	5345	ALTAVOCES NGS POP 2.1 SUBWOOFER			f	t	\N	2	04065345	70	\N	t	24.84	0.00	0.00	f
3692	5346	TECLADO NGS BLUE MOON MULTIMEDIA ILUMINADO US			f	t	\N	2	04075346	71	\N	t	24.84	0.00	0.00	f
3700	5369	CONTROLADORA SATA2 ADAPTEC 1420SA RAID			f	t	\N	2	03235369	129	\N	t	114.61	0.00	0.00	f
3703	5381	LEC. TARJ. 21 EN 1 CONCEPTRONIC USB 2.0 EXT			f	t	\N	2	04235381	148	\N	t	10.53	0.00	0.00	f
3708	5386	TAPA CIEGA SUELO ARMARIO RACK 1000mm NEGRA RT			f	t	\N	2	07065386	185	\N	t	41.11	0.00	0.00	f
4385	6223	SVGA G-FORCE 7300LE 256MB PCIE DDR2 DVI			f	t	\N	2	03176223	55	\N	t	50.39	0.00	0.00	f
3709	5393	ADAPTADOR DE RED RIMAX SOHO PLC RED ELECTRICA			f	t	\N	2	03295393	183	\N	t	30.81	0.00	0.00	f
3713	5402	RATON NGS OPTICAL OCTO P/ PORTATILES USB			f	t	\N	2	04085402	72	\N	t	8.23	0.00	0.00	f
3714	5403	RATON NGS OPTICAL OCTO CHROME P/ PORTATILES U			f	t	\N	2	04085403	72	\N	t	10.72	0.00	0.00	f
4642	5407	HD  80 GB SATA2 SAMSUNG 7200 RPM HD080HJ 8MB			f	t	\N	2	03165407	54	\N	t	44.99	0.00	0.00	f
3718	5412	CART. JT BROTHER LC800 MFC 3220 3420 NEGRO B1			f	t	\N	2	08065412	132	\N	t	5.84	0.00	0.00	f
3719	5413	CART. JT BROTHER LC800 MFC 3220 3420 CYAN B1C			f	t	\N	2	08065413	132	\N	t	4.22	0.00	0.00	f
3720	5414	CART. JT BROTHER LC800 MFC 3220 3420 MAGENTA 			f	t	\N	2	08065414	132	\N	t	4.22	0.00	0.00	f
3721	5415	CART. JT BROTHER LC800 MFC 3220 3420 AMARILLO			f	t	\N	2	08065415	132	\N	t	4.22	0.00	0.00	f
3726	5420	HD 320 GB SATA2 SEAGATE 7200 RPM 16MB			f	t	\N	2	03165420	54	\N	t	76.78	0.00	0.00	f
3729	5424	T.RED PCMCIA D-LINK WIRELESS LAN DWL-G630 54M			f	t	\N	2	07015424	94	\N	t	21.57	0.00	0.00	f
3730	5425	CART. JT HP NEGRO Nº26 DESKJET 500C M26			f	t	\N	2	08065425	132	\N	t	17.53	0.00	0.00	f
3731	5426	CART. JT HP COLOR Nº25 DESKJET 500C M25			f	t	\N	2	08065426	132	\N	t	20.45	0.00	0.00	f
3732	5427	CART. JT HP NEGRO Nº29 DESKJET 600C M29			f	t	\N	2	08065427	132	\N	t	17.53	0.00	0.00	f
3733	5428	CART. JT HP COLOR Nº49 DESKJET 600C M49			f	t	\N	2	08065428	132	\N	t	22.40	0.00	0.00	f
3734	5429	CART. JT HP NEGRO Nº20 DESKJET 610 M20			f	t	\N	2	08065429	132	\N	t	20.45	0.00	0.00	f
3744	5440	CAPTURADORA TV EXT. CONCEPTRONIC  USB2.0 (CTV			f	t	\N	2	04205440	143	\N	t	58.11	0.00	0.00	f
3751	5454	HD 250 GB SATA2 SEAGATE 7200 RPM 8MB			f	t	\N	2	03165454	54	\N	t	74.07	0.00	0.00	f
4645	5455	ROUTER ADSL2-2+D-LINK 4 PUERTOS 10/100 DSL-52			f	t	\N	2	07075455	220	\N	t	48.07	0.00	0.00	f
4646	5456	TELEFONO VOIP GRANDSTREAM GPX-2000 11LINEAS L			f	t	\N	2	13075456	203	\N	t	115.83	0.00	0.00	f
4752	6485	CAJA GAMING ATX PHANTOM TRANSPARENTE USB AUDI			f	t	\N	2	03316485	197	\N	t	73.67	0.00	0.00	f
3756	5468	ROUTER ACCES POINT CONCEPTRONIC BLUETOOTH CBT			f	t	\N	2	07015468	94	\N	t	81.08	0.00	0.00	f
3758	5471	IMPRESORA HP LASERJET 1018 USB CB419A USB 2.0			f	t	\N	2	04245471	173	\N	t	115.87	0.00	0.00	f
3764	5482	TONER IMP. BROTHER TN-6600 NEGRO			f	t	\N	2	08095482	136	\N	t	81.60	0.00	0.00	f
4340	5483	TONER IMP. BROTHER TN-3060 NEGRO			f	t	\N	2	08095483	136	\N	t	84.60	0.00	0.00	f
3768	5496	REPRODUCTOR M.MEDIA CONCEPT.LEC.TARJ USB CMED			f	t	\N	2	13045496	198	\N	t	80.77	0.00	0.00	f
3775	5528	AURICULAR BOTON CON MICRO NGS MSXVOX			f	t	\N	2	09075528	189	\N	t	6.54	0.00	0.00	f
3776	5529	AURICULAR CON MICROFONO NGS MSX6PRO MULTIMEDI			f	t	\N	2	09075529	189	\N	t	8.72	0.00	0.00	f
4647	5530	SAI RIELLO NET DIALOG ND80 800VA 480W SOFT			f	t	\N	2	04145530	81	\N	t	120.48	0.00	0.00	f
3782	5544	PROMO SAI RIELLO WP65 +WD40 DE REGALO			f	t	\N	2	04145544	81	\N	t	87.01	0.00	0.00	f
3784	5549	CART. LEXMARK Nº1  X2310 X2330 X2350 Z730 COL			f	t	\N	2	08075549	133	\N	t	16.01	0.00	0.00	f
4753	6488	SVGA POWERCOLOR RADEON X1300 256MB PCI-E DVI 			f	t	\N	2	03176488	55	\N	t	56.01	0.00	0.00	f
3786	5558	CAMARA WEB LOGITECH QUICKCAM CHAT SKYPE			f	t	\N	2	04115558	75	\N	t	22.18	0.00	0.00	f
4648	5574	IMPRESORA HP OFFICEJET 4315 MULTIFUNCION C/FA			f	t	\N	2	04265574	200	\N	t	94.87	0.00	0.00	f
3790	5575	CARGADOR DE PILAS AA/AAA/9V CEGASA +2 HR6 210			f	t	\N	2	09025575	107	\N	t	12.41	0.00	0.00	f
3791	5576	CARGADOR DE PILAS AA/AAA/9V CEGASA +2 HR03 80			f	t	\N	2	09025576	107	\N	t	12.41	0.00	0.00	f
3794	5587	GAMEPAD RUMBLEPAD 2 LOGITECH REFRESH			f	t	\N	2	04095587	73	\N	t	27.19	0.00	0.00	f
3796	5589	AURICULAR NGS SOUNDLAB ERGONOMICO			f	t	\N	2	09075589	189	\N	t	5.37	0.00	0.00	f
3797	5590	CAMARA WEB NGS EYESHOT LECTOR TARJETAS NEGOCI			f	t	\N	2	04115590	75	\N	t	8.23	0.00	0.00	f
3798	5591	PACK PHOTO CART. HP Nº343+60HOJAS 10X15CM Q79			f	t	\N	2	08075591	133	\N	t	16.80	0.00	0.00	f
4754	6489	CABLE VGA M/M 7M APANTALLADO FERRITA AK4267			f	t	\N	2	09016489	106	\N	t	17.51	0.00	0.00	f
4550	02	HORAS SERVIDOR			f	f	\N	2	020102	23	\N	\N	60.00	12.00	5.00	f
3638	5158	CAJA SEMITORRE ATX 313152 NEGRA PLATA 2228-22			f	t	\N	2	03025158	31	\N	t	50.00	0.00	0.00	f
4078	6094	MINIPC SHUTTLE SS30G2 LGA775 SiS662 DDR2 SATA			f	t	\N	2	03026094	31	\N	t	240.12	0.00	0.00	f
4567	01	FIXING UNIT 230V LE7343001 FUSOR BROTHER			t	t	\N	2	090501	110	\N	\N	40.12	0.00	0.00	f
4650	5609	RATON LOGITECH V270 CORDLESS BLUETOOTH MOUSE 			f	t	\N	2	04085609	72	\N	t	37.83	0.00	0.00	f
3804	5614	CAJA EXT. CONCEPTRONIC 3.5" IDE USB 2.0 LAN H			f	t	\N	2	04195614	142	\N	t	64.63	0.00	0.00	f
4187	03	BROTHER HL-2070N			f	f	\N	2	042903	217	\N	\N	173.20	0.00	0.00	f
4373	6126	MEMORIA DIMM DDR2 1024MB 800MHz KINGSTON CL5 			f	t	\N	2	03146126	52	\N	t	120.23	0.00	0.00	f
3683	5303	PEN DRIVE 2 GB GENERICO USB 2.0			f	t	\N	2	04275303	195	\N	t	16.29	0.00	0.00	f
4528	01	BROTHER TN2000 MFC/DCP			f	f	\N	2	081001	137	\N	\N	60.49	0.00	0.00	f
5326	7372	TELEFONO VOIP Y CAMARA WEB NGS WEBSKYPHONE			f	t	\N	2	13077372	203	\N	t	34.66	0.00	0.00	f
5327	7373	RATON NGS ALUMINA USB OPTICAL			f	t	\N	2	04087373	72	\N	t	15.70	0.00	0.00	f
5333	7379	HD EXT. 120GB WESTERN DIGITAL ELEMENTS PORTAB			f	t	\N	2	04197379	142	\N	t	77.80	0.00	0.00	f
5038	6995	RATON NGS EVO POWERED V2 OPTICO USB			f	t	\N	2	04086995	72	\N	t	6.40	0.00	0.00	f
5051	7023	BOBINA 10 DVD+R DL VERBATIM 8.5GB 2.4X MATT S			f	t	\N	2	08027023	100	\N	t	38.63	0.00	0.00	f
5095	7090	PAPEL ROLLO A1 HP HEAVYWEIGHT PLUS 61cm x 30.			f	t	\N	2	08107090	137	\N	t	45.30	0.00	0.00	f
5334	7380	HD EXT. 160GB WESTERN DIGITAL ELEMENTS PORTAB			f	t	\N	2	04197380	142	\N	t	85.23	0.00	0.00	f
4656	5742	BACKUP INT. HP DAT 72 GB STORAGEWORKS USB AE3			f	t	\N	2	03155742	53	\N	t	529.86	0.00	0.00	f
3863	5744	SVGA G-FORCE 7300GT 512 PCIE DDR2 DVI			f	t	\N	2	03175744	55	\N	t	66.39	0.00	0.00	f
3864	5747	CABLE DVI-D / HDMI 3Mts.M/M AK3793			f	t	\N	2	09015747	106	\N	t	28.92	0.00	0.00	f
4352	5748	HD 500 GB ATA SEAGATE 7200 RPM 16MB			f	t	\N	2	03165748	54	\N	t	126.82	0.00	0.00	f
3866	5754	PB ASUS M2NPV-VM GF6150 AM2 VGA PCIE DDR2 6CH			f	t	\N	2	03325754	196	\N	t	83.29	0.00	0.00	f
4659	5771	T.SONIDO CREATIVE S.B. AUDIGY SE 7.1 RETAIL			f	t	\N	2	03205771	125	\N	t	35.94	0.00	0.00	f
4660	5775	GATEWAY LINKSYS WRT54GL WIRELESS 54MBPS + SWI			f	t	\N	2	07075775	220	\N	t	69.98	0.00	0.00	f
4662	5781	ARMARIO RACK 19" 22U 600X600			f	t	\N	2	07045781	150	\N	t	477.78	0.00	0.00	f
3875	5782	PB ASROCK K7S41GX FSB400 VGA SON LAN			f	t	\N	2	03325782	196	\N	t	43.45	0.00	0.00	f
3877	5786	RATON LOGITECH CORDLESS MX REVOLUTION LASER M			f	t	\N	2	04085786	72	\N	t	81.71	0.00	0.00	f
4663	5787	RATON LOGITECH CORDLESS VX REVOLUTION LASER P			f	t	\N	2	04085787	72	\N	t	47.70	0.00	0.00	f
4664	5793	GATEWAY CONCEPTRONIC C100BRS4H SWITCH 4P + FI			f	t	\N	2	07075793	220	\N	t	26.29	0.00	0.00	f
3881	5803	PB ASROCK ALIVESATA2-GLAN AM2 PCIE GLAN SATA2			f	t	\N	2	03325803	196	\N	t	64.82	0.00	0.00	f
3883	5808	ADAPTADOR MP3 FM RIMAX MUSIC CAR TRANSMITER			f	t	\N	2	13045808	198	\N	t	21.57	0.00	0.00	f
3884	5809	IMPRESORA EPSON LX-300+II USB PARAL SERIE MAT			f	t	\N	2	04255809	182	\N	t	227.11	0.00	0.00	f
3885	5810	TFT 17"  PHILIPS 170S7FS PLATA 1280X1024 NO M			f	t	\N	2	04025810	66	\N	t	188.17	0.00	0.00	f
3888	5817	CAMARA WEB NGS SPARROW 100K USB			f	t	\N	2	04115817	75	\N	t	12.39	0.00	0.00	f
3892	5824	RATON LOGITECH G3 LASER MOUSE			f	t	\N	2	04085824	72	\N	t	49.65	0.00	0.00	f
3894	5831	MALETIN MONRAY STELLA FEMENINO AZUL			f	t	\N	2	09105831	190	\N	t	27.19	0.00	0.00	f
3895	5832	MALETIN MONRAY STELLA FEMENINO RED			f	t	\N	2	09105832	190	\N	t	27.19	0.00	0.00	f
3896	5833	ARCHIVADOR CD S NGS WALLET TAGGER LINE 72 U			f	t	\N	2	09105833	190	\N	t	12.29	0.00	0.00	f
3897	5834	MALETIN MONRAY CORPORATE 17"			f	t	\N	2	09105834	190	\N	t	38.87	0.00	0.00	f
3898	5835	ARCHIVADOR CD S NGS WALLETS BIK 24 U			f	t	\N	2	09105835	190	\N	t	7.19	0.00	0.00	f
3899	5836	TECLADO LOGITECH INTERNET 350 KEYB OEM NEGRO 			f	t	\N	2	04075836	71	\N	t	10.07	0.00	0.00	f
3902	5843	IMPRESORA EPSON DX5000 MULTIFUNCION			f	t	\N	2	04265843	200	\N	t	90.72	0.00	0.00	f
3903	5844	IMPRESORA EPSON DX6000 MULTIFUNCION			f	t	\N	2	04265844	200	\N	t	107.42	0.00	0.00	f
3907	5848	SOFT. McAFEE INTERNET SECURITY SUITE 2007			f	t	\N	2	06035848	91	\N	t	54.43	0.00	0.00	f
3908	5849	SOFT. McAFEE PC PROTECTION PLUS 2007			f	t	\N	2	06035849	91	\N	t	46.64	0.00	0.00	f
3927	5883	ADAPTADOR DE RED NETGEAR SWITCH RED ELECT. A 			f	t	\N	2	07025883	95	\N	t	70.06	0.00	0.00	f
3928	5884	ADAPTADOR DE RED NETGEAR SWITCH RED ELECT. A 			f	t	\N	2	07025884	95	\N	t	116.10	0.00	0.00	f
4670	5900	ROUTER ADSL NETGEAR WIRELESS DG834GTFS + SWIT			f	t	\N	2	07075900	220	\N	t	79.40	0.00	0.00	f
4671	5901	ROUTER ADSL NETGEAR WIFI MIMO DG834PNFS + SWI			f	t	\N	2	07075901	220	\N	t	93.95	0.00	0.00	f
3945	5902	SERV. IMPRESORA NETGEAR PS101SE 1 PUERTO PARA			f	t	\N	2	07025902	95	\N	t	70.06	0.00	0.00	f
3946	5903	SERV. IMPRESORA NETGEAR PS121FS 1 PUERTO USB			f	t	\N	2	07025903	95	\N	t	73.95	0.00	0.00	f
3948	5905	CAJA EXT. NETGEAR SC101FS 2X3.5" IDE LAN RJ45			f	t	\N	2	04195905	142	\N	t	107.45	0.00	0.00	f
3953	5910	T.RED PCI NETGEAR WIRELESS LAN WG311FS 54MBPS			f	t	\N	2	07015910	94	\N	t	24.52	0.00	0.00	f
3956	5913	ACCESS POINT NETGEAR WPN802IS WIRELESS 108Mbp			f	t	\N	2	07015913	94	\N	t	128.20	0.00	0.00	f
3958	5915	T.RED USB NETGEAR WPN111FS WIRELESS 108Mbps			f	t	\N	2	07015915	94	\N	t	35.34	0.00	0.00	f
3959	5916	T.RED PCI NETGEAR WIRELESS LAN WPN311FS 108MB			f	t	\N	2	07015916	94	\N	t	42.30	0.00	0.00	f
3960	5917	ACCESS POINT NETGEAR WG102IS WIRELESS 108M PR			f	t	\N	2	07015917	94	\N	t	112.10	0.00	0.00	f
3961	5918	KIT WGR614FS GATEWAY NETGEAR WIFI+ADAP USB WI			f	t	\N	2	07015918	94	\N	t	45.08	0.00	0.00	f
3964	5923	PB ASUS M2V K8T890 AM2 PCIE DDR2 6CH GLAN SAT			f	t	\N	2	03325923	196	\N	t	67.53	0.00	0.00	f
3978	5947	PB ASROCK K8NF6G-VSTA PCIE VGA SON LAN SATA2			f	t	\N	2	03325947	196	\N	t	50.08	0.00	0.00	f
3982	5954	ESCANER HP SCANJET 3800 48bits USB2.0 2400X24			f	t	\N	2	04055954	69	\N	t	81.93	0.00	0.00	f
4673	5957	SAI RIELLO NET DIALOG ND200 2000VA 10			f	t	\N	2	04145957	81	\N	t	343.45	0.00	0.00	f
3986	5963	RATON LOGITECH V450 LASER CORDLESS NOTEBOOK N			f	t	\N	2	04085963	72	\N	t	40.14	0.00	0.00	f
4674	5966	GATEWAY D-LINK DI-524 WIRELESS 54 + 4XRJ45			f	t	\N	2	07075966	220	\N	t	52.20	0.00	0.00	f
4675	5969	GATEWAY NETGEAR WGR614FS WIRELESS 54MBPS 4LAN			f	t	\N	2	07075969	220	\N	t	41.53	0.00	0.00	f
3992	5973	MEMORIA SECURE DIGITAL KINGSTON SD 2 GB			f	t	\N	2	04275973	195	\N	t	18.48	0.00	0.00	f
3279	3918	REPRODUCTOR MP3 NGS SHARK 512MB RADIO VOZ			f	t	\N	2	13043918	198	\N	t	75.80	0.00	0.00	f
3994	5980	TECLADO NUMERICO NGS USB INALAMBRICO KTOP + R			f	t	\N	2	04075980	71	\N	t	41.46	0.00	0.00	f
3998	5984	FUNDA MP3 NANO MONRAY PROTECH N1 MARFIL			f	t	\N	2	13045984	198	\N	t	7.71	0.00	0.00	f
4000	5986	MICROFONO SOBREMESA NGS MSX2PRO			f	t	\N	2	09075986	189	\N	t	5.75	0.00	0.00	f
4006	5994	CART. LEXMARK Nº32  X3350 X3450 X5250 Z815 NE			f	t	\N	2	08075994	133	\N	t	16.51	0.00	0.00	f
4013	6003	TECLADO LOGITECH GAMER G15 PANTALLA LCD RETAI			f	t	\N	2	04076003	71	\N	t	77.72	0.00	0.00	f
4029	6028	PB INTEL DP965LTCK S775 PCIE DDR2 SATA2 GLAN 			f	t	\N	2	03116028	86	\N	t	98.19	0.00	0.00	f
4031	6032	CPU INTEL CORE2 DUO E6600 2.40 GHZ FSB1066 4M			f	t	\N	2	03126032	50	\N	t	207.24	0.00	0.00	f
4036	6039	HD PORTATIL 120 GB FUJITSU 5400RPM 8MB			f	t	\N	2	03276039	194	\N	t	67.08	0.00	0.00	f
4055	6066	CAMARA RIMAX 45TV COLOR, B/N NOCHE IR + RECEP			f	t	\N	2	13056066	202	\N	t	69.76	0.00	0.00	f
4062	6075	GPS CONCEPTRONIC BLUETOOTH PARA DISP. MOVILES			f	t	\N	2	13026075	201	\N	t	58.63	0.00	0.00	f
4064	6077	ALTAVOCES CONCEPTRONIC 5.1 SPEAKERSET CLLSPK5			f	t	\N	2	04066077	70	\N	t	60.78	0.00	0.00	f
4074	6090	CAJA SEMITORRE ATX SAGITTA NEGRA VENTANA			f	t	\N	2	03026090	31	\N	t	55.12	0.00	0.00	f
4075	6091	CAJA SEMITORRE ATX SILENT TWISTER NEGRA/PLATA			f	t	\N	2	03026091	31	\N	t	57.53	0.00	0.00	f
4076	6092	CAJA SEMITORRE ATX TUNIQ SYMMETRY NEGRA VENTA			f	t	\N	2	03026092	31	\N	t	84.88	0.00	0.00	f
4080	6096	IMPRESORA SAMSUNG ML-2510 LASER USB PARALELO			f	t	\N	2	04246096	173	\N	t	97.20	0.00	0.00	f
4081	6099	CONTROL REMOTO MULTIMEDIA CONCEPTRONIC IR USB			f	t	\N	2	13036099	199	\N	t	23.75	0.00	0.00	f
4085	6109	CAPTURADORA TV EXT. CONCEPTRONIC TDT USB 2.0 			f	t	\N	2	04206109	143	\N	t	36.61	0.00	0.00	f
4087	6111	CART. CANON C20 30 B210 B230C 215 B160 BX20 N			f	t	\N	2	08076111	133	\N	t	33.28	0.00	0.00	f
4088	6112	CART. FAX SAMSUNG SF-3000 3100 3200 4000 4100			f	t	\N	2	08076112	133	\N	t	35.99	0.00	0.00	f
3995	5981	BOLSA CAMARA MONRAY ROCK 200			f	t	\N	2	13035981	199	\N	t	7.80	0.00	0.00	f
3997	5983	BOLSA CAMARA MONRAY FALL 100			f	t	\N	2	13035983	199	\N	t	10.52	0.00	0.00	f
4090	6114	TFT 19" LG L1900J-BF FLATRON 1280x1024 4ms NE			f	t	\N	2	04026114	66	\N	t	302.52	0.00	0.00	f
4094	6118	BOLSA CAMARA NGS SHEATH GRIS			f	t	\N	2	13036118	199	\N	t	7.71	0.00	0.00	f
4095	6119	BOLSA CAMARA NGS SHEATH AMARILLA			f	t	\N	2	13036119	199	\N	t	7.71	0.00	0.00	f
4115	6141	PEN DRIVE 1 GB KINGSTON USB 2.0 DATA TRAV. MI			f	t	\N	2	04276141	195	\N	t	9.72	0.00	0.00	f
4117	6144	AURICULAR LOGITECH BLUETOOTH FREEPULSE ESTERE			f	t	\N	2	09076144	189	\N	t	71.17	0.00	0.00	f
4118	6145	VOLANTE LOGITECH G25 RACING WHEEL PC PSTATION			f	t	\N	2	04096145	73	\N	t	236.29	0.00	0.00	f
4122	6149	MARCO DE FOTOS DIGITAL ARTICFLAMES 7" SD			f	t	\N	2	13036149	199	\N	t	81.08	0.00	0.00	f
4130	6157	MALETIN NGS BEDOUIN BAG			f	t	\N	2	09106157	190	\N	t	31.59	0.00	0.00	f
4131	6158	MALETIN NGS BEDOUIN BACKPACK			f	t	\N	2	09106158	190	\N	t	31.59	0.00	0.00	f
4137	6165	CAJA MICRO ATX FOXCONN GTLM629 300 USB SIN FU			f	t	\N	2	03026165	31	\N	t	35.45	0.00	0.00	f
4140	6168	FA. 500W ARTIC FLAMES 12CM TITANIO			f	t	\N	2	03106168	48	\N	t	27.29	0.00	0.00	f
4142	6170	CAJA TACENS SEMITORRE ATX SAGITTA LUX NEGRA			f	t	\N	2	03026170	31	\N	t	75.52	0.00	0.00	f
4152	6181	CAJA THERMALTAKE AGUILA VD1000BWS VENTANA NEG			f	t	\N	2	03316181	197	\N	t	121.70	0.00	0.00	f
4156	6185	CART. EPSON D68 D88 DX3800 MAGENTA T061340B0			f	t	\N	2	08076185	133	\N	t	8.05	0.00	0.00	f
4157	6186	DESKTOP NGS INALAMBRICO GEOMETRIC DARK OPTICO			f	t	\N	2	04076186	71	\N	t	46.53	0.00	0.00	f
4158	6187	MOCHILA DE PORTATIL MONRAY TOUAREG BAG			f	t	\N	2	09106187	190	\N	t	31.59	0.00	0.00	f
4159	6188	MOCHILA DE PORTATIL MONRAY TOUAREG BACKPACK			f	t	\N	2	09106188	190	\N	t	31.59	0.00	0.00	f
4380	6218	HD PORTATIL 120 GB FUJITSU SATA 5400RPM 8MB			f	t	\N	2	03276218	194	\N	t	67.47	0.00	0.00	f
4381	6219	PEN DRIVE 4 GB TAKE MS MINI USB 2.0			f	t	\N	2	04276219	195	\N	t	29.61	0.00	0.00	f
4384	6222	CART. EPSON D68 D88 DX3800 NEGRO T061140B0			f	t	\N	2	08076222	133	\N	t	7.99	0.00	0.00	f
4386	6224	IMPRESORA HP LASERJET COLOR 1600 CB373A USB2.			f	t	\N	2	04246224	173	\N	t	270.17	0.00	0.00	f
4387	6225	LATIGUILLO UTP CAT.5E ROJO 2 Mt. PL3002			f	t	\N	2	07056225	188	\N	t	1.06	0.00	0.00	f
4388	6226	LATIGUILLO UTP CAT.5E ROJO 3 Mt. PL3003			f	t	\N	2	07056226	188	\N	t	1.20	0.00	0.00	f
4682	6243	MEMORIA MICRO SECURE DIGITAL 1GB KINGSTON SDC			f	t	\N	2	04276243	195	\N	t	12.42	0.00	0.00	f
4407	6248	PEN DRIVE 2 GB KINGSTON USB 2.0 DATA TRAVELLE			f	t	\N	2	04276248	195	\N	t	16.18	0.00	0.00	f
4412	6254	MINIPC ASUS PUNDIT P2-P5945G S775 DDR2 SATA2 			f	t	\N	2	03026254	31	\N	t	158.87	0.00	0.00	f
4413	6255	AURICULAR CON MICRO CONCEPTRONIC WIRELESS CLL			f	t	\N	2	09076255	189	\N	t	63.49	0.00	0.00	f
4415	6262	PB INTEL DG965WHMKR S775 PCIE DDR2 SATA2 GLAN			f	t	\N	2	03116262	86	\N	t	133.71	0.00	0.00	f
4424	6273	CART. MAXTEC EPSON C64 C86 CX3600 AMARILLO T0			f	t	\N	2	08066273	132	\N	t	3.83	0.00	0.00	f
4430	6284	CABLE HD SAS MINI SAS 4 X SFF8482 30 cm			f	t	\N	2	03236284	129	\N	t	84.40	0.00	0.00	f
4432	6286	MODEM ADSL NETGEAR DM111P ETHERNET 10/100			f	t	\N	2	04046286	68	\N	t	41.34	0.00	0.00	f
4435	6289	CART. HP CYAN Nº82 DSJ500 DSJ800 C4911A			f	t	\N	2	08076289	133	\N	t	29.92	0.00	0.00	f
4436	6290	CART. HP AMARILLO Nº82 DSJ500 DSJ800 C4913A			f	t	\N	2	08076290	133	\N	t	29.92	0.00	0.00	f
4440	6294	MALETIN NGS NAROOMA 15.4" FEMENINO			f	t	\N	2	09106294	190	\N	t	69.33	0.00	0.00	f
4441	6295	MALETIN NGS SHAMIRA FEMENINO			f	t	\N	2	09106295	190	\N	t	78.14	0.00	0.00	f
4442	6296	MALETIN NGS JADE FEMENINO			f	t	\N	2	09106296	190	\N	t	61.54	0.00	0.00	f
4443	6297	MALETIN NGS IONA FEMENINO			f	t	\N	2	09106297	190	\N	t	61.54	0.00	0.00	f
4444	6298	MALETIN NGS BERYL FEMENINO			f	t	\N	2	09106298	190	\N	t	39.90	0.00	0.00	f
4445	6299	MALETIN NGS SAPPHIRE FEMENINO			f	t	\N	2	09106299	190	\N	t	69.33	0.00	0.00	f
4446	6300	MALETIN NGS GALENA FEMENINO			f	t	\N	2	09106300	190	\N	t	39.90	0.00	0.00	f
4447	6301	MALETIN NGS JUMAANA FEMENINO			f	t	\N	2	09106301	190	\N	t	69.33	0.00	0.00	f
4453	6308	HD 320 GB SATA2 WESTERN DIGITAL 7200 RPM 16 M			f	t	\N	2	03166308	54	\N	t	78.52	0.00	0.00	f
4454	6309	HD 160 GB SATA2 WESTERN DIGITAL 7200 RPM 8 MB			f	t	\N	2	03166309	54	\N	t	52.70	0.00	0.00	f
4457	6312	ANTENA D-LINK ANT24-0501 5dBi INTERIOR OMNIDI			f	t	\N	2	07016312	94	\N	t	27.70	0.00	0.00	f
4687	6323	BACKPLANE 6 HOT SWAP SC5400/5299-E SAS SATA E			f	t	\N	2	03046323	38	\N	t	175.86	0.00	0.00	f
4568	18	HOSTING MENSUAL URBIENT.COM			f	f	\N	2	020618	207	\N	\N	30.00	0.00	0.00	f
4569	01	OKI IMPRESORA LASER COLOR C5600N			t	t	\N	2	040601	70	\N	\N	404.00	26.00	0.00	f
4469	6324	PB INTEL S5000PSLSAS DXEON 667 DLAN PCIE SATA			f	t	\N	2	03116324	86	\N	t	596.99	0.00	0.00	f
4473	6331	CARGADOR DE PILAS AA/AAA CEGASA COMPACT +2 AA			f	t	\N	2	09026331	107	\N	t	23.93	0.00	0.00	f
4477	6335	SOPORTE CPU CON RUEDAS PCWAGON			f	t	\N	2	09026335	107	\N	t	10.11	0.00	0.00	f
4478	6336	MALETIN NGS FLYER			f	t	\N	2	09106336	190	\N	t	22.59	0.00	0.00	f
4479	6337	RATON NGS LASER BLASTER INALAMBRICO			f	t	\N	2	04086337	72	\N	t	33.16	0.00	0.00	f
4480	6338	RATON NGS TRACKER MOUSE LASER 4DWHEEL USB			f	t	\N	2	04086338	72	\N	t	12.39	0.00	0.00	f
4481	6339	RATON NGS RAPTOR MOUSE OPTICAL CABLE WIRELESS			f	t	\N	2	04086339	72	\N	t	24.01	0.00	0.00	f
4482	6340	TONER IMP. BROTHER TN-4100 NEGRO			f	t	\N	2	08096340	136	\N	t	86.87	0.00	0.00	f
4485	6343	ARCHIVADOR CD S NGS WALLETS STRIP LINE 136 U			f	t	\N	2	09106343	190	\N	t	14.47	0.00	0.00	f
4488	6347	SOFT. WINDOWS VISTA HOME BASIC 32 BIT OEM			f	t	\N	2	03306347	184	\N	t	85.88	0.00	0.00	f
4489	6348	SOFT. WINDOWS VISTA HOME PREMIUM 32 BIT OEM			f	t	\N	2	03306348	184	\N	t	106.64	0.00	0.00	f
4490	6349	SOFT. WINDOWS VISTA BUSINESS 32 BIT OEM			f	t	\N	2	03306349	184	\N	t	136.01	0.00	0.00	f
4491	6350	SOFT. WINDOWS VISTA ULTIMATE 32 BIT OEM			f	t	\N	2	03306350	184	\N	t	188.61	0.00	0.00	f
4492	6351	HD PORTATIL 120 GB SAMSUNG 5400RPM 8MB HM120J			f	t	\N	2	03276351	194	\N	t	70.14	0.00	0.00	f
4496	6359	HD 250 GB ATA WESTERN DIGITAL 7200 RPM 8MB			f	t	\N	2	03166359	54	\N	t	65.65	0.00	0.00	f
4511	6375	HD EXT. USB 120 GB "HANDYDRIVE" SLIM USB2.0			f	t	\N	2	04196375	142	\N	t	99.43	0.00	0.00	f
4515	6379	HD  73 GB USCSI-320 SEAGATE 15000 RPM 68PIN 8			f	t	\N	2	03166379	54	\N	t	262.89	0.00	0.00	f
4517	6383	SOFT. NORTON INTERNET SECURITY 2007 3 USUARIO			f	t	\N	2	06036383	91	\N	t	93.71	0.00	0.00	f
4521	6387	TONER IMP. HP LASERJET 3600 3800 NEGRO Q6470A			f	t	\N	2	08096387	136	\N	t	105.06	0.00	0.00	f
4524	6390	TONER IMP. HP LASERJET 3600 3800 MAGENTA Q758			f	t	\N	2	08096390	136	\N	t	137.01	0.00	0.00	f
4695	6399	TORNILLOS DE CPU ANONIZADOS DORADO 12 mm 10 U			f	t	\N	2	09046399	109	\N	t	2.40	0.00	0.00	f
4696	6400	TORNILLOS DE CPU ANONIZADOS VERDE 12 mm 10 UN			f	t	\N	2	09046400	109	\N	t	2.29	0.00	0.00	f
4697	6401	TORNILLOS DE CPU ANONIZADOS PURPURA 12 mm 10 			f	t	\N	2	09046401	109	\N	t	2.40	0.00	0.00	f
4698	6402	TORNILLOS DE CPU ANONIZADOS ROJO 12 mm 10 UNI			f	t	\N	2	09046402	109	\N	t	2.29	0.00	0.00	f
4699	6403	TORNILLOS DE CPU ANONIZADOS PLATA 12 mm 10 UN			f	t	\N	2	09046403	109	\N	t	2.36	0.00	0.00	f
4700	6404	CART. CANON COLOR BCI21C BJC 2000 4000 5000 S			f	t	\N	2	08076404	133	\N	t	21.13	0.00	0.00	f
4701	6405	NEON CAJA BUBBLE LIGHT 6.6" AZUL BUL-B			f	t	\N	2	09046405	109	\N	t	7.37	0.00	0.00	f
4702	6406	NEON CAJA BUBBLE LIGHT 6.6" ROJO BUL-R			f	t	\N	2	09046406	109	\N	t	7.07	0.00	0.00	f
4712	6418	SVGA XFX G-FORCE 8800GTS PCIE 640DDR3 DUAL DV			f	t	\N	2	03176418	55	\N	t	425.14	0.00	0.00	f
4713	6419	SVGA SAPPHIRE RADEON X1650 PRO 512MB DDR2 AGP			f	t	\N	2	03176419	55	\N	t	115.10	0.00	0.00	f
4714	6421	PB INTEL S5000PSLSATA DXEON 667 DLAN PCIE SAT			f	t	\N	2	03116421	86	\N	t	522.33	0.00	0.00	f
4716	6425	ARMARIO RACK 19" 42U PUERTA 800X1000 ACC SERV			f	t	\N	2	07046425	150	\N	t	1169.39	0.00	0.00	f
4718	6436	HD 320 GB SATA2 WESTERN DIGITAL 7200 RPM 8 MB			f	t	\N	2	03166436	54	\N	t	75.98	0.00	0.00	f
4720	6439	KIT ADAPTADOR CONCEPTRONIC RED ELECT. A R45 2			f	t	\N	2	07026439	95	\N	t	125.80	0.00	0.00	f
4726	6447	HD EXT. USB 320 GB RIMAX HD SLIM USB2.0			f	t	\N	2	04196447	142	\N	t	106.64	0.00	0.00	f
4727	6450	IMP. TICKETS EPSON TM-U220PA-007 PARALELO			f	t	\N	2	04256450	182	\N	t	291.63	0.00	0.00	f
2862	0977	HD  80 GB ATA SEAGATE 7200 RPM 2MB			f	t	\N	2	03160977	54	\N	t	42.43	0.00	0.00	f
4728	6451	CAMARA VIDEO IP RIMAX IPCAM 7100 RJ45 IR (NOC			f	t	\N	2	13056451	202	\N	t	88.19	0.00	0.00	f
4729	6452	CAMARA WEB RIMAX IN-MOTION 1.2MP MOTORIZADA U			f	t	\N	2	04116452	75	\N	t	39.70	0.00	0.00	f
4732	6455	ANTENA RIMAX TDT DIGITAL ANTENNA			f	t	\N	2	13066455	205	\N	t	22.59	0.00	0.00	f
4733	6457	PEN DRIVE 1 GB MEMORIA SOLIDARIA USB 2.0 VERD			f	t	\N	2	04276457	195	\N	t	16.90	0.00	0.00	f
4734	6458	PEN DRIVE 1 GB MEMORIA SOLIDARIA USB 2.0 PLAT			f	t	\N	2	04276458	195	\N	t	16.90	0.00	0.00	f
4317	4947	PB INTEL D945PLRNL S775 PCIE DDR2 SATA2 LAN R			f	t	\N	2	03114947	86	\N	t	89.87	0.00	0.00	f
3252	3822	T.RED USB D-LINK WIRELESS DWL-G122 54Mbps 2.4			f	t	\N	2	07013822	94	\N	t	21.57	0.00	0.00	f
4035	6037	CPU INTEL PIV D 925 LGA775 FSB800 2x(3.0GHZ 2			f	t	\N	2	03126037	50	\N	t	117.20	12.00	5.00	f
3258	3851	HUB USB CONCEPTRONIC 4 PTOS. USB 2.0 C4USB2			f	t	\N	2	04133851	80	\N	t	12.49	0.00	0.00	f
4230	05	HOSTING GNLEON.COM			f	f	\N	2	020605	207	\N	\N	360.00	0.00	0.00	f
4211	04	MANTENIMIENTO SERVIDOR APACHE ANUAL LLABRES FELIU			f	f	\N	2	020504	206	\N	\N	500.00	0.00	0.00	f
4740	6464	CART. MAXTEC BROTHER LC41 47C 900C CYAN B-47C			f	t	\N	2	08066464	132	\N	t	3.90	0.00	0.00	f
4238	07	CONFIGURACIÓN E INSTALACION DE 1 CLIENTE VPN			f	f	\N	2	020207	56	\N	\N	30.00	0.00	0.00	f
4741	6466	T.SONIDO SOUND BLASTER SURROUND 5.1 USB RETAI			f	t	\N	2	03206466	125	\N	t	55.54	0.00	0.00	f
4742	6469	DESKTOP CHERRY INALAMBRICO EVOLUTION MARLIN L			f	t	\N	2	04076469	71	\N	t	69.46	0.00	0.00	f
4743	6473	VIDEO VIGILANCIA SIN CABLES RIMAX BABY KANGOO			f	t	\N	2	13056473	202	\N	t	108.19	0.00	0.00	f
4744	6474	SENSOR DE MOVIMIENTO RIMAX SECURITY PHONE REM			f	t	\N	2	13056474	202	\N	t	155.30	0.00	0.00	f
4755	6491	HD 320 GB ATA SEAGATE 7200 RPM 8MB			f	t	\N	2	03166491	54	\N	t	71.49	0.00	0.00	f
4756	6494	TONER IMP. HP LASERJET P2015 NEGRO Q7553A			f	t	\N	2	08096494	136	\N	t	63.35	0.00	0.00	f
4757	6496	CART. MAXTEC PIXMA NEGRO BCI-5BK MP500 800 IP			f	t	\N	2	08066496	132	\N	t	3.90	0.00	0.00	f
4758	6497	CART. MAXTEC LEXMARK i3 X 1100 X NEGRO 10N001			f	t	\N	2	08066497	132	\N	t	19.39	0.00	0.00	f
4759	6498	CART. MAXTEC LEXMARK 3200 5000 5700 NEGRO 12A			f	t	\N	2	08066498	132	\N	t	22.40	0.00	0.00	f
4764	6503	CART. MAXTEC EPSON R240 RX245 RX420 MAGENTA T			f	t	\N	2	08066503	132	\N	t	3.83	0.00	0.00	f
4765	6504	CART. MAXTEC HP º78 DESKJET 855CXI 920C COLOR			f	t	\N	2	08066504	132	\N	t	18.01	0.00	0.00	f
4766	6505	PB ASUS K8V-VM 754 DDR VGA SATA PCIE SON LAN 			f	t	\N	2	03326505	196	\N	t	47.34	0.00	0.00	f
4769	6508	KIT ACTIVATION KEY INTEL SATA RAID 5 AXXRAKSW			f	t	\N	2	03236508	129	\N	t	84.11	0.00	0.00	f
3535	4781	T.SONIDO CREATIVE S.B. AUDIGY SE 7.1 OEM SB05			f	t	\N	2	03204781	125	\N	t	22.55	0.00	0.00	f
4770	6510	AURICULAR BOTON NGS MSX ELITE			f	t	\N	2	09076510	189	\N	t	13.94	0.00	0.00	f
4771	6511	AURICULAR BOTON NGS MSX EVOLUTION			f	t	\N	2	09076511	189	\N	t	10.83	0.00	0.00	f
4774	6515	PB INTEL S775 D945GCCRL DDR2 VGA SON LAN SATA			f	t	\N	2	03116515	86	\N	t	78.55	0.00	0.00	f
4775	6518	PB INTEL G965OTMKR S775 VGA PCIE DDR2 SATA2 O			f	t	\N	2	03116518	86	\N	t	112.25	0.00	0.00	f
4777	6521	CAPTURADORA TV EXT. ASUS TDT USB 2.0 STICK + 			f	t	\N	2	04206521	143	\N	t	69.53	0.00	0.00	f
4778	6523	CAPTURADORA TV PCI ASUS P7131 HYBRID TDT +ANA			f	t	\N	2	03246523	130	\N	t	40.42	0.00	0.00	f
4780	6528	REPRODUCTOR HD RIMAX ALUM PLUS 320 GB USB2.0 			f	t	\N	2	13046528	198	\N	t	144.58	0.00	0.00	f
4781	6529	REPRODUCTOR HD RIMAX ALUM PLUS 400 GB USB2.0 			f	t	\N	2	13046529	198	\N	t	177.11	0.00	0.00	f
4474	6332	CABLE VGA 10 MTS. M-H (ALARGADOR) AK4229			f	t	\N	2	09016332	106	\N	t	17.83	0.00	0.00	f
4389	6227	LATIGUILLO UTP CAT.5E ROJO 5 Mt. PL3005			f	t	\N	2	07056227	188	\N	t	1.90	0.00	0.00	f
4538	01	AVG Anti-Virus Professional Edition			f	f	\N	2	070701	220	\N	\N	26.90	0.00	0.00	f
4787	6540	PB ASUS P5LD2 SE i945P PCIE DDR2 SON GLAN			f	t	\N	2	03116540	86	\N	t	66.43	0.00	0.00	f
4788	6546	TFT 17" CTX S792A 12MS DVI MM PLATA NEGRO			f	t	\N	2	04026546	66	\N	t	178.69	0.00	0.00	f
4789	6547	CAMARA WEB LOGITECH QUICKCAM PRO 5000			f	t	\N	2	04116547	75	\N	t	64.48	0.00	0.00	f
4790	6549	RATON LOGITECH LX3 OPTICAL MOUSE GRIS			f	t	\N	2	04086549	72	\N	t	20.65	0.00	0.00	f
4791	6550	RATON LOGITECH V150 LASER NOTEBOOK			f	t	\N	2	04086550	72	\N	t	24.20	0.00	0.00	f
4792	6551	RATON LOGITECH V400 LASER CORDLESS NOTEBOOK G			f	t	\N	2	04086551	72	\N	t	45.33	0.00	0.00	f
4793	6555	DESKTOP LOGITECH EASYCALL AURICULARES MANOS L			f	t	\N	2	04076555	71	\N	t	106.76	0.00	0.00	f
4794	6556	BOLIGRAFO LOGITECH IO2 DIGITAL			f	t	\N	2	04176556	116	\N	t	103.20	0.00	0.00	f
4795	6557	CAMARA WEB LOGITECH QUICKCAM NOTEBOOK PRO			f	t	\N	2	04116557	75	\N	t	83.42	0.00	0.00	f
4796	6560	CART. MAXTEC EPSON D68 D88 DX3800 CYAN T0612			f	t	\N	2	08066560	132	\N	t	3.83	0.00	0.00	f
4797	6561	CART. MAXTEC EPSON D68 D88 DX3800 MAGENTA T06			f	t	\N	2	08066561	132	\N	t	3.83	0.00	0.00	f
4798	6562	CART. MAXTEC EPSON D68 D88 DX3800 AMARILLO T0			f	t	\N	2	08066562	132	\N	t	3.83	0.00	0.00	f
4799	6563	SVGA G-FORCE 7100GS 256 512HM PCIE DDR2 DVI T			f	t	\N	2	03176563	55	\N	t	40.76	0.00	0.00	f
4800	6570	PB ASUS A8N-SLI PREMIUM NF4 PCIE RAID GLAN SO			f	t	\N	2	03326570	196	\N	t	130.93	0.00	0.00	f
4801	6573	BOBINA 25 CD-R VERBATIM 700MB 52X EXTRA PROTE			f	t	\N	2	08016573	99	\N	t	12.89	0.00	0.00	f
4434	6288	PORTATIL HP NX7300 T5500 1GB 80GB DVD-RW 15.4			f	t	\N	2	02996288	204	\N	t	923.47	0.00	0.00	f
4802	6576	TFT 17"  HP L1706 PLATA NEGRO 8MS PX849AA			f	t	\N	2	04026576	66	\N	t	216.60	0.00	0.00	f
4803	6577	PORT. SAMSUNG R40+ T5600 1GB 160GB DVD-RW 15.			f	t	\N	2	02996577	204	\N	t	798.99	0.00	0.00	f
4804	6579	SOFT. ANTIVIRUS PANDA INTERNET SECURITY 2007 			f	t	\N	2	06036579	91	\N	t	49.37	0.00	0.00	f
4805	6580	ANTENA LINKSYS HGA7T INTERIOR 7 dBi OMNIDIREC			f	t	\N	2	07016580	94	\N	t	49.83	0.00	0.00	f
4806	6581	RATON LABTEC WHEEL MOUSE NEGRO PLATA PS/2			f	t	\N	2	04086581	72	\N	t	3.81	0.00	0.00	f
4813	6589	CART. MAXTEC EPSON MAGENTA R360/265 RX560 T08			f	t	\N	2	08066589	132	\N	t	5.13	0.00	0.00	f
4814	6590	CART. MAXTEC EPSON AMARILLO R360/265 RX560 T0			f	t	\N	2	08066590	132	\N	t	5.13	0.00	0.00	f
4815	6591	CART. MAXTEC EPSON LIGTH CYAN R360/265 RX560 			f	t	\N	2	08066591	132	\N	t	5.13	0.00	0.00	f
4820	6596	CART. MAXTEC EPSON R200/300 RX500 NEGRO T0481			f	t	\N	2	08066596	132	\N	t	3.83	0.00	0.00	f
4821	6597	CART. MAXTEC EPSON R200/300 RX500 LIGTH CYAN 			f	t	\N	2	08066597	132	\N	t	3.83	0.00	0.00	f
4822	6600	PB INTEL DP965LTCK S775 PCIE DDR2 SATA2 GLAN 			f	t	\N	2	03116600	86	\N	t	100.93	0.00	0.00	f
4823	6603	HD 400 GB ATA SEAGATE 7200 RPM 8MB			f	t	\N	2	03166603	54	\N	t	88.14	0.00	0.00	f
4825	6606	TFT 17" LG L1718S NEGRO PLATA 8MS			f	t	\N	2	04026606	66	\N	t	177.34	0.00	0.00	f
4826	6607	HD PORTATIL 80 GB WESTERN DIGITAL 2.5" 5400RP			f	t	\N	2	03276607	194	\N	t	57.10	0.00	0.00	f
4827	6608	HD PORTATIL 120 GB WESTERN DIGITAL 2.5" 5400R			f	t	\N	2	03276608	194	\N	t	68.89	0.00	0.00	f
4844	6646	IMPRESORA EPSON STYLUS PHOTO R360 LCD USB 6 C			f	t	\N	2	04036646	67	\N	t	135.61	0.00	0.00	f
4849	6653	RATON LOGITECH V320 CORDLESS OPTICAL NOTEBOOK			f	t	\N	2	04086653	72	\N	t	32.39	0.00	0.00	f
4850	6654	SVGA SAPPHIRE RADEON X1550 512MB DDR2 PCIE RE			f	t	\N	2	03176654	55	\N	t	53.41	0.00	0.00	f
4851	6655	SOFT. WINDOWS XP PROFESSIONAL 64 BITS OEM MUL			f	t	\N	2	03306655	184	\N	t	135.89	0.00	0.00	f
4852	6656	CART. EPSON NEGRO RX700 T559140 13ML			f	t	\N	2	08076656	133	\N	t	11.29	0.00	0.00	f
4853	6658	CART. MAXTEC PACK EPSON D68 D88 DX3800 DX4200			f	t	\N	2	08066658	132	\N	t	12.93	0.00	0.00	f
4854	6659	CART. MAXTEC PACK EPSON R200 R300 RX300 RX400			f	t	\N	2	08066659	132	\N	t	19.41	0.00	0.00	f
4855	6660	CART. MAXTEC PACK EPSON C64 C66 C84 CX3600 CX			f	t	\N	2	08066660	132	\N	t	12.93	0.00	0.00	f
4856	6661	CART. MAXTEC PACK EPSON STYLUS COLOR 880 884			f	t	\N	2	08066661	132	\N	t	12.93	0.00	0.00	f
4857	6663	SVGA SAPPHIRE ATI X550XTX PCIE 128MB 512HM TV			f	t	\N	2	03176663	55	\N	t	49.23	0.00	0.00	f
4858	6664	AURICULAR NGS SOUNDSCAPE WIRELESS			f	t	\N	2	04066664	70	\N	t	41.46	0.00	0.00	f
3139	3258	T.RED PCMCIA CONCEPTRONIC WIRELESS 54Mbps C54			f	t	\N	2	07013258	94	\N	t	19.05	0.00	0.00	f
4859	6665	ALTAVOCES NGS CUBE 2.1 BLINDADOS CTRL VOLUMEN			f	t	\N	2	04066665	70	\N	t	33.16	0.00	0.00	f
4860	6666	ALTAVOCES NGS ICEBERG 2.1 BLINDADOS CTRL VOLU			f	t	\N	2	04066666	70	\N	t	24.84	0.00	0.00	f
4862	6670	REPRODUCTOR HD RIMAX ALUM PLUS 500 GB USB2.0 			f	t	\N	2	13046670	198	\N	t	204.82	0.00	0.00	f
4863	6672	CABLE KVM 3 EN 1 2XPS2 M/M 1XVGA M/M 1.8M AK 			f	t	\N	2	09016672	106	\N	t	9.88	0.00	0.00	f
4864	6675	CAMARA WEB CONCEPTRONIC 1.3 MPIXEL CLLFLEXCAM			f	t	\N	2	04116675	75	\N	t	20.51	0.00	0.00	f
4865	6676	ADAPTADOR CONCEPTRONIC RED ELECT. A R45 200M			f	t	\N	2	07026676	95	\N	t	63.55	0.00	0.00	f
4866	6677	ADAPTADOR FM MP3 CONCEPTR. PLAYER TRANSMITTER			f	t	\N	2	13046677	198	\N	t	34.75	0.00	0.00	f
4872	6683	RATON CONCEPTRONIC LASER MOUSE WIRELESS USB P			f	t	\N	2	04086683	72	\N	t	24.17	0.00	0.00	f
4873	6684	RATON CONCEPTRONIC EASYMOUSE USB PS2			f	t	\N	2	04086684	72	\N	t	5.45	0.00	0.00	f
4874	6685	CPU INTEL CORE2 DUO E6320 1.8 GHZ FSB1066 4MB			f	t	\N	2	03126685	50	\N	t	154.16	0.00	0.00	f
4875	6686	CPU INTEL CORE2 DUO E6420 2.13 GHZ FSB1066 4M			f	t	\N	2	03126686	50	\N	t	173.02	0.00	0.00	f
4876	6692	CPU INTEL XEON D5130 2.0 DUAL 4MB 1333FSB ACT			f	t	\N	2	03126692	50	\N	t	338.29	0.00	0.00	f
4877	6694	VENTILADOR PIV SPIRE LIONSTREAM V 3.8 S478 SP			f	t	\N	2	03136694	51	\N	t	8.80	0.00	0.00	f
4878	6696	RW DVD DL SATA LITEON 20X4X20X SH-20A1S NEGRO			f	t	\N	2	03226696	128	\N	t	30.19	0.00	0.00	f
4879	6698	TFT 19"  RYOKU / YURAKU MA9JBA 8MS NEGRO MM P			f	t	\N	2	04026698	66	\N	t	151.72	0.00	0.00	f
4880	6699	REPRODUCTOR MP3 RIMAX B-TWIN 4GB 1.8" MP4 WMA			f	t	\N	2	13046699	198	\N	t	79.40	0.00	0.00	f
4882	6701	CART. MAXTEC HP Nº57 DJ 5150 COLOR C6657A H65			f	t	\N	2	08066701	132	\N	t	21.92	0.00	0.00	f
4883	6704	ARMARIO RACK 19" 9U F450 1 CUERPO			f	t	\N	2	07046704	150	\N	t	128.99	0.00	0.00	f
4884	6707	SOFT. EUROWIN SOLUTION 2.00 SQL MONOPUESTO			f	t	\N	2	06016707	89	\N	t	355.42	0.00	0.00	f
4885	6710	PB GIGABYTE GA-MA69VM-S2 AM2 AMD690V PCIE VGA			f	t	\N	2	03326710	196	\N	t	61.14	0.00	0.00	f
3001	2399	LECTOR/GRAB. TARJETAS DE MEMORIA USB 2.0 CARD			f	t	\N	2	04232399	148	\N	t	12.53	0.00	0.00	f
3969	5935	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0			f	t	\N	2	08075935	133	\N	t	8.10	0.00	0.00	f
4002	5988	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0			f	t	\N	2	08075988	133	\N	t	7.96	0.00	0.00	f
4003	5989	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340			f	t	\N	2	08075989	133	\N	t	7.81	0.00	0.00	f
4886	6715	PB ASUS P5PL2-E i945 PCIE DDR2 SATA2 GLAN SON			f	t	\N	2	03116715	86	\N	t	60.88	0.00	0.00	f
4887	6720	ALTAVOCES LOGITECH X140 2.0 5W RMS			f	t	\N	2	04066720	70	\N	t	23.49	0.00	0.00	f
4888	6721	MICROFONO SOBREMESA LOGITECH DESKTOP			f	t	\N	2	09076721	189	\N	t	10.65	0.00	0.00	f
4892	6725	TONER MAXTEC IMP. HP LASERJET 1010 SERIES H26			f	t	\N	2	08086725	134	\N	t	41.23	0.00	0.00	f
4894	6727	TONER MAXTEC IMP. HP LASERJET 1150 SERIES H26			f	t	\N	2	08096727	136	\N	t	32.04	0.00	0.00	f
4431	6285	IMPRESORA HP PHOTOSMART C5180 MULTIFUNCION Q8			f	t	\N	2	04266285	200	\N	t	203.73	0.00	0.00	f
4895	6728	TONER MAXTEC IMP. HP LASERJET 2000 SERIES H40			f	t	\N	2	08086728	134	\N	t	58.31	0.00	0.00	f
4896	6729	TONER MAXTEC IMP. HP LASERJET 1320/1160 H5949			f	t	\N	2	08086729	134	\N	t	45.78	0.00	0.00	f
4897	6730	TONER MAXTEC IMP. HP LASERJET 1000/1200 H7115			f	t	\N	2	08086730	134	\N	t	36.04	0.00	0.00	f
4898	6731	CART. MAXTEC HP Nº23 DJ 700 SERIES COLOR			f	t	\N	2	08066731	132	\N	t	21.89	0.00	0.00	f
4899	6732	CART. MAXTEC LEXMARK Z12 Z22 Z32 Z700 NEGRO G			f	t	\N	2	08066732	132	\N	t	15.71	0.00	0.00	f
4900	6733	CART. MAXTEC LEXMARK Z12 Z22 Z32 Z700 COLOR G			f	t	\N	2	08066733	132	\N	t	16.80	0.00	0.00	f
4901	6734	BLISTER 4UDS PILAS MAXTEC LR6			f	t	\N	2	09026734	107	\N	t	3.77	0.00	0.00	f
4904	6737	CAJA EXT. ICY BOX 3.5" SATA / USB IB-351STUS 			f	t	\N	2	04236737	148	\N	t	41.53	0.00	0.00	f
4905	6738	CAJA EXT. ICY BOX 3.5" USB / FIREWIRE IB-351U			f	t	\N	2	04236738	148	\N	t	47.40	0.00	0.00	f
4906	6739	CAJA SEMITORRE ATX TUNIQ 3 PLATA 12CM			f	t	\N	2	03026739	31	\N	t	75.13	0.00	0.00	f
3872	5775	GATEWAY LINKSYS WRT54GL WIRELESS 54MBPS + SWI			f	t	\N	2	04045775	68	\N	t	71.81	0.00	0.00	f
4907	6740	CAJA SEMITORRE ATX KATANA NEGRA VENT. 225MM			f	t	\N	2	03316740	197	\N	t	74.42	0.00	0.00	f
4908	6741	CAJA SEMITORRE ATX XFORCE NEGRA ROJA VENTANA			f	t	\N	2	03316741	197	\N	t	76.52	0.00	0.00	f
4909	6742	CAJA SEMITORRE ATX ARES NEGRA VENTANA			f	t	\N	2	03316742	197	\N	t	42.34	0.00	0.00	f
4912	6746	CAJA SEMITORRE TACENS AUDEO FRONT USB NEGRO			f	t	\N	2	03316746	197	\N	t	49.60	0.00	0.00	f
4913	6747	CAJA THERMALTAKE SOPRANO VX VD6000BNS NEGRO			f	t	\N	2	03316747	197	\N	t	68.08	0.00	0.00	f
4914	6748	LECT. TARJ. 3.5" LEGENS 55 EN 1 USB 2.0 ESATA			f	t	\N	2	09046748	109	\N	t	16.16	0.00	0.00	f
4915	6750	CAJA THERMALTAKE BACH VF4000BWS NEGRO VENTANA			f	t	\N	2	03316750	197	\N	t	104.00	0.00	0.00	f
3224	3650	LECTOR C.B. METROLOGIC MS-9520 VOYAGER (USB) 			f	t	\N	2	05033650	120	\N	t	163.40	0.00	0.00	f
3294	3945	IMPRESORA TICKETS SAMSUNG SRP-350 TERMICA NEG			f	t	\N	2	05033945	120	\N	t	271.64	0.00	0.00	f
4916	6751	CAJA THERMALTAKE MOZART SX VC7000SNS SLIM FRO			f	t	\N	2	03316751	197	\N	t	147.36	0.00	0.00	f
4917	6752	CAJA THERMALTAKE MOZART TX VE1000SWA VENTANA			f	t	\N	2	03316752	197	\N	t	203.49	0.00	0.00	f
4918	6753	CAJA CUBO THERMALTAKE LANBOX NEGRO VENTANA			f	t	\N	2	03316753	197	\N	t	100.00	0.00	0.00	f
4244	12	HOSTING G-RIBASAZCONA - TRIMESTRAL			f	f	\N	2	020612	207	\N	\N	90.00	0.00	0.00	f
2892	1223	LATIGUILLO FTP CAT.5E DE 2 MTS MARFIL PL1202			f	t	\N	2	07051223	188	\N	t	1.81	0.00	0.00	f
3451	4525	LATIGUILLO UTP CAT.5E DE 20 MTS GRIS PL1520			f	t	\N	2	07054525	188	\N	t	6.02	0.00	0.00	f
4197	01	BROTHER CARTUCHO TINTA NEGRA LC1000HYBK			t	t	\N	2	080101	99	\N	\N	26.19	0.00	0.00	f
4922	6761	FA. 750W THERMALTAKE TOUGHPOWER SLI READY 14C			f	t	\N	2	03106761	48	\N	t	156.23	0.00	0.00	f
4924	6764	VENTILADOR THERMALTAKE TMGi1 S775 9CM 16dB B.			f	t	\N	2	03136764	51	\N	t	25.55	0.00	0.00	f
4925	6767	CART. HP NEGRO Nº363 PHOTOSMART 8250 C8719EE			f	t	\N	2	08076767	133	\N	t	24.02	0.00	0.00	f
4926	6770	RECARGA MAXTEC CART. UNIV. COLOR + NEGRO 4X10			f	t	\N	2	08066770	132	\N	t	30.12	0.00	0.00	f
4927	6771	CART. MAXTEC PIXMA NEGRO CLI-8BK MP500 800 IP			f	t	\N	2	08066771	132	\N	t	3.57	0.00	0.00	f
3710	5398	RATON LOGITECH VALUE OPTICAL OEM S90 NEGRO PS			f	t	\N	2	04085398	72	\N	t	6.59	0.00	0.00	f
4939	6784	RW DVD DUAL DL SLIM LITEON 8X8X4 DS-8AZH,8A1H			f	t	\N	2	03356784	211	\N	t	56.34	0.00	0.00	f
4940	6794	PB ASUS STRIKER EXTREME 680i 2XPCIE DDR2 2XGL			f	t	\N	2	03116794	86	\N	t	289.71	0.00	0.00	f
4946	6810	SISTEMA DE AYUDA TELEFONICA RIMAX HELP ALARM			f	t	\N	2	13076810	203	\N	t	47.92	0.00	0.00	f
4947	6811	ADAPTADOR USB A TECLADO Y RATON PS2 PH 2080			f	t	\N	2	04236811	148	\N	t	5.53	0.00	0.00	f
4948	6812	HD 500 GB SATA2 WESTERN DIGITAL 7200 RPM 16 M			f	t	\N	2	03166812	54	\N	t	116.17	0.00	0.00	f
3477	4609	TECLADO NGS PLANET OFFICE 125 TECLAS MM USB			f	t	\N	2	04074609	71	\N	t	8.43	0.00	0.00	f
4950	6817	PB INTEL G965OTMKR S775 VGA PCIE DDR2 SATA2 B			f	t	\N	2	03116817	86	\N	t	112.40	0.00	0.00	f
4952	6819	CART. MAXTEC EPSON 680/777 COLOR T018			f	t	\N	2	08066819	132	\N	t	5.86	0.00	0.00	f
4953	6823	CART. BROTHER MFC240C 440CN NEGRO LC1000BK			f	t	\N	2	08076823	133	\N	t	17.27	0.00	0.00	f
4954	6824	CART. BROTHER MFC240C 440CN CYAN LC1000C			f	t	\N	2	08076824	133	\N	t	9.71	0.00	0.00	f
4955	6825	CART. BROTHER MFC240C 440CN AMARILLO LC1000Y			f	t	\N	2	08076825	133	\N	t	10.08	0.00	0.00	f
4134	6162	TFT 19"  BELINEA 1925 S1W PANORAMICO MM NEGRO			f	t	\N	2	04026162	66	\N	t	215.53	0.00	0.00	f
3339	4085	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON			f	t	\N	2	03144085	52	\N	t	51.51	0.00	0.00	f
4330	5243	TECLADO LOGITECH ULTRA-FLAT KEYBOARD			f	t	\N	2	04075243	71	\N	t	15.94	0.00	0.00	f
2836	0465	CABLE VGA M/M 1.8M AK3225			f	t	\N	2	09010465	106	\N	t	2.70	0.00	0.00	f
3347	4107	T.RED USB CONCEPTRONIC WIRELESS 54Mbps C54RU			f	t	\N	2	07014107	94	\N	t	18.45	0.00	0.00	f
3012	2540	CART. JT EPSON C62 CX3200 NEGRO 879JB E70			f	t	\N	2	08062540	132	\N	t	7.81	0.00	0.00	f
3003	2419	CART. JT EPSON C62 CX3200 COLOR 8803JB E71			f	t	\N	2	08062419	132	\N	t	9.10	0.00	0.00	f
4962	6840	CONTROLADORA SATA2 RAID 0-1 SATA 2100			f	t	\N	2	03236840	129	\N	t	29.77	0.00	0.00	f
4964	6847	PB INTEL DQ965GFEKR S775 VGA PCIE DDR2 SATA2 			f	t	\N	2	03116847	86	\N	t	111.40	0.00	0.00	f
4965	6848	SVGA SAPPHIRE RADEON X1650 PRO 512MB DDR2 PCI			f	t	\N	2	03176848	55	\N	t	72.19	0.00	0.00	f
4148	6176	MEMORIA COMPACT FLASH VERBATIM CF 4 GB			f	t	\N	2	04276176	195	\N	t	74.18	0.00	0.00	f
4194	05	BROTHER MFC 5460 CN			t	t	\N	2	042905	217	\N	\N	148.00	0.00	0.00	f
4967	6854	TFT 19"  LG L192WS PLATA 5ms PANORAMICO			f	t	\N	2	04026854	66	\N	t	171.93	0.00	0.00	f
4968	6861	SAI RIELLO DIALOG VISION DUAL DVD220 2200VA 1			f	t	\N	2	04146861	81	\N	t	772.75	0.00	0.00	f
4969	6862	SAI RIELLO PLUG DIALOG PDG400 350VA 225W			f	t	\N	2	04146862	81	\N	t	49.86	0.00	0.00	f
4971	6864	REGLETA RIELLO THUNDERSTORM 5000 5 TOMAS + FA			f	t	\N	2	09026864	107	\N	t	11.80	0.00	0.00	f
4972	6865	ADAPTADOR TELEFONO IP X2 FXS HANDYTONE ATA 38			f	t	\N	2	13076865	203	\N	t	77.04	0.00	0.00	f
4973	6866	PACK PHOTO CART. HP Nº110+120HOJAS 10X15CM Q8			f	t	\N	2	08076866	133	\N	t	28.66	0.00	0.00	f
4178	01	SP CONTAPLUS PRO 2007			t	t	\N	2	070201	95	\N	\N	209.00	0.00	0.00	f
4556	06	OKI TONER AMARILLO C33/C34			f	f	\N	2	081006	137	\N	\N	38.38	0.00	0.00	f
2905	1304	HUB USB MINI CONCEPTRONIC 4 PTOS CSPUSB4			f	t	\N	2	04131304	80	\N	t	7.31	0.00	0.00	f
4190	99	EPSON IMPT STYLUS PHOTO R2400 USB A3			t	t	\N	2	041699	115	\N	\N	775.00	0.00	0.00	f
4202	04	BROTHER CART. TINTA AMARILLA LC1000C			t	t	\N	2	080104	99	\N	\N	10.63	0.00	0.00	f
4974	6867	IMPRESORA HP DESKJET D4260 A4 USB CB641B			f	t	\N	2	04036867	67	\N	t	69.59	0.00	0.00	f
4975	6869	CPU AMD ATHLON64 X2 5600+ AM2 2x(2.8Ghz 1MB) 			f	t	\N	2	03126869	50	\N	t	125.59	0.00	0.00	f
4976	6870	HD 250 GB SATA2 SEAGATE 7200 RPM 16MB			f	t	\N	2	03166870	54	\N	t	61.16	0.00	0.00	f
4978	6881	SVGA ASUS G-FORCE 8800GTX PCIE 768DDR3 DUAL D			f	t	\N	2	03176881	55	\N	t	616.25	0.00	0.00	f
4980	6887	CAJA SEMITORRE ATX 6221CA NEGRA USB+AUDIO			f	t	\N	2	03026887	31	\N	t	52.43	0.00	0.00	f
4981	6892	MEMORIA COMPACT FLASH KINGSTON CF 1 GB CF/1GB			f	t	\N	2	04276892	195	\N	t	14.80	0.00	0.00	f
4987	6905	CAJA EXT. ICY BOX 3.5" SATA / USB IB-351STUS 			f	t	\N	2	04236905	148	\N	t	39.36	0.00	0.00	f
4988	6908	RW DVD DL ASUS 18X8X18X DRW-1814BLT LS NEGRA 			f	t	\N	2	03226908	128	\N	t	27.36	0.00	0.00	f
4996	6916	HD PORTATIL 160 GB FUJITSU SATA 5400RPM 8MB			f	t	\N	2	03276916	194	\N	t	99.94	0.00	0.00	f
5000	6923	ALTAVOCES NGS ICEBERG 2.0 PARA PORTATILES Y M			f	t	\N	2	04066923	70	\N	t	16.53	0.00	0.00	f
5001	6926	VISOR BIXOLON BCD-1000 2 LINEAS SERIE			f	t	\N	2	05036926	120	\N	t	102.01	0.00	0.00	f
5002	6928	SVGA ASUS G-FORCE 8600GTS PCIE 256DDR3 DUAL D			f	t	\N	2	03176928	55	\N	t	172.82	0.00	0.00	f
5003	6929	LEC. TARJ. 15 EN 1 KINGSTON USB 2.0 EXT			f	t	\N	2	04136929	80	\N	t	11.80	0.00	0.00	f
5004	6930	PB INTEL S3000AH XEON/C2D 667 DLAN PCIE SATA2			f	t	\N	2	03116930	86	\N	t	209.57	0.00	0.00	f
5005	6931	MEMORIA DIMM DDR2 1GB 667Mhz KINGSTON ECC			f	t	\N	2	03146931	52	\N	t	28.24	0.00	0.00	f
5006	6932	CPU INTEL XEON D3050 LGA775 FSB1066 2x(2.13GH			f	t	\N	2	03126932	50	\N	t	192.05	0.00	0.00	f
5007	6937	HD PORTATIL 160 GB WESTERN DIGITAL 2.5" 5400R			f	t	\N	2	03276937	194	\N	t	90.30	0.00	0.00	f
5010	6942	SVGA G-FORCE 7200GS 128 512HM PCIE DDR2 DVI T			f	t	\N	2	03176942	55	\N	t	32.42	0.00	0.00	f
5011	6943	SVGA G-FORCE 7200GS 256 512HM PCIE DDR2 DVI T			f	t	\N	2	03176943	55	\N	t	37.25	0.00	0.00	f
5012	6944	SVGA G-FORCE 8500GT PCIE 512DDR2 DVI TV			f	t	\N	2	03176944	55	\N	t	68.70	0.00	0.00	f
5013	6945	TFT 17" AOC 177SA 5MS PLATA NEGRO MM			f	t	\N	2	04026945	66	\N	t	163.17	0.00	0.00	f
5014	6947	AURICULAR CON MICRO NGS SOUNDSATION USB			f	t	\N	2	09076947	189	\N	t	24.84	0.00	0.00	f
5023	6968	CONTROLADORA PCI CONCEPTRONIC HD SATA & IDE			f	t	\N	2	03266968	186	\N	t	20.29	0.00	0.00	f
5024	6969	PB ASUS COMMANDO 775 DDR2 PCIE SATA GLAN 1394			f	t	\N	2	03116969	86	\N	t	229.82	0.00	0.00	f
5028	6975	IMPRESORA EPSON DX7000F MULTIFUNCION CON FAX			f	t	\N	2	04266975	200	\N	t	130.93	0.00	0.00	f
5032	6983	SAI RIELLO DIALOG VISION TOWER DVT110 1100VA 			f	t	\N	2	04146983	81	\N	t	380.83	0.00	0.00	f
5033	6984	SAI RIELLO DIALOG VISION DUAL DVD150 1500VA 1			f	t	\N	2	04146984	81	\N	t	553.94	0.00	0.00	f
5034	6985	SAI RIELLO DIALOG VISION DUAL DVD300 3000VA 2			f	t	\N	2	04146985	81	\N	t	782.39	0.00	0.00	f
5035	6987	VENTILADOR 775 SPIRE QUADROFLOW V SP512S7			f	t	\N	2	03136987	51	\N	t	8.86	0.00	0.00	f
2997	2393	HUB USB MINI NGS 4 PUERTOS			f	t	\N	2	04132393	80	\N	t	8.23	0.00	0.00	f
5036	6990	PORT. SAMSUNG Q45 T7300 2GB 160GB DVD-RW 12.1			f	t	\N	2	02996990	204	\N	t	1549.78	0.00	0.00	f
5039	7000	SVGA G-FORCE 8400GS PCIE 256 DDR2 DVI TV			f	t	\N	2	03177000	55	\N	t	47.86	0.00	0.00	f
5046	7015	CPU INTEL CORE2 DUO E4400 2 GHZ FSB800 2MB LG			f	t	\N	2	03127015	50	\N	t	115.18	0.00	0.00	f
3043	2775	CART. HP COLOR Nº78 DJ PS OJ PSC FAX C6578DE 			f	t	\N	2	08072775	133	\N	t	25.51	0.00	0.00	f
4588	2776	CART. EPSON 740 760 800 850 860 1160 (T051140			f	t	\N	2	08072776	133	\N	t	23.96	0.00	0.00	f
5047	7017	PORT. SAMSUNG R70 T7100 2GB 120GB DVD-RW 15.4			f	t	\N	2	02997017	204	\N	t	1155.36	0.00	0.00	f
5049	7021	IMPRESORA EPSON STYLUS D92 USB DINA4 25PPM 57			f	t	\N	2	04037021	67	\N	t	58.14	0.00	0.00	f
5052	7024	MINIPC ASUS PUNDIT P1-P5945G S775 DDR2 SATA2 			f	t	\N	2	03027024	31	\N	t	156.76	0.00	0.00	f
5053	7025	CABLE CORRIENTE ATX 24PIN EXTENSION 20 cm AK 			f	t	\N	2	03017025	28	\N	t	5.30	0.00	0.00	f
5054	7026	CART. MAXTEC EPSON 400/440/640/740 NEGRO T050			f	t	\N	2	08067026	132	\N	t	3.25	0.00	0.00	f
5056	7028	FA. 450W SHARKOON 8CM SILENT NEGRA PCIE			f	t	\N	2	03107028	48	\N	t	55.01	0.00	0.00	f
3088	3068	CART. JT EPSON C82/CX5200/5400 CYAN 9183 C JB			f	t	\N	2	08063068	132	\N	t	7.14	0.00	0.00	f
5057	7029	VENTILADOR TACENS GELUS LITE 775 754 AM2 14dB			f	t	\N	2	03137029	51	\N	t	21.61	0.00	0.00	f
5058	7031	CAJA SEMITORRE ATX TUNIQ SYMMETRY PLATA NEGRA			f	t	\N	2	03317031	197	\N	t	94.88	0.00	0.00	f
5060	7033	CPU INTEL P DUALCORE E2140 1.6 GHZ FSB800 1MB			f	t	\N	2	03127033	50	\N	t	62.54	0.00	0.00	f
5061	7038	REPRODUCTOR HD CONCEPTRONIC MULTIMEDIA 500 GB			f	t	\N	2	13047038	198	\N	t	192.00	0.00	0.00	f
5063	7040	SVGA ASUS G-FORCE 8600GT PCIE 256DDR3 SILENT 			f	t	\N	2	03177040	55	\N	t	122.14	0.00	0.00	f
5064	7041	HD 250 GB ATA WESTERN DIGITAL 7200 RPM 2MB			f	t	\N	2	03167041	54	\N	t	63.39	0.00	0.00	f
5065	7042	MEMORIA MEMORY STICK PRO DUO 2 GB SONY ADAPTA			f	t	\N	2	04277042	195	\N	t	29.95	0.00	0.00	f
5066	7044	CART. MAXTEC EPSON 1270 1280 1290 NEGRO T007			f	t	\N	2	08067044	132	\N	t	3.90	0.00	0.00	f
5068	7049	CONTROLADORA 4(+1 INT) PTOS. USB 2.0 USB4212V			f	t	\N	2	03267049	186	\N	t	15.45	0.00	0.00	f
5069	7050	CAPTURADORA TV EXT. PINNACLE PCTV HIBRYD PRO 			f	t	\N	2	04207050	143	\N	t	97.28	0.00	0.00	f
5070	7052	RW DVD DUAL DL SLIM LITEON 8X8X4 DS-8AZP OEM			f	t	\N	2	03357052	211	\N	t	52.41	0.00	0.00	f
5071	7054	EXTENSION DE GARANTIA PORTATIL SAMSUNG 3 AÑOS			f	t	\N	2	10057054	187	\N	t	128.42	0.00	0.00	f
5072	7055	RW DVD DUAL DL LITEON 20X4X20X LH-20A1P 3 FRO			f	t	\N	2	03227055	128	\N	t	31.07	0.00	0.00	f
5073	7056	IMP. TICKETS SAMSUNG SRP-350+COP TERM.			f	t	\N	2	05037056	120	\N	t	281.36	0.00	0.00	f
5074	7057	VISOR BIXOLON BCD-1000 2 LINEAS SERIE NEGRO			f	t	\N	2	05037057	120	\N	t	99.22	0.00	0.00	f
3184	3449	CARTUCHO LIMPIADOR HP SUPER DLT C7982A			f	t	\N	2	08033449	101	\N	t	75.13	0.00	0.00	f
5075	7058	LECTOR C.B. LG303B LASER NEGRO TECLADO PS2			f	t	\N	2	05037058	120	\N	t	138.90	0.00	0.00	f
5076	7061	MEMORIA COMPACT FLASH KINGSTON CF 2 GB CF/2GB			f	t	\N	2	04277061	195	\N	t	23.28	0.00	0.00	f
5077	7062	MEMORIA COMPACT FLASH KINGSTON CF 2 GB 50X EL			f	t	\N	2	04277062	195	\N	t	38.04	0.00	0.00	f
5079	7064	CPU INTEL CELERON 420 1.6 GHz 512K 800M S775 			f	t	\N	2	03127064	50	\N	t	34.73	0.00	0.00	f
3215	3634	BLISTER 4UDS PILAS CEGASA LR6 SUPER ALKALINE			f	t	\N	2	09023634	107	\N	t	2.66	0.00	0.00	f
3216	3635	BLISTER 4UDS PILAS CEGASA LR03 EVOLUTION			f	t	\N	2	09023635	107	\N	t	3.49	0.00	0.00	f
5084	7074	RATON LOGITECH G5 LASER MOUSE AZUL			f	t	\N	2	04087074	72	\N	t	63.35	0.00	0.00	f
5085	7076	TECLADO REDUCIDO TPV IONE SCORPIUS 2K NEGRO			f	t	\N	2	05037076	120	\N	t	25.52	0.00	0.00	f
5086	7077	CAJON PORTAMONEDAS TPV 41 CM. AUTO 415LO-N NE			f	t	\N	2	05037077	120	\N	t	46.81	0.00	0.00	f
5087	7078	REPRODUCTOR HD RIMAX ALUM LCD 320 GB USB2			f	t	\N	2	13047078	198	\N	t	160.24	0.00	0.00	f
5088	7080	MALETIN TARGUS XS SUBNOTEBOOK 12" NEGRO			f	t	\N	2	09107080	190	\N	t	43.19	0.00	0.00	f
5091	7085	LECTOR C.B. CCD-SD313E INFRARROJOS PS/2 GRIS			f	t	\N	2	05037085	120	\N	t	35.43	0.00	0.00	f
5092	7086	CAJA CUBO MICRO ATX AEROCOOL RACER NEGRA			f	t	\N	2	03317086	197	\N	t	61.35	0.00	0.00	f
5093	7087	CAJA THERMALTAKE SOPRANO DX VE7000SWA PLATA V			f	t	\N	2	03317087	197	\N	t	133.01	0.00	0.00	f
5094	7089	SOFT. ANTIVIRUS NORTON 360 RETAIL			f	t	\N	2	06037089	91	\N	t	79.81	0.00	0.00	f
5096	7091	PCMCIA LEC. TARJ. 10 EN 1 CONCEPTRONIC			f	t	\N	2	04157091	82	\N	t	25.82	0.00	0.00	f
5097	7092	MEMORIA SECURE DIGITAL KINGSTON SD 1 GB			f	t	\N	2	04277092	195	\N	t	9.65	0.00	0.00	f
5102	7097	REPRODUCTOR MP3 CREATIVE ZEN STONE PLUS 2GB N			f	t	\N	2	13047097	198	\N	t	65.23	0.00	0.00	f
5103	7103	CAJON PORTAMONEDAS TPV 41 CM. AUTO 415LO-G GR			f	t	\N	2	05037103	120	\N	t	42.52	0.00	0.00	f
5104	7104	LECTOR C.B. LG303 LASER USB			f	t	\N	2	05037104	120	\N	t	148.83	0.00	0.00	f
5105	7105	LECTOR C.B. LG303B LASER NEGRO USB			f	t	\N	2	05037105	120	\N	t	148.83	0.00	0.00	f
5110	7113	AURICULAR CON MICRO NGS MSX MAJESTIC ERGONOMI			f	t	\N	2	09077113	189	\N	t	9.98	0.00	0.00	f
5111	7114	AURICULAR CON MICRO NGS MSX CHIC ERGONOMICOS			f	t	\N	2	09077114	189	\N	t	16.53	0.00	0.00	f
5112	7115	AURICULARES CON MICRO NGS MSX EXTREME			f	t	\N	2	09077115	189	\N	t	16.53	0.00	0.00	f
5113	7116	CPU INTEL CORE2 DUO E6750 2.66 GHZ FSB1333 4M			f	t	\N	2	03127116	50	\N	t	166.23	0.00	0.00	f
5114	7118	REPRODUCTOR HD SATA CONCEPTRONIC MMPLAYER 320			f	t	\N	2	13047118	198	\N	t	167.17	0.00	0.00	f
5115	7119	MEMORIA SO DIMM DDR2 1GB 533MHz KINGSTON ACER			f	t	\N	2	03287119	193	\N	t	44.49	0.00	0.00	f
5116	7120	LATIGUILLO FIBRA OPTICA VF-45 DE 2 MTS			f	t	\N	2	07057120	188	\N	t	47.54	0.00	0.00	f
5117	7121	LATIGUILLO FIBRA OPTICA VF-45 ST DE 2 MTS			f	t	\N	2	07057121	188	\N	t	47.64	0.00	0.00	f
5118	7122	SVGA SAPPHIRE ATI RADEON HD 2900XT PCIE 512MB			f	t	\N	2	03177122	55	\N	t	401.60	0.00	0.00	f
5119	7123	LECTOR C.B. LG303 LASER PS2			f	t	\N	2	05037123	120	\N	t	138.90	0.00	0.00	f
3334	4075	LATIGUILLO UTP CAT.6E DE 1MT GRIS IB8001			f	t	\N	2	07054075	188	\N	t	2.57	0.00	0.00	f
5122	7126	IMPRESORA FOTOGRAFICA CANON SELPHY CP720			f	t	\N	2	04037126	67	\N	t	81.06	0.00	0.00	f
5123	7128	IMPRESORA HP OFFICEJET PRO K5400 1200 DPI 4 C			f	t	\N	2	04037128	67	\N	t	153.00	0.00	0.00	f
5125	7130	LATIGUILLO UTP CAT.5E DE 10 MTS MARFIL LA1010			f	t	\N	2	07057130	188	\N	t	4.96	0.00	0.00	f
5126	7131	RATON NGS MINIMOUSE FLEA EVOLUTION USB OPTICA			f	t	\N	2	04087131	72	\N	t	8.23	0.00	0.00	f
5127	7132	AURICULAR CON MICRO NGS VOX320 DJ HUB MULTIME			f	t	\N	2	09077132	189	\N	t	13.22	0.00	0.00	f
5128	7133	REPRODUCTOR HD SATA CONCEPTRONIC MMPLUS 500GB			f	t	\N	2	13047133	198	\N	t	194.24	0.00	0.00	f
5129	7135	BACKUP INT. IOMEGA REV DRIVE 70/140GB SATA+DI			f	t	\N	2	03157135	53	\N	t	523.66	0.00	0.00	f
5131	7138	CAJA EXT. ICY BOX 3.5" SATA USB IB-361STUS-BL			f	t	\N	2	04237138	148	\N	t	49.78	0.00	0.00	f
3360	4154	CART. HP COLOR Nº348 DJ5740 OJ7410 PSC2350/55			f	t	\N	2	08074154	133	\N	t	20.14	0.00	0.00	f
5133	7140	RW DVD DUAL DL USB 2.0 LITEON 20X8X20X LH-20A			f	t	\N	2	04187140	121	\N	t	62.31	0.00	0.00	f
5134	7143	PB INTEL DP35DPM S775 PCIE DDR2 SATA2 GLAN FW			f	t	\N	2	03117143	86	\N	t	110.25	0.00	0.00	f
5135	7144	DVD ROM LG 16X52X GDR-H30N NEGRO OEM			f	t	\N	2	03197144	124	\N	t	15.19	0.00	0.00	f
5136	7145	CPU INTEL XEON D3060 LGA775 FSB1066 2x(2. 4 G			f	t	\N	2	03127145	50	\N	t	233.30	0.00	0.00	f
5138	7147	PB INTEL DG33FBC S775 VGA PCIE DDR2 SATA2 GLA			f	t	\N	2	03117147	86	\N	t	104.47	0.00	0.00	f
5140	7150	VOLANTE NGS COUPE VIBRACION PEDALES USB PS2 P			f	t	\N	2	04097150	73	\N	t	24.84	0.00	0.00	f
5142	7152	CAMARA WEB NGS SKULL 350K USB			f	t	\N	2	04117152	75	\N	t	9.98	0.00	0.00	f
4613	4239	MEMORIA SO DIMM DDR 512 MB 333Mhz KINGSTON			f	t	\N	2	03284239	193	\N	t	34.64	0.00	0.00	f
5143	7153	SVGA ASUS RADEON X1300 PRO PCIE 256MB DDR2 DV			f	t	\N	2	03177153	55	\N	t	71.88	0.00	0.00	f
5146	7160	HD PORTATIL 120 GB WESTERN DIGITAL 2.5" 5400R			f	t	\N	2	03277160	194	\N	t	71.51	0.00	0.00	f
5147	7161	CPU INTEL CORE2 DUO E6550 2.33 GHZ FSB1333 4M			f	t	\N	2	03127161	50	\N	t	147.49	0.00	0.00	f
5148	7162	RW DVD DUAL DL LITEON 20X4X20X LH-20A1H LS BL			f	t	\N	2	03227162	128	\N	t	31.08	0.00	0.00	f
5149	7164	TRANSCEPTOR DE RED CONNECTION ETHER TX-FX RJ4			f	t	\N	2	07057164	188	\N	t	82.83	0.00	0.00	f
5150	7165	CART. EPSON STYLUS 3000 PRO5000 NEGRO C13S020			f	t	\N	2	08077165	133	\N	t	59.83	0.00	0.00	f
5151	7166	CART. EPSON STYLUS 3000 PRO5000 AMARILLO C13S			f	t	\N	2	08077166	133	\N	t	59.83	0.00	0.00	f
5152	7167	CART. EPSON STYLUS 3000 PRO5000 MAGENTA C13S0			f	t	\N	2	08077167	133	\N	t	110.52	0.00	0.00	f
5153	7168	CART. EPSON STYLUS 3000 PRO5000 CYAN C13S0201			f	t	\N	2	08077168	133	\N	t	59.83	0.00	0.00	f
5154	7170	CPU INTEL CORE2 QUAD Q6600 2.40 GHZ FSB1066 8			f	t	\N	2	03127170	50	\N	t	240.87	0.00	0.00	f
5155	7172	PB ASROCK 4CORE1333-ESATA2 2XPCI-E GLAN SATA2			f	t	\N	2	03117172	86	\N	t	85.58	0.00	0.00	f
5158	7177	CAJA SEMITORRE ATX ZORRO NEGRA PLATA 12CM			f	t	\N	2	03027177	31	\N	t	52.64	0.00	0.00	f
5167	7188	PB ASROCK CONROE1333-ESATA2 2XPCI-E GLAN SATA			f	t	\N	2	03117188	86	\N	t	85.58	0.00	0.00	f
5168	7189	TFT 19" SAMSUNG SM 940N 8MS PIVOT 1280X1024 S			f	t	\N	2	04027189	66	\N	t	263.40	0.00	0.00	f
5170	7191	TRANSFORMADOR DC/AC RIMAX CAR INVERTER SPEEDY			f	t	\N	2	09027191	107	\N	t	34.48	0.00	0.00	f
5171	7192	ARMARIO RACK 19" 600X450Mm 12U +ACCESORIOS WM			f	t	\N	2	07047192	150	\N	t	206.12	0.00	0.00	f
5173	7194	LATIGUILLO UTP CAT.6E DE 3MTS GRIS LN 1603			f	t	\N	2	07057194	188	\N	t	2.53	0.00	0.00	f
5175	7199	IMPRESORA HP PHOTOSMART D7360 MULTIFUNCION US			f	t	\N	2	04037199	67	\N	t	122.17	0.00	0.00	f
5176	7200	SOFT. ANTIVIRUS PANDA ANTIVIRUS 2008+ANTISPYW			f	t	\N	2	06037200	91	\N	t	34.02	0.00	0.00	f
5177	7201	SVGA XFX G-FORCE 8800GTS PCIE 320DDR3 DUAL DV			f	t	\N	2	03177201	55	\N	t	300.52	0.00	0.00	f
3455	4533	CART. EPSON D68 D88 DX3800 MAGENTA T061340LB			f	t	\N	2	08074533	133	\N	t	7.96	0.00	0.00	f
5179	7204	CART. HP NEGRO Nº350 CB335EE			f	t	\N	2	08077204	133	\N	t	11.61	0.00	0.00	f
5180	7205	CART. HP NEGRO Nº350XL 25ml CB336EE			f	t	\N	2	08077205	133	\N	t	26.40	0.00	0.00	f
5181	7206	CART. HP COLOR Nº 351 3.5ml CB337EE			f	t	\N	2	08077206	133	\N	t	14.42	0.00	0.00	f
5182	7207	CART. HP COLOR Nº 351XL 14ml CB338EE			f	t	\N	2	08077207	133	\N	t	28.59	0.00	0.00	f
5183	7208	PB ASROCK CONROE1333-D667 R1.0 VGA LAN SON SA			f	t	\N	2	03117208	86	\N	t	45.23	0.00	0.00	f
5184	7212	REPRODUCTOR HD ARTICFLAMES USB2.0 DIVX LECT. 			f	t	\N	2	04237212	148	\N	t	76.40	0.00	0.00	f
5189	7220	GAMEPAD NGS COBRA 12 BOTONES VIBRACION PS2/US			f	t	\N	2	04097220	73	\N	t	16.53	0.00	0.00	f
5190	7221	DESKTOP NGS TRAIL-BLAZING INALAMBRICO MULTIME			f	t	\N	2	04077221	71	\N	t	33.16	0.00	0.00	f
5191	7222	RATON NGS OPTICO SNAKE FLASH P/ PORTATL USB			f	t	\N	2	04087222	72	\N	t	14.95	0.00	0.00	f
5192	7224	IMPRESORA EPSON STYLUS PHOTO RX585 LCD USB 6 			f	t	\N	2	04037224	67	\N	t	163.58	0.00	0.00	f
5193	7225	CART. MAXTEC CANON S300 NEGRO MX-24BK			f	t	\N	2	08067225	132	\N	t	2.53	0.00	0.00	f
5194	7226	PORT. SAMSUNG R60+ T7300 2GB 200GB DVD-RW 15.			f	t	\N	2	02997226	204	\N	t	985.55	0.00	0.00	f
5195	7227	DISQUETERA USB 1.44M 2.5" SONY NEGRA			f	t	\N	2	04197227	142	\N	t	26.19	0.00	0.00	f
3478	4612	LUZ PARA PORTATIL NGS SHINY ALIMENTADA POR US			f	t	\N	2	04234612	148	\N	t	8.23	0.00	0.00	f
5196	7228	PORT. SAMSUNG Q1 ULTRA 1024MB 60GB 7   WXGA			f	t	\N	2	02997228	204	\N	t	1145.39	0.00	0.00	f
5199	7234	PB ASROCK 4COREDUAL-SATA2 AGP8 SATA2 LAN HDMI			f	t	\N	2	03117234	86	\N	t	57.46	0.00	0.00	f
5200	7235	BATERIA DE PORTATIL COMPATIBLE COMPAQ PRES M2			f	t	\N	2	02047235	58	\N	t	107.41	0.00	0.00	f
5201	7236	PANEL REPARTIDOR 24 UTP CAT.5E RACGALPP24UC5			f	t	\N	2	07067236	185	\N	t	29.00	0.00	0.00	f
5202	7237	CAJA EXT. CONCEPTRONIC 3.5" SATA GRABNGO CHD3			f	t	\N	2	04197237	142	\N	t	24.43	0.00	0.00	f
5203	7238	RW DVD DUAL DL LITEON 20X12X20X LIGHTSCRIBE B			f	t	\N	2	03227238	128	\N	t	30.40	0.00	0.00	f
5204	7239	RW DVD DUAL DL SLIM SAMSUNG 8X8X6 NEGRO OEM			f	t	\N	2	03357239	211	\N	t	49.40	0.00	0.00	f
5205	7240	CART. HP CYAN Nº363 PHOTOSMART 8250 C8771EE			f	t	\N	2	08077240	133	\N	t	8.10	0.00	0.00	f
5206	7241	CART. HP MAGENTA Nº363 PHOTOSMART 8250 C8772E			f	t	\N	2	08077241	133	\N	t	8.82	0.00	0.00	f
5207	7242	CART. HP AMARILLO Nº363 PHOTOSMART 8250 C8773			f	t	\N	2	08077242	133	\N	t	8.10	0.00	0.00	f
5208	7243	CAJA SERVIDOR ENLIGHT PR42A1			f	t	\N	2	03037243	32	\N	t	66.16	0.00	0.00	f
5209	7249	CAJA THERMALTAKE MOZART SILVER VC4000SN			f	t	\N	2	03317249	197	\N	t	107.05	0.00	0.00	f
5210	7250	ADAPTADOR DVI-i A VGA H/M AB3755			f	t	\N	2	09017250	106	\N	t	9.48	0.00	0.00	f
5211	7251	ALTAVOCES LOGITECH X-240 / 2.1 CON BASE MULTI			f	t	\N	2	04067251	70	\N	t	39.14	0.00	0.00	f
5212	7252	RATON LOGITECH G9 LASER MOUSE			f	t	\N	2	04087252	72	\N	t	81.42	0.00	0.00	f
5213	7253	RATON LOGITECH LX7 CORDLESS OPTICAL MOUSE AZU			f	t	\N	2	04087253	72	\N	t	33.82	0.00	0.00	f
5215	7256	CINTA EPSON LQ 630 NEGRO (C13S015307)			f	t	\N	2	08057256	103	\N	t	6.12	0.00	0.00	f
5216	7257	RATON LOGITECH PILOT OPTICAL MOUSE NEGRO 1000			f	t	\N	2	04087257	72	\N	t	15.83	0.00	0.00	f
5217	7258	RATON LOGITECH CORDLESS VX NANO LASER PORTIL			f	t	\N	2	04087258	72	\N	t	56.66	0.00	0.00	f
5218	7259	RATON LOGITECH V320 CORDLESS OPTICAL NOTEBOOK			f	t	\N	2	04087259	72	\N	t	32.39	0.00	0.00	f
5219	7260	RATON LOGITECH V220 CORDLESS OPTICAL NOTEBOOK			f	t	\N	2	04087260	72	\N	t	24.47	0.00	0.00	f
5220	7261	RATON LOGITECH V100 OPTICAL MOUSE NOTEBOOK			f	t	\N	2	04087261	72	\N	t	16.41	0.00	0.00	f
5221	7262	SOFT. ANTIVIRUS McAFEE VIRUSSCAN PLUS 2008			f	t	\N	2	06037262	91	\N	t	30.20	0.00	0.00	f
5222	7264	TONER IMP. OKI C5600 SERIES NEGRO			f	t	\N	2	08097264	136	\N	t	77.35	0.00	0.00	f
3502	4686	RATON NGS PLUME DELUXE MOUSE OPT WIRELESS P.L			f	t	\N	2	04084686	72	\N	t	24.86	0.00	0.00	f
3506	4690	RATON NGS OPTICAL KITSCH P/ PORTATILES USB			f	t	\N	2	04084690	72	\N	t	12.39	0.00	0.00	f
3513	4706	CART. JT EPSON D68 D88 DX3800 AMARILLLO E106Y			f	t	\N	2	08064706	132	\N	t	4.55	0.00	0.00	f
5224	7267	PB ASUS P5VD2-VM SE LGA775 PCIE VGA DDR2 SATA			f	t	\N	2	03117267	86	\N	t	47.76	0.00	0.00	f
5236	7281	PB ASUS P5K-E/WIFI-AP AIRLIFESTYLE IP35 SATA2			f	t	\N	2	03117281	86	\N	t	157.04	0.00	0.00	f
3539	4806	TONER IMP. EPSON AL2600N C2600N AMARILLO			f	t	\N	2	08094806	136	\N	t	74.25	0.00	0.00	f
3540	4807	TONER IMP. EPSON AL2600N C2600N MAGENTA			f	t	\N	2	08094807	136	\N	t	73.95	0.00	0.00	f
3541	4808	TONER IMP. EPSON AL2600N C2600N CYAN			f	t	\N	2	08094808	136	\N	t	73.95	0.00	0.00	f
5241	7287	PB ASUS P5KPL-VM G31 VGA 1333 PCI-E SATA2 DDR			f	t	\N	2	03117287	86	\N	t	80.95	0.00	0.00	f
5245	7291	RATON NGS SHUTTLE GAMING OPTICO USB			f	t	\N	2	04087291	72	\N	t	40.71	0.00	0.00	f
5246	7292	RATON NGS VAMP GAMING OPTICO USB			f	t	\N	2	04087292	72	\N	t	32.41	0.00	0.00	f
5247	7293	CAMARA WEB NGS CYCLOPS 352x288			f	t	\N	2	04117293	75	\N	t	12.39	0.00	0.00	f
5248	7294	TECLADO NGS 108 MULTIMEDIA NEGRO WEBMASTER US			f	t	\N	2	04077294	71	\N	t	7.80	0.00	0.00	f
5249	7295	CAJA THERMALTAKE MATRIX VD3000BW NEGRA VENTAN			f	t	\N	2	03317295	197	\N	t	95.78	0.00	0.00	f
3551	4849	TONER IMP. HP LASERJET 2600N CYAN Q6001A			f	t	\N	2	08094849	136	\N	t	62.92	0.00	0.00	f
3552	4850	TONER IMP. HP LASERJET 2600N AMARILLO Q6002A			f	t	\N	2	08094850	136	\N	t	62.92	0.00	0.00	f
3553	4851	TONER IMP. HP LASERJET 2600N MAGENTA Q6003A			f	t	\N	2	08094851	136	\N	t	62.92	0.00	0.00	f
5250	7296	TFT 19" I-INC AG191DP 8MS PLATA NEGRO MM			f	t	\N	2	04027296	66	\N	t	155.67	0.00	0.00	f
5251	7297	SAI RIELLO PLUG DIALOG PDG600 550VA 335W			f	t	\N	2	04147297	81	\N	t	55.40	0.00	0.00	f
5252	7298	PB ASUS P5KPL G31 S775 1333 PCIE DDR2 SATA2 G			f	t	\N	2	03117298	86	\N	t	80.95	0.00	0.00	f
5253	7299	ROUTER ADSL RDSI CISCO 836 + 4 PUERTOS LAN 10			f	t	\N	2	07077299	220	\N	t	423.87	0.00	0.00	f
5254	7300	TFT 17"  RYOKU / YURAKU M17NPXA 8MS PLATA 0.2			f	t	\N	2	04027300	66	\N	t	148.30	0.00	0.00	f
5255	7301	CART. LEXMARK Nº17 Z617 NEGRO			f	t	\N	2	08077301	133	\N	t	29.71	0.00	0.00	f
5256	7302	SVGA ASUS EN7300GT SILENT/HTD/256M PCI-E DDR2			f	t	\N	2	03177302	55	\N	t	58.33	0.00	0.00	f
5257	7303	RATON LOGITECH NX50 NOTEBOOK LASER MOUSE			f	t	\N	2	04087303	72	\N	t	14.58	0.00	0.00	f
5258	7304	IMPRESORA EPSON DX7400 MULTIFUNCION			f	t	\N	2	04267304	200	\N	t	89.87	0.00	0.00	f
5259	7305	IMPRESORA HP LASERJET 3600 COLOR Q5986A			f	t	\N	2	04247305	173	\N	t	472.14	0.00	0.00	f
5260	7306	CABLE DE IMPRESORA IEEE 1284 3METROS M-M AK 5			f	t	\N	2	09017306	106	\N	t	12.69	0.00	0.00	f
5261	7307	MCAFEE TOTAL PROTECTION FOR SB 1:1 GOLD 2USER			f	t	\N	2	06037307	91	\N	t	50.60	0.00	0.00	f
5262	7308	MINIPC SHUTTLE SG31G2S 775 G31+ICH7 DDR2 SATA			f	t	\N	2	03027308	31	\N	t	308.30	0.00	0.00	f
5263	7309	REPRODUCTOR HD SATA CONCEPTRONIC MMPLUS 400GB			f	t	\N	2	13047309	198	\N	t	181.41	0.00	0.00	f
5264	7310	RW DVD DL SATA SAMSUNG 20X8X20X SH-S203B NEGR			f	t	\N	2	03227310	128	\N	t	28.53	0.00	0.00	f
5265	7311	IMPRESORA HP DESKJET F4180 MULTIFUNCION			f	t	\N	2	04267311	200	\N	t	73.93	0.00	0.00	f
5266	7312	PB ASROCK P4VM900-SATA2 VIA P4M900 VGA PCIE R			f	t	\N	2	03117312	86	\N	t	47.22	0.00	0.00	f
5267	7313	GATEWAY D-LINK DIR-100 ( SWITCH 4P + FIREWALL			f	t	\N	2	07077313	220	\N	t	36.02	0.00	0.00	f
5268	7314	CABLE USB EXTENSION 1,8 Mts. M/H A/A KO 1200			f	t	\N	2	09017314	106	\N	t	1.29	0.00	0.00	f
5269	7315	CABLE AUDIO CONEXIÓN RCA M/M HQ 2 METROS AK 2			f	t	\N	2	09017315	106	\N	t	1.60	0.00	0.00	f
5270	7316	VENTILADOR TOWER 120 ULTRA SILENT CPU COOLER			f	t	\N	2	03137316	51	\N	t	50.84	0.00	0.00	f
5271	7317	PANEL VACIO 8 PORTS OPTILAN 1U PARA RACK 12			f	t	\N	2	07067317	185	\N	t	5.86	0.00	0.00	f
5272	7318	SVGA G-FORCE 7200GS 256MB PCIE DDR2 DVI SILEN			f	t	\N	2	03177318	55	\N	t	33.25	0.00	0.00	f
5273	7319	SVGA MSI RX1550-TD256E 256M PCI-E DDR2 DVI HD			f	t	\N	2	03177319	55	\N	t	30.73	0.00	0.00	f
5274	7320	REPRODUCTOR MP4 RIMAX COSMIC 2GB MP4 LCD 2"			f	t	\N	2	13047320	198	\N	t	63.25	0.00	0.00	f
5275	7321	REPRODUCTOR MP4 RIMAX COSMIC 4GB MP4 LCD 2"			f	t	\N	2	13047321	198	\N	t	80.92	0.00	0.00	f
5276	7322	CAJA SERVIDOR INTEL SC5299DP TORRE SERIES			f	t	\N	2	03037322	32	\N	t	218.88	0.00	0.00	f
5277	7323	MINI CAMBIADOR DE GENERO HD15 H/H AB 9065			f	t	\N	2	09017323	106	\N	t	2.73	0.00	0.00	f
5278	7324	LEC. TARJ. 21 EN 1 CONCEPTRONIC USB 2.0 EXT v			f	t	\N	2	04237324	148	\N	t	10.37	0.00	0.00	f
5279	7325	CPU AMD ATHLON64 3800+ AM2 2.4Ghz 512KB BOX			f	t	\N	2	03127325	50	\N	t	53.95	0.00	0.00	f
5280	7326	PB INTEL DG33FBC S775 VGA PCIE DDR2 SATA2 BUL			f	t	\N	2	03117326	86	\N	t	103.06	0.00	0.00	f
5281	7327	ESCANER DOCUMENTAL HP SCANJET N7710 600X600pp			f	t	\N	2	04057327	69	\N	t	1008.49	0.00	0.00	f
5282	7328	NAS ICY BOX IB-NAS4220-B 3.5 RAID JBOD NRAID 			f	t	\N	2	04197328	142	\N	t	170.19	0.00	0.00	f
5283	7329	MINIPC ASUS PUNDIT P2-P5945G S775 DDR2 SATA2 			f	t	\N	2	03027329	31	\N	t	173.65	0.00	0.00	f
5284	7330	CAJA DE SEGURIDAD RIMAX 510BIO APERTURA BIOME			f	t	\N	2	09027330	107	\N	t	155.12	0.00	0.00	f
5285	7331	HD PORTATIL 120 GB ATA SEAGATE 5400RPM 8MB			f	t	\N	2	03277331	194	\N	t	78.04	0.00	0.00	f
5286	7332	BACKUP EXEC 11D WINDOWS SERVER CONTINUOUS PRO			f	t	\N	2	06037332	91	\N	t	654.47	0.00	0.00	f
5287	7333	HD EXT. USB 250 GB WESTERN DIGITAL 5400RPM 2M			f	t	\N	2	04197333	142	\N	t	191.11	0.00	0.00	f
5288	7334	MINIPC ASUS PUNDIT P3-PH4C S775 DDR2 SATA2 NE			f	t	\N	2	03027334	31	\N	t	160.78	0.00	0.00	f
5289	7335	MINIPC ASUS PUNDIT P3-PH5X S775 DDR2 SATA2 NE			f	t	\N	2	03027335	31	\N	t	182.36	0.00	0.00	f
5290	7336	TFT 19"  PHILIPS 190S8FS PLATA 1280X1024 5MS 			f	t	\N	2	04027336	66	\N	t	204.23	0.00	0.00	f
5291	7337	PAPEL FOTO CANON PRO PR-101 4X6 20HOJAS SATIN			f	t	\N	2	08107337	137	\N	t	7.34	0.00	0.00	f
5292	7338	HD EXT. USB 160 GB WESTERN DIGITAL 5400RPM 2M			f	t	\N	2	04197338	142	\N	t	108.61	0.00	0.00	f
5293	7339	T.RED PCI OVISLINK FE-100T 10/100 F.O. ST			f	t	\N	2	03297339	183	\N	t	95.27	0.00	0.00	f
5294	7340	SOFT. ANTIVIRUS NORTON 2008 3 USUARIOS			f	t	\N	2	06037340	91	\N	t	38.27	0.00	0.00	f
5361	7407	FA. 600W GC PFC PIV 12CM 20/24 PIN SA			f	t	\N	2	03107407	48	\N	t	22.60	0.00	0.00	f
5362	7408	CAJA MICRO ATX DH-153-C PLATA NEGRO 250W			f	t	\N	2	03027408	31	\N	t	54.46	0.00	0.00	f
5363	7409	PB INTEL S5000PSLSASR  DXEON 667 SAS PCIE SAT			f	t	\N	2	03117409	86	\N	t	574.58	0.00	0.00	f
5364	7410	SOFT. NORTON INTERNET SECURITY 2008 3 USUARIO			f	t	\N	2	06037410	91	\N	t	70.87	0.00	0.00	f
5365	7411	PB INTEL DQ965GFEKR S775 VGA PCIE DDR2 SATA2 			f	t	\N	2	03117411	86	\N	t	121.35	0.00	0.00	f
5366	7412	MOCHILA DE PORTATIL KINETIK 15.4 MOBILE BACKP			f	t	\N	2	09107412	190	\N	t	64.82	0.00	0.00	f
5369	7416	KIT MEMORIA DIMM FBDDR2 2X512MB 667Mhz HP			f	t	\N	2	03147416	52	\N	t	180.72	0.00	0.00	f
5370	7417	HD  80 GB SATA HP 7200 RPM 349237-B21			f	t	\N	2	03167417	54	\N	t	95.84	0.00	0.00	f
5371	7418	MEMORIA xD PICTURE TYPE M FUJIFILM 1 GB			f	t	\N	2	04277418	195	\N	t	28.07	0.00	0.00	f
5372	7419	PEN DRIVE 1 GB TAKE MS COLOURLINE USB 2.0 ROJ			f	t	\N	2	04277419	195	\N	t	8.12	0.00	0.00	f
5373	7420	PORT. SAMSUNG R60+ T2330 2GB 160GB DVD-RW 15.			f	t	\N	2	02997420	204	\N	t	778.52	0.00	0.00	f
5374	7421	RW DVD DUAL DL LG 18X8X18X GSA-H54L OEM			f	t	\N	2	03227421	128	\N	t	24.99	0.00	0.00	f
5375	7422	CONECTOR PHASAK N JACK RG58 PB 6101			f	t	\N	2	09027422	107	\N	t	2.27	0.00	0.00	f
5376	7423	PORT. SAMSUNG X11 T2300 512MB 60GB DVD-RW 14.			f	t	\N	2	02997423	204	\N	t	530.82	0.00	0.00	f
5377	7424	CABEZAL PLOTTER HP 2100C CN 2300C Nº11 AMARIL			f	t	\N	2	08077424	133	\N	t	28.18	0.00	0.00	f
5379	7426	KIT MEMORIA DIMM DDR2 2x1GB 1066MHz KINGSTON 			f	t	\N	2	03147426	52	\N	t	124.92	0.00	0.00	f
5380	7427	ADAPTADOR CONCEPTRONIC USB SOUND ADAPTER CSOU			f	t	\N	2	04237427	148	\N	t	15.66	0.00	0.00	f
5381	7428	MEMORIA SO DIMM SDRAM 512MB 266Mhz KINGSTON F			f	t	\N	2	03287428	193	\N	t	48.33	0.00	0.00	f
4639	5258	LECTOR C.B. METROLOGIC MS-9535BT VOYAGER BT N			f	t	\N	2	05035258	120	\N	t	359.08	0.00	0.00	f
4331	5262	HD 400 GB SATA2 SEAGATE 7200 RPM 16MB			f	t	\N	2	03165262	54	\N	t	90.57	0.00	0.00	f
5383	7430	KIT EXTENSION VGA KVM PS/2 POR UTP 150 METROS			f	t	\N	2	09027430	107	\N	t	210.10	0.00	0.00	f
5385	7435	INTERFACE ETHERNET IMPRESORAS EPSON 10/100 UB			f	t	\N	2	05037435	120	\N	t	157.37	0.00	0.00	f
5386	7437	MINIPC ASUS PUNDIT P1-P5945GCX S775 DDR2 SATA			f	t	\N	2	03027437	31	\N	t	159.08	0.00	0.00	f
5387	7438	PB ASUS M2N-SLI DELUXE NF570 AM2 2XPCIE DDR2 			f	t	\N	2	03327438	196	\N	t	107.30	0.00	0.00	f
3705	5383	GUIAS FIJAS PARA RACK DE 600MM RT 3010			f	t	\N	2	07065383	185	\N	t	18.42	0.00	0.00	f
3706	5384	PASTA TERMICA CPU  3 GRAMOS DTA 110			f	t	\N	2	09025384	107	\N	t	6.02	0.00	0.00	f
3728	5423	T.RED PCI D-LINK WIRELESS LAN DWL-G510 54MBPS			f	t	\N	2	07015423	94	\N	t	21.57	0.00	0.00	f
3777	5531	AURICULAR CON MICROFONO NGS MSX4PRO MULTIMEDI			f	t	\N	2	09075531	189	\N	t	6.47	0.00	0.00	f
3795	5588	TONER IMP. HP LASERJET 4600 SERIES CYAN C9721			f	t	\N	2	08095588	136	\N	t	167.55	0.00	0.00	f
4649	5605	CPU AMD ATHLON64 3000+ AM2 1000 1.8Ghz 512KB 			f	t	\N	2	03125605	50	\N	t	41.89	0.00	0.00	f
3824	5649	URBAN SET MALETIN ORGANICER + RATON VIPMOUSE			f	t	\N	2	09105649	190	\N	t	24.84	0.00	0.00	f
3890	5819	AURICULAR CON MICROFONO NGS MSX3PRO			f	t	\N	2	09075819	189	\N	t	7.19	0.00	0.00	f
4666	5866	ARMARIO RACK 19" 15U 600X450			f	t	\N	2	07045866	150	\N	t	202.16	0.00	0.00	f
4667	5877	ROUTER ADSL2+ CONCEPTRONIC + 4 PUERTOS LAN 10			f	t	\N	2	07075877	220	\N	t	46.18	0.00	0.00	f
3938	5895	CAMARA WEB LOGITECH QUICKCAM COMMUNICATE STX			f	t	\N	2	04115895	75	\N	t	39.86	0.00	0.00	f
3942	5899	T.RED USB NETGEAR WG111FS WIRELESS 54Mbps			f	t	\N	2	07015899	94	\N	t	17.52	0.00	0.00	f
3966	5932	TONER IMP. EPSON ACULASER C900 C1900 AMARILLO			f	t	\N	2	08095932	136	\N	t	84.19	0.00	0.00	f
3991	5971	FA. 24V SAMSUNG IMPRESORAS TPV SPR-270			f	t	\N	2	05035971	120	\N	t	49.61	0.00	0.00	f
3993	5976	PEN DRIVE 2 GB TAKE MS MINI USB 2.0			f	t	\N	2	04275976	195	\N	t	16.35	0.00	0.00	f
4677	6018	SENSOR DE MOVIMIENTO RIMAX SECURITY PHONE			f	t	\N	2	13056018	202	\N	t	115.66	0.00	0.00	f
4044	6050	CAJA SEMITORRE ATX SAGITTA PLATA/NEGRA VENTAN			f	t	\N	2	03316050	197	\N	t	57.69	0.00	0.00	f
4046	6053	AURICULAR CON MICROFONO NGS VOX 280 DJ			f	t	\N	2	09076053	189	\N	t	11.05	0.00	0.00	f
4063	6076	PEN DRIVE 1 GB TAKE MS MINI USB 2.0			f	t	\N	2	04276076	195	\N	t	8.64	0.00	0.00	f
4065	6078	CAMARA WEB CONCEPTRONIC CLLCHATCAM			f	t	\N	2	04116078	75	\N	t	13.10	0.00	0.00	f
4119	6146	DESKTOP LOGITECH CORDLESS DELUXE 650 WHITE OE			f	t	\N	2	04076146	71	\N	t	25.11	0.00	0.00	f
4128	6155	ARMARIO RACK 19" 1 CUERPO 6U 600X450			f	t	\N	2	07046155	150	\N	t	128.99	0.00	0.00	f
4377	6204	CARTUCHO LIMPIADOR HP DLT1 C7998A			f	t	\N	2	08036204	101	\N	t	69.55	0.00	0.00	f
4405	6246	KIT DG834GFS ROUTER ADSL NETGEAR + ADAPT WIFI			f	t	\N	2	07016246	94	\N	t	63.16	0.00	0.00	f
4683	6252	KIT NETGEAR ROUTER WNR854T + WIFI CARDBUS WN5			f	t	\N	2	07076252	220	\N	t	175.25	0.00	0.00	f
4422	6271	CART. EPSON D68 D88 DX3800 AMARILLO T061440B0			f	t	\N	2	08076271	133	\N	t	7.96	0.00	0.00	f
4439	6293	MALETIN NGS NAROOMA 12" FEMENINO			f	t	\N	2	09106293	190	\N	t	53.75	0.00	0.00	f
4459	6314	CART. MAXTEC EPSON STYLUS RX420 AMARILLO T554			f	t	\N	2	08066314	132	\N	t	3.83	0.00	0.00	f
4691	6344	ROUTER ADSL2+ CONCEPTRONIC + 4 PTS LAN 100MB 			f	t	\N	2	07076344	220	\N	t	56.14	0.00	0.00	f
4501	6365	CABLE DVI-I 3Mts.M/M  DUAL LINK AK 3721			f	t	\N	2	09016365	106	\N	t	16.06	0.00	0.00	f
4693	6397	TORNILLOS DE CPU ANONIZADOS AZUL 12 mm 10 UNI			f	t	\N	2	09046397	109	\N	t	2.28	0.00	0.00	f
4738	6462	CART. MAXTEC BROTHER LC41 47BK 900BK NEGRO B-			f	t	\N	2	08066462	132	\N	t	4.49	0.00	0.00	f
4760	6499	CART. MAXTEC HP DESKJET 810C 812CC NEGRO C661			f	t	\N	2	08066499	132	\N	t	8.77	0.00	0.00	f
4761	6500	CART. MAXTEC EPSON C42 C425SX C44 NEGRO T036			f	t	\N	2	08066500	132	\N	t	3.18	0.00	0.00	f
4762	6501	CART. MAXTEC EPSON C42 C425SX C44 COLOR T037			f	t	\N	2	08066501	132	\N	t	4.49	0.00	0.00	f
4763	6502	CART. MAXTEC EPSON R240 RX245 RX420 CYAN T055			f	t	\N	2	08066502	132	\N	t	3.83	0.00	0.00	f
4776	6520	PEN DRIVE 4 GB KINGSTON USB 2.0 DATA TRAVELLE			f	t	\N	2	04276520	195	\N	t	31.35	0.00	0.00	f
4782	6531	BACKPLANE 6 HOT SWAP SC5400/5299-E DISCOS SAT			f	t	\N	2	03046531	38	\N	t	165.49	0.00	0.00	f
4807	6583	CART. MAXTEC EPSON D78 DX4000 DX5000 NEGRO T0			f	t	\N	2	08066583	132	\N	t	5.13	0.00	0.00	f
4808	6584	CART. MAXTEC EPSON D78 DX4000 DX5000 CYAN T07			f	t	\N	2	08066584	132	\N	t	5.13	0.00	0.00	f
4831	6614	HD  80 GB SATA2 WESTERN DIGITAL 7200 RPM 2 MB			f	t	\N	2	03166614	54	\N	t	42.99	0.00	0.00	f
4832	6615	MINIPC SHUTTLE SD32G2 775 i945G DDR2 SATA PCI			f	t	\N	2	03026615	31	\N	t	339.54	0.00	0.00	f
4838	6625	DATA SWITCH MANUAL 1X4 KONIG USB  KO 1214			f	t	\N	2	09026625	107	\N	t	13.77	0.00	0.00	f
4839	6629	ARCHIVADOR CD S NGS WALLETS TRENDY LINE 56U			f	t	\N	2	09106629	190	\N	t	11.57	0.00	0.00	f
4845	6648	CART. EPSON MAGENTA CLARO RX770 T559640 13ML			f	t	\N	2	08076648	133	\N	t	11.37	0.00	0.00	f
4861	6667	RATON NGS SWORD OPTICO SCROLL 800 DPI USB			f	t	\N	2	04086667	72	\N	t	24.84	0.00	0.00	f
4889	6722	CART. MAXTEC HP Nº342 PSC1510 COLOR C9361EE H			f	t	\N	2	08066722	132	\N	t	18.99	0.00	0.00	f
4935	6779	CART. MAXTEC BROTHER LC800 MFC 3420 MAGENTA B			f	t	\N	2	08066779	132	\N	t	3.90	0.00	0.00	f
4936	6780	CART. MAXTEC BROTHER LC800 MFC 3420 AMARILLO 			f	t	\N	2	08066780	132	\N	t	3.90	0.00	0.00	f
4970	6863	REGLETA RIELLO THUNDERSTORM 6000 5+1 TOMAS + 			f	t	\N	2	09026863	107	\N	t	13.92	0.00	0.00	f
4985	6900	SOFT. WINDOWS 2003 SERVER R2aSP2 5 CAL OEM 1-			f	t	\N	2	03306900	184	\N	t	654.61	0.00	0.00	f
4994	6914	LATIGUILLO FIBRA OPTICA MTRJ-MTRJ DE 2 MTS RL			f	t	\N	2	07056914	188	\N	t	26.36	0.00	0.00	f
5008	6939	FA. 650W INTEL SERVIDOR APP4650WPSU REDUNT.			f	t	\N	2	03046939	38	\N	t	164.39	0.00	0.00	f
5019	6956	CABLE HD SATA 100 CM BLINDAJE EXTRA KO3080			f	t	\N	2	09016956	106	\N	t	5.14	0.00	0.00	f
5020	6957	LECTOR C.B. METROLOGIC MS-9535BT VOYAGER USB 			f	t	\N	2	05036957	120	\N	t	403.96	0.00	0.00	f
5029	6976	PB INTEL S3000AHLX XEON/C2D 667 DLAN PCIE SAT			f	t	\N	2	03116976	86	\N	t	266.76	0.00	0.00	f
5031	6979	CART. EPSON SP-1200 COLOR T001011			f	t	\N	2	08076979	133	\N	t	30.83	0.00	0.00	f
5037	6994	CART. MAXTEC EPSON 480 580 C20 C40 NEGRO T013			f	t	\N	2	08066994	132	\N	t	3.25	0.00	0.00	f
5045	7013	ARMARIO RACK 19" PCCASE 42U 600X900 SUELO			f	t	\N	2	07047013	150	\N	t	713.84	0.00	0.00	f
5062	7039	SVGA ASUS G-FORCE 8600GT PCIE 256DDR3 DUAL DV			f	t	\N	2	03177039	55	\N	t	120.84	0.00	0.00	f
5078	7063	CABLE USB 5 Mts. M/H (EXTENSION) SB 1250  A/A			f	t	\N	2	09017063	106	\N	t	4.18	0.00	0.00	f
5089	7081	PACK 10 ROLLOS PAPEL TERMICO TICKETS 57X55 34			f	t	\N	2	05037081	120	\N	t	5.67	0.00	0.00	f
5090	7083	CART. EPSON C42 C44 C46 NEGRO (T03614020)			f	t	\N	2	08077083	133	\N	t	16.19	0.00	0.00	f
5100	7095	REPRODUCTOR MP3 CREATIVE ZEN STONE 1GB LIME G			f	t	\N	2	13047095	198	\N	t	37.28	0.00	0.00	f
5106	7107	SVGA  ASUS G-FORCE 7300LE 128/512HM PCIE DDR2			f	t	\N	2	03177107	55	\N	t	39.00	0.00	0.00	f
5144	7154	HD PORTATIL 160 GB SATA WESTERN DIGI 2.5" 540			f	t	\N	2	03277154	194	\N	t	92.96	0.00	0.00	f
5145	7159	HD PORTATIL 120 GB HITACHI 5400RPM 8MB			f	t	\N	2	03277159	194	\N	t	73.82	0.00	0.00	f
5160	7179	UNIDAD TRANSFERENCIA EPSON ACULASER C900 C190			f	t	\N	2	08097179	136	\N	t	282.30	0.00	0.00	f
5162	7181	TONER IMP. CANON EP-87M LBP 2410 MAGENTA			f	t	\N	2	08097181	136	\N	t	95.51	0.00	0.00	f
5169	7190	PACK EPSON PICTUREMATE 100 CART. 4 COL +135HO			f	t	\N	2	08077190	133	\N	t	33.18	0.00	0.00	f
5178	7203	SVGA XPERTVISION G-FORCE 8800GTS PCIE 640DDR3			f	t	\N	2	03177203	55	\N	t	452.29	0.00	0.00	f
5214	7254	BATERIA DE PORTATIL COMPATIB. ACER TRAVELMATE			f	t	\N	2	02047254	58	\N	t	107.41	0.00	0.00	f
5237	7282	TONER IMP. CANON PC-D320/340 NEGRO			f	t	\N	2	08097282	136	\N	t	87.33	0.00	0.00	f
5244	7290	IMP. TICKETS ZEBRA TLP 2844			f	t	\N	2	05037290	120	\N	t	476.54	0.00	0.00	f
5367	7413	CAJA SERVIDOR INTEL SC5299BRP TORRE FA. REDUN			f	t	\N	2	03037413	32	\N	t	348.41	0.00	0.00	f
5368	7414	REPRODUCTOR MP3 CREATIVE ZEN STONE PLUS 2GB A			f	t	\N	2	13047414	198	\N	t	65.23	0.00	0.00	f
3212	3619	SOFT. LICENCIA WINDOWS TERMINAL SERVER CAL			f	t	\N	2	06033619	91	\N	t	113.95	0.00	0.00	f
3280	3921	SOFT. MICROSOFT WORKS SUITE 2005 OEM			f	t	\N	2	06023921	90	\N	t	41.07	0.00	0.00	f
3681	5296	SOFT. OFFICE 2003 PROFESIONAL SP2 OEM			f	t	\N	2	06025296	90	\N	t	326.53	0.00	0.00	f
4212	05	PCI - ACTUALIZACION DISTRIBUCION LINUX			f	f	\N	2	020505	206	\N	\N	40.00	0.00	0.00	f
3297	3950	CART. EPSON R800 ROJO C13T054740			f	t	\N	2	08073950	133	\N	t	14.99	0.00	0.00	f
3420	4413	TONER IMP. EPSON ACULASER CX11 PACK 4 COLORES			f	t	\N	2	08094413	136	\N	t	229.43	0.00	0.00	f
2912	1373	CINTA IMPR. EPSON TM-U210 ERC-38 NEGRO			f	t	\N	2	08051373	103	\N	t	3.24	0.00	0.00	f
4250	2064	CINTA DAT HP 4mm 150M DDS-4 40GB			f	t	\N	2	08032064	101	\N	t	6.33	0.00	0.00	f
2986	2376	ALTAVOCES NGS SYSTEM 1300 4.1			f	t	\N	2	04062376	70	\N	t	58.81	0.00	0.00	f
2948	1764	CABLE P.PARALELO DB25 3mt			f	t	\N	2	09011764	106	\N	t	4.73	0.00	0.00	f
2952	1784	SAI NGS ALERT 650 OFF LINE			f	t	\N	2	04141784	81	\N	t	93.89	0.00	0.00	f
2984	2318	SAI NGS ALERT 850 OFF LINE			f	t	\N	2	04142318	81	\N	t	148.73	0.00	0.00	f
4153	6182	CAJA EXT. CONCEPTRONIC 3.5" SATA/IDE GRABNGO 			f	t	\N	2	04196182	142	\N	t	36.01	0.00	0.00	f
3429	4440	ALTAVOCES NGS SOUNDBAND 150			f	t	\N	2	04064440	70	\N	t	5.73	0.00	0.00	f
3781	5542	TFT 17" BELINEA 1705S1 1280x1024 8ms PLATA NE			f	t	\N	2	04025542	66	\N	t	176.71	0.00	0.00	f
4001	5987	TFT 17" TV LG M1717A-BZ FLATRON 1280x1024 8ms			f	t	\N	2	04025987	66	\N	t	283.12	0.00	0.00	f
3025	2653	ESCANER ORGANIZADOR NGS TARJETAS DE VISITA B.			f	t	\N	2	04052653	69	\N	t	49.02	0.00	0.00	f
3507	4691	RATON NGS FROST RF 5 BOTONES			f	t	\N	2	04084691	72	\N	t	29.00	0.00	0.00	f
3409	4371	RATON NGS MINIMOUSE FLEA USB OPTICAL			f	t	\N	2	04084371	72	\N	t	7.40	0.00	0.00	f
3501	4679	CAMARA WEB LOGITECH QUICKCAM FUSION			f	t	\N	2	04114679	75	\N	t	81.51	0.00	0.00	f
3430	4441	CAMARA WEB NGS SPINCAM 1.3MPIXEL USB			f	t	\N	2	04114441	75	\N	t	29.00	0.00	0.00	f
2879	1168	SWITCH CONCEPTRONIC 8 PTOS. 10/100 C100S8			f	t	\N	2	07021168	95	\N	t	15.82	0.00	0.00	f
3282	3924	ROUTER FIREWALL 4P +SERV. IMPRESORA 1 USB + 1			f	t	\N	2	07023924	95	\N	t	67.86	0.00	0.00	f
3291	3942	CART. HP MAGENTA Nº40 DJ1200 DSJ 230 250C 516			f	t	\N	2	08073942	133	\N	t	29.73	0.00	0.00	f
3487	4647	PACK 8 ROLLOS PAPEL TERMICO TICKETS 80X88X12			f	t	\N	2	05034647	120	\N	t	15.46	0.00	0.00	f
3485	4638	BANDEJA FIJA ARMARIO RACK 600X800 Y 800X800 R			f	t	\N	2	07044638	150	\N	t	28.20	0.00	0.00	f
4260	2798	SOFT. PACK 5 LICENCIAS CAL WINDOWS 2003 SERVE			f	t	\N	2	06052798	152	\N	t	120.77	0.00	0.00	f
3006	2491	FRONTAL NEGRO REGRABADORA LITEON			f	t	\N	2	03222491	128	\N	t	0.12	0.00	0.00	f
4112	6137	VENTILADOR 775 SPIRE QUADROFLOW V SP515S0			f	t	\N	2	03136137	51	\N	t	8.22	0.00	0.00	f
4229	04	HOSTING FUNGESTUR.ORG			f	f	\N	2	020604	207	\N	\N	90.00	0.00	0.00	f
4350	5696	MEMORIA SO DIMM DDR 1 GB 333Mhz KINGSTON ACER			f	t	\N	2	03285696	193	\N	t	145.77	0.00	0.00	f
4358	5842	HD 320 GB ATA SEAGATE 7200 RPM 16MB			f	t	\N	2	03165842	54	\N	t	73.25	0.00	0.00	f
3698	5362	KIT CONVERSION RACK PARA 742 743 4U			f	t	\N	2	03035362	32	\N	t	37.70	0.00	0.00	f
4462	6317	CAJA SERVIDOR INTEL SC5400BRP NEGRO			f	t	\N	2	03036317	32	\N	t	552.42	0.00	0.00	f
4519	6385	CAJA SERVIDOR INTEL SC5299WS TORRE			f	t	\N	2	03036385	32	\N	t	332.10	0.00	0.00	f
3356	4136	FUENTE DE ALI. 420W GC PFC PIV 12CM 20/24 PIN			f	t	\N	2	03104136	48	\N	t	19.58	0.00	0.00	f
3397	4285	VENTILADOR THERMALTAKE SILENT 775			f	t	\N	2	03134285	51	\N	t	26.84	0.00	0.00	f
4307	4651	MEMORIA DIMM DDR2 512 MB 400Mhz SAMSUNG ECC R			f	t	\N	2	03144651	52	\N	t	87.45	0.00	0.00	f
3492	4661	PB INTEL EATONVILLE S775 D915GEV DDR2 SON VGA			f	t	\N	2	03114661	86	\N	t	88.99	0.00	0.00	f
4160	6189	CPU INTEL XEON 2.8GHZ 2MB 800FSB DP S604 ACTI			f	t	\N	2	03126189	50	\N	t	220.88	0.00	0.00	f
3004	2431	HD 200 GB SATA MAXTOR 7200 RPM			f	t	\N	2	03162431	54	\N	t	60.24	0.00	0.00	f
3062	2943	HD 200 GB ATA SEAGATE 7200RPM 8MB			f	t	\N	2	03162943	54	\N	t	69.88	0.00	0.00	f
4066	6080	HD 250 GB ATA MAXTOR 7200 RPM 16MB			f	t	\N	2	03166080	54	\N	t	72.29	0.00	0.00	f
3965	5928	SVGA ATI RADEON 9550 256MB TV DVI RETAIL			f	t	\N	2	03175928	55	\N	t	56.25	0.00	0.00	f
4504	6368	SVGA MATROX PARHELIA 128MB PCI-E DUALDVI TV			f	t	\N	2	03176368	55	\N	t	340.90	0.00	0.00	f
4505	6369	SVGA SAPPHIRE ATI X550 PCIE 128MB 512HM TV DV			f	t	\N	2	03176369	55	\N	t	51.34	0.00	0.00	f
3419	4406	ADAPTADOR CABLE CORRIENTE ATX DE 20 PIN A 24 			f	t	\N	2	03014406	28	\N	t	3.86	0.00	0.00	f
3157	3338	MALETIN MONRAY STREET			f	t	\N	2	09103338	190	\N	t	31.08	0.00	0.00	f
3176	3417	MALETIN MONRAY OXFORD			f	t	\N	2	09103417	190	\N	t	23.29	0.00	0.00	f
3177	3418	MALETIN MONRAY CAMBRIDGE			f	t	\N	2	09103418	190	\N	t	15.51	0.00	0.00	f
3967	5933	TONER IMP. EPSON ACULASER C900 C1900 CYAN BAJ			f	t	\N	2	08095933	136	\N	t	84.46	0.00	0.00	f
4005	5991	PAPEL EPSON COOL PEEL T-SHIRT TRANSFERENCIA T			f	t	\N	2	08105991	137	\N	t	15.29	0.00	0.00	f
3789	5573	MEMORIA SECURE DIGITAL TAKE MS SD 2GB			f	t	\N	2	04275573	195	\N	t	23.04	0.00	0.00	f
3567	4909	PEN DRIVE 1 GB DANE-ELEC USB 2.0 AZUL			f	t	\N	2	04274909	195	\N	t	13.60	0.00	0.00	f
3678	5282	MEMORIA SECURE DIGITAL TAKE MS SD 1 GB			f	t	\N	2	04275282	195	\N	t	10.22	0.00	0.00	f
3388	4266	BOLSA CAMARA MONRAY FALL 300			f	t	\N	2	13034266	199	\N	t	18.70	0.00	0.00	f
3479	4617	BOLSA CAMARA MONRAY ROCK 100			f	t	\N	2	13034617	199	\N	t	6.93	0.00	0.00	f
3480	4618	BOLSA CAMARA MONRAY SHELL D200			f	t	\N	2	13034618	199	\N	t	6.93	0.00	0.00	f
3368	4192	CAMARA FOTOS NGS EAGLEVIEW S3-200 3.0MP			f	t	\N	2	13034192	199	\N	t	67.10	0.00	0.00	f
3387	4265	BOLSA CAMARA MONRAY ROCK 400			f	t	\N	2	13034265	199	\N	t	16.36	0.00	0.00	f
4215	06	MANTENIMIENTO AZUL YATCHS 4 EQUIPOS 			f	f	\N	2	020506	206	\N	\N	120.00	0.00	0.00	f
2850	0791	CABLE USB 1,8 Mts. M/H (EXTENSION SB1200)  A/			f	t	\N	2	09010791	106	\N	t	1.92	0.00	0.00	f
2843	0681	CABLE USB 1,8MT A/B MM   SB 2402			f	t	\N	2	09010681	106	\N	t	0.96	0.00	0.00	f
2823	0412	CABLE VGA 3Mts. M/H (EXTENSION) AK 4223			f	t	\N	2	09010412	106	\N	t	6.18	0.00	0.00	f
2883	1213	BOBINA CABLE UTP RIGIDO CAT.5E 305 MTS KN5015			f	t	\N	2	07051213	188	\N	t	95.59	0.00	0.00	f
2884	1214	BOBINA CABLE FTP RIGIDO CAT.5E 305 MTS			f	t	\N	2	07051214	188	\N	t	121.01	0.00	0.00	f
2950	1778	AURICULAR CON MICRO NGS MS202			f	t	\N	2	09071778	189	\N	t	8.51	0.00	0.00	f
2953	1792	PACK 10 CD-RW VERBATIM 8X-12X 700MB SERL			f	t	\N	2	08021792	100	\N	t	11.52	0.00	0.00	f
4584	2498	SOFT. WINDOWS XP HOME EDITION OEM INGLES			f	t	\N	2	03302498	184	\N	t	83.10	0.00	0.00	f
3058	2867	CINTA DAT HP 4mm 120M DDS-2 8GB C5707A			f	t	\N	2	08032867	101	\N	t	5.40	0.00	0.00	f
3059	2887	TONER IMP. HP LASERJET 2500 1500 MAGENTA C970			f	t	\N	2	08092887	136	\N	t	79.90	0.00	0.00	f
3122	3211	KVM MINI PS2 AUTO CON CABLES 4 CPU S AB7520			f	t	\N	2	09023211	107	\N	t	90.22	0.00	0.00	f
3247	3799	DOBLADOR UTP 10/100 RJ45 CAT.5 1M / 2H FA679			f	t	\N	2	07053799	188	\N	t	7.90	0.00	0.00	f
3275	3907	PUERTO INFRARROJOS EXTERNO USB IR1015			f	t	\N	2	04233907	148	\N	t	23.39	0.00	0.00	f
3277	3909	CART. JT EPSON C70 C80 AMARILLO E84Y			f	t	\N	2	08063909	132	\N	t	7.14	0.00	0.00	f
4604	3959	CAJA THERMALTAKE SOPRANO VB1000BWS NEGRO VENT			f	t	\N	2	03023959	31	\N	t	78.24	0.00	0.00	f
3335	4076	LATIGUILLO UTP CAT.6E DE 2MTS GRIS PL1602			f	t	\N	2	07054076	188	\N	t	3.31	0.00	0.00	f
3349	4109	KVM MINI PS2 AUTO CONCEPT CON CABLES 2CPU CKV			f	t	\N	2	09024109	107	\N	t	20.14	0.00	0.00	f
3367	4191	CAMARA WEB NGS ROBBIE 2.0 300K USB			f	t	\N	2	04114191	75	\N	t	23.18	0.00	0.00	f
3370	4205	ARCHIVADOR CD S NGS WALLETS URBAN LINE 104 U			f	t	\N	2	09104205	190	\N	t	14.47	0.00	0.00	f
3462	4577	CART. HP NEGRO Nº 337 DESKJET 5940 C9364EE			f	t	\N	2	08074577	133	\N	t	16.37	0.00	0.00	f
4623	4611	ADAPTADOR USB A P.PARALELO 1.8 M DB25H			f	t	\N	2	04234611	148	\N	t	18.29	0.00	0.00	f
4624	4614	FA. 500W PFC PIV 12CM 20/24 PIN SA ATX			f	t	\N	2	03104614	48	\N	t	15.06	0.00	0.00	f
3530	4768	TONER IMP. EPSON ACULASER C1100/X11 MAGENTA			f	t	\N	2	08094768	136	\N	t	66.58	0.00	0.00	f
3531	4771	TONER IMP. EPSON ACULASER C1100/X11 NEGRO			f	t	\N	2	08094771	136	\N	t	63.36	0.00	0.00	f
3544	4819	ALTAVOCES LOGITECH R-20 2.1 COLOR NEGRO			f	t	\N	2	04064819	70	\N	t	19.93	0.00	0.00	f
3595	5028	HD 500 GB SATA2 SEAGATE 7200 RPM 16MB			f	t	\N	2	03165028	54	\N	t	102.65	0.00	0.00	f
3597	5030	CART. JT CANON BJC6000 3000 6200 S400 CYAN C2			f	t	\N	2	08065030	132	\N	t	4.22	0.00	0.00	f
3626	5101	CABLE DVI-D 1.8Mts.M/M  DUAL LINK AK3630			f	t	\N	2	09015101	106	\N	t	9.64	0.00	0.00	f
3657	5225	CART. CANON IP4200 5200 MP500 MP800 NEGRO PGI			f	t	\N	2	08075225	133	\N	t	12.59	0.00	0.00	f
3688	5341	MEMORIA DIMM DDR2 1024MB 667MHz KINGSTON CL5			f	t	\N	2	03145341	52	\N	t	23.28	0.00	0.00	f
3690	5344	ALTAVOCES NGS HARDTEC 2.1 SUBWOOFER			f	t	\N	2	04065344	70	\N	t	33.16	0.00	0.00	f
3742	5437	PROMO JET TEC C64 CYAN Y MAGEN +1 NEGRO GRATI			f	t	\N	2	08065437	132	\N	t	13.63	0.00	0.00	f
3743	5438	PACK 10 ROLLOS PAPEL CAJA REG. TERMICO CM-745			f	t	\N	2	08105438	137	\N	t	5.67	0.00	0.00	f
4643	5448	CONTROLADORA SATA ADAPTEC 1210SA RAID OEM			f	t	\N	2	03235448	129	\N	t	62.95	0.00	0.00	f
4644	5450	KIT RACK CAJA SERVIDOR SC5295 APP3RACKIT			f	t	\N	2	03045450	38	\N	t	109.22	0.00	0.00	f
3755	5463	CART. JT HP NEGRO M33 DESKJET 310			f	t	\N	2	08065463	132	\N	t	17.53	0.00	0.00	f
3760	5475	CABLE SERIE (DB-9) 1.8 Mts. H/H 9PIN AK2315			f	t	\N	2	09015475	106	\N	t	2.89	0.00	0.00	f
3787	5566	CART. EPSON C48 COLOR C13T067040LB			f	t	\N	2	08075566	133	\N	t	12.75	0.00	0.00	f
3799	5599	VENTILADOR ADIC. COOLBOX 12x12 CM EC12025M12			f	t	\N	2	03015599	28	\N	t	4.80	0.00	0.00	f
3801	5606	CPU AMD ATHLON 3200+ AM2 1000 2.0Ghz 512KB BO			f	t	\N	2	03125606	50	\N	t	44.51	0.00	0.00	f
3808	5619	SOPORTE PARA UNIDADES DE 3.5" CON FRONTAL NEG			f	t	\N	2	03015619	28	\N	t	4.58	0.00	0.00	f
3843	5683	CABLE DVI-I 5Mts.M/M  DUAL LINK AK3722			f	t	\N	2	09015683	106	\N	t	26.02	0.00	0.00	f
3845	5687	CINTA IMPRESORA EPSON FX-1050 NEGRO #8755			f	t	\N	2	08055687	103	\N	t	6.01	0.00	0.00	f
3850	5697	PACK 10 ROLLOS PAPEL TICKET 76.5 x 65			f	t	\N	2	05035697	120	\N	t	3.66	0.00	0.00	f
4657	5751	UNIDAD FOTOCONDUCTORA Y TONER EPSON EPL-N3000			f	t	\N	2	08095751	136	\N	t	195.34	0.00	0.00	f
4661	5777	HD 400 GB SATA2 SEAGATE 7200 RPM 8MB			f	t	\N	2	03165777	54	\N	t	89.17	0.00	0.00	f
3887	5816	DESKTOP NGS INALAMBRICO SYNERGYSET SLIM USB			f	t	\N	2	04075816	71	\N	t	46.53	0.00	0.00	f
3900	5840	TFT 19"  ACER AL1916WAS PLATA 5ms PANORAMICO			f	t	\N	2	04025840	66	\N	t	179.22	0.00	0.00	f
3911	5854	CAMARA WEB LOGITECH QUICKCAM MESSENGER REFRES			f	t	\N	2	04115854	75	\N	t	24.47	0.00	0.00	f
3932	5888	SWITCH NETGEAR FS608FS 8 PUERTOS 10/100			f	t	\N	2	07025888	95	\N	t	17.52	0.00	0.00	f
3970	5936	REPETIDOR D-LINK DWL-G710 WIRELESS 54Mbps			f	t	\N	2	07015936	94	\N	t	73.63	0.00	0.00	f
3983	5955	CART. HP NEGRO Nº15 (C6615NE)14 ml			f	t	\N	2	08075955	133	\N	t	13.98	0.00	0.00	f
3984	5958	CAJA EXT. CONCEPTRONIC 3.5" IDE GRABNGO USB2.			f	t	\N	2	04195958	142	\N	t	20.31	0.00	0.00	f
4019	6011	PACK 10 CD-R SAMSUNG 52X SLIM CASE ( 700 MB )			f	t	\N	2	08016011	99	\N	t	5.51	0.00	0.00	f
4678	6025	CONTROLADORA INTEL RAID SERIAL ATA SRCS16 6 C			f	t	\N	2	03236025	129	\N	t	314.40	0.00	0.00	f
4680	6055	KIT DG834PN ROUTER ADSL NETGEAR WIFI+ADAP USB			f	t	\N	2	07076055	220	\N	t	128.04	0.00	0.00	f
4060	6073	SVGA XFX G-FORCE 7950GT PCIE 512DDR3 DUAL DVI			f	t	\N	2	03176073	55	\N	t	271.27	0.00	0.00	f
4681	6098	SVGA XFX G-FORCE 8800GTX PCIE 768DDR3 DUAL DV			f	t	\N	2	03176098	55	\N	t	637.04	0.00	0.00	f
4126	6153	CART. CANON IP6600 PHOTO CYAN CLI8PC			f	t	\N	2	08076153	133	\N	t	11.19	0.00	0.00	f
4138	6166	HD 160 GB ATA SEAGATE 7200 RPM 8MB			f	t	\N	2	03166166	54	\N	t	49.98	0.00	0.00	f
4141	6169	ETIQUETAS CD REMOVIBLES 200 UDS. DLW1824			f	t	\N	2	08106169	137	\N	t	9.22	0.00	0.00	f
4379	6216	MEMORIA DIMM DDR2 512MB 667MHz KINGSTON			f	t	\N	2	03146216	52	\N	t	15.10	0.00	0.00	f
4393	6231	CART. MAXTEC EPSON C64 C86 CX3600 CYAN T0442			f	t	\N	2	08066231	132	\N	t	3.83	0.00	0.00	f
4684	6263	SVGA XFX G-FORCE 7600GS PCIE 256DDR2 DUAL DVI			f	t	\N	2	03176263	55	\N	t	145.41	0.00	0.00	f
4685	6279	HD 750 GB ATA SEAGATE 7200 RPM 16MB			f	t	\N	2	03166279	54	\N	t	233.24	0.00	0.00	f
4686	6306	MEMORIA xD PICTURE TYPE M OLYMPUS 1 GB PANORA			f	t	\N	2	04276306	195	\N	t	20.05	0.00	0.00	f
4688	6325	HD 147 GB SAS3 FUJITSU 15000 RPM 16MB AL-9			f	t	\N	2	03166325	54	\N	t	382.10	0.00	0.00	f
4694	6398	TORNILLOS DE CPU ANONIZADOS NEGRO 12 mm 10 UN			f	t	\N	2	09046398	109	\N	t	2.36	0.00	0.00	f
4707	6411	RATON NGS SNAKE OPTICO BLUETOOTH P/ PORTATILE			f	t	\N	2	04086411	72	\N	t	57.34	0.00	0.00	f
4717	6430	TONER IMP. HP LASERJET P2015 NEGRO Q7553X			f	t	\N	2	08096430	136	\N	t	118.69	0.00	0.00	f
4724	6445	TAMBOR BROTHER DR-4000 NEGRO ORIGINAL LASER			f	t	\N	2	08096445	136	\N	t	108.90	0.00	0.00	f
4809	6585	CART. MAXTEC EPSON D78 DX4000 DX5000 MAGENTA 			f	t	\N	2	08066585	132	\N	t	5.13	0.00	0.00	f
4810	6586	CART. MAXTEC EPSON D78 DX4000 DX5000 AMARILL 			f	t	\N	2	08066586	132	\N	t	5.13	0.00	0.00	f
4811	6587	CART. MAXTEC EPSON NEGRO R360/265 RX560 T0801			f	t	\N	2	08066587	132	\N	t	5.13	0.00	0.00	f
4829	6610	MEMORIA MMC-MOBILE KINGSTON 2 GB RS-MMC			f	t	\N	2	04276610	195	\N	t	43.59	0.00	0.00	f
4840	6630	SVGA ASUS RADEON X1300 PCIE 128/512HM DVI TV			f	t	\N	2	03176630	55	\N	t	53.94	0.00	0.00	f
4843	6639	VIDEO VIGILANCIA SIN CABLES RIMAX BABY CAM			f	t	\N	2	13056639	202	\N	t	50.48	0.00	0.00	f
4846	6649	CART. EPSON AMARILLO RX700 T559440 13ML			f	t	\N	2	08076649	133	\N	t	11.34	0.00	0.00	f
4847	6650	CART. EPSON CYAN RX700 T559240 13ML			f	t	\N	2	08076650	133	\N	t	11.34	0.00	0.00	f
4871	6682	RATON CONCEPTRONIC EASYMOUSE WIRELESS USB PS2			f	t	\N	2	04086682	72	\N	t	11.78	0.00	0.00	f
4890	6723	CART. MAXTEC EPSON C48 NEGRO T066			f	t	\N	2	08066723	132	\N	t	3.18	0.00	0.00	f
4891	6724	CART. MAXTEC EPSON C48 COLOR T067			f	t	\N	2	08066724	132	\N	t	4.49	0.00	0.00	f
4893	6726	TONER MAXTEC IMP. HP LASERJET 1300 SERIES H26			f	t	\N	2	08086726	134	\N	t	36.04	0.00	0.00	f
4911	6745	DISPLAY TEMPERATURA GATEWATCH II USB 2.0 LCD			f	t	\N	2	09046745	109	\N	t	44.72	0.00	0.00	f
4923	6762	VENTILADOR TACENS GELUS PRO INTEL Y AMD 9dB 1			f	t	\N	2	03136762	51	\N	t	32.59	0.00	0.00	f
4941	6796	FA. 250W FSP MATX PARA MINIPC FSP250-50GL			f	t	\N	2	03106796	48	\N	t	29.88	0.00	0.00	f
4951	6818	CART. MAXTEC EPSON C70 C80 CX5200 5400 AMARIL			f	t	\N	2	08066818	132	\N	t	3.57	0.00	0.00	f
4963	6843	T.RED PCI D-LINK WIRELESS LAN DWA-547 300MBPS			f	t	\N	2	07016843	94	\N	t	54.10	0.00	0.00	f
4982	6893	SVGA SAPPHIRE RADEON X1650 512MB DDR2 AGP RET			f	t	\N	2	03176893	55	\N	t	104.05	0.00	0.00	f
4991	6911	ROSETA EMBUTIDA RJ45 CAT5E UTP 1 TOMA FE 3100			f	t	\N	2	07056911	188	\N	t	5.95	0.00	0.00	f
4997	6920	CHASIS ENLIGHT TPV TACTIL 15" LP751 NEGRO MIC			f	t	\N	2	05036920	120	\N	t	554.22	0.00	0.00	f
4998	6921	ORDENADOR TPV TACTIL 15" POS465 CM1.2 256MB 4			f	t	\N	2	05036921	120	\N	t	1054.22	0.00	0.00	f
4999	6922	LECTOR DE TARJETAS MAGNETICAS PARA POS465			f	t	\N	2	05036922	120	\N	t	96.39	0.00	0.00	f
5009	6941	ALTAVOCES NGS GLACIER 2.1 PARA PORTATILES Y M			f	t	\N	2	04066941	70	\N	t	24.84	0.00	0.00	f
5017	6952	REPRODUCTOR MP4 RIMAX GLOOMY 4GB MP4 LCD 2.4"			f	t	\N	2	13046952	198	\N	t	98.31	0.00	0.00	f
5021	6965	SVGA SAPPHIRE RADEON X1550 256MB DDR2 PCIE RE			f	t	\N	2	03176965	55	\N	t	40.13	0.00	0.00	f
5026	6971	CABLE ALIMENTACION INTERNO MOLEX PCIE 6PIN AK			f	t	\N	2	03016971	28	\N	t	4.22	0.00	0.00	f
5050	7022	UNIDAD FOTOCONDUCTORA EPSON EPL6200			f	t	\N	2	08097022	136	\N	t	82.08	0.00	0.00	f
5055	7027	HD 500 GB ATA WESTERN DIGITAL 7200 RPM 8MB			f	t	\N	2	03167027	54	\N	t	123.70	0.00	0.00	f
5067	7045	CART. MAXTEC EPSON PHOTO 950 NEGRO T0331			f	t	\N	2	08067045	132	\N	t	0.00	0.00	0.00	f
5120	7124	CART. MAXTEC EPSON C62 CX3200 TRICOLOR T041			f	t	\N	2	08067124	132	\N	t	4.49	0.00	0.00	f
5124	7129	LATIGUILLO UTP CAT.5E DE 5 MTS MARFIL LA1005			f	t	\N	2	07057129	188	\N	t	2.48	0.00	0.00	f
5130	7137	FA. 550W FSP SERVIDOR 550-80GLC 8CM EPS12V			f	t	\N	2	03047137	38	\N	t	101.52	0.00	0.00	f
5137	7146	HD 160 GB SATA2 SAMSUNG 7200 RPM HD160HJ 8MB			f	t	\N	2	03167146	54	\N	t	53.64	0.00	0.00	f
5139	7149	LATIGUILLO FIBRA OPTICA MTRJ-VF45 DE 2 MTS			f	t	\N	2	07057149	188	\N	t	52.64	0.00	0.00	f
5156	7175	MINIPC SHUTTLE SD30G2 775 i945GC DDR2 SATA2 P			f	t	\N	2	03027175	31	\N	t	268.42	0.00	0.00	f
5157	7176	CAJA EXT. ICY BOX 2.5" SATA USB 2.0 IB-220STU			f	t	\N	2	04237176	148	\N	t	18.88	0.00	0.00	f
5172	7193	CABLE VGA M/H 1.8M (EXT) AK4220 DOBLE APANTAL			f	t	\N	2	09017193	106	\N	t	4.01	0.00	0.00	f
5174	7195	PORT. XTREM M1221 T7250 1GB 120GB DVD-RW 12.1			f	t	\N	2	02057195	206	\N	t	824.66	0.00	0.00	f
5185	7213	PORT. SAMSUNG R60+ T7300 2GB 160GB DVD-RW 15.			f	t	\N	2	02997213	204	\N	t	879.01	0.00	0.00	f
5186	7216	TONER IMP. OKI C4350 NEGRO 1103402			f	t	\N	2	08097216	136	\N	t	36.00	0.00	0.00	f
5187	7218	TECLADO NGS IN VOGUE 16 TECLAS MULTIMEDIA USB			f	t	\N	2	04077218	71	\N	t	11.73	0.00	0.00	f
5188	7219	TECLADO NGS CLASSY 12 TECLAS MULTIMEDIA USB			f	t	\N	2	04077219	71	\N	t	10.72	0.00	0.00	f
5223	7266	DISQUETERA NEC 3,5"			f	t	\N	2	03157266	53	\N	t	5.41	0.00	0.00	f
5226	7270	RATON NGS EVO PRO V2 OPTICAL USB			f	t	\N	2	04087270	72	\N	t	8.23	0.00	0.00	f
5231	7275	ADAPTADOR CONCEPTRONIC INT. IDE A SATA CSATAC			f	t	\N	2	03017275	28	\N	t	15.88	0.00	0.00	f
5232	7276	HD PORTATIL 160 GB TOSHIBA SATA 5400RPM 8MB			f	t	\N	2	03277276	194	\N	t	98.23	0.00	0.00	f
5303	7349	CINTA AIT 3 SONY 100/260 GB 230M			f	t	\N	2	08037349	101	\N	t	56.33	0.00	0.00	f
5350	7396	HD EXT. 400GB TOSHIBA USB 2.0 16MB			f	t	\N	2	04197396	142	\N	t	103.73	0.00	0.00	f
5351	7397	HD 750GB SATA2 WESTERN DIGITAL 7200 RPM 16 MB			f	t	\N	2	03167397	54	\N	t	208.66	0.00	0.00	f
5352	7398	KIT PROTECCION PARA HP IPAQ H3800/3900/5100..			f	t	\N	2	13027398	201	\N	t	12.89	0.00	0.00	f
5378	7425	PB GIGABYTE GA-X38-DQ6 S775 1600 PCIE DDR2 SA			f	t	\N	2	03117425	86	\N	t	242.89	0.00	0.00	f
5384	7433	PORT. SONY VAIO VGNFZ29VN T7250 15.4" 2GB 160			f	t	\N	2	02997433	204	\N	t	1139.11	0.00	0.00	f
\.


--
-- Data for Name: ausencia; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY ausencia (idausencia, idtrabajador, fechainausencia, fechafinausencia, motivoausencia) FROM stdin;
5	8	2006-01-01	2006-12-31	Año Sabatico
4	2	2007-04-03	2007-04-10	Vacaciones
2	1	2007-01-01	2007-01-31	Tengo un moco
\.


--
-- Data for Name: banco; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY banco (idbanco, nombanco, dirbanco, poblbanco, cpbanco, telbanco, faxbanco, emailbanco, contactobanco, codentidadbanco, codagenciabanco, numcuentabanco, dcbanco, comentbanco, webbanco, idcuentabanco) FROM stdin;
1	La Caixa	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	971 29 06 29		info@iglues.org	Asociacion Iglues				44	Banco Principal	www.lacaixa.es	10936
2	Caja	Joaquin Turina, 1 Local 4			971 29 06 29		info@iglues.org	Asociacion Iglues							10937
3	Caja Bis	Joaquin Turina, 1 Local 4			971 29 06 29		info@iglues.org	Asociacion Iglues							10938
\.


--
-- Data for Name: cliente; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY cliente (idcliente, nomcliente, nomaltcliente, cifcliente, dircliente, poblcliente, cpcliente, telcliente, faxcliente, mailcliente, urlcliente, faltacliente, fbajacliente, comentcliente, inactivocliente, idtarifa, codcliente, corpcliente, teltrabcliente, movilcliente, recargoeqcliente, idforma_pago, regimenfiscalcliente, bancocliente, idprovincia, comentcomercialcliente, idzonacomercial, periodocomercialcliente, fechabasecomercialcliente, horarutacomercialcliente, idcuentacliente) FROM stdin;
114	Alatielia Management	Alatielia Management	114	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Alatielia Management	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10822
127	LLABRES FELIU	LLABRES FELIU	127	Joaquin Turina, 1 Local 4	PALMA DE MALLORCA	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	LLABRES FELIU	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10808
130	Ajuntament de Pollensa	Ajuntament de Pollensa	130	Joaquin Turina, 1 Local 4	Pollensa	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Ajuntament de Pollensa	971 29 06 29	667 776 767	f	2	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10805
133	Click Fortun	Click Fortun	133	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Click Fortun	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	5	\N	\N	7 days	2007-09-15	08:00:00	10888
140	Logística Urbana Ambiental S.A.	Urbient	140	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Logística Urbana Ambiental S.A.	971 29 06 29	667 776 767	t	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10886
8	Viajes Majorica	Viajes Majorica	8	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10807
9	AFIBE Asesoria Integral de Empresas S.L.	\N	9	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10869
10	Aiguas de Lluc, S.A.	Aiguas de Lluc, S.A.	10	Joaquin Turina, 1 Local 4	Palma	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10806
12	Viajes Kontiki	\N	12	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10871
13	Hidropolis Balneario Urbano	\N	13	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10878
14	Bartolome Borras Riera	\N	14	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10844
16	El Corte Inglés	\N	16	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10858
21	Detectives Cabanach	\N	21	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10837
22	Celestino Prieto	\N	22	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10801
24	Estructuras Metalicas Cañellas	\N	24	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10857
26	TecnoDraw	TecnoDraw	26	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	TecnoDraw	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10881
29	Taulons a Punt	\N	29	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10874
30	Piema	\N	30	Joaquin Turina, 1 Local 4	 \tPalma	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10875
32	Steel Pool	\N	32	Joaquin Turina, 1 Local 4	Can Domenge Centre Tecnoloic	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10852
31	Ambigest Salud Ambiental	\N	31	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10876
33	Pizzeria - Restaurante Can Pelut	\N	33	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10826
36	BiniComprat	\N	36	Joaquin Turina, 1 Local 4	\N	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10813
38	Aceites Biniatzent	\N	38	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10827
40	Cliente de Contado	----	40	Joaquin Turina, 1 Local 4	Localidad	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10818
41	J.M.C. Representaciones Siglo XXI	J.M.C. Representaciones Siglo XXI 	41	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	J.M.C. Representaciones Siglo XXI 	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10868
42	Bar La Mar	\N	42	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10833
44	Todo Redes	\N	44	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10882
46	Jupiter Luminosos	\N	46	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10809
49	Rotulos en General	\N	49	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10851
51	Sociedad General de Autistas y Elitistas	\N	51	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10831
54	Proyeccion y Sonido Proson	Proyeccion y Sonido Proson	54	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N	\N	\N	\N	\N	Proyeccion y Sonido Proson	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10863
57	Progreso Traducciones	\N	57	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10870
59	ESTOP. Topografia y Mediciones	ESTOP. Topografia y Mediciones	59	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N	\N	\N	\N	\N	ESTOP. Topografia y Mediciones	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10883
62	Soluciones Tecnologicas 10DE10	\N	62	Joaquin Turina, 1 Local 4	 \tValencia	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10825
67	Aceites Ripoll s.l.	\N	67	Joaquin Turina, 1 Local 4	Caimari - Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-07-04	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10824
76	Mallorquina de Estanterias	\N	76	Joaquin Turina, 1 Local 4	SINEU	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-08-30	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10811
78	Apoteke Bar	Apoteke Bar	78	Joaquin Turina, 1 Local 4	Puerto de Alcudia	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-10-31	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10839
85	CARPINTERIA DE ALUMINIO GORG BLAU 	CARPINTERIA DE ALUMINIO GORG BLAU 	85	Joaquin Turina, 1 Local 4	INCA	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-01-18	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10830
86	JUNCOSA. Muebles Cocinas y Alfombras	JUNCOSA. Muebles Cocinas y Alfombras	86	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-01-18	\N	\N	\N	\N	\N	JUNCOSA. Muebles Cocinas y Alfombras	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10846
88	Marmolería Fullana	Marmolería Fullana	88	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-02-07	\N	\N	\N	\N	\N	Marmolería Fullana	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10849
94	Miquel Serra Arbol	Miquel Serra Arbol	94	Joaquin Turina, 1 Local 4	Calvia	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-05-03	\N	\N	\N	\N	\N	Miquel Serra Arbol	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10845
95	Margarita Indexiada	Margarita Indexiada	95	Joaquin Turina, 1 Local 4	INCA	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-05-15	\N	\N	\N	\N	\N	Margarita Indexiada	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10855
98	Náutica Ripollsegar	Náutica Ripollsegar	98	Joaquin Turina, 1 Local 4	Ibiza	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Náutica Ripollsegar	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10864
101	AUTOSERVICIO HOYGAN	AUTOSERVICIO HOYGAN	101	Joaquin Turina, 1 Local 4	SANTA PONÇA	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-09-06	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10859
106	NautiSur	NautiSur	106	Joaquin Turina, 1 Local 4	Madrid	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-10-09	\N	\N	\N	\N	\N	NautiSur	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10798
108	Universitat de les Illes	UIB	108	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-11-13	\N	\N	\N	\N	\N	Universitat de les Illes	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10802
115	Comercial Video Games Electronic	Comercial Video Games Electronic	115	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Comercial Video Games Electronic	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10856
2	Carlos Santana	\N	2	Joaquin Turina, 1 Local 4	Campos	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-21	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10898
123	ELECTROSAT S.L.	ELECTROSAT	123	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	ELECTROSAT	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10815
75	Prevefoc Insular S.L.		75	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-08-18	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10799
65	Transportes A. Bibiloni S.L.		65	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10823
116	Salvador Ribas Maura	G-RibasAzcona	116	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	G-RibasAzcona	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10796
1	Jorge Gutierrez	Jorge	1	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-21	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10797
20	Centro de Negocios Avenidas		20	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10800
43	La Agencia Q, S.L.		43	Joaquin Turina, 1 Local 4	 \tMallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10803
93	IGLUES	IGLUES	93	Joaquin Turina, 1 Local 4	PALMA DE MALLORCA	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-04-24	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10804
131	APA Colegio Madre Alberta	APA Colegio Madre Alberta	131	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	APA Colegio Madre Alberta	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	5	\N	\N	7 days	2007-09-15	08:00:00	10890
39	Isabel - Marina Estrella		39	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10810
35	Hewlett-Packard International SARL		35	Joaquin Turina, 1 Local 4	 \tLas Rozas	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10812
37	ICentre		37	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10814
100	Centre Profesional de Formacio Publica, s.l	Centre Profesional de Formacio Publica, s.l	100	Joaquin Turina, 1 Local 4	Inca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Centre Profesional de Formacio Publica, s.l	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10816
47	Mercurio Network S.L.		47	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10817
56	Radical Boats		56	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10819
103	Gerencia Inmobiliaria Balear	GIB	103	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-09-26	\N		\N	\N	\N	Gerencia Inmobiliaria Balear	971 29 06 29	667 776 767	f	4	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10820
60	SISTEMES I SEGURETAT COSTA BRAVA S.L.		60	Joaquin Turina, 1 Local 4	 \tRoses	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10821
58	Raggi Damp S.L.		58	Joaquin Turina, 1 Local 4	Palmañola - Buñola	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10828
45	Mancomunitat des Raiguer		45	Joaquin Turina, 1 Local 4	 \tBinissalem	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10829
55	QAMAR Palma, S.L.		55	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10832
53	Pedro Molinera Ordoñez		53	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10834
73	Jose Vallejo Gonzalez		73	Joaquin Turina, 1 Local 4	S'Arenal	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-08-11	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10835
66	TransUnion Mallorca		66	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10836
77	Juana Oliver Estilistas	Juana Oliver Estilistas	77	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-10-07	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10838
61	SKY Helicopteros		61	Joaquin Turina, 1 Local 4	Pont D'Inca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10840
17	Caladrogue		17	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10841
83	Alex Fuentes - IB3		83	Joaquin Turina, 1 Local 4		07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-01-12	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10842
84	ADMAS BALEARES S.L.	Tiendas MasIntimo	84	Joaquin Turina, 1 Local 4	Palma De Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-01-16	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10843
34	Gestion Plus Balear S.L.		34	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10847
63	SPAZZOLA, S.L.		63	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10848
87	Miguel Angel Abraham Oliver		87	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-01-23	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10850
92	Productos Ecológicos del Automóvil S.L.	Productos Ecológicos del Automóvil	92	Joaquin Turina, 1 Local 4		07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-02-22	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10853
107	Vinissimus S.L.	Vinisimus	107	Joaquin Turina, 1 Local 4	Barcelona	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Vinisimus	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10854
119	Xinaris Construcción S.L.	Xinaris	119	Joaquin Turina, 1 Local 4	Sta, María de la Salud	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Xinaris Construcción S.L.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10860
96	Línea Turística SL	\N	96	Joaquin Turina, 1 Local 4	Pollença	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-05-19	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10861
27	Easy Sail S.L.	\N	27	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10862
50	P.C.I. Procesos Comerciales Insulares S.L.	\N	50	Joaquin Turina, 1 Local 4	 \tPalma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10865
99	Ibiza Sea Charter, S.L.	Ibiza Sea Charter, S.L.	99	Joaquin Turina, 1 Local 4	Ibiza 	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Ibiza Sea Charter, S.L.	971 29 06 29	667 776 767	f	6	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10866
23	Construcciones Metálicas PYLSA, S.L.	Pedro y Lopez	23	Joaquin Turina, 1 Local 4	Churriana de la Vega	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10867
25	Corporación Ingemar, S.A.	\N	25	Joaquin Turina, 1 Local 4	San Sebastián	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10872
3	Dolores Martínez	\N	3	Joaquin Turina, 1 Local 4	Muro	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-21	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10873
91	Federación Balear de Tiro Olímpico	Federación Balear de Tiro Olímpico	91	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-02-22	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10877
28	Eugenio Fco. Navarro Leiva	Eugenio Fco. Navarro Leiva	28	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	Eugenio Fco. Navarro Leiva	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10879
19	Centro Balear Inmobiliario	\N	19	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10880
81	AIGUA CORRENT SL	AIGUA CORRENT SL	81	Joaquin Turina, 1 Local 4	Alaro	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-01-09	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10884
97	Ecologing	Ecologing	97	Joaquin Turina, 1 Local 4	Manacor	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-07-19	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10885
143	\N	\N	143	Joaquin Turina, 1 Local 4	\N	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2007-09-15	\N		\N	\N	asdf	asdf	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10885
135	Zaibatsu S.L.	Zaibatsu S.L.	135	Joaquin Turina, 1 Local 4	Bilbao	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Zaibatsu S.L.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10887
132	Patronat Municipal de Turisme Pollença	Patronat Municipal Turisme Pollença	132	Joaquin Turina, 1 Local 4	Pollença	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Patronat Municipal Turisme Pollença	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	5	\N	\N	7 days	2007-09-15	08:00:00	10889
129	Olah Cooking Group. S.L.	Laurus Restaurant	129	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Olah Cooking Group. S.L.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10891
128	SEYMA IMPORTACIO S.L.	SEYMA IMPORTACIO S.L.	128	Joaquin Turina, 1 Local 4	Petra	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	SEYMA IMPORTACIO S.L.	971 29 06 29	667 776 767	f	2	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10892
102	ANTONI MATEU ESTRANY	\N	102	Joaquin Turina, 1 Local 4	PALMA DE MALLORCA	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10893
121	COFRAME	\N	121	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Cooperativa de Transportes de Mercanc'ias	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10894
64	TOYTO 2003, S.L.		64	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-30	\N		\N	\N	\N	\N	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10897
105	Daniel Rebollo	Colegio Luis Vives	105	Joaquin Turina, 1 Local 4	\N	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2006-10-02	\N		\N	\N	\N	Colegio Luis Vives	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10899
126	DISGLOBAL GAMES S.L.L.	DISGLOBAL GAMES	126	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	ACOMAN	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10900
125	Calzados Ballester. S.A.	Calzados Ballester. S.A.	125	Joaquin Turina, 1 Local 4	\N	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Calzados Ballester. S.A.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10901
122	SPORT INCA S.A.	SPORT INCA	122	Joaquin Turina, 1 Local 4	INCA	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	SPORT INCA S.A.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10903
137	Jose Luis Tejada	Jose Luis tejada Luna	137	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Jose Luis tejada Luna	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	5	\N	\N	7 days	2007-09-15	08:00:00	10904
136	Anima Events S.L.	Anima Events S.L.	136	Joaquin Turina, 1 Local 4	Cala Estancia, Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Anima Events S.L.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	5	\N	\N	7 days	2007-09-15	08:00:00	10908
120	Don Reloj S.A.	Don Reloj S.A.	120	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Don Reloj S.A.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10896
124	Escola Turistica Balear	Escola Turistica Balear	124	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	Escola Turistica Balear	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10902
138	A. Aumaris S.L.	A. Aumaris S.L.	138	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	\N	A. Aumaris S.L.	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10907
139	Luis Fraile Romero	Luis Fraile Romero	139	Joaquin Turina, 1 Local 4	Palma de Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N	\N	\N	\N	0001	Luis Fraile Romero	971 29 06 29	667 776 767	f	1	Normal	                                                                                                                        	1	\N	\N	7 days	2007-09-15	08:00:00	10905
109	Miguel Serra Arquitectura S.L.U.	Miguel Serra Arquitectura S.L.U.	109	Joaquin Turina, 1 Local 4	Pto. de Alcudia	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	\N	\N		\N	\N	\N	Miguel Serra Arquitectura S.L.U.	971 29 06 29	667 776 767	\N	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10895
18	Balear Card	\N	18	Joaquin Turina, 1 Local 4	 \tInca - Mallorca	07004	902 88 11 66		info@iglues.org	http://www.iglues.org	2005-06-29	\N	\N	\N	\N	\N	\N	971 29 06 29	667 776 767	f	\N	Normal	                                                                                                                        	\N	\N	\N	7 days	2007-09-15	08:00:00	10906
\.


--
-- Data for Name: cobro; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY cobro (idcobro, idcliente, fechacobro, cantcobro, refcobro, previsioncobro, comentcobro, idtrabajador, idbanco, fechavenccobro, idq19, idasientocobro) FROM stdin;
74	23	2007-01-17	4135.40	VBDXNN	f	IMPRESORA	\N	\N	\N	\N	1007
75	91	2007-01-15	1908.86	GQGKTW	f	BROTHER	\N	\N	\N	\N	1008
77	10	2007-02-05	2796.06	OARTCQ	f	MAT	\N	\N	\N	\N	1009
79	26	2007-02-05	1402.08	KPPHUK	f	MAT	\N	\N	\N	\N	1010
80	57	2007-02-05	971.15	SLRASN	f	MANT	\N	\N	\N	\N	1011
81	50	2007-02-05	213.44	BPRRQJ	f	MANT	\N	\N	\N	\N	1012
82	26	2007-02-05	1760.88	XLTDFR	f	MANT	\N	\N	\N	\N	1013
83	91	2007-01-15	1908.86	GQGKTW	f	BROTHER	\N	\N	\N	\N	1014
84	8	2007-02-12	6898.53	RKSCOE	f	MAT	\N	\N	\N	\N	1015
85	8	2007-02-12	1067.20	YKQTLE	f	MAT	\N	\N	\N	\N	1016
87	120	2007-01-31	143.75	XWEVQD	f	MAT	\N	\N	\N	\N	1017
89	106	2006-10-27	2925.60	FJFSVG	f	WEB	\N	\N	\N	\N	1018
90	106	2007-02-22	8774.04	FJFSVG	f	WEB	\N	\N	\N	\N	1019
86	91	2007-01-29	173.60	YZOBMY	f	TINTAS	\N	\N	\N	\N	1020
91	91	2007-02-23	1322.68	LDBTEN	f	MAT	\N	\N	\N	\N	1021
92	91	2007-02-23	2524.80	TJEQQB	f	ORDENADOR	\N	\N	\N	\N	1022
93	91	2007-02-23	334.28	PTHRMX	f	EPSON	\N	\N	\N	\N	1023
94	103	2007-02-27	2320.29	KBUUFV	f	MAT	\N	\N	\N	\N	1024
95	103	2007-02-27	6147.07	R[WFFL	f	MANT	\N	\N	\N	\N	1025
96	103	2007-02-27	3073.54	MGKWYW	f	MANT	\N	\N	\N	\N	1026
97	122	2007-03-05	874.87	XSZHYS	f	IMPRESORA	\N	\N	\N	\N	1027
98	91	2007-03-06	221.12	RFMSHL	f	TINTAS	\N	\N	\N	\N	1028
99	49	2007-03-01	240.12	XMTMXG	f	HOST	\N	\N	\N	\N	1029
100	123	2007-03-08	48.90	JIZCRY	f	tinta	\N	\N	\N	\N	1030
101	10	2007-02-28	2103.12	[MJXDT	f	TFT + SOFT 1	\N	\N	\N	\N	1031
102	10	2007-02-28	1758.81	WKNSLS	f	TFT + SOTF 2	\N	\N	\N	\N	1032
103	10	2007-02-28	2420.52	BHMMAZ	f	ORDENADOR 1	\N	\N	\N	\N	1033
104	10	2007-02-28	2420.52	BWRKUG	f	ORDENADOR 2	\N	\N	\N	\N	1034
105	26	2007-02-28	1760.88	MFROGY	f	MANT	\N	\N	\N	\N	1035
106	16	2007-02-28	960.48	SWELET	f	VARIOS	\N	\N	\N	\N	1036
107	10	2007-02-28	1595.37	LVVDTM	f	MAT	\N	\N	\N	\N	1037
108	10	2007-02-28	2637.36	XOYIET	f	MAT	\N	\N	\N	\N	1038
109	13	2007-02-28	1096.09	HCIVYT	f	MANT	\N	\N	\N	\N	1039
110	57	2007-02-28	971.15	XHKBSU	f	MANT	\N	\N	\N	\N	1040
112	97	2007-03-20	426.88	GFUNYR	f	MANT	\N	\N	\N	\N	1041
113	97	2007-03-20	426.88	GITZDY	f	MANT	\N	\N	\N	\N	1042
114	108	2007-03-29	369.79	VVSOHG	f	CABLES	\N	\N	\N	\N	1043
115	85	2007-03-28	160.08	SKAKPN	f	MANT	\N	\N	\N	\N	1044
116	85	2007-03-29	160.08	IQSXKB	f	MANT	\N	\N	\N	\N	1045
117	85	2007-03-29	160.08	SIWRWI	f	MANT	\N	\N	\N	\N	1046
118	59	2007-03-29	1493.85	VDRMHJ2	f	IMPRESORAS	\N	\N	\N	\N	1047
119	59	2007-03-29	2673.11	QENLSH1	f	IMPRESORAS	\N	\N	\N	\N	1048
120	59	2007-03-29	1493.85	QENLSH	f	IMPRESORAS	\N	\N	\N	\N	1049
121	49	2007-03-29	240.12	KZGVJG	f	HOST	\N	\N	\N	\N	1050
123	13	2007-03-29	640.32	RJGEKI	f	MANT	\N	\N	\N	\N	1051
125	16	2007-03-29	400.20	WVYAUN	f	HOST	\N	\N	\N	\N	1052
126	88	2007-03-29	640.32	PVEZPK	f	HOST	\N	\N	\N	\N	1053
127	10	2007-03-29	1811.34	SGPNZS	f	MAT	\N	\N	\N	\N	1054
128	10	2007-03-29	1008.50	ECEHFZ	f	MAT	\N	\N	\N	\N	1055
129	10	2007-03-29	1947.41	HJKUGG	f	MAT	\N	\N	\N	\N	1056
130	41	2007-03-29	480.24	ZCPBFD	f	HOST	\N	\N	\N	\N	1057
131	57	2007-03-29	1727.85	DQCDPV	f	MANT	\N	\N	\N	\N	1058
132	98	2007-03-29	480.24	FTLK[Q	f	HOST	\N	\N	\N	\N	1059
134	50	2007-03-29	213.44	CMNXZZ	f	MANT	\N	\N	\N	\N	1060
135	26	2007-03-29	1760.88	ESWOMB	f	MANT	\N	\N	\N	\N	1061
136	93	2007-04-02	976.81	QYIBYU	f	TPV	\N	\N	\N	\N	1062
137	93	2007-04-03	1449.78	XQBOOR	f	IMRESORA	\N	\N	\N	\N	1063
138	93	2007-04-03	10672.00	[VYFS[	f	PROGRAMACION	\N	\N	\N	\N	1064
139	125	2007-03-30	156.40	YQPCIE	f	CABLE SATA/IDE	\N	\N	\N	\N	1065
140	108	2007-05-01	156.31	IVXVYD	f	CABLE	\N	\N	\N	\N	1066
141	54	2007-05-03	2241.12	CLL[ZS	f	PORTATIL	\N	\N	\N	\N	1067
142	128	2007-04-27	6349.84	CNJXJO	f	ABACCINO	\N	\N	\N	\N	1068
143	131	2007-04-26	368.00	QBVUMK	f	APA MADRE ALBERTA	\N	1	\N	\N	1069
144	108	2007-04-24	15105.99	MYVGGU	f	CABLES SEGURIDAD	\N	1	\N	\N	1070
145	131	2007-04-20	2300.00	QBVUMK	f	APA MADRE ALBERTA	\N	1	\N	\N	1071
146	103	2007-05-02	1672.10	PNWNYA	f	MAT	\N	1	\N	\N	1072
147	103	2007-05-02	3073.54	KBJKOH	f	MANT	\N	1	\N	\N	1073
148	26	2007-04-30	2027.68	OIWXYB	f	MANT	\N	1	\N	\N	1074
149	10	2007-04-30	1932.69	NUYUXO	f	MAT	\N	1	\N	\N	1075
150	57	2007-04-30	971.15	YTWDIY	f	MANT	\N	1	\N	\N	1076
151	50	2007-04-30	213.44	UAWJDP	f	MANT	\N	1	\N	\N	1077
152	132	2007-05-03	1920.96	INLXZA	f	HOST	\N	1	\N	\N	1078
153	10	2007-03-31	2587.96	COAQPM	f	ORDENADOR	\N	1	\N	\N	1079
154	10	2007-03-31	968.35	ZRDELL	f	TONERS	\N	1	\N	\N	1080
155	10	2007-03-30	747.04	AXDFEF	f	HORAS JAUME I CATI	\N	1	\N	\N	1081
156	10	2007-03-17	860.71	WHRNDO	f	MAT CATI i JAMUE	\N	1	\N	\N	1082
157	16	2007-03-29	400.20	WVYAUN	f	HOST	\N	1	\N	\N	1083
158	99	2007-03-17	160.08	HGOYZQ	f	HOST	\N	1	\N	\N	1084
88	97	2007-02-19	1188.87	YIKBD[	f	MANT	\N	\N	\N	\N	1085
159	99	2007-03-29	480.24	JXKSHV	f	HOST	\N	1	\N	\N	1086
133	98	2007-03-29	480.24	JXKSHV	f	HOST	\N	\N	\N	\N	1087
160	44	2007-05-09	160.08	CJIKTG	f	HOST	\N	1	\N	\N	1088
161	23	2007-05-11	290.44	UNIIYN	f	LIMPIEZA	\N	2	\N	\N	1089
162	23	2007-05-11	501.58	LRMBBX	f	ACCESORIOS	\N	2	\N	\N	1090
163	40	2007-05-11	186.81	KQTYYO	f	TALLER	\N	3	\N	\N	1091
164	91	2007-04-12	234.19	EFEGZF	f	TINTAS	\N	2	\N	\N	1092
165	26	2007-05-11	2331.51	GWCFSO	f	TINTAS	\N	1	\N	\N	1093
166	41	2007-05-11	160.08	DOOEWQ	f	RENOVACION .COM	\N	1	\N	\N	1094
167	135	2007-05-11	640.32	KUHKXO	f	MANT BGES	\N	1	\N	\N	1095
180	94	2007-08-14	6900.00	TYZ[VR	f	asdfasdf	\N	\N	2007-08-31	\N	1096
111	115	2007-03-14	4652.99	LQIDBZ	f	EQUIPOS	\N	\N	\N	\N	1097
169	28	2007-05-24	465.75	HGMRII	f	TONER	\N	2	\N	\N	1098
173	85	2007-05-24	160.08	EIY[ED	f	MANT	\N	1	\N	\N	1099
168	108	2007-05-19	1109.34	NGIXEL	f	CABLES	\N	1	\N	\N	1100
175	13	2007-05-07	640.32	FGTPBN	f	MANT	\N	1	\N	2	1101
177	24	2007-05-28	920.00	KNMZWF	f	IMPRESORA	\N	2	2007-08-11	2	1102
172	85	2007-05-24	160.08	IFREQT	f	MANT	\N	1	\N	2	1103
170	97	2007-05-24	426.88	XWZFGT	f	MANT	\N	1	\N	2	1104
171	97	2007-05-24	426.88	VYBAMY	f	MANT	\N	1	\N	2	1105
176	93	2007-05-25	8004.00	NNZNUN	f	PROGRAMACION	\N	1	\N	2	1106
174	85	2007-05-24	226.96	SZYMUR	f	MANT	\N	1	\N	2	1107
78	106	2007-02-05	1467.40	YCIHXH	f	MANT	\N	\N	\N	\N	1108
\.


--
-- Data for Name: codigobarras; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY codigobarras (idcodigobarras, idarticulo, ean14codigobarras, unixcajacodigobarras, cajxpaletcodigobarras, unidadcodigobarras) FROM stdin;
\.


--
-- Data for Name: comentario_evento; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY comentario_evento (idcomentario_evento, idevento, idtrabajador, fechacomentario_evento, textcomentario_evento) FROM stdin;
2	3	2	2007-01-01 00:00:00	Este es el primero asd
3	3	2	2007-01-02 00:00:00	Segundo comentario
4	4	2	2007-01-01 00:00:00	Este es un comentario xorra
5	4	8	2007-06-04 20:00:27.490972	Segundo comentario
\.


--
-- Data for Name: comparticulo; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY comparticulo (idarticulo, cantcomparticulo, idcomponente) FROM stdin;
\.


--
-- Data for Name: configuracion; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY configuracion (nombre, valor) FROM stdin;
Pais	--
Tipo	BulmaFact
Provincia	--
Municipio	--
CodCuenta	xxxxyyy
CodPostal	--
DireccionCompleta	*CAMBIAME*
Ejercicio	2006
Escalera	--
TipoVia	--
SerieFacturaDefecto	DD
Puerta	--
Piso	--
NombreEmpresa	Facturación Demo
ProgramaContabilidad	BulmaCont
NumeroVia	--
NombreVia	--
CodArticuloGenerico	*CAMBIAME*
Ciudad	*CAMBIAME*
CIF	--
AlmacenDefecto	100
IRPF	0
DBRev-Trazabilidad	0.9.1
DBRev-Contratos	0.9.1-0002
DBRev-PluginLlamadas	0.9.3-0001
DBRev-Cuadrante	0.9.3-0002
DBRev-ComercialBF	0.5.9
DBRev-ValAsterisk	0.9.3-0001
DatabaseRevision	0.9.3-0009
DBRev-TiposTrabajo	0.10.1-0001
DBRev-PluginnQ19	0.10.1-0001
DBRev-Inventario	0.10.1-0001
DBRev-BulmaTPV	0.10.2-0002
DBRev-IVAInc	0.10.1-0001
DataBaseContabilidad	bulmacont
DBRev-SyncBulmaCont	0.9.1-001
\.


--
-- Data for Name: contrato; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY contrato (idcontrato, idcliente, refcontrato, nomcontrato, fincontrato, ffincontrato, periodicidadcontrato, descontrato, loccontrato) FROM stdin;
1	136	TTYYY	asdf	2007-06-08	2007-06-08	15 days	\N	asdf
\.


--
-- Data for Name: controlstock; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY controlstock (idinventario, idalmacen, idarticulo, stockantcontrolstock, stocknewcontrolstock, punteocontrolstock) FROM stdin;
\.


--
-- Data for Name: cuadrante; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY cuadrante (idcuadrante, fechacuadrante, idalmacen, comentcuadrante, aperturacuadrante, cierrecuadrante, apertura1cuadrante, cierre1cuadrante, fiestacuadrante) FROM stdin;
12	2007-09-07	1	\N	\N	\N	\N	\N	f
1124	2007-11-17	6		\N	\N	\N	\N	f
26	2007-09-07	5	\N	\N	\N	\N	\N	f
1131	2007-11-17	5		\N	\N	\N	\N	f
33	2007-09-07	4	\N	\N	\N	\N	\N	f
1138	2007-11-17	2		\N	\N	\N	\N	f
36	2007-09-10	6	\N	\N	\N	\N	\N	f
37	2007-09-11	6	\N	\N	\N	\N	\N	f
40	2007-09-14	6	\N	\N	\N	\N	\N	f
41	2007-09-15	6	\N	\N	\N	\N	\N	f
1111	2007-11-18	1		\N	\N	\N	\N	f
43	2007-09-10	1	\N	\N	\N	\N	\N	f
47	2007-09-14	1	\N	\N	\N	\N	\N	f
48	2007-09-15	1	\N	\N	\N	\N	\N	f
49	2007-09-16	1	\N	\N	\N	\N	\N	f
50	2007-09-10	2	\N	\N	\N	\N	\N	f
51	2007-09-11	2	\N	\N	\N	\N	\N	f
54	2007-09-14	2	\N	\N	\N	\N	\N	f
55	2007-09-15	2	\N	\N	\N	\N	\N	f
56	2007-09-16	2	\N	\N	\N	\N	\N	f
57	2007-09-10	5	\N	\N	\N	\N	\N	f
58	2007-09-11	5	\N	\N	\N	\N	\N	f
61	2007-09-14	5	\N	\N	\N	\N	\N	f
63	2007-09-16	5	\N	\N	\N	\N	\N	f
64	2007-09-10	4	\N	\N	\N	\N	\N	f
68	2007-09-14	4	\N	\N	\N	\N	\N	f
69	2007-09-15	4	\N	\N	\N	\N	\N	f
70	2007-09-16	4	\N	\N	\N	\N	\N	f
71	2007-08-27	6	\N	\N	\N	\N	\N	f
72	2007-08-28	6	\N	\N	\N	\N	\N	f
73	2007-08-29	6	\N	\N	\N	\N	\N	f
74	2007-08-30	6	\N	\N	\N	\N	\N	f
75	2007-08-31	6	\N	\N	\N	\N	\N	f
76	2007-09-01	6	\N	\N	\N	\N	\N	f
78	2007-08-27	1	\N	\N	\N	\N	\N	f
79	2007-08-28	1	\N	\N	\N	\N	\N	f
80	2007-08-29	1	\N	\N	\N	\N	\N	f
81	2007-08-30	1	\N	\N	\N	\N	\N	f
82	2007-08-31	1	\N	\N	\N	\N	\N	f
83	2007-09-01	1	\N	\N	\N	\N	\N	f
85	2007-08-27	2	\N	\N	\N	\N	\N	f
86	2007-08-28	2	\N	\N	\N	\N	\N	f
87	2007-08-29	2	\N	\N	\N	\N	\N	f
88	2007-08-30	2	\N	\N	\N	\N	\N	f
89	2007-08-31	2	\N	\N	\N	\N	\N	f
90	2007-09-01	2	\N	\N	\N	\N	\N	f
92	2007-08-27	5	\N	\N	\N	\N	\N	f
93	2007-08-28	5	\N	\N	\N	\N	\N	f
94	2007-08-29	5	\N	\N	\N	\N	\N	f
95	2007-08-30	5	\N	\N	\N	\N	\N	f
96	2007-08-31	5	\N	\N	\N	\N	\N	f
97	2007-09-01	5	\N	\N	\N	\N	\N	f
99	2007-08-27	4	\N	\N	\N	\N	\N	f
100	2007-08-28	4	\N	\N	\N	\N	\N	f
101	2007-08-29	4	\N	\N	\N	\N	\N	f
102	2007-08-30	4	\N	\N	\N	\N	\N	f
103	2007-08-31	4	\N	\N	\N	\N	\N	f
104	2007-09-01	4	\N	\N	\N	\N	\N	f
77	2007-09-02	6	\N	\N	\N	\N	\N	t
84	2007-09-02	1	\N	\N	\N	\N	\N	t
91	2007-09-02	2	\N	\N	\N	\N	\N	t
98	2007-09-02	5	\N	\N	\N	\N	\N	t
105	2007-09-02	4	\N	\N	\N	\N	\N	t
7	2007-09-09	6	\N	\N	\N	\N	\N	t
21	2007-09-09	2	\N	\N	\N	\N	\N	t
28	2007-09-09	5	\N	\N	\N	\N	\N	t
35	2007-09-09	4	\N	\N	\N	\N	\N	t
14	2007-09-09	1	\N	\N	\N	\N	\N	t
19	2007-09-07	2	\N	\N	\N	\N	\N	f
5	2007-09-07	6	\N	\N	\N	\N	\N	f
1118	2007-11-18	4		\N	\N	\N	\N	f
108	2007-09-19	6	\N	\N	\N	\N	\N	f
109	2007-09-20	6	\N	\N	\N	\N	\N	f
112	2007-09-23	6	\N	\N	\N	\N	\N	f
115	2007-09-19	1	\N	\N	\N	\N	\N	f
116	2007-09-20	1	\N	\N	\N	\N	\N	f
118	2007-09-22	1	\N	\N	\N	\N	\N	f
119	2007-09-23	1	\N	\N	\N	\N	\N	f
122	2007-09-19	2	\N	\N	\N	\N	\N	f
123	2007-09-20	2	\N	\N	\N	\N	\N	f
125	2007-09-22	2	\N	\N	\N	\N	\N	f
126	2007-09-23	2	\N	\N	\N	\N	\N	f
1125	2007-11-18	6		\N	\N	\N	\N	f
129	2007-09-19	5	\N	\N	\N	\N	\N	f
130	2007-09-20	5	\N	\N	\N	\N	\N	f
132	2007-09-22	5	\N	\N	\N	\N	\N	f
133	2007-09-23	5	\N	\N	\N	\N	\N	f
1132	2007-11-18	5		\N	\N	\N	\N	f
136	2007-09-19	4	\N	\N	\N	\N	\N	f
137	2007-09-20	4	\N	\N	\N	\N	\N	f
139	2007-09-22	4	\N	\N	\N	\N	\N	f
140	2007-09-23	4	\N	\N	\N	\N	\N	f
110	2007-09-21	6	\N	\N	\N	\N	\N	t
1139	2007-11-18	2		\N	\N	\N	\N	f
124	2007-09-21	2	\N	\N	\N	\N	\N	t
131	2007-09-21	5	\N	\N	\N	\N	\N	t
138	2007-09-21	4	\N	\N	\N	\N	\N	t
141	2007-09-24	6	\N	\N	\N	\N	\N	f
142	2007-09-25	6	\N	\N	\N	\N	\N	f
143	2007-09-26	6	\N	\N	\N	\N	\N	f
144	2007-09-27	6	\N	\N	\N	\N	\N	f
145	2007-09-28	6	\N	\N	\N	\N	\N	f
146	2007-09-29	6	\N	\N	\N	\N	\N	f
147	2007-09-30	6	\N	\N	\N	\N	\N	f
148	2007-09-24	1	\N	\N	\N	\N	\N	f
149	2007-09-25	1	\N	\N	\N	\N	\N	f
150	2007-09-26	1	\N	\N	\N	\N	\N	f
151	2007-09-27	1	\N	\N	\N	\N	\N	f
152	2007-09-28	1	\N	\N	\N	\N	\N	f
153	2007-09-29	1	\N	\N	\N	\N	\N	f
154	2007-09-30	1	\N	\N	\N	\N	\N	f
155	2007-09-24	2	\N	\N	\N	\N	\N	f
156	2007-09-25	2	\N	\N	\N	\N	\N	f
157	2007-09-26	2	\N	\N	\N	\N	\N	f
158	2007-09-27	2	\N	\N	\N	\N	\N	f
159	2007-09-28	2	\N	\N	\N	\N	\N	f
160	2007-09-29	2	\N	\N	\N	\N	\N	f
161	2007-09-30	2	\N	\N	\N	\N	\N	f
162	2007-09-24	5	\N	\N	\N	\N	\N	f
163	2007-09-25	5	\N	\N	\N	\N	\N	f
164	2007-09-26	5	\N	\N	\N	\N	\N	f
165	2007-09-27	5	\N	\N	\N	\N	\N	f
166	2007-09-28	5	\N	\N	\N	\N	\N	f
167	2007-09-29	5	\N	\N	\N	\N	\N	f
168	2007-09-30	5	\N	\N	\N	\N	\N	f
169	2007-09-24	4	\N	\N	\N	\N	\N	f
170	2007-09-25	4	\N	\N	\N	\N	\N	f
171	2007-09-26	4	\N	\N	\N	\N	\N	f
172	2007-09-27	4	\N	\N	\N	\N	\N	f
173	2007-09-28	4	\N	\N	\N	\N	\N	f
174	2007-09-29	4	\N	\N	\N	\N	\N	f
175	2007-09-30	4	\N	\N	\N	\N	\N	f
23	2007-09-04	5	\N	\N	\N	\N	\N	f
120	2007-09-17	2	\N	\N	\N	\N	\N	t
2	2007-09-04	6	Dejamé que te diga\nque no me gusta\nel cuadrante	\N	\N	\N	\N	f
31	2007-09-05	4	\N	\N	\N	\N	\N	f
10	2007-09-05	1	\N	\N	\N	\N	\N	f
24	2007-09-05	5	\N	\N	\N	\N	\N	f
17	2007-09-05	2	\N	\N	\N	\N	\N	f
3	2007-09-05	6	JODIOS MALAJES	\N	\N	\N	\N	f
8	2007-09-03	1	\N	\N	\N	\N	\N	f
15	2007-09-03	2	\N	\N	\N	\N	\N	f
22	2007-09-03	5	\N	\N	\N	\N	\N	f
29	2007-09-03	4	\N	\N	\N	\N	\N	f
1	2007-09-03	6	Tienes un comentario\nque hacer y lo pones aqui.\nPECADORRRR !!!!!!	\N	\N	\N	\N	f
16	2007-09-04	2	Heyyyyy\nMacarena\nOAHH!!!	\N	\N	\N	\N	f
111	2007-09-22	6	\N	\N	\N	\N	\N	f
30	2007-09-04	4	Negro futuro\npara la informatica\nde diseño	\N	\N	\N	\N	f
1119	2007-11-12	6		\N	\N	\N	\N	f
44	2007-09-11	1	Poca cosa que decir\neste es un comentario	\N	\N	\N	\N	f
65	2007-09-11	4	\N	\N	\N	\N	\N	f
180	2007-10-05	6	\N	\N	\N	\N	\N	f
186	2007-10-04	1	\N	\N	\N	\N	\N	f
187	2007-10-05	1	\N	\N	\N	\N	\N	f
194	2007-10-05	2	\N	\N	\N	\N	\N	f
200	2007-10-04	5	\N	\N	\N	\N	\N	f
201	2007-10-05	5	\N	\N	\N	\N	\N	f
206	2007-10-03	4	\N	\N	\N	\N	\N	f
208	2007-10-05	4	\N	\N	\N	\N	\N	f
9	2007-09-04	1	Siempre tuyo	\N	\N	\N	\N	t
62	2007-09-15	5	zxcvzxcvzxcv	\N	\N	\N	\N	f
39	2007-09-13	6	\N	\N	\N	\N	\N	t
46	2007-09-13	1	\N	\N	\N	\N	\N	t
67	2007-09-13	4	\N	\N	\N	\N	\N	t
53	2007-09-13	2	\N	\N	\N	\N	\N	f
135	2007-09-18	4	\N	\N	\N	\N	\N	f
117	2007-09-21	1	\N	\N	\N	\N	\N	f
42	2007-09-16	6	\N	\N	\N	\N	\N	t
38	2007-09-12	6	\N	\N	\N	\N	\N	f
52	2007-09-12	2	\N	\N	\N	\N	\N	f
59	2007-09-12	5	\N	\N	\N	\N	\N	f
45	2007-09-12	1	\N	\N	\N	\N	\N	f
66	2007-09-12	4	\N	\N	\N	\N	\N	f
60	2007-09-13	5	\N	\N	\N	\N	\N	f
106	2007-09-17	6	\N	\N	\N	\N	\N	f
127	2007-09-17	5	\N	\N	\N	\N	\N	f
128	2007-09-18	5	\N	\N	\N	\N	\N	t
113	2007-09-17	1	\N	\N	\N	\N	\N	f
134	2007-09-17	4	\N	\N	\N	\N	\N	f
121	2007-09-18	2	\N	\N	\N	\N	\N	f
107	2007-09-18	6	\N	\N	\N	\N	\N	f
114	2007-09-18	1	\N	\N	\N	\N	\N	f
212	2007-10-09	4	\N	\N	\N	\N	\N	f
213	2007-10-10	4	\N	\N	\N	\N	\N	f
214	2007-10-11	4	\N	\N	\N	\N	\N	f
215	2007-10-12	4	\N	\N	\N	\N	\N	f
216	2007-10-13	4	\N	\N	\N	\N	\N	f
217	2007-10-14	4	\N	\N	\N	\N	\N	f
219	2007-10-09	5	\N	\N	\N	\N	\N	f
220	2007-10-10	5	\N	\N	\N	\N	\N	f
221	2007-10-11	5	\N	\N	\N	\N	\N	f
222	2007-10-12	5	\N	\N	\N	\N	\N	f
223	2007-10-13	5	\N	\N	\N	\N	\N	f
224	2007-10-14	5	\N	\N	\N	\N	\N	f
226	2007-10-09	1	\N	\N	\N	\N	\N	f
227	2007-10-10	1	\N	\N	\N	\N	\N	f
228	2007-10-11	1	\N	\N	\N	\N	\N	f
229	2007-10-12	1	\N	\N	\N	\N	\N	f
230	2007-10-13	1	\N	\N	\N	\N	\N	f
231	2007-10-14	1	\N	\N	\N	\N	\N	f
232	2007-10-08	2	\N	\N	\N	\N	\N	f
233	2007-10-09	2	\N	\N	\N	\N	\N	f
234	2007-10-10	2	\N	\N	\N	\N	\N	f
235	2007-10-11	2	\N	\N	\N	\N	\N	f
236	2007-10-12	2	\N	\N	\N	\N	\N	f
237	2007-10-13	2	\N	\N	\N	\N	\N	f
238	2007-10-14	2	\N	\N	\N	\N	\N	f
239	2007-10-08	6	\N	\N	\N	\N	\N	f
240	2007-10-09	6	\N	\N	\N	\N	\N	f
241	2007-10-10	6	\N	\N	\N	\N	\N	f
242	2007-10-11	6	\N	\N	\N	\N	\N	f
243	2007-10-12	6	\N	\N	\N	\N	\N	f
244	2007-10-13	6	\N	\N	\N	\N	\N	f
245	2007-10-14	6	\N	\N	\N	\N	\N	f
246	2007-10-15	4	\N	\N	\N	\N	\N	f
247	2007-10-16	4	\N	\N	\N	\N	\N	f
248	2007-10-17	4	\N	\N	\N	\N	\N	f
249	2007-10-18	4	\N	\N	\N	\N	\N	f
250	2007-10-19	4	\N	\N	\N	\N	\N	f
251	2007-10-20	4	\N	\N	\N	\N	\N	f
252	2007-10-21	4	\N	\N	\N	\N	\N	f
253	2007-10-15	5	\N	\N	\N	\N	\N	f
254	2007-10-16	5	\N	\N	\N	\N	\N	f
255	2007-10-17	5	\N	\N	\N	\N	\N	f
256	2007-10-18	5	\N	\N	\N	\N	\N	f
257	2007-10-19	5	\N	\N	\N	\N	\N	f
258	2007-10-20	5	\N	\N	\N	\N	\N	f
259	2007-10-21	5	\N	\N	\N	\N	\N	f
260	2007-10-15	1	\N	\N	\N	\N	\N	f
261	2007-10-16	1	\N	\N	\N	\N	\N	f
262	2007-10-17	1	\N	\N	\N	\N	\N	f
263	2007-10-18	1	\N	\N	\N	\N	\N	f
264	2007-10-19	1	\N	\N	\N	\N	\N	f
265	2007-10-20	1	\N	\N	\N	\N	\N	f
266	2007-10-21	1	\N	\N	\N	\N	\N	f
269	2007-10-17	2	\N	\N	\N	\N	\N	f
270	2007-10-18	2	\N	\N	\N	\N	\N	f
271	2007-10-19	2	\N	\N	\N	\N	\N	f
272	2007-10-20	2	\N	\N	\N	\N	\N	f
273	2007-10-21	2	\N	\N	\N	\N	\N	f
274	2007-10-15	6	\N	\N	\N	\N	\N	f
275	2007-10-16	6	\N	\N	\N	\N	\N	f
276	2007-10-17	6	\N	\N	\N	\N	\N	f
277	2007-10-18	6	\N	\N	\N	\N	\N	f
278	2007-10-19	6	\N	\N	\N	\N	\N	f
279	2007-10-20	6	\N	\N	\N	\N	\N	f
280	2007-10-21	6	\N	\N	\N	\N	\N	f
189	2007-10-07	1	\N	\N	\N	\N	\N	t
196	2007-10-07	2	\N	\N	\N	\N	\N	t
203	2007-10-07	5	\N	\N	\N	\N	\N	t
188	2007-10-06	1	\N	\N	\N	\N	\N	t
195	2007-10-06	2	\N	\N	\N	\N	\N	t
202	2007-10-06	5	\N	\N	\N	\N	\N	t
190	2007-10-01	2	\N	\N	\N	\N	\N	f
197	2007-10-01	5	hooooderrrrrr	\N	\N	\N	\N	t
4	2007-09-06	6	\N	\N	\N	\N	\N	f
11	2007-09-06	1	\N	\N	\N	\N	\N	f
25	2007-09-06	5	\N	\N	\N	\N	\N	f
32	2007-09-06	4	\N	\N	\N	\N	\N	f
18	2007-09-06	2	\N	\N	\N	\N	\N	f
6	2007-09-08	6	\N	\N	\N	\N	\N	t
20	2007-09-08	2	\N	\N	\N	\N	\N	t
27	2007-09-08	5	\N	\N	\N	\N	\N	t
34	2007-09-08	4	\N	\N	\N	\N	\N	t
13	2007-09-08	1	\N	\N	\N	\N	\N	t
182	2007-10-07	6	\N	\N	\N	\N	\N	t
181	2007-10-06	6	\N	\N	\N	\N	\N	t
184	2007-10-02	1	jodete capullin	\N	\N	\N	\N	f
204	2007-10-01	4	\N	\N	\N	\N	\N	f
176	2007-10-01	6	\N	\N	\N	\N	\N	f
209	2007-10-06	4	\N	\N	\N	\N	\N	t
210	2007-10-07	4	\N	\N	\N	\N	\N	t
191	2007-10-02	2	Este es un comentario cutrecillo\nQue no tiene nada que envidiar a los demás comentarios.\nPero que, <I>no por ello</I>, <font color="#444499">se puede considerar bueno</font>.	\N	\N	\N	\N	f
192	2007-10-03	2	\N	\N	\N	\N	\N	f
317	2007-10-23	4	\N	\N	\N	\N	\N	f
318	2007-10-24	4	\N	\N	\N	\N	\N	f
319	2007-10-25	4	\N	\N	\N	\N	\N	f
320	2007-10-26	4	\N	\N	\N	\N	\N	f
321	2007-10-27	4	\N	\N	\N	\N	\N	f
322	2007-10-28	4	\N	\N	\N	\N	\N	f
324	2007-10-23	5	\N	\N	\N	\N	\N	f
325	2007-10-24	5	\N	\N	\N	\N	\N	f
326	2007-10-25	5	\N	\N	\N	\N	\N	f
327	2007-10-26	5	\N	\N	\N	\N	\N	f
328	2007-10-27	5	\N	\N	\N	\N	\N	f
329	2007-10-28	5	\N	\N	\N	\N	\N	f
330	2007-10-22	1	\N	\N	\N	\N	\N	f
331	2007-10-23	1	\N	\N	\N	\N	\N	f
332	2007-10-24	1	\N	\N	\N	\N	\N	f
333	2007-10-25	1	\N	\N	\N	\N	\N	f
335	2007-10-27	1	\N	\N	\N	\N	\N	f
336	2007-10-28	1	\N	\N	\N	\N	\N	f
338	2007-10-23	2	\N	\N	\N	\N	\N	f
339	2007-10-24	2	\N	\N	\N	\N	\N	f
341	2007-10-26	2	\N	\N	\N	\N	\N	f
342	2007-10-27	2	\N	\N	\N	\N	\N	f
343	2007-10-28	2	\N	\N	\N	\N	\N	f
344	2007-10-22	6	\N	\N	\N	\N	\N	f
345	2007-10-23	6	\N	\N	\N	\N	\N	f
346	2007-10-24	6	\N	\N	\N	\N	\N	f
347	2007-10-25	6	\N	\N	\N	\N	\N	f
348	2007-10-26	6	\N	\N	\N	\N	\N	f
349	2007-10-27	6	\N	\N	\N	\N	\N	f
350	2007-10-28	6	\N	\N	\N	\N	\N	f
351	2007-08-06	4	\N	\N	\N	\N	\N	f
352	2007-08-07	4	\N	\N	\N	\N	\N	f
353	2007-08-08	4	\N	\N	\N	\N	\N	f
354	2007-08-09	4	\N	\N	\N	\N	\N	f
355	2007-08-10	4	\N	\N	\N	\N	\N	f
356	2007-08-11	4	\N	\N	\N	\N	\N	f
357	2007-08-12	4	\N	\N	\N	\N	\N	f
358	2007-08-06	5	\N	\N	\N	\N	\N	f
359	2007-08-07	5	\N	\N	\N	\N	\N	f
360	2007-08-08	5	\N	\N	\N	\N	\N	f
361	2007-08-09	5	\N	\N	\N	\N	\N	f
362	2007-08-10	5	\N	\N	\N	\N	\N	f
363	2007-08-11	5	\N	\N	\N	\N	\N	f
364	2007-08-12	5	\N	\N	\N	\N	\N	f
365	2007-08-06	1	\N	\N	\N	\N	\N	f
366	2007-08-07	1	\N	\N	\N	\N	\N	f
367	2007-08-08	1	\N	\N	\N	\N	\N	f
368	2007-08-09	1	\N	\N	\N	\N	\N	f
369	2007-08-10	1	\N	\N	\N	\N	\N	f
370	2007-08-11	1	\N	\N	\N	\N	\N	f
371	2007-08-12	1	\N	\N	\N	\N	\N	f
372	2007-08-06	2	\N	\N	\N	\N	\N	f
373	2007-08-07	2	\N	\N	\N	\N	\N	f
374	2007-08-08	2	\N	\N	\N	\N	\N	f
375	2007-08-09	2	\N	\N	\N	\N	\N	f
376	2007-08-10	2	\N	\N	\N	\N	\N	f
377	2007-08-11	2	\N	\N	\N	\N	\N	f
378	2007-08-12	2	\N	\N	\N	\N	\N	f
379	2007-08-06	6	\N	\N	\N	\N	\N	f
380	2007-08-07	6	\N	\N	\N	\N	\N	f
381	2007-08-08	6	\N	\N	\N	\N	\N	f
382	2007-08-09	6	\N	\N	\N	\N	\N	f
383	2007-08-10	6	\N	\N	\N	\N	\N	f
384	2007-08-11	6	\N	\N	\N	\N	\N	f
385	2007-08-12	6	\N	\N	\N	\N	\N	f
386	2007-08-13	4	\N	\N	\N	\N	\N	f
387	2007-08-14	4	\N	\N	\N	\N	\N	f
388	2007-08-15	4	\N	\N	\N	\N	\N	f
389	2007-08-16	4	\N	\N	\N	\N	\N	f
390	2007-08-17	4	\N	\N	\N	\N	\N	f
391	2007-08-18	4	\N	\N	\N	\N	\N	f
392	2007-08-19	4	\N	\N	\N	\N	\N	f
393	2007-08-13	5	\N	\N	\N	\N	\N	f
394	2007-08-14	5	\N	\N	\N	\N	\N	f
395	2007-08-15	5	\N	\N	\N	\N	\N	f
396	2007-08-16	5	\N	\N	\N	\N	\N	f
397	2007-08-17	5	\N	\N	\N	\N	\N	f
398	2007-08-18	5	\N	\N	\N	\N	\N	f
399	2007-08-19	5	\N	\N	\N	\N	\N	f
400	2007-08-13	1	\N	\N	\N	\N	\N	f
401	2007-08-14	1	\N	\N	\N	\N	\N	f
402	2007-08-15	1	\N	\N	\N	\N	\N	f
403	2007-08-16	1	\N	\N	\N	\N	\N	f
404	2007-08-17	1	\N	\N	\N	\N	\N	f
405	2007-08-18	1	\N	\N	\N	\N	\N	f
406	2007-08-19	1	\N	\N	\N	\N	\N	f
407	2007-08-13	2	\N	\N	\N	\N	\N	f
408	2007-08-14	2	\N	\N	\N	\N	\N	f
409	2007-08-15	2	\N	\N	\N	\N	\N	f
410	2007-08-16	2	\N	\N	\N	\N	\N	f
411	2007-08-17	2	\N	\N	\N	\N	\N	f
412	2007-08-18	2	\N	\N	\N	\N	\N	f
413	2007-08-19	2	\N	\N	\N	\N	\N	f
414	2007-08-13	6	\N	\N	\N	\N	\N	f
415	2007-08-14	6	\N	\N	\N	\N	\N	f
416	2007-08-15	6	\N	\N	\N	\N	\N	f
417	2007-08-16	6	\N	\N	\N	\N	\N	f
418	2007-08-17	6	\N	\N	\N	\N	\N	f
419	2007-08-18	6	\N	\N	\N	\N	\N	f
420	2007-08-19	6	\N	\N	\N	\N	\N	f
421	2007-08-20	4	\N	\N	\N	\N	\N	f
422	2007-08-21	4	\N	\N	\N	\N	\N	f
423	2007-08-22	4	\N	\N	\N	\N	\N	f
424	2007-08-23	4	\N	\N	\N	\N	\N	f
425	2007-08-24	4	\N	\N	\N	\N	\N	f
426	2007-08-25	4	\N	\N	\N	\N	\N	f
427	2007-08-26	4	\N	\N	\N	\N	\N	f
428	2007-08-20	5	\N	\N	\N	\N	\N	f
429	2007-08-21	5	\N	\N	\N	\N	\N	f
430	2007-08-22	5	\N	\N	\N	\N	\N	f
431	2007-08-23	5	\N	\N	\N	\N	\N	f
432	2007-08-24	5	\N	\N	\N	\N	\N	f
433	2007-08-25	5	\N	\N	\N	\N	\N	f
434	2007-08-26	5	\N	\N	\N	\N	\N	f
435	2007-08-20	1	\N	\N	\N	\N	\N	f
436	2007-08-21	1	\N	\N	\N	\N	\N	f
437	2007-08-22	1	\N	\N	\N	\N	\N	f
438	2007-08-23	1	\N	\N	\N	\N	\N	f
439	2007-08-24	1	\N	\N	\N	\N	\N	f
440	2007-08-25	1	\N	\N	\N	\N	\N	f
441	2007-08-26	1	\N	\N	\N	\N	\N	f
442	2007-08-20	2	\N	\N	\N	\N	\N	f
443	2007-08-21	2	\N	\N	\N	\N	\N	f
444	2007-08-22	2	\N	\N	\N	\N	\N	f
445	2007-08-23	2	\N	\N	\N	\N	\N	f
446	2007-08-24	2	\N	\N	\N	\N	\N	f
447	2007-08-25	2	\N	\N	\N	\N	\N	f
448	2007-08-26	2	\N	\N	\N	\N	\N	f
449	2007-08-20	6	\N	\N	\N	\N	\N	f
450	2007-08-21	6	\N	\N	\N	\N	\N	f
451	2007-08-22	6	\N	\N	\N	\N	\N	f
452	2007-08-23	6	\N	\N	\N	\N	\N	f
453	2007-08-24	6	\N	\N	\N	\N	\N	f
454	2007-08-25	6	\N	\N	\N	\N	\N	f
455	2007-08-26	6	\N	\N	\N	\N	\N	f
198	2007-10-02	5	no tengo miedo	\N	\N	\N	\N	f
178	2007-10-03	6	\N	\N	\N	\N	\N	f
185	2007-10-03	1	\N	\N	\N	\N	\N	f
199	2007-10-03	5	\N	\N	\N	\N	\N	f
193	2007-10-04	2	\N	\N	\N	\N	\N	f
179	2007-10-04	6	\N	\N	\N	\N	\N	f
205	2007-10-02	4	\N	\N	\N	\N	\N	f
207	2007-10-04	4	\N	\N	\N	\N	\N	f
177	2007-10-02	6	\N	\N	\N	\N	\N	f
183	2007-10-01	1	\N	\N	\N	\N	\N	f
225	2007-10-08	1	\N	\N	\N	\N	\N	f
218	2007-10-08	5	Capullete fumate un porrete	\N	\N	\N	\N	f
267	2007-10-15	2	\N	\N	\N	\N	\N	f
268	2007-10-16	2	\N	\N	\N	\N	\N	f
337	2007-10-22	2	\N	\N	\N	\N	\N	f
316	2007-10-22	4	\N	\N	\N	\N	\N	f
323	2007-10-22	5	\N	\N	\N	\N	\N	f
334	2007-10-26	1	\N	\N	\N	\N	\N	f
340	2007-10-25	2	\N	\N	\N	\N	\N	f
211	2007-10-08	4	\N	\N	\N	\N	\N	f
1070	2007-11-05	1		\N	\N	\N	\N	f
1084	2007-11-05	6		\N	\N	\N	\N	f
1091	2007-11-05	5		\N	\N	\N	\N	f
1098	2007-11-05	2		\N	\N	\N	\N	f
1077	2007-11-05	4	asdf asdf asdf asdf asdfa sdf	\N	\N	\N	\N	f
1071	2007-11-06	1		\N	\N	\N	\N	f
1078	2007-11-06	4		\N	\N	\N	\N	f
1085	2007-11-06	6		\N	\N	\N	\N	f
1092	2007-11-06	5		\N	\N	\N	\N	f
1099	2007-11-06	2		\N	\N	\N	\N	f
1072	2007-11-07	1		\N	\N	\N	\N	f
1079	2007-11-07	4		\N	\N	\N	\N	f
1086	2007-11-07	6		\N	\N	\N	\N	f
1093	2007-11-07	5		\N	\N	\N	\N	f
1100	2007-11-07	2		\N	\N	\N	\N	f
1073	2007-11-08	1		\N	\N	\N	\N	f
1080	2007-11-08	4		\N	\N	\N	\N	f
1087	2007-11-08	6		\N	\N	\N	\N	f
1094	2007-11-08	5		\N	\N	\N	\N	f
1101	2007-11-08	2		\N	\N	\N	\N	f
1074	2007-11-09	1		\N	\N	\N	\N	f
1081	2007-11-09	4		\N	\N	\N	\N	f
1088	2007-11-09	6		\N	\N	\N	\N	f
1095	2007-11-09	5		\N	\N	\N	\N	f
1102	2007-11-09	2		\N	\N	\N	\N	f
1075	2007-11-10	1		\N	\N	\N	\N	f
1082	2007-11-10	4		\N	\N	\N	\N	f
1089	2007-11-10	6		\N	\N	\N	\N	f
1096	2007-11-10	5		\N	\N	\N	\N	f
1103	2007-11-10	2		\N	\N	\N	\N	f
1076	2007-11-11	1		\N	\N	\N	\N	f
1083	2007-11-11	4		\N	\N	\N	\N	f
1090	2007-11-11	6		\N	\N	\N	\N	f
1097	2007-11-11	5		\N	\N	\N	\N	f
1104	2007-11-11	2		\N	\N	\N	\N	f
921	2007-11-19	1	\N	\N	\N	\N	\N	f
922	2007-11-20	1	\N	\N	\N	\N	\N	f
923	2007-11-21	1	\N	\N	\N	\N	\N	f
924	2007-11-22	1	\N	\N	\N	\N	\N	f
925	2007-11-23	1	\N	\N	\N	\N	\N	f
926	2007-11-24	1	\N	\N	\N	\N	\N	f
927	2007-11-25	1	\N	\N	\N	\N	\N	f
928	2007-11-19	4	\N	\N	\N	\N	\N	f
929	2007-11-20	4	\N	\N	\N	\N	\N	f
930	2007-11-21	4	\N	\N	\N	\N	\N	f
931	2007-11-22	4	\N	\N	\N	\N	\N	f
932	2007-11-23	4	\N	\N	\N	\N	\N	f
933	2007-11-24	4	\N	\N	\N	\N	\N	f
934	2007-11-25	4	\N	\N	\N	\N	\N	f
935	2007-11-19	6	\N	\N	\N	\N	\N	f
936	2007-11-20	6	\N	\N	\N	\N	\N	f
937	2007-11-21	6	\N	\N	\N	\N	\N	f
938	2007-11-22	6	\N	\N	\N	\N	\N	f
939	2007-11-23	6	\N	\N	\N	\N	\N	f
940	2007-11-24	6	\N	\N	\N	\N	\N	f
941	2007-11-25	6	\N	\N	\N	\N	\N	f
942	2007-11-19	5	\N	\N	\N	\N	\N	f
943	2007-11-20	5	\N	\N	\N	\N	\N	f
944	2007-11-21	5	\N	\N	\N	\N	\N	f
945	2007-11-22	5	\N	\N	\N	\N	\N	f
946	2007-11-23	5	\N	\N	\N	\N	\N	f
947	2007-11-24	5	\N	\N	\N	\N	\N	f
948	2007-11-25	5	\N	\N	\N	\N	\N	f
949	2007-11-19	2	\N	\N	\N	\N	\N	f
950	2007-11-20	2	\N	\N	\N	\N	\N	f
951	2007-11-21	2	\N	\N	\N	\N	\N	f
952	2007-11-22	2	\N	\N	\N	\N	\N	f
953	2007-11-23	2	\N	\N	\N	\N	\N	f
954	2007-11-24	2	\N	\N	\N	\N	\N	f
955	2007-11-25	2	\N	\N	\N	\N	\N	f
496	2007-10-29	1		\N	\N	\N	\N	f
510	2007-10-29	6		\N	\N	\N	\N	f
517	2007-10-29	5		\N	\N	\N	\N	f
524	2007-10-29	2		\N	\N	\N	\N	f
503	2007-10-29	4	asdf asdf asdf asdf asdfa sdf	\N	\N	\N	\N	f
497	2007-10-30	1		\N	\N	\N	\N	f
504	2007-10-30	4		\N	\N	\N	\N	f
511	2007-10-30	6		\N	\N	\N	\N	f
518	2007-10-30	5		\N	\N	\N	\N	f
525	2007-10-30	2		\N	\N	\N	\N	f
498	2007-10-31	1		\N	\N	\N	\N	f
505	2007-10-31	4		\N	\N	\N	\N	f
512	2007-10-31	6		\N	\N	\N	\N	f
519	2007-10-31	5		\N	\N	\N	\N	f
526	2007-10-31	2		\N	\N	\N	\N	f
499	2007-11-01	1		\N	\N	\N	\N	f
506	2007-11-01	4		\N	\N	\N	\N	f
513	2007-11-01	6		\N	\N	\N	\N	f
520	2007-11-01	5		\N	\N	\N	\N	f
527	2007-11-01	2		\N	\N	\N	\N	f
500	2007-11-02	1		\N	\N	\N	\N	f
507	2007-11-02	4		\N	\N	\N	\N	f
514	2007-11-02	6		\N	\N	\N	\N	f
521	2007-11-02	5		\N	\N	\N	\N	f
528	2007-11-02	2		\N	\N	\N	\N	f
501	2007-11-03	1		\N	\N	\N	\N	f
508	2007-11-03	4		\N	\N	\N	\N	f
515	2007-11-03	6		\N	\N	\N	\N	f
522	2007-11-03	5		\N	\N	\N	\N	f
529	2007-11-03	2		\N	\N	\N	\N	f
502	2007-11-04	1		\N	\N	\N	\N	f
509	2007-11-04	4		\N	\N	\N	\N	f
516	2007-11-04	6		\N	\N	\N	\N	f
523	2007-11-04	5		\N	\N	\N	\N	f
530	2007-11-04	2		\N	\N	\N	\N	f
1105	2007-11-12	1		\N	\N	\N	\N	f
1126	2007-11-12	5		\N	\N	\N	\N	f
1133	2007-11-12	2		\N	\N	\N	\N	f
1112	2007-11-12	4	asdf asdf asdf asdf asdfa sdf	\N	\N	\N	\N	f
1106	2007-11-13	1		\N	\N	\N	\N	f
1113	2007-11-13	4		\N	\N	\N	\N	f
1120	2007-11-13	6		\N	\N	\N	\N	f
1127	2007-11-13	5		\N	\N	\N	\N	f
1134	2007-11-13	2		\N	\N	\N	\N	f
1107	2007-11-14	1		\N	\N	\N	\N	f
1114	2007-11-14	4		\N	\N	\N	\N	f
1121	2007-11-14	6		\N	\N	\N	\N	f
1128	2007-11-14	5		\N	\N	\N	\N	f
1135	2007-11-14	2		\N	\N	\N	\N	f
1108	2007-11-15	1		\N	\N	\N	\N	f
1115	2007-11-15	4		\N	\N	\N	\N	f
1122	2007-11-15	6		\N	\N	\N	\N	f
1129	2007-11-15	5		\N	\N	\N	\N	f
1136	2007-11-15	2		\N	\N	\N	\N	f
1109	2007-11-16	1		\N	\N	\N	\N	f
1116	2007-11-16	4		\N	\N	\N	\N	f
1123	2007-11-16	6		\N	\N	\N	\N	f
1130	2007-11-16	5		\N	\N	\N	\N	f
1137	2007-11-16	2		\N	\N	\N	\N	f
1110	2007-11-17	1		\N	\N	\N	\N	f
1117	2007-11-17	4		\N	\N	\N	\N	f
1140	2007-12-10	1	\N	\N	\N	\N	\N	f
1141	2007-12-11	1	\N	\N	\N	\N	\N	f
1142	2007-12-12	1	\N	\N	\N	\N	\N	f
1143	2007-12-13	1	\N	\N	\N	\N	\N	f
1144	2007-12-14	1	\N	\N	\N	\N	\N	f
1145	2007-12-15	1	\N	\N	\N	\N	\N	f
1146	2007-12-16	1	\N	\N	\N	\N	\N	f
1147	2007-12-10	4	\N	\N	\N	\N	\N	f
1148	2007-12-11	4	\N	\N	\N	\N	\N	f
1149	2007-12-12	4	\N	\N	\N	\N	\N	f
1150	2007-12-13	4	\N	\N	\N	\N	\N	f
1151	2007-12-14	4	\N	\N	\N	\N	\N	f
1152	2007-12-15	4	\N	\N	\N	\N	\N	f
1153	2007-12-16	4	\N	\N	\N	\N	\N	f
1154	2007-12-10	6	\N	\N	\N	\N	\N	f
1155	2007-12-11	6	\N	\N	\N	\N	\N	f
1156	2007-12-12	6	\N	\N	\N	\N	\N	f
1157	2007-12-13	6	\N	\N	\N	\N	\N	f
1158	2007-12-14	6	\N	\N	\N	\N	\N	f
1159	2007-12-15	6	\N	\N	\N	\N	\N	f
1160	2007-12-16	6	\N	\N	\N	\N	\N	f
1161	2007-12-10	5	\N	\N	\N	\N	\N	f
1162	2007-12-11	5	\N	\N	\N	\N	\N	f
1163	2007-12-12	5	\N	\N	\N	\N	\N	f
1164	2007-12-13	5	\N	\N	\N	\N	\N	f
1165	2007-12-14	5	\N	\N	\N	\N	\N	f
1166	2007-12-15	5	\N	\N	\N	\N	\N	f
1167	2007-12-16	5	\N	\N	\N	\N	\N	f
1168	2007-12-10	2	\N	\N	\N	\N	\N	f
1169	2007-12-11	2	\N	\N	\N	\N	\N	f
1170	2007-12-12	2	\N	\N	\N	\N	\N	f
1171	2007-12-13	2	\N	\N	\N	\N	\N	f
1172	2007-12-14	2	\N	\N	\N	\N	\N	f
1173	2007-12-15	2	\N	\N	\N	\N	\N	f
1174	2007-12-16	2	\N	\N	\N	\N	\N	f
1175	2007-12-03	1	\N	\N	\N	\N	\N	f
1176	2007-12-04	1	\N	\N	\N	\N	\N	f
1177	2007-12-05	1	\N	\N	\N	\N	\N	f
1178	2007-12-06	1	\N	\N	\N	\N	\N	f
1179	2007-12-07	1	\N	\N	\N	\N	\N	f
1180	2007-12-08	1	\N	\N	\N	\N	\N	f
1181	2007-12-09	1	\N	\N	\N	\N	\N	f
1182	2007-12-03	4	\N	\N	\N	\N	\N	f
1183	2007-12-04	4	\N	\N	\N	\N	\N	f
1184	2007-12-05	4	\N	\N	\N	\N	\N	f
1185	2007-12-06	4	\N	\N	\N	\N	\N	f
1186	2007-12-07	4	\N	\N	\N	\N	\N	f
1187	2007-12-08	4	\N	\N	\N	\N	\N	f
1188	2007-12-09	4	\N	\N	\N	\N	\N	f
1189	2007-12-03	6	\N	\N	\N	\N	\N	f
1190	2007-12-04	6	\N	\N	\N	\N	\N	f
1191	2007-12-05	6	\N	\N	\N	\N	\N	f
1192	2007-12-06	6	\N	\N	\N	\N	\N	f
1193	2007-12-07	6	\N	\N	\N	\N	\N	f
1194	2007-12-08	6	\N	\N	\N	\N	\N	f
1195	2007-12-09	6	\N	\N	\N	\N	\N	f
1196	2007-12-03	5	\N	\N	\N	\N	\N	f
1197	2007-12-04	5	\N	\N	\N	\N	\N	f
1198	2007-12-05	5	\N	\N	\N	\N	\N	f
1199	2007-12-06	5	\N	\N	\N	\N	\N	f
1200	2007-12-07	5	\N	\N	\N	\N	\N	f
1201	2007-12-08	5	\N	\N	\N	\N	\N	f
1202	2007-12-09	5	\N	\N	\N	\N	\N	f
1203	2007-12-03	2	\N	\N	\N	\N	\N	f
1204	2007-12-04	2	\N	\N	\N	\N	\N	f
1205	2007-12-05	2	\N	\N	\N	\N	\N	f
1206	2007-12-06	2	\N	\N	\N	\N	\N	f
1207	2007-12-07	2	\N	\N	\N	\N	\N	f
1208	2007-12-08	2	\N	\N	\N	\N	\N	f
1209	2007-12-09	2	\N	\N	\N	\N	\N	f
1210	2007-11-26	1	\N	\N	\N	\N	\N	f
1211	2007-11-27	1	\N	\N	\N	\N	\N	f
1212	2007-11-28	1	\N	\N	\N	\N	\N	f
1213	2007-11-29	1	\N	\N	\N	\N	\N	f
1214	2007-11-30	1	\N	\N	\N	\N	\N	f
1215	2007-12-01	1	\N	\N	\N	\N	\N	f
1216	2007-12-02	1	\N	\N	\N	\N	\N	f
1217	2007-11-26	4	\N	\N	\N	\N	\N	f
1218	2007-11-27	4	\N	\N	\N	\N	\N	f
1219	2007-11-28	4	\N	\N	\N	\N	\N	f
1220	2007-11-29	4	\N	\N	\N	\N	\N	f
1221	2007-11-30	4	\N	\N	\N	\N	\N	f
1222	2007-12-01	4	\N	\N	\N	\N	\N	f
1223	2007-12-02	4	\N	\N	\N	\N	\N	f
1224	2007-11-26	6	\N	\N	\N	\N	\N	f
1225	2007-11-27	6	\N	\N	\N	\N	\N	f
1226	2007-11-28	6	\N	\N	\N	\N	\N	f
1227	2007-11-29	6	\N	\N	\N	\N	\N	f
1228	2007-11-30	6	\N	\N	\N	\N	\N	f
1229	2007-12-01	6	\N	\N	\N	\N	\N	f
1230	2007-12-02	6	\N	\N	\N	\N	\N	f
1231	2007-11-26	5	\N	\N	\N	\N	\N	f
1232	2007-11-27	5	\N	\N	\N	\N	\N	f
1233	2007-11-28	5	\N	\N	\N	\N	\N	f
1234	2007-11-29	5	\N	\N	\N	\N	\N	f
1235	2007-11-30	5	\N	\N	\N	\N	\N	f
1236	2007-12-01	5	\N	\N	\N	\N	\N	f
1237	2007-12-02	5	\N	\N	\N	\N	\N	f
1238	2007-11-26	2	\N	\N	\N	\N	\N	f
1239	2007-11-27	2	\N	\N	\N	\N	\N	f
1240	2007-11-28	2	\N	\N	\N	\N	\N	f
1241	2007-11-29	2	\N	\N	\N	\N	\N	f
1242	2007-11-30	2	\N	\N	\N	\N	\N	f
1243	2007-12-01	2	\N	\N	\N	\N	\N	f
1244	2007-12-02	2	\N	\N	\N	\N	\N	f
\.


--
-- Data for Name: dalbaran; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dalbaran (iddalbaran, conceptdalbaran, proporciondalbaran, idalbaran) FROM stdin;
\.


--
-- Data for Name: dalbaranp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dalbaranp (iddalbaranp, conceptdalbaranp, proporciondalbaranp, idalbaranp) FROM stdin;
\.


--
-- Data for Name: dfactura; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dfactura (iddfactura, conceptdfactura, proporciondfactura, idfactura) FROM stdin;
\.


--
-- Data for Name: dfacturap; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dfacturap (iddfacturap, conceptdfacturap, proporciondfacturap, idfacturap) FROM stdin;
\.


--
-- Data for Name: division; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY division (iddivision, descdivision, contactosdivisioon, comentdivision, teldivision, faxdivision, maildivision, idproveedor, inactivodivision) FROM stdin;
1	division 1 de mateu	\N	\N	\N	\N	\N	1	\N
2	division 2 de mateu	\N	\N	\N	\N	\N	1	\N
3	division 1 de cristina	\N	\N	\N	\N	\N	2	\N
4	division 2 de cristina	\N	\N	\N	\N	\N	2	\N
5	division 3 de cristina	\N	\N	\N	\N	\N	2	\N
6	division 1 de Torrijas	\N	\N	\N	\N	\N	4	\N
\.


--
-- Data for Name: dpedidocliente; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dpedidocliente (iddpedidocliente, conceptdpedidocliente, proporciondpedidocliente, idpedidocliente) FROM stdin;
\.


--
-- Data for Name: dpedidoproveedor; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dpedidoproveedor (iddpedidoproveedor, conceptdpedidoproveedor, proporciondpedidoproveedor, idpedidoproveedor) FROM stdin;
\.


--
-- Data for Name: dpresupuesto; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY dpresupuesto (iddpresupuesto, conceptdpresupuesto, proporciondpresupuesto, idpresupuesto) FROM stdin;
\.


--
-- Data for Name: estado_evento; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY estado_evento (idestado_evento, nomestado_evento) FROM stdin;
1	Pendiente
\.


--
-- Data for Name: evento; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY evento (idevento, idcliente, idtipo_evento, idestado_evento, fechaevento, subjectevento) FROM stdin;
3	136	1	1	2007-06-04 15:31:00	Toma Resumen majo majete.
4	135	1	1	2007-05-15 12:30:00	Y por si uno fuera poco ...
5	98	1	1	2007-08-09 19:42:24.738505	esto es un evento
\.


--
-- Data for Name: factura; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY factura (idfactura, codigoserie_factura, numfactura, reffactura, ffactura, descfactura, idalmacen, contactfactura, telfactura, comentfactura, procesadafactura, idusuari, idcliente, idforma_pago, idtrabajador, totalfactura, bimpfactura, impfactura, idasientofactura) FROM stdin;
512	DD	56	SGPNZS	2007-03-20	MAT	1	Asociacion Iglues		(ALBARAN: Num 74Ref: KPNBCTFecha: 20/03/2007)\n(ALBARAN: Num 51Ref: [MJXDTFecha: 06/03/2007)\n(ALBARAN: Num 53Ref: EUWLWNFecha: 22/02/2007)\n(ALBARAN: Num 75Ref: LPPUZKFecha: 20/03/2007)\n(ALBARAN: Num 90Ref: GBOFBFFecha: 23/03/2007)\n	t	\N	10	6	\N	527.66	454.88	72.78	1273
568	DD	107	LRMBBX	2007-05-09	ACCESORIOS	1	Asociacion Iglues		\N	t	\N	23	1	\N	146.11	125.96	20.15	1167
457	DD	1	VBDXNN	2007-01-15	IMPRESORA	1	Asociacion Iglues		\N	t	\N	23	1	\N	1204.66	1038.50	166.16	1168
461	DD	4	SIWRWI	2007-01-30	MANT	1	Asociacion Iglues		\N	t	\N	85	1	\N	46.63	40.20	6.43	1169
464	DD	7	MYVGGU	2007-01-31	CABLES SEGURIDAD	1	Asociacion Iglues		\N	t	\N	108	1	\N	4401.50	3794.40	607.10	1171
463	DD	6	R[WFFL	2007-01-31	MANT	1	Asociacion Iglues		(ALBARAN: Num 16Ref: HZIKYPFecha: 20/12/2006)\n	t	\N	103	1	\N	1790.67	1543.68	246.98	1170
469	DD	12	XLTDFR	2007-01-31	MANT	1	Asociacion Iglues		\N	t	\N	26	6	\N	512.95	442.20	70.75	1155
460	DD	3	YZOBMY	2007-01-25	TINTAS	1	Asociacion Iglues		\N	t	\N	91	1	\N	50.58	43.60	6.98	1185
497	DD	41	XLOUJB	2007-02-27	NAUTICA VERMELL	1	Asociacion Iglues		\N	f	\N	16	7	\N	2797.92	2412.00	385.92	1186
503	DD	47	NGIXEL	2007-03-06	CABLES	1	Asociacion Iglues		\N	t	\N	108	7	\N	323.12	278.55	44.57	1187
502	DD	46	RFMSHL	2007-03-06	TINTAS	1	Asociacion Iglues		\N	t	\N	91	1	\N	64.44	55.55	8.88	1188
506	DD	50	JIZCRY	2007-03-08	tinta	1	Asociacion Iglues		\N	t	\N	123	1	\N	14.23	12.27	1.96	1189
500	DD	44	WKNSLS	2007-02-27	TFT + SOTF 2	1	Asociacion Iglues		\N	t	\N	10	6	\N	512.35	441.68	70.67	1190
495	DD	39	SWELET	2007-02-22	VARIOS	1	Asociacion Iglues		(ALBARAN: Num 18Ref: DF[TMWFecha: 09/05/2006)\n(ALBARAN: Num 26Ref: ELDBXHFecha: 01/02/2007)\n(ALBARAN: Num 17Ref: VQLCKFFecha: 08/03/2006)\n	t	\N	16	6	\N	279.79	241.20	38.59	1192
494	DD	38	XHKBSU	2007-02-22	MANT	1	Asociacion Iglues		\N	t	\N	57	6	\N	282.90	243.88	39.01	1193
501	DD	45	[MJXDT	2007-02-27	TFT + SOFT 1	1	Asociacion Iglues		\N	t	\N	10	6	\N	612.65	528.15	84.51	1194
498	DD	42	BWRKUG	2007-02-27	ORDENADOR 2	1	Asociacion Iglues		\N	t	\N	10	6	\N	705.11	607.85	97.26	1195
499	DD	43	BHMMAZ	2007-02-27	ORDENADOR 1	1	Asociacion Iglues		\N	t	\N	10	1	\N	705.11	607.85	97.26	1196
491	DD	35	XOYIET	2007-02-22	MAT	1	Asociacion Iglues		(ALBARAN: Num 34Ref: XHXIXKFecha: 07/02/2007)\n	t	\N	10	1	\N	768.29	662.32	105.98	1156
483	DD	27	KBUUFV	2007-02-19	MAT	1	Asociacion Iglues		(ALBARAN: Num 31Ref: IWQZDHFecha: 19/02/2007)\n(ALBARAN: Num 32Ref: DZTCRVFecha: 19/02/2007)\n	t	\N	103	2	\N	675.93	582.70	93.23	1245
493	DD	37	MFROGY	2007-02-22	MANT	1	Asociacion Iglues		\N	t	\N	26	1	\N	512.95	442.20	70.75	1246
513	DD	57	UEEZVL	2007-03-20	AVG+RED	1	Asociacion Iglues		\N	t	\N	91	6	\N	165.39	142.58	22.82	1197
505	DD	49	GFUNYR	2007-03-08	MANT	1	Asociacion Iglues		\N	t	\N	97	1	\N	124.35	107.20	17.15	1198
509	DD	53	AXDFEF	2007-03-14	HORAS JAUME I CATI	1	Asociacion Iglues		\N	t	\N	10	6	\N	217.62	187.60	30.02	1199
508	DD	52	WHRNDO	2007-03-14	MAT CATI i JAMUE	1	Asociacion Iglues		(ALBARAN: Num 55Ref: JGKYCJFecha: 13/03/2007)\n(ALBARAN: Num 56Ref: JRHZGMFecha: 13/03/2007)\n	t	\N	10	6	\N	250.72	216.14	34.59	1200
511	DD	55	PNWNYA	2007-03-20	MAT	1	Asociacion Iglues		(ALBARAN: Num 30Ref: YUEQDSFecha: 15/02/2007)\n(ALBARAN: Num 68Ref: DPXJRNFecha: 15/03/2007)\n(ALBARAN: Num 64Ref: DPXJRNFecha: 15/03/2007)\n(ALBARAN: Num 62Ref: DGPEBMFecha: 15/03/2007)\n	t	\N	103	4	\N	487.08	419.90	67.18	1201
510	DD	54	KBJKOH	2007-03-20	MANT	1	Asociacion Iglues		\N	t	\N	103	4	\N	895.33	771.84	123.49	1202
530	DD	74	ZRDELL	2007-03-29	TONERS	1	Asociacion Iglues		(ALBARAN: Num 95Ref: SDNJBTFecha: 29/03/2007)\n	t	\N	10	6	\N	282.09	243.18	38.91	1247
529	DD	73	COAQPM	2007-03-29	ORDENADOR	1	Asociacion Iglues		(ALBARAN: Num 96Ref: IXBPGPFecha: 29/03/2007)\n	t	\N	10	6	\N	753.88	649.90	103.98	1248
504	DD	48	SKAKPN	2007-03-08	MANT	1	Asociacion Iglues		\N	t	\N	85	1	\N	46.63	40.20	6.43	1249
517	DD	61	VDRMHJ2	2007-03-23	IMPRESORAS	1	Asociacion Iglues		\N	t	\N	59	1	\N	435.17	375.15	60.03	1250
515	DD	59	QENLSH	2007-03-23	IMPRESORAS	1	Asociacion Iglues		\N	t	\N	59	1	\N	435.17	375.15	60.03	1157
528	DD	72	KZGVJG	2007-03-27	HOST	1	Asociacion Iglues		\N	t	\N	49	1	\N	69.95	60.30	9.65	1158
527	DD	71	WVYAUN	2007-03-27	HOST	1	Asociacion Iglues		\N	t	\N	16	6	\N	116.58	100.50	16.08	1159
520	DD	64	ESWOMB	2007-03-27	MANT	1	Asociacion Iglues		\N	t	\N	26	6	\N	512.95	442.20	70.75	1160
514	DD	58	RJGEKI	2007-03-20	MANT	1	Asociacion Iglues		\N	t	\N	13	6	\N	186.53	160.80	25.73	1161
531	DD	75	YQPCIE	2007-03-30	CABLE SATA/IDE	1	Asociacion Iglues		\N	t	\N	125	1	\N	45.56	39.28	6.28	1203
507	DD	51	IVXVYD	2007-03-13	CABLE	1	Asociacion Iglues		\N	t	\N	108	7	\N	45.53	39.25	6.28	1204
533	DD	77	XQBOOR	2007-04-03	IMRESORA	1	Asociacion Iglues		\N	t	\N	93	1	\N	422.33	364.08	58.25	1205
535	DD	79	VYBAMY	2007-04-03	MANT	1	Asociacion Iglues		\N	t	\N	97	1	\N	124.35	107.20	17.15	1206
536	DD	80	EIY[ED	2007-04-03	MANT	1	Asociacion Iglues		\N	t	\N	85	1	\N	46.63	40.20	6.43	1207
532	DD	76	QYIBYU	2007-04-09	TPV	1	Asociacion Iglues		\N	t	\N	93	1	\N	284.55	245.30	39.25	1208
534	DD	78	[VYFS[	2007-04-03	PROGRAMACION	1	Asociacion Iglues		\N	t	\N	93	1	\N	3108.80	2680.00	428.80	1209
540	DD	84	CNJXJO	2007-04-23	ABACCINO	1	Asociacion Iglues		\N	t	\N	128	2	\N	1849.74	1594.60	255.14	1210
537	DD	81	EFEGZF	2007-04-17	TINTAS	1	Asociacion Iglues		\N	t	\N	91	1	\N	68.22	58.81	9.41	1211
458	DD	2	GQGKTW	2007-01-15	BROTHER	1	Asociacion Iglues		\N	t	\N	91	1	\N	556.00	479.31	76.70	1251
542	DD	86	YTWDIY	2007-04-23	MANT	1	Asociacion Iglues		\N	t	\N	57	6	\N	282.90	243.88	39.01	1252
545	DD	89	UAWJDP	2007-04-23	MANT	1	Asociacion Iglues		\N	t	\N	50	6	\N	62.18	53.60	8.58	1253
541	DD	85	IVSGDN	2007-04-23	CABLES	1	Asociacion Iglues		\N	f	\N	124	1	\N	367.38	316.71	50.67	1162
539	DD	83	FGTPBN	2007-04-20	MANT	1	Asociacion Iglues		\N	t	\N	13	6	\N	186.53	160.80	25.73	1254
549	DD	90	CLL[ZS	2007-04-23	PORTATIL	1	Asociacion Iglues		\N	t	\N	54	1	\N	652.85	562.80	90.05	1212
543	DD	87	OIWXYB	2007-04-23	MANT	1	Asociacion Iglues		\N	t	\N	26	6	\N	590.67	509.20	81.47	1213
524	DD	68	JXKSHV	2007-03-27	HOST	1	Asociacion Iglues		\N	t	\N	99	6	\N	139.90	120.60	19.30	1214
550	DD	91	YRPKXT	2007-04-24	MAT	1	Asociacion Iglues		\N	f	\N	103	2	\N	498.07	429.37	68.69	1215
551	DD	92	NUYUXO	2007-04-24	MAT	1	Asociacion Iglues		\N	t	\N	10	6	\N	563.01	485.35	77.65	1216
538	DD	82	QNAZRE	2007-04-20	MANT	1	Asociacion Iglues		\N	t	\N	103	4	\N	895.33	771.84	123.49	1217
487	DD	31	TJEQQB	2007-02-22	ORDENADOR	1	Asociacion Iglues		\N	t	\N	91	1	\N	735.47	634.03	101.44	1218
486	DD	30	PTHRMX	2007-02-22	EPSON	1	Asociacion Iglues		(ALBARAN: Num 37Ref: NJFYJYFecha: 22/02/2007)\n	t	\N	91	1	\N	97.38	83.95	13.44	1219
554	DD	94	QBVUMK	2007-04-26	APA MADRE ALBERTA	1	Asociacion Iglues		\N	t	\N	131	1	\N	777.20	670.00	107.20	1220
562	DD	101	DOOEWQ	2007-05-08	RENOVACION .COM	1	Asociacion Iglues		\N	t	\N	41	6	\N	46.63	40.20	6.43	1255
573	DD	112	DZHYWZ	2007-05-18	MANT	1	Asociacion Iglues		\N	f	\N	103	4	\N	895.33	771.84	123.49	1256
576	DD	115	HGMRII	2007-05-25	TONER	1	Asociacion Iglues		\N	t	\N	28	1	\N	135.67	116.96	18.71	1257
577	DD	116	IFREQT	2007-05-25	MANT	1	Asociacion Iglues		\N	t	\N	85	1	\N	46.63	40.20	6.43	1258
488	DD	32	HCIVYT	2007-02-22	MANT	1	Asociacion Iglues		(ALBARAN: Num 42Ref: TLUVJWFecha: 16/02/2007)\n	t	\N	13	6	\N	319.29	275.25	44.04	1259
564	DD	103	VIZBOP	2007-05-08	HOSTING	1	Asociacion Iglues		\N	f	\N	131	1	\N	317.10	273.36	43.74	1260
489	DD	33	GITZDY	2007-02-22	MANT	1	Asociacion Iglues		\N	t	\N	97	1	\N	124.35	107.20	17.15	1221
490	DD	34	IQSXKB	2007-02-22	MANT	1	Asociacion Iglues		\N	t	\N	85	1	\N	46.63	40.20	6.43	1222
567	DD	106	UNIIYN	2007-05-08	LIMPIEZA	1	Asociacion Iglues		\N	t	\N	23	1	\N	84.61	72.94	11.67	1223
572	DD	111	KUHKXO	2007-05-08	MANT BGES	1	Asociacion Iglues		\N	t	\N	135	1	\N	186.53	160.80	25.73	1224
566	DD	105	XWZFGT	2007-05-08	MANT	1	Asociacion Iglues		\N	t	\N	97	1	\N	124.35	107.20	17.15	1225
565	DD	104	SZYMUR	2007-05-08	MANT	1	Asociacion Iglues		(ALBARAN: Num 138Ref: DXSHGHFecha: 02/05/2007)\n(ALBARAN: Num 97Ref: T[SFDYFecha: 28/03/2007)\n	t	\N	85	1	\N	66.11	56.99	9.12	1226
557	DD	96	DOCKNO	2007-05-04	INFOPOLLENSA.NET	1	Asociacion Iglues		\N	f	\N	16	1	\N	46.63	40.20	6.43	1227
558	DD	97	BBEQLF	2007-05-04	MONTAJE RED	1	Asociacion Iglues		\N	f	\N	103	4	\N	174.21	150.18	24.03	1228
569	DD	108	FBMTJF	2007-05-09	HOSTING	1	Asociacion Iglues		\N	f	\N	103	4	\N	559.58	482.40	77.18	1229
492	DD	36	LVVDTM	2007-02-22	MAT	1	Asociacion Iglues		(ALBARAN: Num 39Ref: DQLKIYFecha: 01/01/2007)\n(ALBARAN: Num 38Ref: AOGHMXFecha: 08/02/2007)\n	t	\N	10	6	\N	464.74	400.64	64.10	1261
570	DD	109	WRERUC	2007-05-09	VPN	1	Asociacion Iglues		\N	f	\N	103	2	\N	279.79	241.20	38.59	1262
574	DD	113	VCDYLI	2007-05-18	MAT	1	Asociacion Iglues		\N	f	\N	103	4	\N	520.79	448.96	71.84	1230
575	DD	114	MPPRMW	2007-05-18	MANT	1	Asociacion Iglues		\N	f	\N	13	6	\N	186.53	160.80	25.73	1231
579	DD	118	XFJKKO	2007-05-25	MANT	1	Asociacion Iglues		\N	f	\N	57	6	\N	282.90	243.88	39.01	1232
578	DD	117	RUZEYJ	2007-05-25	MANT	1	Asociacion Iglues		\N	f	\N	26	6	\N	590.67	509.20	81.47	1233
580	DD	119	PLAQLL	2007-05-25	MANT	1	Asociacion Iglues		\N	f	\N	50	6	\N	62.18	53.60	8.58	1234
581	DD	120	NNZNUN	2007-05-25	PROGRAMACION	1	Asociacion Iglues		\N	t	\N	93	1	\N	2331.60	2010.00	321.60	1235
582	DD	121	RTLTJO2	2007-05-25	PORTATIL2	1	Asociacion Iglues		\N	f	\N	54	1	\N	652.85	562.80	90.05	1236
522	DD	66	PVEZPK	2007-03-27	HOST	1	Asociacion Iglues		(ALBARAN: Num 54Ref: BRMJZWFecha: 21/02/2007)\n	t	\N	88	6	\N	186.53	160.80	25.73	1237
519	DD	63	ECEHFZ	2007-03-27	MAT	1	Asociacion Iglues		\N	t	\N	10	6	\N	293.78	253.26	40.52	1263
516	DD	60	QENLSH1	2007-03-23	IMPRESORAS	1	Asociacion Iglues		\N	t	\N	59	1	\N	778.70	671.29	107.41	1264
518	DD	62	HJKUGG	2007-03-27	MAT	1	Asociacion Iglues		(ALBARAN: Num 76Ref: XGOQWPFecha: 20/03/2007)\n	t	\N	10	6	\N	567.30	489.05	78.26	1265
526	DD	70	ZCPBFD	2007-03-27	HOST	1	Asociacion Iglues		\N	t	\N	41	4	\N	139.90	120.60	19.30	1240
521	DD	65	DQCDPV	2007-03-27	MANT	1	Asociacion Iglues		(ALBARAN: Num 83Ref: IPUTDFFecha: 20/03/2007)\n(ALBARAN: Num 88Ref: NAPARMFecha: 23/03/2007)\n	t	\N	57	6	\N	503.34	433.91	69.42	1241
523	DD	67	FTLK[Q	2007-03-27	HOST	1	Asociacion Iglues		\N	t	\N	98	6	\N	139.90	120.60	19.30	1242
525	DD	69	CMNXZZ	2007-03-27	MANT	1	Asociacion Iglues		\N	t	\N	50	6	\N	62.18	53.60	8.58	1243
544	DD	88	WTYNHH	2007-04-23	TINTAS	1	Asociacion Iglues		(ALBARAN: Num 94Ref: OGMEGXFecha: 28/03/2007)\n(ALBARAN: Num 109Ref: IPBLYUFecha: 20/04/2007)\n	t	\N	91	1	\N	117.23	101.06	16.16	1244
553	DD	93	FSTHMK	2007-04-25	LLABRES	1	Asociacion Iglues		\N	f	\N	16	\N	\N	777.20	670.00	107.20	1266
556	DD	95	INLXZA	2007-05-03	HOSTI	1	Asociacion Iglues		\N	t	\N	132	1	\N	559.58	482.40	77.18	1267
571	DD	110	GWCFSO	2007-05-09	TINTAS	1	Asociacion Iglues		\N	t	\N	26	6	\N	679.17	585.49	93.69	1163
561	DD	100	CCOBCG	2007-05-08	SERVIDOR PEPMA	1	Asociacion Iglues		\N	f	\N	133	1	\N	233.16	201.00	32.16	1268
585	DD	123	KX[DTY	2007-05-25	TINTAS	1	Asociacion Iglues		(ALBARAN: Num 190Ref: OWZYDKFecha: 15/05/2007)\n(ALBARAN: Num 203Ref: IMNDGIFecha: 23/05/2007)\n	t	\N	91	1	\N	122.53	105.63	16.90	1269
586	DD	124	YEFLON	2007-05-25	TINTAS	1	Asociacion Iglues		\N	t	\N	126	1	\N	45.87	39.54	6.33	1270
559	DD	98	UDRXOU	2007-05-07	\N	1	Asociacion Iglues		\N	t	\N	126	1	\N	45.54	39.26	6.28	1271
496	DD	40	LRFHLP	2007-02-23	VISITAS	1	Asociacion Iglues		(ALBARAN: Num 23Ref: BMAHIEFecha: 03/11/2006)\n(ALBARAN: Num 40Ref: KMSMQNFecha: 17/01/2007)\n(ALBARAN: Num 41Ref: IDPVMKFecha: 13/02/2007)\n(ALBARAN: Num 22Ref: CSLKGXFecha: 02/12/2006)\n	f	\N	64	1	\N	177.59	153.10	24.50	1164
590	DD	128	UNNTKK	2007-07-11	\N	1	Asociacion Iglues		\N	f	\N	138	1	\N	1678.75	1447.20	231.56	1272
596	DD	129	AHXVHE	2007-09-14	asdf	1	Asociacion Iglues		\N	f	\N	136	1	\N	15.54	13.40	2.14	1165
583	DD	122	QXCIHW	2007-05-25	MAT	1	Asociacion Iglues		None\n	f	\N	9	1	\N	107.65	92.80	14.85	1166
485	DD	29	LDBTEN	2007-02-22	MAT	1	Asociacion Iglues		(ALBARAN: Num 36Ref: WKQREAFecha: 31/01/2007)\n(ALBARAN: Num 35Ref: BFZBCBFecha: 05/02/2007)\n	t	\N	91	1	\N	385.31	332.16	53.15	1191
560	DD	99	CJIKTG	2007-05-08	HOST	1	Asociacion Iglues		(ALBARAN: Num 145Ref: KIOYPZFecha: 08/05/2007)\n(ALBARAN: Num 146Ref: XLNCRDFecha: 08/05/2007)\n	f	\N	44	1	\N	512.95	442.20	70.75	1238
563	DD	102	VLVVBH	2007-05-08	MANT SERVIDOR	1	Asociacion Iglues		\N	f	\N	19	2	\N	777.20	670.00	107.20	1239
462	DD	5	YIKBD[	2007-01-30	MANT	1	Asociacion Iglues		(ALBARAN: Num 20Ref: EWCHWXFecha: 20/12/2006)\n	t	\N	97	1	\N	346.33	298.56	47.77	1274
472	DD	15	HGOYZQ	2007-01-31	HOST	1	Asociacion Iglues		\N	t	\N	99	\N	\N	46.63	40.20	6.43	1172
475	DD	18	XMTMXG	2007-01-31	HOST	1	Asociacion Iglues		\N	t	\N	49	1	\N	69.95	60.30	9.65	1173
470	DD	13	WEPLNP	2007-01-31	MAT	1	Asociacion Iglues		(ALBARAN: Num 24Ref: QGGYJVFecha: 15/05/2006)\n(ALBARAN: Num 8Ref: QTJHLIFecha: 17/01/2007)\n	t	\N	95	1	\N	213.74	184.26	29.48	1174
474	DD	17	ONKHQP	2007-01-31	HOST	1	Asociacion Iglues		\N	f	\N	32	1	\N	139.90	120.60	19.30	1175
473	DD	16	OJEDQZ	2007-01-31	HOST	1	Asociacion Iglues		\N	t	\N	98	1	\N	279.79	241.20	38.59	1176
465	DD	8	UOYZYI	2007-01-31	MANT	1	Asociacion Iglues		(ALBARAN: Num 12Ref: TZUAONFecha: 02/01/2007)\n	t	\N	63	6	\N	1405.70	1211.81	193.89	1177
471	DD	14	SLRASN	2007-01-31	MANT	1	Asociacion Iglues		\N	t	\N	57	1	\N	282.90	243.88	39.01	1178
476	DD	19	BPRRQJ	2007-01-31	MANT	1	Asociacion Iglues		\N	t	\N	50	6	\N	62.18	53.60	8.58	1179
479	DD	23	LQIDBZ	2007-02-02	EQUIPOS	1	Asociacion Iglues		\N	t	\N	126	1	\N	1355.44	1168.48	186.96	1275
480	DD	24	[KJZTL	2007-02-02	PANDA	1	Asociacion Iglues		\N	f	\N	84	1	\N	94.13	81.15	12.98	1276
482	DD	26	VVSOHG	2007-02-13	CABLES	1	Asociacion Iglues		\N	t	\N	108	7	\N	107.71	92.85	14.86	1277
477	DD	20	RKSCOE	2007-02-02	MAT	1	Asociacion Iglues		(ALBARAN: Num 5Ref: TVUVLNFecha: 15/01/2007)\n	t	\N	8	1	\N	2009.57	1732.39	277.18	1180
478	DD	21	YKQTLE	2007-02-02	MAT	1	Asociacion Iglues		(ALBARAN: Num 13Ref: WVQHWYFecha: 24/10/2006)\n	t	\N	8	1	\N	310.88	268.00	42.88	1181
481	DD	25	XWEVQD	2007-02-12	MAT	1	Asociacion Iglues		\N	t	\N	120	1	\N	41.88	36.10	5.78	1182
484	DD	28	MGKWYW	2007-02-19	MANT	1	Asociacion Iglues		\N	t	\N	103	2	\N	895.33	771.84	123.49	1183
466	DD	9	YCIHXH	2007-01-31	MANT	1	Asociacion Iglues		(ALBARAN: Num 10Ref: ZTBFVEFecha: 10/01/2007)\n(ALBARAN: Num 15Ref: GYC[VAFecha: 12/12/2006)\n	t	\N	13	6	\N	427.46	368.50	58.96	1184
467	DD	10	OARTCQ	2007-01-31	MAT	1	Asociacion Iglues		(ALBARAN: Num 1Ref: QTUHYJFecha: 10/01/2007)\n(ALBARAN: Num 3Ref: XXMWRQFecha: 10/01/2007)\n(ALBARAN: Num 2Ref: KPOJTDFecha: 10/01/2007)\n	t	\N	10	1	\N	814.51	702.16	112.34	1278
468	DD	11	KPPHUK	2007-01-31	MAT	1	Asociacion Iglues		(ALBARAN: Num 11Ref: BHZGVXFecha: 29/01/2007)\n(ALBARAN: Num 14Ref: YIMGBAFecha: 19/12/2006)\n	t	\N	26	6	\N	408.44	352.10	56.34	1279
587	DD	125	KCWFKB	2007-05-28	MAT	1	Asociacion Iglues		(ALBARAN: Num 200Ref: [FCGSOFecha: 21/05/2007)\n(ALBARAN: Num 201Ref: JZEJVNFecha: 22/05/2007)\n(ALBARAN: Num 173Ref: CIWUGPFecha: 02/05/2007)\n	f	\N	26	6	\N	2144.70	1848.88	295.82	1280
\.


--
-- Data for Name: facturap; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY facturap (idfacturap, numfacturap, reffacturap, ffacturap, descfacturap, contactfacturap, telfacturap, comentfacturap, procesadafacturap, idusuari, idproveedor, idforma_pago, idtrabajador, totalfacturap, bimpfacturap, impfacturap, idasientofacturap) FROM stdin;
223	004	OZDCTQ	2007-01-18	TARJETAS CONETXIA	\N	\N	\N	f	\N	33	1	\N	\N	215.55	34.49	1281
220	075-7872324686	C[RDSC	2007-01-16	Billetes viaje a madrid	\N	\N	\N	f	\N	29	1	\N	54.59	47.06	7.54	1282
224	07/00475	XFHYRL	2007-02-07	TINTA DIALMA	\N	\N	\N	f	\N	7	6	\N	412.88	355.93	56.97	1283
216	99959	VSHKXW	2007-01-11	TIENDA	\N	\N	\N	f	\N	5	6	\N	\N	32.33	5.18	1284
225	00717	TKGFJV	2007-02-27	TAMBOR OKI	\N	\N	\N	f	\N	7	6	\N	66.91	57.68	9.23	1285
227	102266	DMJYLP	2007-02-22	DIALMA	\N	\N	\N	f	\N	5	6	\N	1489.25	1283.84	205.41	1286
229	00583	UVRHKP	2007-02-15	AZUL YATCHS	\N	\N	\N	t	\N	7	6	\N	79.26	68.33	10.93	1287
230	101360	TBSQGT	2007-02-06	FED. BALEAR TIRO	\N	\N	\N	t	\N	5	6	\N	464.65	400.56	64.09	1288
231	101483	XZINVQ	2007-02-07	MAT	\N	\N	\N	t	\N	5	6	\N	576.15	496.68	79.47	1289
232	101049	MYCVWN	2007-01-31	MAT	\N	\N	\N	t	\N	5	6	\N	2559.93	2206.84	353.10	1290
233	101359	LGTMEC	2007-02-06	GIB	\N	\N	\N	t	\N	5	6	\N	3.54	3.05	0.49	1291
234	GIB	GYXXFH	2007-02-02	GIB	\N	\N	\N	t	\N	5	6	\N	198.42	171.05	27.36	1292
237	101892	MYIEOO	2007-02-15	TIENDA	\N	\N	\N	t	\N	5	6	\N	20.81	17.94	2.87	1293
238	100689	XLNFYI	2007-01-24	MAT	\N	\N	\N	t	\N	5	6	\N	192.03	165.54	26.49	1294
239	A40307549	VLGXGD	2007-02-02	ADMAS BALEARES	\N	\N	\N	t	\N	8	6	\N	49.08	42.31	6.77	1295
240	0710	BTURJT	2007-01-08	dialma	\N	\N	\N	t	\N	7	1	\N	200.91	173.20	27.71	1296
241	0726	WSNBXT	2007-01-09	BROTHER DIALMA	\N	\N	\N	t	\N	7	6	\N	407.62	351.40	56.23	1297
242	100560	KRICCN	2007-01-22	TIENDA	\N	\N	\N	t	\N	5	6	\N	80.96	69.79	11.17	1298
243	321393	EJLBGQ	2007-01-23	ONO	\N	\N	\N	t	\N	17	6	\N	135.27	116.61	18.66	1299
244	102029	ISOPVD	2007-02-16	MIGUEL SOLER	\N	\N	\N	t	\N	5	6	\N	407.22	351.05	56.17	1300
245	778021	MKMQTS	2007-02-23	ONO	\N	\N	\N	t	\N	17	6	\N	156.76	135.14	21.62	1301
246	102870	VIPUQY	2007-03-06	MAT	\N	\N	\N	f	\N	5	6	\N	296.26	255.40	40.86	1302
247	769	QSCZIJ	2007-03-06	SPORT INCA	\N	\N	\N	f	\N	7	6	\N	154.74	133.40	21.34	1303
248	103279	PUFJNS	2007-03-13	MAT	\N	\N	\N	f	\N	5	6	\N	36.23	31.23	4.99	1304
250	2007001	OVMUKG	2007-02-02	CERTIFICADO FINAL DE OBRA	\N	\N	\N	t	\N	37	\N	\N	606.00	600.00	96.00	1305
219	008922	YTGOLI	2007-01-11	ACOMAN PYLSA	\N	\N	\N	f	\N	11	1	\N	1180.47	1017.65	162.82	1306
253	07/01394	BYFKIO	2007-04-27	DIALMA	\N	\N	\N	t	\N	7	6	\N	363.08	313.00	50.08	1307
217	07/00111	TKSLPF	2007-01-12	\N	\N	\N	\N	t	\N	7	6	\N	317.45	273.66	43.78	1308
252	07/0173	TXBSBZ	2007-05-22	DIALMA	\N	\N	\N	f	\N	7	6	\N	132.27	114.03	18.24	1309
257	01567	UXVMXB	2007-05-10	DIALMA	\N	\N	\N	f	\N	7	6	\N	616.17	531.18	84.99	1310
258	1719	UQYVIZ	2007-05-23	EUGENIO	\N	\N	\N	f	\N	7	6	\N	72.89	62.84	10.05	1311
218	100270	POVHXI	2007-01-17	TIENDA	\N	\N	\N	f	\N	5	6	\N	42.76	36.86	5.90	1312
259	1187	VJXZTF	2007-04-10	DIALMA	\N	\N	\N	t	\N	7	6	\N	162.11	139.75	22.36	1313
260	1317	ORDNOQ	2007-04-21	DIALMA	\N	\N	\N	t	\N	7	6	\N	316.16	272.55	43.61	1314
262	1448	OYAIKY	2007-05-02	DIALMA	\N	\N	\N	t	\N	7	6	\N	66.91	57.68	9.23	1315
263	07/01630	JEOHZW	2007-05-22	CONETXIA	\N	\N	\N	f	\N	21	6	\N	92.94	80.12	12.82	1316
251	105920	[WCFQE	2007-05-02	\N	\N	\N	\N	f	\N	5	4	\N	220.98	190.50	30.47	1317
255	07/01430	YX[YNK	2007-04-30	DIALMA	\N	\N	\N	t	\N	7	6	\N	187.12	161.31	25.81	1318
226	102265	ZHMULP	2007-02-22	MAT	\N	\N	\N	f	\N	5	6	\N	413.35	356.34	57.02	1319
249	103405	XRQMGX	2007-03-15	TFT GIB	\N	\N	\N	f	\N	5	6	\N	214.28	184.72	29.56	1320
\.


--
-- Data for Name: familia; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY familia (idfamilia, codigofamilia, nombrefamilia, descfamilia, padrefamilia, codigocompletofamilia, productofisicofamilia) FROM stdin;
19	01	Servicios Particulares		\N	01	t
84	06	Redes 		\N	06	t
21	02	Servicios a Empresas		\N	02	t
98	08	Consumibles		\N	08	t
105	09	Accesorios y Cable		\N	09	t
159	11	TPV		\N	11	t
64	04	Perifericos		\N	04	t
77	05	Dispositivos Autonomos		\N	05	t
162	12	Diversos		\N	12	t
93	07	Software 		\N	07	t
154	10	Ordenadores Portatiles		\N	10	t
26	03	Componentes Ensamblaje		\N	03	t
180	13	Equipos Ensamblados	Equipos Montados con componentes segn configurador PCI	\N	13	t
61	04	Varios		19	0104	t
25	01	Taller		19	0101	t
215	07	ORDENADORES MONTADOS	\N	19	0107	t
89	01	Cableador de Redes		84	0601	t
90	02	HUB,Switches	\n	84	0602	t
91	03	Redes Inalambricas(Wireless)		84	0603	t
151	04	Armarios Racks		84	0604	t
152	05	Complementos Armarios		84	0605	t
23	01	Taller		21	0201	t
56	02	A Domicilio		21	0202	t
57	03	Gestiones		21	0203	t
58	04	Varios		21	0204	t
204	99	PORTATILES OTRAS MARCAS	\N	21	0299	t
206	05	Mantenimientos	Descripcion de la familia	21	0205	t
207	06	Hosting - Housing	Descripcion de la familia	21	0206	t
208	07	Programacion	Descripcion de la familia	21	0207	t
214	08	Asistencia Remota	Descripcion de la familia	21	0208	t
103	05	DVD-R-RW/+R+RW		98	0805	t
99	01	Cartuchos Originales 		98	0801	t
100	02	Cartuchos Compatibles		98	0802	t
101	03	CD-R / CD-RW		98	0803	t
102	04	Disquetes		98	0804	t
132	06	Cintas Impresoras		98	0806	t
133	07	Etiquetas y Papeles		98	0807	t
134	08	Soportes Magneticos (Cintas)		98	0808	t
136	09	Soportes Magneticos (Discos)		98	0809	t
137	10	Toners Originales		98	0810	t
191	11	DISQUETES	\N	98	0811	t
122	06	Auriculares y Microfonos		105	0906	t
106	01	Alfombrillas		105	0901	t
107	02	Cables y Adaptadores Externos 		105	0902	t
108	03	Maletines y Archivadores		105	0903	t
109	04	Modding		105	0904	t
189	07	AURICULARES Y MICROFONOS	\N	105	0907	t
190	10	MALETINES Y ARCHIVADORES	\N	105	0910	t
192	09	ALFOMBRILLAS	\N	105	0909	t
110	05	Varios y Accesorios		105	0905	t
160	01	TPV		159	1101	t
80	13	Regrabadoras Externas		64	0413	t
81	14	Teclados		64	0414	t
82	15	Unidades Almac.Datos Externos		64	0415	t
142	19	IMP.Multifuncion		64	0419	t
115	16	Impresoras Inyeccion		64	0416	t
70	06	Impresoras Laser		64	0406	t
116	17	Impresoras Matriciales		64	0417	t
74	10	Monitores de Tubo		64	0410	t
65	01	Adaptadores y Puertos USB		64	0401	t
66	02	Altavoces		64	0402	t
67	03	Camaras Videoconferencia PC		64	0403	t
68	04	Escaners		64	0404	t
69	05	Hubs USB		64	0405	t
71	07	Joysticks-Gamepads		64	0407	t
72	08	Memorias Flash		64	0408	t
73	09	Modems Externos y Routes		64	0409	t
75	11	PCMCIA		64	0411	t
76	12	Ratones		64	0412	t
121	18	Faxes		64	0418	t
147	22	Tabletas Graficas		64	0422	t
148	23	ZIP Externos		64	0423	t
143	20	Monitores TFT		64	0420	t
146	21	CAPTURADORA/SINTONIZ VIDEO/TV EXT		64	0421	t
173	24	SAIS	SAIS	64	0424	t
182	25	IMPRESORAS MATRICIALES	\N	64	0425	t
195	27	MEMORIAS FLASH	\N	64	0427	t
200	26	IMP. MULTIFUNCION CANON INCL.	\N	64	0426	t
217	29	Impresoras Brother	Impresoras Brother	64	0429	t
78	01	 Reproductores/Grab.MP3 DVD DIVX		77	0501	t
119	02	Videovigilancia		77	0502	t
120	03	Walkie Talkies		77	0503	t
139	04	Camaras Foto Digital		77	0504	t
140	05	Telefonia		77	0505	t
141	06	Agenda y PDA		77	0506	t
163	01	Extension de Garantia		162	1201	t
94	01	Sistemas Operativos		93	0701	t
95	02	Soft.Gestion Empresa		93	0702	t
96	03	Soft.Utilidades		93	0703	t
150	04	Soft.Ofimatica		93	0704	t
185	06	COMPLEMENTOS ARMARIOS	\N	93	0706	t
188	05	CABLEADO DE REDES	\N	93	0705	t
220	07	ANTIVIRUS	Descripcion de la familia	93	0707	t
157	02	Portatiles Otra Marcas		154	1002	t
155	01	Portatiles Ensamblados		154	1001	t
187	05	EXTENSIÓN DE GARANTIA	\N	154	1005	t
123	18	CD ROM (Lectores)		26	0318	t
124	19	Controladorsa de Puertos		26	0319	t
125	20	Controladoras SCSI IDE SATA		26	0320	t
126	21	Discos Duros de Portatil		26	0321	t
128	22	DVD (Lectores)		26	0322	t
129	23	Memoria Notebooks		26	0323	t
130	24	Regrabadoras CD/DVD		26	0324	t
131	25	Software S.O.OEM		26	0325	t
41	05	Discos Duro		26	0305	t
38	04	Cajas  Modding		26	0304	t
31	02	Cajas de Ordenadores		26	0302	t
32	03	Capturadoras Video/Sint.TV		26	0303	t
42	06	Dicipador CPU		26	0306	t
43	07	Memorias		26	0307	t
44	08	Microprocesadores		26	0308	t
48	10	Modems Internos		26	0310	t
51	13	Tarjetas de Red		26	0313	t
52	14	Terjetas de Sonido		26	0314	t
45	09	Fuentes de Alimentacion		26	0309	t
86	11	P.Base Micros AMD		26	0311	t
50	12	P.Base Micros Intel 		26	0312	t
53	15	Tarjetas Graficas		26	0315	t
54	16	Unidades Almac.Datos Internas		26	0316	t
55	17	Cajas de Servidores		26	0317	t
28	01	Cables y Accesorios Internos	\n	26	0301	t
183	29	TARJETAS DE RED	\N	26	0329	t
184	30	SOFTWARE S.O. OEM	\N	26	0330	t
186	26	CONTROLADORAS DE PUERTOS	\N	26	0326	t
193	28	MEMORIA NOTEBOOKS	\N	26	0328	t
194	27	DISCOS DUROS DE PORTATIL	\N	26	0327	t
196	32	P. BASE MICROS AMD	\N	26	0332	t
197	31	CAJAS MODDING	\N	26	0331	t
209	34	COMPONENTES PORTATIL PCI	\N	26	0334	t
211	35	DISP. OPTICOS PORTATIL	\N	26	0335	t
212	33	PROCESADORES PORTATIL	\N	26	0333	t
181	01	Creature KAT 313	Equipos Creature Blancos Intel	180	1301	t
198	04	REPROD. / GRABAD. MP3 DVD DIVX	\N	180	1304	t
199	03	FOTO-VIDEO DIGITAL	\N	180	1303	t
201	02	AGENDAS Y PDA	\N	180	1302	t
202	05	VIDEOVIGILANCIA	\N	180	1305	t
203	07	TELEFONIA	\N	180	1307	t
205	06	RECEPTORES DE TDT	\N	180	1306	t
213	08	SERIE FEEL	Descripcion de la familia	180	1308	t
60	03	Gestiones	asdf asdf asdf asdf	19	0103	t
216	08	ORDENADORES OTRAS MARCAS		19	0108	t
59	02	A Domicilio	asdf asdf asdf	19	0102	t
\.


--
-- Data for Name: forma_pago; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY forma_pago (idforma_pago, descforma_pago, dias1tforma_pago, descuentoforma_pago) FROM stdin;
1	Contado	1	5.00
2	Pago 30 dias	30	0.00
3	Pago 60 dias	60	0.00
4	Talon 15 dias	15	1.00
6	Domiciliacion Bancaria	30	0.00
7	Pago 90 Dias	0	0.00
\.


--
-- Data for Name: fra_pro; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY fra_pro (idfra_pro, numfra_pro, fcrefra_pro, comentfra_pro) FROM stdin;
\.


--
-- Data for Name: horario; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY horario (idhorario, idtrabajador, idcuadrante, horainhorario, horafinhorario) FROM stdin;
12	8	8	08:00:00	19:00:00
13	2	8	08:00:00	19:00:00
14	1	15	08:00:00	19:00:00
15	2	37	08:00:00	19:00:00
23	7	10	08:00:00	19:00:00
26	2	25	08:00:00	19:00:00
28	2	11	08:00:00	19:00:00
29	2	4	08:00:00	19:00:00
31	6	12	08:00:00	19:00:00
30	8	19	08:00:00	19:00:00
32	6	19	14:00:00	21:00:00
34	9	20	08:00:00	19:00:00
35	1	20	08:00:00	19:00:00
36	6	20	08:00:00	19:00:00
37	6	22	08:00:00	19:00:00
38	8	22	08:00:00	19:00:00
39	1	22	08:00:00	19:00:00
45	6	29	08:00:00	19:00:00
46	7	29	08:00:00	19:00:00
47	1	31	08:00:00	19:00:00
40	6	24	08:00:00	19:00:00
41	8	24	08:00:00	19:00:00
42	2	24	08:00:00	19:00:00
43	7	24	08:00:00	19:00:00
44	7	24	08:00:00	19:00:00
49	8	29	08:00:00	19:00:00
51	8	15	08:00:00	19:00:00
52	8	8	08:00:00	19:00:00
25	8	5	08:00:00	19:00:00
4	1	1	08:00:00	19:00:00
33	8	1	08:00:00	18:00:00
54	2	43	08:00:00	19:00:00
56	8	50	08:00:00	19:00:00
57	1	43	08:00:00	19:00:00
58	8	51	08:00:00	19:00:00
59	7	36	08:00:00	19:00:00
60	6	36	08:00:00	19:00:00
61	1	36	08:00:00	19:00:00
62	1	38	08:00:00	19:00:00
63	2	38	08:00:00	19:00:00
65	1	37	08:00:00	19:00:00
66	1	57	08:00:00	19:00:00
67	6	57	08:00:00	19:00:00
68	8	57	08:00:00	19:00:00
69	7	57	08:00:00	19:00:00
73	8	52	08:00:00	19:00:00
74	6	45	08:00:00	19:00:00
75	1	45	08:00:00	19:00:00
76	6	52	08:00:00	19:00:00
77	1	52	08:00:00	19:00:00
78	6	58	08:00:00	19:00:00
79	1	58	08:00:00	19:00:00
80	9	58	08:00:00	19:00:00
81	2	46	08:00:00	19:00:00
82	1	46	08:00:00	19:00:00
83	1	59	08:00:00	19:00:00
84	8	59	08:00:00	19:00:00
85	7	59	08:00:00	19:00:00
86	1	50	08:00:00	19:00:00
87	6	50	08:00:00	19:00:00
88	8	48	08:00:00	19:00:00
89	1	48	08:00:00	19:00:00
90	7	48	08:00:00	19:00:00
91	9	61	08:00:00	19:00:00
92	7	61	08:00:00	19:00:00
93	1	61	08:00:00	19:00:00
94	8	15	08:00:00	19:00:00
95	8	27	08:00:00	19:00:00
96	6	27	08:00:00	19:00:00
97	1	27	08:00:00	19:00:00
20	2	17	08:00:00	19:00:00
21	6	17	08:00:00	19:00:00
48	8	17	08:00:00	19:00:00
18	8	23	08:00:00	19:00:00
19	6	23	08:00:00	19:00:00
98	1	17	08:00:00	19:00:00
100	1	23	08:00:00	19:00:00
111	1	136	08:00:00	19:00:00
112	1	137	08:00:00	19:00:00
113	1	139	08:00:00	19:00:00
114	1	148	08:00:00	19:00:00
115	1	149	08:00:00	19:00:00
116	1	150	08:00:00	19:00:00
117	1	151	08:00:00	19:00:00
118	6	148	08:00:00	19:00:00
119	6	149	08:00:00	19:00:00
120	6	150	08:00:00	19:00:00
121	6	151	08:00:00	19:00:00
122	8	148	08:00:00	19:00:00
123	8	149	08:00:00	19:00:00
124	8	150	08:00:00	19:00:00
125	8	151	08:00:00	19:00:00
126	1	141	08:00:00	19:00:00
127	1	142	08:00:00	19:00:00
128	1	143	08:00:00	19:00:00
129	1	144	08:00:00	19:00:00
130	9	141	08:00:00	19:00:00
131	9	142	08:00:00	19:00:00
132	9	143	08:00:00	19:00:00
133	9	144	08:00:00	19:00:00
134	7	141	08:00:00	19:00:00
135	7	142	08:00:00	19:00:00
136	7	143	08:00:00	19:00:00
137	7	144	08:00:00	19:00:00
5	9	2	08:00:00	19:00:00
6	2	2	08:00:00	19:00:00
17	8	2	08:00:00	19:00:00
24	1	2	08:00:00	19:00:00
138	6	2	08:00:00	19:00:00
139	1	10	08:00:00	19:00:00
7	8	3	08:00:00	19:00:00
8	1	3	08:00:00	19:00:00
22	7	3	08:00:00	19:00:00
140	6	26	08:00:00	19:00:00
141	1	26	08:00:00	19:00:00
142	8	26	08:00:00	19:00:00
143	6	33	08:00:00	19:00:00
144	1	34	08:00:00	19:00:00
145	1	33	08:00:00	19:00:00
151	1	13	08:00:00	19:00:00
152	1	6	08:00:00	19:00:00
153	2	6	08:00:00	19:00:00
154	6	6	08:00:00	19:00:00
155	8	6	08:00:00	19:00:00
156	7	6	08:00:00	19:00:00
157	9	6	08:00:00	19:00:00
16	7	16	08:00:00	19:00:00
53	1	16	08:00:00	19:00:00
101	8	16	08:00:00	19:00:00
158	7	32	08:00:00	19:00:00
159	1	32	08:00:00	19:00:00
167	1	108	08:00:00	19:00:00
168	2	108	08:00:00	19:00:00
169	6	108	08:00:00	19:00:00
170	6	115	08:00:00	19:00:00
171	6	122	08:00:00	19:00:00
172	6	129	08:00:00	19:00:00
173	1	115	08:00:00	19:00:00
174	1	122	08:00:00	19:00:00
175	1	129	08:00:00	19:00:00
178	8	111	08:00:00	19:00:00
180	9	111	08:00:00	19:00:00
181	1	111	08:00:00	19:00:00
50	8	30	08:00:00	19:00:00
182	1	30	08:00:00	19:00:00
183	6	30	08:00:00	19:00:00
184	7	30	08:00:00	19:00:00
185	6	1	08:00:00	19:00:00
186	6	23	08:00:00	19:00:00
187	6	3	08:00:00	19:00:00
188	1	18	08:00:00	19:00:00
189	2	18	08:00:00	19:00:00
190	6	18	08:00:00	19:00:00
191	8	18	08:00:00	19:00:00
72	1	44	08:00:00	19:00:00
192	8	44	08:00:00	19:00:00
193	7	44	08:00:00	19:00:00
194	9	44	08:00:00	19:00:00
195	1	65	08:00:00	19:00:00
196	6	65	08:00:00	19:00:00
197	6	65	19:00:00	21:00:00
198	1	64	08:00:00	19:00:00
199	7	163	08:00:00	19:00:00
200	1	162	08:00:00	19:00:00
201	1	164	08:00:00	19:00:00
202	7	165	08:00:00	19:00:00
203	2	162	08:00:00	19:00:00
204	6	163	08:00:00	19:00:00
205	8	164	08:00:00	19:00:00
206	9	165	08:00:00	19:00:00
207	2	15	08:00:00	19:00:00
208	9	22	08:00:00	19:00:00
209	6	29	08:00:00	19:00:00
210	7	1	08:00:00	19:00:00
211	1	1	08:00:00	19:00:00
212	6	1	08:00:00	19:00:00
213	9	1	08:00:00	19:00:00
214	2	1	08:00:00	19:00:00
215	8	1	08:00:00	19:00:00
216	7	2	08:00:00	19:00:00
217	1	2	08:00:00	19:00:00
218	6	2	08:00:00	19:00:00
219	9	2	08:00:00	19:00:00
220	2	2	08:00:00	19:00:00
221	8	2	08:00:00	19:00:00
10	7	9	08:00:00	19:00:00
11	6	9	01:00:00	12:00:00
99	1	9	08:00:00	19:00:00
222	9	62	08:00:00	19:00:00
223	2	62	07:00:00	19:00:00
224	6	62	08:00:00	19:00:00
225	2	62	08:00:00	19:00:00
895	6	1105	08:00:00	13:00:00
896	6	1105	16:00:00	20:00:00
897	7	1112	08:00:00	13:00:00
898	7	1112	16:00:00	20:00:00
899	6	1106	08:00:00	13:00:00
900	6	1106	16:00:00	20:00:00
901	7	1127	08:00:00	13:00:00
902	7	1127	16:00:00	20:00:00
903	1	1134	08:00:00	13:00:00
241	9	130	08:00:00	19:00:00
242	2	130	08:00:00	19:00:00
243	7	130	08:00:00	19:00:00
244	9	116	08:00:00	19:00:00
245	9	116	08:00:00	19:00:00
246	9	116	08:00:00	19:00:00
247	9	116	08:00:00	19:00:00
904	1	1134	16:00:00	20:00:00
905	7	1114	08:00:00	13:00:00
906	7	1114	16:00:00	20:00:00
907	2	1135	08:00:00	13:00:00
908	2	1135	16:00:00	20:00:00
909	7	1115	08:00:00	13:00:00
910	7	1115	16:00:00	20:00:00
911	7	1116	08:00:00	13:00:00
912	7	1116	16:00:00	20:00:00
913	7	1117	08:00:00	13:00:00
103	2	106	08:00:00	19:00:00
104	6	106	08:00:00	19:00:00
108	7	127	08:00:00	19:00:00
914	7	1117	16:00:00	20:00:00
915	7	1118	08:00:00	13:00:00
916	7	1118	16:00:00	20:00:00
105	8	113	08:00:00	19:00:00
106	9	113	08:00:00	18:00:00
249	1	113	19:01:00	21:00:00
110	1	134	08:00:00	19:00:00
251	9	135	08:00:00	19:00:00
162	8	121	08:00:00	19:00:00
165	1	107	08:00:00	19:00:00
917	9	1119	08:00:00	13:00:00
918	9	1119	16:00:00	20:00:00
921	2	1133	08:00:00	13:00:00
922	2	1133	16:00:00	20:00:00
260	6	206	08:00:00	19:00:00
262	6	208	08:00:00	19:00:00
228	2	190	08:00:00	19:00:00
252	7	197	15:00:00	16:00:00
269	2	180	08:00:00	19:00:00
277	9	206	08:00:00	19:00:00
279	9	208	08:00:00	19:00:00
282	2	184	08:00:00	19:00:00
258	6	204	08:00:00	19:00:00
275	9	204	08:00:00	19:00:00
256	1	191	19:00:00	20:00:00
288	2	331	08:00:00	19:00:00
290	8	176	08:00:00	19:00:00
255	8	198	08:00:00	19:00:00
232	2	178	08:00:00	19:00:00
291	1	199	08:00:00	19:00:00
292	8	185	08:00:00	19:00:00
293	7	192	08:00:00	19:00:00
284	2	193	08:00:00	19:00:00
276	9	205	08:00:00	19:00:00
294	6	205	08:00:00	19:00:00
298	1	200	08:00:00	19:00:00
299	6	200	08:00:00	19:00:00
278	9	207	08:00:00	19:00:00
289	1	183	08:00:00	19:00:00
303	1	218	08:00:00	19:00:00
305	6	218	08:00:00	19:00:00
308	6	246	08:00:00	19:00:00
309	9	253	08:00:00	19:00:00
310	1	247	08:00:00	19:00:00
311	7	254	08:00:00	19:00:00
313	6	247	08:00:00	19:00:00
314	8	337	08:00:00	19:00:00
317	6	337	08:00:00	13:00:00
318	6	337	16:00:00	20:00:00
325	2	316	08:00:00	13:00:00
326	2	316	16:00:00	20:00:00
321	2	334	08:00:00	13:00:00
322	2	334	16:00:00	21:00:00
323	1	334	08:00:00	13:00:00
324	1	334	22:00:00	08:00:00
329	6	340	08:30:00	13:00:00
330	6	340	16:00:00	20:00:00
306	9	211	08:00:00	19:00:00
389	7	504	08:00:00	13:00:00
390	7	504	16:00:00	20:00:00
391	7	505	08:00:00	13:00:00
392	7	505	16:00:00	20:00:00
393	7	506	08:00:00	13:00:00
394	7	506	16:00:00	20:00:00
395	7	507	08:00:00	13:00:00
396	7	507	16:00:00	20:00:00
397	7	508	08:00:00	13:00:00
398	7	508	16:00:00	20:00:00
399	7	509	08:00:00	13:00:00
400	7	509	16:00:00	20:00:00
387	7	503	08:00:00	13:00:00
388	7	503	16:00:00	20:00:00
531	6	497	08:00:00	13:00:00
532	6	497	16:00:00	20:00:00
533	6	496	08:00:00	13:00:00
534	6	496	16:00:00	20:00:00
535	2	526	08:00:00	13:00:00
536	2	526	16:00:00	20:00:00
537	1	525	08:00:00	13:00:00
538	1	525	16:00:00	20:00:00
539	7	518	08:00:00	13:00:00
540	7	518	16:00:00	20:00:00
849	6	1070	08:00:00	13:00:00
850	6	1070	16:00:00	20:00:00
851	7	1077	08:00:00	13:00:00
852	7	1077	16:00:00	20:00:00
853	6	1071	08:00:00	13:00:00
854	6	1071	16:00:00	20:00:00
857	7	1092	08:00:00	13:00:00
858	7	1092	16:00:00	20:00:00
859	1	1099	08:00:00	13:00:00
860	1	1099	16:00:00	20:00:00
861	7	1079	08:00:00	13:00:00
862	7	1079	16:00:00	20:00:00
863	2	1100	08:00:00	13:00:00
864	2	1100	16:00:00	20:00:00
865	7	1080	08:00:00	13:00:00
866	7	1080	16:00:00	20:00:00
867	7	1081	08:00:00	13:00:00
868	7	1081	16:00:00	20:00:00
869	7	1082	08:00:00	13:00:00
870	7	1082	16:00:00	20:00:00
871	7	1083	08:00:00	13:00:00
872	7	1083	16:00:00	20:00:00
923	9	1217	08:00:00	13:00:00
924	9	1217	16:00:00	20:00:00
925	1	1224	08:00:00	13:00:00
926	1	1224	16:00:00	20:00:00
\.


--
-- Data for Name: incidenciacomercial; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY incidenciacomercial (idincidenciacomercial, fechaincidenciacomercial, idcliente, comentincidenciacomercial, refincidenciacomercial, estadoincidenciacomercial, horaincidenciacomercial, idrutacomercial, idpedidocliente, idcobro, idtrabajador) FROM stdin;
\.


--
-- Data for Name: inventario; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY inventario (idinventario, nominventario, fechainventario) FROM stdin;
7	Inventario inicial	2006-01-24
8	REGULARIZACIÓN TRAS ALBARANIZAR	2006-02-02
\.


--
-- Data for Name: lalbaran; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lalbaran (numlalbaran, desclalbaran, cantlalbaran, pvplalbaran, descuentolalbaran, ivalalbaran, idalbaran, idarticulo, ordenlalbaran, reqeqlalbaran, lotelalbaran) FROM stdin;
1284	CART. HP COLOR Nº22 PSC1410 DJ3940 5ML	1.00	15.51	0.00	16.00	725	3439	0	0.00	\N
1285	CART. HP NEGRO Nº21 PSC1410 NEGRO 5ML C9351AE	1.00	13.79	0.00	16.00	725	3438	1	0.00	\N
1356	OKI TONER NEGRO C33/C34	3.00	27.41	0.00	16.00	756	4554	3	0.00	\N
1357	BROTHER TAMBOR C-DR200	2.00	80.11	0.00	16.00	756	4529	4	0.00	\N
1286	HOSTING ANUAL\nGNLEON.COM\nGESTORIANAUTICALEON.COM\n	1.00	360.00	0.00	16.00	726	4230	0	0.00	\N
1288	INSTALACION / HORA	1.00	150.00	0.00	16.00	728	4179	0	0.00	\N
1289	RENOVACION ANUAL DE DOMINIOS\nwww.jmcrepresentaciones.com	1.00	30.00	0.00	16.00	729	4203	0	0.00	\N
1290	MANTENIMIENTO SERVIDOR APACHE ANUAL LLABRES FELIU	1.00	500.00	0.00	16.00	730	4211	0	0.00	\N
1216	T.RED USB D-LINK WIRELESS DWL-G122 54Mbps 2.4	1.00	32.13	0.00	16.00	684	3252	0	0.00	\N
1218	HUB USB CONCEPTRONIC 4 PTOS. USB 2.0 C4USB2	1.00	12.61	0.00	16.00	684	3258	1	0.00	\N
1219	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	684	4185	2	0.00	\N
1220	INSTALACION / HORA	3.00	35.00	0.00	16.00	684	4179	3	0.00	\N
1301	HORAS CONTRATO	2.50	0.00	0.00	16.00	734	4184	2	0.00	\N
1302	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	734	4185	3	0.00	\N
1388	CART. HP COLOR Nº57 PSC 2410 (C6657AE) 17 ml	1.00	28.19	0.00	16.00	773	3068	0	0.00	\N
1389	CART. HP NEGRO Nº56 DJ 5150 OJ 5510 C6656AE 1	1.00	16.82	0.00	16.00	773	3067	1	0.00	\N
1026	implantación de sistema de facturacion \nen el nuevo servidor.	1.00	35.00	0.00	16.00	582	4193	0	0.00	\N
1027	DESPLAZAMIENTO PALMA	1.00	12.00	0.00	16.00	584	4180	0	0.00	\N
1028	CONFIGURACION E INSTALACION OPENVPN	1.00	150.00	0.00	16.00	584	4237	1	0.00	\N
1029	CONFIGURACIÓN E INSTALACION DE 1 CLIENTE VPN	3.00	60.00	0.00	16.00	584	4238	2	0.00	\N
1030	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB	1.00	73.49	0.00	16.00	583	4189	0	0.00	\N
1239	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	1.00	244.80	0.00	16.00	694	4011	0	0.00	\N
1240	HD 200 GB SATA2 SEAGATE 7200 RPM 8MB	1.00	56.22	0.00	16.00	694	3586	1	0.00	\N
1241	FUENTE DE ALI. 450W ( PIV ) ATX	1.00	19.41	0.00	16.00	694	3456	2	0.00	\N
1392	INSTALACION / HORA	0.50	35.00	0.00	16.00	775	4179	0	0.00	\N
1393	DESPLAZAMIENTO PALMA	1.00	6.00	100.00	16.00	775	4180	1	0.00	\N
1031	CAJA EXT. HDD 3.5"  SATA/PATA USB 2.0 SATA SI	1.00	69.31	0.00	16.00	583	4189	1	0.00	\N
1250	PROGRAMACION VARIOS	1.00	35.00	0.00	16.00	666	4239	0	0.00	\N
1244	CONFIGURACION E INSTALACION OPENVPN	1.00	180.00	0.00	16.00	696	4237	0	0.00	\N
1022	MANTENIMIENTO DICIEMBRE 06	1.00	576.00	0.00	16.00	579	4204	0	0.00	\N
1015	FEEL INTEL PIV 631 LGA775 3.0GHZ FSB800 2MB	1.00	599.22	0.00	16.00	575	4189	0	0.00	\N
1376	PAGO ANUAL MANTENIMIENTO BULMAGÉS	1.00	120.00	0.00	16.00	766	4240	0	0.00	\N
1377	T.SONIDO CREATIVE S.B. AUDIGY SE 7.1 OEM SB05	1.00	24.51	0.00	16.00	767	3535	0	0.00	\N
1378	INSTALACION / HORA	0.30	35.00	0.00	16.00	767	4179	1	0.00	\N
1088	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	607	4185	0	0.00	\N
1089	HORAS CONTRATO	1.00	0.00	0.00	16.00	607	4184	1	0.00	\N
1090	OKI TAMBOR EP-CART C32-BLACK	1.00	85.41	0.00	16.00	607	4531	2	0.00	\N
1068	BROTHER TN2000 MFC/DCP	6.00	60.49	0.00	16.00	599	4528	0	0.00	\N
1069	BROTHER TAMBOR C-DR200	1.00	80.11	0.00	16.00	599	4529	1	0.00	\N
1070	CARTUCHO NEGRO C-LC1000BK	1.00	19.32	0.00	16.00	599	4530	2	0.00	\N
1071	BROTHER CART. TINTA AMARILLA LC1000C	1.00	10.63	0.00	16.00	599	4202	3	0.00	\N
1072	BROTHER CART. TINTA MAGENTA LC1000M	1.00	10.63	0.00	16.00	599	4199	4	0.00	\N
1073	BROTHER CART. TINTA AZUL LC1000C	1.00	10.63	0.00	16.00	599	4198	5	0.00	\N
1368	SWITCH NETGEAR JGS524GE 24 PUERTOS 10/100/100	1.00	326.84	0.00	16.00	761	3937	0	0.00	\N
1369	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	761	4185	1	0.00	\N
1370	HORAS CONTRATO	1.00	0.00	0.00	16.00	761	4184	2	0.00	\N
1024	CONTRATACION 1 AÑO GECOALIMENT.ES	1.00	35.00	0.00	16.00	580	4203	1	0.00	\N
1034	INSTALACION / HORA	1.00	35.00	0.00	16.00	586	4179	0	0.00	\N
1035	DESPLAZAMIENTO PALMA	1.00	6.00	0.00	16.00	586	4180	1	0.00	\N
1084	INSTALACION / HORA	0.75	35.00	0.00	16.00	605	4179	0	0.00	\N
1085	DESPLAZAMIENTO PALMA	1.00	6.00	0.00	16.00	605	4180	1	0.00	\N
1086	INSTALACION / HORA	1.00	35.00	0.00	16.00	606	4179	0	0.00	\N
1087	DESPLAZAMIENTO PALMA	1.00	6.00	0.00	16.00	606	4180	1	0.00	\N
1091	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	1.00	453.62	0.00	16.00	608	4189	0	0.00	\N
1092	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	1.00	453.62	0.00	16.00	609	4189	0	0.00	\N
1275	PROGRAMACION WEB APA\n50% FINAL	1.00	500.00	0.00	16.00	720	4193	0	0.00	\N
1412	REVISION DEL EQUIPO POR VIRUS Y FALLOS EN OUTLOOK EXPRESS	1.50	35.00	0.00	16.00	785	4179	0	0.00	\N
1413	AVG Anti-Virus Professional Edition	1.00	26.90	0.00	16.00	785	4538	1	0.00	\N
1143	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB	1.00	69.25	10.00	16.00	641	4113	0	0.00	\N
1276	HOSTING PLAN BASE PROFESIONAL ANUAL\nwww.ajuntament de pollença.com	1.00	360.00	0.00	16.00	721	4540	0	0.00	\N
1414	CART. JT EPSON C62 CX3200 COLOR 8803JB E71	2.00	9.10	0.00	16.00	786	3003	0	0.00	\N
1415	CART. JT EPSON C62 CX3200 NEGRO 879JB E70	2.00	7.81	0.00	16.00	786	3012	1	0.00	\N
1277	CONTRATACION DE DOMINIOS\nFESKATEVA.COM, HAZTUCASA.COM,  FESCATEVA.COM,  MAKEUHOME.COM	4.00	30.00	0.00	16.00	722	4203	0	0.00	\N
1278	CONTRATACIONDE DOMINIOS\nFESKTEVA.INFO	1.00	30.00	0.00	16.00	722	4203	1	0.00	\N
1279	CONTRATACION DE DOMINIOS\nFESKTEVA.CAT; FESCATEVA.CAT	2.00	30.00	0.00	16.00	722	4203	2	0.00	\N
1280	RENOVACION DE DOMINIO\nINFOPOLLENSA.NET	1.00	30.00	0.00	16.00	723	4203	0	0.00	\N
1050	CONTRATACION WWW.GIBPROMOCIONES.COM\nHASTA 15/02/2007	1.00	30.00	0.00	16.00	594	4203	0	0.00	\N
1135	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	1.00	244.80	0.00	16.00	637	4011	0	0.00	\N
1053	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	595	4185	2	0.00	\N
1167	CABLE VGA 10 MTS. M-H (ALARGADOR) AK4229	1.00	17.83	0.00	16.00	654	4474	0	0.00	\N
1136	AVG (3 licencias, 1 año) Anti-Virus Professional Edition\n	1.00	53.90	0.00	16.00	638	4538	0	0.00	\N
1137	INSTALACION / HORA MONTAJE RED	1.50	35.00	0.00	16.00	638	4179	1	0.00	\N
1140	LATIGUILLO UTP CAT.5E 5 Mt. PL3005	1.00	2.00	100.00	16.00	638	4389	2	0.00	\N
1155	BROTHER LASER NEGRO HL 5250DN	1.00	279.00	0.00	16.00	649	4189	0	0.00	\N
1156	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	649	2843	1	0.00	\N
1152	OKI C5600N	1.00	404.00	0.00	16.00	648	4189	0	0.00	\N
1154	BANDEJA DUPLEX IMPRESION A DOBLE CARA	1.00	200.00	52.00	16.00	648	4189	1	0.00	\N
1157	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	648	2843	2	0.00	\N
1158	BROTHER LASER NEGRO HL 5250DN	1.00	279.00	0.00	16.00	650	4189	0	0.00	\N
1159	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	650	2843	1	0.00	\N
1186	CARTUCHO NEGRO C-LC1000BK	1.00	19.32	0.00	16.00	668	4530	0	0.00	\N
1187	BROTHER CART. TINTA AMARILLA LC1000C	1.00	10.63	0.00	16.00	668	4202	1	0.00	\N
1188	BROTHER CART. TINTA MAGENTA LC1000M	1.00	10.63	0.00	16.00	668	4199	2	0.00	\N
1189	BROTHER CART. TINTA AZUL LC1000C	1.00	10.63	0.00	16.00	668	4198	3	0.00	\N
1160	CUCHILLAS DE CORTE (2 UNIDADES)	1.00	7.59	0.00	16.00	651	4189	0	0.00	\N
1107	SOFT. OFFICE 2003 BASICO	1.00	191.76	0.00	16.00	616	3664	0	0.00	\N
1109	BROTHER TAMBOR C-DR200 7820N	1.00	80.11	0.00	16.00	621	4529	0	0.00	\N
1183	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	667	4185	0	0.00	\N
1184	HORAS CONTRATO	2.50	0.00	0.00	16.00	667	4184	1	0.00	\N
1185	RW DVD DUAL DL LG 18X8X16X GSA-H42N OEM	2.00	30.00	0.00	16.00	667	4500	2	0.00	\N
1162	QL 1050\nImpresora de etiquetas profesional	1.00	189.00	0.00	16.00	653	4189	0	0.00	\N
1164	BROTHER MFC 7820N	1.00	349.00	0.00	16.00	653	4189	1	0.00	\N
1165	CANON LPI BROTHER	1.00	15.00	0.00	16.00	653	4188	2	0.00	\N
1166	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	653	2843	3	0.00	\N
1197	RATON LOGITECH PILOT  WHEEL OPT OEM S96 NEGRO	1.00	6.31	0.00	16.00	673	3256	0	0.00	\N
1190	INSTALACION / HORA	1.00	35.00	0.00	16.00	669	4179	0	0.00	\N
1191	DESPLAZAMIENTO PALMA	1.00	6.00	100.00	16.00	669	4180	1	0.00	\N
1110	RENOVACION DE DOMINIOS\nmarmoleriafullana.com\nHasta el 21/02/2008	1.00	30.00	0.00	16.00	622	4203	0	0.00	\N
1281	DESPLAZAMIENTO PALMA	1.00	6.00	100.00	16.00	724	4180	0	0.00	\N
1282	INSTALACION / HORA	1.00	35.00	0.00	16.00	724	4179	1	0.00	\N
1283	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	1.00	19.43	0.00	16.00	724	4030	2	0.00	\N
1379	MANTENIMIENTO ANUAL BULMAGES HASTA 11/05/2008	1.00	120.00	0.00	16.00	768	4560	0	0.00	\N
1416	TN3060 BROTHER 8220/8045/8440/8840	1.00	87.28	0.00	16.00	787	4565	0	0.00	\N
1231	PORTATIL HP NX7300 T5500 1GB 80GB DVD-RW 15.4	1.00	840.00	0.00	16.00	689	4434	0	0.00	\N
1232	se ha cobrado la mitad, falta la otra mitad en mayo	1.00	0.00	0.00	16.00	689	4189	1	0.00	\N
1364	HUB USB MINI CONCEPTRONIC 4 PTOS CSPUSB4	1.00	8.37	0.00	16.00	759	2905	0	0.00	\N
1365	HORAS CONTRATO	1.00	0.00	0.00	16.00	759	4184	1	0.00	\N
1366	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	759	4185	2	0.00	\N
1311	OKI TONER NEGRO C33/C34	1.00	27.41	0.00	16.00	739	4554	0	0.00	\N
1312	OKI TONER MAGENTA C33/C34	1.00	38.38	0.00	16.00	739	4555	1	0.00	\N
1291	REPOSAPIES AJUSTABLE MOD. 5120 ARCHIVO 2000	2.00	32.00	0.00	16.00	731	4189	0	0.00	\N
1292	SOPORTE MONITOR OFFI.SUITE 80311 FELLOWES	1.00	31.00	0.00	16.00	731	4189	1	0.00	\N
1295	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144	1.00	8.61	0.00	16.00	733	4004	0	0.00	\N
1296	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340	1.00	8.61	0.00	16.00	733	4003	1	0.00	\N
1297	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0	1.00	8.61	0.00	16.00	733	4002	2	0.00	\N
1298	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0	1.00	8.61	0.00	16.00	733	3969	3	0.00	\N
1221	DESPLAZAMIENTO PALMA	1.00	6.00	0.00	16.00	685	4180	0	0.00	\N
1222	INSTALACION / HORA	3.00	35.00	0.00	16.00	685	4179	1	0.00	\N
1293	HOSTING ANUAL GIBPROMOCIONES.COM	1.00	360.00	0.00	16.00	732	4553	0	0.00	\N
1294	CONTRATACION ANUAL DE DOMINIO\nwww.gibpromociones.com	1.00	30.00	100.00	16.00	732	4203	1	0.00	\N
1309	DESPLAZAMIENTO PALMA	1.00	6.00	0.00	16.00	738	4180	0	0.00	\N
1310	INSTALACION / HORA	0.50	35.00	0.00	16.00	738	4179	1	0.00	\N
1227	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144	2.00	8.61	0.00	16.00	688	4004	0	0.00	\N
1228	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340	2.00	8.61	0.00	16.00	688	4003	1	0.00	\N
1229	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0	2.00	8.61	0.00	16.00	688	4002	2	0.00	\N
1230	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0	2.00	8.61	0.00	16.00	688	3969	3	0.00	\N
994	EPSON IMPT STYLUS PHOTO R2400 USB A3	1.00	775.00	0.00	16.00	566	4190	0	0.00	\N
998	BROTHER MFC 5460 CN	1.00	148.00	0.00	16.00	568	4194	0	0.00	\N
999	CANON LPI BROTHER	1.00	15.00	0.00	16.00	568	4188	1	0.00	\N
1000	BROTHER CARTUCHO TINTA NEGRA LC1000HYBK	5.00	26.19	0.00	16.00	568	4197	2	0.00	\N
1001	BROTHER CART. TINTA AZUL LC1000C	2.00	10.63	0.00	16.00	568	4198	3	0.00	\N
1002	BROTHER CART. TINTA MAGENTA LC1000M	2.00	10.63	0.00	16.00	568	4199	4	0.00	\N
1003	BROTHER CART. TINTA AMARILLA LC1000C	2.00	10.63	0.00	16.00	568	4202	5	0.00	\N
1242	BROTHER HL-2070N\nSERIES: A7J742916	1.00	173.20	0.00	16.00	695	4187	0	0.00	\N
1243	IMPRESORA DE ETIQUETAS QL-1050\nSERIES: A7G111104	1.00	189.00	0.00	16.00	695	4189	1	0.00	\N
1333	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	750	4185	0	0.00	\N
1334	INSTALACION / HORA	4.00	35.00	30.00	16.00	750	4179	1	0.00	\N
1335	LATIGUILLO UTP CAT.5E DE 30 MTS MARFIL PL 101	1.00	9.64	0.00	16.00	750	3825	2	0.00	\N
1336	CONECTOR MACHO RJ45 UTP  7 Unds	1.00	1.43	0.00	16.00	750	3159	3	0.00	\N
1337	ROSETA RJ45 CAT. 5E UTP 2 TOMAS FS 4210	1.00	3.00	0.00	16.00	750	2896	4	0.00	\N
1016	SOFT. WINDOWS XP PROFESIONAL OEM	1.00	124.82	0.00	16.00	575	2852	1	0.00	\N
1020	CONFIGURACION E INSTALACION OPENVPN	1.00	35.00	0.00	16.00	578	4179	0	0.00	\N
1021	CONFIGURACIÓN E INSTALACION DE 1 CLIENTE\nDESCUENTO POR CLIENTE MANTENIMIENTO	2.00	60.00	0.00	16.00	578	4179	1	0.00	\N
988	BROTHER HL-2070N\nSERIES: H6J379202	1.00	173.20	0.00	0.00	563	4187	0	\N	\N
1012	HORAS CONTRATO	1.00	0.00	0.00	16.00	574	4184	0	0.00	\N
1013	TONER TN-2000 BROTHER HL-2070N, MFC-7820N	1.00	60.49	0.00	16.00	574	4189	1	0.00	\N
1014	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	574	4185	2	0.00	\N
1018	TAMBOR OKI C5100 5300 SERIES CYAN	1.00	99.47	0.00	16.00	577	3364	0	0.00	\N
1019	TAMBOR OKI C5100 5300 SERIES AMARILLO	1.00	99.47	0.00	16.00	577	3364	1	0.00	\N
1040	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	200.00	13.81	0.00	16.00	589	2880	0	0.00	\N
1041	LLAVE MAESTRA CABLE SEGURIDAD PARA PORTATIBLES	4.00	17.24	0.00	16.00	589	4189	1	0.00	\N
1042	LLAVE MAESTRA CABLE SEGURIDAD PARA PORTATIBLES	1.00	17.24	100.00	16.00	589	4189	2	0.00	\N
1299	LATIGUILLO UTP CAT.5E DE 8 MTS MARFIL PL1010	1.00	3.31	0.00	16.00	734	2890	0	0.00	\N
1300	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	734	2843	1	0.00	\N
1251	T.RED USB CONCEPTRONIC WIRELESS 54Mbps C54RU\nSERIES 1172816907587	1.00	21.55	0.00	16.00	703	3347	\N	0.00	\N
1004	ARCHIVADOR CD S NGS WALLETS CAR 12 U	1.00	3.17	0.00	16.00	569	3431	0	0.00	\N
1005	\nADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	24.24	0.00	16.00	569	4106	1	0.00	\N
1238	Comprobar copias seguridad cinta	1.00	35.00	0.00	16.00	693	4189	0	0.00	\N
1036	ACCESS POINT CONCEPTRONIC 54 Mbps C54APM WIRE	1.00	34.86	0.00	16.00	587	3227	0	0.00	\N
1037	MEMORIA DIMM DDR 512 MB 400Mhz KINGSTON	1.00	40.16	0.00	16.00	587	2961	1	0.00	\N
1038	T.RED PCMCIA CONCEPTRONIC WIRELESS 54Mbps C54	1.00	18.02	0.00	16.00	587	3139	2	0.00	\N
1006	HUB USB UH-275 MINI 4 PTOS. USB 2.0 SB 2110	1.00	20.23	0.00	16.00	570	3261	0	0.00	\N
1043	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	24.24	0.00	16.00	570	4106	1	0.00	\N
995	\n\n\n\nINSTALACION / HORA	1.00	35.00	0.00	16.00	567	4179	0	0.00	\N
996	\nDESPLAZAMIENTO PALMA	1.00	6.00	99.99	16.00	567	4180	1	0.00	\N
997	\n\n\n\nSP CONTAPLUS PRO 2007	2.00	209.00	0.00	16.00	567	4178	2	0.00	\N
1017	CONFIGURACION E INSTALACION DE RED\n2 ORDENADORES\nMATERIAL INCLUÃDO	1.00	200.00	0.00	16.00	576	4179	0	0.00	\N
1269	BROTHER TN2000 MFC/DCP	6.00	60.49	0.00	16.00	718	4528	0	0.00	\N
1270	BROTHER CART. TINTA AZUL LC1000C	2.00	10.63	0.00	16.00	718	4198	1	0.00	\N
1271	BROTHER CART. TINTA MAGENTA LC1000M	2.00	10.63	0.00	16.00	718	4199	2	0.00	\N
1272	BROTHER CART. TINTA AMARILLA LC1000C	2.00	10.63	0.00	16.00	718	4202	3	0.00	\N
1273	CINTA DE PAPEL CONTINUO BLANCA\nDK22214	1.00	10.22	0.00	16.00	718	4189	4	0.00	\N
1047	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	5.00	13.86	0.00	16.00	591	2880	0	0.00	\N
1061	Programación Fecha Caducidad Alumnos	1.00	200.00	0.00	16.00	598	4189	0	0.00	\N
1062	Aplicación Base Preguntas de test:	1.00	1100.00	0.00	16.00	598	4189	1	0.00	\N
1063	Integración base de datos FileMaker, Excel	1.00	150.00	0.00	16.00	598	4189	2	0.00	\N
1064	Introduccion de examenes inicial	1.00	240.00	0.00	16.00	598	4189	3	0.00	\N
1065	Programación consulta con el profesor	1.00	250.00	0.00	16.00	598	4189	4	0.00	\N
1066	Programación, gestión multiples cursos:	1.00	350.00	0.00	16.00	598	4189	5	0.00	\N
1067	Aplicar estilo e integrar en web Nautivel	1.00	450.00	0.00	16.00	598	4189	6	0.00	\N
1396	INSTALACION / HORA	1.00	35.00	0.00	16.00	777	4179	0	0.00	\N
1076	REPARACIONES	1.00	15.00	0.00	16.00	601	4241	0	0.00	\N
1077	FUENTE DE ALI. 450W ( PIV ) ATX	1.00	17.35	0.00	16.00	601	3456	1	0.00	\N
1074	INSTALACION / HORA	0.50	35.00	0.00	16.00	600	4179	0	0.00	\N
1075	TFT 19"  BELINEA 1925 S1W PANORAMICO MM NEGRO	1.00	215.53	0.00	16.00	600	4134	1	0.00	\N
1078	IMPRESORA EPSON STYLUS D78 USB DINA4 22PPM 57	1.00	60.24	0.00	16.00	602	3878	0	0.00	\N
1397	HORAS CONTRATO	3.00	0.00	0.00	16.00	778	4184	0	0.00	\N
1398	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	778	4185	1	0.00	\N
1399	LATIGUILLO FTP CAT.5E DE 2 MTS MARFIL PL1202	3.00	1.81	0.00	16.00	778	2892	2	0.00	\N
1360	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	758	4185	0	0.00	\N
1361	HORAS CONTRATO	1.00	0.00	0.00	16.00	758	4184	1	0.00	\N
1362	LATIGUILLO UTP CAT.5E DE 5 MTS MARFIL PL1005	1.00	1.51	0.00	16.00	758	2889	2	0.00	\N
1363	LATIGUILLO UTP CAT.5E DE 4 MTS MARFIL PL1005	1.00	1.25	0.00	16.00	758	2889	3	0.00	\N
1079	SOFT. WINDOWS XP PROFESIONAL OEM	1.00	124.82	0.00	16.00	603	2852	0	0.00	\N
1025	REPARACIÓN OFERTAS CLUB MAC	1.00	35.00	0.00	16.00	581	4193	0	0.00	\N
1044	CONTRATACION WWW.LASGALLETASDETUSVIAJES.COM\nDesde 01/02/2007 hasta 01/02/2008	1.00	40.00	0.00	16.00	590	4203	0	0.00	\N
1045	CONTRATACION\nWWW.LESGALETESDELSTEUVIATGES.COM\nDesde 08/02/2007 hasta 08/02/2008	1.00	0.00	0.00	16.00	590	4203	1	0.00	\N
1046	CONTRATACION\n\nWWW.LESGALLETESDELSTEUVIATGES.COM\nDesde 08/02/2007 hasta 08/02/2008	1.00	0.00	0.00	16.00	590	4203	2	0.00	\N
1023	CONTRATACIÓN 1 AÑO GECOALIMENT.COM	1.00	35.00	0.00	16.00	580	4203	0	0.00	\N
1093	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	1.00	205.93	0.00	16.00	610	4189	0	0.00	\N
1094	SOFT. WINDOWS XP PROFESIONAL OEM	1.00	123.68	0.00	16.00	610	2852	1	0.00	\N
1095	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	1.00	205.93	0.00	16.00	611	4189	0	0.00	\N
1097	SWITCH CONCEPTRONIC 8 PTOS. 10/100/1000  CGIG	1.00	64.53	0.00	16.00	611	3640	1	0.00	\N
1098	SOFT. WINDOWS XP PROFESIONAL OEM	1.00	123.68	0.00	16.00	611	2852	2	0.00	\N
1102	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144	1.00	8.20	0.00	16.00	614	4004	0	0.00	\N
1103	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0	1.00	8.31	0.00	16.00	614	4002	1	0.00	\N
1104	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0	2.00	8.31	0.00	16.00	614	3969	2	0.00	\N
1105	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340	1.00	8.31	0.00	16.00	614	4003	3	0.00	\N
1106	CARLOS DE ESCUELA DEL MAR -\n ORDENADOR Y UN ESCANER. \nREPARACI'ON TALLER - REINSTALAR S.O. Y TESTEAR	1.00	40.00	0.00	16.00	615	4189	0	0.00	\N
1099	BROTHER C-MFC 5460 CN	1.00	148.00	0.00	16.00	612	4189	0	0.00	\N
1100	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	612	2843	1	0.00	\N
1101	CANON LPI BROTHER	1.00	15.00	0.00	16.00	612	4188	2	0.00	\N
1108	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	15.00	13.86	0.00	16.00	617	2880	0	0.00	\N
1274	LECTOR/GRAB. TARJETAS DE MEMORIA USB 2.0 CARD	1.00	12.53	0.00	16.00	719	3001	0	0.00	\N
1048	CONTRATACION \nwww.rosconstruccion.com\nHasta 09/02/08	1.00	30.00	0.00	16.00	592	4203	0	0.00	\N
989	BROTHER TINTA COLOR MULTIFUNCION DCP-130\nSERIES: L6F438228	1.00	87.00	0.00	16.00	564	4186	0	\N	\N
990	\n\nHORAS CONTRATO	1.00	0.00	0.00	16.00	565	4184	0	\N	\N
991	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	565	4185	1	\N	\N
993	BROTHER MULTIFUNCION LASER MONOCROMO DCP-7025	1.00	263.80	0.00	16.00	565	4183	2	\N	\N
1080	HORAS CONTRATO	1.50	0.00	0.00	16.00	604	4184	0	0.00	\N
1081	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	604	4185	1	0.00	\N
1082	BROTHER HL-2070N	1.00	173.20	0.00	16.00	604	4187	2	0.00	\N
1083	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	604	2843	3	0.00	\N
1115	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	29.29	0.00	16.00	625	4106	0	0.00	\N
1111	INSTALACION / HORA	2.00	20.00	0.00	16.00	623	4179	0	0.00	\N
1112	IMPRESORA HP PHOTOSMART C4180 MULTIFUNCION	1.00	151.61	0.00	16.00	623	4431	1	0.00	\N
1113	REPARACION ORDENADOR CATI TALLER	2.00	20.00	0.00	16.00	624	4241	0	0.00	\N
1114	MODEM INTERNO CONCEPTRONIC	1.00	9.69	0.00	16.00	624	4189	1	0.00	\N
1144	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON	1.00	68.56	0.00	16.00	637	3339	1	0.00	\N
1051	TECLADO NGS PLANET OFFICE 125 TECLAS MM USB	1.00	16.64	0.00	16.00	595	3477	0	0.00	\N
1052	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON	2.00	84.87	0.00	16.00	595	3339	1	0.00	\N
1054	HORAS CONTRATO	1.00	0.00	0.00	16.00	595	4184	3	0.00	\N
1055	CABLE VGA M/M 1.8M AK3225	1.00	2.70	0.00	16.00	595	2836	4	0.00	\N
1056	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.96	0.00	16.00	595	2843	5	0.00	\N
1057	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	596	4185	0	0.00	\N
1058	HORAS CONTRATO	1.00	0.00	0.00	16.00	596	4184	1	0.00	\N
1059	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	1.00	244.80	0.00	16.00	596	4011	2	0.00	\N
1173	GATEWAY LINKSYS WRT54GS WIRELESS	1.00	84.02	0.00	16.00	660	3872	0	0.00	\N
1174	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	660	4185	1	0.00	\N
1175	HORAS CONTRATO	1.50	0.00	0.00	16.00	660	4184	2	0.00	\N
1201	ORDENADOR MONTADO SERIE FEEL\nCORE2 DUO E6300 DUAL CORE 1 GB	1.00	485.00	0.00	16.00	675	4549	0	0.00	\N
1198	BROTHER TN2000 MFC/DCP	3.00	60.49	0.00	16.00	674	4528	0	0.00	\N
1199	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	674	4185	1	0.00	\N
1200	HORAS CONTRATO	1.00	0.00	0.00	16.00	674	4184	2	0.00	\N
1181	PAQUETE 6 DOMINIOS ESCUELA	1.00	70.00	0.00	16.00	665	4233	0	0.00	\N
1204	AVG Internet Security\n3 Licencias / 1 Año	1.00	66.90	0.00	16.00	678	4539	0	0.00	\N
1205	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	678	4185	1	0.00	\N
1206	HORAS CONTRATO	1.00	0.00	0.00	16.00	678	4184	2	0.00	\N
1207	LECTOR C.B. METROLOGIC MS-9520 VOYAGER (USB) 	1.00	183.06	0.00	16.00	679	3224	0	0.00	\N
1208	IMPRESORA TICKETS SAMSUNG SRP-350 TERMICA NEG	1.00	271.64	0.00	16.00	679	3294	1	0.00	\N
1211	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	17.00	13.90	0.00	16.00	681	2880	0	0.00	\N
1417	CART. HP COLOR Nº22 PSC1410 DJ3940 5ML	1.00	15.72	0.00	16.00	788	3439	0	0.00	\N
1418	CART. HP NEGRO Nº21 PSC1410 NEGRO 5ML C9351AE	1.00	13.79	0.00	16.00	788	3438	1	0.00	\N
1353	HORAS CONTRATO	1.00	0.00	0.00	16.00	756	4184	0	0.00	\N
1354	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	16.00	756	4185	1	0.00	\N
1355	CARTUCHO NEGRO C-LC1000BK	2.00	19.32	0.00	16.00	756	4530	2	0.00	\N
1049	TRASPASO g-ribasazcona.COM	1.00	30.00	0.00	16.00	593	4203	0	0.00	\N
1233	HOSTING G-RIBASAZCONA - \nFEBRERO - MARZO	2.00	17.00	0.00	16.00	690	4244	0	0.00	\N
1419	HOSTING G-RIBASAZCONA \nABRIL - MAYO	2.00	17.00	0.00	16.00	690	4244	1	0.00	\N
1367	LATIGUILLO UTP CAT.5E DE 20 MTS MARFIL PL1020	1.00	6.02	0.00	16.00	760	3451	0	0.00	\N
1426	SIN DEFINIR (COMODIN)\nasdf\nasdf\nasdf\n	1.00	0.00	0.00	16.00	796	4189	0	0.00	\N
1427	SIN DEFINIR (COMODIN)	2.00	100.00	0.00	16.00	796	4189	1	0.00	\N
1428	SIN DEFINIR (COMODIN)	1.00	0.00	0.00	16.00	796	4189	2	0.00	\N
1009	HORAS CONTRATO	0.50	0.00	0.00	16.00	573	4184	0	0.00	\N
1010	\n\n\nLATIGUILLO FTP CAT.5E DE 2 MTS MARFIL PL1202	1.00	1.81	0.00	2.00	573	2892	1	0.00	\N
1011	DESPLAZAMIENTO CONTRATO	1.00	0.00	0.00	2.00	573	4185	2	0.00	\N
1007	CART. JT EPSON C62 CX3200 NEGRO 879JB E70	3.00	7.81	0.00	4.00	572	3012	0	0.00	\N
1008	CART. JT EPSON C62 CX3200 COLOR 8803JB E71	1.00	9.10	0.00	16.00	572	3003	1	0.00	\N
1407	HORAS CONTRATO	3.00	0.00	0.00	16.00	784	4184	0	0.00	\N
1408	OKI TONER AZUL C33/C34	1.00	38.38	0.00	16.00	784	4559	1	0.00	\N
1409	OKI TONER AMARILLO C33/C34	1.00	38.38	0.00	16.00	784	4556	2	0.00	\N
1410	OKI TONER MAGENTA C33/C34	1.00	38.38	0.00	16.00	784	4555	3	0.00	\N
1411	OKI TONER NEGRO C33/C34	1.00	27.41	0.00	16.00	784	4554	4	0.00	\N
1539	SIN DEFINIR (COMODIN)	1.00	200.00	0.00	16.00	824	4189	0	0.00	\N
1540	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	1.00	567.05	0.00	16.00	825	4089	0	0.00	\N
1541	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	1.00	690.16	0.00	16.00	825	4093	1	0.00	\N
1542	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	1.00	26.87	0.00	16.00	825	4919	2	0.00	\N
1543	ORD. INTEL CORE 2 DUO E6300 FOLLETO NAVIDAD 0	1.00	834.52	0.00	16.00	825	4103	3	0.00	\N
1544	FA. 120W FSP UNIV. PORTATIL NB120	1.00	41.89	0.00	16.00	825	4634	4	0.00	\N
1545	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	1.00	567.05	0.00	16.00	826	4089	0	0.00	\N
1546	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	2.00	690.16	0.00	16.00	826	4093	1	0.00	\N
1547	SOPORTE PARA PORTATIL 17" NOTEPAL 2 VENT. NEG	1.00	44.75	0.00	16.00	826	4910	2	0.00	\N
1548	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	1.00	26.87	0.00	16.00	826	4919	3	0.00	\N
1549	ORD. INTEL CORE 2 DUO E6300 FOLLETO NAVIDAD 0	1.00	834.52	0.00	16.00	826	4103	4	0.00	\N
1550	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	2.00	567.05	0.00	16.00	827	4089	0	0.00	\N
1551	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	2.00	690.16	0.00	16.00	827	4093	1	0.00	\N
1552	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	2.00	26.87	0.00	16.00	827	4919	2	0.00	\N
1553	SOPORTE PARA PORTATIL 17" NOTEPAL 2 VENT. NEG	1.00	44.75	0.00	16.00	827	4910	3	0.00	\N
1554	ORD. INTEL CORE 2 DUO E6300 FOLLETO NAVIDAD 0	1.00	834.52	0.00	16.00	828	4103	0	0.00	\N
1555	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	1.00	26.87	0.00	16.00	828	4919	1	0.00	\N
1556	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	1.00	690.16	0.00	16.00	828	4093	2	0.00	\N
1557	SIN DEFINIR (COMODIN)	1.00	25.00	0.00	16.00	828	4189	3	0.00	\N
1558	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	1.00	567.05	0.00	16.00	829	4089	0	0.00	\N
1559	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	1.00	690.16	0.00	16.00	829	4093	1	0.00	\N
1560	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	1.00	26.87	0.00	16.00	829	4919	2	0.00	\N
1561	SOPORTE PARA PORTATIL 17" NOTEPAL 2 VENT. NEG	1.00	44.75	0.00	16.00	829	4910	3	0.00	\N
1562	ORD. INTEL CORE 2 DUO E6300 FOLLETO NAVIDAD 0	1.00	834.52	0.00	16.00	829	4103	4	0.00	\N
1563	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	1.00	567.05	0.00	16.00	830	4089	0	0.00	\N
1564	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	1.00	690.16	0.00	16.00	830	4093	1	0.00	\N
1565	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	1.00	26.87	0.00	16.00	830	4919	2	0.00	\N
1566	SOPORTE PARA PORTATIL 17" NOTEPAL 2 VENT. NEG	1.00	44.75	0.00	16.00	830	4910	3	0.00	\N
1567	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	1.00	567.05	0.00	16.00	831	4089	0	0.00	\N
1568	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	1.00	690.16	0.00	16.00	831	4093	1	0.00	\N
1569	SOPORTE PARA PORTATIL 17" NOTEPAL 2 VENT. NEG	1.00	44.75	0.00	16.00	831	4910	2	0.00	\N
1570	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	79.00	45.00	0.00	16.00	831	4919	3	0.00	\N
1571	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	3.00	567.05	0.00	16.00	832	4089	0	0.00	\N
1572	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	2.00	690.16	0.00	16.00	832	4093	1	0.00	\N
1573	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	1.00	26.87	0.00	16.00	832	4919	2	0.00	\N
1574	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	1.00	26.87	0.00	16.00	833	4919	0	0.00	\N
1575	SOPORTE PARA PORTATIL 17" NOTEPAL 2 VENT. NEG	1.00	44.75	0.00	16.00	833	4910	1	0.00	\N
1576	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	1.00	690.16	0.00	16.00	833	4093	2	0.00	\N
1577	SOPORTE PARA PORTATIL 15" NOTEPAL 2 VENT. NEG	2.00	26.87	0.00	16.00	834	4919	0	0.00	\N
1578	ORD. AMD ATHLON64 AM2 3500+ FOLLETO NAVIDAD 0	1.00	690.16	0.00	16.00	834	4093	1	0.00	\N
1579	ORD. INTEL CELERON D 336+ 2.8 FOLLETO NAVIDAD	1.00	567.05	0.00	16.00	834	4089	2	0.00	\N
1405	Cinta de Papel 12x30,48 DK22214	1.00	10.22	0.00	16.00	783	4562	0	0.00	\N
1406	Cinta de Papel 62x30,48 DK22205	50.00	18.92	0.00	16.00	783	4563	1	0.00	\N
\.


--
-- Data for Name: lalbaranp; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lalbaranp (numlalbaranp, desclalbaranp, cantlalbaranp, ivalalbaranp, pvplalbaranp, descuentolalbaranp, idalbaranp, idarticulo, ordenlalbaranp, reqeqlalbaranp, lotelalbaranp) FROM stdin;
159	R FINANCIERO	1.00	0.00	0.01	0.00	50	4192	2	0.00	\N
184	R FINANCIERO	1.00	0.00	0.09	0.00	58	4192	2	0.00	\N
98	BROTHER MFC 5460 CN	1.00	16.00	118.40	0.00	34	4194	0	0.00	\N
99	CANON LPI BROTHER	1.00	16.00	15.00	0.00	34	4188	1	0.00	\N
100	BROTHER CART. TINTA AMARILLA LC1000C	2.00	16.00	7.66	0.00	34	4202	2	0.00	\N
101	BROTHER CARTUCHO TINTA NEGRA LC1000HYBK	5.00	16.00	18.86	0.00	34	4197	3	0.00	\N
102	BROTHER CART. TINTA AZUL LC1000C	2.00	16.00	7.66	0.00	34	4198	4	0.00	\N
103	\nBROTHER CART. TINTA MAGENTA LC1000M	2.00	16.00	7.66	0.00	34	4199	5	0.00	\N
104	CABLE USB 5MT A/B MM   SB2405	2.00	16.00	2.07	0.00	35	2842	0	0.00	\N
105	RATON LOGITECH PILOT  WHEEL OPT OEM S96 BLANC	1.00	16.00	6.30	0.00	35	3328	1	0.00	\N
106	ARCHIVADOR CD S NGS WALLETS CAR 12 U	1.00	16.00	3.17	0.00	35	3431	2	0.00	\N
107	LATIGUILLO UTP CAT.5E AZUL 1.5M. PL2051	1.00	16.00	0.75	0.00	35	3144	3	0.00	\N
108	LATIGUILLO UTP CAT.5E VERDE 1 Mt. IB5701	1.00	16.00	0.63	0.00	35	3450	4	0.00	\N
109	LATIGUILLO UTP CAT.5E ROJO 1.5 Mt. IB5551	1.00	16.00	0.75	0.00	35	3826	5	0.00	\N
110	LATIGUILLO UTP CAT.5E ROJO 1 Mt. PL3001	1.00	16.00	0.78	0.00	35	3449	6	0.00	\N
111	HUB USB UH-275 MINI 4 PTOS. USB 2.0 SB 2110\nSERIES Z8610188AB0161	1.00	16.00	20.23	0.00	35	3261	7	0.00	\N
112	R FINANCIERO	1.00	0.00	0.11	0.00	35	4192	8	0.00	\N
89	RATON NGS CRUSADER 2 BOTONES PS2	2.00	16.00	2.25	0.00	32	3423	0	\N	\N
90	RATON NGS EVO PRO POWERED OPTICO USB	1.00	16.00	5.31	0.00	32	3239	1	\N	\N
91	RATON LOGITECH VALUE OPTICAL OEM S90 NEGRO PS	1.00	16.00	5.25	0.00	32	3710	2	\N	\N
92	TECLADO NGS ZENITH 17 TECLAS MULTIMEDIA USB	1.00	16.00	6.83	0.00	32	3470	3	\N	\N
93	TECLADO NGS CUTEWHITE 108 TECLAS BLANCO	1.00	16.00	4.10	0.00	32	3254	4	\N	\N
94	R. FINANCIERO	1.00	16.00	0.10	0.00	32	4192	5	\N	\N
95	\nRATON LOGITECH VALUE OPTICAL OEM S90 NEGRO PS	1.00	16.00	6.24	0.00	32	3710	6	\N	\N
96	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	16.00	24.24	0.00	33	4106	0	\N	\N
97	R FINANCIERO	1.00	0.00	0.07	0.00	33	4192	1	\N	\N
116	Tarjetas visita	1.00	16.00	215.55	0.00	37	4189	0	0.00	\N
117	BROTHER TN2000 MFC/DCP	6.00	16.00	43.56	0.00	40	4528	0	0.00	\N
118	BROTHER TAMBOR C-DR200	1.00	16.00	57.68	0.00	40	4529	1	0.00	\N
119	CARTUCHO NEGRO C-LC1000BK	1.00	16.00	13.91	0.00	40	4530	2	0.00	\N
120	BROTHER CART. TINTA AMARILLA LC1000C	1.00	16.00	7.66	0.00	40	4202	3	0.00	\N
121	BROTHER CART. TINTA MAGENTA LC1000M	1.00	16.00	7.66	0.00	40	4199	4	0.00	\N
122	BROTHER CART. TINTA AZUL LC1000C	1.00	16.00	7.66	0.00	40	4198	5	0.00	\N
123	BROTHER TN2000 MFC/DCP	1.00	16.00	43.56	0.00	41	4528	0	0.00	\N
124	BROTHER TAMBOR C-DR200	1.00	16.00	57.68	0.00	42	4529	0	0.00	\N
128	IMPRESORA EPSON STYLUS D78 USB DINA4 22PPM 57	1.00	16.00	50.00	0.00	43	3878	0	0.00	\N
125	CART. HP NEGRO Nº56 DJ 5150 OJ 5510 C6656AE 1	2.00	16.00	13.96	0.00	43	3067	1	0.00	\N
127	SWITCH CONCEPTRONIC 8 PTOS. 10/100/1000  CGIG	1.00	16.00	53.56	0.00	43	3640	2	0.00	\N
126	CART. HP COLOR Nº57 PSC 2410 (C6657AE) 17 ml	2.00	16.00	23.40	0.00	43	3068	3	0.00	\N
129	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB	1.00	16.00	57.48	0.00	43	4113	4	0.00	\N
130	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	10.00	16.00	11.50	0.00	43	2880	5	0.00	\N
132	PORTES	1.00	16.00	4.51	0.00	43	4191	6	0.00	\N
134	R FINANCIERO	1.00	0.00	1.07	0.00	43	4192	7	0.00	\N
135	ORDENADOR MONTADO SERIE FEEL	2.00	16.00	640.00	0.00	44	4549	0	0.00	\N
136	R FINANCIERO	1.00	0.00	3.84	0.00	44	4192	1	0.00	\N
144	EP CART C32 BLACK	1.00	16.00	68.33	0.00	46	4189	0	0.00	\N
145	ORDENADOR MONTADO SERIE FEEL	1.00	16.00	399.36	0.00	47	4549	0	0.00	\N
146	R FINANCIERO	1.00	0.00	1.20	0.00	47	4192	1	0.00	\N
149	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	1.00	16.00	203.18	0.00	48	4011	0	0.00	\N
150	TECLADO NGS PLANET OFFICE 125 TECLAS MM USB	1.00	16.00	13.81	0.00	48	3477	1	0.00	\N
147	PB ASROCK P4i65G i865G SATA VGA SON LAN DDR40	1.00	16.00	38.75	0.00	48	3754	2	0.00	\N
148	TFT 19"  BELINEA 1925 S1W PANORAMICO MM NEGRO	1.00	16.00	178.89	0.00	48	4134	3	0.00	\N
151	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	5.00	16.00	11.16	0.00	48	2880	4	0.00	\N
152	CONECTOR MACHO RJ45 UTP (BOLSA DE 10 U.) TD10	4.00	16.00	1.19	0.00	48	3159	5	0.00	\N
153	R FINANCIERO	1.00	0.00	1.49	0.00	48	4192	6	0.00	\N
154	CABLE VGA M/M 1.8M AK3225	1.00	16.00	2.24	0.00	49	2836	0	0.00	\N
155	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	200.00	16.00	10.99	0.00	49	2880	1	0.00	\N
156	R FINANCIERO	1.00	0.00	6.60	0.00	49	4192	2	0.00	\N
157	CABLE USB 1,8MT A/B MM   SB 2402	1.00	16.00	0.80	0.00	50	2843	0	0.00	\N
158	CABLE VGA M/M 1.8M AK3225	1.00	16.00	2.24	0.00	50	2836	1	0.00	\N
160	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON	2.00	16.00	70.44	0.00	51	3339	0	0.00	\N
161	TECLADO LOGITECH ULTRA-FLAT KEYBOARD	1.00	16.00	13.53	0.00	51	4330	1	0.00	\N
162	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	1.00	16.00	16.13	0.00	51	4030	2	0.00	\N
163	R FINANCIERO	1.00	0.00	0.51	0.00	51	4192	3	0.00	\N
164	T.RED USB CONCEPTRONIC WIRELESS 54Mbps C54RU	1.00	16.00	17.89	0.00	52	3347	0	0.00	\N
165	R FINANCIERO	1.00	0.00	0.05	0.00	52	4192	1	0.00	\N
166	CART. JT EPSON C62 CX3200 NEGRO 879JB E70	3.00	16.00	6.48	0.00	53	3012	0	0.00	\N
167	CART. JT EPSON C62 CX3200 COLOR 8803JB E71	1.00	16.00	7.55	0.00	53	3003	1	0.00	\N
168	SOFT. WINDOWS XP PROFESIONAL OEM	1.00	16.00	113.79	0.00	53	2852	2	0.00	\N
169	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	16.00	24.26	0.00	53	4106	3	0.00	\N
170	R FINANCIERO	1.00	0.00	0.50	0.00	53	4192	4	0.00	\N
171	SOFT. ANTIVIRUS PANDA 2007 + FIREWALL 3 LICENCIAS	1.00	16.00	32.30	0.00	54	4366	0	0.00	\N
172	PORTES	1.00	16.00	10.00	0.00	54	4191	1	0.00	\N
173	CANON GESTION RESIDUOS	1.00	16.00	0.01	0.00	54	4189	2	0.00	\N
85	BROTHER HL-2070N	1.00	0.00	173.20	0.00	30	4187	0	\N	\N
86	BROTHER TINTA COLOR MULTIFUNCION DCP-130	1.00	16.00	57.60	0.00	31	4186	0	\N	\N
87	BROTHER MULTIFUNCION LASER MONOCROMO DCP-7025	1.00	16.00	263.80	0.00	31	4183	1	\N	\N
88	CANON LPI BROTHER	2.00	16.00	15.00	0.00	31	4188	2	\N	\N
174	CABLE USB 3MT A/B MM   SB2403	5.00	16.00	1.20	0.00	55	2841	0	0.00	\N
175	CABLE USB 1,8MT A/B MM   SB 2402	2.00	16.00	0.80	0.00	55	2843	1	0.00	\N
176	MEMORIA COMPACT FLASH VERBATIM CF 4 GB	1.00	16.00	61.98	0.00	55	4148	2	0.00	\N
177	R FINANCIERO	1.00	0.00	0.21	0.00	55	4192	3	0.00	\N
178	ORDENADOR MONTADO SERIE FEEL	1.00	16.00	350.00	0.00	56	4549	0	0.00	\N
179	R FINANCIERO	1.00	0.00	1.05	0.00	56	4192	1	0.00	\N
180	BROTHER MFC 5460 CN	1.00	16.00	118.40	0.00	57	4194	0	0.00	\N
181	CANON LPI BROTHER	1.00	16.00	15.00	0.00	57	4188	1	0.00	\N
182	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	16.00	24.31	0.00	58	4106	0	0.00	\N
183	TECLADO NGS ZENITH 17 TECLAS MULTIMEDIA USB	1.00	16.00	6.83	0.00	58	3470	1	0.00	\N
185	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	1.00	16.00	184.27	0.00	59	4011	0	0.00	\N
186	R FINANCIERO	1.00	0.00	0.55	0.00	59	4192	1	0.00	\N
187	CPU INTEL CORE2 DUO E4300 1.8 GHZ FSB800 2MB	1.00	16.00	128.33	0.00	60	4503	0	0.00	2L708193A1658
188	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	3.00	16.00	16.11	0.00	60	4030	1	0.00	PM035478
189	HUB USB MINI CONCEPTRONIC 4 PTOS CSPUSB4	2.00	16.00	6.92	0.00	60	2905	2	0.00	8714909003094
113	PORTES	1.00	16.00	14.00	0.00	36	4191	0	0.00	\N
114	EPSON IMPT STYLUS PHOTO R2400 USB A3	1.00	16.00	678.13	0.00	36	4190	1	0.00	\N
190	OKI TONER NEGRO C33/C34	1.00	16.00	21.93	0.00	61	4554	0	0.00	\N
191	OKI TONER AZUL C33/C34	1.00	16.00	30.70	0.00	61	4559	1	0.00	\N
192	OKI TONER MAGENTA C33/C34	1.00	16.00	30.70	0.00	61	4555	2	0.00	\N
193	OKI TONER AMARILLO C33/C34	1.00	16.00	30.70	0.00	61	4556	3	0.00	\N
194	BROTHER TN2000 MFC/DCP	6.00	16.00	43.56	0.00	62	4528	0	0.00	\N
195	BROTHER CART. TINTA AMARILLA LC1000C	2.00	16.00	7.66	0.00	62	4202	1	0.00	\N
196	BROTHER CART. TINTA MAGENTA LC1000M	2.00	16.00	7.66	0.00	62	4199	2	0.00	\N
197	BROTHER CART. TINTA AZUL LC1000C	2.00	16.00	7.66	0.00	62	4198	3	0.00	\N
198	Cinta de Papel 12x30,48 DK22214	1.00	16.00	5.68	0.00	62	4562	4	0.00	\N
199	CARTUCHO NEGRO C-LC1000BK	2.00	16.00	13.91	0.00	63	4530	0	0.00	\N
200	OKI TONER NEGRO C33/C34	3.00	16.00	21.93	0.00	63	4554	1	0.00	\N
201	CANON LPI BROTHER	1.00	16.00	15.00	0.00	63	4188	2	0.00	\N
202	DCP130C IMP. BROTHER COLOR MULTIFUNCION	1.00	16.00	52.70	0.00	63	4566	3	0.00	\N
205	Cinta de Papel 12x30,48 DK22214	1.00	16.00	5.68	0.00	65	4562	0	0.00	\N
206	Cinta de Papel 62x30,48 DK22205	50.00	16.00	10.51	0.00	65	4563	1	0.00	\N
213	BROTHER TAMBOR C-DR200	1.00	16.00	57.68	0.00	69	4529	0	0.00	\N
215	FIXING UNIT 230V LE7343001 FUSOR BROTHER	1.00	16.00	40.12	0.00	71	4567	0	0.00	\N
216	REPARACIONES	1.00	16.00	40.00	0.00	71	4241	1	0.00	\N
211	BROTHER HL-2070N	1.00	16.00	130.80	0.00	68	4187	0	0.00	\N
212	IMPRESORA DE ETIQUETAS QL-1050\nSERIES: A7G111104	1.00	2.00	141.75	0.00	68	4189	1	0.00	\N
208	OKI TONER NEGRO C33/C34	1.00	16.00	21.93	0.00	67	4554	0	0.00	\N
209	OKI TONER MAGENTA C33/C34	1.00	4.00	30.70	0.00	67	4555	1	0.00	\N
210	BROTHER TN2000 MFC/DCP	2.00	23.00	43.56	0.00	67	4528	2	0.00	\N
214	BROTHER TAMBOR C-DR200	1.00	23.00	57.68	0.00	70	4529	0	0.00	\N
207	TN3060 BROTHER 8220/8045/8440/8840	1.00	5.00	62.84	0.00	66	4565	0	0.00	\N
217	Back Up y restauración de datos	1.00	16.00	30.00	0.00	72	4548	0	0.00	\N
218	AÑLSKJ	300.00	16.00	12.00	0.00	72	4573	1	0.00	\N
115	SP CONTAPLUS PRO 2007	2.00	16.00	162.76	0.00	36	4178	2	0.00	\N
\.


--
-- Data for Name: lcontrato; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lcontrato (idlcontrato, idcontrato, idarticulo, cantlcontrato, pvplcontrato, desclcontrato, ordenlcontrato) FROM stdin;
1	1	4553	8.00	115.00	sdfasd sdf asdf 	0
\.


--
-- Data for Name: lfactura; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lfactura (idlfactura, cantlfactura, pvplfactura, ivalfactura, descuentolfactura, idfactura, idarticulo, desclfactura, ordenlfactura, reqeqlfactura, lotelfactura) FROM stdin;
1015	1.00	442.20	16.00	0.00	469	4216	MANTENIMIENTO ENERO	0	0.00	\N
992	1.00	40.20	16.00	0.00	462	4208	MANTENIMIENTO BULMAGES ENERO	0	0.00	\N
994	1.00	98.48	16.00	0.00	462	4189	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB\nALBARÁN 20-12-2006	2	0.00	\N
995	1.00	92.88	16.00	0.00	462	4189	CAJA EXT. HDD 3.5"  SATA/PATA USB 2.0 SATA SI\nALBARÁN 20-12-2006	3	0.00	\N
1050	1.00	3.62	16.00	0.00	483	2836	CABLE VGA M/M 1.8M AK3225	2	0.00	\N
989	3.00	10.47	16.00	0.00	460	3012	CART. JT EPSON C62 CX3200 NEGRO 879JB E70	0	0.00	\N
990	1.00	12.19	16.00	0.00	460	3003	CART. JT EPSON C62 CX3200 COLOR 8803JB E71	1	0.00	\N
1097	1.00	2412.00	16.00	0.00	497	4193	PROGRAMACION WEB NAUTICA VERMELL	0	0.00	\N
1057	1.00	23.25	16.00	0.00	485	3456	FUENTE DE ALI. 450W ( PIV ) ATX	1	0.00	\N
1059	1.00	288.81	16.00	0.00	485	4134	TFT 19"  BELINEA 1925 S1W PANORAMICO MM NEGRO	2	0.00	\N
1060	1.00	80.72	16.00	0.00	486	3878	IMPRESORA EPSON STYLUS D78 USB DINA4 22PPM 57	0	0.00	\N
1109	15.00	18.57	16.00	0.00	503	2880	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00	\N
1105	1.00	10.99	16.00	0.00	502	4004	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144	0	0.00	\N
1106	1.00	11.14	16.00	0.00	502	4002	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0	1	0.00	\N
1107	2.00	11.14	16.00	0.00	502	3969	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0	2	0.00	\N
1108	1.00	11.14	16.00	0.00	502	4003	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340	3	0.00	\N
1113	1.00	12.27	16.00	0.00	506	3724	CART. BROTHER LC900 MAGENTA 	0	0.00	\N
1100	1.00	275.95	16.00	0.00	500	4189	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	0	0.00	\N
1101	1.00	165.73	16.00	0.00	500	2852	SOFT. WINDOWS XP PROFESIONAL OEM	1	0.00	\N
1083	1.00	46.90	16.00	0.00	495	4193	REPARACIÓN OFERTAS CLUB MAC	0	0.00	\N
1084	1.00	53.60	16.00	0.00	495	4203	CONTRATACION WWW.LASGALLETASDETUSVIAJES.COM\nDesde 01/02/2007 hasta 01/02/2008	1	0.00	\N
1085	1.00	0.00	16.00	0.00	495	4203	CONTRATACION\nWWW.LESGALETESDELSTEUVIATGES.COM\nDesde 08/02/2007 hasta 08/02/2008	2	0.00	\N
1086	1.00	0.00	16.00	0.00	495	4203	CONTRATACION\nWWW.LESGALLETESDELSTEUVIATGES.COM\nDesde 08/02/2007 hasta 08/02/2008	3	0.00	\N
1087	1.00	46.90	16.00	0.00	495	4203	CONTRATACIÓN 1 AÑO GECOALIMENT.COM	4	0.00	\N
1088	2.00	46.90	16.00	0.00	495	4203	CONTRATACION 1 AÑO GECOALIMENT.ES	5	0.00	\N
1080	1.00	140.70	16.00	0.00	494	4219	MANTENIMIENTO INF.ORMATICO FEBRERO	0	0.00	\N
1081	1.00	56.28	16.00	0.00	494	4228	HOSTING FEBRERO	1	0.00	\N
1082	1.00	46.90	16.00	0.00	494	4218	MANTENIMIENTO RED FEBRERO	2	0.00	\N
1102	1.00	275.95	16.00	0.00	501	4189	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	0	0.00	\N
1103	1.00	86.47	16.00	0.00	501	3640	SWITCH CONCEPTRONIC 8 PTOS. 10/100/1000  CGIG	1	0.00	\N
1104	1.00	165.73	16.00	0.00	501	2852	SOFT. WINDOWS XP PROFESIONAL OEM	2	0.00	\N
1098	1.00	607.85	16.00	0.00	498	4189	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	0	0.00	\N
1099	1.00	607.85	16.00	0.00	499	4189	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	0	0.00	\N
1068	6.00	81.06	16.00	0.00	491	4528	BROTHER TN2000 MFC/DCP	0	0.00	\N
1069	1.00	107.35	16.00	0.00	491	4529	BROTHER TAMBOR C-DR200	1	0.00	\N
1070	1.00	25.89	16.00	0.00	491	4530	CARTUCHO NEGRO C-LC1000BK	2	0.00	\N
1071	1.00	14.24	16.00	0.00	491	4202	BROTHER CART. TINTA AMARILLA LC1000C	3	0.00	\N
1072	1.00	14.24	16.00	0.00	491	4199	BROTHER CART. TINTA MAGENTA LC1000M	4	0.00	\N
1073	1.00	14.24	16.00	0.00	491	4198	BROTHER CART. TINTA AZUL LC1000C	5	0.00	\N
1046	1.00	22.30	16.00	0.00	483	3477	TECLADO NGS PLANET OFFICE 125 TECLAS MM USB	0	0.00	\N
1047	2.00	113.73	16.00	0.00	483	3339	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON	1	0.00	\N
1051	1.00	1.29	16.00	0.00	483	2843	CABLE USB 1,8MT A/B MM   SB 2402	3	0.00	\N
1054	1.00	328.03	16.00	0.00	483	4011	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	4	0.00	\N
1079	1.00	442.20	16.00	0.00	493	4216	MANTENIMIENTO FEBRERO	0	0.00	\N
1129	1.00	72.23	16.00	0.00	513	4538	AVG (3 licencias, 1 año) Anti-Virus Professional Edition\n	0	0.00	\N
1130	1.50	46.90	16.00	0.00	513	4179	INSTALACION / HORA MONTAJE RED	1	0.00	\N
1131	1.00	2.68	16.00	100.00	513	4389	LATIGUILLO UTP CAT.5E 5 Mt. PL3005	2	0.00	\N
1111	1.00	40.20	16.00	0.00	505	4208	MANTENIMIENTO BULMAGES MARZO	0	0.00	\N
1112	1.00	67.00	16.00	0.00	505	4207	MANTENIMIENTO HARDWARE MARZO	1	0.00	\N
1119	2.00	46.90	16.00	0.00	509	4179	INSTALACION / HORA ORDENADOR J	0	0.00	\N
1120	2.00	46.90	16.00	0.00	509	4241	REPARACION ORDENADOR C	1	0.00	\N
1116	1.00	203.16	16.00	0.00	508	4431	IMPRESORA HP PHOTOSMART C4180 MULTIFUNCION	0	0.00	\N
1118	1.00	12.98	16.00	0.00	508	4189	MODEM INTERNO CONCEPTRONIC	1	0.00	\N
1126	1.00	328.03	16.00	0.00	511	4011	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	0	0.00	\N
1127	1.00	91.87	16.00	0.00	511	3339	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON	1	0.00	\N
1121	1.00	771.84	16.00	0.00	510	4204	MANTENIMIENTO MARZO	0	0.00	\N
1166	3.00	81.06	16.00	0.00	530	4528	BROTHER TN2000 MFC/DCP	0	0.00	\N
1167	1.00	0.00	16.00	0.00	530	4185	DESPLAZAMIENTO CONTRATO	1	0.00	\N
1168	1.00	0.00	16.00	0.00	530	4184	HORAS CONTRATO	2	0.00	\N
1165	1.00	649.90	16.00	0.00	529	4549	ORDENADOR MONTADO SERIE FEEL\nCORE2 DUO E6300 DUAL CORE 1 GB	0	0.00	\N
1110	1.00	40.20	16.00	0.00	504	4217	MANTENIMIENTO BFACT MARZO	0	0.00	\N
1138	1.00	373.86	16.00	0.00	517	4189	BROTHER LASER NEGRO HL 5250DN	0	0.00	\N
1139	1.00	1.29	16.00	0.00	517	2843	CABLE USB 1,8MT A/B MM   SB 2402	1	0.00	\N
1133	1.00	373.86	16.00	0.00	515	4189	BROTHER LASER NEGRO HL 5250DN	0	0.00	\N
1134	1.00	1.29	16.00	0.00	515	2843	CABLE USB 1,8MT A/B MM   SB 2402	1	0.00	\N
1164	1.00	60.30	16.00	0.00	528	4234	HOSTING CASASCONHISTORIA.NET\nENERO, FEBRERO, MARZO	0	0.00	\N
1163	1.00	100.50	16.00	0.00	527	4225	HOSTING BORISGRAFIC.COM\nENERO, FEBRERO, MARZO	0	0.00	\N
1151	1.00	442.20	16.00	0.00	520	4216	MANTENIMIENTO MARZO	0	0.00	\N
1132	1.00	160.80	16.00	0.00	514	4215	MANTENIMIENTO AZUL YATCHS 4 EQUIPOS MARZO	0	0.00	\N
1128	1.00	0.00	16.00	0.00	512	4184	HORAS CONTRATO	0	0.00	\N
1140	1.00	10.17	16.00	0.00	512	4189	CUCHILLAS DE CORTE (2 UNIDADES)	1	0.00	\N
1169	1.00	39.28	16.00	0.00	531	4106	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	0	0.00	\N
1114	1.00	39.25	16.00	0.00	507	4106	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	0	0.00	\N
1172	1.00	364.08	16.00	0.00	533	3294	IMPRESORA TICKETS SAMSUNG SRP-350 + TERMICA NEG	0	0.00	\N
1174	1.00	40.20	16.00	0.00	535	4208	MANTENIMIENTO BULMAGES ABRIL	0	0.00	\N
1175	1.00	67.00	16.00	0.00	535	4207	MANTENIMIENTO HARDWARE ABRIL	1	0.00	\N
1176	1.00	40.20	16.00	0.00	536	4217	MANTENIMIENTO BFACT ABRIL	0	0.00	\N
1170	1.00	245.30	16.00	0.00	532	3224	LECTOR C.B. METROLOGIC MS-9520 VOYAGER (USB) 	0	0.00	\N
1171	1.00	0.00	16.00	0.00	532	4189	SIN DEFINIR (COMODIN)	1	0.00	\N
1173	1.00	2680.00	16.00	0.00	534	4240	PROGRAMACION BULMAGES + ACTUALIZACION MANUALES	0	0.00	\N
1181	1.00	1594.60	16.00	0.00	540	4193	PROGRAMACION WEB ABACCINO\n3 IDIOMAS PHP-FLASH	0	0.00	\N
1177	1.00	20.98	16.00	0.00	537	3067	CART. HP NEGRO Nº56 DJ 5150 OJ 5510 C6656AE 1	0	0.00	\N
1178	1.00	37.83	16.00	0.00	537	3068	CART. HP COLOR Nº57 PSC 2410 (C6657AE) 17 ml	1	0.00	\N
983	1.00	198.32	16.00	0.00	458	4194	BROTHER MFC 5460 CN	0	0.00	\N
984	1.00	20.10	16.00	0.00	458	4188	CANON LPI BROTHER	1	0.00	\N
985	5.00	35.09	16.00	0.00	458	4197	BROTHER CARTUCHO TINTA NEGRA LC1000HYBK	2	0.00	\N
986	2.00	14.24	16.00	0.00	458	4198	BROTHER CART. TINTA AZUL LC1000C	3	0.00	\N
987	2.00	14.24	16.00	0.00	458	4199	BROTHER CART. TINTA MAGENTA LC1000M	4	0.00	\N
988	2.00	14.24	16.00	0.00	458	4202	BROTHER CART. TINTA AMARILLA LC1000C	5	0.00	\N
1183	1.00	56.28	16.00	0.00	542	4228	HOSTING ABRIL	0	0.00	\N
1184	1.00	140.70	16.00	0.00	542	4219	MANTENIMIENTO INF. ABRIL	1	0.00	\N
1185	1.00	46.90	16.00	0.00	542	4218	MANTENIMIENTO RED ABRIL	2	0.00	\N
1193	1.00	53.60	16.00	0.00	545	4212	PCI - ACTUALIZACION DISTRIBUCION LINUX ABRIL	0	0.00	\N
1182	17.00	18.63	16.00	0.00	541	2880	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00	\N
1180	1.00	160.80	16.00	0.00	539	4215	MANTENIMIENTO ABRIL	0	0.00	\N
1188	1.00	8.74	16.00	0.00	544	3256	RATON LOGITECH PILOT  WHEEL OPT OEM S96 NEGRO	0	0.00	\N
1189	2.00	11.54	16.00	0.00	544	4004	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144	1	0.00	\N
1190	2.00	11.54	16.00	0.00	544	4003	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340	2	0.00	\N
1191	2.00	11.54	16.00	0.00	544	4002	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0	3	0.00	\N
1197	1.00	562.80	16.00	0.00	549	4434	PORTATIL HP NX7300 T5500 1GB 80GB DVD-RW 15.4\nPAGO 1/2 ABRIL	0	0.00	\N
1187	1.00	509.20	16.00	0.00	543	4216	MANTENIMIENTO DIALMA	0	0.00	\N
1160	3.00	40.20	16.00	0.00	524	4235	HOSTING IBIZASEACHARTER.COM\nENERO, FEBRERO, MARZO 2007	0	0.00	\N
1198	1.00	328.03	16.00	0.00	550	4011	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	0	0.00	\N
1199	1.00	75.33	16.00	0.00	550	3586	HD 200 GB SATA2 SEAGATE 7200 RPM 8MB	1	0.00	\N
1200	1.00	26.01	16.00	0.00	550	3456	FUENTE DE ALI. 450W ( PIV ) ATX	2	0.00	\N
1201	1.00	232.09	16.00	0.00	551	4187	BROTHER HL-2070N\nSERIES: A7J742916	0	0.00	\N
1202	1.00	253.26	16.00	0.00	551	4189	IMPRESORA DE ETIQUETAS QL-1050\nSERIES: A7G111104	1	0.00	\N
1179	1.00	771.84	16.00	0.00	538	4204	MANTENIMIENTO GIB	0	0.00	\N
1061	1.00	634.03	16.00	0.00	487	4189	ORDENADOR SERIE FEEL PIV DUAL CORE + SOFT \nSEGUN PRESUPUESTO	0	0.00	\N
1062	1.00	3.23	16.00	0.00	486	2957	CABLE USB 1,8 MTS A/A M/M SB1000	1	0.00	\N
1205	1.00	670.00	16.00	0.00	554	4193	PROGRAMACION PREVIA WEB APA\nPAGO PREVIO.\nFALTA 50% AL TERMINO DEL TRABAJO	0	0.00	\N
1218	1.00	40.20	16.00	0.00	562	4203	RENOVACION ANUAL DE DOMINIOS\nwww.jmcrepresentaciones.com	0	0.00	\N
1240	1.00	771.84	16.00	0.00	573	4204	MANTENIMIENTO GIB MAYO	0	0.00	\N
1246	1.00	116.96	16.00	0.00	576	4565	TN3060 BROTHER 8220/8045/8440/8840	0	0.00	\N
1247	1.00	40.20	16.00	0.00	577	4217	MANTENIMIENTO BFACT \nMES DE JUNIO. PAGADA 24/05/07	0	0.00	\N
1063	1.00	160.80	16.00	0.00	488	4215	MANTENIMIENTO FEBRERO 4 EQUIPOS 	0	0.00	\N
1064	1.00	114.45	16.00	0.00	488	4531	OKI TAMBOR EP-CART C32-BLACK	1	0.00	\N
1220	1.00	40.20	16.00	100.00	564	4203	CONTRATACION ANUAL DE DOMINIO\nWWW.APA-MADREALBERTA.COM	0	0.00	\N
1221	12.00	22.78	16.00	0.00	564	4541	HOSTING PLAN BASE BÁSICO ANUAL	1	0.00	\N
1065	1.00	40.20	16.00	0.00	489	4208	MANTENIMIENTO BULMAGES FEBRERO	0	0.00	\N
1066	1.00	67.00	16.00	0.00	489	4207	MANTENIMIENTO HARDWARE FEBRERO	1	0.00	\N
1067	1.00	40.20	16.00	0.00	490	4217	MANTENIMIENTO BFACT FEBRERO	0	0.00	\N
1226	1.00	8.04	16.00	100.00	567	4180	DESPLAZAMIENTO PALMA	0	0.00	\N
1227	1.00	46.90	16.00	0.00	567	4179	INSTALACION / HORA	1	0.00	\N
1228	1.00	26.04	16.00	0.00	567	4030	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	2	0.00	\N
1239	1.00	160.80	16.00	0.00	572	4560	MANTENIMIENTO ANUAL BULMAGES HASTA 11/05/2008	0	0.00	\N
1224	1.00	40.20	16.00	0.00	566	4208	MANTENIMIENTO BULMAGES MAYO	0	0.00	\N
1225	1.00	67.00	16.00	0.00	566	4207	MANTENIMIENTO HARDWARE MAYO	1	0.00	\N
1222	1.00	16.79	16.00	0.00	565	3001	LECTOR/GRAB. TARJETAS DE MEMORIA USB 2.0 CARD	0	0.00	\N
1223	1.00	40.20	16.00	0.00	565	4217	MANTENIMIENTO BFACT MAYO	1	0.00	\N
1208	1.00	40.20	16.00	0.00	557	4203	RENOVACION DE DOMINIO\nINFOPOLLENSA.NET	0	0.00	\N
1209	4.00	46.90	16.00	30.00	558	4179	INSTALACION / HORA	0	0.00	\N
1210	1.00	12.92	16.00	0.00	558	3825	CABLE UTP CAT.5E 30 MTS MARFIL PL 101	1	0.00	\N
1211	1.00	1.92	16.00	0.00	558	3159	CONECTOR MACHO RJ45 UTP 7 UNDS.	2	0.00	\N
1212	1.00	4.02	16.00	0.00	558	2896	ROSETA RJ45 CAT. 5E UTP 2 TOMAS	3	0.00	\N
1231	1.00	482.40	16.00	0.00	569	4553	HOSTING ANUAL GIBPROMOCIONES.COM	0	0.00	\N
1232	1.00	40.20	16.00	100.00	569	4203	CONTRATACION ANUAL DE DOMINIO\nwww.gibpromociones.com	1	0.00	\N
1074	1.50	0.00	16.00	0.00	492	4184	HORAS CONTRATO	0	0.00	\N
1075	1.00	0.00	16.00	0.00	492	4185	DESPLAZAMIENTO CONTRATO	1	0.00	\N
1076	1.00	232.09	16.00	0.00	492	4187	BROTHER HL-2070N	2	0.00	\N
1077	1.00	1.29	16.00	0.00	492	2843	CABLE USB 1,8MT A/B MM   SB 2402	3	0.00	\N
1078	1.00	167.26	16.00	0.00	492	2852	SOFT. WINDOWS XP PROFESIONAL OEM	4	0.00	\N
1233	1.00	241.20	16.00	0.00	570	4237	CONFIGURACION E INSTALACION OPENVPN	0	0.00	\N
1241	1.00	437.97	16.00	0.00	574	3937	SWITCH NETGEAR JGS524GE 24 PUERTOS 10/100/100	0	0.00	\N
1242	3.00	2.43	16.00	0.00	574	2892	LATIGUILLO FTP CAT.5E DE 2 MTS MARFIL PL1202\nSA GERRERIA	1	0.00	\N
1243	1.00	2.02	16.00	0.00	574	2889	LATIGUILLO UTP CAT.5E DE 5 MTS MARFIL PL1005	2	0.00	\N
1244	1.00	1.68	16.00	0.00	574	2889	LATIGUILLO UTP CAT.5E DE 4 MTS MARFIL PL1005	3	0.00	\N
1245	1.00	160.80	16.00	0.00	575	4215	MANTENIMIENTO AZUL YATCHS 4 EQUIPOS \nMAYO	0	0.00	\N
1249	1.00	56.28	16.00	0.00	579	4228	HOSTING ESCUELA DEL MAR	0	0.00	\N
1250	1.00	140.70	16.00	0.00	579	4219	MANTENIMIENTO INF. ESCUELA DEL MAR	1	0.00	\N
1251	1.00	46.90	16.00	0.00	579	4218	MANTENIMIENTO RED ESCUELA DEL MAR	2	0.00	\N
1248	1.00	509.20	16.00	0.00	578	4216	MANTENIMIENTO MAYO	0	0.00	\N
1252	1.00	53.60	16.00	0.00	580	4212	ACTUALIZACION DISTRIBUCION LINUX MAYO	0	0.00	\N
1253	1.00	2010.00	16.00	0.00	581	4240	PROGRAMACION BULMAGES	0	0.00	\N
1254	1.00	562.80	16.00	0.00	582	4434	PORTATIL HP NX7300 T5500 1GB 80GB DVD-RW 15.4\n2º COBRO	0	0.00	\N
1089	1.00	46.90	16.00	0.00	496	4179	INSTALACION / HORA\nALBARAN: Num 23Ref: BMAHIEFecha: 03/11/2006	0	0.00	\N
1090	1.00	8.04	16.00	0.00	496	4180	DESPLAZAMIENTO PALMA	1	0.00	\N
1091	0.75	46.90	16.00	0.00	496	4179	INSTALACION / HORA\n(ALBARAN: Num 40Ref: KMSMQNFecha: 17/01/2007)	2	0.00	\N
1092	1.00	8.04	16.00	0.00	496	4180	DESPLAZAMIENTO PALMA	3	0.00	\N
1093	1.00	46.90	16.00	0.00	496	4179	INSTALACION / HORA\n(ALBARAN: Num 41Ref: IDPVMKFecha: 13/02/2007)	4	0.00	\N
1094	1.00	8.04	16.00	0.00	496	4180	DESPLAZAMIENTO PALMA	5	0.00	\N
1096	0.00	46.90	16.00	0.00	496	4179	INSTALACION / HORA\n(ALBARAN: Num 22Ref: CSLKGXFecha: 02/12/2006)	7	0.00	\N
1215	1.00	482.40	16.00	0.00	560	4230	HOSTING ANUAL\nGNLEON.COM\nGESTORIANAUTICALEON.COM\n	0	0.00	\N
1142	1.00	107.35	16.00	0.00	512	4529	BROTHER TAMBOR C-DR200 7820N	3	0.00	\N
1143	1.00	51.43	16.00	100.00	512	4189	TONER NEGRO OKI C3300 (SUSTITUCION)	4	0.00	\N
1144	1.00	0.00	16.00	0.00	512	4185	DESPLAZAMIENTO CONTRATO	5	0.00	\N
1157	1.00	40.20	16.00	0.00	522	4203	CONTRATACION / RENOVACION DE DOMINIOS	0	0.00	\N
1158	1.00	120.60	16.00	0.00	522	4232	HOSTING MARMOLERIAFULLANA.COM\nENERO, FEBRERO, MARZO 2007	1	0.00	\N
1145	2.50	0.00	16.00	0.00	512	4184	HORAS CONTRATO	6	0.00	\N
1146	2.00	40.20	16.00	0.00	512	4500	RW DVD DUAL DL LG 18X8X16X GSA-H42N OEM	7	0.00	\N
1150	1.00	253.26	16.00	0.00	519	4189	QL 1050\nImpresora de etiquetas	0	0.00	\N
1135	1.00	541.36	16.00	0.00	516	4189	OKI C5600N	0	0.00	\N
1136	1.00	268.00	16.00	52.00	516	4189	BANDEJA DUPLEX IMPRESION A DOBLE CARA	1	0.00	\N
1137	1.00	1.29	16.00	0.00	516	2843	CABLE USB 1,8MT A/B MM   SB 2402	2	0.00	\N
1147	1.00	20.10	16.00	0.00	518	4188	CANON LPI BROTHER	0	0.00	\N
1148	1.00	1.29	16.00	0.00	518	2843	CABLE USB 1,8MT A/B MM   SB 2402	1	0.00	\N
1149	1.00	467.66	16.00	0.00	518	4189	BROTHER MFC 7820N	2	0.00	\N
1162	1.00	120.60	16.00	0.00	526	4231	HOSTING JMCREP.COM\nENERO FEBRERO MARZO 2007	0	0.00	\N
1152	1.00	96.23	16.00	0.00	521	3872	GATEWAY LINKSYS WRT54GL WIRELESS 54MBPS + SWI	0	0.00	\N
1153	1.00	56.28	16.00	0.00	521	4228	HOSTING MARZO	1	0.00	\N
1154	1.00	140.70	16.00	0.00	521	4219	MANTENIMIENTO INF. MARZO	2	0.00	\N
1155	1.00	93.80	16.00	0.00	521	4233	PAQUETE 6 DOMINIOS ESCUELA\n(HASTA MARZO 2008)	3	0.00	\N
1156	1.00	46.90	16.00	0.00	521	4218	MANTENIMIENTO REDMARZO	4	0.00	\N
1159	1.00	120.60	16.00	0.00	523	4236	HOSTING VIAMAR-IBIZA.COM\nENERO, FEBRERO, MARZO 2007	0	0.00	\N
1161	1.00	53.60	16.00	0.00	525	4212	PCI - ACTUALIZACION DISTRIBUCION LINUX\nMARZO	0	0.00	\N
1192	2.00	11.54	16.00	0.00	544	3969	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0	4	0.00	\N
1204	1.00	670.00	16.00	0.00	553	4193	PROGRAMACION ESPECIFICA LLABRES FELIU\n"QUIÉN ES QUIÉN"	0	0.00	\N
1207	1.00	482.40	16.00	0.00	556	4540	HOSTING PLAN BASE PROFESIONAL ANUAL\nwww.ajuntament de pollença.com	0	0.00	\N
1234	6.00	81.06	16.00	0.00	571	4528	BROTHER TN2000 MFC/DCP	0	0.00	\N
1235	2.00	14.24	16.00	0.00	571	4198	BROTHER CART. TINTA AZUL LC1000C	1	0.00	\N
1236	2.00	14.24	16.00	0.00	571	4199	BROTHER CART. TINTA MAGENTA LC1000M	2	0.00	\N
1237	2.00	14.24	16.00	0.00	571	4202	BROTHER CART. TINTA AMARILLA LC1000C	3	0.00	\N
1238	1.00	13.69	16.00	0.00	571	4189	CINTA DE PAPEL CONTINUO BLANCA\nDK22214	4	0.00	\N
1217	1.00	201.00	16.00	0.00	561	4179	INSTALACION / HORA	0	0.00	\N
1256	1.00	37.77	16.00	0.00	585	3068	CART. HP COLOR Nº57 PSC 2410 (C6657AE) 17 ml	0	0.00	\N
1257	1.00	22.54	16.00	0.00	585	3067	CART. HP NEGRO Nº56 DJ 5150 OJ 5510 C6656AE 1	1	0.00	\N
1258	2.00	12.19	16.00	0.00	585	3003	CART. JT EPSON C62 CX3200 COLOR 8803JB E71	2	0.00	\N
1259	2.00	10.47	16.00	0.00	585	3012	CART. JT EPSON C62 CX3200 NEGRO 879JB E70	3	0.00	\N
1260	1.00	21.06	16.00	0.00	586	3439	CART. HP COLOR Nº22 PSC1410 DJ3940 5ML	0	0.00	\N
1261	1.00	18.48	16.00	0.00	586	3438	CART. HP NEGRO Nº21 PSC1410 NEGRO 5ML C9351AE	1	0.00	\N
1213	1.00	20.78	16.00	0.00	559	3439	CART. HP COLOR Nº22 PSC1410 DJ3940 5ML	0	0.00	\N
1214	1.00	18.48	16.00	0.00	559	3438	CART. HP NEGRO Nº21 PSC1410 NEGRO 5ML C9351AE	1	0.00	\N
1274	12.00	26.80	16.00	0.00	590	4542	Reparaciones a Particulares	0	0.00	\N
1275	15.00	26.80	16.00	0.00	590	4542	Reparaciones a Particulares	1	0.00	\N
1095	0.00	8.04	16.00	0.00	496	4180	DESPLAZAMIENTO PALMA	6	0.00	\N
1276	12.00	26.80	16.00	0.00	590	4542	Reparaciones a Particulares	2	0.00	\N
1277	15.00	26.80	16.00	0.00	590	4542	Reparaciones a Particulares	3	0.00	\N
1291	1.00	13.40	16.00	0.00	596	4544	Instalacion del SO Linux	0	0.00	\N
1255	1.00	92.80	16.00	0.00	583	4113	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB	0	0.00	\N
1056	1.00	20.10	16.00	0.00	485	4241	REPARACIONES	0	0.00	\N
1216	-1.00	40.20	16.00	0.00	560	4203	RENOVACION DE DOMINIO\nGNLEON.COM (HASTA 16/05/2008)	1	0.00	\N
1219	1.00	670.00	16.00	0.00	563	4211	MANTENIMIENTO SERVIDOR APACHE ANUAL 	0	0.00	\N
1141	1.00	256.96	16.00	0.00	512	3664	SOFT. OFFICE 2003 BASICO	2	0.00	\N
993	1.00	67.00	16.00	0.00	462	4207	MANTENIMIENTO HARDWARE ENERO	1	0.00	\N
1229	1.00	42.88	16.00	0.00	568	4189	REPOSAPIES AJUSTABLE MOD. 5120 ARCHIVO 2000	0	0.00	\N
1230	2.00	41.54	16.00	0.00	568	4189	SOPORTE MONITOR OFFI.SUITE 80311 FELLOWES	1	0.00	\N
982	1.00	1038.50	16.00	0.00	457	4190	EPSON IMPT STYLUS PHOTO R2400 USB A3	0	0.00	\N
991	1.00	40.20	16.00	0.00	461	4217	MANTENIMIENTO BFACT ENERO	0	0.00	\N
998	200.00	18.51	16.00	0.00	464	2880	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00	\N
999	4.00	23.10	16.00	0.00	464	4189	LLAVE MAESTRA CABLE SEGURIDAD PARA PORTATIBLES	2	0.00	\N
1000	1.00	23.10	16.00	100.00	464	4189	LLAVE MAESTRA CABLE SEGURIDAD PARA PORTATIBLES	1	0.00	\N
1016	1.00	46.71	16.00	0.00	470	3227	ACCESS POINT CONCEPTRONIC 54 Mbps C54APM WIRE	0	0.00	\N
1017	1.00	53.81	16.00	0.00	470	2961	MEMORIA DIMM DDR 512 MB 400Mhz KINGSTON	1	0.00	\N
1018	1.00	24.15	16.00	0.00	470	3139	T.RED PCMCIA CONCEPTRONIC WIRELESS 54Mbps C54	2	0.00	\N
1019	1.00	27.11	16.00	0.00	470	3261	HUB USB UH-275 MINI 4 PTOS. USB 2.0 SB 2110	3	0.00	\N
1024	1.00	40.20	16.00	0.00	472	4235	HOSTING IBIZASEACHARTER.COM\nDESDE 25/11/2006 HASTA 31/12/2006	0	0.00	\N
1027	1.00	60.30	16.00	0.00	475	4234	HOSTING CASASCONHISTORIA.NET\nOCTUBRE, NOVIEMBRE Y DICIEMBRE 2006	0	0.00	\N
1020	1.00	32.48	16.00	0.00	470	4106	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	4	0.00	\N
1026	1.00	120.60	16.00	0.00	474	4229	HOSTING FUNGESTUR.ORG \nOCTUBRE, NOVIEMBRE Y DICIEMBRE 2006	0	0.00	\N
1021	1.00	56.28	16.00	0.00	471	4228	HOSTING ENERO	0	0.00	\N
1025	6.00	40.20	16.00	0.00	473	4236	HOSTING VIAMAR-IBIZA.COM\nDESDE 25/06/2006 HASTA 31/12/2006	0	0.00	\N
1001	1.00	802.95	16.00	0.00	465	4189	FEEL INTEL PIV 631 LGA775 3.0GHZ FSB800 2MB	0	0.00	\N
1002	1.00	167.26	16.00	0.00	465	2852	SOFT. WINDOWS XP PROFESIONAL OEM	1	0.00	\N
1004	1.00	241.60	16.00	0.00	465	4220	MANTENIMIENTO ENERO	2	0.00	\N
1022	1.00	140.70	16.00	0.00	471	4219	MANTENIMIENTO INFORMATICO ENERO	1	0.00	\N
1023	1.00	46.90	16.00	0.00	471	4218	MANTENIMIENTO RED ENERO	2	0.00	\N
1028	1.00	53.60	16.00	0.00	476	4212	ACTUALIZACION DISTRIBUCION LINUX\nENERO	0	0.00	\N
1033	1.00	787.92	16.00	0.00	479	4189	EQUIPO FEEL INTEL PIV 641 SIN PERIFÉRICOS\n+ WINDOWS XP PROF.\n	0	0.00	\N
1035	1.00	53.60	16.00	0.00	479	4116	SOFT. ANTIVIRUS PANDA 2007 + FIREWALL + ACT. 	1	0.00	\N
1037	1.00	280.06	16.00	0.00	479	4178	SP CONTAPLUS PRO 2007	2	0.00	\N
1038	1.00	46.90	16.00	0.00	479	4179	INSTALACION / HORA	3	0.00	\N
1039	1.00	8.04	16.00	100.00	479	4180	DESPLAZAMIENTO PALMA	4	0.00	\N
1036	1.00	57.70	16.00	0.00	480	4116	SOFT. ANTIVIRUS PANDA 2007 + FIREWALL + ACT. 	0	0.00	\N
1042	0.50	46.90	16.00	0.00	480	4179	INSTALACION / HORA	1	0.00	\N
1043	1.00	8.04	16.00	100.00	480	4180	DESPLAZAMIENTO PALMA	2	0.00	\N
1045	5.00	18.57	16.00	0.00	482	2880	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00	\N
1029	1.00	46.90	16.00	0.00	477	4179	INSTALACION / HORA	0	0.00	\N
1030	1.00	8.04	16.00	100.00	477	4180	\nDESPLAZAMIENTO PALMA	1	0.00	\N
1031	1.00	280.06	16.00	0.00	477	4178	SP CONTAPLUS PRO 2007	2	0.00	\N
1040	1.00	328.22	16.00	0.00	477	3664	SOFT. OFFICE 2003 PYME OEM	3	0.00	\N
1041	1.00	1077.21	16.00	0.00	477	4189	EQUIPO FEEL INTEL PIV ] PERIFERICOS ] WINDOWSXP PROFFESIO	4	0.00	\N
1032	1.00	268.00	16.00	0.00	478	4179	CONFIGURACION E INSTALACION DE RED\n2 ORDENADORES\nMATERIAL INCLUIDO	0	0.00	\N
1044	1.00	36.10	16.00	0.00	481	3241	BOBINA 50 CD S VERBATIM 700 MB 52X CRYSTAL S-	0	0.00	\N
1055	1.00	771.84	16.00	0.00	484	4204	MANTENIMIENTO FEBREO	0	0.00	\N
1005	1.00	2.43	16.00	100.00	466	2892	LATIGUILLO FTP CAT.5E DE 2 MTS MARFIL PL1202	0	0.00	\N
1006	1.00	46.90	16.00	0.00	466	4179	CONFIGURACION E INSTALACION OPENVPN	1	0.00	\N
1007	2.00	80.40	16.00	0.00	466	4179	CONFIGURACIÓN E INSTALACION DE 1 CLIENTE\nDESCUENTO POR CLIENTE MANTENIMIENTO	2	0.00	\N
1008	1.00	160.80	16.00	0.00	466	4215	MANTENIMIENTO ENERO 4 EQUIPOS 	3	0.00	\N
1009	1.00	232.09	16.00	0.00	467	4187	BROTHER HL-2070N	0	0.00	\N
1010	1.00	353.49	16.00	0.00	467	4183	BROTHER MULTIFUNCION LASER MONOCROMO DCP-7025	1	0.00	\N
1011	1.00	116.58	16.00	0.00	467	4186	BROTHER TINTA COLOR MULTIFUNCION DCP-130\nSERIES: L6F438228	2	0.00	\N
1012	1.00	81.06	16.00	0.00	468	4189	TONER TN-2000 BROTHER HL-2070N, MFC-7820N	0	0.00	\N
1013	1.00	133.29	16.00	0.00	468	3364	TAMBOR OKI C5100 5300 SERIES CYAN	1	0.00	\N
1014	1.00	137.75	16.00	0.00	468	3364	TAMBOR OKI C5100 5300 SERIES CYAN	2	0.00	\N
1262	1.00	13.69	16.00	0.00	587	4562	Cinta de Papel 12x30,48 DK22214	0	0.00	\N
1263	50.00	25.35	16.00	0.00	587	4563	Cinta de Papel 62x30,48 DK22205	1	0.00	\N
1265	1.00	51.43	16.00	0.00	587	4559	OKI TONER AZUL C33/C34	2	0.00	\N
1266	1.00	51.43	16.00	0.00	587	4556	OKI TONER AMARILLO C33/C34	3	0.00	\N
1267	1.00	51.43	16.00	0.00	587	4555	OKI TONER MAGENTA C33/C34	4	0.00	\N
1268	1.00	36.73	16.00	0.00	587	4554	OKI TONER NEGRO C33/C34	5	0.00	\N
1271	2.00	25.89	16.00	0.00	587	4530	CARTUCHO NEGRO C-LC1000BK	6	0.00	\N
1272	3.00	36.73	16.00	0.00	587	4554	OKI TONER NEGRO C33/C34	7	0.00	\N
1273	2.00	107.35	16.00	0.00	587	4529	BROTHER TAMBOR C-DR200	8	0.00	\N
996	1.00	771.84	16.00	0.00	463	4204	MANTENIMIENTO DICIEMBRE 06	0	0.00	\N
997	1.00	771.84	16.00	0.00	463	4204	MANTENIMIENTO ENERO 07	1	0.00	\N
\.


--
-- Data for Name: lfacturap; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lfacturap (idlfacturap, desclfacturap, cantlfacturap, pvplfacturap, ivalfacturap, descuentolfacturap, idfacturap, idarticulo, ordenlfacturap, reqeqlfacturap, lotelfacturap) FROM stdin;
750	LATIGUILLO UTP CAT.5E ROJO 1 Mt. PL3001	1.00	0.78	16.00	0.00	218	3449	6	0.00	\N
751	HUB USB UH-275 MINI 4 PTOS. USB 2.0 SB 2110\nSERIES Z8610188AB0161	1.00	20.23	16.00	0.00	218	3261	7	0.00	\N
752	R FINANCIERO	1.00	0.11	16.00	0.00	218	4192	8	0.00	\N
759	Tarjetas visita	1.00	215.55	16.00	0.00	223	4189	0	0.00	\N
756	BASE SUJETA	1.00	22.85	16.00	0.00	220	4189	0	0.00	\N
757	BASE NO SUJETA	1.00	21.54	16.00	0.00	220	4189	1	0.00	\N
758	SUPLIDO	1.00	2.70	16.00	1.00	220	4189	2	0.00	\N
762	CARTUCHO NEGRO C-LC1000BK	1.00	13.91	16.00	0.00	224	4530	0	0.00	\N
760	BROTHER TN2000 MFC/DCP	6.00	43.56	16.00	0.00	224	4528	1	0.00	\N
761	BROTHER TAMBOR C-DR200	1.00	57.68	16.00	0.00	224	4529	2	0.00	\N
764	BROTHER CART. TINTA MAGENTA LC1000M	1.00	7.66	16.00	0.00	224	4199	3	0.00	\N
765	BROTHER CART. TINTA AZUL LC1000C	1.00	7.66	16.00	0.00	224	4198	4	0.00	\N
763	BROTHER CART. TINTA AMARILLA LC1000C	1.00	7.66	16.00	0.00	224	4202	5	0.00	\N
766	BROTHER TAMBOR C-DR200	1.00	57.68	16.00	0.00	225	4529	0	0.00	\N
776	R FINANCIERO	1.00	3.84	16.00	0.00	227	4192	0	0.00	\N
775	ORDENADOR MONTADO SERIE FEEL	2.00	640.00	16.00	0.00	227	4549	1	0.00	\N
784	EP CART C32 BLACK	1.00	68.33	16.00	0.00	229	4189	0	0.00	\N
786	R FINANCIERO	1.00	1.20	16.00	0.00	230	4192	0	0.00	\N
785	ORDENADOR MONTADO SERIE FEEL	1.00	399.36	16.00	0.00	230	4549	1	0.00	\N
787	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	1.00	203.18	16.00	0.00	231	4011	0	0.00	\N
790	TFT 19"  BELINEA 1925 S1W PANORAMICO MM NEGRO	1.00	178.89	16.00	0.00	231	4134	1	0.00	\N
788	TECLADO NGS PLANET OFFICE 125 TECLAS MM USB	1.00	13.81	16.00	0.00	231	3477	2	0.00	\N
793	R FINANCIERO	1.00	1.49	16.00	0.00	231	4192	3	0.00	\N
789	PB ASROCK P4i65G i865G SATA VGA SON LAN DDR40	1.00	38.75	16.00	0.00	231	3754	4	0.00	\N
792	CONECTOR MACHO RJ45 UTP (BOLSA DE 10 U.) TD10	4.00	1.19	16.00	0.00	231	3159	5	0.00	\N
791	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	5.00	11.16	16.00	0.00	231	2880	6	0.00	\N
796	R FINANCIERO	1.00	6.60	16.00	0.00	232	4192	0	0.00	\N
794	CABLE VGA M/M 1.8M AK3225	1.00	2.24	16.00	0.00	232	2836	1	0.00	\N
795	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	200.00	10.99	16.00	0.00	232	2880	2	0.00	\N
799	R FINANCIERO	1.00	0.01	16.00	0.00	233	4192	0	0.00	\N
798	CABLE VGA M/M 1.8M AK3225	1.00	2.24	16.00	0.00	233	2836	1	0.00	\N
797	CABLE USB 1,8MT A/B MM   SB 2402	1.00	0.80	16.00	0.00	233	2843	2	0.00	\N
801	TECLADO LOGITECH ULTRA-FLAT KEYBOARD	1.00	13.53	16.00	0.00	234	4330	0	0.00	\N
803	R FINANCIERO	1.00	0.51	16.00	0.00	234	4192	1	0.00	\N
800	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON	2.00	70.44	16.00	0.00	234	3339	2	0.00	\N
802	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	1.00	16.13	16.00	0.00	234	4030	3	0.00	\N
804	T.RED USB CONCEPTRONIC WIRELESS 54Mbps C54RU	1.00	17.89	16.00	0.00	237	3347	0	0.00	\N
805	R FINANCIERO	1.00	0.05	16.00	0.00	237	4192	1	0.00	\N
808	SOFT. WINDOWS XP PROFESIONAL OEM	1.00	113.79	16.00	0.00	238	2852	0	0.00	\N
810	R FINANCIERO	1.00	0.50	16.00	0.00	238	4192	1	0.00	\N
806	CART. JT EPSON C62 CX3200 NEGRO 879JB E70	3.00	6.48	16.00	0.00	238	3012	2	0.00	\N
807	CART. JT EPSON C62 CX3200 COLOR 8803JB E71	1.00	7.55	16.00	0.00	238	3003	3	0.00	\N
809	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	24.26	16.00	0.00	238	4106	4	0.00	\N
811	SOFT. ANTIVIRUS PANDA 2007 + FIREWALL 3 LICENCIAS	1.00	32.30	16.00	0.00	239	4366	0	0.00	\N
813	CANON GESTION RESIDUOS	1.00	0.01	16.00	0.00	239	4189	1	0.00	\N
812	PORTES	1.00	10.00	16.00	0.00	239	4191	2	0.00	\N
814	BROTHER HL-2070N	1.00	173.20	16.00	0.00	240	4187	0	0.00	\N
817	CANON LPI BROTHER	2.00	15.00	16.00	0.00	241	4188	0	0.00	\N
815	BROTHER TINTA COLOR MULTIFUNCION DCP-130	1.00	57.60	16.00	0.00	241	4186	1	0.00	\N
816	BROTHER MULTIFUNCION LASER MONOCROMO DCP-7025	1.00	263.80	16.00	0.00	241	4183	2	0.00	\N
821	R FINANCIERO	1.00	0.21	16.00	0.00	242	4192	0	0.00	\N
820	MEMORIA COMPACT FLASH VERBATIM CF 4 GB	1.00	61.98	16.00	0.00	242	4148	1	0.00	\N
818	CABLE USB 3MT A/B MM   SB2403	5.00	1.20	16.00	0.00	242	2841	2	0.00	\N
819	CABLE USB 1,8MT A/B MM   SB 2402	2.00	0.80	16.00	0.00	242	2843	3	0.00	\N
822	TELEFONO ] INTERNET	1.00	116.61	16.00	0.00	243	4189	0	0.00	\N
824	R FINANCIERO	1.00	1.05	16.00	0.00	244	4192	0	0.00	\N
823	ORDENADOR MONTADO SERIE FEEL	1.00	350.00	16.00	0.00	244	4549	1	0.00	\N
825	SERVICIOS TELEFONO E INTERNET	1.00	135.14	16.00	0.00	245	4189	0	0.00	\N
827	SOFT. OFFICE 2003 BASIC 2003 SERV OEM	1.00	162.73	16.00	0.00	246	3664	0	0.00	\N
832	R FINANCIERO	1.00	0.76	16.00	0.00	246	4192	1	0.00	\N
828	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0	2.00	6.90	16.00	0.00	246	3969	2	0.00	\N
830	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340	1.00	6.90	16.00	0.00	246	4003	3	0.00	\N
829	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0	1.00	6.90	16.00	0.00	246	4002	4	0.00	\N
831	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144	1.00	6.81	16.00	0.00	246	4004	5	0.00	\N
826	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	5.00	11.50	16.00	0.00	246	2880	6	0.00	\N
834	CANON LPI BROTHER	1.00	15.00	16.00	0.00	247	4188	0	0.00	\N
833	BROTHER MFC 5460 CN	1.00	118.40	16.00	0.00	247	4194	1	0.00	\N
835	ADAPTADOR CONCEPTRONIC USB 2.0 SATA/IDE CSATA	1.00	24.31	16.00	0.00	248	4106	0	0.00	\N
836	TECLADO NGS ZENITH 17 TECLAS MULTIMEDIA USB	1.00	6.83	16.00	0.00	248	3470	1	0.00	\N
837	R FINANCIERO	1.00	0.09	16.00	0.00	248	4192	2	0.00	\N
840	certificado final de obra	1.00	600.00	16.00	0.00	250	4189	0	0.00	\N
753	PORTES	1.00	14.00	16.00	0.00	219	4191	0	0.00	\N
754	EPSON IMPT STYLUS PHOTO R2400 USB A3	1.00	678.13	16.00	0.00	219	4190	1	0.00	\N
755	SP CONTAPLUS PRO 2007	2.00	162.76	16.00	0.00	219	4178	2	0.00	\N
848	BROTHER TN2000 MFC/DCP	6.00	43.56	16.00	0.00	253	4528	0	0.00	\N
849	BROTHER CART. TINTA AMARILLA LC1000C	2.00	7.66	16.00	0.00	253	4202	1	0.00	\N
850	BROTHER CART. TINTA MAGENTA LC1000M	2.00	7.66	16.00	0.00	253	4199	2	0.00	\N
851	BROTHER CART. TINTA AZUL LC1000C	2.00	7.66	16.00	0.00	253	4198	3	0.00	\N
852	Cinta de Papel 12x30,48 DK22214	1.00	5.68	16.00	0.00	253	4562	4	0.00	\N
738	BROTHER MFC 5460 CN	1.00	118.40	16.00	0.00	217	4194	0	0.00	\N
739	CANON LPI BROTHER	1.00	15.00	16.00	0.00	217	4188	1	0.00	\N
740	BROTHER CART. TINTA AMARILLA LC1000C	2.00	7.66	16.00	0.00	217	4202	2	0.00	\N
741	BROTHER CARTUCHO TINTA NEGRA LC1000HYBK	5.00	18.86	16.00	0.00	217	4197	3	0.00	\N
742	BROTHER CART. TINTA AZUL LC1000C	2.00	7.66	16.00	0.00	217	4198	4	0.00	\N
743	\nBROTHER CART. TINTA MAGENTA LC1000M	2.00	7.66	16.00	0.00	217	4199	5	0.00	\N
844	OKI TONER NEGRO C33/C34	1.00	21.93	16.00	0.00	252	4554	0	0.00	\N
845	OKI TONER AZUL C33/C34	1.00	30.70	16.00	0.00	252	4559	1	0.00	\N
846	OKI TONER MAGENTA C33/C34	1.00	30.70	16.00	0.00	252	4555	2	0.00	\N
847	OKI TONER AMARILLO C33/C34	1.00	30.70	16.00	0.00	252	4556	3	0.00	\N
859	Cinta de Papel 12x30,48 DK22214	1.00	5.68	16.00	0.00	257	4562	0	0.00	\N
860	Cinta de Papel 62x30,48 DK22205	50.00	10.51	16.00	0.00	257	4563	1	0.00	\N
861	TN3060 BROTHER 8220/8045/8440/8840	1.00	62.84	16.00	0.00	258	4565	0	0.00	\N
862	OKI TONER NEGRO C33/C34	1.00	21.93	16.00	0.00	259	4554	0	0.00	\N
863	OKI TONER MAGENTA C33/C34	1.00	30.70	16.00	0.00	259	4555	1	0.00	\N
864	BROTHER TN2000 MFC/DCP	2.00	43.56	16.00	0.00	259	4528	2	0.00	\N
865	BROTHER HL-2070N	1.00	130.80	16.00	0.00	260	4187	0	0.00	\N
866	IMPRESORA DE ETIQUETAS QL-1050\nSERIES: A7G111104	1.00	141.75	16.00	0.00	260	4189	1	0.00	\N
868	BROTHER TAMBOR C-DR200	1.00	57.68	16.00	0.00	262	4529	0	0.00	\N
869	FIXING UNIT 230V LE7343001 FUSOR BROTHER	1.00	40.12	16.00	0.00	263	4567	0	0.00	\N
870	REPARACIONES	1.00	40.00	16.00	0.00	263	4241	1	0.00	\N
841	CPU INTEL CORE2 DUO E4300 1.8 GHZ FSB800 2MB	1.00	128.33	16.00	0.00	251	4503	0	0.00	\N
842	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	3.00	16.11	16.00	0.00	251	4030	1	0.00	\N
843	HUB USB MINI CONCEPTRONIC 4 PTOS CSPUSB4	2.00	6.92	16.00	0.00	251	2905	2	0.00	\N
853	CARTUCHO NEGRO C-LC1000BK	2.00	13.91	16.00	0.00	255	4530	0	0.00	\N
854	OKI TONER NEGRO C33/C34	3.00	21.93	16.00	0.00	255	4554	1	0.00	\N
855	CANON LPI BROTHER	1.00	15.00	16.00	0.00	255	4188	2	0.00	\N
731	RATON NGS CRUSADER 2 BOTONES PS2	2.00	2.25	16.00	0.00	216	3423	0	\N	\N
732	RATON NGS EVO PRO POWERED OPTICO USB	1.00	5.31	16.00	0.00	216	3239	1	\N	\N
733	RATON LOGITECH VALUE OPTICAL OEM S90 NEGRO PS	1.00	5.25	16.00	0.00	216	3710	2	\N	\N
734	TECLADO NGS ZENITH 17 TECLAS MULTIMEDIA USB	1.00	6.83	16.00	0.00	216	3470	3	\N	\N
735	TECLADO NGS CUTEWHITE 108 TECLAS BLANCO	1.00	4.10	16.00	0.00	216	3254	4	\N	\N
736	\n\nDESPLAZAMIENTO PALMA	1.00	0.10	16.00	0.00	216	4192	5	\N	\N
737	\nRATON LOGITECH VALUE OPTICAL OEM S90 NEGRO PS	1.00	6.24	16.00	0.00	216	3710	6	\N	\N
747	LATIGUILLO UTP CAT.5E AZUL 1.5M. PL2051	1.00	0.75	16.00	0.00	218	3144	1	0.00	\N
746	ARCHIVADOR CD S NGS WALLETS CAR 12 U	1.00	3.17	16.00	0.00	218	3431	2	0.00	\N
745	RATON LOGITECH PILOT  WHEEL OPT OEM S96 BLANC	1.00	6.30	16.00	0.00	218	3328	3	0.00	\N
744	CABLE USB 5MT A/B MM   SB2405	2.00	2.07	16.00	0.00	218	2842	4	0.00	\N
749	LATIGUILLO UTP CAT.5E ROJO 1.5 Mt. IB5551	1.00	0.75	16.00	0.00	218	3826	5	0.00	\N
856	DCP130C IMP. BROTHER COLOR MULTIFUNCION	1.00	52.70	16.00	0.00	255	4566	3	0.00	\N
768	SWITCH CONCEPTRONIC 8 PTOS. 10/100/1000  CGIG	1.00	53.56	16.00	0.00	226	3640	0	0.00	\N
774	R FINANCIERO	1.00	1.07	16.00	0.00	226	4192	1	0.00	\N
773	PORTES	1.00	4.51	16.00	0.00	226	4191	2	0.00	\N
769	IMPRESORA EPSON STYLUS D78 USB DINA4 22PPM 57	1.00	50.00	16.00	0.00	226	3878	3	0.00	\N
771	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB	1.00	57.48	16.00	0.00	226	4113	4	0.00	\N
770	CART. HP NEGRO Nº56 DJ 5150 OJ 5510 C6656AE 1	2.00	13.96	16.00	0.00	226	3067	5	0.00	\N
767	CART. HP COLOR Nº57 PSC 2410 (C6657AE) 17 ml	2.00	23.40	16.00	0.00	226	3068	6	0.00	\N
772	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	10.00	11.50	16.00	0.00	226	2880	7	0.00	\N
838	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	1.00	184.17	16.00	0.00	249	4011	0	0.00	\N
839	R FINANCIERO	1.00	0.55	16.00	0.00	249	4192	1	0.00	\N
748	LATIGUILLO UTP CAT.5E VERDE 1 Mt. IB5701	1.00	0.63	16.00	0.00	218	3450	0	0.00	\N
\.


--
-- Data for Name: log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY log (idlog, iplog, urllog, fechalog, useragentlog, getlog, postlog, sessionlog) FROM stdin;
580	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-29-18:27:54	Opera/9.23 (Windows NT 5.1; U; es-es)			<usuario>arturo</usuario>\n<password>arturo</password>\n
607	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:56:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
634	-1062731728	omicron/~arturo/factuweb/web/index.php?m=cliente_listado	2007-11-29-19:16:03	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
661	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_editar&idalbaranp=32	2007-11-30-09:34:55	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_editar.php</m>\n<idalbaranp>32</idalbaranp>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
688	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_listado	2007-11-30-10:01:01	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
715	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_listado	2007-11-30-11:15:37	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
742	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_listado	2007-11-30-12:11:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
769	-1062731728	omicron/~arturo/factuweb/web/	2007-11-30-13:03:56	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
796	-1062731728	omicron/~arturo/factuweb/web/index.php?m=cobro_listado	2007-11-30-13:07:19	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>cobro_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
823	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-13:34:01	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
850	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:46	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
877	-1062731728	omicron/~arturo/factuweb/web/?m=trabajador_listado	2007-11-30-17:28:10	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
904	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_editar&idfacturap=220	2007-11-30-18:03:56	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_editar.php</m>\n<idfacturap>220</idfacturap>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
931	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_listado	2007-11-30-18:19:10	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
958	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:03:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
985	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=6	2007-12-03-11:17:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>6</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1012	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:45:50	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
581	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-29-18:27:55	Opera/9.23 (Windows NT 5.1; U; es-es)			<usuario>arturo</usuario>\n<password>arturo</password>\n
608	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:58:01	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
635	-1062731728	omicron/~arturo/factuweb/web/index.php?m=serie_factura_listado	2007-11-29-19:16:11	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>serie_factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
662	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_listado	2007-11-30-09:35:27	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
689	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_listado	2007-11-30-10:21:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
716	-1062731525	omicron/~arturo/factuweb/web/	2007-11-30-11:30:59	Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2; .NET CLR 1.1.4322; .NET CLR 2.0.50727)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
743	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar&idinventario=8	2007-11-30-12:11:34	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n<idinventario>8</idinventario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
770	-1062731728	omicron/~arturo/factuweb/web/index.php?m=usuario_listado	2007-11-30-13:04:32	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
797	-1062731728	omicron/~arturo/factuweb/web/index.php?m=cobro_editar	2007-11-30-13:07:21	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>cobro_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
824	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-13:34:04	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
851	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:46	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
878	-1062731728	omicron/~arturo/factuweb/web/?m=usuario_listado	2007-11-30-17:28:15	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
905	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_editar&idfacturap=220	2007-11-30-18:05:34	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_editar.php</m>\n<idfacturap>220</idfacturap>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
932	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_editar&idalmacen=2	2007-11-30-18:19:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_editar.php</m>\n<idalmacen>2</idalmacen>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
959	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:03:13	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
986	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=6	2007-12-03-11:17:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>6</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1013	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:46:12	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
582	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-29-18:28:08	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10			<usuario>arturo</usuario>\n<password>arturo</password>\n
609	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:58:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
636	-1062731728	omicron/~arturo/factuweb/web/index.php?m=inventario_listado	2007-11-29-19:16:18	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
663	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_editar&idalbaranp=30	2007-11-30-09:35:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_editar.php</m>\n<idalbaranp>30</idalbaranp>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
690	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=563	2007-11-30-10:21:45	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>563</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
717	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-30-11:33:49	Opera/9.23 (Windows NT 5.1; U; es-es)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
744	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar	2007-11-30-12:11:43	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
771	-1062731728	omicron/~arturo/factuweb/web/index.php?m=trabajador_listado	2007-11-30-13:04:38	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
798	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidoproveedor_listado	2007-11-30-13:07:23	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pedidoproveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
825	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-13:34:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
852	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:52	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
879	-1062731728	omicron/~arturo/factuweb/web/?m=moneda_listado	2007-11-30-17:28:21	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>moneda_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
906	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_editar&idfacturap=220	2007-11-30-18:06:42	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_editar.php</m>\n<idfacturap>220</idfacturap>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
933	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cliente_listado	2007-11-30-18:19:26	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
960	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:03:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
987	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-12-03-11:17:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1014	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:46:15	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
583	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_editar&idpago=90	2007-11-29-18:29:45	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_editar.php</m>\n<idpago>90</idpago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
610	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-19:00:45	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
637	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pais_listado	2007-11-29-19:16:20	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
664	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_listado	2007-11-30-09:35:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
691	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=563	2007-11-30-10:22:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>563</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
718	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_listado	2007-11-30-11:35:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
745	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_listado	2007-11-30-12:11:47	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
772	-1062731728	omicron/~arturo/factuweb/web/index.php?m=proveedor_listado	2007-11-30-13:04:49	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>proveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
799	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidoproveedor_editar	2007-11-30-13:07:26	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pedidoproveedor_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
826	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_editar&idtipo_iva=1	2007-11-30-13:34:16	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_editar.php</m>\n<idtipo_iva>1</idtipo_iva>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
853	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:51:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
880	-1062731728	omicron/~arturo/factuweb/web/?m=pais_listado	2007-11-30-17:28:25	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
907	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_editar	2007-11-30-18:07:05	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
934	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cliente_editar&idcliente=3	2007-11-30-18:19:29	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cliente_editar.php</m>\n<idcliente>3</idcliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
961	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:03:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
988	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=6	2007-12-03-11:17:35	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>6</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1015	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:46:39	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
584	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_listado	2007-11-29-18:30:16	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
611	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-19:02:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
638	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_iva_listado	2007-11-29-19:16:23	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
665	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_editar&idfacturap=218	2007-11-30-09:35:40	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_editar.php</m>\n<idfacturap>218</idfacturap>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
692	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=563	2007-11-30-10:23:04	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>563</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
719	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_editar&idalmacen=1	2007-11-30-11:35:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_editar.php</m>\n<idalmacen>1</idalmacen>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
746	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar&idinventario=8	2007-11-30-12:11:48	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n<idinventario>8</idinventario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
773	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-13:04:52	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
800	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidoproveedor_editar	2007-11-30-13:07:29	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pedidoproveedor_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
827	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_editar	2007-11-30-13:34:20	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
854	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:51:24	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
881	-1062731728	omicron/~arturo/factuweb/web/?m=pais_editar&idpais=4	2007-11-30-17:28:30	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pais_editar.php</m>\n<idpais>4</idpais>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
908	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_listado	2007-11-30-18:07:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
935	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_listado	2007-11-30-18:19:42	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
962	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:03:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
989	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=6	2007-12-03-11:17:35	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>6</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1016	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:46:45	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
585	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_editar&idpago=90	2007-11-29-18:30:18	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_editar.php</m>\n<idpago>90</idpago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
612	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-29-19:03:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
639	-1062731728	omicron/~arturo/factuweb/web/index.php?m=trabajador_listado	2007-11-29-19:16:29	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
666	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_listado	2007-11-30-09:36:45	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
693	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=563	2007-11-30-10:23:33	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>563</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
720	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_editar&idalmacen=1	2007-11-30-11:37:06	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_editar.php</m>\n<idalmacen>1</idalmacen>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
747	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar&idinventario=8	2007-11-30-12:13:35	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n<idinventario>8</idinventario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
774	-1062731728	omicron/~arturo/factuweb/web/index.php?m=proveedor_listado	2007-11-30-13:04:54	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>proveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
801	-1062731728	omicron/~arturo/factuweb/web/index.php?m=albaranp_listado	2007-11-30-13:07:32	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>albaranp_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
828	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-13:34:22	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
855	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:51:25	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
882	-1062731728	omicron/~arturo/factuweb/web/?m=almacen_listado	2007-11-30-17:28:45	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>almacen_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
909	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_editar&idpago=90	2007-11-30-18:07:14	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_editar.php</m>\n<idpago>90</idpago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
936	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar&idinventario=8	2007-11-30-18:19:43	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n<idinventario>8</idinventario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
963	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:03:52	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
990	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-12-03-11:17:39	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1017	-1062731728	omicron/~arturo/factuweb/web/	2007-12-04-19:13:36	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
586	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_listado	2007-11-29-18:30:21	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
613	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-19:03:14	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
640	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_listado	2007-11-30-09:25:46	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_listado.php</m>\n	<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
667	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_editar&idalbaranp=32	2007-11-30-09:36:47	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_editar.php</m>\n<idalbaranp>32</idalbaranp>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
694	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=563	2007-11-30-10:23:45	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>563</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
721	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cliente_listado	2007-11-30-11:37:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
748	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar	2007-11-30-12:13:43	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
775	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pais_listado	2007-11-30-13:04:57	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
802	-1062731728	omicron/~arturo/factuweb/web/index.php?m=albaranp_editar	2007-11-30-13:07:34	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>albaranp_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
829	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_editar	2007-11-30-13:34:29	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
856	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-13:51:49	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
883	-1062731728	omicron/~arturo/factuweb/web/?m=cliente_listado	2007-11-30-17:37:59	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
910	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_editar&idpago=90	2007-11-30-18:14:43	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_editar.php</m>\n<idpago>90</idpago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
937	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_listado	2007-11-30-18:20:02	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
964	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:04:09	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
991	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-12-03-11:17:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1018	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-19:17:38	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
587	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_listado	2007-11-29-18:35:49	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
614	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar	2007-11-29-19:03:18	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
641	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_listado&orden=idpedidocliente&buscar=&buscapor=&offset=30	2007-11-30-09:25:49	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_listado.php</m>\n<orden>idpedidocliente</orden>\n<buscar></buscar>\n<buscapor></buscapor>\n<offset>30</offset>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
668	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_listado	2007-11-30-09:36:52	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
695	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=563	2007-11-30-10:24:48	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>563</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
722	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cliente_editar&idcliente=1	2007-11-30-11:37:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cliente_editar.php</m>\n<idcliente>1</idcliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
749	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar&idinventario=8	2007-11-30-12:13:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n<idinventario>8</idinventario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
776	-1062731728	omicron/~arturo/factuweb/web/index.php?m=moneda_listado	2007-11-30-13:05:01	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>moneda_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
803	-1062731728	omicron/~arturo/factuweb/web/index.php?m=facturap_listado	2007-11-30-13:07:36	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>facturap_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
830	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_editar	2007-11-30-13:35:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
857	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-13:52:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
884	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_listado	2007-11-30-17:51:08	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_listado.php</m>\n	<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
911	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_listado	2007-11-30-18:15:04	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
938	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_editar&idpais=3	2007-11-30-18:20:05	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_editar.php</m>\n<idpais>3</idpais>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
965	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:04:09	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
992	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-12-03-11:17:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1019	-1062731728	omicron/~arturo/factuweb/web/index.php?m=articulo_listado	2007-12-04-19:17:42	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
588	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_listado	2007-11-29-18:36:41	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
615	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_listado	2007-11-29-19:03:21	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
642	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_editar&idpedidocliente=332	2007-11-30-09:25:54	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_editar.php</m>\n<idpedidocliente>332</idpedidocliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
669	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_editar&idfacturap=219	2007-11-30-09:36:55	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_editar.php</m>\n<idfacturap>219</idfacturap>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
696	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_listado	2007-11-30-10:25:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
723	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_listado	2007-11-30-11:38:18	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
750	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar&idinventario=8	2007-11-30-12:14:17	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n<idinventario>8</idinventario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
777	-1062731728	omicron/~arturo/factuweb/web/index.php?m=inventario_listado	2007-11-30-13:05:05	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
804	-1062731728	omicron/~arturo/factuweb/web/index.php?m=facturap_editar	2007-11-30-13:07:39	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>facturap_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
831	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-13:35:37	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
858	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-16:47:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n	<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
885	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_listado&orden=idarticulo&buscar=&buscapor=&offset=30	2007-11-30-17:51:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_listado.php</m>\n<orden>idarticulo</orden>\n<buscar></buscar>\n<buscapor></buscapor>\n<offset>30</offset>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
912	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=2	2007-11-30-18:15:07	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>2</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
939	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-11-30-18:20:19	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
966	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:04:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
993	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-12-03-11:19:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1020	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidoproveedor_listado	2007-12-04-19:17:55	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>pedidoproveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
589	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=1	2007-11-29-18:36:43	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>1</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
616	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-29-19:13:57	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10			<usuario>arturo</usuario>\n<password>arturo</password>\n
643	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_listado	2007-11-30-09:26:05	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
670	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_listado	2007-11-30-09:37:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
697	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=564	2007-11-30-10:25:34	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>564</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
724	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_listado	2007-11-30-11:40:08	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
751	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_listado	2007-11-30-12:14:25	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
778	-1062731728	omicron/~arturo/factuweb/web/index.php?m=serie_factura_listado	2007-11-30-13:05:08	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>serie_factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
805	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pago_listado	2007-11-30-13:07:44	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
832	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_editar&idtipo_iva=2	2007-11-30-13:35:40	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_editar.php</m>\n<idtipo_iva>2</idtipo_iva>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
859	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-16:47:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n	<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
886	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_editar&idarticulo=2844	2007-11-30-17:51:15	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_editar.php</m>\n<idarticulo>2844</idarticulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
913	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-30-18:15:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
940	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-11-30-18:20:20	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
967	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:04:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
994	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-12-03-11:19:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1021	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidoproveedor_editar&idpedidoproveedor=34	2007-12-04-19:17:56	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>pedidoproveedor_editar.php</m>\n<idpedidoproveedor>34</idpedidoproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
590	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=1	2007-11-29-18:36:45	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>1</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
617	-1062731728	omicron/~arturo/factuweb/web/index.php?m=articulo_listado	2007-11-29-19:13:59	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
644	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_editar&idarticulo=2814	2007-11-30-09:26:09	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_editar.php</m>\n<idarticulo>2814</idarticulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
671	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_editar&idpago=90	2007-11-30-09:37:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_editar.php</m>\n<idpago>90</idpago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
698	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar	2007-11-30-10:25:39	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
725	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar&codigoserie_factura=DD	2007-11-30-11:40:15	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n<codigoserie_factura>DD</codigoserie_factura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
752	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_editar	2007-11-30-12:14:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
779	-1062731728	omicron/~arturo/factuweb/web/index.php?m=cliente_listado	2007-11-30-13:05:10	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
806	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pago_editar&idpago=89	2007-11-30-13:07:55	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pago_editar.php</m>\n<idpago>89</idpago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
833	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-11-30-13:36:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
860	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar	2007-11-30-16:48:21	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
887	-1062731740	omicron/~ivan/factuweb/web/index.php?m=familia_listado	2007-11-30-17:52:24	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>familia_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
914	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-30-18:15:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
941	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-11-30-18:20:21	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
968	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_listado	2007-12-03-11:04:39	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
995	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-12-03-11:20:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1022	-1062731728	omicron/~arturo/factuweb/web/index.php?m=cliente_listado	2007-12-04-19:18:20	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
591	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=1	2007-11-29-18:36:55	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>1</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
618	-1062731728	omicron/~arturo/factuweb/web/index.php?m=articulo_editar&idarticulo=2814	2007-11-29-19:14:02	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>articulo_editar.php</m>\n<idarticulo>2814</idarticulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
645	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_listado	2007-11-30-09:27:05	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
672	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_listado	2007-11-30-09:38:11	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
699	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_listado	2007-11-30-10:25:42	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
726	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar&codigoserie_factura=DD	2007-11-30-11:49:41	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n<codigoserie_factura>DD</codigoserie_factura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
753	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_listado	2007-11-30-12:14:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
780	-1062731728	omicron/~arturo/factuweb/web/	2007-11-30-13:05:28	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
807	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pago_editar	2007-11-30-13:08:25	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pago_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
834	-1062731740	omicron/~arturo/factuweb/web/	2007-11-30-13:36:15	Mozilla/5.0 (compatible; Konqueror/3.5; Linux) KHTML/3.5.6 (like Gecko) (Kubuntu)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
861	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar	2007-11-30-16:49:11	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
888	-1062731740	omicron/~ivan/factuweb/web/index.php?m=familia_editar&idfamilia=21	2007-11-30-17:52:26	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>familia_editar.php</m>\n<idfamilia>21</idfamilia>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
915	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-30-18:15:38	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
942	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-11-30-18:20:22	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
969	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_editar&idalmacen=4	2007-12-03-11:04:41	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_editar.php</m>\n<idalmacen>4</idalmacen>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
996	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=8	2007-12-03-11:20:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>8</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1023	-1062731728	omicron/~arturo/factuweb/web/index.php?m=cliente_listado&orden=idcliente&buscar=&buscapor=&offset=30	2007-12-04-19:18:26	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>cliente_listado.php</m>\n<orden>idcliente</orden>\n<buscar></buscar>\n<buscapor></buscapor>\n<offset>30</offset>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
592	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=1	2007-11-29-18:37:07	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>1</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
619	-1062731728	omicron/~arturo/factuweb/web/index.php?m=articulo_editar&idarticulo=2814	2007-11-29-19:14:14	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>articulo_editar.php</m>\n<idarticulo>2814</idarticulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
646	-1062731740	omicron/~ivan/factuweb/web/index.php?m=familia_listado	2007-11-30-09:27:25	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>familia_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
673	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=2	2007-11-30-09:38:13	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>2</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
700	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_listado	2007-11-30-10:45:39	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
727	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar	2007-11-30-11:49:46	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
754	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_listado	2007-11-30-12:27:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
781	-1062731728	omicron/~arturo/factuweb/web/?m=cliente_listado	2007-11-30-13:05:31	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
808	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pago_listado	2007-11-30-13:08:26	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
835	-1062731740	omicron/~arturo/factuweb/web/index.php?m=cliente_listado	2007-11-30-13:37:53	Mozilla/5.0 (compatible; Konqueror/3.5; Linux) KHTML/3.5.6 (like Gecko) (Kubuntu)	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
862	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar	2007-11-30-16:49:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
889	-1062731740	omicron/~ivan/factuweb/web/index.php?m=precio_compra_listado	2007-11-30-17:53:11	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>precio_compra_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
916	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_listado	2007-11-30-18:15:51	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
943	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-18:20:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
970	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-12-03-11:04:48	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
997	-1062731728	omicron/~arturo/factuweb/web/	2007-12-04-12:53:15	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
1024	-1062731728	omicron/~arturo/factuweb/web/index.php?m=cliente_listado&orden=idcliente&buscar=&buscapor=&offset=0	2007-12-04-19:18:27	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>cliente_listado.php</m>\n<orden>idcliente</orden>\n<buscar></buscar>\n<buscapor></buscapor>\n<offset>0</offset>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
593	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=1	2007-11-29-18:37:39	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>1</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
620	-1062731728	omicron/~arturo/factuweb/web/index.php?m=articulo_editar	2007-11-29-19:15:04	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>articulo_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
647	-1062731740	omicron/~ivan/factuweb/web/index.php?m=familia_editar&idfamilia=216	2007-11-30-09:27:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>familia_editar.php</m>\n<idfamilia>216</idfamilia>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
674	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-30-09:38:36	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
701	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_editar&idfactura=457	2007-11-30-10:45:55	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_editar.php</m>\n<idfactura>457</idfactura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
728	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar	2007-11-30-11:50:34	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
755	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_editar	2007-11-30-12:27:49	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
782	-1062731728	omicron/~arturo/factuweb/web/?m=cliente_listado	2007-11-30-13:05:48	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
809	-1062731728	omicron/~arturo/factuweb/web/index.php?m=articulo_listado	2007-11-30-13:08:30	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
836	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-11-30-13:49:10	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
863	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-16:49:39	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
890	-1062731740	omicron/~ivan/factuweb/web/index.php?m=precio_compra_editar	2007-11-30-17:53:17	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>precio_compra_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
917	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=227	2007-11-30-18:16:00	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>presupuesto_editar.php</m>\n<idpresupuesto>227</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
944	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_editar&idtipo_iva=2	2007-11-30-18:20:40	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_editar.php</m>\n<idtipo_iva>2</idtipo_iva>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
971	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:04:50	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
998	-1062731728	omicron/~arturo/factuweb/web/?m=almacen_listado	2007-12-04-12:54:11	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>almacen_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1025	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_listado	2007-12-04-19:18:38	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
594	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=1	2007-11-29-18:37:56	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>1</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
621	-1062731728	omicron/~arturo/factuweb/web/index.php?m=familia_listado	2007-11-29-19:15:06	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>familia_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
648	-1062731740	omicron/~ivan/factuweb/web/index.php?m=precio_compra_listado	2007-11-30-09:27:50	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>precio_compra_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
675	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=226	2007-11-30-09:38:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>226</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
702	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_editar&idfactura=457	2007-11-30-10:46:39	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_editar.php</m>\n<idfactura>457</idfactura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
729	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_listado	2007-11-30-11:50:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
756	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_editar	2007-11-30-12:27:58	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
783	-1062731728	omicron/~arturo/factuweb/web/?m=articulo_listado	2007-11-30-13:05:52	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
810	-1062731728	omicron/~arturo/factuweb/web/index.php?m=articulo_editar	2007-11-30-13:08:32	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>articulo_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
837	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:49:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
864	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar	2007-11-30-16:49:41	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
891	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_articulo_listado	2007-11-30-17:54:08	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
918	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=223	2007-11-30-18:16:24	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>223</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
945	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_listado	2007-11-30-18:21:50	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
972	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:04:50	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
999	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-12:55:49	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
1026	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=224	2007-12-04-19:18:39	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>presupuesto_editar.php</m>\n<idpresupuesto>224</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
595	-1062731740	omicron/~ivan/factuweb/web/index.php?m=forma_pago_editar&idforma_pago=1	2007-11-29-18:38:49	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>forma_pago_editar.php</m>\n<idforma_pago>1</idforma_pago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
622	-1062731728	omicron/~arturo/factuweb/web/index.php?m=precio_compra_listado	2007-11-29-19:15:09	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>precio_compra_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
649	-1062731740	omicron/~ivan/factuweb/web/index.php?m=precio_compra_editar	2007-11-30-09:27:55	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>precio_compra_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
676	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar	2007-11-30-09:38:58	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
703	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_listado	2007-11-30-10:50:21	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
730	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar&codigoserie_factura=DD	2007-11-30-11:50:40	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n<codigoserie_factura>DD</codigoserie_factura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
757	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_listado	2007-11-30-12:28:02	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
784	-1062731728	omicron/~arturo/factuweb/web/?m=articulo_listado&orden=idarticulo&buscar=&buscapor=&offset=30	2007-11-30-13:05:57	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)	<m>articulo_listado.php</m>\n<orden>idarticulo</orden>\n<buscar></buscar>\n<buscapor></buscapor>\n<offset>30</offset>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
811	-1062731728	omicron/~arturo/factuweb/web/index.php?m=familia_listado	2007-11-30-13:08:41	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>familia_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
838	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:49:13	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
865	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar	2007-11-30-16:49:59	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
892	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_articulo_editar&idtipo_articulo=25	2007-11-30-17:54:09	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_articulo_editar.php</m>\n<idtipo_articulo>25</idtipo_articulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
919	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=227	2007-11-30-18:16:26	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>presupuesto_editar.php</m>\n<idpresupuesto>227</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
946	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_editar&idpais=2	2007-11-30-18:21:52	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_editar.php</m>\n<idpais>2</idpais>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
973	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:05:16	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1000	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-16:47:34	Opera/9.23 (Windows NT 5.1; U; es-es)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
1027	-1062731728	omicron/~arturo/factuweb/web/	2007-12-05-18:04:58	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
596	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-29-18:39:08	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
623	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_articulo_listado	2007-11-29-19:15:14	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>tipo_articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
650	-1062731740	omicron/~ivan/factuweb/web/index.php?m=precio_compra_editar	2007-11-30-09:29:25	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>precio_compra_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
677	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_listado	2007-11-30-09:39:02	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
704	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_editar	2007-11-30-10:50:25	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
731	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_listado	2007-11-30-11:50:42	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
758	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_editar	2007-11-30-12:28:09	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
785	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_listado	2007-11-30-13:06:23	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
812	-1062731728	omicron/~arturo/factuweb/web/index.php?m=familia_editar	2007-11-30-13:08:43	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>familia_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
839	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:49:14	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
866	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-16:50:29	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
893	-1062731740	omicron/~ivan/factuweb/web/index.php?m=precio_compra_listado	2007-11-30-17:54:26	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>precio_compra_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
920	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar	2007-11-30-18:16:41	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
947	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_listado	2007-11-30-18:22:05	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
974	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:07:06	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1001	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-16:54:39	Opera/9.23 (Windows NT 5.1; U; es-es)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
1028	-1062731728	omicron/~arturo/factuweb/web/	2007-12-05-18:09:19	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
597	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-29-18:40:15	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
624	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidoproveedor_listado	2007-11-29-19:15:17	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pedidoproveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
651	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_articulo_listado	2007-11-30-09:30:08	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
678	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_editar&idpedidocliente=305	2007-11-30-09:39:04	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_editar.php</m>\n<idpedidocliente>305</idpedidocliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
705	-1062731728	omicron/~arturo/factuweb/web/	2007-11-30-10:50:29	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
732	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar&codigoserie_factura=REC	2007-11-30-11:50:43	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n<codigoserie_factura>REC</codigoserie_factura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
759	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_listado	2007-11-30-12:28:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
786	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-30-13:06:29	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
813	-1062731728	omicron/~arturo/factuweb/web/index.php?m=familia_editar	2007-11-30-13:08:48	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>familia_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
840	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:49:14	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
867	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar	2007-11-30-16:50:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
894	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_listado	2007-11-30-17:54:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
921	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_listado	2007-11-30-18:16:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
948	-1062731740	omicron/~ivan/factuweb/web/index.php?m=moneda_editar	2007-11-30-18:22:13	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>moneda_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
975	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:07:07	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1002	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-16:57:32	Opera/9.23 (Windows NT 5.1; U; es-es)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
1029	-1062731728	omicron/~arturo/factuweb/web/?m=cliente_listado	2007-12-05-18:09:47	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
598	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-29-18:40:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
625	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidoproveedor_editar	2007-11-29-19:15:19	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pedidoproveedor_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
652	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_articulo_editar&idtipo_articulo=35	2007-11-30-09:30:27	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_articulo_editar.php</m>\n<idtipo_articulo>35</idtipo_articulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
679	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-30-09:39:18	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
706	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_listado	2007-11-30-10:50:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
733	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar&codigoserie_factura=REC	2007-11-30-11:52:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n<codigoserie_factura>REC</codigoserie_factura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
760	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_listado	2007-11-30-12:40:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
787	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222&tabla=lpresupuesto&insertarlineadocumento=si&idarticulo=2814&desclpresupuesto=MEMORIA%20DIMM%20SDRAM%20256%20MB%20133MHZ%20MARCA&cantlpresupuesto=0&pvplpresupuesto=0&ivalpresupuesto=0&descuentolpresupuesto=0	2007-11-30-13:06:45	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<idpresupuesto>222</idpresupuesto>\n<insertarlineadocumento>si</insertarlineadocumento>\n<idarticulo>2814</idarticulo>\n<desclpresupuesto>MEMORIA DIMM SDRAM 256 MB 133MHZ MARCA</desclpresupuesto>\n<cantlpresupuesto>0</cantlpresupuesto>\n<pvplpresupuesto>0</pvplpresupuesto>\n<ivalpresupuesto>0</ivalpresupuesto>\n<descuentolpresupuesto>0</descuentolpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
814	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_articulo_listado	2007-11-30-13:08:51	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>tipo_articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
841	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:49:18	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
868	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar&loginusuario=	2007-11-30-16:50:46	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n<loginusuario></loginusuario>\n	<operacion>crear</operacion>\n<loginusuario>dasd</loginusuario>\n<nombreusuario>dasd</nombreusuario>\n<apellido1usuario>das</apellido1usuario>\n<apellido2usuario>das</apellido2usuario>\n<claveusuario>dasd</claveusuario>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
895	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_editar&idpedidoproveedor=34	2007-11-30-17:54:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_editar.php</m>\n<idpedidoproveedor>34</idpedidoproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
922	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_editar&idpedidocliente=303	2007-11-30-18:16:46	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_editar.php</m>\n<idpedidocliente>303</idpedidocliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
949	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_listado	2007-11-30-18:22:25	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
976	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:07:09	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1003	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-16:58:08	Opera/9.23 (Windows NT 5.1; U; es-es)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
599	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-29-18:52:49	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10			<usuario>arturo</usuario>\n<password>arturo</password>\n
626	-1062731728	omicron/~arturo/factuweb/web/index.php?m=albaranp_listado	2007-11-29-19:15:21	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>albaranp_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
653	-1062731728	omicron/~arturo/factuweb/web/	2007-11-30-09:32:26	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
680	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-30-09:40:56	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
707	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_editar&idcobro=75	2007-11-30-10:50:42	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_editar.php</m>\n<idcobro>75</idcobro>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
734	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar&codigoserie_factura=REC	2007-11-30-11:53:06	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n<codigoserie_factura>REC</codigoserie_factura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
761	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_editar&idpais=2	2007-11-30-12:42:37	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_editar.php</m>\n<idpais>2</idpais>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
788	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-11-30-13:06:47	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10			<usuario>arturo</usuario>\n<password>arturo</password>\n
815	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_articulo_editar&idtipo_articulo=25	2007-11-30-13:08:53	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>tipo_articulo_editar.php</m>\n<idtipo_articulo>25</idtipo_articulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
842	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:49:18	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
869	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-16:50:50	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
896	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_editar&idpedidoproveedor=34	2007-11-30-17:56:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_editar.php</m>\n<idpedidoproveedor>34</idpedidoproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
923	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_listado	2007-11-30-18:17:03	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
950	-1062731740	omicron/~ivan/factuweb/web/index.php?m=serie_factura_editar&codigoserie_factura=REC	2007-11-30-18:22:27	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>serie_factura_editar.php</m>\n<codigoserie_factura>REC</codigoserie_factura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
977	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:07:09	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1004	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:00:14	Opera/9.23 (Windows NT 5.1; U; es-es)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
600	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-29-18:53:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
627	-1062731728	omicron/~arturo/factuweb/web/index.php?m=albaranp_editar	2007-11-29-19:15:23	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>albaranp_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
654	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_articulo_editar&idtipo_articulo=35	2007-11-30-09:32:34	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_articulo_editar.php</m>\n<idtipo_articulo>35</idtipo_articulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
681	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_listado	2007-11-30-09:41:29	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
708	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_listado	2007-11-30-10:58:12	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
735	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cliente_listado	2007-11-30-11:56:27	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
762	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_editar	2007-11-30-12:42:43	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
789	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_editar	2007-11-30-13:06:58	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>presupuesto_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
816	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_listado	2007-11-30-13:21:38	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
843	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:00	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
870	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar&loginusuario=dasd	2007-11-30-16:50:52	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n<loginusuario>dasd</loginusuario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
897	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_editar&idpedidoproveedor=34	2007-11-30-18:00:14	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_editar.php</m>\n<idpedidoproveedor>34</idpedidoproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
924	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaran_editar&idalbaran=565	2007-11-30-18:17:06	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaran_editar.php</m>\n<idalbaran>565</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
951	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_listado	2007-11-30-18:22:48	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
978	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:07:11	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1005	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:03:04	Opera/9.23 (Windows NT 5.1; U; es-es)		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
601	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:53:54	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
628	-1062731728	omicron/~arturo/factuweb/web/index.php?m=facturap_listado	2007-11-29-19:15:25	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>facturap_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
655	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_listado	2007-11-30-09:32:58	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
682	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=223	2007-11-30-09:41:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>223</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
709	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_listado	2007-11-30-10:58:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
736	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cliente_editar&idcliente=1	2007-11-30-11:56:29	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cliente_editar.php</m>\n<idcliente>1</idcliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
763	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_listado	2007-11-30-12:42:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
790	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidocliente_listado	2007-11-30-13:07:00	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pedidocliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
817	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_editar&idproveedor=3	2007-11-30-13:22:26	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_editar.php</m>\n<idproveedor>3</idproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
844	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:00	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
871	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_editar&loginusuario=dasd	2007-11-30-16:51:08	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_editar.php</m>\n<loginusuario>dasd</loginusuario>\n	<operacion>borrar</operacion>\n<loginusuario>dasd</loginusuario>\n<nombreusuario>dasd</nombreusuario>\n<apellido1usuario>das</apellido1usuario>\n<apellido2usuario>das</apellido2usuario>\n<claveusuario>dasd</claveusuario>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
898	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_editar&idpedidoproveedor=34	2007-11-30-18:01:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_editar.php</m>\n<idpedidoproveedor>34</idpedidoproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
925	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_listado	2007-11-30-18:17:26	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
952	-1062731740	omicron/~ivan/factuweb/web/index.php?m=almacen_editar&idalmacen=2	2007-11-30-18:23:05	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>almacen_editar.php</m>\n<idalmacen>2</idalmacen>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
979	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:16:58	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1006	-1062731728	omicron/~arturo/factuweb/web/	2007-12-04-17:11:52	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
602	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:53:56	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
629	-1062731728	omicron/~arturo/factuweb/web/index.php?m=facturap_editar	2007-11-29-19:15:28	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>facturap_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
656	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_editar&idarticulo=2815	2007-11-30-09:33:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_editar.php</m>\n<idarticulo>2815</idarticulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
683	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar	2007-11-30-09:41:37	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
710	-1062731728	omicron/~arturo/factuweb/web/?m=cliente_listado	2007-11-30-11:03:28	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)	<m>cliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
737	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_listado	2007-11-30-11:56:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
764	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_editar&idpais=4	2007-11-30-12:42:47	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_editar.php</m>\n<idpais>4</idpais>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
791	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pedidocliente_editar	2007-11-30-13:07:03	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pedidocliente_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
818	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_editar&idproveedor=3	2007-11-30-13:23:00	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_editar.php</m>\n<idproveedor>3</idproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
845	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:02	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
872	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-16:51:11	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
899	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_editar	2007-11-30-18:03:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
926	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_editar&idfactura=458	2007-11-30-18:17:28	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_editar.php</m>\n<idfactura>458</idfactura>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
953	-1062731728	omicron/~arturo/factuweb/web/index.php?m=trabajador_listado	2007-11-30-19:08:36	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
980	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=2	2007-12-03-11:16:58	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>2</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1007	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:27:01	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
603	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:54:50	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
630	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pago_listado	2007-11-29-19:15:37	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
657	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_listado	2007-11-30-09:33:52	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
684	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_listado	2007-11-30-09:41:40	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
711	-1062731728	omicron/~arturo/factuweb/web/?m=cliente_editar&idcliente=1	2007-11-30-11:03:32	Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)	<m>cliente_editar.php</m>\n<idcliente>1</idcliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
738	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_editar&idinventario=8	2007-11-30-11:56:33	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_editar.php</m>\n<idinventario>8</idinventario>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
765	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_listado	2007-11-30-12:42:53	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
792	-1062731728	omicron/~arturo/factuweb/web/index.php?m=albaran_listado	2007-11-30-13:07:09	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>albaran_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
819	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_editar&idproveedor=3	2007-11-30-13:23:41	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_editar.php</m>\n<idproveedor>3</idproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
846	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:02	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
873	-1062731740	omicron/~ivan/factuweb/web/index.php?m=usuario_listado	2007-11-30-16:51:17	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>usuario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
900	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_listado	2007-11-30-18:03:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
927	-1062731740	omicron/~ivan/factuweb/web/index.php?m=factura_editar	2007-11-30-18:17:47	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>factura_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
954	-1062731728	omicron/~arturo/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-19:08:37	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
981	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-12-03-11:17:14	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1008	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_articulo_listado	2007-12-04-17:32:11	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>tipo_articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
604	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:55:11	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
631	-1062731728	omicron/~arturo/factuweb/web/index.php?m=forma_pago_listado	2007-11-29-19:15:42	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>forma_pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
658	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_editar&idpedidoproveedor=34	2007-11-30-09:34:13	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_editar.php</m>\n<idpedidoproveedor>34</idpedidoproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
685	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_listado	2007-11-30-09:59:40	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
712	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_listado	2007-11-30-11:14:30	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
739	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_listado	2007-11-30-11:56:35	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
766	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pais_editar&idpais=2	2007-11-30-12:43:14	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pais_editar.php</m>\n<idpais>2</idpais>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
793	-1062731728	omicron/~arturo/factuweb/web/index.php?m=albaran_editar&idalbaran=563	2007-11-30-13:07:11	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>albaran_editar.php</m>\n<idalbaran>563</idalbaran>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
820	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_editar&idproveedor=3	2007-11-30-13:24:21	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_editar.php</m>\n<idproveedor>3</idproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
847	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:22	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
874	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_listado	2007-11-30-16:51:40	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
901	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_editar&idalbaranp=32	2007-11-30-18:03:35	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_editar.php</m>\n<idalbaranp>32</idalbaranp>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
928	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_listado	2007-11-30-18:18:03	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
955	-1062731728	omicron/~arturo/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-19:08:38	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
982	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar	2007-12-03-11:17:18	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1009	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_articulo_listado	2007-12-04-17:32:20	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>tipo_articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
605	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:55:31	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
632	-1062731728	omicron/~arturo/factuweb/web/index.php?m=pago_listado	2007-11-29-19:15:45	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
659	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidoproveedor_editar	2007-11-30-09:34:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidoproveedor_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
686	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_editar&idpedidocliente=304	2007-11-30-09:59:59	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_editar.php</m>\n<idpedidocliente>304</idpedidocliente>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
713	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_editar&idcobro=75	2007-11-30-11:14:49	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_editar.php</m>\n<idcobro>75</idcobro>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
740	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_listado	2007-11-30-12:11:01	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
767	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_listado	2007-11-30-12:43:37	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
794	-1062731728	omicron/~arturo/factuweb/web/index.php?m=factura_editar	2007-11-30-13:07:14	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>factura_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
821	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_editar&idproveedor=3	2007-11-30-13:25:13	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_editar.php</m>\n<idproveedor>3</idproveedor>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
848	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
875	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_editar&idarticulo=2814	2007-11-30-16:51:44	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_editar.php</m>\n<idarticulo>2814</idarticulo>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
902	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_editar	2007-11-30-18:03:51	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
929	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_editar&idcobro=75	2007-11-30-18:18:04	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_editar.php</m>\n<idcobro>75</idcobro>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
956	-1062731740	omicron/~ivan/factuweb/web/index.php?m=articulo_editar	2007-12-03-11:03:06	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>articulo_editar.php</m>\n	<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
983	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar	2007-12-03-11:17:24	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1010	-1062731728	omicron/~arturo/factuweb/web/index.php?m=tipo_articulo_editar	2007-12-04-17:42:43	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>tipo_articulo_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
606	-1062731740	omicron/~ivan/factuweb/web/index.php?m=presupuesto_editar&idpresupuesto=222	2007-11-29-18:56:10	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>presupuesto_editar.php</m>\n<idpresupuesto>222</idpresupuesto>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
633	-1062731728	omicron/~arturo/factuweb/web/index.php?m=presupuesto_listado	2007-11-29-19:15:47	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
660	-1062731740	omicron/~ivan/factuweb/web/index.php?m=albaranp_listado	2007-11-30-09:34:53	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>albaranp_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
687	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pedidocliente_editar	2007-11-30-10:00:57	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pedidocliente_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
714	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_editar	2007-11-30-11:15:32	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
741	-1062731740	omicron/~ivan/factuweb/web/index.php?m=inventario_listado	2007-11-30-12:11:27	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>inventario_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
768	-1062731740	omicron/~ivan/factuweb/web/index.php?m=proveedor_listado	2007-11-30-12:46:57	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>proveedor_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
795	-1062731728	omicron/~arturo/factuweb/web/index.php?m=factura_listado	2007-11-30-13:07:16	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10	<m>factura_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
822	-1062731740	omicron/~ivan/factuweb/web/index.php?m=tipo_iva_listado	2007-11-30-13:27:01	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>tipo_iva_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
849	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_editar&idtrabajador=1	2007-11-30-13:50:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_editar.php</m>\n<idtrabajador>1</idtrabajador>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
876	-1062731728	omicron/~arturo/factuweb/web/	2007-11-30-17:26:14	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.10) Gecko/20071115 Firefox/2.0.0.10		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
903	-1062731740	omicron/~ivan/factuweb/web/index.php?m=facturap_listado	2007-11-30-18:03:54	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>facturap_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
578	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_listado	2007-11-29-18:12:08	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
579	-1062731740	omicron/~ivan/factuweb/web/index.php?m=pago_editar&idpago=90	2007-11-29-18:12:26	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>pago_editar.php</m>\n<idpago>90</idpago>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
930	-1062731740	omicron/~ivan/factuweb/web/index.php?m=cobro_editar	2007-11-30-18:18:23	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>cobro_editar.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
957	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-12-03-11:03:11	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
984	-1062731740	omicron/~ivan/factuweb/web/index.php?m=trabajador_listado	2007-12-03-11:17:26	Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.5) Gecko/20061201 Firefox/2.0.0.5 (Ubuntu-feisty)	<m>trabajador_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1011	-1062731728	omicron/~arturo/factuweb/web/index.php	2007-12-04-17:45:48	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
1030	-1062731728	omicron/~arturo/factuweb/web/	2007-12-10-13:26:16	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
1031	-1062731728	omicron/~arturo/factuweb/web/?m=presupuesto_listado	2007-12-10-13:26:20	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>presupuesto_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1032	-1062731728	omicron/~arturo/factuweb/web/	2007-12-10-16:16:41	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11		<login>arturo</login>\n<password>arturo</password>\n	<usuario>arturo</usuario>\n<password>arturo</password>\n
1033	-1062731728	omicron/~arturo/factuweb/web/?m=pais_listado	2007-12-10-16:16:55	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>pais_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1034	-1062731728	omicron/~arturo/factuweb/web/	2007-12-10-17:06:44	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11			<usuario>arturo</usuario>\n<password>arturo</password>\n
1035	-1062731728	omicron/~arturo/factuweb/web/?m=articulo_listado	2007-12-10-17:07:00	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
1036	-1062731728	omicron/~arturo/factuweb/web/?m=articulo_listado	2007-12-10-17:07:03	Mozilla/5.0 (Windows; U; Windows NT 5.1; es-ES; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11	<m>articulo_listado.php</m>\n		<usuario>arturo</usuario>\n<password>arturo</password>\n
\.


--
-- Data for Name: lpedido; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lpedido (numlpedido, desclpedido, cantlpedido, pvdlpedido, prevlpedido, ivalpedido, descuentolpedido, idpedido, idalb_pro, idarticulo, reqeqlpedido) FROM stdin;
\.


--
-- Data for Name: lpedidocliente; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lpedidocliente (numlpedidocliente, cantlpedidocliente, pvplpedidocliente, prevlpedidocliente, ivalpedidocliente, descuentolpedidocliente, idpedidocliente, idarticulo, puntlpedidocliente, desclpedidocliente, ordenlpedidocliente, reqeqlpedidocliente) FROM stdin;
908	1.00	35.00	\N	16.00	0.00	401	4179	f	INSTALACION / HORA	1	0.00
924	1.00	360.00	\N	16.00	0.00	433	4553	f	HOSTING ANUAL GIBPROMOCIONES.COM	0	0.00
925	1.00	30.00	\N	16.00	100.00	433	4203	f	CONTRATACION ANUAL DE DOMINIO\nwww.gibpromociones.com	1	0.00
781	1.00	200.00	\N	16.00	0.00	367	4189	f	Programación Fecha Caducidad Alumnos\n        Consiste en dar una fecha limite de utilizacion de la\n aplicacion a los alumnos\n\n\tEntrega: 15 dias tras confirmacion	0	0.00
782	1.00	1100.00	\N	16.00	0.00	367	4189	f	Aplicación Base Preguntas de test:\nZona Administrativa\n- Gestión de Alumnos\n- Estadísticas de Alumnos\n- Gestión de Preguntas\n- Gestion de Exámenes\n\nZona Usuarios\n- Loggin y password de entrada\n- Presentar estadisticas particulares\n- Realizar preguntas por Asignaturas\n- Realizar  Examenes oficiales\n- Realizar examenes al Azar.\n	1	0.00
899	1.00	8.37	\N	16.00	0.00	419	2905	f	HUB USB MINI CONCEPTRONIC 4 PTOS CSPUSB4	0	0.00
977	1.00	0.00	\N	16.00	0.00	419	4185	f	DESPLAZAMIENTO CONTRATO	2	0.00
860	1.00	35.00	\N	16.00	0.00	400	4179	f	INSTALACION / HORA	0	0.00
670	1.50	0.00	\N	16.00	0.00	314	4184	f	HORAS CONTRATO	0	0.00
671	1.00	0.00	\N	16.00	0.00	314	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
676	1.00	173.20	\N	16.00	0.00	314	4187	f	BROTHER HL-2070N	2	0.00
677	1.00	0.96	\N	16.00	0.00	314	2843	f	CABLE USB 1,8MT A/B MM   SB 2402	3	0.00
700	0.75	35.00	\N	16.00	0.00	327	4179	f	INSTALACION / HORA	0	0.00
701	1.00	6.00	\N	16.00	0.00	327	4180	f	DESPLAZAMIENTO PALMA	1	0.00
686	4.00	0.00	\N	16.00	0.00	321	4179	f	INSTALACION / HORA	0	0.00
687	1.00	0.00	\N	16.00	0.00	321	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
688	1.00	5.59	\N	16.00	0.00	321	2882	f	T.RED PCI CONCEPTRONIC 10/100 W.O.L. ( C100i 	2	0.00
707	1.00	0.00	\N	16.00	0.00	331	4184	f	HORAS CONTRATO	0	0.00
708	1.00	60.49	\N	16.00	0.00	331	4189	f	TONER TN-2000 BROTHER HL-2070N, MFC-7820N	1	0.00
709	1.00	0.00	\N	16.00	0.00	331	4185	f	DESPLAZAMIENTO CONTRATO	2	0.00
998	4.00	1.81	\N	16.00	0.00	465	2892	f	LATIGUILLO FTP CAT.5E DE 2 MTS MARFIL PL1202	2	0.00
716	1.00	50.00	\N	16.00	0.00	336	4203	f	CONTRATACION ORIGINALDELI.BIZ \nORIGINALDELI.NET\nORIGINALDELI.US\nORIGINALDELI.UE\nHASTA 19/01/2008	0	0.00
729	1.00	30.00	\N	16.00	0.00	342	4203	f	CONTRATACION WWW.LASGALLETASDETUSVIAJES.COM\nDesde 01/02/2007 hasta 01/02/2008	0	0.00
1012	1.50	35.00	\N	16.00	0.00	470	4179	f	REVISION DEL EQUIPO POR VIRUS Y FALLOS EN OUTLOOK EXPRESS	0	0.00
725	1.00	15.00	\N	16.00	0.00	340	4241	f	REPARACIONES	0	0.00
726	1.00	17.35	\N	16.00	0.00	340	3456	f	FUENTE DE ALI. 450W ( PIV ) ATX	1	0.00
1013	1.00	26.90	\N	16.00	0.00	470	4538	f	AVG Anti-Virus Professional Edition	1	0.00
1007	3.00	0.00	\N	16.00	0.00	469	4184	f	HORAS CONTRATO	0	0.00
1008	1.00	38.38	\N	16.00	0.00	469	4559	f	OKI TONER AZUL C33/C34	1	0.00
1009	1.00	38.38	\N	16.00	0.00	469	4556	f	OKI TONER AMARILLO C33/C34	2	0.00
1010	1.00	38.38	\N	16.00	0.00	469	4555	f	OKI TONER MAGENTA C33/C34	3	0.00
1011	1.00	27.41	\N	16.00	0.00	469	4554	f	OKI TONER NEGRO C33/C34	4	0.00
751	1.00	150.00	\N	16.00	0.00	351	4179	f	INSTALACION / HORA	0	0.00
1019	1.00	122.93	\N	16.00	0.00	473	3595	f	HD 500 GB SATA2 SEAGATE 7200 RPM 16MB	2	0.00
706	1.00	30.00	\N	16.00	0.00	330	4203	f	TRASPASO g-ribasazcona.COM	0	0.00
739	5.00	13.86	\N	16.00	0.00	346	2880	f	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00
752	1.00	35.00	\N	16.00	0.00	352	4179	f	INSTALACION / HORA	0	0.00
753	1.00	6.00	\N	16.00	0.00	352	4180	f	DESPLAZAMIENTO PALMA	1	0.00
750	1.00	30.00	\N	16.00	0.00	350	4203	f	CONTRATACION \nwww.rosconstruccion.com\nHasta 09/02/08	0	0.00
773	1.00	453.62	\N	16.00	0.00	363	4189	f	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	0	0.00
772	1.00	453.62	\N	16.00	0.00	362	4189	f	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	0	0.00
762	1.00	30.00	\N	16.00	0.00	357	4203	f	CONTRATACION WWW.GIBPROMOCIONES.COM\nHASTA 15/02/2007	0	0.00
774	1.00	205.93	\N	16.00	0.00	364	4189	f	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	0	0.00
775	1.00	191.76	\N	16.00	0.00	364	3664	f	SOFT. OFFICE 2003 BASICO	1	0.00
776	1.00	64.53	\N	16.00	0.00	364	3640	f	SWITCH CONCEPTRONIC 8 PTOS. 10/100/1000  CGIG	2	0.00
777	1.00	123.68	\N	16.00	0.00	364	2852	f	SOFT. WINDOWS XP PROFESIONAL OEM	3	0.00
797	1.00	2200.00	\N	16.00	0.00	371	4193	f	PROGRAMACION WEB\nDISTRIBUIDORA ROTGER	0	0.00
799	1.00	1800.00	\N	16.00	0.00	373	4193	f	PROGRAMACION WEB\nLASGALLETASDETUSVIAJES.COM\nENTREGA: 1ª SEMANA MAYO	0	0.00
803	2.00	20.00	\N	16.00	0.00	376	4179	f	INSTALACION / HORA	0	0.00
804	1.00	151.61	\N	16.00	0.00	376	4431	f	IMPRESORA HP PHOTOSMART C4180 MULTIFUNCION	1	0.00
738	2.00	20.00	\N	16.00	0.00	345	4241	f	REPARACION ORDENADOR CATI TALLER	0	0.00
802	1.00	9.69	\N	16.00	0.00	345	4189	f	MODEM INTERNO CONCEPTRONIC	1	0.00
811	1.00	1600.00	\N	16.00	0.00	379	4189	f	Diseño web e imagen corporativa	0	0.00
812	68.57	35.00	\N	16.00	0.00	379	4193	f	Programación WEB con los siguientes apartados:\n- Presentacion empresa (filosofia)	1	0.00
816	1.00	7.59	\N	16.00	0.00	382	4189	f	CUCHILLAS DE CORTE (2 UNIDADES)	0	0.00
792	1.00	189.00	\N	16.00	0.00	370	4189	f	QL 1050\nImpresora de etiquetas profesional	0	0.00
793	1.00	34.16	\N	16.00	0.00	370	4189	f	CINTA DE PAPEL BLANCA 102mm x 30,48 m	1	0.00
794	1.00	349.00	\N	16.00	0.00	370	4189	f	BROTHER MFC 7820N	2	0.00
795	1.00	15.00	\N	16.00	0.00	370	4188	f	CANON LPI BROTHER	3	0.00
796	1.00	0.96	\N	16.00	0.00	370	2843	f	CABLE USB 1,8MT A/B MM   SB 2402	4	0.00
745	1.00	46.96	\N	16.00	0.00	348	3754	f	PB ASROCK P4i65G i865G SATA VGA SON LAN DDR40	0	0.00
758	1.00	2.70	\N	16.00	0.00	348	2836	f	CABLE VGA M/M 1.8M AK3225	1	0.00
814	1.00	84.02	\N	16.00	0.00	380	3872	f	GATEWAY LINKSYS WRT54GS WIRELESS	0	0.00
817	1.00	0.00	\N	16.00	0.00	380	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
818	1.00	0.00	\N	16.00	0.00	380	4184	f	HORAS CONTRATO	2	0.00
824	1.00	70.00	\N	16.00	0.00	386	4233	f	PAQUETE 6 DOMINIOS ESCUELA	0	0.00
825	1.00	30.00	\N	16.00	0.00	387	4203	f	CONTRATACION DE DOMINIO\nwww.tolomayol.com\nhasta 23-03-08	0	0.00
833	0.50	0.00	\N	16.00	0.00	391	4184	f	HORAS CONTRATO	0	0.00
834	1.00	0.00	\N	16.00	0.00	391	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
835	1.00	35.00	\N	16.00	0.00	392	4179	f	INSTALACION / HORA	0	0.00
836	1.00	6.00	\N	16.00	100.00	392	4180	f	DESPLAZAMIENTO PALMA	1	0.00
826	1.00	0.00	\N	16.00	0.00	388	4185	f	DESPLAZAMIENTO CONTRATO	0	0.00
827	1.00	0.00	\N	16.00	0.00	388	4184	f	HORAS CONTRATO	1	0.00
828	2.00	30.00	\N	16.00	0.00	388	4500	f	RW DVD DUAL DL LG 18X8X16X GSA-H42N OEM	2	0.00
829	3.00	60.49	\N	16.00	0.00	389	4528	f	BROTHER TN2000 MFC/DCP	0	0.00
830	1.00	0.00	\N	16.00	0.00	389	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
831	1.00	0.00	\N	16.00	0.00	389	4184	f	HORAS CONTRATO	2	0.00
844	1.00	485.00	\N	16.00	0.00	396	4549	f	ORDENADOR MONTADO SERIE FEEL\nCORE2 DUO E6300 DUAL CORE 1 GB	0	0.00
854	1.00	183.06	\N	16.00	0.00	403	3224	f	LECTOR C.B. METROLOGIC MS-9520 VOYAGER (USB) 	0	0.00
855	1.00	271.64	\N	16.00	0.00	403	3294	f	IMPRESORA TICKETS SAMSUNG SRP-350 TERMICA NEG	1	0.00
847	1.00	66.90	\N	16.00	0.00	399	4539	f	AVG Internet Security\n3 Licencias / 1 Año	0	0.00
848	1.00	0.00	\N	16.00	0.00	399	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
849	1.00	0.00	\N	16.00	0.00	399	4184	f	HORAS CONTRATO	2	0.00
851	1.00	6.00	\N	16.00	100.00	401	4180	f	DESPLAZAMIENTO PALMA	0	0.00
866	1.00	8.61	\N	16.00	0.00	407	4004	f	CART. EPSON D78 DX4000 DX5000 AMARILLO T07144	0	0.00
867	1.00	8.61	\N	16.00	0.00	407	4003	f	CART. EPSON D78 DX4000 DX5000 MAGENTA T071340	1	0.00
868	1.00	8.61	\N	16.00	0.00	407	4002	f	CART. EPSON D78 DX4000 DX5000 CYAN T071240B0	2	0.00
869	1.00	8.61	\N	16.00	0.00	407	3969	f	CART. EPSON D78 DX4000 DX5000 NEGRO T071140B0	3	0.00
846	17.00	13.90	\N	16.00	0.00	398	2880	f	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00
871	1.00	244.80	\N	16.00	0.00	408	4011	f	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	0	0.00
872	1.00	56.22	\N	16.00	0.00	408	3586	f	HD 200 GB SATA2 SEAGATE 7200 RPM 8MB	1	0.00
873	1.00	19.41	\N	16.00	0.00	408	3456	f	FUENTE DE ALI. 450W ( PIV ) ATX	2	0.00
838	1.00	840.00	\N	16.00	0.00	394	4434	f	PORTATIL HP NX7300 T5500 1GB 80GB DVD-RW 15.4	0	0.00
798	34.00	35.00	\N	16.00	0.00	372	4193	f	PROGRAMACION WEB ABBACINO\n3 IDIOMAS\nPHP Y FLASH COMBINADOS\nFECHA: 21 DE MARZO	0	0.00
800	70.00	35.00	\N	16.00	0.00	374	4239	f	PROGRAMACIONWEB\nFUNDACION LLABRES FELIU	0	0.00
877	1.00	3.31	\N	16.00	0.00	411	2890	f	LATIGUILLO UTP CAT.5E DE 8 MTS MARFIL PL1010	0	0.00
878	1.00	0.96	\N	16.00	0.00	411	2843	f	CABLE USB 1,8MT A/B MM   SB 2402	1	0.00
879	2.50	0.00	\N	16.00	0.00	411	4184	f	HORAS CONTRATO	2	0.00
887	1.00	0.00	\N	16.00	0.00	411	4185	f	DESPLAZAMIENTO CONTRATO	3	0.00
894	0.25	35.00	\N	16.00	0.00	416	4179	f	ASISTENCIA TELEFONICA	0	0.00
902	1.00	360.00	\N	16.00	0.00	420	4540	f	HOSTING PLAN BASE PROFESIONAL ANUAL\nwww.ajuntament de pollença.com	0	0.00
909	1.00	19.43	\N	16.00	0.00	401	4030	f	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	2	0.00
982	6.00	58.31	\N	16.00	0.00	391	4298	f	TONER IMP. BROTHER TN-2000 NEGRO	2	0.00
983	3.00	87.00	\N	16.00	0.00	391	4186	f	BROTHER TINTA COLOR MULTIFUNCION DCP-130	3	0.00
769	1.00	402.78	\N	16.00	0.00	361	4189	f	FEEL INTEL PIV D930 FSB800 DUAL CORE 2x(3.0Ghz 2M)	0	0.00
770	1.00	0.00	\N	16.00	0.00	361	4189	f	INSTALACION BFACT	1	0.00
771	1.00	0.00	\N	16.00	0.00	361	4189	f	INSTALACION UBUNTU	2	0.00
784	1.00	240.00	\N	16.00	0.00	367	4189	f	Introduccion de examenes inicial\n\n\tIntroducción de 40 examenes de teoría con sus \nrespectivas preguntas a partir de un documento word, pdf o similar.\n\t\n\tEntrega: 35 dias tras confirmación	3	0.00
785	1.00	250.00	\N	16.00	0.00	367	4189	f	Programación consulta con el profesor\n    Esta modificacion permitira al alumno realizar consultas \nal profesor en relacion con determinadas preguntas.\nLas consultas seran off-line y moderadas por los profesores.\n\n\tTiempo de entrega: 25 dias tras confirmacion.	4	0.00
904	1.00	30.00	\N	16.00	0.00	422	4203	f	RENOVACION DE DOMINIO\nINFOPOLLENSA.NET	0	0.00
905	1.00	326.84	\N	16.00	0.00	423	3937	f	SWITCH NETGEAR JGS524GE 24 PUERTOS 10/100/100	0	0.00
906	1.00	0.00	\N	16.00	0.00	423	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
907	1.00	0.00	\N	16.00	0.00	423	4184	f	HORAS CONTRATO	2	0.00
912	1.00	15.51	\N	16.00	0.00	425	3439	f	CART. HP COLOR Nº22 PSC1410 DJ3940 5ML	0	0.00
913	1.00	13.79	\N	16.00	0.00	425	3438	f	CART. HP NEGRO Nº21 PSC1410 NEGRO 5ML C9351AE	1	0.00
786	1.00	350.00	\N	16.00	0.00	367	4189	f	Programación, gestión multiples cursos:\n\n       Esta modificacion consiste en que el sistema pueda \nalbergar la imparticion de multiples cursos de forma \nsimultanea,  asignando resultados, profesores y fechas de\nimpartición a éstos.\n\n\tEntrega: 25 dias tras confirmación.	5	0.00
787	1.00	450.00	\N	16.00	0.00	367	4189	f	Aplicar estilo e integrar en web Nautivel\n      Aplicar a la aplicación un cambio de imagen que integre\n y permita identificar visualmente una marca única (Nautivel).\n\n     Plazo: 15 dias tras confirmacion.	6	0.00
988	1.00	10.22	\N	16.00	0.00	461	4562	f	Cinta de Papel 12x30,48 DK22214	0	0.00
989	50.00	18.92	\N	16.00	0.00	461	4563	f	Cinta de Papel 62x30,48 DK22205	1	0.00
996	2.00	0.00	\N	16.00	0.00	465	4184	f	HORAS CONTRATO	0	0.00
997	1.00	0.00	\N	16.00	0.00	465	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
915	1.00	360.00	\N	16.00	0.00	427	4230	f	HOSTING ANUAL\nGNLEON.COM\nGESTORIANAUTICALEON.COM\n	0	0.00
920	1.00	30.00	\N	16.00	0.00	430	4203	f	RENOVACION ANUAL DE DOMINIOS\nwww.jmcrepresentaciones.com	0	0.00
921	1.00	500.00	\N	16.00	0.00	431	4211	f	MANTENIMIENTO SERVIDOR APACHE ANUAL LLABRES FELIU	0	0.00
922	1.00	32.00	\N	16.00	0.00	432	4189	f	REPOSAPIES AJUSTABLE MOD. 5120 ARCHIVO 2000	0	0.00
923	1.00	31.00	\N	16.00	0.00	432	4189	f	SOPORTE MONITOR OFFI.SUITE 80311 FELLOWES	1	0.00
783	1.00	150.00	\N	16.00	0.00	367	4189	f	Integración base de datos FileMaker, Excel\n      Consiste en adaptar el programa para que pueda importar\n determinados datos (alumnos, cursos y profesores) de una\n base de datos Filemaker o una hora de cálculo Excel.\n\n\tEntrega 25 dias tras confirmacion	2	0.00
1014	1.00	87.28	\N	16.00	0.00	471	4565	f	TN3060 BROTHER 8220/8045/8440/8840	0	0.00
780	1.00	60.24	\N	16.00	0.00	366	3878	f	IMPRESORA EPSON STYLUS D78 USB DINA4 22PPM 57	0	0.00
790	1.00	85.41	\N	16.00	0.00	358	4531	f	OKI TAMBOR EP-CART C32-BLACK	2	0.00
791	1.00	35.00	\N	16.00	0.00	348	4179	f	INSTALACION / HORA	2	0.00
852	1.00	6.00	\N	16.00	0.00	402	4180	f	DESPLAZAMIENTO PALMA	0	0.00
853	3.00	35.00	\N	16.00	0.00	402	4179	f	INSTALACION / HORA	1	0.00
839	1.00	32.13	\N	16.00	0.00	395	3252	f	T.RED USB D-LINK WIRELESS DWL-G122 54Mbps 2.4	0	0.00
840	1.00	1.92	\N	16.00	0.00	395	2850	f	CABLE USB 1,8 Mts. M/H (EXTENSION SB1200)  A/	1	0.00
841	1.00	12.61	\N	16.00	0.00	395	3258	f	HUB USB CONCEPTRONIC 4 PTOS. USB 2.0 C4USB2	2	0.00
842	1.00	0.00	\N	16.00	0.00	395	4185	f	DESPLAZAMIENTO CONTRATO	3	0.00
843	1.00	35.00	\N	16.00	0.00	395	4179	f	INSTALACION / HORA	4	0.00
806	1.00	404.00	\N	16.00	0.00	377	4189	f	OKI C5600N\nImpresora Láser Color 16ppm color, 20 ppm monocromo\n1200x600 dpi, 32Mb RAM, Windows GDI/Mac Raster, 200 MHz, Tarjeta de Red, USB, Photo Mode	0	0.00
808	2.00	279.00	\N	16.00	0.00	377	4189	f	BROTHER LASER NEGRO HL 5250DN	1	0.00
813	1.00	200.00	\N	16.00	100.00	377	4189	f	BANDEJA DUPLEX IMPRESION A DOBLE CARA	2	0.00
930	1.00	6.00	\N	16.00	0.00	436	4180	f	DESPLAZAMIENTO PALMA	0	0.00
931	0.50	35.00	\N	16.00	0.00	436	4179	f	INSTALACION / HORA	1	0.00
932	1.00	27.41	\N	16.00	0.00	437	4554	f	OKI TONER NEGRO C33/C34	0	0.00
933	1.00	38.38	\N	16.00	0.00	437	4555	f	OKI TONER MAGENTA C33/C34	1	0.00
763	1.00	0.00	\N	16.00	0.00	358	4185	f	DESPLAZAMIENTO CONTRATO	0	0.00
764	1.00	0.00	\N	16.00	0.00	358	4184	f	HORAS CONTRATO	1	0.00
778	1.00	205.93	\N	16.00	0.00	365	4189	f	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	0	0.00
779	1.00	123.68	\N	16.00	0.00	365	2852	f	SOFT. WINDOWS XP PROFESIONAL OEM	1	0.00
789	15.00	13.86	\N	16.00	0.00	369	2880	f	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00
788	1.00	69.25	\N	16.00	0.00	368	4113	f	HD 250 GB SATA2 MAXTOR 7200 RPM 8MB	0	0.00
992	0.50	35.00	\N	16.00	0.00	463	4179	f	INSTALACION / HORA	0	0.00
993	1.00	6.00	\N	16.00	100.00	463	4180	f	DESPLAZAMIENTO PALMA	1	0.00
644	1.00	87.00	\N	16.00	0.00	304	4186	f	BROTHER TINTA COLOR MULTIFUNCION DCP-130\nSERIES: L6F438228	0	0.00
884	1.00	35.00	\N	16.00	0.00	412	4189	f	Comprobar copias seguridad cinta	0	0.00
645	1.00	173.20	\N	0.00	0.00	305	4187	f	BROTHER HL-2070N\nSERIES: H6J379202	0	\N
640	1.00	0.00	\N	16.00	0.00	303	4184	f	\n\nHORAS CONTRATO	0	\N
641	1.00	0.00	\N	16.00	0.00	303	4185	f	DESPLAZAMIENTO CONTRATO	1	\N
642	1.00	24.00	\N	16.00	0.00	303	4183	f	BROTHER MULTIFUNCION LASER MONOCROMO DCP-7025\nSERIES: H6J396831	2	\N
969	1.00	0.00	\N	16.00	0.00	454	4184	f	HORAS CONTRATO	0	0.00
970	1.00	0.00	\N	16.00	0.00	454	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
646	1.00	775.00	\N	16.00	0.00	306	4190	f	EPSON IMPT STYLUS PHOTO R2400 USB A3	0	0.00
971	2.00	19.32	\N	16.00	0.00	454	4530	f	CARTUCHO NEGRO C-LC1000BK	2	0.00
972	3.00	27.41	\N	16.00	0.00	454	4554	f	OKI TONER NEGRO C33/C34	3	0.00
973	2.00	80.11	\N	16.00	0.00	454	4529	f	BROTHER TAMBOR C-DR200	4	0.00
637	1.00	35.00	\N	16.00	0.00	302	4179	f	\n\n\n\nINSTALACION / HORA	0	0.00
638	1.00	6.00	\N	16.00	99.99	302	4180	f	\nDESPLAZAMIENTO PALMA	1	0.00
639	2.00	209.00	\N	16.00	0.00	302	4178	f	\n\n\n\nSP CONTAPLUS PRO 2007	2	0.00
976	1.00	0.00	\N	16.00	0.00	419	4184	f	HORAS CONTRATO	1	0.00
958	1.00	0.00	\N	16.00	0.00	450	4185	f	DESPLAZAMIENTO CONTRATO	0	0.00
959	4.00	35.00	\N	16.00	30.00	450	4179	f	INSTALACION / HORA	1	0.00
960	1.00	9.64	\N	16.00	0.00	450	3825	f	LATIGUILLO UTP CAT.5E DE 30 MTS MARFIL PL 101	2	0.00
961	1.00	1.43	\N	16.00	0.00	450	3159	f	CONECTOR MACHO RJ45 UTP  7 Unds	3	0.00
962	1.00	3.00	\N	16.00	0.00	450	2896	f	ROSETA RJ45 CAT. 5E UTP 2 TOMAS FS 4210	4	0.00
654	1.00	148.00	\N	16.00	0.00	308	4194	f	BROTHER MFC 5460 CN	0	0.00
655	1.00	15.00	\N	16.00	0.00	308	4188	f	CANON LPI BROTHER	1	0.00
656	5.00	26.19	\N	16.00	0.00	308	4197	f	BROTHER CARTUCHO TINTA NEGRA LC1000HYBK	2	0.00
657	2.00	10.63	\N	16.00	0.00	308	4198	f	BROTHER CART. TINTA AZUL LC1000C	3	0.00
658	2.00	10.63	\N	16.00	0.00	308	4199	f	BROTHER CART. TINTA MAGENTA LC1000M	4	0.00
659	2.00	10.63	\N	16.00	0.00	308	4202	f	BROTHER CART. TINTA AMARILLA LC1000C	5	0.00
711	1.00	40.00	\N	16.00	0.00	333	4189	f	CARLOS DE ESCUELA DEL MAR -\n ORDENADOR Y UN ESCANER. \nREPARACI'ON TALLER - REINSTALAR S.O. Y TESTEAR	0	0.00
689	0.50	0.00	\N	16.00	0.00	322	4184	f	HORAS CONTRATO	0	0.00
690	1.00	1.81	\N	16.00	0.00	322	2892	f	LATIGUILLO FTP CAT.5E DE 2 MTS MARFIL PL1202	1	0.00
691	1.00	0.00	\N	16.00	0.00	322	4185	f	DESPLAZAMIENTO CONTRATO	2	0.00
980	1.00	24.51	\N	16.00	0.00	458	3535	f	T.SONIDO CREATIVE S.B. AUDIGY SE 7.1 OEM SB05	0	0.00
981	0.30	35.00	\N	16.00	0.00	458	4179	f	INSTALACION / HORA	1	0.00
717	200.00	13.81	\N	16.00	0.00	337	2880	f	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00
718	4.00	17.24	\N	16.00	0.00	337	4189	f	LLAVE MAESTRA CABLE SEGURIDAD PARA PORTATIBLES	1	0.00
719	1.00	17.24	\N	16.00	100.00	337	4189	f	LLAVE MAESTRA CABLE SEGURIDAD PARA PORTATIBLES	2	0.00
1003	1.00	206.03	\N	16.00	0.00	468	4564	f	LACIE ETHERNET DISK MINI 500 GB (Ref: 301138)	0	0.00
1004	1.00	0.00	\N	16.00	0.00	468	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
1005	4.00	0.00	\N	16.00	0.00	468	4184	f	HORAS CONTRATO	2	0.00
730	1.00	16.64	\N	16.00	0.00	343	3477	f	TECLADO NGS PLANET OFFICE 125 TECLAS MM USB	0	0.00
731	2.00	84.87	\N	16.00	0.00	343	3339	f	MEMORIA DIMM DDR 1024 MB 400Mhz KINGSTON	1	0.00
732	1.00	0.00	\N	16.00	0.00	343	4185	f	DESPLAZAMIENTO CONTRATO	2	0.00
733	1.00	0.00	\N	16.00	0.00	343	4184	f	HORAS CONTRATO	3	0.00
743	1.00	2.70	\N	16.00	0.00	343	2836	f	CABLE VGA M/M 1.8M AK3225	4	0.00
744	1.00	0.96	\N	16.00	0.00	343	2843	f	CABLE USB 1,8MT A/B MM   SB 2402	5	0.00
740	1.00	0.00	\N	16.00	0.00	347	4185	f	DESPLAZAMIENTO CONTRATO	0	0.00
741	1.00	0.00	\N	16.00	0.00	347	4184	f	HORAS CONTRATO	1	0.00
742	1.00	244.80	\N	16.00	0.00	347	4011	f	TFT 19"  PHILIPS 190S7FS PLATA 1280X1024 8MS 	2	0.00
1015	2.00	9.10	\N	16.00	0.00	472	3003	f	CART. JT EPSON C62 CX3200 COLOR 8803JB E71	0	0.00
1016	2.00	7.81	\N	16.00	0.00	472	3012	f	CART. JT EPSON C62 CX3200 NEGRO 879JB E70	1	0.00
979	1.00	120.00	\N	16.00	0.00	457	4240	f	PAGO ANUAL MANTENIMIENTO BULMAGÉS	0	0.00
735	0.50	35.00	\N	16.00	0.00	344	4179	f	INSTALACION / HORA	0	0.00
736	1.00	215.53	\N	16.00	0.00	344	4134	f	TFT 19"  BELINEA 1925 S1W PANORAMICO MM NEGRO	1	0.00
895	1.00	35.00	\N	16.00	0.00	356	4193	f	PROGRAMACION WEB	0	0.00
1017	1.00	0.00	\N	16.00	0.00	473	4185	f	DESPLAZAMIENTO CONTRATO	0	0.00
1018	2.00	0.00	\N	16.00	0.00	473	4184	f	HORAS CONTRATO	1	0.00
898	1.00	35.00	\N	16.00	0.00	418	4193	f	PROGRAMACION WEB	0	0.00
896	12.00	35.00	\N	16.00	0.00	417	4193	f	PROGRAMACION WEB	0	0.00
1026	12.00	17.00	\N	16.00	0.00	477	4541	f	HOSTING PLAN BASE BÁSICO MENSUAL\nC PANEL	0	0.00
1027	1.00	30.00	\N	16.00	100.00	477	4203	f	CONTRATACION DE DOMINIOS\nwww.fundaciollabresfeliu.com\nwww.fundacionllabresfeliu.com (redirigido)	1	0.00
1028	1.00	30.00	\N	16.00	0.00	478	4203	f	RENOVACION DE DOMINIO:\nwww.viamar-ibiza.com\nHasta: 25/06/2008	0	0.00
984	1.00	30.00	\N	16.00	0.00	459	4203	f	CONTRATACION / RENOVACION DE DOMINIOS\nwww.animasealounge.com\nHASTA 15/04/2008	0	0.00
985	1.00	30.00	\N	16.00	0.00	459	4561	f	HOSTING MENSUAL ANIMASEALOUNGE.COM	1	0.00
1029	1.00	30.00	\N	16.00	0.00	480	4203	f	TRASPASO DE DOMINIO\nWWW.URBIENT.COM	0	0.00
1030	1.00	15.00	\N	16.00	0.00	480	4568	f	HOSTING MENSUAL URBIENT.COM\nABRIL	1	0.00
1031	1.00	30.00	\N	16.00	0.00	480	4568	f	HOSTING MENSUAL URBIENT.COM\nMAYO	2	0.00
647	1.00	50.00	\N	16.00	0.00	307	4193	f	RESPUESTAS EXAMENES\n(15 DÍAS)	0	0.00
648	1.00	400.00	\N	16.00	0.00	307	4193	f	PREGUNTAS DE TEST ON-LINE\n(30 DÍAS)	1	0.00
649	1.00	50.00	\N	16.00	0.00	307	4193	f	NOTAS OFICIALES\n(15 DÍAS)	2	0.00
650	1.00	50.00	\N	16.00	0.00	307	4193	f	PROGRAMACION CURSOS\n(15 DÍAS)	3	0.00
651	1.00	500.00	\N	16.00	0.00	307	4193	f	EL PORTAL NÁUTICO\n(60 DÍAS)\n-Publican alumnos y profesores - con secciones-	4	0.00
652	1.00	100.00	\N	16.00	0.00	307	4193	f	AULAS\n(30 DÍAS)	5	0.00
653	1.00	300.00	\N	16.00	0.00	307	4193	f	PROGRAMACION WEB\nCAMBIOS ESTÁTICOS\n(10 DÍAS)\n	6	0.00
1043	3.00	48.08	\N	16.00	0.00	485	3354	f	RATON LOGITECH MX 518 OPTICAL MOUSE USB/PS2	0	0.00
1044	1.00	0.00	\N	16.00	0.00	485	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
1045	1.00	0.00	\N	16.00	0.00	485	4184	f	HORAS CONTRATO	2	0.00
1032	1.00	404.00	\N	16.00	0.00	481	4569	f	OKI IMPRESORA LASER COLOR C5600N	0	0.00
1033	1.00	35.00	\N	16.00	0.00	481	4179	f	INSTALACION / HORA	1	0.00
1034	1.00	3.31	\N	16.00	0.00	481	3335	f	LATIGUILLO UTP CAT.6E DE 2MTS PL1602	2	0.00
1035	1.00	1.51	\N	16.00	0.00	481	2889	f	LATIGUILLO UTP CAT.5E DE 4 MTS PL1005	3	0.00
1047	1.00	29.61	\N	16.00	0.00	481	3913	f	PEN DRIVE 4 GB GENERICO USB 2.0	4	0.00
1048	1.00	20.00	\N	16.00	0.00	486	4542	f	Reparaciones a Particulares	0	0.00
1049	1.00	20.00	\N	16.00	0.00	486	4543	f	Instalacion del SO Windows	1	0.00
1050	1.00	20.00	\N	16.00	0.00	487	4542	f	Reparaciones a Particulares	0	0.00
1051	1.00	20.00	\N	16.00	0.00	488	4542	f	Reparaciones a Particulares	0	0.00
1052	1.00	20.00	\N	16.00	0.00	488	4543	f	Instalacion del SO Windows	1	0.00
1036	1.00	0.00	\N	16.00	0.00	482	4184	f	HORAS CONTRATO	0	0.00
1037	1.00	0.00	\N	16.00	0.00	482	4185	f	DESPLAZAMIENTO CONTRATO	1	0.00
1038	1.00	19.43	\N	16.00	0.00	482	4030	f	FUENTE DE ALI. 460W GC PFC PIV 12CM 20/24 PIN	2	0.00
1039	1.00	0.00	\N	16.00	0.00	483	4185	f	DESPLAZAMIENTO CONTRATO	0	0.00
1040	1.00	0.00	\N	3.00	0.00	483	4184	f	HORAS CONTRATO	1	0.00
1041	1.00	80.11	\N	16.00	0.00	483	4529	f	BROTHER TAMBOR C-DR200	2	0.00
1042	1.00	250.00	\N	16.00	0.00	484	4189	f	Adapatación al alemán de la web abbacino.com\n	0	0.00
\.


--
-- Data for Name: lpedidoproveedor; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lpedidoproveedor (idlpedidoproveedor, desclpedidoproveedor, cantlpedidoproveedor, pvplpedidoproveedor, prevlpedidoproveedor, ivalpedidoproveedor, descuentolpedidoproveedor, idpedidoproveedor, idarticulo, puntlpedidoproveedor, ordenlpedidoproveedor, reqeqlpedidoproveedor) FROM stdin;
93	OKI IMPRESORA LASER COLOR C5600N	0.00	0.00	\N	0.00	0.00	34	4569	f	0	0.00
90	PORTES	1.00	14.00	\N	16.00	0.00	34	4191	f	1	\N
91	EPSON IMPT STYLUS PHOTO R2400 USB A3	1.00	678.13	\N	16.00	0.00	34	4190	f	2	\N
92	SP CONTAPLUS PRO 2007	2.00	162.76	\N	16.00	0.00	34	4178	f	3	\N
\.


--
-- Data for Name: lpresupuesto; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY lpresupuesto (idlpresupuesto, cantlpresupuesto, pvplpresupuesto, ivalpresupuesto, descuentolpresupuesto, idpresupuesto, idarticulo, desclpresupuesto, ordenlpresupuesto, reqeqlpresupuesto) FROM stdin;
747	1.00	1215.00	16.00	0.00	236	4193	POLLENSA\nCAMBIO FICHAS AVANT/HOTEL EN ALOJAMIENTO	0	0.00
821	20.00	85.05	16.00	0.00	279	4179	INSTALACION / HORA\nConfiguración Sistema y puesta a punto.	0	0.00
822	2.00	239.57	16.00	0.00	279	3960	ACCESS POINT NETGEAR WG102IS WIRELESS 108M PR	1	0.00
823	1.00	63.93	16.00	0.00	279	3337	CABLE D-LINK PROLONGACION ANTENA N-N WIRELESS	2	0.00
827	1.00	269.20	16.00	0.00	279	3011	ANTENA D-LINK ANT24-0800 8dBi EXTERIOR OMNIDI	3	0.00
825	1.00	179.70	16.00	0.00	279	3935	SWITCH NETGEAR GS608FS 8 PUERTOS 10/100/1000	4	0.00
832	1.00	85.05	16.00	0.00	280	4193	TRATAMIENTO DE IMÁGENES Y ADAPTACIÓN A WEB\n(2 DÍAS HÁBILES DESDE ACEPTACIÓN DE PRESUPUESTO)	0	0.00
756	1.00	36.45	16.00	0.00	239	4541	HOSTING PLAN BASE BÁSICO\nPANEL DE CONTROL\nMENSUAL	0	0.00
755	1.00	72.90	16.00	0.00	239	4540	HOSTING PLAN BASE PROFESIONAL\nASISTENCIA TOTAL + PANEL DE CONTROL\nMENSUAL	1	0.00
754	1.00	72.90	16.00	0.00	239	4203	CONTRATACION DE DOMINIO\nGESTIONES + PARKING 1 AÑO	2	0.00
757	1.00	121.50	16.00	0.00	239	4179	INSTALACION ZEN CART	3	0.00
753	1.00	215.61	16.00	0.00	239	3943	ROUTER ADSL NETGEAR WIRELESS DG834GTFS\n + SWITCTH 4 PUERTOS	4	0.00
758	1.00	459.27	16.00	0.00	240	4189	QL 1050\nImpresora de etiquetas profesional	0	0.00
759	1.00	920.97	16.00	0.00	240	4189	QL 1050N\nImpresora de etiquetas profesional con con servidor de\nimpresión en red incluido	1	0.00
760	1.00	83.01	16.00	0.00	240	4189	CINTA DE PAPEL BLANCA 102mm x 30,48 m	2	0.00
763	1.00	5346.00	16.00	0.00	242	4193	PROGRAMACION WEB\nDISTRIBUIDORA ROTGER	0	0.00
764	1.00	85.05	16.00	0.00	243	4193	PROGRAMACION WEB ABBACINO\n3 IDIOMAS\nPHP Y FLASH COMBINADOS\nFECHA: 21 DE MARZO	0	0.00
765	1.00	4374.00	16.00	0.00	244	4193	PROGRAMACION WEB\nLASGALLETASDETUSVIAJES.COM\nENTREGA: 1ª SEMANA MAYO	0	0.00
746	70.00	85.05	16.00	0.00	235	4239	PROGRAMACIONWEB\nFUNDACION LLABRES FELIU	0	0.00
766	1.00	860.22	16.00	0.00	246	4189	OKI C3300N\nImpresora Láser Color 12ppm color, 16 ppm monocromo\n1200x600 dpi, 32Mb RAM, Windows GDI/Mac Raster, 200 MHz, Tarjeta de Red, USB, Photo Mode	0	0.00
767	1.00	981.72	16.00	0.00	246	4189	OKI C3400N\nImpresora Láser Color 16ppm color, 20 ppm monocromo\n1200x600 dpi, 32Mb RAM, Windows GDI/Mac Raster, 200 MHz, Tarjeta de Red, USB, Photo Mode	1	0.00
768	1.00	532.17	16.00	0.00	246	4189	BROTHER LASER NEGRO HL 5240	2	0.00
769	1.00	677.97	16.00	0.00	246	4189	BROTHER LASER NEGRO HL 5250DN	3	0.00
782	1.00	2041.20	16.00	0.00	253	4434	PORTATIL HP NX7300 T5500 1GB 80GB DVD-RW 15.4	0	0.00
781	30.00	33.78	16.00	0.00	252	2880	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00
721	1.00	2228.31	16.00	0.00	226	4189	MULTIF OKI COLOR 5510+IMPUEST2	0	0.00
722	1.00	2969.46	16.00	0.00	226	4189	MULTIF OKI COLOR 5540+IMPUEST2	1	0.00
780	1.00	1154.86	16.00	0.00	250	4189	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA\nMEMORIA DDR2	0	0.00
752	1.00	271.92	16.00	0.00	238	4539	AVG Internet Security\n5 Licencias / 1 año\nProtección integral (antivurs, antispyware, firewall y antispam)\npara particulares y pequeñas empresas	0	0.00
783	1.00	162.57	16.00	0.00	254	4539	AVG Internet Security\n3 Licencias / 1 Año	0	0.00
784	1.00	130.98	16.00	0.00	254	4538	AVG Anti-Virus Professional Edition\n3 Licencias / 1 Año	1	0.00
770	1.00	173.26	16.00	0.00	247	4189	TN-3130 Cartucho Tóner Brother\nHasta 3.500 páginas A4	0	0.00
771	1.00	228.37	16.00	0.00	247	4189	TN-3170 Cartucho Tóner Brother\nHasta 7.000 páginas A4	1	0.00
772	1.00	385.84	16.00	0.00	247	4189	DR-3100 Tambor Brother\nHasta 25.000 páginas A4	2	0.00
773	1.00	93.26	16.00	0.00	247	4189	TONER OKI C33 -C34 Color 1 Kg.	3	0.00
774	1.00	66.61	16.00	0.00	247	4189	TONER OKI C33 -C34 Negro 1 Kg.	4	0.00
775	1.00	79.92	16.00	0.00	247	4189	TAMBOR OKI C33 -C34 Color 15 Kg.	5	0.00
776	1.00	79.92	16.00	0.00	247	4189	TAMBOR OKI C33 -C34 Negro 15 Kg.	6	0.00
733	1.00	2228.31	16.00	0.00	230	4189	OKI C5510 MFC MULTIFUNCIÓN COLOR	0	0.00
736	1.00	848.07	16.00	0.00	230	4189	BROTHER MFC 7820N	3	0.00
737	1.00	36.45	16.00	0.00	230	4189	CANON LPI BROTHER	4	0.00
786	1.00	109.62	16.00	0.00	256	3990	GATEWAY NETGEAR WGR614FS WIRELESS 54MBPS + 4x	0	0.00
787	1.00	85.05	16.00	0.00	256	4179	INSTALACION / HORA	1	0.00
788	1.00	14.58	16.00	0.00	256	4180	DESPLAZAMIENTO PALMA	2	0.00
792	1.00	41.31	16.00	0.00	257	4541	HOSTING PLAN BASE BÁSICO MENSUAL\nC PANEL	0	0.00
790	1.00	72.90	16.00	0.00	257	4540	HOSTING PLAN BASE PROFESIONAL MENSUAL\nC PANEL + ASISTENCIA COMPLETA	1	0.00
789	1.00	72.90	16.00	0.00	257	4203	CONTRATACION DE DOMINIOS\nwww.fundaciollabresfeliu.com\nwww.fundacionllabresfeliu.com (redirigido)	2	0.00
785	17.00	33.78	16.00	0.00	255	2880	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00
748	3.00	85.05	16.00	0.00	237	4193	Estudio viabilidad Flash Dinamico o DHTML\nCreacion de Subversion e infraestructura.\n	0	0.00
751	10.00	85.05	16.00	0.00	237	4193	Programacion Backnet\n- Manejo de proyectos, fotografias y publicaciones.\nEntrada controlada. Monitorizacion de accesos.	1	0.00
749	4.00	89.91	16.00	0.00	237	4193	Creacion y modelado de la base de Datos\n-------------------------------------------------------------------\nTabla de proyectos, tabla de fotografias, tabla de publicaciones.\ncontemplacion multiples idiomas.	2	0.00
750	20.00	85.05	16.00	0.00	237	4193	Programacion FrontEnd\n- Efectos en fotografias\n- Efectos de montaje de menu desplegable.	3	0.00
779	1.00	72.90	16.00	0.00	248	4540	Alojamiento Plan Profesional\nIncluye:\n- 100 cuentas de e-mail\n- Base de Datos MySQL\n- 300 Mb de Espacio en Disco\n\n(suficiente para sencart).\n\n(Este es un pago mensual)	0	0.00
778	1.00	72.90	16.00	0.00	248	4203	CONTRATACION / RENOVACION DE DOMINIOS\nmarketholiday.com\n(Este es un pago anual)	1	0.00
777	1.00	279.45	16.00	0.00	248	4193	Puesta en marcha del servidor de tienda virtual\n y comercio electronico SENCART	2	0.00
797	1.00	874.80	16.00	0.00	266	4230	HOSTING ANUAL\nGNLEON.COM\nGESTORIANAUTICALEON.COM\n	0	0.00
795	1.00	364.50	16.00	0.00	264	4240	PAGO ANUAL ACTUALIZACIÓN BULMAGES	0	0.00
796	1.00	85.05	16.00	0.00	264	4208	MANTENIMIENTO MENSUAL BULMAGES	1	0.00
761	1.00	459.27	16.00	0.00	241	4189	QL 1050\nImpresora de etiquetas profesional	0	0.00
762	1.00	83.01	16.00	0.00	241	4189	CINTA DE PAPEL BLANCA 102mm x 30,48 m	1	0.00
804	1.00	0.00	16.00	0.00	269	4550	INSTALACION Y PUESTA EN MARCHA	0	0.00
815	5.00	85.05	16.00	0.00	276	4239	Programacion Base de Datos:\n- Usuarios\n- Promociones, Tipos de Promociones\n- Galeria de Fotos para Promocion\n- Tipos de Galerias \n- Documentacion Adicional Promociones\n- Tipos de Documentacion Promociones\n- Traducciones a Multiples idiomas, es, ca, en, de, fr	0	0.00
813	9.00	85.05	16.00	0.00	276	4193	Creación Parte Administrativa:\n- Acceso de modo restringido.\n- Gestion de usuarios\n- Gestion de Promociones, manteniendo los tipos actuales.\n- Gestión de Galerias de Fotos para Promociones\n- Gestión de documentacion adicional para promociones\n- Gestion de paginas dinamicas.	1	0.00
814	9.00	85.05	16.00	0.00	276	4193	Creación Parte Publica del website.\nAcceso con los datos cogidos de la base de datos.\nManteniendo el diseño actual de la página.	2	0.00
812	6.00	85.05	16.00	0.00	276	4193	Validacion W3C\nLa pagina validara el estandar w3c de paginas web:\nhttp://validator.w3c.org\nLa tecnología utilizada será:\nServidor Apache 1.3 o apache 2.0\nPHP v4.3 ~ PHP v5.0\nMySQL v 5.1 ~ 7.1\nCodificación UTF-8 en todo el sistema.	3	0.00
830	16.00	85.05	16.00	0.00	276	4193	-------------------------------------------------------------------\nSistema de Geolocalizacion GIS.\nConsiste en localizar el inmueble a través de \nlos mapas de Google Maps.\n\nTambién se pueden agregar indicadores de\nvalor añadido sobre el mapa como p.ej:\nFarmacias, bares, escuelas, centros sanitarios ....	4	0.00
738	1.00	1102.30	16.00	0.00	231	4189	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	0	0.00
739	1.00	1102.30	16.00	0.00	232	4189	FEEL INTEL CORE2 DUO E4300 DUAL CORE A GIGA	0	0.00
824	1.00	607.50	16.00	0.00	279	4189	CAJA ENRACKABLE	5	0.00
826	1.00	226.89	16.00	0.00	279	2883	BOBINA CABLE UTP RIGIDO CAT.5E 305 MTS KN5015	6	0.00
828	5.00	9.72	16.00	0.00	279	4189	CANALETA Pared	7	0.00
829	15.00	9.72	16.00	0.00	279	4189	CANALETA Suelo	8	0.00
734	1.00	3124.98	16.00	0.00	230	4189	OKI C5540 MFC MULTIFUNCION COLOR	1	0.00
735	1.00	295.76	16.00	0.00	230	4189	CANON LPI OKI	2	0.00
801	1.00	4072.66	16.00	10.00	269	4189	EQUIPO SERVIDOR MONTADO MIRROR	1	0.00
802	1.00	1518.34	16.00	10.00	269	3862	SOFT. WINDOWS 2003 SERVER R2a ESP 5 CAL OEM 1	2	0.00
803	5.00	284.19	16.00	10.00	269	3212	SOFT. LICENCIA WINDOWS TERMINAL SERVER CAL	3	0.00
805	70.00	85.05	16.00	0.00	270	4239	PROGRAMACION WEB\nFUNDACION LLABRES FELIU	0	0.00
807	1.00	5.35	16.00	0.00	272	4193	PROGRAMACION WEB\nDISTRIBUIDORA ROTGER	0	0.00
806	1.00	607.50	16.00	0.00	271	4193	AÑADIR SISTEMA TRADUCCIÓN ALEMÁN\nABBACINO	0	0.00
809	1.00	1215.00	16.00	0.00	274	4211	MANTENIMIENTO SERVIDOR APACHE ANUAL LLABRES FELIU	0	0.00
810	1.00	72.90	16.00	0.00	275	4203	CONTRATACION / RENOVACION DE DOMINIOS\ndisglobalgames.com\nMantenimiento  3 cuentas de correo. (anual)	0	0.00
811	1.00	53.46	16.00	0.00	275	4208	MANTENIMIENTO BULMAGES (mensual)	1	0.00
816	1.00	77.76	16.00	0.00	277	4189	BASE REPOSAPIES REGULABLE ANATOMICA	0	0.00
817	1.00	30.38	16.00	0.00	277	4189	BASE REPOSAPIES REGULABLE BASICO	1	0.00
818	1.00	75.33	16.00	0.00	277	4189	BASE MONITOR + CAJÓN	2	0.00
714	1.00	121.50	16.00	0.00	224	4193	RESPUESTAS EXAMENES\n(15 DÍAS)	0	0.00
715	1.00	972.00	16.00	0.00	224	4193	PREGUNTAS DE TEST ON-LINE\n(30 DÍAS)	1	0.00
716	1.00	121.50	16.00	0.00	224	4193	NOTAS OFICIALES\n(15 DÍAS)	2	0.00
717	1.00	121.50	16.00	0.00	224	4193	PROGRAMACION CURSOS\n(15 DÍAS)	3	0.00
718	1.00	1215.00	16.00	0.00	224	4193	EL PORTAL NÁUTICO\n(60 DÍAS)\n-Publican alumnos y profesores - con secciones-	4	0.00
719	1.00	243.00	16.00	0.00	224	4193	AULAS\n(30 DÍAS)	5	0.00
720	1.00	729.00	16.00	0.00	224	4193	PROGRAMACION WEB\nCAMBIOS ESTÁTICOS\n(10 DÍAS)\n	6	0.00
731	5.00	33.68	16.00	0.00	228	2880	CABLE SEGURIDAD PARA PORTATILES CKNBLOCK	0	0.00
725	1.00	72.90	16.00	0.00	227	4203	HOSTING MENSUAL\nWEB+E-MAILS	0	0.00
723	1.00	121.50	16.00	0.00	227	4189	MANTENIMIENTO SERVIDOR MENSUAL\n	1	0.00
727	1.00	437.40	16.00	0.00	227	4189	MANTENIMIENTO 4 ORDENADORES\n3 TPV	2	0.00
728	1.00	97.20	16.00	0.00	227	4189	MANTENIMIENTO DE RED + VPN	3	0.00
729	1.00	437.40	16.00	0.00	227	4184	INSTALACION SERVIDOR VPN +INSTALACION 3 CLIENTES	4	0.00
730	1.00	607.50	16.00	0.00	227	4184	PREMANTENIMIENTO: INSTALACION SERVIDOR\n +INSTALACION EQUIPOS\n + INSTALACION SAI + CONFIGURACION DE RED Y EQUIPOS\nY REVISION DE SOFTWARE NECESARIO	5	0.00
831	15.00	85.05	16.00	0.00	276	4193	-------------------------------------------------------------------\nVisitas virtuales guiadas:\nConsiste en integrar un sistema de visitas virtuales\na través del programa 3DVista que genera\n - Fotos 360ª\n - Presentaciones de planos\n - Snapshots\n - Tours guiados.\n\nDichos archivos pueden guardarse en CD o en Flash\npara su visualización.\n\n** No incluye la licencia del programa **\nAprox. 800€ en version Enterprise.\nhttp://www.3dvista.com/\nDemos:\nhttp://www.3dvista.com/web/spainweb/indexspain.htm\n	5	0.00
833	1.00	364.50	16.00	0.00	282	4237	CONFIGURACION E INSTALACION OPENVPN	0	0.00
835	1.00	72.90	16.00	0.00	282	4238	CONFIGURACIÓN E INSTALACION DE 1 CLIENTE VPN	1	0.00
743	1.00	500.41	16.00	0.00	233	4189	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	0	0.00
740	1.00	465.98	16.00	0.00	233	3664	SOFT. OFFICE 2003 BASICO	1	0.00
741	1.00	156.81	16.00	0.00	233	3640	SWITCH CONCEPTRONIC 8 PTOS. 10/100/1000  CGIG	2	0.00
742	1.00	300.54	16.00	0.00	233	2852	SOFT. WINDOWS XP PROFESIONAL OEM	3	0.00
744	1.00	500.41	16.00	0.00	234	4189	TFT 19" ACER AL1916WAF PLATA PANORAMICO 5ms	0	0.00
745	1.00	300.54	16.00	0.00	234	2852	SOFT. WINDOWS XP PROFESIONAL OEM	1	0.00
799	1.00	874.80	16.00	0.00	267	4540	HOSTING PLAN BASE PROFESIONAL ANUAL\nwww.ajuntament de pollença.com	0	0.00
837	1.00	48.60	16.00	0.00	288	4542	Reparaciones a Particulares	0	0.00
819	1.00	874.80	16.00	0.00	278	4553	HOSTING ANUAL GIBPROMOCIONES.COM	0	0.00
820	1.00	72.90	16.00	100.00	278	4203	CONTRATACION ANUAL DE DOMINIO\nwww.gibpromociones.com	1	0.00
710	1.00	85.05	16.00	0.00	222	4179	\n\n\n\nINSTALACION / HORA	0	0.00
711	1.00	14.58	16.00	99.99	222	4180	\nDESPLAZAMIENTO PALMA	1	0.00
712	1.00	242.98	16.00	0.00	222	4178	\n\n\n\nSP CONTAPLUS PRO 2007	2	0.00
713	1.00	1883.25	16.00	0.00	223	4189	IMPT STYL PHOTO R2400 USB	0	0.00
838	1.00	486.00	16.00	0.00	289	4189	SIN DEFINIR (COMODIN)	0	0.00
839	1.00	145.80	16.00	0.00	290	4550	HORAS SERVIDOR	0	0.00
840	1.00	116.81	16.00	0.00	290	4418	CAJA SEMITORRE ATX 313152 NEGRA AZUL 2202	1	0.00
841	0.00	0.00	0.00	0.00	222	2814	MEMORIA DIMM SDRAM 256 MB 133MHZ MARCA	\N	0.00
836	1.00	48.60	16.00	0.00	287	4542	Reparaciones a Particulares	0	0.00
\.


--
-- Data for Name: ltarifa; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY ltarifa (idltarifa, idalmacen, idarticulo, idtarifa, pvpltarifa) FROM stdin;
\.


--
-- Data for Name: minimsalmacen; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY minimsalmacen (idminimsalmacen, idalmacen, idarticulo, valminimsalmacen) FROM stdin;
1	1	4573	100.00
\.


--
-- Data for Name: moneda; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY moneda (idmoneda, cod2moneda, cod3moneda, descmoneda) FROM stdin;
\.


--
-- Data for Name: movimiento; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY movimiento (idmovimiento, fechamovimiento, idarticulo, cantidadmovimiento, lotemovimiento, idalmacen, idlalbaran, idlalbaranp) FROM stdin;
13	2007-05-07	3439	-1.00	\N	1	1284	\N
14	2007-05-07	3438	-1.00	\N	1	1285	\N
85	2007-05-09	4554	-3.00	\N	1	1356	\N
86	2007-05-09	4529	-2.00	\N	1	1357	\N
15	2007-05-08	4230	-1.00	\N	1	1286	\N
17	2007-05-08	4179	-1.00	\N	1	1288	\N
18	2007-05-08	4203	-1.00	\N	1	1289	\N
19	2007-05-08	4211	-1.00	\N	1	1290	\N
30	2007-05-09	4184	-2.50	\N	1	1301	\N
31	2007-05-09	4185	-1.00	\N	1	1302	\N
117	2007-05-15	3068	-1.00	\N	1	1388	\N
118	2007-05-15	3067	-1.00	\N	1	1389	\N
121	2007-05-16	4179	-0.50	\N	1	1392	\N
122	2007-05-16	4180	-1.00	\N	1	1393	\N
105	2007-05-10	4240	-1.00	\N	1	1376	\N
106	2007-05-10	3535	-1.00	\N	1	1377	\N
107	2007-05-10	4179	-0.30	\N	1	1378	\N
97	2007-05-09	3937	-1.00	\N	1	1368	\N
98	2007-05-09	4185	-1.00	\N	1	1369	\N
99	2007-05-09	4184	-1.00	\N	1	1370	\N
4	2007-05-03	4193	-1.00	\N	1	1275	\N
141	2007-05-23	4179	-1.50	\N	1	1412	\N
142	2007-05-23	4538	-1.00	\N	1	1413	\N
5	2007-05-03	4540	-1.00	\N	1	1276	\N
143	2007-05-23	3003	-2.00	\N	1	1414	\N
144	2007-05-23	3012	-2.00	\N	1	1415	\N
6	2007-05-04	4203	-4.00	\N	1	1277	\N
7	2007-05-04	4203	-1.00	\N	1	1278	\N
8	2007-05-04	4203	-2.00	\N	1	1279	\N
9	2007-05-04	4203	-1.00	\N	1	1280	\N
10	2007-05-07	4180	-1.00	\N	1	1281	\N
11	2007-05-07	4179	-1.00	\N	1	1282	\N
12	2007-05-07	4030	-1.00	\N	1	1283	\N
108	2007-05-11	4560	-1.00	\N	1	1379	\N
145	2007-05-25	4565	-1.00	\N	1	1416	\N
93	2007-05-09	2905	-1.00	\N	1	1364	\N
94	2007-05-09	4184	-1.00	\N	1	1365	\N
95	2007-05-09	4185	-1.00	\N	1	1366	\N
40	2007-05-09	4554	-1.00	\N	1	1311	\N
41	2007-05-09	4555	-1.00	\N	1	1312	\N
20	2007-05-09	4189	-2.00	\N	1	1291	\N
21	2007-05-09	4189	-1.00	\N	1	1292	\N
24	2007-05-09	4004	-1.00	\N	1	1295	\N
25	2007-05-09	4003	-1.00	\N	1	1296	\N
26	2007-05-09	4002	-1.00	\N	1	1297	\N
27	2007-05-09	3969	-1.00	\N	1	1298	\N
22	2007-05-09	4553	-1.00	\N	1	1293	\N
23	2007-05-09	4203	-1.00	\N	1	1294	\N
38	2007-05-09	4180	-1.00	\N	1	1309	\N
39	2007-05-09	4179	-0.50	\N	1	1310	\N
62	2007-05-09	4185	-1.00	\N	1	1333	\N
63	2007-05-09	4179	-4.00	\N	1	1334	\N
64	2007-05-09	3825	-1.00	\N	1	1335	\N
65	2007-05-09	3159	-1.00	\N	1	1336	\N
66	2007-05-09	2896	-1.00	\N	1	1337	\N
28	2007-05-09	2890	-1.00	\N	1	1299	\N
29	2007-05-09	2843	-1.00	\N	1	1300	\N
125	2007-05-16	4179	-1.00	\N	1	1396	\N
126	2007-05-17	4184	-3.00	\N	1	1397	\N
127	2007-05-17	4185	-1.00	\N	1	1398	\N
128	2007-05-17	2892	-3.00	\N	1	1399	\N
89	2007-05-09	4185	-1.00	\N	1	1360	\N
90	2007-05-09	4184	-1.00	\N	1	1361	\N
91	2007-05-09	2889	-1.00	\N	1	1362	\N
92	2007-05-09	2889	-1.00	\N	1	1363	\N
173	2007-05-25	3439	-1.00	\N	1	1417	\N
174	2007-05-25	3438	-1.00	\N	1	1418	\N
82	2007-05-09	4184	-1.00	\N	1	1353	\N
83	2007-05-09	4185	-1.00	\N	1	1354	\N
84	2007-05-09	4530	-2.00	\N	1	1355	\N
175	2007-05-28	4244	-2.00	\N	1	1419	\N
96	2007-05-09	3451	-1.00	\N	1	1367	\N
183	2007-08-20	4189	-1.00	\N	1	1426	\N
184	2007-08-20	4189	-2.00	\N	1	1427	\N
185	2007-08-20	4189	-1.00	\N	1	1428	\N
1	2007-05-02	4503	1.00	2L708193A1658	1	\N	187
2	2007-05-02	4030	3.00	3470042011773	1	\N	188
3	2007-05-02	2905	2.00	8714909003094	1	\N	189
146	2007-05-25	4554	1.00	\N	1	\N	190
147	2007-05-25	4559	1.00	\N	1	\N	191
148	2007-05-25	4555	1.00	\N	1	\N	192
149	2007-05-25	4556	1.00	\N	1	\N	193
150	2007-05-25	4528	6.00	\N	1	\N	194
151	2007-05-25	4202	2.00	\N	1	\N	195
152	2007-05-25	4199	2.00	\N	1	\N	196
153	2007-05-25	4198	2.00	\N	1	\N	197
154	2007-05-25	4562	1.00	\N	1	\N	198
155	2007-05-25	4530	2.00	\N	1	\N	199
156	2007-05-25	4554	3.00	\N	1	\N	200
157	2007-05-25	4188	1.00	\N	1	\N	201
158	2007-05-25	4566	1.00	\N	1	\N	202
161	2007-05-25	4562	1.00	\N	1	\N	205
162	2007-05-25	4563	50.00	\N	1	\N	206
169	2007-05-25	4529	1.00	\N	1	\N	213
171	2007-05-25	4567	1.00	\N	1	\N	215
172	2007-05-25	4241	1.00	\N	1	\N	216
167	2007-05-25	4187	1.00	\N	1	\N	211
168	2007-05-25	4189	1.00	\N	1	\N	212
164	2007-05-25	4554	1.00	\N	1	\N	208
165	2007-05-25	4555	1.00	\N	1	\N	209
166	2007-05-25	4528	2.00	\N	1	\N	210
170	2007-05-25	4529	1.00	\N	1	\N	214
163	2007-05-25	4565	1.00	\N	1	\N	207
136	2007-05-23	4184	-3.00	\N	1	1407	\N
137	2007-05-23	4559	-1.00	\N	1	1408	\N
138	2007-05-23	4556	-1.00	\N	1	1409	\N
139	2007-05-23	4555	-1.00	\N	1	1410	\N
140	2007-05-23	4554	-1.00	\N	1	1411	\N
182	2007-08-13	4548	1.00	\N	1	\N	217
187	2007-11-08	4573	300.00	\N	1	\N	218
297	2007-12-04	4189	-1.00	\N	1	1539	\N
298	2007-12-04	4089	-1.00	\N	1	1540	\N
299	2007-12-04	4093	-1.00	\N	1	1541	\N
300	2007-12-04	4919	-1.00	\N	1	1542	\N
301	2007-12-04	4103	-1.00	\N	1	1543	\N
302	2007-12-04	4634	-1.00	\N	1	1544	\N
303	2007-12-04	4089	-1.00	\N	1	1545	\N
304	2007-12-04	4093	-2.00	\N	1	1546	\N
305	2007-12-04	4910	-1.00	\N	1	1547	\N
306	2007-12-04	4919	-1.00	\N	1	1548	\N
307	2007-12-04	4103	-1.00	\N	1	1549	\N
308	2007-12-04	4089	-2.00	\N	1	1550	\N
309	2007-12-04	4093	-2.00	\N	1	1551	\N
310	2007-12-04	4919	-2.00	\N	1	1552	\N
311	2007-12-04	4910	-1.00	\N	1	1553	\N
312	2007-12-04	4103	-1.00	\N	1	1554	\N
313	2007-12-04	4919	-1.00	\N	1	1555	\N
314	2007-12-04	4093	-1.00	\N	1	1556	\N
315	2007-12-04	4189	-1.00	\N	1	1557	\N
316	2007-12-04	4089	-1.00	\N	1	1558	\N
317	2007-12-04	4093	-1.00	\N	1	1559	\N
318	2007-12-04	4919	-1.00	\N	1	1560	\N
319	2007-12-04	4910	-1.00	\N	1	1561	\N
320	2007-12-04	4103	-1.00	\N	1	1562	\N
321	2007-12-04	4089	-1.00	\N	1	1563	\N
322	2007-12-04	4093	-1.00	\N	1	1564	\N
323	2007-12-04	4919	-1.00	\N	1	1565	\N
324	2007-12-04	4910	-1.00	\N	1	1566	\N
325	2007-12-05	4089	-1.00	\N	1	1567	\N
326	2007-12-05	4093	-1.00	\N	1	1568	\N
327	2007-12-05	4910	-1.00	\N	1	1569	\N
328	2007-12-05	4919	-79.00	\N	1	1570	\N
329	2007-12-10	4089	-3.00	\N	1	1571	\N
330	2007-12-10	4093	-2.00	\N	1	1572	\N
331	2007-12-10	4919	-1.00	\N	1	1573	\N
332	2007-12-12	4919	-1.00	\N	1	1574	\N
333	2007-12-12	4910	-1.00	\N	1	1575	\N
334	2007-12-12	4093	-1.00	\N	1	1576	\N
335	2007-12-12	4919	-2.00	\N	1	1577	\N
336	2007-12-12	4093	-1.00	\N	1	1578	\N
337	2007-12-12	4089	-1.00	\N	1	1579	\N
134	2007-05-21	4562	-1.00	\N	1	1405	\N
135	2007-05-21	4563	-50.00	\N	1	1406	\N
\.


--
-- Data for Name: nofactura; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY nofactura (idnofactura, numnofactura, fechanofactura, conceptnofactura, observnofactura, idalmacen) FROM stdin;
\.


--
-- Data for Name: pago; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY pago (idpago, idproveedor, fechapago, cantpago, refpago, previsionpago, comentpago, idtrabajador, idbanco, idasientopago) FROM stdin;
89	7	2007-01-10	151.73	BTURJT	f	BROTHER DIALMA	\N	\N	1109
91	5	2007-01-26	37.50	VSHKXW	t	TIENDA	\N	\N	1110
92	5	2007-01-26	28.19	UVHYFI	t	INMOVILIZADO	\N	\N	1111
94	5	2007-02-01	42.74	POVHXI	t	TIENDA	\N	\N	1112
95	11	2007-01-11	1180.47	YTGOLI	f	ACOMAN PYLSA	\N	\N	1113
96	33	2007-01-18	250.04	OZDCTQ	f	TARJETAS CONETXIA	\N	\N	1114
97	7	2007-02-22	412.88	XFHYRL	t	TINTA DIALMA	\N	\N	1115
98	7	2007-02-09	50.53	FBWSQS	f	DIALMA	\N	\N	1116
99	7	2007-03-14	66.91	TKGFJV	t	TAMBOR OKI	\N	\N	1117
100	5	2007-03-09	413.18	ZHMULP	t	MAT	\N	\N	1118
101	5	2007-03-09	1488.64	DMJYLP	t	DIALMA	\N	\N	1119
103	7	2007-03-02	79.26	UVRHKP	f	AZUL YATCHS	\N	\N	1120
104	5	2007-02-21	464.46	TBSQGT	f	FED. BALEAR TIRO	\N	\N	1121
105	5	2007-02-22	575.91	XZINVQ	f	MAT	\N	\N	1122
106	5	2007-02-15	2558.88	MYCVWN	f	MAT	\N	\N	1123
107	5	2007-02-21	3.54	LGTMEC	f	GIB	\N	\N	1124
108	5	2007-02-17	198.34	GYXXFH	f	GIB	\N	\N	1125
109	5	2007-03-02	20.80	MYIEOO	f	TIENDA	\N	\N	1126
110	5	2007-02-08	191.95	XLNFYI	f	MAT	\N	\N	1127
111	8	2007-02-02	49.08	VLGXGD	f	ADMAS BALEARES	\N	\N	1128
112	7	2007-01-09	407.62	WSNBXT	f	BROTHER DIALMA	\N	\N	1129
113	5	2007-02-06	80.92	KRICCN	f	TIENDA	\N	\N	1130
114	17	2007-01-23	135.27	EJLBGQ	f	ONO	\N	\N	1131
115	5	2007-03-03	407.05	ISOPVD	f	MIGUEL SOLER	\N	\N	1132
116	17	2007-02-23	156.76	MKMQTS	f	ONO	\N	\N	1133
117	5	2007-03-21	296.14	VIPUQY	t	MAT	\N	\N	1134
118	7	2007-03-20	154.74	QSCZIJ	t	SPORT INCA	\N	\N	1135
119	5	2007-03-28	36.21	PUFJNS	t	MAT	\N	\N	1136
120	5	2007-03-30	214.30	XRQMGX	t	TFT GIB	\N	\N	1137
121	37	2007-03-19	606.00	OVMUKG	f	CERTIFICADO FINAL DE OBRA	\N	\N	1138
122	5	2007-05-17	220.98	[WCFQE	f	Pago Fra. 105920	\N	\N	1139
90	7	2007-01-27	332.69	WSNBXT	f	BROTHER DIALMA	\N	1	1140
123	7	2007-06-06	132.28	TXBSBZ	t	DIALMA	\N	1	1141
124	7	2007-05-14	363.08	BYFKIO	f	DIALMA	\N	1	1142
125	7	2007-05-23	187.12	YX[YNK	f	DIALMA	\N	1	1143
93	7	2007-02-12	317.45	TKSLPF	f	FEDERACION DE TIRO	\N	1	1144
127	7	2007-05-25	616.17	UXVMXB	t	DIALMA	\N	1	1145
128	7	2007-06-07	72.89	UQYVIZ	t	EUGENIO	\N	1	1146
129	7	2007-05-04	162.11	VJXZTF	f	DIALMA	\N	1	1147
130	7	2007-05-04	316.16	ORDNOQ	f	DIALMA	\N	1	1148
131	7	2007-05-21	66.91	YXQVED	f	DIALMA	\N	1	1149
132	7	2007-05-21	66.91	OYAIKY	f	DIALMA	\N	1	1150
133	21	2007-06-06	92.94	JEOHZW	t	CONETXIA	\N	1	1151
135	4	2007-08-13	1500.00	111	f	aasdfasdf	\N	\N	1152
137	5	2007-08-14	122.00	UMQIBH	f	hjkjhjkjhjkjhjkjhjkjhhjkj	\N	\N	1153
136	33	2007-08-31	456.00	SBDNFG	f	qwert asasdfas	\N	3	1154
\.


--
-- Data for Name: pais; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY pais (idpais, cod2pais, cod3pais, descpais) FROM stdin;
2	02	002	Francia
1	01	001	España
3	03	003	Portugal
4	as	ast	Tumbuttu as assdf
11	--	---	Nuevo pais
\.


--
-- Data for Name: pedido; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY pedido (idpedido, numpedido, fechapedido, descpedido, iddivision, idalmacen, idtrabajador) FROM stdin;
\.


--
-- Data for Name: pedidocliente; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY pedidocliente (idpedidocliente, numpedidocliente, fechapedidocliente, refpedidocliente, descpedidocliente, comentpedidocliente, contactpedidocliente, telpedidocliente, idpresupuesto, procesadopedidocliente, idcliente, idforma_pago, idalmacen, idtrabajador, totalpedidocliente, bimppedidocliente, imppedidocliente) FROM stdin;
433	132	2007-05-09	FBMTJF	HOSTING	\N	Asociacion Iglues		\N	t	103	4	1	1	417.60	360.00	57.60
400	99	2007-03-29	IPCMVW	CONF. OKI	No coge bien el tamano del papel	Asociacion Iglues		\N	t	59	1	1	6	40.60	35.00	5.60
314	13	2007-01-04	DQLKIY	INSTALAR IMPRESORA	\N	Asociacion Iglues		\N	t	26	6	1	6	202.03	174.16	27.86
327	26	2007-01-17	KMSMQN	RECUPERAR DOCUMENTOS/VIRUS	\N	Asociacion Iglues		\N	t	64	1	1	6	37.41	32.25	5.16
321	20	2007-01-10	MUNTVG	REPARAR EQUIPO IBM	\N	Asociacion Iglues		\N	t	63	6	1	6	6.48	5.59	0.89
331	30	2007-01-25	BHZGVX	TONER HL-2070N/REVISION EQUIPOS	\N	Asociacion Iglues		\N	t	26	6	1	6	70.17	60.49	9.68
336	35	2007-01-19	ECTQAX	ORIGINALDELI	\N	Asociacion Iglues		\N	f	114	1	1	1	58.00	50.00	8.00
342	41	2007-02-01	ELDBXH	lasgalletasdetusviajes	\N	Asociacion Iglues		\N	t	16	1	1	1	34.80	30.00	4.80
340	39	2007-01-31	WKQREA	FUENTE ALIMENTACION	\N	Asociacion Iglues		\N	t	91	1	1	6	37.53	32.35	5.18
470	314173	2007-05-23	QXGFHF	REVISAR EQUIPO-A.CAMBA	\N	Asociacion Iglues		\N	t	40	\N	1	6	92.10	79.40	12.70
469	162	2007-05-22	JZEJVN	MANTEMINIENTO - ENTREGA TONER	\N	Asociacion Iglues		\N	t	26	6	1	6	165.36	142.55	22.81
351	50	2007-02-09	CCOBCG	SERVIDOR	\N	Asociacion Iglues		\N	t	133	1	1	2	174.00	150.00	24.00
330	29	2007-01-25	NLUSQF	g-ribasazcona	\N	Asociacion Iglues		\N	t	116	1	1	1	34.80	30.00	4.80
346	45	2007-02-06	VVSOHG	CABLES DE SEGURIDAD	\N	Asociacion Iglues		\N	t	108	7	1	6	80.39	69.30	11.09
352	51	2007-02-12	IDPVMK	OMAR	\N	Asociacion Iglues		\N	t	64	1	1	6	47.56	41.00	6.56
350	49	2007-02-09	DNHVNN	www.rosconstruccion.com	\N	Asociacion Iglues		\N	t	119	1	1	2	34.80	30.00	4.80
363	62	2007-02-20	BWRKUG	ORDENADOR 2	\N	Asociacion Iglues		\N	t	10	6	1	6	526.20	453.62	72.58
362	61	2007-02-20	BHMMAZ	ORDENADOR 1	\N	Asociacion Iglues		\N	t	10	1	1	6	526.20	453.62	72.58
357	56	2007-02-15	YUEQDS	GIBPROMOCIONES.COM	\N	Asociacion Iglues		\N	t	103	1	1	2	34.80	30.00	4.80
364	63	2007-02-20	[MJXDT	TFT + SOFT 1	\N	Asociacion Iglues		\N	t	10	6	1	6	679.64	585.90	93.74
371	70	2007-03-08	NDJDZN	DISTRIBUDORA ROTGER	\N	Asociacion Iglues		\N	f	16	7	1	2	2552.00	2200.00	352.00
373	72	2007-03-08	PDGFJ[	GALLETAS	\N	Asociacion Iglues		\N	f	16	7	1	8	2088.00	1800.00	288.00
376	75	2007-02-05	JGKYCJ	JAUME ESTRANY	\N	Asociacion Iglues		\N	t	10	6	1	6	222.27	191.61	30.66
345	44	2007-02-05	JRHZGM	MAT CATI	\N	Asociacion Iglues		\N	t	26	6	1	6	57.64	49.69	7.95
379	78	2006-11-16	JQGDXX	Pagina web InverPec	\N	Asociacion Iglues		\N	f	54	1	1	8	4639.94	3999.95	639.99
382	81	2007-03-20	KPNBCT	CUCHILLAS ETIQUETAS	\N	Asociacion Iglues		\N	t	10	6	1	6	8.80	7.59	1.21
370	69	2007-03-06	XGOQWP	SON COCO	\N	Asociacion Iglues		\N	t	10	1	1	\N	682.22	588.12	94.10
380	79	2007-03-20	IPUTDF	GATEWAY	\N	Asociacion Iglues		\N	t	57	1	1	6	97.46	84.02	13.44
386	85	2007-03-23	NAPARM	DOMINIOS	\N	Asociacion Iglues		\N	t	57	6	1	1	81.20	70.00	11.20
387	86	2007-03-23	HTSMMW	TOLO MAYOL	\N	Asociacion Iglues		\N	t	40	1	1	6	34.80	30.00	4.80
392	91	2007-03-27	BXIMM[	VISITA	\N	Asociacion Iglues		\N	t	54	1	1	6	40.60	35.00	5.60
388	87	2007-03-23	GBOFBF	GRABADORAS DVD	\N	Asociacion Iglues		\N	t	10	6	1	6	69.60	60.00	9.60
389	88	2007-03-23	SDNJBT	TN2000	\N	Asociacion Iglues		\N	t	10	1	1	6	210.51	181.47	29.04
396	95	2007-03-29	IXBPGP	ORDENADOR	\N	Asociacion Iglues		\N	t	10	6	1	6	562.60	485.00	77.60
403	102	2007-04-02	QYIBYU	TPV	\N	Asociacion Iglues		\N	t	93	1	1	2	527.45	454.70	72.75
399	98	2007-03-26	RXACNC	AVG	\N	Asociacion Iglues		\N	t	103	2	1	6	77.60	66.90	10.70
407	106	2007-04-17	WTYNHH	TINTA	\N	Asociacion Iglues		\N	t	91	1	1	1	39.95	34.44	5.52
398	97	2007-03-28	IVSGDN	CABLES	\N	Asociacion Iglues		\N	t	124	1	1	6	274.11	236.30	37.81
408	107	2007-04-24	YRPKXT	MAT	\N	Asociacion Iglues		\N	t	103	4	1	6	371.70	320.43	51.28
394	93	2007-03-26	RTLTJO	PORTATIL	\N	Asociacion Iglues		\N	t	54	7	1	1	974.40	840.00	134.40
372	71	2007-01-29	WEQSZA	ABBACINO	\N	Asociacion Iglues		\N	t	16	7	1	8	1380.40	1190.00	190.40
374	73	2007-02-21	X[RUUZ	Fundacion Llabres Feliu	\N	Asociacion Iglues		\N	f	16	7	1	8	2842.00	2450.00	392.00
411	110	2007-04-24	ICTPNV	INSTALAR IMPRESORAS	\N	Asociacion Iglues		\N	t	26	6	1	6	4.95	4.27	0.68
416	115	2007-04-25	FDGTRG	CREAR CTA.EMAIL NUEVA Y FALLO PASSWD EMAIL JOSE	\N	Asociacion Iglues		\N	f	98	6	1	\N	10.15	8.75	1.40
420	119	2007-04-26	INLXZA	HOST	\N	Asociacion Iglues		\N	t	132	1	1	1	417.60	360.00	57.60
401	100	2007-03-30	UNIIYN	LIMPIEZA EQUIPOS	\N	Asociacion Iglues		\N	t	23	1	1	6	63.14	54.43	8.71
391	90	2007-04-27	GWCFSO	ENTREGA TONER	\N	Asociacion Iglues		\N	t	26	1	1	6	708.60	610.86	97.74
361	60	2007-02-19	QAIKVN	MAT Y BFACT	\N	Asociacion Iglues		\N	t	121	1	1	6	467.22	402.78	64.44
422	121	2007-05-04	DOCKNO	INFOPOLLENSA.COM	\N	Asociacion Iglues		\N	t	16	1	1	1	34.80	30.00	4.80
423	122	2007-05-04	[SYCTD	SWITCH	\N	Asociacion Iglues		\N	t	103	4	1	6	379.13	326.84	52.29
425	124	2007-05-07	UDRXOU	TINTA	\N	Asociacion Iglues		\N	t	126	1	1	2	33.99	29.30	4.69
461	157	2007-05-15	[FCGSO	MATERIAL ETIQUETAS	\N	Asociacion Iglues		\N	t	26	6	1	6	1109.22	956.22	153.00
465	158	2007-05-17	VCDYLI	MANT/SA GERRERIA	\N	Asociacion Iglues		\N	t	103	4	1	6	8.40	7.24	1.16
427	126	2007-04-25	KIOYPZ	HOST	\N	Asociacion Iglues		\N	t	44	1	1	1	417.60	360.00	57.60
430	129	2007-05-08	DOOEWQ	RENOVACION .COM	\N	Asociacion Iglues		\N	t	41	6	1	1	34.80	30.00	4.80
431	130	2007-05-07	VLVVBH	MANTENIMIENTO	\N	Asociacion Iglues		\N	t	19	2	1	1	580.00	500.00	80.00
432	131	2007-05-08	LRMBBX	ACCESORIOS	\N	Asociacion Iglues		\N	t	23	1	1	\N	73.08	63.00	10.08
367	66	2006-10-09	FJFSVG	WEB	\N	Asociacion Iglues		\N	f	106	\N	1	8	3178.40	2740.00	438.40
471	163	2007-05-23	HGMRII	TONER	\N	Asociacion Iglues		\N	t	28	1	1	8	101.24	87.28	13.96
366	65	2007-02-20	NJFYJY	IMPRESORA EPSON	\N	Asociacion Iglues		\N	t	91	1	1	2	69.88	60.24	9.64
348	47	2007-02-07	YCKOGN	MAT MARGA	\N	Asociacion Iglues		\N	t	40	\N	1	6	98.21	84.66	13.54
402	101	2007-04-02	EV[JIT	VISITA	\N	Asociacion Iglues		\N	t	54	1	1	6	128.76	111.00	17.76
395	94	2007-03-27	YUJKKK	T. RED	\N	Asociacion Iglues		\N	t	54	1	1	6	94.73	81.66	13.07
377	76	2007-03-09	QENLSH	IMPRESORAS	\N	Asociacion Iglues		\N	t	59	1	1	\N	1115.92	962.00	153.92
436	134	2007-04-10	PNNDII	VISITA	\N	Asociacion Iglues		\N	t	59	1	1	6	27.26	23.50	3.76
437	135	2007-04-11	CEOTVX	TONER	\N	Asociacion Iglues		\N	t	10	6	1	6	76.32	65.79	10.53
358	57	2007-02-16	TLUVJW	MANT	Problemas con programa de facturacion	Asociacion Iglues		\N	t	13	1	1	6	99.08	85.41	13.67
365	64	2007-02-20	WKNSLS	TFT + SOTF 2	\N	Asociacion Iglues		\N	t	10	6	1	6	382.35	329.61	52.74
369	68	2007-02-20	NGIXEL	CABLES	\N	Asociacion Iglues		\N	t	108	7	1	6	241.16	207.90	33.26
368	67	2007-02-20	QXCIHW	MAT	\N	Asociacion Iglues		\N	t	9	\N	1	6	80.33	69.25	11.08
463	314166	2007-05-16	DYIIKQ	REVISION ONO	\N	Asociacion Iglues		\N	t	139	1	1	6	20.30	17.50	2.80
304	3	2007-01-10	KPOJTD	Impresora Jaume	\N	Asociacion Iglues		\N	t	10	6	1	6	100.92	87.00	13.92
412	111	2007-04-25	UHDPIS	REVISION COPIAS A CINTA	\N	Asociacion Iglues		\N	t	59	1	1	6	40.60	35.00	5.60
305	4	2007-01-10	QTUHYJ	BROTHER	\N	Asociacion Iglues		\N	t	10	6	1	6	\N	173.20	0.00
303	2	2007-01-09	XXMWRQ	BRTOHER CATI	\N	Asociacion Iglues		\N	t	10	6	1	6	\N	24.00	3.84
306	5	2007-01-10	VBDXNN	IMPRESORA	\N	Asociacion Iglues		\N	t	23	1	1	6	899.00	775.00	124.00
454	152	2007-05-02	CIWUGP	MANT	\N	Asociacion Iglues		\N	t	26	6	1	6	326.06	281.09	44.98
302	1	2007-01-09	TVUVLN	CONTAPLUS	\N	Asociacion Iglues		\N	t	8	1	1	6	525.48	453.00	72.48
419	118	2007-05-08	JAFAGB	Material Dialma	\N	Asociacion Iglues		\N	t	26	6	1	6	9.71	8.37	1.34
450	148	2007-04-20	BBEQLF	MANT	\N	Asociacion Iglues		\N	t	103	4	1	6	130.00	112.07	17.93
308	7	2007-01-15	GQGKTW	BROTHER	\N	Asociacion Iglues		\N	t	91	1	1	1	414.97	357.73	57.23
333	32	2007-01-29	TUXCBT	ORDENADOR Y ESCANER DE ESCUELA DEL MAR	\N	Asociacion Iglues		\N	t	40	\N	1	6	46.40	40.00	6.40
322	21	2007-01-10	ZTBFVE	CONECTAR EQUIPO057CONFIGURAR IMPRESORAS	\N	Asociacion Iglues		\N	t	13	6	1	6	2.10	1.81	0.29
458	314161	2007-05-10	KQTYYO	TALLER	\N	Asociacion Iglues		\N	t	40	1	1	6	40.61	35.01	5.60
337	36	2006-11-15	MYVGGU	CABLES SEGURIDAD	\N	Asociacion Iglues		\N	t	108	7	1	6	3283.91	2830.96	452.95
468	161	2007-05-28	IF[NDG	MANT - LACIE EN RED	\N	Asociacion Iglues		\N	f	103	4	1	6	238.99	206.03	32.96
343	42	2007-02-05	IWQZDH	MANT MAT	\N	Asociacion Iglues		\N	t	103	1	1	6	220.45	190.04	30.40
347	46	2007-02-07	DZTCRV	TFT	\N	Asociacion Iglues		\N	t	103	1	1	6	283.97	244.80	39.17
472	314175	2007-05-23	IMNDGI	TINTAS	\N	Asociacion Iglues		\N	t	91	1	1	2	39.23	33.82	5.41
457	154	2007-04-24	NSTJHX	BulmaGés	\N	Asociacion Iglues		\N	t	135	1	1	2	139.20	120.00	19.20
344	43	2007-02-05	BFZBCB	MAT	\N	Asociacion Iglues		\N	t	91	1	1	6	270.31	233.03	37.28
356	55	2007-02-15	PLRBUW	PROGRAMACION WEB	\N	Asociacion Iglues		\N	f	40	1	1	8	40.60	35.00	5.60
473	314176	2007-05-24	FDVLPM	MANT - HD500GB UBUNTU	\N	Asociacion Iglues		\N	f	103	4	1	6	142.60	122.93	19.67
418	117	2007-04-26	DPNUAN	Cambios Web	\N	Asociacion Iglues		\N	f	98	6	1	1	40.60	35.00	5.60
417	116	2007-04-25	VOTHJN	WEB Pollensa	\N	Asociacion Iglues		\N	f	16	\N	1	8	487.20	420.00	67.20
477	314180	2007-04-17	HZXILT	FUNDACION LLABRES FELIU	\N	Asociacion Iglues		\N	f	127	1	1	1	236.64	204.00	32.64
478	314181	2007-05-28	JTCVQN	RENOVACION DOMINIO	\N	Asociacion Iglues		\N	f	98	6	1	1	34.80	30.00	4.80
459	156	2007-05-14	NVDZCF	ANIMASEALOUNGE	\N	Asociacion Iglues		\N	f	136	1	1	1	69.60	60.00	9.60
480	314182	2007-05-28	JTNUSH	HOST	\N	Asociacion Iglues		\N	f	140	1	1	1	87.00	75.00	12.00
307	6	2007-01-10	YYKJWR	REFORMAS WEB	\N	Asociacion Iglues		\N	f	57	6	1	8	1682.00	1450.00	232.00
485	314187	2007-05-30	MQRIVD	RATONES	\N	Asociacion Iglues		\N	f	57	6	1	6	167.32	144.24	23.08
481	314183	2007-05-28	KNMZWF	IMPRESORA	\N	Asociacion Iglues		\N	f	24	\N	1	6	549.18	473.43	75.75
486	314188	2007-07-12	CXZKQC	\N	\N	Asociacion Iglues		\N	f	136	1	1	6	46.40	40.00	6.40
487	314189	2007-07-12	PYLKKN	\N	\N	Asociacion Iglues		\N	f	137	1	1	6	23.20	20.00	3.20
488	314190	2007-07-12	BBFXAG	\N	\N	Asociacion Iglues		\N	f	136	1	1	1	46.40	40.00	6.40
482	314184	2007-05-29	FVPLVY	MANT	\N	Asociacion Iglues		\N	f	26	6	1	6	22.54	19.43	3.11
483	314185	2007-05-29	OZLNJC	DR2000	\N	Asociacion Iglues		\N	f	26	6	1	6	92.93	80.11	12.82
484	314186	2007-05-29	MGCYWI	Adapatación al alemán de la web abbacino.com	\N	Asociacion Iglues		\N	f	16	7	1	8	290.00	250.00	40.00
\.


--
-- Data for Name: pedidoproveedor; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY pedidoproveedor (idpedidoproveedor, numpedidoproveedor, fechapedidoproveedor, refpedidoproveedor, descpedidoproveedor, comentpedidoproveedor, contactpedidoproveedor, telpedidoproveedor, procesadopedidoproveedor, idproveedor, idforma_pago, idalmacen, idtrabajador, totalpedidoproveedor, bimppedidoproveedor, imppedidoproveedor) FROM stdin;
34	1	2007-01-11	YTGOLI	ACOMAN PYLSA	\N	Rosa Molina	\N	t	11	1	1	1	\N	1017.65	162.82
\.


--
-- Data for Name: precio_compra; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY precio_compra (idprecio_compra, idarticulo, iddivision, idalmacen, fechapreciocompra, valorpreciocompra) FROM stdin;
\.


--
-- Data for Name: presupuesto; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY presupuesto (idpresupuesto, numpresupuesto, refpresupuesto, fpresupuesto, descpresupuesto, contactpresupuesto, telpresupuesto, vencpresupuesto, comentpresupuesto, idusuari, procesadopresupuesto, idcliente, idalmacen, idforma_pago, idtrabajador, totalpresupuesto, bimppresupuesto, imppresupuesto) FROM stdin;
236	13	ICGHWR	2007-02-22	POLLENSA	Asociacion Iglues		2007-02-28	Presupuesto de demostracion	\N	f	16	1	7	2	1409.40	1215.00	194.40
280	46	HBENKZ	2007-05-18	CAMBIOS WEB	Asociacion Iglues		2007-05-25	Presupuesto de demostracion	\N	f	98	1	6	1	98.66	85.05	13.61
239	16	HOLFYC	2007-03-06	MATERIAL	Asociacion Iglues		2007-03-13	Presupuesto de demostracion	\N	f	101	1	1	2	602.46	519.36	83.09
240	17	XGOQWP	2007-03-06	SON COCO	Asociacion Iglues		2007-03-13	Presupuesto de demostracion	\N	t	10	1	6	6	1697.37	1463.25	234.12
242	19	NDJDZN	2007-03-08	DISTRIBUDORA ROTGER	Asociacion Iglues		2007-03-08	Presupuesto de demostracion	\N	t	16	1	6	2	6201.36	5346.00	855.36
243	20	WEQSZA	2007-01-29	ABBACINO	Asociacion Iglues		2007-03-08	Presupuesto de demostracion	\N	t	16	1	7	2	98.66	85.05	13.61
244	21	PDGFJ[	2007-03-08	GALLETAS	Asociacion Iglues		2007-03-08	Presupuesto de demostracion	\N	t	16	1	7	2	5073.84	4374.00	699.84
235	12	X[RUUZ	2007-02-21	Fundacion Llabres Feliu	Asociacion Iglues		2007-02-21	Presupuesto de demostracion	\N	t	16	1	7	2	6906.06	5953.50	952.56
246	22	QENLSH	2007-03-09	IMPRESORAS	Asociacion Iglues		2007-03-16	Presupuesto de demostracion	\N	t	59	1	1	1	3540.41	3052.08	488.35
253	27	RTLTJO	2007-03-26	PORTATIL	Asociacion Iglues		2007-04-02	Presupuesto de demostracion	\N	t	54	1	7	2	2367.79	2041.20	326.59
252	26	OYLNBR	2007-03-26	CABLES TONI	Asociacion Iglues		2007-04-02	Presupuesto de demostracion	\N	t	108	1	7	1	1175.54	1013.40	162.14
226	4	RHHDZS	2007-01-18	OKI MULTF.	Asociacion Iglues		2007-01-25	Presupuesto de demostracion	\N	t	91	1	1	1	6029.41	5197.77	831.64
250	25	ZPYLFF	2007-03-20	ORDENADOR  CHICO NUEVO	Asociacion Iglues		2007-03-20	Presupuesto de demostracion	\N	t	10	1	1	6	1339.64	1154.86	184.78
238	15	XIFGVQ	2007-03-06	AVG	Asociacion Iglues		2007-03-13	Presupuesto de demostracion	\N	t	103	1	1	6	315.43	271.92	43.51
254	28	RXACNC	2007-03-26	AVG	Asociacion Iglues		2007-04-02	Presupuesto de demostracion	\N	t	103	1	2	6	340.52	293.55	46.97
247	23	QENLSH	2007-03-12	CONSUMIBLES IMPRESORAS	Asociacion Iglues		2007-03-19	Presupuesto de demostracion	\N	t	59	1	1	1	1284.33	1107.18	177.15
256	30	UZUFIM	2007-04-11	ROUTER/GATEWAY ELECTROSAT	Asociacion Iglues		2007-04-30	Presupuesto de demostracion	\N	f	123	1	1	6	242.73	209.25	33.48
257	31	HZXILT	2007-04-17	FUNDACION LLABRES FELIU	Asociacion Iglues		2007-04-24	Presupuesto de demostracion	\N	t	127	1	1	1	217.05	187.11	29.93
255	29	IVSGDN	2007-03-28	CABLES	Asociacion Iglues		2007-04-04	Presupuesto de demostracion	\N	t	124	1	1	6	666.14	574.26	91.88
237	14	VEARHB	2007-02-26	Forteza Carbonell Associats	Asociacion Iglues		2007-03-26	Presupuesto de demostracion	\N	f	16	1	7	2	3672.90	3166.29	506.60
248	24	RJSVVJ	2007-03-12	SENCART	Asociacion Iglues		2007-04-12	Presupuesto de demostracion	\N	f	101	1	1	2	493.29	425.25	68.03
266	33	KIOYPZ	2007-04-25	HOST	Asociacion Iglues		2007-04-25	Presupuesto de demostracion	\N	t	44	1	1	1	1014.77	874.80	139.97
264	32	NSTJHX	2007-04-24	BulmaGés	Asociacion Iglues		2007-05-01	Presupuesto de demostracion	\N	t	135	1	1	2	521.48	449.55	71.93
241	18	LFNKOG	2007-03-06	PQL SA TAFONA	Asociacion Iglues		2007-03-13	Presupuesto de demostracion	\N	f	10	1	1	6	629.04	542.28	86.76
231	8	BHMMAZ	2007-02-20	ORDENADOR 1	Asociacion Iglues		2007-02-27	Presupuesto de demostracion	\N	t	10	1	1	6	1278.67	1102.30	176.37
232	9	BWRKUG	2007-02-20	ORDENADOR 2	Asociacion Iglues		2007-02-27	Presupuesto de demostracion	\N	t	10	1	6	6	1278.67	1102.30	176.37
279	45	XQCZEE	2007-05-16	Instalacion red inhalambrica.	Asociacion Iglues		\N	Presupuesto de demostracion	\N	f	138	1	1	2	4317.24	3721.76	595.48
230	7	IJWDYW	2007-02-15	IMPRESORAS MFC	Asociacion Iglues		2007-02-22	Presupuesto de demostracion	\N	t	26	1	1	6	7578.94	6533.57	1045.37
269	35	ULRSCG	2007-05-03	SERVIDOR	Asociacion Iglues		2007-05-10	Presupuesto de demostracion	\N	f	9	1	1	6	7320.48	6310.76	1009.72
270	36	HJKUMY	2007-02-21	Fundacion Llabres Feliu	Asociacion Iglues		2007-02-21	Presupuesto de demostracion	\N	f	16	1	7	2	6906.06	5953.50	952.56
272	38	NDJDZN	2007-03-08	DISTRIBUDORA ROTGER	Asociacion Iglues		2007-03-08	Presupuesto de demostracion	\N	f	16	1	7	2	6.21	5.35	0.86
271	37	[OBPRU	2007-05-04	ABBACINO	Asociacion Iglues		2007-05-11	Presupuesto de demostracion	\N	f	128	1	2	2	704.70	607.50	97.20
274	40	VLVVBH	2007-05-07	MANTENIMIENTO	Asociacion Iglues		2007-05-14	Presupuesto de demostracion	\N	t	19	1	2	1	1409.40	1215.00	194.40
275	41	JMXSMP	2007-05-07	Hosting Disglobal Games	Asociacion Iglues		2007-06-01	Presupuesto de demostracion	\N	f	126	1	1	2	146.58	126.36	20.21
277	43	LRMBBX	2007-05-08	ACCESORIOS	Asociacion Iglues		2007-05-08	Presupuesto de demostracion	\N	t	23	1	1	1	212.83	183.47	29.35
224	3	YYKJWR	2007-01-10	REFORMAS WEB	Asociacion Iglues		2007-01-17	Presupuesto de demostracion	\N	t	57	1	6	2	4087.26	3523.50	563.76
228	6	VVSOHG	2007-02-06	CABLES DE SEGURIDAD	Asociacion Iglues		2007-02-20	Presupuesto de demostracion	\N	t	108	1	7	6	195.34	168.40	26.94
227	5	FNAUXJ	2007-01-29	MANT	Asociacion Iglues		2007-02-05	Presupuesto de demostracion	\N	f	114	1	1	2	2057.72	1773.90	283.81
276	42	YRHKKJ	2007-05-08	Web www.gib-mallorca.com	Asociacion Iglues		2007-06-30	Presupuesto de demostracion	\N	f	103	1	4	2	5919.48	5103.00	816.48
287	52	GGRAVM	2007-07-12	\N	Asociacion Iglues		\N	Presupuesto de demostracion	\N	f	139	1	1	6	56.38	48.60	7.78
282	47	ICIIDN	2007-05-25	Sevidor VPN y 1 Cliente VPN	Asociacion Iglues		2007-06-08	Presupuesto de demostracion	\N	f	16	1	1	6	507.38	437.40	69.98
233	10	[MJXDT	2007-02-20	TFT + SOFT 1	Asociacion Iglues		2007-02-27	Presupuesto de demostracion	\N	t	10	1	6	6	1651.54	1423.74	227.81
234	11	WKNSLS	2007-02-20	TFT + SOTF 2	Asociacion Iglues		2007-02-27	Presupuesto de demostracion	\N	t	10	1	6	6	929.10	800.95	128.16
267	34	INLXZA	2007-04-26	HOST	Asociacion Iglues		2007-05-31	Presupuesto de demostracion	\N	t	132	1	1	1	1014.77	874.80	139.97
288	53	OBHTNZ	2007-07-12	\N	Asociacion Iglues		\N	Presupuesto de demostracion	\N	f	137	1	1	\N	56.38	48.60	7.78
278	44	FBMTJK	2007-05-09	HOSTING solitario	Asociacion Iglues		2007-05-09	Presupuesto de demostracion	\N	f	103	1	2	6	1014.77	874.80	139.97
223	2	VBDXNN	2007-01-10	IMPRESORA	Asociacion Iglues		2007-01-17	Presupuesto de demostracion	\N	t	23	1	1	2	2184.57	1883.25	301.32
289	54	QEEHKU	2007-08-29	asdf asdf asdf	Asociacion Iglues		2007-08-29	Presupuesto de demostracion	\N	f	103	1	2	8	563.76	486.00	77.76
290	55	IPEJPL	2007-09-15	asdfas	Asociacion Iglues		2007-09-20	Presupuesto de demostracion	\N	t	137	1	2	6	304.63	262.61	42.02
222	1	TVUVLN	2007-01-09	CONTAPLUS	Asociacion Iglues		2007-01-16	Presupuesto de demostracion	\N	t	8	1	1	2	380.52	328.03	52.49
\.


--
-- Data for Name: proveedor; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY proveedor (idproveedor, nomproveedor, nomaltproveedor, cifproveedor, codicliproveedor, comentproveedor, poblproveedor, cpproveedor, emailproveedor, urlproveedor, clavewebproveedor, inactivoproveedor, telproveedor, faxproveedor, dirproveedor, codproveedor, recargoeqproveedor, idforma_pago, regimenfiscalproveedor, irpfproveedor, cbancproveedor, idprovincia, idcuentaproveedor) FROM stdin;
2	Cristina	\N	2	\N		\N	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10909
1	Tomeu	\N	1	\N		\N	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10910
3	Marco Aurelio	\N	3	\N		\N	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10911
19	E.M.A.Y.A	E.M.A.Y.A	19	\N		\N	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10913
5	Procesos Comerciales Insulares,S.L	P.C.I. Baleares	5	43003527		Palma de Mallorca	07004	info@iglues.org	www.pci-baleares.com	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10912
11	Memory Set S.A.U	Memory	11	78377		Plaza (Plataforma Logistica Zaragoza)	07004	info@iglues.org	www.memoryset.com	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10914
12	Intplus,S.L	Intplus	12			Mairena Del Aljarafe 	07004	info@iglues.org	www.superinventos.com	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10915
13	Leroy Merlin S.A.	Leroy Merlin	13			Marratxi Palma	07004	info@iglues.org		\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10916
14	Distribuidora Rotger S.A.	Distribuidora Rotger S.A.	14	2.220		Poligono Son Castello ,Palma	07004	info@iglues.org		\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10917
36	GoDaddy	GoDaddy	36	2901118		\N	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	f	1	Extracomunitario	\N	                                                                                                                        	\N	10919
15	Infortisa S.L.	Infortisa	15			Alfara del Patriarca	07004	info@iglues.org	www.infortisa.com	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10920
10	Compañia Internacional de Ordenadores y Componentes Electronicos S.A.	CIOCE	10	0221273		Cornella de Llobregat	07004	info@iglues.org	www.cioce.es	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10921
20	G.E.S.A.	G.E.S.A.	20	\N		Barcelona	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10922
29	IBERIA	IBERIA	29	\N		\N	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	f	\N	Normal	0.00	                                                                                                                        	5	10932
17	ONO	CABLEUROPA, S.A.U.	17	\N		Madrid	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10923
16	GRISOFT LIMITED	GRISOFT LIMITED - AVG	16			Nicosia - Chipre	07004	info@iglues.org		\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10924
23	MATEU BORRAS HOMAR	MATEU BORRAS HOMAR	23	\N		Alaro / Baleares	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10925
21	Sistemas Técnicos y Consulta, S.L.	STC	21	2821		Palma de Mallorca	07004	info@iglues.org	www.sistemasyrepro.com	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10926
24	DAVID NAVARRO JIMENO	DAVID NAVARRO JIMENO	24	\N		PALMA DE MALLORCA	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10927
25	OFICENTER (ILLY)	OFICENTER (ILLY)	25	\N		PALMA DE MALLORCA	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10928
28	SARUTEK	SARUTEK	28	\N		Chiyoda-ku Tokio - 101-0021	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10929
30	ALCAMPO SA	ALCAMPO	30	\N		MADRID	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	\N	\N	Normal	0.00	                                                                                                                        	\N	10930
37	Daniel Company Oliver	\N	37	\N		Palma de Mallorca	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	f	\N	Normal	15.00	                                                                                                                        	\N	10933
8	Panda Software Spain,S.L.U	Panda Software	8	\N		Bilbao	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	f	\N	Normal	0.00	                                                                                                                        	1	10934
7	Repro Copy Shop,S.L.	Reprocopy	7	2821		Palma de Mallorca	07004	info@iglues.org	\N	\N	\N	971 29 06 29		Joaquin Turina, 1 Local 4	\N	f	6	Normal	0.00	                                                                                                                        	1	10935
4	Torrijas Tordesillas	\N	4	\N	\N	\N	07004	info@iglues.org	\N	\N	\N	971 29 06 29	\N	Joaquin Turina, 1 Local 4	\N	f	\N	Normal	0.00	                                                                                                                        	1	10918
33	Redoble 74, SL	Redoble	33	\N	\N	Palma de Mallorca	07004	info@iglues.org	www.redoble.net	\N	\N	971 29 06 29	\N	Joaquin Turina, 1 Local 4	\N	f	1	Normal	\N	                                                                                                                        	\N	10931
\.


--
-- Data for Name: provincia; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY provincia (idprovincia, idpais, provincia) FROM stdin;
3	2	Paris
6	1	Bilbao
5	1	Barcelona
1	1	Baleares
8	1	Murcia
4	3	Lisboa
9	3	Gabón asd
10	3	Bagul
7	4	Miprov
\.


--
-- Data for Name: q19; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY q19 (idq19, fechaq19, nomq19) FROM stdin;
2	2007-11-02	Nueva Transacción
\.


--
-- Data for Name: rutacomercial; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY rutacomercial (idrutacomercial, fecharutacomercial, idcliente, comentariosrutacomercial, horarutacomercial, refrutacomercial) FROM stdin;
\.


--
-- Data for Name: serie_factura; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY serie_factura (codigoserie_factura, descserie_factura) FROM stdin;
DD	Serie de ejemplo
REC	Facturas Rectificativas
\.


--
-- Data for Name: stock_almacen; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY stock_almacen (idarticulo, idalmacen, stock) FROM stdin;
2814	1	0.00
2815	1	0.00
2816	1	0.00
2817	1	0.00
2818	1	0.00
2819	1	0.00
2820	1	0.00
2821	1	0.00
2822	1	0.00
2823	1	0.00
2824	1	0.00
2825	1	0.00
2826	1	0.00
2827	1	0.00
2828	1	0.00
2829	1	0.00
2830	1	0.00
2831	1	0.00
2832	1	0.00
2833	1	0.00
2834	1	0.00
2835	1	0.00
2837	1	0.00
2838	1	0.00
2839	1	0.00
2840	1	0.00
2844	1	0.00
2845	1	0.00
2846	1	0.00
2847	1	0.00
2848	1	0.00
2849	1	0.00
2851	1	0.00
2853	1	0.00
2854	1	0.00
2855	1	0.00
2856	1	0.00
2857	1	0.00
2858	1	0.00
2859	1	0.00
2860	1	0.00
2861	1	0.00
2862	1	0.00
2863	1	0.00
2864	1	0.00
2865	1	0.00
2866	1	0.00
2867	1	0.00
2868	1	0.00
2869	1	0.00
2870	1	0.00
2871	1	0.00
2872	1	0.00
2873	1	0.00
2874	1	0.00
2875	1	0.00
2876	1	0.00
2877	1	0.00
2878	1	0.00
2879	1	0.00
2881	1	0.00
2882	1	0.00
2883	1	0.00
2884	1	0.00
2885	1	0.00
2886	1	0.00
2887	1	0.00
2888	1	0.00
2891	1	0.00
2893	1	0.00
2894	1	0.00
2895	1	0.00
2897	1	0.00
2898	1	0.00
2899	1	0.00
2900	1	0.00
2901	1	0.00
2902	1	0.00
2904	1	0.00
2906	1	0.00
2907	1	0.00
2908	1	0.00
2909	1	0.00
2910	1	0.00
2911	1	0.00
2912	1	0.00
2913	1	0.00
2914	1	0.00
2915	1	0.00
2916	1	0.00
2917	1	0.00
2918	1	0.00
2919	1	0.00
2920	1	0.00
2921	1	0.00
2922	1	0.00
2923	1	0.00
2924	1	0.00
2925	1	0.00
2926	1	0.00
2927	1	0.00
2928	1	0.00
2929	1	0.00
2930	1	0.00
2931	1	0.00
2932	1	0.00
2933	1	0.00
2934	1	0.00
2935	1	0.00
2936	1	0.00
2937	1	0.00
2938	1	0.00
2939	1	0.00
2940	1	0.00
2941	1	0.00
2942	1	0.00
2943	1	0.00
2944	1	0.00
2945	1	0.00
2946	1	0.00
2947	1	0.00
2948	1	0.00
2949	1	0.00
2950	1	0.00
2951	1	0.00
2952	1	0.00
2953	1	0.00
2954	1	0.00
2955	1	0.00
2956	1	0.00
2957	1	0.00
2958	1	0.00
2959	1	0.00
2960	1	0.00
2962	1	0.00
2963	1	0.00
2964	1	0.00
2965	1	0.00
2966	1	0.00
2967	1	0.00
2968	1	0.00
2969	1	0.00
2970	1	0.00
2971	1	0.00
2972	1	0.00
2973	1	0.00
2974	1	0.00
2975	1	0.00
2976	1	0.00
2977	1	0.00
2978	1	0.00
2979	1	0.00
2980	1	0.00
2981	1	0.00
2982	1	0.00
2983	1	0.00
2984	1	0.00
2985	1	0.00
2986	1	0.00
2987	1	0.00
2988	1	0.00
2989	1	0.00
2990	1	0.00
2991	1	0.00
2992	1	0.00
2993	1	0.00
2994	1	0.00
2995	1	0.00
2996	1	0.00
2997	1	0.00
2998	1	0.00
2999	1	0.00
3000	1	0.00
3002	1	0.00
3004	1	0.00
3005	1	0.00
3006	1	0.00
3007	1	0.00
3008	1	0.00
3009	1	0.00
3010	1	0.00
3011	1	0.00
3013	1	0.00
3014	1	0.00
3015	1	0.00
3016	1	0.00
3017	1	0.00
3018	1	0.00
3019	1	0.00
3020	1	0.00
3021	1	0.00
3022	1	0.00
3023	1	0.00
3024	1	0.00
3025	1	0.00
3026	1	0.00
3027	1	0.00
3028	1	0.00
3029	1	0.00
3030	1	0.00
3031	1	0.00
3032	1	0.00
3033	1	0.00
3034	1	0.00
3035	1	0.00
3036	1	0.00
3037	1	0.00
3038	1	0.00
3039	1	0.00
3040	1	0.00
3041	1	0.00
3042	1	0.00
3043	1	0.00
3044	1	0.00
3045	1	0.00
3046	1	0.00
3047	1	0.00
3048	1	0.00
3049	1	0.00
3050	1	0.00
3051	1	0.00
3052	1	0.00
3053	1	0.00
3054	1	0.00
3055	1	0.00
3056	1	0.00
3057	1	0.00
3058	1	0.00
3059	1	0.00
3060	1	0.00
3061	1	0.00
3062	1	0.00
3063	1	0.00
3064	1	0.00
3065	1	0.00
3066	1	0.00
3069	1	0.00
3070	1	0.00
3071	1	0.00
3072	1	0.00
3073	1	0.00
3074	1	0.00
3075	1	0.00
3076	1	0.00
3077	1	0.00
3078	1	0.00
3079	1	0.00
3080	1	0.00
3081	1	0.00
3082	1	0.00
3083	1	0.00
3084	1	0.00
3085	1	0.00
3086	1	0.00
3087	1	0.00
3088	1	0.00
3089	1	0.00
3090	1	0.00
3091	1	0.00
3092	1	0.00
3093	1	0.00
3094	1	0.00
3095	1	0.00
3096	1	0.00
3097	1	0.00
3098	1	0.00
3099	1	0.00
3100	1	0.00
3101	1	0.00
3102	1	0.00
3103	1	0.00
3104	1	0.00
3105	1	0.00
3106	1	0.00
3107	1	0.00
3108	1	0.00
3109	1	0.00
3110	1	0.00
3111	1	0.00
3112	1	0.00
3113	1	0.00
3114	1	0.00
3115	1	0.00
3116	1	0.00
3117	1	0.00
3118	1	0.00
3119	1	0.00
3120	1	0.00
3121	1	0.00
3122	1	0.00
3123	1	0.00
3124	1	0.00
3125	1	0.00
3126	1	0.00
3127	1	0.00
3128	1	0.00
3129	1	0.00
3130	1	0.00
3131	1	0.00
3132	1	0.00
3133	1	0.00
3134	1	0.00
3135	1	0.00
3136	1	0.00
3137	1	0.00
3138	1	0.00
3140	1	0.00
3141	1	0.00
3142	1	0.00
3143	1	0.00
3145	1	0.00
3146	1	0.00
3147	1	0.00
3148	1	0.00
3149	1	0.00
3150	1	0.00
3151	1	0.00
3152	1	0.00
3153	1	0.00
3154	1	0.00
3155	1	0.00
3156	1	0.00
3157	1	0.00
3158	1	0.00
3160	1	0.00
3161	1	0.00
3162	1	0.00
3163	1	0.00
3164	1	0.00
3165	1	0.00
3166	1	0.00
3167	1	0.00
3168	1	0.00
3169	1	0.00
3170	1	0.00
3171	1	0.00
3172	1	0.00
3173	1	0.00
3174	1	0.00
3175	1	0.00
3176	1	0.00
3177	1	0.00
3178	1	0.00
3179	1	0.00
3180	1	0.00
3181	1	0.00
3182	1	0.00
3183	1	0.00
3184	1	0.00
3185	1	0.00
3186	1	0.00
3187	1	0.00
3188	1	0.00
3189	1	0.00
3190	1	0.00
3191	1	0.00
3192	1	0.00
3193	1	0.00
3194	1	0.00
3195	1	0.00
3196	1	0.00
3197	1	0.00
3198	1	0.00
3199	1	0.00
3200	1	0.00
3201	1	0.00
3202	1	0.00
3203	1	0.00
3204	1	0.00
3205	1	0.00
3206	1	0.00
3207	1	0.00
3208	1	0.00
3209	1	0.00
3210	1	0.00
3211	1	0.00
3212	1	0.00
3213	1	0.00
3214	1	0.00
3215	1	0.00
3216	1	0.00
3219	1	0.00
3220	1	0.00
3221	1	0.00
3222	1	0.00
3223	1	0.00
3225	1	0.00
3226	1	0.00
3228	1	0.00
3229	1	0.00
3230	1	0.00
3231	1	0.00
3232	1	0.00
3233	1	0.00
3234	1	0.00
3235	1	0.00
3236	1	0.00
3237	1	0.00
3238	1	0.00
3240	1	0.00
3241	1	0.00
3242	1	0.00
3243	1	0.00
3244	1	0.00
3245	1	0.00
3246	1	0.00
3247	1	0.00
3248	1	0.00
3249	1	0.00
3250	1	0.00
3251	1	0.00
3253	1	0.00
3255	1	0.00
3257	1	0.00
3259	1	0.00
3260	1	0.00
3262	1	0.00
3263	1	0.00
3264	1	0.00
3265	1	0.00
3266	1	0.00
3267	1	0.00
3268	1	0.00
3269	1	0.00
3270	1	0.00
3271	1	0.00
3272	1	0.00
3273	1	0.00
3274	1	0.00
3275	1	0.00
3276	1	0.00
3277	1	0.00
3278	1	0.00
3279	1	0.00
3280	1	0.00
3281	1	0.00
3282	1	0.00
3283	1	0.00
3284	1	0.00
3285	1	0.00
3286	1	0.00
3287	1	0.00
3288	1	0.00
3289	1	0.00
3290	1	0.00
3291	1	0.00
3292	1	0.00
3293	1	0.00
3295	1	0.00
3296	1	0.00
3297	1	0.00
3298	1	0.00
3299	1	0.00
3300	1	0.00
3301	1	0.00
3302	1	0.00
3303	1	0.00
3304	1	0.00
3305	1	0.00
3306	1	0.00
3307	1	0.00
3308	1	0.00
3309	1	0.00
3310	1	0.00
3311	1	0.00
3312	1	0.00
3313	1	0.00
3314	1	0.00
3315	1	0.00
3316	1	0.00
3317	1	0.00
3318	1	0.00
3319	1	0.00
3320	1	0.00
3321	1	0.00
3322	1	0.00
3323	1	0.00
3324	1	0.00
3325	1	0.00
3326	1	0.00
3327	1	0.00
3329	1	0.00
3330	1	0.00
3331	1	0.00
3332	1	0.00
3333	1	0.00
3334	1	0.00
3335	1	0.00
3336	1	0.00
3337	1	0.00
3338	1	0.00
3340	1	0.00
3341	1	0.00
3342	1	0.00
3343	1	0.00
3344	1	0.00
3345	1	0.00
3346	1	0.00
3348	1	0.00
3349	1	0.00
3350	1	0.00
3351	1	0.00
3352	1	0.00
3353	1	0.00
3354	1	0.00
3355	1	0.00
3356	1	0.00
3357	1	0.00
3358	1	0.00
3359	1	0.00
3360	1	0.00
3361	1	0.00
3362	1	0.00
3363	1	0.00
3365	1	0.00
3366	1	0.00
3367	1	0.00
3368	1	0.00
3369	1	0.00
3370	1	0.00
3371	1	0.00
3372	1	0.00
3373	1	0.00
3374	1	0.00
3375	1	0.00
3376	1	0.00
3377	1	0.00
3378	1	0.00
3379	1	0.00
3380	1	0.00
3381	1	0.00
3382	1	0.00
3383	1	0.00
3384	1	0.00
3385	1	0.00
3386	1	0.00
3387	1	0.00
3388	1	0.00
3389	1	0.00
3390	1	0.00
3391	1	0.00
3392	1	0.00
3393	1	0.00
3394	1	0.00
3395	1	0.00
3397	1	0.00
3398	1	0.00
3399	1	0.00
3400	1	0.00
3401	1	0.00
3402	1	0.00
3403	1	0.00
3404	1	0.00
3405	1	0.00
3406	1	0.00
3407	1	0.00
3408	1	0.00
3409	1	0.00
3410	1	0.00
3411	1	0.00
3412	1	0.00
3413	1	0.00
3414	1	0.00
3415	1	0.00
3416	1	0.00
3417	1	0.00
3418	1	0.00
3419	1	0.00
3420	1	0.00
3421	1	0.00
3422	1	0.00
3424	1	0.00
3425	1	0.00
3426	1	0.00
3427	1	0.00
3428	1	0.00
3429	1	0.00
3430	1	0.00
3432	1	0.00
3433	1	0.00
3434	1	0.00
3435	1	0.00
3436	1	0.00
3437	1	0.00
3440	1	0.00
3441	1	0.00
3442	1	0.00
3443	1	0.00
3444	1	0.00
3445	1	0.00
3446	1	0.00
3447	1	0.00
3448	1	0.00
3452	1	0.00
3453	1	0.00
3454	1	0.00
3455	1	0.00
3457	1	0.00
3458	1	0.00
3459	1	0.00
3460	1	0.00
3461	1	0.00
3462	1	0.00
3463	1	0.00
3464	1	0.00
3465	1	0.00
3466	1	0.00
3467	1	0.00
3468	1	0.00
3469	1	0.00
3471	1	0.00
3472	1	0.00
3473	1	0.00
3474	1	0.00
3475	1	0.00
3476	1	0.00
3478	1	0.00
3479	1	0.00
3480	1	0.00
3481	1	0.00
3482	1	0.00
3483	1	0.00
3484	1	0.00
3485	1	0.00
3486	1	0.00
3487	1	0.00
3488	1	0.00
3489	1	0.00
3490	1	0.00
3491	1	0.00
3492	1	0.00
3493	1	0.00
3494	1	0.00
3495	1	0.00
3496	1	0.00
3497	1	0.00
3498	1	0.00
3499	1	0.00
3500	1	0.00
3501	1	0.00
3502	1	0.00
3503	1	0.00
3504	1	0.00
3505	1	0.00
3506	1	0.00
3507	1	0.00
3508	1	0.00
3509	1	0.00
3510	1	0.00
3511	1	0.00
3512	1	0.00
3513	1	0.00
3514	1	0.00
3515	1	0.00
3516	1	0.00
3517	1	0.00
3518	1	0.00
3519	1	0.00
3521	1	0.00
3522	1	0.00
3523	1	0.00
3524	1	0.00
3525	1	0.00
3526	1	0.00
3527	1	0.00
3528	1	0.00
3529	1	0.00
3530	1	0.00
3531	1	0.00
3532	1	0.00
3533	1	0.00
3534	1	0.00
3536	1	0.00
3537	1	0.00
3538	1	0.00
3539	1	0.00
3540	1	0.00
3541	1	0.00
3542	1	0.00
3543	1	0.00
3544	1	0.00
3545	1	0.00
3546	1	0.00
3547	1	0.00
3548	1	0.00
3549	1	0.00
3550	1	0.00
3551	1	0.00
3552	1	0.00
3553	1	0.00
3554	1	0.00
3555	1	0.00
3556	1	0.00
3557	1	0.00
3558	1	0.00
3559	1	0.00
3560	1	0.00
3561	1	0.00
3562	1	0.00
3563	1	0.00
3564	1	0.00
3565	1	0.00
3566	1	0.00
3567	1	0.00
3568	1	0.00
3569	1	0.00
3570	1	0.00
3571	1	0.00
3572	1	0.00
3573	1	0.00
3574	1	0.00
3575	1	0.00
3576	1	0.00
3577	1	0.00
3578	1	0.00
3579	1	0.00
3581	1	0.00
3582	1	0.00
3583	1	0.00
3584	1	0.00
3585	1	0.00
3587	1	0.00
3588	1	0.00
3589	1	0.00
3590	1	0.00
3591	1	0.00
3592	1	0.00
3593	1	0.00
3594	1	0.00
3595	1	0.00
3596	1	0.00
3597	1	0.00
3598	1	0.00
3599	1	0.00
3600	1	0.00
3601	1	0.00
3602	1	0.00
3603	1	0.00
3604	1	0.00
3605	1	0.00
3606	1	0.00
3607	1	0.00
3608	1	0.00
3609	1	0.00
3610	1	0.00
3611	1	0.00
3612	1	0.00
3613	1	0.00
3614	1	0.00
3615	1	0.00
3616	1	0.00
3617	1	0.00
3618	1	0.00
3619	1	0.00
3620	1	0.00
3621	1	0.00
3622	1	0.00
3623	1	0.00
3624	1	0.00
3625	1	0.00
3626	1	0.00
3627	1	0.00
3628	1	0.00
3629	1	0.00
3630	1	0.00
3631	1	0.00
3632	1	0.00
3633	1	0.00
3634	1	0.00
3635	1	0.00
3636	1	0.00
3637	1	0.00
3638	1	0.00
3639	1	0.00
3641	1	0.00
3642	1	0.00
3643	1	0.00
3644	1	0.00
3645	1	0.00
3646	1	0.00
3647	1	0.00
3648	1	0.00
3649	1	0.00
3650	1	0.00
3651	1	0.00
3652	1	0.00
3653	1	0.00
3654	1	0.00
3655	1	0.00
3656	1	0.00
3657	1	0.00
3658	1	0.00
3659	1	0.00
3660	1	0.00
3661	1	0.00
3662	1	0.00
3663	1	0.00
3665	1	0.00
3666	1	0.00
3667	1	0.00
3668	1	0.00
3669	1	0.00
3670	1	0.00
3671	1	0.00
3672	1	0.00
3673	1	0.00
3674	1	0.00
3675	1	0.00
3676	1	0.00
3677	1	0.00
3678	1	0.00
3679	1	0.00
3680	1	0.00
3681	1	0.00
3682	1	0.00
3683	1	0.00
3684	1	0.00
3685	1	0.00
3686	1	0.00
3687	1	0.00
3688	1	0.00
3689	1	0.00
3690	1	0.00
3691	1	0.00
3692	1	0.00
3693	1	0.00
3694	1	0.00
3695	1	0.00
3696	1	0.00
3697	1	0.00
3698	1	0.00
3699	1	0.00
3700	1	0.00
3701	1	0.00
3702	1	0.00
3703	1	0.00
3704	1	0.00
3705	1	0.00
3706	1	0.00
3707	1	0.00
3708	1	0.00
3709	1	0.00
3711	1	0.00
3712	1	0.00
3713	1	0.00
3714	1	0.00
3715	1	0.00
3716	1	0.00
3717	1	0.00
3718	1	0.00
3719	1	0.00
3720	1	0.00
3721	1	0.00
3722	1	0.00
3723	1	0.00
3724	1	0.00
3725	1	0.00
3726	1	0.00
3727	1	0.00
3728	1	0.00
3729	1	0.00
3730	1	0.00
3731	1	0.00
3732	1	0.00
3733	1	0.00
3734	1	0.00
3735	1	0.00
3736	1	0.00
3737	1	0.00
3738	1	0.00
3739	1	0.00
3740	1	0.00
3741	1	0.00
3742	1	0.00
3743	1	0.00
3744	1	0.00
3745	1	0.00
3746	1	0.00
3747	1	0.00
3748	1	0.00
3749	1	0.00
3750	1	0.00
3751	1	0.00
3752	1	0.00
3753	1	0.00
3755	1	0.00
3756	1	0.00
3757	1	0.00
3758	1	0.00
3759	1	0.00
3760	1	0.00
3761	1	0.00
3762	1	0.00
3763	1	0.00
3764	1	0.00
3765	1	0.00
3766	1	0.00
3767	1	0.00
3768	1	0.00
3769	1	0.00
3770	1	0.00
3771	1	0.00
3772	1	0.00
3773	1	0.00
3774	1	0.00
3775	1	0.00
3776	1	0.00
3777	1	0.00
3778	1	0.00
3779	1	0.00
3781	1	0.00
3782	1	0.00
3784	1	0.00
3785	1	0.00
3786	1	0.00
3787	1	0.00
3788	1	0.00
3789	1	0.00
3790	1	0.00
3791	1	0.00
3792	1	0.00
3793	1	0.00
3794	1	0.00
3795	1	0.00
3796	1	0.00
3797	1	0.00
3798	1	0.00
3799	1	0.00
3800	1	0.00
3801	1	0.00
3802	1	0.00
3803	1	0.00
3804	1	0.00
3805	1	0.00
3806	1	0.00
3807	1	0.00
3808	1	0.00
3809	1	0.00
3810	1	0.00
3811	1	0.00
3812	1	0.00
3813	1	0.00
3814	1	0.00
3815	1	0.00
3816	1	0.00
3817	1	0.00
3818	1	0.00
3819	1	0.00
3820	1	0.00
3821	1	0.00
3822	1	0.00
3823	1	0.00
3824	1	0.00
3827	1	0.00
3828	1	0.00
3829	1	0.00
3830	1	0.00
3831	1	0.00
3832	1	0.00
3833	1	0.00
3834	1	0.00
3835	1	0.00
3836	1	0.00
3837	1	0.00
3838	1	0.00
3839	1	0.00
3840	1	0.00
3841	1	0.00
3842	1	0.00
3843	1	0.00
3844	1	0.00
3845	1	0.00
3846	1	0.00
3847	1	0.00
3848	1	0.00
3849	1	0.00
3850	1	0.00
3851	1	0.00
3852	1	0.00
3853	1	0.00
3854	1	0.00
3855	1	0.00
3856	1	0.00
3857	1	0.00
3858	1	0.00
3859	1	0.00
3860	1	0.00
3861	1	0.00
3862	1	0.00
3863	1	0.00
3864	1	0.00
3865	1	0.00
3866	1	0.00
3867	1	0.00
3868	1	0.00
3869	1	0.00
3870	1	0.00
3871	1	0.00
3873	1	0.00
3874	1	0.00
3875	1	0.00
3876	1	0.00
3877	1	0.00
3879	1	0.00
3880	1	0.00
3881	1	0.00
3882	1	0.00
3883	1	0.00
3884	1	0.00
3885	1	0.00
3886	1	0.00
3887	1	0.00
3888	1	0.00
3889	1	0.00
3890	1	0.00
3891	1	0.00
3892	1	0.00
3893	1	0.00
3894	1	0.00
3895	1	0.00
3896	1	0.00
3897	1	0.00
3898	1	0.00
3899	1	0.00
3900	1	0.00
3901	1	0.00
3902	1	0.00
3903	1	0.00
3904	1	0.00
3905	1	0.00
3906	1	0.00
3907	1	0.00
3908	1	0.00
3909	1	0.00
3910	1	0.00
3911	1	0.00
3912	1	0.00
3913	1	0.00
3914	1	0.00
3915	1	0.00
3916	1	0.00
3917	1	0.00
3918	1	0.00
3919	1	0.00
3920	1	0.00
3921	1	0.00
3922	1	0.00
3923	1	0.00
3924	1	0.00
3925	1	0.00
3926	1	0.00
3927	1	0.00
3928	1	0.00
3929	1	0.00
3930	1	0.00
3931	1	0.00
3932	1	0.00
3933	1	0.00
3934	1	0.00
3935	1	0.00
3936	1	0.00
3938	1	0.00
3939	1	0.00
3940	1	0.00
3941	1	0.00
3942	1	0.00
3943	1	0.00
3944	1	0.00
3945	1	0.00
3946	1	0.00
3947	1	0.00
3948	1	0.00
3949	1	0.00
3950	1	0.00
3951	1	0.00
3952	1	0.00
3953	1	0.00
3954	1	0.00
3955	1	0.00
3956	1	0.00
3957	1	0.00
3958	1	0.00
3959	1	0.00
3960	1	0.00
3961	1	0.00
3962	1	0.00
3963	1	0.00
3964	1	0.00
3965	1	0.00
3966	1	0.00
3967	1	0.00
3968	1	0.00
3970	1	0.00
3971	1	0.00
3972	1	0.00
3973	1	0.00
3974	1	0.00
3975	1	0.00
3976	1	0.00
3977	1	0.00
3978	1	0.00
3979	1	0.00
3980	1	0.00
3981	1	0.00
3982	1	0.00
3983	1	0.00
3984	1	0.00
3985	1	0.00
3986	1	0.00
3987	1	0.00
3988	1	0.00
3989	1	0.00
3990	1	0.00
3991	1	0.00
3992	1	0.00
3993	1	0.00
3994	1	0.00
3995	1	0.00
3996	1	0.00
3997	1	0.00
3998	1	0.00
3999	1	0.00
4000	1	0.00
4001	1	0.00
4005	1	0.00
4006	1	0.00
4007	1	0.00
4008	1	0.00
4009	1	0.00
4010	1	0.00
4012	1	0.00
4013	1	0.00
4014	1	0.00
4015	1	0.00
4016	1	0.00
4017	1	0.00
4018	1	0.00
4019	1	0.00
4020	1	0.00
4021	1	0.00
4022	1	0.00
4023	1	0.00
4024	1	0.00
4025	1	0.00
4026	1	0.00
4027	1	0.00
4028	1	0.00
4029	1	0.00
4031	1	0.00
4032	1	0.00
4033	1	0.00
4034	1	0.00
4035	1	0.00
4036	1	0.00
4037	1	0.00
4038	1	0.00
4039	1	0.00
4040	1	0.00
4041	1	0.00
4042	1	0.00
4043	1	0.00
4044	1	0.00
4045	1	0.00
4046	1	0.00
4047	1	0.00
4048	1	0.00
4049	1	0.00
4050	1	0.00
4051	1	0.00
4052	1	0.00
4053	1	0.00
4054	1	0.00
4055	1	0.00
4056	1	0.00
4057	1	0.00
4058	1	0.00
4059	1	0.00
4060	1	0.00
4061	1	0.00
4062	1	0.00
4063	1	0.00
4064	1	0.00
4065	1	0.00
4066	1	0.00
4067	1	0.00
4068	1	0.00
4069	1	0.00
4070	1	0.00
4071	1	0.00
4072	1	0.00
4073	1	0.00
4074	1	0.00
4075	1	0.00
4076	1	0.00
4077	1	0.00
4078	1	0.00
4079	1	0.00
4080	1	0.00
4081	1	0.00
4082	1	0.00
4083	1	0.00
4084	1	0.00
4085	1	0.00
4086	1	0.00
4087	1	0.00
4088	1	0.00
4090	1	0.00
4091	1	0.00
4092	1	0.00
4094	1	0.00
4095	1	0.00
4096	1	0.00
4097	1	0.00
4099	1	0.00
4100	1	0.00
4101	1	0.00
4102	1	0.00
4104	1	0.00
4105	1	0.00
4107	1	0.00
4108	1	0.00
4109	1	0.00
4110	1	0.00
4111	1	0.00
4112	1	0.00
4114	1	0.00
4115	1	0.00
4116	1	0.00
4117	1	0.00
4118	1	0.00
4119	1	0.00
4120	1	0.00
4121	1	0.00
4122	1	0.00
4123	1	0.00
4124	1	0.00
4125	1	0.00
4126	1	0.00
4127	1	0.00
4128	1	0.00
4129	1	0.00
4130	1	0.00
4131	1	0.00
4132	1	0.00
4133	1	0.00
4135	1	0.00
4136	1	0.00
4137	1	0.00
4138	1	0.00
4139	1	0.00
4140	1	0.00
4141	1	0.00
4142	1	0.00
4143	1	0.00
4144	1	0.00
4145	1	0.00
4146	1	0.00
4147	1	0.00
4149	1	0.00
4150	1	0.00
4151	1	0.00
4152	1	0.00
4153	1	0.00
4154	1	0.00
4155	1	0.00
4156	1	0.00
4157	1	0.00
4158	1	0.00
4159	1	0.00
4160	1	0.00
4161	1	0.00
4162	1	0.00
4163	1	0.00
4164	1	0.00
4165	1	0.00
4166	1	0.00
4167	1	0.00
4168	1	0.00
4169	1	0.00
4170	1	0.00
4171	1	0.00
4172	1	0.00
4173	1	0.00
4174	1	0.00
4175	1	0.00
4176	1	0.00
4177	1	0.00
4572	1	0.00
4572	2	0.00
2850	1	0.00
4572	4	0.00
4572	5	0.00
4572	6	0.00
4573	2	0.00
4573	4	0.00
4573	5	0.00
4573	6	0.00
4573	1	0.00
4574	2	0.00
4561	1	0.00
4564	1	0.00
4574	4	0.00
4574	5	0.00
4574	6	0.00
4574	1	0.00
4575	2	0.00
4208	1	0.00
4212	1	0.00
4215	1	0.00
4216	1	0.00
4217	1	0.00
4218	1	0.00
4219	1	0.00
4220	1	0.00
4225	1	0.00
4228	1	0.00
4229	1	0.00
4231	1	0.00
4232	1	0.00
4234	1	0.00
4235	1	0.00
4236	1	0.00
4575	4	0.00
4575	5	0.00
4575	6	0.00
4575	1	0.00
4576	2	0.00
4245	1	0.00
4246	1	0.00
4247	1	0.00
4248	1	0.00
4249	1	0.00
4250	1	0.00
4251	1	0.00
4252	1	0.00
4253	1	0.00
4254	1	0.00
4255	1	0.00
4256	1	0.00
4257	1	0.00
4258	1	0.00
4259	1	0.00
4260	1	0.00
4261	1	0.00
4262	1	0.00
4263	1	0.00
4264	1	0.00
4265	1	0.00
4266	1	0.00
4267	1	0.00
4268	1	0.00
4269	1	0.00
4270	1	0.00
4271	1	0.00
4272	1	0.00
4273	1	0.00
4274	1	0.00
4275	1	0.00
4276	1	0.00
4277	1	0.00
4278	1	0.00
4279	1	0.00
4280	1	0.00
4281	1	0.00
4282	1	0.00
4283	1	0.00
4284	1	0.00
4285	1	0.00
4286	1	0.00
4287	1	0.00
4288	1	0.00
4289	1	0.00
4290	1	0.00
4291	1	0.00
4292	1	0.00
4293	1	0.00
4294	1	0.00
4295	1	0.00
4296	1	0.00
4297	1	0.00
4298	1	0.00
4299	1	0.00
4300	1	0.00
4301	1	0.00
4302	1	0.00
4303	1	0.00
4304	1	0.00
4305	1	0.00
4306	1	0.00
4307	1	0.00
4308	1	0.00
4309	1	0.00
4310	1	0.00
4311	1	0.00
4312	1	0.00
4313	1	0.00
4314	1	0.00
4315	1	0.00
4316	1	0.00
4576	4	0.00
4576	5	0.00
4317	1	0.00
4318	1	0.00
4319	1	0.00
4320	1	0.00
4321	1	0.00
4322	1	0.00
4323	1	0.00
4324	1	0.00
4325	1	0.00
4326	1	0.00
4327	1	0.00
4328	1	0.00
4329	1	0.00
4331	1	0.00
4332	1	0.00
4333	1	0.00
4334	1	0.00
4335	1	0.00
4336	1	0.00
4337	1	0.00
4338	1	0.00
4339	1	0.00
4340	1	0.00
4341	1	0.00
4342	1	0.00
4343	1	0.00
4344	1	0.00
4345	1	0.00
4346	1	0.00
4347	1	0.00
4348	1	0.00
4349	1	0.00
4350	1	0.00
4351	1	0.00
4352	1	0.00
4353	1	0.00
4354	1	0.00
4355	1	0.00
4356	1	0.00
4357	1	0.00
4358	1	0.00
4359	1	0.00
4360	1	0.00
4361	1	0.00
4362	1	0.00
4363	1	0.00
4364	1	0.00
4365	1	0.00
4367	1	0.00
4368	1	0.00
4369	1	0.00
4370	1	0.00
4371	1	0.00
4372	1	0.00
4373	1	0.00
4374	1	0.00
4375	1	0.00
4376	1	0.00
4377	1	0.00
4378	1	0.00
4379	1	0.00
4380	1	0.00
4381	1	0.00
4382	1	0.00
4383	1	0.00
4384	1	0.00
4385	1	0.00
4386	1	0.00
4387	1	0.00
4388	1	0.00
4390	1	0.00
4391	1	0.00
4392	1	0.00
4393	1	0.00
4394	1	0.00
4395	1	0.00
4396	1	0.00
4397	1	0.00
4398	1	0.00
4399	1	0.00
4400	1	0.00
4401	1	0.00
4402	1	0.00
4403	1	0.00
4404	1	0.00
4405	1	0.00
4406	1	0.00
4407	1	0.00
4408	1	0.00
4409	1	0.00
4410	1	0.00
4411	1	0.00
4412	1	0.00
4413	1	0.00
4414	1	0.00
4415	1	0.00
4416	1	0.00
4417	1	0.00
4418	1	0.00
4419	1	0.00
4420	1	0.00
4421	1	0.00
4422	1	0.00
4423	1	0.00
4424	1	0.00
4425	1	0.00
4426	1	0.00
4427	1	0.00
4428	1	0.00
4429	1	0.00
4430	1	0.00
4432	1	0.00
4433	1	0.00
4435	1	0.00
4436	1	0.00
4437	1	0.00
4438	1	0.00
4439	1	0.00
4440	1	0.00
4441	1	0.00
4442	1	0.00
4443	1	0.00
4444	1	0.00
4445	1	0.00
4446	1	0.00
4447	1	0.00
4448	1	0.00
4449	1	0.00
4450	1	0.00
4451	1	0.00
4452	1	0.00
4453	1	0.00
4454	1	0.00
4455	1	0.00
4456	1	0.00
4457	1	0.00
4458	1	0.00
4459	1	0.00
4460	1	0.00
4461	1	0.00
4462	1	0.00
4463	1	0.00
4464	1	0.00
4465	1	0.00
4466	1	0.00
4467	1	0.00
4468	1	0.00
4469	1	0.00
4470	1	0.00
4471	1	0.00
4472	1	0.00
4473	1	0.00
4475	1	0.00
4476	1	0.00
4477	1	0.00
4478	1	0.00
4479	1	0.00
4480	1	0.00
4481	1	0.00
4482	1	0.00
4483	1	0.00
4484	1	0.00
4485	1	0.00
4486	1	0.00
4487	1	0.00
4488	1	0.00
4489	1	0.00
4490	1	0.00
4491	1	0.00
4492	1	0.00
4493	1	0.00
4494	1	0.00
4495	1	0.00
4496	1	0.00
4497	1	0.00
4498	1	0.00
4499	1	0.00
4501	1	0.00
4502	1	0.00
4504	1	0.00
4505	1	0.00
4506	1	0.00
4507	1	0.00
4508	1	0.00
4509	1	0.00
4510	1	0.00
4511	1	0.00
4512	1	0.00
4513	1	0.00
4514	1	0.00
4515	1	0.00
4516	1	0.00
4517	1	0.00
4518	1	0.00
4519	1	0.00
4520	1	0.00
4521	1	0.00
4522	1	0.00
4523	1	0.00
4524	1	0.00
4525	1	0.00
4526	1	0.00
4527	1	0.00
4576	6	0.00
4576	1	0.00
4577	2	0.00
4577	4	0.00
4577	5	0.00
4577	6	0.00
4577	1	0.00
4578	2	0.00
4578	4	0.00
4541	1	0.00
4543	1	0.00
4544	1	0.00
4545	1	0.00
4578	5	0.00
4578	6	0.00
4578	1	0.00
4579	2	0.00
4579	4	0.00
4579	5	0.00
4579	6	0.00
4579	1	0.00
4580	2	0.00
4580	4	0.00
4580	5	0.00
4580	6	0.00
4580	1	0.00
4581	2	0.00
4581	4	0.00
4581	5	0.00
4581	6	0.00
4581	1	0.00
4582	2	0.00
4582	4	0.00
4582	5	0.00
4582	6	0.00
4582	1	0.00
4583	2	0.00
4583	4	0.00
4568	1	0.00
4569	1	0.00
4583	5	0.00
4583	6	0.00
4583	1	0.00
4584	2	0.00
4584	4	0.00
4584	5	0.00
4584	6	0.00
4584	1	0.00
4585	2	0.00
4585	4	0.00
4585	5	0.00
4585	6	0.00
4585	1	0.00
4586	2	0.00
4586	4	0.00
4586	5	0.00
4586	6	0.00
4586	1	0.00
4587	2	0.00
4587	4	0.00
4587	5	0.00
4587	6	0.00
4587	1	0.00
4588	2	0.00
4588	4	0.00
4588	5	0.00
4588	6	0.00
4588	1	0.00
4589	2	0.00
4589	4	0.00
4589	5	0.00
4589	6	0.00
4589	1	0.00
4590	2	0.00
4590	4	0.00
4590	5	0.00
4590	6	0.00
4590	1	0.00
4591	2	0.00
4591	4	0.00
4591	5	0.00
4591	6	0.00
4591	1	0.00
4592	2	0.00
4592	4	0.00
4592	5	0.00
4592	6	0.00
4592	1	0.00
4593	2	0.00
4593	4	0.00
4593	5	0.00
4593	6	0.00
4593	1	0.00
4594	2	0.00
4550	2	0.00
4270	2	0.00
2997	2	0.00
3212	2	0.00
3280	2	0.00
3681	2	0.00
4212	2	0.00
2922	2	0.00
2986	2	0.00
2912	2	0.00
4594	4	0.00
4594	5	0.00
4594	6	0.00
4594	1	0.00
4595	2	0.00
4595	4	0.00
4250	2	0.00
3297	2	0.00
4088	2	0.00
3420	2	0.00
4340	2	0.00
4310	2	0.00
4124	2	0.00
4125	2	0.00
3907	2	0.00
3908	2	0.00
3914	2	0.00
3915	2	0.00
3916	2	0.00
3917	2	0.00
4116	2	0.00
4165	2	0.00
4429	2	0.00
3906	2	0.00
2941	2	0.00
3165	2	0.00
3166	2	0.00
3353	2	0.00
3442	2	0.00
3241	2	0.00
2942	2	0.00
4019	2	0.00
2953	2	0.00
3033	2	0.00
3358	2	0.00
3371	2	0.00
3061	2	0.00
3200	2	0.00
3201	2	0.00
3350	2	0.00
3652	2	0.00
4256	2	0.00
3058	2	0.00
3184	2	0.00
3198	2	0.00
3229	2	0.00
3326	2	0.00
3307	2	0.00
4421	2	0.00
2817	2	0.00
3064	2	0.00
2980	2	0.00
2823	2	0.00
3310	2	0.00
2822	2	0.00
2824	2	0.00
2825	2	0.00
2826	2	0.00
2827	2	0.00
2828	2	0.00
2829	2	0.00
2830	2	0.00
2839	2	0.00
2854	2	0.00
2856	2	0.00
2863	2	0.00
2870	2	0.00
2872	2	0.00
2873	2	0.00
2874	2	0.00
2878	2	0.00
2917	2	0.00
2957	2	0.00
4252	2	0.00
3002	2	0.00
3030	2	0.00
3105	2	0.00
3106	2	0.00
3107	2	0.00
3108	2	0.00
3142	2	0.00
3174	2	0.00
3193	2	0.00
3259	2	0.00
3322	2	0.00
3323	2	0.00
4305	2	0.00
4345	2	0.00
3523	2	0.00
3615	2	0.00
3626	2	0.00
2916	2	0.00
2948	2	0.00
3583	2	0.00
3584	2	0.00
3711	2	0.00
3864	2	0.00
3843	2	0.00
3699	2	0.00
4501	2	0.00
3461	2	0.00
3855	2	0.00
2845	2	0.00
2847	2	0.00
2848	2	0.00
2931	2	0.00
2960	2	0.00
2962	2	0.00
2988	2	0.00
2989	2	0.00
2990	2	0.00
3018	2	0.00
3056	2	0.00
3057	2	0.00
3087	2	0.00
3111	2	0.00
3112	2	0.00
3121	2	0.00
3122	2	0.00
3150	2	0.00
3197	2	0.00
3214	2	0.00
3215	2	0.00
3216	2	0.00
3217	2	0.00
3218	2	0.00
3219	2	0.00
3248	2	0.00
3249	2	0.00
4282	2	0.00
3260	2	0.00
3265	2	0.00
3283	2	0.00
3349	2	0.00
4292	2	0.00
3373	2	0.00
4010	2	0.00
3426	2	0.00
3481	2	0.00
3488	2	0.00
3489	2	0.00
4308	2	0.00
3490	2	0.00
3491	2	0.00
3520	2	0.00
3791	2	0.00
4312	2	0.00
3616	2	0.00
3617	2	0.00
4323	2	0.00
3632	2	0.00
4329	2	0.00
2831	2	0.00
3667	2	0.00
3670	2	0.00
2846	2	0.00
3257	2	0.00
3550	2	0.00
3747	2	0.00
3830	2	0.00
3694	2	0.00
3706	2	0.00
4150	2	0.00
4473	2	0.00
4477	2	0.00
3149	2	0.00
3151	2	0.00
3910	2	0.00
2853	2	0.00
3525	2	0.00
3773	2	0.00
3019	2	0.00
2999	2	0.00
3000	2	0.00
3172	2	0.00
3173	2	0.00
2996	2	0.00
3230	2	0.00
2998	2	0.00
3410	2	0.00
2861	2	0.00
2915	2	0.00
2918	2	0.00
2921	2	0.00
2983	2	0.00
3471	2	0.00
3473	2	0.00
3561	2	0.00
3782	2	0.00
2952	2	0.00
2984	2	0.00
3654	2	0.00
4374	2	0.00
2871	2	0.00
2876	2	0.00
4291	2	0.00
3767	2	0.00
4290	2	0.00
4333	2	0.00
3804	2	0.00
4121	2	0.00
3948	2	0.00
4153	2	0.00
4511	2	0.00
3205	2	0.00
4348	2	0.00
3762	2	0.00
2985	2	0.00
3160	2	0.00
3181	2	0.00
3380	2	0.00
3381	2	0.00
3537	2	0.00
3544	2	0.00
3589	2	0.00
3634	2	0.00
3213	2	0.00
3228	2	0.00
3472	2	0.00
3463	2	0.00
3689	2	0.00
3690	2	0.00
4239	2	0.00
4041	2	0.00
4038	2	0.00
3691	2	0.00
3817	2	0.00
4064	2	0.00
3408	2	0.00
3429	2	0.00
3475	2	0.00
3476	2	0.00
4306	2	0.00
4376	2	0.00
2936	2	0.00
2937	2	0.00
2938	2	0.00
3769	2	0.00
3242	2	0.00
4327	2	0.00
3377	2	0.00
4498	2	0.00
4508	2	0.00
3460	2	0.00
4272	2	0.00
4354	2	0.00
4486	2	0.00
4502	2	0.00
2969	2	0.00
4531	2	0.00
2994	2	0.00
2927	2	0.00
3382	2	0.00
3521	2	0.00
3522	2	0.00
3820	2	0.00
3363	2	0.00
4085	2	0.00
4020	2	0.00
3781	2	0.00
3679	2	0.00
4334	2	0.00
3146	2	0.00
3924	2	0.00
4090	2	0.00
3829	2	0.00
3885	2	0.00
4001	2	0.00
4091	2	0.00
4168	2	0.00
4451	2	0.00
3900	2	0.00
4102	2	0.00
4342	2	0.00
3327	2	0.00
3570	2	0.00
4105	2	0.00
3833	2	0.00
3834	2	0.00
3977	2	0.00
4383	2	0.00
4465	2	0.00
4466	2	0.00
4467	2	0.00
3752	2	0.00
4253	2	0.00
4259	2	0.00
3210	2	0.00
3244	2	0.00
4328	2	0.00
3208	2	0.00
3854	2	0.00
3985	2	0.00
4143	2	0.00
3831	2	0.00
3923	2	0.00
3940	2	0.00
3941	2	0.00
3943	2	0.00
3944	2	0.00
3955	2	0.00
3988	2	0.00
3990	2	0.00
4432	2	0.00
3025	2	0.00
3250	2	0.00
4303	2	0.00
3901	2	0.00
3982	2	0.00
4427	2	0.00
4428	2	0.00
3109	2	0.00
3110	2	0.00
3158	2	0.00
3171	2	0.00
3202	2	0.00
3262	2	0.00
3359	2	0.00
3366	2	0.00
3394	2	0.00
3402	2	0.00
3494	2	0.00
3495	2	0.00
3542	2	0.00
3590	2	0.00
3245	2	0.00
3496	2	0.00
3692	2	0.00
3899	2	0.00
3994	2	0.00
4099	2	0.00
4149	2	0.00
4157	2	0.00
4460	2	0.00
3504	2	0.00
3505	2	0.00
3887	2	0.00
4013	2	0.00
3712	2	0.00
3713	2	0.00
3714	2	0.00
3417	2	0.00
2926	2	0.00
2974	2	0.00
2978	2	0.00
2981	2	0.00
3118	2	0.00
3168	2	0.00
3183	2	0.00
3223	2	0.00
3266	2	0.00
3267	2	0.00
4293	2	0.00
3354	2	0.00
3383	2	0.00
3384	2	0.00
3409	2	0.00
3497	2	0.00
3499	2	0.00
3500	2	0.00
3502	2	0.00
3503	2	0.00
3506	2	0.00
3507	2	0.00
3573	2	0.00
2877	2	0.00
3189	2	0.00
3246	2	0.00
3498	2	0.00
3662	2	0.00
3663	2	0.00
3892	2	0.00
4028	2	0.00
3693	2	0.00
3695	2	0.00
3818	2	0.00
3819	2	0.00
3877	2	0.00
3986	2	0.00
4098	2	0.00
4479	2	0.00
4480	2	0.00
4481	2	0.00
3469	2	0.00
4265	2	0.00
3170	2	0.00
3178	2	0.00
3196	2	0.00
3427	2	0.00
3428	2	0.00
3466	2	0.00
3467	2	0.00
3468	2	0.00
4118	2	0.00
3591	2	0.00
3169	2	0.00
3464	2	0.00
3794	2	0.00
4375	2	0.00
2919	2	0.00
2928	2	0.00
2995	2	0.00
3367	2	0.00
3372	2	0.00
3407	2	0.00
3430	2	0.00
3786	2	0.00
3838	2	0.00
3686	2	0.00
2869	2	0.00
3501	2	0.00
3797	2	0.00
3821	2	0.00
3837	2	0.00
3888	2	0.00
3911	2	0.00
3989	2	0.00
4065	2	0.00
4100	2	0.00
4163	2	0.00
4009	2	0.00
4390	2	0.00
4249	2	0.00
4325	2	0.00
3011	2	0.00
3668	2	0.00
3778	2	0.00
4507	2	0.00
2982	2	0.00
3053	2	0.00
3119	2	0.00
3728	2	0.00
3729	2	0.00
3633	2	0.00
3756	2	0.00
4344	2	0.00
3102	2	0.00
3125	2	0.00
3129	2	0.00
3185	2	0.00
3195	2	0.00
3238	2	0.00
3333	2	0.00
3337	2	0.00
3338	2	0.00
3351	2	0.00
4294	2	0.00
3375	2	0.00
3446	2	0.00
3458	2	0.00
3653	2	0.00
3970	2	0.00
3828	2	0.00
3849	2	0.00
3922	2	0.00
3951	2	0.00
3953	2	0.00
3954	2	0.00
3956	2	0.00
3957	2	0.00
3958	2	0.00
3960	2	0.00
3961	2	0.00
4457	2	0.00
4472	2	0.00
3952	2	0.00
2879	2	0.00
4251	2	0.00
3010	2	0.00
3124	2	0.00
3126	2	0.00
3128	2	0.00
3132	2	0.00
3282	2	0.00
3526	2	0.00
4315	2	0.00
3669	2	0.00
2975	2	0.00
3243	2	0.00
4360	2	0.00
3926	2	0.00
4361	2	0.00
3927	2	0.00
3928	2	0.00
3929	2	0.00
3931	2	0.00
3933	2	0.00
4362	2	0.00
3935	2	0.00
3936	2	0.00
3945	2	0.00
3946	2	0.00
3947	2	0.00
4406	2	0.00
3346	2	0.00
3932	2	0.00
3719	2	0.00
3720	2	0.00
3704	2	0.00
3721	2	0.00
3732	2	0.00
3733	2	0.00
3734	2	0.00
3735	2	0.00
3737	2	0.00
3738	2	0.00
3739	2	0.00
3741	2	0.00
3742	2	0.00
2858	2	0.00
2859	2	0.00
2865	2	0.00
2866	2	0.00
2867	2	0.00
2868	2	0.00
2881	2	0.00
2909	2	0.00
2910	2	0.00
2911	2	0.00
2920	2	0.00
2947	2	0.00
3020	2	0.00
3021	2	0.00
3022	2	0.00
3028	2	0.00
3029	2	0.00
3034	2	0.00
3035	2	0.00
3036	2	0.00
3037	2	0.00
3073	2	0.00
3074	2	0.00
3075	2	0.00
3076	2	0.00
3077	2	0.00
3078	2	0.00
3079	2	0.00
3080	2	0.00
3081	2	0.00
3082	2	0.00
3083	2	0.00
3084	2	0.00
3088	2	0.00
3141	2	0.00
3232	2	0.00
3233	2	0.00
3234	2	0.00
3277	2	0.00
3278	2	0.00
3448	2	0.00
3511	2	0.00
3512	2	0.00
3513	2	0.00
3587	2	0.00
3600	2	0.00
3601	2	0.00
3602	2	0.00
3604	2	0.00
3605	2	0.00
3606	2	0.00
3607	2	0.00
3608	2	0.00
3609	2	0.00
3611	2	0.00
3622	2	0.00
3645	2	0.00
3646	2	0.00
3647	2	0.00
3649	2	0.00
3650	2	0.00
3840	2	0.00
3026	2	0.00
3044	2	0.00
3045	2	0.00
3046	2	0.00
3047	2	0.00
3027	2	0.00
3072	2	0.00
3235	2	0.00
3514	2	0.00
3612	2	0.00
3620	2	0.00
3603	2	0.00
3621	2	0.00
3718	2	0.00
3736	2	0.00
3730	2	0.00
3731	2	0.00
3839	2	0.00
4395	2	0.00
4396	2	0.00
4397	2	0.00
4398	2	0.00
3013	2	0.00
3135	2	0.00
3136	2	0.00
3138	2	0.00
3140	2	0.00
3276	2	0.00
3597	2	0.00
3598	2	0.00
3599	2	0.00
3641	2	0.00
3642	2	0.00
3643	2	0.00
3644	2	0.00
2857	2	0.00
2860	2	0.00
2914	2	0.00
2955	2	0.00
3137	2	0.00
3610	2	0.00
3722	2	0.00
3723	2	0.00
3724	2	0.00
3725	2	0.00
3841	2	0.00
3842	2	0.00
4393	2	0.00
4394	2	0.00
3657	2	0.00
3766	2	0.00
2943	2	0.00
2944	2	0.00
2945	2	0.00
2958	2	0.00
2959	2	0.00
4255	2	0.00
3039	2	0.00
3040	2	0.00
3041	2	0.00
3043	2	0.00
4261	2	0.00
4262	2	0.00
4263	2	0.00
4264	2	0.00
4269	2	0.00
3130	2	0.00
4127	2	0.00
4276	2	0.00
3220	2	0.00
3221	2	0.00
3231	2	0.00
3236	2	0.00
3237	2	0.00
3286	2	0.00
3287	2	0.00
3288	2	0.00
3289	2	0.00
3290	2	0.00
3291	2	0.00
3292	2	0.00
3293	2	0.00
4285	2	0.00
3298	2	0.00
3360	2	0.00
3379	2	0.00
4295	2	0.00
4296	2	0.00
3401	2	0.00
3406	2	0.00
3412	2	0.00
3486	2	0.00
3788	2	0.00
4311	2	0.00
3555	2	0.00
3556	2	0.00
3557	2	0.00
3577	2	0.00
3613	2	0.00
3648	2	0.00
3651	2	0.00
3676	2	0.00
3302	2	0.00
3435	2	0.00
3452	2	0.00
3453	2	0.00
3454	2	0.00
3455	2	0.00
3566	2	0.00
3779	2	0.00
4126	2	0.00
3983	2	0.00
4018	2	0.00
3798	2	0.00
4338	2	0.00
4087	2	0.00
4436	2	0.00
3434	2	0.00
3784	2	0.00
2968	2	0.00
3332	2	0.00
3374	2	0.00
4300	2	0.00
3462	2	0.00
3787	2	0.00
3571	2	0.00
3656	2	0.00
3658	2	0.00
3659	2	0.00
3660	2	0.00
3661	2	0.00
3673	2	0.00
3309	2	0.00
3299	2	0.00
3300	2	0.00
3301	2	0.00
3697	2	0.00
4006	2	0.00
4384	2	0.00
4435	2	0.00
2819	2	0.00
2820	2	0.00
4245	2	0.00
2821	2	0.00
4246	2	0.00
2977	2	0.00
4283	2	0.00
3269	2	0.00
3270	2	0.00
3271	2	0.00
3273	2	0.00
3399	2	0.00
3433	2	0.00
3445	2	0.00
4309	2	0.00
3579	2	0.00
3581	2	0.00
2818	2	0.00
3103	2	0.00
3281	2	0.00
3342	2	0.00
3487	2	0.00
4411	2	0.00
4438	2	0.00
4513	2	0.00
4052	2	0.00
3764	2	0.00
3770	2	0.00
2864	2	0.00
2946	2	0.00
2956	2	0.00
2965	2	0.00
3014	2	0.00
3024	2	0.00
3059	2	0.00
4266	2	0.00
3063	2	0.00
3066	2	0.00
4268	2	0.00
4271	2	0.00
3145	2	0.00
3147	2	0.00
3186	2	0.00
3206	2	0.00
4277	2	0.00
4278	2	0.00
3222	2	0.00
4281	2	0.00
3255	2	0.00
4284	2	0.00
4288	2	0.00
3324	2	0.00
3325	2	0.00
3330	2	0.00
3376	2	0.00
3403	2	0.00
4298	2	0.00
3418	2	0.00
4299	2	0.00
3421	2	0.00
3422	2	0.00
3425	2	0.00
4037	2	0.00
3530	2	0.00
3531	2	0.00
3532	2	0.00
3533	2	0.00
4346	2	0.00
3539	2	0.00
3540	2	0.00
3541	2	0.00
3551	2	0.00
3552	2	0.00
3553	2	0.00
4318	2	0.00
4319	2	0.00
3576	2	0.00
3578	2	0.00
3674	2	0.00
3675	2	0.00
2835	2	0.00
2849	2	0.00
3312	2	0.00
4482	2	0.00
4287	2	0.00
3524	2	0.00
3120	2	0.00
3207	2	0.00
3795	2	0.00
3968	2	0.00
3743	2	0.00
4512	2	0.00
3090	2	0.00
3091	2	0.00
3092	2	0.00
3093	2	0.00
3094	2	0.00
3095	2	0.00
3096	2	0.00
3097	2	0.00
3098	2	0.00
3099	2	0.00
3272	2	0.00
3340	2	0.00
4082	2	0.00
3536	2	0.00
3575	2	0.00
2970	2	0.00
3089	2	0.00
4141	2	0.00
3763	2	0.00
3131	2	0.00
3263	2	0.00
3275	2	0.00
3284	2	0.00
3478	2	0.00
3534	2	0.00
3538	2	0.00
3545	2	0.00
3546	2	0.00
3629	2	0.00
3655	2	0.00
3085	2	0.00
3161	2	0.00
3253	2	0.00
3765	2	0.00
3703	2	0.00
3918	2	0.00
4022	2	0.00
2901	2	0.00
3031	2	0.00
3100	2	0.00
3101	2	0.00
3182	2	0.00
4128	2	0.00
3482	2	0.00
2902	2	0.00
3441	2	0.00
3485	2	0.00
3707	2	0.00
4420	2	0.00
4260	2	0.00
3744	2	0.00
3194	2	0.00
2967	2	0.00
3378	2	0.00
3362	2	0.00
3528	2	0.00
4314	2	0.00
4133	2	0.00
4015	2	0.00
4107	2	0.00
3671	2	0.00
4146	2	0.00
3758	2	0.00
3052	2	0.00
3308	2	0.00
3352	2	0.00
4302	2	0.00
3637	2	0.00
4083	2	0.00
4061	2	0.00
3913	2	0.00
4080	2	0.00
4386	2	0.00
3209	2	0.00
3006	2	0.00
4136	2	0.00
4137	2	0.00
3871	2	0.00
4034	2	0.00
3574	2	0.00
3635	2	0.00
3974	2	0.00
4112	2	0.00
2814	2	0.00
2815	2	0.00
4247	2	0.00
4320	2	0.00
3746	2	0.00
4229	2	0.00
4029	2	0.00
3801	2	0.00
3314	2	0.00
3315	2	0.00
3558	2	0.00
4336	2	0.00
4355	2	0.00
4496	2	0.00
4497	2	0.00
4258	2	0.00
4060	2	0.00
4067	2	0.00
4119	2	0.00
2838	2	0.00
4341	2	0.00
4356	2	0.00
4487	2	0.00
4492	2	0.00
3627	2	0.00
3628	2	0.00
3808	2	0.00
3814	2	0.00
4280	2	0.00
3836	2	0.00
3835	2	0.00
3850	2	0.00
3226	2	0.00
2940	2	0.00
3518	2	0.00
3413	2	0.00
3886	2	0.00
4463	2	0.00
4350	2	0.00
3623	2	0.00
4304	2	0.00
3365	2	0.00
3740	2	0.00
4114	2	0.00
4026	2	0.00
4053	2	0.00
4353	2	0.00
4056	2	0.00
4372	2	0.00
4120	2	0.00
4437	2	0.00
4475	2	0.00
4510	2	0.00
2913	2	0.00
4321	2	0.00
2816	2	0.00
3700	2	0.00
4155	2	0.00
4495	2	0.00
3562	2	0.00
3005	2	0.00
3543	2	0.00
4493	2	0.00
4499	2	0.00
3009	2	0.00
3069	2	0.00
3133	2	0.00
3134	2	0.00
4297	2	0.00
3444	2	0.00
3459	2	0.00
3638	2	0.00
4324	2	0.00
3639	2	0.00
3304	2	0.00
3987	2	0.00
4024	2	0.00
4078	2	0.00
3867	2	0.00
3963	2	0.00
4045	2	0.00
4058	2	0.00
4358	2	0.00
4073	2	0.00
4074	2	0.00
4075	2	0.00
4076	2	0.00
4108	2	0.00
4109	2	0.00
4110	2	0.00
4111	2	0.00
4142	2	0.00
4412	2	0.00
4418	2	0.00
3832	2	0.00
3596	2	0.00
3305	2	0.00
3316	2	0.00
3698	2	0.00
3702	2	0.00
3715	2	0.00
3716	2	0.00
3717	2	0.00
3745	2	0.00
3748	2	0.00
3749	2	0.00
4050	2	0.00
4400	2	0.00
4417	2	0.00
4462	2	0.00
4464	2	0.00
4468	2	0.00
4483	2	0.00
4519	2	0.00
3847	2	0.00
3356	2	0.00
3925	2	0.00
4129	2	0.00
4139	2	0.00
4016	2	0.00
4068	2	0.00
4069	2	0.00
4140	2	0.00
4425	2	0.00
3846	2	0.00
3397	2	0.00
3515	2	0.00
3980	2	0.00
3981	2	0.00
3934	2	0.00
3809	2	0.00
3876	2	0.00
4248	2	0.00
3188	2	0.00
3199	2	0.00
4307	2	0.00
4161	2	0.00
3688	2	0.00
3938	2	0.00
4470	2	0.00
3492	2	0.00
3560	2	0.00
3564	2	0.00
3942	2	0.00
4317	2	0.00
3792	2	0.00
3211	2	0.00
3869	2	0.00
3803	2	0.00
3813	2	0.00
3874	2	0.00
4357	2	0.00
3919	2	0.00
3975	2	0.00
4027	2	0.00
3959	2	0.00
4051	2	0.00
4072	2	0.00
4402	2	0.00
4363	2	0.00
4415	2	0.00
4456	2	0.00
4469	2	0.00
4525	2	0.00
3759	2	0.00
3802	2	0.00
3264	2	0.00
3268	2	0.00
3313	2	0.00
4033	2	0.00
3559	2	0.00
3563	2	0.00
4322	2	0.00
3682	2	0.00
3800	2	0.00
3868	2	0.00
4032	2	0.00
4160	2	0.00
3984	2	0.00
4364	2	0.00
4365	2	0.00
3857	2	0.00
3858	2	0.00
3870	2	0.00
3971	2	0.00
3991	2	0.00
3972	2	0.00
4367	2	0.00
4368	2	0.00
4031	2	0.00
4035	2	0.00
4151	2	0.00
4164	2	0.00
4401	2	0.00
4461	2	0.00
2837	2	0.00
4273	2	0.00
3996	2	0.00
3331	2	0.00
2979	2	0.00
3274	2	0.00
3979	2	0.00
3240	2	0.00
2862	2	0.00
3004	2	0.00
3007	2	0.00
3062	2	0.00
3204	2	0.00
4279	2	0.00
3973	2	0.00
4123	2	0.00
3565	2	0.00
3618	2	0.00
4331	2	0.00
3687	2	0.00
3049	2	0.00
3050	2	0.00
3060	2	0.00
3306	2	0.00
4007	2	0.00
4025	2	0.00
3509	2	0.00
3595	2	0.00
3726	2	0.00
3751	2	0.00
3856	2	0.00
4369	2	0.00
3861	2	0.00
4352	2	0.00
4086	2	0.00
4409	2	0.00
4040	2	0.00
4370	2	0.00
4449	2	0.00
4450	2	0.00
4452	2	0.00
4453	2	0.00
4371	2	0.00
4454	2	0.00
4455	2	0.00
3865	2	0.00
4515	2	0.00
4066	2	0.00
3785	2	0.00
3104	2	0.00
3163	2	0.00
3251	2	0.00
4289	2	0.00
3848	2	0.00
3414	2	0.00
3484	2	0.00
3023	2	0.00
3685	2	0.00
3806	2	0.00
3810	2	0.00
3880	2	0.00
3965	2	0.00
4012	2	0.00
4101	2	0.00
4175	2	0.00
3807	2	0.00
3853	2	0.00
3859	2	0.00
3863	2	0.00
4014	2	0.00
4043	2	0.00
4166	2	0.00
4382	2	0.00
4385	2	0.00
4079	2	0.00
4373	2	0.00
4391	2	0.00
4392	2	0.00
4414	2	0.00
4448	2	0.00
4504	2	0.00
4505	2	0.00
3799	2	0.00
2832	2	0.00
2833	2	0.00
2834	2	0.00
2844	2	0.00
2904	2	0.00
2939	2	0.00
3008	2	0.00
3042	2	0.00
4267	2	0.00
3341	2	0.00
3343	2	0.00
3419	2	0.00
3666	2	0.00
3827	2	0.00
3852	2	0.00
3517	2	0.00
3750	2	0.00
4135	2	0.00
4138	2	0.00
4156	2	0.00
4171	2	0.00
3998	2	0.00
4377	2	0.00
4097	2	0.00
4378	2	0.00
4403	2	0.00
4405	2	0.00
4404	2	0.00
4144	2	0.00
4017	2	0.00
4422	2	0.00
4274	2	0.00
3582	2	0.00
3054	2	0.00
3884	2	0.00
3709	2	0.00
2882	2	0.00
3071	2	0.00
3345	2	0.00
3893	2	0.00
3930	2	0.00
2851	2	0.00
4254	2	0.00
4257	2	0.00
3123	2	0.00
3051	2	0.00
3684	2	0.00
3862	2	0.00
4488	2	0.00
4489	2	0.00
4490	2	0.00
4491	2	0.00
4514	2	0.00
2855	2	0.00
2897	2	0.00
3015	2	0.00
3016	2	0.00
3032	2	0.00
3070	2	0.00
3086	2	0.00
3164	2	0.00
3191	2	0.00
3192	2	0.00
4275	2	0.00
3285	2	0.00
3295	2	0.00
3355	2	0.00
3569	2	0.00
3017	2	0.00
3162	2	0.00
3303	2	0.00
3708	2	0.00
3701	2	0.00
3705	2	0.00
3757	2	0.00
2875	2	0.00
2954	2	0.00
3317	2	0.00
3415	2	0.00
3588	2	0.00
3614	2	0.00
3048	2	0.00
3065	2	0.00
4154	2	0.00
2883	2	0.00
2885	2	0.00
2886	2	0.00
2887	2	0.00
4459	2	0.00
2888	2	0.00
2891	2	0.00
2893	2	0.00
2894	2	0.00
2895	2	0.00
2898	2	0.00
2899	2	0.00
2900	2	0.00
2906	2	0.00
2907	2	0.00
2908	2	0.00
3113	2	0.00
3114	2	0.00
3115	2	0.00
3247	2	0.00
3296	2	0.00
3318	2	0.00
3319	2	0.00
3320	2	0.00
3321	2	0.00
3335	2	0.00
3336	2	0.00
3344	2	0.00
3547	2	0.00
3548	2	0.00
3549	2	0.00
2884	2	0.00
2964	2	0.00
3143	2	0.00
3357	2	0.00
3672	2	0.00
3811	2	0.00
3696	2	0.00
4387	2	0.00
3851	2	0.00
4070	2	0.00
4071	2	0.00
4388	2	0.00
3334	2	0.00
3775	2	0.00
3776	2	0.00
3777	2	0.00
2923	2	0.00
2924	2	0.00
4471	2	0.00
2925	2	0.00
2950	2	0.00
2951	2	0.00
2966	2	0.00
2976	2	0.00
2987	2	0.00
2991	2	0.00
2992	2	0.00
2993	2	0.00
3038	2	0.00
3180	2	0.00
3348	2	0.00
3395	2	0.00
3400	2	0.00
3905	2	0.00
3519	2	0.00
3527	2	0.00
4117	2	0.00
3631	2	0.00
3465	2	0.00
3774	2	0.00
3815	2	0.00
3816	2	0.00
4000	2	0.00
4162	2	0.00
3167	2	0.00
3796	2	0.00
4104	2	0.00
3890	2	0.00
4046	2	0.00
4413	2	0.00
2929	2	0.00
2930	2	0.00
2932	2	0.00
2934	2	0.00
2935	2	0.00
2971	2	0.00
4517	2	0.00
4527	2	0.00
4516	2	0.00
4518	2	0.00
4521	2	0.00
4522	2	0.00
4523	2	0.00
4524	2	0.00
4526	2	0.00
4520	2	0.00
3760	2	0.00
3761	2	0.00
3755	2	0.00
3055	2	0.00
3411	2	0.00
3457	2	0.00
3790	2	0.00
3508	2	0.00
3845	2	0.00
2972	2	0.00
2973	2	0.00
3894	2	0.00
3127	2	0.00
3152	2	0.00
3153	2	0.00
3154	2	0.00
3155	2	0.00
3156	2	0.00
3157	2	0.00
3175	2	0.00
3176	2	0.00
3177	2	0.00
3190	2	0.00
3311	2	0.00
3896	2	0.00
3897	2	0.00
3370	2	0.00
3966	2	0.00
3967	2	0.00
4005	2	0.00
3391	2	0.00
4021	2	0.00
4023	2	0.00
3393	2	0.00
4047	2	0.00
3898	2	0.00
4130	2	0.00
4132	2	0.00
3404	2	0.00
4379	2	0.00
3432	2	0.00
4410	2	0.00
3483	2	0.00
4423	2	0.00
4424	2	0.00
4430	2	0.00
3592	2	0.00
3593	2	0.00
3594	2	0.00
4131	2	0.00
2933	2	0.00
3329	2	0.00
4509	2	0.00
3822	2	0.00
3823	2	0.00
3824	2	0.00
3889	2	0.00
4158	2	0.00
4159	2	0.00
4440	2	0.00
4441	2	0.00
4442	2	0.00
4443	2	0.00
4444	2	0.00
4445	2	0.00
4446	2	0.00
4478	2	0.00
4485	2	0.00
4447	2	0.00
3895	2	0.00
4439	2	0.00
2949	2	0.00
2840	2	0.00
3116	2	0.00
3117	2	0.00
3187	2	0.00
2963	2	0.00
3405	2	0.00
3585	2	0.00
3225	2	0.00
4458	2	0.00
4484	2	0.00
4494	2	0.00
3203	2	0.00
4286	2	0.00
3510	2	0.00
3625	2	0.00
3361	2	0.00
3369	2	0.00
3630	2	0.00
4541	2	0.00
3665	2	0.00
4351	2	0.00
4036	2	0.00
4380	2	0.00
4419	2	0.00
3879	2	0.00
3904	2	0.00
3424	2	0.00
3447	2	0.00
4054	2	0.00
3789	2	0.00
3567	2	0.00
3396	2	0.00
3443	2	0.00
3568	2	0.00
3680	2	0.00
3678	2	0.00
3727	2	0.00
4349	2	0.00
3992	2	0.00
3993	2	0.00
4063	2	0.00
4115	2	0.00
4542	2	0.00
4543	2	0.00
4544	2	0.00
4545	2	0.00
4548	2	0.00
4407	2	0.00
3440	2	0.00
3683	2	0.00
4359	2	0.00
3891	2	0.00
3962	2	0.00
4177	2	0.00
4381	2	0.00
3875	2	0.00
4301	2	0.00
3437	2	0.00
3436	2	0.00
3866	2	0.00
3881	2	0.00
3882	2	0.00
3909	2	0.00
3964	2	0.00
3978	2	0.00
4042	2	0.00
4169	2	0.00
4416	2	0.00
4316	2	0.00
4044	2	0.00
4152	2	0.00
4399	2	0.00
4426	2	0.00
3768	2	0.00
3771	2	0.00
3772	2	0.00
3148	2	0.00
3279	2	0.00
3416	2	0.00
3624	2	0.00
3805	2	0.00
3883	2	0.00
4077	2	0.00
4337	2	0.00
3860	2	0.00
3949	2	0.00
3999	2	0.00
4048	2	0.00
4049	2	0.00
4084	2	0.00
4167	2	0.00
4172	2	0.00
4173	2	0.00
4339	2	0.00
3388	2	0.00
3392	2	0.00
3474	2	0.00
3479	2	0.00
3480	2	0.00
3636	2	0.00
3179	2	0.00
3368	2	0.00
3386	2	0.00
3389	2	0.00
3390	2	0.00
3385	2	0.00
3387	2	0.00
3753	2	0.00
3844	2	0.00
4347	2	0.00
4092	2	0.00
4094	2	0.00
4095	2	0.00
4096	2	0.00
4145	2	0.00
4147	2	0.00
4081	2	0.00
4122	2	0.00
4176	2	0.00
4408	2	0.00
3995	2	0.00
3997	2	0.00
4343	2	0.00
3398	2	0.00
3493	2	0.00
4326	2	0.00
4332	2	0.00
3677	2	0.00
3572	2	0.00
3793	2	0.00
3812	2	0.00
3873	2	0.00
3902	2	0.00
3903	2	0.00
3912	2	0.00
3976	2	0.00
4039	2	0.00
4476	2	0.00
4506	2	0.00
3554	2	0.00
4062	2	0.00
4174	2	0.00
3516	2	0.00
3529	2	0.00
4313	2	0.00
4055	2	0.00
3920	2	0.00
3921	2	0.00
3950	2	0.00
4008	2	0.00
3580	2	0.00
4059	2	0.00
3939	2	0.00
4433	2	0.00
4057	2	0.00
3780	2	0.00
3783	2	0.00
3619	2	0.00
4335	2	0.00
4215	2	0.00
4217	2	0.00
4218	2	0.00
4219	2	0.00
4220	2	0.00
4216	2	0.00
4208	2	0.00
4225	2	0.00
4228	2	0.00
4231	2	0.00
4232	2	0.00
4234	2	0.00
4236	2	0.00
4235	2	0.00
4089	2	0.00
4093	2	0.00
4103	2	0.00
4170	2	0.00
2850	2	0.00
4561	2	0.00
4564	2	0.00
4568	2	0.00
4569	2	0.00
4560	2	0.00
4434	2	0.00
4230	2	0.00
4211	2	0.00
3252	2	0.00
3258	2	0.00
4553	2	0.00
3825	2	0.00
2896	2	0.00
4238	2	0.00
2903	2	0.00
3586	2	0.00
4237	2	0.00
4204	2	0.00
3364	2	0.00
2890	2	0.00
3227	2	0.00
2961	2	0.00
3139	2	0.00
3451	2	0.00
3456	2	0.00
2892	2	0.00
4240	2	0.00
3535	2	0.00
3937	2	0.00
2889	2	0.00
4207	2	0.00
4004	2	0.00
4002	2	0.00
3969	2	0.00
4003	2	0.00
3001	2	0.00
4431	2	0.00
4540	2	0.00
4474	2	0.00
4538	2	0.00
4389	2	0.00
4193	2	0.00
3664	2	0.00
4500	2	0.00
3256	2	0.00
4179	2	0.00
4180	2	0.00
3872	2	0.00
4233	2	0.00
4539	2	0.00
3224	2	0.00
3294	2	0.00
3439	2	0.00
3438	2	0.00
4185	2	0.00
4184	2	0.00
4203	2	0.00
4244	2	0.00
4197	2	0.00
2842	2	0.00
3328	2	0.00
3431	2	0.00
3144	2	0.00
3450	2	0.00
3826	2	0.00
3449	2	0.00
3261	2	0.00
3423	2	0.00
3239	2	0.00
3254	2	0.00
3710	2	0.00
3878	2	0.00
3067	2	0.00
3640	2	0.00
3068	2	0.00
4113	2	0.00
2880	2	0.00
3477	2	0.00
3754	2	0.00
4134	2	0.00
3159	2	0.00
2836	2	0.00
3339	2	0.00
4330	2	0.00
3347	2	0.00
3012	2	0.00
3003	2	0.00
2852	2	0.00
4366	2	0.00
4186	2	0.00
4183	2	0.00
2841	2	0.00
2843	2	0.00
4148	2	0.00
4549	2	0.00
4194	2	0.00
4106	2	0.00
3470	2	0.00
4192	2	0.00
4188	2	0.00
4187	2	0.00
4011	2	0.00
4503	2	0.00
4030	2	0.00
2905	2	0.00
4191	2	0.00
4190	2	0.00
4178	2	0.00
4559	2	0.00
4556	2	0.00
4202	2	0.00
4199	2	0.00
4198	2	0.00
4530	2	0.00
4566	2	0.00
4562	2	0.00
4563	2	0.00
4565	2	0.00
4554	2	0.00
4555	2	0.00
4528	2	0.00
4189	2	0.00
4529	2	0.00
4567	2	0.00
4241	2	0.00
4550	4	0.00
4270	4	0.00
2997	4	0.00
3212	4	0.00
3280	4	0.00
3681	4	0.00
4212	4	0.00
2922	4	0.00
2986	4	0.00
2912	4	0.00
4250	4	0.00
3297	4	0.00
4088	4	0.00
3420	4	0.00
4340	4	0.00
4310	4	0.00
4124	4	0.00
4125	4	0.00
3907	4	0.00
3908	4	0.00
3914	4	0.00
3915	4	0.00
3916	4	0.00
3917	4	0.00
4116	4	0.00
4165	4	0.00
4429	4	0.00
3906	4	0.00
2941	4	0.00
3165	4	0.00
3166	4	0.00
3353	4	0.00
3442	4	0.00
3241	4	0.00
2942	4	0.00
4019	4	0.00
2953	4	0.00
3033	4	0.00
3358	4	0.00
3371	4	0.00
3061	4	0.00
3200	4	0.00
3201	4	0.00
3350	4	0.00
3652	4	0.00
4256	4	0.00
3058	4	0.00
3184	4	0.00
3198	4	0.00
3229	4	0.00
3326	4	0.00
3307	4	0.00
4421	4	0.00
2817	4	0.00
3064	4	0.00
2980	4	0.00
2823	4	0.00
3310	4	0.00
2822	4	0.00
2824	4	0.00
2825	4	0.00
2826	4	0.00
2827	4	0.00
2828	4	0.00
2829	4	0.00
2830	4	0.00
2839	4	0.00
2854	4	0.00
2856	4	0.00
2863	4	0.00
2870	4	0.00
2872	4	0.00
2873	4	0.00
2874	4	0.00
2878	4	0.00
2917	4	0.00
2957	4	0.00
4252	4	0.00
3002	4	0.00
3030	4	0.00
3105	4	0.00
3106	4	0.00
3107	4	0.00
3108	4	0.00
3142	4	0.00
3174	4	0.00
3193	4	0.00
3259	4	0.00
3322	4	0.00
3323	4	0.00
4305	4	0.00
4345	4	0.00
3523	4	0.00
3615	4	0.00
3626	4	0.00
2916	4	0.00
2948	4	0.00
3583	4	0.00
3584	4	0.00
3711	4	0.00
3864	4	0.00
3843	4	0.00
3699	4	0.00
4501	4	0.00
3461	4	0.00
3855	4	0.00
2845	4	0.00
2847	4	0.00
2848	4	0.00
2931	4	0.00
2960	4	0.00
2962	4	0.00
2988	4	0.00
2989	4	0.00
2990	4	0.00
3018	4	0.00
3056	4	0.00
3057	4	0.00
3087	4	0.00
3111	4	0.00
3112	4	0.00
3121	4	0.00
3122	4	0.00
3150	4	0.00
3197	4	0.00
3214	4	0.00
3215	4	0.00
3216	4	0.00
3217	4	0.00
3218	4	0.00
3219	4	0.00
3248	4	0.00
3249	4	0.00
4282	4	0.00
3260	4	0.00
3265	4	0.00
3283	4	0.00
3349	4	0.00
4292	4	0.00
3373	4	0.00
4010	4	0.00
3426	4	0.00
3481	4	0.00
3488	4	0.00
3489	4	0.00
4308	4	0.00
3490	4	0.00
3491	4	0.00
3520	4	0.00
3791	4	0.00
4312	4	0.00
3616	4	0.00
3617	4	0.00
4323	4	0.00
3632	4	0.00
4329	4	0.00
2831	4	0.00
3667	4	0.00
3670	4	0.00
2846	4	0.00
3257	4	0.00
3550	4	0.00
3747	4	0.00
3830	4	0.00
3694	4	0.00
3706	4	0.00
4150	4	0.00
4473	4	0.00
4477	4	0.00
3149	4	0.00
3151	4	0.00
3910	4	0.00
2853	4	0.00
3525	4	0.00
3773	4	0.00
3019	4	0.00
2999	4	0.00
3000	4	0.00
3172	4	0.00
3173	4	0.00
2996	4	0.00
3230	4	0.00
2998	4	0.00
3410	4	0.00
2861	4	0.00
2915	4	0.00
2918	4	0.00
2921	4	0.00
2983	4	0.00
3471	4	0.00
3473	4	0.00
3561	4	0.00
3782	4	0.00
2952	4	0.00
2984	4	0.00
3654	4	0.00
4374	4	0.00
2871	4	0.00
2876	4	0.00
4291	4	0.00
3767	4	0.00
4290	4	0.00
4333	4	0.00
3804	4	0.00
4121	4	0.00
3948	4	0.00
4153	4	0.00
4511	4	0.00
3205	4	0.00
4348	4	0.00
3762	4	0.00
2985	4	0.00
3160	4	0.00
3181	4	0.00
3380	4	0.00
3381	4	0.00
3537	4	0.00
3544	4	0.00
3589	4	0.00
3634	4	0.00
3213	4	0.00
3228	4	0.00
3472	4	0.00
3463	4	0.00
3689	4	0.00
3690	4	0.00
4239	4	0.00
4041	4	0.00
4038	4	0.00
3691	4	0.00
3817	4	0.00
4064	4	0.00
3408	4	0.00
3429	4	0.00
3475	4	0.00
3476	4	0.00
4306	4	0.00
4376	4	0.00
2936	4	0.00
2937	4	0.00
2938	4	0.00
3769	4	0.00
3242	4	0.00
4327	4	0.00
3377	4	0.00
4498	4	0.00
4508	4	0.00
3460	4	0.00
4272	4	0.00
4354	4	0.00
4486	4	0.00
4502	4	0.00
2969	4	0.00
4531	4	0.00
2994	4	0.00
2927	4	0.00
3382	4	0.00
3521	4	0.00
3522	4	0.00
3820	4	0.00
3363	4	0.00
4085	4	0.00
4020	4	0.00
3781	4	0.00
3679	4	0.00
4334	4	0.00
3146	4	0.00
3924	4	0.00
4090	4	0.00
3829	4	0.00
3885	4	0.00
4001	4	0.00
4091	4	0.00
4168	4	0.00
4451	4	0.00
3900	4	0.00
4102	4	0.00
4342	4	0.00
3327	4	0.00
3570	4	0.00
4105	4	0.00
3833	4	0.00
3834	4	0.00
3977	4	0.00
4383	4	0.00
4465	4	0.00
4466	4	0.00
4467	4	0.00
3752	4	0.00
4253	4	0.00
4259	4	0.00
3210	4	0.00
3244	4	0.00
4328	4	0.00
3208	4	0.00
3854	4	0.00
3985	4	0.00
4143	4	0.00
3831	4	0.00
3923	4	0.00
3940	4	0.00
3941	4	0.00
3943	4	0.00
3944	4	0.00
3955	4	0.00
3988	4	0.00
3990	4	0.00
4432	4	0.00
3025	4	0.00
3250	4	0.00
4303	4	0.00
3901	4	0.00
3982	4	0.00
4427	4	0.00
4428	4	0.00
3109	4	0.00
3110	4	0.00
3158	4	0.00
3171	4	0.00
3202	4	0.00
3262	4	0.00
3359	4	0.00
3366	4	0.00
3394	4	0.00
3402	4	0.00
3494	4	0.00
3495	4	0.00
3542	4	0.00
3590	4	0.00
3245	4	0.00
3496	4	0.00
3692	4	0.00
3899	4	0.00
3994	4	0.00
4099	4	0.00
4149	4	0.00
4157	4	0.00
4460	4	0.00
3504	4	0.00
3505	4	0.00
3887	4	0.00
4013	4	0.00
3712	4	0.00
3713	4	0.00
3714	4	0.00
3417	4	0.00
2926	4	0.00
2974	4	0.00
2978	4	0.00
2981	4	0.00
3118	4	0.00
3168	4	0.00
3183	4	0.00
3223	4	0.00
3266	4	0.00
3267	4	0.00
4293	4	0.00
3354	4	0.00
3383	4	0.00
3384	4	0.00
3409	4	0.00
3497	4	0.00
3499	4	0.00
3500	4	0.00
3502	4	0.00
3503	4	0.00
3506	4	0.00
3507	4	0.00
3573	4	0.00
2877	4	0.00
3189	4	0.00
3246	4	0.00
3498	4	0.00
3662	4	0.00
3663	4	0.00
3892	4	0.00
4028	4	0.00
3693	4	0.00
3695	4	0.00
3818	4	0.00
3819	4	0.00
3877	4	0.00
3986	4	0.00
4098	4	0.00
4479	4	0.00
4480	4	0.00
4481	4	0.00
3469	4	0.00
4265	4	0.00
3170	4	0.00
3178	4	0.00
3196	4	0.00
3427	4	0.00
3428	4	0.00
3466	4	0.00
3467	4	0.00
3468	4	0.00
4118	4	0.00
3591	4	0.00
3169	4	0.00
3464	4	0.00
3794	4	0.00
4375	4	0.00
2919	4	0.00
2928	4	0.00
2995	4	0.00
3367	4	0.00
3372	4	0.00
3407	4	0.00
3430	4	0.00
3786	4	0.00
3838	4	0.00
3686	4	0.00
2869	4	0.00
3501	4	0.00
3797	4	0.00
3821	4	0.00
3837	4	0.00
3888	4	0.00
3911	4	0.00
3989	4	0.00
4065	4	0.00
4100	4	0.00
4163	4	0.00
4009	4	0.00
4390	4	0.00
4249	4	0.00
4325	4	0.00
3011	4	0.00
3668	4	0.00
3778	4	0.00
4507	4	0.00
2982	4	0.00
3053	4	0.00
3119	4	0.00
3728	4	0.00
3729	4	0.00
3633	4	0.00
3756	4	0.00
4344	4	0.00
3102	4	0.00
3125	4	0.00
3129	4	0.00
3185	4	0.00
3195	4	0.00
3238	4	0.00
3333	4	0.00
3337	4	0.00
3338	4	0.00
3351	4	0.00
4294	4	0.00
3375	4	0.00
3446	4	0.00
3458	4	0.00
3653	4	0.00
3970	4	0.00
3828	4	0.00
3849	4	0.00
3922	4	0.00
3951	4	0.00
3953	4	0.00
3954	4	0.00
3956	4	0.00
3957	4	0.00
3958	4	0.00
3960	4	0.00
3961	4	0.00
4457	4	0.00
4472	4	0.00
3952	4	0.00
2879	4	0.00
4251	4	0.00
3010	4	0.00
3124	4	0.00
3126	4	0.00
3128	4	0.00
3132	4	0.00
3282	4	0.00
3526	4	0.00
4315	4	0.00
3669	4	0.00
2975	4	0.00
3243	4	0.00
4360	4	0.00
3926	4	0.00
4361	4	0.00
3927	4	0.00
3928	4	0.00
3929	4	0.00
3931	4	0.00
3933	4	0.00
4362	4	0.00
3935	4	0.00
3936	4	0.00
3945	4	0.00
3946	4	0.00
3947	4	0.00
4406	4	0.00
3346	4	0.00
3932	4	0.00
3719	4	0.00
3720	4	0.00
3704	4	0.00
3721	4	0.00
3732	4	0.00
3733	4	0.00
3734	4	0.00
3735	4	0.00
3737	4	0.00
3738	4	0.00
3739	4	0.00
3741	4	0.00
3742	4	0.00
2858	4	0.00
2859	4	0.00
2865	4	0.00
2866	4	0.00
2867	4	0.00
2868	4	0.00
2881	4	0.00
2909	4	0.00
2910	4	0.00
2911	4	0.00
2920	4	0.00
2947	4	0.00
3020	4	0.00
3021	4	0.00
3022	4	0.00
3028	4	0.00
3029	4	0.00
3034	4	0.00
3035	4	0.00
3036	4	0.00
3037	4	0.00
3073	4	0.00
3074	4	0.00
3075	4	0.00
3076	4	0.00
3077	4	0.00
3078	4	0.00
3079	4	0.00
3080	4	0.00
3081	4	0.00
3082	4	0.00
3083	4	0.00
3084	4	0.00
3088	4	0.00
3141	4	0.00
3232	4	0.00
3233	4	0.00
3234	4	0.00
3277	4	0.00
3278	4	0.00
3448	4	0.00
3511	4	0.00
3512	4	0.00
3513	4	0.00
3587	4	0.00
3600	4	0.00
3601	4	0.00
3602	4	0.00
3604	4	0.00
3605	4	0.00
3606	4	0.00
3607	4	0.00
3608	4	0.00
3609	4	0.00
3611	4	0.00
3622	4	0.00
3645	4	0.00
3646	4	0.00
3647	4	0.00
3649	4	0.00
3650	4	0.00
3840	4	0.00
3026	4	0.00
3044	4	0.00
3045	4	0.00
3046	4	0.00
3047	4	0.00
3027	4	0.00
3072	4	0.00
3235	4	0.00
3514	4	0.00
3612	4	0.00
3620	4	0.00
3603	4	0.00
3621	4	0.00
3718	4	0.00
3736	4	0.00
3730	4	0.00
3731	4	0.00
3839	4	0.00
4395	4	0.00
4396	4	0.00
4397	4	0.00
4398	4	0.00
3013	4	0.00
3135	4	0.00
3136	4	0.00
3138	4	0.00
3140	4	0.00
3276	4	0.00
3597	4	0.00
3598	4	0.00
3599	4	0.00
3641	4	0.00
3642	4	0.00
3643	4	0.00
3644	4	0.00
2857	4	0.00
2860	4	0.00
2914	4	0.00
2955	4	0.00
3137	4	0.00
3610	4	0.00
3722	4	0.00
3723	4	0.00
3724	4	0.00
3725	4	0.00
3841	4	0.00
3842	4	0.00
4393	4	0.00
4394	4	0.00
3657	4	0.00
3766	4	0.00
2943	4	0.00
2944	4	0.00
2945	4	0.00
2958	4	0.00
2959	4	0.00
4255	4	0.00
3039	4	0.00
3040	4	0.00
3041	4	0.00
3043	4	0.00
4261	4	0.00
4262	4	0.00
4263	4	0.00
4264	4	0.00
4269	4	0.00
3130	4	0.00
4127	4	0.00
4276	4	0.00
3220	4	0.00
3221	4	0.00
3231	4	0.00
3236	4	0.00
3237	4	0.00
3286	4	0.00
3287	4	0.00
3288	4	0.00
3289	4	0.00
3290	4	0.00
3291	4	0.00
3292	4	0.00
3293	4	0.00
4285	4	0.00
3298	4	0.00
3360	4	0.00
3379	4	0.00
4295	4	0.00
4296	4	0.00
3401	4	0.00
3406	4	0.00
3412	4	0.00
3486	4	0.00
3788	4	0.00
4311	4	0.00
3555	4	0.00
3556	4	0.00
3557	4	0.00
3577	4	0.00
3613	4	0.00
3648	4	0.00
3651	4	0.00
3676	4	0.00
3302	4	0.00
3435	4	0.00
3452	4	0.00
3453	4	0.00
3454	4	0.00
3455	4	0.00
3566	4	0.00
3779	4	0.00
4126	4	0.00
3983	4	0.00
4018	4	0.00
3798	4	0.00
4338	4	0.00
4087	4	0.00
4436	4	0.00
3434	4	0.00
3784	4	0.00
2968	4	0.00
3332	4	0.00
3374	4	0.00
4300	4	0.00
3462	4	0.00
3787	4	0.00
3571	4	0.00
3656	4	0.00
3658	4	0.00
3659	4	0.00
3660	4	0.00
3661	4	0.00
3673	4	0.00
3309	4	0.00
3299	4	0.00
3300	4	0.00
3301	4	0.00
3697	4	0.00
4006	4	0.00
4384	4	0.00
4435	4	0.00
2819	4	0.00
2820	4	0.00
4245	4	0.00
2821	4	0.00
4246	4	0.00
2977	4	0.00
4283	4	0.00
3269	4	0.00
3270	4	0.00
3271	4	0.00
3273	4	0.00
3399	4	0.00
3433	4	0.00
3445	4	0.00
4309	4	0.00
3579	4	0.00
3581	4	0.00
2818	4	0.00
3103	4	0.00
3281	4	0.00
3342	4	0.00
3487	4	0.00
4411	4	0.00
4438	4	0.00
4513	4	0.00
4052	4	0.00
3764	4	0.00
3770	4	0.00
2864	4	0.00
2946	4	0.00
2956	4	0.00
2965	4	0.00
3014	4	0.00
3024	4	0.00
3059	4	0.00
4266	4	0.00
3063	4	0.00
3066	4	0.00
4268	4	0.00
4271	4	0.00
3145	4	0.00
3147	4	0.00
3186	4	0.00
3206	4	0.00
4277	4	0.00
4278	4	0.00
3222	4	0.00
4281	4	0.00
3255	4	0.00
4284	4	0.00
4288	4	0.00
3324	4	0.00
3325	4	0.00
3330	4	0.00
3376	4	0.00
3403	4	0.00
4298	4	0.00
3418	4	0.00
4299	4	0.00
3421	4	0.00
3422	4	0.00
3425	4	0.00
4037	4	0.00
3530	4	0.00
3531	4	0.00
3532	4	0.00
3533	4	0.00
4346	4	0.00
3539	4	0.00
3540	4	0.00
3541	4	0.00
3551	4	0.00
3552	4	0.00
3553	4	0.00
4318	4	0.00
4319	4	0.00
3576	4	0.00
3578	4	0.00
3674	4	0.00
3675	4	0.00
2835	4	0.00
2849	4	0.00
3312	4	0.00
4482	4	0.00
4287	4	0.00
3524	4	0.00
3120	4	0.00
3207	4	0.00
3795	4	0.00
3968	4	0.00
3743	4	0.00
4512	4	0.00
3090	4	0.00
3091	4	0.00
3092	4	0.00
3093	4	0.00
3094	4	0.00
3095	4	0.00
3096	4	0.00
3097	4	0.00
3098	4	0.00
3099	4	0.00
3272	4	0.00
3340	4	0.00
4082	4	0.00
3536	4	0.00
3575	4	0.00
2970	4	0.00
3089	4	0.00
4141	4	0.00
3763	4	0.00
3131	4	0.00
3263	4	0.00
3275	4	0.00
3284	4	0.00
3478	4	0.00
3534	4	0.00
3538	4	0.00
3545	4	0.00
3546	4	0.00
3629	4	0.00
3655	4	0.00
3085	4	0.00
3161	4	0.00
3253	4	0.00
3765	4	0.00
3703	4	0.00
3918	4	0.00
4022	4	0.00
2901	4	0.00
3031	4	0.00
3100	4	0.00
3101	4	0.00
3182	4	0.00
4128	4	0.00
3482	4	0.00
2902	4	0.00
3441	4	0.00
3485	4	0.00
3707	4	0.00
4420	4	0.00
4260	4	0.00
3744	4	0.00
3194	4	0.00
2967	4	0.00
3378	4	0.00
3362	4	0.00
3528	4	0.00
4314	4	0.00
4133	4	0.00
4015	4	0.00
4107	4	0.00
3671	4	0.00
4146	4	0.00
3758	4	0.00
3052	4	0.00
3308	4	0.00
3352	4	0.00
4302	4	0.00
3637	4	0.00
4083	4	0.00
4061	4	0.00
3913	4	0.00
4080	4	0.00
4386	4	0.00
3209	4	0.00
3006	4	0.00
4136	4	0.00
4137	4	0.00
3871	4	0.00
4034	4	0.00
3574	4	0.00
3635	4	0.00
3974	4	0.00
4112	4	0.00
2814	4	0.00
2815	4	0.00
4247	4	0.00
4320	4	0.00
3746	4	0.00
4229	4	0.00
4029	4	0.00
3801	4	0.00
3314	4	0.00
3315	4	0.00
3558	4	0.00
4336	4	0.00
4355	4	0.00
4496	4	0.00
4497	4	0.00
4258	4	0.00
4060	4	0.00
4067	4	0.00
4119	4	0.00
2838	4	0.00
4341	4	0.00
4356	4	0.00
4487	4	0.00
4492	4	0.00
3627	4	0.00
3628	4	0.00
3808	4	0.00
3814	4	0.00
4280	4	0.00
3836	4	0.00
3835	4	0.00
3850	4	0.00
3226	4	0.00
2940	4	0.00
3518	4	0.00
3413	4	0.00
3886	4	0.00
4463	4	0.00
4350	4	0.00
3623	4	0.00
4304	4	0.00
3365	4	0.00
3740	4	0.00
4114	4	0.00
4026	4	0.00
4053	4	0.00
4353	4	0.00
4056	4	0.00
4372	4	0.00
4120	4	0.00
4437	4	0.00
4475	4	0.00
4510	4	0.00
2913	4	0.00
4321	4	0.00
2816	4	0.00
3700	4	0.00
4155	4	0.00
4495	4	0.00
3562	4	0.00
3005	4	0.00
3543	4	0.00
4493	4	0.00
4499	4	0.00
3009	4	0.00
3069	4	0.00
3133	4	0.00
3134	4	0.00
4297	4	0.00
3444	4	0.00
3459	4	0.00
3638	4	0.00
4324	4	0.00
3639	4	0.00
3304	4	0.00
3987	4	0.00
4024	4	0.00
4078	4	0.00
3867	4	0.00
3963	4	0.00
4045	4	0.00
4058	4	0.00
4358	4	0.00
4073	4	0.00
4074	4	0.00
4075	4	0.00
4076	4	0.00
4108	4	0.00
4109	4	0.00
4110	4	0.00
4111	4	0.00
4142	4	0.00
4412	4	0.00
4418	4	0.00
3832	4	0.00
3596	4	0.00
3305	4	0.00
3316	4	0.00
3698	4	0.00
3702	4	0.00
3715	4	0.00
3716	4	0.00
3717	4	0.00
3745	4	0.00
3748	4	0.00
3749	4	0.00
4050	4	0.00
4400	4	0.00
4417	4	0.00
4462	4	0.00
4464	4	0.00
4468	4	0.00
4483	4	0.00
4519	4	0.00
3847	4	0.00
3356	4	0.00
3925	4	0.00
4129	4	0.00
4139	4	0.00
4016	4	0.00
4068	4	0.00
4069	4	0.00
4140	4	0.00
4425	4	0.00
3846	4	0.00
3397	4	0.00
3515	4	0.00
3980	4	0.00
3981	4	0.00
3934	4	0.00
3809	4	0.00
3876	4	0.00
4248	4	0.00
3188	4	0.00
3199	4	0.00
4307	4	0.00
4161	4	0.00
3688	4	0.00
3938	4	0.00
4470	4	0.00
3492	4	0.00
3560	4	0.00
3564	4	0.00
3942	4	0.00
4317	4	0.00
3792	4	0.00
3211	4	0.00
3869	4	0.00
3803	4	0.00
3813	4	0.00
3874	4	0.00
4357	4	0.00
3919	4	0.00
3975	4	0.00
4027	4	0.00
3959	4	0.00
4051	4	0.00
4072	4	0.00
4402	4	0.00
4363	4	0.00
4415	4	0.00
4456	4	0.00
4469	4	0.00
4525	4	0.00
3759	4	0.00
3802	4	0.00
3264	4	0.00
3268	4	0.00
3313	4	0.00
4033	4	0.00
3559	4	0.00
3563	4	0.00
4322	4	0.00
3682	4	0.00
3800	4	0.00
3868	4	0.00
4032	4	0.00
4160	4	0.00
3984	4	0.00
4364	4	0.00
4365	4	0.00
3857	4	0.00
3858	4	0.00
3870	4	0.00
3971	4	0.00
3991	4	0.00
3972	4	0.00
4367	4	0.00
4368	4	0.00
4031	4	0.00
4035	4	0.00
4151	4	0.00
4164	4	0.00
4401	4	0.00
4461	4	0.00
2837	4	0.00
4273	4	0.00
3996	4	0.00
3331	4	0.00
2979	4	0.00
3274	4	0.00
3979	4	0.00
3240	4	0.00
2862	4	0.00
3004	4	0.00
3007	4	0.00
3062	4	0.00
3204	4	0.00
4279	4	0.00
3973	4	0.00
4123	4	0.00
3565	4	0.00
3618	4	0.00
4331	4	0.00
3687	4	0.00
3049	4	0.00
3050	4	0.00
3060	4	0.00
3306	4	0.00
4007	4	0.00
4025	4	0.00
3509	4	0.00
3595	4	0.00
3726	4	0.00
3751	4	0.00
3856	4	0.00
4369	4	0.00
3861	4	0.00
4352	4	0.00
4086	4	0.00
4409	4	0.00
4040	4	0.00
4370	4	0.00
4449	4	0.00
4450	4	0.00
4452	4	0.00
4453	4	0.00
4371	4	0.00
4454	4	0.00
4455	4	0.00
3865	4	0.00
4515	4	0.00
4066	4	0.00
3785	4	0.00
3104	4	0.00
3163	4	0.00
3251	4	0.00
4289	4	0.00
3848	4	0.00
3414	4	0.00
3484	4	0.00
3023	4	0.00
3685	4	0.00
3806	4	0.00
3810	4	0.00
3880	4	0.00
3965	4	0.00
4012	4	0.00
4101	4	0.00
4175	4	0.00
3807	4	0.00
3853	4	0.00
3859	4	0.00
3863	4	0.00
4014	4	0.00
4043	4	0.00
4166	4	0.00
4382	4	0.00
4385	4	0.00
4079	4	0.00
4373	4	0.00
4391	4	0.00
4392	4	0.00
4414	4	0.00
4448	4	0.00
4504	4	0.00
4505	4	0.00
3799	4	0.00
2832	4	0.00
2833	4	0.00
2834	4	0.00
2844	4	0.00
2904	4	0.00
2939	4	0.00
3008	4	0.00
3042	4	0.00
4267	4	0.00
3341	4	0.00
3343	4	0.00
3419	4	0.00
3666	4	0.00
3827	4	0.00
3852	4	0.00
3517	4	0.00
3750	4	0.00
4135	4	0.00
4138	4	0.00
4156	4	0.00
4171	4	0.00
3998	4	0.00
4377	4	0.00
4097	4	0.00
4378	4	0.00
4403	4	0.00
4405	4	0.00
4404	4	0.00
4144	4	0.00
4017	4	0.00
4422	4	0.00
4274	4	0.00
3582	4	0.00
3054	4	0.00
3884	4	0.00
3709	4	0.00
2882	4	0.00
3071	4	0.00
3345	4	0.00
3893	4	0.00
3930	4	0.00
2851	4	0.00
4254	4	0.00
4257	4	0.00
3123	4	0.00
3051	4	0.00
3684	4	0.00
3862	4	0.00
4488	4	0.00
4489	4	0.00
4490	4	0.00
4491	4	0.00
4514	4	0.00
2855	4	0.00
2897	4	0.00
3015	4	0.00
3016	4	0.00
3032	4	0.00
3070	4	0.00
3086	4	0.00
3164	4	0.00
3191	4	0.00
3192	4	0.00
4275	4	0.00
3285	4	0.00
3295	4	0.00
3355	4	0.00
3569	4	0.00
3017	4	0.00
3162	4	0.00
3303	4	0.00
3708	4	0.00
3701	4	0.00
3705	4	0.00
3757	4	0.00
2875	4	0.00
2954	4	0.00
3317	4	0.00
3415	4	0.00
3588	4	0.00
3614	4	0.00
3048	4	0.00
3065	4	0.00
4154	4	0.00
2883	4	0.00
2885	4	0.00
2886	4	0.00
2887	4	0.00
4459	4	0.00
2888	4	0.00
2891	4	0.00
2893	4	0.00
2894	4	0.00
2895	4	0.00
2898	4	0.00
2899	4	0.00
2900	4	0.00
2906	4	0.00
2907	4	0.00
2908	4	0.00
3113	4	0.00
3114	4	0.00
3115	4	0.00
3247	4	0.00
3296	4	0.00
3318	4	0.00
3319	4	0.00
3320	4	0.00
3321	4	0.00
3335	4	0.00
3336	4	0.00
3344	4	0.00
3547	4	0.00
3548	4	0.00
3549	4	0.00
2884	4	0.00
2964	4	0.00
3143	4	0.00
3357	4	0.00
3672	4	0.00
3811	4	0.00
3696	4	0.00
4387	4	0.00
3851	4	0.00
4070	4	0.00
4071	4	0.00
4388	4	0.00
3334	4	0.00
3775	4	0.00
3776	4	0.00
3777	4	0.00
2923	4	0.00
2924	4	0.00
4471	4	0.00
2925	4	0.00
2950	4	0.00
2951	4	0.00
2966	4	0.00
2976	4	0.00
2987	4	0.00
2991	4	0.00
2992	4	0.00
2993	4	0.00
3038	4	0.00
3180	4	0.00
3348	4	0.00
3395	4	0.00
3400	4	0.00
3905	4	0.00
3519	4	0.00
3527	4	0.00
4117	4	0.00
3631	4	0.00
3465	4	0.00
3774	4	0.00
3815	4	0.00
3816	4	0.00
4000	4	0.00
4162	4	0.00
3167	4	0.00
3796	4	0.00
4104	4	0.00
3890	4	0.00
4046	4	0.00
4413	4	0.00
2929	4	0.00
2930	4	0.00
2932	4	0.00
2934	4	0.00
2935	4	0.00
2971	4	0.00
4517	4	0.00
4527	4	0.00
4516	4	0.00
4518	4	0.00
4521	4	0.00
4522	4	0.00
4523	4	0.00
4524	4	0.00
4526	4	0.00
4520	4	0.00
3760	4	0.00
3761	4	0.00
3755	4	0.00
3055	4	0.00
3411	4	0.00
3457	4	0.00
3790	4	0.00
3508	4	0.00
3845	4	0.00
2972	4	0.00
2973	4	0.00
3894	4	0.00
3127	4	0.00
3152	4	0.00
3153	4	0.00
3154	4	0.00
3155	4	0.00
3156	4	0.00
3157	4	0.00
3175	4	0.00
3176	4	0.00
3177	4	0.00
3190	4	0.00
3311	4	0.00
3896	4	0.00
3897	4	0.00
3370	4	0.00
3966	4	0.00
3967	4	0.00
4005	4	0.00
3391	4	0.00
4021	4	0.00
4023	4	0.00
3393	4	0.00
4047	4	0.00
3898	4	0.00
4130	4	0.00
4132	4	0.00
3404	4	0.00
4379	4	0.00
3432	4	0.00
4410	4	0.00
3483	4	0.00
4423	4	0.00
4424	4	0.00
4430	4	0.00
3592	4	0.00
3593	4	0.00
3594	4	0.00
4131	4	0.00
2933	4	0.00
3329	4	0.00
4509	4	0.00
3822	4	0.00
3823	4	0.00
3824	4	0.00
3889	4	0.00
4158	4	0.00
4159	4	0.00
4440	4	0.00
4441	4	0.00
4442	4	0.00
4443	4	0.00
4444	4	0.00
4445	4	0.00
4446	4	0.00
4478	4	0.00
4485	4	0.00
4447	4	0.00
3895	4	0.00
4439	4	0.00
2949	4	0.00
2840	4	0.00
3116	4	0.00
3117	4	0.00
3187	4	0.00
2963	4	0.00
3405	4	0.00
3585	4	0.00
3225	4	0.00
4458	4	0.00
4484	4	0.00
4494	4	0.00
3203	4	0.00
4286	4	0.00
3510	4	0.00
3625	4	0.00
3361	4	0.00
3369	4	0.00
3630	4	0.00
4541	4	0.00
3665	4	0.00
4351	4	0.00
4036	4	0.00
4380	4	0.00
4419	4	0.00
3879	4	0.00
3904	4	0.00
3424	4	0.00
3447	4	0.00
4054	4	0.00
3789	4	0.00
3567	4	0.00
3396	4	0.00
3443	4	0.00
3568	4	0.00
3680	4	0.00
3678	4	0.00
3727	4	0.00
4349	4	0.00
3992	4	0.00
3993	4	0.00
4063	4	0.00
4115	4	0.00
4542	4	0.00
4543	4	0.00
4544	4	0.00
4545	4	0.00
4548	4	0.00
4407	4	0.00
3440	4	0.00
3683	4	0.00
4359	4	0.00
3891	4	0.00
3962	4	0.00
4177	4	0.00
4381	4	0.00
3875	4	0.00
4301	4	0.00
3437	4	0.00
3436	4	0.00
3866	4	0.00
3881	4	0.00
3882	4	0.00
3909	4	0.00
3964	4	0.00
3978	4	0.00
4042	4	0.00
4169	4	0.00
4416	4	0.00
4316	4	0.00
4044	4	0.00
4152	4	0.00
4399	4	0.00
4426	4	0.00
3768	4	0.00
3771	4	0.00
3772	4	0.00
3148	4	0.00
3279	4	0.00
3416	4	0.00
3624	4	0.00
3805	4	0.00
3883	4	0.00
4077	4	0.00
4337	4	0.00
3860	4	0.00
3949	4	0.00
3999	4	0.00
4048	4	0.00
4049	4	0.00
4084	4	0.00
4167	4	0.00
4172	4	0.00
4173	4	0.00
4339	4	0.00
3388	4	0.00
3392	4	0.00
3474	4	0.00
3479	4	0.00
3480	4	0.00
3636	4	0.00
3179	4	0.00
3368	4	0.00
3386	4	0.00
3389	4	0.00
3390	4	0.00
3385	4	0.00
3387	4	0.00
3753	4	0.00
3844	4	0.00
4347	4	0.00
4092	4	0.00
4094	4	0.00
4095	4	0.00
4096	4	0.00
4145	4	0.00
4147	4	0.00
4081	4	0.00
4122	4	0.00
4176	4	0.00
4408	4	0.00
3995	4	0.00
3997	4	0.00
4343	4	0.00
3398	4	0.00
3493	4	0.00
4326	4	0.00
4332	4	0.00
3677	4	0.00
3572	4	0.00
3793	4	0.00
3812	4	0.00
3873	4	0.00
3902	4	0.00
3903	4	0.00
3912	4	0.00
3976	4	0.00
4039	4	0.00
4476	4	0.00
4506	4	0.00
3554	4	0.00
4062	4	0.00
4174	4	0.00
3516	4	0.00
3529	4	0.00
4313	4	0.00
4055	4	0.00
3920	4	0.00
3921	4	0.00
3950	4	0.00
4008	4	0.00
3580	4	0.00
4059	4	0.00
3939	4	0.00
4433	4	0.00
4057	4	0.00
3780	4	0.00
3783	4	0.00
3619	4	0.00
4335	4	0.00
4215	4	0.00
4217	4	0.00
4218	4	0.00
4219	4	0.00
4220	4	0.00
4216	4	0.00
4208	4	0.00
4225	4	0.00
4228	4	0.00
4231	4	0.00
4232	4	0.00
4234	4	0.00
4236	4	0.00
4235	4	0.00
4089	4	0.00
4093	4	0.00
4103	4	0.00
4170	4	0.00
2850	4	0.00
4561	4	0.00
4564	4	0.00
4568	4	0.00
4569	4	0.00
4560	4	0.00
4434	4	0.00
4230	4	0.00
4211	4	0.00
3252	4	0.00
3258	4	0.00
4553	4	0.00
3825	4	0.00
2896	4	0.00
4238	4	0.00
2903	4	0.00
3586	4	0.00
4237	4	0.00
4204	4	0.00
3364	4	0.00
2890	4	0.00
3227	4	0.00
2961	4	0.00
3139	4	0.00
3451	4	0.00
3456	4	0.00
2892	4	0.00
4240	4	0.00
3535	4	0.00
3937	4	0.00
2889	4	0.00
4207	4	0.00
4004	4	0.00
4002	4	0.00
3969	4	0.00
4003	4	0.00
3001	4	0.00
4431	4	0.00
4540	4	0.00
4474	4	0.00
4538	4	0.00
4389	4	0.00
4193	4	0.00
3664	4	0.00
4500	4	0.00
3256	4	0.00
4179	4	0.00
4180	4	0.00
3872	4	0.00
4233	4	0.00
4539	4	0.00
3224	4	0.00
3294	4	0.00
3439	4	0.00
3438	4	0.00
4185	4	0.00
4184	4	0.00
4203	4	0.00
4244	4	0.00
4197	4	0.00
2842	4	0.00
3328	4	0.00
3431	4	0.00
3144	4	0.00
3450	4	0.00
3826	4	0.00
3449	4	0.00
3261	4	0.00
3423	4	0.00
3239	4	0.00
3254	4	0.00
3710	4	0.00
3878	4	0.00
3067	4	0.00
3640	4	0.00
3068	4	0.00
4113	4	0.00
2880	4	0.00
3477	4	0.00
3754	4	0.00
4134	4	0.00
3159	4	0.00
2836	4	0.00
3339	4	0.00
4330	4	0.00
3347	4	0.00
3012	4	0.00
3003	4	0.00
2852	4	0.00
4366	4	0.00
4186	4	0.00
4183	4	0.00
2841	4	0.00
2843	4	0.00
4148	4	0.00
4549	4	0.00
4194	4	0.00
4106	4	0.00
3470	4	0.00
4192	4	0.00
4188	4	0.00
4187	4	0.00
4011	4	0.00
4503	4	0.00
4030	4	0.00
2905	4	0.00
4191	4	0.00
4190	4	0.00
4178	4	0.00
4559	4	0.00
4556	4	0.00
4202	4	0.00
4199	4	0.00
4198	4	0.00
4530	4	0.00
4566	4	0.00
4562	4	0.00
4563	4	0.00
4565	4	0.00
4554	4	0.00
4555	4	0.00
4528	4	0.00
4189	4	0.00
4529	4	0.00
4567	4	0.00
4241	4	0.00
4550	5	0.00
4270	5	0.00
2997	5	0.00
3212	5	0.00
3280	5	0.00
3681	5	0.00
4212	5	0.00
2922	5	0.00
2986	5	0.00
2912	5	0.00
4250	5	0.00
3297	5	0.00
4088	5	0.00
3420	5	0.00
4340	5	0.00
4310	5	0.00
4124	5	0.00
4125	5	0.00
3907	5	0.00
3908	5	0.00
3914	5	0.00
3915	5	0.00
3916	5	0.00
3917	5	0.00
4116	5	0.00
4165	5	0.00
4429	5	0.00
3906	5	0.00
2941	5	0.00
3165	5	0.00
3166	5	0.00
3353	5	0.00
3442	5	0.00
3241	5	0.00
2942	5	0.00
4019	5	0.00
2953	5	0.00
3033	5	0.00
3358	5	0.00
3371	5	0.00
3061	5	0.00
3200	5	0.00
3201	5	0.00
3350	5	0.00
3652	5	0.00
4256	5	0.00
3058	5	0.00
3184	5	0.00
3198	5	0.00
3229	5	0.00
3326	5	0.00
3307	5	0.00
4421	5	0.00
2817	5	0.00
3064	5	0.00
2980	5	0.00
2823	5	0.00
3310	5	0.00
2822	5	0.00
2824	5	0.00
2825	5	0.00
2826	5	0.00
2827	5	0.00
2828	5	0.00
2829	5	0.00
2830	5	0.00
2839	5	0.00
2854	5	0.00
2856	5	0.00
2863	5	0.00
2870	5	0.00
2872	5	0.00
2873	5	0.00
2874	5	0.00
2878	5	0.00
2917	5	0.00
2957	5	0.00
4252	5	0.00
3002	5	0.00
3030	5	0.00
3105	5	0.00
3106	5	0.00
3107	5	0.00
3108	5	0.00
3142	5	0.00
3174	5	0.00
3193	5	0.00
3259	5	0.00
3322	5	0.00
3323	5	0.00
4305	5	0.00
4345	5	0.00
3523	5	0.00
3615	5	0.00
3626	5	0.00
2916	5	0.00
2948	5	0.00
3583	5	0.00
3584	5	0.00
3711	5	0.00
3864	5	0.00
3843	5	0.00
3699	5	0.00
4501	5	0.00
3461	5	0.00
3855	5	0.00
2845	5	0.00
2847	5	0.00
2848	5	0.00
2931	5	0.00
2960	5	0.00
2962	5	0.00
2988	5	0.00
2989	5	0.00
2990	5	0.00
3018	5	0.00
3056	5	0.00
3057	5	0.00
3087	5	0.00
3111	5	0.00
3112	5	0.00
3121	5	0.00
3122	5	0.00
3150	5	0.00
3197	5	0.00
3214	5	0.00
3215	5	0.00
3216	5	0.00
3217	5	0.00
3218	5	0.00
3219	5	0.00
3248	5	0.00
3249	5	0.00
4282	5	0.00
3260	5	0.00
3265	5	0.00
3283	5	0.00
3349	5	0.00
4292	5	0.00
3373	5	0.00
4010	5	0.00
3426	5	0.00
3481	5	0.00
3488	5	0.00
3489	5	0.00
4308	5	0.00
3490	5	0.00
3491	5	0.00
3520	5	0.00
3791	5	0.00
4312	5	0.00
3616	5	0.00
3617	5	0.00
4323	5	0.00
3632	5	0.00
4329	5	0.00
2831	5	0.00
3667	5	0.00
3670	5	0.00
2846	5	0.00
3257	5	0.00
3550	5	0.00
3747	5	0.00
3830	5	0.00
3694	5	0.00
3706	5	0.00
4150	5	0.00
4473	5	0.00
4477	5	0.00
3149	5	0.00
3151	5	0.00
3910	5	0.00
2853	5	0.00
3525	5	0.00
3773	5	0.00
3019	5	0.00
2999	5	0.00
3000	5	0.00
3172	5	0.00
3173	5	0.00
2996	5	0.00
3230	5	0.00
2998	5	0.00
3410	5	0.00
2861	5	0.00
2915	5	0.00
2918	5	0.00
2921	5	0.00
2983	5	0.00
3471	5	0.00
3473	5	0.00
3561	5	0.00
3782	5	0.00
2952	5	0.00
2984	5	0.00
3654	5	0.00
4374	5	0.00
2871	5	0.00
2876	5	0.00
4291	5	0.00
3767	5	0.00
4290	5	0.00
4333	5	0.00
3804	5	0.00
4121	5	0.00
3948	5	0.00
4153	5	0.00
4511	5	0.00
3205	5	0.00
4348	5	0.00
3762	5	0.00
2985	5	0.00
3160	5	0.00
3181	5	0.00
3380	5	0.00
3381	5	0.00
3537	5	0.00
3544	5	0.00
3589	5	0.00
3634	5	0.00
3213	5	0.00
3228	5	0.00
3472	5	0.00
3463	5	0.00
3689	5	0.00
3690	5	0.00
4239	5	0.00
4041	5	0.00
4038	5	0.00
3691	5	0.00
3817	5	0.00
4064	5	0.00
3408	5	0.00
3429	5	0.00
3475	5	0.00
3476	5	0.00
4306	5	0.00
4376	5	0.00
2936	5	0.00
2937	5	0.00
2938	5	0.00
3769	5	0.00
3242	5	0.00
4327	5	0.00
3377	5	0.00
4498	5	0.00
4508	5	0.00
3460	5	0.00
4272	5	0.00
4354	5	0.00
4486	5	0.00
4502	5	0.00
2969	5	0.00
4531	5	0.00
2994	5	0.00
2927	5	0.00
3382	5	0.00
3521	5	0.00
3522	5	0.00
3820	5	0.00
3363	5	0.00
4085	5	0.00
4020	5	0.00
3781	5	0.00
3679	5	0.00
4334	5	0.00
3146	5	0.00
3924	5	0.00
4090	5	0.00
3829	5	0.00
3885	5	0.00
4001	5	0.00
4091	5	0.00
4168	5	0.00
4451	5	0.00
3900	5	0.00
4102	5	0.00
4342	5	0.00
3327	5	0.00
3570	5	0.00
4105	5	0.00
3833	5	0.00
3834	5	0.00
3977	5	0.00
4383	5	0.00
4465	5	0.00
4466	5	0.00
4467	5	0.00
3752	5	0.00
4253	5	0.00
4259	5	0.00
3210	5	0.00
3244	5	0.00
4328	5	0.00
3208	5	0.00
3854	5	0.00
3985	5	0.00
4143	5	0.00
3831	5	0.00
3923	5	0.00
3940	5	0.00
3941	5	0.00
3943	5	0.00
3944	5	0.00
3955	5	0.00
3988	5	0.00
3990	5	0.00
4432	5	0.00
3025	5	0.00
3250	5	0.00
4303	5	0.00
3901	5	0.00
3982	5	0.00
4427	5	0.00
4428	5	0.00
3109	5	0.00
3110	5	0.00
3158	5	0.00
3171	5	0.00
3202	5	0.00
3262	5	0.00
3359	5	0.00
3366	5	0.00
3394	5	0.00
3402	5	0.00
3494	5	0.00
3495	5	0.00
3542	5	0.00
3590	5	0.00
3245	5	0.00
3496	5	0.00
3692	5	0.00
3899	5	0.00
3994	5	0.00
4099	5	0.00
4149	5	0.00
4157	5	0.00
4460	5	0.00
3504	5	0.00
3505	5	0.00
3887	5	0.00
4013	5	0.00
3712	5	0.00
3713	5	0.00
3714	5	0.00
3417	5	0.00
2926	5	0.00
2974	5	0.00
2978	5	0.00
2981	5	0.00
3118	5	0.00
3168	5	0.00
3183	5	0.00
3223	5	0.00
3266	5	0.00
3267	5	0.00
4293	5	0.00
3354	5	0.00
3383	5	0.00
3384	5	0.00
3409	5	0.00
3497	5	0.00
3499	5	0.00
3500	5	0.00
3502	5	0.00
3503	5	0.00
3506	5	0.00
3507	5	0.00
3573	5	0.00
2877	5	0.00
3189	5	0.00
3246	5	0.00
3498	5	0.00
3662	5	0.00
3663	5	0.00
3892	5	0.00
4028	5	0.00
3693	5	0.00
3695	5	0.00
3818	5	0.00
3819	5	0.00
3877	5	0.00
3986	5	0.00
4098	5	0.00
4479	5	0.00
4480	5	0.00
4481	5	0.00
3469	5	0.00
4265	5	0.00
3170	5	0.00
3178	5	0.00
3196	5	0.00
3427	5	0.00
3428	5	0.00
3466	5	0.00
3467	5	0.00
3468	5	0.00
4118	5	0.00
3591	5	0.00
3169	5	0.00
3464	5	0.00
3794	5	0.00
4375	5	0.00
2919	5	0.00
2928	5	0.00
2995	5	0.00
3367	5	0.00
3372	5	0.00
3407	5	0.00
3430	5	0.00
3786	5	0.00
3838	5	0.00
3686	5	0.00
2869	5	0.00
3501	5	0.00
3797	5	0.00
3821	5	0.00
3837	5	0.00
3888	5	0.00
3911	5	0.00
3989	5	0.00
4065	5	0.00
4100	5	0.00
4163	5	0.00
4009	5	0.00
4390	5	0.00
4249	5	0.00
4325	5	0.00
3011	5	0.00
3668	5	0.00
3778	5	0.00
4507	5	0.00
2982	5	0.00
3053	5	0.00
3119	5	0.00
3728	5	0.00
3729	5	0.00
3633	5	0.00
3756	5	0.00
4344	5	0.00
3102	5	0.00
3125	5	0.00
3129	5	0.00
3185	5	0.00
3195	5	0.00
3238	5	0.00
3333	5	0.00
3337	5	0.00
3338	5	0.00
3351	5	0.00
4294	5	0.00
3375	5	0.00
3446	5	0.00
3458	5	0.00
3653	5	0.00
3970	5	0.00
3828	5	0.00
3849	5	0.00
3922	5	0.00
3951	5	0.00
3953	5	0.00
3954	5	0.00
3956	5	0.00
3957	5	0.00
3958	5	0.00
3960	5	0.00
3961	5	0.00
4457	5	0.00
4472	5	0.00
3952	5	0.00
2879	5	0.00
4251	5	0.00
3010	5	0.00
3124	5	0.00
3126	5	0.00
3128	5	0.00
3132	5	0.00
3282	5	0.00
3526	5	0.00
4315	5	0.00
3669	5	0.00
2975	5	0.00
3243	5	0.00
4360	5	0.00
3926	5	0.00
4361	5	0.00
3927	5	0.00
3928	5	0.00
3929	5	0.00
3931	5	0.00
3933	5	0.00
4362	5	0.00
3935	5	0.00
3936	5	0.00
3945	5	0.00
3946	5	0.00
3947	5	0.00
4406	5	0.00
3346	5	0.00
3932	5	0.00
3719	5	0.00
3720	5	0.00
3704	5	0.00
3721	5	0.00
3732	5	0.00
3733	5	0.00
3734	5	0.00
3735	5	0.00
3737	5	0.00
3738	5	0.00
3739	5	0.00
3741	5	0.00
3742	5	0.00
2858	5	0.00
2859	5	0.00
2865	5	0.00
2866	5	0.00
2867	5	0.00
2868	5	0.00
2881	5	0.00
2909	5	0.00
2910	5	0.00
2911	5	0.00
2920	5	0.00
2947	5	0.00
3020	5	0.00
3021	5	0.00
3022	5	0.00
3028	5	0.00
3029	5	0.00
3034	5	0.00
3035	5	0.00
3036	5	0.00
3037	5	0.00
3073	5	0.00
3074	5	0.00
3075	5	0.00
3076	5	0.00
3077	5	0.00
3078	5	0.00
3079	5	0.00
3080	5	0.00
3081	5	0.00
3082	5	0.00
3083	5	0.00
3084	5	0.00
3088	5	0.00
3141	5	0.00
3232	5	0.00
3233	5	0.00
3234	5	0.00
3277	5	0.00
3278	5	0.00
3448	5	0.00
3511	5	0.00
3512	5	0.00
3513	5	0.00
3587	5	0.00
3600	5	0.00
3601	5	0.00
3602	5	0.00
3604	5	0.00
3605	5	0.00
3606	5	0.00
3607	5	0.00
3608	5	0.00
3609	5	0.00
3611	5	0.00
3622	5	0.00
3645	5	0.00
3646	5	0.00
3647	5	0.00
3649	5	0.00
3650	5	0.00
3840	5	0.00
3026	5	0.00
3044	5	0.00
3045	5	0.00
3046	5	0.00
3047	5	0.00
3027	5	0.00
3072	5	0.00
3235	5	0.00
3514	5	0.00
3612	5	0.00
3620	5	0.00
3603	5	0.00
3621	5	0.00
3718	5	0.00
3736	5	0.00
3730	5	0.00
3731	5	0.00
3839	5	0.00
4395	5	0.00
4396	5	0.00
4397	5	0.00
4398	5	0.00
3013	5	0.00
3135	5	0.00
3136	5	0.00
3138	5	0.00
3140	5	0.00
3276	5	0.00
3597	5	0.00
3598	5	0.00
3599	5	0.00
3641	5	0.00
3642	5	0.00
3643	5	0.00
3644	5	0.00
2857	5	0.00
2860	5	0.00
2914	5	0.00
2955	5	0.00
3137	5	0.00
3610	5	0.00
3722	5	0.00
3723	5	0.00
3724	5	0.00
3725	5	0.00
3841	5	0.00
3842	5	0.00
4393	5	0.00
4394	5	0.00
3657	5	0.00
3766	5	0.00
2943	5	0.00
2944	5	0.00
2945	5	0.00
2958	5	0.00
2959	5	0.00
4255	5	0.00
3039	5	0.00
3040	5	0.00
3041	5	0.00
3043	5	0.00
4261	5	0.00
4262	5	0.00
4263	5	0.00
4264	5	0.00
4269	5	0.00
3130	5	0.00
4127	5	0.00
4276	5	0.00
3220	5	0.00
3221	5	0.00
3231	5	0.00
3236	5	0.00
3237	5	0.00
3286	5	0.00
3287	5	0.00
3288	5	0.00
3289	5	0.00
3290	5	0.00
3291	5	0.00
3292	5	0.00
3293	5	0.00
4285	5	0.00
3298	5	0.00
3360	5	0.00
3379	5	0.00
4295	5	0.00
4296	5	0.00
3401	5	0.00
3406	5	0.00
3412	5	0.00
3486	5	0.00
3788	5	0.00
4311	5	0.00
3555	5	0.00
3556	5	0.00
3557	5	0.00
3577	5	0.00
3613	5	0.00
3648	5	0.00
3651	5	0.00
3676	5	0.00
3302	5	0.00
3435	5	0.00
3452	5	0.00
3453	5	0.00
3454	5	0.00
3455	5	0.00
3566	5	0.00
3779	5	0.00
4126	5	0.00
3983	5	0.00
4018	5	0.00
3798	5	0.00
4338	5	0.00
4087	5	0.00
4436	5	0.00
3434	5	0.00
3784	5	0.00
2968	5	0.00
3332	5	0.00
3374	5	0.00
4300	5	0.00
3462	5	0.00
3787	5	0.00
3571	5	0.00
3656	5	0.00
3658	5	0.00
3659	5	0.00
3660	5	0.00
3661	5	0.00
3673	5	0.00
3309	5	0.00
3299	5	0.00
3300	5	0.00
3301	5	0.00
3697	5	0.00
4006	5	0.00
4384	5	0.00
4435	5	0.00
2819	5	0.00
2820	5	0.00
4245	5	0.00
2821	5	0.00
4246	5	0.00
2977	5	0.00
4283	5	0.00
3269	5	0.00
3270	5	0.00
3271	5	0.00
3273	5	0.00
3399	5	0.00
3433	5	0.00
3445	5	0.00
4309	5	0.00
3579	5	0.00
3581	5	0.00
2818	5	0.00
3103	5	0.00
3281	5	0.00
3342	5	0.00
3487	5	0.00
4411	5	0.00
4438	5	0.00
4513	5	0.00
4052	5	0.00
3764	5	0.00
3770	5	0.00
2864	5	0.00
2946	5	0.00
2956	5	0.00
2965	5	0.00
3014	5	0.00
3024	5	0.00
3059	5	0.00
4266	5	0.00
3063	5	0.00
3066	5	0.00
4268	5	0.00
4271	5	0.00
3145	5	0.00
3147	5	0.00
3186	5	0.00
3206	5	0.00
4277	5	0.00
4278	5	0.00
3222	5	0.00
4281	5	0.00
3255	5	0.00
4284	5	0.00
4288	5	0.00
3324	5	0.00
3325	5	0.00
3330	5	0.00
3376	5	0.00
3403	5	0.00
4298	5	0.00
3418	5	0.00
4299	5	0.00
3421	5	0.00
3422	5	0.00
3425	5	0.00
4037	5	0.00
3530	5	0.00
3531	5	0.00
3532	5	0.00
3533	5	0.00
4346	5	0.00
3539	5	0.00
3540	5	0.00
3541	5	0.00
3551	5	0.00
3552	5	0.00
3553	5	0.00
4318	5	0.00
4319	5	0.00
3576	5	0.00
3578	5	0.00
3674	5	0.00
3675	5	0.00
2835	5	0.00
2849	5	0.00
3312	5	0.00
4482	5	0.00
4287	5	0.00
3524	5	0.00
3120	5	0.00
3207	5	0.00
3795	5	0.00
3968	5	0.00
3743	5	0.00
4512	5	0.00
3090	5	0.00
3091	5	0.00
3092	5	0.00
3093	5	0.00
3094	5	0.00
3095	5	0.00
3096	5	0.00
3097	5	0.00
3098	5	0.00
3099	5	0.00
3272	5	0.00
3340	5	0.00
4082	5	0.00
3536	5	0.00
3575	5	0.00
2970	5	0.00
3089	5	0.00
4141	5	0.00
3763	5	0.00
3131	5	0.00
3263	5	0.00
3275	5	0.00
3284	5	0.00
3478	5	0.00
3534	5	0.00
3538	5	0.00
3545	5	0.00
3546	5	0.00
3629	5	0.00
3655	5	0.00
3085	5	0.00
3161	5	0.00
3253	5	0.00
3765	5	0.00
3703	5	0.00
3918	5	0.00
4022	5	0.00
2901	5	0.00
3031	5	0.00
3100	5	0.00
3101	5	0.00
3182	5	0.00
4128	5	0.00
3482	5	0.00
2902	5	0.00
3441	5	0.00
3485	5	0.00
3707	5	0.00
4420	5	0.00
4260	5	0.00
3744	5	0.00
3194	5	0.00
2967	5	0.00
3378	5	0.00
3362	5	0.00
3528	5	0.00
4314	5	0.00
4133	5	0.00
4015	5	0.00
4107	5	0.00
3671	5	0.00
4146	5	0.00
3758	5	0.00
3052	5	0.00
3308	5	0.00
3352	5	0.00
4302	5	0.00
3637	5	0.00
4083	5	0.00
4061	5	0.00
3913	5	0.00
4080	5	0.00
4386	5	0.00
3209	5	0.00
3006	5	0.00
4136	5	0.00
4137	5	0.00
3871	5	0.00
4034	5	0.00
3574	5	0.00
3635	5	0.00
3974	5	0.00
4112	5	0.00
2814	5	0.00
2815	5	0.00
4247	5	0.00
4320	5	0.00
3746	5	0.00
4229	5	0.00
4029	5	0.00
3801	5	0.00
3314	5	0.00
3315	5	0.00
3558	5	0.00
4336	5	0.00
4355	5	0.00
4496	5	0.00
4497	5	0.00
4258	5	0.00
4060	5	0.00
4067	5	0.00
4119	5	0.00
2838	5	0.00
4341	5	0.00
4356	5	0.00
4487	5	0.00
4492	5	0.00
3627	5	0.00
3628	5	0.00
3808	5	0.00
3814	5	0.00
4280	5	0.00
3836	5	0.00
3835	5	0.00
3850	5	0.00
3226	5	0.00
2940	5	0.00
3518	5	0.00
3413	5	0.00
3886	5	0.00
4463	5	0.00
4350	5	0.00
3623	5	0.00
4304	5	0.00
3365	5	0.00
3740	5	0.00
4114	5	0.00
4026	5	0.00
4053	5	0.00
4353	5	0.00
4056	5	0.00
4372	5	0.00
4120	5	0.00
4437	5	0.00
4475	5	0.00
4510	5	0.00
2913	5	0.00
4321	5	0.00
2816	5	0.00
3700	5	0.00
4155	5	0.00
4495	5	0.00
3562	5	0.00
3005	5	0.00
3543	5	0.00
4493	5	0.00
4499	5	0.00
3009	5	0.00
3069	5	0.00
3133	5	0.00
3134	5	0.00
4297	5	0.00
3444	5	0.00
3459	5	0.00
3638	5	0.00
4324	5	0.00
3639	5	0.00
3304	5	0.00
3987	5	0.00
4024	5	0.00
4078	5	0.00
3867	5	0.00
3963	5	0.00
4045	5	0.00
4058	5	0.00
4358	5	0.00
4073	5	0.00
4074	5	0.00
4075	5	0.00
4076	5	0.00
4108	5	0.00
4109	5	0.00
4110	5	0.00
4111	5	0.00
4142	5	0.00
4412	5	0.00
4418	5	0.00
3832	5	0.00
3596	5	0.00
3305	5	0.00
3316	5	0.00
3698	5	0.00
3702	5	0.00
3715	5	0.00
3716	5	0.00
3717	5	0.00
3745	5	0.00
3748	5	0.00
3749	5	0.00
4050	5	0.00
4400	5	0.00
4417	5	0.00
4462	5	0.00
4464	5	0.00
4468	5	0.00
4483	5	0.00
4519	5	0.00
3847	5	0.00
3356	5	0.00
3925	5	0.00
4129	5	0.00
4139	5	0.00
4016	5	0.00
4068	5	0.00
4069	5	0.00
4140	5	0.00
4425	5	0.00
3846	5	0.00
3397	5	0.00
3515	5	0.00
3980	5	0.00
3981	5	0.00
3934	5	0.00
3809	5	0.00
3876	5	0.00
4248	5	0.00
3188	5	0.00
3199	5	0.00
4307	5	0.00
4161	5	0.00
3688	5	0.00
3938	5	0.00
4470	5	0.00
3492	5	0.00
3560	5	0.00
3564	5	0.00
3942	5	0.00
4317	5	0.00
3792	5	0.00
3211	5	0.00
3869	5	0.00
3803	5	0.00
3813	5	0.00
3874	5	0.00
4357	5	0.00
3919	5	0.00
3975	5	0.00
4027	5	0.00
3959	5	0.00
4051	5	0.00
4072	5	0.00
4402	5	0.00
4363	5	0.00
4415	5	0.00
4456	5	0.00
4469	5	0.00
4525	5	0.00
3759	5	0.00
3802	5	0.00
3264	5	0.00
3268	5	0.00
3313	5	0.00
4033	5	0.00
3559	5	0.00
3563	5	0.00
4322	5	0.00
3682	5	0.00
3800	5	0.00
3868	5	0.00
4032	5	0.00
4160	5	0.00
3984	5	0.00
4364	5	0.00
4365	5	0.00
3857	5	0.00
3858	5	0.00
3870	5	0.00
3971	5	0.00
3991	5	0.00
3972	5	0.00
4367	5	0.00
4368	5	0.00
4031	5	0.00
4035	5	0.00
4151	5	0.00
4164	5	0.00
4401	5	0.00
4461	5	0.00
2837	5	0.00
4273	5	0.00
3996	5	0.00
3331	5	0.00
2979	5	0.00
3274	5	0.00
3979	5	0.00
3240	5	0.00
2862	5	0.00
3004	5	0.00
3007	5	0.00
3062	5	0.00
3204	5	0.00
4279	5	0.00
3973	5	0.00
4123	5	0.00
3565	5	0.00
3618	5	0.00
4331	5	0.00
3687	5	0.00
3049	5	0.00
3050	5	0.00
3060	5	0.00
3306	5	0.00
4007	5	0.00
4025	5	0.00
3509	5	0.00
3595	5	0.00
3726	5	0.00
3751	5	0.00
3856	5	0.00
4369	5	0.00
3861	5	0.00
4352	5	0.00
4086	5	0.00
4409	5	0.00
4040	5	0.00
4370	5	0.00
4449	5	0.00
4450	5	0.00
4452	5	0.00
4453	5	0.00
4371	5	0.00
4454	5	0.00
4455	5	0.00
3865	5	0.00
4515	5	0.00
4066	5	0.00
3785	5	0.00
3104	5	0.00
3163	5	0.00
3251	5	0.00
4289	5	0.00
3848	5	0.00
3414	5	0.00
3484	5	0.00
3023	5	0.00
3685	5	0.00
3806	5	0.00
3810	5	0.00
3880	5	0.00
3965	5	0.00
4012	5	0.00
4101	5	0.00
4175	5	0.00
3807	5	0.00
3853	5	0.00
3859	5	0.00
3863	5	0.00
4014	5	0.00
4043	5	0.00
4166	5	0.00
4382	5	0.00
4385	5	0.00
4079	5	0.00
4373	5	0.00
4391	5	0.00
4392	5	0.00
4414	5	0.00
4448	5	0.00
4504	5	0.00
4505	5	0.00
3799	5	0.00
2832	5	0.00
2833	5	0.00
2834	5	0.00
2844	5	0.00
2904	5	0.00
2939	5	0.00
3008	5	0.00
3042	5	0.00
4267	5	0.00
3341	5	0.00
3343	5	0.00
3419	5	0.00
3666	5	0.00
3827	5	0.00
3852	5	0.00
3517	5	0.00
3750	5	0.00
4135	5	0.00
4138	5	0.00
4156	5	0.00
4171	5	0.00
3998	5	0.00
4377	5	0.00
4097	5	0.00
4378	5	0.00
4403	5	0.00
4405	5	0.00
4404	5	0.00
4144	5	0.00
4017	5	0.00
4422	5	0.00
4274	5	0.00
3582	5	0.00
3054	5	0.00
3884	5	0.00
3709	5	0.00
2882	5	0.00
3071	5	0.00
3345	5	0.00
3893	5	0.00
3930	5	0.00
2851	5	0.00
4254	5	0.00
4257	5	0.00
3123	5	0.00
3051	5	0.00
3684	5	0.00
3862	5	0.00
4488	5	0.00
4489	5	0.00
4490	5	0.00
4491	5	0.00
4514	5	0.00
2855	5	0.00
2897	5	0.00
3015	5	0.00
3016	5	0.00
3032	5	0.00
3070	5	0.00
3086	5	0.00
3164	5	0.00
3191	5	0.00
3192	5	0.00
4275	5	0.00
3285	5	0.00
3295	5	0.00
3355	5	0.00
3569	5	0.00
3017	5	0.00
3162	5	0.00
3303	5	0.00
3708	5	0.00
3701	5	0.00
3705	5	0.00
3757	5	0.00
2875	5	0.00
2954	5	0.00
3317	5	0.00
3415	5	0.00
3588	5	0.00
3614	5	0.00
3048	5	0.00
3065	5	0.00
4154	5	0.00
2883	5	0.00
2885	5	0.00
2886	5	0.00
2887	5	0.00
4459	5	0.00
2888	5	0.00
2891	5	0.00
2893	5	0.00
2894	5	0.00
2895	5	0.00
2898	5	0.00
2899	5	0.00
2900	5	0.00
2906	5	0.00
2907	5	0.00
2908	5	0.00
3113	5	0.00
3114	5	0.00
3115	5	0.00
3247	5	0.00
3296	5	0.00
3318	5	0.00
3319	5	0.00
3320	5	0.00
3321	5	0.00
3335	5	0.00
3336	5	0.00
3344	5	0.00
3547	5	0.00
3548	5	0.00
3549	5	0.00
2884	5	0.00
2964	5	0.00
3143	5	0.00
3357	5	0.00
3672	5	0.00
3811	5	0.00
3696	5	0.00
4387	5	0.00
3851	5	0.00
4070	5	0.00
4071	5	0.00
4388	5	0.00
3334	5	0.00
3775	5	0.00
3776	5	0.00
3777	5	0.00
2923	5	0.00
2924	5	0.00
4471	5	0.00
2925	5	0.00
2950	5	0.00
2951	5	0.00
2966	5	0.00
2976	5	0.00
2987	5	0.00
2991	5	0.00
2992	5	0.00
2993	5	0.00
3038	5	0.00
3180	5	0.00
3348	5	0.00
3395	5	0.00
3400	5	0.00
3905	5	0.00
3519	5	0.00
3527	5	0.00
4117	5	0.00
3631	5	0.00
3465	5	0.00
3774	5	0.00
3815	5	0.00
3816	5	0.00
4000	5	0.00
4162	5	0.00
3167	5	0.00
3796	5	0.00
4104	5	0.00
3890	5	0.00
4046	5	0.00
4413	5	0.00
2929	5	0.00
2930	5	0.00
2932	5	0.00
2934	5	0.00
2935	5	0.00
2971	5	0.00
4517	5	0.00
4527	5	0.00
4516	5	0.00
4518	5	0.00
4521	5	0.00
4522	5	0.00
4523	5	0.00
4524	5	0.00
4526	5	0.00
4520	5	0.00
3760	5	0.00
3761	5	0.00
3755	5	0.00
3055	5	0.00
3411	5	0.00
3457	5	0.00
3790	5	0.00
3508	5	0.00
3845	5	0.00
2972	5	0.00
2973	5	0.00
3894	5	0.00
3127	5	0.00
3152	5	0.00
3153	5	0.00
3154	5	0.00
3155	5	0.00
3156	5	0.00
3157	5	0.00
3175	5	0.00
3176	5	0.00
3177	5	0.00
3190	5	0.00
3311	5	0.00
3896	5	0.00
3897	5	0.00
3370	5	0.00
3966	5	0.00
3967	5	0.00
4005	5	0.00
3391	5	0.00
4021	5	0.00
4023	5	0.00
3393	5	0.00
4047	5	0.00
3898	5	0.00
4130	5	0.00
4132	5	0.00
3404	5	0.00
4379	5	0.00
3432	5	0.00
4410	5	0.00
3483	5	0.00
4423	5	0.00
4424	5	0.00
4430	5	0.00
3592	5	0.00
3593	5	0.00
3594	5	0.00
4131	5	0.00
2933	5	0.00
3329	5	0.00
4509	5	0.00
3822	5	0.00
3823	5	0.00
3824	5	0.00
3889	5	0.00
4158	5	0.00
4159	5	0.00
4440	5	0.00
4441	5	0.00
4442	5	0.00
4443	5	0.00
4444	5	0.00
4445	5	0.00
4446	5	0.00
4478	5	0.00
4485	5	0.00
4447	5	0.00
3895	5	0.00
4439	5	0.00
2949	5	0.00
2840	5	0.00
3116	5	0.00
3117	5	0.00
3187	5	0.00
2963	5	0.00
3405	5	0.00
3585	5	0.00
3225	5	0.00
4458	5	0.00
4484	5	0.00
4494	5	0.00
3203	5	0.00
4286	5	0.00
3510	5	0.00
3625	5	0.00
3361	5	0.00
3369	5	0.00
3630	5	0.00
4541	5	0.00
3665	5	0.00
4351	5	0.00
4036	5	0.00
4380	5	0.00
4419	5	0.00
3879	5	0.00
3904	5	0.00
3424	5	0.00
3447	5	0.00
4054	5	0.00
3789	5	0.00
3567	5	0.00
3396	5	0.00
3443	5	0.00
3568	5	0.00
3680	5	0.00
3678	5	0.00
3727	5	0.00
4349	5	0.00
3992	5	0.00
3993	5	0.00
4063	5	0.00
4115	5	0.00
4542	5	0.00
4543	5	0.00
4544	5	0.00
4545	5	0.00
4548	5	0.00
4407	5	0.00
3440	5	0.00
3683	5	0.00
4359	5	0.00
3891	5	0.00
3962	5	0.00
4177	5	0.00
4381	5	0.00
3875	5	0.00
4301	5	0.00
3437	5	0.00
3436	5	0.00
3866	5	0.00
3881	5	0.00
3882	5	0.00
3909	5	0.00
3964	5	0.00
3978	5	0.00
4042	5	0.00
4169	5	0.00
4416	5	0.00
4316	5	0.00
4044	5	0.00
4152	5	0.00
4399	5	0.00
4426	5	0.00
3768	5	0.00
3771	5	0.00
3772	5	0.00
3148	5	0.00
3279	5	0.00
3416	5	0.00
3624	5	0.00
3805	5	0.00
3883	5	0.00
4077	5	0.00
4337	5	0.00
3860	5	0.00
3949	5	0.00
3999	5	0.00
4048	5	0.00
4049	5	0.00
4084	5	0.00
4167	5	0.00
4172	5	0.00
4173	5	0.00
4339	5	0.00
3388	5	0.00
3392	5	0.00
3474	5	0.00
3479	5	0.00
3480	5	0.00
3636	5	0.00
3179	5	0.00
3368	5	0.00
3386	5	0.00
3389	5	0.00
3390	5	0.00
3385	5	0.00
3387	5	0.00
3753	5	0.00
3844	5	0.00
4347	5	0.00
4092	5	0.00
4094	5	0.00
4095	5	0.00
4096	5	0.00
4145	5	0.00
4147	5	0.00
4081	5	0.00
4122	5	0.00
4176	5	0.00
4408	5	0.00
3995	5	0.00
3997	5	0.00
4343	5	0.00
3398	5	0.00
3493	5	0.00
4326	5	0.00
4332	5	0.00
3677	5	0.00
3572	5	0.00
3793	5	0.00
3812	5	0.00
3873	5	0.00
3902	5	0.00
3903	5	0.00
3912	5	0.00
3976	5	0.00
4039	5	0.00
4476	5	0.00
4506	5	0.00
3554	5	0.00
4062	5	0.00
4174	5	0.00
3516	5	0.00
3529	5	0.00
4313	5	0.00
4055	5	0.00
3920	5	0.00
3921	5	0.00
3950	5	0.00
4008	5	0.00
3580	5	0.00
4059	5	0.00
3939	5	0.00
4433	5	0.00
4057	5	0.00
3780	5	0.00
3783	5	0.00
3619	5	0.00
4335	5	0.00
4215	5	0.00
4217	5	0.00
4218	5	0.00
4219	5	0.00
4220	5	0.00
4216	5	0.00
4208	5	0.00
4225	5	0.00
4228	5	0.00
4231	5	0.00
4232	5	0.00
4234	5	0.00
4236	5	0.00
4235	5	0.00
4089	5	0.00
4093	5	0.00
4103	5	0.00
4170	5	0.00
2850	5	0.00
4561	5	0.00
4564	5	0.00
4568	5	0.00
4569	5	0.00
4560	5	0.00
4434	5	0.00
4230	5	0.00
4211	5	0.00
3252	5	0.00
3258	5	0.00
4553	5	0.00
3825	5	0.00
2896	5	0.00
4238	5	0.00
2903	5	0.00
3586	5	0.00
4237	5	0.00
4204	5	0.00
3364	5	0.00
2890	5	0.00
3227	5	0.00
2961	5	0.00
3139	5	0.00
3451	5	0.00
3456	5	0.00
2892	5	0.00
4240	5	0.00
3535	5	0.00
3937	5	0.00
2889	5	0.00
4207	5	0.00
4004	5	0.00
4002	5	0.00
3969	5	0.00
4003	5	0.00
3001	5	0.00
4431	5	0.00
4540	5	0.00
4474	5	0.00
4538	5	0.00
4389	5	0.00
4193	5	0.00
3664	5	0.00
4500	5	0.00
3256	5	0.00
4179	5	0.00
4180	5	0.00
3872	5	0.00
4233	5	0.00
4539	5	0.00
3224	5	0.00
3294	5	0.00
3439	5	0.00
3438	5	0.00
4185	5	0.00
4184	5	0.00
4203	5	0.00
4244	5	0.00
4197	5	0.00
2842	5	0.00
3328	5	0.00
3431	5	0.00
3144	5	0.00
3450	5	0.00
3826	5	0.00
3449	5	0.00
3261	5	0.00
3423	5	0.00
3239	5	0.00
3254	5	0.00
3710	5	0.00
3878	5	0.00
3067	5	0.00
3640	5	0.00
3068	5	0.00
4113	5	0.00
2880	5	0.00
3477	5	0.00
3754	5	0.00
4134	5	0.00
3159	5	0.00
2836	5	0.00
3339	5	0.00
4330	5	0.00
3347	5	0.00
3012	5	0.00
3003	5	0.00
2852	5	0.00
4366	5	0.00
4186	5	0.00
4183	5	0.00
2841	5	0.00
2843	5	0.00
4148	5	0.00
4549	5	0.00
4194	5	0.00
4106	5	0.00
3470	5	0.00
4192	5	0.00
4188	5	0.00
4187	5	0.00
4011	5	0.00
4503	5	0.00
4030	5	0.00
2905	5	0.00
4191	5	0.00
4190	5	0.00
4178	5	0.00
4559	5	0.00
4556	5	0.00
4202	5	0.00
4199	5	0.00
4198	5	0.00
4530	5	0.00
4566	5	0.00
4562	5	0.00
4563	5	0.00
4565	5	0.00
4554	5	0.00
4555	5	0.00
4528	5	0.00
4189	5	0.00
4529	5	0.00
4567	5	0.00
4241	5	0.00
4550	6	0.00
4270	6	0.00
2997	6	0.00
3212	6	0.00
3280	6	0.00
3681	6	0.00
4212	6	0.00
2922	6	0.00
2986	6	0.00
2912	6	0.00
4250	6	0.00
3297	6	0.00
4088	6	0.00
3420	6	0.00
4340	6	0.00
4310	6	0.00
4124	6	0.00
4125	6	0.00
3907	6	0.00
3908	6	0.00
3914	6	0.00
3915	6	0.00
3916	6	0.00
3917	6	0.00
4116	6	0.00
4165	6	0.00
4429	6	0.00
3906	6	0.00
2941	6	0.00
3165	6	0.00
3166	6	0.00
3353	6	0.00
3442	6	0.00
3241	6	0.00
2942	6	0.00
4019	6	0.00
2953	6	0.00
3033	6	0.00
3358	6	0.00
3371	6	0.00
3061	6	0.00
3200	6	0.00
3201	6	0.00
3350	6	0.00
3652	6	0.00
4256	6	0.00
3058	6	0.00
3184	6	0.00
3198	6	0.00
3229	6	0.00
3326	6	0.00
3307	6	0.00
4421	6	0.00
2817	6	0.00
3064	6	0.00
2980	6	0.00
2823	6	0.00
3310	6	0.00
2822	6	0.00
2824	6	0.00
2825	6	0.00
2826	6	0.00
2827	6	0.00
2828	6	0.00
2829	6	0.00
2830	6	0.00
2839	6	0.00
2854	6	0.00
2856	6	0.00
2863	6	0.00
2870	6	0.00
2872	6	0.00
2873	6	0.00
2874	6	0.00
2878	6	0.00
2917	6	0.00
2957	6	0.00
4252	6	0.00
3002	6	0.00
3030	6	0.00
3105	6	0.00
3106	6	0.00
3107	6	0.00
3108	6	0.00
3142	6	0.00
3174	6	0.00
3193	6	0.00
3259	6	0.00
3322	6	0.00
3323	6	0.00
4305	6	0.00
4345	6	0.00
3523	6	0.00
3615	6	0.00
3626	6	0.00
2916	6	0.00
2948	6	0.00
3583	6	0.00
3584	6	0.00
3711	6	0.00
3864	6	0.00
3843	6	0.00
3699	6	0.00
4501	6	0.00
3461	6	0.00
3855	6	0.00
2845	6	0.00
2847	6	0.00
2848	6	0.00
2931	6	0.00
2960	6	0.00
2962	6	0.00
2988	6	0.00
2989	6	0.00
2990	6	0.00
3018	6	0.00
3056	6	0.00
3057	6	0.00
3087	6	0.00
3111	6	0.00
3112	6	0.00
3121	6	0.00
3122	6	0.00
3150	6	0.00
3197	6	0.00
3214	6	0.00
3215	6	0.00
3216	6	0.00
3217	6	0.00
3218	6	0.00
3219	6	0.00
3248	6	0.00
3249	6	0.00
4282	6	0.00
3260	6	0.00
3265	6	0.00
3283	6	0.00
3349	6	0.00
4292	6	0.00
3373	6	0.00
4010	6	0.00
3426	6	0.00
3481	6	0.00
3488	6	0.00
3489	6	0.00
4308	6	0.00
3490	6	0.00
3491	6	0.00
3520	6	0.00
3791	6	0.00
4312	6	0.00
3616	6	0.00
3617	6	0.00
4323	6	0.00
3632	6	0.00
4329	6	0.00
2831	6	0.00
3667	6	0.00
3670	6	0.00
2846	6	0.00
3257	6	0.00
3550	6	0.00
3747	6	0.00
3830	6	0.00
3694	6	0.00
3706	6	0.00
4150	6	0.00
4473	6	0.00
4477	6	0.00
3149	6	0.00
3151	6	0.00
3910	6	0.00
2853	6	0.00
3525	6	0.00
3773	6	0.00
3019	6	0.00
2999	6	0.00
3000	6	0.00
3172	6	0.00
3173	6	0.00
2996	6	0.00
3230	6	0.00
2998	6	0.00
3410	6	0.00
2861	6	0.00
2915	6	0.00
2918	6	0.00
2921	6	0.00
2983	6	0.00
3471	6	0.00
3473	6	0.00
3561	6	0.00
3782	6	0.00
2952	6	0.00
2984	6	0.00
3654	6	0.00
4374	6	0.00
2871	6	0.00
2876	6	0.00
4291	6	0.00
3767	6	0.00
4290	6	0.00
4333	6	0.00
3804	6	0.00
4121	6	0.00
3948	6	0.00
4153	6	0.00
4511	6	0.00
3205	6	0.00
4348	6	0.00
3762	6	0.00
2985	6	0.00
3160	6	0.00
3181	6	0.00
3380	6	0.00
3381	6	0.00
3537	6	0.00
3544	6	0.00
3589	6	0.00
3634	6	0.00
3213	6	0.00
3228	6	0.00
3472	6	0.00
3463	6	0.00
3689	6	0.00
3690	6	0.00
4239	6	0.00
4041	6	0.00
4038	6	0.00
3691	6	0.00
3817	6	0.00
4064	6	0.00
3408	6	0.00
3429	6	0.00
3475	6	0.00
3476	6	0.00
4306	6	0.00
4376	6	0.00
2936	6	0.00
2937	6	0.00
2938	6	0.00
3769	6	0.00
3242	6	0.00
4327	6	0.00
3377	6	0.00
4498	6	0.00
4508	6	0.00
3460	6	0.00
4272	6	0.00
4354	6	0.00
4486	6	0.00
4502	6	0.00
2969	6	0.00
4531	6	0.00
2994	6	0.00
2927	6	0.00
3382	6	0.00
3521	6	0.00
3522	6	0.00
3820	6	0.00
3363	6	0.00
4085	6	0.00
4020	6	0.00
3781	6	0.00
3679	6	0.00
4334	6	0.00
3146	6	0.00
3924	6	0.00
4090	6	0.00
3829	6	0.00
3885	6	0.00
4001	6	0.00
4091	6	0.00
4168	6	0.00
4451	6	0.00
3900	6	0.00
4102	6	0.00
4342	6	0.00
3327	6	0.00
3570	6	0.00
4105	6	0.00
3833	6	0.00
3834	6	0.00
3977	6	0.00
4383	6	0.00
4465	6	0.00
4466	6	0.00
4467	6	0.00
3752	6	0.00
4253	6	0.00
4259	6	0.00
3210	6	0.00
3244	6	0.00
4328	6	0.00
3208	6	0.00
3854	6	0.00
3985	6	0.00
4143	6	0.00
3831	6	0.00
3923	6	0.00
3940	6	0.00
3941	6	0.00
3943	6	0.00
3944	6	0.00
3955	6	0.00
3988	6	0.00
3990	6	0.00
4432	6	0.00
3025	6	0.00
3250	6	0.00
4303	6	0.00
3901	6	0.00
3982	6	0.00
4427	6	0.00
4428	6	0.00
3109	6	0.00
3110	6	0.00
3158	6	0.00
3171	6	0.00
3202	6	0.00
3262	6	0.00
3359	6	0.00
3366	6	0.00
3394	6	0.00
3402	6	0.00
3494	6	0.00
3495	6	0.00
3542	6	0.00
3590	6	0.00
3245	6	0.00
3496	6	0.00
3692	6	0.00
3899	6	0.00
3994	6	0.00
4099	6	0.00
4149	6	0.00
4157	6	0.00
4460	6	0.00
3504	6	0.00
3505	6	0.00
3887	6	0.00
4013	6	0.00
3712	6	0.00
3713	6	0.00
3714	6	0.00
3417	6	0.00
2926	6	0.00
2974	6	0.00
2978	6	0.00
2981	6	0.00
3118	6	0.00
3168	6	0.00
3183	6	0.00
3223	6	0.00
3266	6	0.00
3267	6	0.00
4293	6	0.00
3354	6	0.00
3383	6	0.00
3384	6	0.00
3409	6	0.00
3497	6	0.00
3499	6	0.00
3500	6	0.00
3502	6	0.00
3503	6	0.00
3506	6	0.00
3507	6	0.00
3573	6	0.00
2877	6	0.00
3189	6	0.00
3246	6	0.00
3498	6	0.00
3662	6	0.00
3663	6	0.00
3892	6	0.00
4028	6	0.00
3693	6	0.00
3695	6	0.00
3818	6	0.00
3819	6	0.00
3877	6	0.00
3986	6	0.00
4098	6	0.00
4479	6	0.00
4480	6	0.00
4481	6	0.00
3469	6	0.00
4265	6	0.00
3170	6	0.00
3178	6	0.00
3196	6	0.00
3427	6	0.00
3428	6	0.00
3466	6	0.00
3467	6	0.00
3468	6	0.00
4118	6	0.00
3591	6	0.00
3169	6	0.00
3464	6	0.00
3794	6	0.00
4375	6	0.00
2919	6	0.00
2928	6	0.00
2995	6	0.00
3367	6	0.00
3372	6	0.00
3407	6	0.00
3430	6	0.00
3786	6	0.00
3838	6	0.00
3686	6	0.00
2869	6	0.00
3501	6	0.00
3797	6	0.00
3821	6	0.00
3837	6	0.00
3888	6	0.00
3911	6	0.00
3989	6	0.00
4065	6	0.00
4100	6	0.00
4163	6	0.00
4009	6	0.00
4390	6	0.00
4249	6	0.00
4325	6	0.00
3011	6	0.00
3668	6	0.00
3778	6	0.00
4507	6	0.00
2982	6	0.00
3053	6	0.00
3119	6	0.00
3728	6	0.00
3729	6	0.00
3633	6	0.00
3756	6	0.00
4344	6	0.00
3102	6	0.00
3125	6	0.00
3129	6	0.00
3185	6	0.00
3195	6	0.00
3238	6	0.00
3333	6	0.00
3337	6	0.00
3338	6	0.00
3351	6	0.00
4294	6	0.00
3375	6	0.00
3446	6	0.00
3458	6	0.00
3653	6	0.00
3970	6	0.00
3828	6	0.00
3849	6	0.00
3922	6	0.00
3951	6	0.00
3953	6	0.00
3954	6	0.00
3956	6	0.00
3957	6	0.00
3958	6	0.00
3960	6	0.00
3961	6	0.00
4457	6	0.00
4472	6	0.00
3952	6	0.00
2879	6	0.00
4251	6	0.00
3010	6	0.00
3124	6	0.00
3126	6	0.00
3128	6	0.00
3132	6	0.00
3282	6	0.00
3526	6	0.00
4315	6	0.00
3669	6	0.00
2975	6	0.00
3243	6	0.00
4360	6	0.00
3926	6	0.00
4361	6	0.00
3927	6	0.00
3928	6	0.00
3929	6	0.00
3931	6	0.00
3933	6	0.00
4362	6	0.00
3935	6	0.00
3936	6	0.00
3945	6	0.00
3946	6	0.00
3947	6	0.00
4406	6	0.00
3346	6	0.00
3932	6	0.00
3719	6	0.00
3720	6	0.00
3704	6	0.00
3721	6	0.00
3732	6	0.00
3733	6	0.00
3734	6	0.00
3735	6	0.00
3737	6	0.00
3738	6	0.00
3739	6	0.00
3741	6	0.00
3742	6	0.00
2858	6	0.00
2859	6	0.00
2865	6	0.00
2866	6	0.00
2867	6	0.00
2868	6	0.00
2881	6	0.00
2909	6	0.00
2910	6	0.00
2911	6	0.00
2920	6	0.00
2947	6	0.00
3020	6	0.00
3021	6	0.00
3022	6	0.00
3028	6	0.00
3029	6	0.00
3034	6	0.00
3035	6	0.00
3036	6	0.00
3037	6	0.00
3073	6	0.00
3074	6	0.00
3075	6	0.00
3076	6	0.00
3077	6	0.00
3078	6	0.00
3079	6	0.00
3080	6	0.00
3081	6	0.00
3082	6	0.00
3083	6	0.00
3084	6	0.00
3088	6	0.00
3141	6	0.00
3232	6	0.00
3233	6	0.00
3234	6	0.00
3277	6	0.00
3278	6	0.00
3448	6	0.00
3511	6	0.00
3512	6	0.00
3513	6	0.00
3587	6	0.00
3600	6	0.00
3601	6	0.00
3602	6	0.00
3604	6	0.00
3605	6	0.00
3606	6	0.00
3607	6	0.00
3608	6	0.00
3609	6	0.00
3611	6	0.00
3622	6	0.00
3645	6	0.00
3646	6	0.00
3647	6	0.00
3649	6	0.00
3650	6	0.00
3840	6	0.00
3026	6	0.00
3044	6	0.00
3045	6	0.00
3046	6	0.00
3047	6	0.00
3027	6	0.00
3072	6	0.00
3235	6	0.00
3514	6	0.00
3612	6	0.00
3620	6	0.00
3603	6	0.00
3621	6	0.00
3718	6	0.00
3736	6	0.00
3730	6	0.00
3731	6	0.00
3839	6	0.00
4395	6	0.00
4396	6	0.00
4397	6	0.00
4398	6	0.00
3013	6	0.00
3135	6	0.00
3136	6	0.00
3138	6	0.00
3140	6	0.00
3276	6	0.00
3597	6	0.00
3598	6	0.00
3599	6	0.00
3641	6	0.00
3642	6	0.00
3643	6	0.00
3644	6	0.00
2857	6	0.00
2860	6	0.00
2914	6	0.00
2955	6	0.00
3137	6	0.00
3610	6	0.00
3722	6	0.00
3723	6	0.00
3724	6	0.00
3725	6	0.00
3841	6	0.00
3842	6	0.00
4393	6	0.00
4394	6	0.00
3657	6	0.00
3766	6	0.00
2943	6	0.00
2944	6	0.00
2945	6	0.00
2958	6	0.00
2959	6	0.00
4255	6	0.00
3039	6	0.00
3040	6	0.00
3041	6	0.00
3043	6	0.00
4261	6	0.00
4262	6	0.00
4263	6	0.00
4264	6	0.00
4269	6	0.00
3130	6	0.00
4127	6	0.00
4276	6	0.00
3220	6	0.00
3221	6	0.00
3231	6	0.00
3236	6	0.00
3237	6	0.00
3286	6	0.00
3287	6	0.00
3288	6	0.00
3289	6	0.00
3290	6	0.00
3291	6	0.00
3292	6	0.00
3293	6	0.00
4285	6	0.00
3298	6	0.00
3360	6	0.00
3379	6	0.00
4295	6	0.00
4296	6	0.00
3401	6	0.00
3406	6	0.00
3412	6	0.00
3486	6	0.00
3788	6	0.00
4311	6	0.00
3555	6	0.00
3556	6	0.00
3557	6	0.00
3577	6	0.00
3613	6	0.00
3648	6	0.00
3651	6	0.00
3676	6	0.00
3302	6	0.00
3435	6	0.00
3452	6	0.00
3453	6	0.00
3454	6	0.00
3455	6	0.00
3566	6	0.00
3779	6	0.00
4126	6	0.00
3983	6	0.00
4018	6	0.00
3798	6	0.00
4338	6	0.00
4087	6	0.00
4436	6	0.00
3434	6	0.00
3784	6	0.00
2968	6	0.00
3332	6	0.00
3374	6	0.00
4300	6	0.00
3462	6	0.00
3787	6	0.00
3571	6	0.00
3656	6	0.00
3658	6	0.00
3659	6	0.00
3660	6	0.00
3661	6	0.00
3673	6	0.00
3309	6	0.00
3299	6	0.00
3300	6	0.00
3301	6	0.00
3697	6	0.00
4006	6	0.00
4384	6	0.00
4435	6	0.00
2819	6	0.00
2820	6	0.00
4245	6	0.00
2821	6	0.00
4246	6	0.00
2977	6	0.00
4283	6	0.00
3269	6	0.00
3270	6	0.00
3271	6	0.00
3273	6	0.00
3399	6	0.00
3433	6	0.00
3445	6	0.00
4309	6	0.00
3579	6	0.00
3581	6	0.00
2818	6	0.00
3103	6	0.00
3281	6	0.00
3342	6	0.00
3487	6	0.00
4411	6	0.00
4438	6	0.00
4513	6	0.00
4052	6	0.00
3764	6	0.00
3770	6	0.00
2864	6	0.00
2946	6	0.00
2956	6	0.00
2965	6	0.00
3014	6	0.00
3024	6	0.00
3059	6	0.00
4266	6	0.00
3063	6	0.00
3066	6	0.00
4268	6	0.00
4271	6	0.00
3145	6	0.00
3147	6	0.00
3186	6	0.00
3206	6	0.00
4277	6	0.00
4278	6	0.00
3222	6	0.00
4281	6	0.00
3255	6	0.00
4284	6	0.00
4288	6	0.00
3324	6	0.00
3325	6	0.00
3330	6	0.00
3376	6	0.00
3403	6	0.00
4298	6	0.00
3418	6	0.00
4299	6	0.00
3421	6	0.00
3422	6	0.00
3425	6	0.00
4037	6	0.00
3530	6	0.00
3531	6	0.00
3532	6	0.00
3533	6	0.00
4346	6	0.00
3539	6	0.00
3540	6	0.00
3541	6	0.00
3551	6	0.00
3552	6	0.00
3553	6	0.00
4318	6	0.00
4319	6	0.00
3576	6	0.00
3578	6	0.00
3674	6	0.00
3675	6	0.00
2835	6	0.00
2849	6	0.00
3312	6	0.00
4482	6	0.00
4287	6	0.00
3524	6	0.00
3120	6	0.00
3207	6	0.00
3795	6	0.00
3968	6	0.00
3743	6	0.00
4512	6	0.00
3090	6	0.00
3091	6	0.00
3092	6	0.00
3093	6	0.00
3094	6	0.00
3095	6	0.00
3096	6	0.00
3097	6	0.00
3098	6	0.00
3099	6	0.00
3272	6	0.00
3340	6	0.00
4082	6	0.00
3536	6	0.00
3575	6	0.00
2970	6	0.00
3089	6	0.00
4141	6	0.00
3763	6	0.00
3131	6	0.00
3263	6	0.00
3275	6	0.00
3284	6	0.00
3478	6	0.00
3534	6	0.00
3538	6	0.00
3545	6	0.00
3546	6	0.00
3629	6	0.00
3655	6	0.00
3085	6	0.00
3161	6	0.00
3253	6	0.00
3765	6	0.00
3703	6	0.00
3918	6	0.00
4022	6	0.00
2901	6	0.00
3031	6	0.00
3100	6	0.00
3101	6	0.00
3182	6	0.00
4128	6	0.00
3482	6	0.00
2902	6	0.00
3441	6	0.00
3485	6	0.00
3707	6	0.00
4420	6	0.00
4260	6	0.00
3744	6	0.00
3194	6	0.00
2967	6	0.00
3378	6	0.00
3362	6	0.00
3528	6	0.00
4314	6	0.00
4133	6	0.00
4015	6	0.00
4107	6	0.00
3671	6	0.00
4146	6	0.00
3758	6	0.00
3052	6	0.00
3308	6	0.00
3352	6	0.00
4302	6	0.00
3637	6	0.00
4083	6	0.00
4061	6	0.00
3913	6	0.00
4080	6	0.00
4386	6	0.00
3209	6	0.00
3006	6	0.00
4136	6	0.00
4137	6	0.00
3871	6	0.00
4034	6	0.00
3574	6	0.00
3635	6	0.00
3974	6	0.00
4112	6	0.00
2814	6	0.00
2815	6	0.00
4247	6	0.00
4320	6	0.00
3746	6	0.00
4229	6	0.00
4029	6	0.00
3801	6	0.00
3314	6	0.00
3315	6	0.00
3558	6	0.00
4336	6	0.00
4355	6	0.00
4496	6	0.00
4497	6	0.00
4258	6	0.00
4060	6	0.00
4067	6	0.00
4119	6	0.00
2838	6	0.00
4341	6	0.00
4356	6	0.00
4487	6	0.00
4492	6	0.00
3627	6	0.00
3628	6	0.00
3808	6	0.00
3814	6	0.00
4280	6	0.00
3836	6	0.00
3835	6	0.00
3850	6	0.00
3226	6	0.00
2940	6	0.00
3518	6	0.00
3413	6	0.00
3886	6	0.00
4463	6	0.00
4350	6	0.00
3623	6	0.00
4304	6	0.00
3365	6	0.00
3740	6	0.00
4114	6	0.00
4026	6	0.00
4053	6	0.00
4353	6	0.00
4056	6	0.00
4372	6	0.00
4120	6	0.00
4437	6	0.00
4475	6	0.00
4510	6	0.00
2913	6	0.00
4321	6	0.00
2816	6	0.00
3700	6	0.00
4155	6	0.00
4495	6	0.00
3562	6	0.00
3005	6	0.00
3543	6	0.00
4493	6	0.00
4499	6	0.00
3009	6	0.00
3069	6	0.00
3133	6	0.00
3134	6	0.00
4297	6	0.00
3444	6	0.00
3459	6	0.00
3638	6	0.00
4324	6	0.00
3639	6	0.00
3304	6	0.00
3987	6	0.00
4024	6	0.00
4078	6	0.00
3867	6	0.00
3963	6	0.00
4045	6	0.00
4058	6	0.00
4358	6	0.00
4073	6	0.00
4074	6	0.00
4075	6	0.00
4076	6	0.00
4108	6	0.00
4109	6	0.00
4110	6	0.00
4111	6	0.00
4142	6	0.00
4412	6	0.00
4418	6	0.00
3832	6	0.00
3596	6	0.00
3305	6	0.00
3316	6	0.00
3698	6	0.00
3702	6	0.00
3715	6	0.00
3716	6	0.00
3717	6	0.00
3745	6	0.00
3748	6	0.00
3749	6	0.00
4050	6	0.00
4400	6	0.00
4417	6	0.00
4462	6	0.00
4464	6	0.00
4468	6	0.00
4483	6	0.00
4519	6	0.00
3847	6	0.00
3356	6	0.00
3925	6	0.00
4129	6	0.00
4139	6	0.00
4016	6	0.00
4068	6	0.00
4069	6	0.00
4140	6	0.00
4425	6	0.00
3846	6	0.00
3397	6	0.00
3515	6	0.00
3980	6	0.00
3981	6	0.00
3934	6	0.00
3809	6	0.00
3876	6	0.00
4248	6	0.00
3188	6	0.00
3199	6	0.00
4307	6	0.00
4161	6	0.00
3688	6	0.00
3938	6	0.00
4470	6	0.00
3492	6	0.00
3560	6	0.00
3564	6	0.00
3942	6	0.00
4317	6	0.00
3792	6	0.00
3211	6	0.00
3869	6	0.00
3803	6	0.00
3813	6	0.00
3874	6	0.00
4357	6	0.00
3919	6	0.00
3975	6	0.00
4027	6	0.00
3959	6	0.00
4051	6	0.00
4072	6	0.00
4402	6	0.00
4363	6	0.00
4415	6	0.00
4456	6	0.00
4469	6	0.00
4525	6	0.00
3759	6	0.00
3802	6	0.00
3264	6	0.00
3268	6	0.00
3313	6	0.00
4033	6	0.00
3559	6	0.00
3563	6	0.00
4322	6	0.00
3682	6	0.00
3800	6	0.00
3868	6	0.00
4032	6	0.00
4160	6	0.00
3984	6	0.00
4364	6	0.00
4365	6	0.00
3857	6	0.00
3858	6	0.00
3870	6	0.00
3971	6	0.00
3991	6	0.00
3972	6	0.00
4367	6	0.00
4368	6	0.00
4031	6	0.00
4035	6	0.00
4151	6	0.00
4164	6	0.00
4401	6	0.00
4461	6	0.00
2837	6	0.00
4273	6	0.00
3996	6	0.00
3331	6	0.00
2979	6	0.00
3274	6	0.00
3979	6	0.00
3240	6	0.00
2862	6	0.00
3004	6	0.00
3007	6	0.00
3062	6	0.00
3204	6	0.00
4279	6	0.00
3973	6	0.00
4123	6	0.00
3565	6	0.00
3618	6	0.00
4331	6	0.00
3687	6	0.00
3049	6	0.00
3050	6	0.00
3060	6	0.00
3306	6	0.00
4007	6	0.00
4025	6	0.00
3509	6	0.00
3595	6	0.00
3726	6	0.00
3751	6	0.00
3856	6	0.00
4369	6	0.00
3861	6	0.00
4352	6	0.00
4086	6	0.00
4409	6	0.00
4040	6	0.00
4370	6	0.00
4449	6	0.00
4450	6	0.00
4452	6	0.00
4453	6	0.00
4371	6	0.00
4454	6	0.00
4455	6	0.00
3865	6	0.00
4515	6	0.00
4066	6	0.00
3785	6	0.00
3104	6	0.00
3163	6	0.00
3251	6	0.00
4289	6	0.00
3848	6	0.00
3414	6	0.00
3484	6	0.00
3023	6	0.00
3685	6	0.00
3806	6	0.00
3810	6	0.00
3880	6	0.00
3965	6	0.00
4012	6	0.00
4101	6	0.00
4175	6	0.00
3807	6	0.00
3853	6	0.00
3859	6	0.00
3863	6	0.00
4014	6	0.00
4043	6	0.00
4166	6	0.00
4382	6	0.00
4385	6	0.00
4079	6	0.00
4373	6	0.00
4391	6	0.00
4392	6	0.00
4414	6	0.00
4448	6	0.00
4504	6	0.00
4505	6	0.00
3799	6	0.00
2832	6	0.00
2833	6	0.00
2834	6	0.00
2844	6	0.00
2904	6	0.00
2939	6	0.00
3008	6	0.00
3042	6	0.00
4267	6	0.00
3341	6	0.00
3343	6	0.00
3419	6	0.00
3666	6	0.00
3827	6	0.00
3852	6	0.00
3517	6	0.00
3750	6	0.00
4135	6	0.00
4138	6	0.00
4156	6	0.00
4171	6	0.00
3998	6	0.00
4377	6	0.00
4097	6	0.00
4378	6	0.00
4403	6	0.00
4405	6	0.00
4404	6	0.00
4144	6	0.00
4017	6	0.00
4422	6	0.00
4274	6	0.00
3582	6	0.00
3054	6	0.00
3884	6	0.00
3709	6	0.00
2882	6	0.00
3071	6	0.00
3345	6	0.00
3893	6	0.00
3930	6	0.00
2851	6	0.00
4254	6	0.00
4257	6	0.00
3123	6	0.00
3051	6	0.00
3684	6	0.00
3862	6	0.00
4488	6	0.00
4489	6	0.00
4490	6	0.00
4491	6	0.00
4514	6	0.00
2855	6	0.00
2897	6	0.00
3015	6	0.00
3016	6	0.00
3032	6	0.00
3070	6	0.00
3086	6	0.00
3164	6	0.00
3191	6	0.00
3192	6	0.00
4275	6	0.00
3285	6	0.00
3295	6	0.00
3355	6	0.00
3569	6	0.00
3017	6	0.00
3162	6	0.00
3303	6	0.00
3708	6	0.00
3701	6	0.00
3705	6	0.00
3757	6	0.00
2875	6	0.00
2954	6	0.00
3317	6	0.00
3415	6	0.00
3588	6	0.00
3614	6	0.00
3048	6	0.00
3065	6	0.00
4154	6	0.00
2883	6	0.00
2885	6	0.00
2886	6	0.00
2887	6	0.00
4459	6	0.00
2888	6	0.00
2891	6	0.00
2893	6	0.00
2894	6	0.00
2895	6	0.00
2898	6	0.00
2899	6	0.00
2900	6	0.00
2906	6	0.00
2907	6	0.00
2908	6	0.00
3113	6	0.00
3114	6	0.00
3115	6	0.00
3247	6	0.00
3296	6	0.00
3318	6	0.00
3319	6	0.00
3320	6	0.00
3321	6	0.00
3335	6	0.00
3336	6	0.00
3344	6	0.00
3547	6	0.00
3548	6	0.00
3549	6	0.00
2884	6	0.00
2964	6	0.00
3143	6	0.00
3357	6	0.00
3672	6	0.00
3811	6	0.00
3696	6	0.00
4387	6	0.00
3851	6	0.00
4070	6	0.00
4071	6	0.00
4388	6	0.00
3334	6	0.00
3775	6	0.00
3776	6	0.00
3777	6	0.00
2923	6	0.00
2924	6	0.00
4471	6	0.00
2925	6	0.00
2950	6	0.00
2951	6	0.00
2966	6	0.00
2976	6	0.00
2987	6	0.00
2991	6	0.00
2992	6	0.00
2993	6	0.00
3038	6	0.00
3180	6	0.00
3348	6	0.00
3395	6	0.00
3400	6	0.00
3905	6	0.00
3519	6	0.00
3527	6	0.00
4117	6	0.00
3631	6	0.00
3465	6	0.00
3774	6	0.00
3815	6	0.00
3816	6	0.00
4000	6	0.00
4162	6	0.00
3167	6	0.00
3796	6	0.00
4104	6	0.00
3890	6	0.00
4046	6	0.00
4413	6	0.00
2929	6	0.00
2930	6	0.00
2932	6	0.00
2934	6	0.00
2935	6	0.00
2971	6	0.00
4517	6	0.00
4527	6	0.00
4516	6	0.00
4518	6	0.00
4521	6	0.00
4522	6	0.00
4523	6	0.00
4524	6	0.00
4526	6	0.00
4520	6	0.00
3760	6	0.00
3761	6	0.00
3755	6	0.00
3055	6	0.00
3411	6	0.00
3457	6	0.00
3790	6	0.00
3508	6	0.00
3845	6	0.00
2972	6	0.00
2973	6	0.00
3894	6	0.00
3127	6	0.00
3152	6	0.00
3153	6	0.00
3154	6	0.00
3155	6	0.00
3156	6	0.00
3157	6	0.00
3175	6	0.00
3176	6	0.00
3177	6	0.00
3190	6	0.00
3311	6	0.00
3896	6	0.00
3897	6	0.00
3370	6	0.00
3966	6	0.00
3967	6	0.00
4005	6	0.00
3391	6	0.00
4021	6	0.00
4023	6	0.00
3393	6	0.00
4047	6	0.00
3898	6	0.00
4130	6	0.00
4132	6	0.00
3404	6	0.00
4379	6	0.00
3432	6	0.00
4410	6	0.00
3483	6	0.00
4423	6	0.00
4424	6	0.00
4430	6	0.00
3592	6	0.00
3593	6	0.00
3594	6	0.00
4131	6	0.00
2933	6	0.00
3329	6	0.00
4509	6	0.00
3822	6	0.00
3823	6	0.00
3824	6	0.00
3889	6	0.00
4158	6	0.00
4159	6	0.00
4440	6	0.00
4441	6	0.00
4442	6	0.00
4443	6	0.00
4444	6	0.00
4445	6	0.00
4446	6	0.00
4478	6	0.00
4485	6	0.00
4447	6	0.00
3895	6	0.00
4439	6	0.00
2949	6	0.00
2840	6	0.00
3116	6	0.00
3117	6	0.00
3187	6	0.00
2963	6	0.00
3405	6	0.00
3585	6	0.00
3225	6	0.00
4458	6	0.00
4484	6	0.00
4494	6	0.00
3203	6	0.00
4286	6	0.00
3510	6	0.00
3625	6	0.00
3361	6	0.00
3369	6	0.00
3630	6	0.00
4541	6	0.00
3665	6	0.00
4351	6	0.00
4036	6	0.00
4380	6	0.00
4419	6	0.00
3879	6	0.00
3904	6	0.00
3424	6	0.00
3447	6	0.00
4054	6	0.00
3789	6	0.00
3567	6	0.00
3396	6	0.00
3443	6	0.00
3568	6	0.00
3680	6	0.00
3678	6	0.00
3727	6	0.00
4349	6	0.00
3992	6	0.00
3993	6	0.00
4063	6	0.00
4115	6	0.00
4542	6	0.00
4543	6	0.00
4544	6	0.00
4545	6	0.00
4548	6	0.00
4407	6	0.00
3440	6	0.00
3683	6	0.00
4359	6	0.00
3891	6	0.00
3962	6	0.00
4177	6	0.00
4381	6	0.00
3875	6	0.00
4301	6	0.00
3437	6	0.00
3436	6	0.00
3866	6	0.00
3881	6	0.00
3882	6	0.00
3909	6	0.00
3964	6	0.00
3978	6	0.00
4042	6	0.00
4169	6	0.00
4416	6	0.00
4316	6	0.00
4044	6	0.00
4152	6	0.00
4399	6	0.00
4426	6	0.00
3768	6	0.00
3771	6	0.00
3772	6	0.00
3148	6	0.00
3279	6	0.00
3416	6	0.00
3624	6	0.00
3805	6	0.00
3883	6	0.00
4077	6	0.00
4337	6	0.00
3860	6	0.00
3949	6	0.00
3999	6	0.00
4048	6	0.00
4049	6	0.00
4084	6	0.00
4167	6	0.00
4172	6	0.00
4173	6	0.00
4339	6	0.00
3388	6	0.00
3392	6	0.00
3474	6	0.00
3479	6	0.00
3480	6	0.00
3636	6	0.00
3179	6	0.00
3368	6	0.00
3386	6	0.00
3389	6	0.00
3390	6	0.00
3385	6	0.00
3387	6	0.00
3753	6	0.00
3844	6	0.00
4347	6	0.00
4092	6	0.00
4094	6	0.00
4095	6	0.00
4096	6	0.00
4145	6	0.00
4147	6	0.00
4081	6	0.00
4122	6	0.00
4176	6	0.00
4408	6	0.00
3995	6	0.00
3997	6	0.00
4343	6	0.00
3398	6	0.00
3493	6	0.00
4326	6	0.00
4332	6	0.00
3677	6	0.00
3572	6	0.00
3793	6	0.00
3812	6	0.00
3873	6	0.00
3902	6	0.00
3903	6	0.00
3912	6	0.00
3976	6	0.00
4039	6	0.00
4476	6	0.00
4506	6	0.00
3554	6	0.00
4062	6	0.00
4174	6	0.00
3516	6	0.00
3529	6	0.00
4313	6	0.00
4055	6	0.00
3920	6	0.00
3921	6	0.00
3950	6	0.00
4008	6	0.00
3580	6	0.00
4059	6	0.00
3939	6	0.00
4433	6	0.00
4057	6	0.00
3780	6	0.00
3783	6	0.00
3619	6	0.00
4335	6	0.00
4215	6	0.00
4217	6	0.00
4218	6	0.00
4219	6	0.00
4220	6	0.00
4216	6	0.00
4208	6	0.00
4225	6	0.00
4228	6	0.00
4231	6	0.00
4232	6	0.00
4234	6	0.00
4236	6	0.00
4235	6	0.00
4089	6	0.00
4093	6	0.00
4103	6	0.00
4170	6	0.00
2850	6	0.00
4561	6	0.00
4564	6	0.00
4568	6	0.00
4569	6	0.00
4560	6	0.00
4434	6	0.00
4230	6	0.00
4211	6	0.00
3252	6	0.00
3258	6	0.00
4553	6	0.00
3825	6	0.00
2896	6	0.00
4238	6	0.00
2903	6	0.00
3586	6	0.00
4237	6	0.00
4204	6	0.00
3364	6	0.00
2890	6	0.00
3227	6	0.00
2961	6	0.00
3139	6	0.00
3451	6	0.00
3456	6	0.00
2892	6	0.00
4240	6	0.00
3535	6	0.00
3937	6	0.00
2889	6	0.00
4207	6	0.00
4004	6	0.00
4002	6	0.00
3969	6	0.00
4003	6	0.00
3001	6	0.00
4431	6	0.00
4540	6	0.00
4474	6	0.00
4538	6	0.00
4389	6	0.00
4193	6	0.00
3664	6	0.00
4500	6	0.00
3256	6	0.00
4179	6	0.00
4180	6	0.00
3872	6	0.00
4233	6	0.00
4539	6	0.00
3224	6	0.00
3294	6	0.00
3439	6	0.00
3438	6	0.00
4185	6	0.00
4184	6	0.00
4203	6	0.00
4244	6	0.00
4197	6	0.00
2842	6	0.00
3328	6	0.00
3431	6	0.00
3144	6	0.00
3450	6	0.00
3826	6	0.00
3449	6	0.00
3261	6	0.00
3423	6	0.00
3239	6	0.00
3254	6	0.00
3710	6	0.00
3878	6	0.00
3067	6	0.00
3640	6	0.00
3068	6	0.00
4113	6	0.00
2880	6	0.00
3477	6	0.00
3754	6	0.00
4134	6	0.00
3159	6	0.00
2836	6	0.00
3339	6	0.00
4330	6	0.00
3347	6	0.00
3012	6	0.00
3003	6	0.00
2852	6	0.00
4366	6	0.00
4186	6	0.00
4183	6	0.00
2841	6	0.00
2843	6	0.00
4148	6	0.00
4549	6	0.00
4194	6	0.00
4106	6	0.00
3470	6	0.00
4192	6	0.00
4188	6	0.00
4187	6	0.00
4011	6	0.00
4503	6	0.00
4030	6	0.00
2905	6	0.00
4191	6	0.00
4190	6	0.00
4178	6	0.00
4559	6	0.00
4556	6	0.00
4202	6	0.00
4199	6	0.00
4198	6	0.00
4530	6	0.00
4566	6	0.00
4562	6	0.00
4563	6	0.00
4565	6	0.00
4554	6	0.00
4555	6	0.00
4528	6	0.00
4189	6	0.00
4529	6	0.00
4567	6	0.00
4241	6	0.00
4595	5	0.00
4550	1	0.00
4595	6	0.00
4595	1	0.00
4596	2	0.00
4596	4	0.00
4596	5	0.00
4596	6	0.00
4596	1	0.00
4597	2	0.00
4597	4	0.00
4597	5	0.00
4597	6	0.00
4597	1	0.00
4598	2	0.00
4598	4	0.00
4598	5	0.00
4598	6	0.00
4598	1	0.00
4599	2	0.00
4599	4	0.00
4599	5	0.00
4599	6	0.00
4599	1	0.00
4600	2	0.00
4600	4	0.00
4600	5	0.00
4600	6	0.00
4600	1	0.00
4601	2	0.00
4601	4	0.00
4601	5	0.00
4601	6	0.00
4601	1	0.00
4602	2	0.00
4602	4	0.00
4602	5	0.00
4602	6	0.00
4602	1	0.00
4603	2	0.00
4603	4	0.00
4603	5	0.00
4603	6	0.00
4603	1	0.00
4604	2	0.00
4604	4	0.00
4604	5	0.00
4604	6	0.00
4604	1	0.00
4605	2	0.00
4605	4	0.00
4605	5	0.00
4605	6	0.00
4605	1	0.00
4606	2	0.00
4606	4	0.00
4606	5	0.00
4606	6	0.00
4606	1	0.00
4607	2	0.00
4607	4	0.00
4607	5	0.00
4607	6	0.00
4607	1	0.00
4608	2	0.00
4608	4	0.00
4608	5	0.00
4608	6	0.00
4608	1	0.00
4609	2	0.00
4609	4	0.00
4609	5	0.00
4609	6	0.00
4609	1	0.00
4610	2	0.00
4610	4	0.00
4610	5	0.00
4610	6	0.00
4610	1	0.00
4611	2	0.00
4611	4	0.00
4611	5	0.00
4611	6	0.00
4611	1	0.00
4612	2	0.00
4612	4	0.00
4612	5	0.00
4612	6	0.00
4612	1	0.00
4613	2	0.00
4613	4	0.00
4613	5	0.00
4613	6	0.00
4613	1	0.00
4614	2	0.00
4614	4	0.00
4614	5	0.00
4614	6	0.00
4614	1	0.00
4615	2	0.00
4615	4	0.00
4615	5	0.00
4615	6	0.00
4615	1	0.00
4616	2	0.00
4616	4	0.00
4616	5	0.00
4616	6	0.00
4616	1	0.00
4617	2	0.00
4617	4	0.00
4617	5	0.00
4617	6	0.00
4617	1	0.00
4618	2	0.00
4618	4	0.00
4618	5	0.00
4618	6	0.00
4618	1	0.00
4619	2	0.00
4619	4	0.00
4619	5	0.00
4619	6	0.00
4619	1	0.00
4620	2	0.00
4620	4	0.00
4620	5	0.00
4620	6	0.00
4620	1	0.00
4621	2	0.00
4621	4	0.00
4621	5	0.00
4621	6	0.00
4621	1	0.00
4622	2	0.00
4622	4	0.00
4622	5	0.00
4622	6	0.00
4622	1	0.00
4623	2	0.00
4623	4	0.00
4623	5	0.00
4623	6	0.00
4623	1	0.00
4624	2	0.00
4624	4	0.00
4624	5	0.00
4624	6	0.00
4624	1	0.00
4625	2	0.00
4625	4	0.00
4625	5	0.00
4625	6	0.00
4625	1	0.00
4626	2	0.00
4626	4	0.00
4626	5	0.00
4626	6	0.00
4626	1	0.00
4627	2	0.00
4627	4	0.00
4627	5	0.00
4627	6	0.00
4628	2	0.00
4628	4	0.00
4628	5	0.00
4628	6	0.00
4628	1	0.00
4629	2	0.00
4629	4	0.00
4629	5	0.00
4629	6	0.00
4629	1	0.00
4630	2	0.00
4630	4	0.00
4630	5	0.00
4630	6	0.00
4630	1	0.00
4631	2	0.00
4631	4	0.00
4631	5	0.00
4631	6	0.00
4631	1	0.00
4632	2	0.00
4632	4	0.00
4632	5	0.00
4632	6	0.00
4632	1	0.00
4633	2	0.00
4633	4	0.00
4633	5	0.00
4633	6	0.00
4633	1	0.00
4634	2	0.00
4634	4	0.00
4634	5	0.00
4634	6	0.00
4635	2	0.00
4635	4	0.00
4635	5	0.00
4635	6	0.00
4635	1	0.00
4636	2	0.00
4636	4	0.00
4636	5	0.00
4636	6	0.00
4636	1	0.00
4637	2	0.00
4637	4	0.00
4637	5	0.00
4637	6	0.00
4637	1	0.00
4638	2	0.00
4638	4	0.00
4638	5	0.00
4638	6	0.00
4638	1	0.00
4639	2	0.00
4639	4	0.00
4639	5	0.00
4639	6	0.00
4639	1	0.00
4640	2	0.00
4640	4	0.00
4640	5	0.00
4640	6	0.00
4640	1	0.00
4641	2	0.00
4641	4	0.00
4641	5	0.00
4641	6	0.00
4641	1	0.00
4642	2	0.00
4642	4	0.00
4642	5	0.00
4642	6	0.00
4642	1	0.00
4643	2	0.00
4643	4	0.00
4643	5	0.00
4643	6	0.00
4643	1	0.00
4644	2	0.00
4644	4	0.00
4644	5	0.00
4644	6	0.00
4644	1	0.00
4645	2	0.00
4645	4	0.00
4645	5	0.00
4645	6	0.00
4645	1	0.00
4646	2	0.00
4646	4	0.00
4646	5	0.00
4646	6	0.00
4646	1	0.00
4647	2	0.00
4647	4	0.00
4647	5	0.00
4647	6	0.00
4647	1	0.00
4648	2	0.00
4648	4	0.00
4648	5	0.00
4648	6	0.00
4648	1	0.00
4649	2	0.00
4649	4	0.00
4649	5	0.00
4649	6	0.00
4649	1	0.00
4650	2	0.00
4650	4	0.00
4650	5	0.00
4650	6	0.00
4650	1	0.00
4651	2	0.00
4651	4	0.00
4651	5	0.00
4651	6	0.00
4651	1	0.00
4652	2	0.00
4652	4	0.00
4652	5	0.00
4652	6	0.00
4652	1	0.00
4653	2	0.00
4653	4	0.00
4653	5	0.00
4653	6	0.00
4653	1	0.00
4654	2	0.00
4654	4	0.00
4654	5	0.00
4654	6	0.00
4654	1	0.00
4655	2	0.00
4655	4	0.00
4655	5	0.00
4655	6	0.00
4655	1	0.00
4656	2	0.00
4656	4	0.00
4656	5	0.00
4656	6	0.00
4656	1	0.00
4657	2	0.00
4657	4	0.00
4657	5	0.00
4657	6	0.00
4657	1	0.00
4658	2	0.00
4658	4	0.00
4658	5	0.00
4658	6	0.00
4658	1	0.00
4659	2	0.00
4659	4	0.00
4659	5	0.00
4659	6	0.00
4659	1	0.00
4660	2	0.00
4660	4	0.00
4660	5	0.00
4660	6	0.00
4660	1	0.00
4661	2	0.00
4661	4	0.00
4661	5	0.00
4661	6	0.00
4661	1	0.00
4662	2	0.00
4662	4	0.00
4662	5	0.00
4662	6	0.00
4662	1	0.00
4663	2	0.00
4663	4	0.00
4663	5	0.00
4663	6	0.00
4663	1	0.00
4664	2	0.00
4664	4	0.00
4664	5	0.00
4664	6	0.00
4664	1	0.00
4665	2	0.00
4665	4	0.00
4665	5	0.00
4665	6	0.00
4665	1	0.00
4666	2	0.00
4666	4	0.00
4666	5	0.00
4666	6	0.00
4666	1	0.00
4667	2	0.00
4667	4	0.00
4667	5	0.00
4667	6	0.00
4667	1	0.00
4668	2	0.00
4668	4	0.00
4668	5	0.00
4668	6	0.00
4668	1	0.00
4669	2	0.00
4669	4	0.00
4669	5	0.00
4669	6	0.00
4669	1	0.00
4670	2	0.00
4670	4	0.00
4670	5	0.00
4670	6	0.00
4670	1	0.00
4671	2	0.00
4671	4	0.00
4671	5	0.00
4671	6	0.00
4671	1	0.00
4672	2	0.00
4672	4	0.00
4672	5	0.00
4672	6	0.00
4672	1	0.00
4673	2	0.00
4673	4	0.00
4673	5	0.00
4673	6	0.00
4673	1	0.00
4674	2	0.00
4674	4	0.00
4674	5	0.00
4674	6	0.00
4674	1	0.00
4675	2	0.00
4675	4	0.00
4675	5	0.00
4675	6	0.00
4675	1	0.00
4676	2	0.00
4676	4	0.00
4676	5	0.00
4676	6	0.00
4676	1	0.00
4677	2	0.00
4677	4	0.00
4677	5	0.00
4677	6	0.00
4677	1	0.00
4678	2	0.00
4678	4	0.00
4678	5	0.00
4678	6	0.00
4678	1	0.00
4679	2	0.00
4679	4	0.00
4679	5	0.00
4679	6	0.00
4679	1	0.00
4680	2	0.00
4680	4	0.00
4680	5	0.00
4680	6	0.00
4680	1	0.00
4681	2	0.00
4681	4	0.00
4681	5	0.00
4681	6	0.00
4681	1	0.00
4682	2	0.00
4682	4	0.00
4682	5	0.00
4682	6	0.00
4682	1	0.00
4683	2	0.00
4683	4	0.00
4683	5	0.00
4683	6	0.00
4683	1	0.00
4684	2	0.00
4684	4	0.00
4684	5	0.00
4684	6	0.00
4684	1	0.00
4685	2	0.00
4685	4	0.00
4685	5	0.00
4685	6	0.00
4685	1	0.00
4686	2	0.00
4686	4	0.00
4686	5	0.00
4686	6	0.00
4686	1	0.00
4687	2	0.00
4687	4	0.00
4687	5	0.00
4687	6	0.00
4687	1	0.00
4688	2	0.00
4688	4	0.00
4688	5	0.00
4688	6	0.00
4688	1	0.00
4689	2	0.00
4689	4	0.00
4689	5	0.00
4689	6	0.00
4689	1	0.00
4690	2	0.00
4690	4	0.00
4690	5	0.00
4690	6	0.00
4690	1	0.00
4691	2	0.00
4691	4	0.00
4691	5	0.00
4691	6	0.00
4691	1	0.00
4692	2	0.00
4692	4	0.00
4692	5	0.00
4692	6	0.00
4692	1	0.00
4693	2	0.00
4693	4	0.00
4693	5	0.00
4693	6	0.00
4693	1	0.00
4694	2	0.00
4694	4	0.00
4694	5	0.00
4694	6	0.00
4694	1	0.00
4695	2	0.00
4695	4	0.00
4695	5	0.00
4695	6	0.00
4695	1	0.00
4696	2	0.00
4696	4	0.00
4696	5	0.00
4696	6	0.00
4696	1	0.00
4697	2	0.00
4697	4	0.00
4697	5	0.00
4697	6	0.00
4697	1	0.00
4698	2	0.00
4698	4	0.00
4698	5	0.00
4698	6	0.00
4698	1	0.00
4699	2	0.00
4699	4	0.00
4699	5	0.00
4699	6	0.00
4699	1	0.00
4700	2	0.00
4700	4	0.00
4700	5	0.00
4700	6	0.00
4700	1	0.00
4701	2	0.00
4701	4	0.00
4701	5	0.00
4701	6	0.00
4701	1	0.00
4702	2	0.00
4702	4	0.00
4702	5	0.00
4702	6	0.00
4702	1	0.00
4703	2	0.00
4703	4	0.00
4703	5	0.00
4703	6	0.00
4703	1	0.00
4704	2	0.00
4704	4	0.00
4704	5	0.00
4704	6	0.00
4704	1	0.00
4705	2	0.00
4705	4	0.00
4705	5	0.00
4705	6	0.00
4705	1	0.00
4706	2	0.00
4706	4	0.00
4706	5	0.00
4706	6	0.00
4706	1	0.00
4707	2	0.00
4707	4	0.00
4707	5	0.00
4707	6	0.00
4707	1	0.00
4708	2	0.00
4708	4	0.00
4708	5	0.00
4708	6	0.00
4708	1	0.00
4709	2	0.00
4709	4	0.00
4709	5	0.00
4709	6	0.00
4709	1	0.00
4710	2	0.00
4710	4	0.00
4710	5	0.00
4710	6	0.00
4710	1	0.00
4711	2	0.00
4711	4	0.00
4711	5	0.00
4711	6	0.00
4711	1	0.00
4712	2	0.00
4712	4	0.00
4712	5	0.00
4712	6	0.00
4712	1	0.00
4713	2	0.00
4713	4	0.00
4713	5	0.00
4713	6	0.00
4713	1	0.00
4714	2	0.00
4714	4	0.00
4714	5	0.00
4714	6	0.00
4714	1	0.00
4715	2	0.00
4715	4	0.00
4715	5	0.00
4715	6	0.00
4715	1	0.00
4716	2	0.00
4716	4	0.00
4716	5	0.00
4716	6	0.00
4716	1	0.00
4717	2	0.00
4717	4	0.00
4717	5	0.00
4717	6	0.00
4717	1	0.00
4718	2	0.00
4718	4	0.00
4718	5	0.00
4718	6	0.00
4718	1	0.00
4719	2	0.00
4719	4	0.00
4719	5	0.00
4719	6	0.00
4719	1	0.00
4720	2	0.00
4720	4	0.00
4720	5	0.00
4720	6	0.00
4720	1	0.00
4721	2	0.00
4721	4	0.00
4721	5	0.00
4721	6	0.00
4721	1	0.00
4722	2	0.00
4722	4	0.00
4722	5	0.00
4722	6	0.00
4722	1	0.00
4723	2	0.00
4723	4	0.00
4723	5	0.00
4723	6	0.00
4723	1	0.00
4724	2	0.00
4724	4	0.00
4724	5	0.00
4724	6	0.00
4724	1	0.00
4725	2	0.00
4725	4	0.00
4725	5	0.00
4725	6	0.00
4725	1	0.00
4726	2	0.00
4726	4	0.00
4726	5	0.00
4726	6	0.00
4726	1	0.00
4727	2	0.00
4727	4	0.00
4727	5	0.00
4727	6	0.00
4727	1	0.00
4728	2	0.00
4728	4	0.00
4728	5	0.00
4728	6	0.00
4728	1	0.00
4729	2	0.00
4729	4	0.00
4729	5	0.00
4729	6	0.00
4729	1	0.00
4730	2	0.00
4730	4	0.00
4730	5	0.00
4730	6	0.00
4730	1	0.00
4731	2	0.00
4731	4	0.00
4731	5	0.00
4731	6	0.00
4731	1	0.00
4732	2	0.00
4732	4	0.00
4732	5	0.00
4732	6	0.00
4732	1	0.00
4733	2	0.00
4733	4	0.00
4733	5	0.00
4733	6	0.00
4733	1	0.00
4734	2	0.00
4734	4	0.00
4734	5	0.00
4734	6	0.00
4734	1	0.00
4735	2	0.00
4735	4	0.00
4735	5	0.00
4735	6	0.00
4735	1	0.00
4736	2	0.00
4736	4	0.00
4736	5	0.00
4736	6	0.00
4736	1	0.00
4737	2	0.00
4737	4	0.00
4737	5	0.00
4737	6	0.00
4737	1	0.00
4738	2	0.00
4738	4	0.00
4738	5	0.00
4738	6	0.00
4738	1	0.00
4739	2	0.00
4739	4	0.00
4739	5	0.00
4739	6	0.00
4739	1	0.00
4740	2	0.00
4740	4	0.00
4740	5	0.00
4740	6	0.00
4740	1	0.00
4741	2	0.00
4741	4	0.00
4741	5	0.00
4741	6	0.00
4741	1	0.00
4742	2	0.00
4742	4	0.00
4742	5	0.00
4742	6	0.00
4742	1	0.00
4743	2	0.00
4743	4	0.00
4743	5	0.00
4743	6	0.00
4743	1	0.00
4744	2	0.00
4744	4	0.00
4744	5	0.00
4744	6	0.00
4744	1	0.00
4745	2	0.00
4745	4	0.00
4745	5	0.00
4745	6	0.00
4745	1	0.00
4746	2	0.00
4746	4	0.00
4746	5	0.00
4746	6	0.00
4746	1	0.00
4747	2	0.00
4747	4	0.00
4747	5	0.00
4747	6	0.00
4747	1	0.00
4748	2	0.00
4748	4	0.00
4748	5	0.00
4748	6	0.00
4748	1	0.00
4749	2	0.00
4749	4	0.00
4749	5	0.00
4749	6	0.00
4749	1	0.00
4750	2	0.00
4750	4	0.00
4750	5	0.00
4750	6	0.00
4750	1	0.00
4751	2	0.00
4751	4	0.00
4751	5	0.00
4751	6	0.00
4751	1	0.00
4752	2	0.00
4752	4	0.00
4752	5	0.00
4752	6	0.00
4752	1	0.00
4753	2	0.00
4753	4	0.00
4753	5	0.00
4753	6	0.00
4753	1	0.00
4754	2	0.00
4754	4	0.00
4754	5	0.00
4754	6	0.00
4754	1	0.00
4755	2	0.00
4755	4	0.00
4755	5	0.00
4755	6	0.00
4755	1	0.00
4756	2	0.00
4756	4	0.00
4756	5	0.00
4756	6	0.00
4756	1	0.00
4757	2	0.00
4757	4	0.00
4757	5	0.00
4757	6	0.00
4757	1	0.00
4758	2	0.00
4758	4	0.00
4758	5	0.00
4758	6	0.00
4758	1	0.00
4759	2	0.00
4759	4	0.00
4759	5	0.00
4759	6	0.00
4759	1	0.00
4760	2	0.00
4760	4	0.00
4760	5	0.00
4760	6	0.00
4760	1	0.00
4761	2	0.00
4761	4	0.00
4761	5	0.00
4761	6	0.00
4761	1	0.00
4762	2	0.00
4762	4	0.00
4762	5	0.00
4762	6	0.00
4762	1	0.00
4763	2	0.00
4763	4	0.00
4763	5	0.00
4763	6	0.00
4763	1	0.00
4764	2	0.00
4764	4	0.00
4764	5	0.00
4764	6	0.00
4764	1	0.00
4765	2	0.00
4765	4	0.00
4765	5	0.00
4765	6	0.00
4765	1	0.00
4766	2	0.00
4766	4	0.00
4766	5	0.00
4766	6	0.00
4766	1	0.00
4767	2	0.00
4767	4	0.00
4767	5	0.00
4767	6	0.00
4767	1	0.00
4768	2	0.00
4768	4	0.00
4768	5	0.00
4768	6	0.00
4768	1	0.00
4769	2	0.00
4769	4	0.00
4769	5	0.00
4769	6	0.00
4769	1	0.00
4770	2	0.00
4770	4	0.00
4770	5	0.00
4770	6	0.00
4770	1	0.00
4771	2	0.00
4771	4	0.00
4771	5	0.00
4771	6	0.00
4771	1	0.00
4772	2	0.00
4772	4	0.00
4772	5	0.00
4772	6	0.00
4772	1	0.00
4773	2	0.00
4773	4	0.00
4773	5	0.00
4773	6	0.00
4773	1	0.00
4774	2	0.00
4774	4	0.00
4774	5	0.00
4774	6	0.00
4774	1	0.00
4775	2	0.00
4775	4	0.00
4775	5	0.00
4775	6	0.00
4775	1	0.00
4776	2	0.00
4776	4	0.00
4776	5	0.00
4776	6	0.00
4776	1	0.00
4777	2	0.00
4777	4	0.00
4777	5	0.00
4777	6	0.00
4777	1	0.00
4778	2	0.00
4778	4	0.00
4778	5	0.00
4778	6	0.00
4778	1	0.00
4779	2	0.00
4779	4	0.00
4779	5	0.00
4779	6	0.00
4779	1	0.00
4780	2	0.00
4780	4	0.00
4780	5	0.00
4780	6	0.00
4780	1	0.00
4781	2	0.00
4781	4	0.00
4781	5	0.00
4781	6	0.00
4781	1	0.00
4782	2	0.00
4782	4	0.00
4782	5	0.00
4782	6	0.00
4782	1	0.00
4783	2	0.00
4783	4	0.00
4783	5	0.00
4783	6	0.00
4783	1	0.00
4784	2	0.00
4784	4	0.00
4784	5	0.00
4784	6	0.00
4784	1	0.00
4785	2	0.00
4785	4	0.00
4785	5	0.00
4785	6	0.00
4785	1	0.00
4786	2	0.00
4786	4	0.00
4786	5	0.00
4786	6	0.00
4786	1	0.00
4787	2	0.00
4787	4	0.00
4787	5	0.00
4787	6	0.00
4787	1	0.00
4788	2	0.00
4788	4	0.00
4788	5	0.00
4788	6	0.00
4788	1	0.00
4789	2	0.00
4789	4	0.00
4789	5	0.00
4789	6	0.00
4789	1	0.00
4790	2	0.00
4790	4	0.00
4790	5	0.00
4790	6	0.00
4790	1	0.00
4791	2	0.00
4791	4	0.00
4791	5	0.00
4791	6	0.00
4791	1	0.00
4792	2	0.00
4792	4	0.00
4792	5	0.00
4792	6	0.00
4792	1	0.00
4793	2	0.00
4793	4	0.00
4793	5	0.00
4793	6	0.00
4793	1	0.00
4794	2	0.00
4794	4	0.00
4794	5	0.00
4794	6	0.00
4794	1	0.00
4795	2	0.00
4795	4	0.00
4795	5	0.00
4795	6	0.00
4795	1	0.00
4796	2	0.00
4796	4	0.00
4796	5	0.00
4796	6	0.00
4796	1	0.00
4797	2	0.00
4797	4	0.00
4797	5	0.00
4797	6	0.00
4797	1	0.00
4798	2	0.00
4798	4	0.00
4798	5	0.00
4798	6	0.00
4798	1	0.00
4799	2	0.00
4799	4	0.00
4799	5	0.00
4799	6	0.00
4799	1	0.00
4800	2	0.00
4800	4	0.00
4800	5	0.00
4800	6	0.00
4800	1	0.00
4801	2	0.00
4801	4	0.00
4801	5	0.00
4801	6	0.00
4801	1	0.00
4802	2	0.00
4802	4	0.00
4802	5	0.00
4802	6	0.00
4802	1	0.00
4803	2	0.00
4803	4	0.00
4803	5	0.00
4803	6	0.00
4803	1	0.00
4804	2	0.00
4804	4	0.00
4804	5	0.00
4804	6	0.00
4804	1	0.00
4805	2	0.00
4805	4	0.00
4805	5	0.00
4805	6	0.00
4805	1	0.00
4806	2	0.00
4806	4	0.00
4806	5	0.00
4806	6	0.00
4806	1	0.00
4807	2	0.00
4807	4	0.00
4807	5	0.00
4807	6	0.00
4807	1	0.00
4808	2	0.00
4808	4	0.00
4808	5	0.00
4808	6	0.00
4808	1	0.00
4809	2	0.00
4809	4	0.00
4809	5	0.00
4809	6	0.00
4809	1	0.00
4810	2	0.00
4810	4	0.00
4810	5	0.00
4810	6	0.00
4810	1	0.00
4811	2	0.00
4811	4	0.00
4811	5	0.00
4811	6	0.00
4811	1	0.00
4812	2	0.00
4812	4	0.00
4812	5	0.00
4812	6	0.00
4812	1	0.00
4813	2	0.00
4813	4	0.00
4813	5	0.00
4813	6	0.00
4813	1	0.00
4814	2	0.00
4814	4	0.00
4814	5	0.00
4814	6	0.00
4814	1	0.00
4815	2	0.00
4815	4	0.00
4815	5	0.00
4815	6	0.00
4815	1	0.00
4816	2	0.00
4816	4	0.00
4816	5	0.00
4816	6	0.00
4816	1	0.00
4817	2	0.00
4817	4	0.00
4817	5	0.00
4817	6	0.00
4817	1	0.00
4818	2	0.00
4818	4	0.00
4818	5	0.00
4818	6	0.00
4818	1	0.00
4819	2	0.00
4819	4	0.00
4819	5	0.00
4819	6	0.00
4819	1	0.00
4820	2	0.00
4820	4	0.00
4820	5	0.00
4820	6	0.00
4820	1	0.00
4821	2	0.00
4821	4	0.00
4821	5	0.00
4821	6	0.00
4821	1	0.00
4822	2	0.00
4822	4	0.00
4822	5	0.00
4822	6	0.00
4822	1	0.00
4823	2	0.00
4823	4	0.00
4823	5	0.00
4823	6	0.00
4823	1	0.00
4824	2	0.00
4824	4	0.00
4824	5	0.00
4824	6	0.00
4824	1	0.00
4825	2	0.00
4825	4	0.00
4825	5	0.00
4825	6	0.00
4825	1	0.00
4826	2	0.00
4826	4	0.00
4826	5	0.00
4826	6	0.00
4826	1	0.00
4827	2	0.00
4827	4	0.00
4827	5	0.00
4827	6	0.00
4827	1	0.00
4828	2	0.00
4828	4	0.00
4828	5	0.00
4828	6	0.00
4828	1	0.00
4829	2	0.00
4829	4	0.00
4829	5	0.00
4829	6	0.00
4829	1	0.00
4830	2	0.00
4830	4	0.00
4830	5	0.00
4830	6	0.00
4830	1	0.00
4831	2	0.00
4831	4	0.00
4831	5	0.00
4831	6	0.00
4831	1	0.00
4832	2	0.00
4832	4	0.00
4832	5	0.00
4832	6	0.00
4832	1	0.00
4833	2	0.00
4833	4	0.00
4833	5	0.00
4833	6	0.00
4833	1	0.00
4834	2	0.00
4834	4	0.00
4834	5	0.00
4834	6	0.00
4834	1	0.00
4835	2	0.00
4835	4	0.00
4835	5	0.00
4835	6	0.00
4835	1	0.00
4836	2	0.00
4836	4	0.00
4836	5	0.00
4836	6	0.00
4836	1	0.00
4837	2	0.00
4837	4	0.00
4837	5	0.00
4837	6	0.00
4837	1	0.00
4838	2	0.00
4838	4	0.00
4838	5	0.00
4838	6	0.00
4838	1	0.00
4839	2	0.00
4839	4	0.00
4839	5	0.00
4839	6	0.00
4839	1	0.00
4840	2	0.00
4840	4	0.00
4840	5	0.00
4840	6	0.00
4840	1	0.00
4841	2	0.00
4841	4	0.00
4841	5	0.00
4841	6	0.00
4841	1	0.00
4842	2	0.00
4842	4	0.00
4842	5	0.00
4842	6	0.00
4842	1	0.00
4843	2	0.00
4843	4	0.00
4843	5	0.00
4843	6	0.00
4843	1	0.00
4844	2	0.00
4844	4	0.00
4844	5	0.00
4844	6	0.00
4844	1	0.00
4845	2	0.00
4845	4	0.00
4845	5	0.00
4845	6	0.00
4845	1	0.00
4846	2	0.00
4846	4	0.00
4846	5	0.00
4846	6	0.00
4846	1	0.00
4847	2	0.00
4847	4	0.00
4847	5	0.00
4847	6	0.00
4847	1	0.00
4848	2	0.00
4848	4	0.00
4848	5	0.00
4848	6	0.00
4848	1	0.00
4849	2	0.00
4849	4	0.00
4849	5	0.00
4849	6	0.00
4849	1	0.00
4850	2	0.00
4850	4	0.00
4850	5	0.00
4850	6	0.00
4850	1	0.00
4851	2	0.00
4851	4	0.00
4851	5	0.00
4851	6	0.00
4851	1	0.00
4852	2	0.00
4852	4	0.00
4852	5	0.00
4852	6	0.00
4852	1	0.00
4853	2	0.00
4853	4	0.00
4853	5	0.00
4853	6	0.00
4853	1	0.00
4854	2	0.00
4854	4	0.00
4854	5	0.00
4854	6	0.00
4854	1	0.00
4855	2	0.00
4855	4	0.00
4855	5	0.00
4855	6	0.00
4855	1	0.00
4856	2	0.00
4856	4	0.00
4856	5	0.00
4856	6	0.00
4856	1	0.00
4857	2	0.00
4857	4	0.00
4857	5	0.00
4857	6	0.00
4857	1	0.00
4858	2	0.00
4858	4	0.00
4858	5	0.00
4858	6	0.00
4858	1	0.00
4859	2	0.00
4859	4	0.00
4859	5	0.00
4859	6	0.00
4859	1	0.00
4860	2	0.00
4860	4	0.00
4860	5	0.00
4860	6	0.00
4860	1	0.00
4861	2	0.00
4861	4	0.00
4861	5	0.00
4861	6	0.00
4861	1	0.00
4862	2	0.00
4862	4	0.00
4862	5	0.00
4862	6	0.00
4862	1	0.00
4863	2	0.00
4863	4	0.00
4863	5	0.00
4863	6	0.00
4863	1	0.00
4864	2	0.00
4864	4	0.00
4864	5	0.00
4864	6	0.00
4864	1	0.00
4865	2	0.00
4865	4	0.00
4865	5	0.00
4865	6	0.00
4865	1	0.00
4866	2	0.00
4866	4	0.00
4866	5	0.00
4866	6	0.00
4866	1	0.00
4867	2	0.00
4867	4	0.00
4867	5	0.00
4867	6	0.00
4867	1	0.00
4868	2	0.00
4868	4	0.00
4868	5	0.00
4868	6	0.00
4868	1	0.00
4869	2	0.00
4869	4	0.00
4869	5	0.00
4869	6	0.00
4869	1	0.00
4870	2	0.00
4870	4	0.00
4870	5	0.00
4870	6	0.00
4870	1	0.00
4871	2	0.00
4871	4	0.00
4871	5	0.00
4871	6	0.00
4871	1	0.00
4872	2	0.00
4872	4	0.00
4872	5	0.00
4872	6	0.00
4872	1	0.00
4873	2	0.00
4873	4	0.00
4873	5	0.00
4873	6	0.00
4873	1	0.00
4874	2	0.00
4874	4	0.00
4874	5	0.00
4874	6	0.00
4874	1	0.00
4875	2	0.00
4875	4	0.00
4875	5	0.00
4875	6	0.00
4875	1	0.00
4876	2	0.00
4876	4	0.00
4876	5	0.00
4876	6	0.00
4876	1	0.00
4877	2	0.00
4877	4	0.00
4877	5	0.00
4877	6	0.00
4877	1	0.00
4878	2	0.00
4878	4	0.00
4878	5	0.00
4878	6	0.00
4878	1	0.00
4879	2	0.00
4879	4	0.00
4879	5	0.00
4879	6	0.00
4879	1	0.00
4880	2	0.00
4880	4	0.00
4880	5	0.00
4880	6	0.00
4880	1	0.00
4881	2	0.00
4881	4	0.00
4881	5	0.00
4881	6	0.00
4881	1	0.00
4882	2	0.00
4882	4	0.00
4882	5	0.00
4882	6	0.00
4882	1	0.00
4883	2	0.00
4883	4	0.00
4883	5	0.00
4883	6	0.00
4883	1	0.00
4884	2	0.00
4884	4	0.00
4884	5	0.00
4884	6	0.00
4884	1	0.00
4885	2	0.00
4885	4	0.00
4885	5	0.00
4885	6	0.00
4885	1	0.00
4886	2	0.00
4886	4	0.00
4886	5	0.00
4886	6	0.00
4886	1	0.00
4887	2	0.00
4887	4	0.00
4887	5	0.00
4887	6	0.00
4887	1	0.00
4888	2	0.00
4888	4	0.00
4888	5	0.00
4888	6	0.00
4888	1	0.00
4889	2	0.00
4889	4	0.00
4889	5	0.00
4889	6	0.00
4889	1	0.00
4890	2	0.00
4890	4	0.00
4890	5	0.00
4890	6	0.00
4890	1	0.00
4891	2	0.00
4891	4	0.00
4891	5	0.00
4891	6	0.00
4891	1	0.00
4892	2	0.00
4892	4	0.00
4892	5	0.00
4892	6	0.00
4892	1	0.00
4893	2	0.00
4893	4	0.00
4893	5	0.00
4893	6	0.00
4893	1	0.00
4894	2	0.00
4894	4	0.00
4894	5	0.00
4894	6	0.00
4894	1	0.00
4895	2	0.00
4895	4	0.00
4895	5	0.00
4895	6	0.00
4895	1	0.00
4896	2	0.00
4896	4	0.00
4896	5	0.00
4896	6	0.00
4896	1	0.00
4897	2	0.00
4897	4	0.00
4897	5	0.00
4897	6	0.00
4897	1	0.00
4898	2	0.00
4898	4	0.00
4898	5	0.00
4898	6	0.00
4898	1	0.00
4899	2	0.00
4899	4	0.00
4899	5	0.00
4899	6	0.00
4899	1	0.00
4900	2	0.00
4900	4	0.00
4900	5	0.00
4900	6	0.00
4900	1	0.00
4901	2	0.00
4901	4	0.00
4901	5	0.00
4901	6	0.00
4901	1	0.00
4902	2	0.00
4902	4	0.00
4902	5	0.00
4902	6	0.00
4902	1	0.00
4903	2	0.00
4903	4	0.00
4903	5	0.00
4903	6	0.00
4903	1	0.00
4904	2	0.00
4904	4	0.00
4904	5	0.00
4904	6	0.00
4904	1	0.00
4905	2	0.00
4905	4	0.00
4905	5	0.00
4905	6	0.00
4905	1	0.00
4906	2	0.00
4906	4	0.00
4906	5	0.00
4906	6	0.00
4906	1	0.00
4907	2	0.00
4907	4	0.00
4907	5	0.00
4907	6	0.00
4907	1	0.00
4908	2	0.00
4908	4	0.00
4908	5	0.00
4908	6	0.00
4908	1	0.00
4909	2	0.00
4909	4	0.00
4909	5	0.00
4909	6	0.00
4909	1	0.00
4910	2	0.00
4910	4	0.00
4910	5	0.00
4910	6	0.00
4911	2	0.00
4911	4	0.00
4911	5	0.00
4911	6	0.00
4911	1	0.00
4912	2	0.00
4912	4	0.00
4912	5	0.00
4912	6	0.00
4912	1	0.00
4913	2	0.00
4913	4	0.00
4913	5	0.00
4913	6	0.00
4913	1	0.00
4914	2	0.00
4914	4	0.00
4914	5	0.00
4914	6	0.00
4914	1	0.00
4915	2	0.00
4915	4	0.00
4915	5	0.00
4915	6	0.00
4915	1	0.00
4916	2	0.00
4916	4	0.00
4916	5	0.00
4916	6	0.00
4916	1	0.00
4917	2	0.00
4917	4	0.00
4917	5	0.00
4917	6	0.00
4917	1	0.00
4918	2	0.00
4918	4	0.00
4918	5	0.00
4918	6	0.00
4918	1	0.00
4919	2	0.00
4919	4	0.00
4919	5	0.00
4919	6	0.00
4920	2	0.00
4920	4	0.00
4920	5	0.00
4920	6	0.00
4920	1	0.00
4921	2	0.00
4921	4	0.00
4921	5	0.00
4921	6	0.00
4921	1	0.00
4922	2	0.00
4922	4	0.00
4922	5	0.00
4922	6	0.00
4922	1	0.00
4923	2	0.00
4923	4	0.00
4923	5	0.00
4923	6	0.00
4923	1	0.00
4924	2	0.00
4924	4	0.00
4924	5	0.00
4924	6	0.00
4924	1	0.00
4925	2	0.00
4925	4	0.00
4925	5	0.00
4925	6	0.00
4925	1	0.00
4926	2	0.00
4926	4	0.00
4926	5	0.00
4926	6	0.00
4926	1	0.00
4927	2	0.00
4927	4	0.00
4927	5	0.00
4927	6	0.00
4927	1	0.00
4928	2	0.00
4928	4	0.00
4928	5	0.00
4928	6	0.00
4928	1	0.00
4929	2	0.00
4929	4	0.00
4929	5	0.00
4929	6	0.00
4929	1	0.00
4930	2	0.00
4930	4	0.00
4930	5	0.00
4930	6	0.00
4930	1	0.00
4931	2	0.00
4931	4	0.00
4931	5	0.00
4931	6	0.00
4931	1	0.00
4932	2	0.00
4932	4	0.00
4932	5	0.00
4932	6	0.00
4932	1	0.00
4933	2	0.00
4933	4	0.00
4933	5	0.00
4933	6	0.00
4933	1	0.00
4934	2	0.00
4934	4	0.00
4934	5	0.00
4934	6	0.00
4934	1	0.00
4935	2	0.00
4935	4	0.00
4935	5	0.00
4935	6	0.00
4935	1	0.00
4936	2	0.00
4936	4	0.00
4936	5	0.00
4936	6	0.00
4936	1	0.00
4937	2	0.00
4937	4	0.00
4937	5	0.00
4937	6	0.00
4937	1	0.00
4938	2	0.00
4938	4	0.00
4938	5	0.00
4938	6	0.00
4938	1	0.00
4939	2	0.00
4939	4	0.00
4939	5	0.00
4939	6	0.00
4939	1	0.00
4940	2	0.00
4940	4	0.00
4940	5	0.00
4940	6	0.00
4940	1	0.00
4941	2	0.00
4941	4	0.00
4941	5	0.00
4941	6	0.00
4941	1	0.00
4942	2	0.00
4942	4	0.00
4942	5	0.00
4942	6	0.00
4942	1	0.00
4943	2	0.00
4943	4	0.00
4943	5	0.00
4943	6	0.00
4943	1	0.00
4944	2	0.00
4944	4	0.00
4944	5	0.00
4944	6	0.00
4944	1	0.00
4945	2	0.00
4945	4	0.00
4945	5	0.00
4945	6	0.00
4945	1	0.00
4946	2	0.00
4946	4	0.00
4946	5	0.00
4946	6	0.00
4946	1	0.00
4947	2	0.00
4947	4	0.00
4947	5	0.00
4947	6	0.00
4947	1	0.00
4948	2	0.00
4948	4	0.00
4948	5	0.00
4948	6	0.00
4948	1	0.00
4949	2	0.00
4949	4	0.00
4949	5	0.00
4949	6	0.00
4949	1	0.00
4950	2	0.00
4950	4	0.00
4950	5	0.00
4950	6	0.00
4950	1	0.00
4951	2	0.00
4951	4	0.00
4951	5	0.00
4951	6	0.00
4951	1	0.00
4952	2	0.00
4952	4	0.00
4952	5	0.00
4952	6	0.00
4952	1	0.00
4953	2	0.00
4953	4	0.00
4953	5	0.00
4953	6	0.00
4953	1	0.00
4954	2	0.00
4954	4	0.00
4954	5	0.00
4954	6	0.00
4954	1	0.00
4955	2	0.00
4955	4	0.00
4955	5	0.00
4955	6	0.00
4955	1	0.00
4956	2	0.00
4956	4	0.00
4956	5	0.00
4956	6	0.00
4956	1	0.00
4957	2	0.00
4957	4	0.00
4957	5	0.00
4957	6	0.00
4957	1	0.00
4958	2	0.00
4958	4	0.00
4958	5	0.00
4958	6	0.00
4958	1	0.00
4959	2	0.00
4959	4	0.00
4959	5	0.00
4959	6	0.00
4959	1	0.00
4960	2	0.00
4960	4	0.00
4960	5	0.00
4960	6	0.00
4960	1	0.00
4961	2	0.00
4961	4	0.00
4961	5	0.00
4961	6	0.00
4961	1	0.00
4962	2	0.00
4962	4	0.00
4962	5	0.00
4962	6	0.00
4962	1	0.00
4963	2	0.00
4963	4	0.00
4963	5	0.00
4963	6	0.00
4963	1	0.00
4964	2	0.00
4964	4	0.00
4964	5	0.00
4964	6	0.00
4964	1	0.00
4965	2	0.00
4965	4	0.00
4965	5	0.00
4965	6	0.00
4965	1	0.00
4966	2	0.00
4966	4	0.00
4966	5	0.00
4966	6	0.00
4966	1	0.00
4967	2	0.00
4967	4	0.00
4967	5	0.00
4967	6	0.00
4967	1	0.00
4968	2	0.00
4968	4	0.00
4968	5	0.00
4968	6	0.00
4968	1	0.00
4969	2	0.00
4969	4	0.00
4969	5	0.00
4969	6	0.00
4969	1	0.00
4970	2	0.00
4970	4	0.00
4970	5	0.00
4970	6	0.00
4970	1	0.00
4971	2	0.00
4971	4	0.00
4971	5	0.00
4971	6	0.00
4971	1	0.00
4972	2	0.00
4972	4	0.00
4972	5	0.00
4972	6	0.00
4972	1	0.00
4973	2	0.00
4973	4	0.00
4973	5	0.00
4973	6	0.00
4973	1	0.00
4974	2	0.00
4974	4	0.00
4974	5	0.00
4974	6	0.00
4974	1	0.00
4975	2	0.00
4975	4	0.00
4975	5	0.00
4975	6	0.00
4975	1	0.00
4976	2	0.00
4976	4	0.00
4976	5	0.00
4976	6	0.00
4976	1	0.00
4977	2	0.00
4977	4	0.00
4977	5	0.00
4977	6	0.00
4977	1	0.00
4978	2	0.00
4978	4	0.00
4978	5	0.00
4978	6	0.00
4978	1	0.00
4979	2	0.00
4979	4	0.00
4979	5	0.00
4979	6	0.00
4979	1	0.00
4980	2	0.00
4980	4	0.00
4980	5	0.00
4980	6	0.00
4980	1	0.00
4981	2	0.00
4981	4	0.00
4981	5	0.00
4981	6	0.00
4981	1	0.00
4982	2	0.00
4982	4	0.00
4982	5	0.00
4982	6	0.00
4982	1	0.00
4983	2	0.00
4983	4	0.00
4983	5	0.00
4983	6	0.00
4983	1	0.00
4984	2	0.00
4984	4	0.00
4984	5	0.00
4984	6	0.00
4984	1	0.00
4985	2	0.00
4985	4	0.00
4985	5	0.00
4985	6	0.00
4985	1	0.00
4986	2	0.00
4986	4	0.00
4986	5	0.00
4986	6	0.00
4986	1	0.00
4987	2	0.00
4987	4	0.00
4987	5	0.00
4987	6	0.00
4987	1	0.00
4988	2	0.00
4988	4	0.00
4988	5	0.00
4988	6	0.00
4988	1	0.00
4989	2	0.00
4989	4	0.00
4989	5	0.00
4989	6	0.00
4989	1	0.00
4990	2	0.00
4990	4	0.00
4990	5	0.00
4990	6	0.00
4990	1	0.00
4991	2	0.00
4991	4	0.00
4991	5	0.00
4991	6	0.00
4991	1	0.00
4992	2	0.00
4992	4	0.00
4992	5	0.00
4992	6	0.00
4992	1	0.00
4993	2	0.00
4993	4	0.00
4993	5	0.00
4993	6	0.00
4993	1	0.00
4994	2	0.00
4994	4	0.00
4994	5	0.00
4994	6	0.00
4994	1	0.00
4995	2	0.00
4995	4	0.00
4995	5	0.00
4995	6	0.00
4995	1	0.00
4996	2	0.00
4996	4	0.00
4996	5	0.00
4996	6	0.00
4996	1	0.00
4997	2	0.00
4997	4	0.00
4997	5	0.00
4997	6	0.00
4997	1	0.00
4998	2	0.00
4998	4	0.00
4998	5	0.00
4998	6	0.00
4998	1	0.00
4999	2	0.00
4999	4	0.00
4999	5	0.00
4999	6	0.00
4999	1	0.00
5000	2	0.00
5000	4	0.00
5000	5	0.00
5000	6	0.00
5000	1	0.00
5001	2	0.00
5001	4	0.00
5001	5	0.00
5001	6	0.00
5001	1	0.00
5002	2	0.00
5002	4	0.00
5002	5	0.00
5002	6	0.00
5002	1	0.00
5003	2	0.00
5003	4	0.00
5003	5	0.00
5003	6	0.00
5003	1	0.00
5004	2	0.00
5004	4	0.00
5004	5	0.00
5004	6	0.00
5004	1	0.00
5005	2	0.00
5005	4	0.00
5005	5	0.00
5005	6	0.00
5005	1	0.00
5006	2	0.00
5006	4	0.00
5006	5	0.00
5006	6	0.00
5006	1	0.00
5007	2	0.00
5007	4	0.00
5007	5	0.00
5007	6	0.00
5007	1	0.00
5008	2	0.00
5008	4	0.00
5008	5	0.00
5008	6	0.00
5008	1	0.00
5009	2	0.00
5009	4	0.00
5009	5	0.00
5009	6	0.00
5009	1	0.00
5010	2	0.00
5010	4	0.00
5010	5	0.00
5010	6	0.00
5010	1	0.00
5011	2	0.00
5011	4	0.00
5011	5	0.00
5011	6	0.00
5011	1	0.00
5012	2	0.00
5012	4	0.00
5012	5	0.00
5012	6	0.00
5012	1	0.00
5013	2	0.00
5013	4	0.00
5013	5	0.00
5013	6	0.00
5013	1	0.00
5014	2	0.00
5014	4	0.00
5014	5	0.00
5014	6	0.00
5014	1	0.00
5015	2	0.00
5015	4	0.00
5015	5	0.00
5015	6	0.00
5015	1	0.00
5016	2	0.00
5016	4	0.00
5016	5	0.00
5016	6	0.00
5016	1	0.00
5017	2	0.00
5017	4	0.00
5017	5	0.00
5017	6	0.00
5017	1	0.00
5018	2	0.00
5018	4	0.00
5018	5	0.00
5018	6	0.00
5018	1	0.00
5019	2	0.00
5019	4	0.00
5019	5	0.00
5019	6	0.00
5019	1	0.00
5020	2	0.00
5020	4	0.00
5020	5	0.00
5020	6	0.00
5020	1	0.00
5021	2	0.00
5021	4	0.00
5021	5	0.00
5021	6	0.00
5021	1	0.00
5022	2	0.00
5022	4	0.00
5022	5	0.00
5022	6	0.00
5022	1	0.00
5023	2	0.00
5023	4	0.00
5023	5	0.00
5023	6	0.00
5023	1	0.00
5024	2	0.00
5024	4	0.00
5024	5	0.00
5024	6	0.00
5024	1	0.00
5025	2	0.00
5025	4	0.00
5025	5	0.00
5025	6	0.00
5025	1	0.00
5026	2	0.00
5026	4	0.00
5026	5	0.00
5026	6	0.00
5026	1	0.00
5027	2	0.00
5027	4	0.00
5027	5	0.00
5027	6	0.00
5027	1	0.00
5028	2	0.00
5028	4	0.00
5028	5	0.00
5028	6	0.00
5028	1	0.00
5029	2	0.00
5029	4	0.00
5029	5	0.00
5029	6	0.00
5029	1	0.00
5030	2	0.00
5030	4	0.00
5030	5	0.00
5030	6	0.00
5030	1	0.00
5031	2	0.00
5031	4	0.00
5031	5	0.00
5031	6	0.00
5031	1	0.00
5032	2	0.00
5032	4	0.00
5032	5	0.00
5032	6	0.00
5032	1	0.00
5033	2	0.00
5033	4	0.00
5033	5	0.00
5033	6	0.00
5033	1	0.00
5034	2	0.00
5034	4	0.00
5034	5	0.00
5034	6	0.00
5034	1	0.00
5035	2	0.00
5035	4	0.00
5035	5	0.00
5035	6	0.00
5035	1	0.00
5036	2	0.00
5036	4	0.00
5036	5	0.00
5036	6	0.00
5036	1	0.00
5037	2	0.00
5037	4	0.00
5037	5	0.00
5037	6	0.00
5037	1	0.00
5038	2	0.00
5038	4	0.00
5038	5	0.00
5038	6	0.00
5038	1	0.00
5039	2	0.00
5039	4	0.00
5039	5	0.00
5039	6	0.00
5039	1	0.00
5040	2	0.00
5040	4	0.00
5040	5	0.00
5040	6	0.00
5040	1	0.00
5041	2	0.00
5041	4	0.00
5041	5	0.00
5041	6	0.00
5041	1	0.00
5042	2	0.00
5042	4	0.00
5042	5	0.00
5042	6	0.00
5042	1	0.00
5043	2	0.00
5043	4	0.00
5043	5	0.00
5043	6	0.00
5043	1	0.00
5044	2	0.00
5044	4	0.00
5044	5	0.00
5044	6	0.00
5044	1	0.00
5045	2	0.00
5045	4	0.00
5045	5	0.00
5045	6	0.00
5045	1	0.00
5046	2	0.00
5046	4	0.00
5046	5	0.00
5046	6	0.00
5046	1	0.00
5047	2	0.00
5047	4	0.00
5047	5	0.00
5047	6	0.00
5047	1	0.00
5048	2	0.00
5048	4	0.00
5048	5	0.00
5048	6	0.00
5048	1	0.00
5049	2	0.00
5049	4	0.00
5049	5	0.00
5049	6	0.00
5049	1	0.00
5050	2	0.00
5050	4	0.00
5050	5	0.00
5050	6	0.00
5050	1	0.00
5051	2	0.00
5051	4	0.00
5051	5	0.00
5051	6	0.00
5051	1	0.00
5052	2	0.00
5052	4	0.00
5052	5	0.00
5052	6	0.00
5052	1	0.00
5053	2	0.00
5053	4	0.00
5053	5	0.00
5053	6	0.00
5053	1	0.00
5054	2	0.00
5054	4	0.00
5054	5	0.00
5054	6	0.00
5054	1	0.00
5055	2	0.00
5055	4	0.00
5055	5	0.00
5055	6	0.00
5055	1	0.00
5056	2	0.00
5056	4	0.00
5056	5	0.00
5056	6	0.00
4230	1	0.00
5056	1	0.00
5057	2	0.00
5057	4	0.00
5057	5	0.00
5057	6	0.00
5057	1	0.00
5058	2	0.00
4211	1	0.00
5058	4	0.00
3252	1	0.00
5058	5	0.00
3258	1	0.00
5058	6	0.00
5058	1	0.00
5059	2	0.00
5059	4	0.00
5059	5	0.00
5059	6	0.00
5059	1	0.00
5060	2	0.00
5060	4	0.00
5060	5	0.00
5060	6	0.00
5060	1	0.00
5061	2	0.00
5061	4	0.00
5061	5	0.00
5061	6	0.00
5061	1	0.00
5062	2	0.00
5062	4	0.00
5062	5	0.00
5062	6	0.00
5062	1	0.00
5063	2	0.00
5063	4	0.00
5063	5	0.00
5063	6	0.00
5063	1	0.00
5064	2	0.00
5064	4	0.00
5064	5	0.00
5064	6	0.00
4238	1	0.00
5064	1	0.00
5065	2	0.00
5065	4	0.00
5065	5	0.00
5065	6	0.00
5065	1	0.00
5066	2	0.00
5066	4	0.00
5066	5	0.00
5066	6	0.00
5066	1	0.00
5067	2	0.00
5067	4	0.00
5067	5	0.00
5067	6	0.00
5067	1	0.00
5068	2	0.00
5068	4	0.00
5068	5	0.00
5068	6	0.00
5068	1	0.00
5069	2	0.00
5069	4	0.00
5069	5	0.00
5069	6	0.00
5069	1	0.00
5070	2	0.00
3586	1	0.00
5070	4	0.00
5070	5	0.00
5070	6	0.00
5070	1	0.00
5071	2	0.00
5071	4	0.00
5071	5	0.00
5071	6	0.00
5071	1	0.00
5072	2	0.00
4237	1	0.00
5072	4	0.00
5072	5	0.00
5072	6	0.00
5072	1	0.00
5073	2	0.00
4204	1	0.00
5073	4	0.00
5073	5	0.00
5073	6	0.00
5073	1	0.00
5074	2	0.00
5074	4	0.00
5074	5	0.00
5074	6	0.00
5074	1	0.00
5075	2	0.00
5075	4	0.00
5075	5	0.00
5075	6	0.00
5075	1	0.00
5076	2	0.00
4240	1	0.00
5076	4	0.00
3535	1	0.00
5076	5	0.00
5076	6	0.00
5076	1	0.00
5077	2	0.00
5077	4	0.00
5077	5	0.00
5077	6	0.00
5077	1	0.00
5078	2	0.00
5078	4	0.00
5078	5	0.00
5078	6	0.00
5078	1	0.00
4531	1	0.00
5079	2	0.00
5079	4	0.00
5079	5	0.00
5079	6	0.00
5079	1	0.00
5080	2	0.00
5080	4	0.00
5080	5	0.00
5080	6	0.00
5080	1	0.00
5081	2	0.00
5081	4	0.00
5081	5	0.00
5081	6	0.00
5081	1	0.00
5082	2	0.00
5082	4	0.00
5082	5	0.00
5082	6	0.00
5082	1	0.00
5083	2	0.00
3937	1	0.00
5083	4	0.00
5083	5	0.00
5083	6	0.00
5083	1	0.00
5084	2	0.00
5084	4	0.00
5084	5	0.00
5084	6	0.00
5084	1	0.00
5085	2	0.00
5085	4	0.00
5085	5	0.00
5085	6	0.00
5085	1	0.00
5086	2	0.00
5086	4	0.00
5086	5	0.00
5086	6	0.00
5086	1	0.00
5087	2	0.00
5087	4	0.00
5087	5	0.00
5087	6	0.00
5087	1	0.00
5088	2	0.00
5088	4	0.00
5088	5	0.00
5088	6	0.00
5088	1	0.00
5089	2	0.00
5089	4	0.00
5089	5	0.00
5089	6	0.00
5089	1	0.00
5090	2	0.00
5090	4	0.00
5090	5	0.00
5090	6	0.00
5090	1	0.00
5091	2	0.00
5091	4	0.00
5091	5	0.00
5091	6	0.00
5091	1	0.00
5092	2	0.00
5092	4	0.00
5092	5	0.00
4540	1	0.00
5092	6	0.00
5092	1	0.00
5093	2	0.00
5093	4	0.00
5093	5	0.00
5093	6	0.00
5093	1	0.00
5094	2	0.00
5094	4	0.00
5094	5	0.00
5094	6	0.00
5094	1	0.00
5095	2	0.00
5095	4	0.00
5095	5	0.00
5095	6	0.00
5095	1	0.00
5096	2	0.00
5096	4	0.00
5096	5	0.00
5096	6	0.00
5096	1	0.00
5097	2	0.00
5097	4	0.00
5097	5	0.00
5097	6	0.00
5097	1	0.00
5098	2	0.00
5098	4	0.00
5098	5	0.00
5098	6	0.00
5098	1	0.00
5099	2	0.00
5099	4	0.00
5099	5	0.00
5099	6	0.00
5099	1	0.00
5100	2	0.00
5100	4	0.00
5100	5	0.00
5100	6	0.00
5100	1	0.00
5101	2	0.00
5101	4	0.00
5101	5	0.00
5101	6	0.00
5101	1	0.00
5102	2	0.00
5102	4	0.00
4474	1	0.00
5102	5	0.00
5102	6	0.00
5102	1	0.00
4538	1	0.00
5103	2	0.00
5103	4	0.00
5103	5	0.00
4389	1	0.00
5103	6	0.00
5103	1	0.00
5104	2	0.00
5104	4	0.00
5104	5	0.00
5104	6	0.00
5104	1	0.00
5105	2	0.00
5105	4	0.00
5105	5	0.00
5105	6	0.00
5105	1	0.00
5106	2	0.00
5106	4	0.00
5106	5	0.00
5106	6	0.00
5106	1	0.00
5107	2	0.00
5107	4	0.00
5107	5	0.00
5107	6	0.00
5107	1	0.00
5108	2	0.00
5108	4	0.00
5108	5	0.00
5108	6	0.00
5108	1	0.00
5109	2	0.00
5109	4	0.00
5109	5	0.00
5109	6	0.00
5109	1	0.00
5110	2	0.00
5110	4	0.00
5110	5	0.00
5110	6	0.00
5110	1	0.00
3664	1	0.00
5111	2	0.00
5111	4	0.00
5111	5	0.00
5111	6	0.00
5111	1	0.00
5112	2	0.00
5112	4	0.00
5112	5	0.00
5112	6	0.00
4500	1	0.00
5112	1	0.00
5113	2	0.00
5113	4	0.00
5113	5	0.00
5113	6	0.00
5113	1	0.00
5114	2	0.00
5114	4	0.00
5114	5	0.00
3256	1	0.00
5114	6	0.00
5114	1	0.00
5115	2	0.00
5115	4	0.00
5115	5	0.00
5115	6	0.00
5115	1	0.00
5116	2	0.00
5116	4	0.00
5116	5	0.00
5116	6	0.00
5116	1	0.00
5117	2	0.00
5117	4	0.00
5117	5	0.00
5117	6	0.00
5117	1	0.00
5118	2	0.00
5118	4	0.00
5118	5	0.00
5118	6	0.00
5118	1	0.00
5119	2	0.00
4560	1	0.00
5119	4	0.00
5119	5	0.00
5119	6	0.00
5119	1	0.00
5120	2	0.00
5120	4	0.00
5120	5	0.00
5120	6	0.00
5120	1	0.00
5121	2	0.00
5121	4	0.00
5121	5	0.00
5121	6	0.00
5121	1	0.00
5122	2	0.00
5122	4	0.00
5122	5	0.00
5122	6	0.00
5122	1	0.00
4434	1	0.00
5123	2	0.00
5123	4	0.00
5123	5	0.00
5123	6	0.00
5123	1	0.00
5124	2	0.00
5124	4	0.00
5124	5	0.00
5124	6	0.00
5124	1	0.00
5125	2	0.00
5125	4	0.00
5125	5	0.00
5125	6	0.00
5125	1	0.00
5126	2	0.00
5126	4	0.00
5126	5	0.00
5126	6	0.00
5126	1	0.00
5127	2	0.00
5127	4	0.00
5127	5	0.00
5127	6	0.00
5127	1	0.00
5128	2	0.00
5128	4	0.00
5128	5	0.00
5128	6	0.00
5128	1	0.00
5129	2	0.00
5129	4	0.00
5129	5	0.00
5129	6	0.00
5129	1	0.00
5130	2	0.00
5130	4	0.00
5130	5	0.00
5130	6	0.00
5130	1	0.00
5131	2	0.00
5131	4	0.00
5131	5	0.00
4553	1	0.00
5131	6	0.00
5131	1	0.00
5132	2	0.00
5132	4	0.00
5132	5	0.00
5132	6	0.00
5132	1	0.00
5133	2	0.00
5133	4	0.00
5133	5	0.00
5133	6	0.00
5133	1	0.00
5134	2	0.00
5134	4	0.00
5134	5	0.00
5134	6	0.00
5134	1	0.00
5135	2	0.00
5135	4	0.00
5135	5	0.00
5135	6	0.00
5135	1	0.00
5136	2	0.00
5136	4	0.00
5136	5	0.00
5136	6	0.00
5136	1	0.00
5137	2	0.00
5137	4	0.00
5137	5	0.00
5137	6	0.00
5137	1	0.00
5138	2	0.00
5138	4	0.00
5138	5	0.00
5138	6	0.00
5138	1	0.00
5139	2	0.00
5139	4	0.00
5139	5	0.00
5139	6	0.00
5139	1	0.00
5140	2	0.00
5140	4	0.00
5140	5	0.00
5140	6	0.00
5140	1	0.00
5141	2	0.00
5141	4	0.00
5141	5	0.00
5141	6	0.00
5141	1	0.00
5142	2	0.00
5142	4	0.00
5142	5	0.00
5142	6	0.00
5142	1	0.00
5143	2	0.00
5143	4	0.00
5143	5	0.00
5143	6	0.00
5143	1	0.00
5144	2	0.00
5144	4	0.00
5144	5	0.00
5144	6	0.00
5144	1	0.00
5145	2	0.00
5145	4	0.00
5145	5	0.00
5145	6	0.00
5145	1	0.00
5146	2	0.00
5146	4	0.00
5146	5	0.00
5146	6	0.00
5146	1	0.00
3825	1	0.00
5147	2	0.00
5147	4	0.00
5147	5	0.00
2896	1	0.00
5147	6	0.00
5147	1	0.00
5148	2	0.00
5148	4	0.00
5148	5	0.00
5148	6	0.00
5148	1	0.00
5149	2	0.00
5149	4	0.00
5149	5	0.00
5149	6	0.00
5149	1	0.00
5150	2	0.00
5150	4	0.00
5150	5	0.00
5150	6	0.00
5150	1	0.00
5151	2	0.00
5151	4	0.00
5151	5	0.00
5151	6	0.00
5151	1	0.00
5152	2	0.00
5152	4	0.00
5152	5	0.00
3364	1	0.00
5152	6	0.00
5152	1	0.00
5153	2	0.00
5153	4	0.00
5153	5	0.00
5153	6	0.00
5153	1	0.00
2890	1	0.00
5154	2	0.00
5154	4	0.00
5154	5	0.00
5154	6	0.00
5154	1	0.00
5155	2	0.00
5155	4	0.00
5155	5	0.00
5155	6	0.00
5155	1	0.00
5156	2	0.00
3227	1	0.00
5156	4	0.00
5156	5	0.00
5156	6	0.00
5156	1	0.00
5157	2	0.00
5157	4	0.00
5157	5	0.00
5157	6	0.00
5157	1	0.00
5158	2	0.00
5158	4	0.00
2961	1	0.00
5158	5	0.00
3139	1	0.00
5158	6	0.00
5158	1	0.00
5159	2	0.00
5159	4	0.00
5159	5	0.00
5159	6	0.00