/***************************************************************************
 *   Copyright (C) 2005 by Tomeu Borras Riera                              *
 *   tborras@conetxia.com                                                  *
 *   http://www.iglues.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BUSQUEDATIPOARTICULO_H
#define BUSQUEDATIPOARTICULO_H

#include <QLineEdit>
#include <QLabel>

#include "blwidget.h"
#include "ui_busquedatipoarticulobase.h"


class company;

/// Permite buscar y seleccionar un tipo de art&iacute;culo.
/** Este Widget permite buscar y seleccionar un
    tipo de art&iacute;culo. */
class BusquedaTipoArticulo : public BLWidget, public Ui_BusquedaTipoArticuloBase
{
    Q_OBJECT

private:
    /// Almacena el idtipo_articulo del elemento seleccionado.
    QString mdb_idtipo_articulo;
    /// Almacena la descripcion del tipo de articulo seleccionado.
    QString mdb_desctipo_articulo;
    /// Almacena el codigo del tipo de articulo seleccionado.
    QString mdb_codtipo_articulo;

public:
    BusquedaTipoArticulo ( QWidget *parent = 0 );
    ~BusquedaTipoArticulo();
    virtual QString codtipo_articulo();
    virtual QString idtipo_articulo();
    virtual QString valorCampo();
    virtual QString desctipo_articulo();
    virtual void setidtipo_articulo ( QString val );
    virtual void setValorCampo ( QString val );
    virtual void setcodtipo_articulo ( QString val );

public slots:
    virtual void on_mui_buscar_clicked();
    virtual void on_m_codtipo_articulo_textChanged ( const QString & );

signals:
    void valueChanged ( QString );
};

#endif

