/////////////////////////////////////////////////////////////////////////
// $Id: dis_tables.inc 10891 2011-12-29 21:41:56Z sshwarts $
/////////////////////////////////////////////////////////////////////////
//
//   Copyright (c) 2005-2011 Stanislav Shwartsman
//          Written by Stanislav Shwartsman [sshwarts at sourceforge net]
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
//
/////////////////////////////////////////////////////////////////////////

/* ************************************************************************ */
/* Opcode GroupN */

/* Group1 */
static BxDisasmOpcodeTable_t BxDisasmGroupG1EbIb[8] = {
  /* 0 */ { 0, &Ia_addb_Eb_Ib },
  /* 1 */ { 0, &Ia_orb_Eb_Ib  },
  /* 2 */ { 0, &Ia_adcb_Eb_Ib },
  /* 3 */ { 0, &Ia_sbbb_Eb_Ib },
  /* 4 */ { 0, &Ia_andb_Eb_Ib },
  /* 5 */ { 0, &Ia_subb_Eb_Ib },
  /* 6 */ { 0, &Ia_xorb_Eb_Ib },
  /* 7 */ { 0, &Ia_cmpb_Eb_Ib }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG1EwIw[8] = {
  /* 0 */ { 0, &Ia_addw_Ew_Iw },
  /* 1 */ { 0, &Ia_orw_Ew_Iw  },
  /* 2 */ { 0, &Ia_adcw_Ew_Iw },
  /* 3 */ { 0, &Ia_sbbw_Ew_Iw },
  /* 4 */ { 0, &Ia_andw_Ew_Iw },
  /* 5 */ { 0, &Ia_subw_Ew_Iw },
  /* 6 */ { 0, &Ia_xorw_Ew_Iw },
  /* 7 */ { 0, &Ia_cmpw_Ew_Iw }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG1EdId[8] = {
  /* 0 */ { 0, &Ia_addl_Ed_Id },
  /* 1 */ { 0, &Ia_orl_Ed_Id  },
  /* 2 */ { 0, &Ia_adcl_Ed_Id },
  /* 3 */ { 0, &Ia_sbbl_Ed_Id },
  /* 4 */ { 0, &Ia_andl_Ed_Id },
  /* 5 */ { 0, &Ia_subl_Ed_Id },
  /* 6 */ { 0, &Ia_xorl_Ed_Id },
  /* 7 */ { 0, &Ia_cmpl_Ed_Id }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG1EqId[8] = {
  /* 0 */ { 0, &Ia_addq_Eq_sId },
  /* 1 */ { 0, &Ia_orq_Eq_sId  },
  /* 2 */ { 0, &Ia_adcq_Eq_sId },
  /* 3 */ { 0, &Ia_sbbq_Eq_sId },
  /* 4 */ { 0, &Ia_andq_Eq_sId },
  /* 5 */ { 0, &Ia_subq_Eq_sId },
  /* 6 */ { 0, &Ia_xorq_Eq_sId },
  /* 7 */ { 0, &Ia_cmpq_Eq_sId }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG1EwIb[8] = {
  /* 0 */ { 0, &Ia_addw_Ew_sIb },	// sign-extend byte
  /* 1 */ { 0, &Ia_orw_Ew_sIb  },
  /* 2 */ { 0, &Ia_adcw_Ew_sIb },
  /* 3 */ { 0, &Ia_sbbw_Ew_sIb },
  /* 4 */ { 0, &Ia_andw_Ew_sIb },
  /* 5 */ { 0, &Ia_subw_Ew_sIb },
  /* 6 */ { 0, &Ia_xorw_Ew_sIb },
  /* 7 */ { 0, &Ia_cmpw_Ew_sIb }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG1EdIb[8] = {
  /* 0 */ { 0, &Ia_addl_Ed_sIb },	// sign-extend byte
  /* 1 */ { 0, &Ia_orl_Ed_sIb  },
  /* 2 */ { 0, &Ia_adcl_Ed_sIb },
  /* 3 */ { 0, &Ia_sbbl_Ed_sIb },
  /* 4 */ { 0, &Ia_andl_Ed_sIb },
  /* 5 */ { 0, &Ia_subl_Ed_sIb },
  /* 6 */ { 0, &Ia_xorl_Ed_sIb },
  /* 7 */ { 0, &Ia_cmpl_Ed_sIb }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG1EqIb[8] = {
  /* 0 */ { 0, &Ia_addq_Eq_sIb },	// sign-extend byte
  /* 1 */ { 0, &Ia_orq_Eq_sIb  },
  /* 2 */ { 0, &Ia_adcq_Eq_sIb },
  /* 3 */ { 0, &Ia_sbbq_Eq_sIb },
  /* 4 */ { 0, &Ia_andq_Eq_sIb },
  /* 5 */ { 0, &Ia_subq_Eq_sIb },
  /* 6 */ { 0, &Ia_xorq_Eq_sIb },
  /* 7 */ { 0, &Ia_cmpq_Eq_sIb }
};

/* Group2 */
static BxDisasmOpcodeTable_t BxDisasmGroupG2Eb[8] = {
  /* 0 */ { 0, &Ia_rolb_Eb_Ib },
  /* 1 */ { 0, &Ia_rorb_Eb_Ib },
  /* 2 */ { 0, &Ia_rclb_Eb_Ib },
  /* 3 */ { 0, &Ia_rcrb_Eb_Ib },
  /* 4 */ { 0, &Ia_shlb_Eb_Ib },
  /* 5 */ { 0, &Ia_shrb_Eb_Ib },
  /* 6 */ { 0, &Ia_shlb_Eb_Ib },
  /* 7 */ { 0, &Ia_sarb_Eb_Ib }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EbI1[8] = {
  /* 0 */ { 0, &Ia_rolb_Eb_I1 },
  /* 1 */ { 0, &Ia_rorb_Eb_I1 },
  /* 2 */ { 0, &Ia_rclb_Eb_I1 },
  /* 3 */ { 0, &Ia_rcrb_Eb_I1 },
  /* 4 */ { 0, &Ia_shlb_Eb_I1 },
  /* 5 */ { 0, &Ia_shrb_Eb_I1 },
  /* 6 */ { 0, &Ia_shlb_Eb_I1 },
  /* 7 */ { 0, &Ia_sarb_Eb_I1 }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EbCL[8] = {
  /* 0 */ { 0, &Ia_rolb_Eb_CL },
  /* 1 */ { 0, &Ia_rorb_Eb_CL },
  /* 2 */ { 0, &Ia_rclb_Eb_CL },
  /* 3 */ { 0, &Ia_rcrb_Eb_CL },
  /* 4 */ { 0, &Ia_shlb_Eb_CL },
  /* 5 */ { 0, &Ia_shrb_Eb_CL },
  /* 6 */ { 0, &Ia_shlb_Eb_CL },
  /* 7 */ { 0, &Ia_sarb_Eb_CL }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2Ew[8] = {
  /* 0 */ { 0, &Ia_rolw_Ew_Ib },
  /* 1 */ { 0, &Ia_rorw_Ew_Ib },
  /* 2 */ { 0, &Ia_rclw_Ew_Ib },
  /* 3 */ { 0, &Ia_rcrw_Ew_Ib },
  /* 4 */ { 0, &Ia_shlw_Ew_Ib },
  /* 5 */ { 0, &Ia_shrw_Ew_Ib },
  /* 6 */ { 0, &Ia_shlw_Ew_Ib },
  /* 7 */ { 0, &Ia_sarw_Ew_Ib }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2Ed[8] = {
  /* 0 */ { 0, &Ia_roll_Ed_Ib },
  /* 1 */ { 0, &Ia_rorl_Ed_Ib },
  /* 2 */ { 0, &Ia_rcll_Ed_Ib },
  /* 3 */ { 0, &Ia_rcrl_Ed_Ib },
  /* 4 */ { 0, &Ia_shll_Ed_Ib },
  /* 5 */ { 0, &Ia_shrl_Ed_Ib },
  /* 6 */ { 0, &Ia_shll_Ed_Ib },
  /* 7 */ { 0, &Ia_sarl_Ed_Ib }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2Eq[8] = {
  /* 0 */ { 0, &Ia_rolq_Eq_Ib },
  /* 1 */ { 0, &Ia_rorq_Eq_Ib },
  /* 2 */ { 0, &Ia_rclq_Eq_Ib },
  /* 3 */ { 0, &Ia_rcrq_Eq_Ib },
  /* 4 */ { 0, &Ia_shlq_Eq_Ib },
  /* 5 */ { 0, &Ia_shrq_Eq_Ib },
  /* 6 */ { 0, &Ia_shlq_Eq_Ib },
  /* 7 */ { 0, &Ia_sarq_Eq_Ib }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EwI1[8] = {
  /* 0 */ { 0, &Ia_rolw_Ew_I1 },
  /* 1 */ { 0, &Ia_rorw_Ew_I1 },
  /* 2 */ { 0, &Ia_rclw_Ew_I1 },
  /* 3 */ { 0, &Ia_rcrw_Ew_I1 },
  /* 4 */ { 0, &Ia_shlw_Ew_I1 },
  /* 5 */ { 0, &Ia_shrw_Ew_I1 },
  /* 6 */ { 0, &Ia_shlw_Ew_I1 },
  /* 7 */ { 0, &Ia_sarw_Ew_I1 }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EdI1[8] = {
  /* 0 */ { 0, &Ia_roll_Ed_I1 },
  /* 1 */ { 0, &Ia_rorl_Ed_I1 },
  /* 2 */ { 0, &Ia_rcll_Ed_I1 },
  /* 3 */ { 0, &Ia_rcrl_Ed_I1 },
  /* 4 */ { 0, &Ia_shll_Ed_I1 },
  /* 5 */ { 0, &Ia_shrl_Ed_I1 },
  /* 6 */ { 0, &Ia_shll_Ed_I1 },
  /* 7 */ { 0, &Ia_sarl_Ed_I1 }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EqI1[8] = {
  /* 0 */ { 0, &Ia_rolq_Eq_I1 },
  /* 1 */ { 0, &Ia_rorq_Eq_I1 },
  /* 2 */ { 0, &Ia_rclq_Eq_I1 },
  /* 3 */ { 0, &Ia_rcrq_Eq_I1 },
  /* 4 */ { 0, &Ia_shlq_Eq_I1 },
  /* 5 */ { 0, &Ia_shrq_Eq_I1 },
  /* 6 */ { 0, &Ia_shlq_Eq_I1 },
  /* 7 */ { 0, &Ia_sarq_Eq_I1 }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EwCL[8] = {
  /* 0 */ { 0, &Ia_rolw_Ew_CL },
  /* 1 */ { 0, &Ia_rorw_Ew_CL },
  /* 2 */ { 0, &Ia_rclw_Ew_CL },
  /* 3 */ { 0, &Ia_rcrw_Ew_CL },
  /* 4 */ { 0, &Ia_shlw_Ew_CL },
  /* 5 */ { 0, &Ia_shrw_Ew_CL },
  /* 6 */ { 0, &Ia_shlw_Ew_CL },
  /* 7 */ { 0, &Ia_sarw_Ew_CL }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EdCL[8] = {
  /* 0 */ { 0, &Ia_roll_Ed_CL },
  /* 1 */ { 0, &Ia_rorl_Ed_CL },
  /* 2 */ { 0, &Ia_rcll_Ed_CL },
  /* 3 */ { 0, &Ia_rcrl_Ed_CL },
  /* 4 */ { 0, &Ia_shll_Ed_CL },
  /* 5 */ { 0, &Ia_shrl_Ed_CL },
  /* 6 */ { 0, &Ia_shll_Ed_CL },
  /* 7 */ { 0, &Ia_sarl_Ed_CL }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG2EqCL[8] = {
  /* 0 */ { 0, &Ia_rolq_Eq_CL },
  /* 1 */ { 0, &Ia_rorq_Eq_CL },
  /* 2 */ { 0, &Ia_rclq_Eq_CL },
  /* 3 */ { 0, &Ia_rcrq_Eq_CL },
  /* 4 */ { 0, &Ia_shlq_Eq_CL },
  /* 5 */ { 0, &Ia_shrq_Eq_CL },
  /* 6 */ { 0, &Ia_shlq_Eq_CL },
  /* 7 */ { 0, &Ia_sarq_Eq_CL }
};

/* Group3 */
static BxDisasmOpcodeTable_t BxDisasmGroupG3Eb[8] = {
  /* 0 */ { 0, &Ia_testb_Eb_Ib },
  /* 1 */ { 0, &Ia_testb_Eb_Ib },
  /* 2 */ { 0, &Ia_notb_Eb     },
  /* 3 */ { 0, &Ia_negb_Eb     },
  /* 4 */ { 0, &Ia_mulb_AL_Eb  },
  /* 5 */ { 0, &Ia_imulb_AL_Eb },
  /* 6 */ { 0, &Ia_divb_AL_Eb  },
  /* 7 */ { 0, &Ia_idivb_AL_Eb }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG3Ew[8] = {
  /* 0 */ { 0, &Ia_testw_Ew_Iw },
  /* 1 */ { 0, &Ia_testw_Ew_Iw },
  /* 2 */ { 0, &Ia_notw_Ew     },
  /* 3 */ { 0, &Ia_negw_Ew     },
  /* 4 */ { 0, &Ia_mulw_AX_Ew  },
  /* 5 */ { 0, &Ia_imulw_AX_Ew },
  /* 6 */ { 0, &Ia_divw_AX_Ew  },
  /* 7 */ { 0, &Ia_idivw_AX_Ew }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG3Ed[8] = {
  /* 0 */ { 0, &Ia_testl_Ed_Id  },
  /* 1 */ { 0, &Ia_testl_Ed_Id  },
  /* 2 */ { 0, &Ia_notl_Ed      },
  /* 3 */ { 0, &Ia_negl_Ed      },
  /* 4 */ { 0, &Ia_mull_EAX_Ed  },
  /* 5 */ { 0, &Ia_imull_EAX_Ed },
  /* 6 */ { 0, &Ia_divl_EAX_Ed  },
  /* 7 */ { 0, &Ia_idivl_EAX_Ed }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG3Eq[8] = {
  /* 0 */ { 0, &Ia_testq_Eq_sId },
  /* 1 */ { 0, &Ia_testq_Eq_sId },
  /* 2 */ { 0, &Ia_notq_Eq      },
  /* 3 */ { 0, &Ia_negq_Eq      },
  /* 4 */ { 0, &Ia_mulq_RAX_Eq  },
  /* 5 */ { 0, &Ia_imulq_RAX_Eq },
  /* 6 */ { 0, &Ia_divq_RAX_Eq  },
  /* 7 */ { 0, &Ia_idivq_RAX_Eq }
};

/* Group4 */
static BxDisasmOpcodeTable_t BxDisasmGroupG4[8] = {
  /* 0 */ { 0, &Ia_incb_Eb },
  /* 1 */ { 0, &Ia_decb_Eb },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

/* Group5 */
static BxDisasmOpcodeTable_t BxDisasmGroupG5w[8] = {
  /* 0 */ { 0, &Ia_incw_Ew  },
  /* 1 */ { 0, &Ia_decw_Ew  },
  /* 2 */ { 0, &Ia_call_Ew  },
  /* 3 */ { 0, &Ia_lcall_Mp },
  /* 4 */ { 0, &Ia_jmp_Ew   },
  /* 5 */ { 0, &Ia_ljmp_Mp  },
  /* 6 */ { 0, &Ia_pushw_Ew },
  /* 7 */ { 0, &Ia_Invalid  }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG5d[8] = {
  /* 0 */ { 0, &Ia_incl_Ed  },
  /* 1 */ { 0, &Ia_decl_Ed  },
  /* 2 */ { 0, &Ia_call_Ed  },
  /* 3 */ { 0, &Ia_lcall_Mp },
  /* 4 */ { 0, &Ia_jmp_Ed   },
  /* 5 */ { 0, &Ia_ljmp_Mp  },
  /* 6 */ { 0, &Ia_pushl_Ed },
  /* 7 */ { 0, &Ia_Invalid  }
};

static BxDisasmOpcodeTable_t BxDisasmGroup64G5w[8] = {
  /* 0 */ { 0, &Ia_incw_Ew  },
  /* 1 */ { 0, &Ia_decw_Ew  },
  /* 2 */ { 0, &Ia_call_Eq  },
  /* 3 */ { 0, &Ia_lcall_Mp },
  /* 4 */ { 0, &Ia_jmp_Eq   },
  /* 5 */ { 0, &Ia_ljmp_Mp  },
  /* 6 */ { 0, &Ia_pushw_Ew },
  /* 7 */ { 0, &Ia_Invalid  }
};

static BxDisasmOpcodeTable_t BxDisasmGroup64G5d[8] = {
  /* 0 */ { 0, &Ia_incl_Ed  },
  /* 1 */ { 0, &Ia_decl_Ed  },
  /* 2 */ { 0, &Ia_call_Eq  },
  /* 3 */ { 0, &Ia_lcall_Mp },
  /* 4 */ { 0, &Ia_jmp_Eq   },
  /* 5 */ { 0, &Ia_ljmp_Mp  },
  /* 6 */ { 0, &Ia_pushq_Eq },
  /* 7 */ { 0, &Ia_Invalid  }
};

static BxDisasmOpcodeTable_t BxDisasmGroup64G5q[8] = {
  /* 0 */ { 0, &Ia_incq_Eq  },
  /* 1 */ { 0, &Ia_decq_Eq  },
  /* 2 */ { 0, &Ia_call_Eq  },
  /* 3 */ { 0, &Ia_lcall_Mp },
  /* 4 */ { 0, &Ia_jmp_Eq   },
  /* 5 */ { 0, &Ia_ljmp_Mp  },
  /* 6 */ { 0, &Ia_pushq_Eq },
  /* 7 */ { 0, &Ia_Invalid  }
};

/* Group6 */
static BxDisasmOpcodeTable_t BxDisasmGroupG6[8] = {
  /* 0 */ { 0, &Ia_sldt    },
  /* 1 */ { 0, &Ia_str     },
  /* 2 */ { 0, &Ia_lldt    },
  /* 3 */ { 0, &Ia_ltr     },
  /* 4 */ { 0, &Ia_verr    },
  /* 5 */ { 0, &Ia_verw    },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

/* Group7 */
static BxDisasmOpcodeTable_t BxDisasmGroupG7M[8] = {
  /* 0 */ { 0, &Ia_sgdt    },
  /* 2 */ { 0, &Ia_sidt    },
  /* 2 */ { 0, &Ia_lgdt    },
  /* 3 */ { 0, &Ia_lidt    },
  /* 4 */ { 0, &Ia_smsw_Ew },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_lmsw_Ew },
  /* 7 */ { 0, &Ia_invlpg  }
};

static BxDisasmOpcodeTable_t BxDisasmGroupRmINVLPG[8] = {
  /* 0 */ { 0, &Ia_swapgs  },
  /* 1 */ { 0, &Ia_rdtscp  },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

/* VMX */
static BxDisasmOpcodeTable_t BxDisasmGroupRmG7VMX[8] = {
  /* 0 */ { 0, &Ia_Invalid  },
  /* 1 */ { 0, &Ia_vmcall   },
  /* 2 */ { 0, &Ia_vmlaunch },
  /* 3 */ { 0, &Ia_vmresume },
  /* 4 */ { 0, &Ia_vmxoff   },
  /* 5 */ { 0, &Ia_Invalid  },
  /* 6 */ { 0, &Ia_Invalid  },
  /* 7 */ { 0, &Ia_Invalid  }
};

/* VMX */
static BxDisasmOpcodeTable_t BxDisasmGroupSSE_G7VMX[4] = {
  /* -- */ { GRPRM(G7VMX)   },
  /* 66 */ { 0, &Ia_Invalid },
  /* F3 */ { 0, &Ia_Invalid },
  /* F2 */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmGroupRmMONITOR[8] = {
  /* 0 */ { 0, &Ia_monitor },
  /* 1 */ { 0, &Ia_mwait   },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmGroupRmXSETGET[8] = {
  /* 0 */ { 0, &Ia_xgetbv },
  /* 1 */ { 0, &Ia_xsetbv },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_vmfunc },  // VMX
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmGroupRmG7SVM[8] = {
  /* 0 */ { 0, &Ia_vmrun },
  /* 1 */ { 0, &Ia_vmmcall },
  /* 2 */ { 0, &Ia_vmload },
  /* 3 */ { 0, &Ia_vmsave },
  /* 4 */ { 0, &Ia_stgi },
  /* 5 */ { 0, &Ia_clgi },
  /* 6 */ { 0, &Ia_skinit },
  /* 7 */ { 0, &Ia_invlpga }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG7R[8] = {
  /* 0 */ { GRPSSE(G7VMX)  }, // VMX
  /* 1 */ { GRPRM(MONITOR) },
  /* 2 */ { GRPRM(XSETGET) },
  /* 3 */ { GRPRM(G7SVM)   }, // SVM
  /* 4 */ { 0, &Ia_smsw_Ew },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_lmsw_Ew },
  /* 7 */ { GRPRM(INVLPG)  }
};

static BxDisasmOpcodeTable_t BxDisasmGroupModG7[2] = {
  /* R */ { GRPN(G7R) },
  /* M */ { GRPN(G7M) }
};

/* Group8 */
static BxDisasmOpcodeTable_t BxDisasmGroupG8EwIb[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_btw_Ew_Ib  },
  /* 5 */ { 0, &Ia_btsw_Ew_Ib },
  /* 6 */ { 0, &Ia_btrw_Ew_Ib },
  /* 7 */ { 0, &Ia_btcw_Ew_Ib }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG8EdIb[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_btl_Ed_Ib  },
  /* 5 */ { 0, &Ia_btsl_Ed_Ib },
  /* 6 */ { 0, &Ia_btrl_Ed_Ib },
  /* 7 */ { 0, &Ia_btcl_Ed_Ib }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG8EqIb[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_btq_Eq_Ib  },
  /* 5 */ { 0, &Ia_btsq_Eq_Ib },
  /* 6 */ { 0, &Ia_btrq_Eq_Ib },
  /* 7 */ { 0, &Ia_btcq_Eq_Ib }
};

/* Group9 */

/* VMX */
static BxDisasmOpcodeTable_t BxDisasmGroupSSE_G9VMX6[4] = {
  /* -- */ { 0, &Ia_vmptrld_Mq },
  /* 66 */ { 0, &Ia_vmclear_Mq },
  /* F3 */ { 0, &Ia_vmxon_Mq },
  /* F2 */ { 0, &Ia_Invalid  }
};

/* VMX */
static BxDisasmOpcodeTable_t BxDisasmGroupSSE_G9VMX7[4] = {
  /* -- */ { 0, &Ia_vmptrst_Mq },
  /* 66 */ { 0, &Ia_Invalid },
  /* F3 */ { 0, &Ia_Invalid },
  /* F2 */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG9[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_cmpxchg8b_Mq },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { GRPSSE(G9VMX6) }, // VMX
  /* 7 */ { GRPSSE(G9VMX7) }  // VMX
};

static BxDisasmOpcodeTable_t BxDisasmGroupG9q[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_cmpxchg16b_Mdq },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { GRPSSE(G9VMX6) }, // VMX
  /* 7 */ { GRPSSE(G9VMX7) }  // VMX
};

/* Group11 */
static BxDisasmOpcodeTable_t BxDisasmGroupG11Eb[8] = {
  /* 0 */ { 0, &Ia_movb_Eb_Ib },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG11Ew[8] = {
  /* 0 */ { 0, &Ia_movw_Ew_Iw },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG11Ed[8] = {
  /* 0 */ { 0, &Ia_movl_Ed_Id },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG11Eq[8] = {
  /* 0 */ { 0, &Ia_movq_Eq_sId },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { 0, &Ia_Invalid },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { 0, &Ia_Invalid },
  /* 7 */ { 0, &Ia_Invalid }
};

/* Group12 */
static BxDisasmOpcodeTable_t BxDisasmGroupG12[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { GRPSSE(G1202) },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { GRPSSE(G1204) },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { GRPSSE(G1206) },
  /* 7 */ { 0, &Ia_Invalid }
};

/* Group13 */
static BxDisasmOpcodeTable_t BxDisasmGroupG13[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { GRPSSE(G1302) },
  /* 3 */ { 0, &Ia_Invalid },
  /* 4 */ { GRPSSE(G1304) },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { GRPSSE(G1306) },
  /* 7 */ { 0, &Ia_Invalid }
};

/* Group14 */
static BxDisasmOpcodeTable_t BxDisasmGroupG14[8] = {
  /* 0 */ { 0, &Ia_Invalid },
  /* 1 */ { 0, &Ia_Invalid },
  /* 2 */ { GRPSSE(G1402) },
  /* 3 */ { GRPSSE66(Ia_psrldq_Udq_Ib) },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_Invalid },
  /* 6 */ { GRPSSE(G1406) },
  /* 7 */ { GRPSSE66(Ia_pslldq_Udq_Ib) }
};

/* Group15 */
static BxDisasmOpcodeTable_t BxDisasmGroupG15M[8] = {
  /* 0 */ { 0, &Ia_fxsave   },
  /* 1 */ { 0, &Ia_fxrstor  },
  /* 2 */ { 0, &Ia_ldmxcsr  },
  /* 3 */ { 0, &Ia_stmxcsr  },
  /* 4 */ { 0, &Ia_xsave    },
  /* 5 */ { 0, &Ia_xrstor   },
  /* 6 */ { 0, &Ia_xsaveopt },
  /* 7 */ { 0, &Ia_cflush   }
};

static BxDisasmOpcodeTable_t BxDisasmGroupG15R[8] = {
  /* 0 */ { GRPSSEF3(Ia_rdfsbase_Ry) },
  /* 1 */ { GRPSSEF3(Ia_rdgsbase_Ry) },
  /* 2 */ { GRPSSEF3(Ia_wrfsbase_Ry) },
  /* 3 */ { GRPSSEF3(Ia_wrgsbase_Ry) },
  /* 4 */ { 0, &Ia_Invalid },
  /* 5 */ { 0, &Ia_lfence },
  /* 6 */ { 0, &Ia_mfence },
  /* 6 */ { 0, &Ia_sfence },
};

static BxDisasmOpcodeTable_t BxDisasmGroupModG15[2] = {
  /* R */ { GRPN(G15R) },
  /* M */ { GRPN(G15M) }
};

/* Group16 */
static BxDisasmOpcodeTable_t BxDisasmGroupG16[8] =
{
  /* 0 */ { 0, &Ia_prefetchnta },
  /* 1 */ { 0, &Ia_prefetcht0  },
  /* 2 */ { 0, &Ia_prefetcht1  },
  /* 3 */ { 0, &Ia_prefetcht2  },
  /* 4 */ { 0, &Ia_prefetch_hint },
  /* 5 */ { 0, &Ia_prefetch_hint },
  /* 6 */ { 0, &Ia_prefetch_hint },
  /* 7 */ { 0, &Ia_prefetch_hint }
};

/* ************************************************************************ */
/* 16-bit operand size */

static BxDisasmOpcodeTable_t BxDisasmOpcodes16[256*2] = {
  // 256 entries for single byte opcodes
  /* 00 */ { 0, &Ia_addb_Eb_Gb },
  /* 01 */ { 0, &Ia_addw_Ew_Gw },
  /* 02 */ { 0, &Ia_addb_Gb_Eb },
  /* 03 */ { 0, &Ia_addw_Gw_Ew },
  /* 04 */ { 0, &Ia_addb_AL_Ib },
  /* 05 */ { 0, &Ia_addw_AX_Iw },
  /* 06 */ { 0, &Ia_pushw_ES   },
  /* 07 */ { 0, &Ia_popw_ES    },
  /* 08 */ { 0, &Ia_orb_Eb_Gb  },
  /* 09 */ { 0, &Ia_orw_Ew_Gw  },
  /* 0A */ { 0, &Ia_orb_Gb_Eb  },
  /* 0B */ { 0, &Ia_orw_Gw_Ew  },
  /* 0C */ { 0, &Ia_orb_AL_Ib  },
  /* 0D */ { 0, &Ia_orw_AX_Iw  },
  /* 0E */ { 0, &Ia_pushw_CS   },
  /* 0F */ { 0, &Ia_error      },   // 2 byte escape
  /* 10 */ { 0, &Ia_adcb_Eb_Gb },
  /* 11 */ { 0, &Ia_adcw_Ew_Gw },
  /* 12 */ { 0, &Ia_adcb_Gb_Eb },
  /* 13 */ { 0, &Ia_adcw_Gw_Ew },
  /* 14 */ { 0, &Ia_adcb_AL_Ib },
  /* 15 */ { 0, &Ia_adcw_AX_Iw },
  /* 16 */ { 0, &Ia_pushw_SS   },
  /* 17 */ { 0, &Ia_popw_SS    },
  /* 18 */ { 0, &Ia_sbbb_Eb_Gb },
  /* 19 */ { 0, &Ia_sbbw_Ew_Gw },
  /* 1A */ { 0, &Ia_sbbb_Gb_Eb },
  /* 1B */ { 0, &Ia_sbbw_Gw_Ew },
  /* 1C */ { 0, &Ia_sbbb_AL_Ib },
  /* 1D */ { 0, &Ia_sbbw_AX_Iw },
  /* 1E */ { 0, &Ia_pushw_DS   },
  /* 1F */ { 0, &Ia_popw_DS    },
  /* 20 */ { 0, &Ia_andb_Eb_Gb },
  /* 21 */ { 0, &Ia_andw_Ew_Gw },
  /* 22 */ { 0, &Ia_andb_Gb_Eb },
  /* 23 */ { 0, &Ia_andw_Gw_Ew },
  /* 24 */ { 0, &Ia_andb_AL_Ib },
  /* 25 */ { 0, &Ia_andw_AX_Iw },
  /* 26 */ { 0, &Ia_prefix_es  },   // ES:
  /* 27 */ { 0, &Ia_daa        },
  /* 28 */ { 0, &Ia_subb_Eb_Gb },
  /* 29 */ { 0, &Ia_subw_Ew_Gw },
  /* 2A */ { 0, &Ia_subb_Gb_Eb },
  /* 2B */ { 0, &Ia_subw_Gw_Ew },
  /* 2C */ { 0, &Ia_subb_AL_Ib },
  /* 2D */ { 0, &Ia_subw_AX_Iw },
  /* 2E */ { 0, &Ia_prefix_cs  },   // CS:
  /* 2F */ { 0, &Ia_das        },
  /* 30 */ { 0, &Ia_xorb_Eb_Gb },
  /* 31 */ { 0, &Ia_xorw_Ew_Gw },
  /* 32 */ { 0, &Ia_xorb_Gb_Eb },
  /* 33 */ { 0, &Ia_xorw_Gw_Ew },
  /* 34 */ { 0, &Ia_xorb_AL_Ib },
  /* 35 */ { 0, &Ia_xorw_AX_Iw },
  /* 36 */ { 0, &Ia_prefix_ss  },   // SS:
  /* 37 */ { 0, &Ia_aaa        },
  /* 38 */ { 0, &Ia_cmpb_Eb_Gb },
  /* 39 */ { 0, &Ia_cmpw_Ew_Gw },
  /* 3A */ { 0, &Ia_cmpb_Gb_Eb },
  /* 3B */ { 0, &Ia_cmpw_Gw_Ew },
  /* 3C */ { 0, &Ia_cmpb_AL_Ib },
  /* 3D */ { 0, &Ia_cmpw_AX_Iw },
  /* 3E */ { 0, &Ia_prefix_ds  },   // DS:
  /* 3F */ { 0, &Ia_aas        },
  /* 40 */ { 0, &Ia_incw_RX    },
  /* 41 */ { 0, &Ia_incw_RX    },
  /* 42 */ { 0, &Ia_incw_RX    },
  /* 43 */ { 0, &Ia_incw_RX    },
  /* 44 */ { 0, &Ia_incw_RX    },
  /* 45 */ { 0, &Ia_incw_RX    },
  /* 46 */ { 0, &Ia_incw_RX    },
  /* 47 */ { 0, &Ia_incw_RX    },
  /* 48 */ { 0, &Ia_decw_RX    },
  /* 49 */ { 0, &Ia_decw_RX    },
  /* 4A */ { 0, &Ia_decw_RX    },
  /* 4B */ { 0, &Ia_decw_RX    },
  /* 4C */ { 0, &Ia_decw_RX    },
  /* 4D */ { 0, &Ia_decw_RX    },
  /* 4E */ { 0, &Ia_decw_RX    },
  /* 4F */ { 0, &Ia_decw_RX    },
  /* 50 */ { 0, &Ia_pushw_RX   },
  /* 51 */ { 0, &Ia_pushw_RX   },
  /* 52 */ { 0, &Ia_pushw_RX   },
  /* 53 */ { 0, &Ia_pushw_RX   },
  /* 54 */ { 0, &Ia_pushw_RX   },
  /* 55 */ { 0, &Ia_pushw_RX   },
  /* 56 */ { 0, &Ia_pushw_RX   },
  /* 57 */ { 0, &Ia_pushw_RX   },
  /* 58 */ { 0, &Ia_popw_RX    },
  /* 59 */ { 0, &Ia_popw_RX    },
  /* 5A */ { 0, &Ia_popw_RX    },
  /* 5B */ { 0, &Ia_popw_RX    },
  /* 5C */ { 0, &Ia_popw_RX    },
  /* 5D */ { 0, &Ia_popw_RX    },
  /* 5E */ { 0, &Ia_popw_RX    },
  /* 5F */ { 0, &Ia_popw_RX    },
  /* 60 */ { 0, &Ia_pushaw     },
  /* 61 */ { 0, &Ia_popaw      },
  /* 62 */ { 0, &Ia_boundw_Gw_Ma },
  /* 63 */ { 0, &Ia_arpl_Ew_Gw },
  /* 64 */ { 0, &Ia_prefix_fs  },   // FS:
  /* 65 */ { 0, &Ia_prefix_gs  },   // GS:
  /* 66 */ { 0, &Ia_prefix_osize }, // OSIZE:
  /* 67 */ { 0, &Ia_prefix_asize }, // ASIZE:
  /* 68 */ { 0, &Ia_pushw_Iw   },
  /* 69 */ { 0, &Ia_imulw_Gw_Ew_Iw  },
  /* 6A */ { 0, &Ia_pushw_sIb   },
  /* 6B */ { 0, &Ia_imulw_Gw_Ew_sIb },
  /* 6C */ { 0, &Ia_insb_Yb_DX  },
  /* 6D */ { 0, &Ia_insw_Yw_DX  },
  /* 6E */ { 0, &Ia_outsb_DX_Xb },
  /* 6F */ { 0, &Ia_outsw_DX_Xw },
  /* 70 */ { 0, &Ia_jo_Jb       },
  /* 71 */ { 0, &Ia_jno_Jb      },
  /* 72 */ { 0, &Ia_jb_Jb       },
  /* 73 */ { 0, &Ia_jnb_Jb      },
  /* 74 */ { 0, &Ia_jz_Jb       },
  /* 75 */ { 0, &Ia_jnz_Jb      },
  /* 76 */ { 0, &Ia_jbe_Jb      },
  /* 77 */ { 0, &Ia_jnbe_Jb     },
  /* 78 */ { 0, &Ia_js_Jb       },
  /* 79 */ { 0, &Ia_jns_Jb      },
  /* 7A */ { 0, &Ia_jp_Jb       },
  /* 7B */ { 0, &Ia_jnp_Jb      },
  /* 7C */ { 0, &Ia_jl_Jb       },
  /* 7D */ { 0, &Ia_jnl_Jb      },
  /* 7E */ { 0, &Ia_jle_Jb      },
  /* 7F */ { 0, &Ia_jnle_Jb     },
  /* 80 */ { GRPN(G1EbIb)       },
  /* 81 */ { GRPN(G1EwIw)       },
  /* 82 */ { GRPN(G1EbIb)       },
  /* 83 */ { GRPN(G1EwIb)       },
  /* 84 */ { 0, &Ia_testb_Eb_Gb },
  /* 85 */ { 0, &Ia_testw_Ew_Gw },
  /* 86 */ { 0, &Ia_xchgb_Eb_Gb },
  /* 87 */ { 0, &Ia_xchgw_Ew_Gw },
  /* 88 */ { 0, &Ia_movb_Eb_Gb  },
  /* 89 */ { 0, &Ia_movw_Ew_Gw  },
  /* 8A */ { 0, &Ia_movb_Gb_Eb  },
  /* 8B */ { 0, &Ia_movw_Gw_Ew  },
  /* 8C */ { 0, &Ia_movw_Ew_Sw  },
  /* 8D */ { 0, &Ia_leaw_Gw_Mw  },
  /* 8E */ { 0, &Ia_movw_Sw_Ew  },
  /* 8F */ { 0, &Ia_popw_Ew     },
  /* 90 */ { 0, &Ia_nop         },
  /* 91 */ { 0, &Ia_xchgw_RX_AX },
  /* 92 */ { 0, &Ia_xchgw_RX_AX },
  /* 93 */ { 0, &Ia_xchgw_RX_AX },
  /* 94 */ { 0, &Ia_xchgw_RX_AX },
  /* 95 */ { 0, &Ia_xchgw_RX_AX },
  /* 96 */ { 0, &Ia_xchgw_RX_AX },
  /* 97 */ { 0, &Ia_xchgw_RX_AX },
  /* 98 */ { 0, &Ia_cbw         },
  /* 99 */ { 0, &Ia_cwd         },
  /* 9A */ { 0, &Ia_lcall_Apw   },
  /* 9B */ { 0, &Ia_fwait       },
  /* 9C */ { 0, &Ia_pushfw      },
  /* 9D */ { 0, &Ia_popfw       },
  /* 9E */ { 0, &Ia_sahf        },
  /* 9F */ { 0, &Ia_lahf        },
  /* A0 */ { 0, &Ia_movb_AL_Ob  },
  /* A1 */ { 0, &Ia_movw_AX_Ow  },
  /* A0 */ { 0, &Ia_movb_Ob_AL  },
  /* A1 */ { 0, &Ia_movw_Ow_AX  },
  /* A4 */ { 0, &Ia_movsb_Yb_Xb },
  /* A5 */ { 0, &Ia_movsw_Yw_Xw },
  /* A6 */ { 0, &Ia_cmpsb_Yb_Xb },
  /* A7 */ { 0, &Ia_cmpsw_Yw_Xw },
  /* A8 */ { 0, &Ia_testb_AL_Ib },
  /* A9 */ { 0, &Ia_testw_AX_Iw },
  /* AA */ { 0, &Ia_stosb_Yb_AL },
  /* AB */ { 0, &Ia_stosw_Yw_AX },
  /* AC */ { 0, &Ia_lodsb_AL_Xb },
  /* AD */ { 0, &Ia_lodsw_AX_Xw },
  /* AE */ { 0, &Ia_scasb_Yb_AL },
  /* AF */ { 0, &Ia_scasw_Yw_AX },
  /* B0 */ { 0, &Ia_movb_R8_Ib  },
  /* B1 */ { 0, &Ia_movb_R8_Ib  },
  /* B2 */ { 0, &Ia_movb_R8_Ib  },
  /* B3 */ { 0, &Ia_movb_R8_Ib  },
  /* B4 */ { 0, &Ia_movb_R8_Ib  },
  /* B5 */ { 0, &Ia_movb_R8_Ib  },
  /* B6 */ { 0, &Ia_movb_R8_Ib  },
  /* B7 */ { 0, &Ia_movb_R8_Ib  },
  /* B8 */ { 0, &Ia_movw_RX_Iw  },
  /* B9 */ { 0, &Ia_movw_RX_Iw  },
  /* BA */ { 0, &Ia_movw_RX_Iw  },
  /* BB */ { 0, &Ia_movw_RX_Iw  },
  /* BC */ { 0, &Ia_movw_RX_Iw  },
  /* BD */ { 0, &Ia_movw_RX_Iw  },
  /* BE */ { 0, &Ia_movw_RX_Iw  },
  /* BF */ { 0, &Ia_movw_RX_Iw  },
  /* C0 */ { GRPN(G2Eb)         },
  /* C1 */ { GRPN(G2Ew)         },
  /* C2 */ { 0, &Ia_ret_Iw      },
  /* C3 */ { 0, &Ia_ret         },
  /* C4 */ { 0, &Ia_lesw_Gw_Mp  },
  /* C5 */ { 0, &Ia_ldsw_Gw_Mp  },
  /* C6 */ { GRPN(G11Eb)        },
  /* C7 */ { GRPN(G11Ew)        },
  /* C8 */ { 0, &Ia_enter       },
  /* C9 */ { 0, &Ia_leave       },
  /* CA */ { 0, &Ia_lret_Iw     },
  /* CB */ { 0, &Ia_lret        },
  /* CC */ { 0, &Ia_int3        },
  /* CD */ { 0, &Ia_int_Ib      },
  /* CE */ { 0, &Ia_into        },
  /* CF */ { 0, &Ia_iretw       },
  /* D0 */ { GRPN(G2EbI1)       },
  /* D1 */ { GRPN(G2EwI1)       },
  /* D2 */ { GRPN(G2EbCL)       },
  /* D3 */ { GRPN(G2EwCL)       },
  /* D4 */ { 0, &Ia_aam         },
  /* D5 */ { 0, &Ia_aad         },
  /* D6 */ { 0, &Ia_salc        },
  /* D7 */ { 0, &Ia_xlat        },
  /* D8 */ { GRPFP(D8)          },
  /* D9 */ { GRPFP(D9)          },
  /* DA */ { GRPFP(DA)          },
  /* DB */ { GRPFP(DB)          },
  /* DC */ { GRPFP(DC)          },
  /* DD */ { GRPFP(DD)          },
  /* DE */ { GRPFP(DE)          },
  /* DF */ { GRPFP(DF)          },
  /* E0 */ { 0, &Ia_loopne_Jb   },
  /* E1 */ { 0, &Ia_loope_Jb    },
  /* E2 */ { 0, &Ia_loop_Jb     },
  /* E3 */ { 0, &Ia_jcxz_Jb     },
  /* E4 */ { 0, &Ia_inb_AL_Ib   },
  /* E5 */ { 0, &Ia_inw_AX_Ib   },
  /* E6 */ { 0, &Ia_outb_Ib_AL  },
  /* E7 */ { 0, &Ia_outw_Ib_AX  },
  /* E8 */ { 0, &Ia_call_Jw     },
  /* E9 */ { 0, &Ia_jmp_Jw      },
  /* EA */ { 0, &Ia_ljmp_Apw    },
  /* EB */ { 0, &Ia_jmp_Jb      },
  /* EC */ { 0, &Ia_inb_AL_DX   },
  /* ED */ { 0, &Ia_inw_AX_DX   },
  /* EE */ { 0, &Ia_outb_DX_AL  },
  /* EF */ { 0, &Ia_outw_DX_AX  },
  /* F0 */ { 0, &Ia_prefix_lock },   // LOCK:
  /* F1 */ { 0, &Ia_int1        },
  /* F2 */ { 0, &Ia_prefix_repne },  // REPNE:
  /* F3 */ { 0, &Ia_prefix_rep  },   // REP:
  /* F4 */ { 0, &Ia_hlt         },
  /* F5 */ { 0, &Ia_cmc         },
  /* F6 */ { GRPN(G3Eb)         },
  /* F7 */ { GRPN(G3Ew)         },
  /* F8 */ { 0, &Ia_clc         },
  /* F9 */ { 0, &Ia_stc         },
  /* FA */ { 0, &Ia_cli         },
  /* FB */ { 0, &Ia_sti         },
  /* FC */ { 0, &Ia_cld         },
  /* FD */ { 0, &Ia_std         },
  /* FE */ { GRPN(G4)           },
  /* FF */ { GRPN(G5w)          },

  // 256 entries for two byte opcodes
  /* 0F 00 */ { GRPN(G6)          },
  /* 0F 01 */ { GRPMOD(G7)        },
  /* 0F 02 */ { 0, &Ia_larw_Gw_Ew },
  /* 0F 03 */ { 0, &Ia_lslw_Gw_Ew },
  /* 0F 04 */ { 0, &Ia_Invalid    },
  /* 0F 05 */ { 0, &Ia_syscall    },
  /* 0F 06 */ { 0, &Ia_clts       },
  /* 0F 07 */ { 0, &Ia_sysret     },
  /* 0F 08 */ { 0, &Ia_invd       },
  /* 0F 09 */ { 0, &Ia_wbinvd     },
  /* 0F 0A */ { 0, &Ia_Invalid    },
  /* 0F 0B */ { 0, &Ia_ud2a       },
  /* 0F 0C */ { 0, &Ia_Invalid    },
  /* 0F 0D */ { 0, &Ia_prefetchw  },   // 3DNow!
  /* 0F 0E */ { 0, &Ia_femms      },   // 3DNow!
  /* 0F 0F */ { GRP3DNOW          },
  /* 0F 10 */ { GRPSSE(0f10)      },
  /* 0F 11 */ { GRPSSE(0f11)      },
  /* 0F 12 */ { GRPSSE(0f12)      },
  /* 0F 13 */ { GRPSSE(0f13)      },
  /* 0F 14 */ { GRPSSE(0f14)      },
  /* 0F 15 */ { GRPSSE(0f15)      },
  /* 0F 16 */ { GRPSSE(0f16)      },
  /* 0F 17 */ { GRPSSE(0f17)      },
  /* 0F 18 */ { GRPN(G16)         },
  /* 0F 19 */ { 0, &Ia_multibyte_nop },
  /* 0F 1A */ { 0, &Ia_multibyte_nop },
  /* 0F 1B */ { 0, &Ia_multibyte_nop },
  /* 0F 1C */ { 0, &Ia_multibyte_nop },
  /* 0F 1D */ { 0, &Ia_multibyte_nop },
  /* 0F 1E */ { 0, &Ia_multibyte_nop },
  /* 0F 1F */ { 0, &Ia_multibyte_nop },
  /* 0F 20 */ { 0, &Ia_movl_Rd_Cd },
  /* 0F 21 */ { 0, &Ia_movl_Rd_Dd },
  /* 0F 22 */ { 0, &Ia_movl_Cd_Rd },
  /* 0F 23 */ { 0, &Ia_movl_Dd_Rd },
  /* 0F 24 */ { 0, &Ia_movl_Rd_Td },
  /* 0F 25 */ { 0, &Ia_Invalid    },
  /* 0F 26 */ { 0, &Ia_movl_Td_Rd },
  /* 0F 27 */ { 0, &Ia_Invalid    },
  /* 0F 28 */ { GRPSSE(0f28) },
  /* 0F 29 */ { GRPSSE(0f29) },
  /* 0F 2A */ { GRPSSE(0f2a) },
  /* 0F 2B */ { GRPSSE(0f2b) },
  /* 0F 2C */ { GRPSSE(0f2c) },
  /* 0F 2D */ { GRPSSE(0f2d) },
  /* 0F 2E */ { GRPSSE(0f2e) },
  /* 0F 2F */ { GRPSSE(0f2f) },
  /* 0F 30 */ { 0, &Ia_wrmsr },
  /* 0F 31 */ { 0, &Ia_rdtsc },
  /* 0F 32 */ { 0, &Ia_rdmsr },
  /* 0F 33 */ { 0, &Ia_rdpmc },
  /* 0F 34 */ { 0, &Ia_sysenter },
  /* 0F 35 */ { 0, &Ia_sysexit },
  /* 0F 36 */ { 0, &Ia_Invalid },
  /* 0F 37 */ { 0, &Ia_getsec },
  /* 0F 38 */ { GR3BTAB(0f38) },
  /* 0F 39 */ { 0, &Ia_Invalid  },
  /* 0F 3A */ { GR3BTAB(0f3a) },
  /* 0F 3B */ { 0, &Ia_Invalid },
  /* 0F 3C */ { 0, &Ia_Invalid },
  /* 0F 3D */ { 0, &Ia_Invalid },
  /* 0F 3E */ { 0, &Ia_Invalid },
  /* 0F 3F */ { 0, &Ia_Invalid },
  /* 0F 40 */ { 0, &Ia_cmovow_Gw_Ew  },
  /* 0F 41 */ { 0, &Ia_cmovnow_Gw_Ew },
  /* 0F 42 */ { 0, &Ia_cmovcw_Gw_Ew  },
  /* 0F 43 */ { 0, &Ia_cmovncw_Gw_Ew },
  /* 0F 44 */ { 0, &Ia_cmovzw_Gw_Ew  },
  /* 0F 45 */ { 0, &Ia_cmovnzw_Gw_Ew },
  /* 0F 46 */ { 0, &Ia_cmovnaw_Gw_Ew },
  /* 0F 47 */ { 0, &Ia_cmovaw_Gw_Ew  },
  /* 0F 48 */ { 0, &Ia_cmovsw_Gw_Ew  },
  /* 0F 49 */ { 0, &Ia_cmovnsw_Gw_Ew },
  /* 0F 4A */ { 0, &Ia_cmovpw_Gw_Ew  },
  /* 0F 4B */ { 0, &Ia_cmovnpw_Gw_Ew },
  /* 0F 4C */ { 0, &Ia_cmovlw_Gw_Ew  },
  /* 0F 4D */ { 0, &Ia_cmovnlw_Gw_Ew },
  /* 0F 4E */ { 0, &Ia_cmovngw_Gw_Ew },
  /* 0F 4F */ { 0, &Ia_cmovgw_Gw_Ew  },
  /* 0F 50 */ { GRPSSE(0f50) },
  /* 0F 51 */ { GRPSSE(0f51) },
  /* 0F 52 */ { GRPSSE(0f52) },
  /* 0F 53 */ { GRPSSE(0f53) },
  /* 0F 54 */ { GRPSSE(0f54) },
  /* 0F 55 */ { GRPSSE(0f55) },
  /* 0F 56 */ { GRPSSE(0f56) },
  /* 0F 57 */ { GRPSSE(0f57) },
  /* 0F 58 */ { GRPSSE(0f58) },
  /* 0F 59 */ { GRPSSE(0f59) },
  /* 0F 5A */ { GRPSSE(0f5a) },
  /* 0F 5B */ { GRPSSE(0f5b) },
  /* 0F 5C */ { GRPSSE(0f5c) },
  /* 0F 5D */ { GRPSSE(0f5d) },
  /* 0F 5E */ { GRPSSE(0f5e) },
  /* 0F 5F */ { GRPSSE(0f5f) },
  /* 0F 60 */ { GRPSSE(0f60) },
  /* 0F 61 */ { GRPSSE(0f61) },
  /* 0F 62 */ { GRPSSE(0f62) },
  /* 0F 63 */ { GRPSSE(0f63) },
  /* 0F 64 */ { GRPSSE(0f64) },
  /* 0F 65 */ { GRPSSE(0f65) },
  /* 0F 66 */ { GRPSSE(0f66) },
  /* 0F 67 */ { GRPSSE(0f67) },
  /* 0F 68 */ { GRPSSE(0f68) },
  /* 0F 69 */ { GRPSSE(0f69) },
  /* 0F 6A */ { GRPSSE(0f6a) },
  /* 0F 6B */ { GRPSSE(0f6b) },
  /* 0F 6C */ { GRPSSE66(Ia_punpcklqdq_Vdq_Wdq) },
  /* 0F 6D */ { GRPSSE66(Ia_punpckhqdq_Vdq_Wdq) },
  /* 0F 6E */ { GRPSSE(0f6e) },
  /* 0F 6F */ { GRPSSE(0f6f) },
  /* 0F 70 */ { GRPSSE(0f70) },
  /* 0F 71 */ { GRPN(G12)    },
  /* 0F 72 */ { GRPN(G13)    },
  /* 0F 73 */ { GRPN(G14)    },
  /* 0F 74 */ { GRPSSE(0f74) },
  /* 0F 75 */ { GRPSSE(0f75) },
  /* 0F 76 */ { GRPSSE(0f76) },
  /* 0F 77 */ { 0, &Ia_emms  },
  /* 0F 78 */ { GRPSSE(0f78) }, // VMX
  /* 0F 79 */ { GRPSSE(0f79) }, // VMX
  /* 0F 7A */ { 0, &Ia_Invalid },
  /* 0F 7B */ { 0, &Ia_Invalid },
  /* 0F 7C */ { GRPSSE(0f7c) },
  /* 0F 7D */ { GRPSSE(0f7d) },
  /* 0F 7E */ { GRPSSE(0f7e) },
  /* 0F 7F */ { GRPSSE(0f7f) },
  /* 0F 80 */ { 0, &Ia_jo_Jw     },
  /* 0F 81 */ { 0, &Ia_jno_Jw    },
  /* 0F 82 */ { 0, &Ia_jb_Jw     },
  /* 0F 83 */ { 0, &Ia_jnb_Jw    },
  /* 0F 84 */ { 0, &Ia_jz_Jw     },
  /* 0F 85 */ { 0, &Ia_jnz_Jw    },
  /* 0F 86 */ { 0, &Ia_jbe_Jw    },
  /* 0F 87 */ { 0, &Ia_jnbe_Jw   },
  /* 0F 88 */ { 0, &Ia_js_Jw     },
  /* 0F 89 */ { 0, &Ia_jns_Jw    },
  /* 0F 8A */ { 0, &Ia_jp_Jw     },
  /* 0F 8B */ { 0, &Ia_jnp_Jw    },
  /* 0F 8C */ { 0, &Ia_jl_Jw     },
  /* 0F 8D */ { 0, &Ia_jnl_Jw    },
  /* 0F 8E */ { 0, &Ia_jle_Jw    },
  /* 0F 8F */ { 0, &Ia_jnle_Jw   },
  /* 0F 90 */ { 0, &Ia_seto_Eb   },
  /* 0F 91 */ { 0, &Ia_setno_Eb  },
  /* 0F 92 */ { 0, &Ia_setb_Eb   },
  /* 0F 93 */ { 0, &Ia_setnb_Eb  },
  /* 0F 94 */ { 0, &Ia_setz_Eb   },
  /* 0F 95 */ { 0, &Ia_setnz_Eb  },
  /* 0F 96 */ { 0, &Ia_setbe_Eb  },
  /* 0F 97 */ { 0, &Ia_setnbe_Eb },
  /* 0F 98 */ { 0, &Ia_sets_Eb   },
  /* 0F 99 */ { 0, &Ia_setns_Eb  },
  /* 0F 9A */ { 0, &Ia_setp_Eb   },
  /* 0F 9B */ { 0, &Ia_setnp_Eb  },
  /* 0F 9C */ { 0, &Ia_setl_Eb   },
  /* 0F 9D */ { 0, &Ia_setnl_Eb  },
  /* 0F 9E */ { 0, &Ia_setle_Eb  },
  /* 0F 9F */ { 0, &Ia_setnle_Eb },
  /* 0F A0 */ { 0, &Ia_pushw_FS  },
  /* 0F A1 */ { 0, &Ia_popw_FS   },
  /* 0F A2 */ { 0, &Ia_cpuid     },
  /* 0F A3 */ { 0, &Ia_btw_Ew_Gw },
  /* 0F A4 */ { 0, &Ia_shldw_Ew_Gw_Ib },
  /* 0F A5 */ { 0, &Ia_shldw_Ew_Gw_CL },
  /* 0F A6 */ { 0, &Ia_Invalid        },
  /* 0F A7 */ { 0, &Ia_Invalid        },
  /* 0F A8 */ { 0, &Ia_pushw_GS       },
  /* 0F A9 */ { 0, &Ia_popw_GS        },
  /* 0F AA */ { 0, &Ia_rsm            },
  /* 0F AB */ { 0, &Ia_btsw_Ew_Gw     },
  /* 0F AC */ { 0, &Ia_shrdw_Ew_Gw_Ib },
  /* 0F AD */ { 0, &Ia_shrdw_Ew_Gw_CL },
  /* 0F AE */ { GRPMOD(G15)           },
  /* 0F AF */ { 0, &Ia_imulw_Gw_Ew    },
  /* 0F B0 */ { 0, &Ia_cmpxchgb_Eb_Gb },
  /* 0F B1 */ { 0, &Ia_cmpxchgw_Ew_Gw },
  /* 0F B2 */ { 0, &Ia_lssw_Gw_Mp   },
  /* 0F B3 */ { 0, &Ia_btrw_Ew_Gw   },
  /* 0F B4 */ { 0, &Ia_lfsw_Gw_Mp   },
  /* 0F B5 */ { 0, &Ia_lgsw_Gw_Mp   },
  /* 0F B6 */ { 0, &Ia_movzbw_Gw_Eb },
  /* 0F B7 */ { 0, &Ia_movw_Gw_Ew   },
  /* 0F B8 */ { GRPSSEF3(Ia_popcnt_Gw_Ew) },
  /* 0F B9 */ { 0, &Ia_ud2b         },
  /* 0F BA */ { GRPN(G8EwIb)        },
  /* 0F BB */ { 0, &Ia_btcw_Ew_Gw   },
  /* 0F BC */ { GRPSSE(0fbcw) },
  /* 0F BD */ { GRPSSE(0fbdw) },
  /* 0F BE */ { 0, &Ia_movsbw_Gw_Eb },
  /* 0F BF */ { 0, &Ia_movw_Gw_Ew   },
  /* 0F C0 */ { 0, &Ia_xaddb_Eb_Gb  },
  /* 0F C0 */ { 0, &Ia_xaddw_Ew_Gw  },
  /* 0F C2 */ { GRPSSE(0fc2) },
  /* 0F C3 */ { GRPSSE(0fc3) },
  /* 0F C4 */ { GRPSSE(0fc4) },
  /* 0F C5 */ { GRPSSE(0fc5) },
  /* 0F C6 */ { GRPSSE(0fc6) },
  /* 0F C7 */ { GRPN(G9)     },
  /* 0F C8 */ { 0, &Ia_bswapl_ERX },
  /* 0F C9 */ { 0, &Ia_bswapl_ERX },
  /* 0F CA */ { 0, &Ia_bswapl_ERX },
  /* 0F CB */ { 0, &Ia_bswapl_ERX },
  /* 0F CC */ { 0, &Ia_bswapl_ERX },
  /* 0F CD */ { 0, &Ia_bswapl_ERX },
  /* 0F CE */ { 0, &Ia_bswapl_ERX },
  /* 0F CF */ { 0, &Ia_bswapl_ERX },
  /* 0F D0 */ { GRPSSE(0fd0) },
  /* 0F D1 */ { GRPSSE(0fd1) },
  /* 0F D2 */ { GRPSSE(0fd2) },
  /* 0F D3 */ { GRPSSE(0fd3) },
  /* 0F D4 */ { GRPSSE(0fd4) },
  /* 0F D5 */ { GRPSSE(0fd5) },
  /* 0F D6 */ { GRPSSE(0fd6) },
  /* 0F D7 */ { GRPSSE(0fd7) },
  /* 0F D8 */ { GRPSSE(0fd8) },
  /* 0F D9 */ { GRPSSE(0fd9) },
  /* 0F DA */ { GRPSSE(0fda) },
  /* 0F DB */ { GRPSSE(0fdb) },
  /* 0F DC */ { GRPSSE(0fdc) },
  /* 0F DD */ { GRPSSE(0fdd) },
  /* 0F DE */ { GRPSSE(0fde) },
  /* 0F DF */ { GRPSSE(0fdf) },
  /* 0F E0 */ { GRPSSE(0fe0) },
  /* 0F E1 */ { GRPSSE(0fe1) },
  /* 0F E2 */ { GRPSSE(0fe2) },
  /* 0F E3 */ { GRPSSE(0fe3) },
  /* 0F E4 */ { GRPSSE(0fe4) },
  /* 0F E5 */ { GRPSSE(0fe5) },
  /* 0F E6 */ { GRPSSE(0fe6) },
  /* 0F E7 */ { GRPSSE(0fe7) },
  /* 0F E8 */ { GRPSSE(0fe8) },
  /* 0F E9 */ { GRPSSE(0fe9) },
  /* 0F EA */ { GRPSSE(0fea) },
  /* 0F EB */ { GRPSSE(0feb) },
  /* 0F EC */ { GRPSSE(0fec) },
  /* 0F ED */ { GRPSSE(0fed) },
  /* 0F EE */ { GRPSSE(0fee) },
  /* 0F EF */ { GRPSSE(0fef) },
  /* 0F F0 */ { GRPSSEF2(Ia_lddqu_Vdq_Mdq) },
  /* 0F F1 */ { GRPSSE(0ff1) },
  /* 0F F2 */ { GRPSSE(0ff2) },
  /* 0F F3 */ { GRPSSE(0ff3) },
  /* 0F F4 */ { GRPSSE(0ff4) },
  /* 0F F5 */ { GRPSSE(0ff5) },
  /* 0F F6 */ { GRPSSE(0ff6) },
  /* 0F F7 */ { GRPSSE(0ff7) },
  /* 0F F8 */ { GRPSSE(0ff8) },
  /* 0F F9 */ { GRPSSE(0ff9) },
  /* 0F FA */ { GRPSSE(0ffa) },
  /* 0F FB */ { GRPSSE(0ffb) },
  /* 0F FC */ { GRPSSE(0ffc) },
  /* 0F FD */ { GRPSSE(0ffd) },
  /* 0F FE */ { GRPSSE(0ffe) },
  /* 0F FF */ { 0, &Ia_Invalid }
};

/* ************************************************************************ */
/* 32-bit operand size */

static BxDisasmOpcodeTable_t BxDisasmOpcodes32[256*2] = {
  // 256 entries for single byte opcodes
  /* 00 */ { 0, &Ia_addb_Eb_Gb    },
  /* 01 */ { 0, &Ia_addl_Ed_Gd    },
  /* 02 */ { 0, &Ia_addb_Gb_Eb    },
  /* 03 */ { 0, &Ia_addl_Gd_Ed    },
  /* 04 */ { 0, &Ia_addb_AL_Ib,   },
  /* 05 */ { 0, &Ia_addl_EAX_Id,  },
  /* 06 */ { 0, &Ia_pushl_ES      },
  /* 07 */ { 0, &Ia_popl_ES       },
  /* 08 */ { 0, &Ia_orb_Eb_Gb     },
  /* 09 */ { 0, &Ia_orl_Ed_Gd     },
  /* 0A */ { 0, &Ia_orb_Gb_Eb     },
  /* 0B */ { 0, &Ia_orl_Gd_Ed     },
  /* 0C */ { 0, &Ia_orb_AL_Ib     },
  /* 0D */ { 0, &Ia_orl_EAX_Id    },
  /* 0E */ { 0, &Ia_pushl_CS      },
  /* 0F */ { 0, &Ia_error         },   // 2 byte escape
  /* 10 */ { 0, &Ia_adcb_Eb_Gb    },
  /* 11 */ { 0, &Ia_adcl_Ed_Gd    },
  /* 12 */ { 0, &Ia_adcb_Gb_Eb    },
  /* 13 */ { 0, &Ia_adcl_Gd_Ed    },
  /* 14 */ { 0, &Ia_adcb_AL_Ib    },
  /* 15 */ { 0, &Ia_adcl_EAX_Id   },
  /* 16 */ { 0, &Ia_pushl_SS      },
  /* 17 */ { 0, &Ia_popl_SS       },
  /* 18 */ { 0, &Ia_sbbb_Eb_Gb    },
  /* 19 */ { 0, &Ia_sbbl_Ed_Gd    },
  /* 1A */ { 0, &Ia_sbbb_Gb_Eb    },
  /* 1B */ { 0, &Ia_sbbl_Gd_Ed    },
  /* 1C */ { 0, &Ia_sbbb_AL_Ib    },
  /* 1D */ { 0, &Ia_sbbl_EAX_Id   },
  /* 1E */ { 0, &Ia_pushl_DS      },
  /* 1F */ { 0, &Ia_popl_DS       },
  /* 20 */ { 0, &Ia_andb_Eb_Gb    },
  /* 21 */ { 0, &Ia_andl_Ed_Gd    },
  /* 22 */ { 0, &Ia_andb_Gb_Eb    },
  /* 23 */ { 0, &Ia_andl_Gd_Ed    },
  /* 24 */ { 0, &Ia_andb_AL_Ib    },
  /* 25 */ { 0, &Ia_andl_EAX_Id   },
  /* 26 */ { 0, &Ia_prefix_es     },   // ES:
  /* 27 */ { 0, &Ia_daa           },
  /* 28 */ { 0, &Ia_subb_Eb_Gb    },
  /* 29 */ { 0, &Ia_subl_Ed_Gd    },
  /* 2A */ { 0, &Ia_subb_Gb_Eb    },
  /* 2B */ { 0, &Ia_subl_Gd_Ed    },
  /* 2C */ { 0, &Ia_subb_AL_Ib    },
  /* 2D */ { 0, &Ia_subl_EAX_Id   },
  /* 2E */ { 0, &Ia_prefix_cs     },   // CS:
  /* 2F */ { 0, &Ia_das           },
  /* 30 */ { 0, &Ia_xorb_Eb_Gb    },
  /* 31 */ { 0, &Ia_xorl_Ed_Gd    },
  /* 32 */ { 0, &Ia_xorb_Gb_Eb    },
  /* 33 */ { 0, &Ia_xorl_Gd_Ed    },
  /* 34 */ { 0, &Ia_xorb_AL_Ib    },
  /* 35 */ { 0, &Ia_xorl_EAX_Id   },
  /* 36 */ { 0, &Ia_prefix_ss     },   // SS:
  /* 37 */ { 0, &Ia_aaa           },
  /* 38 */ { 0, &Ia_cmpb_Eb_Gb    },
  /* 39 */ { 0, &Ia_cmpl_Ed_Gd    },
  /* 3A */ { 0, &Ia_cmpb_Gb_Eb    },
  /* 3B */ { 0, &Ia_cmpl_Gd_Ed    },
  /* 3C */ { 0, &Ia_cmpb_AL_Ib    },
  /* 3D */ { 0, &Ia_cmpl_EAX_Id   },
  /* 3E */ { 0, &Ia_prefix_ds     },   // DS:
  /* 3F */ { 0, &Ia_aas           },
  /* 40 */ { 0, &Ia_incl_ERX      },
  /* 41 */ { 0, &Ia_incl_ERX      },
  /* 42 */ { 0, &Ia_incl_ERX      },
  /* 43 */ { 0, &Ia_incl_ERX      },
  /* 44 */ { 0, &Ia_incl_ERX      },
  /* 45 */ { 0, &Ia_incl_ERX      },
  /* 46 */ { 0, &Ia_incl_ERX      },
  /* 47 */ { 0, &Ia_incl_ERX      },
  /* 48 */ { 0, &Ia_decl_ERX      },
  /* 49 */ { 0, &Ia_decl_ERX      },
  /* 4A */ { 0, &Ia_decl_ERX      },
  /* 4B */ { 0, &Ia_decl_ERX      },
  /* 4C */ { 0, &Ia_decl_ERX      },
  /* 4D */ { 0, &Ia_decl_ERX      },
  /* 4E */ { 0, &Ia_decl_ERX      },
  /* 4F */ { 0, &Ia_decl_ERX      },
  /* 50 */ { 0, &Ia_pushl_ERX     },
  /* 51 */ { 0, &Ia_pushl_ERX     },
  /* 52 */ { 0, &Ia_pushl_ERX     },
  /* 53 */ { 0, &Ia_pushl_ERX     },
  /* 54 */ { 0, &Ia_pushl_ERX     },
  /* 55 */ { 0, &Ia_pushl_ERX     },
  /* 56 */ { 0, &Ia_pushl_ERX     },
  /* 57 */ { 0, &Ia_pushl_ERX     },
  /* 58 */ { 0, &Ia_popl_ERX      },
  /* 59 */ { 0, &Ia_popl_ERX      },
  /* 5A */ { 0, &Ia_popl_ERX      },
  /* 5B */ { 0, &Ia_popl_ERX      },
  /* 5C */ { 0, &Ia_popl_ERX      },
  /* 5D */ { 0, &Ia_popl_ERX      },
  /* 5E */ { 0, &Ia_popl_ERX      },
  /* 5F */ { 0, &Ia_popl_ERX      },
  /* 60 */ { 0, &Ia_pushal        },
  /* 61 */ { 0, &Ia_popal         },
  /* 62 */ { 0, &Ia_boundl_Gd_Ma  },
  /* 63 */ { 0, &Ia_arpl_Ew_Gw    },
  /* 64 */ { 0, &Ia_prefix_fs     },   // FS:
  /* 65 */ { 0, &Ia_prefix_gs     },   // GS:
  /* 66 */ { 0, &Ia_prefix_osize  },   // OSIZE:
  /* 67 */ { 0, &Ia_prefix_asize  },   // ASIZE:
  /* 68 */ { 0, &Ia_pushl_Id      },
  /* 69 */ { 0, &Ia_imull_Gd_Ed_Id  },
  /* 6A */ { 0, &Ia_pushl_sIb     },
  /* 6B */ { 0, &Ia_imull_Gd_Ed_sIb },
  /* 6C */ { 0, &Ia_insb_Yb_DX    },
  /* 6D */ { 0, &Ia_insl_Yd_DX    },
  /* 6E */ { 0, &Ia_outsb_DX_Xb   },
  /* 6F */ { 0, &Ia_outsl_DX_Xd   },
  /* 70 */ { 0, &Ia_jo_Jb         },
  /* 71 */ { 0, &Ia_jno_Jb        },
  /* 72 */ { 0, &Ia_jb_Jb         },
  /* 73 */ { 0, &Ia_jnb_Jb        },
  /* 74 */ { 0, &Ia_jz_Jb         },
  /* 75 */ { 0, &Ia_jnz_Jb        },
  /* 76 */ { 0, &Ia_jbe_Jb        },
  /* 77 */ { 0, &Ia_jnbe_Jb       },
  /* 78 */ { 0, &Ia_js_Jb         },
  /* 79 */ { 0, &Ia_jns_Jb        },
  /* 7A */ { 0, &Ia_jp_Jb         },
  /* 7B */ { 0, &Ia_jnp_Jb        },
  /* 7C */ { 0, &Ia_jl_Jb         },
  /* 7D */ { 0, &Ia_jnl_Jb        },
  /* 7E */ { 0, &Ia_jle_Jb        },
  /* 7F */ { 0, &Ia_jnle_Jb       },
  /* 80 */ { GRPN(G1EbIb)         },
  /* 81 */ { GRPN(G1EdId)         },
  /* 82 */ { GRPN(G1EbIb)         },
  /* 83 */ { GRPN(G1EdIb)         },
  /* 84 */ { 0, &Ia_testb_Eb_Gb   },
  /* 85 */ { 0, &Ia_testl_Ed_Gd   },
  /* 86 */ { 0, &Ia_xchgb_Eb_Gb   },
  /* 87 */ { 0, &Ia_xchgl_Ed_Gd   },
  /* 88 */ { 0, &Ia_movb_Eb_Gb    },
  /* 89 */ { 0, &Ia_movl_Ed_Gd    },
  /* 8A */ { 0, &Ia_movb_Gb_Eb    },
  /* 8B */ { 0, &Ia_movl_Gd_Ed    },
  /* 8C */ { 0, &Ia_movw_Ew_Sw    },
  /* 8D */ { 0, &Ia_leal_Gd_Md    },
  /* 8E */ { 0, &Ia_movw_Sw_Ew    },
  /* 8F */ { 0, &Ia_popl_Ed       },
  /* 90 */ { 0, &Ia_nop           },
  /* 91 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 92 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 93 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 94 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 95 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 96 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 97 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 98 */ { 0, &Ia_cwde          },
  /* 99 */ { 0, &Ia_cdq           },
  /* 9A */ { 0, &Ia_lcall_Apd     },
  /* 9B */ { 0, &Ia_fwait         },
  /* 9C */ { 0, &Ia_pushfl        },
  /* 9D */ { 0, &Ia_popfl         },
  /* 9E */ { 0, &Ia_sahf          },
  /* 9F */ { 0, &Ia_lahf          },
  /* A0 */ { 0, &Ia_movb_AL_Ob    },
  /* A1 */ { 0, &Ia_movl_EAX_Od   },
  /* A0 */ { 0, &Ia_movb_Ob_AL    },
  /* A1 */ { 0, &Ia_movl_Od_EAX   },
  /* A4 */ { 0, &Ia_movsb_Yb_Xb   },
  /* A5 */ { 0, &Ia_movsl_Yd_Xd   },
  /* A6 */ { 0, &Ia_cmpsb_Yb_Xb   },
  /* A7 */ { 0, &Ia_cmpsl_Yd_Xd   },
  /* A8 */ { 0, &Ia_testb_AL_Ib   },
  /* A9 */ { 0, &Ia_testl_EAX_Id  },
  /* AA */ { 0, &Ia_stosb_Yb_AL   },
  /* AB */ { 0, &Ia_stosl_Yd_EAX  },
  /* AC */ { 0, &Ia_lodsb_AL_Xb   },
  /* AD */ { 0, &Ia_lodsl_EAX_Xd  },
  /* AE */ { 0, &Ia_scasb_Yb_AL   },
  /* AF */ { 0, &Ia_scasl_Yd_EAX  },
  /* B0 */ { 0, &Ia_movb_R8_Ib    },
  /* B1 */ { 0, &Ia_movb_R8_Ib    },
  /* B2 */ { 0, &Ia_movb_R8_Ib    },
  /* B3 */ { 0, &Ia_movb_R8_Ib    },
  /* B4 */ { 0, &Ia_movb_R8_Ib    },
  /* B5 */ { 0, &Ia_movb_R8_Ib    },
  /* B6 */ { 0, &Ia_movb_R8_Ib    },
  /* B7 */ { 0, &Ia_movb_R8_Ib    },
  /* B8 */ { 0, &Ia_movl_ERX_Id   },
  /* B9 */ { 0, &Ia_movl_ERX_Id   },
  /* BA */ { 0, &Ia_movl_ERX_Id   },
  /* BB */ { 0, &Ia_movl_ERX_Id   },
  /* BC */ { 0, &Ia_movl_ERX_Id   },
  /* BD */ { 0, &Ia_movl_ERX_Id   },
  /* BE */ { 0, &Ia_movl_ERX_Id   },
  /* BF */ { 0, &Ia_movl_ERX_Id   },
  /* C0 */ { GRPN(G2Eb)           },
  /* C1 */ { GRPN(G2Ed)           },
  /* C2 */ { 0, &Ia_ret_Iw        },
  /* C3 */ { 0, &Ia_ret           },
  /* C4 */ { 0, &Ia_lesl_Gd_Mp    },
  /* C5 */ { 0, &Ia_ldsl_Gd_Mp    },
  /* C6 */ { GRPN(G11Eb)          },
  /* C7 */ { GRPN(G11Ed)          },
  /* C8 */ { 0, &Ia_enter         },
  /* C9 */ { 0, &Ia_leave         },
  /* CA */ { 0, &Ia_lret_Iw       },
  /* CB */ { 0, &Ia_lret          },
  /* CC */ { 0, &Ia_int3          },
  /* CD */ { 0, &Ia_int_Ib        },
  /* CE */ { 0, &Ia_into          },
  /* CF */ { 0, &Ia_iretl         },
  /* D0 */ { GRPN(G2EbI1)         },
  /* D1 */ { GRPN(G2EdI1)         },
  /* D2 */ { GRPN(G2EbCL)         },
  /* D3 */ { GRPN(G2EdCL)         },
  /* D4 */ { 0, &Ia_aam           },
  /* D5 */ { 0, &Ia_aad           },
  /* D6 */ { 0, &Ia_salc          },
  /* D7 */ { 0, &Ia_xlat          },
  /* D8 */ { GRPFP(D8)            },
  /* D9 */ { GRPFP(D9)            },
  /* DA */ { GRPFP(DA)            },
  /* DB */ { GRPFP(DB)            },
  /* DC */ { GRPFP(DC)            },
  /* DD */ { GRPFP(DD)            },
  /* DE */ { GRPFP(DE)            },
  /* DF */ { GRPFP(DF)            },
  /* E0 */ { 0, &Ia_loopne_Jb     },
  /* E1 */ { 0, &Ia_loope_Jb      },
  /* E2 */ { 0, &Ia_loop_Jb       },
  /* E3 */ { 0, &Ia_jcxz_Jb       },
  /* E4 */ { 0, &Ia_inb_AL_Ib     },
  /* E5 */ { 0, &Ia_inl_EAX_Ib    },
  /* E6 */ { 0, &Ia_outb_Ib_AL    },
  /* E7 */ { 0, &Ia_outl_Ib_EAX   },
  /* E8 */ { 0, &Ia_call_Jd       },
  /* E9 */ { 0, &Ia_jmp_Jd        },
  /* EA */ { 0, &Ia_ljmp_Apd      },
  /* EB */ { 0, &Ia_jmp_Jb        },
  /* EC */ { 0, &Ia_inb_AL_DX     },
  /* ED */ { 0, &Ia_inl_EAX_DX    },
  /* EE */ { 0, &Ia_outb_DX_AL    },
  /* EF */ { 0, &Ia_outl_DX_EAX   },
  /* F0 */ { 0, &Ia_prefix_lock   },   // LOCK:
  /* F1 */ { 0, &Ia_int1          },
  /* F2 */ { 0, &Ia_prefix_repne  },   // REPNE:
  /* F3 */ { 0, &Ia_prefix_rep    },   // REP:
  /* F4 */ { 0, &Ia_hlt           },
  /* F5 */ { 0, &Ia_cmc           },
  /* F6 */ { GRPN(G3Eb)           },
  /* F7 */ { GRPN(G3Ed)           },
  /* F8 */ { 0, &Ia_clc           },
  /* F9 */ { 0, &Ia_stc           },
  /* FA */ { 0, &Ia_cli           },
  /* FB */ { 0, &Ia_sti           },
  /* FC */ { 0, &Ia_cld           },
  /* FD */ { 0, &Ia_std           },
  /* FE */ { GRPN(G4)             },
  /* FF */ { GRPN(G5d)            },

  // 256 entries for two byte opcodes
  /* 0F 00 */ { GRPN(G6)          },
  /* 0F 01 */ { GRPMOD(G7)        },
  /* 0F 02 */ { 0, &Ia_larl_Gd_Ew },
  /* 0F 03 */ { 0, &Ia_lsll_Gd_Ew },
  /* 0F 04 */ { 0, &Ia_Invalid    },
  /* 0F 05 */ { 0, &Ia_syscall    },
  /* 0F 06 */ { 0, &Ia_clts       },
  /* 0F 07 */ { 0, &Ia_sysret     },
  /* 0F 08 */ { 0, &Ia_invd       },
  /* 0F 09 */ { 0, &Ia_wbinvd     },
  /* 0F 0A */ { 0, &Ia_Invalid    },
  /* 0F 0B */ { 0, &Ia_ud2a       },
  /* 0F 0C */ { 0, &Ia_Invalid    },
  /* 0F 0D */ { 0, &Ia_prefetchw  },   // 3DNow!
  /* 0F 0E */ { 0, &Ia_femms      },   // 3DNow!
  /* 0F 0F */ { GRP3DNOW          },
  /* 0F 10 */ { GRPSSE(0f10)      },
  /* 0F 11 */ { GRPSSE(0f11)      },
  /* 0F 12 */ { GRPSSE(0f12)      },
  /* 0F 13 */ { GRPSSE(0f13)      },
  /* 0F 14 */ { GRPSSE(0f14)      },
  /* 0F 15 */ { GRPSSE(0f15)      },
  /* 0F 16 */ { GRPSSE(0f16)      },
  /* 0F 17 */ { GRPSSE(0f17)      },
  /* 0F 18 */ { GRPN(G16)         },
  /* 0F 19 */ { 0, &Ia_multibyte_nop },
  /* 0F 1A */ { 0, &Ia_multibyte_nop },
  /* 0F 1B */ { 0, &Ia_multibyte_nop },
  /* 0F 1C */ { 0, &Ia_multibyte_nop },
  /* 0F 1D */ { 0, &Ia_multibyte_nop },
  /* 0F 1E */ { 0, &Ia_multibyte_nop },
  /* 0F 1F */ { 0, &Ia_multibyte_nop },
  /* 0F 20 */ { 0, &Ia_movl_Rd_Cd },
  /* 0F 21 */ { 0, &Ia_movl_Rd_Dd },
  /* 0F 22 */ { 0, &Ia_movl_Cd_Rd },
  /* 0F 23 */ { 0, &Ia_movl_Dd_Rd },
  /* 0F 24 */ { 0, &Ia_movl_Rd_Td },
  /* 0F 25 */ { 0, &Ia_Invalid    },
  /* 0F 26 */ { 0, &Ia_movl_Td_Rd },
  /* 0F 27 */ { 0, &Ia_Invalid    },
  /* 0F 28 */ { GRPSSE(0f28) },
  /* 0F 29 */ { GRPSSE(0f29) },
  /* 0F 2A */ { GRPSSE(0f2a) },
  /* 0F 2B */ { GRPSSE(0f2b) },
  /* 0F 2C */ { GRPSSE(0f2c) },
  /* 0F 2D */ { GRPSSE(0f2d) },
  /* 0F 2E */ { GRPSSE(0f2e) },
  /* 0F 2F */ { GRPSSE(0f2f) },
  /* 0F 30 */ { 0, &Ia_wrmsr },
  /* 0F 31 */ { 0, &Ia_rdtsc },
  /* 0F 32 */ { 0, &Ia_rdmsr },
  /* 0F 33 */ { 0, &Ia_rdpmc },
  /* 0F 34 */ { 0, &Ia_sysenter },
  /* 0F 35 */ { 0, &Ia_sysexit },
  /* 0F 36 */ { 0, &Ia_Invalid },
  /* 0F 37 */ { 0, &Ia_getsec },
  /* 0F 38 */ { GR3BTAB(0f38) },
  /* 0F 39 */ { 0, &Ia_Invalid  },
  /* 0F 3A */ { GR3BTAB(0f3a) },
  /* 0F 3B */ { 0, &Ia_Invalid },
  /* 0F 3C */ { 0, &Ia_Invalid },
  /* 0F 3D */ { 0, &Ia_Invalid },
  /* 0F 3E */ { 0, &Ia_Invalid },
  /* 0F 3F */ { 0, &Ia_Invalid },
  /* 0F 40 */ { 0, &Ia_cmovol_Gd_Ed  },
  /* 0F 41 */ { 0, &Ia_cmovnol_Gd_Ed },
  /* 0F 42 */ { 0, &Ia_cmovcl_Gd_Ed  },
  /* 0F 43 */ { 0, &Ia_cmovncl_Gd_Ed },
  /* 0F 44 */ { 0, &Ia_cmovzl_Gd_Ed  },
  /* 0F 45 */ { 0, &Ia_cmovnzl_Gd_Ed },
  /* 0F 46 */ { 0, &Ia_cmovnal_Gd_Ed },
  /* 0F 47 */ { 0, &Ia_cmoval_Gd_Ed  },
  /* 0F 48 */ { 0, &Ia_cmovsl_Gd_Ed  },
  /* 0F 49 */ { 0, &Ia_cmovnsl_Gd_Ed },
  /* 0F 4A */ { 0, &Ia_cmovpl_Gd_Ed  },
  /* 0F 4B */ { 0, &Ia_cmovnpl_Gd_Ed },
  /* 0F 4C */ { 0, &Ia_cmovll_Gd_Ed  },
  /* 0F 4D */ { 0, &Ia_cmovnll_Gd_Ed },
  /* 0F 4E */ { 0, &Ia_cmovngl_Gd_Ed },
  /* 0F 4F */ { 0, &Ia_cmovgl_Gd_Ed  },
  /* 0F 50 */ { GRPSSE(0f50) },
  /* 0F 51 */ { GRPSSE(0f51) },
  /* 0F 52 */ { GRPSSE(0f52) },
  /* 0F 53 */ { GRPSSE(0f53) },
  /* 0F 54 */ { GRPSSE(0f54) },
  /* 0F 55 */ { GRPSSE(0f55) },
  /* 0F 56 */ { GRPSSE(0f56) },
  /* 0F 57 */ { GRPSSE(0f57) },
  /* 0F 58 */ { GRPSSE(0f58) },
  /* 0F 59 */ { GRPSSE(0f59) },
  /* 0F 5A */ { GRPSSE(0f5a) },
  /* 0F 5B */ { GRPSSE(0f5b) },
  /* 0F 5C */ { GRPSSE(0f5c) },
  /* 0F 5D */ { GRPSSE(0f5d) },
  /* 0F 5E */ { GRPSSE(0f5e) },
  /* 0F 5F */ { GRPSSE(0f5f) },
  /* 0F 60 */ { GRPSSE(0f60) },
  /* 0F 61 */ { GRPSSE(0f61) },
  /* 0F 62 */ { GRPSSE(0f62) },
  /* 0F 63 */ { GRPSSE(0f63) },
  /* 0F 64 */ { GRPSSE(0f64) },
  /* 0F 65 */ { GRPSSE(0f65) },
  /* 0F 66 */ { GRPSSE(0f66) },
  /* 0F 67 */ { GRPSSE(0f67) },
  /* 0F 68 */ { GRPSSE(0f68) },
  /* 0F 69 */ { GRPSSE(0f69) },
  /* 0F 6A */ { GRPSSE(0f6a) },
  /* 0F 6B */ { GRPSSE(0f6b) },
  /* 0F 6C */ { GRPSSE66(Ia_punpcklqdq_Vdq_Wdq) },
  /* 0F 6D */ { GRPSSE66(Ia_punpckhqdq_Vdq_Wdq) },
  /* 0F 6E */ { GRPSSE(0f6e) },
  /* 0F 6F */ { GRPSSE(0f6f) },
  /* 0F 70 */ { GRPSSE(0f70) },
  /* 0F 71 */ { GRPN(G12)    },
  /* 0F 72 */ { GRPN(G13)    },
  /* 0F 73 */ { GRPN(G14)    },
  /* 0F 74 */ { GRPSSE(0f74) },
  /* 0F 75 */ { GRPSSE(0f75) },
  /* 0F 76 */ { GRPSSE(0f76) },
  /* 0F 77 */ { 0, &Ia_emms  },
  /* 0F 78 */ { GRPSSE(0f78) }, // VMX
  /* 0F 79 */ { GRPSSE(0f79) }, // VMX
  /* 0F 7A */ { 0, &Ia_Invalid },
  /* 0F 7B */ { 0, &Ia_Invalid },
  /* 0F 7C */ { GRPSSE(0f7c) },
  /* 0F 7D */ { GRPSSE(0f7d) },
  /* 0F 7E */ { GRPSSE(0f7e) },
  /* 0F 7F */ { GRPSSE(0f7f) },
  /* 0F 80 */ { 0, &Ia_jo_Jd     },
  /* 0F 81 */ { 0, &Ia_jno_Jd    },
  /* 0F 82 */ { 0, &Ia_jb_Jd     },
  /* 0F 83 */ { 0, &Ia_jnb_Jd    },
  /* 0F 84 */ { 0, &Ia_jz_Jd     },
  /* 0F 85 */ { 0, &Ia_jnz_Jd    },
  /* 0F 86 */ { 0, &Ia_jbe_Jd    },
  /* 0F 87 */ { 0, &Ia_jnbe_Jd   },
  /* 0F 88 */ { 0, &Ia_js_Jd     },
  /* 0F 89 */ { 0, &Ia_jns_Jd    },
  /* 0F 8A */ { 0, &Ia_jp_Jd     },
  /* 0F 8B */ { 0, &Ia_jnp_Jd    },
  /* 0F 8C */ { 0, &Ia_jl_Jd     },
  /* 0F 8D */ { 0, &Ia_jnl_Jd    },
  /* 0F 8E */ { 0, &Ia_jle_Jd    },
  /* 0F 8F */ { 0, &Ia_jnle_Jd   },
  /* 0F 90 */ { 0, &Ia_seto_Eb   },
  /* 0F 91 */ { 0, &Ia_setno_Eb  },
  /* 0F 92 */ { 0, &Ia_setb_Eb   },
  /* 0F 93 */ { 0, &Ia_setnb_Eb  },
  /* 0F 94 */ { 0, &Ia_setz_Eb   },
  /* 0F 95 */ { 0, &Ia_setnz_Eb  },
  /* 0F 96 */ { 0, &Ia_setbe_Eb  },
  /* 0F 97 */ { 0, &Ia_setnbe_Eb },
  /* 0F 98 */ { 0, &Ia_sets_Eb   },
  /* 0F 99 */ { 0, &Ia_setns_Eb  },
  /* 0F 9A */ { 0, &Ia_setp_Eb   },
  /* 0F 9B */ { 0, &Ia_setnp_Eb  },
  /* 0F 9C */ { 0, &Ia_setl_Eb   },
  /* 0F 9D */ { 0, &Ia_setnl_Eb  },
  /* 0F 9E */ { 0, &Ia_setle_Eb  },
  /* 0F 9F */ { 0, &Ia_setnle_Eb },
  /* 0F A0 */ { 0, &Ia_pushl_FS  },
  /* 0F A1 */ { 0, &Ia_popl_FS   },
  /* 0F A2 */ { 0, &Ia_cpuid     },
  /* 0F A3 */ { 0, &Ia_btl_Ed_Gd },
  /* 0F A4 */ { 0, &Ia_shldl_Ed_Gd_Ib },
  /* 0F A5 */ { 0, &Ia_shldl_Ed_Gd_CL },
  /* 0F A6 */ { 0, &Ia_Invalid    },
  /* 0F A7 */ { 0, &Ia_Invalid    },
  /* 0F A8 */ { 0, &Ia_pushl_GS   },
  /* 0F A9 */ { 0, &Ia_popl_GS    },
  /* 0F AA */ { 0, &Ia_rsm        },
  /* 0F AB */ { 0, &Ia_btsl_Ed_Gd },
  /* 0F AC */ { 0, &Ia_shrdl_Ed_Gd_Ib },
  /* 0F AD */ { 0, &Ia_shrdl_Ed_Gd_CL },
  /* 0F AE */ { GRPMOD(G15)           },
  /* 0F AF */ { 0, &Ia_imull_Gd_Ed    },
  /* 0F B0 */ { 0, &Ia_cmpxchgb_Eb_Gb },
  /* 0F B1 */ { 0, &Ia_cmpxchgl_Ed_Gd },
  /* 0F B2 */ { 0, &Ia_lssl_Gd_Mp   },
  /* 0F B3 */ { 0, &Ia_btrl_Ed_Gd   },
  /* 0F B4 */ { 0, &Ia_lfsl_Gd_Mp   },
  /* 0F B5 */ { 0, &Ia_lgsl_Gd_Mp   },
  /* 0F B6 */ { 0, &Ia_movzbl_Gd_Eb },
  /* 0F B7 */ { 0, &Ia_movzwl_Gd_Ew },
  /* 0F B8 */ { GRPSSEF3(Ia_popcnt_Gd_Ed) },
  /* 0F B9 */ { 0, &Ia_ud2b         },
  /* 0F BA */ { GRPN(G8EdIb)        },
  /* 0F BB */ { 0, &Ia_btcl_Ed_Gd   },
  /* 0F BC */ { GRPSSE(0fbcd) },
  /* 0F BD */ { GRPSSE(0fbdd) },
  /* 0F BE */ { 0, &Ia_movsbl_Gd_Eb },
  /* 0F BF */ { 0, &Ia_movswl_Gd_Ew },
  /* 0F C0 */ { 0, &Ia_xaddb_Eb_Gb  },
  /* 0F C0 */ { 0, &Ia_xaddl_Ed_Gd  },
  /* 0F C2 */ { GRPSSE(0fc2)      },
  /* 0F C3 */ { GRPSSE(0fc3)      },
  /* 0F C4 */ { GRPSSE(0fc4)      },
  /* 0F C5 */ { GRPSSE(0fc5)      },
  /* 0F C6 */ { GRPSSE(0fc6)      },
  /* 0F C7 */ { GRPN(G9)          },
  /* 0F C8 */ { 0, &Ia_bswapl_ERX },
  /* 0F C9 */ { 0, &Ia_bswapl_ERX },
  /* 0F CA */ { 0, &Ia_bswapl_ERX },
  /* 0F CB */ { 0, &Ia_bswapl_ERX },
  /* 0F CC */ { 0, &Ia_bswapl_ERX },
  /* 0F CD */ { 0, &Ia_bswapl_ERX },
  /* 0F CE */ { 0, &Ia_bswapl_ERX },
  /* 0F CF */ { 0, &Ia_bswapl_ERX },
  /* 0F D0 */ { GRPSSE(0fd0) },
  /* 0F D1 */ { GRPSSE(0fd1) },
  /* 0F D2 */ { GRPSSE(0fd2) },
  /* 0F D3 */ { GRPSSE(0fd3) },
  /* 0F D4 */ { GRPSSE(0fd4) },
  /* 0F D5 */ { GRPSSE(0fd5) },
  /* 0F D6 */ { GRPSSE(0fd6) },
  /* 0F D7 */ { GRPSSE(0fd7) },
  /* 0F D8 */ { GRPSSE(0fd8) },
  /* 0F D9 */ { GRPSSE(0fd9) },
  /* 0F DA */ { GRPSSE(0fda) },
  /* 0F DB */ { GRPSSE(0fdb) },
  /* 0F DC */ { GRPSSE(0fdc) },
  /* 0F DD */ { GRPSSE(0fdd) },
  /* 0F DE */ { GRPSSE(0fde) },
  /* 0F DF */ { GRPSSE(0fdf) },
  /* 0F E0 */ { GRPSSE(0fe0) },
  /* 0F E1 */ { GRPSSE(0fe1) },
  /* 0F E2 */ { GRPSSE(0fe2) },
  /* 0F E3 */ { GRPSSE(0fe3) },
  /* 0F E4 */ { GRPSSE(0fe4) },
  /* 0F E5 */ { GRPSSE(0fe5) },
  /* 0F E6 */ { GRPSSE(0fe6) },
  /* 0F E7 */ { GRPSSE(0fe7) },
  /* 0F E8 */ { GRPSSE(0fe8) },
  /* 0F E9 */ { GRPSSE(0fe9) },
  /* 0F EA */ { GRPSSE(0fea) },
  /* 0F EB */ { GRPSSE(0feb) },
  /* 0F EC */ { GRPSSE(0fec) },
  /* 0F ED */ { GRPSSE(0fed) },
  /* 0F EE */ { GRPSSE(0fee) },
  /* 0F EF */ { GRPSSE(0fef) },
  /* 0F F0 */ { GRPSSEF2(Ia_lddqu_Vdq_Mdq) },
  /* 0F F1 */ { GRPSSE(0ff1) },
  /* 0F F2 */ { GRPSSE(0ff2) },
  /* 0F F3 */ { GRPSSE(0ff3) },
  /* 0F F4 */ { GRPSSE(0ff4) },
  /* 0F F5 */ { GRPSSE(0ff5) },
  /* 0F F6 */ { GRPSSE(0ff6) },
  /* 0F F7 */ { GRPSSE(0ff7) },
  /* 0F F8 */ { GRPSSE(0ff8) },
  /* 0F F9 */ { GRPSSE(0ff9) },
  /* 0F FA */ { GRPSSE(0ffa) },
  /* 0F FB */ { GRPSSE(0ffb) },
  /* 0F FC */ { GRPSSE(0ffc) },
  /* 0F FD */ { GRPSSE(0ffd) },
  /* 0F FE */ { GRPSSE(0ffe) },
  /* 0F FF */ { 0, &Ia_Invalid }
};

/* ************************************************************************ */
/* Long mode */

static BxDisasmOpcodeTable_t BxDisasmOpcodes64w[256*2] = {
  // 256 entries for single byte opcodes
  /* 00 */ { 0, &Ia_addb_Eb_Gb },
  /* 01 */ { 0, &Ia_addw_Ew_Gw },
  /* 02 */ { 0, &Ia_addb_Gb_Eb },
  /* 03 */ { 0, &Ia_addw_Gw_Ew },
  /* 04 */ { 0, &Ia_addb_AL_Ib },
  /* 05 */ { 0, &Ia_addw_AX_Iw },
  /* 06 */ { 0, &Ia_Invalid    },
  /* 07 */ { 0, &Ia_Invalid    },
  /* 08 */ { 0, &Ia_orb_Eb_Gb  },
  /* 09 */ { 0, &Ia_orw_Ew_Gw  },
  /* 0A */ { 0, &Ia_orb_Gb_Eb  },
  /* 0B */ { 0, &Ia_orw_Gw_Ew  },
  /* 0C */ { 0, &Ia_orb_AL_Ib  },
  /* 0D */ { 0, &Ia_orw_AX_Iw  },
  /* 0E */ { 0, &Ia_Invalid    },
  /* 0F */ { 0, &Ia_error      },   // 2 byte escape
  /* 10 */ { 0, &Ia_adcb_Eb_Gb },
  /* 11 */ { 0, &Ia_adcw_Ew_Gw },
  /* 12 */ { 0, &Ia_adcb_Gb_Eb },
  /* 13 */ { 0, &Ia_adcw_Gw_Ew },
  /* 14 */ { 0, &Ia_adcb_AL_Ib },
  /* 15 */ { 0, &Ia_adcw_AX_Iw },
  /* 16 */ { 0, &Ia_Invalid    },
  /* 17 */ { 0, &Ia_Invalid    },
  /* 18 */ { 0, &Ia_sbbb_Eb_Gb },
  /* 19 */ { 0, &Ia_sbbw_Ew_Gw },
  /* 1A */ { 0, &Ia_sbbb_Gb_Eb },
  /* 1B */ { 0, &Ia_sbbw_Gw_Ew },
  /* 1C */ { 0, &Ia_sbbb_AL_Ib },
  /* 1D */ { 0, &Ia_sbbw_AX_Iw },
  /* 1E */ { 0, &Ia_Invalid    },
  /* 1F */ { 0, &Ia_Invalid    },
  /* 20 */ { 0, &Ia_andb_Eb_Gb },
  /* 21 */ { 0, &Ia_andw_Ew_Gw },
  /* 22 */ { 0, &Ia_andb_Gb_Eb },
  /* 23 */ { 0, &Ia_andw_Gw_Ew },
  /* 24 */ { 0, &Ia_andb_AL_Ib },
  /* 25 */ { 0, &Ia_andw_AX_Iw },
  /* 26 */ { 0, &Ia_prefix_es  },   // ES:
  /* 27 */ { 0, &Ia_Invalid    },
  /* 28 */ { 0, &Ia_subb_Eb_Gb },
  /* 29 */ { 0, &Ia_subw_Ew_Gw },
  /* 2A */ { 0, &Ia_subb_Gb_Eb },
  /* 2B */ { 0, &Ia_subw_Gw_Ew },
  /* 2C */ { 0, &Ia_subb_AL_Ib },
  /* 2D */ { 0, &Ia_subw_AX_Iw },
  /* 2E */ { 0, &Ia_prefix_cs  },   // CS:
  /* 2F */ { 0, &Ia_Invalid    },
  /* 30 */ { 0, &Ia_xorb_Eb_Gb },
  /* 31 */ { 0, &Ia_xorw_Ew_Gw },
  /* 32 */ { 0, &Ia_xorb_Gb_Eb },
  /* 33 */ { 0, &Ia_xorw_Gw_Ew },
  /* 34 */ { 0, &Ia_xorb_AL_Ib },
  /* 35 */ { 0, &Ia_xorw_AX_Iw },
  /* 36 */ { 0, &Ia_prefix_ss  },   // SS:
  /* 37 */ { 0, &Ia_Invalid    },
  /* 38 */ { 0, &Ia_cmpb_Eb_Gb },
  /* 39 */ { 0, &Ia_cmpw_Ew_Gw },
  /* 3A */ { 0, &Ia_cmpb_Gb_Eb },
  /* 3B */ { 0, &Ia_cmpw_Gw_Ew },
  /* 3C */ { 0, &Ia_cmpb_AL_Ib },
  /* 3D */ { 0, &Ia_cmpw_AX_Iw },
  /* 3E */ { 0, &Ia_prefix_ds  },   // DS:
  /* 3F */ { 0, &Ia_Invalid    },
  /* 40 */ { 0, &Ia_prefix_rex },   // REX:
  /* 41 */ { 0, &Ia_prefix_rex },   // REX:
  /* 42 */ { 0, &Ia_prefix_rex },   // REX:
  /* 43 */ { 0, &Ia_prefix_rex },   // REX:
  /* 44 */ { 0, &Ia_prefix_rex },   // REX:
  /* 45 */ { 0, &Ia_prefix_rex },   // REX:
  /* 46 */ { 0, &Ia_prefix_rex },   // REX:
  /* 47 */ { 0, &Ia_prefix_rex },   // REX:
  /* 48 */ { 0, &Ia_prefix_rex },   // REX:
  /* 49 */ { 0, &Ia_prefix_rex },   // REX:
  /* 4A */ { 0, &Ia_prefix_rex },   // REX:
  /* 4B */ { 0, &Ia_prefix_rex },   // REX:
  /* 4C */ { 0, &Ia_prefix_rex },   // REX:
  /* 4D */ { 0, &Ia_prefix_rex },   // REX:
  /* 4E */ { 0, &Ia_prefix_rex },   // REX:
  /* 4F */ { 0, &Ia_prefix_rex },   // REX:
  /* 50 */ { 0, &Ia_pushw_RX   },
  /* 51 */ { 0, &Ia_pushw_RX   },
  /* 52 */ { 0, &Ia_pushw_RX   },
  /* 53 */ { 0, &Ia_pushw_RX   },
  /* 54 */ { 0, &Ia_pushw_RX   },
  /* 55 */ { 0, &Ia_pushw_RX   },
  /* 56 */ { 0, &Ia_pushw_RX   },
  /* 57 */ { 0, &Ia_pushw_RX   },
  /* 58 */ { 0, &Ia_popw_RX    },
  /* 59 */ { 0, &Ia_popw_RX    },
  /* 5A */ { 0, &Ia_popw_RX    },
  /* 5B */ { 0, &Ia_popw_RX    },
  /* 5C */ { 0, &Ia_popw_RX    },
  /* 5D */ { 0, &Ia_popw_RX    },
  /* 5E */ { 0, &Ia_popw_RX    },
  /* 5F */ { 0, &Ia_popw_RX    },
  /* 60 */ { 0, &Ia_Invalid    },
  /* 61 */ { 0, &Ia_Invalid    },
  /* 62 */ { 0, &Ia_Invalid    },
  /* 63 */ { 0, &Ia_movw_Gw_Ew },
  /* 64 */ { 0, &Ia_prefix_fs  },   // FS:
  /* 65 */ { 0, &Ia_prefix_gs  },   // GS:
  /* 66 */ { 0, &Ia_prefix_osize }, // OSIZE:
  /* 67 */ { 0, &Ia_prefix_asize }, // ASIZE:
  /* 68 */ { 0, &Ia_pushw_Iw    },
  /* 69 */ { 0, &Ia_imulw_Gw_Ew_Iw  },
  /* 6A */ { 0, &Ia_pushw_sIb   },
  /* 6B */ { 0, &Ia_imulw_Gw_Ew_sIb },
  /* 6C */ { 0, &Ia_insb_Yb_DX  },
  /* 6D */ { 0, &Ia_insw_Yw_DX  },
  /* 6E */ { 0, &Ia_outsb_DX_Xb },
  /* 6F */ { 0, &Ia_outsw_DX_Xw },
  /* 70 */ { 0, &Ia_jo_Jb       },
  /* 71 */ { 0, &Ia_jno_Jb      },
  /* 72 */ { 0, &Ia_jb_Jb       },
  /* 73 */ { 0, &Ia_jnb_Jb      },
  /* 74 */ { 0, &Ia_jz_Jb       },
  /* 75 */ { 0, &Ia_jnz_Jb      },
  /* 76 */ { 0, &Ia_jbe_Jb      },
  /* 77 */ { 0, &Ia_jnbe_Jb     },
  /* 78 */ { 0, &Ia_js_Jb       },
  /* 79 */ { 0, &Ia_jns_Jb      },
  /* 7A */ { 0, &Ia_jp_Jb       },
  /* 7B */ { 0, &Ia_jnp_Jb      },
  /* 7C */ { 0, &Ia_jl_Jb       },
  /* 7D */ { 0, &Ia_jnl_Jb      },
  /* 7E */ { 0, &Ia_jle_Jb      },
  /* 7F */ { 0, &Ia_jnle_Jb     },
  /* 80 */ { GRPN(G1EbIb)       },
  /* 81 */ { GRPN(G1EwIw)       },
  /* 82 */ { 9, &Ia_Invalid     },
  /* 83 */ { GRPN(G1EwIb)       },
  /* 84 */ { 0, &Ia_testb_Eb_Gb },
  /* 85 */ { 0, &Ia_testw_Ew_Gw },
  /* 86 */ { 0, &Ia_xchgb_Eb_Gb },
  /* 87 */ { 0, &Ia_xchgw_Ew_Gw },
  /* 88 */ { 0, &Ia_movb_Eb_Gb  },
  /* 89 */ { 0, &Ia_movw_Ew_Gw  },
  /* 8A */ { 0, &Ia_movb_Gb_Eb  },
  /* 8B */ { 0, &Ia_movw_Gw_Ew  },
  /* 8C */ { 0, &Ia_movw_Ew_Sw  },
  /* 8D */ { 0, &Ia_leaw_Gw_Mw  },
  /* 8E */ { 0, &Ia_movw_Sw_Ew  },
  /* 8F */ { 0, &Ia_popw_Ew     },
  /* 90 */ { 0, &Ia_xchgw_RX_AX }, // handle XCHG R8w, AX
  /* 91 */ { 0, &Ia_xchgw_RX_AX },
  /* 92 */ { 0, &Ia_xchgw_RX_AX },
  /* 93 */ { 0, &Ia_xchgw_RX_AX },
  /* 94 */ { 0, &Ia_xchgw_RX_AX },
  /* 95 */ { 0, &Ia_xchgw_RX_AX },
  /* 96 */ { 0, &Ia_xchgw_RX_AX },
  /* 97 */ { 0, &Ia_xchgw_RX_AX },
  /* 98 */ { 0, &Ia_cbw         },
  /* 99 */ { 0, &Ia_cwd         },
  /* 9A */ { 0, &Ia_Invalid     },
  /* 9B */ { 0, &Ia_fwait       },
  /* 9C */ { 0, &Ia_pushfw      },
  /* 9D */ { 0, &Ia_popfw       },
  /* 9E */ { 0, &Ia_sahf        },
  /* 9F */ { 0, &Ia_lahf        },
  /* A0 */ { 0, &Ia_movb_AL_Ob  },
  /* A1 */ { 0, &Ia_movw_AX_Ow  },
  /* A0 */ { 0, &Ia_movb_Ob_AL  },
  /* A1 */ { 0, &Ia_movw_Ow_AX  },
  /* A4 */ { 0, &Ia_movsb_Yb_Xb },
  /* A5 */ { 0, &Ia_movsw_Yw_Xw },
  /* A6 */ { 0, &Ia_cmpsb_Yb_Xb },
  /* A7 */ { 0, &Ia_cmpsw_Yw_Xw },
  /* A8 */ { 0, &Ia_testb_AL_Ib },
  /* A9 */ { 0, &Ia_testw_AX_Iw },
  /* AA */ { 0, &Ia_stosb_Yb_AL },
  /* AB */ { 0, &Ia_stosw_Yw_AX },
  /* AC */ { 0, &Ia_lodsb_AL_Xb },
  /* AD */ { 0, &Ia_lodsw_AX_Xw },
  /* AE */ { 0, &Ia_scasb_Yb_AL },
  /* AF */ { 0, &Ia_scasw_Yw_AX },
  /* B0 */ { 0, &Ia_movb_R8_Ib  },
  /* B1 */ { 0, &Ia_movb_R8_Ib  },
  /* B2 */ { 0, &Ia_movb_R8_Ib  },
  /* B3 */ { 0, &Ia_movb_R8_Ib  },
  /* B4 */ { 0, &Ia_movb_R8_Ib  },
  /* B5 */ { 0, &Ia_movb_R8_Ib  },
  /* B6 */ { 0, &Ia_movb_R8_Ib  },
  /* B7 */ { 0, &Ia_movb_R8_Ib  },
  /* B8 */ { 0, &Ia_movw_RX_Iw  },
  /* B9 */ { 0, &Ia_movw_RX_Iw  },
  /* BA */ { 0, &Ia_movw_RX_Iw  },
  /* BB */ { 0, &Ia_movw_RX_Iw  },
  /* BC */ { 0, &Ia_movw_RX_Iw  },
  /* BD */ { 0, &Ia_movw_RX_Iw  },
  /* BE */ { 0, &Ia_movw_RX_Iw  },
  /* BF */ { 0, &Ia_movw_RX_Iw  },
  /* C0 */ { GRPN(G2Eb)         },
  /* C1 */ { GRPN(G2Ew)         },
  /* C2 */ { 0, &Ia_ret_Iw      },
  /* C3 */ { 0, &Ia_ret         },
  /* C4 */ { 0, &Ia_Invalid     },
  /* C5 */ { 0, &Ia_Invalid     },
  /* C6 */ { GRPN(G11Eb)        },
  /* C7 */ { GRPN(G11Ew)        },
  /* C8 */ { 0, &Ia_enter       },
  /* C9 */ { 0, &Ia_leave       },
  /* CA */ { 0, &Ia_lret_Iw     },
  /* CB */ { 0, &Ia_lret        },
  /* CC */ { 0, &Ia_int3        },
  /* CD */ { 0, &Ia_int_Ib      },
  /* CE */ { 0, &Ia_Invalid     },
  /* CF */ { 0, &Ia_iretw       },
  /* D0 */ { GRPN(G2EbI1)       },
  /* D1 */ { GRPN(G2EwI1)       },
  /* D2 */ { GRPN(G2EbCL)       },
  /* D3 */ { GRPN(G2EwCL)       },
  /* D4 */ { 0, &Ia_Invalid     },
  /* D5 */ { 0, &Ia_Invalid     },
  /* D6 */ { 0, &Ia_Invalid     },
  /* D7 */ { 0, &Ia_xlat        },
  /* D8 */ { GRPFP(D8)          },
  /* D9 */ { GRPFP(D9)          },
  /* DA */ { GRPFP(DA)          },
  /* DB */ { GRPFP(DB)          },
  /* DC */ { GRPFP(DC)          },
  /* DD */ { GRPFP(DD)          },
  /* DE */ { GRPFP(DE)          },
  /* DF */ { GRPFP(DF)          },
  /* E0 */ { 0, &Ia_loopne_Jb   },
  /* E1 */ { 0, &Ia_loope_Jb    },
  /* E2 */ { 0, &Ia_loop_Jb     },
  /* E3 */ { 0, &Ia_jrcxz_Jb    },
  /* E4 */ { 0, &Ia_inb_AL_Ib   },
  /* E5 */ { 0, &Ia_inw_AX_Ib   },
  /* E6 */ { 0, &Ia_outb_Ib_AL  },
  /* E7 */ { 0, &Ia_outw_Ib_AX  },
  /* E8 */ { 0, &Ia_call_Jd     },
  /* E9 */ { 0, &Ia_jmp_Jd      },
  /* EA */ { 0, &Ia_Invalid     },
  /* EB */ { 0, &Ia_jmp_Jb      },
  /* EC */ { 0, &Ia_inb_AL_DX   },
  /* ED */ { 0, &Ia_inw_AX_DX   },
  /* EE */ { 0, &Ia_outb_DX_AL  },
  /* EF */ { 0, &Ia_outw_DX_AX  },
  /* F0 */ { 0, &Ia_prefix_lock },   // LOCK:
  /* F1 */ { 0, &Ia_int1        },
  /* F2 */ { 0, &Ia_prefix_repne },  // REPNE:
  /* F3 */ { 0, &Ia_prefix_rep  },   // REP:
  /* F4 */ { 0, &Ia_hlt         },
  /* F5 */ { 0, &Ia_cmc         },
  /* F6 */ { GRPN(G3Eb)         },
  /* F7 */ { GRPN(G3Ew)         },
  /* F8 */ { 0, &Ia_clc         },
  /* F9 */ { 0, &Ia_stc         },
  /* FA */ { 0, &Ia_cli         },
  /* FB */ { 0, &Ia_sti         },
  /* FC */ { 0, &Ia_cld         },
  /* FD */ { 0, &Ia_std         },
  /* FE */ { GRPN(G4)           },
  /* FF */ { GRPN(64G5w)        },

  // 256 entries for two byte opcodes
  /* 0F 00 */ { GRPN(G6)          },
  /* 0F 01 */ { GRPMOD(G7)        },
  /* 0F 02 */ { 0, &Ia_larw_Gw_Ew },
  /* 0F 03 */ { 0, &Ia_lslw_Gw_Ew },
  /* 0F 04 */ { 0, &Ia_Invalid    },
  /* 0F 05 */ { 0, &Ia_syscall    },
  /* 0F 06 */ { 0, &Ia_clts       },
  /* 0F 07 */ { 0, &Ia_sysret     },
  /* 0F 08 */ { 0, &Ia_invd       },
  /* 0F 09 */ { 0, &Ia_wbinvd     },
  /* 0F 0A */ { 0, &Ia_Invalid    },
  /* 0F 0B */ { 0, &Ia_ud2a       },
  /* 0F 0C */ { 0, &Ia_Invalid    },
  /* 0F 0D */ { 0, &Ia_prefetchw  },   // 3DNow!
  /* 0F 0E */ { 0, &Ia_femms      },   // 3DNow!
  /* 0F 0F */ { GRP3DNOW          },
  /* 0F 10 */ { GRPSSE(0f10)      },
  /* 0F 11 */ { GRPSSE(0f11)      },
  /* 0F 12 */ { GRPSSE(0f12)      },
  /* 0F 13 */ { GRPSSE(0f13)      },
  /* 0F 14 */ { GRPSSE(0f14)      },
  /* 0F 15 */ { GRPSSE(0f15)      },
  /* 0F 16 */ { GRPSSE(0f16)      },
  /* 0F 17 */ { GRPSSE(0f17)      },
  /* 0F 18 */ { GRPN(G16)         },
  /* 0F 19 */ { 0, &Ia_multibyte_nop },
  /* 0F 1A */ { 0, &Ia_multibyte_nop },
  /* 0F 1B */ { 0, &Ia_multibyte_nop },
  /* 0F 1C */ { 0, &Ia_multibyte_nop },
  /* 0F 1D */ { 0, &Ia_multibyte_nop },
  /* 0F 1E */ { 0, &Ia_multibyte_nop },
  /* 0F 1F */ { 0, &Ia_multibyte_nop },
  /* 0F 20 */ { 0, &Ia_movq_Rq_Cq },
  /* 0F 21 */ { 0, &Ia_movq_Rq_Dq },
  /* 0F 22 */ { 0, &Ia_movq_Cq_Rq },
  /* 0F 23 */ { 0, &Ia_movq_Dq_Rq },
  /* 0F 24 */ { 0, &Ia_Invalid    },
  /* 0F 25 */ { 0, &Ia_Invalid    },
  /* 0F 26 */ { 0, &Ia_Invalid    },
  /* 0F 27 */ { 0, &Ia_Invalid    },
  /* 0F 28 */ { GRPSSE(0f28) },
  /* 0F 29 */ { GRPSSE(0f29) },
  /* 0F 2A */ { GRPSSE(0f2a) },
  /* 0F 2B */ { GRPSSE(0f2b) },
  /* 0F 2C */ { GRPSSE(0f2c) },
  /* 0F 2D */ { GRPSSE(0f2d) },
  /* 0F 2E */ { GRPSSE(0f2e) },
  /* 0F 2F */ { GRPSSE(0f2f) },
  /* 0F 30 */ { 0, &Ia_wrmsr },
  /* 0F 31 */ { 0, &Ia_rdtsc },
  /* 0F 32 */ { 0, &Ia_rdmsr },
  /* 0F 33 */ { 0, &Ia_rdpmc },
  /* 0F 34 */ { 0, &Ia_sysenter },
  /* 0F 35 */ { 0, &Ia_sysexit },
  /* 0F 36 */ { 0, &Ia_Invalid },
  /* 0F 37 */ { 0, &Ia_getsec },
  /* 0F 38 */ { GR3BTAB(0f38) },
  /* 0F 39 */ { 0, &Ia_Invalid  },
  /* 0F 3A */ { GR3BTAB(0f3a) },
  /* 0F 3B */ { 0, &Ia_Invalid },
  /* 0F 3C */ { 0, &Ia_Invalid },
  /* 0F 3D */ { 0, &Ia_Invalid },
  /* 0F 3E */ { 0, &Ia_Invalid },
  /* 0F 3F */ { 0, &Ia_Invalid },
  /* 0F 40 */ { 0, &Ia_cmovow_Gw_Ew  },
  /* 0F 41 */ { 0, &Ia_cmovnow_Gw_Ew },
  /* 0F 42 */ { 0, &Ia_cmovcw_Gw_Ew  },
  /* 0F 43 */ { 0, &Ia_cmovncw_Gw_Ew },
  /* 0F 44 */ { 0, &Ia_cmovzw_Gw_Ew  },
  /* 0F 45 */ { 0, &Ia_cmovnzw_Gw_Ew },
  /* 0F 46 */ { 0, &Ia_cmovnaw_Gw_Ew },
  /* 0F 47 */ { 0, &Ia_cmovaw_Gw_Ew  },
  /* 0F 48 */ { 0, &Ia_cmovsw_Gw_Ew  },
  /* 0F 49 */ { 0, &Ia_cmovnsw_Gw_Ew },
  /* 0F 4A */ { 0, &Ia_cmovpw_Gw_Ew  },
  /* 0F 4B */ { 0, &Ia_cmovnpw_Gw_Ew },
  /* 0F 4C */ { 0, &Ia_cmovlw_Gw_Ew  },
  /* 0F 4D */ { 0, &Ia_cmovnlw_Gw_Ew },
  /* 0F 4E */ { 0, &Ia_cmovngw_Gw_Ew },
  /* 0F 4F */ { 0, &Ia_cmovgw_Gw_Ew  },
  /* 0F 50 */ { GRPSSE(0f50) },
  /* 0F 51 */ { GRPSSE(0f51) },
  /* 0F 52 */ { GRPSSE(0f52) },
  /* 0F 53 */ { GRPSSE(0f53) },
  /* 0F 54 */ { GRPSSE(0f54) },
  /* 0F 55 */ { GRPSSE(0f55) },
  /* 0F 56 */ { GRPSSE(0f56) },
  /* 0F 57 */ { GRPSSE(0f57) },
  /* 0F 58 */ { GRPSSE(0f58) },
  /* 0F 59 */ { GRPSSE(0f59) },
  /* 0F 5A */ { GRPSSE(0f5a) },
  /* 0F 5B */ { GRPSSE(0f5b) },
  /* 0F 5C */ { GRPSSE(0f5c) },
  /* 0F 5D */ { GRPSSE(0f5d) },
  /* 0F 5E */ { GRPSSE(0f5e) },
  /* 0F 5F */ { GRPSSE(0f5f) },
  /* 0F 60 */ { GRPSSE(0f60) },
  /* 0F 61 */ { GRPSSE(0f61) },
  /* 0F 62 */ { GRPSSE(0f62) },
  /* 0F 63 */ { GRPSSE(0f63) },
  /* 0F 64 */ { GRPSSE(0f64) },
  /* 0F 65 */ { GRPSSE(0f65) },
  /* 0F 66 */ { GRPSSE(0f66) },
  /* 0F 67 */ { GRPSSE(0f67) },
  /* 0F 68 */ { GRPSSE(0f68) },
  /* 0F 69 */ { GRPSSE(0f69) },
  /* 0F 6A */ { GRPSSE(0f6a) },
  /* 0F 6B */ { GRPSSE(0f6b) },
  /* 0F 6C */ { GRPSSE66(Ia_punpcklqdq_Vdq_Wdq) },
  /* 0F 6D */ { GRPSSE66(Ia_punpckhqdq_Vdq_Wdq) },
  /* 0F 6E */ { GRPSSE(0f6e) },
  /* 0F 6F */ { GRPSSE(0f6f) },
  /* 0F 70 */ { GRPSSE(0f70) },
  /* 0F 71 */ { GRPN(G12)    },
  /* 0F 72 */ { GRPN(G13)    },
  /* 0F 73 */ { GRPN(G14)    },
  /* 0F 74 */ { GRPSSE(0f74) },
  /* 0F 75 */ { GRPSSE(0f75) },
  /* 0F 76 */ { GRPSSE(0f76) },
  /* 0F 77 */ { 0, &Ia_emms  },
  /* 0F 78 */ { GRPSSE(0f78Q) }, // VMX
  /* 0F 79 */ { GRPSSE(0f79Q) }, // VMX
  /* 0F 7A */ { 0, &Ia_Invalid },
  /* 0F 7B */ { 0, &Ia_Invalid },
  /* 0F 7C */ { GRPSSE(0f7c) },
  /* 0F 7D */ { GRPSSE(0f7d) },
  /* 0F 7E */ { GRPSSE(0f7e) },
  /* 0F 7F */ { GRPSSE(0f7f) },
  /* 0F 80 */ { 0, &Ia_jo_Jd     },
  /* 0F 81 */ { 0, &Ia_jno_Jd    },
  /* 0F 82 */ { 0, &Ia_jb_Jd     },
  /* 0F 83 */ { 0, &Ia_jnb_Jd    },
  /* 0F 84 */ { 0, &Ia_jz_Jd     },
  /* 0F 85 */ { 0, &Ia_jnz_Jd    },
  /* 0F 86 */ { 0, &Ia_jbe_Jd    },
  /* 0F 87 */ { 0, &Ia_jnbe_Jd   },
  /* 0F 88 */ { 0, &Ia_js_Jd     },
  /* 0F 89 */ { 0, &Ia_jns_Jd    },
  /* 0F 8A */ { 0, &Ia_jp_Jd     },
  /* 0F 8B */ { 0, &Ia_jnp_Jd    },
  /* 0F 8C */ { 0, &Ia_jl_Jd     },
  /* 0F 8D */ { 0, &Ia_jnl_Jd    },
  /* 0F 8E */ { 0, &Ia_jle_Jd    },
  /* 0F 8F */ { 0, &Ia_jnle_Jd   },
  /* 0F 90 */ { 0, &Ia_seto_Eb   },
  /* 0F 91 */ { 0, &Ia_setno_Eb  },
  /* 0F 92 */ { 0, &Ia_setb_Eb   },
  /* 0F 93 */ { 0, &Ia_setnb_Eb  },
  /* 0F 94 */ { 0, &Ia_setz_Eb   },
  /* 0F 95 */ { 0, &Ia_setnz_Eb  },
  /* 0F 96 */ { 0, &Ia_setbe_Eb  },
  /* 0F 97 */ { 0, &Ia_setnbe_Eb },
  /* 0F 98 */ { 0, &Ia_sets_Eb   },
  /* 0F 99 */ { 0, &Ia_setns_Eb  },
  /* 0F 9A */ { 0, &Ia_setp_Eb   },
  /* 0F 9B */ { 0, &Ia_setnp_Eb  },
  /* 0F 9C */ { 0, &Ia_setl_Eb   },
  /* 0F 9D */ { 0, &Ia_setnl_Eb  },
  /* 0F 9E */ { 0, &Ia_setle_Eb  },
  /* 0F 9F */ { 0, &Ia_setnle_Eb },
  /* 0F A0 */ { 0, &Ia_pushw_FS  },
  /* 0F A1 */ { 0, &Ia_popw_FS   },
  /* 0F A2 */ { 0, &Ia_cpuid     },
  /* 0F A3 */ { 0, &Ia_btw_Ew_Gw },
  /* 0F A4 */ { 0, &Ia_shldw_Ew_Gw_Ib },
  /* 0F A5 */ { 0, &Ia_shldw_Ew_Gw_CL },
  /* 0F A6 */ { 0, &Ia_Invalid        },
  /* 0F A7 */ { 0, &Ia_Invalid        },
  /* 0F A8 */ { 0, &Ia_pushw_GS       },
  /* 0F A9 */ { 0, &Ia_popw_GS        },
  /* 0F AA */ { 0, &Ia_rsm            },
  /* 0F AB */ { 0, &Ia_btsw_Ew_Gw     },
  /* 0F AC */ { 0, &Ia_shrdw_Ew_Gw_Ib },
  /* 0F AD */ { 0, &Ia_shrdw_Ew_Gw_CL },
  /* 0F AE */ { GRPMOD(G15)           },
  /* 0F AF */ { 0, &Ia_imulw_Gw_Ew    },
  /* 0F B0 */ { 0, &Ia_cmpxchgb_Eb_Gb },
  /* 0F B1 */ { 0, &Ia_cmpxchgw_Ew_Gw },
  /* 0F B2 */ { 0, &Ia_lssw_Gw_Mp   },
  /* 0F B3 */ { 0, &Ia_btrw_Ew_Gw   },
  /* 0F B4 */ { 0, &Ia_lfsw_Gw_Mp   },
  /* 0F B5 */ { 0, &Ia_lgsw_Gw_Mp   },
  /* 0F B6 */ { 0, &Ia_movzbw_Gw_Eb },
  /* 0F B7 */ { 0, &Ia_movw_Gw_Ew   },
  /* 0F B8 */ { GRPSSEF3(Ia_popcnt_Gw_Ew) },
  /* 0F B9 */ { 0, &Ia_ud2b         },
  /* 0F BA */ { GRPN(G8EwIb)        },
  /* 0F BB */ { 0, &Ia_btcw_Ew_Gw   },
  /* 0F BC */ { GRPSSE(0fbcw) },
  /* 0F BD */ { GRPSSE(0fbdw) },
  /* 0F BE */ { 0, &Ia_movsbw_Gw_Eb },
  /* 0F BF */ { 0, &Ia_movw_Gw_Ew   },
  /* 0F C0 */ { 0, &Ia_xaddb_Eb_Gb  },
  /* 0F C0 */ { 0, &Ia_xaddw_Ew_Gw  },
  /* 0F C2 */ { GRPSSE(0fc2) },
  /* 0F C3 */ { GRPSSE(0fc3) },
  /* 0F C4 */ { GRPSSE(0fc4) },
  /* 0F C5 */ { GRPSSE(0fc5) },
  /* 0F C6 */ { GRPSSE(0fc6) },
  /* 0F C7 */ { GRPN(G9)     },
  /* 0F C8 */ { 0, &Ia_bswapl_ERX },
  /* 0F C9 */ { 0, &Ia_bswapl_ERX },
  /* 0F CA */ { 0, &Ia_bswapl_ERX },
  /* 0F CB */ { 0, &Ia_bswapl_ERX },
  /* 0F CC */ { 0, &Ia_bswapl_ERX },
  /* 0F CD */ { 0, &Ia_bswapl_ERX },
  /* 0F CE */ { 0, &Ia_bswapl_ERX },
  /* 0F CF */ { 0, &Ia_bswapl_ERX },
  /* 0F D0 */ { GRPSSE(0fd0) },
  /* 0F D1 */ { GRPSSE(0fd1) },
  /* 0F D2 */ { GRPSSE(0fd2) },
  /* 0F D3 */ { GRPSSE(0fd3) },
  /* 0F D4 */ { GRPSSE(0fd4) },
  /* 0F D5 */ { GRPSSE(0fd5) },
  /* 0F D6 */ { GRPSSE(0fd6) },
  /* 0F D7 */ { GRPSSE(0fd7) },
  /* 0F D8 */ { GRPSSE(0fd8) },
  /* 0F D9 */ { GRPSSE(0fd9) },
  /* 0F DA */ { GRPSSE(0fda) },
  /* 0F DB */ { GRPSSE(0fdb) },
  /* 0F DC */ { GRPSSE(0fdc) },
  /* 0F DD */ { GRPSSE(0fdd) },
  /* 0F DE */ { GRPSSE(0fde) },
  /* 0F DF */ { GRPSSE(0fdf) },
  /* 0F E0 */ { GRPSSE(0fe0) },
  /* 0F E1 */ { GRPSSE(0fe1) },
  /* 0F E2 */ { GRPSSE(0fe2) },
  /* 0F E3 */ { GRPSSE(0fe3) },
  /* 0F E4 */ { GRPSSE(0fe4) },
  /* 0F E5 */ { GRPSSE(0fe5) },
  /* 0F E6 */ { GRPSSE(0fe6) },
  /* 0F E7 */ { GRPSSE(0fe7) },
  /* 0F E8 */ { GRPSSE(0fe8) },
  /* 0F E9 */ { GRPSSE(0fe9) },
  /* 0F EA */ { GRPSSE(0fea) },
  /* 0F EB */ { GRPSSE(0feb) },
  /* 0F EC */ { GRPSSE(0fec) },
  /* 0F ED */ { GRPSSE(0fed) },
  /* 0F EE */ { GRPSSE(0fee) },
  /* 0F EF */ { GRPSSE(0fef) },
  /* 0F F0 */ { GRPSSEF2(Ia_lddqu_Vdq_Mdq) },
  /* 0F F1 */ { GRPSSE(0ff1) },
  /* 0F F2 */ { GRPSSE(0ff2) },
  /* 0F F3 */ { GRPSSE(0ff3) },
  /* 0F F4 */ { GRPSSE(0ff4) },
  /* 0F F5 */ { GRPSSE(0ff5) },
  /* 0F F6 */ { GRPSSE(0ff6) },
  /* 0F F7 */ { GRPSSE(0ff7) },
  /* 0F F8 */ { GRPSSE(0ff8) },
  /* 0F F9 */ { GRPSSE(0ff9) },
  /* 0F FA */ { GRPSSE(0ffa) },
  /* 0F FB */ { GRPSSE(0ffb) },
  /* 0F FC */ { GRPSSE(0ffc) },
  /* 0F FD */ { GRPSSE(0ffd) },
  /* 0F FE */ { GRPSSE(0ffe) },
  /* 0F FF */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmOpcodes64d[256*2] = {
  // 256 entries for single byte opcodes
  /* 00 */ { 0, &Ia_addb_Eb_Gb    },
  /* 01 */ { 0, &Ia_addl_Ed_Gd    },
  /* 02 */ { 0, &Ia_addb_Gb_Eb    },
  /* 03 */ { 0, &Ia_addl_Gd_Ed    },
  /* 04 */ { 0, &Ia_addb_AL_Ib,   },
  /* 05 */ { 0, &Ia_addl_EAX_Id,  },
  /* 06 */ { 0, &Ia_Invalid       },
  /* 07 */ { 0, &Ia_Invalid       },
  /* 08 */ { 0, &Ia_orb_Eb_Gb     },
  /* 09 */ { 0, &Ia_orl_Ed_Gd     },
  /* 0A */ { 0, &Ia_orb_Gb_Eb     },
  /* 0B */ { 0, &Ia_orl_Gd_Ed     },
  /* 0C */ { 0, &Ia_orb_AL_Ib     },
  /* 0D */ { 0, &Ia_orl_EAX_Id    },
  /* 0E */ { 0, &Ia_Invalid       },
  /* 0F */ { 0, &Ia_error         },   // 2 byte escape
  /* 10 */ { 0, &Ia_adcb_Eb_Gb    },
  /* 11 */ { 0, &Ia_adcl_Ed_Gd    },
  /* 12 */ { 0, &Ia_adcb_Gb_Eb    },
  /* 13 */ { 0, &Ia_adcl_Gd_Ed    },
  /* 14 */ { 0, &Ia_adcb_AL_Ib    },
  /* 15 */ { 0, &Ia_adcl_EAX_Id   },
  /* 16 */ { 0, &Ia_Invalid       },
  /* 17 */ { 0, &Ia_Invalid       },
  /* 18 */ { 0, &Ia_sbbb_Eb_Gb    },
  /* 19 */ { 0, &Ia_sbbl_Ed_Gd    },
  /* 1A */ { 0, &Ia_sbbb_Gb_Eb    },
  /* 1B */ { 0, &Ia_sbbl_Gd_Ed    },
  /* 1C */ { 0, &Ia_sbbb_AL_Ib    },
  /* 1D */ { 0, &Ia_sbbl_EAX_Id   },
  /* 1E */ { 0, &Ia_Invalid       },
  /* 1F */ { 0, &Ia_Invalid       },
  /* 20 */ { 0, &Ia_andb_Eb_Gb    },
  /* 21 */ { 0, &Ia_andl_Ed_Gd    },
  /* 22 */ { 0, &Ia_andb_Gb_Eb    },
  /* 23 */ { 0, &Ia_andl_Gd_Ed    },
  /* 24 */ { 0, &Ia_andb_AL_Ib    },
  /* 25 */ { 0, &Ia_andl_EAX_Id   },
  /* 26 */ { 0, &Ia_prefix_es     },   // ES:
  /* 27 */ { 0, &Ia_Invalid       },
  /* 28 */ { 0, &Ia_subb_Eb_Gb    },
  /* 29 */ { 0, &Ia_subl_Ed_Gd    },
  /* 2A */ { 0, &Ia_subb_Gb_Eb    },
  /* 2B */ { 0, &Ia_subl_Gd_Ed    },
  /* 2C */ { 0, &Ia_subb_AL_Ib    },
  /* 2D */ { 0, &Ia_subl_EAX_Id   },
  /* 2E */ { 0, &Ia_prefix_cs     },   // CS:
  /* 2F */ { 0, &Ia_Invalid       },
  /* 30 */ { 0, &Ia_xorb_Eb_Gb    },
  /* 31 */ { 0, &Ia_xorl_Ed_Gd    },
  /* 32 */ { 0, &Ia_xorb_Gb_Eb    },
  /* 33 */ { 0, &Ia_xorl_Gd_Ed    },
  /* 34 */ { 0, &Ia_xorb_AL_Ib    },
  /* 35 */ { 0, &Ia_xorl_EAX_Id   },
  /* 36 */ { 0, &Ia_prefix_ss     },   // SS:
  /* 37 */ { 0, &Ia_Invalid       },
  /* 38 */ { 0, &Ia_cmpb_Eb_Gb    },
  /* 39 */ { 0, &Ia_cmpl_Ed_Gd    },
  /* 3A */ { 0, &Ia_cmpb_Gb_Eb    },
  /* 3B */ { 0, &Ia_cmpl_Gd_Ed    },
  /* 3C */ { 0, &Ia_cmpb_AL_Ib    },
  /* 3D */ { 0, &Ia_cmpl_EAX_Id   },
  /* 3E */ { 0, &Ia_prefix_ds     },   // DS:
  /* 3F */ { 0, &Ia_Invalid       },
  /* 40 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 41 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 42 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 43 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 44 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 45 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 46 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 47 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 48 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 49 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4A */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4B */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4C */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4D */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4E */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4F */ { 0, &Ia_prefix_rex    },   // REX:
  /* 50 */ { 0, &Ia_pushq_RRX     },
  /* 51 */ { 0, &Ia_pushq_RRX     },
  /* 52 */ { 0, &Ia_pushq_RRX     },
  /* 53 */ { 0, &Ia_pushq_RRX     },
  /* 54 */ { 0, &Ia_pushq_RRX     },
  /* 55 */ { 0, &Ia_pushq_RRX     },
  /* 56 */ { 0, &Ia_pushq_RRX     },
  /* 57 */ { 0, &Ia_pushq_RRX     },
  /* 58 */ { 0, &Ia_popq_RRX      },
  /* 59 */ { 0, &Ia_popq_RRX      },
  /* 5A */ { 0, &Ia_popq_RRX      },
  /* 5B */ { 0, &Ia_popq_RRX      },
  /* 5C */ { 0, &Ia_popq_RRX      },
  /* 5D */ { 0, &Ia_popq_RRX      },
  /* 5E */ { 0, &Ia_popq_RRX      },
  /* 5F */ { 0, &Ia_popq_RRX      },
  /* 60 */ { 0, &Ia_Invalid       },
  /* 61 */ { 0, &Ia_Invalid       },
  /* 62 */ { 0, &Ia_Invalid       },
  /* 63 */ { 0, &Ia_movl_Gd_Ed    },
  /* 64 */ { 0, &Ia_prefix_fs     },   // FS:
  /* 65 */ { 0, &Ia_prefix_gs     },   // GS:
  /* 66 */ { 0, &Ia_prefix_osize  },   // OSIZE:
  /* 67 */ { 0, &Ia_prefix_asize  },   // ASIZE:
  /* 68 */ { 0, &Ia_pushq_sId     },
  /* 69 */ { 0, &Ia_imull_Gd_Ed_Id  },
  /* 6A */ { 0, &Ia_pushq_sIb     },
  /* 6B */ { 0, &Ia_imull_Gd_Ed_sIb },
  /* 6C */ { 0, &Ia_insb_Yb_DX    },
  /* 6D */ { 0, &Ia_insl_Yd_DX    },
  /* 6E */ { 0, &Ia_outsb_DX_Xb   },
  /* 6F */ { 0, &Ia_outsl_DX_Xd   },
  /* 70 */ { 0, &Ia_jo_Jb         },
  /* 71 */ { 0, &Ia_jno_Jb        },
  /* 72 */ { 0, &Ia_jb_Jb         },
  /* 73 */ { 0, &Ia_jnb_Jb        },
  /* 74 */ { 0, &Ia_jz_Jb         },
  /* 75 */ { 0, &Ia_jnz_Jb        },
  /* 76 */ { 0, &Ia_jbe_Jb        },
  /* 77 */ { 0, &Ia_jnbe_Jb       },
  /* 78 */ { 0, &Ia_js_Jb         },
  /* 79 */ { 0, &Ia_jns_Jb        },
  /* 7A */ { 0, &Ia_jp_Jb         },
  /* 7B */ { 0, &Ia_jnp_Jb        },
  /* 7C */ { 0, &Ia_jl_Jb         },
  /* 7D */ { 0, &Ia_jnl_Jb        },
  /* 7E */ { 0, &Ia_jle_Jb        },
  /* 7F */ { 0, &Ia_jnle_Jb       },
  /* 80 */ { GRPN(G1EbIb)         },
  /* 81 */ { GRPN(G1EdId)         },
  /* 82 */ { 0, &Ia_Invalid       },
  /* 83 */ { GRPN(G1EdIb)         },
  /* 84 */ { 0, &Ia_testb_Eb_Gb   },
  /* 85 */ { 0, &Ia_testl_Ed_Gd   },
  /* 86 */ { 0, &Ia_xchgb_Eb_Gb   },
  /* 87 */ { 0, &Ia_xchgl_Ed_Gd   },
  /* 88 */ { 0, &Ia_movb_Eb_Gb    },
  /* 89 */ { 0, &Ia_movl_Ed_Gd    },
  /* 8A */ { 0, &Ia_movb_Gb_Eb    },
  /* 8B */ { 0, &Ia_movl_Gd_Ed    },
  /* 8C */ { 0, &Ia_movw_Ew_Sw    },
  /* 8D */ { 0, &Ia_leal_Gd_Md    },
  /* 8E */ { 0, &Ia_movw_Sw_Ew    },
  /* 8F */ { 0, &Ia_popq_Eq       },
  /* 90 */ { 0, &Ia_xchgl_ERX_EAX }, // handle XCHG R8d, EAX
  /* 91 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 92 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 93 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 94 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 95 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 96 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 97 */ { 0, &Ia_xchgl_ERX_EAX },
  /* 98 */ { 0, &Ia_cwde          },
  /* 99 */ { 0, &Ia_cdq           },
  /* 9A */ { 0, &Ia_Invalid       },
  /* 9B */ { 0, &Ia_fwait         },
  /* 9C */ { 0, &Ia_pushfq        },
  /* 9D */ { 0, &Ia_popfq         },
  /* 9E */ { 0, &Ia_sahf          },
  /* 9F */ { 0, &Ia_lahf          },
  /* A0 */ { 0, &Ia_movb_AL_Ob    },
  /* A1 */ { 0, &Ia_movl_EAX_Od   },
  /* A0 */ { 0, &Ia_movb_Ob_AL    },
  /* A1 */ { 0, &Ia_movl_Od_EAX   },
  /* A4 */ { 0, &Ia_movsb_Yb_Xb   },
  /* A5 */ { 0, &Ia_movsl_Yd_Xd   },
  /* A6 */ { 0, &Ia_cmpsb_Yb_Xb   },
  /* A7 */ { 0, &Ia_cmpsl_Yd_Xd   },
  /* A8 */ { 0, &Ia_testb_AL_Ib   },
  /* A9 */ { 0, &Ia_testl_EAX_Id  },
  /* AA */ { 0, &Ia_stosb_Yb_AL   },
  /* AB */ { 0, &Ia_stosl_Yd_EAX  },
  /* AC */ { 0, &Ia_lodsb_AL_Xb   },
  /* AD */ { 0, &Ia_lodsl_EAX_Xd  },
  /* AE */ { 0, &Ia_scasb_Yb_AL   },
  /* AF */ { 0, &Ia_scasl_Yd_EAX  },
  /* B0 */ { 0, &Ia_movb_R8_Ib    },
  /* B1 */ { 0, &Ia_movb_R8_Ib    },
  /* B2 */ { 0, &Ia_movb_R8_Ib    },
  /* B3 */ { 0, &Ia_movb_R8_Ib    },
  /* B4 */ { 0, &Ia_movb_R8_Ib    },
  /* B5 */ { 0, &Ia_movb_R8_Ib    },
  /* B6 */ { 0, &Ia_movb_R8_Ib    },
  /* B7 */ { 0, &Ia_movb_R8_Ib    },
  /* B8 */ { 0, &Ia_movl_ERX_Id   },
  /* B9 */ { 0, &Ia_movl_ERX_Id   },
  /* BA */ { 0, &Ia_movl_ERX_Id   },
  /* BB */ { 0, &Ia_movl_ERX_Id   },
  /* BC */ { 0, &Ia_movl_ERX_Id   },
  /* BD */ { 0, &Ia_movl_ERX_Id   },
  /* BE */ { 0, &Ia_movl_ERX_Id   },
  /* BF */ { 0, &Ia_movl_ERX_Id   },
  /* C0 */ { GRPN(G2Eb)           },
  /* C1 */ { GRPN(G2Ed)           },
  /* C2 */ { 0, &Ia_ret_Iw        },
  /* C3 */ { 0, &Ia_ret           },
  /* C4 */ { 0, &Ia_Invalid       },
  /* C5 */ { 0, &Ia_Invalid       },
  /* C6 */ { GRPN(G11Eb)          },
  /* C7 */ { GRPN(G11Ed)          },
  /* C8 */ { 0, &Ia_enter         },
  /* C9 */ { 0, &Ia_leave         },
  /* CA */ { 0, &Ia_lret_Iw       },
  /* CB */ { 0, &Ia_lret          },
  /* CC */ { 0, &Ia_int3          },
  /* CD */ { 0, &Ia_int_Ib        },
  /* CE */ { 0, &Ia_Invalid       },
  /* CF */ { 0, &Ia_iretl         },
  /* D0 */ { GRPN(G2EbI1)         },
  /* D1 */ { GRPN(G2EdI1)         },
  /* D2 */ { GRPN(G2EbCL)         },
  /* D3 */ { GRPN(G2EdCL)         },
  /* D4 */ { 0, &Ia_Invalid       },
  /* D5 */ { 0, &Ia_Invalid       },
  /* D6 */ { 0, &Ia_Invalid       },
  /* D7 */ { 0, &Ia_xlat          },
  /* D8 */ { GRPFP(D8)            },
  /* D9 */ { GRPFP(D9)            },
  /* DA */ { GRPFP(DA)            },
  /* DB */ { GRPFP(DB)            },
  /* DC */ { GRPFP(DC)            },
  /* DD */ { GRPFP(DD)            },
  /* DE */ { GRPFP(DE)            },
  /* DF */ { GRPFP(DF)            },
  /* E0 */ { 0, &Ia_loopne_Jb     },
  /* E1 */ { 0, &Ia_loope_Jb      },
  /* E2 */ { 0, &Ia_loop_Jb       },
  /* E3 */ { 0, &Ia_jrcxz_Jb      },
  /* E4 */ { 0, &Ia_inb_AL_Ib     },
  /* E5 */ { 0, &Ia_inl_EAX_Ib    },
  /* E6 */ { 0, &Ia_outb_Ib_AL    },
  /* E7 */ { 0, &Ia_outl_Ib_EAX   },
  /* E8 */ { 0, &Ia_call_Jd       },
  /* E9 */ { 0, &Ia_jmp_Jd        },
  /* EA */ { 0, &Ia_Invalid       },
  /* EB */ { 0, &Ia_jmp_Jb        },
  /* EC */ { 0, &Ia_inb_AL_DX     },
  /* ED */ { 0, &Ia_inl_EAX_DX    },
  /* EE */ { 0, &Ia_outb_DX_AL    },
  /* EF */ { 0, &Ia_outl_DX_EAX   },
  /* F0 */ { 0, &Ia_prefix_lock   },   // LOCK:
  /* F1 */ { 0, &Ia_int1          },
  /* F2 */ { 0, &Ia_prefix_repne  },   // REPNE:
  /* F3 */ { 0, &Ia_prefix_rep    },   // REP:
  /* F4 */ { 0, &Ia_hlt           },
  /* F5 */ { 0, &Ia_cmc           },
  /* F6 */ { GRPN(G3Eb)           },
  /* F7 */ { GRPN(G3Ed)           },
  /* F8 */ { 0, &Ia_clc           },
  /* F9 */ { 0, &Ia_stc           },
  /* FA */ { 0, &Ia_cli           },
  /* FB */ { 0, &Ia_sti           },
  /* FC */ { 0, &Ia_cld           },
  /* FD */ { 0, &Ia_std           },
  /* FE */ { GRPN(G4)             },
  /* FF */ { GRPN(64G5d)          },

  // 256 entries for two byte opcodes
  /* 0F 00 */ { GRPN(G6)          },
  /* 0F 01 */ { GRPMOD(G7)        },
  /* 0F 02 */ { 0, &Ia_larl_Gd_Ew },
  /* 0F 03 */ { 0, &Ia_lsll_Gd_Ew },
  /* 0F 04 */ { 0, &Ia_Invalid    },
  /* 0F 05 */ { 0, &Ia_syscall    },
  /* 0F 06 */ { 0, &Ia_clts       },
  /* 0F 07 */ { 0, &Ia_sysret     },
  /* 0F 08 */ { 0, &Ia_invd       },
  /* 0F 09 */ { 0, &Ia_wbinvd     },
  /* 0F 0A */ { 0, &Ia_Invalid    },
  /* 0F 0B */ { 0, &Ia_ud2a       },
  /* 0F 0C */ { 0, &Ia_Invalid    },
  /* 0F 0D */ { 0, &Ia_prefetchw  },   // 3DNow!
  /* 0F 0E */ { 0, &Ia_femms      },   // 3DNow!
  /* 0F 0F */ { GRP3DNOW          },
  /* 0F 10 */ { GRPSSE(0f10)      },
  /* 0F 11 */ { GRPSSE(0f11)      },
  /* 0F 12 */ { GRPSSE(0f12)      },
  /* 0F 13 */ { GRPSSE(0f13)      },
  /* 0F 14 */ { GRPSSE(0f14)      },
  /* 0F 15 */ { GRPSSE(0f15)      },
  /* 0F 16 */ { GRPSSE(0f16)      },
  /* 0F 17 */ { GRPSSE(0f17)      },
  /* 0F 18 */ { GRPN(G16)         },
  /* 0F 19 */ { 0, &Ia_multibyte_nop },
  /* 0F 1A */ { 0, &Ia_multibyte_nop },
  /* 0F 1B */ { 0, &Ia_multibyte_nop },
  /* 0F 1C */ { 0, &Ia_multibyte_nop },
  /* 0F 1D */ { 0, &Ia_multibyte_nop },
  /* 0F 1E */ { 0, &Ia_multibyte_nop },
  /* 0F 1F */ { 0, &Ia_multibyte_nop },
  /* 0F 20 */ { 0, &Ia_movq_Rq_Cq },
  /* 0F 21 */ { 0, &Ia_movq_Rq_Dq },
  /* 0F 22 */ { 0, &Ia_movq_Cq_Rq },
  /* 0F 23 */ { 0, &Ia_movq_Dq_Rq },
  /* 0F 24 */ { 0, &Ia_Invalid    },
  /* 0F 25 */ { 0, &Ia_Invalid    },
  /* 0F 26 */ { 0, &Ia_Invalid    },
  /* 0F 27 */ { 0, &Ia_Invalid    },
  /* 0F 28 */ { GRPSSE(0f28) },
  /* 0F 29 */ { GRPSSE(0f29) },
  /* 0F 2A */ { GRPSSE(0f2a) },
  /* 0F 2B */ { GRPSSE(0f2b) },
  /* 0F 2C */ { GRPSSE(0f2c) },
  /* 0F 2D */ { GRPSSE(0f2d) },
  /* 0F 2E */ { GRPSSE(0f2e) },
  /* 0F 2F */ { GRPSSE(0f2f) },
  /* 0F 30 */ { 0, &Ia_wrmsr },
  /* 0F 31 */ { 0, &Ia_rdtsc },
  /* 0F 32 */ { 0, &Ia_rdmsr },
  /* 0F 33 */ { 0, &Ia_rdpmc },
  /* 0F 34 */ { 0, &Ia_sysenter },
  /* 0F 35 */ { 0, &Ia_sysexit },
  /* 0F 36 */ { 0, &Ia_Invalid },
  /* 0F 37 */ { 0, &Ia_getsec },
  /* 0F 38 */ { GR3BTAB(0f38) },
  /* 0F 39 */ { 0, &Ia_Invalid  },
  /* 0F 3A */ { GR3BTAB(0f3a) },
  /* 0F 3B */ { 0, &Ia_Invalid },
  /* 0F 3C */ { 0, &Ia_Invalid },
  /* 0F 3D */ { 0, &Ia_Invalid },
  /* 0F 3E */ { 0, &Ia_Invalid },
  /* 0F 3F */ { 0, &Ia_Invalid },
  /* 0F 40 */ { 0, &Ia_cmovol_Gd_Ed  },
  /* 0F 41 */ { 0, &Ia_cmovnol_Gd_Ed },
  /* 0F 42 */ { 0, &Ia_cmovcl_Gd_Ed  },
  /* 0F 43 */ { 0, &Ia_cmovncl_Gd_Ed },
  /* 0F 44 */ { 0, &Ia_cmovzl_Gd_Ed  },
  /* 0F 45 */ { 0, &Ia_cmovnzl_Gd_Ed },
  /* 0F 46 */ { 0, &Ia_cmovnal_Gd_Ed },
  /* 0F 47 */ { 0, &Ia_cmoval_Gd_Ed  },
  /* 0F 48 */ { 0, &Ia_cmovsl_Gd_Ed  },
  /* 0F 49 */ { 0, &Ia_cmovnsl_Gd_Ed },
  /* 0F 4A */ { 0, &Ia_cmovpl_Gd_Ed  },
  /* 0F 4B */ { 0, &Ia_cmovnpl_Gd_Ed },
  /* 0F 4C */ { 0, &Ia_cmovll_Gd_Ed  },
  /* 0F 4D */ { 0, &Ia_cmovnll_Gd_Ed },
  /* 0F 4E */ { 0, &Ia_cmovngl_Gd_Ed },
  /* 0F 4F */ { 0, &Ia_cmovgl_Gd_Ed  },
  /* 0F 50 */ { GRPSSE(0f50) },
  /* 0F 51 */ { GRPSSE(0f51) },
  /* 0F 52 */ { GRPSSE(0f52) },
  /* 0F 53 */ { GRPSSE(0f53) },
  /* 0F 54 */ { GRPSSE(0f54) },
  /* 0F 55 */ { GRPSSE(0f55) },
  /* 0F 56 */ { GRPSSE(0f56) },
  /* 0F 57 */ { GRPSSE(0f57) },
  /* 0F 58 */ { GRPSSE(0f58) },
  /* 0F 59 */ { GRPSSE(0f59) },
  /* 0F 5A */ { GRPSSE(0f5a) },
  /* 0F 5B */ { GRPSSE(0f5b) },
  /* 0F 5C */ { GRPSSE(0f5c) },
  /* 0F 5D */ { GRPSSE(0f5d) },
  /* 0F 5E */ { GRPSSE(0f5e) },
  /* 0F 5F */ { GRPSSE(0f5f) },
  /* 0F 60 */ { GRPSSE(0f60) },
  /* 0F 61 */ { GRPSSE(0f61) },
  /* 0F 62 */ { GRPSSE(0f62) },
  /* 0F 63 */ { GRPSSE(0f63) },
  /* 0F 64 */ { GRPSSE(0f64) },
  /* 0F 65 */ { GRPSSE(0f65) },
  /* 0F 66 */ { GRPSSE(0f66) },
  /* 0F 67 */ { GRPSSE(0f67) },
  /* 0F 68 */ { GRPSSE(0f68) },
  /* 0F 69 */ { GRPSSE(0f69) },
  /* 0F 6A */ { GRPSSE(0f6a) },
  /* 0F 6B */ { GRPSSE(0f6b) },
  /* 0F 6C */ { GRPSSE66(Ia_punpcklqdq_Vdq_Wdq) },
  /* 0F 6D */ { GRPSSE66(Ia_punpckhqdq_Vdq_Wdq) },
  /* 0F 6E */ { GRPSSE(0f6e) },
  /* 0F 6F */ { GRPSSE(0f6f) },
  /* 0F 70 */ { GRPSSE(0f70) },
  /* 0F 71 */ { GRPN(G12)    },
  /* 0F 72 */ { GRPN(G13)    },
  /* 0F 73 */ { GRPN(G14)    },
  /* 0F 74 */ { GRPSSE(0f74) },
  /* 0F 75 */ { GRPSSE(0f75) },
  /* 0F 76 */ { GRPSSE(0f76) },
  /* 0F 77 */ { 0, &Ia_emms  },
  /* 0F 78 */ { GRPSSE(0f78Q) }, // VMX
  /* 0F 79 */ { GRPSSE(0f79Q) }, // VMX
  /* 0F 7A */ { 0, &Ia_Invalid },
  /* 0F 7B */ { 0, &Ia_Invalid },
  /* 0F 7C */ { GRPSSE(0f7c) },
  /* 0F 7D */ { GRPSSE(0f7d) },
  /* 0F 7E */ { GRPSSE(0f7e) },
  /* 0F 7F */ { GRPSSE(0f7f) },
  /* 0F 80 */ { 0, &Ia_jo_Jd     },
  /* 0F 81 */ { 0, &Ia_jno_Jd    },
  /* 0F 82 */ { 0, &Ia_jb_Jd     },
  /* 0F 83 */ { 0, &Ia_jnb_Jd    },
  /* 0F 84 */ { 0, &Ia_jz_Jd     },
  /* 0F 85 */ { 0, &Ia_jnz_Jd    },
  /* 0F 86 */ { 0, &Ia_jbe_Jd    },
  /* 0F 87 */ { 0, &Ia_jnbe_Jd   },
  /* 0F 88 */ { 0, &Ia_js_Jd     },
  /* 0F 89 */ { 0, &Ia_jns_Jd    },
  /* 0F 8A */ { 0, &Ia_jp_Jd     },
  /* 0F 8B */ { 0, &Ia_jnp_Jd    },
  /* 0F 8C */ { 0, &Ia_jl_Jd     },
  /* 0F 8D */ { 0, &Ia_jnl_Jd    },
  /* 0F 8E */ { 0, &Ia_jle_Jd    },
  /* 0F 8F */ { 0, &Ia_jnle_Jd   },
  /* 0F 90 */ { 0, &Ia_seto_Eb   },
  /* 0F 91 */ { 0, &Ia_setno_Eb  },
  /* 0F 92 */ { 0, &Ia_setb_Eb   },
  /* 0F 93 */ { 0, &Ia_setnb_Eb  },
  /* 0F 94 */ { 0, &Ia_setz_Eb   },
  /* 0F 95 */ { 0, &Ia_setnz_Eb  },
  /* 0F 96 */ { 0, &Ia_setbe_Eb  },
  /* 0F 97 */ { 0, &Ia_setnbe_Eb },
  /* 0F 98 */ { 0, &Ia_sets_Eb   },
  /* 0F 99 */ { 0, &Ia_setns_Eb  },
  /* 0F 9A */ { 0, &Ia_setp_Eb   },
  /* 0F 9B */ { 0, &Ia_setnp_Eb  },
  /* 0F 9C */ { 0, &Ia_setl_Eb   },
  /* 0F 9D */ { 0, &Ia_setnl_Eb  },
  /* 0F 9E */ { 0, &Ia_setle_Eb  },
  /* 0F 9F */ { 0, &Ia_setnle_Eb },
  /* 0F A0 */ { 0, &Ia_pushq_FS  },
  /* 0F A1 */ { 0, &Ia_popq_FS   },
  /* 0F A2 */ { 0, &Ia_cpuid     },
  /* 0F A3 */ { 0, &Ia_btl_Ed_Gd },
  /* 0F A4 */ { 0, &Ia_shldl_Ed_Gd_Ib },
  /* 0F A5 */ { 0, &Ia_shldl_Ed_Gd_CL },
  /* 0F A6 */ { 0, &Ia_Invalid    },
  /* 0F A7 */ { 0, &Ia_Invalid    },
  /* 0F A8 */ { 0, &Ia_pushq_GS   },
  /* 0F A9 */ { 0, &Ia_popq_GS    },
  /* 0F AA */ { 0, &Ia_rsm        },
  /* 0F AB */ { 0, &Ia_btsl_Ed_Gd },
  /* 0F AC */ { 0, &Ia_shrdl_Ed_Gd_Ib },
  /* 0F AD */ { 0, &Ia_shrdl_Ed_Gd_CL },
  /* 0F AE */ { GRPMOD(G15)           },
  /* 0F AF */ { 0, &Ia_imull_Gd_Ed    },
  /* 0F B0 */ { 0, &Ia_cmpxchgb_Eb_Gb },
  /* 0F B1 */ { 0, &Ia_cmpxchgl_Ed_Gd },
  /* 0F B2 */ { 0, &Ia_lssl_Gd_Mp   },
  /* 0F B3 */ { 0, &Ia_btrl_Ed_Gd   },
  /* 0F B4 */ { 0, &Ia_lfsl_Gd_Mp   },
  /* 0F B5 */ { 0, &Ia_lgsl_Gd_Mp   },
  /* 0F B6 */ { 0, &Ia_movzbl_Gd_Eb },
  /* 0F B7 */ { 0, &Ia_movzwl_Gd_Ew },
  /* 0F B8 */ { GRPSSEF3(Ia_popcnt_Gd_Ed) },
  /* 0F B9 */ { 0, &Ia_ud2b         },
  /* 0F BA */ { GRPN(G8EdIb)        },
  /* 0F BB */ { 0, &Ia_btcl_Ed_Gd   },
  /* 0F BC */ { GRPSSE(0fbcd) },
  /* 0F BD */ { GRPSSE(0fbdd) },
  /* 0F BE */ { 0, &Ia_movsbl_Gd_Eb },
  /* 0F BF */ { 0, &Ia_movswl_Gd_Ew },
  /* 0F C0 */ { 0, &Ia_xaddb_Eb_Gb  },
  /* 0F C0 */ { 0, &Ia_xaddl_Ed_Gd  },
  /* 0F C2 */ { GRPSSE(0fc2)      },
  /* 0F C3 */ { GRPSSE(0fc3)      },
  /* 0F C4 */ { GRPSSE(0fc4)      },
  /* 0F C5 */ { GRPSSE(0fc5)      },
  /* 0F C6 */ { GRPSSE(0fc6)      },
  /* 0F C7 */ { GRPN(G9)          },
  /* 0F C8 */ { 0, &Ia_bswapl_ERX },
  /* 0F C9 */ { 0, &Ia_bswapl_ERX },
  /* 0F CA */ { 0, &Ia_bswapl_ERX },
  /* 0F CB */ { 0, &Ia_bswapl_ERX },
  /* 0F CC */ { 0, &Ia_bswapl_ERX },
  /* 0F CD */ { 0, &Ia_bswapl_ERX },
  /* 0F CE */ { 0, &Ia_bswapl_ERX },
  /* 0F CF */ { 0, &Ia_bswapl_ERX },
  /* 0F D0 */ { GRPSSE(0fd0) },
  /* 0F D1 */ { GRPSSE(0fd1) },
  /* 0F D2 */ { GRPSSE(0fd2) },
  /* 0F D3 */ { GRPSSE(0fd3) },
  /* 0F D4 */ { GRPSSE(0fd4) },
  /* 0F D5 */ { GRPSSE(0fd5) },
  /* 0F D6 */ { GRPSSE(0fd6) },
  /* 0F D7 */ { GRPSSE(0fd7) },
  /* 0F D8 */ { GRPSSE(0fd8) },
  /* 0F D9 */ { GRPSSE(0fd9) },
  /* 0F DA */ { GRPSSE(0fda) },
  /* 0F DB */ { GRPSSE(0fdb) },
  /* 0F DC */ { GRPSSE(0fdc) },
  /* 0F DD */ { GRPSSE(0fdd) },
  /* 0F DE */ { GRPSSE(0fde) },
  /* 0F DF */ { GRPSSE(0fdf) },
  /* 0F E0 */ { GRPSSE(0fe0) },
  /* 0F E1 */ { GRPSSE(0fe1) },
  /* 0F E2 */ { GRPSSE(0fe2) },
  /* 0F E3 */ { GRPSSE(0fe3) },
  /* 0F E4 */ { GRPSSE(0fe4) },
  /* 0F E5 */ { GRPSSE(0fe5) },
  /* 0F E6 */ { GRPSSE(0fe6) },
  /* 0F E7 */ { GRPSSE(0fe7) },
  /* 0F E8 */ { GRPSSE(0fe8) },
  /* 0F E9 */ { GRPSSE(0fe9) },
  /* 0F EA */ { GRPSSE(0fea) },
  /* 0F EB */ { GRPSSE(0feb) },
  /* 0F EC */ { GRPSSE(0fec) },
  /* 0F ED */ { GRPSSE(0fed) },
  /* 0F EE */ { GRPSSE(0fee) },
  /* 0F EF */ { GRPSSE(0fef) },
  /* 0F F0 */ { GRPSSEF2(Ia_lddqu_Vdq_Mdq) },
  /* 0F F1 */ { GRPSSE(0ff1) },
  /* 0F F2 */ { GRPSSE(0ff2) },
  /* 0F F3 */ { GRPSSE(0ff3) },
  /* 0F F4 */ { GRPSSE(0ff4) },
  /* 0F F5 */ { GRPSSE(0ff5) },
  /* 0F F6 */ { GRPSSE(0ff6) },
  /* 0F F7 */ { GRPSSE(0ff7) },
  /* 0F F8 */ { GRPSSE(0ff8) },
  /* 0F F9 */ { GRPSSE(0ff9) },
  /* 0F FA */ { GRPSSE(0ffa) },
  /* 0F FB */ { GRPSSE(0ffb) },
  /* 0F FC */ { GRPSSE(0ffc) },
  /* 0F FD */ { GRPSSE(0ffd) },
  /* 0F FE */ { GRPSSE(0ffe) },
  /* 0F FF */ { 0, &Ia_Invalid }
};

static BxDisasmOpcodeTable_t BxDisasmOpcodes64q[256*2] = {
  // 256 entries for single byte opcodes
  /* 00 */ { 0, &Ia_addb_Eb_Gb    },
  /* 01 */ { 0, &Ia_addq_Eq_Gq    },
  /* 02 */ { 0, &Ia_addb_Gb_Eb    },
  /* 03 */ { 0, &Ia_addq_Gq_Eq    },
  /* 04 */ { 0, &Ia_addb_AL_Ib,   },
  /* 05 */ { 0, &Ia_addq_RAX_sId  },
  /* 06 */ { 0, &Ia_Invalid       },
  /* 07 */ { 0, &Ia_Invalid       },
  /* 08 */ { 0, &Ia_orb_Eb_Gb     },
  /* 09 */ { 0, &Ia_orq_Eq_Gq     },
  /* 0A */ { 0, &Ia_orb_Gb_Eb     },
  /* 0B */ { 0, &Ia_orq_Gq_Eq     },
  /* 0C */ { 0, &Ia_orb_AL_Ib     },
  /* 0D */ { 0, &Ia_orq_RAX_sId   },
  /* 0E */ { 0, &Ia_Invalid       },
  /* 0F */ { 0, &Ia_error         },   // 2 byte escape
  /* 10 */ { 0, &Ia_adcb_Eb_Gb    },
  /* 11 */ { 0, &Ia_adcq_Eq_Gq    },
  /* 12 */ { 0, &Ia_adcb_Gb_Eb    },
  /* 13 */ { 0, &Ia_adcq_Gq_Eq    },
  /* 14 */ { 0, &Ia_adcb_AL_Ib    },
  /* 15 */ { 0, &Ia_adcq_RAX_sId  },
  /* 16 */ { 0, &Ia_Invalid       },
  /* 17 */ { 0, &Ia_Invalid       },
  /* 18 */ { 0, &Ia_sbbb_Eb_Gb    },
  /* 19 */ { 0, &Ia_sbbq_Eq_Gq    },
  /* 1A */ { 0, &Ia_sbbb_Gb_Eb    },
  /* 1B */ { 0, &Ia_sbbq_Gq_Eq    },
  /* 1C */ { 0, &Ia_sbbb_AL_Ib    },
  /* 1D */ { 0, &Ia_sbbq_RAX_sId  },
  /* 1E */ { 0, &Ia_Invalid       },
  /* 1F */ { 0, &Ia_Invalid       },
  /* 20 */ { 0, &Ia_andb_Eb_Gb    },
  /* 21 */ { 0, &Ia_andq_Eq_Gq    },
  /* 22 */ { 0, &Ia_andb_Gb_Eb    },
  /* 23 */ { 0, &Ia_andq_Gq_Eq    },
  /* 24 */ { 0, &Ia_andb_AL_Ib    },
  /* 25 */ { 0, &Ia_andq_RAX_sId  },
  /* 26 */ { 0, &Ia_prefix_es     },   // ES:
  /* 27 */ { 0, &Ia_Invalid       },
  /* 28 */ { 0, &Ia_subb_Eb_Gb    },
  /* 29 */ { 0, &Ia_subq_Eq_Gq    },
  /* 2A */ { 0, &Ia_subb_Gb_Eb    },
  /* 2B */ { 0, &Ia_subq_Gq_Eq    },
  /* 2C */ { 0, &Ia_subb_AL_Ib    },
  /* 2D */ { 0, &Ia_subq_RAX_sId  },
  /* 2E */ { 0, &Ia_prefix_cs     },   // CS:
  /* 2F */ { 0, &Ia_Invalid       },
  /* 30 */ { 0, &Ia_xorb_Eb_Gb    },
  /* 31 */ { 0, &Ia_xorq_Eq_Gq    },
  /* 32 */ { 0, &Ia_xorb_Gb_Eb    },
  /* 33 */ { 0, &Ia_xorq_Gq_Eq    },
  /* 34 */ { 0, &Ia_xorb_AL_Ib    },
  /* 35 */ { 0, &Ia_xorq_RAX_sId  },
  /* 36 */ { 0, &Ia_prefix_ss     },   // SS:
  /* 37 */ { 0, &Ia_Invalid       },
  /* 38 */ { 0, &Ia_cmpb_Eb_Gb    },
  /* 39 */ { 0, &Ia_cmpq_Eq_Gq    },
  /* 3A */ { 0, &Ia_cmpb_Gb_Eb    },
  /* 3B */ { 0, &Ia_cmpq_Gq_Eq    },
  /* 3C */ { 0, &Ia_cmpb_AL_Ib    },
  /* 3D */ { 0, &Ia_cmpq_RAX_sId  },
  /* 3E */ { 0, &Ia_prefix_ds     },   // DS:
  /* 3F */ { 0, &Ia_Invalid       },
  /* 40 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 41 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 42 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 43 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 44 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 45 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 46 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 47 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 48 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 49 */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4A */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4B */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4C */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4D */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4E */ { 0, &Ia_prefix_rex    },   // REX:
  /* 4F */ { 0, &Ia_prefix_rex    },   // REX:
  /* 50 */ { 0, &Ia_pushq_RRX     },
  /* 51 */ { 0, &Ia_pushq_RRX     },
  /* 52 */ { 0, &Ia_pushq_RRX     },
  /* 53 */ { 0, &Ia_pushq_RRX     },
  /* 54 */ { 0, &Ia_pushq_RRX     },
  /* 55 */ { 0, &Ia_pushq_RRX     },
  /* 56 */ { 0, &Ia_pushq_RRX     },
  /* 57 */ { 0, &Ia_pushq_RRX     },
  /* 58 */ { 0, &Ia_popq_RRX      },
  /* 59 */ { 0, &Ia_popq_RRX      },
  /* 5A */ { 0, &Ia_popq_RRX      },
  /* 5B */ { 0, &Ia_popq_RRX      },
  /* 5C */ { 0, &Ia_popq_RRX      },
  /* 5D */ { 0, &Ia_popq_RRX      },
  /* 5E */ { 0, &Ia_popq_RRX      },
  /* 5F */ { 0, &Ia_popq_RRX      },
  /* 60 */ { 0, &Ia_Invalid       },
  /* 61 */ { 0, &Ia_Invalid       },
  /* 62 */ { 0, &Ia_Invalid       },
  /* 63 */ { 0, &Ia_movslq_Gq_Ed  },
  /* 64 */ { 0, &Ia_prefix_fs     },   // FS:
  /* 65 */ { 0, &Ia_prefix_gs     },   // GS:
  /* 66 */ { 0, &Ia_prefix_osize  },   // OSIZE:
  /* 67 */ { 0, &Ia_prefix_asize  },   // ASIZE:
  /* 68 */ { 0, &Ia_pushq_sId     },
  /* 69 */ { 0, &Ia_imulq_Gq_Eq_sId },
  /* 6A */ { 0, &Ia_pushq_sIb     },
  /* 6B */ { 0, &Ia_imulq_Gq_Eq_sIb },
  /* 6C */ { 0, &Ia_insb_Yb_DX    },
  /* 6D */ { 0, &Ia_insl_Yd_DX    },
  /* 6E */ { 0, &Ia_outsb_DX_Xb   },
  /* 6F */ { 0, &Ia_outsl_DX_Xd   },
  /* 70 */ { 0, &Ia_jo_Jb         },
  /* 71 */ { 0, &Ia_jno_Jb        },
  /* 72 */ { 0, &Ia_jb_Jb         },
  /* 73 */ { 0, &Ia_jnb_Jb        },
  /* 74 */ { 0, &Ia_jz_Jb         },
  /* 75 */ { 0, &Ia_jnz_Jb        },
  /* 76 */ { 0, &Ia_jbe_Jb        },
  /* 77 */ { 0, &Ia_jnbe_Jb       },
  /* 78 */ { 0, &Ia_js_Jb         },
  /* 79 */ { 0, &Ia_jns_Jb        },
  /* 7A */ { 0, &Ia_jp_Jb         },
  /* 7B */ { 0, &Ia_jnp_Jb        },
  /* 7C */ { 0, &Ia_jl_Jb         },
  /* 7D */ { 0, &Ia_jnl_Jb        },
  /* 7E */ { 0, &Ia_jle_Jb        },
  /* 7F */ { 0, &Ia_jnle_Jb       },
  /* 80 */ { GRPN(G1EbIb)         },
  /* 81 */ { GRPN(G1EqId)         },
  /* 82 */ { 0, &Ia_Invalid       },
  /* 83 */ { GRPN(G1EqIb)         },
  /* 84 */ { 0, &Ia_testb_Eb_Gb   },
  /* 85 */ { 0, &Ia_testq_Eq_Gq   },
  /* 86 */ { 0, &Ia_xchgb_Eb_Gb   },
  /* 87 */ { 0, &Ia_xchgq_Eq_Gq   },
  /* 88 */ { 0, &Ia_movb_Eb_Gb    },
  /* 89 */ { 0, &Ia_movq_Eq_Gq    },
  /* 8A */ { 0, &Ia_movb_Gb_Eb    },
  /* 8B */ { 0, &Ia_movq_Gq_Eq    },
  /* 8C */ { 0, &Ia_movw_Ew_Sw    },
  /* 8D */ { 0, &Ia_leaq_Gq_Mq    },
  /* 8E */ { 0, &Ia_movw_Sw_Ew    },
  /* 8F */ { 0, &Ia_popq_Eq       },
  /* 90 */ { 0, &Ia_xchgq_RRX_RAX }, // handle XCHG R8, RAX
  /* 91 */ { 0, &Ia_xchgq_RRX_RAX },
  /* 92 */ { 0, &Ia_xchgq_RRX_RAX },
  /* 93 */ { 0, &Ia_xchgq_RRX_RAX },
  /* 94 */ { 0, &Ia_xchgq_RRX_RAX },
  /* 95 */ { 0, &Ia_xchgq_RRX_RAX },
  /* 96 */ { 0, &Ia_xchgq_RRX_RAX },
  /* 97 */ { 0, &Ia_xchgq_RRX_RAX },
  /* 98 */ { 0, &Ia_cdqe          },
  /* 99 */ { 0, &Ia_cqo           },
  /* 9A */ { 0, &Ia_Invalid       },
  /* 9B */ { 0, &Ia_fwait         },
  /* 9C */ { 0, &Ia_pushfq        },
  /* 9D */ { 0, &Ia_popfq         },
  /* 9E */ { 0, &Ia_sahf          },
  /* 9F */ { 0, &Ia_lahf          },
  /* A0 */ { 0, &Ia_movb_AL_Ob    },
  /* A1 */ { 0, &Ia_movq_RAX_Oq   },
  /* A0 */ { 0, &Ia_movb_Ob_AL    },
  /* A1 */ { 0, &Ia_movq_Oq_RAX   },
  /* A4 */ { 0, &Ia_movsb_Yb_Xb   },
  /* A5 */ { 0, &Ia_movsq_Yq_Xq   },
  /* A6 */ { 0, &Ia_cmpsb_Yb_Xb   },
  /* A7 */ { 0, &Ia_cmpsq_Yq_Xq   },
  /* A8 */ { 0, &Ia_testb_AL_Ib   },
  /* A9 */ { 0, &Ia_testq_RAX_sId },
  /* AA */ { 0, &Ia_stosb_Yb_AL   },
  /* AB */ { 0, &Ia_stosq_Yq_RAX  },
  /* AC */ { 0, &Ia_lodsb_AL_Xb   },
  /* AD */ { 0, &Ia_lodsq_RAX_Xq  },
  /* AE */ { 0, &Ia_scasb_Yb_AL   },
  /* AF */ { 0, &Ia_scasq_Yq_RAX  },
  /* B0 */ { 0, &Ia_movb_R8_Ib    },
  /* B1 */ { 0, &Ia_movb_R8_Ib    },
  /* B2 */ { 0, &Ia_movb_R8_Ib    },
  /* B3 */ { 0, &Ia_movb_R8_Ib    },
  /* B4 */ { 0, &Ia_movb_R8_Ib    },
  /* B5 */ { 0, &Ia_movb_R8_Ib    },
  /* B6 */ { 0, &Ia_movb_R8_Ib    },
  /* B7 */ { 0, &Ia_movb_R8_Ib    },
  /* B8 */ { 0, &Ia_movq_RRX_Iq   },
  /* B9 */ { 0, &Ia_movq_RRX_Iq   },
  /* BA */ { 0, &Ia_movq_RRX_Iq   },
  /* BB */ { 0, &Ia_movq_RRX_Iq   },
  /* BC */ { 0, &Ia_movq_RRX_Iq   },
  /* BD */ { 0, &Ia_movq_RRX_Iq   },
  /* BE */ { 0, &Ia_movq_RRX_Iq   },
  /* BF */ { 0, &Ia_movq_RRX_Iq   },
  /* C0 */ { GRPN(G2Eb)           },
  /* C1 */ { GRPN(G2Eq)           },
  /* C2 */ { 0, &Ia_ret_Iw        },
  /* C3 */ { 0, &Ia_ret           },
  /* C4 */ { 0, &Ia_Invalid       },
  /* C5 */ { 0, &Ia_Invalid       },
  /* C6 */ { GRPN(G11Eb)          },
  /* C7 */ { GRPN(G11Eq)          },
  /* C8 */ { 0, &Ia_enter         },
  /* C9 */ { 0, &Ia_leave         },
  /* CA */ { 0, &Ia_lret_Iw       },
  /* CB */ { 0, &Ia_lret          },
  /* CC */ { 0, &Ia_int3          },
  /* CD */ { 0, &Ia_int_Ib        },
  /* CE */ { 0, &Ia_Invalid       },
  /* CF */ { 0, &Ia_iretq         },
  /* D0 */ { GRPN(G2EbI1)         },
  /* D1 */ { GRPN(G2EqI1)         },
  /* D2 */ { GRPN(G2EbCL)         },
  /* D3 */ { GRPN(G2EqCL)         },
  /* D4 */ { 0, &Ia_Invalid       },
  /* D5 */ { 0, &Ia_Invalid       },
  /* D6 */ { 0, &Ia_Invalid       },
  /* D7 */ { 0, &Ia_xlat          },
  /* D8 */ { GRPFP(D8)            },
  /* D9 */ { GRPFP(D9)            },
  /* DA */ { GRPFP(DA)            },
  /* DB */ { GRPFP(DB)            },
  /* DC */ { GRPFP(DC)            },
  /* DD */ { GRPFP(DD)            },
  /* DE */ { GRPFP(DE)            },
  /* DF */ { GRPFP(DF)            },
  /* E0 */ { 0, &Ia_loopne_Jb     },
  /* E1 */ { 0, &Ia_loope_Jb      },
  /* E2 */ { 0, &Ia_loop_Jb       },
  /* E3 */ { 0, &Ia_jrcxz_Jb      },
  /* E4 */ { 0, &Ia_inb_AL_Ib     },
  /* E5 */ { 0, &Ia_inl_EAX_Ib    },
  /* E6 */ { 0, &Ia_outb_Ib_AL    },
  /* E7 */ { 0, &Ia_outl_Ib_EAX   },
  /* E8 */ { 0, &Ia_call_Jd       },
  /* E9 */ { 0, &Ia_jmp_Jd        },
  /* EA */ { 0, &Ia_Invalid       },
  /* EB */ { 0, &Ia_jmp_Jb        },
  /* EC */ { 0, &Ia_inb_AL_DX     },
  /* ED */ { 0, &Ia_inl_EAX_DX    },
  /* EE */ { 0, &Ia_outb_DX_AL    },
  /* EF */ { 0, &Ia_outl_DX_EAX   },
  /* F0 */ { 0, &Ia_prefix_lock   },   // LOCK:
  /* F1 */ { 0, &Ia_int1          },
  /* F2 */ { 0, &Ia_prefix_repne  },   // REPNE:
  /* F3 */ { 0, &Ia_prefix_rep    },   // REP:
  /* F4 */ { 0, &Ia_hlt           },
  /* F5 */ { 0, &Ia_cmc           },
  /* F6 */ { GRPN(G3Eb)           },
  /* F7 */ { GRPN(G3Eq)           },
  /* F8 */ { 0, &Ia_clc           },
  /* F9 */ { 0, &Ia_stc           },
  /* FA */ { 0, &Ia_cli           },
  /* FB */ { 0, &Ia_sti           },
  /* FC */ { 0, &Ia_cld           },
  /* FD */ { 0, &Ia_std           },
  /* FE */ { GRPN(G4)             },
  /* FF */ { GRPN(64G5q)          },

  // 256 entries for two byte opcodes
  /* 0F 00 */ { GRPN(G6)          },
  /* 0F 01 */ { GRPMOD(G7)        },
  /* 0F 02 */ { 0, &Ia_larq_Gq_Ew },
  /* 0F 03 */ { 0, &Ia_lslq_Gq_Ew },
  /* 0F 04 */ { 0, &Ia_Invalid    },
  /* 0F 05 */ { 0, &Ia_syscall    },
  /* 0F 06 */ { 0, &Ia_clts       },
  /* 0F 07 */ { 0, &Ia_sysret     },
  /* 0F 08 */ { 0, &Ia_invd       },
  /* 0F 09 */ { 0, &Ia_wbinvd     },
  /* 0F 0A */ { 0, &Ia_Invalid    },
  /* 0F 0B */ { 0, &Ia_ud2a       },
  /* 0F 0C */ { 0, &Ia_Invalid    },
  /* 0F 0D */ { 0, &Ia_prefetchw  },   // 3DNow!
  /* 0F 0E */ { 0, &Ia_femms      },   // 3DNow!
  /* 0F 0F */ { GRP3DNOW          },
  /* 0F 10 */ { GRPSSE(0f10)      },
  /* 0F 11 */ { GRPSSE(0f11)      },
  /* 0F 12 */ { GRPSSE(0f12)      },
  /* 0F 13 */ { GRPSSE(0f13)      },
  /* 0F 14 */ { GRPSSE(0f14)      },
  /* 0F 15 */ { GRPSSE(0f15)      },
  /* 0F 16 */ { GRPSSE(0f16)      },
  /* 0F 17 */ { GRPSSE(0f17)      },
  /* 0F 18 */ { GRPN(G16)         },
  /* 0F 19 */ { 0, &Ia_multibyte_nop },
  /* 0F 1A */ { 0, &Ia_multibyte_nop },
  /* 0F 1B */ { 0, &Ia_multibyte_nop },
  /* 0F 1C */ { 0, &Ia_multibyte_nop },
  /* 0F 1D */ { 0, &Ia_multibyte_nop },
  /* 0F 1E */ { 0, &Ia_multibyte_nop },
  /* 0F 1F */ { 0, &Ia_multibyte_nop },
  /* 0F 20 */ { 0, &Ia_movq_Rq_Cq },
  /* 0F 21 */ { 0, &Ia_movq_Rq_Dq },
  /* 0F 22 */ { 0, &Ia_movq_Cq_Rq },
  /* 0F 23 */ { 0, &Ia_movq_Dq_Rq },
  /* 0F 24 */ { 0, &Ia_Invalid    },
  /* 0F 25 */ { 0, &Ia_Invalid    },
  /* 0F 26 */ { 0, &Ia_Invalid    },
  /* 0F 27 */ { 0, &Ia_Invalid    },
  /* 0F 28 */ { GRPSSE(0f28) },
  /* 0F 29 */ { GRPSSE(0f29) },
  /* 0F 2A */ { GRPSSE(0f2a) },
  /* 0F 2B */ { GRPSSE(0f2b) },
  /* 0F 2C */ { GRPSSE(0f2c) },
  /* 0F 2D */ { GRPSSE(0f2d) },
  /* 0F 2E */ { GRPSSE(0f2e) },
  /* 0F 2F */ { GRPSSE(0f2f) },
  /* 0F 30 */ { 0, &Ia_wrmsr },
  /* 0F 31 */ { 0, &Ia_rdtsc },
  /* 0F 32 */ { 0, &Ia_rdmsr },
  /* 0F 33 */ { 0, &Ia_rdpmc },
  /* 0F 34 */ { 0, &Ia_sysenter },
  /* 0F 35 */ { 0, &Ia_sysexit },
  /* 0F 36 */ { 0, &Ia_Invalid },
  /* 0F 37 */ { 0, &Ia_getsec },
  /* 0F 38 */ { GR3BTAB(0f38) },
  /* 0F 39 */ { 0, &Ia_Invalid  },
  /* 0F 3A */ { GR3BTAB(0f3a) },
  /* 0F 3B */ { 0, &Ia_Invalid },
  /* 0F 3C */ { 0, &Ia_Invalid },
  /* 0F 3D */ { 0, &Ia_Invalid },
  /* 0F 3E */ { 0, &Ia_Invalid },
  /* 0F 3F */ { 0, &Ia_Invalid },
  /* 0F 40 */ { 0, &Ia_cmovoq_Gq_Eq  },
  /* 0F 41 */ { 0, &Ia_cmovnoq_Gq_Eq },
  /* 0F 42 */ { 0, &Ia_cmovcq_Gq_Eq  },
  /* 0F 43 */ { 0, &Ia_cmovncq_Gq_Eq },
  /* 0F 44 */ { 0, &Ia_cmovzq_Gq_Eq  },
  /* 0F 45 */ { 0, &Ia_cmovnzq_Gq_Eq },
  /* 0F 46 */ { 0, &Ia_cmovnaq_Gq_Eq },
  /* 0F 47 */ { 0, &Ia_cmovaq_Gq_Eq  },
  /* 0F 48 */ { 0, &Ia_cmovsq_Gq_Eq  },
  /* 0F 49 */ { 0, &Ia_cmovnsq_Gq_Eq },
  /* 0F 4A */ { 0, &Ia_cmovpq_Gq_Eq  },
  /* 0F 4B */ { 0, &Ia_cmovnpq_Gq_Eq },
  /* 0F 4C */ { 0, &Ia_cmovlq_Gq_Eq  },
  /* 0F 4D */ { 0, &Ia_cmovnlq_Gq_Eq },
  /* 0F 4E */ { 0, &Ia_cmovngq_Gq_Eq },
  /* 0F 4F */ { 0, &Ia_cmovgq_Gq_Eq  },
  /* 0F 50 */ { GRPSSE(0f50) },
  /* 0F 51 */ { GRPSSE(0f51) },
  /* 0F 52 */ { GRPSSE(0f52) },
  /* 0F 53 */ { GRPSSE(0f53) },
  /* 0F 54 */ { GRPSSE(0f54) },
  /* 0F 55 */ { GRPSSE(0f55) },
  /* 0F 56 */ { GRPSSE(0f56) },
  /* 0F 57 */ { GRPSSE(0f57) },
  /* 0F 58 */ { GRPSSE(0f58) },
  /* 0F 59 */ { GRPSSE(0f59) },
  /* 0F 5A */ { GRPSSE(0f5a) },
  /* 0F 5B */ { GRPSSE(0f5b) },
  /* 0F 5C */ { GRPSSE(0f5c) },
  /* 0F 5D */ { GRPSSE(0f5d) },
  /* 0F 5E */ { GRPSSE(0f5e) },
  /* 0F 5F */ { GRPSSE(0f5f) },
  /* 0F 60 */ { GRPSSE(0f60) },
  /* 0F 61 */ { GRPSSE(0f61) },
  /* 0F 62 */ { GRPSSE(0f62) },
  /* 0F 63 */ { GRPSSE(0f63) },
  /* 0F 64 */ { GRPSSE(0f64) },
  /* 0F 65 */ { GRPSSE(0f65) },
  /* 0F 66 */ { GRPSSE(0f66) },
  /* 0F 67 */ { GRPSSE(0f67) },
  /* 0F 68 */ { GRPSSE(0f68) },
  /* 0F 69 */ { GRPSSE(0f69) },
  /* 0F 6A */ { GRPSSE(0f6a) },
  /* 0F 6B */ { GRPSSE(0f6b) },
  /* 0F 6C */ { GRPSSE66(Ia_punpcklqdq_Vdq_Wdq) },
  /* 0F 6D */ { GRPSSE66(Ia_punpckhqdq_Vdq_Wdq) },
  /* 0F 6E */ { GRPSSE(0f6eQ) },
  /* 0F 6F */ { GRPSSE(0f6f) },
  /* 0F 70 */ { GRPSSE(0f70) },
  /* 0F 71 */ { GRPN(G12)    },
  /* 0F 72 */ { GRPN(G13)    },
  /* 0F 73 */ { GRPN(G14)    },
  /* 0F 74 */ { GRPSSE(0f74) },
  /* 0F 75 */ { GRPSSE(0f75) },
  /* 0F 76 */ { GRPSSE(0f76) },
  /* 0F 77 */ { 0, &Ia_emms  },
  /* 0F 78 */ { GRPSSE(0f78Q) }, // VMX
  /* 0F 79 */ { GRPSSE(0f79Q) }, // VMX
  /* 0F 7A */ { 0, &Ia_Invalid },
  /* 0F 7B */ { 0, &Ia_Invalid },
  /* 0F 7C */ { GRPSSE(0f7c) },
  /* 0F 7D */ { GRPSSE(0f7d) },
  /* 0F 7E */ { GRPSSE(0f7eQ) },
  /* 0F 7F */ { GRPSSE(0f7f) },
  /* 0F 80 */ { 0, &Ia_jo_Jd     },
  /* 0F 81 */ { 0, &Ia_jno_Jd    },
  /* 0F 82 */ { 0, &Ia_jb_Jd     },
  /* 0F 83 */ { 0, &Ia_jnb_Jd    },
  /* 0F 84 */ { 0, &Ia_jz_Jd     },
  /* 0F 85 */ { 0, &Ia_jnz_Jd    },
  /* 0F 86 */ { 0, &Ia_jbe_Jd    },
  /* 0F 87 */ { 0, &Ia_jnbe_Jd   },
  /* 0F 88 */ { 0, &Ia_js_Jd     },
  /* 0F 89 */ { 0, &Ia_jns_Jd    },
  /* 0F 8A */ { 0, &Ia_jp_Jd     },
  /* 0F 8B */ { 0, &Ia_jnp_Jd    },
  /* 0F 8C */ { 0, &Ia_jl_Jd     },
  /* 0F 8D */ { 0, &Ia_jnl_Jd    },
  /* 0F 8E */ { 0, &Ia_jle_Jd    },
  /* 0F 8F */ { 0, &Ia_jnle_Jd   },
  /* 0F 90 */ { 0, &Ia_seto_Eb   },
  /* 0F 91 */ { 0, &Ia_setno_Eb  },
  /* 0F 92 */ { 0, &Ia_setb_Eb   },
  /* 0F 93 */ { 0, &Ia_setnb_Eb  },
  /* 0F 94 */ { 0, &Ia_setz_Eb   },
  /* 0F 95 */ { 0, &Ia_setnz_Eb  },
  /* 0F 96 */ { 0, &Ia_setbe_Eb  },
  /* 0F 97 */ { 0, &Ia_setnbe_Eb },
  /* 0F 98 */ { 0, &Ia_sets_Eb   },
  /* 0F 99 */ { 0, &Ia_setns_Eb  },
  /* 0F 9A */ { 0, &Ia_setp_Eb   },
  /* 0F 9B */ { 0, &Ia_setnp_Eb  },
  /* 0F 9C */ { 0, &Ia_setl_Eb   },
  /* 0F 9D */ { 0, &Ia_setnl_Eb  },
  /* 0F 9E */ { 0, &Ia_setle_Eb  },
  /* 0F 9F */ { 0, &Ia_setnle_Eb },
  /* 0F A0 */ { 0, &Ia_pushq_FS  },
  /* 0F A1 */ { 0, &Ia_popq_FS   },
  /* 0F A2 */ { 0, &Ia_cpuid     },
  /* 0F A3 */ { 0, &Ia_btq_Eq_Gq },
  /* 0F A4 */ { 0, &Ia_shldq_Eq_Gq_Ib },
  /* 0F A5 */ { 0, &Ia_shldq_Eq_Gq_CL },
  /* 0F A6 */ { 0, &Ia_Invalid    },
  /* 0F A7 */ { 0, &Ia_Invalid    },
  /* 0F A8 */ { 0, &Ia_pushq_GS   },
  /* 0F A9 */ { 0, &Ia_popq_GS    },
  /* 0F AA */ { 0, &Ia_rsm        },
  /* 0F AB */ { 0, &Ia_btsq_Eq_Gq },
  /* 0F AC */ { 0, &Ia_shrdq_Eq_Gq_Ib },
  /* 0F AD */ { 0, &Ia_shrdq_Eq_Gq_CL },
  /* 0F AE */ { GRPMOD(G15)           },
  /* 0F AF */ { 0, &Ia_imulq_Gq_Eq    },
  /* 0F B0 */ { 0, &Ia_cmpxchgb_Eb_Gb },
  /* 0F B1 */ { 0, &Ia_cmpxchgq_Eq_Gq },
  /* 0F B2 */ { 0, &Ia_lssq_Gq_Mp   },
  /* 0F B3 */ { 0, &Ia_btrq_Eq_Gq   },
  /* 0F B4 */ { 0, &Ia_lfsq_Gq_Mp   },
  /* 0F B5 */ { 0, &Ia_lgsq_Gq_Mp   },
  /* 0F B6 */ { 0, &Ia_movzbq_Gq_Eb },
  /* 0F B7 */ { 0, &Ia_movzwq_Gq_Ew },
  /* 0F B8 */ { GRPSSEF3(Ia_popcnt_Gq_Eq) },
  /* 0F B9 */ { 0, &Ia_ud2b         },
  /* 0F BA */ { GRPN(G8EqIb)        },
  /* 0F BB */ { 0, &Ia_btcq_Eq_Gq   },
  /* 0F BC */ { GRPSSE(0fbcq) },
  /* 0F BD */ { GRPSSE(0fbdq) },
  /* 0F BE */ { 0, &Ia_movsbq_Gq_Eb },
  /* 0F BF */ { 0, &Ia_movswq_Gq_Ew },
  /* 0F C0 */ { 0, &Ia_xaddb_Eb_Gb  },
  /* 0F C0 */ { 0, &Ia_xaddq_Eq_Gq  },
  /* 0F C2 */ { GRPSSE(0fc2)      },
  /* 0F C3 */ { GRPSSE(0fc3Q)     },
  /* 0F C4 */ { GRPSSE(0fc4)      },
  /* 0F C5 */ { GRPSSE(0fc5)      },
  /* 0F C6 */ { GRPSSE(0fc6)      },
  /* 0F C7 */ { GRPN(G9q)         },
  /* 0F C8 */ { 0, &Ia_bswapq_RRX },
  /* 0F C9 */ { 0, &Ia_bswapq_RRX },
  /* 0F CA */ { 0, &Ia_bswapq_RRX },
  /* 0F CB */ { 0, &Ia_bswapq_RRX },
  /* 0F CC */ { 0, &Ia_bswapq_RRX },
  /* 0F CD */ { 0, &Ia_bswapq_RRX },
  /* 0F CE */ { 0, &Ia_bswapq_RRX },
  /* 0F CF */ { 0, &Ia_bswapq_RRX },
  /* 0F D0 */ { GRPSSE(0fd0) },
  /* 0F D1 */ { GRPSSE(0fd1) },
  /* 0F D2 */ { GRPSSE(0fd2) },
  /* 0F D3 */ { GRPSSE(0fd3) },
  /* 0F D4 */ { GRPSSE(0fd4) },
  /* 0F D5 */ { GRPSSE(0fd5) },
  /* 0F D6 */ { GRPSSE(0fd6) },
  /* 0F D7 */ { GRPSSE(0fd7) },
  /* 0F D8 */ { GRPSSE(0fd8) },
  /* 0F D9 */ { GRPSSE(0fd9) },
  /* 0F DA */ { GRPSSE(0fda) },
  /* 0F DB */ { GRPSSE(0fdb) },
  /* 0F DC */ { GRPSSE(0fdc) },
  /* 0F DD */ { GRPSSE(0fdd) },
  /* 0F DE */ { GRPSSE(0fde) },
  /* 0F DF */ { GRPSSE(0fdf) },
  /* 0F E0 */ { GRPSSE(0fe0) },
  /* 0F E1 */ { GRPSSE(0fe1) },
  /* 0F E2 */ { GRPSSE(0fe2) },
  /* 0F E3 */ { GRPSSE(0fe3) },
  /* 0F E4 */ { GRPSSE(0fe4) },
  /* 0F E5 */ { GRPSSE(0fe5) },
  /* 0F E6 */ { GRPSSE(0fe6) },
  /* 0F E7 */ { GRPSSE(0fe7) },
  /* 0F E8 */ { GRPSSE(0fe8) },
  /* 0F E9 */ { GRPSSE(0fe9) },
  /* 0F EA */ { GRPSSE(0fea) },
  /* 0F EB */ { GRPSSE(0feb) },
  /* 0F EC */ { GRPSSE(0fec) },
  /* 0F ED */ { GRPSSE(0fed) },
  /* 0F EE */ { GRPSSE(0fee) },
  /* 0F EF */ { GRPSSE(0fef) },
  /* 0F F0 */ { GRPSSEF2(Ia_lddqu_Vdq_Mdq) },
  /* 0F F1 */ { GRPSSE(0ff1) },
  /* 0F F2 */ { GRPSSE(0ff2) },
  /* 0F F3 */ { GRPSSE(0ff3) },
  /* 0F F4 */ { GRPSSE(0ff4) },
  /* 0F F5 */ { GRPSSE(0ff5) },
  /* 0F F6 */ { GRPSSE(0ff6) },
  /* 0F F7 */ { GRPSSE(0ff7) },
  /* 0F F8 */ { GRPSSE(0ff8) },
  /* 0F F9 */ { GRPSSE(0ff9) },
  /* 0F FA */ { GRPSSE(0ffa) },
  /* 0F FB */ { GRPSSE(0ffb) },
  /* 0F FC */ { GRPSSE(0ffc) },
  /* 0F FD */ { GRPSSE(0ffd) },
  /* 0F FE */ { GRPSSE(0ffe) },
  /* 0F FF */ { 0, &Ia_Invalid }
};
