/**
 * Copyright Copr. INRIA/INRA
 * Contact :  biomaj_AT_genouest.org
 * 
 * BioMAJ is a workflow engine dedicated to biological bank management. 
 * The Software automates the update cycle and the supervision of the locally 
 * mirrored bank repository. The project is a collaborative effort between two 
 * French Research Institutes INRIA (Institut National de Recherche en
 * Informatique 
 * et en Automatique) & INRA (Institut National de la Recherche Agronomique).
 *
 * Inter Deposit Digital Number : IDDN ...................................
 *
 * This software is governed by the CeCILL-A license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-A license and that you accept its terms.
 */


package org.inria.biomaj.ant.task;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.inria.biomaj.ant.logger.BiomajConsoleLogger;
import org.inria.biomaj.ant.logger.DBWriter;
import org.inria.biomaj.session.bank.FileDesc;
import org.inria.biomaj.utils.BiomajBuildException;
import org.inria.biomaj.utils.BiomajConst;
import org.inria.biomaj.utils.BiomajException;
import org.inria.biomaj.utils.BiomajUtils;


public class BmajMove extends BmajTask {

	public static final String MODE_COPY = "copy";
	public static final String MODE_MOVE = "move";

	private Vector<FileSet> vFilesSet = new Vector<FileSet>();
	/**
	 * @uml.property  name="mode"
	 */
	private String mode ;
	/**
	 * @uml.property  name="toDir"
	 */
	private String toDir;
	
	private String taskId;

	@Override
	public void execute() throws BuildException {

		File targetDirectory = new File (toDir);

		if (!targetDirectory.exists())
			throw new BiomajBuildException(getProject(),"bmajmove.todir.not.exist",toDir,new Exception());
		
		for (FileSet fileset : vFilesSet) {
			if (MODE_COPY.compareTo(mode)==0)
				execute_copy(fileset);
			else if (MODE_MOVE.compareTo(mode)==0)
				execute_move(fileset);
			else
				throw new BiomajBuildException(getProject(),"bmajmove.unknow.mode",mode,new Exception());
		}

	}

	/**
	 * 
	 * @param fileset
	 * @throws BuildException
	 */
	public void execute_copy(FileSet fileset) throws BuildException {
		String[] files = fileset.getDirectoryScanner(getProject()).getIncludedFiles();
		boolean logFiles = Boolean.valueOf(getProject().getProperty(BiomajConst.logFilesProperty));
		int count = 0;
		for (int i=0;i<files.length;i++) {
			try {
				float a = ((float)++count/ (float)files.length)*100;
				log(BiomajConsoleLogger.NOT_KEEP_LINE_ON_CONSOLE+"["+Integer.toString((int)a)+"%]",Project.MSG_INFO);				
				log("COPY:"+BiomajUtils.getOfflineDirectory(getProject())+"/"+files[i]+" to "+toDir,Project.MSG_VERBOSE);
				File tempFile = new File(BiomajUtils.getOfflineDirectory(getProject())+"/"+files[i]);
				File targetFile = new File(toDir+"/"+files[i]);
				BiomajUtils.copy(tempFile, targetFile);
				tempFile.delete();
				if (logFiles)
					addProductionFile(targetFile.getCanonicalPath(),true);
			} catch (IOException ioe) {
				System.out.println("######"+ioe);
				throw new BiomajBuildException(getProject(),"io.error",ioe.getMessage(),ioe);
			} catch (BiomajException be) {
				throw new BiomajBuildException(getProject(),be);
			}
		}

	}
	/**
	 * 
	 * @param fileset
	 * @throws BuildException
	 */
	public void execute_move(FileSet fileset) throws BuildException {
		String[] files = fileset.getDirectoryScanner(getProject()).getIncludedFiles();
		boolean logFiles = Boolean.valueOf(getProject().getProperty(BiomajConst.logFilesProperty));
		int count = 0;
		for (int i=0;i<files.length;i++) {
			try {
				float a = ((float)++count/ (float)files.length)*100;
				log(BiomajConsoleLogger.NOT_KEEP_LINE_ON_CONSOLE+"["+Integer.toString((int)a)+"%]",Project.MSG_INFO);
				//log("["+count+"]",Project.MSG_INFO);
				
				log("MOVE:"+BiomajUtils.getOfflineDirectory(getProject())+"/"+files[i]+" to "+toDir,Project.MSG_VERBOSE);
				File tempFile = new File(BiomajUtils.getOfflineDirectory(getProject())+"/"+files[i]);
				File targetFile = new File(toDir+"/"+files[i]);
				BiomajUtils.createSubDirectories(BiomajUtils.getRelativeDirectory(targetFile.getAbsolutePath()));
				tempFile.renameTo(targetFile);
				if (logFiles)
					addProductionFile(targetFile.getCanonicalPath(), false);
			} catch (BiomajException be) {
				throw new BiomajBuildException(getProject(),be);
			} catch (IOException e) {
				throw new BiomajBuildException(getProject(),e);
			}
		}
	}
	
	private void addFileInDB(int taskId, File file) {
		try {
			FileDesc fd = new FileDesc(file.getCanonicalFile(), false);
			DBWriter.addFileToTask(fd, taskId, "file");
		} catch (BiomajException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}


	/**
	 * @param mode  the mode to set
	 * @uml.property  name="mode"
	 */
	public void setMode(String mode) {
		this.mode = mode;
	}

	public void addConfiguredFileSet(FileSet fileset) {
		vFilesSet.add(fileset);
	}

	/**
	 * @return  the toDir
	 * @uml.property  name="toDir"
	 */
	public String getToDir() {
		return toDir;
	}

	/**
	 * @param toDir  the toDir to set
	 * @uml.property  name="toDir"
	 */
	public void setToDir(String toDir) {
		this.toDir = toDir;
	}
	
	public String getTaskId() {
		return taskId;
	}
	
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
}
