/*
 * Biloba
 * Copyright (C) 2004-2008 Guillaume Demougeot, Colin Leroy
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __GAME_H__
#define __GAME_H__

typedef struct _Game Game;

struct _Game
{
	char *name;
	int id;
	int num_players;
	int num_remote;
	char *player_name[4];
	int player_type[4];
	int first_avail_spot;
	int started;
	int cur_player, cur_x, cur_y;
	int move_id;
	int waiting_acks;
	int quit_players;
	int killed;
	int last_joined;

#ifndef __MINGW32__
	pthread_cond_t  cond_wait;
	pthread_cond_t  cond_move;
	pthread_cond_t  cond_quit;
#endif
};

void game_free(Game *);
#endif
