/*
 * Decompiled with CFR 0.152.
 */
package jolon.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jolon.xml.XMLAttribute;
import jolon.xml.XMLCompatible;

public class XMLObject
implements XMLCompatible {
    String tag;
    Object data;
    Vector children;
    Vector attributes;
    public static final int END = 1;
    public static final int LITERAL = 4;
    public static final int EXT_T_1 = 81;
    public static final int STR_T = 83;

    public XMLObject(String tag) {
        this.tag = tag;
        this.data = this.data;
        this.children = new Vector();
        this.attributes = new Vector();
    }

    public void add(XMLObject inObject) {
        this.children.addElement(inObject);
    }

    public void fromXML(XMLObject xmlobject) {
    }

    public XMLCompatible addXMLChild(XMLCompatible inObject) {
        this.children.addElement(inObject);
        return inObject;
    }

    public XMLObject getAt(int index) {
        return (XMLObject)this.children.elementAt(index);
    }

    public void add(XMLAttribute attribute) {
        this.attributes.addElement(attribute);
    }

    public void addAttribute(String name, Object data) {
        this.add(new XMLAttribute(name, data));
    }

    public void addAttribute(String name, int data) {
        this.add(new XMLAttribute(name, new Integer(data)));
    }

    public void addAttribute(String name, double data) {
        this.add(new XMLAttribute(name, new Double(data)));
    }

    public void addAttribute(String name, boolean data) {
        this.add(new XMLAttribute(name, new Boolean(data)));
    }

    public void writeXML(File file) {
        try {
            FileWriter writer = new FileWriter(file);
            this.writeXML(writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeXML(Writer writer) {
        try {
            writer.write("<?xml version=\"1.0\"?>\n");
            this.write(writer, 0);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    protected void write(Writer writer, int level) throws IOException {
        this.writeTabs(writer, level);
        writer.write("<" + this.tag);
        this.writeAttributes(writer);
        if (this.children.size() > 0 || this.data != null) {
            writer.write(">\n");
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                ((XMLObject)e.nextElement()).write(writer, level + 1);
            }
            if (this.data != null) {
                this.writeTabs(writer, level + 1);
                writer.write(this.data.toString());
            }
            this.writeTabs(writer, level);
            writer.write("</" + this.tag + ">" + "\n");
        } else {
            writer.write("/>\n");
        }
    }

    protected void writeTabs(Writer writer, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            writer.write("\t");
        }
    }

    protected void writeAttributes(Writer writer) throws IOException {
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            writer.write(" ");
            ((XMLAttribute)e.nextElement()).write(writer);
        }
    }

    public void writeWBXML(File file) {
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.writeWBXML(outputStream);
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeWBXML(OutputStream outputStream) {
        try {
            this.writeWBXMLversion(outputStream);
            this.writeWBXMLpublicID(outputStream);
            this.writeWBXMLcharSet(outputStream);
            Hashtable stringTable = this.writeWBXMLstringTable(outputStream);
            this.writeWBXML(outputStream, stringTable);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void writeWBXMLversion(OutputStream outputStream) throws IOException {
        outputStream.write(1);
    }

    public void writeWBXMLpublicID(OutputStream outputStream) throws IOException {
        outputStream.write(0);
    }

    public void writeWBXMLcharSet(OutputStream outputStream) throws IOException {
        outputStream.write(0);
    }

    public Hashtable writeWBXMLstringTable(OutputStream outputStream) throws IOException {
        Hashtable<String, Integer> stringTable = new Hashtable<String, Integer>();
        stringTable.put("Jolon's public id", new Integer(0));
        this.generateStringTable(stringTable);
        int totalLength = 0;
        Enumeration e = stringTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            stringTable.put(key, new Integer(totalLength));
            totalLength += key.length() + 1;
        }
        this.writeWBXMLmultibyteInteger(outputStream, totalLength);
        System.out.println("String table length = " + totalLength);
        Enumeration e2 = stringTable.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            this.writeWBXMLnullTerminatedString(outputStream, key);
        }
        return stringTable;
    }

    public void generateStringTable(Hashtable stringTable) {
        stringTable.put(this.tag, new Integer(0));
        if (!this.attributes.isEmpty()) {
            Enumeration e = this.attributes.elements();
            while (e.hasMoreElements()) {
                XMLAttribute attribute = (XMLAttribute)e.nextElement();
                stringTable.put(attribute.getName(), new Integer(0));
                if (attribute.getData() instanceof Double) continue;
                stringTable.put(attribute.getDataAsString(), new Integer(0));
            }
        }
        if (!this.children.isEmpty()) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                XMLObject xml = (XMLObject)e.nextElement();
                xml.generateStringTable(stringTable);
            }
        }
    }

    public void writeWBXMLmultibyteInteger(OutputStream outputStream, int value) throws IOException {
        if (value == 0) {
            outputStream.write(0);
        } else {
            int bitsLeft = 28;
            boolean start = false;
            do {
                int bits = value >> bitsLeft & 0x7F;
                if (!start && bits > 0) {
                    start = true;
                }
                if (!start) continue;
                if (bitsLeft > 0) {
                    bits |= 0x80;
                }
                outputStream.write(bits);
            } while ((bitsLeft -= 7) >= 0);
        }
    }

    public void writeWBXMLnullTerminatedString(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes(), 0, string.length());
        outputStream.write(0);
    }

    public void writeWBXML(OutputStream outputStream, Hashtable stringTable) throws IOException {
        int tokenCode = 4;
        if (!this.attributes.isEmpty()) {
            tokenCode |= 0x80;
        }
        if (!this.children.isEmpty()) {
            tokenCode |= 0x40;
        }
        outputStream.write(tokenCode);
        this.writeWBXMLstringIndex(outputStream, stringTable, this.tag);
        if (!this.attributes.isEmpty()) {
            Enumeration e = this.attributes.elements();
            while (e.hasMoreElements()) {
                XMLAttribute attribute = (XMLAttribute)e.nextElement();
                outputStream.write(4);
                this.writeWBXMLstringIndex(outputStream, stringTable, attribute.getName());
                Object data = attribute.getData();
                if (data instanceof Double) {
                    Double doubleObject = (Double)data;
                    int bits = Float.floatToIntBits(doubleObject.floatValue());
                    outputStream.write(81);
                    this.writeWBXMLmultibyteInteger(outputStream, bits);
                    continue;
                }
                outputStream.write(83);
                this.writeWBXMLstringIndex(outputStream, stringTable, attribute.getDataAsString());
            }
            outputStream.write(1);
        }
        if (!this.children.isEmpty()) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                XMLObject xml = (XMLObject)e.nextElement();
                xml.writeWBXML(outputStream, stringTable);
            }
            outputStream.write(1);
        }
    }

    public void writeWBXMLstringIndex(OutputStream outputStream, Hashtable stringTable, String string) throws IOException {
        int index = (Integer)stringTable.get(string);
        this.writeWBXMLmultibyteInteger(outputStream, index);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String inTag) {
        this.tag = inTag;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object inData) {
        this.data = inData;
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public XMLObject getChild(String inTag) {
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            XMLObject currentChild = (XMLObject)e.nextElement();
            if (!currentChild.getTag().equalsIgnoreCase(inTag)) continue;
            return currentChild;
        }
        return null;
    }

    public boolean hasChild(String inTag) {
        return this.getChild(inTag) != null;
    }

    public XMLCompatible getXMLChild(String inTag) {
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            XMLCompatible currentChild = (XMLCompatible)e.nextElement();
            if (!currentChild.getTag().equalsIgnoreCase(inTag)) continue;
            return currentChild;
        }
        return null;
    }

    public XMLAttribute getAttribute(String name) {
        if (name != null) {
            Enumeration e = this.attributes.elements();
            while (e.hasMoreElements()) {
                String attributeName;
                XMLAttribute currentAttribute = (XMLAttribute)e.nextElement();
                if (currentAttribute == null || (attributeName = currentAttribute.getName()) == null || !attributeName.equalsIgnoreCase(name)) continue;
                return currentAttribute;
            }
        }
        return null;
    }

    public XMLObject getChildAt(int index) {
        return (XMLObject)this.children.elementAt(0);
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String toString() {
        Enumeration e;
        StringBuffer string = new StringBuffer();
        string.append(this.tag + " : ");
        if (this.data != null) {
            string.append(this.data.toString().trim() + " ");
        }
        if ((e = this.children.elements()).hasMoreElements()) {
            string.append("{");
            while (e.hasMoreElements()) {
                string.append(" [ ");
                string.append(((XMLObject)e.nextElement()).toString());
                string.append(" ]");
            }
            string.append("}");
        }
        if ((e = this.attributes.elements()).hasMoreElements()) {
            string.append("{");
            while (e.hasMoreElements()) {
                string.append(" [ ");
                string.append(e.nextElement().toString());
                string.append(" ]");
            }
            string.append("}");
        }
        return string.toString();
    }

    public String getAttribute(String attributeName, String defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        String value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsString();
        }
        return value;
    }

    public int getAttribute(String attributeName, int defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        int value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsInt();
        }
        return value;
    }

    public double getAttribute(String attributeName, double defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        double value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsDouble();
        }
        return value;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        boolean value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsBoolean();
        }
        return value;
    }

    public String getAttributeAsString(String attributeName, String defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        String value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsString();
        }
        return value;
    }

    public int getAttributeAsInt(String attributeName, int defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        int value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsInt();
        }
        return value;
    }

    public double getAttributeAsDouble(String attributeName, double defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        double value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsDouble();
        }
        return value;
    }

    public boolean getAttributeAsBoolean(String attributeName, boolean defaultValue) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        boolean value = defaultValue;
        if (attribute != null) {
            value = attribute.getDataAsBoolean();
        }
        return value;
    }
}

