/*
 * Decompiled with CFR 0.152.
 */
package jolon.xml;

import java.io.IOException;
import java.io.Writer;

public class XMLAttribute {
    private String name;
    private Object data;

    public XMLAttribute() {
        this(null, null);
    }

    public XMLAttribute(String name, Object data) {
        this.name = name;
        this.data = data;
    }

    public void write(Writer writer) {
        try {
            if (this.data != null) {
                writer.write(this.name + "=\"" + this.data + "\"");
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getData() {
        return this.data;
    }

    public int getDataAsInt() {
        return Integer.parseInt(this.data.toString());
    }

    public double getDataAsDouble() {
        double value = 0.0;
        String string = this.data.toString();
        try {
            value = string.equals("Infinity") ? Double.POSITIVE_INFINITY : (string.equals("NaN") ? 0.0 : Double.valueOf(string));
        }
        catch (NumberFormatException e) {
            System.out.println(string);
            throw e;
        }
        return value;
    }

    public boolean getDataAsBoolean() {
        return Boolean.valueOf(this.data.toString());
    }

    public String getDataAsString() {
        return this.data.toString();
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return this.name + "=\"" + this.data + "\"";
    }
}

