/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package be.belgium.eid;

/******************************************************************************//**
  * Base class for a Smart card
  *********************************************************************************/
public class BEID_SmartCard extends BEID_Card {
  private long swigCPtr;

  protected BEID_SmartCard(long cPtr, boolean cMemoryOwn) {
    super(beidlibJava_WrapperJNI.SWIGBEID_SmartCardUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BEID_SmartCard obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      beidlibJava_WrapperJNI.delete_BEID_SmartCard(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

 	/**
	 * Select an application from the card
	 */
  public void selectApplication(BEID_ByteArray applicationId) throws java.lang.Exception {
    beidlibJava_WrapperJNI.BEID_SmartCard_selectApplication(swigCPtr, this, BEID_ByteArray.getCPtr(applicationId), applicationId);
  }

 	/**
	 * Send an APDU command to the card and get the result
	 * @param cmd is the apdu command
	 * @param pin is the pin to ask for writing
	 * @param csPinCode is the code of the pin (it will be asked if needed and not set)
	 * @return a BEID_ByteArray containing the result
	 */
  public BEID_ByteArray sendAPDU(BEID_ByteArray cmd, BEID_Pin pin, String csPinCode) throws java.lang.Exception {
    return new BEID_ByteArray(beidlibJava_WrapperJNI.BEID_SmartCard_sendAPDU__SWIG_0(swigCPtr, this, BEID_ByteArray.getCPtr(cmd), cmd, BEID_Pin.getCPtr(pin), pin, csPinCode), true);
  }

 	/**
	 * Send an APDU command to the card and get the result
	 * @param cmd is the apdu command
	 * @param pin is the pin to ask for writing
	 * @return a BEID_ByteArray containing the result
	 */
  public BEID_ByteArray sendAPDU(BEID_ByteArray cmd, BEID_Pin pin) throws java.lang.Exception {
    return new BEID_ByteArray(beidlibJava_WrapperJNI.BEID_SmartCard_sendAPDU__SWIG_1(swigCPtr, this, BEID_ByteArray.getCPtr(cmd), cmd, BEID_Pin.getCPtr(pin), pin), true);
  }

 	/**
	 * Send an APDU command to the card and get the result
	 * @param cmd is the apdu command
	 * @return a BEID_ByteArray containing the result
	 */
  public BEID_ByteArray sendAPDU(BEID_ByteArray cmd) throws java.lang.Exception {
    return new BEID_ByteArray(beidlibJava_WrapperJNI.BEID_SmartCard_sendAPDU__SWIG_2(swigCPtr, this, BEID_ByteArray.getCPtr(cmd), cmd), true);
  }

 	/**
	 * Read a File from the card
	 *
	 * If no pin is passed and a pin is needed by the card, the pin code will be asked anyway
	 *
	 * @param fileID is the path of the file
	 * @param in return the file
	 * @param pin is the pin to ask for writing
	 * @param csPinCode is the code of the pin (it will be asked if needed and not set)
	 */
  public int readFile(String fileID, BEID_ByteArray in, BEID_Pin pin, String csPinCode) throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_readFile__SWIG_0(swigCPtr, this, fileID, BEID_ByteArray.getCPtr(in), in, BEID_Pin.getCPtr(pin), pin, csPinCode);
  }

 	/**
	 * Read a File from the card
	 *
	 * If no pin is passed and a pin is needed by the card, the pin code will be asked anyway
	 *
	 * @param fileID is the path of the file
	 * @param in return the file
	 * @param pin is the pin to ask for writing
	 */
  public int readFile(String fileID, BEID_ByteArray in, BEID_Pin pin) throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_readFile__SWIG_1(swigCPtr, this, fileID, BEID_ByteArray.getCPtr(in), in, BEID_Pin.getCPtr(pin), pin);
  }

 	/**
	 * Read a File from the card
	 *
	 * If no pin is passed and a pin is needed by the card, the pin code will be asked anyway
	 *
	 * @param fileID is the path of the file
	 * @param in return the file
	 */
  public int readFile(String fileID, BEID_ByteArray in) throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_readFile__SWIG_2(swigCPtr, this, fileID, BEID_ByteArray.getCPtr(in), in);
  }

 	/**
	 * Write a file to the card
	 * Throw BEID_ExCmdNotAllowed exception you're not allowed to write the file
	 *
	 * If no pin is passed and a pin is needed by the card, the pin code will be asked anyway
	 *
	 * @param fileID is the path of the file
	 * @param out contents the bytes to write
	 * @param pin is the pin to ask for writing
	 * @param csPinCode is the code of the pin (it will be asked if needed and not set)
	 */
  public boolean writeFile(String fileID, BEID_ByteArray out, BEID_Pin pin, String csPinCode) throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_writeFile__SWIG_0(swigCPtr, this, fileID, BEID_ByteArray.getCPtr(out), out, BEID_Pin.getCPtr(pin), pin, csPinCode);
  }

 	/**
	 * Write a file to the card
	 * Throw BEID_ExCmdNotAllowed exception you're not allowed to write the file
	 *
	 * If no pin is passed and a pin is needed by the card, the pin code will be asked anyway
	 *
	 * @param fileID is the path of the file
	 * @param out contents the bytes to write
	 * @param pin is the pin to ask for writing
	 */
  public boolean writeFile(String fileID, BEID_ByteArray out, BEID_Pin pin) throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_writeFile__SWIG_1(swigCPtr, this, fileID, BEID_ByteArray.getCPtr(out), out, BEID_Pin.getCPtr(pin), pin);
  }

 	/**
	 * Write a file to the card
	 * Throw BEID_ExCmdNotAllowed exception you're not allowed to write the file
	 *
	 * If no pin is passed and a pin is needed by the card, the pin code will be asked anyway
	 *
	 * @param fileID is the path of the file
	 * @param out contents the bytes to write
	 */
  public boolean writeFile(String fileID, BEID_ByteArray out) throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_writeFile__SWIG_2(swigCPtr, this, fileID, BEID_ByteArray.getCPtr(out), out);
  }
	/** Return the number of pins on the card */
  public long pinCount() throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_pinCount(swigCPtr, this);
  }
	/** Return an object to access all the pins on the card */
  public BEID_Pins getPins() throws java.lang.Exception {
    return new BEID_Pins(beidlibJava_WrapperJNI.BEID_SmartCard_getPins(swigCPtr, this), false);
  }

	/** Return the number of certificates on the card */
  public long certificateCount() throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_certificateCount(swigCPtr, this);
  }
	/** Return an object to access all the certificates on the card */
  public BEID_Certificates getCertificates() throws java.lang.Exception {
    return new BEID_Certificates(beidlibJava_WrapperJNI.BEID_SmartCard_getCertificates(swigCPtr, this), false);
  }

	/**
	  * Get the challenge
	  *
	  * @param bForceNewInit force a new initialization of the couple challenge/response
	  */
  public BEID_ByteArray getChallenge(boolean bForceNewInit) throws java.lang.Exception {
    return new BEID_ByteArray(beidlibJava_WrapperJNI.BEID_SmartCard_getChallenge__SWIG_0(swigCPtr, this, bForceNewInit), false);
  }

	/**
	  * Get the challenge
	  */
  public BEID_ByteArray getChallenge() throws java.lang.Exception {
    return new BEID_ByteArray(beidlibJava_WrapperJNI.BEID_SmartCard_getChallenge__SWIG_1(swigCPtr, this), false);
  }

	/** Get the response to the challenge */
	public BEID_ByteArray getChallengeResponse() throws java.lang.Exception {
    return new BEID_ByteArray(beidlibJava_WrapperJNI.BEID_SmartCard_getChallengeResponse(swigCPtr, this), false);
  }

	/**
	  * Verify the challenge-response
	  *
	  * @param challenge is the challenge to check
	  * @param response is the response expected from the card
	  * @return true if the response of the card to the given challenge is the same as the response expected
	  * For virtual cards (=from file), always return false
	  */
  public boolean verifyChallengeResponse(BEID_ByteArray challenge, BEID_ByteArray response) throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_SmartCard_verifyChallengeResponse(swigCPtr, this, BEID_ByteArray.getCPtr(challenge), challenge, BEID_ByteArray.getCPtr(response), response);
  }

}
