/*
 *  Copyright (c) 2004 Apple Computer, Inc. All Rights Reserved.
 * 
 *  @APPLE_LICENSE_HEADER_START@
 *  
 *  This file contains Original Code and/or Modifications of Original Code
 *  as defined in and that are subject to the Apple Public Source License
 *  Version 2.0 (the 'License'). You may not use this file except in
 *  compliance with the License. Please obtain a copy of the License at
 *  http://www.opensource.apple.com/apsl/ and read it before using this
 *  file.
 *  
 *  The Original Code and all software distributed under the License are
 *  distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 *  INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 *  Please see the License for the specific language governing rights and
 *  limitations under the License.
 *  
 *  @APPLE_LICENSE_HEADER_END@
 */

/*
 *  BELPICError.cpp
 *  TokendMuscle
 */

#include "BELPICError.h"

#include <Security/cssmerr.h>

//
// BELPICError exceptions
//
BELPICError::BELPICError(uint16_t sw) : SCardError(sw)
{
	IFDEBUG(debugDiagnose(this));
}

const char *BELPICError::what() const throw ()
{ return "BELPIC error"; }

void BELPICError::throwMe(uint16_t sw)
{ throw BELPICError(sw); }

#if !defined(NDEBUG)

void BELPICError::debugDiagnose(const void *id) const
{
    secdebug("exception", "%p BELPICError %s (%04hX)",
             id, errorstr(statusWord), statusWord);
}

#endif //NDEBUG


/* arch-tag: 8B4FF59F-124C-11D9-AFF8-000A9595DEEE */
