------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--  A S I S _ U L . E N V I R O N M E N T . S C A N _ P A R A M E T E R S   --
--                                                                          --
--            (adapted for gnatsync from ASIS Utility Library)              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2007-2008, AdaCore                      --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Command_Line;          use GNAT.Command_Line;

with ASIS_UL.Options;            use ASIS_UL.Options;
with ASIS_UL.Output;
with ASIS_UL.Source_Table;       use ASIS_UL.Source_Table;

with Gnatsync.Options;           use Gnatsync.Options;
with Gnatsync.Output;            use Gnatsync.Output;
with Gnatsync.Threads;

separate (ASIS_UL.Environment)
procedure Scan_Parameters is
   No_More_Args : Boolean := True;
begin

   Initialize_Option_Scan
     (Stop_At_First_Non_Switch => True,
      Section_Delimiters       => "cargs");

   loop
      case GNAT.Command_Line.Getopt
             ("t v d dd q files= a " &
              "main= "               &       --  specify the main subprogram
              "threads= "            &       --  specify foreign threads
              "os om of "            &       --  output level control
              "wq ws wn wf "         &       --  Warning message control
              "out_file=")                   --  output control
      is

         when ASCII.NUL =>
            exit;
         when 'a' =>

            if Full_Switch = "a" then
               Process_RTL_Units := True;
            end if;

         when 'd' =>

            if Full_Switch = "d" then
               Debug_Mode := True;
               Compute_Timing := True;
            elsif Full_Switch = "dd" then
               Progress_Indicator_Mode := True;
            end if;

         when 'f' =>

            if Full_Switch = "files" then
               Read_Args_From_File (Parameter);
            end if;

         when 'm' =>

            if Full_Switch = "main" then

               if Is_Regular_File (Parameter) then

                  Free (Gnatsync.Options.Main_Subprogram_Name);

                  Gnatsync.Options.Main_Subprogram_Name :=
                     new String'(Normalize_Pathname
                                   (Parameter,
                                    Resolve_Links  => False,
                                    Case_Sensitive => False));
               else
                  Error (Parameter & " not found");
               end if;

            end if;

         when 'o' =>

            if Full_Switch = "out_file" then
               Set_Report_File_Name (Parameter);
            elsif Full_Switch = "os" then
               Gnatsync.Options.Output_Level := Brief;
            elsif Full_Switch = "om" then
               Gnatsync.Options.Output_Level := Medium;
            elsif Full_Switch = "of" then
               Gnatsync.Options.Output_Level := Full;
            end if;

         when 'q' =>
            Quiet_Mode := True;

         when 't' =>
            if Full_Switch = "t" then
               Compute_Timing := True;
            else

               if Is_Regular_File (Parameter) then
                  Gnatsync.Threads.Store_Threads_Info
                    (Thread_File_Name => Parameter);
               else
                  Error (Parameter & " not found");
               end if;

            end if;

         when 'v' =>
            Verbose_Mode := True;

         when 'w' =>

            if Full_Switch = "wq" then
               Warning_Mode := Quiet;
            elsif Full_Switch = "ws" then
               Warning_Mode := Short;
            elsif Full_Switch = "wn" then
               Warning_Mode := Normal;
            elsif Full_Switch = "wf" then
               Warning_Mode := Full;
            end if;

         when others =>
            raise Parameter_Error;
      end case;
   end loop;

   loop
      Add_Source_To_Process
        (Get_Argument (Do_Expansion => True), No_More_Args);
      exit when No_More_Args;
   end loop;

   Process_cargs_Section;

exception
   when GNAT.Command_Line.Invalid_Switch =>
      Error ("invalid switch : " & Full_Switch);
      Brief_Help;
      raise Parameter_Error;

   when GNAT.Command_Line.Invalid_Parameter =>
      Error ("missing parameter for: " & Full_Switch);
      raise Parameter_Error;

end Scan_Parameters;
