------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--           ASIS_UL.ENVIRONMENT.TOOL_SPECIFIC_INITIALIZATION_1             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2004-2008, AdaCore                     --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

--  Here all the calls to Gnatcheck.Rules.Register_Rule for all the rules
--  currently implemented in gnatcheck should be placed

with Gnatcheck.Rules;                use Gnatcheck.Rules;
with Gnatcheck.Rules.Custom_1;       use Gnatcheck.Rules.Custom_1;
with Gnatcheck.Rules.Custom_2;       use Gnatcheck.Rules.Custom_2;
with Gnatcheck.Rules.Default;        use Gnatcheck.Rules.Default;
with Gnatcheck.Rules.Metrics;        use Gnatcheck.Rules.Metrics;
with Gnatcheck.Rules.Metrics.Checks; use Gnatcheck.Rules.Metrics.Checks;

separate (ASIS_UL.Environment)
procedure Tool_Specific_Initialization_1 is
begin
   Register_Rule (Abstract_Type_Declarations_Rule                  'Access);
   Register_Rule (Anonymous_Arrays_Rule                            'Access);
   Register_Rule (Anonymous_Subtypes_Rule                          'Access);
   Register_Rule (Blocks_Rule                                      'Access);
   Register_Rule (Boolean_Relational_Operators_Rule                'Access);
--    Register_Rule (Ceiling_Violations_Rule                          'Access);
   Register_Rule (Controlled_Type_Declarations_Rule                'Access);
   Register_Rule (Declarations_In_Blocks_Rule                      'Access);
   Register_Rule (Default_Parameters_Rule                          'Access);
   Register_Rule (Discriminated_Records_Rule                       'Access);
   Register_Rule (Enumeration_Ranges_In_CASE_Statements_Rule       'Access);
   Register_Rule (Exceptions_As_Control_Flow_Rule                  'Access);
   Register_Rule (EXIT_Statements_With_No_Loop_Name_Rule           'Access);
   Register_Rule (Expanded_Loop_Exit_Names_Rule                    'Access);
   Register_Rule (Explicit_Full_Discrete_Ranges_Rule               'Access);
   Register_Rule (Float_Equality_Checks_Rule                       'Access);
   Register_Rule (Forbidden_Pragmas_Rule                           'Access);
   Register_Rule (Function_Style_Procedures_Rule                   'Access);
   Register_Rule (Generics_In_Subprograms_Rule                     'Access);
   Register_Rule (GOTO_Statements_Rule                             'Access);
   Register_Rule (Implicit_IN_Mode_Parameters_Rule                 'Access);
   Register_Rule (Implicit_SMALL_For_Fixed_Point_Types_Rule        'Access);
   Register_Rule (Improper_Returns_Rule                            'Access);
--   Register_Rule (Improperly_Called_Protected_Entries_Rule         'Access);
   Register_Rule (Improperly_Located_Instantiations_Rule           'Access);
   Register_Rule (Library_Level_Subprograms_Rule                   'Access);
   Register_Rule (Local_Packages_Rule                              'Access);

   --  Rules implementing the metric-based checks:

   Register_Rule (Metrics_Violation_Rule                           'Access);
   Register_Rule (Cyclomatic_Complexity_Rule                       'Access);
   Register_Rule (Essential_Complexity_Rule                        'Access);
   Register_Rule (LSLOC_Rule                                       'Access);

   Register_Rule (Misnamed_Identifiers_Rule                        'Access);
   Register_Rule (Multiple_Entries_In_Protected_Definitions_Rule   'Access);
   Register_Rule (Name_Clashes_Rule                                'Access);
   Register_Rule (Non_Qualified_Aggregates_Rule                    'Access);
   Register_Rule (Non_Short_Circuit_Operators_Rule                 'Access);
   Register_Rule (Non_SPARK_Attributes_Rule                        'Access);
   Register_Rule (Non_Tagged_Derived_Types_Rule                    'Access);
   Register_Rule (Non_Visible_Exceptions_Rule                      'Access);
   Register_Rule (Numeric_Literals_Rule                            'Access);
   Register_Rule (OTHERS_In_Aggregates_Rule                        'Access);
   Register_Rule (OTHERS_In_CASE_Statements_Rule                   'Access);
   Register_Rule (OTHERS_In_Exception_Handlers_Rule                'Access);
   Register_Rule (Outer_Loop_Exits_Rule                            'Access);
   Register_Rule (Overloaded_Operators_Rule                        'Access);
   Register_Rule (Overly_Nested_Control_Structures_Rule            'Access);
   Register_Rule (Parameters_Out_Of_Order_Rule                     'Access);
   Register_Rule (Positional_Actuals_For_Defaulted_Generic_Parameters_Rule
                                                                   'Access);
   Register_Rule (Positional_Actuals_For_Defaulted_Parameters_Rule 'Access);
   Register_Rule (Positional_Components_Rule                       'Access);
   Register_Rule (Positional_Generic_Parameters_Rule               'Access);
   Register_Rule (Positional_Parameters_Rule                       'Access);
   Register_Rule (Predefined_Numeric_Types_Rule                    'Access);
   Register_Rule (Raising_External_Exceptions_Rule                 'Access);
   Register_Rule (Raising_Predefined_Exceptions_Rule               'Access);
   Register_Rule (Recursive_Subprograms_Rule                       'Access);
--    Register_Rule (Side_Effect_Functions_Rule                       'Access);
   Register_Rule (Slices_Rule                                      'Access);
   Register_Rule (Unassigned_OUT_Parameters_Rule                   'Access);
   Register_Rule (Uncommented_BEGIN_In_Package_Bodies_Rule         'Access);
   Register_Rule (Unconstrained_Array_Returns_Rule                 'Access);
   Register_Rule (Universal_Ranges_Rule                            'Access);
   Register_Rule (Unnamed_Blocks_And_Loops_Rule                    'Access);
--    Register_Rule (Unused_Subprograms_Rule                          'Access);
   Register_Rule (USE_PACKAGE_Clauses_Rule                         'Access);
   Register_Rule (Visible_Record_Fields                            'Access);
   Register_Rule (Volatile_Objects_Without_Address_Clauses_Rule    'Access);
end Tool_Specific_Initialization_1;
