//basic.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2012
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_BASIC_H_
#define _AROARFW_BASIC_H_

#include <aroarfw/byteorder.h>
#include <aroarfw/msg.h>

//! Generate a NOOP message
#define rmsg0_msg_noop(msg) rmsg0_init((msg), RCMD_NOOP)

//! Generate a dummy AUTH message
#define rmsg0_msg_auth(msg) rmsg0_init((msg), RCMD_AUTH)

//! Generate a QUIT message
#define rmsg0_msg_quit(msg) rmsg0_init((msg), RCMD_QUIT)

//! Test if returned message is OK
#define rmsg0_is_ok(msg) (rmsg0_getcmd(msg) == RCMD_OK)

//! Test if returned message is ERROR
#define rmsg0_is_error(msg) (rmsg0_getcmd(msg) == RCMD_ERROR)

// IDENTIFY helper macros:

//! Length of IDENTIFY message body prefix
#define RPROTO_IDENTIFY_PREFIX_LEN 5

//! Return pointer to possition behind IDENTIFY message body prefix
#define rproto_identify_name(buf) (((char*)(buf)) + RPROTO_IDENTIFY_PREFIX_LEN)

//! Support function to generate IDENTIFY prefix
#define rproto_identify_prefix(buf, pid) ((void)((((unsigned char*)(buf))[0] = 1) + \
                                               RBO_H2NB32(&(((unsigned char*)(buf))[1]), (pid))))
#endif

//ll
