#!/usr/bin/python
# -*- coding: iso-8859-15 -*-
######################################################
##
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
##
######################################################
## 
#  Project: AptOnCd
#  File: DownloadGUI.py
#  Author: Alfredo Jr. <junix>
#  Creation: 18/11/2006
#  Changed: 08/12/2006 by Laudeci Oliveira <laudeci@gmail.com>
#  Purpose: Gui Class to control frmDownload Glade file
##
######################################################

import gtk
from gtk import glade
import string
import xmlfile
import os
import utils
import config
from messageBox import MessageBox
from configDownload import distros

class DownloadGUI:
    def __init__(self, gladefilename):
        self.conf = self.load_conf(config.XML_FILE)
        self.PackFiles = []
        self.gladefile = gladefilename
        self.gui = glade.XML(self.gladefile, "frmDownload")
        self.canceled = False
           
    def run(self):
        
        #Variable to control Download
        self.downloading = True
        # Main form Creation
        self.frmDownload = self.gui.get_widget("frmDownload")
        self.frmDownload.set_position(gtk.WIN_POS_CENTER)
        self.frmDownload.set_modal(True)
        self.frmDownload.connect("delete-event", self.on_btnCancel_clicked)

        #list options
        list_names = [x['name'] for x in distros]
        list_versions = distros[0]['versions']
        list_archs = distros[0]['archs']
        list_urls = distros[0]['urls']
        
        list_countries = self.get_urls(list_urls)

        list_methods = distros[0]['methods']
        list_media = distros[0]['media']
        list_sections = distros[0]['sections']
        
        # Form controls binding
        self.button_cancel = self.gui.get_widget("btnCancel")
        self.button_ok = self.gui.get_widget("btnDownload")
        self.combo_dist = self.gui.get_widget("cboDistribuition")
        self.combo_version = self.gui.get_widget("cboVersion")
        self.combo_arch = self.gui.get_widget("cboArchitecture")
        self.combo_mirror = self.gui.get_widget("cboMirror")
        self.combo_method = self.gui.get_widget("cboMethod")
        self.combo_media = self.gui.get_widget("cboMediaType")
        self.tvSections = self.gui.get_widget("tvSections")
        
        
        self.cboFileLocation = self.gui.get_widget('destinationDownload')
        
        # Events signals declarations
        self.button_cancel.connect("clicked", self.on_btnCancel_clicked)
        self.button_ok.connect("clicked", self.on_btnDownload_clicked)
        
        # fill combo with lists
        self.set_model_from_list(self.combo_dist, list_names)
        self.set_model_from_list(self.combo_version, list_versions)
        self.set_model_from_list(self.combo_arch, list_archs)
        self.set_model_from_list(self.combo_method, list_methods)
        self.set_model_from_list(self.combo_media, list_media)
        self.set_model_from_treelist(self.tvSections, list_sections)
        self.set_model_from_list(self.combo_mirror, list_countries,True)
         
        self.combo_dist.connect("changed", self.on_cboDistribuition_changed)
        
        self.set_saved_itens()
        
        result = self.frmDownload.run()

        #we are done with the dialog, destory it
        self.frmDownload.destroy()

        #return the result
        return result
    
    def get_urls(self,list):
        list_countries = []
        for n in list:
            start = n.find('(')+1
            end = n.find(')')
            country = n[start:end]
            list_countries.append( [country, n[:(start -1) ]])
        return list_countries
            
    def set_saved_itens(self):
        self.selectComboItem(self.combo_dist, self.conf[xmlfile.DISTRIBUTION])
        utils.updateUI()
        self.combo_dist.emit('changed')
        self.selectComboItem(self.combo_version, self.conf[xmlfile.VERSION])
        self.selectComboItem(self.combo_arch, self.conf[xmlfile.ARCHITECTURE])
        self.selectComboItem(self.combo_method, self.conf[xmlfile.METHOD])
        self.selectComboItem(self.combo_media, self.conf[xmlfile.MEDIA])
        self.checkSavedList(self.conf[xmlfile.SECTION])
        self.selectComboItem(self.combo_mirror, self.conf[xmlfile.HOST],True)
        self.cboFileLocation.set_current_folder_uri(self.conf[xmlfile.PATH])                              
    
    def checkSavedList(self,iList):
        for item in iList.split(';'):
            for iter in self.tvSections.get_model():
                if iter[1] == item:
                    iter[0] = True
                    
    def selectComboItem(self,combo, value,isUrl =False):
        model = combo.get_model()
        iter = model.get_iter_first()
        try: 
            if isUrl:
                while model.get_value(iter,1).replace(' ','') != value.replace(' ',''):
                    iter = model.iter_next(iter)
                combo.set_active_iter(iter)
            else:
                while model.get_value(iter,0) != value:
                    iter = model.iter_next(iter)
                combo.set_active_iter(iter)
        except:
            pass
        
        return
    
    def cancel(self):
        return self.canceled
    
    def getWindow(self):
         return self.frmDownload  
     
    def on_cboDistribuition_changed(self, widget):
        model = widget.get_model()
        iter = widget.get_active_iter()
        distro = model.get_value(iter, 0)
        distroIndex = 0
        if distro == 'ubuntu':
            distroIndex = 0
        elif distro == 'debian':
            distroIndex = 1
        list_versions = distros[distroIndex]['versions']
        list_archs = distros[distroIndex]['archs']
        list_urls = distros[distroIndex]['urls']
        list_sections = distros[distroIndex]['sections']
        
        list_countries = self.get_urls(list_urls)
            
        self.set_model_from_list(self.combo_version, list_versions)
        self.set_model_from_list(self.combo_arch, list_archs)
        self.set_model_from_treelist(self.tvSections, list_sections)
        self.set_model_from_list(self.combo_mirror, list_countries, True)
    
    def set_model_from_treelist (self, cb, items):
        if cb.get_model() == None:
            cb.set_model(gtk.ListStore(int,str))
            cell = gtk.CellRendererToggle()
            cell.set_property('activatable', True)
            column1 = gtk.TreeViewColumn(' ', cell)
            column1.add_attribute( cell, "active", 0)
            column1.set_resizable(True)
            cell.connect('toggled',self.on_Column_toggled, cb.get_model())
            self.tvSections.append_column(column1)
            cell1 = gtk.CellRendererText()
            column = gtk.TreeViewColumn(_('Sections'), cell1, markup=1)
            column.set_resizable(True)
            self.tvSections.append_column(column)
            
        model = cb.get_model()
        model.clear()
        
        for i in items:
            value = [False,i.encode("utf-8")]
            model.append(value)
    def on_Column_toggled(self, cell, path, model):
        model[path][config.C_CHECKED] = not model[path][config.C_CHECKED]
    def set_model_from_list (self, cb, items, isUrl = False):
        if cb.get_model() == None:
            if isUrl:
                cb.set_model(gtk.ListStore(str,str))
            else:
                cb.set_model(gtk.ListStore(str))
            cell = gtk.CellRendererText()
            cb.pack_start(cell)
            if isUrl:
                cell2 = gtk.CellRendererText()
                cb.pack_start(cell2)
                cb.add_attribute(cell, 'text',0)
                cb.add_attribute(cell2, 'text',1)
            else:
                cb.add_attribute(cell, 'text',0)
            
        model = cb.get_model()
        model.clear()
        
        for i in items:
            if isUrl:
                model.append(i)
            else:
                model.append([i])
                
    def on_btnDownload_clicked(self, widget):
        self.SaveXmlList()
    
    def on_btnCancel_clicked(self, *widget):
        pass
    
    def load_conf(self, file):
        XMLFile = xmlfile.XMLFile()
        self.node_text = XMLFile.parse(file)
        return XMLFile.load_conf(file)

    def geturl(self,value):
        distro = self.combo_dist.get_active_text() 
        if distro == 'ubuntu':
            distroIndex = 0
        elif distro == 'debian':
            distroIndex = 1
        list_versions = distro
        list_urls = distros[distroIndex]['urls']
        inti = 0
        for n in list_urls:
            if value in n:
                break
            inti+=1
        return list_urls[inti].split(' (')[0]
    
    def get_sections(self):
        list = [sect[1] for sect in self.tvSections.get_model() if sect[config.C_CHECKED]]
        result=''
        for s in list:
            result += s + ';'
        return result[:-1]
    
    def SaveXmlList(self):
        """Persists the server list and its folders to a xml file."""
        aFile = open(config.XML_FILE,"w")
        aFile.write('<?xml version="1.0" encoding="UTF-8" ?>\n')
        aFile.write('<download version="1.0">\n')
        aFile.write('    <settings>\n')
        aFile.write('        <host>'+ self.geturl(self.combo_mirror.get_active_text()) +'</host>\n')
        aFile.write('        <dist>'+ self.combo_dist.get_active_text() +'</dist>\n')
        aFile.write('        <method>'+ self.combo_method.get_active_text() +'</method>\n')
        aFile.write('        <version>'+ self.combo_version.get_active_text() +'</version>\n')
        aFile.write('        <section>%s</section>\n' % self.get_sections())
        aFile.write('        <arch>'+ self.combo_arch.get_active_text() +'</arch>\n')
        sPath = self.cboFileLocation.get_current_folder()
        aFile.write('        <path>'+ sPath +'</path>\n')
        aFile.write('        <media>'+ self.combo_media.get_active_text() +'</media>\n')
        aFile.write('    </settings>\n')
        aFile.write('</download>\n')
        aFile.close()
        return 
