#!/usr/bin/env python
# -*- coding: utf-8 -*-
# createAptoncd.py
#  
#  Author: Laudeci Oliveira <laudeci@gmail.com>
#          Rafael Proença   <cypherbios@ubuntu.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

from messageBox import MessageBox
import ProgressWindow
import apt_inst
import apt_pkg
import config
import gobject
import gtk
import gtk.glade
import math
import metaPackage
import os
import pango
import pygtk
import re
import shutil
import utils
import msg
import gzip
#from mediaInfo import mediaInfo
import mediaInfo
from mediaInfo import aptDiskInfo
from mediaInfo import aptDiskDefines

(LOAD_DEFAULT, LOAD_DOWNLOAD, LOAD_FILE) = range(3)
class createAptOnCd:
    
    def __init__(self, gladeFileName, defaultPath =config.LOCAL_APT_FOLDER , loadfrom = LOAD_DEFAULT, file_to_scan = ''):
        self.formName = "frmCreateCD"
        self.gladeFile = gtk.glade.XML(gladeFileName, self.formName)
        self.util = utils
        self.pathToScan = defaultPath
        self.scanFile = file_to_scan
        self.cursorManager = utils.cursorManager()
        self.checkOld = False
        self.AllowedChars = re.compile('[^0-9A-Za-z_\s\+\.-]+')
        self.type = loadfrom
        self.isError = False
                
    def run(self):
        """This function will show the Create APTonCD Dialog"""
        
        #Get the actual dialog widget
        self.frmCreateCD = self.gladeFile.get_widget(self.formName)
        self.frmCreateCD.set_position(gtk.WIN_POS_CENTER)
        self.frmCreateCD.set_modal(True)
        self.gladeFile.get_widget("cboMediaCreate").set_active(0)
        self.frmCreateCD.set_sensitive(False)
        
        #Holds a Variable to use with progressWindos
        self.wProgress = None
        
        # ---- dictionary ----
        dic = { 'on_btnCreateGo_clicked' : self.on_btnCreateGo_clicked,'on_btnAddDeb_clicked':self.on_btnAddDeb_clicked}
        
        self.gladeFile.signal_autoconnect(dic)       
        self.frmCreateCD.connect('response', self.onResponse) 
        self.cmdCreateGo = self.gladeFile.get_widget("btnCreateGo")
        
        self.cmdAddDeb = self.gladeFile.get_widget("btnAddDeb")
        self.cmdCancel = self.gladeFile.get_widget("btnCancel")
        self.cmdCancel.connect('clicked',self.onCancel)
        
        self.lblMediaNumber = self.gladeFile.get_widget("lblMediaNumber")
        self.cboMediaCreate = self.gladeFile.get_widget("cboMediaCreate")
        self.cboMediaCreate.connect("changed", self.on_cboMediaCreate)

        self.txtFileName = self.gladeFile.get_widget('entryIsoFilename')
        self.txtFileName.connect('insert-text',self.on_insert_text)
        
        self.ckbtnOldVersions = self.gladeFile.get_widget("ckbtnOldVersions")
        self.ckbtnOldVersions.connect("toggled", self.on_ckbtnOldVersion_check)

        self.ckbtnMetaPackage = self.gladeFile.get_widget("ckbtnMetaPackage")
        self.ckbtnMetaPackage.connect("toggled", self.on_ckbtnMetaPackage_check)
        
        self.cmbIsoFileName = self.gladeFile.get_widget("fileIsoTo")
        self.cmbIsoFileName.connect('selection_changed', self.on_cmbIsoFileName_change)
        
        self.ckbtnAutoSelectDepends = self.gladeFile.get_widget("ckbtnAutoSelectDepends")
        
        ret = metaPackage.updatePackageCount(None,False)
        self.updateCountView(ret)
        
        self.createPackageViewList()
        ret = metaPackage.updatePackageCount(self.packageList)
        self.updateCountView(ret)
        #run the dialog and store the response
        self.frmCreateCD.set_sensitive(True)
        
        result = self.frmCreateCD.run()

        #we are done with the dialog, destory it
        if result == gtk.RESPONSE_CANCEL :
            self.frmCreateCD.destroy()
        if result == gtk.RESPONSE_OK and not self.isError :
            self.frmCreateCD.destroy()

        #return the result
        return     result
    
    def on_cmbIsoFileName_change(self, widget):
        toMainDir = widget.get_filename()
        #print toMainDir
        if not self.util.checkAccess(toMainDir):
            widget.set_current_folder(os.path.expanduser('~/'))
            widget.emit_stop_by_name('selection_changed')
            #

        
    def package_tree_sort_func(self, model, iter1, iter2):
       statecmp = cmp(model.get_value(iter1, config.C_TITLE), model.get_value(iter2, config.C_TITLE))
       #if statecmp == 0:
       try:
           descr1 = model.get_value(iter1, config.C_PKG).get_pkg_Name()
       except:
           descr1 = None
       if descr1:
           descr1 = descr1.decode('utf-8')
       try:
           descr2 = model.get_value(iter2, config.C_PKG).get_pkg_Name()
       except:
           descr2 = None
       if descr2:
           descr2 = descr2.decode('utf-8')
       
       return cmp(descr1, descr2)

        
    def onCancel(self,widget,*args):
        self.frmCreateCD.destroy()
        
    def onResponse(self, response_id ,value):
        if response_id == gtk.RESPONSE_OK and self.isError:
            print 'Onresponse:', response_id
            self.isError = False
            self.frmCreateCD.emit_stop_by_name('response')
        elif response_id == gtk.RESPONSE_OK and not self.isError:
            self.wProgress.destroy()
        
    def on_insert_text (self, entry, text, length, position):
        """Stop garbage input."""
        for c in text[:length]:
            if c in r"(){}[]<>?*&%$#@!';:|\/^ ":
                entry.emit_stop_by_name ('insert-text')
                
            
    def on_cboMediaCreate(self,*args):
        ret = metaPackage.updatePackageCount(self.packageList)
        self.updateCountView(ret)
        
    def createDebFileList(self):
          
        #fileNames = [nFile for nFile in os.listdir(self.pathToScan) if nFile.endswith(".deb")],
        fileNames=[]
        if self.type ==LOAD_DEFAULT or self.type == LOAD_DOWNLOAD:
            fileNames = [nFile for nFile in os.listdir(self.pathToScan) if ( nFile.endswith(".deb") and "aptoncd-metapackage" not in nFile )]
        else:
           objFile = open(self.scanFile,'r')
           files = objFile.read().split('\n')
           objFile.close()
           
           for n in files:
               if len(n) >1:
                   fileNames.append(n)
        
        mLen = len(fileNames)
        self.wProgress.TaskLenght(mLen)
        for iIndex in range(mLen):
            #if '.deb' in fileName:
            self.wProgress.update(iIndex)
            iList = metaPackage.createNewItem(fileNames[iIndex],False,self.pathToScan)
            metaPackage.addNewListItem(self.packageList,iList)
        metaPackage.uncheckMinorVersion(self.packageList)        
        ret = metaPackage.updatePackageCount(self.packageList)
        self.updateCountView(ret)
        return
    
    def addListColumn(self, title, columnId, activatable = False):
        """This function adds a column to the list view.
        First it create the gtk.TreeViewColumn and then set
        some needed properties"""
        if activatable:
            cell = gtk.CellRendererToggle()
            cell.set_property('activatable', activatable)
            cell.connect('toggled',self.on_Column_toggled, self.packageList)
            column = gtk.TreeViewColumn(title, cell)
            column.add_attribute( cell, "active", 0)
        else :
            cell = gtk.CellRendererText()
            column = gtk.TreeViewColumn(title, cell, markup=config.LIST_CONTENTS)
            #column = gtk.TreeViewColumn(title, cell, text = columnId)            

        column.set_resizable(True)
        #column.set_sort_column_id(columnId)
        
        self.packageView.append_column(column)
        
        return
        
    def createPackageViewList(self):
        
        #Get the listView from the widget Tree
        self.packageView = self.gladeFile.get_widget("tvwPackages")
        self.packageView.connect('row-activated',self.on_double_Click)
        self.cursorManager.setBusy(self.frmCreateCD,True)
        self.packageView.set_sensitive(False)
        
        self.wProgress = ProgressWindow.AptOnCDProgressDialog(self.frmCreateCD)
        self.wProgress.Title("Selecting Packages")
        self.wProgress.TaskTitle(msg.MESSAGE_0001)
        self.wProgress.Task(msg.MESSAGE_0002)
        self.wProgress.Description(msg.MESSAGE_0003)
        
        self.cursorManager.setBusy(self.wProgress,True)
        self.wProgress.isCancelEnabled(False)
        #Create the listStore Model to use with the wineView
        # list will have bool representing checked state
        # filename, fullfilename with path, and a bool value
        # indicating if it is a custom deb file
        # stores deb information

        #changed to add the last param.. to show deb description
        self.packageList = gtk.ListStore(bool, str, bool, object, bool, bool)
        
        self.addListColumn('   ', 0,True)
        self.addListColumn(msg.MESSAGE_0004,1,False)
        
        #this will create a tooltip object    
        self.toolTip = gtk.Tooltips() 
        self.toolTip.set_tip(self.packageView, "")


        # this will turn searchable on
        self.packageView.set_enable_search(True)
        self.packageView.set_search_column(1)
        self.packageView.set_search_equal_func(utils.TreeViewSearch, None)

        # prepares list for drag and drop operations
        self.packageView.enable_model_drag_dest([('text/plain', 0, 0), ('text/uri-list', 0, 1)],
                        gtk.gdk.ACTION_DEFAULT | gtk.gdk.ACTION_MOVE)
        #packages events to show tooltips
        self.packageView.connect("motion-notify-event", self.util.packageTooltip, self.toolTip, 1)
        self.packageView.connect("drag_data_received",self.on_drag_data_received)
        
        # this will start the list sorted by name
        self.packageList.set_sort_column_id(1, gtk.SORT_ASCENDING)
        
        self.createDebFileList()
        
        # this will create the main list and store it in the view
        self.packageList.set_sort_func(config.C_TITLE, self.package_tree_sort_func)
        self.packageList.set_sort_column_id(config.C_TITLE, gtk.SORT_ASCENDING)
        
        self.packageView.set_model(self.packageList)
        
        
        self.wProgress.destroy()
        
        self.packageView.connect("button_press_event", self.on_button_press_event)
        self.packageView.set_sensitive(True)
        self.cursorManager.setBusy(self.frmCreateCD,False)
        return
    
    def updateCountView(self,value):
        mediaCount = 0
        mediaType =self.cboMediaCreate.get_active_text()
        try:
            if  mediaType == "DVD":
                mediaCount = int(math.floor(int(value[3]) / config.DVD))
            else:
                mediaCount = int(math.floor(int(value[3]) / config.CD))
        except ValueError:
            mediaCount = 1
            
        if mediaCount <= 0:
            mediaCount =1
            
        if mediaCount > 1 :
            self.gladeFile.get_widget("lblMediaNumber")   .set_text("<span foreground='gray'><big><b>%s %ss</b></big></span>" % ( mediaCount,mediaType))
        else:
            self.gladeFile.get_widget("lblMediaNumber")   .set_text("<span foreground='gray'><big><b>%s %s</b></big></span>" % ( mediaCount,mediaType))
             
        self.gladeFile.get_widget("lblMediaNumber").set_use_markup(True)
        
        self.gladeFile.get_widget("lblPackageList").set_text(value[0])
        self.gladeFile.get_widget("lblCustomPackage").set_text(value[1])
        self.gladeFile.get_widget("lblSelected").set_text(value[2])

    def on_double_Click(self, treeview, path, view_column):
        renderer = treeview.get_column(0).get_cell_renderers()[0]
        renderer.emit('toggled',path[0])

    def on_ckbtnOldVersion_check(self, widget):
        self.checkOld =  self.ckbtnOldVersions.get_active()

    def on_ckbtnMetaPackage_check(self, widget):
        if self.ckbtnMetaPackage.get_active() == True:
            config.set("cache", "metapackage", "True")
        else:
            config.set("cache", "metapackage", "False")
        
        config.write(config.CONFIG_FILE)
        
    def on_drag_data_received(self, widget, context, x, y, selection, target_type, timestamp):
        uri = selection.data.strip()
        uri_splitted = uri.split() # we may have more than one file dropped
        
        for uri in uri_splitted:
            #path = self._get_file_path_from_dnd_dropped_uri(uri)
            #print 'path to open', path
            if uri.endswith(".deb"):
                self.cursorManager.setBusy(self.frmCreateCD,True)
                while gtk.events_pending(): gtk.main_iteration()        
                ipath = self.util.getFilePathFromUrl(uri)
                path,filename = os.path.split(ipath)
                
                if not metaPackage.itemExistSearch(self.packageList,ipath):
                    metaPackage.addNewListItem(self.packageList,metaPackage.createNewItem(filename,True,path),True,self.packageView)
                    ret = metaPackage.updatePackageCount(self.packageList)
                    self.updateCountView(ret)
                else:
                    from messageBox import MessageBox
                    MessageBox().ShowError(msg.MESSAGE_0005 %filename,self.frmCreateCD)

                self.cursorManager.setBusy(self.frmCreateCD,False)
                
                
    def on_btnAddDeb_clicked(self,widget):
        
        self.cmdAddDeb.set_sensitive(False)
        
        result, files = self.util.openSelectDialog (msg.MESSAGE_0006,msg.MESSAGE_0007,"*.deb",True)
        if result == gtk.RESPONSE_OK:
            for nFile in files:
                path,filename = os.path.split(nFile)
                if not metaPackage.itemExistSearch(self.packageList,filename,path):
                        metaPackage.addNewListItem(self.packageList,metaPackage.createNewItem(filename,True,path),True, self.packageView)
                        ret = metaPackage.updatePackageCount(self.packageList)
                        self.updateCountView(ret)
                else:
                    from messageBox import MessageBox
                    MessageBox().ShowError(msg.MESSAGE_0005 % (filename),self.frmCreateCD)
        
        self.cmdAddDeb.set_sensitive(True)
        return

    def on_button_press_event(self, widget, event):
        if event.button == 3 and event.type == gtk.gdk.BUTTON_PRESS:
            c = utils.ContextMenu(self)
            c.addMenuItem(msg.MESSAGE_0009, self.on_checkAll)
            c.addMenuItem(msg.MESSAGE_0010, self.on_uncheckAll)
            c.addMenuItem("-")
            c.addMenuItem(msg.MESSAGE_0011, self.on_removePackage)
            c.addMenuItem("-")
            c.addMenuItem(msg.MESSAGE_0012, self.on_invertcheckAll)
            c.popup(None, None, None, event.button, event.get_time())
        return
    
    def checkUncheck(self,iType,path = None, model = None):
        self.cursorManager.setBusy(self.frmCreateCD,True)
        
        if iType == 0:
            metaPackage.removePackage(self.packageView)
        elif iType == 1:
            metaPackage.checkAll(self.packageList,self.checkOld)
        elif iType == 2:
            metaPackage.uncheckAll(self.packageList)
        elif iType == 3:
            metaPackage.invertcheckAll(self.packageList,self.checkOld)
        elif iType == 4:
            metaPackage.Column_toggled(path,model,self.checkOld)
            # if user wants, aptoncd will check dependets packages 
            if self.ckbtnAutoSelectDepends.get_active():
                if model[path][config.C_CHECKED]:
                    metaPackage.checkDepends(self.packageList,model[path][config.C_PKG].get_pkg_depends())
            
        ret =metaPackage.updatePackageCount(self.packageList)    
        self.updateCountView(ret)
        self.cursorManager.setBusy(self.frmCreateCD,False)
        
    def on_removePackage(self, *args):
        self.checkUncheck(0)
        return
    
    def on_checkAll(self,*args):
        self.checkUncheck(1)
        return
    
    def on_uncheckAll(self,*args):
        self.checkUncheck(2)
        return
    
    def on_invertcheckAll(self,*args):
        self.checkUncheck(3)
        return
    
    def on_Column_toggled(self, cell, path, model):
        self.checkUncheck(4, path, model)
        
        return
    
        
    # Create APTonCD
    def on_btnCreateGo_clicked(self,widget, *args):
        self.isError = False
        self.entryIsoFilename = self.gladeFile.get_widget("entryIsoFilename").get_text()
        
	nbrSelectedPackages = metaPackage.countChecked(self.packageList)[2]
		
	if nbrSelectedPackages == 0:
	   mReturn = MessageBox().ShowError((msg.MESSAGE_0069),self.frmCreateCD)
           self.isError = True
	
        if self.entryIsoFilename !="":
            if not self.util.isValidFileName(self.entryIsoFilename):
                mReturn = MessageBox().ShowError((msg.MESSAGE_0024  % ( self.entryIsoFilename)),self.frmCreateCD)
                self.isError = True
        
        if not self.isError:
            self.cmdCreateGo.set_sensitive(False)
            self.cmdCancel.set_sensitive(False)
             
            toMainDir = self.gladeFile.get_widget("fileIsoTo").get_filename()
        
            if self.util.checkAccess(toMainDir):

                self.wProgress = ProgressWindow.AptOnCDProgressDialog(self.frmCreateCD)
                self.wProgress.Title("APTonCD")
                self.wProgress.TaskTitle(msg.MESSAGE_0013)
                self.wProgress.Task(msg.MESSAGE_0002)
                self.wProgress.Description(msg.MESSAGE_0014)
    
                if not self.createAptOnCD():
                    self.isError = True
            else:
                    MessageBox().ShowError(msg.MESSAGE_0015,self.frmCreateCD)
                    self.isError = True
            
        
        self.cmdCreateGo.set_sensitive(True)
        self.cmdCancel.set_sensitive(True)
        
        #return self.isError
        
    def createAptOnCD(self):

        import datetime        
        errorMsg=""
        isos = []
        
        # -- get the user's preferences --
        toMainDir = self.gladeFile.get_widget("fileIsoTo").get_filename()
        
        if not self.util.checkAccess(toMainDir):
            MessageBox().ShowError(msg.MESSAGE_0015,self.frmCreateCD)
            return False

        media = self.cboMediaCreate.get_active_text()       
     
        config.set("cache", "media", media)
                
        config.write(config.CONFIG_FILE)
        
        metaPackActive = self.ckbtnMetaPackage.get_active()
        tmpdir = "/tmp/aptoncd-c/"
        tmpmetapackageDir = tmpdir +"metapackage/"
        tmppackages = tmpdir + "packages/"
        
        self.util.mkdir(tmpdir,True)
        
        if metaPackActive:
            self.util.mkdir(tmpmetapackageDir + 'DEBIAN/',True)
        else:
            self.util.removePath(tmpmetapackageDir )    
        
        self.wProgress.show()
        
        iIndex = 0
        
        # --- Copy the packages ---
        
        # get selected packages in the list
        filesToCopy = [files for files in self.packageList if files[config.C_CHECKED]]
        self.wProgress.TaskLenght(len(filesToCopy)-1)
        
        if media == 'DVD':
            isoFileList = self.CreateIsoList(config.DVD,filesToCopy)
        else:
            isoFileList = self.CreateIsoList(config.CD,filesToCopy)
        
        for cds in isoFileList.keys():
            self.wProgress.Task(msg.MESSAGE_0002)            
            # --- some meta-package configs ---
            controlFile =  tmpmetapackageDir + 'DEBIAN/control'
            self.util.delFile(controlFile)
        
            mPack = metaPackage.MetaPackage(controlFile)
        
            destination = tmppackages+ media +"_" + cds.__str__() + "/"
            pkgdest = destination + 'packages/'
            
            self.util.mkdir(destination,True)
            self.util.mkdir(pkgdest,True)            
            
            for pkg in isoFileList[cds]:
                iIndex +=1
                self.wProgress.update(iIndex)

                mPack.appendPackage(pkg.get_pkg_Name())

                filedestination = pkgdest  + pkg.get_pkg_FileName()
                if self.wProgress.cancel_status:
                    errorMsg = msg.MESSAGE_0016
                    break
                    
                pkg.copyTo(filedestination )
                self.wProgress.Task(msg.MESSAGE_0017 % pkg.get_pkg_FileName())
            
            if self.wProgress.cancel_status or len(errorMsg)>0:
                break
            if metaPackActive:
                if not mPack.write():
                    errorMsg = msg.MESSAGE_0018

                result = os.system('dpkg-deb -b ' + tmpmetapackageDir.replace(' ','\ ') + ' ' + pkgdest.replace(' ','\ ')  + mPack.get_mtFileName() + ' > /dev/null 2> /dev/null')
                self.util.delFile(controlFile)
                
            # --- Scan the packages ---
            if self.wProgress.cancel_status:
                errorMsg = msg.MESSAGE_0016
                break
            
            self.wProgress.Task(msg.MESSAGE_0019)
            while gtk.events_pending():    gtk.main_iteration()
            
            curdir = os.getcwd()
            os.chdir(destination)
            PackagesFile = destination.replace(' ','\ ') + 'Packages'      
            os.system('apt-ftparchive packages packages/ > ' + PackagesFile)

            utils.compress(PackagesFile, PackagesFile)
            
            fileObj = gzip.GzipFile(os.path.join(destination +'Packages.gz' ), 'wb');
            fileObj.write(file(os.path.join(destination +'Packages' ), 'rb').read())
            fileObj.close()
            
            os.system('apt-ftparchive release  ./ > ./Release')
                       
      	    os.chdir(curdir)
      	    
            #Write aptoncd.inf
            infoFile = destination + 'aptoncd.info'
            info = mediaInfo.mediaInfo(infoFile)
            info.write()
      	    
      	    #write .disk/info
      	    diskinfodir = os.path.join(destination +'.disk')
      	    self.util.mkdir(diskinfodir,True)
      	    infoDiskFile = os.path.join(diskinfodir,'info')
      	    infoDisk = mediaInfo.aptDiskInfo(infoDiskFile,media + cds.__str__())
      	    infoDisk.write()

	    #write README.diskdefines
      	    infoDiskDefinesFile = os.path.join(destination,'README.diskdefines')
      	    infoDiskDefines = mediaInfo.aptDiskDefines(infoDiskDefinesFile,cds.__str__(),cds.__str__())
      	    infoDiskDefines.write()
    
      	    
            # --- Make the .iso image ---
            if self.wProgress.cancel_status:
                errorMsg = msg.MESSAGE_0016
                break
        
        
            today = datetime.date.today().strftime('%Y%m%d') 

#
            if self.entryIsoFilename == "":
                fileNames = [nFile for nFile in os.listdir(toMainDir) if ( 'aptoncd-' + today +"-" + media + cds.__str__() in nFile  )]
                if len(fileNames) >0:
                    fileDestiny = 'aptoncd-' + today +"-" + media + cds.__str__() +'-'+str(len(fileNames)) +'.iso'
                else:
                    fileDestiny = 'aptoncd-' + today +"-" + media + cds.__str__() +'.iso'
            else:
                fileNames = [nFile for nFile in os.listdir(toMainDir) if ( self.entryIsoFilename + "-" + media + cds.__str__() in  nFile)]
                if len(fileNames) >0:
                    fileDestiny = self.entryIsoFilename + "-" + media + cds.__str__() +'-' +str( len(fileNames)) +'.iso'
                else:
                    fileDestiny = self.entryIsoFilename + "-" + media + cds.__str__() +'.iso'
                
            finalDestiny = os.path.join(toMainDir, fileDestiny)
            isos.append(finalDestiny)
            
            self.wProgress.Task(msg.MESSAGE_0020)
            while gtk.events_pending():    gtk.main_iteration()
            os.system('mkisofs -quiet -iso-level 4 -pad -l -r -J -joliet-long -v -V "APTonCD" -hide-rr-moved -o ' + finalDestiny.replace(' ','\ ') + ' ' + destination.replace(' ','\ ') + ' 2> /dev/null')

            if self.wProgress.cancel_status:
                errorMsg = msg.MESSAGE_0016
                break 
            self.wProgress.Task(msg.MESSAGE_0021)
        
        #clean folders created previously    
        self.util.removePath(tmpdir)        
        self.wProgress.hide()
        if len(errorMsg) > 0 :
            #mReturn = MessageBox().ShowInfo((msg.MESSAGE_0022  % ( finalDestiny,errorMsg)),self.frmCreateCD)
            return False
        else :
            if MessageBox().ShowQuestion((msg.MESSAGE_0023 % finalDestiny),self.frmCreateCD):
                for finalDestiny in isos:
                    os.system('/usr/bin/nautilus-cd-burner --source-iso=' + finalDestiny.replace(' ','\ ') + ' &')   
        
        self.frmCreateCD.destroy()     
        return True            
                                
    def CreateIsoList(self,size,packList = []):
        
        cds = {}
        currentCD = 1
        actualSize = 0
        
        
        for n in packList:
            pkg = n[config.C_PKG]
            if not currentCD in cds: cds[currentCD] = []
            if ( actualSize + pkg.get_pkg_Size()) > size:
                    actualSize = 0
                    currentCD += 1
                    cds[currentCD] = []
            cds[currentCD].append(pkg)
            actualSize += pkg.get_pkg_Size()
                
        return cds
