#ifndef _META_H
#define _META_H

#include "config.h"

#if defined(_POSIX_C_SOURCE) && (_POSIX_C_SOURCE < 200112L)
#undef _POSIX_C_SOURCE
#endif
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 200112L
#endif

#include <string>
#include <map>
#include <set>
#include <vector>
#include <deque>
#include <limits>
#include <cstdio>

#include <fcntl.h>
#include <pthread.h>
#include <strings.h>
#include <stdlib.h>
#include <errno.h>


#define EXTREME_MEMORY_SAVING false

typedef MYSTD::string mstring;
typedef const MYSTD::string cmstring;

typedef mstring::size_type tStrPos;
const static tStrPos stmiss(cmstring::npos);
typedef unsigned int UINT;
typedef unsigned short USHORT;
typedef unsigned char UCHAR;

#define citer const_iterator

#define CPATHSEPUNX '/'
#define SZPATHSEPUNIX "/"
#define CPATHSEPWIN '\\'
#define SZPATHSEPWIN "\\"
extern mstring sPathSep;

#ifdef WINDOWS
#define WIN32
#define SZPATHSEP SZPATHSEPWIN
#define CPATHSEP CPATHSEPWIN
#define szNEWLINE "\r\n"
#else
#define SZPATHSEP SZPATHSEPUNIX
#define CPATHSEP CPATHSEPUNX
#define szNEWLINE "\n"
#endif

// some alternative versions of these flags

#ifndef O_NONBLOCK
#ifdef NOBLOCK
#define O_NONBLOCK NOBLOCK
#else
#ifdef O_NDELAY
#define O_NONBLOCK O_NDELAY
#endif
#endif
#endif

#ifndef O_NONBLOCK
#error "Unknown how to configure non-blocking mode (O_NONBLOCK) on this system"
#endif

#include <sys/socket.h>
#ifndef SO_MAXCONN
#define SO_MAXCONN 250
#endif
#if defined(__linux__)
#include <sys/socketvar.h>
#endif

//#define PATHSEP "/"
int getUUID();

#define SPACECHARS " \f\n\r\t\v"

typedef MYSTD::map<mstring, mstring> tStrMap;

inline void trimFront(mstring &s, const char *junk=SPACECHARS)
{
	mstring::size_type pos = s.find_first_not_of(junk);
	if(pos != 0)
		s.erase(0, pos);
}

inline void trimBack(mstring &s, const char *junk=SPACECHARS)
{
	mstring::size_type pos = s.find_last_not_of(junk);
	s.erase(pos+1);
}

inline void trimString(mstring &s, const char *junk=SPACECHARS)
{
	trimBack(s, junk);
	trimFront(s, junk);
}

#define trimLine(x) { trimFront(x); trimBack(x); }

#define startsWith(where, what) (0==(where).compare(0, (what).size(), (what)))
#define endsWith(where, what) ((where).size()>=(what).size() && \
		0==(where).compare((where).size()-(what).size(), (what).size(), (what)))
#define startsWithSz(where, what) (0==(where).compare(0, sizeof((what))-1, (what)))
#define endsWithSzAr(where, what) ((where).size()>=(sizeof((what))-1) && \
		0==(where).compare((where).size()-(sizeof((what))-1), (sizeof((what))-1), (what)))
#define stripSuffix(where, what) if(endsWithSzAr(where, what)) where.erase(where.size()-sizeof(what)+1);

#define setIfNotEmpty(where, cand) { if(where.empty() && !cand.empty()) where = cand; }
#define setIfNotEmpty2(where, cand, alt) { if(where.empty()) { if(!cand.empty()) where = cand; else where = alt; } }

mstring GetBaseName(cmstring &in);
mstring GetDirPart(cmstring &in);

void trimProto(mstring & sUri);
tStrPos findHostStart(const mstring & sUri);

#ifndef _countof
#define _countof(x) sizeof(x)/sizeof(x[0])
#endif

#define NAMEWLEN(x) x, (_countof(x)-1)

//extern mstring sPathSep, sPathSepUnix, sCR, sCRLF;

// there is memchr and strpbrk but nothing like the last one acting on specified RAW memory range
static inline const char * mempbrk (const char * membuf, char const * const needles, size_t len)
{
   for(const char *pWhere=membuf ; pWhere<membuf+len ; pWhere++)
      for(const char *pWhat=needles; *pWhat ; pWhat++)
         if(*pWhat==*pWhere)
            return pWhere;
   return NULL;
}

typedef MYSTD::vector<mstring> tStrVec;
typedef MYSTD::set<mstring> tStrSet;
typedef MYSTD::deque<mstring> tStrDeq;
typedef MYSTD::vector<mstring>::iterator tStrVecIter;
typedef MYSTD::vector<mstring>::const_iterator tStrVecIterConst;

// Sometimes I miss Perl...
tStrVec::size_type Tokenize(const mstring &in, const char *sep, tStrVec & out, bool bAppend=false, mstring::size_type nStartOffset=0);
void Join(mstring &out, const mstring & sep, const tStrVec & tokens);

// TODO: __attribute__((externally_visible))
bool ParseKeyValLine(const mstring & sIn, mstring & sOutKey, mstring & sOutVal);
#define keyEq(a, b) (0 == strcasecmp((a), (b).c_str()))


class tHttpUrl
{
public:
	bool SetHttpUrl(mstring uri);
	/*
	/// The specified url has a path which is a prefix of the one in *this 
	UINT HasPathPrefix(const tHttpUrl &another);
	*/
	mstring ToURI() const;
	mstring sHost, sPort, sPath;
	tHttpUrl & operator=(const tHttpUrl &a) 
	{
		sHost=a.sHost; sPort=a.sPort; sPath=a.sPath;
		return *this;
	};
	bool operator==(const tHttpUrl &a) const
	{
		return a.sHost==sHost && a.sPort == sPort && a.sPath == sPath;
	};
	bool operator!=(const tHttpUrl &a) const
	{
		return ! (a==*this);
	}
	inline void clear() { sHost=sPort=sPath=""; }
	
	tHttpUrl(const mstring & host, const mstring & path)
	: sHost(host), sPath(path)
	{}
	tHttpUrl()
	{};
	
};

#define POKE(x) for(;;) { ssize_t n=write(x, "", 1); if(n>0 || (EAGAIN!=errno && EINTR!=errno)) break;  }

#define MIN_VAL(x) (MYSTD::numeric_limits<x>::min()) 
#define MAX_VAL(x) (MYSTD::numeric_limits<x>::max()) 

void appendLong(mstring &s, long val);

mstring CsBinToString(const uint8_t b[], unsigned short binLength);
bool CsAsciiToBin(const char *a, uint8_t b[], unsigned short binLength);

typedef const unsigned char CUCHAR;
bool CsEqual(const char *a, uint8_t b[], unsigned short binLength);
void StrSubst(mstring &contents, const mstring &from, const mstring &to);

typedef unsigned int FiStatus;

#if SIZEOF_LONG == 8
// _FILE_OFFSET_BITS apparently irrelevant, at least on Linux. But if set, watch out for user's experiments.
#if _FILE_OFFSET_BITS == 32
#error Unsupported: _FILE_OFFSET_BITS == 32 with large long size
#endif

#else // not 64bit arch?

#if 64 == _FILE_OFFSET_BITS
#define OFF_T_FMT "%"PRId64
#endif

#if 32 == _FILE_OFFSET_BITS
#define OFF_T_FMT "%"PRId32
#endif

#endif // !64bit arch

#ifndef OFF_T_FMT // either set above or let the os/compiler deal with the mess
#define OFF_T_FMT "%ld"
#endif

// let the compiler optimize and keep best variant
inline off_t atoofft(const char *p)
{
	if(sizeof(long long) == sizeof(off_t))
		return atoll(p);
	if(sizeof(int) == sizeof(off_t))
		return atoi(p);
	return atol(p);
}

mstring offttosH(off_t n);

tStrDeq ExpandFilePattern(const mstring &pattern, bool bSorted=false);

void MakeAbsolutePath(mstring &dirToFix, const mstring &reldir);


void HttpEscape(mstring &s);
bool UrlDecode(const mstring &from, mstring & to);
mstring UrlDecode(const mstring &from);


#define pathTidy(s) { if(startsWithSz(s, "." SZPATHSEP)) s.erase(0, 2); tStrPos n(0); \
	for(n=0;stmiss!=n;) { n=s.find(SZPATHSEP SZPATHSEP, n); if(stmiss!=n) s.erase(n, 1);}; \
	for(n=0;stmiss!=n;) { n=s.find(SZPATHSEP "." SZPATHSEP, n); if(stmiss!=n) s.erase(n, 2);}; }

// appears in the STL container?
#define ContHas(stlcont, needle) ((stlcont).find(needle) != (stlcont).end())

#define StrHas(haystack, needle) (haystack.find(needle) != stmiss)

off_t GetFileSize(cmstring & path, off_t defret);

inline mstring offttos(off_t n)
{
	char buf[21];
	int len=snprintf(buf, 21, OFF_T_FMT, n);
	return mstring(buf, len);
}

inline mstring ltos(long n)
{
	char buf[21];
	int len=snprintf(buf, 21, "%ld", n);
	return mstring(buf, len);
}

inline mstring offttosH(off_t n)
{
	const char * pref[]={"", " KiB", " MiB", " GiB", " TiB", " PiB", " EiB"};
	for(UINT i=0;i<_countof(pref)-1; i++)
	{
		if(n<1024)
			return ltos(n)+pref[i];
		if(n<10000)
			return ltos(n/1000)+"."+ltos((n%1000)/100)+pref[i+1];

		n/=1024;
	}
	return "INF";
}

extern cmstring sEmptyString;

//! split-and-extract helper for strings, for convenient use with for-loops
// Only for local application, uses references!
class tSplitWalk
{
	cmstring &s;
	mstring::size_type start, len, oob;
	const char *m_seps;

public:
	inline tSplitWalk(cmstring &line, const char *separators=SPACECHARS)
	: s(line), start(0), len(stmiss), oob(line.size()), m_seps(separators) {}
	inline bool Next()
	{
		if(len != stmiss) // initial state
			start = start + len + 1;
		if(start>=oob)
			return false;
		start = s.find_first_not_of(m_seps, start);
		if(start>=oob)
			return false;

		len = s.find_first_of(m_seps, start);
		if(len>=oob)
			len=oob-start;
		else
			len-=start;

		return true;
	}
	inline mstring GetPart(){ return s.substr(start, len); }
	inline operator mstring() { return GetPart(); }
};

#endif // _META_H

