#include <adept/progresswidget.h>

namespace adept {

OpProgressWidget::OpProgressWidget( QWidget *p )
    : KVBox( p ), m_busy( false )
{
    setMargin( 10 );
    m_label = new QLabel( this );
    m_pbar = new QProgressBar( this );
    m_pbar->setMaximum( 100 );
}

void OpProgressWidget::Update() {
    if ( CheckChange( 0.05 ) == false )
        return;
    if (MajorChange) {
        if ( !m_busy ) {
            QTimer::singleShot( 0, this, SIGNAL( activated() ) );
            QApplication::setOverrideCursor( QCursor( Qt::BusyCursor ) );
            m_busy = true;
        }
    }
    ProcessEvents::process();
    QTimer::singleShot( 0, this, SLOT( updateValues() ) );
}

void OpProgressWidget::Done() {
    QApplication::restoreOverrideCursor();
    m_busy = false;
    QTimer::singleShot( 0, this, SIGNAL( done() ) );
}

void OpProgressWidget::updateValues() {
    m_label->setText( l8bit( Op ) + "..." );
    m_pbar->setValue( Percent );
}

ProgressWidget::ProgressWidget( QWidget *p ) : QStackedWidget( p )
{
    m_noopParent = new KVBox( this );
    m_noop = setupErrorWidget( m_noopParent );
    addWidget( m_noopParent );
    m_noop->setWordWrap( true );
    m_noop->setMargin( 10 );

    m_progress = new OpProgressWidget( this );
    addWidget( m_progress );

    m_commit = new CommitWidget( this );
    addWidget( m_commit );

    m_download = new DownloadProgress( this );
    addWidget( m_download );

    connect( m_download,
             SIGNAL( statusChanged( DownloadProgress::Status ) ),
             this,
             SLOT( downloadStatusChanged( DownloadProgress::Status ) ) );
    connect( m_commit, SIGNAL( activated() ),
             this, SLOT( raiseCommit() ) );

    connect( m_progress, SIGNAL( activated() ),
             this, SLOT( progressStart() ) );
    connect( m_progress, SIGNAL( done() ),
             this, SLOT( progressDone() ) );

    noop();
}

void ProgressWidget::noop() {
    setCurrentWidget( m_noopParent );
    m_noop->setAlignment( Qt::AlignCenter );
    m_noop->setText( i18n( "No operation currently in progress. "
                           "Please go to Preview to apply any pending "
                           "changes or to Sources to update available "
                           "package lists." ) );
}

void ProgressWidget::done() {
    setCurrentWidget( m_noopParent );
    m_noop->setAlignment( Qt::AlignCenter );
    m_noop->setText(
        i18n( "The operation finished successfully and "
              "no operation is currently in progress. "
              "You may now exit the program or go back to "
              "installing and removing packages." ) );
}

void ProgressWidget::downloadCancelled() {
    setCurrentWidget( m_noopParent );
    m_noop->setAlignment( Qt::AlignCenter | Qt::AlignVCenter );
    m_noop->setText(
        i18n( "You have cancelled package download, therefore the"
              " installation or upgrade that was requested cannot"
              " be completed. I have tried to preserve the operation"
              " you have requested, so you could return to the Preview"
              " tab and click Apply changes again to restart the"
              " operation. Otherwise, you may exit the program or go"
              " back to installing and removing packages." ) );
}

void ProgressWidget::updateCancelled() {
    setCurrentWidget( m_noopParent );
    m_noop->setAlignment( Qt::AlignCenter | Qt::AlignVCenter );
    m_noop->setText(
        i18n( "You have cancelled package list download. I am therefore"
              " not updating anything. To continue where we left of, please"
              " restart the operation." ) );
}

void ProgressWidget::error( QString err, bool justify ) {
    setCurrentWidget( m_noopParent );
    m_noop->setAlignment(
        ( justify ? Qt::AlignJustify : Qt::AlignHCenter )
        | Qt::AlignVCenter );
    m_noop->setText( err );
}

}
