// -*- C++ -*- (c) 2007 Petr Rockai <me@mornfall.net>

#include <stdlib.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kapplication.h>

#include "manager.h"

int main(int argc, char *argv[])
{
    KLocale::setMainCatalog("adept");

    putenv( const_cast< char * >( "QT_IM_MODULE=xim" ) );

    KAboutData aboutData( "adept",
                          QByteArray(),
                          ki18n("Adept"),
                          "3.0 Beta 7",
                          ki18n( "Adept" ),
                          KAboutData::License_BSD,
                          ki18n("(c) 2005-2009 Peter Rockai, 2008 Yuriy Kozlov"),
                          KLocalizedString(),
                          "http://web.mornfall.net/adept.html" );

    aboutData.addAuthor ( ki18n( "Petr Ročkai" ),
                          ki18n( "developer" ),
                          "me@mornfall.net",
                          "http://web.mornfall.net" );

    aboutData.addAuthor ( ki18n( "Yuriy Kozlov" ),
                          ki18n( "developer" ),
                          "yuriy.kozlov@gmail.com",
                          "" );

    aboutData.setProgramIconName( "applications-other" );

    KCmdLineOptions options;
    options.add( "+updater", ki18n("Perform package updates only"), 0 );
    options.add( "+installer", ki18n("Add/Remove applications"), 0 );
    options.add( "+", ki18n("If no argument is supplied, launch full package manager"), 0 );
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); 

    KApplication app;

    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

    KGlobal::locale()->insertCatalog(QString::fromUtf8("libept"));

    AdeptManager *ta = new AdeptManager( args );

    app.setTopWidget(ta);
    ta->show();

    return app.exec();
}
