// -*- C++ -*-
#include <ept/core/apt.h>

#include <ept/test.h>

using namespace ept::core;

struct TestAptRecord : AptTestEnvironment
{
    record::Source recs;
    ept::Token t;

    TestAptRecord() : recs( db ) {
        t._id = "sp";
    }

    Test checkLookup() {
        recs.get< record::Record >( t );
    }

    Test checkLookupValue() {
        assert_eq( recs.get< record::Name >( t ), t.package() );
        assert_eq( recs.get< record::Maintainer >( t ),
                   "Neil Roeth <neil@debian.org>" );
    }

    Test checkLookupNumeric() {
        assert_eq( recs.get< record::InstalledSize >( t ),
                   600 );
    }

    Test checkShortDescription() {
        assert_eq( recs.get< record::ShortDescription >( t ),
                   "James Clark's SGML parsing tools" );
    }

    template< typename List >
    void checkRecordNameList( List l ) {
        while ( !l.empty() ) {
            assert_eq( l.property(), l.token().package() );
            l = l.tail();
        }
    }

    Test checkList() {
        // there are 435 valid records in the list file
        assert_eq( list::count( recs.list<
                                record::Name >() ), 435 );
        checkRecordNameList( recs.list< record::Name >() );
    }

    Test nonexistent() {
        assert_eq( recs.get< record::ShortDescription >(
                       ept::Token( "nonexistent-package" ) ), "" );
    }
};
