#!/bin/sh

# This script initiates a shutdown when the power putton has been
# pressed. Loosely based on the sample that ships with the acpid package.
# If the acpid sample is present as a real config file (as it was in earlier
# versions of acpid), we skip this script. (Purging and reinstalling acpid
# resolves this situation, or simply deleting /etc/acpi/events/powerbtn.)

if [ -f /etc/acpi/events/powerbtn ] ; then 
	echo Acpi-support not handling power button, acpid handler /etc/acpi/events/powerbtn exists.
	exit 0
fi

[ -e /usr/share/acpi-support/policy-funcs ] || exit 0

. /usr/share/acpi-support/policy-funcs

# If powersaved is running, let it process the acpi event
if pidof powersaved; then
	exit 0
fi

if [ `CheckPolicy` = 0 ] ; then
	exit 0
fi

if [ -x /etc/acpi/powerbtn.sh ] ; then
	# Compatibility with old config script from acpid package
	/etc/acpi/powerbtn.sh
else
	# Normal handling.
	/sbin/shutdown -h -P now "Power button pressed"
fi

