// -*- C++ -*-
// $Id: StockDistributor_exec.h 93117 2011-01-20 12:11:28Z mcorino $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.7.6
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 *       http://doc.ece.uci.edu/
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

// TAO_IDL - Generated from
// .\be\be_codegen.cpp:1217

#ifndef CIAO_STOCKDISTRIBUTOR_EXEC_H_
#define CIAO_STOCKDISTRIBUTOR_EXEC_H_

#include "ace/Thread_Manager.h"
#include "ace/Task.h"

#include "StockDistributorEC.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include /**/ "StockDistributor_exec_export.h"
#include "tao/LocalObject.h"


namespace CIAO_Stock_StockDistributor_Impl
{
  class StockDistributor_exec_i;

  // TAO_IDL - Generated from
  // c:\middleware\ace_wrappers\tao\tao_idl\be\be_visitor_component/facet_exh.cpp:58

  class STOCKDISTRIBUTOR_EXEC_Export StockQuoter_exec_i
    : public virtual ::Stock::CCM_StockQuoter,
      public virtual ::CORBA::LocalObject
  {
  public:
    StockQuoter_exec_i (StockDistributor_exec_i &distributor);

    virtual ~StockQuoter_exec_i (void);

    // Operations and attributes from Stock::StockQuoter

    // TAO_IDL - Generated from
    // c:\middleware\ace_wrappers\tao\tao_idl\be\be_visitor_operation/operation_ch.cpp:42

    virtual ::Stock::StockInfo *
    get_stock_info (
      const char * stock_name);

  private:
    /// Maintains a handle to the distributor so that the quoter can refer to it for latest quote
    StockDistributor_exec_i &distributor_;
  };


  /**
  * @class pulse generator
  *
  * @brief an active object used by StockDistributor to perform periodical pulse generation
  *
  */
  class pulse_Generator : public ACE_Task_Base
  {
  public:
    pulse_Generator (StockDistributor_exec_i *callback);

    ~pulse_Generator ();

    /// Hook method that performs application-defined initialization activities
    int open_h (void);

    /// Hook method that performs application-defined destruction activites
    int close_h (void);

    /// appliation-defined method for starting the pulse-generation service
    int start (CORBA::Long hertz);

    /// application-defined method for stopping the pulse-generation service
    int stop (void);

    /// Indicate whether the current object is active
    int active (void);

    /// Handle the timeout.
    virtual int handle_timeout (const ACE_Time_Value &tv,
                                const void *arg);

    /// Called when timer handler is removed.
    virtual int handle_close (ACE_HANDLE handle,
                              ACE_Reactor_Mask close_mask);

    /// Hook methods implemnting the task's service processing,
    /// invoked by all threads activated by activate () method
    virtual int svc (void);

  private:
    /// Tracking whether we are actively generating pulse or not.
    int active_;

    /// Maintains a handle that actually process the event
    StockDistributor_exec_i *pulse_callback_;

  };


  class STOCKDISTRIBUTOR_EXEC_Export StockDistributor_exec_i
    : public virtual StockDistributor_Exec,
      public virtual ::CORBA::LocalObject
  {
  public:
    StockDistributor_exec_i (void);
    virtual ~StockDistributor_exec_i (void);

    //@{
    /** Supported operations and attributes. */


    // TAO_IDL - Generated from
    // c:\middleware\ace_wrappers\tao\tao_idl\be\be_visitor_operation/operation_ch.cpp:42

    virtual void
    start (void);

    // TAO_IDL - Generated from
    // c:\middleware\ace_wrappers\tao\tao_idl\be\be_visitor_operation/operation_ch.cpp:42

    virtual void
    stop (void);
    //@}

    //@{
    /** Component attributes and port operations. */


    virtual ::Stock::CCM_StockQuoter_ptr
    get_push_quoter (void);

    // TAO_IDL - Generated from
    // c:\middleware\ace_wrappers\tao\tao_idl\be\be_visitor_operation/operation_ch.cpp:42

    virtual ::CORBA::Long
    rate (void);

    // TAO_IDL - Generated from
    // c:\middleware\ace_wrappers\tao\tao_idl\be\be_visitor_operation/operation_ch.cpp:42

    virtual void
    rate (
      ::CORBA::Long rate);
    //@}

    //@{
    /** Operations from Components::SessionComponent. */

    virtual void
    set_session_context (
      ::Components::SessionContext_ptr ctx);

    virtual void configuration_complete (void);

    virtual void ccm_activate (void);
    virtual void ccm_passivate (void);
    virtual void ccm_remove (void);
    //@}


  private:
    ::Stock::CCM_StockDistributor_Context_var context_;
    /// User defined members
    public:

    /// push event to all subscribers
    void push_notify_out ();

    private:
    /// pulse generation rate
    CORBA::Long rate_;

    /// pulser object
    pulse_Generator pulser_;

    /// "real-time" stock value
    static CORBA::Long msft_;

    /// "real-tiime" stock value
    static CORBA::Long ibm_;

    friend class StockQuoter_exec_i;
  };

  extern "C" STOCKDISTRIBUTOR_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Stock_StockDistributor_Impl (void);
}

namespace CIAO_Stock_StockDistributor_Impl
{
  class STOCKDISTRIBUTOR_EXEC_Export StockDistributorHome_exec_i
    : public virtual StockDistributorHome_Exec,
      public virtual ::CORBA::LocalObject
  {
  public:
    StockDistributorHome_exec_i (void);

    virtual ~StockDistributorHome_exec_i (void);

    // All operations and attributes.

    // Factory operations.

    // Finder operations.

    // Implicit operations.

    virtual ::Components::EnterpriseComponent_ptr
    create (void);
  };

  extern "C" STOCKDISTRIBUTOR_EXEC_Export ::Components::HomeExecutorBase_ptr
  create_Stock_StockDistributorHome_Impl (void);
}

#endif /* ifndef */

