// -*- C++ -*-
// $Id: Updater_Sender_exec.cpp 92902 2010-12-17 15:09:42Z mcorino $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "Updater_Sender_exec.h"
#include "tao/ORB_Core.h"
#include "ace/Reactor.h"

namespace CIAO_Updater_Sender_Impl
{

  /**
   * Write action generator
   */

  pulse_Generator::pulse_Generator (Sender_exec_i &callback)
    : pulse_callback_ (callback)
  {
  }

  int
  pulse_Generator::handle_timeout (const ACE_Time_Value &, const void *)
  {
    // Notify the subscribers
    this->pulse_callback_.tick ();
    return 0;
  }

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void)
    : test_nr_(UPDATE_CREATE),
      test_ok_(true)
  {
    ACE_NEW_THROW_EX (this->ticker_,
                      pulse_Generator (*this),
                      ::CORBA::NO_MEMORY ());
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
    delete this->ticker_;
  }

  // Supported operations and attributes.
  ACE_Reactor*
  Sender_exec_i::reactor (void)
  {
    ACE_Reactor* reactor = 0;
    ::CORBA::Object_var ccm_object =
      this->ciao_context_->get_CCM_object();
    if (! ::CORBA::is_nil (ccm_object.in ()))
      {
        ::CORBA::ORB_var orb = ccm_object->_get_orb ();
        if (! ::CORBA::is_nil (orb.in ()))
          {
            reactor = orb->orb_core ()->reactor ();
          }
      }
    if (reactor == 0)
      {
        throw ::CORBA::INTERNAL ();
      }
    return reactor;
  }

  CORBA::Boolean
  Sender_exec_i::create_one (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    TestTopic i = this->topic_seq_one_[0];
    try
      {
        if (! ::CORBA::is_nil (updater) )
          {
            updater->create_one(i);
            ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: create_one with instance key <%C>\n"),
                         i.key.in ()));
          }
        else
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: updater_ is nil")));
            return false;
          }
      }
    catch(const CCM_DDS::AlreadyCreated &)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: AlreadyCreated with test updater create_one <%C>.\n"),
                        i.key.in ()));
        return false;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while create_one for <%C>.\n"),
                        i.key.in ()));
        return false;;
      }
    return true;
  }

  CORBA::Boolean
  Sender_exec_i::create_one_already_exist (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    TestTopic i = this->topic_seq_one_[0];
    //try to create same instance again, this should erase an AlreadyCreated exception
    try
      {
        updater->create_one (i);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: create_one with already existing instance key <%Cs>\n"),
                      i.key.in ()));
      }
    catch(const CCM_DDS::AlreadyCreated &)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Expected : Exception AlreadyCreated test updater create_one.\n")));
        return true;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while create_one for <%C>.\n"),
                        i.key.in ()));
      }
    return false;
  }

  CORBA::Boolean
  Sender_exec_i::update_one (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    //update already created instance with handle nil
    TestTopic i = this->topic_seq_one_[0];
    try
      {
        updater->update_one(i, DDS::HANDLE_NIL);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: update_one with already existing instance with DDS::HANDLE_NIL, key <%C>\n"),
                      i.key.in ()));
      }
    catch(const CCM_DDS::NonExistent &)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater update_one <%C>.\n"),
                       i.key.in ()));
        return false;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while update_one for <%C>.\n"),
                        i.key.in ()));
        return false;
      }
    return true;
  }

  CORBA::Boolean
  Sender_exec_i::update_one_not_registered (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    //update a not yet registered instance,expext a NonExistent exception
     //use second instance of table
    TestTopic i = this->topic_seq_one_[1];
    try
      {
        updater->update_one(i, DDS::HANDLE_NIL);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: update_one with unregistered instance, key <%C>\n"),
                      i.key.in ()));
      }
    catch (const CCM_DDS::NonExistent &)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Expected : Exception NonExistent test updater updater_one.\n")));
        return true;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while update_one for <%C>.\n"),
                        i.key.in ()));
      }
    return false;
  }

  CORBA::Boolean
  Sender_exec_i::delete_one (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    //delete registered instance with DDS::HANDLE_NIL
    TestTopic i = this->topic_seq_one_[0];
    try
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: delete_one with registered instance with DDS::HANDLE_NIL, key <%C>\n"),
                      i.key.in ()));
        updater->delete_one(i, DDS::HANDLE_NIL);
      }
    catch(const CCM_DDS::NonExistent &)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater delete_one <%C>.\n"),
                       i.key.in ()));
        return false;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while delete_one for <%C>.\n"),
                        i.key.in ()));
        return false;
      }
    return true;
  }

  CORBA::Boolean
  Sender_exec_i::delete_one_not_registered (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    //delete non-existing instance, expect NonExistent exception
    TestTopic i = this->topic_seq_one_[1];
    try
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: delete_one with not registered instance, key <%C>\n"),
                     i.key.in ()));
        updater->delete_one(i, DDS::HANDLE_NIL);
      }
    catch(const CCM_DDS::NonExistent &)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Expected : Exception NonExistent test updater delete_one.\n")));
        return true;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while delete_one for <%C>.\n"),
                       i.key.in ()));
      }
    return false;
  }

  CORBA::Boolean
  Sender_exec_i::update_and_delete_one_after_register (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    //update an instance after registering first, using a handle
    TestTopic i = this->topic_seq_one_[2];
    //take third instance of table
    DDS::InstanceHandle_t hnd = updater->register_instance(i);
    try
      {
        if (hnd.isValid)
          {
            ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: update a new  instance after registrating instance, key <%C>\n"),
                        i.key.in ()));
            updater->update_one(i, hnd);
          }
        else
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("Error, invalid handle for <%C>.\n"),
                          i.key.in ()));
            return false;
          }
      }
    catch(const CCM_DDS::NonExistent &)
      {
         ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater update_one using handle <%C>.\n"),
                       i.key.in ()));
         return false;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while update_one for <%C>.\n"),
                        i.key.in ()));
        return false;
      }
    //update an instance with an instance_handler belonging to an other instance
    try
      {
        TestTopic y = this->topic_seq_one_[0];
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: update an instance with an instance_handler belonging to an other instance\n")));
        updater->update_one(y, hnd);
      }
    catch(const CCM_DDS::NonExistent &)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater update_one with incompatible datum and handle.\n")));
        return false;
      }
    catch (const CCM_DDS::InternalError& ex )
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("OK: Expected : Exception InternalE. test updater update_one with incompatible datum and handle. ex %d\n"),ex.error_code));
        return true;
      }

    try
      {
         i = this->topic_seq_one_[2];
         ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updater: delete a instance with handle, key <%C>\n"),
                    i.key.in ()));
         updater->delete_one(i, hnd);
      }
    catch (const CCM_DDS::NonExistent &)
      {
         ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater delett_one with valid handler.\n")));
         return false;
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Internal Error while delete_one for <%C>.\n"),
                      i.key.in ()));
        return false;
      }
    return true;
  }

  CORBA::Boolean
  Sender_exec_i::create_many (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    //create many with no exception
    try
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("create_many : <%u> samples\n"),
                         this->topic_seq_many_.length ()));
        updater->create_many (this->topic_seq_many_);
      }
    catch(const CCM_DDS::NonExistent& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater create_many\n")));
        return false;
      }
    catch (const CCM_DDS::InternalError& ex)
      {
         ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Internal Error ")
                     ACE_TEXT ("in updater: create_many: index <%d> - retval <%d>\n"),
                     ex.index, ex.error_code));
        return false;
    }
    //test create_many  with AlreadyCreated exception

    try
      {
         updater->create_many (this->topic_seq_many_);
         ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("create_many which are already created : <%u> samples\n"),
                       this->topic_seq_many_.length ()));

      }
    catch (const CCM_DDS::NonExistent & )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Unexpected Error ")
                     ACE_TEXT ("in create_many , already created.\n")));
         return false;
      }
    catch (const CCM_DDS::AlreadyCreated & )
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Expected : Exception AlreadyCreated test updater create_many.\n")));
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Internal Error ")
                     ACE_TEXT ("in test create_many,already created: index <%d> - retval <%d>\n"),
                     ex.index, ex.error_code));
        return false;
      }
    return true;
  }

  CORBA::Boolean
  Sender_exec_i::update_many (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    try
      {
        updater->update_many (this->topic_seq_many_);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("update_many : written <%u> samples\n"),
                   this->topic_seq_many_.length ()));
      }
    catch(const CCM_DDS::NonExistent& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater update_many.\n")));
        return false;
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Internal Error ")
                     ACE_TEXT ("whit update_many: index <%d> - retval <%d>\n"),
                     ex.index, ex.error_code));
        return false;
      }
    //update with exception
    // make from the second and third instances a unregistered instance , see above
    char key[7];
    TestTopic test_key;
    ACE_OS::sprintf (key, "XXX_%d",2);
    test_key.key = CORBA::string_dup(key);
    test_key.x = 2;
    this->topic_seq_many_[1] = test_key;
    ACE_OS::sprintf (key, "YYY_%d",3);
    test_key.key = CORBA::string_dup(key);
    test_key.x = 3;
    this->topic_seq_many_[2] = test_key;
    try
      {
        updater->update_many (this->topic_seq_many_);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("create_many : <%u> samples\n"),
                     this->topic_seq_many_.length ()));
      }
    catch (const CCM_DDS::NonExistent & ex)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Expected : Exception NonExistent test updater update_many.\n"),
                              ACE_TEXT ("index length expected = 2 and  value = %d, expected index[0] = 1 and value = %d.\n"),
                              ex.indexes.length(),ex.indexes[0]));

        if (ex.indexes.length() != 2 || ex.indexes[0] != 1 || ex.indexes[1] != 2)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("create_many:expected exception: NonExistent gives wrong indexes.\n")));
            return false;
          }
        else
          {
            return true;
          }
      }
    catch (const CCM_DDS::InternalError& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Internal Error ")
                    ACE_TEXT ("test update_many with not registered instances\n")));
      }
    catch (const CCM_DDS::AlreadyCreated & )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: AlreadyCreated with test update_many with not registered instances.\n")));
      }
    return false;
  }

  CORBA::Boolean
  Sender_exec_i::delete_many (
    ::Updater::UpdaterConnector::Updater_ptr updater)
  {
    // delete_many with exception
    // make from the second and third instances a unregistered instance
    try
      {
        updater->delete_many (this->topic_seq_many_);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("create_many : <%u> samples\n"),
                       this->topic_seq_many_.length ()));
      }
    catch (const CCM_DDS::NonExistent & ex)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Expected : Exception NonExistent test updater delete_many.\n"),
                               ACE_TEXT ("index length expected = 2 and  value = %d, expected index[0] = 1 and value = %d.\n"),
                               ex.indexes.length(),ex.indexes[0]));

        if (ex.indexes.length() != 2 || ex.indexes[0] != 1 || ex.indexes[1] != 2)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("delete_many:expected exception: NonExistent gives wrong indices.\n")));
            return false;
          }
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Internal Error ")
                    ACE_TEXT ("test updater delete_many with inregistered instances, info: index <%d> - retval <%d>\n"),
                    ex.index, ex.error_code));
        return false;
      }
    catch (const CCM_DDS::AlreadyCreated &)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: AlreadyCreated  with test updater delete_many.\n")));
        return false;
      }

    // Delete many with no exception
    // reset instances to original values
    for (int i = 1; i < 4; i++)
      {
        char key[7];
        TestTopic new_key;
        ACE_OS::sprintf (key, "many_%d", i);
        new_key.key = CORBA::string_dup(key);
        new_key.x = i;
        this->topic_seq_many_[i-1] = new_key;
      }
    try
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("delete_many : deleted <%u> samples\n"),
                                          this->topic_seq_many_.length ()));

        updater->delete_many (this->topic_seq_many_);
        return true;
      }
    catch(const CCM_DDS::NonExistent& )
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unexpected exception: NonExistent with test updater delete_many\n")));
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Internal Error ")
                  ACE_TEXT ("with test updater delete_many: index <%d> - retval <%d>\n"),
                  ex.index, ex.error_code));
      }
    return false;
  }

  void
  Sender_exec_i::add_instances_of_topic (void)
  {
    //make 2 sequences of instances as testdata
    CORBA::UShort total = 3;
    this->topic_seq_one_.length (total);
    //sequence for tests with .._one
    for (int i = 1; i < (total + 1); i++)
      {
        char key[7];
        TestTopic new_key;
        ACE_OS::sprintf (key, "KEY_%d", i);
        new_key.key = CORBA::string_dup(key);
        new_key.x = i;
        this->topic_seq_one_[i-1] = new_key;
      }
    //sequence for tests with .._many
    this->topic_seq_many_.length (total);
    for (int i = 1; i < (total + 1); i++)
      {
        char key[7];
        TestTopic new_key;
        ACE_OS::sprintf (key, "many_%d", i);
        new_key.key = CORBA::string_dup(key);
        new_key.x = i;
        this->topic_seq_many_[i-1] = new_key;
      }
  }

  void
  Sender_exec_i::tick (void)
  {
    if  (this->test_ok_.value())
      {
        ::Updater::UpdaterConnector::Updater_var updater =
          this->ciao_context_->get_connection_test_topic_update_data ();
        if (!::CORBA::is_nil (updater.in ()))
          {
            switch (this->test_nr_)
              {
                case UPDATE_CREATE:
                  this->test_ok_ = this->create_one (updater.in ());
                  if(this->test_ok_.value())
                    {
                      this->test_nr_ = UPDATE_CREATE_ALREADY_EXIST;
                    }
                  else
                    {
                      this->test_nr_ = END_TEST;
                    }
                  break;
                case UPDATE_CREATE_ALREADY_EXIST:
                  this->test_ok_ = this->create_one_already_exist (updater.in ());
                  this->test_nr_ = UPDATE_ONE;
                  break;
                case UPDATE_ONE:
                  this->test_ok_ = this->update_one (updater.in ());
                  this->test_nr_ = UPDATE_ONE_NOT_REGISTERED;
                  break;
                case UPDATE_ONE_NOT_REGISTERED:
                  this->test_ok_ = this->update_one_not_registered (updater.in ());
                  this->test_nr_ = DELETE_ONE;
                  break;
                case DELETE_ONE:
                  this->test_ok_ = this->delete_one (updater.in ());
                  this->test_nr_ = DELETE_ONE_NOT_REGISTERED;
                  break;
                case DELETE_ONE_NOT_REGISTERED:
                  this->test_ok_ = this->delete_one_not_registered (updater.in ());
                  this->test_nr_ = UPDATE_DELETE_REGISTER;
                  break;
                case UPDATE_DELETE_REGISTER:
                  this->test_ok_ = this->update_and_delete_one_after_register (updater.in ());
                  this->test_nr_ = CREATE_MANY;
                  break;
                case CREATE_MANY:
                  this->test_ok_ = this->create_many (updater.in ());
                  if(this->test_ok_.value())
                    {
                      this->test_nr_ = UPDATE_MANY;
                    }
                  else
                    {
                      this->test_nr_ = END_TEST;
                    }
                  this->test_nr_ = UPDATE_MANY;
                  break;
                case UPDATE_MANY:
                  this->test_ok_ = this->update_many (updater.in ());
                  this->test_nr_ = DELETE_MANY;
                  break;
                case DELETE_MANY:
                  this->test_ok_ = this->delete_many (updater.in ());
                  this->test_nr_ = END_TEST;
                  break;
                default:
                  break;
              }
          }
        else
          {
            ACE_ERROR ((LM_ERROR, "Sender_exec_i::tick - "
                      "ERROR: Updater seems nil.\n"));
            this->test_ok_ = false;
          }
      }
  }

  void
  Sender_exec_i::start (void)
  {
    if (this->reactor ()->schedule_timer (
                this->ticker_,
                0,
                ACE_Time_Value (3, 0),
                ACE_Time_Value (3, 0)) == -1)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Sender_exec_i::start : ")
                               ACE_TEXT ("Error scheduling timer")));
      }
  }

  void
  Sender_exec_i::stop (void)
  {
    this->reactor ()->cancel_timer (this->ticker_);
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Sender_exec_i::stop : Timer canceled.\n")));
  }

  // Component attributes and port operations.

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::Updater::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_activate (void)
  {

    this->add_instances_of_topic ();
    this->start ();
  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    this->stop ();
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    if (!this->test_ok_.value())
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Error in Updater in Sender")));
      }
  }

  extern "C" SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Updater_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
