// -*- C++ -*-
// $Id: ReadGet_Test_Sender_exec.cpp 92634 2010-11-18 12:46:14Z msmit $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "ReadGet_Test_Sender_exec.h"
#include "tao/ORB_Core.h"
#include "ace/Reactor.h"

#define ITERATIONS 20

namespace CIAO_ReadGet_Test_Sender_Impl
{
  /**
   * WriteHandler
   */

  WriteHandler::WriteHandler (Sender_exec_i &callback)
    : callback_ (callback)
  {
  }

  int
  WriteHandler::handle_exception (ACE_HANDLE)
  {
    this->callback_.start ();
    return 0;
  }

  /**
   * Facet Executor Implementation Class: restart_writer_exec_i
   */

  restart_writer_exec_i::restart_writer_exec_i (
        ::ReadGet_Test::CCM_Sender_Context_ptr ctx,
        Sender_exec_i & callback)
    : ciao_context_ (
        ::ReadGet_Test::CCM_Sender_Context::_duplicate (ctx))
      , callback_ (callback)
  {
  }

  restart_writer_exec_i::~restart_writer_exec_i (void)
  {
  }

  // Operations from ::ReadGetRestarter

  void
  restart_writer_exec_i::restart_write (void)
  {
    this->callback_.restart ();
  }

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void)
    : keys_ (5)
      , iterations_ (ITERATIONS)
      , run_ (1)
      , wh_ (0)
  {
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
  }

  // Component attributes and port operations.
  ACE_Reactor*
  Sender_exec_i::reactor (void)
  {
    ACE_Reactor* reactor = 0;
    ::CORBA::Object_var ccm_object =
      this->ciao_context_->get_CCM_object();
    if (! ::CORBA::is_nil (ccm_object.in ()))
      {
        ::CORBA::ORB_var orb = ccm_object->_get_orb ();
        if (! ::CORBA::is_nil (orb.in ()))
          {
            reactor = orb->orb_core ()->reactor ();
          }
      }
    if (reactor == 0)
      {
        throw ::CORBA::INTERNAL ();
      }
    return reactor;
  }

  ::CCM_ReadGetRestarter_ptr
  Sender_exec_i::get_restart_writer (void)
  {
    if ( ::CORBA::is_nil (this->ciao_restart_writer_.in ()))
      {
        restart_writer_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          restart_writer_exec_i (
            this->ciao_context_.in (),
            *this),
            ::CCM_ReadGetRestarter::_nil ());

          this->ciao_restart_writer_ = tmp;
      }

    return
      ::CCM_ReadGetRestarter::_duplicate (
        this->ciao_restart_writer_.in ());
  }

  void
  Sender_exec_i::restart (void)
  {
    ++this->run_;
    delete this->wh_;
    ACE_NEW_THROW_EX (this->wh_,
                      WriteHandler (*this),
                      CORBA::INTERNAL ());
    this->reactor ()->notify (this->wh_);
  }

  void
  Sender_exec_i::start (void)
  {
    ::ReadGet_Test::QueryConditionTestConnector::Writer_var writer =
      this->ciao_context_->get_connection_info_write_data ();
    ReadGetStarter_var starter =
      this->ciao_context_->get_connection_start_reader ();

    if (::CORBA::is_nil (starter.in ()) ||
        ::CORBA::is_nil (writer.in ()))
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Sender_exec_i::start - ")
                              ACE_TEXT ("Unable to start the reader\n")));
        return;
      }
    starter->set_reader_properties (this->keys_, this->iterations_);

    if (this->run_ > 1)
      {
        for (CORBA::UShort iter_key = 1; iter_key < this->keys_ + 1; ++iter_key)
          {
            char key[7];
            QueryConditionTest new_key;
            ACE_OS::sprintf (key, "KEY_%d", iter_key);
            new_key.symbol = CORBA::string_dup(key);
            CORBA::UShort iter = 1;
            if (this->run_ == 3)
              {
                iter = this->iterations_ + 1;
              }
            while (iter < (this->run_ - 1) * this->iterations_ + 1)
              {
                new_key.iteration = iter;
                writer->write_one (new_key, ::DDS::HANDLE_NIL);
                ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Written key <%C> with <%d>\n"),
                            key, iter));
                ++iter;
              }
          }
        ACE_OS::sleep (1);
      }
    starter->start_read (this->run_);
  }

  ::CORBA::UShort
  Sender_exec_i::keys (void)
  {
    return this->keys_;
  }

  void
  Sender_exec_i::keys (
    const ::CORBA::UShort keys)
  {
    this->keys_ = keys;
  }

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::ReadGet_Test::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    try
      {
        ACE_NEW_THROW_EX (this->wh_,
                          WriteHandler (*this),
                          CORBA::INTERNAL ());
        this->reactor ()->notify (this->wh_);
      }
    catch (const ::CORBA::Exception& ex)
      {
        ex._tao_print_exception ("Exception caught:");
        ACE_ERROR ((LM_ERROR,
          ACE_TEXT ("ERROR: GET_CONNECTION_START_READER : Exception caught\n")));
      }
    catch (...)
      {
        ACE_ERROR ((LM_ERROR,
          ACE_TEXT ("ERROR: GET_CONNECTION_START_READER : Unknown exception caught\n")));
      }
  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    delete this->wh_;
  }

  extern "C" SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_ReadGet_Test_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
