// -*- C++ -*-
// $Id: InterMulti_Sender_exec.cpp 92902 2010-12-17 15:09:42Z mcorino $

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "InterMulti_Sender_exec.h"

namespace CIAO_InterMulti_Sender_Impl
{
  //============================================================
   // Worker thread for asynchronous invocations for One
   //============================================================
   asynch_one_generator::asynch_one_generator (
     ::InterMulti::CCM_Sender_Context_ptr context,
      Atomic_UShort &nr_of_received)
   : context_(::InterMulti::CCM_Sender_Context::_duplicate (context)),
     nr_of_received_ (nr_of_received)
   {
   }

   int asynch_one_generator::svc ()
   {
     ::InterMulti::AMI4CCM_One_var my_one_ami_  =
        context_->get_connection_sendc_run_my_one();

      ::InterMulti::AMI4CCM_OneReplyHandler_var cb =
        new AMI4CCM_OneReplyHandler_run_my_one_i (
        this->nr_of_received_);

     //Invoke Asynchronous calls to test
     my_one_ami_->sendc_foo ( cb.in(),
       "Hi from asynch call ONE::foo", 1);
     return 0;
   }

 //============================================================
   // Worker thread for asynchronous invocations for Two
   //============================================================
   asynch_two_generator::asynch_two_generator (
     ::InterMulti::CCM_Sender_Context_ptr context,
      Atomic_UShort &nr_of_received)
   : context_(::InterMulti::CCM_Sender_Context::_duplicate (context)),
     nr_of_received_ (nr_of_received)
   {
   }

   int asynch_two_generator::svc ()
   {
     ::InterMulti::AMI4CCM_Two_var my_two_ami_  =
        context_->get_connection_sendc_run_my_two();

     if (CORBA::is_nil (my_two_ami_.in ()))
       {
         ACE_ERROR ((LM_ERROR,
                    "ERROR Sender (ASYNCH) :my_two_ami_ is NIL !\n"));
         return 1;
       }
     else
       {
         ::InterMulti::AMI4CCM_TwoReplyHandler_var cb =
           new AMI4CCM_TwoReplyHandler_run_my_two_i (
           this->nr_of_received_);

         //Invoke Asynchronous calls to test
         my_two_ami_->sendc_bar ( cb.in(), 2);
       }
     return 0;
   }

   //============================================================
   // Worker thread for asynchronous invocations for Three
   //============================================================
   asynch_three_generator::asynch_three_generator (
    ::InterMulti::CCM_Sender_Context_ptr context,
     Atomic_UShort &nr_of_received)
   : context_(::InterMulti::CCM_Sender_Context::_duplicate (context)),
     nr_of_received_ (nr_of_received)
   {
   }

   int asynch_three_generator::svc ()
   {
     ::InterMulti::AMI4CCM_Three_var my_three_ami_  =
        context_->get_connection_sendc_run_my_three();

     if (CORBA::is_nil (my_three_ami_))
       {
         ACE_ERROR ((LM_ERROR,
                     "ERROR Sender (ASYNCH) :my_three_ami_ is NIL !\n"));
         return 1;
       }
     else
       {
        ::InterMulti::AMI4CCM_ThreeReplyHandler_var cb =
           new AMI4CCM_ThreeReplyHandler_run_my_three_i (
           this->nr_of_received_);

         //Invoke Asynchronous calls to test
         my_three_ami_->sendc_plus(cb.in (), 3);
         // derived from CLASS ONE
         my_three_ami_->sendc_foo ( cb.in (),"hoi", 3);
         // derived fron CLASS TWO
         my_three_ami_->sendc_bar ( cb.in (), 3);
       }
     return 0;
   }
   //============================================================
   // Worker thread for synchronous invocations for One
   //============================================================
   synch_one_generator::synch_one_generator (
    ::InterMulti::CCM_Sender_Context_ptr context)
   : context_(::InterMulti::CCM_Sender_Context::_duplicate (context))
   {
   }

   int synch_one_generator::svc ()
   {
     ::InterMulti::One_var my_one_ami_ =
          context_->get_connection_run_my_one ();

     CORBA::String_var answer;
     CORBA::Long result = my_one_ami_->foo (
                             "Synchronous call foo from class One",
                             1,
                             answer.out ());
     if (result != 1)
       {
         ACE_ERROR ((LM_ERROR,
                     "ERROR Sender (SYNCH) : CLASS One foo !\n"));
       }
     return 0;
   }
  //============================================================
   // Worker thread for synchronous invocations for One
   //============================================================
   synch_three_generator::synch_three_generator (
    ::InterMulti::CCM_Sender_Context_ptr context)
   : context_(::InterMulti::CCM_Sender_Context::_duplicate (context))
   {
   }

   int synch_three_generator::svc ()
   {
     ::InterMulti::Three_var my_three_ami_ =
          context_->get_connection_run_my_three ();

     ::CORBA::String_var answer;
     CORBA::Long result = my_three_ami_->foo (
                         "Synchronous call foo from class Three, "
                         " derived from class ONE",
                         3 ,
                         answer.out ());
     if (result != 3)
       {
         ACE_ERROR ((LM_ERROR,
                     "ERROR Sender (SYNCH) : CLASS Three foo !\n"));
       }
     return 0;
   }
  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void)
  : nr_of_received_ (0){
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::InterMulti::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    this->asynch_one_gen =
       new asynch_one_generator (this->ciao_context_.in (),
                                  this->nr_of_received_);
    this->asynch_one_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);

    this->asynch_two_gen =
       new asynch_two_generator (this->ciao_context_.in (),
                                 this->nr_of_received_);
    this->asynch_two_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);

    this->asynch_three_gen =
       new asynch_three_generator (this->ciao_context_.in (),
                                   this->nr_of_received_);
    this->asynch_three_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);


    this->synch_one_gen =
        new synch_one_generator (this->ciao_context_.in());
    this->synch_one_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);

    this->synch_three_gen =
        new synch_three_generator (this->ciao_context_.in());
    this->synch_three_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    if (this->nr_of_received_.value() != 5)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: Did not get all callbacks for"
                               "derived classes."
                               " Received = %u of 5\n",
                               this->nr_of_received_.value()));
      }
    else
      {
        ACE_DEBUG ((LM_DEBUG,
                     "OK: All messages received back by Sender\n"));
      }
    delete this->asynch_one_gen;
    this->asynch_one_gen = 0;
    delete this->synch_one_gen;
    this->synch_one_gen = 0;
    delete this->asynch_two_gen;
    this->asynch_two_gen = 0;
    delete this->asynch_three_gen;
    this->asynch_three_gen = 0;
    delete this->synch_three_gen;
    this->synch_three_gen = 0;
  }


  AMI4CCM_OneReplyHandler_run_my_one_i::AMI4CCM_OneReplyHandler_run_my_one_i (
      Atomic_UShort &nr_of_received)
  : nr_of_received_(nr_of_received)
  {
  }

  AMI4CCM_OneReplyHandler_run_my_one_i::~AMI4CCM_OneReplyHandler_run_my_one_i (void)
  {
  }

  void
  AMI4CCM_OneReplyHandler_run_my_one_i::foo (::CORBA::Long /* ami_return_val */,
      const char * answer)
  {
    ACE_DEBUG ((LM_DEBUG, "OK: Get asynchronous callback from ONE::foo,"
                          " answer = <%C>\n",
                          answer));
    ++this->nr_of_received_;  }

  void
  AMI4CCM_OneReplyHandler_run_my_one_i::foo_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }


  AMI4CCM_TwoReplyHandler_run_my_two_i::AMI4CCM_TwoReplyHandler_run_my_two_i (
      Atomic_UShort &nr_of_received)
  : nr_of_received_(nr_of_received)

  {
  }

  AMI4CCM_TwoReplyHandler_run_my_two_i::~AMI4CCM_TwoReplyHandler_run_my_two_i (void)
  {
  }

  void
  AMI4CCM_TwoReplyHandler_run_my_two_i::bar (const char * answer)
  {
    ACE_DEBUG ((LM_DEBUG, "OK: Get asynchronous callback from TWO::bar,"
                          " answer = <%C>\n",
                          answer));
    ++this->nr_of_received_;
  }

  void
  AMI4CCM_TwoReplyHandler_run_my_two_i::bar_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }


  AMI4CCM_ThreeReplyHandler_run_my_three_i::AMI4CCM_ThreeReplyHandler_run_my_three_i (
      Atomic_UShort &nr_of_received)
  : nr_of_received_(nr_of_received)
  {
  }

  AMI4CCM_ThreeReplyHandler_run_my_three_i::~AMI4CCM_ThreeReplyHandler_run_my_three_i (void)
  {
  }

  void
  AMI4CCM_ThreeReplyHandler_run_my_three_i::foo (::CORBA::Long /* ami_return_val */,
  const char * answer)
  {
    ACE_DEBUG ((LM_DEBUG, "OK: Get asynchronous callback from THREE::foo,"
                          " answer = <%C>\n",
                          answer));
    ++this->nr_of_received_;
 }

  void
  AMI4CCM_ThreeReplyHandler_run_my_three_i::foo_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }

  void
  AMI4CCM_ThreeReplyHandler_run_my_three_i::bar (const char * answer)
  {
    ACE_DEBUG ((LM_DEBUG, "OK: Get asynchronous callback from THREE::bar,"
                           " answer = <%C>\n",
                           answer));
     ++this->nr_of_received_;
 }

  void
  AMI4CCM_ThreeReplyHandler_run_my_three_i::bar_excep (
  ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }

  void
  AMI4CCM_ThreeReplyHandler_run_my_three_i::plus (const char * answer )
  {
    ACE_DEBUG ((LM_DEBUG, "OK: Get asynchronous callback from THREE::plus,"
                          " answer = <%C>\n",
                          answer));
     ++this->nr_of_received_;
  }

  void
  AMI4CCM_ThreeReplyHandler_run_my_three_i::plus_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }

  extern "C" INTERMULTI_SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_InterMulti_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
