/**
 * @file Echo_Caller.cpp
 *
 * $Id: Echo_Caller.cpp 88011 2009-12-09 09:50:25Z vzykov $
 *
 * @author Carlos O'Ryan <coryan@atdesk.com>
 *
 */
#include "Echo_Caller.h"
#include "tao/ORB_Core.h"
#include "Server_Thread_Pool.h"

ACE_RCSID(Bug_1270_Regression, Echo_Caller, "$Id: Echo_Caller.cpp 88011 2009-12-09 09:50:25Z vzykov $")

Echo_Caller::Echo_Caller(Thread_Pool *pool)
  : pool_(pool)
{
}

void
Echo_Caller::start_task(Test::Echo_ptr client)
{
  pool_->put(client);
}

void
Echo_Caller::shutdown(void)
{
  ACE_DEBUG ((LM_DEBUG, "(%P|%t) Server received shutdown message\n"));
  pool_->shutdown();
}
