/**
 * @file Echo_Caller.cpp
 *
 * $Id: Echo_Caller.cpp 86599 2009-09-03 09:20:13Z vzykov $
 *
 * @author Carlos O'Ryan <coryan@atdesk.com>
 *
 */
#include "Echo_Caller.h"
#include "Server_Timer.h"
#include "tao/ORB_Core.h"

ACE_RCSID(Bug_1270_Regression, Echo_Caller, "$Id: Echo_Caller.cpp 86599 2009-09-03 09:20:13Z vzykov $")

Echo_Caller::Echo_Caller(CORBA::ORB_ptr orb)
  : orb_(CORBA::ORB::_duplicate(orb))
{
}

void
Echo_Caller::start_task(Test::Echo_ptr client)
{
  Server_Timer * task =
    new Server_Timer(client, orb_->orb_core()->reactor());
  task->activate();
  task->remove_reference ();

  task =
    new Server_Timer(client, orb_->orb_core()->reactor());
  task->activate();
  task->remove_reference ();
}

void
Echo_Caller::shutdown(void)
{
  ACE_DEBUG ((LM_DEBUG, "Server received shutdown message\n"));
  orb_->shutdown(0);
}
