!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_shapef
!! NAME 
!! calc_shapef
!!
!! FUNCTION
!! Compute normalized shape function and its moments (gnorm)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pawdata
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pshead
!!    %lambda= Lambda in gaussian type g(r)
!!    %l_size= Max. value of l+1 leading to a non zero Gaunt coeffs
!!    %log_step= Logaritmic step corresponding to radial mesh
!!    %rcomp= Radius for compensation charge
!!    %shape_type= Shape function type
!!    %sigma= Sigma for gaussian type g(r)
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!  un_log= Unit number for log file (comments)
!!
!! OUTPUT
!!  pawarray
!!    %gnorm(l_size)= Normalisation of qijl for each l
!!    %shapefunc(sph_meshsz)= Normalized shape function
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!      ctrap
!!
!! SOURCE

 subroutine calc_shapef(pawarray,pawdata,pshead,un_log)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ------------------------------------	
 integer :: un_log
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pshead_type)   :: pshead

!Local variables-------------------------------
 integer :: il,ir
 real(dp) :: arg,intg,shapefunc1,shapefunc2,shapefunc2s
 real(dp), allocatable :: ff(:)

!Statement functions -----------------------------------
 shapefunc1(arg) = exp(-(arg/pshead%sigma)**pshead%lambda)
 shapefunc2(arg) = (sin(pi*arg/pshead%rcomp)/(pi*arg/pshead%rcomp))**2
 shapefunc2s(arg)= (1-(pi*arg/pshead%rcomp)**2/6.d0*(1-(pi*arg/pshead%rcomp)**2/20.d0))**2

! *************************************************************************

!Select the suitable shape function
 pawarray%shapefunc(1)=1.d0
 if (pshead%shape_type==1) then
  do ir=2,pshead%sph_meshsz
   pawarray%shapefunc(ir)=shapefunc1(pawdata%rad(ir))
  enddo
 else if (pshead%shape_type==2.or.pshead%shape_type==-1) then
  do ir=2,pshead%sph_meshsz
   if (pawdata%rad(ir)<=1.d-3) then
    pawarray%shapefunc(ir)=shapefunc2s(pawdata%rad(ir))
   else if (pawdata%rad(ir)<=pshead%rcomp) then
    pawarray%shapefunc(ir)=shapefunc2(pawdata%rad(ir))
   else
    pawarray%shapefunc(ir)=zero
   endif
  enddo
 else
  write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (calc_shapef):'
  write(un_log,'(a)')   '    Invalid value of shape_type !'
  stop 'Program stopped before end'
 endif

!Compute Gnorm
 allocate(ff(pshead%sph_meshsz))
 pawarray%gnorm(:)=zero
 do il=1,pshead%l_size
  ff(1)=zero
  ff(2:pshead%sph_meshsz)=pawarray%shapefunc(2:pshead%sph_meshsz)&
&                       *pawdata%rad(2:pshead%sph_meshsz)**(2*il)&
&                       *pawdata%rad_(2:pshead%sph_meshsz)
  call ctrap(pshead%sph_meshsz,ff,pshead%log_step,intg)
  pawarray%gnorm(il)=1.d0/intg
 enddo
 deallocate(ff)

end subroutine
!!***
