!!****h* BigDFT/lazy_8
!! NAME
!!   lazy_8
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 8)
!!
!! SOURCE
!!
integer, parameter :: m=10
real(dp), dimension(-m:m) ::  ch,cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   ch(i)=0._dp
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! The normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

ch(-7)=-5._dp/2048._dp
ch(-6)=0._dp
ch(-5)=49._dp/2048._dp
ch(-4)=0._dp
ch(-3)=-245._dp/2048._dp
ch(-2)=0._dp
ch(-1)=1225._dp/2048._dp
ch( 0)=1._dp
ch( 1)=1225._dp/2048._dp
ch( 2)=0._dp
ch( 3)=-245._dp/2048._dp
ch( 4)=0._dp
ch( 5)=49._dp/2048._dp
ch( 6)=0._dp
ch( 7)=-5._dp/2048._dp
! 
cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***
