/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.AttributeHTML;
import org.apache.bcel.util.CodeHTML;
import org.apache.bcel.util.ConstantHTML;
import org.apache.bcel.util.MethodHTML;

public class Class2HTML
implements Constants {
    private JavaClass java_class;
    private String dir;
    private static String class_package;
    private static String class_name;
    private static ConstantPool constant_pool;

    public Class2HTML(JavaClass javaClass, String string) throws IOException {
        Method[] methodArray = javaClass.getMethods();
        this.java_class = javaClass;
        this.dir = string;
        class_name = javaClass.getClassName();
        constant_pool = javaClass.getConstantPool();
        int n = class_name.lastIndexOf(46);
        class_package = n > -1 ? class_name.substring(0, n) : "";
        ConstantHTML constantHTML = new ConstantHTML(string, class_name, class_package, methodArray, constant_pool);
        AttributeHTML attributeHTML = new AttributeHTML(string, class_name, constant_pool, constantHTML);
        MethodHTML methodHTML = new MethodHTML(string, class_name, methodArray, javaClass.getFields(), constantHTML, attributeHTML);
        this.writeMainHTML(attributeHTML);
        new CodeHTML(string, class_name, methodArray, constant_pool, constantHTML);
        attributeHTML.close();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        ClassParser classParser = null;
        JavaClass javaClass = null;
        String string = null;
        char c = System.getProperty("file.separator").toCharArray()[0];
        String string2 = "." + c;
        try {
            int n2;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].charAt(0) == '-') {
                    if (stringArray[n2].equals("-d")) {
                        if (!(string2 = stringArray[++n2]).endsWith("" + c)) {
                            string2 = string2 + c;
                        }
                        new File(string2).mkdirs();
                        continue;
                    }
                    if (stringArray[n2].equals("-zip")) {
                        string = stringArray[++n2];
                        continue;
                    }
                    System.out.println("Unknown option " + stringArray[n2]);
                    continue;
                }
                stringArray2[n++] = stringArray[n2];
            }
            if (n == 0) {
                System.err.println("Class2HTML: No input files specified.");
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.print("Processing " + stringArray2[n2] + "...");
                    classParser = string == null ? new ClassParser(stringArray2[n2]) : new ClassParser(string, stringArray2[n2]);
                    javaClass = classParser.parse();
                    new Class2HTML(javaClass, string2);
                    System.out.println("Done.");
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
    }

    static String referenceClass(int n) {
        String string = constant_pool.getConstantString(n, (byte)7);
        string = Utility.compactClassName(string);
        string = Utility.compactClassName(string, class_package + ".", true);
        return "<A HREF=\"" + class_name + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string + "</A>";
    }

    static final String referenceType(String string) {
        String string2 = Utility.compactClassName(string);
        string2 = Utility.compactClassName(string2, class_package + ".", true);
        int n = string.indexOf(91);
        String string3 = string;
        if (n > -1) {
            string3 = string.substring(0, n);
        }
        if (string3.equals("int") || string3.equals("short") || string3.equals("boolean") || string3.equals("void") || string3.equals("char") || string3.equals("byte") || string3.equals("long") || string3.equals("double") || string3.equals("float")) {
            return "<FONT COLOR=\"#00FF00\">" + string + "</FONT>";
        }
        return "<A HREF=\"" + string3 + ".html\" TARGET=_top>" + string2 + "</A>";
    }

    static String toHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            block8: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block8;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block8;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private void writeMainHTML(AttributeHTML attributeHTML) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.dir + class_name + ".html"));
        Attribute[] attributeArray = this.java_class.getAttributes();
        printWriter.println("<HTML>\n<HEAD><TITLE>Documentation for " + class_name + "</TITLE>" + "</HEAD>\n" + "<FRAMESET BORDER=1 cols=\"30%,*\">\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"ConstantPool\" SRC=\"" + class_name + "_cp.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Attributes\" SRC=\"" + class_name + "_attributes.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "</FRAMESET>\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"Code\" SRC=\"" + class_name + "_code.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Methods\" SRC=\"" + class_name + "_methods.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "</FRAMESET></FRAMESET></HTML>");
        printWriter.close();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeHTML.writeAttribute(attributeArray[i], "class" + i);
        }
    }
}

