/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.FieldObserver;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;

public class FieldGen
extends FieldGenOrMethodGen {
    private Object value = null;
    private static BCELComparator _cmp = new BCELComparator(){

        public boolean equals(Object object, Object object2) {
            FieldGen fieldGen = (FieldGen)object;
            FieldGen fieldGen2 = (FieldGen)object2;
            return fieldGen.getName().equals(fieldGen2.getName()) && fieldGen.getSignature().equals(fieldGen2.getSignature());
        }

        public int hashCode(Object object) {
            FieldGen fieldGen = (FieldGen)object;
            return fieldGen.getSignature().hashCode() ^ fieldGen.getName().hashCode();
        }
    };
    private List observers;

    public FieldGen(int n, Type type, String string, ConstantPoolGen constantPoolGen) {
        this.setAccessFlags(n);
        this.setType(type);
        this.setName(string);
        this.setConstantPool(constantPoolGen);
    }

    public FieldGen(Field field, ConstantPoolGen constantPoolGen) {
        this(field.getAccessFlags(), Type.getType(field.getSignature()), field.getName(), constantPoolGen);
        Attribute[] attributeArray = field.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i] instanceof ConstantValue) {
                this.setValue(((ConstantValue)attributeArray[i]).getConstantValueIndex());
                continue;
            }
            this.addAttribute(attributeArray[i]);
        }
    }

    private void setValue(int n) {
        ConstantPool constantPool = this.cp.getConstantPool();
        Constant constant = constantPool.getConstant(n);
        this.value = ((ConstantObject)((Object)constant)).getConstantValue(constantPool);
    }

    public void setInitValue(String string) {
        this.checkType(new ObjectType("java.lang.String"));
        if (string != null) {
            this.value = string;
        }
    }

    public void setInitValue(long l) {
        this.checkType(Type.LONG);
        if (l != 0L) {
            this.value = new Long(l);
        }
    }

    public void setInitValue(int n) {
        this.checkType(Type.INT);
        if (n != 0) {
            this.value = new Integer(n);
        }
    }

    public void setInitValue(short s) {
        this.checkType(Type.SHORT);
        if (s != 0) {
            this.value = new Integer(s);
        }
    }

    public void setInitValue(char c) {
        this.checkType(Type.CHAR);
        if (c != '\u0000') {
            this.value = new Integer(c);
        }
    }

    public void setInitValue(byte by) {
        this.checkType(Type.BYTE);
        if (by != 0) {
            this.value = new Integer(by);
        }
    }

    public void setInitValue(boolean bl) {
        this.checkType(Type.BOOLEAN);
        if (bl) {
            this.value = new Integer(1);
        }
    }

    public void setInitValue(float f) {
        this.checkType(Type.FLOAT);
        if ((double)f != 0.0) {
            this.value = new Float(f);
        }
    }

    public void setInitValue(double d) {
        this.checkType(Type.DOUBLE);
        if (d != 0.0) {
            this.value = new Double(d);
        }
    }

    public void cancelInitValue() {
        this.value = null;
    }

    private void checkType(Type type) {
        if (this.type == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!this.type.equals(type)) {
            throw new ClassGenException("Types are not compatible: " + this.type + " vs. " + type);
        }
    }

    public Field getField() {
        String string = this.getSignature();
        int n = this.cp.addUtf8(this.name);
        int n2 = this.cp.addUtf8(string);
        if (this.value != null) {
            this.checkType(this.type);
            int n3 = this.addConstant();
            this.addAttribute(new ConstantValue(this.cp.addUtf8("ConstantValue"), 2, n3, this.cp.getConstantPool()));
        }
        return new Field(this.access_flags, n, n2, this.getAttributes(), this.cp.getConstantPool());
    }

    private int addConstant() {
        switch (this.type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return this.cp.addInteger((Integer)this.value);
            }
            case 6: {
                return this.cp.addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return this.cp.addDouble((Double)this.value);
            }
            case 11: {
                return this.cp.addLong((Long)this.value);
            }
            case 14: {
                return this.cp.addString((String)this.value);
            }
        }
        throw new RuntimeException("Oops: Unhandled : " + this.type.getType());
    }

    public String getSignature() {
        return this.type.getSignature();
    }

    public void addObserver(FieldObserver fieldObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(fieldObserver);
    }

    public void removeObserver(FieldObserver fieldObserver) {
        if (this.observers != null) {
            this.observers.remove(fieldObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                ((FieldObserver)iterator.next()).notify(this);
            }
        }
    }

    public String getInitValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public final String toString() {
        String string = Utility.accessToString(this.access_flags);
        string = string.equals("") ? "" : string + " ";
        String string2 = this.type.toString();
        String string3 = this.getName();
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(string).append(string2).append(" ").append(string3);
        String string4 = this.getInitValue();
        if (string4 != null) {
            stringBuffer.append(" = ").append(string4);
        }
        return stringBuffer.toString();
    }

    public FieldGen copy(ConstantPoolGen constantPoolGen) {
        FieldGen fieldGen = (FieldGen)this.clone();
        fieldGen.setConstantPool(constantPoolGen);
        return fieldGen;
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        _cmp = bCELComparator;
    }

    public boolean equals(Object object) {
        return _cmp.equals(this, object);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

