/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Synthetic
extends Attribute {
    private byte[] bytes;

    public Synthetic(Synthetic synthetic) {
        this(synthetic.getNameIndex(), synthetic.getLength(), synthetic.getBytes(), synthetic.getConstantPool());
    }

    public Synthetic(int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super((byte)7, n, n2, constantPool);
        this.bytes = byArray;
    }

    Synthetic(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (byte[])null, constantPool);
        if (n2 > 0) {
            this.bytes = new byte[n2];
            dataInputStream.readFully(this.bytes);
            System.err.println("Synthetic attribute with length > 0");
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitSynthetic(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.length > 0) {
            dataOutputStream.write(this.bytes, 0, this.length);
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("Synthetic");
        if (this.length > 0) {
            stringBuffer.append(" ").append(Utility.toHexString(this.bytes));
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        Synthetic synthetic = (Synthetic)this.clone();
        if (this.bytes != null) {
            synthetic.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, synthetic.bytes, 0, this.bytes.length);
        }
        synthetic.constant_pool = constantPool;
        return synthetic;
    }
}

